/*
 * CCursorHandler.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */
#pragma once
class CIntObject;
class CAnimImage;
struct SDL_Surface;
struct SDL_Texture;

namespace ECursor
{
	enum ECursorTypes { ADVENTURE, COMBAT, DEFAULT, SPELLBOOK };

	enum EBattleCursors { COMBAT_BLOCKED, COMBAT_MOVE, COMBAT_FLY, COMBAT_SHOOT,
						COMBAT_HERO, COMBAT_QUERY, COMBAT_POINTER,
						//various attack frames
						COMBAT_SHOOT_PENALTY = 15, COMBAT_SHOOT_CATAPULT, COMBAT_HEAL,
						COMBAT_SACRIFICE, COMBAT_TELEPORT};
}

/// handles mouse cursor
class CCursorHandler final
{
	bool needUpdate;
	SDL_Texture * cursorLayer;

	SDL_Surface * buffer;
	CAnimImage * currentCursor;

	std::unique_ptr<CAnimImage> dndObject; //if set, overrides currentCursor

	std::array<std::unique_ptr<CAnimImage>, 4> cursors;

	bool showing;

	void clearBuffer();
	void updateBuffer(CIntObject * payload);
	void replaceBuffer(CIntObject * payload);
	void shiftPos( int &x, int &y );

	void updateTexture();
public:
	/// position of cursor
	int xpos, ypos;

	/// Current cursor
	ECursor::ECursorTypes type;
	size_t frame;

	/// inits cursorHandler - run only once, it's not memleak-proof (rev 1333)
	void initCursor();

	/// changes cursor graphic for type type (0 - adventure, 1 - combat, 2 - default, 3 - spellbook) and frame index (not used for type 3)
	void changeGraphic(ECursor::ECursorTypes type, int index);

	/**
	 * Replaces the cursor with a custom image.
	 *
	 * @param image Image to replace cursor with or nullptr to use the normal
	 * cursor. CursorHandler takes ownership of object
	 */
	void dragAndDropCursor (std::unique_ptr<CAnimImage> image);

	void render();

	void hide() { showing=false; };
	void show() { showing=true; };

	/// change cursor's positions to (x, y)
	void cursorMove(const int & x, const int & y);
	/// Move cursor to screen center
	void centerCursor();

	CCursorHandler();
	~CCursorHandler();
};
