---
layout: docs
title: Features
prev_section: singleton
next_section: why
permalink: /docs/features/
---

<blockquote>
Simple things should be simple, complex things should be possible. <br/>
<div style="text-align:right; white-space:nowrap">-- <a href="http://en.wikiquote.org/wiki/Alan_Kay">Alan Kay</a> (Computer Scientist)</div>
</blockquote>

The design of the OWNER APIs has been developed with this motto in mind.

OWNER is a features rich API, but while adding more features, we wanted to keep the
[basic usages]({{ site.url }}/docs/usage/) as simple as it could possibly be.

OWNER API supports a long list of features:

{% include features.html %}

The design of the new features is intended not to make existing things more complicated: you can pick what you need and
ignore what you don't need. Backward compatibility between versions is also in our goals.

If you need something special that is missing in OWNER, feel free to open a
[request](https://github.com/lviggiano/owner/issues) for it.
We'll do our best to make OWNER do what you need.
