{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBody1: TRigidBodyNode;
    procedure SetBody1(const Value: TRigidBodyNode);
    function GetBody2: TRigidBodyNode;
    procedure SetBody2(const Value: TRigidBodyNode);
  public
    property Body1: TRigidBodyNode read GetBody1 write SetBody1;
    property Body2: TRigidBodyNode read GetBody2 write SetBody2;
    procedure SetForceOutput(const Value: array of string);
    procedure SetForceOutput(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractRigidJointNode ----------------------------------------------- }

function TAbstractRigidJointNode.GetBody1: TRigidBodyNode;
begin
  if FdBody1.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody1.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody1(const Value: TRigidBodyNode);
begin
  FdBody1.Send(Value);
end;

function TAbstractRigidJointNode.GetBody2: TRigidBodyNode;
begin
  if FdBody2.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody2.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody2(const Value: TRigidBodyNode);
begin
  FdBody2.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: array of string);
begin
  FdForceOutput.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: TCastleStringList);
begin
  FdForceOutput.Send(Value);
end;

{$endif read_implementation}
