/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef PTHREAD_DEBUG_H
#define PTHREAD_DEBUG_H

void print_pthread_attr(const char *caller, pthread_attr_t *attr);

int Pthread_create(const char *caller, pthread_t *th, pthread_attr_t *attr, void *(*start_routine)(void *), void *arg);
int Pthread_join(const char *caller, pthread_t th, void **thread_return);

#define pthread_create(a, b, c, d) Pthread_create(__func__, a, b, c, d)
#define pthread_join(a, b) Pthread_join(__func__, a, b)

#endif /* PTHREAD_DEBUG_H */
