/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import jalview.appletgui.AlignFrame;
import jalview.appletgui.PaintRefresher;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.io.AppletFormatAdapter;
import jalview.io.IdentifyFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.emboss.jemboss.gui.SwingWorker;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class LaunchJalView
extends JFrame {
    public LaunchJalView() {
        super("Launch JalviewLite ");
        final TextFieldSink tfs = new TextFieldSink();
        final Cursor cbusy = new Cursor(3);
        final Cursor cdone = new Cursor(0);
        Box bacross = Box.createHorizontalBox();
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalStrut(5));
        JLabel lname = new JLabel("Multiple Sequence Filename:");
        lname.setFont(SectionPanel.labfont);
        lname.setForeground(Color.black);
        bdown.add(Box.createVerticalStrut(5));
        bacross.add(Box.createHorizontalStrut(5));
        bacross.add(lname);
        bacross.add(Box.createHorizontalStrut(100));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(1));
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(5));
        bacross.add(tfs);
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(5));
        JButton launch = new JButton("LAUNCH");
        bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalStrut(100));
        bacross.add(launch);
        bdown.add(bacross);
        tfs.setToolTipText("Enter full path of your input alignment or multiple sequence file, or drag the file from local file manager to here.");
        final LaunchJalView fr = this;
        launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingWorker launchworker = new SwingWorker(){

                    public Object construct() {
                        LaunchJalView.this.setCursor(cbusy);
                        String filename = tfs.getText();
                        File fn = new File(filename);
                        if (!fn.exists()) {
                            JOptionPane.showMessageDialog(fr, filename + " not found.\n" + "Note if this is a file on the server then\n" + "drag it to the local file manager first.", "File Not Found", 0);
                            LaunchJalView.this.setCursor(cdone);
                            LaunchJalView.this.dispose();
                            return null;
                        }
                        try {
                            LaunchJalView.callJalview(filename, filename);
                            LaunchJalView.this.setCursor(cdone);
                            LaunchJalView.this.dispose();
                        }
                        catch (Exception npe) {
                            LaunchJalView.this.setCursor(cdone);
                            JOptionPane.showMessageDialog(fr, "Check the input file entered.", "Error", 0);
                        }
                        return null;
                    }
                };
                launchworker.start();
            }
        });
        JPanel jp = (JPanel)this.getContentPane();
        jp.setLayout(new BorderLayout());
        jp.add((Component)bdown, "Center");
        this.pack();
        this.setLocation(this.getWidth() / 4, this.getHeight() / 4);
        this.setVisible(true);
    }

    public static void callJalview(String filename, String title) throws IOException {
        Label dummylabel = new Label("dummy");
        String dummyname = "dummy";
        PaintRefresher.Register((Component)dummylabel, (String)"dummy");
        Alignment al = null;
        String format = new IdentifyFile().Identify(filename, AppletFormatAdapter.FILE);
        al = new AppletFormatAdapter().readFile(filename, AppletFormatAdapter.FILE, format);
        if (al.getHeight() > 0) {
            AlignFrame af = new AlignFrame((AlignmentI)al, null, title, false);
            af.setVisible(true);
        }
    }
}

