/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.SequenceRenderer;
import jalview.datamodel.SequenceI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class OverviewPanel
extends Panel
implements Runnable,
MouseMotionListener,
MouseListener {
    Image miniMe;
    Image offscreen;
    AlignViewport av;
    AlignmentPanel ap;
    float scalew = 1.0f;
    float scaleh = 1.0f;
    public int width;
    public int sequencesHeight;
    int graphHeight = 20;
    int boxX = -1;
    int boxY = -1;
    int boxWidth = -1;
    int boxHeight = -1;
    boolean resizing = false;
    SequenceRenderer sr;
    FeatureRenderer fr;
    Frame nullFrame;
    boolean resizeAgain = false;

    public OverviewPanel(AlignmentPanel ap) {
        this.av = ap.av;
        this.ap = ap;
        this.setLayout(null);
        this.nullFrame = new Frame();
        this.nullFrame.addNotify();
        this.sr = new SequenceRenderer(this.av);
        this.sr.graphics = this.nullFrame.getGraphics();
        this.sr.renderGaps = false;
        this.sr.forOverview = true;
        this.fr = new FeatureRenderer(this.av);
        this.fr.overview = true;
        float initialScale = (float)this.av.alignment.getWidth() / (float)this.av.alignment.getHeight();
        if (this.av.hconsensus == null) {
            this.graphHeight = 0;
        }
        if (this.av.alignment.getWidth() > this.av.alignment.getHeight()) {
            this.width = 400;
            this.sequencesHeight = (int)(400.0f / initialScale);
            if (this.sequencesHeight < 40) {
                this.sequencesHeight = 40;
            }
        } else {
            this.width = (int)(400.0f * initialScale);
            this.sequencesHeight = 300;
            if (this.width < 120) {
                this.width = 120;
            }
        }
        this.setSize(new Dimension(this.width, this.sequencesHeight + this.graphHeight));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                if (OverviewPanel.this.getSize().width != OverviewPanel.this.width || OverviewPanel.this.getSize().height != OverviewPanel.this.sequencesHeight + OverviewPanel.this.graphHeight) {
                    OverviewPanel.this.updateOverviewImage();
                }
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.updateOverviewImage();
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.boxX = evt.getX();
        this.boxY = evt.getY();
        this.checkValid();
    }

    public void mouseReleased(MouseEvent evt) {
        this.boxX = evt.getX();
        this.boxY = evt.getY();
        this.checkValid();
    }

    public void mouseDragged(MouseEvent evt) {
        this.boxX = evt.getX();
        this.boxY = evt.getY();
        this.checkValid();
    }

    void checkValid() {
        if (this.boxY < 0) {
            this.boxY = 0;
        }
        if (this.boxY > this.sequencesHeight - this.boxHeight) {
            this.boxY = this.sequencesHeight - this.boxHeight + 1;
        }
        if (this.boxX < 0) {
            this.boxX = 0;
        }
        if (this.boxX > this.width - this.boxWidth) {
            if (this.av.hasHiddenColumns) {
                this.boxWidth = (int)((float)((this.av.endRes - this.av.startRes + 1) * this.av.getCharWidth()) * this.scalew);
            }
            this.boxX = this.width - this.boxWidth;
        }
        int col = (int)((float)this.boxX / this.scalew / (float)this.av.getCharWidth());
        int row = (int)((float)this.boxY / this.scaleh / (float)this.av.getCharHeight());
        if (this.av.hasHiddenColumns) {
            if (!this.av.getColumnSelection().isVisible(col)) {
                return;
            }
            col = this.av.getColumnSelection().findColumnPosition(col);
        }
        if (this.av.hasHiddenRows) {
            row = this.av.alignment.getHiddenSequences().findIndexWithoutHiddenSeqs(row);
        }
        this.ap.setScrollValues(col, row);
        this.ap.paintAlignment(false);
    }

    public void updateOverviewImage() {
        if (this.resizing) {
            this.resizeAgain = true;
            return;
        }
        if (this.av.showSequenceFeatures) {
            this.fr.featureGroups = this.ap.seqPanel.seqCanvas.getFeatureRenderer().featureGroups;
            this.fr.featureColours = this.ap.seqPanel.seqCanvas.getFeatureRenderer().featureColours;
        }
        this.resizing = true;
        if (this.getSize().width > 0 && this.getSize().height > 0) {
            this.width = this.getSize().width;
            this.sequencesHeight = this.getSize().height - this.graphHeight;
        }
        this.setSize(new Dimension(this.width, this.sequencesHeight + this.graphHeight));
        Thread thread = new Thread(this);
        thread.start();
        this.repaint();
    }

    public void run() {
        int col;
        this.miniMe = null;
        int alwidth = this.av.alignment.getWidth();
        int alheight = this.av.alignment.getHeight();
        if (this.av.showSequenceFeatures) {
            this.fr.transferSettings(this.ap.seqPanel.seqCanvas.getFeatureRenderer());
        }
        if (this.getSize().width > 0 && this.getSize().height > 0) {
            this.width = this.getSize().width;
            this.sequencesHeight = this.getSize().height - this.graphHeight;
        }
        this.setSize(new Dimension(this.width, this.sequencesHeight + this.graphHeight));
        int fullsizeWidth = alwidth * this.av.getCharWidth();
        int fullsizeHeight = alheight * this.av.getCharHeight();
        this.scalew = (float)this.width / (float)fullsizeWidth;
        this.scaleh = (float)this.sequencesHeight / (float)fullsizeHeight;
        this.miniMe = this.nullFrame.createImage(this.width, this.sequencesHeight + this.graphHeight);
        this.offscreen = this.nullFrame.createImage(this.width, this.sequencesHeight + this.graphHeight);
        Graphics mg = this.miniMe.getGraphics();
        float sampleCol = (float)alwidth / (float)this.width;
        float sampleRow = (float)alheight / (float)this.sequencesHeight;
        int lastcol = 0;
        int lastrow = 0;
        int xstart = 0;
        int ystart = 0;
        Color color = Color.yellow;
        int sameRow = 0;
        int sameCol = 0;
        boolean hiddenRow = false;
        for (int row = 0; row <= this.sequencesHeight; ++row) {
            SequenceI seq;
            if ((int)((float)row * sampleRow) == lastrow) {
                ++sameRow;
                continue;
            }
            hiddenRow = false;
            if (this.av.hasHiddenRows) {
                seq = this.av.alignment.getHiddenSequences().getHiddenSequence(lastrow);
                if (seq == null) {
                    int index = this.av.alignment.getHiddenSequences().findIndexWithoutHiddenSeqs(lastrow);
                    seq = this.av.alignment.getSequenceAt(index);
                } else {
                    hiddenRow = true;
                }
            } else {
                seq = this.av.alignment.getSequenceAt(lastrow);
            }
            for (col = 0; col < this.width; ++col) {
                if ((int)((float)col * sampleCol) == lastcol && (int)((float)row * sampleRow) == lastrow) {
                    ++sameCol;
                    continue;
                }
                lastcol = (int)((float)col * sampleCol);
                if (seq.getLength() > lastcol) {
                    color = this.sr.getResidueBoxColour(seq, lastcol);
                    if (this.av.showSequenceFeatures) {
                        color = this.fr.findFeatureColour(color, seq, lastcol);
                    }
                } else {
                    color = Color.white;
                }
                if (hiddenRow || this.av.hasHiddenColumns && !this.av.getColumnSelection().isVisible(lastcol)) {
                    color = color.darker().darker();
                }
                mg.setColor(color);
                if (sameCol == 1 && sameRow == 1) {
                    mg.drawLine(xstart, ystart, xstart, ystart);
                } else {
                    mg.fillRect(xstart, ystart, sameCol, sameRow);
                }
                xstart = col;
                sameCol = 1;
            }
            lastrow = (int)((float)row * sampleRow);
            ystart = row;
            sameRow = 1;
        }
        if (this.av.conservation != null) {
            for (col = 0; col < this.width; ++col) {
                lastcol = (int)((float)col * sampleCol);
                mg.translate(col, this.sequencesHeight);
                this.ap.annotationPanel.drawGraph(mg, this.av.conservation, (int)sampleCol + 1, this.graphHeight, (int)((float)col * sampleCol), (int)((float)col * sampleCol) + 1);
                mg.translate(-col, -this.sequencesHeight);
            }
        }
        System.gc();
        this.resizing = false;
        this.setBoxPosition();
        if (this.resizeAgain) {
            this.resizeAgain = false;
            this.updateOverviewImage();
        }
    }

    public void setBoxPosition() {
        int fullsizeWidth = this.av.alignment.getWidth() * this.av.getCharWidth();
        int fullsizeHeight = (this.av.alignment.getHeight() + this.av.alignment.getHiddenSequences().getSize()) * this.av.getCharHeight();
        int startRes = this.av.getStartRes();
        int endRes = this.av.getEndRes();
        if (this.av.hasHiddenColumns) {
            startRes = this.av.getColumnSelection().adjustForHiddenColumns(startRes);
            endRes = this.av.getColumnSelection().adjustForHiddenColumns(endRes);
        }
        int startSeq = this.av.startSeq;
        int endSeq = this.av.endSeq;
        if (this.av.hasHiddenRows) {
            startSeq = this.av.alignment.getHiddenSequences().adjustForHiddenSeqs(startSeq);
            endSeq = this.av.alignment.getHiddenSequences().adjustForHiddenSeqs(endSeq);
        }
        this.scalew = (float)this.width / (float)fullsizeWidth;
        this.scaleh = (float)this.sequencesHeight / (float)fullsizeHeight;
        this.boxX = (int)((float)(startRes * this.av.getCharWidth()) * this.scalew);
        this.boxY = (int)((float)(startSeq * this.av.getCharHeight()) * this.scaleh);
        this.boxWidth = this.av.hasHiddenColumns ? (int)((float)((endRes - startRes + 1) * this.av.getCharWidth()) * this.scalew) : (int)((float)((endRes - startRes + 1) * this.av.getCharWidth()) * this.scalew);
        this.boxHeight = (int)((float)((endSeq - startSeq) * this.av.getCharHeight()) * this.scaleh);
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Graphics og = this.offscreen.getGraphics();
        if (this.miniMe != null) {
            og.drawImage(this.miniMe, 0, 0, this);
            og.setColor(Color.red);
            og.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
            og.drawRect(this.boxX + 1, this.boxY + 1, this.boxWidth - 2, this.boxHeight - 2);
            g.drawImage(this.offscreen, 0, 0, this);
        }
    }
}

