/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_ERROR_HPP_INCLUDED
#define __TYPE_ERROR_HPP_INCLUDED

#include "frontend/reporting/CompileError.hpp"
#include "frontend/ast/TypeDeclaration.hpp"

namespace ast {

//! a type error was encountered.
class TypeError : public CompileError {
public:
	//! c'tor
	/** @param node AST node which contains the type error
	 *  @param declaration declaration of type
	 *  @param msg message to report.
          */
	TypeError(
		const AstNode &node,
		const TypeDeclaration &decl,
		std::string msg
	);

	//! write error to stream.
	/** @param stream write the compile error to this stream.
	 */
	virtual void put(std::ostream& stream) const;

protected:
	//! name of declared type
	std::string typeName;
	//! location of declared type
	Location declLoc;
};

}; /* namespace ast */

#endif /* __TYPE_ERROR_HPP_INCLUDED */
