# Automated UI Testing
_This document is intended to explain how various technologies are used together to conduct automated UI testing for Android at Mozilla. This document is accessible for all developers including those that are new to the Mozilla community._

Recall, that the primary problem we try to solve with automated testing is preventing unintended changes, which often lead to bugs or poor user experiences. This problem is most common -- thus we benefit the most from thorough testing.

When a Pull Request or merge request is created, we want to ensure that the changes are tested before they are merged. This is done by running a series of UI tests on the code. These tests are ran on Firebase Test Lab on virtual devices.

_Recall that on Pull Requests, the status badge on Github will let you know whether it is green, running, or broken (red)._

But what is the flow of this process from creating a Pull Request to seeing UI test results?

For simplicity, the flow of UI test execution starts with Taskcluster:

# Taskcluster

Taskcluster is a generic task execution service. Mozilla uses Taskcluster as the continuous (CI) pipeline to build and release Firefox. At Mozilla, we use Taskcluster to build, test, and run code tools for all commits and Pull Requests.

For the sake of simplicity, when a Pull Request (or merge request) is created, a task is created on Taskcluster (FirefoxCI) that handles the building, signing, packaging and delivery of the Android application.

Subsequently, a handoff to Firebase Test Lab occurs to provide an environment of UI test execution.

For a more detailed document on Taskcluster see [here](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/shared/android/taskcluster_guide.md).

## Firebase Test Lab

We use [Firebase Test Lab](https://firebase.google.com/docs/test-lab) to conduct automated on-device testing. Firebase Test Lab is a cloud-based testing platform that allows us to test our apps and websites in a way that is similar to how we would test them on a physical device.

For more information on physical device testing see [here](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/shared/android/device_testing.md).

Executable Espresso and UI Automator UI tests run on virtual devices by default and the test suite will run automatically on all Pull Requests and merges on the `main` branch. Test results and test artifacts are immediately available after test execution.

_Espresso and UI Automator are Google's core UI testing libraries on Android: they provide APIs to select views, perform actions on them, and assert state without reaching into implementation details._

For a more detailed document on testing styles and technologies used by the Android teams at Mozilla see [here](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/shared/android/testing.md)

# Treeherder

[Treeherder](https://treeherder.mozilla.org/) is a reporting dashboard for Mozilla check-ins. It allows users to see result of automatic builds and their respective tests. A common use case is looking at a particular check-in and pulling up test logs and artifacts from the UI test job.

For all Android applications, UI tests are classified under the `ui-test-x86` job symbol.

# Tying it all together

Below is a very simplified flow diagram that demonstrates the hand-off from a Github event (e.g, Pull Request) to Taskcluster and Firebase Test Lab, and lastly back to Taskcluster and Treeherder.

# Flow Diagram

```
        Pull Request
         or Merge
             │
             │
     ┌───────▼───────┐               ┌────────────┐
     │               │               │            │
┌─┬──┤  Taskcluster  ├───────────────►  Firebase  │
│ │  │               │               │            │
│ │  └───────▲───────┘               └──────┬─────┘
│ │          │                              │
│ │          └──────────────────────────────┘
│ │
│ │                  ┌──────────────┐
│ │                  │              │
│ └──────────────────┤  Treeherder  │
│                    │              │
│                    └──────────────┘
│
│                      ┌──────────┐
│                      │          │
└──────────────────────┤  Github  │
                       │          │
                       └──────────┘
```

## Mozilla resources
* [Firebase Console](https://console.firebase.google.com/)
* [FirefoxCI](https://firefox-ci-tc.services.mozilla.com)
* [Taskcluster](https://taskcluster.net)
* [Taskcluster-wiki](https://wiki.mozilla.org/Taskcluster)
* [Treeherder](https://treeherder.mozilla.org)

## Testing resources
* [Firebase](https://firebase.google.com)
* [Espresso](https://developer.android.com/training/testing/espresso)
* [UI Automator](https://developer.android.com/training/testing/ui-automator)
