/*
  Copyright (c) 2011-2012 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2011-2012 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
  THIS FILE IS GENERATED by
  scripts/gen-esa-bottomup.rb
  --key shulen
  --reader
  --absolute
  --no_process_lcpinterval.
  DO NOT EDIT.
*/

#include <limits.h>
#include "core/ma_api.h"
#include "esa-seqread.h"
/* no include for seqnumrelpos.h */

static void initBUinfo_shulen(GtBUinfo_shulen *,
                              GtBUstate_shulen *);

static void freeBUinfo_shulen(GtBUinfo_shulen *,
                              GtBUstate_shulen *);

static int processleafedge_shulen(bool,
    GtUword,
    GtBUinfo_shulen *,
    GtUword, /* position */
    GtBUstate_shulen *,
    GtError *err);

static int processbranchingedge_shulen(bool firstsucc,
    GtUword,
    GtBUinfo_shulen *,
    GtUword,
    GtUword,
    GtBUinfo_shulen *,
    GtBUstate_shulen *,
    GtError *);

/* no declaration of processlcpinterval_shulen */

#define TOP_ESA_BOTTOMUP_shulen\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo-1]

#define POP_ESA_BOTTOMUP_shulen\
        (stack->spaceGtBUItvinfo + (--stack->nextfreeGtBUItvinfo))

#define PUSH_ESA_BOTTOMUP_shulen(LCP,LB)\
        if (stack->nextfreeGtBUItvinfo >= stack->allocatedGtBUItvinfo)\
        {\
          gt_assert(stack->nextfreeGtBUItvinfo ==\
                    stack->allocatedGtBUItvinfo);\
          stack->spaceGtBUItvinfo\
            = allocateBUstack_shulen(stack->spaceGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo+incrementstacksize,\
                              bustate);\
          stack->allocatedGtBUItvinfo += incrementstacksize;\
        }\
        gt_assert(stack->spaceGtBUItvinfo != NULL);\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lcp = LCP;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lb = LB;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo++].rb = ULONG_MAX

typedef struct
{
  GtUword lcp, lb, rb;
  GtBUinfo_shulen info;
} GtBUItvinfo_shulen;

typedef struct
{
  GtBUItvinfo_shulen *spaceGtBUItvinfo;
  GtUword allocatedGtBUItvinfo,
                nextfreeGtBUItvinfo;
} GtArrayGtBUItvinfo_shulen;

GtArrayGtBUItvinfo_shulen *gt_GtArrayGtBUItvinfo_new_shulen(void)
{
  GtArrayGtBUItvinfo_shulen *stack = gt_malloc(sizeof (*stack));

  stack->spaceGtBUItvinfo = NULL;
  stack->allocatedGtBUItvinfo = stack->nextfreeGtBUItvinfo = 0;
  return stack;
}

void gt_GtArrayGtBUItvinfo_delete_shulen(
                           GtArrayGtBUItvinfo_shulen *stack,
                           GtBUstate_shulen *state)
{
  GtUword idx;

  for (idx=0; idx<stack->allocatedGtBUItvinfo; idx++)
  {
    freeBUinfo_shulen(&stack->spaceGtBUItvinfo[idx].info,state);
  }
  gt_free(stack->spaceGtBUItvinfo);
  gt_free(stack);
}

static GtBUItvinfo_shulen *allocateBUstack_shulen(
                                   GtBUItvinfo_shulen *ptr,
                                   GtUword currentallocated,
                                   GtUword allocated,
                                   GtBUstate_shulen *state)
{
  GtUword idx;
  GtBUItvinfo_shulen *itvinfo;

  itvinfo = gt_realloc(ptr,sizeof (*itvinfo) * allocated);
  gt_assert(allocated > currentallocated);
  for (idx=currentallocated; idx<allocated; idx++)
  {
    initBUinfo_shulen(&itvinfo[idx].info,state);
  }
  gt_assert(itvinfo != NULL);
  return itvinfo;
}

static int gt_esa_bottomup_shulen(Sequentialsuffixarrayreader *ssar,
                    GtBUstate_shulen *bustate,
                    /* no parameter snrp */
                    GtError *err)
{
  const GtUword incrementstacksize = 32UL;
  GtUword lcpvalue,
                previoussuffix = 0,
                idx,
                numberofsuffixes,
                lastsuftabvalue = 0;
  GtBUItvinfo_shulen *lastinterval = NULL;
  bool haserr = false, firstedge, firstedgefromroot = true;
  GtArrayGtBUItvinfo_shulen *stack;

  stack = gt_GtArrayGtBUItvinfo_new_shulen();
  PUSH_ESA_BOTTOMUP_shulen(0,0);
  numberofsuffixes = gt_Sequentialsuffixarrayreader_nonspecials(ssar);
  for (idx = 0; !haserr && idx < numberofsuffixes; idx++)
  {
    SSAR_NEXTSEQUENTIALLCPTABVALUEWITHLAST(lcpvalue,lastsuftabvalue,ssar);
    SSAR_NEXTSEQUENTIALSUFTABVALUE(previoussuffix,ssar);
    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_shulen(firstedge,
                          TOP_ESA_BOTTOMUP_shulen.lcp,
                          &TOP_ESA_BOTTOMUP_shulen.info,
                          previoussuffix,
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_shulen;
      lastinterval->rb = idx;
      /* no call to processlcpinterval_shulen */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
      {
        if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_shulen(firstedge,
               TOP_ESA_BOTTOMUP_shulen.lcp,
               &TOP_ESA_BOTTOMUP_shulen.info,
               lastinterval->lcp,
               lastinterval->rb - lastinterval->lb + 1,
               &lastinterval->info,
               bustate,
               err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (lastinterval != NULL)
      {
        GtUword lastintervallb = lastinterval->lb;
        GtUword lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,lastintervallb);
        if (processbranchingedge_shulen(true,
                       TOP_ESA_BOTTOMUP_shulen.lcp,
                       &TOP_ESA_BOTTOMUP_shulen.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,idx);
        if (processleafedge_shulen(true,
                            TOP_ESA_BOTTOMUP_shulen.lcp,
                            &TOP_ESA_BOTTOMUP_shulen.info,
                            previoussuffix,
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  }
  gt_assert(stack->nextfreeGtBUItvinfo > 0);
  if (!haserr && TOP_ESA_BOTTOMUP_shulen.lcp > 0)
  {
    /* no assignment to lastsuftabvalue */
    if (processleafedge_shulen(false,
                        TOP_ESA_BOTTOMUP_shulen.lcp,
                        &TOP_ESA_BOTTOMUP_shulen.info,
                        lastsuftabvalue,
                        bustate,
                        err) != 0)
    {
      haserr = true;
    } else
    {
      TOP_ESA_BOTTOMUP_shulen.rb = idx;
      /* no call to processlcpinterval_shulen */
    }
  }
  gt_GtArrayGtBUItvinfo_delete_shulen(stack,bustate);
  return haserr ? -1 : 0;
}
