/* Recording.c generated by valac 0.34.4, the Vala compiler
 * generated from Recording.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>


#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
typedef struct _DVBRecordingPrivate DVBRecordingPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_IO_TYPE_RECORDING_WRITER (dvb_io_recording_writer_get_type ())
#define DVB_IO_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriter))
#define DVB_IO_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))
#define DVB_IO_IS_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_IS_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_RECORDING_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))

typedef struct _DVBioRecordingWriter DVBioRecordingWriter;
typedef struct _DVBioRecordingWriterClass DVBioRecordingWriterClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

struct _DVBRecording {
	GObject parent_instance;
	DVBRecordingPrivate * priv;
};

struct _DVBRecordingClass {
	GObjectClass parent_class;
};

struct _DVBRecordingPrivate {
	guint32 _Id;
	guint _ChannelSid;
	gchar* _ChannelName;
	GFile* _Location;
	gchar* _Name;
	gchar* _Description;
	struct tm _StartTime;
	gint64 _Length;
	GFileMonitor* _file_monitor;
};


static gpointer dvb_recording_parent_class = NULL;
static DVBLoggingLogger* dvb_recording_log;
static DVBLoggingLogger* dvb_recording_log = NULL;

GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDING, DVBRecordingPrivate))
enum  {
	DVB_RECORDING_DUMMY_PROPERTY,
	DVB_RECORDING_ID,
	DVB_RECORDING_CHANNEL_SID,
	DVB_RECORDING_CHANNEL_NAME,
	DVB_RECORDING_LOCATION,
	DVB_RECORDING_NAME,
	DVB_RECORDING_DESCRIPTION,
	DVB_RECORDING_LENGTH,
	DVB_RECORDING_FILE_MONITOR
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
void dvb_recording_monitor_recording (DVBRecording* self);
GFile* dvb_recording_get_Location (DVBRecording* self);
void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value);
GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self);
static void dvb_recording_on_recording_file_changed (DVBRecording* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _dvb_recording_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void dvb_recording_save_to_disk (DVBRecording* self);
GType dvb_io_recording_writer_get_type (void) G_GNUC_CONST;
DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec);
DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec);
void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
guint32 dvb_recording_get_Id (DVBRecording* self);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
const gchar* dvb_recording_get_Name (DVBRecording* self);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
const gchar* dvb_recording_get_Description (DVBRecording* self);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
static void dvb_recording_finalize (GObject* obj);
static void _vala_dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


guint* dvb_recording_get_start (DVBRecording* self, int* result_length1) {
	guint* result = NULL;
	struct tm _tmp0_ = {0};
	gint _tmp1_ = 0;
	struct tm _tmp2_ = {0};
	gint _tmp3_ = 0;
	struct tm _tmp4_ = {0};
	gint _tmp5_ = 0;
	struct tm _tmp6_ = {0};
	gint _tmp7_ = 0;
	struct tm _tmp8_ = {0};
	gint _tmp9_ = 0;
	guint* _tmp10_ = NULL;
	guint* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_StartTime;
	_tmp1_ = _tmp0_.tm_year;
	_tmp2_ = self->priv->_StartTime;
	_tmp3_ = _tmp2_.tm_mon;
	_tmp4_ = self->priv->_StartTime;
	_tmp5_ = _tmp4_.tm_mday;
	_tmp6_ = self->priv->_StartTime;
	_tmp7_ = _tmp6_.tm_hour;
	_tmp8_ = self->priv->_StartTime;
	_tmp9_ = _tmp8_.tm_min;
	_tmp10_ = g_new0 (guint, 5);
	_tmp10_[0] = (guint) (_tmp1_ + 1900);
	_tmp10_[1] = (guint) (_tmp3_ + 1);
	_tmp10_[2] = (guint) _tmp5_;
	_tmp10_[3] = (guint) _tmp7_;
	_tmp10_[4] = (guint) _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 5;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}


static void _dvb_recording_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	dvb_recording_on_recording_file_changed ((DVBRecording*) self, _sender, file, other_file, event_type);
}


void dvb_recording_monitor_recording (DVBRecording* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileMonitor* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFileMonitor* _tmp2_ = NULL;
		GFileMonitor* _tmp3_ = NULL;
		_tmp1_ = self->priv->_Location;
		_tmp2_ = g_file_monitor_file (_tmp1_, 0, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch136_g_error;
		}
		dvb_recording_set_file_monitor (self, _tmp0_);
		_tmp3_ = self->priv->_file_monitor;
		g_signal_connect_object (_tmp3_, "changed", (GCallback) _dvb_recording_on_recording_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally136;
	__catch136_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Recording.vala:57: Could not create FileMonitor: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally136:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void dvb_recording_save_to_disk (DVBRecording* self) {
	DVBioRecordingWriter* writer = NULL;
	DVBioRecordingWriter* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_io_recording_writer_new (self);
	writer = _tmp0_;
	{
		dvb_io_recording_writer_write (writer, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch137_g_error;
		}
	}
	goto __finally137;
	__catch137_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = dvb_recording_log;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		dvb_logging_logger_error (_tmp1_, "Recording.vala:66: Could not save recording: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally137:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (writer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (writer);
}


static void dvb_recording_on_recording_file_changed (DVBRecording* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	GFileMonitorEvent _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = event;
	if (_tmp0_ == G_FILE_MONITOR_EVENT_DELETED) {
		gchar* location = NULL;
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		DVBLoggingLogger* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GFileMonitor* _tmp5_ = NULL;
		DVBRecordingsStore* _tmp6_ = NULL;
		_tmp1_ = file;
		_tmp2_ = g_file_get_path (_tmp1_);
		location = _tmp2_;
		_tmp3_ = dvb_recording_log;
		_tmp4_ = location;
		dvb_logging_logger_debug (_tmp3_, "Recording.vala:74: %s has been deleted", _tmp4_);
		_tmp5_ = monitor;
		g_file_monitor_cancel (_tmp5_);
		_tmp6_ = dvb_recordings_store_get_instance ();
		dvb_recordings_store_remove (_tmp6_, self);
		_g_free0 (location);
	}
}


DVBRecording* dvb_recording_construct (GType object_type) {
	DVBRecording * self = NULL;
	self = (DVBRecording*) g_object_new (object_type, NULL);
	return self;
}


DVBRecording* dvb_recording_new (void) {
	return dvb_recording_construct (DVB_TYPE_RECORDING);
}


guint32 dvb_recording_get_Id (DVBRecording* self) {
	guint32 result;
	guint32 _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Id;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_Id (DVBRecording* self, guint32 value) {
	guint32 _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Id = _tmp0_;
	g_object_notify ((GObject *) self, "Id");
}


guint dvb_recording_get_ChannelSid (DVBRecording* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_ChannelSid;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_ChannelSid (DVBRecording* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ChannelSid = _tmp0_;
	g_object_notify ((GObject *) self, "ChannelSid");
}


const gchar* dvb_recording_get_ChannelName (DVBRecording* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ChannelName;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_ChannelName);
	self->priv->_ChannelName = _tmp1_;
	g_object_notify ((GObject *) self, "ChannelName");
}


GFile* dvb_recording_get_Location (DVBRecording* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Location;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recording_set_Location (DVBRecording* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_Location);
	self->priv->_Location = _tmp1_;
	g_object_notify ((GObject *) self, "Location");
}


const gchar* dvb_recording_get_Name (DVBRecording* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Name;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_Name (DVBRecording* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Name);
	self->priv->_Name = _tmp1_;
	g_object_notify ((GObject *) self, "Name");
}


const gchar* dvb_recording_get_Description (DVBRecording* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Description;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_Description (DVBRecording* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Description);
	self->priv->_Description = _tmp1_;
	g_object_notify ((GObject *) self, "Description");
}


void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result) {
	struct tm _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_StartTime;
	*result = _tmp0_;
	return;
}


void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value) {
	struct tm _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_StartTime = _tmp0_;
}


gint64 dvb_recording_get_Length (DVBRecording* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_Length;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_Length (DVBRecording* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Length = _tmp0_;
	g_object_notify ((GObject *) self, "Length");
}


GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self) {
	GFileMonitor* result;
	GFileMonitor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_monitor;
	result = _tmp0_;
	return result;
}


void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value) {
	GFileMonitor* _tmp0_ = NULL;
	GFileMonitor* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file_monitor);
	self->priv->_file_monitor = _tmp1_;
	g_object_notify ((GObject *) self, "file-monitor");
}


static void dvb_recording_class_init (DVBRecordingClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_recording_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_recording_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_recording_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_recording_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_SID, g_param_spec_uint ("ChannelSid", "ChannelSid", "ChannelSid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_NAME, g_param_spec_string ("ChannelName", "ChannelName", "ChannelName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LOCATION, g_param_spec_object ("Location", "Location", "Location", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_DESCRIPTION, g_param_spec_string ("Description", "Description", "Description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LENGTH, g_param_spec_int64 ("Length", "Length", "Length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_FILE_MONITOR, g_param_spec_object ("file-monitor", "file-monitor", "file-monitor", g_file_monitor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_recording_log = _tmp1_;
}


static void dvb_recording_instance_init (DVBRecording * self) {
	self->priv = DVB_RECORDING_GET_PRIVATE (self);
}


static void dvb_recording_finalize (GObject* obj) {
	DVBRecording * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_RECORDING, DVBRecording);
	_g_free0 (self->priv->_ChannelName);
	_g_object_unref0 (self->priv->_Location);
	_g_free0 (self->priv->_Name);
	_g_free0 (self->priv->_Description);
	_g_object_unref0 (self->priv->_file_monitor);
	G_OBJECT_CLASS (dvb_recording_parent_class)->finalize (obj);
}


/**
     * This class represents a finished recording
     */
GType dvb_recording_get_type (void) {
	static volatile gsize dvb_recording_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recording_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recording_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecording), 0, (GInstanceInitFunc) dvb_recording_instance_init, NULL };
		GType dvb_recording_type_id;
		dvb_recording_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecording", &g_define_type_info, 0);
		g_once_init_leave (&dvb_recording_type_id__volatile, dvb_recording_type_id);
	}
	return dvb_recording_type_id__volatile;
}


static void _vala_dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_RECORDING, DVBRecording);
	switch (property_id) {
		case DVB_RECORDING_ID:
		g_value_set_uint (value, dvb_recording_get_Id (self));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		g_value_set_uint (value, dvb_recording_get_ChannelSid (self));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		g_value_set_string (value, dvb_recording_get_ChannelName (self));
		break;
		case DVB_RECORDING_LOCATION:
		g_value_set_object (value, dvb_recording_get_Location (self));
		break;
		case DVB_RECORDING_NAME:
		g_value_set_string (value, dvb_recording_get_Name (self));
		break;
		case DVB_RECORDING_DESCRIPTION:
		g_value_set_string (value, dvb_recording_get_Description (self));
		break;
		case DVB_RECORDING_LENGTH:
		g_value_set_int64 (value, dvb_recording_get_Length (self));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		g_value_set_object (value, dvb_recording_get_file_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_RECORDING, DVBRecording);
	switch (property_id) {
		case DVB_RECORDING_ID:
		dvb_recording_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		dvb_recording_set_ChannelSid (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		dvb_recording_set_ChannelName (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LOCATION:
		dvb_recording_set_Location (self, g_value_get_object (value));
		break;
		case DVB_RECORDING_NAME:
		dvb_recording_set_Name (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_DESCRIPTION:
		dvb_recording_set_Description (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LENGTH:
		dvb_recording_set_Length (self, g_value_get_int64 (value));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		dvb_recording_set_file_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



