// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists agents or collectors as specified by ID or other filters. All
// agents/collectors associated with your user can be listed if you call
// DescribeAgents as is without passing any parameters.
func (c *Client) DescribeAgents(ctx context.Context, params *DescribeAgentsInput, optFns ...func(*Options)) (*DescribeAgentsOutput, error) {
	if params == nil {
		params = &DescribeAgentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAgents", params, optFns, c.addOperationDescribeAgentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAgentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAgentsInput struct {

	// The agent or the collector IDs for which you want information. If you specify
	// no IDs, the system returns information about all agents/collectors associated
	// with your user.
	AgentIds []string

	// You can filter the request using various logical operators and a key-value
	// format. For example: {"key": "collectionStatus", "value": "STARTED"}
	Filters []types.Filter

	// The total number of agents/collectors to return in a single page of output. The
	// maximum value is 100.
	MaxResults int32

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for DescribeAgentsRequest$agentIds but set
	// DescribeAgentsRequest$maxResults to 10, you received a set of 10 results along
	// with a token. Use that token in this query to get the next set of 10.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeAgentsOutput struct {

	// Lists agents or the collector by ID or lists all agents/collectors associated
	// with your user, if you did not specify an agent/collector ID. The output
	// includes agent/collector IDs, IP addresses, media access control (MAC)
	// addresses, agent/collector health, host name where the agent/collector resides,
	// and the version number of each agent/collector.
	AgentsInfo []types.AgentInfo

	// Token to retrieve the next set of results. For example, if you specified 100
	// IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token in
	// the next query to retrieve the next set of 10.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAgentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeAgents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeAgents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAgents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeAgentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAgents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeAgentsAPIClient is a client that implements the DescribeAgents
// operation.
type DescribeAgentsAPIClient interface {
	DescribeAgents(context.Context, *DescribeAgentsInput, ...func(*Options)) (*DescribeAgentsOutput, error)
}

var _ DescribeAgentsAPIClient = (*Client)(nil)

// DescribeAgentsPaginatorOptions is the paginator options for DescribeAgents
type DescribeAgentsPaginatorOptions struct {
	// The total number of agents/collectors to return in a single page of output. The
	// maximum value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeAgentsPaginator is a paginator for DescribeAgents
type DescribeAgentsPaginator struct {
	options   DescribeAgentsPaginatorOptions
	client    DescribeAgentsAPIClient
	params    *DescribeAgentsInput
	nextToken *string
	firstPage bool
}

// NewDescribeAgentsPaginator returns a new DescribeAgentsPaginator
func NewDescribeAgentsPaginator(client DescribeAgentsAPIClient, params *DescribeAgentsInput, optFns ...func(*DescribeAgentsPaginatorOptions)) *DescribeAgentsPaginator {
	if params == nil {
		params = &DescribeAgentsInput{}
	}

	options := DescribeAgentsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeAgentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeAgentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeAgents page.
func (p *DescribeAgentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeAgentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeAgents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeAgents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAgents",
	}
}
