// Code generated by smithy-go-codegen DO NOT EDIT.

package iotanalytics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotanalytics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists information about dataset contents that have been created.
func (c *Client) ListDatasetContents(ctx context.Context, params *ListDatasetContentsInput, optFns ...func(*Options)) (*ListDatasetContentsOutput, error) {
	if params == nil {
		params = &ListDatasetContentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDatasetContents", params, optFns, c.addOperationListDatasetContentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDatasetContentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDatasetContentsInput struct {

	// The name of the dataset whose contents information you want to list.
	//
	// This member is required.
	DatasetName *string

	// The maximum number of results to return in this request.
	MaxResults *int32

	// The token for the next set of results.
	NextToken *string

	// A filter to limit results to those dataset contents whose creation is scheduled
	// before the given time. See the field triggers.schedule in the CreateDataset
	// request. (timestamp)
	ScheduledBefore *time.Time

	// A filter to limit results to those dataset contents whose creation is scheduled
	// on or after the given time. See the field triggers.schedule in the CreateDataset
	// request. (timestamp)
	ScheduledOnOrAfter *time.Time

	noSmithyDocumentSerde
}

type ListDatasetContentsOutput struct {

	// Summary information about dataset contents that have been created.
	DatasetContentSummaries []types.DatasetContentSummary

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDatasetContentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDatasetContents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDatasetContents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDatasetContents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListDatasetContentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDatasetContents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDatasetContentsAPIClient is a client that implements the
// ListDatasetContents operation.
type ListDatasetContentsAPIClient interface {
	ListDatasetContents(context.Context, *ListDatasetContentsInput, ...func(*Options)) (*ListDatasetContentsOutput, error)
}

var _ ListDatasetContentsAPIClient = (*Client)(nil)

// ListDatasetContentsPaginatorOptions is the paginator options for
// ListDatasetContents
type ListDatasetContentsPaginatorOptions struct {
	// The maximum number of results to return in this request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDatasetContentsPaginator is a paginator for ListDatasetContents
type ListDatasetContentsPaginator struct {
	options   ListDatasetContentsPaginatorOptions
	client    ListDatasetContentsAPIClient
	params    *ListDatasetContentsInput
	nextToken *string
	firstPage bool
}

// NewListDatasetContentsPaginator returns a new ListDatasetContentsPaginator
func NewListDatasetContentsPaginator(client ListDatasetContentsAPIClient, params *ListDatasetContentsInput, optFns ...func(*ListDatasetContentsPaginatorOptions)) *ListDatasetContentsPaginator {
	if params == nil {
		params = &ListDatasetContentsInput{}
	}

	options := ListDatasetContentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDatasetContentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDatasetContentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDatasetContents page.
func (p *ListDatasetContentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDatasetContentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDatasetContents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDatasetContents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDatasetContents",
	}
}
