// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpDecryptData struct {
}

func (*awsRestjson1_serializeOpDecryptData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDecryptData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DecryptDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/keys/{KeyIdentifier}/decrypt")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDecryptDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDecryptDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDecryptDataInput(v *DecryptDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyIdentifier == nil || len(*v.KeyIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyIdentifier must not be empty")}
	}
	if v.KeyIdentifier != nil {
		if err := encoder.SetURI("KeyIdentifier").String(*v.KeyIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDecryptDataInput(v *DecryptDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CipherText != nil {
		ok := object.Key("CipherText")
		ok.String(*v.CipherText)
	}

	if v.DecryptionAttributes != nil {
		ok := object.Key("DecryptionAttributes")
		if err := awsRestjson1_serializeDocumentEncryptionDecryptionAttributes(v.DecryptionAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEncryptData struct {
}

func (*awsRestjson1_serializeOpEncryptData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEncryptData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EncryptDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/keys/{KeyIdentifier}/encrypt")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsEncryptDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEncryptDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEncryptDataInput(v *EncryptDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyIdentifier == nil || len(*v.KeyIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyIdentifier must not be empty")}
	}
	if v.KeyIdentifier != nil {
		if err := encoder.SetURI("KeyIdentifier").String(*v.KeyIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEncryptDataInput(v *EncryptDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionAttributes != nil {
		ok := object.Key("EncryptionAttributes")
		if err := awsRestjson1_serializeDocumentEncryptionDecryptionAttributes(v.EncryptionAttributes, ok); err != nil {
			return err
		}
	}

	if v.PlainText != nil {
		ok := object.Key("PlainText")
		ok.String(*v.PlainText)
	}

	return nil
}

type awsRestjson1_serializeOpGenerateCardValidationData struct {
}

func (*awsRestjson1_serializeOpGenerateCardValidationData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateCardValidationData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateCardValidationDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cardvalidationdata/generate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateCardValidationDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateCardValidationDataInput(v *GenerateCardValidationDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateCardValidationDataInput(v *GenerateCardValidationDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerationAttributes != nil {
		ok := object.Key("GenerationAttributes")
		if err := awsRestjson1_serializeDocumentCardGenerationAttributes(v.GenerationAttributes, ok); err != nil {
			return err
		}
	}

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	if v.ValidationDataLength != nil {
		ok := object.Key("ValidationDataLength")
		ok.Integer(*v.ValidationDataLength)
	}

	return nil
}

type awsRestjson1_serializeOpGenerateMac struct {
}

func (*awsRestjson1_serializeOpGenerateMac) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateMac) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateMacInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mac/generate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateMacInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateMacInput(v *GenerateMacInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateMacInput(v *GenerateMacInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerationAttributes != nil {
		ok := object.Key("GenerationAttributes")
		if err := awsRestjson1_serializeDocumentMacAttributes(v.GenerationAttributes, ok); err != nil {
			return err
		}
	}

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	if v.MacLength != nil {
		ok := object.Key("MacLength")
		ok.Integer(*v.MacLength)
	}

	if v.MessageData != nil {
		ok := object.Key("MessageData")
		ok.String(*v.MessageData)
	}

	return nil
}

type awsRestjson1_serializeOpGeneratePinData struct {
}

func (*awsRestjson1_serializeOpGeneratePinData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGeneratePinData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GeneratePinDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pindata/generate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGeneratePinDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGeneratePinDataInput(v *GeneratePinDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGeneratePinDataInput(v *GeneratePinDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionKeyIdentifier != nil {
		ok := object.Key("EncryptionKeyIdentifier")
		ok.String(*v.EncryptionKeyIdentifier)
	}

	if v.GenerationAttributes != nil {
		ok := object.Key("GenerationAttributes")
		if err := awsRestjson1_serializeDocumentPinGenerationAttributes(v.GenerationAttributes, ok); err != nil {
			return err
		}
	}

	if v.GenerationKeyIdentifier != nil {
		ok := object.Key("GenerationKeyIdentifier")
		ok.String(*v.GenerationKeyIdentifier)
	}

	if len(v.PinBlockFormat) > 0 {
		ok := object.Key("PinBlockFormat")
		ok.String(string(v.PinBlockFormat))
	}

	if v.PinDataLength != nil {
		ok := object.Key("PinDataLength")
		ok.Integer(*v.PinDataLength)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

type awsRestjson1_serializeOpReEncryptData struct {
}

func (*awsRestjson1_serializeOpReEncryptData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpReEncryptData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReEncryptDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/keys/{IncomingKeyIdentifier}/reencrypt")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsReEncryptDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentReEncryptDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsReEncryptDataInput(v *ReEncryptDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IncomingKeyIdentifier == nil || len(*v.IncomingKeyIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IncomingKeyIdentifier must not be empty")}
	}
	if v.IncomingKeyIdentifier != nil {
		if err := encoder.SetURI("IncomingKeyIdentifier").String(*v.IncomingKeyIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentReEncryptDataInput(v *ReEncryptDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CipherText != nil {
		ok := object.Key("CipherText")
		ok.String(*v.CipherText)
	}

	if v.IncomingEncryptionAttributes != nil {
		ok := object.Key("IncomingEncryptionAttributes")
		if err := awsRestjson1_serializeDocumentReEncryptionAttributes(v.IncomingEncryptionAttributes, ok); err != nil {
			return err
		}
	}

	if v.OutgoingEncryptionAttributes != nil {
		ok := object.Key("OutgoingEncryptionAttributes")
		if err := awsRestjson1_serializeDocumentReEncryptionAttributes(v.OutgoingEncryptionAttributes, ok); err != nil {
			return err
		}
	}

	if v.OutgoingKeyIdentifier != nil {
		ok := object.Key("OutgoingKeyIdentifier")
		ok.String(*v.OutgoingKeyIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpTranslatePinData struct {
}

func (*awsRestjson1_serializeOpTranslatePinData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTranslatePinData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TranslatePinDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pindata/translate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTranslatePinDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTranslatePinDataInput(v *TranslatePinDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTranslatePinDataInput(v *TranslatePinDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptedPinBlock != nil {
		ok := object.Key("EncryptedPinBlock")
		ok.String(*v.EncryptedPinBlock)
	}

	if v.IncomingDukptAttributes != nil {
		ok := object.Key("IncomingDukptAttributes")
		if err := awsRestjson1_serializeDocumentDukptDerivationAttributes(v.IncomingDukptAttributes, ok); err != nil {
			return err
		}
	}

	if v.IncomingKeyIdentifier != nil {
		ok := object.Key("IncomingKeyIdentifier")
		ok.String(*v.IncomingKeyIdentifier)
	}

	if v.IncomingTranslationAttributes != nil {
		ok := object.Key("IncomingTranslationAttributes")
		if err := awsRestjson1_serializeDocumentTranslationIsoFormats(v.IncomingTranslationAttributes, ok); err != nil {
			return err
		}
	}

	if v.OutgoingDukptAttributes != nil {
		ok := object.Key("OutgoingDukptAttributes")
		if err := awsRestjson1_serializeDocumentDukptDerivationAttributes(v.OutgoingDukptAttributes, ok); err != nil {
			return err
		}
	}

	if v.OutgoingKeyIdentifier != nil {
		ok := object.Key("OutgoingKeyIdentifier")
		ok.String(*v.OutgoingKeyIdentifier)
	}

	if v.OutgoingTranslationAttributes != nil {
		ok := object.Key("OutgoingTranslationAttributes")
		if err := awsRestjson1_serializeDocumentTranslationIsoFormats(v.OutgoingTranslationAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpVerifyAuthRequestCryptogram struct {
}

func (*awsRestjson1_serializeOpVerifyAuthRequestCryptogram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpVerifyAuthRequestCryptogram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyAuthRequestCryptogramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cryptogram/verify")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentVerifyAuthRequestCryptogramInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsVerifyAuthRequestCryptogramInput(v *VerifyAuthRequestCryptogramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentVerifyAuthRequestCryptogramInput(v *VerifyAuthRequestCryptogramInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthRequestCryptogram != nil {
		ok := object.Key("AuthRequestCryptogram")
		ok.String(*v.AuthRequestCryptogram)
	}

	if v.AuthResponseAttributes != nil {
		ok := object.Key("AuthResponseAttributes")
		if err := awsRestjson1_serializeDocumentCryptogramAuthResponse(v.AuthResponseAttributes, ok); err != nil {
			return err
		}
	}

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	if len(v.MajorKeyDerivationMode) > 0 {
		ok := object.Key("MajorKeyDerivationMode")
		ok.String(string(v.MajorKeyDerivationMode))
	}

	if v.SessionKeyDerivationAttributes != nil {
		ok := object.Key("SessionKeyDerivationAttributes")
		if err := awsRestjson1_serializeDocumentSessionKeyDerivation(v.SessionKeyDerivationAttributes, ok); err != nil {
			return err
		}
	}

	if v.TransactionData != nil {
		ok := object.Key("TransactionData")
		ok.String(*v.TransactionData)
	}

	return nil
}

type awsRestjson1_serializeOpVerifyCardValidationData struct {
}

func (*awsRestjson1_serializeOpVerifyCardValidationData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpVerifyCardValidationData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyCardValidationDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/cardvalidationdata/verify")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentVerifyCardValidationDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsVerifyCardValidationDataInput(v *VerifyCardValidationDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentVerifyCardValidationDataInput(v *VerifyCardValidationDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	if v.ValidationData != nil {
		ok := object.Key("ValidationData")
		ok.String(*v.ValidationData)
	}

	if v.VerificationAttributes != nil {
		ok := object.Key("VerificationAttributes")
		if err := awsRestjson1_serializeDocumentCardVerificationAttributes(v.VerificationAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpVerifyMac struct {
}

func (*awsRestjson1_serializeOpVerifyMac) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpVerifyMac) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyMacInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/mac/verify")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentVerifyMacInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsVerifyMacInput(v *VerifyMacInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentVerifyMacInput(v *VerifyMacInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	if v.Mac != nil {
		ok := object.Key("Mac")
		ok.String(*v.Mac)
	}

	if v.MacLength != nil {
		ok := object.Key("MacLength")
		ok.Integer(*v.MacLength)
	}

	if v.MessageData != nil {
		ok := object.Key("MessageData")
		ok.String(*v.MessageData)
	}

	if v.VerificationAttributes != nil {
		ok := object.Key("VerificationAttributes")
		if err := awsRestjson1_serializeDocumentMacAttributes(v.VerificationAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpVerifyPinData struct {
}

func (*awsRestjson1_serializeOpVerifyPinData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpVerifyPinData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyPinDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pindata/verify")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentVerifyPinDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsVerifyPinDataInput(v *VerifyPinDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentVerifyPinDataInput(v *VerifyPinDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DukptAttributes != nil {
		ok := object.Key("DukptAttributes")
		if err := awsRestjson1_serializeDocumentDukptAttributes(v.DukptAttributes, ok); err != nil {
			return err
		}
	}

	if v.EncryptedPinBlock != nil {
		ok := object.Key("EncryptedPinBlock")
		ok.String(*v.EncryptedPinBlock)
	}

	if v.EncryptionKeyIdentifier != nil {
		ok := object.Key("EncryptionKeyIdentifier")
		ok.String(*v.EncryptionKeyIdentifier)
	}

	if len(v.PinBlockFormat) > 0 {
		ok := object.Key("PinBlockFormat")
		ok.String(string(v.PinBlockFormat))
	}

	if v.PinDataLength != nil {
		ok := object.Key("PinDataLength")
		ok.Integer(*v.PinDataLength)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	if v.VerificationAttributes != nil {
		ok := object.Key("VerificationAttributes")
		if err := awsRestjson1_serializeDocumentPinVerificationAttributes(v.VerificationAttributes, ok); err != nil {
			return err
		}
	}

	if v.VerificationKeyIdentifier != nil {
		ok := object.Key("VerificationKeyIdentifier")
		ok.String(*v.VerificationKeyIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion1(v *types.AmexCardSecurityCodeVersion1, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion2(v *types.AmexCardSecurityCodeVersion2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	if v.ServiceCode != nil {
		ok := object.Key("ServiceCode")
		ok.String(*v.ServiceCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentAsymmetricEncryptionAttributes(v *types.AsymmetricEncryptionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PaddingType) > 0 {
		ok := object.Key("PaddingType")
		ok.String(string(v.PaddingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentCardGenerationAttributes(v types.CardGenerationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CardGenerationAttributesMemberAmexCardSecurityCodeVersion1:
		av := object.Key("AmexCardSecurityCodeVersion1")
		if err := awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion1(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberAmexCardSecurityCodeVersion2:
		av := object.Key("AmexCardSecurityCodeVersion2")
		if err := awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion2(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberCardHolderVerificationValue:
		av := object.Key("CardHolderVerificationValue")
		if err := awsRestjson1_serializeDocumentCardHolderVerificationValue(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberCardVerificationValue1:
		av := object.Key("CardVerificationValue1")
		if err := awsRestjson1_serializeDocumentCardVerificationValue1(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberCardVerificationValue2:
		av := object.Key("CardVerificationValue2")
		if err := awsRestjson1_serializeDocumentCardVerificationValue2(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberDynamicCardVerificationCode:
		av := object.Key("DynamicCardVerificationCode")
		if err := awsRestjson1_serializeDocumentDynamicCardVerificationCode(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardGenerationAttributesMemberDynamicCardVerificationValue:
		av := object.Key("DynamicCardVerificationValue")
		if err := awsRestjson1_serializeDocumentDynamicCardVerificationValue(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCardHolderVerificationValue(v *types.CardHolderVerificationValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.UnpredictableNumber != nil {
		ok := object.Key("UnpredictableNumber")
		ok.String(*v.UnpredictableNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentCardVerificationAttributes(v types.CardVerificationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CardVerificationAttributesMemberAmexCardSecurityCodeVersion1:
		av := object.Key("AmexCardSecurityCodeVersion1")
		if err := awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion1(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberAmexCardSecurityCodeVersion2:
		av := object.Key("AmexCardSecurityCodeVersion2")
		if err := awsRestjson1_serializeDocumentAmexCardSecurityCodeVersion2(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberCardHolderVerificationValue:
		av := object.Key("CardHolderVerificationValue")
		if err := awsRestjson1_serializeDocumentCardHolderVerificationValue(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberCardVerificationValue1:
		av := object.Key("CardVerificationValue1")
		if err := awsRestjson1_serializeDocumentCardVerificationValue1(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberCardVerificationValue2:
		av := object.Key("CardVerificationValue2")
		if err := awsRestjson1_serializeDocumentCardVerificationValue2(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberDiscoverDynamicCardVerificationCode:
		av := object.Key("DiscoverDynamicCardVerificationCode")
		if err := awsRestjson1_serializeDocumentDiscoverDynamicCardVerificationCode(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberDynamicCardVerificationCode:
		av := object.Key("DynamicCardVerificationCode")
		if err := awsRestjson1_serializeDocumentDynamicCardVerificationCode(&uv.Value, av); err != nil {
			return err
		}

	case *types.CardVerificationAttributesMemberDynamicCardVerificationValue:
		av := object.Key("DynamicCardVerificationValue")
		if err := awsRestjson1_serializeDocumentDynamicCardVerificationValue(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCardVerificationValue1(v *types.CardVerificationValue1, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	if v.ServiceCode != nil {
		ok := object.Key("ServiceCode")
		ok.String(*v.ServiceCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentCardVerificationValue2(v *types.CardVerificationValue2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	return nil
}

func awsRestjson1_serializeDocumentCryptogramAuthResponse(v types.CryptogramAuthResponse, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CryptogramAuthResponseMemberArpcMethod1:
		av := object.Key("ArpcMethod1")
		if err := awsRestjson1_serializeDocumentCryptogramVerificationArpcMethod1(&uv.Value, av); err != nil {
			return err
		}

	case *types.CryptogramAuthResponseMemberArpcMethod2:
		av := object.Key("ArpcMethod2")
		if err := awsRestjson1_serializeDocumentCryptogramVerificationArpcMethod2(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCryptogramVerificationArpcMethod1(v *types.CryptogramVerificationArpcMethod1, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthResponseCode != nil {
		ok := object.Key("AuthResponseCode")
		ok.String(*v.AuthResponseCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentCryptogramVerificationArpcMethod2(v *types.CryptogramVerificationArpcMethod2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CardStatusUpdate != nil {
		ok := object.Key("CardStatusUpdate")
		ok.String(*v.CardStatusUpdate)
	}

	if v.ProprietaryAuthenticationData != nil {
		ok := object.Key("ProprietaryAuthenticationData")
		ok.String(*v.ProprietaryAuthenticationData)
	}

	return nil
}

func awsRestjson1_serializeDocumentDiscoverDynamicCardVerificationCode(v *types.DiscoverDynamicCardVerificationCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	if v.UnpredictableNumber != nil {
		ok := object.Key("UnpredictableNumber")
		ok.String(*v.UnpredictableNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentDukptAttributes(v *types.DukptAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DukptDerivationType) > 0 {
		ok := object.Key("DukptDerivationType")
		ok.String(string(v.DukptDerivationType))
	}

	if v.KeySerialNumber != nil {
		ok := object.Key("KeySerialNumber")
		ok.String(*v.KeySerialNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentDukptDerivationAttributes(v *types.DukptDerivationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DukptKeyDerivationType) > 0 {
		ok := object.Key("DukptKeyDerivationType")
		ok.String(string(v.DukptKeyDerivationType))
	}

	if len(v.DukptKeyVariant) > 0 {
		ok := object.Key("DukptKeyVariant")
		ok.String(string(v.DukptKeyVariant))
	}

	if v.KeySerialNumber != nil {
		ok := object.Key("KeySerialNumber")
		ok.String(*v.KeySerialNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentDukptEncryptionAttributes(v *types.DukptEncryptionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DukptKeyDerivationType) > 0 {
		ok := object.Key("DukptKeyDerivationType")
		ok.String(string(v.DukptKeyDerivationType))
	}

	if len(v.DukptKeyVariant) > 0 {
		ok := object.Key("DukptKeyVariant")
		ok.String(string(v.DukptKeyVariant))
	}

	if v.InitializationVector != nil {
		ok := object.Key("InitializationVector")
		ok.String(*v.InitializationVector)
	}

	if v.KeySerialNumber != nil {
		ok := object.Key("KeySerialNumber")
		ok.String(*v.KeySerialNumber)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamicCardVerificationCode(v *types.DynamicCardVerificationCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.TrackData != nil {
		ok := object.Key("TrackData")
		ok.String(*v.TrackData)
	}

	if v.UnpredictableNumber != nil {
		ok := object.Key("UnpredictableNumber")
		ok.String(*v.UnpredictableNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamicCardVerificationValue(v *types.DynamicCardVerificationValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.CardExpiryDate != nil {
		ok := object.Key("CardExpiryDate")
		ok.String(*v.CardExpiryDate)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.ServiceCode != nil {
		ok := object.Key("ServiceCode")
		ok.String(*v.ServiceCode)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionDecryptionAttributes(v types.EncryptionDecryptionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EncryptionDecryptionAttributesMemberAsymmetric:
		av := object.Key("Asymmetric")
		if err := awsRestjson1_serializeDocumentAsymmetricEncryptionAttributes(&uv.Value, av); err != nil {
			return err
		}

	case *types.EncryptionDecryptionAttributesMemberDukpt:
		av := object.Key("Dukpt")
		if err := awsRestjson1_serializeDocumentDukptEncryptionAttributes(&uv.Value, av); err != nil {
			return err
		}

	case *types.EncryptionDecryptionAttributesMemberSymmetric:
		av := object.Key("Symmetric")
		if err := awsRestjson1_serializeDocumentSymmetricEncryptionAttributes(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentIbm3624NaturalPin(v *types.Ibm3624NaturalPin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalizationTable != nil {
		ok := object.Key("DecimalizationTable")
		ok.String(*v.DecimalizationTable)
	}

	if v.PinValidationData != nil {
		ok := object.Key("PinValidationData")
		ok.String(*v.PinValidationData)
	}

	if v.PinValidationDataPadCharacter != nil {
		ok := object.Key("PinValidationDataPadCharacter")
		ok.String(*v.PinValidationDataPadCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentIbm3624PinFromOffset(v *types.Ibm3624PinFromOffset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalizationTable != nil {
		ok := object.Key("DecimalizationTable")
		ok.String(*v.DecimalizationTable)
	}

	if v.PinOffset != nil {
		ok := object.Key("PinOffset")
		ok.String(*v.PinOffset)
	}

	if v.PinValidationData != nil {
		ok := object.Key("PinValidationData")
		ok.String(*v.PinValidationData)
	}

	if v.PinValidationDataPadCharacter != nil {
		ok := object.Key("PinValidationDataPadCharacter")
		ok.String(*v.PinValidationDataPadCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentIbm3624PinOffset(v *types.Ibm3624PinOffset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalizationTable != nil {
		ok := object.Key("DecimalizationTable")
		ok.String(*v.DecimalizationTable)
	}

	if v.EncryptedPinBlock != nil {
		ok := object.Key("EncryptedPinBlock")
		ok.String(*v.EncryptedPinBlock)
	}

	if v.PinValidationData != nil {
		ok := object.Key("PinValidationData")
		ok.String(*v.PinValidationData)
	}

	if v.PinValidationDataPadCharacter != nil {
		ok := object.Key("PinValidationDataPadCharacter")
		ok.String(*v.PinValidationDataPadCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentIbm3624PinVerification(v *types.Ibm3624PinVerification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalizationTable != nil {
		ok := object.Key("DecimalizationTable")
		ok.String(*v.DecimalizationTable)
	}

	if v.PinOffset != nil {
		ok := object.Key("PinOffset")
		ok.String(*v.PinOffset)
	}

	if v.PinValidationData != nil {
		ok := object.Key("PinValidationData")
		ok.String(*v.PinValidationData)
	}

	if v.PinValidationDataPadCharacter != nil {
		ok := object.Key("PinValidationDataPadCharacter")
		ok.String(*v.PinValidationDataPadCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentIbm3624RandomPin(v *types.Ibm3624RandomPin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecimalizationTable != nil {
		ok := object.Key("DecimalizationTable")
		ok.String(*v.DecimalizationTable)
	}

	if v.PinValidationData != nil {
		ok := object.Key("PinValidationData")
		ok.String(*v.PinValidationData)
	}

	if v.PinValidationDataPadCharacter != nil {
		ok := object.Key("PinValidationDataPadCharacter")
		ok.String(*v.PinValidationDataPadCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentMacAlgorithmDukpt(v *types.MacAlgorithmDukpt, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DukptDerivationType) > 0 {
		ok := object.Key("DukptDerivationType")
		ok.String(string(v.DukptDerivationType))
	}

	if len(v.DukptKeyVariant) > 0 {
		ok := object.Key("DukptKeyVariant")
		ok.String(string(v.DukptKeyVariant))
	}

	if v.KeySerialNumber != nil {
		ok := object.Key("KeySerialNumber")
		ok.String(*v.KeySerialNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentMacAlgorithmEmv(v *types.MacAlgorithmEmv, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MajorKeyDerivationMode) > 0 {
		ok := object.Key("MajorKeyDerivationMode")
		ok.String(string(v.MajorKeyDerivationMode))
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	if len(v.SessionKeyDerivationMode) > 0 {
		ok := object.Key("SessionKeyDerivationMode")
		ok.String(string(v.SessionKeyDerivationMode))
	}

	if v.SessionKeyDerivationValue != nil {
		ok := object.Key("SessionKeyDerivationValue")
		if err := awsRestjson1_serializeDocumentSessionKeyDerivationValue(v.SessionKeyDerivationValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMacAttributes(v types.MacAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MacAttributesMemberAlgorithm:
		av := object.Key("Algorithm")
		av.String(string(uv.Value))

	case *types.MacAttributesMemberDukptCmac:
		av := object.Key("DukptCmac")
		if err := awsRestjson1_serializeDocumentMacAlgorithmDukpt(&uv.Value, av); err != nil {
			return err
		}

	case *types.MacAttributesMemberDukptIso9797Algorithm1:
		av := object.Key("DukptIso9797Algorithm1")
		if err := awsRestjson1_serializeDocumentMacAlgorithmDukpt(&uv.Value, av); err != nil {
			return err
		}

	case *types.MacAttributesMemberDukptIso9797Algorithm3:
		av := object.Key("DukptIso9797Algorithm3")
		if err := awsRestjson1_serializeDocumentMacAlgorithmDukpt(&uv.Value, av); err != nil {
			return err
		}

	case *types.MacAttributesMemberEmvMac:
		av := object.Key("EmvMac")
		if err := awsRestjson1_serializeDocumentMacAlgorithmEmv(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPinGenerationAttributes(v types.PinGenerationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PinGenerationAttributesMemberIbm3624NaturalPin:
		av := object.Key("Ibm3624NaturalPin")
		if err := awsRestjson1_serializeDocumentIbm3624NaturalPin(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinGenerationAttributesMemberIbm3624PinFromOffset:
		av := object.Key("Ibm3624PinFromOffset")
		if err := awsRestjson1_serializeDocumentIbm3624PinFromOffset(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinGenerationAttributesMemberIbm3624PinOffset:
		av := object.Key("Ibm3624PinOffset")
		if err := awsRestjson1_serializeDocumentIbm3624PinOffset(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinGenerationAttributesMemberIbm3624RandomPin:
		av := object.Key("Ibm3624RandomPin")
		if err := awsRestjson1_serializeDocumentIbm3624RandomPin(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinGenerationAttributesMemberVisaPin:
		av := object.Key("VisaPin")
		if err := awsRestjson1_serializeDocumentVisaPin(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinGenerationAttributesMemberVisaPinVerificationValue:
		av := object.Key("VisaPinVerificationValue")
		if err := awsRestjson1_serializeDocumentVisaPinVerificationValue(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPinVerificationAttributes(v types.PinVerificationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PinVerificationAttributesMemberIbm3624Pin:
		av := object.Key("Ibm3624Pin")
		if err := awsRestjson1_serializeDocumentIbm3624PinVerification(&uv.Value, av); err != nil {
			return err
		}

	case *types.PinVerificationAttributesMemberVisaPin:
		av := object.Key("VisaPin")
		if err := awsRestjson1_serializeDocumentVisaPinVerification(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentReEncryptionAttributes(v types.ReEncryptionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ReEncryptionAttributesMemberDukpt:
		av := object.Key("Dukpt")
		if err := awsRestjson1_serializeDocumentDukptEncryptionAttributes(&uv.Value, av); err != nil {
			return err
		}

	case *types.ReEncryptionAttributesMemberSymmetric:
		av := object.Key("Symmetric")
		if err := awsRestjson1_serializeDocumentSymmetricEncryptionAttributes(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSessionKeyAmex(v *types.SessionKeyAmex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionKeyDerivation(v types.SessionKeyDerivation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SessionKeyDerivationMemberAmex:
		av := object.Key("Amex")
		if err := awsRestjson1_serializeDocumentSessionKeyAmex(&uv.Value, av); err != nil {
			return err
		}

	case *types.SessionKeyDerivationMemberEmv2000:
		av := object.Key("Emv2000")
		if err := awsRestjson1_serializeDocumentSessionKeyEmv2000(&uv.Value, av); err != nil {
			return err
		}

	case *types.SessionKeyDerivationMemberEmvCommon:
		av := object.Key("EmvCommon")
		if err := awsRestjson1_serializeDocumentSessionKeyEmvCommon(&uv.Value, av); err != nil {
			return err
		}

	case *types.SessionKeyDerivationMemberMastercard:
		av := object.Key("Mastercard")
		if err := awsRestjson1_serializeDocumentSessionKeyMastercard(&uv.Value, av); err != nil {
			return err
		}

	case *types.SessionKeyDerivationMemberVisa:
		av := object.Key("Visa")
		if err := awsRestjson1_serializeDocumentSessionKeyVisa(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSessionKeyDerivationValue(v types.SessionKeyDerivationValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SessionKeyDerivationValueMemberApplicationCryptogram:
		av := object.Key("ApplicationCryptogram")
		av.String(uv.Value)

	case *types.SessionKeyDerivationValueMemberApplicationTransactionCounter:
		av := object.Key("ApplicationTransactionCounter")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSessionKeyEmv2000(v *types.SessionKeyEmv2000, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionKeyEmvCommon(v *types.SessionKeyEmvCommon, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionKeyMastercard(v *types.SessionKeyMastercard, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationTransactionCounter != nil {
		ok := object.Key("ApplicationTransactionCounter")
		ok.String(*v.ApplicationTransactionCounter)
	}

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	if v.UnpredictableNumber != nil {
		ok := object.Key("UnpredictableNumber")
		ok.String(*v.UnpredictableNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionKeyVisa(v *types.SessionKeyVisa, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PanSequenceNumber != nil {
		ok := object.Key("PanSequenceNumber")
		ok.String(*v.PanSequenceNumber)
	}

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentSymmetricEncryptionAttributes(v *types.SymmetricEncryptionAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitializationVector != nil {
		ok := object.Key("InitializationVector")
		ok.String(*v.InitializationVector)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	if len(v.PaddingType) > 0 {
		ok := object.Key("PaddingType")
		ok.String(string(v.PaddingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTranslationIsoFormats(v types.TranslationIsoFormats, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.TranslationIsoFormatsMemberIsoFormat0:
		av := object.Key("IsoFormat0")
		if err := awsRestjson1_serializeDocumentTranslationPinDataIsoFormat034(&uv.Value, av); err != nil {
			return err
		}

	case *types.TranslationIsoFormatsMemberIsoFormat1:
		av := object.Key("IsoFormat1")
		if err := awsRestjson1_serializeDocumentTranslationPinDataIsoFormat1(&uv.Value, av); err != nil {
			return err
		}

	case *types.TranslationIsoFormatsMemberIsoFormat3:
		av := object.Key("IsoFormat3")
		if err := awsRestjson1_serializeDocumentTranslationPinDataIsoFormat034(&uv.Value, av); err != nil {
			return err
		}

	case *types.TranslationIsoFormatsMemberIsoFormat4:
		av := object.Key("IsoFormat4")
		if err := awsRestjson1_serializeDocumentTranslationPinDataIsoFormat034(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentTranslationPinDataIsoFormat034(v *types.TranslationPinDataIsoFormat034, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrimaryAccountNumber != nil {
		ok := object.Key("PrimaryAccountNumber")
		ok.String(*v.PrimaryAccountNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentTranslationPinDataIsoFormat1(v *types.TranslationPinDataIsoFormat1, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentVisaPin(v *types.VisaPin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PinVerificationKeyIndex != nil {
		ok := object.Key("PinVerificationKeyIndex")
		ok.Integer(*v.PinVerificationKeyIndex)
	}

	return nil
}

func awsRestjson1_serializeDocumentVisaPinVerification(v *types.VisaPinVerification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PinVerificationKeyIndex != nil {
		ok := object.Key("PinVerificationKeyIndex")
		ok.Integer(*v.PinVerificationKeyIndex)
	}

	if v.VerificationValue != nil {
		ok := object.Key("VerificationValue")
		ok.String(*v.VerificationValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentVisaPinVerificationValue(v *types.VisaPinVerificationValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptedPinBlock != nil {
		ok := object.Key("EncryptedPinBlock")
		ok.String(*v.EncryptedPinBlock)
	}

	if v.PinVerificationKeyIndex != nil {
		ok := object.Key("PinVerificationKeyIndex")
		ok.Integer(*v.PinVerificationKeyIndex)
	}

	return nil
}
