
// w20_2a_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -10.000000
 // --table_div  1.000000
 // --table_op  0.020000

struct tablew20_2a_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablew20_2a_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablew20_2a_neg&() const { return *(tablew20_2a_neg*)this; }
};

 static tablew20_2a_neg_imp<2048> w20_2a_neg_table __rt_data = {
	0,0.00185676,4.094,2048, {
	0.000000000000,0.072348300926,0.140660805033,0.176034316294,0.189144547117,
	0.196235506581,0.200912692525,0.204320969364,0.206954482669,0.209068764162,
	0.210812365085,0.212279009349,0.213531506318,0.214613948592,0.215558446369,
	0.216389090687,0.217124406717,0.217778937378,0.218364302125,0.218889926343,
	0.219363556927,0.219791634998,0.220179570714,0.220531949449,0.220852688927,
	0.221145160653,0.221412284950,0.221656606200,0.221880353036,0.222085486962,
	0.222273738975,0.222446654268,0.222605600685,0.222751803641,0.222886361814,
	0.223010263055,0.223124397877,0.223229570986,0.223326511157,0.223415879753,
	0.223498278093,0.223574253861,0.223644306698,0.223708893094,0.223768430695,
	0.223823302101,0.223873858221,0.223920421256,0.223963287347,0.224002728948,
	0.224038996934,0.224072322508,0.224102918900,0.224130982903,0.224156696266,
	0.224180226939,0.224201730214,0.224221349753,0.224239218526,0.224255459659,
	0.224270187216,0.224283506905,0.224295516726,0.224306307566,0.224315963740,
	0.224324563491,0.224332179447,0.224338879038,0.224344724889,0.224349775170,
	0.224354083924,0.224357701375,0.224360674198,0.224363045784,0.224364856473,
	0.224366143774,0.224366942570,0.224367285305,0.224367202157,0.224366721199,
	0.224365868551,0.224364668512,0.224363143697,0.224361315148,0.224359202447,
	0.224356823819,0.224354196227,0.224351335459,0.224348256210,0.224344972159,
	0.224341496038,0.224337839700,0.224334014179,0.224330029744,0.224325895957,
	0.224321621717,0.224317215309,0.224312684443,0.224308036300,0.224303277559,
	0.224298414441,0.224293452733,0.224288397822,0.224283254721,0.224278028096,
	0.224272722288,0.224267341335,0.224261888996,0.224256368764,0.224250783893,
	0.224245137404,0.224239432111,0.224233670626,0.224227855381,0.224221988633,
	0.224216072481,0.224210108874,0.224204099625,0.224198046413,0.224191950801,
	0.224185814236,0.224179638062,0.224173423525,0.224167171780,0.224160883898,
	0.224154560868,0.224148203609,0.224141812968,0.224135389731,0.224128934621,
	0.224122448307,0.224115931406,0.224109384486,0.224102808069,0.224096202637,
	0.224089568630,0.224082906454,0.224076216478,0.224069499040,0.224062754449,
	0.224055982985,0.224049184902,0.224042360431,0.224035509780,0.224028633133,
	0.224021730658,0.224014802502,0.224007848797,0.224000869655,0.223993865178,
	0.223986835449,0.223979780541,0.223972700513,0.223965595413,0.223958465278,
	0.223951310136,0.223944130004,0.223936924889,0.223929694793,0.223922439707,
	0.223915159617,0.223907854501,0.223900524329,0.223893169068,0.223885788676,
	0.223878383109,0.223870952315,0.223863496239,0.223856014819,0.223848507993,
	0.223840975690,0.223833417839,0.223825834364,0.223818225185,0.223810590219,
	0.223802929380,0.223795242580,0.223787529727,0.223779790727,0.223772025482,
	0.223764233894,0.223756415860,0.223748571277,0.223740700039,0.223732802038,
	0.223724877163,0.223716925303,0.223708946344,0.223700940169,0.223692906663,
	0.223684845704,0.223676757174,0.223668640949,0.223660496906,0.223652324920,
	0.223644124862,0.223635896606,0.223627640022,0.223619354978,0.223611041342,
	0.223602698981,0.223594327759,0.223585927540,0.223577498185,0.223569039557,
	0.223560551515,0.223552033918,0.223543486622,0.223534909485,0.223526302360,
	0.223517665102,0.223508997562,0.223500299593,0.223491571044,0.223482811764,
	0.223474021601,0.223465200400,0.223456348009,0.223447464270,0.223438549026,
	0.223429602119,0.223420623390,0.223411612678,0.223402569821,0.223393494656,
	0.223384387018,0.223375246742,0.223366073662,0.223356867609,0.223347628414,
	0.223338355907,0.223329049916,0.223319710268,0.223310336789,0.223300929304,
	0.223291487635,0.223282011605,0.223272501035,0.223262955744,0.223253375550,
	0.223243760270,0.223234109720,0.223224423714,0.223214702064,0.223204944583,
	0.223195151080,0.223185321365,0.223175455244,0.223165552524,0.223155613009,
	0.223145636503,0.223135622808,0.223125571723,0.223115483049,0.223105356582,
	0.223095192120,0.223084989455,0.223074748382,0.223064468692,0.223054150176,
	0.223043792622,0.223033395817,0.223022959546,0.223012483595,0.223001967745,
	0.222991411777,0.222980815471,0.222970178604,0.222959500952,0.222948782290,
	0.222938022392,0.222927221027,0.222916377966,0.222905492976,0.222894565823,
	0.222883596273,0.222872584088,0.222861529028,0.222850430854,0.222839289322,
	0.222828104188,0.222816875206,0.222805602129,0.222794284707,0.222782922688,
	0.222771515818,0.222760063844,0.222748566506,0.222737023547,0.222725434706,
	0.222713799719,0.222702118322,0.222690390247,0.222678615227,0.222666792991,
	0.222654923266,0.222643005776,0.222631040246,0.222619026395,0.222606963945,
	0.222594852610,0.222582692106,0.222570482147,0.222558222441,0.222545912698,
	0.222533552624,0.222521141923,0.222508680297,0.222496167444,0.222483603063,
	0.222470986849,0.222458318493,0.222445597686,0.222432824117,0.222419997472,
	0.222407117432,0.222394183680,0.222381195893,0.222368153748,0.222355056918,
	0.222341905075,0.222328697887,0.222315435019,0.222302116137,0.222288740899,
	0.222275308966,0.222261819992,0.222248273631,0.222234669533,0.222221007346,
	0.222207286715,0.222193507283,0.222179668688,0.222165770569,0.222151812558,
	0.222137794288,0.222123715387,0.222109575479,0.222095374189,0.222081111135,
	0.222066785934,0.222052398201,0.222037947545,0.222023433576,0.222008855897,
	0.221994214110,0.221979507815,0.221964736605,0.221949900075,0.221934997813,
	0.221920029405,0.221904994433,0.221889892478,0.221874723115,0.221859485918,
	0.221844180455,0.221828806294,0.221813362997,0.221797850123,0.221782267228,
	0.221766613865,0.221750889583,0.221735093926,0.221719226438,0.221703286655,
	0.221687274113,0.221671188342,0.221655028870,0.221638795220,0.221622486912,
	0.221606103461,0.221589644380,0.221573109177,0.221556497357,0.221539808419,
	0.221523041860,0.221506197173,0.221489273846,0.221472271363,0.221455189204,
	0.221438026847,0.221420783762,0.221403459417,0.221386053277,0.221368564800,
	0.221350993441,0.221333338650,0.221315599875,0.221297776556,0.221279868132,
	0.221261874034,0.221243793692,0.221225626528,0.221207371963,0.221189029410,
	0.221170598280,0.221152077977,0.221133467902,0.221114767450,0.221095976012,
	0.221077092973,0.221058117715,0.221039049613,0.221019888038,0.221000632356,
	0.220981281928,0.220961836108,0.220942294249,0.220922655693,0.220902919783,
	0.220883085851,0.220863153228,0.220843121236,0.220822989195,0.220802756418,
	0.220782422210,0.220761985876,0.220741446709,0.220720804002,0.220700057039,
	0.220679205098,0.220658247452,0.220637183370,0.220616012113,0.220594732935,
	0.220573345087,0.220551847811,0.220530240346,0.220508521921,0.220486691763,
	0.220464749089,0.220442693113,0.220420523039,0.220398238068,0.220375837394,
	0.220353320202,0.220330685672,0.220307932979,0.220285061289,0.220262069762,
	0.220238957551,0.220215723804,0.220192367660,0.220168888251,0.220145284704,
	0.220121556137,0.220097701661,0.220073720383,0.220049611398,0.220025373796,
	0.220001006662,0.219976509070,0.219951880088,0.219927118777,0.219902224190,
	0.219877195372,0.219852031361,0.219826731187,0.219801293873,0.219775718434,
	0.219750003875,0.219724149196,0.219698153388,0.219672015433,0.219645734306,
	0.219619308973,0.219592738394,0.219566021518,0.219539157286,0.219512144633,
	0.219484982482,0.219457669751,0.219430205348,0.219402588171,0.219374817110,
	0.219346891049,0.219318808860,0.219290569407,0.219262171545,0.219233614121,
	0.219204895972,0.219176015927,0.219146972803,0.219117765411,0.219088392552,
	0.219058853017,0.219029145588,0.218999269036,0.218969222126,0.218939003610,
	0.218908612232,0.218878046727,0.218847305818,0.218816388221,0.218785292639,
	0.218754017769,0.218722562294,0.218690924889,0.218659104220,0.218627098941,
	0.218594907696,0.218562529121,0.218529961838,0.218497204461,0.218464255594,
	0.218431113829,0.218397777749,0.218364245925,0.218330516919,0.218296589281,
	0.218262461550,0.218228132257,0.218193599917,0.218158863040,0.218123920122,
	0.218088769647,0.218053410091,0.218017839917,0.217982057576,0.217946061511,
	0.217909850151,0.217873421915,0.217836775211,0.217799908434,0.217762819969,
	0.217725508191,0.217687971460,0.217650208128,0.217612216533,0.217573995003,
	0.217535541854,0.217496855390,0.217457933904,0.217418775677,0.217379378978,
	0.217339742066,0.217299863185,0.217259740571,0.217219372444,0.217178757017,
	0.217137892487,0.217096777041,0.217055408855,0.217013786092,0.216971906902,
	0.216929769425,0.216887371788,0.216844712107,0.216801788485,0.216758599014,
	0.216715141774,0.216671414831,0.216627416243,0.216583144052,0.216538596291,
	0.216493770979,0.216448666125,0.216403279725,0.216357609763,0.216311654212,
	0.216265411032,0.216218878171,0.216172053568,0.216124935146,0.216077520820,
	0.216029808492,0.215981796051,0.215933481375,0.215884862333,0.215835936778,
	0.215786702556,0.215737157498,0.215687299425,0.215637126147,0.215586635462,
	0.215535825158,0.215484693010,0.215433236784,0.215381454233,0.215329343100,
	0.215276901118,0.215224126007,0.215171015479,0.215117567234,0.215063778961,
	0.215009648339,0.214955173037,0.214900350714,0.214845179019,0.214789655590,
	0.214733778055,0.214677544034,0.214620951136,0.214563996961,0.214506679100,
	0.214448995133,0.214390942633,0.214332519164,0.214273722279,0.214214549524,
	0.214154998438,0.214095066548,0.214034751376,0.213974050434,0.213912961228,
	0.213851481255,0.213789608005,0.213727338960,0.213664671597,0.213601603384,
	0.213538131782,0.213474254248,0.213409968231,0.213345271175,0.213280160515,
	0.213214633685,0.213148688111,0.213082321214,0.213015530410,0.212948313111,
	0.212880666724,0.212812588653,0.212744076296,0.212675127049,0.212605738304,
	0.212535907450,0.212465631872,0.212394908955,0.212323736080,0.212252110625,
	0.212180029968,0.212107491485,0.212034492551,0.211961030539,0.211887102824,
	0.211812706777,0.211737839773,0.211662499185,0.211586682387,0.211510386755,
	0.211433609665,0.211356348497,0.211278600629,0.211200363446,0.211121634333,
	0.211042410679,0.210962689875,0.210882469318,0.210801746407,0.210720518546,
	0.210638783146,0.210556537620,0.210473779389,0.210390505878,0.210306714520,
	0.210222402753,0.210137568024,0.210052207786,0.209966319500,0.209879900635,
	0.209792948669,0.209705461090,0.209617435393,0.209528869084,0.209439759679,
	0.209350104704,0.209259901698,0.209169148208,0.209077841794,0.208985980029,
	0.208893560498,0.208800580797,0.208707038538,0.208612931344,0.208518256854,
	0.208423012719,0.208327196608,0.208230806202,0.208133839199,0.208036293312,
	0.207938166272,0.207839455824,0.207740159731,0.207640275775,0.207539801753,
	0.207438735482,0.207337074797,0.207234817550,0.207131961615,0.207028504883,
	0.206924445266,0.206819780696,0.206714509125,0.206608628526,0.206502136894,
	0.206395032244,0.206287312613,0.206178976061,0.206070020669,0.205960444029,
	0.205850245295,0.205739422103,0.205627972626,0.205515895062,0.205403187633,
	0.205289848584,0.205175876184,0.205061268730,0.204946024539,0.204830141958,
	0.204713619357,0.204596455130,0.204478647699,0.204360195512,0.204241097042,
	0.204121350789,0.204000955277,0.203879909061,0.203758210719,0.203635858857,
	0.203512852107,0.203389189131,0.203264868614,0.203139889272,0.203014249844,
	0.202887949100,0.202760985836,0.202633358876,0.202505067070,0.202376109296,
	0.202246484459,0.202116191494,0.201985229360,0.201853597046,0.201721293565,
	0.201588317961,0.201454669303,0.201320346687,0.201185349236,0.201049676102,
	0.200913326462,0.200776299518,0.200638594502,0.200500210669,0.200361147302,
	0.200221403710,0.200080979227,0.199939873212,0.199798085052,0.199655614155,
	0.199512459958,0.199368621918,0.199224099521,0.199078892274,0.198932999708,
	0.198786421676,0.198639157156,0.198491206050,0.198342567981,0.198193242594,
	0.198043229555,0.197892528551,0.197741139292,0.197589061505,0.197436294940,
	0.197282839364,0.197128694565,0.196973860348,0.196818336538,0.196662122975,
	0.196505219519,0.196347626045,0.196189342444,0.196030368622,0.195870704503,
	0.195710350022,0.195549305128,0.195387569787,0.195225143974,0.195062027676,
	0.194898220895,0.194733723641,0.194568535934,0.194402657805,0.194236089293,
	0.194068830447,0.193900881322,0.193732241979,0.193562912488,0.193392892923,
	0.193222183363,0.193050783890,0.192878694591,0.192705915556,0.192532446876,
	0.192358288644,0.192183440951,0.192007903891,0.191831677555,0.191654762033,
	0.191477157412,0.191298863775,0.191119881202,0.190940209767,0.190759849539,
	0.190578800579,0.190397062943,0.190214636677,0.190031521817,0.189847718391,
	0.189663226416,0.189478045896,0.189292176824,0.189105619179,0.188918372927,
	0.188730438016,0.188541814383,0.188352501944,0.188162500598,0.187971810229,
	0.187780430698,0.187588361847,0.187395603497,0.187202155448,0.187008017476,
	0.186813189334,0.186617670750,0.186421461428,0.186224561043,0.186026969245,
	0.185828685657,0.185629709870,0.185430041448,0.185229679923,0.185028624796,
	0.184826875536,0.184624431578,0.184421292324,0.184217457141,0.184012925358,
	0.183807696271,0.183601769137,0.183395143174,0.183187817562,0.182979791441,
	0.182771063909,0.182561634026,0.182351500805,0.182140663220,0.181929120198,
	0.181716870625,0.181503913337,0.181290247128,0.181075870743,0.180860782881,
	0.180644982189,0.180428467270,0.180211236674,0.179993288901,0.179774622401,
	0.179555235572,0.179335126758,0.179114294252,0.178892736294,0.178670451067,
	0.178447436702,0.178223691273,0.177999212801,0.177773999246,0.177548048516,
	0.177321358459,0.177093926866,0.176865751471,0.176636829949,0.176407159916,
	0.176176738928,0.175945564484,0.175713634022,0.175480944919,0.175247494495,
	0.175013280007,0.174778298653,0.174542547571,0.174306023838,0.174068724469,
	0.173830646422,0.173591786592,0.173352141816,0.173111708867,0.172870484463,
	0.172628465260,0.172385647855,0.172142028786,0.171897604533,0.171652371519,
	0.171406326107,0.171159464605,0.170911783266,0.170663278286,0.170413945805,
	0.170163781913,0.169912782645,0.169660943983,0.169408261861,0.169154732162,
	0.168900350720,0.168645113323,0.168389015714,0.168132053589,0.167874222606,
	0.167615518376,0.167355936477,0.167095472445,0.166834121783,0.166571879959,
	0.166308742410,0.166044704546,0.165779761747,0.165513909371,0.165247142752,
	0.164979457206,0.164710848033,0.164441310518,0.164170839936,0.163899431554,
	0.163627080636,0.163353782442,0.163079532237,0.162804325290,0.162528156881,
	0.162251022300,0.161972916859,0.161693835887,0.161413774739,0.161132728800,
	0.160850693489,0.160567664263,0.160283636621,0.159998606111,0.159712568332,
	0.159425518940,0.159137453655,0.158848368262,0.158558258621,0.158267120669,
	0.157974950425,0.157681744000,0.157387497597,0.157092207521,0.156795870182,
	0.156498482102,0.156200039921,0.155900540404,0.155599980446,0.155298357076,
	0.154995667468,0.154691908944,0.154387078979,0.154081175212,0.153774195447,
	0.153466137663,0.153157000020,0.152846780862,0.152535478728,0.152223092354,
	0.151909620684,0.151595062871,0.151279418285,0.150962686522,0.150644867407,
	0.150325960998,0.150005967598,0.149684887754,0.149362722267,0.149039472196,
	0.148715138861,0.148389723855,0.148063229039,0.147735656555,0.147407008828,
	0.147077288568,0.146746498779,0.146414642757,0.146081724100,0.145747746705,
	0.145412714778,0.145076632832,0.144739505690,0.144401338490,0.144062136686,
	0.143721906050,0.143380652671,0.143038382960,0.142695103648,0.142350821791,
	0.142005544763,0.141659280262,0.141312036308,0.140963821242,0.140614643723,
	0.140264512731,0.139913437562,0.139561427827,0.139208493447,0.138854644658,
	0.138499891997,0.138144246308,0.137787718734,0.137430320713,0.137072063975,
	0.136712960538,0.136353022700,0.135992263039,0.135630694401,0.135268329901,
	0.134905182913,0.134541267063,0.134176596228,0.133811184524,0.133445046300,
	0.133078196135,0.132710648824,0.132342419377,0.131973523010,0.131603975133,
	0.131233791348,0.130862987438,0.130491579357,0.130119583228,0.129747015330,
	0.129373892088,0.129000230072,0.128626045979,0.128251356635,0.127876178976,
	0.127500530048,0.127124426995,0.126747887050,0.126370927527,0.125993565814,
	0.125615819364,0.125237705686,0.124859242338,0.124480446917,0.124101337053,
	0.123721930401,0.123342244633,0.122962297427,0.122582106467,0.122201689426,
	0.121821063967,0.121440247732,0.121059258333,0.120678113352,0.120296830325,
	0.119915426744,0.119533920045,0.119152327604,0.118770666732,0.118388954666,
	0.118007208566,0.117625445508,0.117243682481,0.116861936377,0.116480223991,
	0.116098562014,0.115716967028,0.115335455503,0.114954043791,0.114572748122,
	0.114191584603,0.113810569209,0.113429717785,0.113049046038,0.112668569536,
	0.112288303706,0.111908263829,0.111528465037,0.111148922311,0.110769650480,
	0.110390664217,0.110011978039,0.109633606299,0.109255563194,0.108877862753,
	0.108500518843,0.108123545163,0.107746955246,0.107370762455,0.106994979984,
	0.106619620855,0.106244697920,0.105870223855,0.105496211168,0.105122672190,
	0.104749619078,0.104377063817,0.104005018216,0.103633493908,0.103262502355,
	0.102892054841,0.102522162477,0.102152836200,0.101784086772,0.101415924783,
	0.101048360649,0.100681404612,0.100315066744,0.099949356944,0.099584284943,
	0.099219860299,0.098856092401,0.098492990471,0.098130563564,0.097768820566,
	0.097407770200,0.097047421024,0.096687781426,0.096328859649,0.095970663758,
	0.095613201664,0.095256481119,0.094900509717,0.094545294897,0.094190843943,
	0.093837163982,0.093484261995,0.093132144805,0.092780819091,0.092430291382,
	0.092080568058,0.091731655357,0.091383559372,0.091036286052,0.090689841208,
	0.090344230509,0.089999459487,0.089655533538,0.089312457921,0.088970237764,
	0.088628878061,0.088288383676,0.087948759345,0.087610009676,0.087272139150,
	0.086935152125,0.086599052835,0.086263845392,0.085929533790,0.085596121904,
	0.085263613490,0.084932012191,0.084601321536,0.084271544939,0.083942685705,
	0.083614747031,0.083287732002,0.082961643599,0.082636484698,0.082312258071,
	0.081988966387,0.081666612214,0.081345198023,0.081024726183,0.080705198970,
	0.080386618564,0.080068987049,0.079752306419,0.079436578576,0.079121805332,
	0.078807988412,0.078495129451,0.078183230001,0.077872291528,0.077562315416,
	0.077253302966,0.076945255398,0.076638173855,0.076332059399,0.076026913017,
	0.075722735619,0.075419528041,0.075117291047,0.074816025327,0.074515731500,
	0.074216410117,0.073918061660,0.073620686542,0.073324285110,0.073028857647,
	0.072734404371,0.072440925437,0.072148420938,0.071856890906,0.071566335312,
	0.071276754071,0.070988147037,0.070700514009,0.070413854729,0.070128168886,
	0.069843456113,0.069559715991,0.069276948049,0.068995151765,0.068714326567,
	0.068434471833,0.068155586893,0.067877671031,0.067600723483,0.067324743439,
	0.067049730046,0.066775682405,0.066502599575,0.066230480573,0.065959324374,
	0.065689129911,0.065419896081,0.065151621736,0.064884305696,0.064617946739,
	0.064352543608,0.064088095009,0.063824599613,0.063562056057,0.063300462944,
	0.063039818842,0.062780122288,0.062521371788,0.062263565815,0.062006702811,
	0.061750781191,0.061495799338,0.061241755607,0.060988648327,0.060736475795,
	0.060485236287,0.060234928049,0.059985549302,0.059737098242,0.059489573042,
	0.059242971850,0.058997292789,0.058752533963,0.058508693450,0.058265769308,
	0.058023759575,0.057782662266,0.057542475377,0.057303196884,0.057064824743,
	0.056827356894,0.056590791256,0.056355125731,0.056120358204,0.055886486543,
	0.055653508599,0.055421422208,0.055190225191,0.054959915351,0.054730490479,
	0.054501948351,0.054274286729,0.054047503361,0.053821595982,0.053596562317,
	0.053372400074,0.053149106952,0.052926680637,0.052705118807,0.052484419124,
	0.052264579244,0.052045596810,0.051827469456,0.051610194808,0.051393770480,
	0.051178194079,0.050963463204,0.050749575444,0.050536528380,0.050324319588,
	0.050112946635,0.049902407079,0.049692698475,0.049483818370,0.049275764303,
	0.049068533810,0.048862124419,0.048656533654,0.048451759034,0.048247798073,
	0.048044648278,0.047842307156,0.047640772206,0.047440040925,0.047240110807,
	0.047040979339,0.046842644010,0.046645102302,0.046448351696,0.046252389669,
	0.046057213698,0.045862821256,0.045669209814,0.045476376842,0.045284319809,
	0.045093036181,0.044902523424,0.044712779003,0.044523800381,0.044335585023,
	0.044148130390,0.043961433946,0.043775493152,0.043590305472,0.043405868367,
	0.043222179301,0.043039235738,0.042857035141,0.042675574976,0.042494852709,
	0.042314865807,0.042135611738,0.041957087972,0.041779291980,0.041602221235,
	0.041425873213,0.041250245389,0.041075335242,0.040901140253,0.040727657906,
	0.040554885686,0.040382821081,0.040211461582,0.040040804682,0.039870847877,
	0.039701588667,0.039533024554,0.039365153044,0.039197971645,0.039031477870,
	0.038865669233,0.038700543255,0.038536097458,0.038372329368,0.038209236516,
	0.038046816436,0.037885066666,0.037723984749,0.037563568230,0.037403814661,
	0.037244721597,0.037086286596,0.036928507224,0.036771381047,0.036614905640,
	0.036459078579,0.036303897447,0.036149359831,0.035995463323,0.035842205521,
	0.035689584025,0.035537596443,0.035386240387,0.035235513474,0.035085413326,
	0.034935937572,0.034787083843,0.034638849780,0.034491233024,0.034344231226,
	0.034197842040,0.034052063127,0.033906892152,0.033762326788,0.033618364710,
	0.033475003603,0.033332241154,0.033190075059,0.033048503018,0.032907522737,
	0.032767131928,0.032627328310,0.032488109606,0.032349473546,0.032211417867,
	0.032073940312,0.031937038627,0.031800710568,0.031664953896,0.031529766377,
	0.031395145783,0.031261089896,0.031127596499,0.030994663386,0.030862288353,
	0.030730469205,0.030599203754,0.030468489815,0.030338325214,0.030208707779,
	0.030079635347,0.029951105761,0.029823116870,0.029695666530,0.029568752603,
	0.029442372957,0.029316525468,0.029191208017,0.029066418494,0.028942154791,
	0.028818414812,0.028695196463,0.028572497659,0.028450316322,0.028328650378,
	0.028207497762,0.028086856416,0.027966724285,0.027847099325,0.027727979496,
	0.027609362765,0.027491247106,0.027373630500,0.027256510933,0.027139886401,
	0.027023754903,0.026908114445,0.026792963043,0.026678298717,0.026564119492,
	0.026450423404,0.026337208492,0.026224472803,0.026112214391,0.026000431316,
	0.025889121644,0.025778283451,0.025667914814,0.025558013822,0.025448578568,
	0.025339607151,0.025231097678,0.025123048263,0.025015457024,0.024908322089,
	0.024801641591,0.024695413669,0.024589636468,0.024484308143,0.024379426853,
	0.024274990762,0.024170998044,0.024067446877,0.023964335447,0.023861661946,
	0.023759424573,0.023657621532,0.023556251035,0.023455311300,0.023354800552,
	0.023254717021,0.023155058946,0.023055824569,0.022957012141,0.022858619919,
	0.022760646167,0.022663089153,0.022565947153,0.022469218451,0.022372901335,
	0.022276994099,0.022181495046,0.022086402482,0.021991714723,0.021897430088,
	0.021803546905,0.021710063506,0.021616978230,0.021524289424,0.021431995438,
	0.021340094630,0.021248585366,0.021157466015,0.021066734955,0.020976390566,
	0.020886431240,0.020796855370,0.020707661359,0.020618847612,0.020530412544,
	0.020442354575,0.020354672129,0.020267363639,0.020180427542,0.020093862282,
	0.020007666308,0.019921838077,0.019836376050,0.019751278694,0.019666544484,
	0.019582171899,0.019498159424,0.019414505550,0.019331208776,0.019248267603,
	0.019165680542,0.019083446106,0.019001562817,0.018920029201,0.018838843790,
	0.018758005122,0.018677511741,0.018597362196,0.018517555043,0.018438088842,
	0.018358962160,0.018280173569,0.018201721648,0.018123604979,0.018045822152,
	0.017968371762,0.017891252408,0.017814462698,0.017738001242,0.017661866658,
	0.017586057568,0.017510572599,0.017435410386,0.017360569568,0.017286048789,
	0.017211846698,0.017137961951,0.017064393209,0.016991139138,0.016918198409,
	0.016845569699,0.016773251689,0.016701243068,0.016629542529,0.016558148768,
	0.016487060489,0.016416276401,0.016345795217,0.016275615656,0.016205736443,
	0.016136156306,0.016066873980,0.015997888205,0.015929197724,0.015860801288,
	0.015792697652,0.015724885575,0.015657363823,0.015590131165,0.015523186376,
	0.015456528237,0.015390155532,0.015324067051,0.015258261589,0.015192737946,
	0.015127494927,0.015062531341,0.014997846002,0.014933437730,0.014869305350,
	0.014805447689,0.014741863582,0.014678551868,0.014615511390,0.014552740995,
	0.014490239537,0.014428005874,0.014366038867,0.014304337383,0.014242900295,
	0.014181726478,0.014120814813,0.014060164187,0.013999773488,0.013939641612,
	0.013879767458,0.013820149929,0.013760787935,0.013701680388,0.013642826205,
	0.013584224309,0.013525873625,0.013467773085,0.013409921623,0.013352318180,
	0.013294961698,0.013237851128,0.013180985421,0.013124363535,0.013067984430,
	0.013011847074,0.012955950436,0.012900293490,0.012844875215,0.012789694594,
	0.012734750614,0.012680042266,0.012625568547,0.012571328455,0.012517320994,
	0.012463545174,0.012410000006,0.012356684505,0.012303597694,0.012250738596,
	0.012198106240,0.012145699658,0.012093517888,0.012041559970,0.011989824949,
	0.011938311874,0.011887019797,0.011835947775,0.011785094869,0.011734460143,
	0.011684042667,0.011633841512,0.011583855755,0.011534084476,0.011484526759,
	0.011435181692,0.011386048366,0.011337125878,0.011288413327,0.011239909816,
	0.011191614451,0.011143526344,0.011095644608,0.011047968363,0.011000496729,
	0.010953228833,0.010906163803,0.010859300773,0.010812638879,0.010766177261,
	0.010719915064,0.010673851433,0.010627985521,0.010582316482,0.010536843475,
	0.010491565660,0.010446482204,0.010401592274,0.010356895043,0.010312389688,
	0.010268075387,0.010223951322,0.010180016681,0.010136270653,0.010092712430,
	0.010049341209,0.010006156191,0.009963156577,0.009920341576,0.009877710396,
	0.009835262252,0.009792996359,0.009750911937,0.009709008211,0.009667284406,
	0.009625739752,0.009584373482,0.009543184833,0.009502173044,0.009461337358,
	0.009420677021,0.009380191282,0.009339879393,0.009299740611,0.009259774192,
	0.009219979400,0.009180355500,0.009140901759,0.009101617449,0.009062501843,
	0.009023554220,0.008984773860,0.008946160046,0.008907712064,0.008869429205,
	0.008831310760,0.008793356026,0.008755564301,0.008717934886,0.008680467087,
	0.008643160209,0.008606013565,0.008569026467,0.008532198232,0.008495528178,
	0.008459015627,0.008422659906,0.008386460341,0.008350416263,0.008314527006,
	0.008278791906,0.008243210302,0.008207781536,0.008172504954,0.008137379902,
	0.008102405731,0.008067581794,0.008032907447,0.007998382049,0.007964004961,
	0.007929775547,0.007895693174,0.007861757212,0.007827967031,0.007794322009,
	0.007760821521,0.007727464948,0.007694251673,0.007661181082,0.007628252562,
	0.007595465504,0.007562819301,0.007530313350,0.007497947048,0.007465719797,
	0.007433631000,0.007401680063,0.007369866395,0.007338189408,0.007306648514,
	0.007275243130,0.007243972674,0.007212836568,0.007181834236,0.007150965103,
	0.007120228598,0.007089624151,0.007059151197,0.007028809171,0.006998597512,
	0.006968515659,0.006938563056,0.006908739149,0.006879043384,0.006849475213,
	0.006820034088,0.006790719463,0.006761530795,0.006732467545,0.006703529173,
	0.006674715145,0.006646024925,0.006617457984,0.006589013791,0.006560691820,
	0.006532491547,0.006504412449,0.006476454005,0.006448615699,0.006420897014,
	0.006393297437,0.006365816456,0.006338453563,0.006311208251,0.006284080015,
	0.006257068352,0.006230172762,0.006203392747,0.006176727810,0.006150177458,
	0.006123741198,0.006097418541,0.006071209000,0.006045112087,0.006019127321,
	0.005993254218,0.005967492301,0.005941841092,0.005916300114,0.005890868896,
	0.005865546965,0.005840333853,0.005815229092,0.005790232217,0.005765342765,
	0.005740560274,0.005715884286,0.005691314342,0.005666849988,0.005642490770,
	0.005618236237,0.005594085938,0.005570039428,0.005546096259,0.005522255988,
	0.005498518173,0.005474882374,0.005451348153,0.005427915074,0.005404582703,
	0.005381350606,0.005358218354,0.005335185517,0.005312251669,0.005289416384,
	0.005266679239,0.005244039813,0.005221497685,0.005199052439,0.005176703657,
	0.005154450926,0.005132293833,0.005110231967,0.005088264919,0.005066392282,
	0.005044613651,0.005022928621,0.005001336791,0.004979837760,0.004958431130,
	0.004937116503,0.004915893485,0.004894761682,0.004873720703,0.004852770156,
	0.004831909654,0.004811138810,0.004790457238,0.004769864556,0.004749360381,
	0.004728944333,0.004708616034,0.004688375106,0.004668221175,0.004648153866,
	0.004628172807,0.004608277628,0.004588467961,0.004568743437,0.004549103690,
	0.004529548358,0.004510077076,0.004490689484,0.004471385222,0.004452163933,
	0.004433025259,0.004413968847,0.004394994341,0.004376101392,0.004357289647,
	0.004338558759,0.004319908380,0.004301338164,0.004282847766,0.004264436844,
	0.004246105056,0.004227852062,0.004209677524,0.004191581105,0.004173562468,
	0.004155621280,0.004137757208,0.004119969921,0.004102259088,0.004084624382,
	0.004067065474,0.004049582040,0.004032173755,0.004014840297,0.003997581342,
	0.003980396573,0.003963285669,0.003946248314,0.003929284191,0.003912392985,
	0.003895574384,0.003878828076,0.003862153749,0.003845551094,0.003829019804,
	0.003812559572,0.003796170092,0.003779851061,0.003763602175,0.003747423134,
	0.003731313637,0.003715273385,0.003699302081,0.003683399429,0.003667565132,
	0.003651798899,0.003636100436,0.003620469452,0.003604905657,0.003589408762,
	0.003573978480,0.003558614524,0.003543316611,0.003528084454,0.003512917773,
	0.003497816286,0.003482779713,0.003467807774,0.003452900192,0.003438056690,
	0.003423276993,0.003408560827,0.003393907918,0.003379317996,0.003364790789,
	0.003350326027,0.003335923442,0.003321582768,0.003307303738,0.003293086087,
	0.003278929551,0.003264833867,0.003250798775,0.003236824014,0.003222909324,
	0.003209054448,0.003195259127,0.003181523107,0.003167846133,0.003154227950,
	0.003140668306,0.003127166949,0.003113723629,0.003100338097,0.003087010104,
	0.003073739403,0.003060525747,0.003047368892,0.003034268593,0.003021224608,
	0.003008236693,0.002995304609,0.002982428115,0.002969606973,0.002956840944,
	0.002944129791,0.002931473280,0.002918871174,0.002906323240,0.002893829246,
	0.002881388959,0.002869002148,0.002856668585,0.002844388039,0.002832160283,
	0.002819985090,0.002807862235,0.002795791492,0.002783772637,0.002771805447,
	0.002759889701,0.002748025176,0.002736211654,0.002724448914,0.002712736739,
	0.002701074911,0.002689463214,0.002677901432,0.002666389350,0.002654926756,
	0.002643513437,0.002632149179,0.002620833774,0.002609567011,0.002598348680,
	0.002587178573,0.002576056484,0.002564982206,0.002553955533,0.002542976261,
	0.002532044186,0.002521159105,0.002510320817,0.002499529119,0.002488783812,
	0.002478084697,0.002467431574,0.002456824247,0.002446262518,0.002435746191,
	0.002425275071,0.002414848964,0.002404467677,0.002394131016,0.002383838790,
	0.002373590809,0.002363386881,0.002353226817,0.002343110429,0.002333037529,
	0.002323007931,0.002313021448,0.002303077894,0.002293177085,0.002283318838,
	0.002273502970,0.002263729298,0.002253997641,0.002244307818,0.002234659650,
	0.002225052958,0.002215487563,0.002205963287,0.002196479955,0.002187037389,
	0.002177635415,0.002168273859,0.002158952546,0.002149671304,0.002140429960,
	0.002131228343,0.002122066282,0.002112943607,0.002103860149,0.002094815739,
	0.002085810210,0.002076843393,0.002067915124,0.002059025235,0.002050173563,
	0.002041359942,0.002032584210,0.002023846203,0.002015145760,0.002006482718,
	0.001997856918,0.001989268198,0.001980716400,0.001972201364,0.001963722934,
	0.001955280951,0.001946875259,0.001938505701,0.001930172123,0.001921874370,
	0.001913612288,0.001905385723,0.001897194523,0.001889038536,0.001880917611,
	0.001872831596,0.001864780341,0.001856763698
	}
};

double always_inline w20_2a_negclip(double x) {
    double f = fabs(x);
    f = f * w20_2a_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = w20_2a_neg_table.data[0];
    } else if (i >= w20_2a_neg_table.size-1) {
        f = w20_2a_neg_table.data[w20_2a_neg_table.size-1];
    } else {
    f -= i;
    f = w20_2a_neg_table.data[i]*(1-f) + w20_2a_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

