/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.xmlcml.cml.tools;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

public class TestString {

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		byte[] parsable = FileUtils.readFileToByteArray(new File("C:\\temp\\encodingissues\\parsable"));
		String parsableS = new String(parsable);
		byte[] unparsable = FileUtils.readFileToByteArray(new File("C:\\temp\\encodingissues\\unparsable"));
		String unparsableS = new String(unparsable);
		int diff = unparsableS.compareTo(parsableS);
		System.out.println(diff+"\n"+unparsableS.substring(0, diff+2)+"\n"+parsableS.substring(0, diff+2));
		System.out.println(diff+"/"+unparsableS.charAt(diff)+"/"+parsableS.charAt(diff));
	}

}
