<?php
$this->load->helper('html');
echo doctype('html5');?>
<html>

<head>
	<title>Kalkun - <?php echo tr('Log in'); ?></title>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<meta name="generator" content="Geany 0.13" />
	<meta name="robots" content="noindex,nofollow" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php echo link_tag($this->config->item('img_path').'icon.ico', 'shortcut icon', 'image/ico');?>
	<?php echo link_tag($this->config->item('css_path').'base.css');?>
	<script language="javascript" src="<?php echo $this->config->item('js_path');?>jquery-3.7.1.min.js"></script>
	<script language="javascript">
		$(document).ready(function() {
			$("#username").trigger('focus');
		});

	</script>
	<style type="text/css">
		@import url("<?php echo $this->config->item('css_path');?>blue.css");

	</style>
</head>

<body>
	<div id="main_container">
		<div class="login_loading_container">&nbsp;
			<?php if ($this->session->flashdata('errorlogin')): ?>
			<span class="loading_area"><?php echo htmlentities($this->session->flashdata('errorlogin'), ENT_QUOTES);?></span>
			<?php endif; ?>
		</div>

		<div id="login_logo"><a href="<?php echo site_url().'?l='.$idiom ?>"><img src="<?php echo $this->config->item('img_path');?>logo.png" alt="Kalkun logo" /></a></div>
		<div style="text-align: center;">
			<?php
				echo form_open('');
				echo form_dropdown('idiom', $language_list, $idiom, 'onchange="this.form.submit()"');
				echo form_hidden('change_language', 'true');
				echo form_close();
			?>
		</div>
		<div id="login_container">
			<?php echo form_open('login');
				echo form_hidden('r_url', $this->input->get('r_url'));
?>
			<table id="login" class="rounded">
				<tr>
					<td><i><?php echo tr('Please enter your username and password'); ?></i></td>
				</tr>
				<tr>
					<td><label><?php echo tr('Username'); ?></label><input type="text" name="username" id="username" style="width:95%" /></td>
				</tr>
				<tr>
					<td><label><?php echo tr('Password'); ?></label><input type="password" name="password" style="width:95%" /></td>
				</tr>
				<tr>
					<td>
						<div style="float: left">
							<input type="checkbox" id="remember_me" name="remember_me" /><label for="remember_me"><?php echo tr('Remember me'); ?></label>
						</div>
						<div style="float: right; padding-right: 3px"><input type="submit" id="submit" value="<?php echo tr('Log in') ?>" /></div>
					</td>
				</tr>
				<tr>
					<td style="text-align: center"><a style="color: #fff" href="<?php echo site_url('login/forgot_password')."?l={$idiom}"; ?>"><?php echo tr('Forgot your password?'); ?></a></td>
				</tr>
			</table>
			<?php echo form_hidden('idiom', $idiom); ?>
			<?php echo form_close();?>
		</div>

	</div>
</body>

</html>
