#!/bin/sh -e

# run with GIT_REVISION set to check out a new tarball

UPSTREAM_REPO=git://github.com/kaniini/libguess.git
TARBALLDIR=${1:-.}
WDIR=debian/orig-source
rm -rf ${WDIR}
mkdir ${WDIR}

set -- $(head -n1 debian/changelog | tr -d '()')

PACKAGE=$1
VERSION=$2
SRC_VERSION=${2%%-*}
if [ -z "$GIT_REVISION" ]
then
    TARBALLNAME=${PACKAGE}_${SRC_VERSION}
    GIT_REVISION=${SRC_VERSION##*.}
fi

rm -rf debian/orig-source
mkdir debian/orig-source

git clone -n ${UPSTREAM_REPO} debian/orig-source/
export GIT_DIR=debian/orig-source/.git
if [ -z "$TARBALLNAME" ]
then
    DATE=$(date +%Y%m%d -d @$(git log ${GIT_REVISION} -1 --pretty=format:%ct))
    TARBALLNAME=${PACKAGE}_${SRC_VERSION%%+*}+git${DATE}.$(echo ${GIT_REVISION}| cut -b 1-8)
fi
git archive -o ${TARBALLDIR}/${TARBALLNAME}.orig.tar --prefix=${TARBALLNAME}/ ${GIT_REVISION}
bzip2 ${TARBALLDIR}/${TARBALLNAME}.orig.tar

rm -rf debian/orig-source

