
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotWhiskerBorderAttributes.h
    \\brief Definition of BoxPlotWhiskerBorder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "BoxPlotWhiskerBorderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


BoxPlotWhiskerBorderWrapper::BoxPlotWhiskerBorderWrapper(): boxplotwhiskerborder_(new BoxPlotWhiskerBorder())

{

	
	
	
} 
BoxPlotWhiskerBorderWrapper::BoxPlotWhiskerBorderWrapper(BoxPlotWhiskerBorder* boxplotwhiskerborder): boxplotwhiskerborder_(boxplotwhiskerborder)
{
	
	
} 

BoxPlotWhiskerBorderWrapper::~BoxPlotWhiskerBorderWrapper()
{
	
}

void BoxPlotWhiskerBorderWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_THICKNESS") ) {
		int thickness_value = request("BOXPLOT_WHISKER_BOX_BORDER_THICKNESS");
		boxplotwhiskerborder_->thickness_ = thickness_value;
		}
	
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_COLOUR") ) {
		string colour_value = request("BOXPLOT_WHISKER_BOX_BORDER_COLOUR");
		boxplotwhiskerborder_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_LINE_STYLE") ) {
		string style_value = request("BOXPLOT_WHISKER_BOX_BORDER_LINE_STYLE");
		boxplotwhiskerborder_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	
}

void BoxPlotWhiskerBorderWrapper::print(ostream& out)  const
{
	out << "BoxPlotWhiskerBorderWrapper[]";
}


    





