
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileEpsShadeAttributes.h
    \brief Definition of EpsShade Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef EpsShadeAttributes_H
#define EpsShadeAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class EpsShadeAttributes 
{
public:
//  --  constructor
    EpsShadeAttributes();
    
//  --  destructor
    virtual ~EpsShadeAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const EpsShadeAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	int line_thickness_;
	unique_ptr<Colour> colour_;
	unique_ptr<Colour> line_colour_;
	LineStyle line_style_;
	 

private:
	friend ostream& operator<<(ostream& s,const EpsShadeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

