/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P1 = [
	-1.4258509801366645672e+11,
	6.6781041261492395835e+09,
	-1.1548696764841276794e+08,
	9.8062904098958257677e+05,
	-4.4615792982775076130e+03,
	1.0650724020080236441e+01,
	-1.0767857011487300348e-02
];

var Q1 = [
	4.1868604460820175290e+12,
	4.2091902282580133541e+10,
	2.0228375140097033958e+08,
	5.9117614494174794095e+05,
	1.0742272239517380498e+03,
	1.0,
	0.0
];

var P2 = [
	-1.7527881995806511112e+16,
	1.6608531731299018674e+15,
	-3.6658018905416665164e+13,
	3.5580665670910619166e+11,
	-1.8113931269860667829e+09,
	5.0793266148011179143e+06,
	-7.5023342220781607561e+03,
	4.6179191852758252278e+00
];

var Q2 = [
	1.7253905888447681194e+18,
	1.7128800897135812012e+16,
	8.4899346165481429307e+13,
	2.7622777286244082666e+11,
	6.4872502899596389593e+08,
	1.1267125065029138050e+06,
	1.3886978985861357615e+03,
	1.0
];

var PC = [
	-4.4357578167941278571e+06,
	-9.9422465050776411957e+06,
	-6.6033732483649391093e+06,
	-1.5235293511811373833e+06,
	-1.0982405543459346727e+05,
	-1.6116166443246101165e+03,
	0.0
];

var QC = [
	-4.4357578167941278568e+06,
	-9.9341243899345856590e+06,
	-6.5853394797230870728e+06,
	-1.5118095066341608816e+06,
	-1.0726385991103820119e+05,
	-1.4550094401904961825e+03,
	1.0
];

var PS = [
	3.3220913409857223519e+04,
	8.5145160675335701966e+04,
	6.6178836581270835179e+04,
	1.8494262873223866797e+04,
	1.7063754290207680021e+03,
	3.5265133846636032186e+01,
	0.0
];

var QS = [
	7.0871281941028743574e+05,
	1.8194580422439972989e+06,
	1.4194606696037208929e+06,
	4.0029443582266975117e+05,
	3.7890229745772202641e+04,
	8.6383677696049909675e+02,
	1.0
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p1q1.js' );
	str = header + compile( P1, Q1 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p2q2.js' );
	str = header + compile( P2, Q2 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_pcqc.js' );
	str = header + compile( PC, QC );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_psqs.js' );
	str = header + compile( PS, QS );
	writeFileSync( fpath, str, opts );
}

main();
