/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.util.TurbineException;

public class IntegerValidator
extends NumberValidator {
    private static String INVALID_NUMBER = "Entry was not a valid integer";
    private int minValue;
    private int maxValue;

    protected void doInit(Map paramMap) {
        String param;
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Integer.parseInt(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Integer.parseInt(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
        int i = 0;
        try {
            i = Integer.parseInt(testValue);
        }
        catch (RuntimeException e) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (i < this.minValue) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (i > this.maxValue) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public IntegerValidator(Map paramMap) throws TurbineException {
        this.init(paramMap);
    }

    public IntegerValidator() {
    }
}

