/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.notification.ris.TimeoutHandler;

public class Lock {
    protected static long mTimeoutIntervalMS = 1800000L;
    protected String mLockedResourceId;
    protected TimeoutHandler mTimeoutHandler;
    protected long mLockCreationTimeMS;

    public Lock(String lockedResourceId, TimeoutHandler timeoutHandler) {
        this.mLockedResourceId = lockedResourceId;
        this.mTimeoutHandler = timeoutHandler;
        this.mLockCreationTimeMS = System.currentTimeMillis();
    }

    public Lock(String lockedResourceId) {
        this(lockedResourceId, null);
    }

    public String getLockedResourceId() {
        return this.mLockedResourceId;
    }

    public boolean hasTimedOut() {
        long currentTimeMS = System.currentTimeMillis();
        boolean ret = false;
        if (currentTimeMS > this.mLockCreationTimeMS + mTimeoutIntervalMS) {
            ret = true;
        }
        return ret;
    }

    public void notifyOwner() {
        if (this.mTimeoutHandler != null) {
            this.mTimeoutHandler.lockTimedOut();
        }
    }
}

