/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class TemplateSecurityCheck {
    private String message = "Sorry, you do not have permission to access this area.";
    private String failScreen = TurbineTemplate.getDefaultScreen();
    private String failTemplate;
    private RunData data = null;

    public boolean hasRole(Role role) throws Exception {
        if (!this.checkLogin()) {
            return false;
        }
        if (this.data.getACL() == null || !this.data.getACL().hasRole(role)) {
            this.data.setScreen(this.getFailScreen());
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            this.data.setMessage(this.getMessage());
            return false;
        }
        return true;
    }

    public boolean hasPermission(Permission permission) throws Exception {
        if (this.data.getACL() == null || !this.data.getACL().hasPermission(permission)) {
            this.data.setScreen(this.getFailScreen());
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            this.data.setMessage(this.getMessage());
            return false;
        }
        return true;
    }

    public boolean checkLogin() throws Exception {
        boolean value = false;
        if (this.data.getUser() != null && !this.data.getUser().hasLoggedIn()) {
            this.data.setMessage(TurbineResources.getString("login.message"));
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            value = false;
        } else {
            value = true;
        }
        return value;
    }

    public void setMessage(String v) {
        this.message = v;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailScreen() {
        return this.failScreen;
    }

    public void setFailScreen(String v) {
        this.failScreen = v;
    }

    public String getFailTemplate() {
        return this.failTemplate;
    }

    public void setFailTemplate(String v) {
        this.failTemplate = v;
    }

    public TemplateSecurityCheck(RunData data, String message) {
        this.data = data;
        this.message = message;
    }

    public TemplateSecurityCheck(RunData data) {
        this.data = data;
    }
}

