#!/bin/bash

# utility shell script to create etc/openvms.zip file.

# move into the grandparent of this file:

pushd $(dirname $0)/../..
if [ -a etc/openvms.zip ]; then 
  echo 'cannot run '$0': perform a rm -r etc/openvms.zip first!';
  exit 2;
fi

set -x

# cleanup
# find \( -name '*~' -o -name corba_interfaces.opt \)  -exec rm -f '{}' ';'

zip -m etc/openvms.zip $(find mk -not -name '*.mk*' -and -type f)
zip -m etc/openvms.zip $(find * \( -iname '*.mms' -o -iname '*.com' -o -iname '*.dcl' -o\
    -iname '*.opt' -o -iname 'tcpSocketVax*' \) )
zip -m etc/openvms.zip $(find bin/scripts/make_etc_openvms.zip.sh)
zip -m etc/openvms.zip $(find src/tool/openvms*)
zip -m etc/openvms.zip $(find src/services -name '*.py')
zip -m etc/openvms.zip $(find src/lib/omniORB/orbcore/corba?*Float.cc)

popd
