//========================================================================
//
// annot_stamp_for_comment.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_FOR_COMMENT_H
#define ANNOT_STAMP_FOR_COMMENT_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"

static const double ANNOT_STAMP_FOR_COMMENT_WIDTH = 170.508179;
static const double ANNOT_STAMP_FOR_COMMENT_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_FOR_COMMENT = "1 0 0 -1 0 26.484741 cm\n"
                                             "q\n"
                                             "1 1 1 rg /a0 gs\n"
                                             "3.406 2.129 m 167.117 2.129 l 167.816 2.129 168.387 2.828 168.387 3.398\n"
                                             " c 168.387 23.09 l 168.387 23.789 167.82 24.359 167.117 24.359 c 3.406 24.359\n"
                                             " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                             " 2.129 3.406 2.129 c h\n"
                                             "3.406 2.129 m f\n"
                                             "0 0.298039 0.431373 rg /a1 gs\n"
                                             "1 1 1 RG 0.265748 w\n"
                                             "0 J\n"
                                             "0 j\n"
                                             "[] 0.0 d\n"
                                             "4 M q 1 0 0 1 0 0 cm\n"
                                             "18.043 7.926 m 18.043 12.691 l 25.922 12.691 l 25.922 15.184 l 18.043 15.18\n"
                                             " l 18.043 20.828 l 14.82 20.828 l 14.82 5.434 l 26.172 5.434 l 26.172 7.926\n"
                                             " l 18.043 7.926 l 39.797 14.906 m 39.797 15.809 39.668 16.637 39.414 17.387\n"
                                             " c 39.168 18.137 38.793 18.785 38.289 19.332 c 37.785 19.871 37.16 20.293\n"
                                             " 36.41 20.598 c 35.66 20.895 34.785 21.047 33.789 21.047 c 32.828 21.047\n"
                                             " 31.98 20.898 31.242 20.598 c 30.508 20.301 29.887 19.879 29.383 19.34 c\n"
                                             " 28.887 18.801 28.512 18.156 28.258 17.406 c 28.004 16.648 27.875 15.816\n"
                                             " 27.875 14.902 c 27.875 14.02 27.996 13.207 28.234 12.465 c 28.48 11.715\n"
                                             " 28.855 11.066 29.348 10.52 c 29.844 9.973 30.465 9.547 31.215 9.242 c 31.965\n"
                                             " 8.938 32.844 8.785 33.848 8.785 c 34.91 8.785 35.816 8.938 36.57 9.242 \n"
                                             "c 37.32 9.547 37.934 9.973 38.406 10.52 c 38.887 11.059 39.238 11.703 39.457\n"
                                             " 12.453 c 39.684 13.195 39.797 14.012 39.797 14.902 c 36.586 14.902 m 36.586\n"
                                             " 13.496 36.355 12.477 35.898 11.844 c 35.441 11.211 34.773 10.895 33.898\n"
                                             " 10.895 c 32.996 10.895 32.305 11.215 31.824 11.855 c 31.344 12.496 31.102\n"
                                             " 13.512 31.102 14.902 c 31.102 15.609 31.164 16.219 31.289 16.727 c 31.422\n"
                                             " 17.238 31.602 17.656 31.836 17.984 c 32.07 18.312 32.348 18.555 32.676 \n"
                                             "18.715 c 33.004 18.867 33.363 18.945 33.758 18.945 c 34.211 18.945 34.609\n"
                                             " 18.867 34.961 18.715 c 35.316 18.555 35.617 18.312 35.855 17.984 c 36.098\n"
                                             " 17.656 36.277 17.238 36.402 16.727 c 36.527 16.215 36.59 15.609 36.59 14.902\n"
                                             " c 42.25 20.824 m 42.25 11.777 l 42.25 11.523 42.246 11.254 42.238 10.969\n"
                                             " c 42.238 10.684 42.23 10.414 42.215 10.16 c 42.207 9.898 42.199 9.664 42.191\n"
                                             " 9.461 c 42.184 9.25 42.172 9.098 42.16 9.004 c 45.09 9.004 l 45.105 9.09\n"
                                             " 45.117 9.246 45.133 9.461 c 45.148 9.672 45.16 9.906 45.176 10.16 c 45.191\n"
                                             " 10.414 45.203 10.672 45.207 10.926 c 45.223 11.172 45.23 11.375 45.23 11.527\n"
                                             " c 45.273 11.527 l 45.426 11.098 45.578 10.715 45.73 10.379 c 45.883 10.035\n"
                                             " 46.062 9.75 46.266 9.516 c 46.477 9.273 46.727 9.094 47.02 8.969 c 47.312\n"
                                             " 8.836 47.672 8.773 48.102 8.773 c 48.285 8.773 48.461 8.793 48.637 8.828\n"
                                             " c 48.82 8.855 48.957 8.895 49.051 8.938 c 49.051 11.504 l 48.855 11.461\n"
                                             " 48.652 11.422 48.449 11.395 c 48.254 11.359 48.016 11.34 47.738 11.34 c\n"
                                             " 46.973 11.34 46.375 11.648 45.945 12.27 c 45.523 12.891 45.312 13.805 45.312\n"
                                             " 15.023 c 45.312 20.824 l 42.242 20.824 l 64.27 18.508 m 64.875 18.508 65.395\n"
                                             " 18.426 65.832 18.258 c 66.277 18.082 66.66 17.855 66.98 17.582 c 67.309\n"
                                             " 17.305 67.578 16.992 67.789 16.641 c 68.008 16.289 68.188 15.938 68.324\n"
                                             " 15.582 c 71.133 16.641 l 70.906 17.195 70.613 17.738 70.246 18.27 c 69.883\n"
                                             " 18.801 69.426 19.27 68.879 19.68 c 68.332 20.086 67.68 20.418 66.922 20.676\n"
                                             " c 66.172 20.922 65.285 21.047 64.266 21.047 c 62.934 21.047 61.777 20.852\n"
                                             " 60.801 20.457 c 59.824 20.055 59.016 19.504 58.375 18.797 c 57.742 18.082\n"
                                             " 57.27 17.238 56.953 16.262 c 56.648 15.285 56.496 14.219 56.496 13.059 \n"
                                             "c 56.496 11.855 56.648 10.77 56.953 9.801 c 57.266 8.832 57.734 8.008 58.363\n"
                                             " 7.332 c 58.988 6.648 59.781 6.121 60.734 5.758 c 61.695 5.387 62.824 5.199\n"
                                             " 64.121 5.199 c 65.125 5.199 66.004 5.305 66.754 5.516 c 67.512 5.727 68.164\n"
                                             " 6.027 68.711 6.41 c 69.266 6.789 69.719 7.242 70.078 7.766 c 70.441 8.281\n"
                                             " 70.727 8.855 70.93 9.48 c 68.09 10.258 l 67.988 9.93 67.832 9.617 67.621\n"
                                             " 9.316 c 67.41 9.012 67.141 8.742 66.812 8.508 c 66.492 8.273 66.113 8.09\n"
                                             " 65.676 7.949 c 65.238 7.805 64.742 7.73 64.191 7.73 c 63.41 7.73 62.742\n"
                                             " 7.859 62.18 8.113 c 61.617 8.359 61.156 8.719 60.793 9.184 c 60.438 9.648\n"
                                             " 60.172 10.211 59.996 10.867 c 59.828 11.516 59.746 12.242 59.746 13.051\n"
                                             " c 59.746 13.852 59.828 14.586 59.996 15.258 c 60.172 15.922 60.441 16.492\n"
                                             " 60.805 16.973 c 61.168 17.453 61.637 17.828 62.203 18.098 c 62.777 18.367\n"
                                             " 63.469 18.504 64.27 18.5 c 84.551 14.895 m 84.551 15.797 84.422 16.625 \n"
                                             "84.168 17.375 c 83.922 18.125 83.547 18.773 83.043 19.32 c 82.539 19.859\n"
                                             " 81.914 20.281 81.164 20.586 c 80.414 20.883 79.539 21.035 78.543 21.035\n"
                                             " c 77.582 21.035 76.734 20.887 75.996 20.586 c 75.262 20.289 74.641 19.867\n"
                                             " 74.137 19.328 c 73.641 18.789 73.266 18.145 73.012 17.395 c 72.758 16.637\n"
                                             " 72.629 15.805 72.629 14.891 c 72.629 14.008 72.75 13.195 72.988 12.453 \n"
                                             "c 73.234 11.703 73.609 11.055 74.102 10.508 c 74.598 9.961 75.219 9.535 \n"
                                             "75.969 9.23 c 76.719 8.926 77.598 8.773 78.602 8.773 c 79.664 8.773 80.57\n"
                                             " 8.926 81.324 9.23 c 82.074 9.535 82.688 9.961 83.16 10.508 c 83.641 11.047\n"
                                             " 83.992 11.691 84.211 12.441 c 84.438 13.184 84.551 14 84.551 14.891 c 81.34\n"
                                             " 14.891 m 81.34 13.484 81.109 12.465 80.652 11.832 c 80.195 11.199 79.527\n"
                                             " 10.883 78.652 10.883 c 77.75 10.883 77.059 11.203 76.578 11.844 c 76.098\n"
                                             " 12.484 75.855 13.5 75.855 14.891 c 75.855 15.598 75.918 16.207 76.043 16.715\n"
                                             " c 76.176 17.227 76.355 17.645 76.59 17.973 c 76.824 18.301 77.102 18.543\n"
                                             " 77.43 18.703 c 77.758 18.855 78.117 18.934 78.512 18.934 c 78.965 18.934\n"
                                             " 79.363 18.855 79.715 18.703 c 80.07 18.543 80.371 18.301 80.609 17.973 \n"
                                             "c 80.852 17.645 81.031 17.227 81.156 16.715 c 81.281 16.203 81.344 15.598\n"
                                             " 81.344 14.891 c 93.965 20.812 m 93.965 14.18 l 93.965 13.723 93.934 13.301\n"
                                             " 93.867 12.922 c 93.809 12.535 93.707 12.207 93.562 11.938 c 93.426 11.66\n"
                                             " 93.238 11.445 93.004 11.293 c 92.777 11.141 92.5 11.062 92.172 11.062 c\n"
                                             " 91.859 11.062 91.574 11.145 91.32 11.312 c 91.066 11.473 90.844 11.707 \n"
                                             "90.652 12.012 c 90.469 12.309 90.328 12.672 90.227 13.094 c 90.125 13.508\n"
                                             " 90.074 13.969 90.074 14.469 c 90.074 20.805 l 87.004 20.805 l 87.004 11.625\n"
                                             " l 87.004 11.371 87 11.109 86.992 10.84 c 86.992 10.57 86.984 10.316 86.969\n"
                                             " 10.074 c 86.961 9.828 86.953 9.609 86.945 9.418 c 86.938 9.223 86.926 9.074\n"
                                             " 86.914 8.98 c 89.844 8.98 l 89.859 9.066 89.871 9.211 89.887 9.406 c 89.902\n"
                                             " 9.594 89.914 9.809 89.93 10.039 c 89.945 10.273 89.957 10.504 89.961 10.738\n"
                                             " c 89.977 10.973 89.984 11.168 89.984 11.328 c 90.027 11.328 l 90.406 10.426\n"
                                             " 90.875 9.77 91.438 9.359 c 92.004 8.953 92.684 8.746 93.469 8.746 c 94.371\n"
                                             " 8.746 95.098 8.969 95.645 9.414 c 96.199 9.852 96.57 10.488 96.758 11.328\n"
                                             " c 96.824 11.328 l 97.035 10.84 97.262 10.434 97.5 10.105 c 97.746 9.777\n"
                                             " 98.016 9.516 98.309 9.32 c 98.605 9.117 98.93 8.969 99.27 8.883 c 99.621\n"
                                             " 8.797 99.996 8.75 100.406 8.75 c 101.055 8.75 101.602 8.867 102.047 9.102\n"
                                             " c 102.5 9.336 102.863 9.656 103.141 10.062 c 103.426 10.469 103.629 10.953\n"
                                             " 103.754 11.504 c 103.887 12.059 103.949 12.656 103.949 13.297 c 103.949\n"
                                             " 20.805 l 100.902 20.805 l 100.902 14.172 l 100.902 13.715 100.871 13.293\n"
                                             " 100.805 12.914 c 100.746 12.527 100.645 12.199 100.5 11.93 c 100.363 11.652\n"
                                             " 100.176 11.438 99.941 11.285 c 99.715 11.133 99.438 11.055 99.109 11.055\n"
                                             " c 98.805 11.055 98.523 11.137 98.27 11.297 c 98.023 11.449 97.805 11.672\n"
                                             " 97.613 11.965 c 97.43 12.25 97.289 12.59 97.188 12.992 c 97.086 13.395 \n"
                                             "97.027 13.836 97.012 14.324 c 97.012 20.805 l 93.965 20.805 l 113.852 20.805\n"
                                             " m 113.852 14.172 l 113.852 13.715 113.82 13.293 113.754 12.914 c 113.695\n"
                                             " 12.527 113.594 12.199 113.449 11.93 c 113.312 11.652 113.125 11.438 112.891\n"
                                             " 11.285 c 112.664 11.133 112.387 11.055 112.059 11.055 c 111.746 11.055 \n"
                                             "111.461 11.137 111.207 11.305 c 110.953 11.465 110.73 11.699 110.539 12.004\n"
                                             " c 110.355 12.301 110.215 12.664 110.113 13.086 c 110.012 13.5 109.961 13.961\n"
                                             " 109.961 14.461 c 109.961 20.797 l 106.891 20.797 l 106.891 11.617 l 106.891\n"
                                             " 11.363 106.887 11.102 106.879 10.832 c 106.879 10.562 106.871 10.309 106.855\n"
                                             " 10.066 c 106.848 9.82 106.84 9.602 106.832 9.41 c 106.824 9.215 106.812\n"
                                             " 9.066 106.801 8.973 c 109.73 8.973 l 109.746 9.059 109.758 9.203 109.773\n"
                                             " 9.398 c 109.789 9.586 109.801 9.801 109.816 10.031 c 109.832 10.266 109.844\n"
                                             " 10.496 109.848 10.73 c 109.863 10.965 109.871 11.16 109.871 11.32 c 109.914\n"
                                             " 11.32 l 110.293 10.418 110.762 9.762 111.324 9.352 c 111.891 8.945 112.57\n"
                                             " 8.738 113.355 8.738 c 114.258 8.738 114.984 8.961 115.531 9.406 c 116.086\n"
                                             " 9.844 116.457 10.48 116.645 11.32 c 116.711 11.32 l 116.922 10.832 117.148\n"
                                             " 10.426 117.387 10.098 c 117.633 9.77 117.902 9.508 118.195 9.312 c 118.492\n"
                                             " 9.109 118.816 8.961 119.156 8.875 c 119.508 8.789 119.883 8.742 120.293\n"
                                             " 8.742 c 120.941 8.742 121.488 8.859 121.934 9.094 c 122.387 9.328 122.75\n"
                                             " 9.648 123.027 10.055 c 123.312 10.461 123.516 10.945 123.641 11.496 c 123.773\n"
                                             " 12.051 123.836 12.648 123.836 13.289 c 123.836 20.797 l 120.789 20.797 \n"
                                             "l 120.789 14.164 l 120.789 13.707 120.758 13.285 120.691 12.906 c 120.633\n"
                                             " 12.52 120.531 12.191 120.387 11.922 c 120.25 11.645 120.062 11.43 119.828\n"
                                             " 11.277 c 119.602 11.125 119.324 11.047 118.996 11.047 c 118.691 11.047 \n"
                                             "118.41 11.129 118.156 11.289 c 117.91 11.441 117.691 11.664 117.5 11.957\n"
                                             " c 117.316 12.242 117.176 12.582 117.074 12.984 c 116.973 13.387 116.914\n"
                                             " 13.828 116.898 14.316 c 116.898 20.797 l 113.852 20.797 l 131.617 21.016\n"
                                             " m 130.766 21.016 129.996 20.891 129.312 20.645 c 128.637 20.391 128.055\n"
                                             " 20.008 127.574 19.496 c 127.094 18.98 126.727 18.336 126.469 17.562 c 126.215\n"
                                             " 16.781 126.086 15.871 126.086 14.832 c 126.086 13.703 126.234 12.754 126.535\n"
                                             " 11.98 c 126.84 11.207 127.25 10.586 127.758 10.113 c 128.273 9.633 128.867\n"
                                             " 9.285 129.539 9.074 c 130.211 8.863 130.914 8.758 131.66 8.758 c 132.594\n"
                                             " 8.758 133.387 8.922 134.043 9.25 c 134.707 9.57 135.25 10.023 135.672 10.605\n"
                                             " c 136.094 11.188 136.402 11.887 136.602 12.703 c 136.797 13.512 136.898\n"
                                             " 14.406 136.898 15.391 c 136.898 15.477 l 129.316 15.477 l 129.316 15.973\n"
                                             " 129.359 16.434 129.449 16.863 c 129.535 17.285 129.68 17.652 129.875 17.969\n"
                                             " c 130.07 18.273 130.328 18.52 130.641 18.699 c 130.953 18.875 131.332 18.961\n"
                                             " 131.777 18.961 c 132.316 18.961 132.758 18.848 133.098 18.621 c 133.441\n"
                                             " 18.387 133.684 18.031 133.828 17.551 c 136.723 17.801 l 136.59 18.137 136.406\n"
                                             " 18.492 136.164 18.871 c 135.93 19.25 135.617 19.598 135.223 19.922 c 134.828\n"
                                             " 20.234 134.336 20.496 133.746 20.707 c 133.164 20.91 132.453 21.012 131.617\n"
                                             " 21.012 c 131.617 10.688 m 131.305 10.688 131.008 10.742 130.73 10.852 c\n"
                                             " 130.461 10.953 130.223 11.121 130.02 11.355 c 129.824 11.582 129.664 11.875\n"
                                             " 129.539 12.242 c 129.414 12.605 129.348 13.043 129.332 13.555 c 133.922\n"
                                             " 13.555 l 133.863 12.602 133.633 11.887 133.234 11.414 c 132.832 10.934 \n"
                                             "132.293 10.691 131.617 10.691 c 146.895 20.797 m 146.895 14.164 l 146.895\n"
                                             " 13.707 146.859 13.285 146.785 12.906 c 146.711 12.52 146.594 12.191 146.426\n"
                                             " 11.922 c 146.258 11.645 146.039 11.43 145.77 11.277 c 145.5 11.125 145.172\n"
                                             " 11.047 144.785 11.047 c 144.414 11.047 144.074 11.129 143.77 11.297 c 143.473\n"
                                             " 11.457 143.211 11.691 142.992 11.996 c 142.773 12.293 142.602 12.656 142.48\n"
                                             " 13.078 c 142.363 13.492 142.305 13.953 142.305 14.453 c 142.305 20.789 \n"
                                             "l 139.234 20.789 l 139.234 11.609 l 139.234 11.355 139.23 11.094 139.223\n"
                                             " 10.824 c 139.223 10.555 139.215 10.301 139.199 10.059 c 139.191 9.812 139.184\n"
                                             " 9.594 139.176 9.402 c 139.168 9.207 139.156 9.059 139.145 8.965 c 142.074\n"
                                             " 8.965 l 142.09 9.051 142.102 9.195 142.117 9.391 c 142.133 9.578 142.145\n"
                                             " 9.793 142.16 10.023 c 142.176 10.258 142.188 10.488 142.191 10.723 c 142.207\n"
                                             " 10.957 142.215 11.152 142.215 11.312 c 142.258 11.312 l 142.672 10.41 143.195\n"
                                             " 9.754 143.82 9.344 c 144.445 8.938 145.195 8.73 146.059 8.73 c 146.773 \n"
                                             "8.73 147.375 8.848 147.863 9.082 c 148.359 9.316 148.758 9.637 149.066 10.043\n"
                                             " c 149.379 10.449 149.605 10.934 149.742 11.484 c 149.879 12.039 149.949\n"
                                             " 12.637 149.949 13.277 c 149.949 20.785 l 146.891 20.785 l 155.938 20.98\n"
                                             " m 155.035 20.98 154.34 20.738 153.852 20.25 c 153.363 19.754 153.121 19.008\n"
                                             " 153.121 18.012 c 153.121 11.039 l 151.625 11.039 l 151.625 8.965 l 153.273\n"
                                             " 8.965 l 154.234 6.188 l 156.156 6.188 l 156.156 8.965 l 158.395 8.965 l\n"
                                             " 158.395 11.039 l 156.156 11.039 l 156.156 17.18 l 156.156 17.754 156.266\n"
                                             " 18.18 156.484 18.457 c 156.703 18.727 157.043 18.859 157.5 18.859 c 157.688\n"
                                             " 18.859 157.859 18.844 158.012 18.816 c 158.164 18.789 158.336 18.75 158.523\n"
                                             " 18.707 c 158.523 20.609 l 158.145 20.734 157.742 20.824 157.32 20.883 c\n"
                                             " 156.898 20.949 156.434 20.98 155.934 20.98 c B Q\n"
                                             "Q q\n"
                                             "0 0.298039 0.431373 rg /a1 gs\n"
                                             "1 1 1 RG 0.797243 w\n"
                                             "1 J\n"
                                             "1 j\n"
                                             "[] 0.0 d\n"
                                             "4 M q 1 0 0 1 0 0 cm\n"
                                             "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                             "24.715 1.77 26.086 3.398 26.086 c 167.109 26.086 l 168.738 26.086 170.109\n"
                                             " 24.715 170.109 23.086 c 170.109 3.398 l 170.109 1.77 168.738 0.398 167.109\n"
                                             " 0.398 c h\n"
                                             "3.867 3.844 m 166.664 3.844 l 166.664 22.617 l 3.867 22.617 l h\n"
                                             "3.867 3.844 m B Q\n"
                                             "Q\n";

static Dict *getForCommentStampExtGStateDict(PDFDoc *doc)
{
    Dict *a0Dict = new Dict(doc->getXRef());
    a0Dict->add("CA", Object(0.588235));
    a0Dict->add("ca", Object(0.588235));

    Dict *a1Dict = new Dict(doc->getXRef());
    a1Dict->add("CA", Object(1));
    a1Dict->add("ca", Object(1));

    Dict *extGStateDict = new Dict(doc->getXRef());
    extGStateDict->add("a0", Object(a0Dict));
    extGStateDict->add("a1", Object(a1Dict));

    return extGStateDict;
}

#endif
