# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Setting(Resource):
    """The kind of the security setting.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AlertSyncSettings, DataExportSettings

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.v2021_06_01.models.SettingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"AlertSyncSettings": "AlertSyncSettings", "DataExportSettings": "DataExportSettings"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AlertSyncSettings(Setting):
    """Represents an alert sync setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.v2021_06_01.models.SettingKind
    :ivar enabled: Is the alert sync setting enabled.
    :vartype enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is the alert sync setting enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: str = "AlertSyncSettings"
        self.enabled = enabled


class AssessmentLinks(_serialization.Model):
    """Links relevant to the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_portal_uri: Link to assessment in Azure Portal.
    :vartype azure_portal_uri: str
    """

    _validation = {
        "azure_portal_uri": {"readonly": True},
    }

    _attribute_map = {
        "azure_portal_uri": {"key": "azurePortalUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_portal_uri = None


class AssessmentStatus(_serialization.Model):
    """The result of the assessment.

    All required parameters must be populated in order to send to server.

    :ivar code: Programmatic code for the status of the assessment. Required. Known values are:
     "Healthy", "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.AssessmentStatusCode"],
        cause: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Programmatic code for the status of the assessment. Required. Known values are:
         "Healthy", "Unhealthy", and "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusCode
        :keyword cause: Programmatic code for the cause of the assessment status.
        :paramtype cause: str
        :keyword description: Human readable description of the assessment status.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.cause = cause
        self.description = description


class AssessmentStatusResponse(AssessmentStatus):
    """The result of the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar code: Programmatic code for the status of the assessment. Required. Known values are:
     "Healthy", "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar first_evaluation_date: The time that the assessment was created and first evaluated.
     Returned as UTC time in ISO 8601 format.
    :vartype first_evaluation_date: ~datetime.datetime
    :ivar status_change_date: The time that the status of the assessment last changed. Returned as
     UTC time in ISO 8601 format.
    :vartype status_change_date: ~datetime.datetime
    """

    _validation = {
        "code": {"required": True},
        "first_evaluation_date": {"readonly": True},
        "status_change_date": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "first_evaluation_date": {"key": "firstEvaluationDate", "type": "iso-8601"},
        "status_change_date": {"key": "statusChangeDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.AssessmentStatusCode"],
        cause: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Programmatic code for the status of the assessment. Required. Known values are:
         "Healthy", "Unhealthy", and "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusCode
        :keyword cause: Programmatic code for the cause of the assessment status.
        :paramtype cause: str
        :keyword description: Human readable description of the assessment status.
        :paramtype description: str
        """
        super().__init__(code=code, cause=cause, description=description, **kwargs)
        self.first_evaluation_date = None
        self.status_change_date = None


class ResourceDetails(_serialization.Model):
    """Details of the resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceDetails, OnPremiseResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2021_06_01.models.Source
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
    }

    _subtype_map = {"source": {"Azure": "AzureResourceDetails", "OnPremise": "OnPremiseResourceDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: Optional[str] = None


class AzureResourceDetails(ResourceDetails):
    """Details of the Azure resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2021_06_01.models.Source
    :ivar id: Azure resource Id of the assessed resource.
    :vartype id: str
    """

    _validation = {
        "source": {"required": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: str = "Azure"
        self.id = None


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2021_06_01.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2021_06_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class DataExportSettings(Setting):
    """Represents a data export setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.v2021_06_01.models.SettingKind
    :ivar enabled: Is the data export setting enabled.
    :vartype enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is the data export setting enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: str = "DataExportSettings"
        self.enabled = enabled


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class OnPremiseResourceDetails(ResourceDetails):
    """Details of the On Premise resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OnPremiseSqlResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2021_06_01.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
    }

    _subtype_map = {"source": {"OnPremiseSql": "OnPremiseSqlResourceDetails"}}

    def __init__(
        self, *, workspace_id: str, vmuuid: str, source_computer_id: str, machine_name: str, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        """
        super().__init__(**kwargs)
        self.source: str = "OnPremise"
        self.workspace_id = workspace_id
        self.vmuuid = vmuuid
        self.source_computer_id = source_computer_id
        self.machine_name = machine_name


class OnPremiseSqlResourceDetails(OnPremiseResourceDetails):
    """Details of the On Premise Sql resource that was assessed.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2021_06_01.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    :ivar server_name: The Sql server name installed on the machine. Required.
    :vartype server_name: str
    :ivar database_name: The Sql database name installed on the machine. Required.
    :vartype database_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
        "server_name": {"required": True},
        "database_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_id: str,
        vmuuid: str,
        source_computer_id: str,
        machine_name: str,
        server_name: str,
        database_name: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        :keyword server_name: The Sql server name installed on the machine. Required.
        :paramtype server_name: str
        :keyword database_name: The Sql database name installed on the machine. Required.
        :paramtype database_name: str
        """
        super().__init__(
            workspace_id=workspace_id,
            vmuuid=vmuuid,
            source_computer_id=source_computer_id,
            machine_name=machine_name,
            **kwargs
        )
        self.source: str = "OnPremiseSql"
        self.server_name = server_name
        self.database_name = database_name


class SecurityAssessment(Resource):
    """Security assessment on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2021_06_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment.
    :vartype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{str}"},
        "links": {"key": "properties.links", "type": "AssessmentLinks"},
        "metadata": {"key": "properties.metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "properties.partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "properties.status", "type": "AssessmentStatus"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        status: Optional["_models.AssessmentStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment.
        :paramtype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatus
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.display_name = None
        self.additional_data = additional_data
        self.links = None
        self.metadata = metadata
        self.partners_data = partners_data
        self.status = status


class SecurityAssessmentList(_serialization.Model):
    """Page of a security assessments list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security assessments in this page.
    :vartype value: list[~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentResponse]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessmentResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityAssessmentMetadata(Resource):  # pylint: disable=too-many-instance-attributes
    """Security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
    :ivar severity: The severity level of the assessment. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
     "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_definition_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "user_impact": {"key": "properties.userImpact", "type": "str"},
        "implementation_effort": {"key": "properties.implementationEffort", "type": "str"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "partner_data": {"key": "properties.partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
        :keyword severity: The severity level of the assessment. Known values are: "Low", "Medium", and
         "High".
        :paramtype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
         "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentMetadataPartnerData(_serialization.Model):
    """Describes the partner that created the assessment.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar product_name: Name of the product of the partner that created the assessment.
    :vartype product_name: str
    :ivar secret: Secret to authenticate the partner and verify it created the assessment - write
     only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, product_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword product_name: Name of the product of the partner that created the assessment.
        :paramtype product_name: str
        :keyword secret: Secret to authenticate the partner and verify it created the assessment -
         write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.product_name = product_name
        self.secret = secret


class SecurityAssessmentMetadataProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes properties of an assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: User friendly display name of the assessment. Required.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
    :ivar severity: The severity level of the assessment. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
     "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "display_name": {"required": True},
        "policy_definition_id": {"readonly": True},
        "severity": {"required": True},
        "assessment_type": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation_description": {"key": "remediationDescription", "type": "str"},
        "categories": {"key": "categories", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "user_impact": {"key": "userImpact", "type": "str"},
        "implementation_effort": {"key": "implementationEffort", "type": "str"},
        "threats": {"key": "threats", "type": "[str]"},
        "preview": {"key": "preview", "type": "bool"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "partner_data": {"key": "partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        severity: Union[str, "_models.Severity"],
        assessment_type: Union[str, "_models.AssessmentType"],
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment. Required.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
        :keyword severity: The severity level of the assessment. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
         "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentMetadataPropertiesResponse(
    SecurityAssessmentMetadataProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Describes properties of an assessment metadata response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: User friendly display name of the assessment. Required.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
    :ivar severity: The severity level of the assessment. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
     "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
    :ivar publish_dates:
    :vartype publish_dates:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
    :ivar planned_deprecation_date:
    :vartype planned_deprecation_date: str
    :ivar tactics:
    :vartype tactics: list[str or ~azure.mgmt.security.v2021_06_01.models.Tactics]
    :ivar techniques:
    :vartype techniques: list[str or ~azure.mgmt.security.v2021_06_01.models.Techniques]
    """

    _validation = {
        "display_name": {"required": True},
        "policy_definition_id": {"readonly": True},
        "severity": {"required": True},
        "assessment_type": {"required": True},
        "planned_deprecation_date": {"pattern": r"^[0-9]{2}/[0-9]{4}$"},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation_description": {"key": "remediationDescription", "type": "str"},
        "categories": {"key": "categories", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "user_impact": {"key": "userImpact", "type": "str"},
        "implementation_effort": {"key": "implementationEffort", "type": "str"},
        "threats": {"key": "threats", "type": "[str]"},
        "preview": {"key": "preview", "type": "bool"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "partner_data": {"key": "partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
        "publish_dates": {"key": "publishDates", "type": "SecurityAssessmentMetadataPropertiesResponsePublishDates"},
        "planned_deprecation_date": {"key": "plannedDeprecationDate", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        severity: Union[str, "_models.Severity"],
        assessment_type: Union[str, "_models.AssessmentType"],
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        publish_dates: Optional["_models.SecurityAssessmentMetadataPropertiesResponsePublishDates"] = None,
        planned_deprecation_date: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.Tactics"]]] = None,
        techniques: Optional[List[Union[str, "_models.Techniques"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment. Required.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
        :keyword severity: The severity level of the assessment. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
         "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
        :keyword publish_dates:
        :paramtype publish_dates:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
        :keyword planned_deprecation_date:
        :paramtype planned_deprecation_date: str
        :keyword tactics:
        :paramtype tactics: list[str or ~azure.mgmt.security.v2021_06_01.models.Tactics]
        :keyword techniques:
        :paramtype techniques: list[str or ~azure.mgmt.security.v2021_06_01.models.Techniques]
        """
        super().__init__(
            display_name=display_name,
            description=description,
            remediation_description=remediation_description,
            categories=categories,
            severity=severity,
            user_impact=user_impact,
            implementation_effort=implementation_effort,
            threats=threats,
            preview=preview,
            assessment_type=assessment_type,
            partner_data=partner_data,
            **kwargs
        )
        self.publish_dates = publish_dates
        self.planned_deprecation_date = planned_deprecation_date
        self.tactics = tactics
        self.techniques = techniques


class SecurityAssessmentMetadataPropertiesResponsePublishDates(_serialization.Model):  # pylint: disable=name-too-long
    """SecurityAssessmentMetadataPropertiesResponsePublishDates.

    All required parameters must be populated in order to send to server.

    :ivar ga:
    :vartype ga: str
    :ivar public: Required.
    :vartype public: str
    """

    _validation = {
        "ga": {"pattern": r"^([0-9]{2}/){2}[0-9]{4}$"},
        "public": {"required": True, "pattern": r"^([0-9]{2}/){2}[0-9]{4}$"},
    }

    _attribute_map = {
        "ga": {"key": "GA", "type": "str"},
        "public": {"key": "public", "type": "str"},
    }

    def __init__(self, *, public: str, ga: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ga:
        :paramtype ga: str
        :keyword public: Required.
        :paramtype public: str
        """
        super().__init__(**kwargs)
        self.ga = ga
        self.public = public


class SecurityAssessmentMetadataResponse(Resource):  # pylint: disable=too-many-instance-attributes
    """Security assessment metadata response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
    :ivar severity: The severity level of the assessment. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
     "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
    :ivar publish_dates:
    :vartype publish_dates:
     ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
    :ivar planned_deprecation_date:
    :vartype planned_deprecation_date: str
    :ivar tactics:
    :vartype tactics: list[str or ~azure.mgmt.security.v2021_06_01.models.Tactics]
    :ivar techniques:
    :vartype techniques: list[str or ~azure.mgmt.security.v2021_06_01.models.Techniques]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_definition_id": {"readonly": True},
        "planned_deprecation_date": {"pattern": r"^[0-9]{2}/[0-9]{4}$"},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "user_impact": {"key": "properties.userImpact", "type": "str"},
        "implementation_effort": {"key": "properties.implementationEffort", "type": "str"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "partner_data": {"key": "properties.partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
        "publish_dates": {
            "key": "properties.publishDates",
            "type": "SecurityAssessmentMetadataPropertiesResponsePublishDates",
        },
        "planned_deprecation_date": {"key": "properties.plannedDeprecationDate", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        publish_dates: Optional["_models.SecurityAssessmentMetadataPropertiesResponsePublishDates"] = None,
        planned_deprecation_date: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.Tactics"]]] = None,
        techniques: Optional[List[Union[str, "_models.Techniques"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2021_06_01.models.Categories]
        :keyword severity: The severity level of the assessment. Known values are: "Low", "Medium", and
         "High".
        :paramtype severity: str or ~azure.mgmt.security.v2021_06_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2021_06_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2021_06_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2021_06_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
         "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2021_06_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPartnerData
        :keyword publish_dates:
        :paramtype publish_dates:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
        :keyword planned_deprecation_date:
        :paramtype planned_deprecation_date: str
        :keyword tactics:
        :paramtype tactics: list[str or ~azure.mgmt.security.v2021_06_01.models.Tactics]
        :keyword techniques:
        :paramtype techniques: list[str or ~azure.mgmt.security.v2021_06_01.models.Techniques]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data
        self.publish_dates = publish_dates
        self.planned_deprecation_date = planned_deprecation_date
        self.tactics = tactics
        self.techniques = techniques


class SecurityAssessmentMetadataResponseList(_serialization.Model):
    """List of security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value:
     list[~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataResponse]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessmentMetadataResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityAssessmentPartnerData(_serialization.Model):
    """Data regarding 3rd party partner integration.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar secret: secret to authenticate the partner - write only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword secret: secret to authenticate the partner - write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.secret = secret


class SecurityAssessmentPropertiesBase(_serialization.Model):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2021_06_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.display_name = None
        self.additional_data = additional_data
        self.links = None
        self.metadata = metadata
        self.partners_data = partners_data


class SecurityAssessmentProperties(SecurityAssessmentPropertiesBase):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2021_06_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment. Required.
    :vartype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatus
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "status", "type": "AssessmentStatus"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        status: "_models.AssessmentStatus",
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment. Required.
        :paramtype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatus
        """
        super().__init__(
            resource_details=resource_details,
            additional_data=additional_data,
            metadata=metadata,
            partners_data=partners_data,
            **kwargs
        )
        self.status = status


class SecurityAssessmentPropertiesResponse(SecurityAssessmentPropertiesBase):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2021_06_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment. Required.
    :vartype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusResponse
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "status", "type": "AssessmentStatusResponse"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        status: "_models.AssessmentStatusResponse",
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment. Required.
        :paramtype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusResponse
        """
        super().__init__(
            resource_details=resource_details,
            additional_data=additional_data,
            metadata=metadata,
            partners_data=partners_data,
            **kwargs
        )
        self.status = status


class SecurityAssessmentResponse(Resource):
    """Security assessment on a resource - response format.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2021_06_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment.
    :vartype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusResponse
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{str}"},
        "links": {"key": "properties.links", "type": "AssessmentLinks"},
        "metadata": {"key": "properties.metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "properties.partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "properties.status", "type": "AssessmentStatusResponse"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        status: Optional["_models.AssessmentStatusResponse"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.v2021_06_01.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2021_06_01.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment.
        :paramtype status: ~azure.mgmt.security.v2021_06_01.models.AssessmentStatusResponse
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.display_name = None
        self.additional_data = additional_data
        self.links = None
        self.metadata = metadata
        self.partners_data = partners_data
        self.status = status


class SettingsList(_serialization.Model):
    """Subscription settings list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The settings list.
    :vartype value: list[~azure.mgmt.security.v2021_06_01.models.Setting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Setting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Setting"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The settings list.
        :paramtype value: list[~azure.mgmt.security.v2021_06_01.models.Setting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None
