
##############################################################################
#
# Copyright (c) 2003-2018 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2018 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
test for binary operations which don't have new style tests written for them.
The plan is to remove this file once its tests have been moved over.

:remark: use see `test_util`
:var __author__: name of author
:var __copyright__: copyrights
:var __license__: licence agreement
:var __url__: url entry point on documentation
:var __version__: version
:var __date__: date of the version
"""

__author__="Lutz Gross, l.gross@uq.edu.au"

import esys.escriptcore.utestselect as unittest
import numpy
from esys.escript import *
from test_util_base import Test_util_base

class Test_util_binary_leftover(Test_util_base):
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_float_rank0_offset0(self):
      arg0=7.0
      arg1=6.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=42.0
      self.assertTrue(isinstance(res,float),"wrong type of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,complex),"wrong type of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_array_rank0_offset0(self):
      arg0=0.0
      arg1=numpy.array(-6.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(-0.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_array_rank1_offset0(self):
      arg0=-2.0
      arg1=numpy.array([-7.0, -5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([14.0, 10.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_array_rank2_offset0(self):
      arg0=-3.0
      arg1=numpy.array([[0.0, -4.0, 2.0, -7.0, -3.0], [-7.0, 4.0, -1.0, 3.0, 0.0], [3.0, 4.0, -3.0, 7.0, -4.0], [5.0, 4.0, 4.0, 
0.0, 3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[-0.0, 12.0, -6.0, 21.0, 9.0], [21.0, -12.0, 3.0, -9.0, -0.0], [-9.0, -12.0, 9.0, -21.0, 12.0], [-15.0, 
-12.0, -12.0, -0.0, -9.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_array_rank3_offset0(self):
      arg0=-6.0
      arg1=numpy.array([[[-4.0, 7.0], [-1.0, -3.0]], [[3.0, -1.0], [-5.0, -6.0]], [[-6.0, 6.0], [5.0, -5.0]], [[0.0, 6.0], 
[7.0, 7.0]], [[-6.0, 7.0], [4.0, 5.0]], [[6.0, 1.0], [-5.0, 2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[24.0, -42.0], [6.0, 18.0]], [[-18.0, 6.0], [30.0, 36.0]], [[36.0, -36.0], [-30.0, 30.0]], [[-0.0, 
-36.0], [-42.0, -42.0]], [[36.0, -42.0], [-24.0, -30.0]], [[-36.0, -6.0], [30.0, -12.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_array_rank4_offset0(self):
      arg0=7.0
      arg1=numpy.array([[[[0.0, -7.0, -6.0, 5.0], [-5.0, 2.0, 6.0, 0.0], [0.0, 1.0, -1.0, -1.0]], [[0.0, -2.0, -1.0, 3.0], 
[-4.0, 0.0, 2.0, -3.0], [-3.0, -6.0, -3.0, -2.0]]], [[[6.0, 7.0, 5.0, 5.0], [5.0, 1.0, 0.0, -3.0], [0.0, 0.0, -1.0, 0.0]], 
[[-6.0, 1.0, -7.0, -3.0], [7.0, 7.0, -5.0, 6.0], [-7.0, 1.0, 0.0, 0.0]]], [[[2.0, -2.0, 6.0, -6.0], [-7.0, 2.0, 0.0, -2.0], 
[3.0, -6.0, -3.0, 1.0]], [[-6.0, 1.0, 2.0, 3.0], [-2.0, 5.0, 4.0, 1.0], [4.0, 0.0, -2.0, -2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[0.0, -49.0, -42.0, 35.0], [-35.0, 14.0, 42.0, 0.0], [0.0, 7.0, -7.0, -7.0]], [[0.0, -14.0, -7.0, 
21.0], [-28.0, 0.0, 14.0, -21.0], [-21.0, -42.0, -21.0, -14.0]]], [[[42.0, 49.0, 35.0, 35.0], [35.0, 7.0, 0.0, -21.0], [0.0, 
0.0, -7.0, 0.0]], [[-42.0, 7.0, -49.0, -21.0], [49.0, 49.0, -35.0, 42.0], [-49.0, 7.0, 0.0, 0.0]]], [[[14.0, -14.0, 42.0, 
-42.0], [-49.0, 14.0, 0.0, -14.0], [21.0, -42.0, -21.0, 7.0]], [[-42.0, 7.0, 14.0, 21.0], [-14.0, 35.0, 28.0, 7.0], [28.0, 0.0, 
-14.0, -14.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_constData_rank0_offset0(self):
      arg0=7.0
      arg1=Data(-4.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-28.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_constData_rank1_offset0(self):
      arg0=3.0
      arg1=Data(numpy.array([-1.0, -6.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-3.0, -18.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_constData_rank2_offset0(self):
      arg0=-1.0
      arg1=Data(numpy.array([[-7.0, 0.0, -7.0, -1.0, -4.0], [0.0, -4.0, -1.0, 3.0, 0.0], [4.0, -5.0, 6.0, -3.0, 0.0], [0.0, 
-2.0, 3.0, -2.0, 4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[7.0, -0.0, 7.0, 1.0, 4.0], [-0.0, 4.0, 1.0, -3.0, -0.0], [-4.0, 5.0, -6.0, 3.0, -0.0], [-0.0, 2.0, 
-3.0, 2.0, -4.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_constData_rank3_offset0(self):
      arg0=-6.0
      arg1=Data(numpy.array([[[-6.0, 2.0], [4.0, 2.0]], [[-5.0, -2.0], [-4.0, -3.0]], [[-6.0, 2.0], [-1.0, -4.0]], [[0.0, 0.0], 
[0.0, 3.0]], [[5.0, 5.0], [-7.0, -6.0]], [[0.0, 5.0], [6.0, 3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[36.0, -12.0], [-24.0, -12.0]], [[30.0, 12.0], [24.0, 18.0]], [[36.0, -12.0], [6.0, 24.0]], 
[[-0.0, -0.0], [-0.0, -18.0]], [[-30.0, -30.0], [42.0, 36.0]], [[-0.0, -30.0], [-36.0, -18.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_constData_rank4_offset0(self):
      arg0=-6.0
      arg1=Data(numpy.array([[[[7.0, 1.0, -7.0, 0.0], [-6.0, 0.0, -5.0, 4.0], [-6.0, 7.0, 0.0, -5.0]], [[2.0, 3.0, 5.0, -4.0], 
[7.0, -3.0, 0.0, -6.0], [2.0, -6.0, 7.0, 2.0]]], [[[3.0, 0.0, 1.0, -2.0], [-4.0, -1.0, 0.0, -5.0], [7.0, 3.0, 0.0, -6.0]], 
[[-7.0, -1.0, 1.0, -7.0], [7.0, 4.0, -1.0, -3.0], [5.0, -2.0, 2.0, 6.0]]], [[[-3.0, -1.0, 7.0, 0.0], [0.0, 6.0, 5.0, 0.0], 
[2.0, -7.0, 3.0, -4.0]], [[-5.0, 3.0, 5.0, 2.0], [-5.0, 1.0, 3.0, -2.0], [2.0, -3.0, 5.0, -5.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-42.0, -6.0, 42.0, -0.0], [36.0, -0.0, 30.0, -24.0], [36.0, -42.0, -0.0, 30.0]], [[-12.0, -18.0, 
-30.0, 24.0], [-42.0, 18.0, -0.0, 36.0], [-12.0, 36.0, -42.0, -12.0]]], [[[-18.0, -0.0, -6.0, 12.0], [24.0, 6.0, -0.0, 30.0], 
[-42.0, -18.0, -0.0, 36.0]], [[42.0, 6.0, -6.0, 42.0], [-42.0, -24.0, 6.0, 18.0], [-30.0, 12.0, -12.0, -36.0]]], [[[18.0, 6.0, 
-42.0, -0.0], [-0.0, -36.0, -30.0, -0.0], [-12.0, 42.0, -18.0, 24.0]], [[30.0, -18.0, -30.0, -12.0], [30.0, -6.0, -18.0, 12.0], 
[-12.0, 18.0, -30.0, 30.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_expandedData_rank0_offset0(self):
      arg0=7.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-6.0)+(1-msk_arg1)*(-3.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-42.0)+(1.-msk_ref)*numpy.array(-21.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_expandedData_rank1_offset0(self):
      arg0=-6.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([7.0, 2.0])+(1.-msk_arg1)*numpy.array([0.0, -5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-42.0, -12.0])+(1.-msk_ref)*numpy.array([-0.0, 30.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_expandedData_rank2_offset0(self):
      arg0=-1.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[1.0, 6.0, 6.0, 7.0, 0.0], [7.0, -4.0, 4.0, -2.0, 7.0], [-1.0, -6.0, 5.0, -5.0, 7.0], [-2.0, 
0.0, -4.0, 3.0, 3.0]])+(1.-msk_arg1)*numpy.array([[-5.0, 4.0, 5.0, -2.0, 7.0], [-6.0, 1.0, -3.0, 3.0, 0.0], [-4.0, 0.0, 5.0, 
-3.0, 0.0], [-2.0, 6.0, -7.0, 0.0, -1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-1.0, -6.0, -6.0, -7.0, -0.0], [-7.0, 4.0, -4.0, 2.0, -7.0], [1.0, 6.0, -5.0, 5.0, -7.0], [2.0, 
-0.0, 4.0, -3.0, -3.0]])+(1.-msk_ref)*numpy.array([[5.0, -4.0, -5.0, 2.0, -7.0], [6.0, -1.0, 3.0, -3.0, -0.0], [4.0, -0.0, 
-5.0, 3.0, -0.0], [2.0, -6.0, 7.0, -0.0, 1.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_expandedData_rank3_offset0(self):
      arg0=7.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[0.0, -5.0], [-6.0, 0.0]], [[3.0, -7.0], [4.0, -1.0]], [[1.0, -6.0], [-6.0, -6.0]], [[0.0, 
-4.0], [-6.0, 7.0]], [[-3.0, 7.0], [-6.0, 1.0]], [[-2.0, 3.0], [-6.0, 0.0]]])+(1.-msk_arg1)*numpy.array([[[-5.0, -4.0], [2.0, 
1.0]], [[0.0, 0.0], [-7.0, -4.0]], [[-6.0, -1.0], [3.0, -3.0]], [[-4.0, -6.0], [5.0, 1.0]], [[-5.0, 7.0], [-4.0, 0.0]], [[7.0, 
-7.0], [2.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.0, -35.0], [-42.0, 0.0]], [[21.0, -49.0], [28.0, -7.0]], [[7.0, -42.0], [-42.0, -42.0]], 
[[0.0, -28.0], [-42.0, 49.0]], [[-21.0, 49.0], [-42.0, 7.0]], [[-14.0, 21.0], [-42.0, 
0.0]]])+(1.-msk_ref)*numpy.array([[[-35.0, -28.0], [14.0, 7.0]], [[0.0, 0.0], [-49.0, -28.0]], [[-42.0, -7.0], [21.0, -21.0]], 
[[-28.0, -42.0], [35.0, 7.0]], [[-35.0, 49.0], [-28.0, 0.0]], [[49.0, -49.0], [14.0, -21.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_float_rank0_expandedData_rank4_offset0(self):
      arg0=3.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[3.0, -4.0, -6.0, 7.0], [7.0, 3.0, 3.0, 6.0], [0.0, -7.0, 6.0, 1.0]], [[-7.0, 1.0, 4.0, 
4.0], [5.0, 4.0, 1.0, -7.0], [7.0, 0.0, -6.0, 2.0]]], [[[0.0, -7.0, -3.0, 2.0], [1.0, -7.0, 2.0, -6.0], [0.0, 5.0, -1.0, 
-3.0]], [[-7.0, -1.0, 3.0, 0.0], [5.0, 0.0, 0.0, -6.0], [-5.0, -3.0, 0.0, -5.0]]], [[[-7.0, 0.0, 2.0, -3.0], [0.0, 6.0, -4.0, 
-1.0], [-4.0, -2.0, 4.0, 7.0]], [[-7.0, 6.0, -5.0, -1.0], [6.0, 2.0, 2.0, -3.0], [-5.0, -7.0, 2.0, 
0.0]]]])+(1.-msk_arg1)*numpy.array([[[[0.0, -4.0, 6.0, -6.0], [7.0, 7.0, -3.0, -2.0], [3.0, -5.0, 0.0, 0.0]], [[3.0, 1.0, 0.0, 
-1.0], [-3.0, -3.0, 0.0, -3.0], [-3.0, -6.0, 6.0, -2.0]]], [[[-2.0, 3.0, 0.0, -2.0], [0.0, 5.0, -4.0, -3.0], [-5.0, -5.0, -7.0, 
-1.0]], [[-4.0, -5.0, 2.0, -1.0], [2.0, -1.0, 0.0, 1.0], [6.0, 6.0, 3.0, -4.0]]], [[[-7.0, -6.0, 3.0, -2.0], [-6.0, 7.0, 3.0, 
-3.0], [-1.0, 2.0, -3.0, 1.0]], [[3.0, -3.0, 0.0, -5.0], [2.0, -6.0, -7.0, 5.0], [-2.0, 0.0, 3.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[9.0, -12.0, -18.0, 21.0], [21.0, 9.0, 9.0, 18.0], [0.0, -21.0, 18.0, 3.0]], [[-21.0, 3.0, 
12.0, 12.0], [15.0, 12.0, 3.0, -21.0], [21.0, 0.0, -18.0, 6.0]]], [[[0.0, -21.0, -9.0, 6.0], [3.0, -21.0, 6.0, -18.0], [0.0, 
15.0, -3.0, -9.0]], [[-21.0, -3.0, 9.0, 0.0], [15.0, 0.0, 0.0, -18.0], [-15.0, -9.0, 0.0, -15.0]]], [[[-21.0, 0.0, 6.0, -9.0], 
[0.0, 18.0, -12.0, -3.0], [-12.0, -6.0, 12.0, 21.0]], [[-21.0, 18.0, -15.0, -3.0], [18.0, 6.0, 6.0, -9.0], [-15.0, -21.0, 6.0, 
0.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, -12.0, 18.0, -18.0], [21.0, 21.0, -9.0, -6.0], [9.0, -15.0, 0.0, 0.0]], [[9.0, 3.0, 
0.0, -3.0], [-9.0, -9.0, 0.0, -9.0], [-9.0, -18.0, 18.0, -6.0]]], [[[-6.0, 9.0, 0.0, -6.0], [0.0, 15.0, -12.0, -9.0], [-15.0, 
-15.0, -21.0, -3.0]], [[-12.0, -15.0, 6.0, -3.0], [6.0, -3.0, 0.0, 3.0], [18.0, 18.0, 9.0, -12.0]]], [[[-21.0, -18.0, 9.0, 
-6.0], [-18.0, 21.0, 9.0, -9.0], [-3.0, 6.0, -9.0, 3.0]], [[9.0, -9.0, 0.0, -15.0], [6.0, -18.0, -21.0, 15.0], [-6.0, 0.0, 9.0, 
3.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_float_rank0_offset0(self):
      arg0=numpy.array(4.0)
      arg1=-5.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(-20.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_array_rank0_offset0(self):
      arg0=numpy.array(-3.0)
      arg1=numpy.array(-7.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(21.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank1_offset1(self):
      arg0=numpy.array([-4.0, 0.0, -6.0])
      arg1=numpy.array([-4.0, 4.0, -5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array(46.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank2_offset2(self):
      arg0=numpy.array([[-4.0, -6.0, 0.0], [5.0, 0.0, 0.0]])
      arg1=numpy.array([[1.0, 1.0, 4.0], [5.0, -3.0, 2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array(15.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank3_offset3(self):
      arg0=numpy.array([[[-4.0, 6.0, -7.0], [-1.0, 0.0, -3.0], [0.0, -7.0, 5.0], [4.0, -4.0, -3.0]], [[0.0, 6.0, 5.0], [-4.0, 
0.0, -1.0], [0.0, 7.0, 6.0], [-2.0, -6.0, 6.0]]])
      arg1=numpy.array([[[-1.0, -6.0, -6.0], [-7.0, 3.0, 0.0], [5.0, 0.0, 1.0], [-6.0, 3.0, -7.0]], [[4.0, 1.0, -3.0], [-3.0, 
7.0, -1.0], [5.0, 5.0, -6.0], [6.0, -1.0, 1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array(10.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank4_offset4(self):
      arg0=numpy.array([[[[0.0, 5.0], [-6.0, -7.0], [-5.0, 1.0]], [[1.0, 3.0], [-6.0, 1.0], [-3.0, -1.0]]], [[[-4.0, 0.0], 
[5.0, 7.0], [-3.0, -2.0]], [[5.0, -3.0], [6.0, 0.0], [6.0, -2.0]]], [[[-4.0, -3.0], [3.0, -5.0], [4.0, 6.0]], [[-4.0, -3.0], 
[5.0, 6.0], [3.0, 2.0]]], [[[-6.0, -2.0], [-2.0, 5.0], [-4.0, 5.0]], [[2.0, -6.0], [-3.0, -2.0], [-1.0, 3.0]]]])
      arg1=numpy.array([[[[-5.0, -5.0], [-6.0, -1.0], [-4.0, -7.0]], [[-7.0, -4.0], [-2.0, -1.0], [-7.0, -2.0]]], [[[2.0, 1.0], 
[3.0, -6.0], [-7.0, 2.0]], [[7.0, 3.0], [3.0, 7.0], [-3.0, 7.0]]], [[[-5.0, 6.0], [6.0, -5.0], [-2.0, 7.0]], [[5.0, 4.0], 
[-3.0, -7.0], [-2.0, 4.0]]], [[[-1.0, 6.0], [0.0, 2.0], [1.0, 7.0]], [[-5.0, 1.0], [2.0, -2.0], [5.0, -5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      ref=numpy.array(29.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_array_rank1_offset0(self):
      arg0=numpy.array(-7.0)
      arg1=numpy.array([0.0, -6.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([-0.0, 42.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank2_offset1(self):
      arg0=numpy.array([-5.0, -6.0, -2.0])
      arg1=numpy.array([[6.0, 6.0], [0.0, 7.0], [-1.0, -6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([-28.0, -60.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank3_offset2(self):
      arg0=numpy.array([[4.0, 2.0, 5.0], [-5.0, 6.0, -6.0]])
      arg1=numpy.array([[[4.0, 3.0], [-2.0, -5.0], [-6.0, 6.0]], [[-7.0, 5.0], [-1.0, -6.0], [-6.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([47.0, -29.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank4_offset3(self):
      arg0=numpy.array([[[-5.0, -4.0, 7.0], [-6.0, -3.0, 1.0], [4.0, -7.0, 1.0], [7.0, 5.0, 2.0]], [[2.0, 0.0, 0.0], [5.0, 
-2.0, -4.0], [-4.0, 0.0, -5.0], [1.0, -2.0, 1.0]]])
      arg1=numpy.array([[[[0.0, -2.0], [-1.0, 0.0], [3.0, -1.0]], [[-6.0, 5.0], [-4.0, -1.0], [-7.0, -4.0]], [[0.0, -2.0], 
[-4.0, 3.0], [2.0, -6.0]], [[3.0, -5.0], [6.0, 0.0], [-5.0, 0.0]]], [[[5.0, 3.0], [0.0, -2.0], [-6.0, -5.0]], [[-5.0, 0.0], 
[-1.0, 1.0], [-7.0, -3.0]], [[0.0, -4.0], [1.0, 2.0], [-6.0, -5.0]], [[-1.0, 3.0], [6.0, 0.0], [6.0, -3.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([175.0, -41.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_array_rank2_offset0(self):
      arg0=numpy.array(1.0)
      arg1=numpy.array([[0.0, -7.0, 0.0, -2.0, -2.0], [7.0, 1.0, 2.0, -4.0, 3.0], [-7.0, 4.0, 4.0, 5.0, -6.0], [-3.0, 7.0, 4.0, 
3.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[0.0, -7.0, 0.0, -2.0, -2.0], [7.0, 1.0, 2.0, -4.0, 3.0], [-7.0, 4.0, 4.0, 5.0, -6.0], [-3.0, 7.0, 4.0, 
3.0, -4.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank3_offset1(self):
      arg0=numpy.array([0.0, 2.0, 4.0])
      arg1=numpy.array([[[7.0, -5.0, -6.0, 6.0, 0.0], [3.0, 3.0, -6.0, 4.0, 1.0], [-7.0, 3.0, 7.0, 3.0, 5.0], [5.0, -2.0, 6.0, 
-1.0, 4.0]], [[-7.0, 0.0, 5.0, 7.0, 5.0], [0.0, 0.0, 5.0, -7.0, 2.0], [1.0, -4.0, 5.0, 5.0, 3.0], [-2.0, 0.0, 7.0, -7.0, 0.0]], 
[[-2.0, 2.0, 2.0, 4.0, 3.0], [-3.0, 4.0, 0.0, 3.0, -7.0], [5.0, -4.0, -6.0, -6.0, -2.0], [-6.0, 1.0, -1.0, -1.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[-22.0, 8.0, 18.0, 30.0, 22.0], [-12.0, 16.0, 10.0, -2.0, -24.0], [22.0, -24.0, -14.0, -14.0, -2.0], 
[-28.0, 4.0, 10.0, -18.0, 0.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank4_offset2(self):
      arg0=numpy.array([[2.0, -6.0, -3.0], [-5.0, -5.0, -7.0]])
      arg1=numpy.array([[[[-5.0, -2.0, 2.0, -2.0, 6.0], [1.0, -6.0, -7.0, -1.0, -5.0], [5.0, 0.0, 2.0, 5.0, 2.0], [-1.0, -5.0, 
7.0, 0.0, 3.0]], [[7.0, 4.0, 6.0, -6.0, 0.0], [5.0, -5.0, 3.0, 4.0, -2.0], [7.0, -4.0, 4.0, 5.0, 7.0], [-7.0, 0.0, 7.0, 0.0, 
4.0]], [[5.0, 6.0, 6.0, 4.0, 6.0], [5.0, -4.0, 0.0, -6.0, 2.0], [-5.0, -1.0, -2.0, -1.0, 1.0], [0.0, 6.0, -3.0, -1.0, 5.0]]], 
[[[3.0, -2.0, 6.0, -4.0, -4.0], [3.0, -2.0, 4.0, -6.0, -1.0], [-5.0, -6.0, 0.0, -6.0, -2.0], [-5.0, -4.0, 7.0, -6.0, -2.0]], 
[[-7.0, 1.0, 7.0, 4.0, 3.0], [1.0, -1.0, -5.0, 5.0, -7.0], [-2.0, 6.0, 0.0, -6.0, 6.0], [0.0, -2.0, -4.0, 3.0, 2.0]], [[-4.0, 
7.0, 6.0, -6.0, 1.0], [0.0, 3.0, -3.0, 3.0, -4.0], [-2.0, 0.0, -3.0, -5.0, -7.0], [6.0, -7.0, 0.0, 7.0, -1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[-19.0, -90.0, -157.0, 62.0, -8.0], [-63.0, 24.0, -6.0, -24.0, 64.0], [32.0, 27.0, 7.0, 78.0, -12.0], 
[23.0, 51.0, -34.0, -31.0, -26.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_array_rank3_offset0(self):
      arg0=numpy.array(6.0)
      arg1=numpy.array([[[-2.0, 6.0], [-7.0, 5.0]], [[5.0, -4.0], [-5.0, 1.0]], [[-5.0, 4.0], [1.0, -1.0]], [[4.0, -1.0], 
[-4.0, 4.0]], [[2.0, 1.0], [6.0, -2.0]], [[3.0, 6.0], [3.0, -6.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-12.0, 36.0], [-42.0, 30.0]], [[30.0, -24.0], [-30.0, 6.0]], [[-30.0, 24.0], [6.0, -6.0]], [[24.0, 
-6.0], [-24.0, 24.0]], [[12.0, 6.0], [36.0, -12.0]], [[18.0, 36.0], [18.0, -36.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank4_offset1(self):
      arg0=numpy.array([-3.0, 5.0, 0.0])
      arg1=numpy.array([[[[-7.0, 0.0], [-7.0, 2.0]], [[7.0, 4.0], [0.0, 6.0]], [[-7.0, 6.0], [-6.0, -4.0]], [[-4.0, 3.0], 
[-2.0, -1.0]], [[7.0, 0.0], [-4.0, 1.0]], [[6.0, -5.0], [-1.0, 4.0]]], [[[-6.0, 6.0], [-2.0, -2.0]], [[-1.0, 0.0], [5.0, 6.0]], 
[[2.0, 0.0], [-6.0, 0.0]], [[-5.0, 7.0], [0.0, 0.0]], [[3.0, 2.0], [3.0, 1.0]], [[6.0, 4.0], [-1.0, 0.0]]], [[[-6.0, 5.0], 
[2.0, 4.0]], [[-7.0, 7.0], [6.0, -7.0]], [[-7.0, -4.0], [-5.0, 3.0]], [[1.0, 2.0], [3.0, 0.0]], [[0.0, 6.0], [-7.0, 3.0]], 
[[-3.0, 6.0], [-5.0, 2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-9.0, 30.0], [11.0, -16.0]], [[-26.0, -12.0], [25.0, 12.0]], [[31.0, -18.0], [-12.0, 12.0]], [[-13.0, 
26.0], [6.0, 3.0]], [[-6.0, 10.0], [27.0, 2.0]], [[12.0, 35.0], [-2.0, -12.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_array_rank4_offset0(self):
      arg0=numpy.array(6.0)
      arg1=numpy.array([[[[-3.0, 5.0, 5.0, 0.0], [-3.0, -2.0, 4.0, 4.0], [-1.0, 1.0, 6.0, 3.0]], [[-6.0, -5.0, -5.0, -3.0], 
[5.0, 3.0, -2.0, 7.0], [0.0, 6.0, -5.0, -1.0]]], [[[2.0, -4.0, 7.0, 7.0], [3.0, -5.0, -7.0, -7.0], [0.0, 5.0, -1.0, 6.0]], 
[[4.0, 4.0, -3.0, 0.0], [0.0, -4.0, -4.0, -4.0], [-3.0, -4.0, 5.0, 1.0]]], [[[2.0, -3.0, -7.0, -5.0], [-7.0, 3.0, 5.0, 3.0], 
[-3.0, -2.0, 1.0, 7.0]], [[1.0, 2.0, -1.0, 0.0], [0.0, 5.0, 4.0, 3.0], [6.0, -3.0, -5.0, 4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[-18.0, 30.0, 30.0, 0.0], [-18.0, -12.0, 24.0, 24.0], [-6.0, 6.0, 36.0, 18.0]], [[-36.0, -30.0, -30.0, 
-18.0], [30.0, 18.0, -12.0, 42.0], [0.0, 36.0, -30.0, -6.0]]], [[[12.0, -24.0, 42.0, 42.0], [18.0, -30.0, -42.0, -42.0], [0.0, 
30.0, -6.0, 36.0]], [[24.0, 24.0, -18.0, 0.0], [0.0, -24.0, -24.0, -24.0], [-18.0, -24.0, 30.0, 6.0]]], [[[12.0, -18.0, -42.0, 
-30.0], [-42.0, 18.0, 30.0, 18.0], [-18.0, -12.0, 6.0, 42.0]], [[6.0, 12.0, -6.0, 0.0], [0.0, 30.0, 24.0, 18.0], [36.0, -18.0, 
-30.0, 24.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_constData_rank0_offset0(self):
      arg0=numpy.array(3.0)
      arg1=Data(-6.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-18.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank1_offset1(self):
      arg0=numpy.array([-4.0, -7.0, -5.0])
      arg1=Data(numpy.array([-1.0, -3.0, 4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(5.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank2_offset2(self):
      arg0=numpy.array([[2.0, 5.0, 3.0], [-3.0, -2.0, 0.0]])
      arg1=Data(numpy.array([[3.0, 5.0, -1.0], [3.0, 7.0, 3.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(5.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank3_offset3(self):
      arg0=numpy.array([[[5.0, -7.0, 6.0], [4.0, -4.0, -2.0], [-2.0, 3.0, -7.0], [1.0, -7.0, 7.0]], [[6.0, -2.0, -6.0], [6.0, 
-4.0, -1.0], [5.0, 2.0, -6.0], [1.0, -2.0, 2.0]]])
      arg1=Data(numpy.array([[[5.0, -6.0, 4.0], [-4.0, -4.0, -7.0], [-3.0, -6.0, -6.0], [0.0, 4.0, 6.0]], [[-1.0, 1.0, 1.0], 
[3.0, 2.0, -7.0], [-1.0, -6.0, -2.0], [-4.0, -2.0, 1.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(149.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank4_offset4(self):
      arg0=numpy.array([[[[-7.0, 6.0], [4.0, -1.0], [-6.0, 3.0]], [[1.0, -7.0], [-1.0, 3.0], [-7.0, -1.0]]], [[[4.0, -6.0], 
[4.0, 6.0], [6.0, 1.0]], [[3.0, -4.0], [-3.0, 6.0], [0.0, -7.0]]], [[[0.0, 7.0], [1.0, -4.0], [-6.0, -6.0]], [[-6.0, -1.0], 
[6.0, 0.0], [-7.0, -6.0]]], [[[-7.0, -3.0], [-5.0, 0.0], [0.0, 3.0]], [[3.0, 0.0], [0.0, -1.0], [0.0, -4.0]]]])
      arg1=Data(numpy.array([[[[-4.0, 4.0], [-3.0, 3.0], [5.0, 1.0]], [[-3.0, 0.0], [0.0, 5.0], [-7.0, -7.0]]], [[[5.0, -6.0], 
[-6.0, 1.0], [-3.0, -7.0]], [[-6.0, 3.0], [5.0, -4.0], [-4.0, -3.0]]], [[[4.0, 5.0], [7.0, -5.0], [7.0, 5.0]], [[0.0, -2.0], 
[-1.0, 4.0], [-2.0, -5.0]]], [[[2.0, 3.0], [6.0, 0.0], [-7.0, 2.0]], [[0.0, -4.0], [5.0, 1.0], [-6.0, 
7.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(-3.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=4)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_constData_rank1_offset0(self):
      arg0=numpy.array(-5.0)
      arg1=Data(numpy.array([-2.0, 2.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([10.0, -10.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank2_offset1(self):
      arg0=numpy.array([4.0, 3.0, 1.0])
      arg1=Data(numpy.array([[-1.0, 0.0], [-2.0, 1.0], [0.0, 1.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-10.0, 4.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank3_offset2(self):
      arg0=numpy.array([[-3.0, 1.0, 3.0], [-3.0, 4.0, 7.0]])
      arg1=Data(numpy.array([[[1.0, 7.0], [-6.0, -3.0], [2.0, 2.0]], [[-4.0, -2.0], [0.0, 0.0], [-6.0, 
5.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-33.0, 23.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank4_offset3(self):
      arg0=numpy.array([[[6.0, 5.0, 1.0], [-2.0, 5.0, 1.0], [0.0, -4.0, -6.0], [-6.0, 2.0, -1.0]], [[-7.0, -5.0, 0.0], [6.0, 
6.0, -5.0], [-7.0, -2.0, 7.0], [-2.0, 7.0, 1.0]]])
      arg1=Data(numpy.array([[[[7.0, 5.0], [-2.0, 6.0], [6.0, -3.0]], [[0.0, 1.0], [-1.0, 0.0], [-2.0, -4.0]], [[-4.0, -4.0], 
[-5.0, -2.0], [-7.0, 0.0]], [[1.0, -7.0], [1.0, -6.0], [7.0, -3.0]]], [[[-3.0, -1.0], [-5.0, -1.0], [-5.0, -1.0]], [[-2.0, 
0.0], [-7.0, 0.0], [5.0, -5.0]], [[-2.0, -7.0], [2.0, -6.0], [7.0, -4.0]], [[-1.0, -5.0], [3.0, -1.0], [-6.0, 
7.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([125.0, 172.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_constData_rank2_offset0(self):
      arg0=numpy.array(3.0)
      arg1=Data(numpy.array([[6.0, -3.0, -5.0, -3.0, 0.0], [1.0, 6.0, 6.0, 3.0, 0.0], [-6.0, 3.0, 7.0, -5.0, 1.0], [6.0, -1.0, 
2.0, 0.0, -2.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[18.0, -9.0, -15.0, -9.0, 0.0], [3.0, 18.0, 18.0, 9.0, 0.0], [-18.0, 9.0, 21.0, -15.0, 3.0], [18.0, 
-3.0, 6.0, 0.0, -6.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank3_offset1(self):
      arg0=numpy.array([-6.0, 0.0, -1.0])
      arg1=Data(numpy.array([[[-7.0, 6.0, -2.0, -4.0, -7.0], [1.0, 1.0, -1.0, -7.0, 7.0], [5.0, -4.0, -4.0, 0.0, -3.0], [5.0, 
-2.0, -4.0, 0.0, -2.0]], [[2.0, -7.0, 0.0, 3.0, -1.0], [1.0, -7.0, -4.0, 6.0, -2.0], [-4.0, 7.0, 5.0, 1.0, 0.0], [7.0, -1.0, 
-5.0, 7.0, 6.0]], [[-3.0, -5.0, 4.0, -1.0, 6.0], [5.0, -3.0, -7.0, -1.0, -4.0], [7.0, 2.0, 7.0, 3.0, -5.0], [5.0, -6.0, 6.0, 
5.0, -3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[45.0, -31.0, 8.0, 25.0, 36.0], [-11.0, -3.0, 13.0, 43.0, -38.0], [-37.0, 22.0, 17.0, -3.0, 23.0], 
[-35.0, 18.0, 18.0, -5.0, 15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank4_offset2(self):
      arg0=numpy.array([[-2.0, 0.0, 0.0], [6.0, 3.0, 0.0]])
      arg1=Data(numpy.array([[[[1.0, -5.0, -1.0, -5.0, -4.0], [0.0, -4.0, -2.0, 7.0, 2.0], [4.0, 5.0, 0.0, 2.0, -4.0], [1.0, 
-2.0, 1.0, -5.0, 0.0]], [[-1.0, -1.0, 4.0, 6.0, -1.0], [-7.0, 4.0, 2.0, -4.0, 1.0], [-3.0, 1.0, -3.0, -1.0, -6.0], [1.0, -4.0, 
4.0, 0.0, 0.0]], [[0.0, 1.0, 1.0, -7.0, 6.0], [-7.0, -1.0, 3.0, 3.0, 3.0], [3.0, -6.0, 0.0, 6.0, 6.0], [7.0, 0.0, 2.0, 7.0, 
6.0]]], [[[-3.0, -2.0, -5.0, -7.0, 0.0], [0.0, -3.0, 1.0, -1.0, 0.0], [-3.0, -5.0, 2.0, 4.0, -1.0], [-7.0, 3.0, 5.0, -1.0, 
-5.0]], [[-2.0, 0.0, 4.0, -3.0, 0.0], [-3.0, -6.0, 0.0, -7.0, -3.0], [4.0, -6.0, 4.0, 4.0, 2.0], [-5.0, 4.0, -4.0, -1.0, 
-6.0]], [[0.0, 1.0, -5.0, -7.0, 4.0], [3.0, -3.0, -2.0, -4.0, 2.0], [-1.0, -3.0, 4.0, -3.0, 2.0], [2.0, 1.0, 3.0, 0.0, 
-2.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-26.0, -2.0, -16.0, -41.0, 8.0], [-9.0, -28.0, 10.0, -41.0, -13.0], [-14.0, -58.0, 24.0, 32.0, 
8.0], [-59.0, 34.0, 16.0, 1.0, -48.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_constData_rank3_offset0(self):
      arg0=numpy.array(0.0)
      arg1=Data(numpy.array([[[0.0, -1.0], [-3.0, -1.0]], [[5.0, 2.0], [-4.0, 6.0]], [[-5.0, 4.0], [0.0, 7.0]], [[-2.0, -2.0], 
[5.0, 6.0]], [[0.0, 5.0], [1.0, -6.0]], [[-1.0, -3.0], [4.0, 7.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[0.0, -0.0], [-0.0, -0.0]], [[0.0, 0.0], [-0.0, 0.0]], [[-0.0, 0.0], [0.0, 0.0]], [[-0.0, -0.0], 
[0.0, 0.0]], [[0.0, 0.0], [0.0, -0.0]], [[-0.0, -0.0], [0.0, 0.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank4_offset1(self):
      arg0=numpy.array([-2.0, 0.0, 1.0])
      arg1=Data(numpy.array([[[[0.0, 6.0], [5.0, 2.0]], [[-2.0, 2.0], [3.0, 0.0]], [[-2.0, 1.0], [4.0, -6.0]], [[-5.0, 5.0], 
[-6.0, 4.0]], [[-2.0, -5.0], [5.0, 2.0]], [[-2.0, 2.0], [-7.0, 0.0]]], [[[-1.0, -4.0], [-4.0, -2.0]], [[3.0, -6.0], [-7.0, 
4.0]], [[-6.0, -3.0], [-6.0, -3.0]], [[5.0, -2.0], [4.0, -5.0]], [[4.0, -6.0], [7.0, 6.0]], [[-7.0, -4.0], [-4.0, 5.0]]], 
[[[3.0, -2.0], [-3.0, 0.0]], [[4.0, 4.0], [-4.0, 1.0]], [[-4.0, -3.0], [0.0, 2.0]], [[6.0, -3.0], [0.0, -6.0]], [[-1.0, 2.0], 
[5.0, -3.0]], [[6.0, 7.0], [6.0, 4.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[3.0, -14.0], [-13.0, -4.0]], [[8.0, 0.0], [-10.0, 1.0]], [[0.0, -5.0], [-8.0, 14.0]], [[16.0, 
-13.0], [12.0, -14.0]], [[3.0, 12.0], [-5.0, -7.0]], [[10.0, 3.0], [20.0, 4.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_constData_rank4_offset0(self):
      arg0=numpy.array(5.0)
      arg1=Data(numpy.array([[[[0.0, -3.0, -4.0, -5.0], [7.0, 4.0, 4.0, -2.0], [-6.0, 1.0, 6.0, 3.0]], [[2.0, 0.0, 6.0, 7.0], 
[3.0, 7.0, -1.0, -2.0], [6.0, 5.0, 3.0, 5.0]]], [[[-2.0, 1.0, 4.0, 1.0], [6.0, -6.0, -1.0, -4.0], [1.0, 3.0, 7.0, 7.0]], [[7.0, 
-6.0, 0.0, 5.0], [-1.0, -7.0, 3.0, -3.0], [-1.0, 1.0, 2.0, -3.0]]], [[[3.0, -4.0, 6.0, -2.0], [4.0, -2.0, 5.0, 6.0], [4.0, 
-3.0, -2.0, 1.0]], [[1.0, 0.0, -2.0, -4.0], [0.0, -7.0, -6.0, 5.0], [7.0, 7.0, -2.0, 2.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[0.0, -15.0, -20.0, -25.0], [35.0, 20.0, 20.0, -10.0], [-30.0, 5.0, 30.0, 15.0]], [[10.0, 0.0, 
30.0, 35.0], [15.0, 35.0, -5.0, -10.0], [30.0, 25.0, 15.0, 25.0]]], [[[-10.0, 5.0, 20.0, 5.0], [30.0, -30.0, -5.0, -20.0], 
[5.0, 15.0, 35.0, 35.0]], [[35.0, -30.0, 0.0, 25.0], [-5.0, -35.0, 15.0, -15.0], [-5.0, 5.0, 10.0, -15.0]]], [[[15.0, -20.0, 
30.0, -10.0], [20.0, -10.0, 25.0, 30.0], [20.0, -15.0, -10.0, 5.0]], [[5.0, 0.0, -10.0, -20.0], [0.0, -35.0, -30.0, 25.0], 
[35.0, 35.0, -10.0, 10.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_expandedData_rank0_offset0(self):
      arg0=numpy.array(5.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(1.0)+(1-msk_arg1)*(6.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(5.0)+(1.-msk_ref)*numpy.array(30.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank1_offset1(self):
      arg0=numpy.array([1.0, -7.0, 5.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, -2.0, -6.0])+(1.-msk_arg1)*numpy.array([-3.0, -1.0, -2.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-12.0)+(1.-msk_ref)*numpy.array(-6.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank2_offset2(self):
      arg0=numpy.array([[-6.0, 0.0, 0.0], [7.0, -3.0, 5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, 2.0, 6.0], [7.0, 1.0, 2.0]])+(1.-msk_arg1)*numpy.array([[-6.0, 7.0, -6.0], [-7.0, -2.0, 
0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(98.0)+(1.-msk_ref)*numpy.array(-7.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank3_offset3(self):
      arg0=numpy.array([[[-5.0, 1.0, -7.0], [5.0, 1.0, -5.0], [7.0, -5.0, -4.0], [-7.0, 0.0, -7.0]], [[2.0, -1.0, 7.0], [2.0, 
-6.0, -2.0], [-3.0, -7.0, 4.0], [-6.0, 0.0, 6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, 2.0, -2.0], [-5.0, 4.0, 7.0], [1.0, -1.0, 1.0], [2.0, 6.0, -6.0]], [[-7.0, -5.0, 
-4.0], [0.0, -6.0, 3.0], [-5.0, 3.0, -4.0], [7.0, 3.0, -6.0]]])+(1.-msk_arg1)*numpy.array([[[-2.0, 6.0, -1.0], [7.0, 1.0, 
-5.0], [7.0, -1.0, 3.0], [2.0, -6.0, -2.0]], [[5.0, -1.0, -3.0], [-5.0, -3.0, 1.0], [5.0, 4.0, 2.0], [-7.0, 1.0, -2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-81.0)+(1.-msk_ref)*numpy.array(117.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank4_offset4(self):
      arg0=numpy.array([[[[7.0, -1.0], [-7.0, 3.0], [5.0, 4.0]], [[-4.0, 6.0], [-2.0, -4.0], [1.0, -1.0]]], [[[1.0, 0.0], [3.0, 
-3.0], [0.0, 6.0]], [[6.0, -7.0], [-1.0, 7.0], [7.0, 2.0]]], [[[0.0, 4.0], [-4.0, 5.0], [5.0, -3.0]], [[2.0, -3.0], [0.0, 5.0], 
[4.0, 4.0]]], [[[-7.0, 7.0], [-5.0, -1.0], [2.0, -6.0]], [[-3.0, -5.0], [-6.0, 3.0], [6.0, -5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-3.0, 5.0], [-7.0, 0.0], [-5.0, 4.0]], [[6.0, 3.0], [6.0, 4.0], [-3.0, -6.0]]], [[[-4.0, 
3.0], [1.0, 1.0], [-2.0, -5.0]], [[5.0, 2.0], [0.0, 6.0], [3.0, -1.0]]], [[[-4.0, -1.0], [7.0, -6.0], [7.0, -1.0]], [[-1.0, 
0.0], [-6.0, -3.0], [-6.0, -4.0]]], [[[0.0, 0.0], [-5.0, 5.0], [-3.0, 7.0]], [[6.0, 1.0], [-6.0, -3.0], [-2.0, 
-2.0]]]])+(1.-msk_arg1)*numpy.array([[[[4.0, -3.0], [3.0, -1.0], [-4.0, -7.0]], [[7.0, -7.0], [2.0, 6.0], [-7.0, 6.0]]], 
[[[6.0, 0.0], [-1.0, -7.0], [-3.0, -7.0]], [[-7.0, 0.0], [4.0, -4.0], [-6.0, -1.0]]], [[[-6.0, 0.0], [-7.0, 7.0], [-7.0, 
-6.0]], [[5.0, -5.0], [-7.0, 1.0], [3.0, 0.0]]], [[[-2.0, -5.0], [0.0, 2.0], [7.0, 6.0]], [[4.0, 2.0], [1.0, 3.0], [7.0, 
-5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-81.0)+(1.-msk_ref)*numpy.array(-197.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_expandedData_rank1_offset0(self):
      arg0=numpy.array(-3.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-4.0, 7.0])+(1.-msk_arg1)*numpy.array([0.0, -2.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([12.0, -21.0])+(1.-msk_ref)*numpy.array([-0.0, 6.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank2_offset1(self):
      arg0=numpy.array([-6.0, -6.0, -4.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, 5.0], [7.0, -4.0], [-1.0, 0.0]])+(1.-msk_arg1)*numpy.array([[1.0, 6.0], [6.0, -1.0], 
[1.0, 5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-14.0, -6.0])+(1.-msk_ref)*numpy.array([-46.0, -50.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank3_offset2(self):
      arg0=numpy.array([[-1.0, -3.0, -5.0], [5.0, -7.0, 5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-3.0, 7.0], [3.0, 0.0], [-2.0, 3.0]], [[-7.0, 0.0], [6.0, -5.0], [3.0, 
3.0]]])+(1.-msk_arg1)*numpy.array([[[6.0, -4.0], [0.0, 6.0], [-6.0, -3.0]], [[2.0, -7.0], [-4.0, 3.0], [-4.0, -5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-58.0, 28.0])+(1.-msk_ref)*numpy.array([42.0, -80.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank4_offset3(self):
      arg0=numpy.array([[[-5.0, 3.0, 6.0], [-2.0, 7.0, -4.0], [0.0, 4.0, 5.0], [0.0, -7.0, -5.0]], [[0.0, -6.0, 3.0], [-1.0, 
-3.0, 5.0], [-6.0, 0.0, -2.0], [-6.0, -7.0, 6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[0.0, -4.0], [-5.0, 6.0], [2.0, 6.0]], [[-6.0, 0.0], [1.0, 6.0], [0.0, -5.0]], [[-2.0, 
-4.0], [-1.0, -4.0], [-7.0, -6.0]], [[2.0, 2.0], [-3.0, 5.0], [-7.0, -1.0]]], [[[6.0, 6.0], [-2.0, -6.0], [4.0, -5.0]], [[2.0, 
5.0], [7.0, -5.0], [0.0, -3.0]], [[2.0, 1.0], [7.0, 4.0], [1.0, 4.0]], [[-2.0, -6.0], [3.0, -1.0], [4.0, 
3.0]]]])+(1.-msk_arg1)*numpy.array([[[[5.0, 2.0], [-1.0, -5.0], [3.0, -3.0]], [[6.0, 5.0], [-6.0, 0.0], [6.0, 2.0]], [[3.0, 
-1.0], [6.0, 4.0], [4.0, 0.0]], [[-7.0, 4.0], [-2.0, -1.0], [-4.0, -2.0]]], [[[-3.0, -6.0], [-3.0, -6.0], [1.0, 4.0]], [[-3.0, 
-7.0], [-5.0, -5.0], [2.0, 4.0]], [[7.0, -4.0], [-6.0, -4.0], [-2.0, -7.0]], [[-4.0, 7.0], [-6.0, 2.0], [5.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([35.0, 123.0])+(1.-msk_ref)*numpy.array([97.0, 50.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_expandedData_rank2_offset0(self):
      arg0=numpy.array(-6.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[3.0, -3.0, -5.0, 4.0, 3.0], [-3.0, -7.0, 1.0, 0.0, 4.0], [-1.0, 5.0, -3.0, 5.0, 3.0], [-1.0, 
-3.0, -1.0, 0.0, -7.0]])+(1.-msk_arg1)*numpy.array([[0.0, 4.0, 5.0, -5.0, -6.0], [4.0, 2.0, 0.0, 1.0, 0.0], [5.0, 1.0, 0.0, 
-6.0, 5.0], [1.0, 0.0, -3.0, -1.0, 3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-18.0, 18.0, 30.0, -24.0, -18.0], [18.0, 42.0, -6.0, -0.0, -24.0], [6.0, -30.0, 18.0, -30.0, 
-18.0], [6.0, 18.0, 6.0, -0.0, 42.0]])+(1.-msk_ref)*numpy.array([[-0.0, -24.0, -30.0, 30.0, 36.0], [-24.0, -12.0, -0.0, -6.0, 
-0.0], [-30.0, -6.0, -0.0, 36.0, -30.0], [-6.0, -0.0, 18.0, 6.0, -18.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank3_offset1(self):
      arg0=numpy.array([6.0, 7.0, 7.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[6.0, -5.0, -7.0, -5.0, 5.0], [2.0, 2.0, 0.0, 0.0, -3.0], [-2.0, 4.0, -4.0, 4.0, -6.0], 
[-3.0, 0.0, -5.0, -6.0, 4.0]], [[-2.0, 7.0, 6.0, 5.0, 5.0], [-6.0, 0.0, -3.0, 2.0, 5.0], [1.0, 1.0, -2.0, 6.0, 7.0], [-1.0, 
-6.0, -4.0, 5.0, -2.0]], [[-5.0, -5.0, 5.0, -2.0, 4.0], [0.0, -4.0, -3.0, 0.0, 4.0], [0.0, -6.0, 5.0, 3.0, 4.0], [-5.0, -4.0, 
-4.0, 1.0, 2.0]]])+(1.-msk_arg1)*numpy.array([[[1.0, 7.0, 7.0, -3.0, 6.0], [3.0, 1.0, 5.0, -5.0, 0.0], [6.0, -5.0, -7.0, 1.0, 
4.0], [-1.0, 0.0, 3.0, 5.0, 0.0]], [[3.0, 7.0, -7.0, 4.0, 7.0], [2.0, -5.0, 7.0, -7.0, 1.0], [-2.0, -3.0, 4.0, 1.0, 6.0], [1.0, 
6.0, -4.0, 3.0, 5.0]], [[1.0, 0.0, -6.0, -5.0, 3.0], [-5.0, 2.0, 4.0, -1.0, 5.0], [-6.0, -5.0, 7.0, -6.0, -3.0], [-6.0, -1.0, 
5.0, -2.0, 4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-13.0, -16.0, 35.0, -9.0, 93.0], [-30.0, -16.0, -42.0, 14.0, 45.0], [-5.0, -11.0, -3.0, 87.0, 
41.0], [-60.0, -70.0, -86.0, 6.0, 24.0]])+(1.-msk_ref)*numpy.array([[34.0, 91.0, -49.0, -25.0, 106.0], [-3.0, -15.0, 107.0, 
-86.0, 42.0], [-20.0, -86.0, 35.0, -29.0, 45.0], [-41.0, 35.0, 25.0, 37.0, 63.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank4_offset2(self):
      arg0=numpy.array([[-6.0, -2.0, 0.0], [-2.0, 0.0, 0.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[7.0, 3.0, 7.0, -7.0, 3.0], [-2.0, -2.0, 0.0, -7.0, 2.0], [-2.0, -6.0, 4.0, 2.0, -2.0], 
[-4.0, 4.0, 3.0, 7.0, -3.0]], [[5.0, 1.0, 0.0, -1.0, 7.0], [5.0, 2.0, 0.0, 4.0, 0.0], [5.0, -7.0, 3.0, 5.0, -4.0], [3.0, -1.0, 
7.0, 0.0, -2.0]], [[4.0, -7.0, 3.0, 0.0, 0.0], [3.0, 2.0, 4.0, 3.0, -2.0], [5.0, -2.0, -6.0, 5.0, -4.0], [-4.0, -6.0, 0.0, 
-7.0, -2.0]]], [[[5.0, 7.0, -2.0, 5.0, 3.0], [7.0, 0.0, 5.0, 1.0, -2.0], [0.0, 7.0, 1.0, 5.0, -4.0], [5.0, 7.0, 0.0, 2.0, 
5.0]], [[6.0, 6.0, 4.0, -4.0, -6.0], [-3.0, 0.0, -4.0, 7.0, 4.0], [7.0, 3.0, 0.0, -6.0, -7.0], [6.0, 3.0, 0.0, -7.0, 4.0]], 
[[-2.0, 2.0, 0.0, 2.0, 0.0], [-4.0, 0.0, 0.0, 2.0, 3.0], [-7.0, -6.0, 1.0, -7.0, -4.0], [7.0, 4.0, 0.0, 0.0, 
-3.0]]]])+(1.-msk_arg1)*numpy.array([[[[7.0, 7.0, 2.0, -7.0, 0.0], [1.0, -7.0, 0.0, -4.0, 5.0], [-7.0, -3.0, 0.0, 3.0, -3.0], 
[5.0, -4.0, 7.0, -1.0, 3.0]], [[5.0, 4.0, 5.0, 4.0, 3.0], [2.0, 4.0, -7.0, 1.0, -5.0], [-1.0, -7.0, 5.0, 0.0, -3.0], [-2.0, 
1.0, 1.0, 0.0, 6.0]], [[-3.0, 0.0, 7.0, -5.0, -5.0], [3.0, -4.0, 3.0, 5.0, -7.0], [-7.0, -2.0, 7.0, 7.0, -4.0], [0.0, -3.0, 
0.0, -7.0, -4.0]]], [[[-3.0, -4.0, 0.0, -7.0, -1.0], [-7.0, 6.0, -7.0, 6.0, 6.0], [7.0, 0.0, 6.0, -3.0, 0.0], [0.0, 4.0, 1.0, 
1.0, -2.0]], [[0.0, 0.0, 4.0, 4.0, 7.0], [0.0, -5.0, 2.0, -7.0, 4.0], [-3.0, -4.0, -3.0, 2.0, 7.0], [-1.0, -7.0, -7.0, 7.0, 
0.0]], [[-7.0, 5.0, -3.0, 1.0, 3.0], [-6.0, -1.0, -6.0, -5.0, -6.0], [-2.0, 6.0, -3.0, 4.0, 0.0], [0.0, -1.0, -2.0, 6.0, 
-7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-62.0, -34.0, -38.0, 34.0, -38.0], [-12.0, 8.0, -10.0, 32.0, -8.0], [2.0, 36.0, -32.0, -32.0, 
28.0], [8.0, -36.0, -32.0, -46.0, 12.0]])+(1.-msk_ref)*numpy.array([[-46.0, -42.0, -22.0, 48.0, -4.0], [4.0, 22.0, 28.0, 10.0, 
-32.0], [30.0, 32.0, -22.0, -12.0, 24.0], [-26.0, 14.0, -46.0, 4.0, -26.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_expandedData_rank3_offset0(self):
      arg0=numpy.array(-5.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-5.0, 0.0], [2.0, -6.0]], [[-4.0, 0.0], [-1.0, -5.0]], [[-2.0, 6.0], [-2.0, -4.0]], [[-4.0, 
4.0], [-2.0, -6.0]], [[0.0, 3.0], [2.0, -1.0]], [[6.0, 7.0], [-3.0, 7.0]]])+(1.-msk_arg1)*numpy.array([[[7.0, 4.0], [5.0, 
5.0]], [[-5.0, -1.0], [-1.0, 2.0]], [[2.0, -2.0], [0.0, 6.0]], [[-5.0, 6.0], [-2.0, 0.0]], [[4.0, 4.0], [0.0, 5.0]], [[-5.0, 
-3.0], [4.0, 2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[25.0, -0.0], [-10.0, 30.0]], [[20.0, -0.0], [5.0, 25.0]], [[10.0, -30.0], [10.0, 20.0]], 
[[20.0, -20.0], [10.0, 30.0]], [[-0.0, -15.0], [-10.0, 5.0]], [[-30.0, -35.0], [15.0, 
-35.0]]])+(1.-msk_ref)*numpy.array([[[-35.0, -20.0], [-25.0, -25.0]], [[25.0, 5.0], [5.0, -10.0]], [[-10.0, 10.0], [-0.0, 
-30.0]], [[25.0, -30.0], [10.0, -0.0]], [[-20.0, -20.0], [-0.0, -25.0]], [[25.0, 15.0], [-20.0, -10.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=numpy.array(arg0*1j)
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=0)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank4_offset1(self):
      arg0=numpy.array([-5.0, -6.0, -3.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[6.0, 0.0], [-5.0, 0.0]], [[6.0, -3.0], [4.0, -4.0]], [[-3.0, 6.0], [0.0, 4.0]], [[-6.0, 
-4.0], [-7.0, 7.0]], [[7.0, -7.0], [-7.0, 1.0]], [[-4.0, 5.0], [0.0, 0.0]]], [[[0.0, 2.0], [0.0, 2.0]], [[-2.0, 0.0], [-5.0, 
-1.0]], [[5.0, 5.0], [-7.0, -3.0]], [[-7.0, 0.0], [7.0, -5.0]], [[1.0, -7.0], [5.0, 2.0]], [[-2.0, 4.0], [-3.0, -3.0]]], 
[[[-6.0, 7.0], [1.0, 6.0]], [[0.0, 5.0], [4.0, -1.0]], [[-6.0, -3.0], [5.0, -1.0]], [[0.0, 5.0], [2.0, -1.0]], [[-3.0, 5.0], 
[7.0, 2.0]], [[6.0, 0.0], [-5.0, 1.0]]]])+(1.-msk_arg1)*numpy.array([[[[1.0, -2.0], [-6.0, -2.0]], [[-3.0, 0.0], [4.0, 0.0]], 
[[-4.0, 1.0], [2.0, 3.0]], [[0.0, 2.0], [-4.0, -2.0]], [[2.0, 0.0], [3.0, 4.0]], [[0.0, 7.0], [2.0, -7.0]]], [[[2.0, 2.0], 
[7.0, 5.0]], [[-2.0, 7.0], [0.0, 3.0]], [[4.0, 7.0], [0.0, 1.0]], [[-3.0, 5.0], [6.0, 4.0]], [[-4.0, 0.0], [4.0, -5.0]], 
[[-2.0, 6.0], [3.0, -1.0]]], [[[7.0, -1.0], [4.0, 7.0]], [[-6.0, 0.0], [-3.0, 1.0]], [[-1.0, 1.0], [6.0, -3.0]], [[-4.0, 1.0], 
[0.0, -1.0]], [[1.0, 7.0], [4.0, 4.0]], [[-4.0, -3.0], [-2.0, 7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-12.0, -33.0], [22.0, -30.0]], [[-18.0, 0.0], [-2.0, 29.0]], [[3.0, -51.0], [27.0, 1.0]], 
[[72.0, 5.0], [-13.0, -2.0]], [[-32.0, 62.0], [-16.0, -23.0]], [[14.0, -49.0], [33.0, 
15.0]]])+(1.-msk_ref)*numpy.array([[[-38.0, 1.0], [-24.0, -41.0]], [[45.0, -42.0], [-11.0, -21.0]], [[-1.0, -50.0], [-28.0, 
-12.0]], [[30.0, -43.0], [-16.0, -11.0]], [[11.0, -21.0], [-51.0, -2.0]], [[24.0, -62.0], [-22.0, 20.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=numpy.array(arg0*1j)
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank0_expandedData_rank4_offset0(self):
      arg0=numpy.array(-1.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-2.0, -3.0, 4.0, -1.0], [7.0, 1.0, -3.0, 1.0], [2.0, -3.0, 0.0, 5.0]], [[3.0, 4.0, 4.0, 
1.0], [-7.0, 0.0, 6.0, -6.0], [4.0, -4.0, -2.0, 1.0]]], [[[-7.0, 5.0, 0.0, -5.0], [-5.0, 0.0, 5.0, -5.0], [-4.0, 1.0, -6.0, 
-1.0]], [[-7.0, -5.0, -3.0, 2.0], [-2.0, 0.0, -7.0, -7.0], [0.0, -6.0, -1.0, 5.0]]], [[[-2.0, 6.0, 5.0, -5.0], [2.0, 4.0, -6.0, 
-4.0], [-5.0, 4.0, -6.0, 7.0]], [[5.0, 4.0, 4.0, -2.0], [7.0, 3.0, -1.0, -2.0], [-1.0, 6.0, 6.0, 
0.0]]]])+(1.-msk_arg1)*numpy.array([[[[-3.0, -7.0, 0.0, -5.0], [4.0, 5.0, -1.0, 5.0], [5.0, 2.0, 7.0, 1.0]], [[7.0, 0.0, -6.0, 
6.0], [-5.0, 0.0, 0.0, 5.0], [-5.0, 7.0, -5.0, 1.0]]], [[[0.0, -1.0, 5.0, 5.0], [4.0, 1.0, 5.0, 2.0], [0.0, -2.0, 3.0, 5.0]], 
[[-5.0, 4.0, 2.0, -4.0], [0.0, 0.0, -2.0, -6.0], [7.0, 6.0, 0.0, 5.0]]], [[[-3.0, 5.0, 0.0, -6.0], [7.0, -2.0, -5.0, -4.0], 
[-2.0, 7.0, -4.0, -2.0]], [[-4.0, 1.0, 6.0, 0.0], [1.0, 3.0, 7.0, 0.0], [-3.0, -1.0, -2.0, -3.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[2.0, 3.0, -4.0, 1.0], [-7.0, -1.0, 3.0, -1.0], [-2.0, 3.0, -0.0, -5.0]], [[-3.0, -4.0, -4.0, 
-1.0], [7.0, -0.0, -6.0, 6.0], [-4.0, 4.0, 2.0, -1.0]]], [[[7.0, -5.0, -0.0, 5.0], [5.0, -0.0, -5.0, 5.0], [4.0, -1.0, 6.0, 
1.0]], [[7.0, 5.0, 3.0, -2.0], [2.0, -0.0, 7.0, 7.0], [-0.0, 6.0, 1.0, -5.0]]], [[[2.0, -6.0, -5.0, 5.0], [-2.0, -4.0, 6.0, 
4.0], [5.0, -4.0, 6.0, -7.0]], [[-5.0, -4.0, -4.0, 2.0], [-7.0, -3.0, 1.0, 2.0], [1.0, -6.0, -6.0, 
-0.0]]]])+(1.-msk_ref)*numpy.array([[[[3.0, 7.0, -0.0, 5.0], [-4.0, -5.0, 1.0, -5.0], [-5.0, -2.0, -7.0, -1.0]], [[-7.0, -0.0, 
6.0, -6.0], [5.0, -0.0, -0.0, -5.0], [5.0, -7.0, 5.0, -1.0]]], [[[-0.0, 1.0, -5.0, -5.0], [-4.0, -1.0, -5.0, -2.0], [-0.0, 2.0, 
-3.0, -5.0]], [[5.0, -4.0, -2.0, 4.0], [-0.0, -0.0, 2.0, 6.0], [-7.0, -6.0, -0.0, -5.0]]], [[[3.0, -5.0, -0.0, 6.0], [-7.0, 
2.0, 5.0, 4.0], [2.0, -7.0, 4.0, 2.0]], [[4.0, -1.0, -6.0, -0.0], [-1.0, -3.0, -7.0, -0.0], [3.0, 1.0, 2.0, 3.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_float_rank0_offset0(self):
      arg0=numpy.array([4.0, -3.0])
      arg1=3.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([12.0, -9.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank0_offset0(self):
      arg0=numpy.array([3.0, 5.0])
      arg1=numpy.array(4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([12.0, 20.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank1_offset1(self):
      arg0=numpy.array([[0.0, 3.0, -3.0], [3.0, 5.0, 0.0]])
      arg1=numpy.array([3.0, 3.0, -1.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([12.0, 24.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank2_offset2(self):
      arg0=numpy.array([[[-3.0, -7.0, 5.0], [2.0, -2.0, 0.0]], [[-1.0, 0.0, 0.0], [-6.0, -5.0, -1.0]]])
      arg1=numpy.array([[-3.0, -4.0, 0.0], [-1.0, -7.0, -5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([49.0, 49.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank3_offset3(self):
      arg0=numpy.array([[[[4.0, -5.0, 6.0], [7.0, 5.0, 0.0], [0.0, -5.0, -3.0], [-3.0, -2.0, -2.0]], [[4.0, 1.0, -4.0], [-1.0, 
-1.0, 0.0], [1.0, 0.0, 6.0], [-5.0, 2.0, -6.0]]], [[[1.0, 2.0, 6.0], [2.0, 7.0, -6.0], [7.0, -6.0, 0.0], [-3.0, 0.0, -6.0]], 
[[2.0, 1.0, 3.0], [4.0, -4.0, 7.0], [5.0, 0.0, -4.0], [1.0, 0.0, 4.0]]]])
      arg1=numpy.array([[[-1.0, 7.0, 2.0], [-3.0, -4.0, -6.0], [7.0, -5.0, -5.0], [0.0, -1.0, -4.0]], [[6.0, -3.0, -5.0], 
[-2.0, 2.0, -1.0], [4.0, -1.0, -7.0], [-4.0, 5.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([33.0, 133.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank1_offset0(self):
      arg0=numpy.array([-2.0, 0.0])
      arg1=numpy.array([-2.0, -1.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[4.0, 2.0], [0.0, 0.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank2_offset1(self):
      arg0=numpy.array([[-3.0, 4.0, 6.0], [-1.0, 2.0, -1.0]])
      arg1=numpy.array([[-4.0, -1.0], [-6.0, -7.0], [7.0, -7.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[30.0, -67.0], [-15.0, -6.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank3_offset2(self):
      arg0=numpy.array([[[-4.0, 7.0, 7.0], [-7.0, -7.0, -5.0]], [[-6.0, 0.0, -3.0], [-3.0, 4.0, 4.0]]])
      arg1=numpy.array([[[-2.0, 7.0], [2.0, -6.0], [-1.0, 7.0]], [[3.0, 6.0], [7.0, 0.0], [5.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[-80.0, -63.0], [54.0, -81.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank4_offset3(self):
      arg0=numpy.array([[[[-6.0, -2.0, -4.0], [1.0, -5.0, -2.0], [0.0, -3.0, -2.0], [0.0, -5.0, 5.0]], [[-3.0, 0.0, 7.0], 
[-4.0, 4.0, -7.0], [-1.0, 0.0, 5.0], [0.0, -1.0, 6.0]]], [[[-4.0, 4.0, 4.0], [-4.0, -7.0, 5.0], [3.0, 4.0, 5.0], [0.0, -3.0, 
0.0]], [[-7.0, -6.0, -5.0], [-5.0, -6.0, 0.0], [-7.0, -6.0, -7.0], [-4.0, -6.0, -1.0]]]])
      arg1=numpy.array([[[[-7.0, 0.0], [3.0, -4.0], [7.0, 5.0]], [[7.0, -1.0], [7.0, -4.0], [-7.0, 4.0]], [[-6.0, 1.0], [1.0, 
7.0], [1.0, -4.0]], [[-7.0, 3.0], [1.0, -7.0], [7.0, -1.0]]], [[[7.0, -4.0], [-1.0, 3.0], [-6.0, 6.0]], [[-7.0, -2.0], [-5.0, 
0.0], [-4.0, 6.0]], [[4.0, 0.0], [-1.0, -1.0], [5.0, 0.0]], [[0.0, -4.0], [0.0, 3.0], [1.0, -6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([[19.0, -3.0], [-62.0, 88.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank2_offset0(self):
      arg0=numpy.array([0.0, -5.0])
      arg1=numpy.array([[-4.0, 0.0, -6.0, -3.0, 0.0], [1.0, 5.0, -4.0, 6.0, 0.0], [7.0, -6.0, 0.0, -4.0, 5.0], [-6.0, 2.0, 
-6.0, 0.0, -6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0]], [[20.0, 0.0, 30.0, 15.0, 0.0], [-5.0, -25.0, 20.0, -30.0, 0.0], [-35.0, 30.0, 0.0, 20.0, -25.0], [30.0, -10.0, 30.0, 
0.0, 30.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank3_offset1(self):
      arg0=numpy.array([[-6.0, 3.0, -1.0], [2.0, -2.0, -4.0]])
      arg1=numpy.array([[[7.0, 2.0, -5.0, -1.0, -4.0], [-5.0, 7.0, -1.0, -2.0, -7.0], [4.0, 3.0, -2.0, -6.0, -4.0], [0.0, 0.0, 
-4.0, -3.0, 7.0]], [[4.0, 0.0, 0.0, -2.0, 0.0], [6.0, 7.0, 7.0, 0.0, 7.0], [0.0, 0.0, 2.0, 5.0, 0.0], [-7.0, 0.0, 3.0, -3.0, 
0.0]], [[-2.0, -7.0, -4.0, 4.0, -5.0], [-3.0, -5.0, -4.0, -5.0, -3.0], [4.0, -5.0, -1.0, 0.0, 7.0], [1.0, 4.0, -5.0, 6.0, 
-5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-28.0, -5.0, 34.0, -4.0, 29.0], [51.0, -16.0, 31.0, 17.0, 66.0], [-28.0, -13.0, 19.0, 51.0, 17.0], 
[-22.0, -4.0, 38.0, 3.0, -37.0]], [[14.0, 32.0, 6.0, -14.0, 12.0], [-10.0, 20.0, 0.0, 16.0, -16.0], [-8.0, 26.0, -4.0, -22.0, 
-36.0], [10.0, -16.0, 6.0, -24.0, 34.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank4_offset2(self):
      arg0=numpy.array([[[-3.0, 7.0, 0.0], [7.0, 0.0, -7.0]], [[7.0, 4.0, -2.0], [-1.0, 6.0, 1.0]]])
      arg1=numpy.array([[[[0.0, -6.0, 1.0, -1.0, -6.0], [1.0, 5.0, -2.0, -5.0, -7.0], [6.0, -4.0, 0.0, -7.0, -5.0], [0.0, 0.0, 
4.0, -1.0, -6.0]], [[-4.0, 1.0, 1.0, 5.0, -4.0], [5.0, -4.0, 3.0, -3.0, 7.0], [-2.0, -7.0, -3.0, 7.0, -3.0], [7.0, -1.0, 0.0, 
-2.0, -6.0]], [[1.0, 3.0, 0.0, -7.0, 2.0], [0.0, 0.0, 5.0, -6.0, 0.0], [-2.0, -5.0, 1.0, -2.0, -4.0], [-7.0, 0.0, 6.0, 3.0, 
-7.0]]], [[[-6.0, 4.0, 1.0, 1.0, 0.0], [7.0, -4.0, -2.0, 0.0, 3.0], [-1.0, -3.0, -3.0, -4.0, 4.0], [-7.0, 5.0, -2.0, 0.0, 
0.0]], [[-6.0, 0.0, -7.0, -7.0, -6.0], [-2.0, -1.0, 6.0, 0.0, 3.0], [-5.0, -3.0, 0.0, -5.0, -7.0], [5.0, -7.0, -5.0, -3.0, 
-2.0]], [[0.0, 3.0, -6.0, 5.0, 0.0], [2.0, -2.0, -4.0, 6.0, 4.0], [-1.0, -3.0, 6.0, 6.0, 2.0], [0.0, 3.0, 4.0, 1.0, -1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[-70.0, 32.0, 53.0, 10.0, -10.0], [67.0, -57.0, 41.0, -48.0, 63.0], [-32.0, -37.0, -84.0, 0.0, 8.0], 
[0.0, 7.0, -54.0, -18.0, -17.0]], [[-48.0, -45.0, -38.0, -11.0, -98.0], [10.0, 15.0, 22.0, -29.0, -2.0], [8.0, -64.0, -5.0, 
-37.0, -83.0], [79.0, -48.0, -8.0, -38.0, -65.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_array_rank3_offset0(self):
      arg0=numpy.array([1.0, 5.0])
      arg1=numpy.array([[[4.0, 3.0], [6.0, 0.0]], [[0.0, 0.0], [5.0, 4.0]], [[-5.0, 1.0], [-7.0, -2.0]], [[4.0, -7.0], [7.0, 
-2.0]], [[5.0, 2.0], [-3.0, 1.0]], [[0.0, 4.0], [-1.0, -5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[4.0, 3.0], [6.0, 0.0]], [[0.0, 0.0], [5.0, 4.0]], [[-5.0, 1.0], [-7.0, -2.0]], [[4.0, -7.0], [7.0, 
-2.0]], [[5.0, 2.0], [-3.0, 1.0]], [[0.0, 4.0], [-1.0, -5.0]]], [[[20.0, 15.0], [30.0, 0.0]], [[0.0, 0.0], [25.0, 20.0]], 
[[-25.0, 5.0], [-35.0, -10.0]], [[20.0, -35.0], [35.0, -10.0]], [[25.0, 10.0], [-15.0, 5.0]], [[0.0, 20.0], [-5.0, -25.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank4_offset1(self):
      arg0=numpy.array([[-7.0, 4.0, -6.0], [-2.0, -3.0, -7.0]])
      arg1=numpy.array([[[[3.0, 1.0], [-1.0, 2.0]], [[2.0, 2.0], [0.0, 1.0]], [[-5.0, 2.0], [-2.0, 1.0]], [[-1.0, 7.0], [7.0, 
5.0]], [[1.0, 0.0], [-5.0, -6.0]], [[-3.0, -1.0], [-7.0, -7.0]]], [[[-7.0, 4.0], [-2.0, 5.0]], [[5.0, -1.0], [-2.0, 7.0]], 
[[5.0, -2.0], [0.0, 5.0]], [[7.0, -3.0], [0.0, 0.0]], [[1.0, 2.0], [4.0, 7.0]], [[3.0, 0.0], [5.0, 5.0]]], [[[-7.0, -6.0], 
[-7.0, 3.0]], [[1.0, -6.0], [4.0, -7.0]], [[1.0, -7.0], [-5.0, -1.0]], [[0.0, -1.0], [-3.0, -7.0]], [[5.0, 4.0], [-1.0, -5.0]], 
[[4.0, 6.0], [2.0, -7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[-7.0, 45.0], [41.0, -12.0]], [[0.0, 18.0], [-32.0, 63.0]], [[49.0, 20.0], [44.0, 19.0]], [[35.0, 
-55.0], [-31.0, 7.0]], [[-33.0, -16.0], [57.0, 100.0]], [[9.0, -29.0], [57.0, 111.0]]], [[[64.0, 28.0], [57.0, -40.0]], 
[[-26.0, 41.0], [-22.0, 26.0]], [[-12.0, 51.0], [39.0, -10.0]], [[-19.0, 2.0], [7.0, 39.0]], [[-40.0, -34.0], [5.0, 26.0]], 
[[-31.0, -40.0], [-15.0, 48.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank0_offset0(self):
      arg0=numpy.array([0.0, -5.0])
      arg1=Data(-7.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-0.0, 35.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank1_offset1(self):
      arg0=numpy.array([[-4.0, 0.0, 7.0], [-1.0, -7.0, -4.0]])
      arg1=Data(numpy.array([-5.0, -6.0, -3.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-1.0, 59.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank2_offset2(self):
      arg0=numpy.array([[[-1.0, -6.0, 7.0], [-2.0, -7.0, 4.0]], [[-4.0, 1.0, -7.0], [-2.0, -4.0, 7.0]]])
      arg1=Data(numpy.array([[0.0, -5.0, -2.0], [-1.0, 7.0, 0.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-31.0, -17.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank3_offset3(self):
      arg0=numpy.array([[[[-3.0, 3.0, 5.0], [-4.0, -2.0, 7.0], [-1.0, -1.0, -1.0], [-6.0, -3.0, 6.0]], [[-7.0, -7.0, 1.0], 
[-5.0, -1.0, -5.0], [4.0, 2.0, 0.0], [-7.0, 1.0, 1.0]]], [[[7.0, -7.0, 3.0], [1.0, -7.0, 0.0], [-4.0, -7.0, 4.0], [-6.0, 0.0, 
1.0]], [[-3.0, -3.0, 5.0], [-1.0, 1.0, 2.0], [5.0, 0.0, -6.0], [-3.0, 5.0, -5.0]]]])
      arg1=Data(numpy.array([[[-2.0, -5.0, 0.0], [2.0, 7.0, -4.0], [-2.0, -3.0, 5.0], [-2.0, -3.0, -3.0]], [[3.0, 0.0, 2.0], 
[-5.0, 0.0, 3.0], [5.0, -6.0, -7.0], [3.0, 6.0, 0.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([-72.0, 132.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank1_offset0(self):
      arg0=numpy.array([-7.0, 0.0])
      arg1=Data(numpy.array([-3.0, 4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[21.0, -28.0], [0.0, 0.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank2_offset1(self):
      arg0=numpy.array([[1.0, -2.0, -6.0], [3.0, -1.0, 2.0]])
      arg1=Data(numpy.array([[1.0, 3.0], [4.0, -1.0], [-1.0, 2.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-1.0, -7.0], [-3.0, 14.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank3_offset2(self):
      arg0=numpy.array([[[-1.0, -6.0, 0.0], [-2.0, 0.0, 7.0]], [[-5.0, 5.0, 3.0], [-1.0, -4.0, -3.0]]])
      arg1=Data(numpy.array([[[1.0, 0.0], [-3.0, -4.0], [-2.0, -5.0]], [[6.0, 0.0], [3.0, -1.0], [3.0, 
-6.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[26.0, -18.0], [-53.0, -13.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank4_offset3(self):
      arg0=numpy.array([[[[-5.0, -5.0, 6.0], [-7.0, -7.0, 5.0], [1.0, 6.0, -7.0], [0.0, 1.0, -4.0]], [[-6.0, -7.0, 3.0], [2.0, 
-3.0, -7.0], [-3.0, -2.0, -4.0], [4.0, -4.0, -4.0]]], [[[-3.0, 0.0, 6.0], [-2.0, 0.0, 7.0], [-4.0, -6.0, -3.0], [1.0, -5.0, 
-6.0]], [[5.0, 7.0, -5.0], [3.0, -2.0, 6.0], [-7.0, -1.0, -7.0], [-4.0, 6.0, 5.0]]]])
      arg1=Data(numpy.array([[[[7.0, -7.0], [5.0, 4.0], [4.0, -4.0]], [[4.0, 0.0], [6.0, -7.0], [-5.0, 6.0]], [[-4.0, -6.0], 
[-3.0, -5.0], [0.0, 1.0]], [[1.0, -5.0], [-7.0, -4.0], [0.0, -5.0]]], [[[4.0, 1.0], [-2.0, -4.0], [-7.0, 7.0]], [[1.0, 4.0], 
[-4.0, 0.0], [3.0, 2.0]], [[2.0, 4.0], [1.0, 5.0], [4.0, -2.0]], [[7.0, 3.0], [-3.0, 5.0], [-4.0, 2.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([[-166.0, 50.0], [-9.0, 110.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank2_offset0(self):
      arg0=numpy.array([-4.0, -3.0])
      arg1=Data(numpy.array([[5.0, -4.0, 2.0, 7.0, 4.0], [3.0, -1.0, 7.0, -6.0, 2.0], [6.0, 0.0, 6.0, -4.0, 6.0], [-6.0, -5.0, 
-6.0, 3.0, -4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-20.0, 16.0, -8.0, -28.0, -16.0], [-12.0, 4.0, -28.0, 24.0, -8.0], [-24.0, 0.0, -24.0, 16.0, 
-24.0], [24.0, 20.0, 24.0, -12.0, 16.0]], [[-15.0, 12.0, -6.0, -21.0, -12.0], [-9.0, 3.0, -21.0, 18.0, -6.0], [-18.0, 0.0, 
-18.0, 12.0, -18.0], [18.0, 15.0, 18.0, -9.0, 12.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank3_offset1(self):
      arg0=numpy.array([[0.0, 6.0, 4.0], [-5.0, -3.0, -4.0]])
      arg1=Data(numpy.array([[[0.0, 7.0, -6.0, 2.0, -7.0], [6.0, -4.0, -2.0, -2.0, 6.0], [-7.0, -5.0, -6.0, 7.0, -5.0], [-1.0, 
0.0, 3.0, -2.0, -7.0]], [[-7.0, -1.0, -4.0, 3.0, 0.0], [6.0, -6.0, 2.0, 4.0, 5.0], [0.0, -3.0, -6.0, 1.0, -1.0], [-7.0, -3.0, 
0.0, 5.0, -5.0]], [[-6.0, -7.0, -3.0, 4.0, 1.0], [0.0, 3.0, -1.0, 3.0, 0.0], [-7.0, 6.0, -5.0, -4.0, -7.0], [6.0, 3.0, 3.0, 
7.0, 5.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-66.0, -34.0, -36.0, 34.0, 4.0], [36.0, -24.0, 8.0, 36.0, 30.0], [-28.0, 6.0, -56.0, -10.0, 
-34.0], [-18.0, -6.0, 12.0, 58.0, -10.0]], [[45.0, -4.0, 54.0, -35.0, 31.0], [-48.0, 26.0, 8.0, -14.0, -45.0], [63.0, 10.0, 
68.0, -22.0, 56.0], [2.0, -3.0, -27.0, -33.0, 30.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank4_offset2(self):
      arg0=numpy.array([[[2.0, 4.0, 4.0], [7.0, -3.0, 1.0]], [[4.0, 3.0, -4.0], [-3.0, -5.0, 0.0]]])
      arg1=Data(numpy.array([[[[-5.0, -4.0, 0.0, 2.0, 2.0], [-2.0, 0.0, 0.0, 7.0, 5.0], [-4.0, -1.0, 1.0, 4.0, -2.0], [0.0, 
6.0, -4.0, 7.0, 0.0]], [[0.0, 5.0, 1.0, 0.0, 1.0], [3.0, 3.0, -6.0, 2.0, -4.0], [-6.0, 3.0, 2.0, -4.0, 1.0], [-7.0, -1.0, 5.0, 
3.0, -3.0]], [[1.0, 4.0, 2.0, 7.0, 3.0], [5.0, -3.0, 3.0, 3.0, -7.0], [-3.0, 2.0, 7.0, -4.0, -6.0], [5.0, -7.0, 4.0, 3.0, 
2.0]]], [[[2.0, 1.0, 0.0, -6.0, 0.0], [-7.0, 1.0, -4.0, 3.0, -6.0], [-1.0, 4.0, 2.0, 3.0, -1.0], [0.0, -2.0, 0.0, 6.0, 3.0]], 
[[0.0, -3.0, 5.0, -7.0, -2.0], [-1.0, 7.0, -2.0, -1.0, 1.0], [2.0, -7.0, 3.0, 7.0, 3.0], [-2.0, 5.0, 0.0, -4.0, 3.0]], [[7.0, 
-1.0, -2.0, 4.0, 6.0], [2.0, 1.0, 2.0, 0.0, 6.0], [2.0, 6.0, -1.0, -2.0, -2.0], [3.0, -4.0, 5.0, 5.0, 
-7.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[15.0, 43.0, -5.0, 15.0, 32.0], [-16.0, -13.0, -32.0, 58.0, -73.0], [-55.0, 73.0, 42.0, -26.0, 
-42.0], [1.0, -53.0, 33.0, 97.0, 1.0]], [[-30.0, -5.0, -30.0, 33.0, 9.0], [7.0, -17.0, -8.0, 18.0, 49.0], [-29.0, 20.0, -39.0, 
-24.0, 7.0], [-31.0, 30.0, -17.0, 27.0, -41.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_constData_rank3_offset0(self):
      arg0=numpy.array([-4.0, -3.0])
      arg1=Data(numpy.array([[[3.0, 0.0], [7.0, -4.0]], [[-4.0, 3.0], [-4.0, -3.0]], [[4.0, -1.0], [1.0, 2.0]], [[4.0, 5.0], 
[-7.0, 1.0]], [[-5.0, 4.0], [4.0, 2.0]], [[0.0, -4.0], [-4.0, 2.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-12.0, 0.0], [-28.0, 16.0]], [[16.0, -12.0], [16.0, 12.0]], [[-16.0, 4.0], [-4.0, -8.0]], 
[[-16.0, -20.0], [28.0, -4.0]], [[20.0, -16.0], [-16.0, -8.0]], [[0.0, 16.0], [16.0, -8.0]]], [[[-9.0, 0.0], [-21.0, 12.0]], 
[[12.0, -9.0], [12.0, 9.0]], [[-12.0, 3.0], [-3.0, -6.0]], [[-12.0, -15.0], [21.0, -3.0]], [[15.0, -12.0], [-12.0, -6.0]], 
[[0.0, 12.0], [12.0, -6.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank4_offset1(self):
      arg0=numpy.array([[1.0, -4.0, 7.0], [-3.0, 5.0, 1.0]])
      arg1=Data(numpy.array([[[[-1.0, 4.0], [0.0, -6.0]], [[4.0, 2.0], [7.0, -2.0]], [[-5.0, 3.0], [5.0, 2.0]], [[0.0, 1.0], 
[0.0, 3.0]], [[-3.0, 5.0], [-4.0, 2.0]], [[7.0, -6.0], [4.0, -3.0]]], [[[-3.0, 2.0], [1.0, -3.0]], [[2.0, -4.0], [5.0, -1.0]], 
[[5.0, -7.0], [-3.0, 4.0]], [[-5.0, -5.0], [3.0, -5.0]], [[0.0, -6.0], [0.0, -1.0]], [[3.0, -2.0], [2.0, 5.0]]], [[[-1.0, 1.0], 
[-5.0, -5.0]], [[-5.0, -6.0], [4.0, -4.0]], [[-2.0, 0.0], [3.0, -7.0]], [[1.0, 6.0], [1.0, 4.0]], [[2.0, 3.0], [2.0, 3.0]], 
[[-1.0, 0.0], [4.0, -2.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[4.0, 3.0], [-39.0, -29.0]], [[-39.0, -24.0], [15.0, -26.0]], [[-39.0, 31.0], [38.0, -63.0]], 
[[27.0, 63.0], [-5.0, 51.0]], [[11.0, 50.0], [10.0, 27.0]], [[-12.0, 2.0], [24.0, -37.0]]], [[[-13.0, -1.0], [0.0, -2.0]], 
[[-7.0, -32.0], [8.0, -3.0]], [[38.0, -44.0], [-27.0, 7.0]], [[-24.0, -22.0], [16.0, -30.0]], [[11.0, -42.0], [14.0, -8.0]], 
[[-7.0, 8.0], [2.0, 32.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank0_offset0(self):
      arg0=numpy.array([-4.0, -2.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-7.0)+(1-msk_arg1)*(4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([28.0, 14.0])+(1.-msk_ref)*numpy.array([-16.0, -8.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank1_offset1(self):
      arg0=numpy.array([[4.0, -1.0, -3.0], [-5.0, 6.0, 7.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([5.0, -3.0, -1.0])+(1.-msk_arg1)*numpy.array([-5.0, -3.0, 1.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([26.0, -50.0])+(1.-msk_ref)*numpy.array([-20.0, 14.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank2_offset2(self):
      arg0=numpy.array([[[1.0, 1.0, 7.0], [-4.0, -3.0, -3.0]], [[-4.0, -1.0, 0.0], [4.0, -4.0, -4.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, -2.0, -1.0], [-7.0, 6.0, -4.0]])+(1.-msk_arg1)*numpy.array([[0.0, 7.0, -6.0], [3.0, 
-6.0, 1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([6.0, -6.0])+(1.-msk_ref)*numpy.array([-32.0, 25.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank3_offset3(self):
      arg0=numpy.array([[[[0.0, 6.0, -1.0], [3.0, 3.0, -1.0], [-5.0, -4.0, -7.0], [-2.0, -6.0, 3.0]], [[1.0, 7.0, 3.0], [0.0, 
5.0, 5.0], [-2.0, 7.0, 2.0], [5.0, 6.0, 1.0]]], [[[-2.0, 0.0, -1.0], [0.0, 7.0, -5.0], [-5.0, 1.0, -6.0], [4.0, -2.0, 1.0]], 
[[-3.0, -1.0, 1.0], [-4.0, 4.0, -1.0], [-5.0, 7.0, -5.0], [3.0, 0.0, -1.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-5.0, 7.0, -2.0], [-5.0, -6.0, 2.0], [3.0, -6.0, -1.0], [3.0, 0.0, 0.0]], [[4.0, -7.0, 0.0], 
[-4.0, 5.0, -4.0], [4.0, -4.0, -5.0], [0.0, 4.0, 2.0]]])+(1.-msk_arg1)*numpy.array([[[-6.0, 2.0, 5.0], [-6.0, -2.0, 6.0], [0.0, 
-6.0, -2.0], [-4.0, 6.0, -3.0]], [[0.0, -2.0, 4.0], [5.0, 4.0, 6.0], [-2.0, 6.0, 7.0], [-5.0, -7.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-41.0, -33.0])+(1.-msk_ref)*numpy.array([16.0, -61.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank1_offset0(self):
      arg0=numpy.array([-3.0, 3.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-1.0, -3.0])+(1.-msk_arg1)*numpy.array([-6.0, 4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 9.0], [-3.0, -9.0]])+(1.-msk_ref)*numpy.array([[18.0, -12.0], [-18.0, 12.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank2_offset1(self):
      arg0=numpy.array([[-7.0, 0.0, 1.0], [3.0, 0.0, -4.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[0.0, 3.0], [5.0, -5.0], [0.0, -2.0]])+(1.-msk_arg1)*numpy.array([[0.0, 1.0], [3.0, -2.0], 
[-3.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, -23.0], [0.0, 17.0]])+(1.-msk_ref)*numpy.array([[-3.0, -1.0], [12.0, -21.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank3_offset2(self):
      arg0=numpy.array([[[-7.0, 0.0, 2.0], [6.0, 4.0, 7.0]], [[3.0, 0.0, 2.0], [4.0, -7.0, -3.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-1.0, -7.0], [7.0, -7.0], [6.0, -1.0]], [[2.0, 7.0], [0.0, 1.0], [-4.0, 
-5.0]]])+(1.-msk_arg1)*numpy.array([[[-5.0, 0.0], [-2.0, 5.0], [1.0, -2.0]], [[4.0, 4.0], [2.0, -4.0], [-1.0, -7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 58.0], [29.0, 13.0]])+(1.-msk_ref)*numpy.array([[62.0, -45.0], [-8.0, 61.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank4_offset3(self):
      arg0=numpy.array([[[[6.0, 0.0, 6.0], [0.0, 0.0, -2.0], [-4.0, -6.0, -7.0], [6.0, 7.0, 5.0]], [[3.0, 1.0, -1.0], [0.0, 
5.0, 6.0], [7.0, 1.0, -6.0], [-5.0, -4.0, 2.0]]], [[[-1.0, 7.0, 7.0], [-4.0, -5.0, 6.0], [-4.0, 4.0, 3.0], [6.0, 6.0, -1.0]], 
[[-1.0, 2.0, -7.0], [7.0, -6.0, 0.0], [-5.0, -6.0, -3.0], [-2.0, 4.0, 6.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[6.0, -3.0], [-7.0, -6.0], [-2.0, -6.0]], [[5.0, -6.0], [-6.0, 2.0], [-5.0, -2.0]], [[-6.0, 
-4.0], [0.0, -2.0], [0.0, -2.0]], [[-2.0, -7.0], [-7.0, -1.0], [-4.0, 1.0]]], [[[-7.0, -7.0], [-6.0, 0.0], [6.0, 1.0]], [[1.0, 
-2.0], [-1.0, 0.0], [0.0, -5.0]], [[0.0, -1.0], [0.0, -2.0], [5.0, 4.0]], [[1.0, -1.0], [-7.0, 0.0], [5.0, 
-7.0]]]])+(1.-msk_arg1)*numpy.array([[[[3.0, 0.0], [1.0, 4.0], [3.0, 5.0]], [[4.0, -3.0], [-2.0, -3.0], [6.0, -7.0]], [[-6.0, 
-7.0], [0.0, -6.0], [-6.0, 3.0]], [[2.0, -6.0], [7.0, -4.0], [-6.0, -7.0]]], [[[2.0, -1.0], [5.0, -6.0], [2.0, -2.0]], [[-1.0, 
-1.0], [7.0, -6.0], [4.0, 6.0]], [[-4.0, 7.0], [-1.0, 0.0], [5.0, 3.0]], [[1.0, 3.0], [6.0, 6.0], [-3.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-58.0, -146.0], [-164.0, -175.0]])+(1.-msk_ref)*numpy.array([[95.0, -19.0], [81.0, 20.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank2_offset0(self):
      arg0=numpy.array([5.0, -5.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[3.0, 2.0, -5.0, 2.0, -6.0], [-4.0, 4.0, 3.0, -7.0, 3.0], [5.0, 3.0, 7.0, 5.0, 1.0], [1.0, 
4.0, 3.0, -2.0, 4.0]])+(1.-msk_arg1)*numpy.array([[-6.0, 0.0, 1.0, 1.0, 2.0], [-5.0, 5.0, -6.0, -2.0, -6.0], [-5.0, 5.0, -7.0, 
7.0, 3.0], [3.0, -7.0, 5.0, -3.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[15.0, 10.0, -25.0, 10.0, -30.0], [-20.0, 20.0, 15.0, -35.0, 15.0], [25.0, 15.0, 35.0, 25.0, 
5.0], [5.0, 20.0, 15.0, -10.0, 20.0]], [[-15.0, -10.0, 25.0, -10.0, 30.0], [20.0, -20.0, -15.0, 35.0, -15.0], [-25.0, -15.0, 
-35.0, -25.0, -5.0], [-5.0, -20.0, -15.0, 10.0, -20.0]]])+(1.-msk_ref)*numpy.array([[[-30.0, 0.0, 5.0, 5.0, 10.0], [-25.0, 
25.0, -30.0, -10.0, -30.0], [-25.0, 25.0, -35.0, 35.0, 15.0], [15.0, -35.0, 25.0, -15.0, -20.0]], [[30.0, 0.0, -5.0, -5.0, 
-10.0], [25.0, -25.0, 30.0, 10.0, 30.0], [25.0, -25.0, 35.0, -35.0, -15.0], [-15.0, 35.0, -25.0, 15.0, 20.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank3_offset1(self):
      arg0=numpy.array([[3.0, 2.0, -4.0], [1.0, -2.0, 0.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, 0.0, 0.0, -3.0, -1.0], [6.0, 5.0, -7.0, 4.0, 3.0], [2.0, 0.0, -1.0, 5.0, 1.0], [-5.0, 
-7.0, -4.0, -3.0, 1.0]], [[-5.0, 4.0, 7.0, 5.0, -2.0], [0.0, -4.0, 7.0, -1.0, -4.0], [-4.0, -1.0, 7.0, 4.0, 0.0], [0.0, 3.0, 
-1.0, -5.0, -7.0]], [[-6.0, 6.0, 0.0, -5.0, -3.0], [0.0, 2.0, 6.0, -5.0, 4.0], [-2.0, 7.0, 1.0, 5.0, 0.0], [-2.0, 0.0, 4.0, 
-2.0, 6.0]]])+(1.-msk_arg1)*numpy.array([[[0.0, 5.0, -4.0, 7.0, 7.0], [1.0, 3.0, -4.0, -6.0, -5.0], [1.0, -1.0, -7.0, 6.0, 
-1.0], [-1.0, 5.0, 5.0, -4.0, -3.0]], [[0.0, 0.0, -3.0, 1.0, 2.0], [3.0, -3.0, -3.0, 0.0, 1.0], [7.0, 1.0, 2.0, -6.0, 7.0], 
[2.0, 0.0, -5.0, -7.0, 4.0]], [[5.0, 0.0, -5.0, -5.0, 0.0], [0.0, -2.0, -2.0, 1.0, -2.0], [6.0, 5.0, 1.0, -7.0, -6.0], [2.0, 
0.0, 5.0, -4.0, 4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-4.0, -16.0, 14.0, 21.0, 5.0], [18.0, -1.0, -31.0, 30.0, -15.0], [6.0, -30.0, 7.0, 3.0, 3.0], 
[-7.0, -15.0, -30.0, -11.0, -35.0]], [[4.0, -8.0, -14.0, -13.0, 3.0], [6.0, 13.0, -21.0, 6.0, 11.0], [10.0, 2.0, -15.0, -3.0, 
1.0], [-5.0, -13.0, -2.0, 7.0, 15.0]]])+(1.-msk_ref)*numpy.array([[[-20.0, 15.0, 2.0, 43.0, 25.0], [9.0, 11.0, -10.0, -22.0, 
-5.0], [-7.0, -21.0, -21.0, 34.0, 35.0], [-7.0, 15.0, -15.0, -10.0, -17.0]], [[0.0, 5.0, 2.0, 5.0, 3.0], [-5.0, 9.0, 2.0, -6.0, 
-7.0], [-13.0, -3.0, -11.0, 18.0, -15.0], [-5.0, 5.0, 15.0, 10.0, -11.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank4_offset2(self):
      arg0=numpy.array([[[6.0, 2.0, -1.0], [4.0, 1.0, -6.0]], [[0.0, -4.0, -2.0], [5.0, 6.0, 2.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[4.0, 7.0, 3.0, 0.0, 1.0], [-2.0, 5.0, 0.0, -1.0, -4.0], [-1.0, 3.0, 0.0, 3.0, 0.0], [-7.0, 
1.0, -6.0, -2.0, 4.0]], [[-4.0, -4.0, 0.0, 6.0, 2.0], [6.0, -2.0, -7.0, 5.0, 0.0], [-3.0, 1.0, -4.0, 0.0, 2.0], [-7.0, -1.0, 
-7.0, 2.0, 0.0]], [[5.0, 1.0, 0.0, -1.0, 4.0], [2.0, -1.0, 2.0, 0.0, -2.0], [-4.0, -6.0, -7.0, 2.0, 0.0], [-7.0, -7.0, -6.0, 
-4.0, -2.0]]], [[[5.0, -3.0, 6.0, 6.0, 3.0], [0.0, -1.0, 0.0, 6.0, 6.0], [-1.0, -4.0, 7.0, 6.0, -2.0], [0.0, 2.0, -2.0, 6.0, 
0.0]], [[3.0, -2.0, -3.0, -2.0, -7.0], [-1.0, -2.0, -3.0, -1.0, 1.0], [5.0, -6.0, 6.0, -3.0, 0.0], [-4.0, -5.0, 5.0, -1.0, 
0.0]], [[4.0, 0.0, 0.0, -3.0, 0.0], [-1.0, -6.0, 4.0, 3.0, 6.0], [2.0, -4.0, -2.0, -4.0, 0.0], [3.0, 5.0, -2.0, -3.0, 
-6.0]]]])+(1.-msk_arg1)*numpy.array([[[[4.0, -5.0, -3.0, -1.0, -7.0], [-6.0, 6.0, 1.0, -2.0, -4.0], [-5.0, 6.0, -5.0, -6.0, 
-4.0], [-1.0, 1.0, -7.0, 3.0, 7.0]], [[1.0, 7.0, -3.0, 6.0, 0.0], [-1.0, 2.0, 6.0, 5.0, 5.0], [-7.0, 1.0, 5.0, -1.0, -7.0], 
[1.0, -4.0, 0.0, 1.0, 3.0]], [[-4.0, -4.0, 1.0, 3.0, -5.0], [0.0, 0.0, -3.0, -2.0, 6.0], [-6.0, -5.0, 2.0, -6.0, 0.0], [-2.0, 
-6.0, -4.0, -4.0, -2.0]]], [[[-1.0, -2.0, 3.0, 0.0, -2.0], [0.0, 3.0, -6.0, 2.0, 3.0], [4.0, 6.0, -1.0, 3.0, -3.0], [3.0, 7.0, 
5.0, -3.0, 3.0]], [[-1.0, 5.0, -7.0, 1.0, 1.0], [-4.0, 5.0, -3.0, 0.0, -5.0], [-1.0, 1.0, 0.0, 7.0, -1.0], [-5.0, -6.0, -7.0, 
-5.0, 5.0]], [[-6.0, 0.0, 6.0, 3.0, 2.0], [3.0, 4.0, 2.0, 0.0, -1.0], [5.0, 0.0, -4.0, -3.0, -6.0], [7.0, 1.0, -6.0, 0.0, 
-3.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[10.0, 19.0, 39.0, 53.0, 11.0], [3.0, 57.0, -43.0, 9.0, -33.0], [-19.0, 28.0, 45.0, 61.0, 
-4.0], [-71.0, -16.0, -35.0, 37.0, 62.0]], [[57.0, -13.0, 12.0, -10.0, -43.0], [-36.0, -19.0, 14.0, 10.0, 52.0], [49.0, -56.0, 
97.0, 0.0, -18.0], [24.0, 8.0, 56.0, 18.0, -8.0]]])+(1.-msk_ref)*numpy.array([[[61.0, -15.0, -56.0, -14.0, -56.0], [-60.0, 
33.0, -18.0, 8.0, -7.0], [-53.0, 68.0, -2.0, 5.0, -15.0], [-37.0, 20.0, 11.0, 7.0, 85.0]], [[-19.0, 0.0, -5.0, -18.0, 10.0], 
[-14.0, 45.0, -62.0, -6.0, -49.0], [64.0, 42.0, -37.0, 67.0, -5.0], [-1.0, 29.0, -21.0, -41.0, 31.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank1_expandedData_rank3_offset0(self):
      arg0=numpy.array([-6.0, 6.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[7.0, -1.0], [-5.0, 3.0]], [[2.0, 3.0], [2.0, -2.0]], [[0.0, 0.0], [-5.0, -1.0]], [[-2.0, 
0.0], [-6.0, -4.0]], [[-3.0, -3.0], [7.0, -7.0]], [[5.0, 0.0], [-5.0, -3.0]]])+(1.-msk_arg1)*numpy.array([[[0.0, 7.0], [3.0, 
6.0]], [[-7.0, -4.0], [-7.0, -4.0]], [[0.0, 3.0], [3.0, 0.0]], [[-7.0, -3.0], [7.0, -2.0]], [[-6.0, 0.0], [6.0, -6.0]], [[7.0, 
0.0], [2.0, -5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-42.0, 6.0], [30.0, -18.0]], [[-12.0, -18.0], [-12.0, 12.0]], [[0.0, 0.0], [30.0, 6.0]], 
[[12.0, 0.0], [36.0, 24.0]], [[18.0, 18.0], [-42.0, 42.0]], [[-30.0, 0.0], [30.0, 18.0]]], [[[42.0, -6.0], [-30.0, 18.0]], 
[[12.0, 18.0], [12.0, -12.0]], [[0.0, 0.0], [-30.0, -6.0]], [[-12.0, 0.0], [-36.0, -24.0]], [[-18.0, -18.0], [42.0, -42.0]], 
[[30.0, 0.0], [-30.0, -18.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, -42.0], [-18.0, -36.0]], [[42.0, 24.0], [42.0, 24.0]], 
[[0.0, -18.0], [-18.0, 0.0]], [[42.0, 18.0], [-42.0, 12.0]], [[36.0, 0.0], [-36.0, 36.0]], [[-42.0, 0.0], [-12.0, 30.0]]], 
[[[0.0, 42.0], [18.0, 36.0]], [[-42.0, -24.0], [-42.0, -24.0]], [[0.0, 18.0], [18.0, 0.0]], [[-42.0, -18.0], [42.0, -12.0]], 
[[-36.0, 0.0], [36.0, -36.0]], [[42.0, 0.0], [12.0, -30.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank4_offset1(self):
      arg0=numpy.array([[-2.0, -6.0, 2.0], [-5.0, 6.0, 3.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[5.0, 2.0], [5.0, 4.0]], [[-3.0, 0.0], [-4.0, 0.0]], [[-1.0, -1.0], [-2.0, 5.0]], [[-7.0, 
0.0], [-4.0, -4.0]], [[-1.0, 0.0], [7.0, -2.0]], [[-2.0, 3.0], [-3.0, -2.0]]], [[[0.0, -4.0], [0.0, -3.0]], [[-6.0, -1.0], 
[1.0, -3.0]], [[3.0, -7.0], [6.0, -6.0]], [[7.0, 5.0], [-2.0, 3.0]], [[6.0, 1.0], [-6.0, 7.0]], [[7.0, -3.0], [2.0, 0.0]]], 
[[[7.0, 5.0], [2.0, -2.0]], [[-4.0, -2.0], [-7.0, 0.0]], [[-4.0, -2.0], [5.0, -1.0]], [[-6.0, 6.0], [-4.0, -2.0]], [[6.0, 
-2.0], [5.0, -1.0]], [[-4.0, 0.0], [-5.0, 3.0]]]])+(1.-msk_arg1)*numpy.array([[[[-6.0, 7.0], [2.0, -7.0]], [[3.0, 4.0], [5.0, 
3.0]], [[6.0, -5.0], [6.0, -7.0]], [[-2.0, 6.0], [5.0, 3.0]], [[-3.0, -7.0], [-5.0, 0.0]], [[7.0, 4.0], [4.0, -2.0]]], [[[2.0, 
-4.0], [-2.0, -6.0]], [[-6.0, -7.0], [0.0, 6.0]], [[5.0, 6.0], [3.0, 5.0]], [[2.0, 6.0], [-4.0, 6.0]], [[-3.0, -4.0], [-6.0, 
-2.0]], [[2.0, 1.0], [6.0, 2.0]]], [[[2.0, 3.0], [7.0, 5.0]], [[-4.0, 3.0], [4.0, 1.0]], [[2.0, -7.0], [-4.0, -6.0]], [[-4.0, 
0.0], [-2.0, 7.0]], [[-7.0, 6.0], [2.0, 4.0]], [[6.0, 4.0], [4.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[4.0, 30.0], [-6.0, 6.0]], [[34.0, 2.0], [-12.0, 18.0]], [[-24.0, 40.0], [-22.0, 24.0]], 
[[-40.0, -18.0], [12.0, -14.0]], [[-22.0, -10.0], [32.0, -40.0]], [[-46.0, 12.0], [-16.0, 10.0]]], [[[-4.0, -19.0], [-19.0, 
-44.0]], [[-33.0, -12.0], [5.0, -18.0]], [[11.0, -43.0], [61.0, -64.0]], [[59.0, 48.0], [-4.0, 32.0]], [[59.0, 0.0], [-56.0, 
49.0]], [[40.0, -33.0], [12.0, 19.0]]]])+(1.-msk_ref)*numpy.array([[[[4.0, 16.0], [22.0, 60.0]], [[22.0, 40.0], [-2.0, -40.0]], 
[[-38.0, -40.0], [-38.0, -28.0]], [[-16.0, -48.0], [10.0, -28.0]], [[10.0, 50.0], [50.0, 20.0]], [[-14.0, -6.0], [-36.0, 
-6.0]]], [[[48.0, -50.0], [-1.0, 14.0]], [[-63.0, -53.0], [-13.0, 24.0]], [[6.0, 40.0], [-24.0, 47.0]], [[10.0, 6.0], [-55.0, 
42.0]], [[-24.0, 29.0], [-5.0, 0.0]], [[-5.0, -2.0], [28.0, 25.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_float_rank0_offset0(self):
      arg0=numpy.array([[-4.0, 0.0, -3.0, -4.0, -6.0], [3.0, 3.0, -3.0, 2.0, -3.0], [-4.0, 2.0, 5.0, -6.0, 4.0], [-3.0, 5.0, 
1.0, -6.0, 0.0]])
      arg1=0.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[-0.0, 0.0, -0.0, -0.0, -0.0], [0.0, 0.0, -0.0, 0.0, -0.0], [-0.0, 0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, 
0.0, -0.0, 0.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank0_offset0(self):
      arg0=numpy.array([[-6.0, -7.0, -2.0, 4.0, -3.0], [6.0, -2.0, 4.0, 6.0, 4.0], [-5.0, 0.0, -1.0, -3.0, -7.0], [0.0, -5.0, 
7.0, -3.0, 2.0]])
      arg1=numpy.array(-2.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[12.0, 14.0, 4.0, -8.0, 6.0], [-12.0, 4.0, -8.0, -12.0, -8.0], [10.0, -0.0, 2.0, 6.0, 14.0], [-0.0, 
10.0, -14.0, 6.0, -4.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank1_offset1(self):
      arg0=numpy.array([[[6.0, -7.0, 0.0], [0.0, 1.0, 6.0], [-1.0, 6.0, 6.0], [-4.0, 2.0, 4.0], [-6.0, 6.0, 5.0]], [[-5.0, 6.0, 
4.0], [6.0, -5.0, -7.0], [-3.0, 1.0, -6.0], [-3.0, 2.0, 0.0], [1.0, -1.0, 5.0]], [[4.0, 0.0, -6.0], [-1.0, 5.0, -6.0], [0.0, 
-6.0, -3.0], [0.0, 4.0, 7.0], [-1.0, -4.0, 0.0]], [[-2.0, -4.0, -1.0], [0.0, 0.0, 5.0], [-4.0, -4.0, 0.0], [-5.0, 1.0, -7.0], 
[6.0, 4.0, 0.0]]])
      arg1=numpy.array([-7.0, -5.0, -5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[-7.0, -35.0, -53.0, -2.0, -13.0], [-15.0, 18.0, 46.0, 11.0, -27.0], [2.0, 12.0, 45.0, -55.0, 27.0], 
[39.0, -25.0, 48.0, 65.0, -62.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank2_offset2(self):
      arg0=numpy.array([[[[-4.0, 1.0, -1.0], [-1.0, -4.0, 1.0]], [[0.0, -7.0, 0.0], [0.0, 6.0, 2.0]], [[-6.0, 7.0, 1.0], [7.0, 
-5.0, 6.0]], [[-2.0, 0.0, 4.0], [2.0, -3.0, -3.0]], [[3.0, 5.0, -4.0], [4.0, 4.0, 2.0]]], [[[-3.0, -3.0, 7.0], [7.0, -1.0, 
5.0]], [[-3.0, -7.0, -7.0], [7.0, -5.0, 5.0]], [[2.0, -4.0, -1.0], [-4.0, -2.0, 0.0]], [[6.0, -5.0, -3.0], [6.0, -1.0, 0.0]], 
[[-6.0, -1.0, 5.0], [0.0, 6.0, 3.0]]], [[[4.0, 6.0, -2.0], [3.0, -6.0, -4.0]], [[2.0, -4.0, 1.0], [0.0, -6.0, -4.0]], [[-7.0, 
-1.0, -1.0], [-1.0, 5.0, -6.0]], [[6.0, -7.0, -7.0], [0.0, -3.0, -4.0]], [[2.0, 3.0, 3.0], [1.0, 6.0, -1.0]]], [[[-2.0, 5.0, 
-2.0], [7.0, 1.0, -6.0]], [[-7.0, -4.0, 1.0], [3.0, 0.0, 5.0]], [[-3.0, -4.0, 6.0], [-7.0, -3.0, 0.0]], [[6.0, -7.0, 7.0], 
[-5.0, 6.0, -6.0]], [[1.0, -1.0, -2.0], [7.0, -1.0, 0.0]]]])
      arg1=numpy.array([[2.0, 1.0, 3.0], [-7.0, -6.0, -1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[20.0, -45.0, -27.0, 15.0, -55.0], [-36.0, -58.0, 37.0, -38.0, -37.0], [27.0, 43.0, -35.0, 6.0, -26.0], 
[-54.0, -41.0, 75.0, 31.0, -48.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank1_offset0(self):
      arg0=numpy.array([[5.0, -7.0, -6.0, -3.0, -3.0], [5.0, 6.0, -4.0, 7.0, 4.0], [6.0, 2.0, 3.0, 6.0, 7.0], [1.0, 5.0, -5.0, 
-5.0, 7.0]])
      arg1=numpy.array([-6.0, 4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-30.0, 20.0], [42.0, -28.0], [36.0, -24.0], [18.0, -12.0], [18.0, -12.0]], [[-30.0, 20.0], [-36.0, 
24.0], [24.0, -16.0], [-42.0, 28.0], [-24.0, 16.0]], [[-36.0, 24.0], [-12.0, 8.0], [-18.0, 12.0], [-36.0, 24.0], [-42.0, 
28.0]], [[-6.0, 4.0], [-30.0, 20.0], [30.0, -20.0], [30.0, -20.0], [-42.0, 28.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank2_offset1(self):
      arg0=numpy.array([[[-5.0, -2.0, 7.0], [-6.0, 2.0, 1.0], [-6.0, 3.0, -5.0], [-1.0, 4.0, -5.0], [-5.0, 7.0, -5.0]], [[2.0, 
2.0, -6.0], [-7.0, 0.0, 2.0], [-5.0, 1.0, -2.0], [-6.0, 0.0, -3.0], [-7.0, -2.0, -1.0]], [[-4.0, 7.0, -3.0], [-3.0, -2.0, 5.0], 
[-5.0, -1.0, -4.0], [-3.0, 3.0, 7.0], [-3.0, -5.0, -1.0]], [[-2.0, -6.0, -3.0], [-6.0, 5.0, -2.0], [-1.0, -5.0, -7.0], [5.0, 
2.0, 5.0], [1.0, -1.0, 4.0]]])
      arg1=numpy.array([[3.0, 7.0], [5.0, 0.0], [4.0, 5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[3.0, 0.0], [-4.0, -37.0], [-23.0, -67.0], [-3.0, -32.0], [0.0, -60.0]], [[-8.0, -16.0], [-13.0, 
-39.0], [-18.0, -45.0], [-30.0, -57.0], [-35.0, -54.0]], [[11.0, -43.0], [1.0, 4.0], [-36.0, -55.0], [34.0, 14.0], [-38.0, 
-26.0]], [[-48.0, -29.0], [-1.0, -52.0], [-56.0, -42.0], [45.0, 60.0], [14.0, 27.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank3_offset2(self):
      arg0=numpy.array([[[[-6.0, -4.0, 0.0], [0.0, -1.0, 2.0]], [[0.0, -3.0, 4.0], [2.0, -2.0, 1.0]], [[-3.0, 7.0, -3.0], [5.0, 
-4.0, -3.0]], [[3.0, 5.0, 1.0], [-5.0, -6.0, 3.0]], [[-5.0, 0.0, 1.0], [-7.0, 2.0, 6.0]]], [[[-2.0, 6.0, 6.0], [0.0, 3.0, 
-2.0]], [[-1.0, 4.0, -7.0], [6.0, -5.0, 1.0]], [[-6.0, -3.0, -6.0], [7.0, -6.0, 5.0]], [[-4.0, -2.0, 5.0], [3.0, -2.0, 5.0]], 
[[-7.0, -3.0, -6.0], [-7.0, 4.0, 1.0]]], [[[6.0, -1.0, 0.0], [0.0, 2.0, -7.0]], [[1.0, 5.0, -5.0], [3.0, 7.0, -5.0]], [[-3.0, 
6.0, -6.0], [6.0, 7.0, 0.0]], [[0.0, -7.0, 2.0], [-6.0, 1.0, -6.0]], [[3.0, -4.0, -4.0], [1.0, -5.0, 3.0]]], [[[-3.0, -1.0, 
-2.0], [-7.0, 0.0, 6.0]], [[-1.0, 2.0, -7.0], [-4.0, 6.0, 0.0]], [[-6.0, 1.0, 7.0], [3.0, -4.0, 1.0]], [[4.0, 0.0, 3.0], [7.0, 
-3.0, 2.0]], [[-2.0, 3.0, 6.0], [0.0, 3.0, 2.0]]]])
      arg1=numpy.array([[[0.0, -4.0], [0.0, 1.0], [5.0, 1.0]], [[-7.0, -1.0], [4.0, -7.0], [7.0, -1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[10.0, 25.0], [5.0, 12.0], [-87.0, 42.0], [37.0, 38.0], [104.0, 8.0]], [[28.0, 1.0], [-90.0, 29.0], 
[-68.0, 45.0], [31.0, 25.0], [42.0, -3.0]], [[-41.0, -32.0], [-53.0, -51.0], [-44.0, -43.0], [14.0, 0.0], [-26.0, 11.0]], 
[[81.0, 10.0], [17.0, -39.0], [5.0, 56.0], [-32.0, -1.0], [56.0, -6.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_array_rank2_offset0(self):
      arg0=numpy.array([[6.0, -4.0, 0.0, 4.0, -6.0], [1.0, -1.0, 7.0, 6.0, 6.0], [-2.0, -7.0, 1.0, -3.0, -7.0], [0.0, -6.0, 
7.0, -2.0, 6.0]])
      arg1=numpy.array([[3.0, -6.0, -1.0, 2.0, -6.0], [-7.0, -6.0, 0.0, -2.0, 5.0], [-2.0, 6.0, 7.0, -6.0, -4.0], [0.0, 6.0, 
4.0, 0.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[18.0, -36.0, -6.0, 12.0, -36.0], [-42.0, -36.0, 0.0, -12.0, 30.0], [-12.0, 36.0, 42.0, -36.0, -24.0], 
[0.0, 36.0, 24.0, 0.0, 0.0]], [[-12.0, 24.0, 4.0, -8.0, 24.0], [28.0, 24.0, 0.0, 8.0, -20.0], [8.0, -24.0, -28.0, 24.0, 16.0], 
[0.0, -24.0, -16.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0]], [[12.0, -24.0, -4.0, 8.0, -24.0], [-28.0, -24.0, 0.0, -8.0, 20.0], [-8.0, 24.0, 28.0, -24.0, -16.0], [0.0, 
24.0, 16.0, 0.0, 0.0]], [[-18.0, 36.0, 6.0, -12.0, 36.0], [42.0, 36.0, 0.0, 12.0, -30.0], [12.0, -36.0, -42.0, 36.0, 24.0], 
[0.0, -36.0, -24.0, 0.0, 0.0]]], [[[3.0, -6.0, -1.0, 2.0, -6.0], [-7.0, -6.0, 0.0, -2.0, 5.0], [-2.0, 6.0, 7.0, -6.0, -4.0], 
[0.0, 6.0, 4.0, 0.0, 0.0]], [[-3.0, 6.0, 1.0, -2.0, 6.0], [7.0, 6.0, 0.0, 2.0, -5.0], [2.0, -6.0, -7.0, 6.0, 4.0], [0.0, -6.0, 
-4.0, 0.0, 0.0]], [[21.0, -42.0, -7.0, 14.0, -42.0], [-49.0, -42.0, 0.0, -14.0, 35.0], [-14.0, 42.0, 49.0, -42.0, -28.0], [0.0, 
42.0, 28.0, 0.0, 0.0]], [[18.0, -36.0, -6.0, 12.0, -36.0], [-42.0, -36.0, 0.0, -12.0, 30.0], [-12.0, 36.0, 42.0, -36.0, -24.0], 
[0.0, 36.0, 24.0, 0.0, 0.0]], [[18.0, -36.0, -6.0, 12.0, -36.0], [-42.0, -36.0, 0.0, -12.0, 30.0], [-12.0, 36.0, 42.0, -36.0, 
-24.0], [0.0, 36.0, 24.0, 0.0, 0.0]]], [[[-6.0, 12.0, 2.0, -4.0, 12.0], [14.0, 12.0, 0.0, 4.0, -10.0], [4.0, -12.0, -14.0, 
12.0, 8.0], [0.0, -12.0, -8.0, 0.0, 0.0]], [[-21.0, 42.0, 7.0, -14.0, 42.0], [49.0, 42.0, 0.0, 14.0, -35.0], [14.0, -42.0, 
-49.0, 42.0, 28.0], [0.0, -42.0, -28.0, 0.0, 0.0]], [[3.0, -6.0, -1.0, 2.0, -6.0], [-7.0, -6.0, 0.0, -2.0, 5.0], [-2.0, 6.0, 
7.0, -6.0, -4.0], [0.0, 6.0, 4.0, 0.0, 0.0]], [[-9.0, 18.0, 3.0, -6.0, 18.0], [21.0, 18.0, 0.0, 6.0, -15.0], [6.0, -18.0, 
-21.0, 18.0, 12.0], [0.0, -18.0, -12.0, 0.0, 0.0]], [[-21.0, 42.0, 7.0, -14.0, 42.0], [49.0, 42.0, 0.0, 14.0, -35.0], [14.0, 
-42.0, -49.0, 42.0, 28.0], [0.0, -42.0, -28.0, 0.0, 0.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[-18.0, 36.0, 6.0, -12.0, 36.0], [42.0, 36.0, 0.0, 12.0, -30.0], [12.0, -36.0, 
-42.0, 36.0, 24.0], [0.0, -36.0, -24.0, 0.0, 0.0]], [[21.0, -42.0, -7.0, 14.0, -42.0], [-49.0, -42.0, 0.0, -14.0, 35.0], 
[-14.0, 42.0, 49.0, -42.0, -28.0], [0.0, 42.0, 28.0, 0.0, 0.0]], [[-6.0, 12.0, 2.0, -4.0, 12.0], [14.0, 12.0, 0.0, 4.0, -10.0], 
[4.0, -12.0, -14.0, 12.0, 8.0], [0.0, -12.0, -8.0, 0.0, 0.0]], [[18.0, -36.0, -6.0, 12.0, -36.0], [-42.0, -36.0, 0.0, -12.0, 
30.0], [-12.0, 36.0, 42.0, -36.0, -24.0], [0.0, 36.0, 24.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank3_offset1(self):
      arg0=numpy.array([[[-1.0, -2.0, -7.0], [-3.0, 0.0, -2.0], [0.0, 1.0, -5.0], [0.0, -6.0, 5.0], [6.0, -1.0, -4.0]], [[0.0, 
1.0, 6.0], [0.0, -7.0, -7.0], [1.0, 3.0, 7.0], [6.0, 7.0, 0.0], [7.0, 0.0, 0.0]], [[6.0, 3.0, -3.0], [0.0, 2.0, 0.0], [4.0, 
-1.0, 6.0], [3.0, 3.0, 0.0], [7.0, 0.0, -6.0]], [[3.0, 5.0, -4.0], [-6.0, 0.0, 6.0], [-5.0, -2.0, -5.0], [-2.0, 4.0, 0.0], 
[-3.0, -5.0, -6.0]]])
      arg1=numpy.array([[[-7.0, 4.0, -3.0, 4.0, 5.0], [-6.0, -2.0, 5.0, -1.0, 7.0], [-2.0, -7.0, -2.0, 4.0, -5.0], [5.0, 3.0, 
-1.0, 3.0, 4.0]], [[3.0, -2.0, -1.0, 4.0, 3.0], [-6.0, 2.0, -3.0, -4.0, 4.0], [2.0, 2.0, -1.0, -1.0, -2.0], [2.0, -7.0, 7.0, 
6.0, -2.0]], [[7.0, -4.0, 0.0, -4.0, -3.0], [-3.0, 6.0, 4.0, -6.0, 0.0], [1.0, 2.0, 6.0, 4.0, 4.0], [0.0, 0.0, 5.0, -7.0, 
2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[-48.0, 28.0, 5.0, 16.0, 10.0], [39.0, -44.0, -27.0, 51.0, -15.0], [-9.0, -11.0, -38.0, -30.0, -19.0], 
[-9.0, 11.0, -48.0, 34.0, -14.0]], [[7.0, -4.0, 9.0, -4.0, -9.0], [24.0, -6.0, -23.0, 15.0, -21.0], [4.0, 17.0, -6.0, -20.0, 
7.0], [-15.0, -9.0, -7.0, 5.0, -16.0]], [[-32.0, 18.0, -1.0, 24.0, 18.0], [9.0, -28.0, -23.0, 26.0, 4.0], [-3.0, -8.0, -31.0, 
-21.0, -22.0], [2.0, -7.0, -18.0, 41.0, -12.0]], [[17.0, -8.0, 6.0, -44.0, -33.0], [21.0, 18.0, 38.0, -6.0, -24.0], [-7.0, 
-2.0, 36.0, 26.0, 32.0], [-12.0, 42.0, -17.0, -71.0, 22.0]], [[-73.0, 42.0, -17.0, 36.0, 39.0], [-18.0, -38.0, 17.0, 22.0, 
38.0], [-18.0, -52.0, -35.0, 9.0, -44.0], [28.0, 25.0, -33.0, 40.0, 18.0]]], [[[45.0, -26.0, -1.0, -20.0, -15.0], [-24.0, 38.0, 
21.0, -40.0, 4.0], [8.0, 14.0, 35.0, 23.0, 22.0], [2.0, -7.0, 37.0, -36.0, 10.0]], [[-70.0, 42.0, 7.0, 0.0, 0.0], [63.0, -56.0, 
-7.0, 70.0, -28.0], [-21.0, -28.0, -35.0, -21.0, -14.0], [-14.0, 49.0, -84.0, 7.0, 0.0]], [[51.0, -30.0, -6.0, -12.0, -7.0], 
[-45.0, 46.0, 24.0, -55.0, 19.0], [11.0, 13.0, 37.0, 29.0, 17.0], [11.0, -18.0, 55.0, -28.0, 12.0]], [[-21.0, 10.0, -25.0, 
52.0, 51.0], [-78.0, 2.0, 9.0, -34.0, 70.0], [2.0, -28.0, -19.0, 17.0, -44.0], [44.0, -31.0, 43.0, 60.0, 10.0]], [[-49.0, 28.0, 
-21.0, 28.0, 35.0], [-42.0, -14.0, 35.0, -7.0, 49.0], [-14.0, -49.0, -14.0, 28.0, -35.0], [35.0, 21.0, -7.0, 21.0, 28.0]]], 
[[[-54.0, 30.0, -21.0, 48.0, 48.0], [-45.0, -24.0, 9.0, 0.0, 54.0], [-9.0, -42.0, -33.0, 9.0, -48.0], [36.0, -3.0, 0.0, 57.0, 
12.0]], [[6.0, -4.0, -2.0, 8.0, 6.0], [-12.0, 4.0, -6.0, -8.0, 8.0], [4.0, 4.0, -2.0, -2.0, -4.0], [4.0, -14.0, 14.0, 12.0, 
-4.0]], [[11.0, -6.0, -11.0, -12.0, -1.0], [-36.0, 26.0, 47.0, -36.0, 24.0], [-4.0, -18.0, 29.0, 41.0, 6.0], [18.0, 19.0, 19.0, 
-36.0, 30.0]], [[-12.0, 6.0, -12.0, 24.0, 24.0], [-36.0, 0.0, 6.0, -15.0, 33.0], [0.0, -15.0, -9.0, 9.0, -21.0], [21.0, -12.0, 
18.0, 27.0, 6.0]], [[-91.0, 52.0, -21.0, 52.0, 53.0], [-24.0, -50.0, 11.0, 29.0, 49.0], [-20.0, -61.0, -50.0, 4.0, -59.0], 
[35.0, 21.0, -37.0, 63.0, 16.0]]], [[[-34.0, 18.0, -14.0, 48.0, 42.0], [-36.0, -20.0, -16.0, 1.0, 41.0], [0.0, -19.0, -35.0, 
-9.0, -41.0], [25.0, -26.0, 12.0, 67.0, -6.0]], [[84.0, -48.0, 18.0, -48.0, -48.0], [18.0, 48.0, -6.0, -30.0, -42.0], [18.0, 
54.0, 48.0, 0.0, 54.0], [-30.0, -18.0, 36.0, -60.0, -12.0]], [[-6.0, 4.0, 17.0, -8.0, -16.0], [57.0, -24.0, -39.0, 43.0, 
-43.0], [1.0, 21.0, -18.0, -38.0, 9.0], [-29.0, -1.0, -34.0, 8.0, -26.0]], [[26.0, -16.0, 2.0, 8.0, 2.0], [-12.0, 12.0, -22.0, 
-14.0, 2.0], [12.0, 22.0, 0.0, -12.0, 2.0], [-2.0, -34.0, 30.0, 18.0, -16.0]], [[-36.0, 22.0, 14.0, -8.0, -12.0], [66.0, -40.0, 
-24.0, 59.0, -41.0], [-10.0, -1.0, -25.0, -31.0, 1.0], [-25.0, 26.0, -62.0, 3.0, -14.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank4_offset2(self):
      arg0=numpy.array([[[[-1.0, -7.0, 5.0], [2.0, 1.0, 0.0]], [[-4.0, 0.0, 0.0], [-1.0, 3.0, 2.0]], [[-5.0, 3.0, 3.0], [4.0, 
-5.0, 3.0]], [[0.0, -6.0, -7.0], [-2.0, -2.0, 5.0]], [[-3.0, 7.0, 7.0], [-7.0, 0.0, 7.0]]], [[[-2.0, -3.0, -1.0], [0.0, 0.0, 
-4.0]], [[0.0, -1.0, 0.0], [-7.0, 4.0, -4.0]], [[5.0, -2.0, 3.0], [-7.0, 1.0, 0.0]], [[-7.0, 3.0, -2.0], [-7.0, 5.0, -6.0]], 
[[5.0, -1.0, -1.0], [6.0, -4.0, -6.0]]], [[[-6.0, -1.0, 0.0], [5.0, 5.0, 4.0]], [[-1.0, 0.0, -4.0], [-4.0, -3.0, -7.0]], 
[[-6.0, -1.0, 0.0], [4.0, -3.0, -6.0]], [[6.0, -1.0, 6.0], [-5.0, 5.0, -4.0]], [[6.0, -1.0, 6.0], [2.0, -4.0, 1.0]]], [[[4.0, 
7.0, -6.0], [0.0, 4.0, -5.0]], [[3.0, -2.0, -3.0], [-2.0, -3.0, 4.0]], [[4.0, 7.0, 1.0], [7.0, 3.0, 1.0]], [[3.0, -5.0, -7.0], 
[-1.0, -4.0, -7.0]], [[-5.0, 6.0, 6.0], [5.0, 7.0, 0.0]]]])
      arg1=numpy.array([[[[6.0, 3.0, -6.0, 7.0, -5.0], [7.0, 7.0, 0.0, 5.0, 2.0], [1.0, -5.0, -3.0, -3.0, 1.0], [1.0, -7.0, 
2.0, -2.0, -1.0]], [[7.0, -7.0, -7.0, -7.0, 0.0], [7.0, 1.0, -1.0, 0.0, -4.0], [1.0, 1.0, 0.0, -4.0, 7.0], [-4.0, 0.0, -5.0, 
6.0, 4.0]], [[-4.0, 2.0, 1.0, 4.0, 6.0], [-7.0, 4.0, -3.0, 5.0, -5.0], [5.0, -2.0, 3.0, -6.0, 4.0], [3.0, 5.0, -5.0, -3.0, 
4.0]]], [[[3.0, 6.0, -1.0, -2.0, -6.0], [-5.0, -3.0, 4.0, -3.0, 0.0], [-1.0, -4.0, 0.0, 3.0, 0.0], [3.0, 7.0, 5.0, 1.0, 3.0]], 
[[3.0, -1.0, -6.0, 7.0, 0.0], [2.0, 7.0, 3.0, 0.0, 3.0], [0.0, 2.0, -3.0, 2.0, 4.0], [6.0, 3.0, -3.0, -3.0, -7.0]], [[-7.0, 
7.0, 0.0, 3.0, 4.0], [-3.0, 6.0, 0.0, 4.0, -2.0], [2.0, 3.0, 6.0, 3.0, -3.0], [-3.0, 6.0, -2.0, -2.0, -7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[[-66.0, 67.0, 52.0, 65.0, 23.0], [-99.0, 7.0, 3.0, 14.0, 4.0], [15.0, -18.0, 15.0, 9.0, -26.0], [54.0, 
49.0, 15.0, -56.0, -8.0]], [[-32.0, -7.0, 7.0, 1.0, 34.0], [-23.0, 8.0, 5.0, -9.0, -3.0], [1.0, 36.0, 15.0, 21.0, 2.0], [5.0, 
42.0, -26.0, -6.0, -34.0]], [[-45.0, 20.0, 38.0, -78.0, 31.0], [-74.0, -49.0, -11.0, -10.0, -58.0], [15.0, 5.0, 57.0, -4.0, 
-1.0], [-35.0, 81.0, -11.0, 32.0, 55.0]], [[-61.0, 53.0, 49.0, 19.0, -10.0], [-2.0, -12.0, 13.0, -9.0, 43.0], [-29.0, 27.0, 
15.0, 71.0, -93.0], [-30.0, -25.0, 51.0, -21.0, -79.0]], [[-67.0, -37.0, -17.0, -7.0, 127.0], [-7.0, 77.0, -56.0, 69.0, -83.0], 
[60.0, 57.0, 72.0, -61.0, 53.0], [-52.0, 49.0, -125.0, 6.0, -11.0]]], [[[-1.0, -15.0, 32.0, -9.0, -12.0], [-16.0, -45.0, 6.0, 
-31.0, 21.0], [-18.0, -3.0, -21.0, 12.0, -15.0], [19.0, -15.0, 24.0, -3.0, 14.0]], [[12.0, -67.0, -10.0, 37.0, 26.0], [48.0, 
24.0, -15.0, 5.0, 24.0], [-2.0, 23.0, -36.0, -21.0, 21.0], [19.0, -61.0, -34.0, -17.0, -25.0]], [[-14.0, -8.0, -12.0, 82.0, 
35.0], [37.0, 73.0, -32.0, 61.0, 6.0], [25.0, -3.0, -9.0, -44.0, 7.0], [7.0, -66.0, -33.0, -41.0, -29.0]], [[23.0, -135.0, 
-4.0, -47.0, 41.0], [49.0, -34.0, -10.0, -48.0, 11.0], [-19.0, 62.0, -36.0, -8.0, 44.0], [2.0, -31.0, -57.0, 28.0, -3.0]], 
[[75.0, 18.0, -6.0, -20.0, -91.0], [15.0, -52.0, 16.0, -22.0, 19.0], [-19.0, -74.0, -42.0, -13.0, -4.0], [18.0, -46.0, 74.0, 
17.0, 75.0]]], [[[-41.0, 42.0, 8.0, 2.0, 16.0], [-76.0, 1.0, 36.0, -29.0, -1.0], [-4.0, 31.0, 27.0, 59.0, -5.0], [31.0, 116.0, 
-5.0, -12.0, -46.0]], [[38.0, -81.0, 24.0, -57.0, -23.0], [56.0, -74.0, -13.0, -41.0, 23.0], [-31.0, 2.0, -42.0, -12.0, -8.0], 
[-22.0, -92.0, 21.0, 33.0, 43.0]], [[2.0, -26.0, 57.0, -82.0, -18.0], [-57.0, -112.0, 8.0, -66.0, -5.0], [-23.0, -11.0, -9.0, 
10.0, -7.0], [10.0, 25.0, 34.0, 31.0, 77.0]], [[33.0, -26.0, -48.0, 106.0, 20.0], [40.0, 91.0, -22.0, 59.0, 9.0], [32.0, -25.0, 
-39.0, -67.0, 55.0], [55.0, -56.0, -45.0, -48.0, -8.0]], [[-8.0, 60.0, -1.0, 44.0, -2.0], [-28.0, 37.0, -21.0, 58.0, -28.0], 
[35.0, -56.0, 18.0, -49.0, 4.0], [7.0, -4.0, 7.0, -24.0, 41.0]]], [[[144.0, -88.0, -103.0, -32.0, -76.0], [142.0, 9.0, 23.0, 
-30.0, 32.0], [-29.0, -8.0, -72.0, -11.0, 60.0], [-3.0, -76.0, 1.0, 50.0, 7.0]], [[-27.0, 36.0, 13.0, 18.0, -5.0], [20.0, 16.0, 
-6.0, 22.0, 12.0], [-4.0, 3.0, 15.0, 17.0, -47.0], [-34.0, -35.0, 22.0, -10.0, -36.0]], [[92.0, 11.0, -97.0, -7.0, -52.0], 
[38.0, 45.0, 27.0, 8.0, -18.0], [11.0, -34.0, -12.0, -16.0, 66.0], [15.0, 41.0, -8.0, 27.0, 21.0]], [[45.0, -21.0, 35.0, -19.0, 
-79.0], [53.0, -79.0, 10.0, -45.0, 63.0], [-50.0, -31.0, -60.0, 21.0, -55.0], [-4.0, -117.0, 87.0, 10.0, 23.0]], [[24.0, -22.0, 
-53.0, -14.0, 31.0], [-46.0, 29.0, 17.0, -10.0, -43.0], [26.0, 13.0, 12.0, -16.0, 89.0], [46.0, 121.0, -66.0, 12.0, 19.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank0_offset0(self):
      arg0=numpy.array([[-7.0, 6.0, 1.0, 0.0, -6.0], [1.0, 3.0, -4.0, 5.0, -3.0], [-2.0, -7.0, -2.0, 0.0, -6.0], [6.0, -1.0, 
3.0, -2.0, 1.0]])
      arg1=Data(-6.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[42.0, -36.0, -6.0, -0.0, 36.0], [-6.0, -18.0, 24.0, -30.0, 18.0], [12.0, 42.0, 12.0, -0.0, 36.0], 
[-36.0, 6.0, -18.0, 12.0, -6.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank1_offset1(self):
      arg0=numpy.array([[[-7.0, 7.0, -5.0], [-3.0, 0.0, -6.0], [7.0, -6.0, -4.0], [3.0, -6.0, -4.0], [-4.0, -3.0, -7.0]], 
[[7.0, 4.0, 6.0], [0.0, 5.0, -3.0], [6.0, -3.0, -2.0], [-7.0, 3.0, 4.0], [5.0, 4.0, 5.0]], [[-3.0, 3.0, 1.0], [-1.0, -7.0, 
6.0], [-5.0, -2.0, 7.0], [3.0, 3.0, 4.0], [4.0, 4.0, -6.0]], [[1.0, 0.0, -1.0], [-7.0, 0.0, 0.0], [4.0, -7.0, -5.0], [-4.0, 
-4.0, 3.0], [-7.0, -1.0, -4.0]]])
      arg1=Data(numpy.array([1.0, 2.0, -6.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[37.0, 33.0, 19.0, 15.0, 32.0], [-21.0, 28.0, 12.0, -25.0, -17.0], [-3.0, -51.0, -51.0, -15.0, 
48.0], [7.0, -7.0, 20.0, -30.0, 15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank2_offset2(self):
      arg0=numpy.array([[[[0.0, -6.0, 5.0], [-3.0, 1.0, 2.0]], [[-3.0, -7.0, 2.0], [-5.0, 1.0, -1.0]], [[5.0, 0.0, -7.0], [0.0, 
0.0, -4.0]], [[4.0, 1.0, -2.0], [0.0, 2.0, 6.0]], [[7.0, 4.0, -7.0], [4.0, 7.0, 1.0]]], [[[0.0, -7.0, -4.0], [-4.0, 0.0, 
-6.0]], [[4.0, 2.0, 1.0], [1.0, 2.0, -4.0]], [[-3.0, 1.0, 6.0], [0.0, -6.0, 3.0]], [[0.0, -1.0, -2.0], [-2.0, -2.0, 0.0]], 
[[3.0, 1.0, -1.0], [7.0, 0.0, -4.0]]], [[[-6.0, 2.0, 3.0], [-7.0, -2.0, -5.0]], [[-5.0, 3.0, 1.0], [2.0, -4.0, 2.0]], [[-1.0, 
-3.0, -7.0], [3.0, 6.0, 0.0]], [[-2.0, -6.0, -4.0], [-5.0, 1.0, 1.0]], [[-7.0, 3.0, -6.0], [-4.0, -2.0, 5.0]]], [[[3.0, -4.0, 
4.0], [-7.0, 1.0, 2.0]], [[-6.0, 6.0, 6.0], [-1.0, -3.0, 7.0]], [[-1.0, -5.0, -7.0], [0.0, 7.0, 7.0]], [[-2.0, -7.0, 0.0], 
[-2.0, 1.0, 0.0]], [[6.0, -1.0, -2.0], [5.0, -7.0, 6.0]]]])
      arg1=Data(numpy.array([[-4.0, 4.0, -4.0], [2.0, -2.0, -5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-62.0, -31.0, 28.0, -38.0, 5.0], [10.0, 6.0, -11.0, 4.0, 30.0], [35.0, 30.0, 14.0, -17.0, 35.0], 
[-70.0, -7.0, -37.0, -26.0, -26.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank1_offset0(self):
      arg0=numpy.array([[-2.0, 4.0, 2.0, -7.0, -2.0], [-3.0, -1.0, -4.0, -5.0, 0.0], [-7.0, 1.0, -3.0, -5.0, 3.0], [-5.0, -5.0, 
0.0, -1.0, -3.0]])
      arg1=Data(numpy.array([2.0, 0.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-4.0, 0.0], [8.0, 0.0], [4.0, 0.0], [-14.0, 0.0], [-4.0, 0.0]], [[-6.0, 0.0], [-2.0, 0.0], [-8.0, 
0.0], [-10.0, 0.0], [0.0, 0.0]], [[-14.0, 0.0], [2.0, 0.0], [-6.0, 0.0], [-10.0, 0.0], [6.0, 0.0]], [[-10.0, 0.0], [-10.0, 
0.0], [0.0, 0.0], [-2.0, 0.0], [-6.0, 0.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank2_offset1(self):
      arg0=numpy.array([[[-7.0, -5.0, 0.0], [5.0, -6.0, 6.0], [0.0, -3.0, -7.0], [2.0, -2.0, 5.0], [2.0, 1.0, 3.0]], [[-1.0, 
-4.0, -4.0], [0.0, -5.0, 4.0], [-2.0, -7.0, -3.0], [-6.0, -4.0, -5.0], [0.0, -4.0, -3.0]], [[-2.0, 2.0, 3.0], [-6.0, 5.0, 5.0], 
[3.0, -6.0, 3.0], [-1.0, 0.0, 3.0], [6.0, -1.0, 6.0]], [[-7.0, 1.0, -7.0], [7.0, -2.0, 5.0], [0.0, 5.0, -5.0], [7.0, 4.0, 3.0], 
[-3.0, 4.0, 3.0]]])
      arg1=Data(numpy.array([[-7.0, -3.0], [1.0, 6.0], [5.0, -4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[44.0, -9.0], [-11.0, -75.0], [-38.0, 10.0], [9.0, -38.0], [2.0, -12.0]], [[-17.0, -5.0], [15.0, 
-46.0], [-8.0, -24.0], [13.0, 14.0], [-19.0, -12.0]], [[31.0, 6.0], [72.0, 28.0], [-12.0, -57.0], [22.0, -9.0], [-13.0, 
-48.0]], [[15.0, 55.0], [-26.0, -53.0], [-20.0, 50.0], [-30.0, -9.0], [40.0, 21.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank3_offset2(self):
      arg0=numpy.array([[[[1.0, 5.0, -7.0], [2.0, -1.0, -6.0]], [[6.0, 0.0, 7.0], [-1.0, -7.0, -6.0]], [[2.0, 0.0, 2.0], [7.0, 
7.0, -2.0]], [[4.0, 0.0, 2.0], [5.0, 0.0, 0.0]], [[-3.0, 0.0, 2.0], [0.0, -3.0, -6.0]]], [[[0.0, -6.0, -4.0], [-6.0, 6.0, 
6.0]], [[-1.0, 3.0, -4.0], [-5.0, 3.0, 4.0]], [[3.0, -3.0, -1.0], [0.0, 5.0, -2.0]], [[-5.0, -7.0, -1.0], [0.0, -3.0, 1.0]], 
[[-4.0, 4.0, -5.0], [-2.0, 4.0, 5.0]]], [[[0.0, -1.0, -7.0], [7.0, 5.0, -5.0]], [[1.0, -6.0, 7.0], [6.0, -6.0, 1.0]], [[2.0, 
3.0, 1.0], [0.0, 5.0, 4.0]], [[-6.0, 4.0, -4.0], [0.0, 4.0, 6.0]], [[1.0, -4.0, 2.0], [2.0, 0.0, -3.0]]], [[[-4.0, -7.0, -7.0], 
[0.0, 5.0, 6.0]], [[-4.0, 0.0, 3.0], [-3.0, -2.0, 7.0]], [[-5.0, 4.0, -6.0], [-1.0, 0.0, 0.0]], [[-2.0, 1.0, 0.0], [0.0, 0.0, 
-5.0]], [[6.0, 0.0, -3.0], [2.0, 5.0, -3.0]]]])
      arg1=Data(numpy.array([[[-5.0, 6.0], [0.0, -5.0], [-2.0, -5.0]], [[3.0, -4.0], [0.0, 3.0], [1.0, 
4.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[9.0, -19.0], [-53.0, -40.0], [5.0, -13.0], [-9.0, -6.0], [5.0, -61.0]], [[-4.0, 116.0], [2.0, 
44.0], [-15.0, 45.0], [28.0, 5.0], [29.0, 21.0]], [[30.0, 7.0], [0.0, -37.0], [-8.0, 23.0], [44.0, 0.0], [-6.0, -4.0]], [[40.0, 
85.0], [12.0, -5.0], [34.0, -16.0], [5.0, -37.0], [-21.0, 46.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_constData_rank2_offset0(self):
      arg0=numpy.array([[0.0, -6.0, 0.0, 0.0, 0.0], [0.0, 7.0, -3.0, 6.0, -1.0], [-3.0, -3.0, -3.0, -1.0, 3.0], [-2.0, -3.0, 
1.0, -2.0, 6.0]])
      arg1=Data(numpy.array([[5.0, 0.0, -3.0, -5.0, -1.0], [-2.0, -2.0, 0.0, -4.0, 6.0], [-2.0, 5.0, 5.0, 0.0, -1.0], [3.0, 
-6.0, 3.0, -7.0, 7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0]], [[-30.0, 0.0, 18.0, 30.0, 6.0], [12.0, 12.0, 0.0, 24.0, -36.0], [12.0, -30.0, -30.0, 0.0, 6.0], [-18.0, 36.0, 
-18.0, 42.0, -42.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 
0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[35.0, 0.0, -21.0, -35.0, -7.0], 
[-14.0, -14.0, 0.0, -28.0, 42.0], [-14.0, 35.0, 35.0, 0.0, -7.0], [21.0, -42.0, 21.0, -49.0, 49.0]], [[-15.0, 0.0, 9.0, 15.0, 
3.0], [6.0, 6.0, 0.0, 12.0, -18.0], [6.0, -15.0, -15.0, 0.0, 3.0], [-9.0, 18.0, -9.0, 21.0, -21.0]], [[30.0, 0.0, -18.0, -30.0, 
-6.0], [-12.0, -12.0, 0.0, -24.0, 36.0], [-12.0, 30.0, 30.0, 0.0, -6.0], [18.0, -36.0, 18.0, -42.0, 42.0]], [[-5.0, 0.0, 3.0, 
5.0, 1.0], [2.0, 2.0, 0.0, 4.0, -6.0], [2.0, -5.0, -5.0, 0.0, 1.0], [-3.0, 6.0, -3.0, 7.0, -7.0]]], [[[-15.0, 0.0, 9.0, 15.0, 
3.0], [6.0, 6.0, 0.0, 12.0, -18.0], [6.0, -15.0, -15.0, 0.0, 3.0], [-9.0, 18.0, -9.0, 21.0, -21.0]], [[-15.0, 0.0, 9.0, 15.0, 
3.0], [6.0, 6.0, 0.0, 12.0, -18.0], [6.0, -15.0, -15.0, 0.0, 3.0], [-9.0, 18.0, -9.0, 21.0, -21.0]], [[-15.0, 0.0, 9.0, 15.0, 
3.0], [6.0, 6.0, 0.0, 12.0, -18.0], [6.0, -15.0, -15.0, 0.0, 3.0], [-9.0, 18.0, -9.0, 21.0, -21.0]], [[-5.0, 0.0, 3.0, 5.0, 
1.0], [2.0, 2.0, 0.0, 4.0, -6.0], [2.0, -5.0, -5.0, 0.0, 1.0], [-3.0, 6.0, -3.0, 7.0, -7.0]], [[15.0, 0.0, -9.0, -15.0, -3.0], 
[-6.0, -6.0, 0.0, -12.0, 18.0], [-6.0, 15.0, 15.0, 0.0, -3.0], [9.0, -18.0, 9.0, -21.0, 21.0]]], [[[-10.0, 0.0, 6.0, 10.0, 
2.0], [4.0, 4.0, 0.0, 8.0, -12.0], [4.0, -10.0, -10.0, 0.0, 2.0], [-6.0, 12.0, -6.0, 14.0, -14.0]], [[-15.0, 0.0, 9.0, 15.0, 
3.0], [6.0, 6.0, 0.0, 12.0, -18.0], [6.0, -15.0, -15.0, 0.0, 3.0], [-9.0, 18.0, -9.0, 21.0, -21.0]], [[5.0, 0.0, -3.0, -5.0, 
-1.0], [-2.0, -2.0, 0.0, -4.0, 6.0], [-2.0, 5.0, 5.0, 0.0, -1.0], [3.0, -6.0, 3.0, -7.0, 7.0]], [[-10.0, 0.0, 6.0, 10.0, 2.0], 
[4.0, 4.0, 0.0, 8.0, -12.0], [4.0, -10.0, -10.0, 0.0, 2.0], [-6.0, 12.0, -6.0, 14.0, -14.0]], [[30.0, 0.0, -18.0, -30.0, -6.0], 
[-12.0, -12.0, 0.0, -24.0, 36.0], [-12.0, 30.0, 30.0, 0.0, -6.0], [18.0, -36.0, 18.0, -42.0, 42.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank3_offset1(self):
      arg0=numpy.array([[[-2.0, -7.0, 6.0], [0.0, -6.0, 0.0], [2.0, 1.0, -1.0], [4.0, 5.0, -3.0], [1.0, 7.0, -5.0]], [[1.0, 
0.0, 6.0], [7.0, -1.0, -6.0], [0.0, 3.0, 4.0], [-2.0, 7.0, 0.0], [2.0, 2.0, -1.0]], [[-6.0, 5.0, -1.0], [-7.0, -4.0, -4.0], 
[-5.0, -4.0, 0.0], [1.0, 4.0, 6.0], [0.0, 0.0, -7.0]], [[-3.0, -4.0, -7.0], [3.0, -4.0, -1.0], [3.0, 5.0, 4.0], [0.0, 3.0, 
0.0], [-4.0, -5.0, 7.0]]])
      arg1=Data(numpy.array([[[0.0, 5.0, -7.0, -2.0, -6.0], [5.0, 0.0, 5.0, -3.0, -3.0], [-3.0, -3.0, -4.0, -6.0, 0.0], [-7.0, 
-2.0, 7.0, -5.0, 7.0]], [[0.0, -7.0, 0.0, 4.0, 2.0], [0.0, 0.0, 6.0, 5.0, 2.0], [-1.0, 4.0, -3.0, -7.0, -7.0], [0.0, 0.0, -6.0, 
-5.0, 4.0]], [[0.0, 6.0, 2.0, -5.0, 0.0], [7.0, -1.0, 7.0, -3.0, 6.0], [0.0, 1.0, -2.0, -3.0, 3.0], [-7.0, 0.0, 0.0, 2.0, 
4.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[0.0, 75.0, 26.0, -54.0, -2.0], [32.0, -6.0, -10.0, -47.0, 28.0], [13.0, -16.0, 17.0, 43.0, 
67.0], [-28.0, 4.0, 28.0, 57.0, -18.0]], [[0.0, 42.0, 0.0, -24.0, -12.0], [0.0, 0.0, -36.0, -30.0, -12.0], [6.0, -24.0, 18.0, 
42.0, 42.0], [0.0, 0.0, 36.0, 30.0, -24.0]], [[0.0, -3.0, -16.0, 5.0, -10.0], [3.0, 1.0, 9.0, 2.0, -10.0], [-7.0, -3.0, -9.0, 
-16.0, -10.0], [-7.0, -4.0, 8.0, -17.0, 14.0]], [[0.0, -33.0, -34.0, 27.0, -14.0], [-1.0, 3.0, 29.0, 22.0, -20.0], [-17.0, 5.0, 
-25.0, -50.0, -44.0], [-7.0, -8.0, -2.0, -51.0, 36.0]], [[0.0, -74.0, -17.0, 51.0, 8.0], [-30.0, 5.0, 12.0, 47.0, -19.0], 
[-10.0, 20.0, -15.0, -40.0, -64.0], [28.0, -2.0, -35.0, -50.0, 15.0]]], [[[0.0, 41.0, 5.0, -32.0, -6.0], [47.0, -6.0, 47.0, 
-21.0, 33.0], [-3.0, 3.0, -16.0, -24.0, 18.0], [-49.0, -2.0, 7.0, 7.0, 31.0]], [[0.0, 6.0, -61.0, 12.0, -44.0], [-7.0, 6.0, 
-13.0, -8.0, -59.0], [-20.0, -31.0, -13.0, -17.0, -11.0], [-7.0, -14.0, 55.0, -42.0, 21.0]], [[0.0, 3.0, 8.0, -8.0, 6.0], 
[28.0, -4.0, 46.0, 3.0, 30.0], [-3.0, 16.0, -17.0, -33.0, -9.0], [-28.0, 0.0, -18.0, -7.0, 28.0]], [[0.0, -59.0, 14.0, 32.0, 
26.0], [-10.0, 0.0, 32.0, 41.0, 20.0], [-1.0, 34.0, -13.0, -37.0, -49.0], [14.0, 4.0, -56.0, -25.0, 14.0]], [[0.0, -10.0, 
-16.0, 9.0, -8.0], [3.0, 1.0, 15.0, 7.0, -8.0], [-8.0, 1.0, -12.0, -23.0, -17.0], [-7.0, -4.0, 2.0, -22.0, 18.0]]], [[[0.0, 
-71.0, 40.0, 37.0, 46.0], [-37.0, 1.0, -7.0, 46.0, 22.0], [13.0, 37.0, 11.0, 4.0, -38.0], [49.0, 12.0, -72.0, 3.0, -26.0]], 
[[0.0, -31.0, 41.0, 18.0, 34.0], [-63.0, 4.0, -87.0, 13.0, -11.0], [25.0, 1.0, 48.0, 82.0, 16.0], [77.0, 14.0, -25.0, 47.0, 
-81.0]], [[0.0, 3.0, 35.0, -6.0, 22.0], [-25.0, 0.0, -49.0, -5.0, 7.0], [19.0, -1.0, 32.0, 58.0, 28.0], [35.0, 10.0, -11.0, 
45.0, -51.0]], [[0.0, 13.0, 5.0, -16.0, 2.0], [47.0, -6.0, 71.0, -1.0, 41.0], [-7.0, 19.0, -28.0, -52.0, -10.0], [-49.0, -2.0, 
-17.0, -13.0, 47.0]], [[0.0, -42.0, -14.0, 35.0, 0.0], [-49.0, 7.0, -49.0, 21.0, -42.0], [0.0, -7.0, 14.0, 21.0, -21.0], [49.0, 
0.0, 0.0, -14.0, -28.0]]], [[[0.0, -29.0, 7.0, 25.0, 10.0], [-64.0, 7.0, -88.0, 10.0, -41.0], [13.0, -14.0, 38.0, 67.0, 7.0], 
[70.0, 6.0, 3.0, 21.0, -65.0]], [[0.0, 37.0, -23.0, -17.0, -26.0], [8.0, 1.0, -16.0, -26.0, -23.0], [-5.0, -26.0, 2.0, 13.0, 
25.0], [-14.0, -6.0, 45.0, 3.0, 1.0]], [[0.0, 4.0, -13.0, -6.0, -8.0], [43.0, -4.0, 73.0, 4.0, 25.0], [-14.0, 15.0, -35.0, 
-65.0, -23.0], [-49.0, -6.0, -9.0, -32.0, 57.0]], [[0.0, -21.0, 0.0, 12.0, 6.0], [0.0, 0.0, 18.0, 15.0, 6.0], [-3.0, 12.0, 
-9.0, -21.0, -21.0], [0.0, 0.0, -18.0, -15.0, 12.0]], [[0.0, 57.0, 42.0, -47.0, 14.0], [29.0, -7.0, -1.0, -34.0, 44.0], [17.0, 
-1.0, 17.0, 38.0, 56.0], [-21.0, 8.0, 2.0, 59.0, -20.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank4_offset2(self):
      arg0=numpy.array([[[[-7.0, -7.0, 1.0], [0.0, 0.0, -6.0]], [[1.0, 4.0, 1.0], [-5.0, 3.0, -6.0]], [[7.0, 6.0, -6.0], [0.0, 
-5.0, 4.0]], [[-1.0, -5.0, 5.0], [6.0, 0.0, 5.0]], [[0.0, -3.0, 3.0], [-4.0, 0.0, 7.0]]], [[[5.0, -6.0, -6.0], [0.0, -1.0, 
-3.0]], [[3.0, 0.0, 6.0], [-1.0, -2.0, 4.0]], [[1.0, -7.0, 5.0], [-4.0, 0.0, -2.0]], [[0.0, -7.0, 2.0], [1.0, 6.0, 0.0]], 
[[1.0, 3.0, -3.0], [-5.0, -5.0, 5.0]]], [[[-1.0, -5.0, -5.0], [7.0, 3.0, -2.0]], [[-1.0, 0.0, 7.0], [-3.0, 0.0, -7.0]], [[-2.0, 
7.0, -6.0], [-3.0, -5.0, -2.0]], [[7.0, 6.0, 4.0], [-3.0, -1.0, 6.0]], [[-5.0, 7.0, 2.0], [5.0, 2.0, -3.0]]], [[[6.0, -2.0, 
-6.0], [-6.0, 1.0, 5.0]], [[-2.0, -7.0, 3.0], [6.0, 0.0, 3.0]], [[-3.0, 0.0, -7.0], [-5.0, -6.0, -4.0]], [[7.0, -2.0, 5.0], 
[-4.0, 3.0, 4.0]], [[-4.0, -6.0, -6.0], [2.0, 4.0, 7.0]]]])
      arg1=Data(numpy.array([[[[1.0, 5.0, -3.0, -3.0, 1.0], [0.0, 7.0, -1.0, 0.0, 4.0], [6.0, 2.0, 0.0, -4.0, -3.0], [3.0, 0.0, 
2.0, 6.0, -4.0]], [[0.0, 0.0, -1.0, 3.0, 0.0], [-1.0, 3.0, -6.0, 4.0, -1.0], [0.0, 5.0, -5.0, -4.0, 2.0], [-4.0, -2.0, 0.0, 
0.0, 5.0]], [[-6.0, 0.0, -2.0, 4.0, 4.0], [-6.0, -2.0, 3.0, 2.0, -3.0], [5.0, -5.0, -2.0, 3.0, 3.0], [-4.0, -1.0, -2.0, -4.0, 
-2.0]]], [[[3.0, -5.0, 5.0, 0.0, -7.0], [1.0, 6.0, 5.0, 0.0, 0.0], [-7.0, 6.0, 1.0, -2.0, 3.0], [-6.0, 0.0, 6.0, 0.0, -7.0]], 
[[6.0, 0.0, -3.0, 2.0, 4.0], [4.0, 7.0, 0.0, 3.0, 2.0], [-4.0, -2.0, 4.0, -3.0, -1.0], [7.0, -7.0, 0.0, 5.0, 2.0]], [[6.0, 
-1.0, 0.0, -6.0, -3.0], [0.0, -7.0, -6.0, 7.0, -3.0], [4.0, -1.0, 6.0, 1.0, -5.0], [-2.0, -2.0, -2.0, 4.0, 
-1.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[[-49.0, -29.0, 26.0, 40.0, 15.0], [1.0, -30.0, 88.0, -68.0, -6.0], [-61.0, -48.0, -3.0, 53.0, 
40.0], [15.0, 25.0, -4.0, -70.0, -3.0]], [[-38.0, 36.0, -43.0, 55.0, 70.0], [-3.0, 50.0, -11.0, -15.0, 21.0], [10.0, -13.0, 
-51.0, -22.0, 20.0], [46.0, -18.0, -18.0, -7.0, 61.0]], [[37.0, 31.0, 0.0, -61.0, -49.0], [10.0, 16.0, -85.0, 25.0, 18.0], 
[48.0, 80.0, -14.0, -51.0, -42.0], [-22.0, 21.0, 18.0, 57.0, 0.0]], [[17.0, -40.0, 28.0, -22.0, -38.0], [-19.0, -31.0, 46.0, 
25.0, -29.0], [-3.0, -21.0, 51.0, 32.0, 1.0], [-49.0, -5.0, 14.0, -6.0, -78.0]], [[12.0, 13.0, -23.0, -39.0, 19.0], [-19.0, 
-88.0, -35.0, 43.0, -27.0], [71.0, -61.0, 47.0, 36.0, -44.0], [10.0, -11.0, -44.0, 16.0, 0.0]]], [[[17.0, 28.0, 6.0, -41.0, 
-14.0], [38.0, 43.0, 31.0, -60.0, 51.0], [-8.0, 15.0, 20.0, -14.0, -29.0], [62.0, 31.0, 28.0, 37.0, -37.0]], [[-24.0, 16.0, 
-20.0, -13.0, 14.0], [-45.0, -39.0, -14.0, 34.0, -22.0], [79.0, -30.0, 3.0, 18.0, -12.0], [-31.0, 0.0, -20.0, 0.0, -25.0]], 
[[-53.0, 27.0, -26.0, 8.0, 55.0], [-27.0, -34.0, 48.0, -32.0, 2.0], [51.0, -80.0, 9.0, 45.0, -4.0], [39.0, 13.0, -28.0, -22.0, 
-19.0]], [[27.0, -5.0, -10.0, -1.0, 25.0], [20.0, 23.0, 53.0, -6.0, 13.0], [-21.0, -51.0, 56.0, 14.0, -11.0], [56.0, -30.0, 
2.0, 22.0, -34.0]], [[4.0, 25.0, -10.0, -46.0, -11.0], [-10.0, -78.0, -83.0, 26.0, -15.0], [66.0, 7.0, -4.0, 5.0, -41.0], 
[-12.0, 22.0, -32.0, 13.0, 37.0]]], [[[56.0, -38.0, 44.0, -14.0, -52.0], [54.0, 65.0, 63.0, -35.0, 28.0], [-100.0, 36.0, 42.0, 
-16.0, 6.0], [20.0, -2.0, 54.0, 21.0, -52.0]], [[-94.0, 17.0, -26.0, 73.0, 69.0], [-45.0, 10.0, 49.0, -35.0, -4.0], [22.0, 
-48.0, -59.0, 24.0, 50.0], [1.0, 7.0, -20.0, -62.0, 18.0]], [[-17.0, 7.0, 11.0, 5.0, -19.0], [6.0, -20.0, -61.0, -13.0, -1.0], 
[-9.0, 55.0, -58.0, -19.0, 8.0], [-23.0, 31.0, -6.0, -21.0, 68.0]], [[4.0, 44.0, -47.0, -25.0, 22.0], [-37.0, -8.0, -82.0, 
71.0, -10.0], [111.0, 2.0, -9.0, -25.0, -35.0], [-20.0, -21.0, -24.0, 45.0, 7.0]], [[-8.0, -47.0, 23.0, 66.0, -15.0], [-6.0, 
47.0, 12.0, 17.0, -20.0], [-75.0, 44.0, -44.0, -21.0, 63.0], [-61.0, -24.0, 22.0, -40.0, 23.0]]], [[[60.0, 55.0, -37.0, -76.0, 
13.0], [36.0, -16.0, -72.0, 18.0, 31.0], [64.0, -11.0, 50.0, -20.0, -84.0], [83.0, -7.0, -22.0, 85.0, 17.0]], [[16.0, -43.0, 
37.0, -21.0, -41.0], [-5.0, -26.0, 65.0, -1.0, -19.0], [-27.0, -21.0, 53.0, 36.0, 4.0], [-32.0, 5.0, 20.0, -12.0, -78.0]], 
[[-36.0, 14.0, 16.0, -7.0, -8.0], [13.0, -51.0, -19.0, -60.0, 9.0], [-10.0, 15.0, -39.0, 15.0, -1.0], [15.0, 57.0, -14.0, 
-36.0, 53.0]], [[7.0, 51.0, -58.0, -25.0, 55.0], [-20.0, 2.0, -24.0, 39.0, 9.0], [99.0, -55.0, 32.0, -2.0, -45.0], [46.0, 
-30.0, -28.0, 53.0, -18.0]], [[104.0, -37.0, 28.0, -64.0, -47.0], [60.0, -43.0, -10.0, 25.0, -5.0], [-56.0, -11.0, 102.0, 13.0, 
-51.0], [38.0, -24.0, 2.0, 48.0, -15.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank0_offset0(self):
      arg0=numpy.array([[-5.0, 3.0, 3.0, 0.0, -1.0], [-7.0, 0.0, 0.0, 0.0, -3.0], [2.0, -5.0, -1.0, 1.0, -6.0], [-6.0, -3.0, 
0.0, 1.0, 0.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-3.0)+(1-msk_arg1)*(-2.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[15.0, -9.0, -9.0, -0.0, 3.0], [21.0, -0.0, -0.0, -0.0, 9.0], [-6.0, 15.0, 3.0, -3.0, 18.0], 
[18.0, 9.0, -0.0, -3.0, -0.0]])+(1.-msk_ref)*numpy.array([[10.0, -6.0, -6.0, -0.0, 2.0], [14.0, -0.0, -0.0, -0.0, 6.0], [-4.0, 
10.0, 2.0, -2.0, 12.0], [12.0, 6.0, -0.0, -2.0, -0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank1_offset1(self):
      arg0=numpy.array([[[-1.0, 6.0, -2.0], [5.0, 6.0, 1.0], [-1.0, 0.0, -3.0], [-1.0, -5.0, -6.0], [-6.0, -1.0, -7.0]], [[3.0, 
-1.0, 6.0], [-2.0, -2.0, -4.0], [2.0, -1.0, 7.0], [4.0, 1.0, 3.0], [-4.0, 1.0, 5.0]], [[-7.0, 2.0, 2.0], [2.0, 2.0, -3.0], 
[-5.0, -6.0, -1.0], [-6.0, 6.0, 5.0], [2.0, 4.0, -3.0]], [[1.0, 0.0, 2.0], [7.0, 6.0, -6.0], [-1.0, -5.0, -6.0], [0.0, -1.0, 
-5.0], [-5.0, -1.0, 5.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-2.0, -2.0, 2.0])+(1.-msk_arg1)*numpy.array([0.0, 0.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-14.0, -20.0, -4.0, 0.0, 0.0], [8.0, 0.0, 12.0, -4.0, 16.0], [14.0, -14.0, 20.0, 10.0, -18.0], 
[2.0, -38.0, 0.0, -8.0, 22.0]])+(1.-msk_ref)*numpy.array([[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank2_offset2(self):
      arg0=numpy.array([[[[5.0, -3.0, 1.0], [1.0, -2.0, 1.0]], [[-7.0, 5.0, 1.0], [3.0, 2.0, -2.0]], [[-6.0, 2.0, -4.0], [-6.0, 
1.0, -5.0]], [[5.0, -1.0, 0.0], [-3.0, 1.0, 2.0]], [[-1.0, 4.0, 0.0], [0.0, 4.0, -4.0]]], [[[3.0, 4.0, 3.0], [-5.0, -2.0, 
5.0]], [[3.0, -2.0, -5.0], [0.0, -4.0, 0.0]], [[5.0, 5.0, -7.0], [-6.0, 2.0, -2.0]], [[3.0, -3.0, 0.0], [-2.0, 3.0, -6.0]], 
[[-3.0, 1.0, 2.0], [6.0, 5.0, -3.0]]], [[[4.0, 0.0, 0.0], [-1.0, 2.0, -1.0]], [[-4.0, 1.0, 1.0], [6.0, 4.0, -4.0]], [[-1.0, 
-2.0, -4.0], [-6.0, 3.0, -7.0]], [[0.0, -3.0, 0.0], [6.0, -1.0, -3.0]], [[-6.0, 0.0, 3.0], [1.0, 7.0, -7.0]]], [[[0.0, 0.0, 
-4.0], [-4.0, 1.0, -6.0]], [[-1.0, 2.0, 3.0], [-1.0, 5.0, -5.0]], [[5.0, 3.0, 3.0], [4.0, -2.0, 1.0]], [[1.0, -4.0, 0.0], [5.0, 
3.0, 5.0]], [[5.0, 6.0, -3.0], [1.0, 5.0, 5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-1.0, 1.0, 1.0], [6.0, -7.0, -7.0]])+(1.-msk_arg1)*numpy.array([[3.0, 6.0, -7.0], [7.0, 6.0, 
4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[6.0, 31.0, -4.0, -45.0, 5.0], [-47.0, 18.0, -43.0, 3.0, 28.0], [-17.0, 42.0, -13.0, 61.0, 
15.0], [7.0, 0.0, 32.0, -31.0, -66.0]])+(1.-msk_ref)*numpy.array([[-11.0, 27.0, -34.0, 2.0, 29.0], [-15.0, 8.0, 56.0, -29.0, 
43.0], [13.0, 37.0, -39.0, 6.0, -18.0], [-18.0, -9.0, 32.0, 52.0, 129.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank1_offset0(self):
      arg0=numpy.array([[7.0, -2.0, 0.0, -1.0, 5.0], [-4.0, 7.0, 1.0, -2.0, -1.0], [-1.0, 2.0, -7.0, -5.0, 6.0], [0.0, -7.0, 
-5.0, 3.0, -5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-5.0, -5.0])+(1.-msk_arg1)*numpy.array([0.0, -7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-35.0, -35.0], [10.0, 10.0], [0.0, 0.0], [5.0, 5.0], [-25.0, -25.0]], [[20.0, 20.0], [-35.0, 
-35.0], [-5.0, -5.0], [10.0, 10.0], [5.0, 5.0]], [[5.0, 5.0], [-10.0, -10.0], [35.0, 35.0], [25.0, 25.0], [-30.0, -30.0]], 
[[0.0, 0.0], [35.0, 35.0], [25.0, 25.0], [-15.0, -15.0], [25.0, 25.0]]])+(1.-msk_ref)*numpy.array([[[0.0, -49.0], [0.0, 14.0], 
[0.0, 0.0], [0.0, 7.0], [0.0, -35.0]], [[0.0, 28.0], [0.0, -49.0], [0.0, -7.0], [0.0, 14.0], [0.0, 7.0]], [[0.0, 7.0], [0.0, 
-14.0], [0.0, 49.0], [0.0, 35.0], [0.0, -42.0]], [[0.0, 0.0], [0.0, 49.0], [0.0, 35.0], [0.0, -21.0], [0.0, 35.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank2_offset1(self):
      arg0=numpy.array([[[-6.0, -2.0, -7.0], [5.0, -2.0, 3.0], [7.0, -7.0, -3.0], [5.0, -7.0, -1.0], [6.0, 0.0, 3.0]], [[-6.0, 
-3.0, -5.0], [6.0, 5.0, 5.0], [-2.0, 5.0, -4.0], [5.0, 0.0, 1.0], [-6.0, -6.0, 6.0]], [[-7.0, 7.0, -1.0], [2.0, -3.0, -4.0], 
[-1.0, 2.0, 7.0], [5.0, -5.0, -4.0], [-2.0, 6.0, -7.0]], [[5.0, 1.0, 6.0], [-1.0, -1.0, -5.0], [-5.0, -3.0, 5.0], [6.0, -6.0, 
-6.0], [0.0, 0.0, -5.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[0.0, 7.0], [3.0, -3.0], [-2.0, 4.0]])+(1.-msk_arg1)*numpy.array([[3.0, 4.0], [-4.0, -6.0], 
[-4.0, -2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, -64.0], [-12.0, 53.0], [-15.0, 58.0], [-19.0, 52.0], [-6.0, 54.0]], [[1.0, -53.0], [5.0, 
47.0], [23.0, -45.0], [-2.0, 39.0], [-30.0, 0.0]], [[23.0, -74.0], [-1.0, 7.0], [-8.0, 15.0], [-7.0, 34.0], [32.0, -60.0]], 
[[-9.0, 56.0], [7.0, -24.0], [-19.0, -6.0], [-6.0, 36.0], [10.0, -20.0]]])+(1.-msk_ref)*numpy.array([[[18.0, 2.0], [11.0, 
26.0], [61.0, 76.0], [47.0, 64.0], [6.0, 18.0]], [[14.0, 4.0], [-22.0, -16.0], [-10.0, -30.0], [11.0, 18.0], [-18.0, 0.0]], 
[[-45.0, -68.0], [34.0, 34.0], [-39.0, -30.0], [51.0, 58.0], [-2.0, -30.0]], [[-13.0, 2.0], [21.0, 12.0], [-23.0, -12.0], 
[66.0, 72.0], [20.0, 10.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank3_offset2(self):
      arg0=numpy.array([[[[-4.0, 1.0, 0.0], [0.0, -5.0, 1.0]], [[6.0, -4.0, -2.0], [-2.0, 3.0, -1.0]], [[2.0, 7.0, 0.0], [5.0, 
-2.0, 0.0]], [[7.0, 7.0, 3.0], [3.0, -1.0, -4.0]], [[-2.0, -1.0, -5.0], [0.0, 1.0, -3.0]]], [[[0.0, -5.0, -6.0], [6.0, 0.0, 
-1.0]], [[-2.0, -5.0, -1.0], [-7.0, -3.0, -4.0]], [[7.0, -7.0, -3.0], [-5.0, -2.0, 3.0]], [[-2.0, 4.0, -5.0], [4.0, 7.0, 
-7.0]], [[3.0, 0.0, 2.0], [7.0, -2.0, -1.0]]], [[[-3.0, -7.0, 5.0], [-4.0, -2.0, -4.0]], [[6.0, -6.0, 6.0], [0.0, 5.0, -7.0]], 
[[0.0, 3.0, -1.0], [-5.0, -6.0, 1.0]], [[1.0, -1.0, 0.0], [5.0, 7.0, 1.0]], [[4.0, 5.0, -3.0], [-7.0, 0.0, 0.0]]], [[[1.0, 
-6.0, -4.0], [1.0, 1.0, 1.0]], [[-3.0, -1.0, 4.0], [1.0, -6.0, 6.0]], [[6.0, 7.0, -7.0], [-6.0, 0.0, 2.0]], [[1.0, 4.0, -7.0], 
[6.0, -6.0, 6.0]], [[-3.0, 4.0, 0.0], [-3.0, -7.0, -7.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[3.0, 7.0], [-1.0, 5.0], [6.0, 6.0]], [[6.0, 7.0], [-4.0, -2.0], [7.0, 
3.0]]])+(1.-msk_arg1)*numpy.array([[[-6.0, -2.0], [2.0, -2.0], [4.0, 2.0]], [[-4.0, -7.0], [4.0, 4.0], [-7.0, -6.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[14.0, -10.0], [-21.0, -13.0], [37.0, 88.0], [26.0, 113.0], [-60.0, -60.0]], [[-2.0, -22.0], 
[-65.0, -100.0], [9.0, -26.0], [-93.0, -31.0], [64.0, 83.0]], [[-16.0, -62.0], [-9.0, 17.0], [-8.0, -11.0], [13.0, 26.0], 
[-53.0, -14.0]], [[-6.0, -39.0], [88.0, 35.0], [-53.0, -1.0], [59.0, 57.0], [-52.0, -29.0]]])+(1.-msk_ref)*numpy.array([[[-1.0, 
-20.0], [-25.0, 24.0], [-26.0, -61.0], [-4.0, -23.0], [15.0, 18.0]], [[-51.0, -38.0], [42.0, 73.0], [-77.0, 3.0], [61.0, 28.0], 
[-39.0, -53.0]], [[60.0, 74.0], [45.0, 74.0], [-9.0, -3.0], [-7.0, -13.0], [2.0, 25.0]], [[-41.0, -7.0], [-38.0, -51.0], 
[-40.0, -10.0], [-116.0, -126.0], [59.0, 33.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank2_expandedData_rank2_offset0(self):
      arg0=numpy.array([[6.0, 7.0, -6.0, 5.0, 0.0], [2.0, -4.0, -1.0, 0.0, 0.0], [6.0, 2.0, -2.0, 5.0, -1.0], [5.0, -4.0, 5.0, 
1.0, 3.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, 5.0, 0.0, -2.0, 6.0], [-3.0, -7.0, -2.0, -3.0, 0.0], [0.0, -6.0, 6.0, 0.0, -6.0], 
[-3.0, -6.0, 6.0, -3.0, -3.0]])+(1.-msk_arg1)*numpy.array([[4.0, 0.0, 6.0, -4.0, 5.0], [-7.0, 0.0, 3.0, -2.0, 1.0], [0.0, 3.0, 
-7.0, 4.0, -5.0], [-4.0, -5.0, 6.0, 1.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-24.0, 30.0, 0.0, -12.0, 36.0], [-18.0, -42.0, -12.0, -18.0, 0.0], [0.0, -36.0, 36.0, 0.0, 
-36.0], [-18.0, -36.0, 36.0, -18.0, -18.0]], [[-28.0, 35.0, 0.0, -14.0, 42.0], [-21.0, -49.0, -14.0, -21.0, 0.0], [0.0, -42.0, 
42.0, 0.0, -42.0], [-21.0, -42.0, 42.0, -21.0, -21.0]], [[24.0, -30.0, 0.0, 12.0, -36.0], [18.0, 42.0, 12.0, 18.0, 0.0], [0.0, 
36.0, -36.0, 0.0, 36.0], [18.0, 36.0, -36.0, 18.0, 18.0]], [[-20.0, 25.0, 0.0, -10.0, 30.0], [-15.0, -35.0, -10.0, -15.0, 0.0], 
[0.0, -30.0, 30.0, 0.0, -30.0], [-15.0, -30.0, 30.0, -15.0, -15.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[-8.0, 10.0, 0.0, -4.0, 12.0], [-6.0, -14.0, -4.0, -6.0, 0.0], [0.0, 
-12.0, 12.0, 0.0, -12.0], [-6.0, -12.0, 12.0, -6.0, -6.0]], [[16.0, -20.0, 0.0, 8.0, -24.0], [12.0, 28.0, 8.0, 12.0, 0.0], 
[0.0, 24.0, -24.0, 0.0, 24.0], [12.0, 24.0, -24.0, 12.0, 12.0]], [[4.0, -5.0, 0.0, 2.0, -6.0], [3.0, 7.0, 2.0, 3.0, 0.0], [0.0, 
6.0, -6.0, 0.0, 6.0], [3.0, 6.0, -6.0, 3.0, 3.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0]]], [[[-24.0, 30.0, 0.0, -12.0, 36.0], [-18.0, -42.0, -12.0, -18.0, 0.0], [0.0, -36.0, 36.0, 0.0, -36.0], [-18.0, 
-36.0, 36.0, -18.0, -18.0]], [[-8.0, 10.0, 0.0, -4.0, 12.0], [-6.0, -14.0, -4.0, -6.0, 0.0], [0.0, -12.0, 12.0, 0.0, -12.0], 
[-6.0, -12.0, 12.0, -6.0, -6.0]], [[8.0, -10.0, 0.0, 4.0, -12.0], [6.0, 14.0, 4.0, 6.0, 0.0], [0.0, 12.0, -12.0, 0.0, 12.0], 
[6.0, 12.0, -12.0, 6.0, 6.0]], [[-20.0, 25.0, 0.0, -10.0, 30.0], [-15.0, -35.0, -10.0, -15.0, 0.0], [0.0, -30.0, 30.0, 0.0, 
-30.0], [-15.0, -30.0, 30.0, -15.0, -15.0]], [[4.0, -5.0, 0.0, 2.0, -6.0], [3.0, 7.0, 2.0, 3.0, 0.0], [0.0, 6.0, -6.0, 0.0, 
6.0], [3.0, 6.0, -6.0, 3.0, 3.0]]], [[[-20.0, 25.0, 0.0, -10.0, 30.0], [-15.0, -35.0, -10.0, -15.0, 0.0], [0.0, -30.0, 30.0, 
0.0, -30.0], [-15.0, -30.0, 30.0, -15.0, -15.0]], [[16.0, -20.0, 0.0, 8.0, -24.0], [12.0, 28.0, 8.0, 12.0, 0.0], [0.0, 24.0, 
-24.0, 0.0, 24.0], [12.0, 24.0, -24.0, 12.0, 12.0]], [[-20.0, 25.0, 0.0, -10.0, 30.0], [-15.0, -35.0, -10.0, -15.0, 0.0], [0.0, 
-30.0, 30.0, 0.0, -30.0], [-15.0, -30.0, 30.0, -15.0, -15.0]], [[-4.0, 5.0, 0.0, -2.0, 6.0], [-3.0, -7.0, -2.0, -3.0, 0.0], 
[0.0, -6.0, 6.0, 0.0, -6.0], [-3.0, -6.0, 6.0, -3.0, -3.0]], [[-12.0, 15.0, 0.0, -6.0, 18.0], [-9.0, -21.0, -6.0, -9.0, 0.0], 
[0.0, -18.0, 18.0, 0.0, -18.0], [-9.0, -18.0, 18.0, -9.0, -9.0]]]])+(1.-msk_ref)*numpy.array([[[[24.0, 0.0, 36.0, -24.0, 30.0], 
[-42.0, 0.0, 18.0, -12.0, 6.0], [0.0, 18.0, -42.0, 24.0, -30.0], [-24.0, -30.0, 36.0, 6.0, -24.0]], [[28.0, 0.0, 42.0, -28.0, 
35.0], [-49.0, 0.0, 21.0, -14.0, 7.0], [0.0, 21.0, -49.0, 28.0, -35.0], [-28.0, -35.0, 42.0, 7.0, -28.0]], [[-24.0, 0.0, -36.0, 
24.0, -30.0], [42.0, 0.0, -18.0, 12.0, -6.0], [0.0, -18.0, 42.0, -24.0, 30.0], [24.0, 30.0, -36.0, -6.0, 24.0]], [[20.0, 0.0, 
30.0, -20.0, 25.0], [-35.0, 0.0, 15.0, -10.0, 5.0], [0.0, 15.0, -35.0, 20.0, -25.0], [-20.0, -25.0, 30.0, 5.0, -20.0]], [[0.0, 
0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[8.0, 0.0, 12.0, 
-8.0, 10.0], [-14.0, 0.0, 6.0, -4.0, 2.0], [0.0, 6.0, -14.0, 8.0, -10.0], [-8.0, -10.0, 12.0, 2.0, -8.0]], [[-16.0, 0.0, -24.0, 
16.0, -20.0], [28.0, 0.0, -12.0, 8.0, -4.0], [0.0, -12.0, 28.0, -16.0, 20.0], [16.0, 20.0, -24.0, -4.0, 16.0]], [[-4.0, 0.0, 
-6.0, 4.0, -5.0], [7.0, 0.0, -3.0, 2.0, -1.0], [0.0, -3.0, 7.0, -4.0, 5.0], [4.0, 5.0, -6.0, -1.0, 4.0]], [[0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[24.0, 0.0, 36.0, -24.0, 30.0], [-42.0, 0.0, 18.0, 
-12.0, 6.0], [0.0, 18.0, -42.0, 24.0, -30.0], [-24.0, -30.0, 36.0, 6.0, -24.0]], [[8.0, 0.0, 12.0, -8.0, 10.0], [-14.0, 0.0, 
6.0, -4.0, 2.0], [0.0, 6.0, -14.0, 8.0, -10.0], [-8.0, -10.0, 12.0, 2.0, -8.0]], [[-8.0, 0.0, -12.0, 8.0, -10.0], [14.0, 0.0, 
-6.0, 4.0, -2.0], [0.0, -6.0, 14.0, -8.0, 10.0], [8.0, 10.0, -12.0, -2.0, 8.0]], [[20.0, 0.0, 30.0, -20.0, 25.0], [-35.0, 0.0, 
15.0, -10.0, 5.0], [0.0, 15.0, -35.0, 20.0, -25.0], [-20.0, -25.0, 30.0, 5.0, -20.0]], [[-4.0, 0.0, -6.0, 4.0, -5.0], [7.0, 
0.0, -3.0, 2.0, -1.0], [0.0, -3.0, 7.0, -4.0, 5.0], [4.0, 5.0, -6.0, -1.0, 4.0]]], [[[20.0, 0.0, 30.0, -20.0, 25.0], [-35.0, 
0.0, 15.0, -10.0, 5.0], [0.0, 15.0, -35.0, 20.0, -25.0], [-20.0, -25.0, 30.0, 5.0, -20.0]], [[-16.0, 0.0, -24.0, 16.0, -20.0], 
[28.0, 0.0, -12.0, 8.0, -4.0], [0.0, -12.0, 28.0, -16.0, 20.0], [16.0, 20.0, -24.0, -4.0, 16.0]], [[20.0, 0.0, 30.0, -20.0, 
25.0], [-35.0, 0.0, 15.0, -10.0, 5.0], [0.0, 15.0, -35.0, 20.0, -25.0], [-20.0, -25.0, 30.0, 5.0, -20.0]], [[4.0, 0.0, 6.0, 
-4.0, 5.0], [-7.0, 0.0, 3.0, -2.0, 1.0], [0.0, 3.0, -7.0, 4.0, -5.0], [-4.0, -5.0, 6.0, 1.0, -4.0]], [[12.0, 0.0, 18.0, -12.0, 
15.0], [-21.0, 0.0, 9.0, -6.0, 3.0], [0.0, 9.0, -21.0, 12.0, -15.0], [-12.0, -15.0, 18.0, 3.0, -12.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=0)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank3_offset1(self):
      arg0=numpy.array([[[-4.0, 7.0, -5.0], [-6.0, -3.0, 0.0], [1.0, -1.0, -5.0], [-4.0, 5.0, 7.0], [5.0, 7.0, -7.0]], [[1.0, 
0.0, 0.0], [-1.0, -2.0, 2.0], [-4.0, 6.0, 6.0], [0.0, 1.0, 6.0], [2.0, 2.0, -7.0]], [[3.0, 6.0, 0.0], [2.0, -4.0, -1.0], [3.0, 
6.0, -4.0], [7.0, -5.0, -6.0], [-6.0, 7.0, -2.0]], [[4.0, -7.0, 3.0], [-3.0, -7.0, 2.0], [7.0, 5.0, -4.0], [4.0, -3.0, 0.0], 
[-7.0, 6.0, 3.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, -3.0, -3.0, -4.0, -5.0], [-6.0, 2.0, 6.0, -6.0, 7.0], [5.0, -4.0, 2.0, 5.0, -5.0], 
[1.0, 0.0, 7.0, -3.0, -2.0]], [[5.0, -7.0, 2.0, 5.0, -7.0], [6.0, -6.0, 3.0, 2.0, 0.0], [2.0, -1.0, 3.0, 2.0, 0.0], [0.0, 0.0, 
-4.0, -7.0, -5.0]], [[2.0, -5.0, -5.0, -4.0, 1.0], [3.0, 0.0, -7.0, 6.0, -4.0], [-1.0, -7.0, 0.0, 1.0, 0.0], [0.0, -2.0, -2.0, 
6.0, -3.0]]])+(1.-msk_arg1)*numpy.array([[[6.0, -4.0, 5.0, 0.0, 4.0], [-6.0, 0.0, 2.0, 0.0, 0.0], [0.0, 7.0, 2.0, 1.0, 2.0], 
[-5.0, 2.0, 4.0, 2.0, 0.0]], [[-5.0, -2.0, 7.0, 7.0, 3.0], [3.0, 4.0, 5.0, 0.0, -6.0], [-5.0, -3.0, 7.0, 0.0, -7.0], [-5.0, 
-6.0, 0.0, 3.0, 0.0]], [[6.0, 0.0, 4.0, 2.0, 0.0], [6.0, 0.0, 1.0, 1.0, -5.0], [1.0, 5.0, -4.0, -6.0, 0.0], [-7.0, -7.0, -6.0, 
4.0, -4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[49.0, -12.0, 51.0, 71.0, -34.0], [51.0, -50.0, 32.0, 8.0, -8.0], [-1.0, 44.0, 13.0, -11.0, 
20.0], [-4.0, 10.0, -46.0, -67.0, -12.0]], [[21.0, 39.0, 12.0, 9.0, 51.0], [18.0, 6.0, -45.0, 30.0, -42.0], [-36.0, 27.0, 
-21.0, -36.0, 30.0], [-6.0, 0.0, -30.0, 39.0, 27.0]], [[-21.0, 29.0, 20.0, 11.0, -3.0], [-27.0, 8.0, 38.0, -38.0, 27.0], [8.0, 
32.0, -1.0, -2.0, -5.0], [1.0, 10.0, 21.0, -26.0, 18.0]], [[63.0, -58.0, -13.0, 13.0, -8.0], [75.0, -38.0, -58.0, 76.0, -56.0], 
[-17.0, -38.0, 7.0, -3.0, 20.0], [-4.0, -14.0, -62.0, 19.0, -38.0]], [[-9.0, -29.0, 34.0, 43.0, -81.0], [-9.0, -32.0, 100.0, 
-58.0, 63.0], [46.0, 22.0, 31.0, 32.0, -25.0], [5.0, 14.0, 21.0, -106.0, -24.0]]], [[[-6.0, -3.0, -3.0, -4.0, -5.0], [-6.0, 
2.0, 6.0, -6.0, 7.0], [5.0, -4.0, 2.0, 5.0, -5.0], [1.0, 0.0, 7.0, -3.0, -2.0]], [[0.0, 7.0, -11.0, -14.0, 21.0], [0.0, 10.0, 
-26.0, 14.0, -15.0], [-11.0, -8.0, -8.0, -7.0, 5.0], [-1.0, -4.0, -3.0, 29.0, 6.0]], [[66.0, -60.0, -6.0, 22.0, -16.0], [78.0, 
-44.0, -48.0, 72.0, -52.0], [-14.0, -32.0, 10.0, -2.0, 20.0], [-4.0, -12.0, -64.0, 6.0, -40.0]], [[17.0, -37.0, -28.0, -19.0, 
-1.0], [24.0, -6.0, -39.0, 38.0, -24.0], [-4.0, -43.0, 3.0, 8.0, 0.0], [0.0, -12.0, -16.0, 29.0, -23.0]], [[-16.0, 15.0, 33.0, 
30.0, -31.0], [-21.0, -8.0, 67.0, -50.0, 42.0], [21.0, 39.0, 10.0, 7.0, -10.0], [2.0, 14.0, 20.0, -62.0, 7.0]]], [[[12.0, 
-51.0, 3.0, 18.0, -57.0], [18.0, -30.0, 36.0, -6.0, 21.0], [27.0, -18.0, 24.0, 27.0, -15.0], [3.0, 0.0, -3.0, -51.0, -36.0]], 
[[-34.0, 27.0, -9.0, -24.0, 17.0], [-39.0, 28.0, 7.0, -26.0, 18.0], [3.0, 3.0, -8.0, 1.0, -10.0], [2.0, 2.0, 32.0, 16.0, 
19.0]], [[4.0, -31.0, 23.0, 34.0, -61.0], [6.0, -30.0, 64.0, -30.0, 37.0], [31.0, 10.0, 24.0, 23.0, -15.0], [3.0, 8.0, 5.0, 
-75.0, -24.0]], [[-79.0, 44.0, -1.0, -29.0, -6.0], [-90.0, 44.0, 69.0, -88.0, 73.0], [31.0, 19.0, -1.0, 19.0, -35.0], [7.0, 
12.0, 81.0, -22.0, 29.0]], [[67.0, -21.0, 42.0, 67.0, -21.0], [72.0, -54.0, -1.0, 38.0, -34.0], [-14.0, 31.0, 9.0, -18.0, 
30.0], [-6.0, 4.0, -66.0, -43.0, -17.0]]], [[[-53.0, 22.0, -41.0, -63.0, 32.0], [-57.0, 50.0, -18.0, -20.0, 16.0], [3.0, -30.0, 
-13.0, 9.0, -20.0], [4.0, -6.0, 50.0, 55.0, 18.0]], [[-13.0, 48.0, -15.0, -31.0, 66.0], [-18.0, 36.0, -53.0, 16.0, -29.0], 
[-31.0, 5.0, -27.0, -27.0, 15.0], [-3.0, -4.0, 3.0, 70.0, 35.0]], [[-25.0, -36.0, 9.0, 13.0, -74.0], [-24.0, -16.0, 85.0, 
-56.0, 65.0], [49.0, -5.0, 29.0, 41.0, -35.0], [7.0, 8.0, 37.0, -80.0, -27.0]], [[-39.0, 9.0, -18.0, -31.0, 1.0], [-42.0, 26.0, 
15.0, -30.0, 28.0], [14.0, -13.0, -1.0, 14.0, -20.0], [4.0, 0.0, 40.0, 9.0, 7.0]], [[78.0, -36.0, 18.0, 46.0, -4.0], [87.0, 
-50.0, -45.0, 72.0, -61.0], [-26.0, 1.0, 4.0, -20.0, 35.0], [-7.0, -6.0, -79.0, -3.0, 
-25.0]]]])+(1.-msk_ref)*numpy.array([[[[-89.0, 2.0, 9.0, 39.0, 5.0], [15.0, 28.0, 22.0, -5.0, -17.0], [-40.0, -74.0, 61.0, 
26.0, -57.0], [20.0, -15.0, 14.0, -7.0, 20.0]], [[-21.0, 30.0, -51.0, -21.0, -33.0], [27.0, -12.0, -27.0, 0.0, 18.0], [15.0, 
-33.0, -33.0, -6.0, 9.0], [45.0, 6.0, -24.0, -21.0, 0.0]], [[-19.0, -2.0, -22.0, -17.0, 1.0], [-39.0, -4.0, -8.0, -5.0, 31.0], 
[0.0, -15.0, 15.0, 31.0, 9.0], [35.0, 43.0, 34.0, -21.0, 20.0]], [[-7.0, 6.0, 43.0, 49.0, -1.0], [81.0, 20.0, 24.0, 7.0, 
-65.0], [-18.0, -8.0, -1.0, -46.0, -43.0], [-54.0, -87.0, -58.0, 35.0, -28.0]], [[-47.0, -34.0, 46.0, 35.0, 41.0], [-51.0, 
28.0, 38.0, -7.0, -7.0], [-42.0, -21.0, 87.0, 47.0, -39.0], [-11.0, 17.0, 62.0, 3.0, 28.0]]], [[[6.0, -4.0, 5.0, 0.0, 4.0], 
[-6.0, 0.0, 2.0, 0.0, 0.0], [0.0, 7.0, 2.0, 1.0, 2.0], [-5.0, 2.0, 4.0, 2.0, 0.0]], [[16.0, 8.0, -11.0, -10.0, -10.0], [12.0, 
-8.0, -10.0, 2.0, 2.0], [12.0, 9.0, -24.0, -13.0, 12.0], [1.0, -4.0, -16.0, 0.0, -8.0]], [[-18.0, 4.0, 46.0, 54.0, 2.0], [78.0, 
24.0, 28.0, 6.0, -66.0], [-24.0, -16.0, 10.0, -40.0, -50.0], [-52.0, -86.0, -52.0, 34.0, -24.0]], [[31.0, -2.0, 31.0, 19.0, 
3.0], [39.0, 4.0, 11.0, 6.0, -36.0], [1.0, 27.0, -17.0, -36.0, -7.0], [-47.0, -48.0, -36.0, 27.0, -24.0]], [[-40.0, -12.0, 
-4.0, 0.0, 14.0], [-48.0, 8.0, 7.0, -7.0, 23.0], [-17.0, -27.0, 46.0, 44.0, -10.0], [29.0, 41.0, 50.0, -18.0, 28.0]]], 
[[[-12.0, -24.0, 57.0, 42.0, 30.0], [0.0, 24.0, 36.0, 0.0, -36.0], [-30.0, 3.0, 48.0, 3.0, -36.0], [-45.0, -30.0, 12.0, 24.0, 
0.0]], [[26.0, 0.0, -22.0, -30.0, -4.0], [-30.0, -16.0, -17.0, -1.0, 29.0], [19.0, 21.0, -20.0, 8.0, 32.0], [17.0, 35.0, 14.0, 
-12.0, 4.0]], [[-36.0, -24.0, 41.0, 34.0, 30.0], [-24.0, 24.0, 32.0, -4.0, -16.0], [-34.0, -17.0, 64.0, 27.0, -36.0], [-17.0, 
-2.0, 36.0, 8.0, 16.0]], [[31.0, -18.0, -24.0, -47.0, 13.0], [-93.0, -20.0, -17.0, -6.0, 60.0], [19.0, 34.0, 3.0, 43.0, 49.0], 
[32.0, 86.0, 64.0, -25.0, 24.0]], [[-83.0, 10.0, 11.0, 45.0, -3.0], [45.0, 28.0, 21.0, -2.0, -32.0], [-37.0, -73.0, 45.0, 6.0, 
-61.0], [9.0, -40.0, -12.0, 1.0, 8.0]]], [[[77.0, -2.0, -17.0, -43.0, -5.0], [-27.0, -28.0, -24.0, 3.0, 27.0], [38.0, 64.0, 
-53.0, -14.0, 57.0], [-6.0, 29.0, -2.0, -1.0, -12.0]], [[29.0, 26.0, -56.0, -45.0, -33.0], [9.0, -28.0, -39.0, 2.0, 32.0], 
[37.0, 10.0, -63.0, -15.0, 43.0], [36.0, 22.0, -24.0, -19.0, -8.0]], [[-7.0, -38.0, 54.0, 27.0, 43.0], [-51.0, 20.0, 35.0, 
-4.0, -10.0], [-29.0, 14.0, 65.0, 31.0, -21.0], [-32.0, 12.0, 52.0, 13.0, 16.0]], [[39.0, -10.0, -1.0, -21.0, 7.0], [-33.0, 
-12.0, -7.0, 0.0, 18.0], [15.0, 37.0, -13.0, 4.0, 29.0], [-5.0, 26.0, 16.0, -1.0, 0.0]], [[-54.0, 16.0, 19.0, 48.0, -10.0], 
[78.0, 24.0, 19.0, 3.0, -51.0], [-27.0, -52.0, 16.0, -25.0, -56.0], [-16.0, -71.0, -46.0, 16.0, -12.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank4_offset2(self):
      arg0=numpy.array([[[[-6.0, 7.0, -2.0], [-2.0, -5.0, 4.0]], [[-2.0, -3.0, 3.0], [-3.0, 2.0, -6.0]], [[1.0, 7.0, -7.0], 
[-5.0, 5.0, -5.0]], [[4.0, 5.0, -5.0], [6.0, -6.0, -6.0]], [[4.0, -7.0, -1.0], [4.0, 1.0, -5.0]]], [[[-6.0, 7.0, 6.0], [-1.0, 
7.0, -2.0]], [[0.0, -6.0, -3.0], [3.0, 2.0, -7.0]], [[0.0, 2.0, 1.0], [-1.0, 0.0, 3.0]], [[-2.0, -1.0, -4.0], [-5.0, -3.0, 
-2.0]], [[4.0, 7.0, 4.0], [4.0, 2.0, -2.0]]], [[[4.0, -1.0, 0.0], [4.0, 0.0, 2.0]], [[-5.0, 3.0, 4.0], [-7.0, -6.0, -3.0]], 
[[1.0, 7.0, -6.0], [7.0, 2.0, -2.0]], [[0.0, 0.0, 3.0], [5.0, -5.0, 2.0]], [[-3.0, -7.0, 0.0], [-7.0, -5.0, -7.0]]], [[[0.0, 
5.0, 7.0], [3.0, -7.0, -2.0]], [[3.0, -5.0, 7.0], [5.0, -7.0, 0.0]], [[-6.0, 3.0, 5.0], [-4.0, 5.0, 2.0]], [[7.0, 0.0, -3.0], 
[1.0, 6.0, 0.0]], [[-1.0, 4.0, 5.0], [-2.0, -2.0, -4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-7.0, 2.0, -2.0, 4.0, -4.0], [1.0, 1.0, 3.0, 4.0, 2.0], [5.0, -5.0, -3.0, 2.0, -1.0], 
[-3.0, 6.0, -3.0, -1.0, -7.0]], [[0.0, -4.0, -4.0, -4.0, 2.0], [6.0, 7.0, -7.0, -7.0, 4.0], [0.0, 4.0, -5.0, 1.0, -3.0], [-7.0, 
2.0, -5.0, -6.0, 5.0]], [[-7.0, -7.0, -4.0, -3.0, -1.0], [1.0, -3.0, -4.0, -1.0, -6.0], [7.0, 2.0, -6.0, 0.0, 0.0], [-3.0, 
-5.0, -3.0, -6.0, -7.0]]], [[[0.0, 0.0, -4.0, 5.0, 7.0], [-1.0, -3.0, -3.0, 0.0, 0.0], [2.0, -3.0, 5.0, -3.0, 7.0], [0.0, -6.0, 
-2.0, 6.0, 2.0]], [[5.0, 7.0, 7.0, 3.0, 7.0], [0.0, 5.0, 3.0, 4.0, -7.0], [5.0, -5.0, 7.0, -1.0, -4.0], [-4.0, 1.0, 1.0, -3.0, 
-4.0]], [[-1.0, 2.0, -1.0, 0.0, -1.0], [0.0, -3.0, 5.0, -7.0, 6.0], [-1.0, -7.0, -3.0, -6.0, -3.0], [-1.0, 6.0, -6.0, 6.0, 
6.0]]]])+(1.-msk_arg1)*numpy.array([[[[2.0, -5.0, 3.0, 3.0, 7.0], [-6.0, -7.0, -4.0, 7.0, -7.0], [3.0, 3.0, 0.0, -1.0, 3.0], 
[3.0, -7.0, -2.0, -4.0, -3.0]], [[-5.0, -4.0, -1.0, -5.0, 4.0], [-1.0, 6.0, -7.0, 6.0, 5.0], [6.0, -5.0, -1.0, 0.0, -4.0], 
[-7.0, 1.0, -6.0, -3.0, 7.0]], [[6.0, 0.0, -3.0, 1.0, -2.0], [1.0, 4.0, -4.0, 5.0, 6.0], [-1.0, 4.0, -4.0, 5.0, -2.0], [1.0, 
0.0, 0.0, 1.0, -7.0]]], [[[-5.0, 4.0, -2.0, 2.0, -4.0], [7.0, -5.0, 0.0, 2.0, 7.0], [-3.0, -7.0, 2.0, -1.0, 1.0], [6.0, -1.0, 
4.0, -4.0, -4.0]], [[2.0, -2.0, 4.0, 7.0, 0.0], [3.0, -5.0, 4.0, -5.0, 6.0], [0.0, -7.0, 0.0, -2.0, -2.0], [-4.0, -2.0, 7.0, 
-6.0, -3.0]], [[-2.0, -2.0, -6.0, -4.0, -3.0], [5.0, 0.0, 5.0, 2.0, -4.0], [-4.0, -6.0, 1.0, -6.0, -1.0], [2.0, 0.0, 4.0, 6.0, 
-1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[27.0, -53.0, -39.0, -71.0, -13.0], [36.0, 18.0, -48.0, -119.0, 87.0], [-77.0, 57.0, -62.0, 
-18.0, -21.0], [-9.0, 19.0, -36.0, 3.0, 131.0]], [[9.0, -11.0, 36.0, -14.0, -2.0], [-14.0, 5.0, -12.0, 60.0, -84.0], [21.0, 
45.0, 20.0, 36.0, 0.0], [16.0, -49.0, 56.0, -58.0, -72.0]], [[72.0, 48.0, 58.0, -13.0, 22.0], [41.0, 126.0, -13.0, 17.0, 7.0], 
[-24.0, 34.0, 29.0, 49.0, -62.0], [-46.0, 60.0, 28.0, -76.0, 17.0]], [[-17.0, -31.0, -68.0, 23.0, 5.0], [23.0, 24.0, -69.0, 
4.0, 64.0], [-27.0, 44.0, -1.0, 37.0, 65.0], [-2.0, -19.0, -4.0, 14.0, 32.0]], [[-11.0, 40.0, 20.0, 70.0, 11.0], [-43.0, -34.0, 
31.0, 105.0, -51.0], [31.0, -32.0, 71.0, 18.0, 56.0], [41.0, -38.0, 49.0, 35.0, -82.0]]], [[[37.0, -37.0, 15.0, -54.0, 76.0], 
[43.0, 69.0, -77.0, -37.0, -81.0], [47.0, 52.0, -3.0, 3.0, -44.0], [-75.0, -51.0, -14.0, -111.0, -7.0]], [[38.0, 45.0, 45.0, 
54.0, 33.0], [-42.0, -11.0, 16.0, 102.0, -62.0], [2.0, 0.0, 98.0, 25.0, 52.0], [50.0, -55.0, 77.0, 24.0, -53.0]], [[-10.0, 
-9.0, -11.0, -16.0, -7.0], [14.0, 5.0, 0.0, -36.0, 20.0], [2.0, -8.0, -30.0, -13.0, -22.0], [-20.0, 23.0, -29.0, -6.0, 19.0]], 
[[29.0, 3.0, 25.0, -26.0, -44.0], [-7.0, 9.0, 13.0, 5.0, 25.0], [-61.0, 42.0, -5.0, 25.0, -12.0], [39.0, 21.0, 42.0, -1.0, 
27.0]], [[-44.0, -38.0, -52.0, 2.0, 38.0], [46.0, 45.0, -69.0, -15.0, -14.0], [68.0, 8.0, -31.0, 13.0, 1.0], [-79.0, -16.0, 
-53.0, -64.0, -33.0]]], [[[-30.0, 16.0, -22.0, 40.0, 8.0], [-6.0, -21.0, 17.0, 9.0, 16.0], [26.0, -50.0, 7.0, -17.0, 21.0], 
[-7.0, 10.0, -27.0, 38.0, -13.0]], [[-20.0, -98.0, -29.0, -97.0, -66.0], [24.0, 4.0, -64.0, -48.0, 2.0], [-38.0, 117.0, -92.0, 
38.0, -20.0], [9.0, -26.0, 14.0, -79.0, 14.0]], [[47.0, 26.0, -18.0, 35.0, 81.0], [30.0, 63.0, -47.0, -17.0, 40.0], [-11.0, 
-6.0, 53.0, -2.0, 25.0], [-40.0, -2.0, -20.0, 17.0, 64.0]], [[-48.0, -52.0, -69.0, 1.0, -5.0], [-2.0, -55.0, -32.0, -37.0, 
29.0], [4.0, 2.0, -34.0, -22.0, 49.0], [9.0, -38.0, -36.0, 39.0, 21.0]], [[3.0, -27.0, 34.0, -34.0, -79.0], [-38.0, -35.0, 
11.0, 66.0, -41.0], [-47.0, 82.0, -5.0, 55.0, 16.0], [85.0, -37.0, 95.0, -24.0, -50.0]]], [[[-82.0, -122.0, -107.0, -47.0, 
-23.0], [34.0, -24.0, -103.0, -56.0, 15.0], [22.0, 74.0, -95.0, 15.0, 40.0], [-26.0, -62.0, -47.0, -45.0, -2.0]], [[-105.0, 
-72.0, -83.0, 15.0, -43.0], [-25.0, -103.0, -20.0, 12.0, -7.0], [39.0, -1.0, -50.0, -7.0, 75.0], [33.0, -64.0, -22.0, 36.0, 
-57.0]], [[30.0, -20.0, 29.0, -56.0, 30.0], [21.0, 31.0, -22.0, -44.0, -53.0], [20.0, 25.0, -18.0, -14.0, -57.0], [-40.0, 
-14.0, -11.0, -69.0, 6.0]], [[2.0, 77.0, 36.0, 60.0, 24.0], [3.0, 43.0, 48.0, 55.0, -10.0], [46.0, -74.0, 44.0, 5.0, -24.0], 
[-36.0, 57.0, -8.0, -1.0, -50.0]], [[-34.0, -75.0, -36.0, -51.0, -17.0], [30.0, 20.0, -71.0, -17.0, -26.0], [20.0, 75.0, -59.0, 
34.0, -5.0], [-28.0, -37.0, -6.0, -83.0, -28.0]]]])+(1.-msk_ref)*numpy.array([[[[-67.0, -4.0, -59.0, -110.0, -14.0], [18.0, 
111.0, -17.0, 19.0, 5.0], [16.0, -36.0, 1.0, -16.0, -38.0], [-53.0, 61.0, -57.0, 63.0, 100.0]], [[60.0, 18.0, 38.0, 44.0, 
-2.0], [-27.0, 13.0, -5.0, -45.0, 32.0], [6.0, 64.0, -21.0, 52.0, -1.0], [-20.0, 10.0, 0.0, -16.0, -24.0]], [[-30.0, -53.0, 
77.0, 6.0, 84.0], [-65.0, 7.0, -30.0, -31.0, 1.0], [87.0, -30.0, 6.0, -11.0, -21.0], [-113.0, -5.0, -49.0, -72.0, 105.0]], 
[[-77.0, 8.0, 22.0, -24.0, 52.0], [-40.0, -18.0, -85.0, 63.0, -3.0], [53.0, 3.0, 21.0, 13.0, 26.0], [20.0, -17.0, -80.0, -60.0, 
58.0]], [[29.0, 32.0, 48.0, 81.0, 1.0], [-12.0, -99.0, 16.0, -26.0, -15.0], [-21.0, 38.0, 14.0, 15.0, 49.0], [70.0, -41.0, 
37.0, -48.0, -68.0]]], [[[12.0, -12.0, -1.0, 8.0, -16.0], [39.0, 78.0, -31.0, -11.0, 156.0], [29.0, -59.0, -35.0, 35.0, -71.0], 
[-99.0, 36.0, 7.0, -41.0, 10.0]], [[15.0, 46.0, 59.0, 75.0, -9.0], [-5.0, -73.0, 27.0, -69.0, 13.0], [-14.0, 25.0, 17.0, 20.0, 
36.0], [35.0, -13.0, 34.0, -51.0, -32.0]], [[-5.0, -18.0, -21.0, -23.0, 1.0], [7.0, 21.0, -3.0, 21.0, -3.0], [2.0, -17.0, -5.0, 
-12.0, -14.0], [-13.0, 3.0, -4.0, 17.0, 8.0]], [[0.0, 4.0, 17.0, -28.0, 16.0], [-45.0, 32.0, 9.0, -39.0, -60.0], [15.0, 51.0, 
5.0, 5.0, 9.0], [-25.0, 24.0, -39.0, 33.0, 58.0]], [[-15.0, -32.0, 5.0, 11.0, 38.0], [-3.0, 0.0, -83.0, 84.0, 79.0], [46.0, 
-37.0, -17.0, 20.0, -22.0], [-21.0, -29.0, -28.0, -73.0, -11.0]]], [[[-11.0, -4.0, -7.0, 17.0, 2.0], [15.0, -54.0, 1.0, 34.0, 
-13.0], [-14.0, -23.0, 11.0, -20.0, 18.0], [47.0, -33.0, 22.0, -17.0, -37.0]], [[28.0, 3.0, -22.0, -70.0, 6.0], [-51.0, 134.0, 
-56.0, 13.0, 1.0], [32.0, 95.0, -36.0, 62.0, -27.0], [-56.0, 57.0, -90.0, 61.0, 57.0]], [[-96.0, -5.0, 20.0, -2.0, 25.0], 
[26.0, -34.0, -31.0, 19.0, 61.0], [38.0, -107.0, 29.0, -30.0, -8.0], [-22.0, -11.0, -10.0, -83.0, 56.0]], [[-21.0, 26.0, -51.0, 
-30.0, -32.0], [33.0, 12.0, -22.0, 54.0, 15.0], [-26.0, 0.0, 0.0, 8.0, 7.0], [57.0, 5.0, -7.0, 25.0, -28.0]], [[68.0, 39.0, 
34.0, 5.0, 0.0], [-74.0, 39.0, 6.0, -66.0, -65.0], [-2.0, 152.0, -14.0, 62.0, 29.0], [4.0, 31.0, -43.0, 49.0, 10.0]]], [[[-8.0, 
10.0, -48.0, -53.0, 0.0], [-8.0, 78.0, -101.0, 102.0, 54.0], [22.0, 43.0, -29.0, 58.0, -15.0], [14.0, 16.0, -75.0, 10.0, 
-3.0]], [[34.0, 39.0, -45.0, 2.0, -33.0], [8.0, -13.0, -33.0, 71.0, -11.0], [-43.0, 76.0, -13.0, 41.0, 34.0], [109.0, -17.0, 
-5.0, 32.0, -92.0]], [[29.0, -12.0, -20.0, -9.0, -30.0], [35.0, 75.0, 13.0, -28.0, 81.0], [-1.0, -32.0, -29.0, 13.0, -56.0], 
[-74.0, 39.0, 21.0, 18.0, 3.0]], [[3.0, -43.0, 52.0, 62.0, 51.0], [-20.0, -96.0, 8.0, 6.0, -24.0], [21.0, -40.0, 14.0, -35.0, 
16.0], [0.0, -62.0, 32.0, -71.0, -22.0]], [[22.0, -7.0, -2.0, -20.0, 19.0], [-33.0, 71.0, -72.0, 40.0, 47.0], [38.0, 49.0, 
-32.0, 56.0, -23.0], [-38.0, 17.0, -60.0, -7.0, 14.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_float_rank0_offset0(self):
      arg0=numpy.array([[[-4.0, -1.0], [-5.0, 6.0]], [[6.0, 4.0], [-3.0, -2.0]], [[4.0, -2.0], [-2.0, -6.0]], [[-5.0, -6.0], 
[0.0, 2.0]], [[-5.0, -1.0], [-6.0, 2.0]], [[6.0, -7.0], [3.0, -7.0]]])
      arg1=2.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-8.0, -2.0], [-10.0, 12.0]], [[12.0, 8.0], [-6.0, -4.0]], [[8.0, -4.0], [-4.0, -12.0]], [[-10.0, 
-12.0], [0.0, 4.0]], [[-10.0, -2.0], [-12.0, 4.0]], [[12.0, -14.0], [6.0, -14.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank0_offset0(self):
      arg0=numpy.array([[[5.0, -2.0], [-7.0, 1.0]], [[-4.0, -5.0], [0.0, 6.0]], [[2.0, -4.0], [-2.0, 7.0]], [[-7.0, -7.0], 
[6.0, -7.0]], [[1.0, 3.0], [6.0, 0.0]], [[6.0, -7.0], [1.0, -2.0]]])
      arg1=numpy.array(4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[20.0, -8.0], [-28.0, 4.0]], [[-16.0, -20.0], [0.0, 24.0]], [[8.0, -16.0], [-8.0, 28.0]], [[-28.0, 
-28.0], [24.0, -28.0]], [[4.0, 12.0], [24.0, 0.0]], [[24.0, -28.0], [4.0, -8.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank1_offset1(self):
      arg0=numpy.array([[[[5.0, -2.0, 7.0], [0.0, -3.0, 6.0]], [[4.0, 4.0, -5.0], [0.0, -1.0, -2.0]]], [[[-4.0, 5.0, 0.0], 
[5.0, 6.0, -6.0]], [[4.0, -5.0, 0.0], [5.0, -3.0, 4.0]]], [[[3.0, 0.0, 5.0], [7.0, -4.0, 6.0]], [[0.0, 6.0, 0.0], [-4.0, -3.0, 
-3.0]]], [[[6.0, 2.0, 0.0], [-3.0, -6.0, -2.0]], [[0.0, 1.0, 0.0], [-2.0, 4.0, -5.0]]], [[[5.0, 3.0, 0.0], [2.0, -3.0, -5.0]], 
[[6.0, 1.0, 3.0], [-1.0, 2.0, 0.0]]], [[[1.0, -4.0, 1.0], [6.0, -6.0, -3.0]], [[0.0, 0.0, 7.0], [2.0, 3.0, -6.0]]]])
      arg1=numpy.array([6.0, -4.0, -2.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[24.0, 0.0], [18.0, 8.0]], [[-44.0, 18.0], [44.0, 34.0]], [[8.0, 46.0], [-24.0, -6.0]], [[28.0, 10.0], 
[-4.0, -18.0]], [[18.0, 34.0], [26.0, -14.0]], [[20.0, 66.0], [-14.0, 12.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_array_rank1_offset0(self):
      arg0=numpy.array([[[2.0, -5.0], [-1.0, -2.0]], [[-1.0, 7.0], [-3.0, -4.0]], [[-2.0, -7.0], [0.0, 6.0]], [[-1.0, 3.0], 
[5.0, 5.0]], [[6.0, -3.0], [3.0, 0.0]], [[-7.0, 0.0], [-4.0, 0.0]]])
      arg1=numpy.array([1.0, 4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[2.0, 8.0], [-5.0, -20.0]], [[-1.0, -4.0], [-2.0, -8.0]]], [[[-1.0, -4.0], [7.0, 28.0]], [[-3.0, 
-12.0], [-4.0, -16.0]]], [[[-2.0, -8.0], [-7.0, -28.0]], [[0.0, 0.0], [6.0, 24.0]]], [[[-1.0, -4.0], [3.0, 12.0]], [[5.0, 
20.0], [5.0, 20.0]]], [[[6.0, 24.0], [-3.0, -12.0]], [[3.0, 12.0], [0.0, 0.0]]], [[[-7.0, -28.0], [0.0, 0.0]], [[-4.0, -16.0], 
[0.0, 0.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank2_offset1(self):
      arg0=numpy.array([[[[4.0, -3.0, -4.0], [4.0, -2.0, 0.0]], [[-4.0, -3.0, -4.0], [2.0, 0.0, 7.0]]], [[[0.0, -6.0, 2.0], 
[6.0, -1.0, -7.0]], [[-1.0, -5.0, -2.0], [6.0, -6.0, -4.0]]], [[[2.0, 0.0, 4.0], [-2.0, -3.0, 1.0]], [[0.0, 0.0, -5.0], [7.0, 
7.0, -6.0]]], [[[7.0, -5.0, 2.0], [-3.0, -3.0, 6.0]], [[6.0, 1.0, -3.0], [-2.0, -2.0, 1.0]]], [[[-6.0, 4.0, 2.0], [-3.0, -6.0, 
0.0]], [[2.0, -2.0, -7.0], [7.0, 4.0, 4.0]]], [[[6.0, 2.0, 6.0], [4.0, -7.0, 4.0]], [[6.0, 7.0, -2.0], [-1.0, -5.0, 2.0]]]])
      arg1=numpy.array([[-1.0, -3.0], [-3.0, -6.0], [-3.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[17.0, -18.0], [2.0, 0.0]], [[25.0, 6.0], [-23.0, 36.0]]], [[[12.0, 48.0], [18.0, -54.0]], [[22.0, 
21.0], [24.0, -6.0]]], [[[-14.0, 18.0], [8.0, 30.0]], [[15.0, -30.0], [-10.0, -99.0]]], [[[2.0, 21.0], [-6.0, 63.0]], [[0.0, 
-42.0], [5.0, 24.0]]], [[[-12.0, 6.0], [21.0, 45.0]], [[25.0, -36.0], [-31.0, -21.0]]], [[[-30.0, 6.0], [5.0, 54.0]], [[-21.0, 
-72.0], [10.0, 45.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank0_offset0(self):
      arg0=numpy.array([[[-5.0, 4.0], [-3.0, -4.0]], [[4.0, 0.0], [2.0, 7.0]], [[1.0, 1.0], [3.0, -6.0]], [[4.0, 2.0], [2.0, 
-2.0]], [[6.0, -3.0], [0.0, 0.0]], [[0.0, -6.0], [-1.0, -4.0]]])
      arg1=Data(2.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-10.0, 8.0], [-6.0, -8.0]], [[8.0, 0.0], [4.0, 14.0]], [[2.0, 2.0], [6.0, -12.0]], [[8.0, 4.0], 
[4.0, -4.0]], [[12.0, -6.0], [0.0, 0.0]], [[0.0, -12.0], [-2.0, -8.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank1_offset1(self):
      arg0=numpy.array([[[[-2.0, -3.0, -1.0], [7.0, -4.0, -1.0]], [[-4.0, 0.0, 6.0], [-3.0, 1.0, 4.0]]], [[[7.0, -2.0, -4.0], 
[1.0, 0.0, -3.0]], [[-6.0, -2.0, -2.0], [0.0, 6.0, 2.0]]], [[[-6.0, 7.0, -4.0], [3.0, 5.0, 5.0]], [[3.0, 5.0, -4.0], [-1.0, 
0.0, 7.0]]], [[[1.0, -1.0, 4.0], [0.0, -3.0, 0.0]], [[3.0, -4.0, 0.0], [-3.0, 7.0, -1.0]]], [[[-4.0, -4.0, 2.0], [0.0, -4.0, 
-1.0]], [[4.0, 6.0, -5.0], [0.0, 2.0, -7.0]]], [[[-7.0, 3.0, 5.0], [-4.0, -7.0, -5.0]], [[-1.0, -4.0, 0.0], [-1.0, 1.0, 
-6.0]]]])
      arg1=Data(numpy.array([-5.0, 0.0, -3.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[13.0, -32.0], [2.0, 3.0]], [[-23.0, 4.0], [36.0, -6.0]], [[42.0, -30.0], [-3.0, -16.0]], [[-17.0, 
0.0], [-15.0, 18.0]], [[14.0, 3.0], [-5.0, 21.0]], [[20.0, 35.0], [5.0, 23.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_constData_rank1_offset0(self):
      arg0=numpy.array([[[-4.0, 6.0], [-6.0, -1.0]], [[-1.0, 4.0], [-3.0, 3.0]], [[-6.0, -6.0], [-3.0, 4.0]], [[-2.0, 4.0], 
[-2.0, 0.0]], [[5.0, 5.0], [3.0, 7.0]], [[3.0, 0.0], [0.0, 0.0]]])
      arg1=Data(numpy.array([-2.0, -4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[8.0, 16.0], [-12.0, -24.0]], [[12.0, 24.0], [2.0, 4.0]]], [[[2.0, 4.0], [-8.0, -16.0]], [[6.0, 
12.0], [-6.0, -12.0]]], [[[12.0, 24.0], [12.0, 24.0]], [[6.0, 12.0], [-8.0, -16.0]]], [[[4.0, 8.0], [-8.0, -16.0]], [[4.0, 
8.0], [0.0, 0.0]]], [[[-10.0, -20.0], [-10.0, -20.0]], [[-6.0, -12.0], [-14.0, -28.0]]], [[[-6.0, -12.0], [0.0, 0.0]], [[0.0, 
0.0], [0.0, 0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank2_offset1(self):
      arg0=numpy.array([[[[3.0, 3.0, 0.0], [4.0, 0.0, 3.0]], [[5.0, 1.0, -4.0], [-2.0, -5.0, 7.0]]], [[[-7.0, -6.0, 1.0], 
[-6.0, -5.0, -4.0]], [[2.0, 0.0, -2.0], [6.0, -7.0, 6.0]]], [[[-2.0, 3.0, 0.0], [0.0, -6.0, -1.0]], [[-1.0, -6.0, -4.0], [-4.0, 
0.0, -2.0]]], [[[4.0, 0.0, 6.0], [-5.0, -1.0, 5.0]], [[7.0, -4.0, -2.0], [6.0, 5.0, -3.0]]], [[[1.0, -1.0, 3.0], [3.0, -1.0, 
3.0]], [[-6.0, 0.0, -3.0], [-5.0, -3.0, -6.0]]], [[[2.0, 0.0, -3.0], [2.0, -3.0, 2.0]], [[0.0, 7.0, 7.0], [0.0, -1.0, -5.0]]]])
      arg1=Data(numpy.array([[-1.0, 4.0], [0.0, 3.0], [-1.0, 5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-3.0, 21.0], [-7.0, 31.0]], [[-1.0, 3.0], [-5.0, 12.0]]], [[[6.0, -41.0], [10.0, -59.0]], [[0.0, 
-2.0], [-12.0, 33.0]]], [[[2.0, 1.0], [1.0, -23.0]], [[5.0, -42.0], [6.0, -26.0]]], [[[-10.0, 46.0], [0.0, 2.0]], [[-5.0, 6.0], 
[-3.0, 24.0]]], [[[-4.0, 16.0], [-6.0, 24.0]], [[9.0, -39.0], [11.0, -59.0]]], [[[1.0, -7.0], [-4.0, 9.0]], [[-7.0, 56.0], 
[5.0, -28.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank0_offset0(self):
      arg0=numpy.array([[[-1.0, 3.0], [-1.0, 0.0]], [[-1.0, -2.0], [1.0, 0.0]], [[-5.0, 2.0], [-3.0, 0.0]], [[5.0, -2.0], 
[-4.0, 0.0]], [[-5.0, 6.0], [6.0, -6.0]], [[5.0, 3.0], [-7.0, 4.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-3.0)+(1-msk_arg1)*(-7.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, -9.0], [3.0, -0.0]], [[3.0, 6.0], [-3.0, -0.0]], [[15.0, -6.0], [9.0, -0.0]], [[-15.0, 
6.0], [12.0, -0.0]], [[15.0, -18.0], [-18.0, 18.0]], [[-15.0, -9.0], [21.0, -12.0]]])+(1.-msk_ref)*numpy.array([[[7.0, -21.0], 
[7.0, -0.0]], [[7.0, 14.0], [-7.0, -0.0]], [[35.0, -14.0], [21.0, -0.0]], [[-35.0, 14.0], [28.0, -0.0]], [[35.0, -42.0], 
[-42.0, 42.0]], [[-35.0, -21.0], [49.0, -28.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
         arg0=arg0*1j
         arg1=arg1*1j
         ref=-ref
         res=generalTensorProduct(arg0,arg1,axis_offset=0)
         self.assertTrue(isinstance(res,Data),"wrong type of result.")
         self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
         self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")         
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank1_offset1(self):
      arg0=numpy.array([[[[-5.0, 0.0, 6.0], [-2.0, 7.0, -1.0]], [[-3.0, -3.0, -1.0], [4.0, 6.0, 0.0]]], [[[-6.0, 3.0, 7.0], 
[-3.0, -1.0, 0.0]], [[2.0, -2.0, -5.0], [-4.0, 7.0, 6.0]]], [[[0.0, -1.0, 1.0], [5.0, 7.0, -1.0]], [[-6.0, -4.0, 0.0], [-7.0, 
1.0, -1.0]]], [[[7.0, -4.0, -5.0], [1.0, -6.0, -4.0]], [[1.0, 4.0, -7.0], [-1.0, -1.0, 5.0]]], [[[4.0, -1.0, 0.0], [3.0, -2.0, 
6.0]], [[4.0, -3.0, 4.0], [3.0, 1.0, 4.0]]], [[[-5.0, 4.0, -6.0], [0.0, 0.0, 2.0]], [[-1.0, 0.0, 7.0], [-4.0, 1.0, 2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-3.0, -3.0, -4.0])+(1.-msk_arg1)*numpy.array([3.0, -2.0, 6.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-9.0, -11.0], [22.0, -30.0]], [[-19.0, 12.0], [20.0, -33.0]], [[-1.0, -32.0], [30.0, 22.0]], 
[[11.0, 31.0], [13.0, -14.0]], [[-9.0, -27.0], [-19.0, -28.0]], [[27.0, -8.0], [-25.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[21.0, -26.0], [-9.0, 0.0]], [[18.0, -7.0], [-20.0, 10.0]], [[8.0, -5.0], [-10.0, -29.0]], 
[[-1.0, -9.0], [-47.0, 29.0]], [[14.0, 49.0], [42.0, 31.0]], [[-59.0, 12.0], [39.0, -2.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank3_expandedData_rank1_offset0(self):
      arg0=numpy.array([[[-1.0, 3.0], [-5.0, 5.0]], [[0.0, -1.0], [-2.0, 4.0]], [[-5.0, 5.0], [-7.0, 3.0]], [[-5.0, -4.0], 
[4.0, -5.0]], [[5.0, -3.0], [1.0, 2.0]], [[-2.0, -6.0], [6.0, 4.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([3.0, 1.0])+(1.-msk_arg1)*numpy.array([5.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-3.0, -1.0], [9.0, 3.0]], [[-15.0, -5.0], [15.0, 5.0]]], [[[0.0, 0.0], [-3.0, -1.0]], [[-6.0, 
-2.0], [12.0, 4.0]]], [[[-15.0, -5.0], [15.0, 5.0]], [[-21.0, -7.0], [9.0, 3.0]]], [[[-15.0, -5.0], [-12.0, -4.0]], [[12.0, 
4.0], [-15.0, -5.0]]], [[[15.0, 5.0], [-9.0, -3.0]], [[3.0, 1.0], [6.0, 2.0]]], [[[-6.0, -2.0], [-18.0, -6.0]], [[18.0, 6.0], 
[12.0, 4.0]]]])+(1.-msk_ref)*numpy.array([[[[-5.0, 0.0], [15.0, 0.0]], [[-25.0, 0.0], [25.0, 0.0]]], [[[0.0, 0.0], [-5.0, 
0.0]], [[-10.0, 0.0], [20.0, 0.0]]], [[[-25.0, 0.0], [25.0, 0.0]], [[-35.0, 0.0], [15.0, 0.0]]], [[[-25.0, 0.0], [-20.0, 0.0]], 
[[20.0, 0.0], [-25.0, 0.0]]], [[[25.0, 0.0], [-15.0, 0.0]], [[5.0, 0.0], [10.0, 0.0]]], [[[-10.0, 0.0], [-30.0, 0.0]], [[30.0, 
0.0], [20.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank2_offset1(self):
      arg0=numpy.array([[[[6.0, 3.0, 4.0], [-7.0, 2.0, 7.0]], [[5.0, 3.0, -4.0], [7.0, -6.0, 6.0]]], [[[-4.0, 6.0, 0.0], [0.0, 
-2.0, 0.0]], [[3.0, 3.0, 7.0], [-1.0, -5.0, 5.0]]], [[[6.0, 7.0, -1.0], [2.0, 5.0, 6.0]], [[0.0, -4.0, -5.0], [-5.0, 3.0, 
-3.0]]], [[[7.0, 5.0, -6.0], [0.0, -4.0, 3.0]], [[0.0, 3.0, 2.0], [7.0, 0.0, 6.0]]], [[[4.0, 0.0, 0.0], [-7.0, -5.0, -4.0]], 
[[-2.0, 2.0, -7.0], [2.0, 5.0, 0.0]]], [[[2.0, 5.0, 3.0], [5.0, -5.0, 1.0]], [[-4.0, -1.0, 4.0], [5.0, -2.0, -2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, -2.0], [7.0, -4.0], [0.0, 2.0]])+(1.-msk_arg1)*numpy.array([[2.0, 7.0], [-4.0, -2.0], 
[-3.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-21.0, -16.0], [63.0, 20.0]], [[-14.0, -30.0], [-91.0, 22.0]]], [[[70.0, -16.0], [-14.0, 
8.0]], [[0.0, -4.0], [-28.0, 32.0]]], [[[7.0, -42.0], [21.0, -12.0]], [[-28.0, 6.0], [56.0, -8.0]]], [[[-14.0, -46.0], [-28.0, 
22.0]], [[21.0, -8.0], [-49.0, -2.0]]], [[[-28.0, -8.0], [14.0, 26.0]], [[28.0, -18.0], [21.0, -24.0]]], [[[21.0, -18.0], 
[-70.0, 12.0]], [[21.0, 20.0], [-49.0, -6.0]]]])+(1.-msk_ref)*numpy.array([[[[-12.0, 20.0], [-43.0, -81.0]], [[10.0, 45.0], 
[20.0, 37.0]]], [[[-32.0, -40.0], [8.0, 4.0]], [[-27.0, -13.0], [3.0, -17.0]]], [[[-13.0, 32.0], [-34.0, -20.0]], [[31.0, 
28.0], [-13.0, -29.0]]], [[[12.0, 63.0], [7.0, -4.0]], [[-18.0, -14.0], [-4.0, 25.0]]], [[[8.0, 28.0], [18.0, -23.0]], [[9.0, 
10.0], [-16.0, 4.0]]], [[[-25.0, -8.0], [27.0, 41.0]], [[-16.0, -42.0], [24.0, 47.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_float_rank0_offset0(self):
      arg0=numpy.array([[[[5.0, 0.0, 3.0, -6.0], [-1.0, 7.0, 0.0, -6.0], [-1.0, 0.0, 0.0, 6.0]], [[5.0, -1.0, 7.0, -4.0], [2.0, 
5.0, 0.0, 1.0], [0.0, 1.0, -1.0, -5.0]]], [[[2.0, 0.0, 3.0, 6.0], [-7.0, -1.0, 0.0, -6.0], [-3.0, 5.0, -4.0, 3.0]], [[-5.0, 
-2.0, 7.0, 4.0], [0.0, 1.0, -1.0, -1.0], [6.0, -2.0, 0.0, 3.0]]], [[[-4.0, 2.0, -2.0, 7.0], [-7.0, 6.0, -5.0, -4.0], [3.0, 1.0, 
-7.0, 0.0]], [[6.0, 0.0, -4.0, 1.0], [6.0, 0.0, -2.0, -2.0], [-5.0, 5.0, -4.0, 5.0]]]])
      arg1=6.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[30.0, 0.0, 18.0, -36.0], [-6.0, 42.0, 0.0, -36.0], [-6.0, 0.0, 0.0, 36.0]], [[30.0, -6.0, 42.0, 
-24.0], [12.0, 30.0, 0.0, 6.0], [0.0, 6.0, -6.0, -30.0]]], [[[12.0, 0.0, 18.0, 36.0], [-42.0, -6.0, 0.0, -36.0], [-18.0, 30.0, 
-24.0, 18.0]], [[-30.0, -12.0, 42.0, 24.0], [0.0, 6.0, -6.0, -6.0], [36.0, -12.0, 0.0, 18.0]]], [[[-24.0, 12.0, -12.0, 42.0], 
[-42.0, 36.0, -30.0, -24.0], [18.0, 6.0, -42.0, 0.0]], [[36.0, 0.0, -24.0, 6.0], [36.0, 0.0, -12.0, -12.0], [-30.0, 30.0, 
-24.0, 30.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_array_rank0_offset0(self):
      arg0=numpy.array([[[[-6.0, 0.0, -7.0, -5.0], [-6.0, 0.0, 0.0, 6.0], [-7.0, 0.0, 3.0, 7.0]], [[-7.0, -1.0, 2.0, 5.0], 
[-3.0, 6.0, 4.0, -4.0], [0.0, 3.0, -2.0, -3.0]]], [[[-6.0, 6.0, 6.0, 1.0], [4.0, 3.0, 2.0, 3.0], [6.0, 7.0, -7.0, -3.0]], 
[[-5.0, 4.0, -5.0, 0.0], [-2.0, 6.0, -1.0, -2.0], [-1.0, 4.0, 5.0, -6.0]]], [[[-3.0, -1.0, -5.0, -7.0], [5.0, 5.0, 0.0, -3.0], 
[-1.0, 6.0, -6.0, -2.0]], [[1.0, -1.0, 5.0, 2.0], [-5.0, 6.0, 1.0, -2.0], [6.0, -6.0, 3.0, -3.0]]]])
      arg1=numpy.array(-1.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[6.0, -0.0, 7.0, 5.0], [6.0, -0.0, -0.0, -6.0], [7.0, -0.0, -3.0, -7.0]], [[7.0, 1.0, -2.0, -5.0], 
[3.0, -6.0, -4.0, 4.0], [-0.0, -3.0, 2.0, 3.0]]], [[[6.0, -6.0, -6.0, -1.0], [-4.0, -3.0, -2.0, -3.0], [-6.0, -7.0, 7.0, 3.0]], 
[[5.0, -4.0, 5.0, -0.0], [2.0, -6.0, 1.0, 2.0], [1.0, -4.0, -5.0, 6.0]]], [[[3.0, 1.0, 5.0, 7.0], [-5.0, -5.0, -0.0, 3.0], 
[1.0, -6.0, 6.0, 2.0]], [[-1.0, 1.0, -5.0, -2.0], [5.0, -6.0, -1.0, 2.0], [-6.0, 6.0, -3.0, 3.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_constData_rank0_offset0(self):
      arg0=numpy.array([[[[1.0, 1.0, -5.0, 6.0], [1.0, 6.0, 7.0, 0.0], [2.0, -6.0, -5.0, 5.0]], [[0.0, -2.0, 0.0, 2.0], [3.0, 
-3.0, -6.0, -4.0], [-2.0, 0.0, -4.0, 2.0]]], [[[0.0, 1.0, 4.0, -4.0], [-6.0, -3.0, -6.0, 3.0], [0.0, -1.0, -2.0, 5.0]], [[6.0, 
-1.0, 6.0, 4.0], [0.0, 3.0, 0.0, 7.0], [-1.0, 6.0, -1.0, 5.0]]], [[[-2.0, -4.0, -3.0, -7.0], [0.0, -2.0, -3.0, 5.0], [3.0, 
-2.0, 1.0, 0.0]], [[-2.0, 7.0, -5.0, -6.0], [1.0, -5.0, -7.0, -6.0], [-1.0, 5.0, -2.0, 3.0]]]])
      arg1=Data(6.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[6.0, 6.0, -30.0, 36.0], [6.0, 36.0, 42.0, 0.0], [12.0, -36.0, -30.0, 30.0]], [[0.0, -12.0, 0.0, 
12.0], [18.0, -18.0, -36.0, -24.0], [-12.0, 0.0, -24.0, 12.0]]], [[[0.0, 6.0, 24.0, -24.0], [-36.0, -18.0, -36.0, 18.0], [0.0, 
-6.0, -12.0, 30.0]], [[36.0, -6.0, 36.0, 24.0], [0.0, 18.0, 0.0, 42.0], [-6.0, 36.0, -6.0, 30.0]]], [[[-12.0, -24.0, -18.0, 
-42.0], [0.0, -12.0, -18.0, 30.0], [18.0, -12.0, 6.0, 0.0]], [[-12.0, 42.0, -30.0, -36.0], [6.0, -30.0, -42.0, -36.0], [-6.0, 
30.0, -12.0, 18.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_array_rank4_expandedData_rank0_offset0(self):
      arg0=numpy.array([[[[-1.0, 2.0, 0.0, -7.0], [3.0, 1.0, 3.0, 7.0], [2.0, 4.0, 0.0, -2.0]], [[2.0, 0.0, 7.0, -5.0], [-1.0, 
0.0, -3.0, -3.0], [0.0, -1.0, -7.0, 2.0]]], [[[0.0, 4.0, -2.0, 4.0], [-1.0, 6.0, -7.0, 2.0], [0.0, -1.0, 5.0, 0.0]], [[-3.0, 
3.0, 1.0, 5.0], [3.0, -5.0, -1.0, 0.0], [5.0, 0.0, 5.0, 0.0]]], [[[-6.0, -3.0, -4.0, -3.0], [0.0, -7.0, -3.0, -7.0], [3.0, 0.0, 
0.0, 3.0]], [[-2.0, 3.0, 7.0, -4.0], [0.0, 3.0, 4.0, -1.0], [3.0, 2.0, 4.0, 4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(0.0)+(1-msk_arg1)*(0.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, -0.0], 
[-0.0, 0.0, -0.0, -0.0], [0.0, -0.0, -0.0, 0.0]]], [[[0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, -0.0, 0.0], [0.0, -0.0, 0.0, 0.0]], 
[[-0.0, 0.0, 0.0, 0.0], [0.0, -0.0, -0.0, 0.0], [0.0, 0.0, 0.0, 0.0]]], [[[-0.0, -0.0, -0.0, -0.0], [0.0, -0.0, -0.0, -0.0], 
[0.0, 0.0, 0.0, 0.0]], [[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 
0.0]]]])+(1.-msk_ref)*numpy.array([[[[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 
-0.0], [-0.0, 0.0, -0.0, -0.0], [0.0, -0.0, -0.0, 0.0]]], [[[0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, -0.0, 0.0], [0.0, -0.0, 0.0, 
0.0]], [[-0.0, 0.0, 0.0, 0.0], [0.0, -0.0, -0.0, 0.0], [0.0, 0.0, 0.0, 0.0]]], [[[-0.0, -0.0, -0.0, -0.0], [0.0, -0.0, -0.0, 
-0.0], [0.0, 0.0, 0.0, 0.0]], [[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_float_rank0_offset0(self):
      arg0=Data(2.0,self.functionspace)
      arg1=4.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(8.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_array_rank0_offset0(self):
      arg0=Data(5.0,self.functionspace)
      arg1=numpy.array(6.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(30.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank1_offset1(self):
      arg0=Data(numpy.array([-7.0, -7.0, 5.0]),self.functionspace)
      arg1=numpy.array([-6.0, -1.0, 7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(84.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank2_offset2(self):
      arg0=Data(numpy.array([[1.0, -3.0, 5.0], [-1.0, 0.0, -2.0]]),self.functionspace)
      arg1=numpy.array([[-5.0, -3.0, 3.0], [5.0, -7.0, -2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(18.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank3_offset3(self):
      arg0=Data(numpy.array([[[6.0, -2.0, 2.0], [-5.0, -5.0, -3.0], [-7.0, 2.0, 3.0], [-5.0, 2.0, 3.0]], [[7.0, 6.0, 3.0], 
[0.0, 1.0, 7.0], [2.0, 1.0, 2.0], [3.0, 4.0, 0.0]]]),self.functionspace)
      arg1=numpy.array([[[-4.0, -1.0, 5.0], [-2.0, 3.0, -2.0], [0.0, 6.0, 3.0], [-6.0, -1.0, -3.0]], [[7.0, 0.0, 3.0], [-4.0, 
-5.0, 5.0], [-4.0, -4.0, 0.0], [3.0, 5.0, -4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(134.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank4_offset4(self):
      arg0=Data(numpy.array([[[[2.0, 5.0], [-7.0, 6.0], [-3.0, 0.0]], [[3.0, -2.0], [0.0, 7.0], [-3.0, -6.0]]], [[[2.0, -7.0], 
[-6.0, -1.0], [-2.0, 3.0]], [[-6.0, -4.0], [0.0, -7.0], [0.0, 1.0]]], [[[-2.0, -6.0], [-6.0, 1.0], [2.0, 1.0]], [[3.0, 0.0], 
[-1.0, -1.0], [3.0, -3.0]]], [[[0.0, -5.0], [-2.0, -2.0], [5.0, 4.0]], [[-5.0, 4.0], [-2.0, 0.0], [-1.0, 
-1.0]]]]),self.functionspace)
      arg1=numpy.array([[[[2.0, 1.0], [4.0, 7.0], [-5.0, 0.0]], [[0.0, 0.0], [-5.0, 2.0], [-6.0, 1.0]]], [[[-7.0, 6.0], [-4.0, 
-6.0], [-5.0, 2.0]], [[7.0, -2.0], [-5.0, -6.0], [5.0, 0.0]]], [[[2.0, 6.0], [5.0, -7.0], [0.0, 1.0]], [[2.0, 1.0], [2.0, 
-3.0], [4.0, 7.0]]], [[[-6.0, -1.0], [4.0, 5.0], [-3.0, 7.0]], [[-4.0, -1.0], [5.0, -7.0], [-4.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(-6.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_array_rank1_offset0(self):
      arg0=Data(-6.0,self.functionspace)
      arg1=numpy.array([-5.0, 4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([30.0, -24.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank2_offset1(self):
      arg0=Data(numpy.array([7.0, -5.0, 3.0]),self.functionspace)
      arg1=numpy.array([[-7.0, 6.0], [3.0, 7.0], [3.0, 3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-55.0, 16.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=1j*arg0
      arg1=1j*arg1
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank3_offset2(self):
      arg0=Data(numpy.array([[-2.0, 4.0, 5.0], [0.0, -3.0, 0.0]]),self.functionspace)
      arg1=numpy.array([[[4.0, -1.0], [1.0, 6.0], [-2.0, -1.0]], [[7.0, 5.0], [-7.0, 0.0], [7.0, -5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([7.0, 21.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank4_offset3(self):
      arg0=Data(numpy.array([[[0.0, 6.0, 2.0], [-2.0, 3.0, -2.0], [3.0, -7.0, -4.0], [2.0, 1.0, -5.0]], [[-1.0, 1.0, -1.0], 
[-7.0, 0.0, -3.0], [-4.0, -4.0, 0.0], [3.0, 2.0, 0.0]]]),self.functionspace)
      arg1=numpy.array([[[[0.0, -4.0], [4.0, -7.0], [-2.0, -1.0]], [[-2.0, -2.0], [5.0, 0.0], [-5.0, -7.0]], [[-5.0, -3.0], 
[0.0, 6.0], [-4.0, 7.0]], [[2.0, 1.0], [0.0, 6.0], [-3.0, -3.0]]], [[[-7.0, 0.0], [5.0, -3.0], [-2.0, -1.0]], [[-3.0, 4.0], 
[2.0, -6.0], [-6.0, 4.0]], [[-4.0, -1.0], [-1.0, 2.0], [1.0, -7.0]], [[7.0, 3.0], [4.0, 5.0], [0.0, 5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([171.0, -109.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_array_rank2_offset0(self):
      arg0=Data(0.0,self.functionspace)
      arg1=numpy.array([[5.0, -3.0, 1.0, 0.0, 6.0], [-5.0, -6.0, -7.0, -2.0, -2.0], [-6.0, -6.0, -6.0, 6.0, -6.0], [-4.0, 7.0, 
-5.0, -5.0, -3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[0.0, -0.0, 0.0, 0.0, 0.0], [-0.0, -0.0, -0.0, -0.0, -0.0], [-0.0, -0.0, -0.0, 0.0, -0.0], [-0.0, 
0.0, -0.0, -0.0, -0.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank3_offset1(self):
      arg0=Data(numpy.array([3.0, -2.0, -3.0]),self.functionspace)
      arg1=numpy.array([[[-6.0, -2.0, -3.0, 5.0, -4.0], [-5.0, 6.0, 6.0, 0.0, -1.0], [0.0, -5.0, 6.0, -5.0, 0.0], [1.0, -2.0, 
-4.0, 7.0, 4.0]], [[-6.0, -2.0, -6.0, -3.0, -7.0], [-5.0, 2.0, -2.0, 0.0, 4.0], [4.0, -3.0, 0.0, -1.0, -6.0], [7.0, 0.0, -3.0, 
6.0, 0.0]], [[0.0, -6.0, -1.0, 5.0, -4.0], [0.0, 3.0, 2.0, 2.0, 0.0], [3.0, -6.0, 1.0, 0.0, 6.0], [1.0, 0.0, -1.0, -3.0, 
-5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-6.0, 16.0, 6.0, 6.0, 14.0], [-5.0, 5.0, 16.0, -6.0, -11.0], [-17.0, 9.0, 15.0, -13.0, -6.0], 
[-14.0, -6.0, -3.0, 18.0, 27.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank4_offset2(self):
      arg0=Data(numpy.array([[0.0, -2.0, -1.0], [-3.0, 6.0, 7.0]]),self.functionspace)
      arg1=numpy.array([[[[1.0, -3.0, 7.0, 0.0, -7.0], [2.0, 4.0, -4.0, -7.0, 1.0], [6.0, 6.0, 2.0, 1.0, 0.0], [7.0, -2.0, 4.0, 
0.0, -7.0]], [[6.0, -7.0, 4.0, 4.0, 3.0], [-3.0, 2.0, -6.0, 0.0, -5.0], [3.0, 1.0, 1.0, 1.0, -6.0], [7.0, 5.0, -6.0, 2.0, 
-5.0]], [[0.0, -4.0, 0.0, 0.0, -5.0], [7.0, 0.0, -4.0, -6.0, -6.0], [-4.0, -2.0, 3.0, 2.0, -3.0], [-4.0, 0.0, 5.0, -2.0, 
-6.0]]], [[[-1.0, 7.0, -5.0, 7.0, 7.0], [5.0, -3.0, 5.0, -4.0, 2.0], [-2.0, 4.0, 5.0, 5.0, 7.0], [-3.0, 3.0, 7.0, -2.0, -3.0]], 
[[-7.0, -4.0, 5.0, 5.0, -3.0], [-3.0, 2.0, -6.0, -5.0, 5.0], [-6.0, -2.0, 0.0, -1.0, -6.0], [7.0, -1.0, 0.0, 1.0, 2.0]], [[1.0, 
4.0, 0.0, -7.0, 3.0], [-1.0, 0.0, 0.0, 1.0, -2.0], [-3.0, 2.0, 0.0, 2.0, -1.0], [5.0, -7.0, -4.0, 0.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-44.0, 1.0, 37.0, -48.0, -19.0], [-41.0, 17.0, -35.0, -5.0, 26.0], [-53.0, -10.0, -20.0, -11.0, 
-49.0], [76.0, -74.0, -42.0, 10.0, 37.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_array_rank3_offset0(self):
      arg0=Data(6.0,self.functionspace)
      arg1=numpy.array([[[-6.0, -2.0], [0.0, 7.0]], [[-3.0, 7.0], [-5.0, 3.0]], [[-6.0, -3.0], [0.0, 3.0]], [[-7.0, 0.0], [2.0, 
-1.0]], [[6.0, 1.0], [5.0, 4.0]], [[7.0, -7.0], [-4.0, 1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-36.0, -12.0], [0.0, 42.0]], [[-18.0, 42.0], [-30.0, 18.0]], [[-36.0, -18.0], [0.0, 18.0]], 
[[-42.0, 0.0], [12.0, -6.0]], [[36.0, 6.0], [30.0, 24.0]], [[42.0, -42.0], [-24.0, 6.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank4_offset1(self):
      arg0=Data(numpy.array([-1.0, -5.0, 3.0]),self.functionspace)
      arg1=numpy.array([[[[1.0, -2.0], [3.0, 3.0]], [[-6.0, 5.0], [7.0, 7.0]], [[-4.0, 6.0], [-5.0, 5.0]], [[-1.0, 4.0], [-3.0, 
2.0]], [[5.0, -1.0], [-2.0, 3.0]], [[-4.0, 2.0], [-5.0, -2.0]]], [[[-2.0, 4.0], [1.0, -6.0]], [[-1.0, 0.0], [-5.0, 0.0]], 
[[1.0, -5.0], [-7.0, 0.0]], [[3.0, -2.0], [1.0, 4.0]], [[-7.0, -4.0], [-3.0, -2.0]], [[6.0, 4.0], [1.0, -5.0]]], [[[7.0, 7.0], 
[2.0, -2.0]], [[6.0, -2.0], [-7.0, 3.0]], [[0.0, -5.0], [-4.0, 6.0]], [[-2.0, -2.0], [5.0, -3.0]], [[-4.0, -4.0], [1.0, -3.0]], 
[[3.0, -3.0], [-5.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[30.0, 3.0], [-2.0, 21.0]], [[29.0, -11.0], [-3.0, 2.0]], [[-1.0, 4.0], [28.0, 13.0]], [[-20.0, 
0.0], [13.0, -31.0]], [[18.0, 9.0], [20.0, -2.0]], [[-17.0, -31.0], [-15.0, 27.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_array_rank4_offset0(self):
      arg0=Data(-7.0,self.functionspace)
      arg1=numpy.array([[[[5.0, -7.0, 6.0, -7.0], [6.0, 3.0, -6.0, -5.0], [0.0, -7.0, 6.0, 6.0]], [[6.0, 3.0, 0.0, -1.0], [6.0, 
0.0, 0.0, -3.0], [-5.0, -3.0, 7.0, 0.0]]], [[[-7.0, -2.0, 0.0, 0.0], [7.0, -2.0, 6.0, 2.0], [-3.0, -7.0, 1.0, -1.0]], [[2.0, 
-7.0, 7.0, -3.0], [-5.0, -1.0, 2.0, -2.0], [-2.0, -4.0, -7.0, 2.0]]], [[[3.0, 6.0, -6.0, 7.0], [5.0, 0.0, 5.0, -5.0], [-7.0, 
6.0, -2.0, -6.0]], [[6.0, -2.0, 3.0, 2.0], [4.0, 1.0, 1.0, -4.0], [-4.0, 3.0, -7.0, -1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-35.0, 49.0, -42.0, 49.0], [-42.0, -21.0, 42.0, 35.0], [-0.0, 49.0, -42.0, -42.0]], [[-42.0, 
-21.0, -0.0, 7.0], [-42.0, -0.0, -0.0, 21.0], [35.0, 21.0, -49.0, -0.0]]], [[[49.0, 14.0, -0.0, -0.0], [-49.0, 14.0, -42.0, 
-14.0], [21.0, 49.0, -7.0, 7.0]], [[-14.0, 49.0, -49.0, 21.0], [35.0, 7.0, -14.0, 14.0], [14.0, 28.0, 49.0, -14.0]]], [[[-21.0, 
-42.0, 42.0, -49.0], [-35.0, -0.0, -35.0, 35.0], [49.0, -42.0, 14.0, 42.0]], [[-42.0, 14.0, -21.0, -14.0], [-28.0, -7.0, -7.0, 
28.0], [28.0, -21.0, 49.0, 7.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_constData_rank0_offset0(self):
      arg0=Data(-4.0,self.functionspace)
      arg1=Data(4.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-16.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank1_offset1(self):
      arg0=Data(numpy.array([7.0, 5.0, -4.0]),self.functionspace)
      arg1=Data(numpy.array([7.0, -2.0, 0.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(39.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank2_offset2(self):
      arg0=Data(numpy.array([[0.0, 5.0, 7.0], [-5.0, 2.0, -6.0]]),self.functionspace)
      arg1=Data(numpy.array([[0.0, -1.0, -5.0], [-7.0, -7.0, 4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(-43.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank3_offset3(self):
      arg0=Data(numpy.array([[[4.0, -2.0, 4.0], [-3.0, -7.0, -6.0], [5.0, -2.0, 0.0], [-3.0, -3.0, -3.0]], [[-3.0, -1.0, 7.0], 
[2.0, 7.0, 6.0], [3.0, 7.0, 4.0], [0.0, -3.0, 3.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[5.0, -3.0, 6.0], [-6.0, -3.0, -3.0], [3.0, -5.0, 0.0], [7.0, -4.0, -5.0]], [[2.0, 7.0, -4.0], 
[4.0, -4.0, -2.0], [-4.0, 3.0, -5.0], [4.0, -3.0, 3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(72.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank4_offset4(self):
      arg0=Data(numpy.array([[[[3.0, -3.0], [-1.0, -4.0], [5.0, -7.0]], [[7.0, -1.0], [7.0, -3.0], [5.0, -4.0]]], [[[6.0, 
-3.0], [7.0, -7.0], [3.0, 0.0]], [[-2.0, -4.0], [0.0, -1.0], [-1.0, 5.0]]], [[[7.0, -1.0], [5.0, -4.0], [6.0, 6.0]], [[6.0, 
1.0], [-2.0, 0.0], [1.0, -2.0]]], [[[2.0, 7.0], [-4.0, -2.0], [4.0, -2.0]], [[-6.0, -7.0], [4.0, -5.0], [3.0, 
4.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[1.0, -7.0], [-7.0, -4.0], [0.0, 0.0]], [[2.0, 1.0], [-6.0, 0.0], [-4.0, 6.0]]], [[[-6.0, -6.0], 
[-5.0, 0.0], [5.0, 5.0]], [[6.0, -3.0], [7.0, -4.0], [0.0, 2.0]]], [[[-2.0, 4.0], [4.0, 0.0], [6.0, -2.0]], [[3.0, 2.0], [-7.0, 
2.0], [-4.0, 4.0]]], [[[1.0, -6.0], [-6.0, -5.0], [7.0, -2.0]], [[-5.0, 2.0], [-2.0, 0.0], [2.0, -7.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(10.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_constData_rank1_offset0(self):
      arg0=Data(0.0,self.functionspace)
      arg1=Data(numpy.array([-2.0, 4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-0.0, 0.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank2_offset1(self):
      arg0=Data(numpy.array([6.0, -5.0, 0.0]),self.functionspace)
      arg1=Data(numpy.array([[-3.0, -2.0], [7.0, 4.0], [2.0, -5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-53.0, -32.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank3_offset2(self):
      arg0=Data(numpy.array([[0.0, -6.0, 7.0], [0.0, -5.0, 4.0]]),self.functionspace)
      arg1=Data(numpy.array([[[-2.0, 3.0], [7.0, -1.0], [0.0, 1.0]], [[-4.0, -3.0], [0.0, 2.0], [3.0, 
1.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-30.0, 7.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank4_offset3(self):
      arg0=Data(numpy.array([[[4.0, -6.0, -5.0], [3.0, 2.0, 6.0], [-7.0, -3.0, 2.0], [7.0, 1.0, 5.0]], [[-5.0, -6.0, -3.0], 
[6.0, 0.0, 1.0], [4.0, 7.0, 4.0], [-5.0, -3.0, -5.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[[1.0, -3.0], [4.0, 3.0], [-3.0, 7.0]], [[6.0, 6.0], [-3.0, -7.0], [6.0, 0.0]], [[-2.0, -3.0], 
[-7.0, -7.0], [3.0, -6.0]], [[-1.0, 3.0], [3.0, 7.0], [7.0, 3.0]]], [[[-3.0, 3.0], [0.0, -1.0], [-1.0, 6.0]], [[0.0, 2.0], 
[2.0, -4.0], [-5.0, -5.0]], [[0.0, 1.0], [0.0, 4.0], [-3.0, 7.0]], [[7.0, 2.0], [6.0, -2.0], [0.0, 1.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([63.0, 43.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=-ref
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_constData_rank2_offset0(self):
      arg0=Data(-1.0,self.functionspace)
      arg1=Data(numpy.array([[0.0, -7.0, -1.0, 7.0, 6.0], [0.0, 7.0, -4.0, -4.0, -5.0], [-5.0, 2.0, -2.0, -6.0, -6.0], [2.0, 
-3.0, 0.0, 3.0, 4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-0.0, 7.0, 1.0, -7.0, -6.0], [-0.0, -7.0, 4.0, 4.0, 5.0], [5.0, -2.0, 2.0, 6.0, 6.0], [-2.0, 3.0, 
-0.0, -3.0, -4.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank3_offset1(self):
      arg0=Data(numpy.array([0.0, -2.0, 0.0]),self.functionspace)
      arg1=Data(numpy.array([[[3.0, 0.0, -2.0, -4.0, -2.0], [2.0, -3.0, -3.0, -7.0, 0.0], [7.0, -3.0, -3.0, 6.0, -1.0], [0.0, 
3.0, -3.0, -5.0, 3.0]], [[0.0, -1.0, 0.0, 1.0, -3.0], [4.0, -4.0, 5.0, -4.0, 0.0], [-1.0, -7.0, -2.0, 2.0, 0.0], [3.0, -4.0, 
4.0, 0.0, 6.0]], [[-3.0, -5.0, -5.0, -4.0, 4.0], [-3.0, 0.0, 2.0, -7.0, 5.0], [-1.0, -5.0, 4.0, -4.0, -4.0], [0.0, -1.0, 6.0, 
1.0, 0.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[0.0, 2.0, 0.0, -2.0, 6.0], [-8.0, 8.0, -10.0, 8.0, 0.0], [2.0, 14.0, 4.0, -4.0, 0.0], [-6.0, 8.0, 
-8.0, 0.0, -12.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank4_offset2(self):
      arg0=Data(numpy.array([[3.0, -5.0, 5.0], [0.0, 5.0, -7.0]]),self.functionspace)
      arg1=Data(numpy.array([[[[0.0, 5.0, -4.0, 1.0, 6.0], [7.0, 0.0, -6.0, 7.0, -1.0], [-6.0, -5.0, 0.0, 2.0, 6.0], [-5.0, 
5.0, 7.0, 6.0, -2.0]], [[-4.0, -7.0, 0.0, -6.0, 0.0], [-4.0, 5.0, 5.0, -2.0, -1.0], [5.0, -1.0, 1.0, -6.0, -2.0], [1.0, -2.0, 
3.0, -4.0, -7.0]], [[4.0, 3.0, -7.0, 1.0, -3.0], [-5.0, 1.0, 3.0, 6.0, 4.0], [0.0, -5.0, 1.0, -2.0, 4.0], [0.0, -3.0, -6.0, 
0.0, -4.0]]], [[[5.0, 0.0, 0.0, -1.0, -4.0], [7.0, 5.0, 1.0, -6.0, 1.0], [-5.0, -5.0, -3.0, 4.0, -2.0], [-5.0, 3.0, 2.0, 4.0, 
5.0]], [[2.0, 7.0, 2.0, -2.0, -6.0], [6.0, 0.0, 6.0, -6.0, 4.0], [-4.0, 0.0, 4.0, 5.0, -3.0], [3.0, 1.0, 2.0, -4.0, 0.0]], 
[[-4.0, 2.0, 6.0, 1.0, -6.0], [-2.0, -2.0, -7.0, 6.0, 3.0], [-5.0, 7.0, 0.0, -6.0, -4.0], [-6.0, -1.0, -2.0, 0.0, 
-1.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[78.0, 86.0, -79.0, 21.0, 15.0], [60.0, -6.0, 51.0, -11.0, 21.0], [-28.0, -84.0, 20.0, 93.0, 61.0], 
[37.0, 22.0, 0.0, 18.0, 16.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_constData_rank3_offset0(self):
      arg0=Data(6.0,self.functionspace)
      arg1=Data(numpy.array([[[-2.0, 5.0], [-4.0, 3.0]], [[-4.0, 2.0], [5.0, 7.0]], [[0.0, -6.0], [-7.0, 0.0]], [[-2.0, -3.0], 
[-5.0, -4.0]], [[-2.0, 5.0], [4.0, -3.0]], [[4.0, 1.0], [-7.0, -1.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-12.0, 30.0], [-24.0, 18.0]], [[-24.0, 12.0], [30.0, 42.0]], [[0.0, -36.0], [-42.0, 0.0]], 
[[-12.0, -18.0], [-30.0, -24.0]], [[-12.0, 30.0], [24.0, -18.0]], [[24.0, 6.0], [-42.0, -6.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank4_offset1(self):
      arg0=Data(numpy.array([0.0, -7.0, 7.0]),self.functionspace)
      arg1=Data(numpy.array([[[[-7.0, 6.0], [3.0, -5.0]], [[2.0, 3.0], [-2.0, 1.0]], [[-2.0, 4.0], [6.0, -1.0]], [[5.0, 5.0], 
[4.0, 4.0]], [[4.0, 0.0], [5.0, 7.0]], [[-1.0, 6.0], [-2.0, -7.0]]], [[[3.0, -2.0], [3.0, -6.0]], [[0.0, -1.0], [-6.0, 0.0]], 
[[-3.0, 6.0], [5.0, 6.0]], [[4.0, 3.0], [-6.0, -3.0]], [[-5.0, 0.0], [-7.0, 0.0]], [[0.0, -4.0], [-3.0, 7.0]]], [[[-1.0, 6.0], 
[0.0, -1.0]], [[1.0, -6.0], [-4.0, -1.0]], [[5.0, 2.0], [-1.0, -6.0]], [[1.0, 3.0], [1.0, -6.0]], [[-7.0, -1.0], [2.0, 7.0]], 
[[2.0, -6.0], [5.0, -4.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-28.0, 56.0], [-21.0, 35.0]], [[7.0, -35.0], [14.0, -7.0]], [[56.0, -28.0], [-42.0, -84.0]], 
[[-21.0, 0.0], [49.0, -21.0]], [[-14.0, -7.0], [63.0, 49.0]], [[14.0, -14.0], [56.0, -77.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_constData_rank4_offset0(self):
      arg0=Data(-5.0,self.functionspace)
      arg1=Data(numpy.array([[[[5.0, 0.0, -2.0, -5.0], [-3.0, -5.0, -4.0, 6.0], [5.0, -4.0, -1.0, 3.0]], [[-6.0, 0.0, 6.0, 
2.0], [6.0, -3.0, 4.0, 6.0], [-3.0, 2.0, 1.0, 3.0]]], [[[0.0, 4.0, 4.0, 4.0], [-4.0, -6.0, -6.0, 0.0], [6.0, 7.0, 7.0, -2.0]], 
[[-2.0, -5.0, 2.0, 3.0], [4.0, 2.0, -7.0, 6.0], [-7.0, 3.0, 5.0, 2.0]]], [[[-4.0, -1.0, -3.0, 6.0], [2.0, 7.0, 5.0, 2.0], 
[-6.0, -7.0, 0.0, -6.0]], [[-5.0, -1.0, 4.0, 4.0], [-4.0, 4.0, -6.0, 0.0], [-5.0, 3.0, -5.0, -2.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-25.0, -0.0, 10.0, 25.0], [15.0, 25.0, 20.0, -30.0], [-25.0, 20.0, 5.0, -15.0]], [[30.0, -0.0, 
-30.0, -10.0], [-30.0, 15.0, -20.0, -30.0], [15.0, -10.0, -5.0, -15.0]]], [[[-0.0, -20.0, -20.0, -20.0], [20.0, 30.0, 30.0, 
-0.0], [-30.0, -35.0, -35.0, 10.0]], [[10.0, 25.0, -10.0, -15.0], [-20.0, -10.0, 35.0, -30.0], [35.0, -15.0, -25.0, -10.0]]], 
[[[20.0, 5.0, 15.0, -30.0], [-10.0, -35.0, -25.0, -10.0], [30.0, 35.0, -0.0, 30.0]], [[25.0, 5.0, -20.0, -20.0], [20.0, -20.0, 
30.0, -0.0], [25.0, -15.0, 25.0, 10.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_expandedData_rank0_offset0(self):
      arg0=Data(-7.0,self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-5.0)+(1-msk_arg1)*(0.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(35.0)+(1.-msk_ref)*numpy.array(-0.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank1_offset1(self):
      arg0=Data(numpy.array([-6.0, -1.0, -3.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-3.0, -4.0, 3.0])+(1.-msk_arg1)*numpy.array([4.0, 4.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(13.0)+(1.-msk_ref)*numpy.array(-28.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank2_offset2(self):
      arg0=Data(numpy.array([[5.0, 0.0, -1.0], [3.0, 6.0, 1.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[0.0, 7.0, 0.0], [6.0, 6.0, -5.0]])+(1.-msk_arg1)*numpy.array([[0.0, 6.0, -4.0], [-4.0, -1.0, 
3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(49.0)+(1.-msk_ref)*numpy.array(-11.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank3_offset3(self):
      arg0=Data(numpy.array([[[1.0, -6.0, -6.0], [7.0, 0.0, 5.0], [1.0, 5.0, 0.0], [6.0, -5.0, -3.0]], [[7.0, -5.0, 6.0], 
[-5.0, -2.0, 1.0], [7.0, 5.0, 7.0], [4.0, -4.0, -2.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[1.0, 5.0, 1.0], [5.0, 4.0, -2.0], [5.0, 4.0, 3.0], [-2.0, 3.0, 0.0]], [[2.0, 2.0, 0.0], 
[-7.0, 7.0, -6.0], [1.0, 1.0, -1.0], [1.0, -4.0, -4.0]]])+(1.-msk_arg1)*numpy.array([[[1.0, 3.0, 0.0], [5.0, 2.0, 4.0], [-5.0, 
-1.0, 2.0], [-7.0, -1.0, 0.0]], [[-5.0, -7.0, 7.0], [0.0, 1.0, -5.0], [-6.0, -6.0, 4.0], [4.0, 1.0, -2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(40.0)+(1.-msk_ref)*numpy.array(-2.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank4_offset4(self):
      arg0=Data(numpy.array([[[[-5.0, 7.0], [-2.0, 7.0], [3.0, 7.0]], [[5.0, -4.0], [0.0, 0.0], [2.0, 5.0]]], [[[4.0, 6.0], 
[4.0, -4.0], [-7.0, 1.0]], [[0.0, -6.0], [-6.0, 2.0], [2.0, 3.0]]], [[[-5.0, 6.0], [-6.0, 0.0], [-6.0, 4.0]], [[-2.0, 3.0], 
[7.0, -6.0], [0.0, 6.0]]], [[[-5.0, -4.0], [0.0, -3.0], [-7.0, 4.0]], [[-3.0, 6.0], [0.0, 0.0], [5.0, 
2.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[7.0, 5.0], [0.0, -5.0], [-4.0, -5.0]], [[0.0, -3.0], [4.0, 5.0], [6.0, -6.0]]], [[[-4.0, 
-3.0], [-6.0, 3.0], [-1.0, 0.0]], [[5.0, 1.0], [0.0, -6.0], [2.0, 5.0]]], [[[6.0, 7.0], [3.0, -1.0], [5.0, 6.0]], [[3.0, 1.0], 
[-7.0, 0.0], [5.0, -5.0]]], [[[7.0, -4.0], [0.0, 5.0], [6.0, -6.0]], [[0.0, -4.0], [-2.0, 1.0], [-2.0, 
2.0]]]])+(1.-msk_arg1)*numpy.array([[[[-5.0, 4.0], [-5.0, 4.0], [0.0, -5.0]], [[-4.0, 0.0], [0.0, 3.0], [-5.0, -3.0]]], [[[1.0, 
-1.0], [-2.0, -4.0], [4.0, 3.0]], [[-5.0, 2.0], [0.0, -4.0], [4.0, 0.0]]], [[[-1.0, 0.0], [0.0, 4.0], [7.0, 0.0]], [[-4.0, 
-6.0], [-7.0, 2.0], [-4.0, 4.0]]], [[[3.0, 5.0], [-4.0, -6.0], [0.0, 2.0]], [[4.0, 0.0], [-2.0, 0.0], [-4.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-374.0)+(1.-msk_ref)*numpy.array(-145.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_expandedData_rank1_offset0(self):
      arg0=Data(1.0,self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([1.0, -3.0])+(1.-msk_arg1)*numpy.array([0.0, 5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([1.0, -3.0])+(1.-msk_ref)*numpy.array([0.0, 5.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank2_offset1(self):
      arg0=Data(numpy.array([7.0, 3.0, -1.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, -2.0], [4.0, -7.0], [6.0, 5.0]])+(1.-msk_arg1)*numpy.array([[-7.0, 7.0], [0.0, 6.0], 
[-6.0, -7.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-29.0, -40.0])+(1.-msk_ref)*numpy.array([-43.0, 74.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank3_offset2(self):
      arg0=Data(numpy.array([[-6.0, -5.0, 4.0], [-6.0, -2.0, 1.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[4.0, 6.0], [-3.0, 5.0], [5.0, -3.0]], [[-3.0, -5.0], [-5.0, -2.0], [-5.0, 
-5.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, 1.0], [5.0, 1.0], [-3.0, 6.0]], [[-4.0, -4.0], [0.0, -7.0], [-3.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([34.0, -44.0])+(1.-msk_ref)*numpy.array([-34.0, 48.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=1j*arg0
        arg1=1j*arg1
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank4_offset3(self):
      arg0=Data(numpy.array([[[-1.0, 4.0, 3.0], [4.0, 0.0, 3.0], [3.0, -4.0, -6.0], [7.0, 5.0, -4.0]], [[1.0, 4.0, -1.0], [5.0, 
-3.0, -5.0], [2.0, -5.0, 3.0], [-5.0, -2.0, 1.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-1.0, -1.0], [-4.0, -7.0], [0.0, 6.0]], [[-3.0, 6.0], [5.0, 7.0], [-1.0, -5.0]], [[3.0, 
-1.0], [-6.0, -2.0], [-3.0, 6.0]], [[5.0, 0.0], [2.0, -2.0], [0.0, 0.0]]], [[[-4.0, 5.0], [6.0, -3.0], [7.0, -6.0]], [[-4.0, 
2.0], [2.0, -6.0], [1.0, -5.0]], [[3.0, 0.0], [1.0, -7.0], [-3.0, 0.0]], [[7.0, -6.0], [-4.0, 7.0], [-5.0, 
5.0]]]])+(1.-msk_arg1)*numpy.array([[[[7.0, 0.0], [0.0, -4.0], [0.0, -1.0]], [[2.0, 5.0], [-4.0, 0.0], [-5.0, 5.0]], [[-7.0, 
3.0], [-4.0, -3.0], [7.0, -5.0]], [[-3.0, -7.0], [-3.0, -3.0], [1.0, 1.0]]], [[[-4.0, 1.0], [-3.0, 7.0], [0.0, -6.0]], [[6.0, 
5.0], [-4.0, -5.0], [3.0, -1.0]], [[-2.0, 6.0], [-7.0, 4.0], [-3.0, -5.0]], [[0.0, -2.0], [-1.0, -4.0], [1.0, -3.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([8.0, 67.0])+(1.-msk_ref)*numpy.array([-65.0, 71.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_expandedData_rank2_offset0(self):
      arg0=Data(-2.0,self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[1.0, 2.0, -5.0, -7.0, 0.0], [-7.0, -2.0, -2.0, -3.0, -5.0], [-7.0, -2.0, -2.0, 0.0, 0.0], 
[7.0, 2.0, 2.0, -6.0, -2.0]])+(1.-msk_arg1)*numpy.array([[-2.0, 2.0, 0.0, -1.0, 0.0], [-1.0, 4.0, 1.0, -2.0, -1.0], [-7.0, 
-2.0, -7.0, 1.0, 3.0], [4.0, 6.0, 4.0, -7.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-2.0, -4.0, 10.0, 14.0, -0.0], [14.0, 4.0, 4.0, 6.0, 10.0], [14.0, 4.0, 4.0, -0.0, -0.0], 
[-14.0, -4.0, -4.0, 12.0, 4.0]])+(1.-msk_ref)*numpy.array([[4.0, -4.0, -0.0, 2.0, -0.0], [2.0, -8.0, -2.0, 4.0, 2.0], [14.0, 
4.0, 14.0, -2.0, -6.0], [-8.0, -12.0, -8.0, 14.0, -0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank3_offset1(self):
      arg0=Data(numpy.array([-3.0, -7.0, -3.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[4.0, 7.0, 6.0, 7.0, 1.0], [5.0, -5.0, 4.0, 1.0, 1.0], [-1.0, 2.0, -2.0, -7.0, 5.0], [-4.0, 
0.0, -5.0, 0.0, -6.0]], [[-2.0, 1.0, -4.0, -1.0, 3.0], [4.0, 4.0, 4.0, 3.0, -4.0], [3.0, -2.0, -1.0, -6.0, 0.0], [-5.0, -6.0, 
-6.0, -4.0, -7.0]], [[3.0, -1.0, -5.0, 4.0, -2.0], [-5.0, 4.0, 5.0, 6.0, -3.0], [-5.0, 3.0, 1.0, 0.0, 0.0], [2.0, 7.0, 6.0, 
4.0, -7.0]]])+(1.-msk_arg1)*numpy.array([[[-1.0, -4.0, 3.0, -3.0, -6.0], [-2.0, -4.0, -1.0, 6.0, -1.0], [6.0, 0.0, 0.0, 0.0, 
5.0], [-4.0, -4.0, 5.0, -7.0, 0.0]], [[-2.0, 1.0, 1.0, -3.0, -3.0], [1.0, 6.0, -6.0, -2.0, 7.0], [2.0, 3.0, 0.0, 5.0, -5.0], 
[4.0, 0.0, -4.0, -1.0, 2.0]], [[-3.0, 7.0, -5.0, -5.0, 5.0], [4.0, 4.0, -7.0, -7.0, -3.0], [7.0, -5.0, 6.0, -5.0, 0.0], [2.0, 
7.0, 3.0, -3.0, 7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-7.0, -25.0, 25.0, -26.0, -18.0], [-28.0, -25.0, -55.0, -42.0, 34.0], [-3.0, -1.0, 10.0, 63.0, 
-15.0], [41.0, 21.0, 39.0, 16.0, 88.0]])+(1.-msk_ref)*numpy.array([[26.0, -16.0, -1.0, 45.0, 24.0], [-13.0, -42.0, 66.0, 17.0, 
-37.0], [-53.0, -6.0, -18.0, -20.0, 20.0], [-22.0, -9.0, 4.0, 37.0, -35.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank4_offset2(self):
      arg0=Data(numpy.array([[-2.0, -1.0, 3.0], [3.0, 2.0, 3.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-4.0, 4.0, 0.0, -3.0, 6.0], [5.0, -4.0, 4.0, 4.0, 2.0], [-7.0, -2.0, -3.0, -3.0, 5.0], 
[-5.0, -4.0, -4.0, 1.0, -3.0]], [[-5.0, 7.0, -6.0, 1.0, 2.0], [-5.0, 4.0, 4.0, 6.0, -6.0], [7.0, 6.0, 6.0, 3.0, -3.0], [7.0, 
4.0, 7.0, -6.0, -3.0]], [[2.0, -3.0, -3.0, -5.0, -6.0], [2.0, -4.0, 5.0, -4.0, -1.0], [1.0, -3.0, 1.0, -3.0, -2.0], [3.0, 7.0, 
1.0, 0.0, -1.0]]], [[[4.0, -4.0, 0.0, 5.0, 2.0], [1.0, -3.0, 0.0, 0.0, -5.0], [-7.0, -5.0, -5.0, 0.0, -1.0], [6.0, -3.0, 7.0, 
1.0, -3.0]], [[5.0, 4.0, 0.0, -4.0, 1.0], [1.0, 7.0, -7.0, 3.0, 5.0], [0.0, 4.0, 3.0, 7.0, -4.0], [-1.0, 4.0, -3.0, 4.0, 5.0]], 
[[-6.0, 1.0, 5.0, -2.0, 2.0], [1.0, 6.0, -4.0, 1.0, -6.0], [-3.0, -6.0, 2.0, -7.0, 0.0], [3.0, 6.0, -5.0, -5.0, 
-1.0]]]])+(1.-msk_arg1)*numpy.array([[[[-5.0, -4.0, 7.0, -4.0, 2.0], [5.0, -7.0, -5.0, -3.0, 4.0], [0.0, 6.0, -7.0, -2.0, 
-7.0], [-6.0, 7.0, -5.0, 4.0, -2.0]], [[6.0, 5.0, 6.0, -3.0, 0.0], [0.0, -7.0, 6.0, -5.0, -3.0], [-3.0, 1.0, 6.0, 5.0, -4.0], 
[3.0, 0.0, 2.0, -5.0, 4.0]], [[-3.0, -3.0, 5.0, -5.0, 6.0], [3.0, -6.0, 7.0, 1.0, -5.0], [2.0, 5.0, 5.0, 5.0, 1.0], [1.0, -4.0, 
3.0, 5.0, -6.0]]], [[[3.0, -7.0, 2.0, 6.0, 0.0], [1.0, 6.0, -4.0, -1.0, -7.0], [2.0, 4.0, -2.0, -7.0, 4.0], [6.0, 0.0, 1.0, 
0.0, 4.0]], [[1.0, 1.0, 5.0, -1.0, 3.0], [5.0, 5.0, 6.0, 4.0, -5.0], [-3.0, 1.0, -3.0, -2.0, 0.0], [2.0, 1.0, -2.0, -5.0, 
-4.0]], [[-5.0, 7.0, -1.0, -5.0, -6.0], [-3.0, 3.0, 6.0, 7.0, -1.0], [-6.0, -6.0, 4.0, 1.0, -7.0], [-2.0, -6.0, -1.0, 2.0, 
-5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[23.0, -25.0, 12.0, -9.0, -18.0], [9.0, 15.0, -23.0, -17.0, -24.0], [-20.0, -36.0, 0.0, -13.0, 
-24.0], [37.0, 42.0, 4.0, 0.0, 4.0]])+(1.-msk_ref)*numpy.array([[-9.0, -4.0, 8.0, -3.0, 2.0], [3.0, 40.0, 43.0, 40.0, -54.0], 
[-9.0, -2.0, 23.0, -8.0, 12.0], [28.0, -42.0, 13.0, 8.0, -29.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_expandedData_rank3_offset0(self):
      arg0=Data(4.0,self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-4.0, 0.0], [-5.0, 4.0]], [[-4.0, 6.0], [0.0, 0.0]], [[-3.0, 0.0], [2.0, -4.0]], [[6.0, 
7.0], [2.0, -2.0]], [[3.0, 2.0], [-6.0, 3.0]], [[5.0, 0.0], [6.0, -3.0]]])+(1.-msk_arg1)*numpy.array([[[-6.0, 0.0], [-6.0, 
5.0]], [[2.0, 3.0], [7.0, -2.0]], [[1.0, 7.0], [0.0, 0.0]], [[-7.0, -7.0], [0.0, -7.0]], [[6.0, -7.0], [3.0, 0.0]], [[0.0, 
5.0], [6.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-16.0, 0.0], [-20.0, 16.0]], [[-16.0, 24.0], [0.0, 0.0]], [[-12.0, 0.0], [8.0, -16.0]], 
[[24.0, 28.0], [8.0, -8.0]], [[12.0, 8.0], [-24.0, 12.0]], [[20.0, 0.0], [24.0, -12.0]]])+(1.-msk_ref)*numpy.array([[[-24.0, 
0.0], [-24.0, 20.0]], [[8.0, 12.0], [28.0, -8.0]], [[4.0, 28.0], [0.0, 0.0]], [[-28.0, -28.0], [0.0, -28.0]], [[24.0, -28.0], 
[12.0, 0.0]], [[0.0, 20.0], [24.0, -12.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank4_offset1(self):
      arg0=Data(numpy.array([-6.0, -1.0, -4.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-4.0, 0.0], [-7.0, 7.0]], [[2.0, 3.0], [-4.0, 5.0]], [[-7.0, -1.0], [4.0, 4.0]], [[-4.0, 
-4.0], [0.0, -6.0]], [[4.0, -3.0], [-2.0, -2.0]], [[-5.0, 3.0], [-5.0, -6.0]]], [[[-7.0, 3.0], [-1.0, -6.0]], [[0.0, -1.0], 
[-2.0, -3.0]], [[0.0, 5.0], [7.0, 3.0]], [[-6.0, 5.0], [-5.0, 0.0]], [[-2.0, 6.0], [2.0, 1.0]], [[4.0, -4.0], [-7.0, 5.0]]], 
[[[-4.0, 3.0], [-5.0, -7.0]], [[-7.0, 6.0], [-6.0, 3.0]], [[5.0, 3.0], [4.0, 2.0]], [[-1.0, 7.0], [4.0, -5.0]], [[6.0, -6.0], 
[3.0, 2.0]], [[-2.0, 3.0], [-3.0, 7.0]]]])+(1.-msk_arg1)*numpy.array([[[[-7.0, -3.0], [7.0, 5.0]], [[-5.0, 3.0], [7.0, 4.0]], 
[[7.0, -2.0], [0.0, 0.0]], [[2.0, -4.0], [7.0, 2.0]], [[-3.0, 6.0], [4.0, -2.0]], [[-4.0, -2.0], [0.0, 0.0]]], [[[1.0, 7.0], 
[-5.0, -5.0]], [[5.0, 3.0], [7.0, 0.0]], [[-3.0, 0.0], [-5.0, -4.0]], [[1.0, 0.0], [5.0, -4.0]], [[0.0, -1.0], [0.0, 2.0]], 
[[-5.0, 6.0], [4.0, 3.0]]], [[[7.0, -6.0], [-4.0, 6.0]], [[5.0, -1.0], [7.0, -4.0]], [[3.0, -6.0], [5.0, 2.0]], [[-6.0, 2.0], 
[5.0, -5.0]], [[0.0, 7.0], [-7.0, 0.0]], [[5.0, 0.0], [-6.0, -2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[47.0, -15.0], [63.0, -8.0]], [[16.0, -41.0], [50.0, -39.0]], [[22.0, -11.0], [-47.0, -35.0]], 
[[34.0, -9.0], [-11.0, 56.0]], [[-46.0, 36.0], [-2.0, 3.0]], [[34.0, -26.0], [49.0, 3.0]]])+(1.-msk_ref)*numpy.array([[[13.0, 
35.0], [-21.0, -49.0]], [[5.0, -17.0], [-77.0, -8.0]], [[-51.0, 36.0], [-15.0, -4.0]], [[11.0, 16.0], [-67.0, 12.0]], [[18.0, 
-63.0], [4.0, 10.0]], [[9.0, 6.0], [20.0, 5.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank0_expandedData_rank4_offset0(self):
      arg0=Data(4.0,self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[2.0, 3.0, 1.0, 0.0], [7.0, -4.0, -4.0, 0.0], [-4.0, 0.0, 4.0, -6.0]], [[-7.0, -7.0, -5.0, 
-5.0], [-6.0, -1.0, 3.0, -1.0], [2.0, 3.0, 4.0, -3.0]]], [[[7.0, 1.0, -1.0, 1.0], [7.0, -3.0, 7.0, 3.0], [-3.0, -3.0, -5.0, 
0.0]], [[-6.0, 5.0, -5.0, 0.0], [-6.0, -6.0, 0.0, -6.0], [-2.0, -2.0, -3.0, 7.0]]], [[[-7.0, -5.0, 4.0, -4.0], [-2.0, 2.0, 
-2.0, -5.0], [-6.0, -3.0, -2.0, 2.0]], [[-5.0, 0.0, 1.0, -6.0], [-7.0, 2.0, 6.0, 0.0], [3.0, 1.0, 0.0, 
0.0]]]])+(1.-msk_arg1)*numpy.array([[[[2.0, 5.0, 4.0, -6.0], [-4.0, 0.0, -2.0, -4.0], [-6.0, 0.0, 5.0, -4.0]], [[-3.0, 0.0, 
1.0, -5.0], [-3.0, -5.0, 3.0, -7.0], [0.0, -6.0, -1.0, -7.0]]], [[[2.0, 7.0, 1.0, 2.0], [-2.0, -1.0, 4.0, -7.0], [4.0, -3.0, 
-6.0, 2.0]], [[-4.0, 6.0, -7.0, -3.0], [0.0, 2.0, 6.0, -5.0], [1.0, -2.0, -7.0, 7.0]]], [[[-2.0, -1.0, 3.0, -3.0], [-5.0, -6.0, 
5.0, -1.0], [6.0, 1.0, -5.0, -7.0]], [[0.0, 1.0, 3.0, -2.0], [-3.0, -6.0, 4.0, 1.0], [-6.0, -6.0, -1.0, -7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 12.0, 4.0, 0.0], [28.0, -16.0, -16.0, 0.0], [-16.0, 0.0, 16.0, -24.0]], [[-28.0, -28.0, 
-20.0, -20.0], [-24.0, -4.0, 12.0, -4.0], [8.0, 12.0, 16.0, -12.0]]], [[[28.0, 4.0, -4.0, 4.0], [28.0, -12.0, 28.0, 12.0], 
[-12.0, -12.0, -20.0, 0.0]], [[-24.0, 20.0, -20.0, 0.0], [-24.0, -24.0, 0.0, -24.0], [-8.0, -8.0, -12.0, 28.0]]], [[[-28.0, 
-20.0, 16.0, -16.0], [-8.0, 8.0, -8.0, -20.0], [-24.0, -12.0, -8.0, 8.0]], [[-20.0, 0.0, 4.0, -24.0], [-28.0, 8.0, 24.0, 0.0], 
[12.0, 4.0, 0.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[8.0, 20.0, 16.0, -24.0], [-16.0, 0.0, -8.0, -16.0], [-24.0, 0.0, 20.0, 
-16.0]], [[-12.0, 0.0, 4.0, -20.0], [-12.0, -20.0, 12.0, -28.0], [0.0, -24.0, -4.0, -28.0]]], [[[8.0, 28.0, 4.0, 8.0], [-8.0, 
-4.0, 16.0, -28.0], [16.0, -12.0, -24.0, 8.0]], [[-16.0, 24.0, -28.0, -12.0], [0.0, 8.0, 24.0, -20.0], [4.0, -8.0, -28.0, 
28.0]]], [[[-8.0, -4.0, 12.0, -12.0], [-20.0, -24.0, 20.0, -4.0], [24.0, 4.0, -20.0, -28.0]], [[0.0, 4.0, 12.0, -8.0], [-12.0, 
-24.0, 16.0, 4.0], [-24.0, -24.0, -4.0, -28.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=0)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_float_rank0_offset0(self):
      arg0=Data(numpy.array([3.0, -7.0]),self.functionspace)
      arg1=2.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([6.0, -14.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank0_offset0(self):
      arg0=Data(numpy.array([-2.0, 2.0]),self.functionspace)
      arg1=numpy.array(5.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-10.0, 10.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank1_offset1(self):
      arg0=Data(numpy.array([[7.0, -5.0, -1.0], [-7.0, 0.0, -4.0]]),self.functionspace)
      arg1=numpy.array([-4.0, -7.0, -3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([10.0, 40.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank2_offset2(self):
      arg0=Data(numpy.array([[[0.0, 5.0, 2.0], [1.0, 0.0, 6.0]], [[-4.0, 7.0, 0.0], [7.0, -5.0, 1.0]]]),self.functionspace)
      arg1=numpy.array([[3.0, 5.0, 1.0], [0.0, -4.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([63.0, 49.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank3_offset3(self):
      arg0=Data(numpy.array([[[[6.0, -6.0, -4.0], [4.0, 0.0, 4.0], [5.0, 7.0, 5.0], [0.0, 2.0, 0.0]], [[5.0, -5.0, -6.0], [0.0, 
1.0, 4.0], [-6.0, -7.0, -5.0], [7.0, -1.0, 0.0]]], [[[3.0, 2.0, 4.0], [-7.0, -7.0, -6.0], [-6.0, 0.0, -5.0], [-5.0, 0.0, 
-5.0]], [[6.0, -6.0, 0.0], [-1.0, -3.0, -7.0], [-7.0, 3.0, 3.0], [7.0, 5.0, -2.0]]]]),self.functionspace)
      arg1=numpy.array([[[-4.0, 0.0, -1.0], [2.0, 3.0, -2.0], [-3.0, -4.0, 6.0], [-3.0, 0.0, 4.0]], [[-4.0, 3.0, 4.0], [-4.0, 
-1.0, 4.0], [-3.0, 6.0, -5.0], [0.0, 6.0, -7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([-82.0, -51.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank1_offset0(self):
      arg0=Data(numpy.array([3.0, -3.0]),self.functionspace)
      arg1=numpy.array([-3.0, 7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-9.0, 21.0], [9.0, -21.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank2_offset1(self):
      arg0=Data(numpy.array([[1.0, 0.0, 2.0], [5.0, 3.0, 1.0]]),self.functionspace)
      arg1=numpy.array([[3.0, -1.0], [-4.0, -2.0], [1.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[5.0, -9.0], [4.0, -15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank3_offset2(self):
      arg0=Data(numpy.array([[[-7.0, -7.0, 0.0], [6.0, 5.0, 7.0]], [[2.0, -7.0, 3.0], [2.0, 3.0, -2.0]]]),self.functionspace)
      arg1=numpy.array([[[-3.0, 0.0], [3.0, 6.0], [-6.0, 7.0]], [[0.0, 6.0], [3.0, 5.0], [-3.0, -5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-6.0, -16.0], [-30.0, 16.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank4_offset3(self):
      arg0=Data(numpy.array([[[[5.0, -7.0, -3.0], [3.0, -2.0, -6.0], [2.0, -2.0, -3.0], [1.0, -4.0, 4.0]], [[0.0, -4.0, 6.0], 
[4.0, -4.0, 0.0], [0.0, -7.0, -2.0], [3.0, 4.0, 5.0]]], [[[0.0, 2.0, 0.0], [-1.0, 7.0, 5.0], [5.0, -5.0, 6.0], [6.0, 5.0, 
-7.0]], [[0.0, -3.0, -1.0], [-3.0, -6.0, 1.0], [0.0, 3.0, -3.0], [2.0, 7.0, 0.0]]]]),self.functionspace)
      arg1=numpy.array([[[[-6.0, -1.0], [-5.0, 4.0], [-6.0, 0.0]], [[-6.0, 0.0], [7.0, 7.0], [-2.0, 2.0]], [[-5.0, -1.0], 
[-2.0, -3.0], [-5.0, 4.0]], [[7.0, -1.0], [6.0, 0.0], [6.0, -2.0]]], [[[6.0, 4.0], [4.0, -2.0], [0.0, 1.0]], [[6.0, -7.0], 
[7.0, -2.0], [0.0, 0.0]], [[0.0, 5.0], [4.0, 0.0], [0.0, 0.0]], [[-6.0, 2.0], [-4.0, 0.0], [-4.0, -5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([[-83.0, -101.0], [-80.0, 151.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank2_offset0(self):
      arg0=Data(numpy.array([1.0, -2.0]),self.functionspace)
      arg1=numpy.array([[-1.0, -3.0, 0.0, -4.0, 1.0], [1.0, -7.0, 0.0, -3.0, -1.0], [0.0, -3.0, 3.0, 4.0, 2.0], [1.0, -1.0, 
-1.0, -2.0, 1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-1.0, -3.0, 0.0, -4.0, 1.0], [1.0, -7.0, 0.0, -3.0, -1.0], [0.0, -3.0, 3.0, 4.0, 2.0], [1.0, 
-1.0, -1.0, -2.0, 1.0]], [[2.0, 6.0, 0.0, 8.0, -2.0], [-2.0, 14.0, 0.0, 6.0, 2.0], [0.0, 6.0, -6.0, -8.0, -4.0], [-2.0, 2.0, 
2.0, 4.0, -2.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank3_offset1(self):
      arg0=Data(numpy.array([[3.0, -6.0, 2.0], [0.0, 5.0, 4.0]]),self.functionspace)
      arg1=numpy.array([[[1.0, 6.0, 0.0, 6.0, 1.0], [0.0, 5.0, 6.0, 5.0, 1.0], [6.0, 0.0, -3.0, 0.0, -5.0], [-6.0, 6.0, -6.0, 
0.0, -7.0]], [[-2.0, 4.0, -2.0, -2.0, 2.0], [6.0, -4.0, -2.0, 1.0, 1.0], [0.0, 5.0, 6.0, 0.0, -2.0], [6.0, -1.0, 7.0, 7.0, 
0.0]], [[-3.0, 0.0, -2.0, 1.0, -1.0], [6.0, 4.0, 4.0, -6.0, 0.0], [2.0, -7.0, -5.0, 7.0, 2.0], [-5.0, 5.0, -7.0, 1.0, 1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[9.0, -6.0, 8.0, 32.0, -11.0], [-24.0, 47.0, 38.0, -3.0, -3.0], [22.0, -44.0, -55.0, 14.0, 1.0], 
[-64.0, 34.0, -74.0, -40.0, -19.0]], [[-22.0, 20.0, -18.0, -6.0, 6.0], [54.0, -4.0, 6.0, -19.0, 5.0], [8.0, -3.0, 10.0, 28.0, 
-2.0], [10.0, 15.0, 7.0, 39.0, 4.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank4_offset2(self):
      arg0=Data(numpy.array([[[-2.0, 2.0, -7.0], [-2.0, 2.0, -5.0]], [[5.0, 5.0, -1.0], [6.0, 0.0, -3.0]]]),self.functionspace)
      arg1=numpy.array([[[[4.0, 0.0, 7.0, -6.0, -3.0], [6.0, 0.0, -2.0, 5.0, -3.0], [7.0, 7.0, 5.0, -5.0, -3.0], [4.0, 6.0, 
-5.0, 0.0, 1.0]], [[-5.0, -4.0, 6.0, 3.0, 5.0], [5.0, 2.0, 7.0, -5.0, -4.0], [-4.0, 3.0, 0.0, 1.0, 2.0], [-2.0, 1.0, 3.0, -7.0, 
5.0]], [[6.0, -7.0, -1.0, -6.0, 0.0], [-3.0, 5.0, 7.0, 5.0, 3.0], [6.0, -6.0, 5.0, -2.0, -3.0], [-3.0, -7.0, 6.0, 5.0, 4.0]]], 
[[[5.0, -3.0, 5.0, 3.0, -3.0], [3.0, -7.0, 0.0, 0.0, 0.0], [4.0, 2.0, 6.0, -7.0, -2.0], [-1.0, 0.0, 4.0, 0.0, -2.0]], [[7.0, 
-6.0, -2.0, -7.0, 0.0], [-6.0, -2.0, -3.0, -4.0, -5.0], [0.0, -4.0, 2.0, -5.0, -2.0], [6.0, 3.0, -1.0, 1.0, -2.0]], [[3.0, 6.0, 
4.0, 2.0, -2.0], [3.0, 0.0, 4.0, 0.0, 4.0], [-1.0, 0.0, 0.0, 5.0, 6.0], [-7.0, -2.0, -3.0, 4.0, 4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[-71.0, 5.0, -29.0, 30.0, 32.0], [-14.0, -21.0, -57.0, -63.0, -53.0], [-67.0, 22.0, -53.0, 5.0, 
1.0], [58.0, 55.0, -21.0, -67.0, -40.0]], [[10.0, -49.0, 84.0, 3.0, -2.0], [67.0, -37.0, 6.0, -5.0, -50.0], [36.0, 68.0, 56.0, 
-75.0, -32.0], [28.0, 48.0, 17.0, -52.0, 2.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_array_rank3_offset0(self):
      arg0=Data(numpy.array([-4.0, 0.0]),self.functionspace)
      arg1=numpy.array([[[4.0, -5.0], [6.0, 4.0]], [[7.0, -4.0], [7.0, 5.0]], [[-1.0, -6.0], [4.0, -1.0]], [[-5.0, -2.0], 
[-6.0, -1.0]], [[6.0, -3.0], [0.0, -1.0]], [[-2.0, 1.0], [1.0, -1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-16.0, 20.0], [-24.0, -16.0]], [[-28.0, 16.0], [-28.0, -20.0]], [[4.0, 24.0], [-16.0, 4.0]], 
[[20.0, 8.0], [24.0, 4.0]], [[-24.0, 12.0], [0.0, 4.0]], [[8.0, -4.0], [-4.0, 4.0]]], [[[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 
0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank4_offset1(self):
      arg0=Data(numpy.array([[-2.0, 3.0, -5.0], [6.0, 3.0, -1.0]]),self.functionspace)
      arg1=numpy.array([[[[1.0, -1.0], [-3.0, -3.0]], [[-1.0, -3.0], [1.0, 5.0]], [[-7.0, 2.0], [-2.0, -3.0]], [[1.0, -1.0], 
[-1.0, 0.0]], [[-2.0, -3.0], [-7.0, 0.0]], [[-7.0, 0.0], [-4.0, 5.0]]], [[[-5.0, 6.0], [2.0, 6.0]], [[-1.0, 6.0], [2.0, 0.0]], 
[[3.0, 5.0], [-2.0, -4.0]], [[-7.0, 5.0], [-1.0, -3.0]], [[5.0, 0.0], [2.0, -1.0]], [[-7.0, 1.0], [-6.0, -2.0]]], [[[-3.0, 
0.0], [-3.0, 6.0]], [[5.0, -7.0], [2.0, -2.0]], [[-1.0, 5.0], [4.0, -2.0]], [[2.0, 4.0], [4.0, -5.0]], [[-4.0, 7.0], [2.0, 
1.0]], [[-2.0, -1.0], [-7.0, 2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-2.0, 20.0], [27.0, -6.0]], [[-26.0, 59.0], [-6.0, 0.0]], [[28.0, -14.0], [-22.0, 4.0]], 
[[-33.0, -3.0], [-21.0, 16.0]], [[39.0, -29.0], [10.0, -8.0]], [[3.0, 8.0], [25.0, -26.0]]], [[[-6.0, 12.0], [-9.0, -6.0]], 
[[-14.0, 7.0], [10.0, 32.0]], [[-32.0, 22.0], [-22.0, -28.0]], [[-17.0, 5.0], [-13.0, -4.0]], [[7.0, -25.0], [-38.0, -4.0]], 
[[-61.0, 4.0], [-35.0, 22.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank0_offset0(self):
      arg0=Data(numpy.array([2.0, 0.0]),self.functionspace)
      arg1=Data(3.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([6.0, 0.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank1_offset1(self):
      arg0=Data(numpy.array([[2.0, 0.0, 6.0], [5.0, 7.0, 2.0]]),self.functionspace)
      arg1=Data(numpy.array([6.0, 4.0, -4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-12.0, 50.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank2_offset2(self):
      arg0=Data(numpy.array([[[0.0, 3.0, -5.0], [1.0, 2.0, 1.0]], [[-3.0, 7.0, 1.0], [-1.0, 5.0, -4.0]]]),self.functionspace)
      arg1=Data(numpy.array([[4.0, -6.0, 2.0], [7.0, -7.0, 5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-30.0, -114.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank3_offset3(self):
      arg0=Data(numpy.array([[[[7.0, -3.0, 6.0], [0.0, 2.0, -2.0], [2.0, -6.0, -2.0], [2.0, -5.0, 7.0]], [[0.0, -5.0, 6.0], 
[6.0, -1.0, 2.0], [-7.0, 3.0, -7.0], [4.0, -7.0, 7.0]]], [[[-1.0, -3.0, 0.0], [-6.0, 7.0, -6.0], [-2.0, 5.0, 0.0], [-6.0, 0.0, 
-5.0]], [[5.0, -3.0, 5.0], [-7.0, -2.0, -2.0], [5.0, -6.0, -7.0], [-6.0, 3.0, 2.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[-2.0, 4.0, 3.0], [-2.0, -3.0, -3.0], [6.0, -6.0, -5.0], [7.0, -3.0, 7.0]], [[5.0, -2.0, 4.0], 
[5.0, 0.0, -7.0], [7.0, -4.0, -6.0], [0.0, -3.0, 6.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([222.0, 14.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank1_offset0(self):
      arg0=Data(numpy.array([6.0, -5.0]),self.functionspace)
      arg1=Data(numpy.array([2.0, -6.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[12.0, -36.0], [-10.0, 30.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank2_offset1(self):
      arg0=Data(numpy.array([[7.0, 5.0, 3.0], [-4.0, -5.0, -6.0]]),self.functionspace)
      arg1=Data(numpy.array([[0.0, -3.0], [-6.0, -3.0], [6.0, -7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-12.0, -57.0], [-6.0, 69.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank3_offset2(self):
      arg0=Data(numpy.array([[[-7.0, -6.0, 4.0], [4.0, -6.0, 6.0]], [[4.0, 2.0, -3.0], [-3.0, 0.0, -3.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[0.0, -1.0], [-7.0, -1.0], [0.0, 5.0]], [[3.0, 5.0], [-5.0, 4.0], [-6.0, 
0.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[48.0, 29.0], [-5.0, -36.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank4_offset3(self):
      arg0=Data(numpy.array([[[[0.0, 5.0, -5.0], [5.0, 6.0, 4.0], [3.0, -2.0, 0.0], [-3.0, 4.0, 4.0]], [[1.0, 7.0, -1.0], [0.0, 
-1.0, -5.0], [-2.0, 2.0, -1.0], [-1.0, -3.0, -6.0]]], [[[6.0, -6.0, -6.0], [-5.0, -6.0, 5.0], [-5.0, 3.0, 2.0], [5.0, 1.0, 
6.0]], [[1.0, -3.0, 0.0], [-3.0, -1.0, 0.0], [-4.0, 0.0, -3.0], [7.0, -4.0, 2.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-7.0, -2.0], [-7.0, -3.0], [1.0, 4.0]], [[5.0, -4.0], [5.0, 5.0], [7.0, 1.0]], [[-7.0, 5.0], 
[-1.0, 3.0], [-1.0, 5.0]], [[2.0, 7.0], [5.0, 5.0], [4.0, -3.0]]], [[[3.0, -4.0], [5.0, -6.0], [-6.0, 4.0]], [[-3.0, 7.0], 
[-3.0, -2.0], [-6.0, 7.0]], [[1.0, 0.0], [5.0, 0.0], [-1.0, -6.0]], [[5.0, -5.0], [3.0, 0.0], [-3.0, 
-6.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([[144.0, -61.0], [59.0, -41.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank2_offset0(self):
      arg0=Data(numpy.array([5.0, -2.0]),self.functionspace)
      arg1=Data(numpy.array([[0.0, -2.0, 3.0, -7.0, 1.0], [0.0, 1.0, 0.0, -7.0, -7.0], [-1.0, -1.0, 7.0, 0.0, 3.0], [-5.0, 1.0, 
3.0, 6.0, -4.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[0.0, -10.0, 15.0, -35.0, 5.0], [0.0, 5.0, 0.0, -35.0, -35.0], [-5.0, -5.0, 35.0, 0.0, 15.0], 
[-25.0, 5.0, 15.0, 30.0, -20.0]], [[0.0, 4.0, -6.0, 14.0, -2.0], [0.0, -2.0, 0.0, 14.0, 14.0], [2.0, 2.0, -14.0, 0.0, -6.0], 
[10.0, -2.0, -6.0, -12.0, 8.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank3_offset1(self):
      arg0=Data(numpy.array([[0.0, 6.0, -4.0], [-6.0, -6.0, -3.0]]),self.functionspace)
      arg1=Data(numpy.array([[[-1.0, -2.0, -1.0, 3.0, 3.0], [0.0, 0.0, 5.0, -2.0, 3.0], [3.0, -6.0, 3.0, 3.0, 6.0], [-2.0, 
-6.0, 7.0, 5.0, 2.0]], [[0.0, -5.0, -6.0, -7.0, 3.0], [5.0, 5.0, 5.0, -5.0, 4.0], [3.0, 4.0, 2.0, -6.0, -5.0], [1.0, 0.0, -1.0, 
5.0, -2.0]], [[5.0, 2.0, 6.0, -7.0, -2.0], [0.0, -2.0, -6.0, -5.0, 5.0], [0.0, 0.0, 0.0, -4.0, -5.0], [3.0, 0.0, -4.0, 4.0, 
3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-20.0, -38.0, -60.0, -14.0, 26.0], [30.0, 38.0, 54.0, -10.0, 4.0], [18.0, 24.0, 12.0, -20.0, 
-10.0], [-6.0, 0.0, 10.0, 14.0, -24.0]], [[-9.0, 36.0, 24.0, 45.0, -30.0], [-30.0, -24.0, -42.0, 57.0, -57.0], [-36.0, 12.0, 
-30.0, 30.0, 9.0], [-3.0, 36.0, -24.0, -72.0, -9.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank4_offset2(self):
      arg0=Data(numpy.array([[[-3.0, 4.0, -1.0], [1.0, -7.0, -7.0]], [[2.0, 5.0, 1.0], [0.0, -1.0, -6.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-1.0, -1.0, 0.0, 6.0, 3.0], [-3.0, 4.0, -6.0, 7.0, 3.0], [7.0, -3.0, -4.0, 3.0, 6.0], [0.0, 
2.0, 0.0, 7.0, -1.0]], [[4.0, -4.0, 2.0, -2.0, -7.0], [1.0, 7.0, 2.0, -6.0, -7.0], [-1.0, 5.0, -1.0, 5.0, -2.0], [-6.0, -6.0, 
-5.0, -5.0, -2.0]], [[0.0, 7.0, -7.0, 2.0, 7.0], [-3.0, 4.0, 6.0, -5.0, 1.0], [5.0, 6.0, 7.0, -5.0, 5.0], [-3.0, 0.0, 2.0, 
-3.0, -5.0]]], [[[-6.0, -7.0, 2.0, 6.0, 1.0], [0.0, -1.0, -6.0, -4.0, -2.0], [5.0, -1.0, 6.0, 5.0, -4.0], [-2.0, -1.0, 4.0, 
-3.0, 0.0]], [[7.0, -1.0, -3.0, 0.0, -4.0], [0.0, -6.0, -6.0, 7.0, 5.0], [1.0, 3.0, 1.0, -2.0, -1.0], [1.0, 6.0, 0.0, 7.0, 
7.0]], [[-3.0, 6.0, 1.0, -4.0, -7.0], [-6.0, -3.0, 6.0, 7.0, 0.0], [2.0, -3.0, -1.0, -3.0, 4.0], [-7.0, -4.0, -5.0, -6.0, 
6.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[-15.0, -62.0, 31.0, 6.0, 34.0], [58.0, 74.0, 14.0, -142.0, -75.0], [-46.0, 22.0, 7.0, 56.0, 
-56.0], [19.0, -45.0, 17.0, -48.0, -91.0]], [[29.0, -50.0, 0.0, 28.0, 24.0], [32.0, 71.0, -26.0, -70.0, -33.0], [1.0, 40.0, 
-1.0, 46.0, -16.0], [8.0, -8.0, 7.0, 15.0, -60.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_constData_rank3_offset0(self):
      arg0=Data(numpy.array([6.0, 3.0]),self.functionspace)
      arg1=Data(numpy.array([[[2.0, 0.0], [0.0, 2.0]], [[4.0, 4.0], [-1.0, 4.0]], [[0.0, 7.0], [3.0, -5.0]], [[-5.0, -7.0], 
[-6.0, -1.0]], [[5.0, 2.0], [-6.0, 7.0]], [[4.0, 7.0], [0.0, -4.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[12.0, 0.0], [0.0, 12.0]], [[24.0, 24.0], [-6.0, 24.0]], [[0.0, 42.0], [18.0, -30.0]], [[-30.0, 
-42.0], [-36.0, -6.0]], [[30.0, 12.0], [-36.0, 42.0]], [[24.0, 42.0], [0.0, -24.0]]], [[[6.0, 0.0], [0.0, 6.0]], [[12.0, 12.0], 
[-3.0, 12.0]], [[0.0, 21.0], [9.0, -15.0]], [[-15.0, -21.0], [-18.0, -3.0]], [[15.0, 6.0], [-18.0, 21.0]], [[12.0, 21.0], [0.0, 
-12.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank4_offset1(self):
      arg0=Data(numpy.array([[3.0, -3.0, 0.0], [-6.0, -7.0, 6.0]]),self.functionspace)
      arg1=Data(numpy.array([[[[-2.0, 7.0], [-6.0, -3.0]], [[4.0, -4.0], [3.0, 4.0]], [[4.0, -6.0], [5.0, 4.0]], [[-7.0, 3.0], 
[2.0, 6.0]], [[-3.0, 3.0], [0.0, -2.0]], [[-7.0, -7.0], [4.0, 2.0]]], [[[4.0, 7.0], [-3.0, -1.0]], [[-1.0, -5.0], [0.0, 6.0]], 
[[2.0, 5.0], [4.0, 6.0]], [[0.0, 2.0], [-3.0, -1.0]], [[4.0, -1.0], [-6.0, -3.0]], [[-6.0, -7.0], [-3.0, 1.0]]], [[[0.0, 5.0], 
[4.0, 1.0]], [[0.0, -3.0], [1.0, 7.0]], [[3.0, 4.0], [-1.0, 4.0]], [[4.0, 7.0], [2.0, 4.0]], [[4.0, 1.0], [-7.0, -7.0]], 
[[-6.0, -1.0], [-2.0, 0.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-18.0, 0.0], [-9.0, -6.0]], [[15.0, 3.0], [9.0, -6.0]], [[6.0, -33.0], [3.0, -6.0]], [[-21.0, 
3.0], [15.0, 21.0]], [[-21.0, 12.0], [18.0, 3.0]], [[-3.0, 0.0], [21.0, 3.0]]], [[[-16.0, -61.0], [81.0, 31.0]], [[-17.0, 
41.0], [-12.0, -24.0]], [[-20.0, 25.0], [-64.0, -42.0]], [[66.0, 10.0], [21.0, -5.0]], [[14.0, -5.0], [0.0, -9.0]], [[48.0, 
85.0], [-15.0, -19.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank0_offset0(self):
      arg0=Data(numpy.array([2.0, 1.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-3.0)+(1-msk_arg1)*(7.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-6.0, -3.0])+(1.-msk_ref)*numpy.array([14.0, 7.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank1_offset1(self):
      arg0=Data(numpy.array([[6.0, -6.0, 1.0], [-3.0, 2.0, -2.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([1.0, 5.0, -3.0])+(1.-msk_arg1)*numpy.array([5.0, 6.0, -4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-27.0, 13.0])+(1.-msk_ref)*numpy.array([-10.0, 5.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank2_offset2(self):
      arg0=Data(numpy.array([[[7.0, 0.0, -7.0], [7.0, 0.0, -3.0]], [[4.0, 6.0, 3.0], [0.0, 0.0, -7.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-3.0, 6.0, -4.0], [0.0, 4.0, 4.0]])+(1.-msk_arg1)*numpy.array([[-4.0, 2.0, -1.0], [4.0, -1.0, 
-3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-5.0, -16.0])+(1.-msk_ref)*numpy.array([16.0, 14.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank3_offset3(self):
      arg0=Data(numpy.array([[[[5.0, -2.0, 4.0], [-1.0, 2.0, 3.0], [-5.0, 4.0, 6.0], [-2.0, 1.0, 4.0]], [[-5.0, 1.0, -4.0], 
[-2.0, -7.0, 1.0], [7.0, 0.0, -7.0], [6.0, 0.0, 0.0]]], [[[-3.0, 0.0, 6.0], [0.0, -4.0, 5.0], [2.0, 1.0, 5.0], [0.0, 1.0, 
3.0]], [[-7.0, -4.0, -4.0], [7.0, -3.0, -3.0], [-2.0, -3.0, 0.0], [-1.0, -6.0, -3.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-4.0, 4.0, 6.0], [-3.0, 2.0, -4.0], [-3.0, 6.0, 1.0], [-7.0, -6.0, 3.0]], [[-5.0, 7.0, 
-6.0], [-5.0, 3.0, -6.0], [-2.0, 5.0, -5.0], [0.0, -3.0, -2.0]]])+(1.-msk_arg1)*numpy.array([[[1.0, -2.0, -2.0], [1.0, 3.0, 
6.0], [-7.0, -3.0, 0.0], [0.0, 7.0, 1.0]], [[3.0, 2.0, 3.0], [-5.0, 4.0, -7.0], [0.0, -4.0, -7.0], [-5.0, -5.0, 7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([116.0, 46.0])+(1.-msk_ref)*numpy.array([27.0, -45.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank1_offset0(self):
      arg0=Data(numpy.array([-7.0, -3.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-3.0, -5.0])+(1.-msk_arg1)*numpy.array([-2.0, -3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[21.0, 35.0], [9.0, 15.0]])+(1.-msk_ref)*numpy.array([[14.0, 21.0], [6.0, 9.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank2_offset1(self):
      arg0=Data(numpy.array([[0.0, 3.0, 4.0], [-5.0, -6.0, 1.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, 0.0], [6.0, 1.0], [-3.0, 0.0]])+(1.-msk_arg1)*numpy.array([[6.0, 3.0], [6.0, -6.0], 
[-5.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[6.0, 3.0], [-4.0, -6.0]])+(1.-msk_ref)*numpy.array([[-2.0, 6.0], [-71.0, 27.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank3_offset2(self):
      arg0=Data(numpy.array([[[6.0, 3.0, 2.0], [-7.0, -2.0, 7.0]], [[-6.0, -4.0, -7.0], [3.0, 6.0, 2.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[0.0, -3.0], [1.0, 2.0], [7.0, 5.0]], [[0.0, -1.0], [-7.0, 4.0], [-4.0, 
5.0]]])+(1.-msk_arg1)*numpy.array([[[-1.0, -5.0], [1.0, 0.0], [2.0, 4.0]], [[-5.0, 6.0], [-6.0, -5.0], [0.0, -4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 32.0], [-103.0, 6.0]])+(1.-msk_ref)*numpy.array([[48.0, -82.0], [-63.0, -18.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank4_offset3(self):
      arg0=Data(numpy.array([[[[-7.0, 6.0, -7.0], [0.0, 2.0, 6.0], [0.0, -2.0, 0.0], [6.0, 6.0, 7.0]], [[-4.0, 6.0, -4.0], 
[6.0, 0.0, -2.0], [7.0, -2.0, 0.0], [0.0, 7.0, -3.0]]], [[[3.0, -2.0, 5.0], [-6.0, -7.0, -5.0], [-6.0, -6.0, 7.0], [6.0, 4.0, 
-5.0]], [[-3.0, -7.0, 0.0], [6.0, -5.0, -7.0], [1.0, 2.0, 1.0], [4.0, 0.0, -7.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-2.0, 0.0], [6.0, 4.0], [-7.0, -2.0]], [[6.0, 2.0], [5.0, -2.0], [-3.0, -5.0]], [[-6.0, 
2.0], [-4.0, -6.0], [5.0, -2.0]], [[2.0, -4.0], [3.0, 6.0], [0.0, 5.0]]], [[[6.0, -2.0], [1.0, 1.0], [-3.0, -3.0]], [[3.0, 
-4.0], [3.0, 4.0], [-2.0, -3.0]], [[-5.0, 2.0], [-2.0, 3.0], [-5.0, 7.0]], [[4.0, 2.0], [2.0, -2.0], [-7.0, 
6.0]]]])+(1.-msk_arg1)*numpy.array([[[[6.0, -5.0], [3.0, 0.0], [-3.0, -7.0]], [[-3.0, 7.0], [1.0, -6.0], [1.0, 1.0]], [[-4.0, 
3.0], [0.0, 1.0], [5.0, -3.0]], [[-1.0, 3.0], [-4.0, 2.0], [-7.0, 1.0]]], [[[3.0, 0.0], [0.0, -3.0], [-6.0, 7.0]], [[-1.0, 
3.0], [-3.0, 7.0], [-3.0, -2.0]], [[7.0, -2.0], [0.0, 4.0], [6.0, -5.0]], [[-1.0, -5.0], [0.0, -7.0], [2.0, -5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[149.0, 47.0], [53.0, -49.0]])+(1.-msk_ref)*numpy.array([[-19.0, 33.0], [91.0, -45.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank2_offset0(self):
      arg0=Data(numpy.array([2.0, 5.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[4.0, 3.0, 3.0, 4.0, -1.0], [5.0, -3.0, 1.0, -3.0, -2.0], [0.0, -7.0, -7.0, 2.0, -4.0], [-1.0, 
-3.0, -2.0, -3.0, -4.0]])+(1.-msk_arg1)*numpy.array([[-5.0, 0.0, -1.0, 6.0, 0.0], [1.0, 3.0, -4.0, 3.0, 4.0], [0.0, 6.0, -1.0, 
6.0, 5.0], [-2.0, -4.0, 0.0, 2.0, 4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 6.0, 6.0, 8.0, -2.0], [10.0, -6.0, 2.0, -6.0, -4.0], [0.0, -14.0, -14.0, 4.0, -8.0], 
[-2.0, -6.0, -4.0, -6.0, -8.0]], [[20.0, 15.0, 15.0, 20.0, -5.0], [25.0, -15.0, 5.0, -15.0, -10.0], [0.0, -35.0, -35.0, 10.0, 
-20.0], [-5.0, -15.0, -10.0, -15.0, -20.0]]])+(1.-msk_ref)*numpy.array([[[-10.0, 0.0, -2.0, 12.0, 0.0], [2.0, 6.0, -8.0, 6.0, 
8.0], [0.0, 12.0, -2.0, 12.0, 10.0], [-4.0, -8.0, 0.0, 4.0, 8.0]], [[-25.0, 0.0, -5.0, 30.0, 0.0], [5.0, 15.0, -20.0, 15.0, 
20.0], [0.0, 30.0, -5.0, 30.0, 25.0], [-10.0, -20.0, 0.0, 10.0, 20.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank3_offset1(self):
      arg0=Data(numpy.array([[2.0, 2.0, -6.0], [2.0, -5.0, 0.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[4.0, -4.0, 6.0, 5.0, 5.0], [4.0, -1.0, 3.0, -4.0, 3.0], [-4.0, 2.0, -7.0, -5.0, -7.0], [3.0, 
-3.0, 1.0, 3.0, 0.0]], [[7.0, -1.0, 6.0, 1.0, 4.0], [4.0, 7.0, -5.0, -1.0, 3.0], [4.0, -7.0, -6.0, 7.0, -1.0], [-2.0, -3.0, 
4.0, 2.0, 0.0]], [[-4.0, 4.0, 2.0, -4.0, 0.0], [7.0, 7.0, -7.0, -7.0, -2.0], [0.0, 5.0, -6.0, 2.0, -3.0], [-7.0, -6.0, -2.0, 
-1.0, -5.0]]])+(1.-msk_arg1)*numpy.array([[[-4.0, -4.0, 6.0, 3.0, 3.0], [-3.0, 1.0, 6.0, -5.0, 5.0], [-4.0, 5.0, -1.0, 2.0, 
7.0], [-5.0, 2.0, 3.0, 0.0, 0.0]], [[-6.0, 0.0, -5.0, -2.0, 5.0], [3.0, -1.0, -3.0, 6.0, -2.0], [0.0, 1.0, -1.0, 3.0, 7.0], 
[-2.0, -4.0, 7.0, -7.0, 2.0]], [[-4.0, 3.0, -5.0, 3.0, 6.0], [-3.0, -7.0, 2.0, -1.0, 1.0], [2.0, -5.0, -2.0, 0.0, -5.0], [-5.0, 
-6.0, 6.0, 2.0, -1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[46.0, -34.0, 12.0, 36.0, 18.0], [-26.0, -30.0, 38.0, 32.0, 24.0], [0.0, -40.0, 10.0, -8.0, 
2.0], [44.0, 24.0, 22.0, 16.0, 30.0]], [[-27.0, -3.0, -18.0, 5.0, -10.0], [-12.0, -37.0, 31.0, -3.0, -9.0], [-28.0, 39.0, 16.0, 
-45.0, -9.0], [16.0, 9.0, -18.0, -4.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[4.0, -26.0, 32.0, -16.0, -20.0], [18.0, 42.0, -6.0, 
8.0, 0.0], [-20.0, 42.0, 8.0, 10.0, 58.0], [16.0, 32.0, -16.0, -26.0, 10.0]], [[22.0, -8.0, 37.0, 16.0, -19.0], [-21.0, 7.0, 
27.0, -40.0, 20.0], [-8.0, 5.0, 3.0, -11.0, -21.0], [0.0, 24.0, -29.0, 35.0, -10.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank4_offset2(self):
      arg0=Data(numpy.array([[[-7.0, 0.0, -6.0], [-5.0, 1.0, 3.0]], [[6.0, 6.0, -4.0], [5.0, 5.0, 3.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[6.0, -7.0, 2.0, 0.0, 1.0], [0.0, 2.0, 7.0, -2.0, -3.0], [4.0, -4.0, 5.0, 7.0, 5.0], [1.0, 
0.0, 4.0, -5.0, -1.0]], [[3.0, -3.0, -2.0, 2.0, 4.0], [7.0, -2.0, 6.0, -2.0, -5.0], [4.0, 6.0, -7.0, 6.0, -4.0], [4.0, -6.0, 
-2.0, -6.0, 5.0]], [[6.0, -5.0, 6.0, -4.0, -5.0], [-6.0, -6.0, -4.0, 3.0, 4.0], [2.0, -6.0, 6.0, -3.0, -2.0], [-3.0, -3.0, 0.0, 
3.0, 5.0]]], [[[-1.0, 0.0, -3.0, -5.0, 7.0], [3.0, -1.0, -2.0, -2.0, 7.0], [2.0, -3.0, -1.0, 5.0, -7.0], [-7.0, -4.0, -4.0, 
2.0, 6.0]], [[0.0, 2.0, -3.0, -2.0, -2.0], [-4.0, -4.0, -2.0, -4.0, -1.0], [7.0, 7.0, -2.0, 4.0, 3.0], [1.0, -4.0, 7.0, -7.0, 
2.0]], [[6.0, 6.0, -6.0, -5.0, 0.0], [5.0, 1.0, -4.0, 3.0, 1.0], [-7.0, 0.0, 4.0, 0.0, -5.0], [5.0, -4.0, 5.0, -4.0, 
6.0]]]])+(1.-msk_arg1)*numpy.array([[[[7.0, -5.0, -2.0, -1.0, 0.0], [-5.0, -2.0, -3.0, 4.0, -2.0], [7.0, 0.0, 3.0, -2.0, 5.0], 
[-2.0, 1.0, 3.0, 0.0, 1.0]], [[6.0, 7.0, 6.0, -7.0, 0.0], [3.0, -1.0, 7.0, 0.0, -1.0], [2.0, 6.0, 5.0, 3.0, 1.0], [4.0, -3.0, 
-4.0, -3.0, -4.0]], [[-5.0, 4.0, 7.0, 0.0, -2.0], [-7.0, 0.0, 5.0, 3.0, 6.0], [0.0, 0.0, -5.0, 2.0, 4.0], [0.0, 5.0, 0.0, 1.0, 
-4.0]]], [[[4.0, 3.0, 6.0, 0.0, 6.0], [-7.0, -4.0, 1.0, -4.0, 4.0], [-5.0, -1.0, -5.0, 1.0, 2.0], [0.0, -1.0, -2.0, -3.0, 
-5.0]], [[0.0, 7.0, 5.0, -7.0, -6.0], [-7.0, -4.0, 0.0, -4.0, -1.0], [-3.0, -1.0, 0.0, 0.0, 7.0], [-4.0, -7.0, 7.0, -7.0, 
5.0]], [[-7.0, -1.0, -3.0, -3.0, 0.0], [5.0, 1.0, 6.0, 7.0, -3.0], [-5.0, -5.0, -1.0, -4.0, 1.0], [5.0, 3.0, -6.0, 0.0, 
-6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-55.0, 99.0, -56.0, 32.0, -14.0], [32.0, 26.0, -29.0, 11.0, -36.0], [-64.0, 86.0, -56.0, 
-52.0, 0.0], [62.0, 22.0, 14.0, -12.0, -33.0]], [[43.0, -12.0, -72.0, -22.0, 75.0], [76.0, 2.0, 62.0, -57.0, -31.0], [64.0, 
56.0, -39.0, 135.0, -21.0], [27.0, -76.0, 42.0, -115.0, 62.0]]])+(1.-msk_ref)*numpy.array([[[-60.0, 0.0, -62.0, -9.0, -24.0], 
[120.0, 33.0, 4.0, -9.0, -52.0], [-42.0, -11.0, 31.0, -15.0, -59.0], [25.0, -30.0, -22.0, 2.0, 29.0]], [[97.0, 43.0, 42.0, 
-92.0, 8.0], [-39.0, -55.0, 27.0, -7.0, -36.0], [-1.0, 11.0, 40.0, -9.0, 68.0], [7.0, -63.0, 1.0, -72.0, -20.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank1_expandedData_rank3_offset0(self):
      arg0=Data(numpy.array([7.0, 7.0]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[3.0, -6.0], [-2.0, -2.0]], [[4.0, 6.0], [-1.0, -3.0]], [[-3.0, -1.0], [1.0, 6.0]], [[0.0, 
3.0], [7.0, 5.0]], [[-7.0, -7.0], [4.0, 4.0]], [[-5.0, -3.0], [7.0, 5.0]]])+(1.-msk_arg1)*numpy.array([[[-5.0, -6.0], [4.0, 
5.0]], [[-5.0, 3.0], [-2.0, 0.0]], [[0.0, -7.0], [-7.0, 3.0]], [[0.0, 3.0], [-5.0, -4.0]], [[-6.0, 6.0], [2.0, 0.0]], [[-6.0, 
3.0], [-2.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[21.0, -42.0], [-14.0, -14.0]], [[28.0, 42.0], [-7.0, -21.0]], [[-21.0, -7.0], [7.0, 42.0]], 
[[0.0, 21.0], [49.0, 35.0]], [[-49.0, -49.0], [28.0, 28.0]], [[-35.0, -21.0], [49.0, 35.0]]], [[[21.0, -42.0], [-14.0, -14.0]], 
[[28.0, 42.0], [-7.0, -21.0]], [[-21.0, -7.0], [7.0, 42.0]], [[0.0, 21.0], [49.0, 35.0]], [[-49.0, -49.0], [28.0, 28.0]], 
[[-35.0, -21.0], [49.0, 35.0]]]])+(1.-msk_ref)*numpy.array([[[[-35.0, -42.0], [28.0, 35.0]], [[-35.0, 21.0], [-14.0, 0.0]], 
[[0.0, -49.0], [-49.0, 21.0]], [[0.0, 21.0], [-35.0, -28.0]], [[-42.0, 42.0], [14.0, 0.0]], [[-42.0, 21.0], [-14.0, 0.0]]], 
[[[-35.0, -42.0], [28.0, 35.0]], [[-35.0, 21.0], [-14.0, 0.0]], [[0.0, -49.0], [-49.0, 21.0]], [[0.0, 21.0], [-35.0, -28.0]], 
[[-42.0, 42.0], [14.0, 0.0]], [[-42.0, 21.0], [-14.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank4_offset1(self):
      arg0=Data(numpy.array([[-1.0, 7.0, -2.0], [-4.0, -2.0, -5.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-2.0, -2.0], [3.0, 6.0]], [[5.0, 2.0], [3.0, -4.0]], [[6.0, -1.0], [-5.0, -4.0]], [[6.0, 
0.0], [0.0, 0.0]], [[-4.0, 0.0], [4.0, 5.0]], [[0.0, -1.0], [-4.0, 0.0]]], [[[4.0, 6.0], [6.0, 1.0]], [[-4.0, 2.0], [-5.0, 
2.0]], [[-3.0, 6.0], [0.0, 0.0]], [[-1.0, -2.0], [-5.0, -4.0]], [[-1.0, -3.0], [5.0, 0.0]], [[-7.0, -4.0], [5.0, -1.0]]], 
[[[-1.0, 6.0], [-2.0, -6.0]], [[-2.0, 0.0], [-4.0, -3.0]], [[6.0, -2.0], [2.0, -3.0]], [[6.0, 1.0], [-5.0, -3.0]], [[6.0, 0.0], 
[0.0, 2.0]], [[6.0, -2.0], [0.0, 0.0]]]])+(1.-msk_arg1)*numpy.array([[[[0.0, -6.0], [6.0, 7.0]], [[5.0, -3.0], [-7.0, -2.0]], 
[[0.0, -1.0], [-5.0, -2.0]], [[-5.0, 0.0], [-3.0, -5.0]], [[7.0, -3.0], [3.0, 1.0]], [[2.0, 5.0], [2.0, 3.0]]], [[[2.0, -3.0], 
[-6.0, 5.0]], [[7.0, -4.0], [6.0, -4.0]], [[6.0, -5.0], [4.0, 0.0]], [[6.0, 3.0], [-2.0, -1.0]], [[6.0, 5.0], [-4.0, -6.0]], 
[[7.0, 2.0], [-6.0, -2.0]]], [[[5.0, -3.0], [0.0, 4.0]], [[-7.0, 0.0], [1.0, 2.0]], [[-4.0, -6.0], [-3.0, 0.0]], [[5.0, -5.0], 
[2.0, 7.0]], [[-2.0, 7.0], [5.0, -7.0]], [[-6.0, -7.0], [-4.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[32.0, 32.0], [43.0, 13.0]], [[-29.0, 12.0], [-30.0, 24.0]], [[-39.0, 47.0], [1.0, 10.0]], 
[[-25.0, -16.0], [-25.0, -22.0]], [[-15.0, -21.0], [31.0, -9.0]], [[-61.0, -23.0], [39.0, -7.0]]], [[[5.0, -34.0], [-14.0, 
4.0]], [[-2.0, -12.0], [18.0, 27.0]], [[-48.0, 2.0], [10.0, 31.0]], [[-52.0, -1.0], [35.0, 23.0]], [[-12.0, 6.0], [-26.0, 
-30.0]], [[-16.0, 22.0], [6.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[4.0, -9.0], [-48.0, 20.0]], [[58.0, -25.0], [47.0, 
-30.0]], [[50.0, -22.0], [39.0, 2.0]], [[37.0, 31.0], [-15.0, -16.0]], [[39.0, 24.0], [-41.0, -29.0]], [[59.0, 23.0], [-36.0, 
-19.0]]], [[[-29.0, 45.0], [-12.0, -58.0]], [[1.0, 20.0], [11.0, 6.0]], [[8.0, 44.0], [27.0, 8.0]], [[-17.0, 19.0], [6.0, 
-13.0]], [[-30.0, -33.0], [-29.0, 43.0]], [[8.0, 11.0], [24.0, -13.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_float_rank0_offset0(self):
      arg0=Data(numpy.array([[4.0, -1.0, 6.0, -6.0, 0.0], [-1.0, -2.0, -1.0, 7.0, -1.0], [0.0, 4.0, 1.0, 6.0, -7.0], [0.0, 5.0, 
-2.0, 6.0, -1.0]]),self.functionspace)
      arg1=-3.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-12.0, 3.0, -18.0, 18.0, -0.0], [3.0, 6.0, 3.0, -21.0, 3.0], [-0.0, -12.0, -3.0, -18.0, 21.0], 
[-0.0, -15.0, 6.0, -18.0, 3.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank0_offset0(self):
      arg0=Data(numpy.array([[-7.0, -5.0, 6.0, -5.0, 4.0], [-4.0, 3.0, -4.0, 1.0, -5.0], [4.0, -2.0, -3.0, 0.0, -5.0], [2.0, 
-5.0, -2.0, 4.0, 4.0]]),self.functionspace)
      arg1=numpy.array(-4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[28.0, 20.0, -24.0, 20.0, -16.0], [16.0, -12.0, 16.0, -4.0, 20.0], [-16.0, 8.0, 12.0, -0.0, 20.0], 
[-8.0, 20.0, 8.0, -16.0, -16.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank1_offset1(self):
      arg0=Data(numpy.array([[[0.0, 3.0, 5.0], [6.0, -5.0, -2.0], [4.0, 3.0, 7.0], [-2.0, -2.0, -7.0], [3.0, 4.0, 6.0]], 
[[-1.0, 7.0, 5.0], [7.0, 7.0, 0.0], [4.0, 5.0, 0.0], [2.0, -1.0, 2.0], [3.0, -2.0, -5.0]], [[3.0, -5.0, -6.0], [2.0, -6.0, 
-2.0], [4.0, 7.0, 0.0], [0.0, 7.0, -5.0], [6.0, -1.0, 7.0]], [[7.0, 1.0, -6.0], [0.0, -1.0, -3.0], [-5.0, 3.0, 3.0], [7.0, 
-1.0, 7.0], [-3.0, -4.0, 6.0]]]),self.functionspace)
      arg1=numpy.array([5.0, 2.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[6.0, 20.0, 26.0, -14.0, 23.0], [9.0, 49.0, 30.0, 8.0, 11.0], [5.0, -2.0, 34.0, 14.0, 28.0], [37.0, 
-2.0, -19.0, 33.0, -23.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank2_offset2(self):
      arg0=Data(numpy.array([[[[-3.0, -2.0, 0.0], [3.0, 1.0, 5.0]], [[5.0, 4.0, -6.0], [4.0, -6.0, 2.0]], [[0.0, 0.0, 1.0], 
[6.0, -6.0, 7.0]], [[-2.0, -7.0, -5.0], [-1.0, 0.0, -3.0]], [[-5.0, -3.0, -2.0], [4.0, -1.0, 7.0]]], [[[-1.0, 6.0, 0.0], [-3.0, 
-2.0, 5.0]], [[4.0, 2.0, -4.0], [1.0, -6.0, 7.0]], [[3.0, -1.0, -5.0], [2.0, -7.0, 0.0]], [[1.0, 0.0, -1.0], [-2.0, 0.0, 
-5.0]], [[-5.0, -1.0, -2.0], [0.0, -6.0, -1.0]]], [[[1.0, 0.0, 7.0], [-1.0, 3.0, -6.0]], [[-7.0, -3.0, 3.0], [6.0, -1.0, 2.0]], 
[[0.0, -1.0, 7.0], [-7.0, -3.0, 4.0]], [[-6.0, 5.0, 1.0], [-5.0, 1.0, 2.0]], [[6.0, 3.0, 0.0], [-4.0, 6.0, -1.0]]], [[[-5.0, 
0.0, -3.0], [-6.0, -1.0, -6.0]], [[-7.0, 0.0, 5.0], [4.0, 6.0, -3.0]], [[6.0, -2.0, 1.0], [3.0, 0.0, 0.0]], [[-3.0, 5.0, 4.0], 
[-2.0, 4.0, -4.0]], [[-2.0, -3.0, -2.0], [7.0, -6.0, -7.0]]]]),self.functionspace)
      arg1=numpy.array([[0.0, 1.0, -5.0], [-4.0, 0.0, 4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[6.0, 26.0, -1.0, 10.0, 19.0], [38.0, 46.0, 16.0, -7.0, 5.0], [-55.0, -34.0, 8.0, 28.0, 15.0], 
[15.0, -53.0, -19.0, -23.0, -49.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank1_offset0(self):
      arg0=Data(numpy.array([[-5.0, -4.0, 6.0, -2.0, 3.0], [7.0, 0.0, 6.0, -2.0, 3.0], [-6.0, -6.0, -2.0, -2.0, 0.0], [-6.0, 
-5.0, 7.0, 6.0, -5.0]]),self.functionspace)
      arg1=numpy.array([-5.0, -3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[25.0, 15.0], [20.0, 12.0], [-30.0, -18.0], [10.0, 6.0], [-15.0, -9.0]], [[-35.0, -21.0], [0.0, 
0.0], [-30.0, -18.0], [10.0, 6.0], [-15.0, -9.0]], [[30.0, 18.0], [30.0, 18.0], [10.0, 6.0], [10.0, 6.0], [0.0, 0.0]], [[30.0, 
18.0], [25.0, 15.0], [-35.0, -21.0], [-30.0, -18.0], [25.0, 15.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank2_offset1(self):
      arg0=Data(numpy.array([[[-3.0, -3.0, -6.0], [-5.0, 1.0, 0.0], [-7.0, 3.0, 0.0], [7.0, -6.0, 7.0], [-4.0, -1.0, -5.0]], 
[[4.0, -1.0, 0.0], [3.0, 0.0, 6.0], [0.0, -3.0, -7.0], [4.0, -1.0, 6.0], [-1.0, 7.0, -3.0]], [[-6.0, 1.0, 0.0], [-4.0, -6.0, 
4.0], [0.0, 0.0, 0.0], [3.0, -3.0, 1.0], [-1.0, 0.0, -4.0]], [[3.0, -1.0, -7.0], [7.0, -6.0, 7.0], [6.0, 0.0, -1.0], [3.0, 4.0, 
3.0], [-2.0, -6.0, -3.0]]]),self.functionspace)
      arg1=numpy.array([[0.0, -1.0], [0.0, -4.0], [4.0, -6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-24.0, 51.0], [0.0, 1.0], [0.0, -5.0], [28.0, -25.0], [-20.0, 38.0]], [[0.0, 0.0], [24.0, -39.0], 
[-28.0, 54.0], [24.0, -36.0], [-12.0, -9.0]], [[0.0, 2.0], [16.0, 4.0], [0.0, 0.0], [4.0, 3.0], [-16.0, 25.0]], [[-28.0, 43.0], 
[28.0, -25.0], [-4.0, 0.0], [12.0, -37.0], [-12.0, 44.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank3_offset2(self):
      arg0=Data(numpy.array([[[[5.0, 0.0, -6.0], [-7.0, 2.0, -6.0]], [[-7.0, 4.0, 0.0], [4.0, 0.0, 1.0]], [[3.0, -5.0, 0.0], 
[-6.0, -4.0, -6.0]], [[-2.0, -6.0, 6.0], [-3.0, 2.0, 2.0]], [[6.0, -6.0, 1.0], [1.0, -4.0, -3.0]]], [[[0.0, 0.0, 4.0], [-3.0, 
6.0, -6.0]], [[-6.0, -5.0, 4.0], [6.0, -6.0, -6.0]], [[7.0, -2.0, 0.0], [0.0, -6.0, -1.0]], [[-7.0, -4.0, -2.0], [-5.0, -3.0, 
6.0]], [[-5.0, 2.0, 0.0], [-6.0, 2.0, 2.0]]], [[[-2.0, -4.0, 2.0], [3.0, 6.0, -6.0]], [[6.0, 0.0, -5.0], [-6.0, 0.0, 4.0]], 
[[0.0, 0.0, -5.0], [4.0, 2.0, -2.0]], [[2.0, -1.0, 4.0], [0.0, -5.0, -3.0]], [[4.0, -3.0, -1.0], [7.0, 7.0, -2.0]]], [[[-6.0, 
6.0, -3.0], [6.0, -2.0, 3.0]], [[1.0, -1.0, 2.0], [3.0, -3.0, -3.0]], [[2.0, -6.0, 2.0], [-7.0, 7.0, -7.0]], [[1.0, -3.0, 1.0], 
[-6.0, -6.0, -2.0]], [[6.0, -3.0, -2.0], [-7.0, 5.0, 0.0]]]]),self.functionspace)
      arg1=numpy.array([[[4.0, 6.0], [0.0, 4.0], [-1.0, 4.0]], [[-4.0, 4.0], [4.0, 7.0], [-2.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[74.0, 10.0], [-46.0, -13.0], [32.0, -36.0], [2.0, -16.0], [9.0, 1.0]], [[44.0, 64.0], [-64.0, 
-40.0], [6.0, -5.0], [-30.0, -125.0], [8.0, -38.0]], [[14.0, 52.0], [45.0, -20.0], [1.0, 16.0], [-10.0, -2.0], [21.0, 91.0]], 
[[-59.0, -23.0], [-16.0, 10.0], [76.0, 38.0], [7.0, -62.0], [74.0, 23.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_array_rank2_offset0(self):
      arg0=Data(numpy.array([[1.0, 4.0, 6.0, 1.0, 3.0], [-1.0, 2.0, 0.0, -3.0, -3.0], [7.0, 4.0, -6.0, -3.0, 4.0], [-7.0, -6.0, 
4.0, 0.0, 4.0]]),self.functionspace)
      arg1=numpy.array([[-7.0, 6.0, 7.0, 5.0, -1.0], [-3.0, -1.0, 6.0, -7.0, 3.0], [-1.0, -1.0, 3.0, 6.0, 7.0], [-4.0, 7.0, 
0.0, 6.0, -7.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-7.0, 6.0, 7.0, 5.0, -1.0], [-3.0, -1.0, 6.0, -7.0, 3.0], [-1.0, -1.0, 3.0, 6.0, 7.0], [-4.0, 
7.0, 0.0, 6.0, -7.0]], [[-28.0, 24.0, 28.0, 20.0, -4.0], [-12.0, -4.0, 24.0, -28.0, 12.0], [-4.0, -4.0, 12.0, 24.0, 28.0], 
[-16.0, 28.0, 0.0, 24.0, -28.0]], [[-42.0, 36.0, 42.0, 30.0, -6.0], [-18.0, -6.0, 36.0, -42.0, 18.0], [-6.0, -6.0, 18.0, 36.0, 
42.0], [-24.0, 42.0, 0.0, 36.0, -42.0]], [[-7.0, 6.0, 7.0, 5.0, -1.0], [-3.0, -1.0, 6.0, -7.0, 3.0], [-1.0, -1.0, 3.0, 6.0, 
7.0], [-4.0, 7.0, 0.0, 6.0, -7.0]], [[-21.0, 18.0, 21.0, 15.0, -3.0], [-9.0, -3.0, 18.0, -21.0, 9.0], [-3.0, -3.0, 9.0, 18.0, 
21.0], [-12.0, 21.0, 0.0, 18.0, -21.0]]], [[[7.0, -6.0, -7.0, -5.0, 1.0], [3.0, 1.0, -6.0, 7.0, -3.0], [1.0, 1.0, -3.0, -6.0, 
-7.0], [4.0, -7.0, 0.0, -6.0, 7.0]], [[-14.0, 12.0, 14.0, 10.0, -2.0], [-6.0, -2.0, 12.0, -14.0, 6.0], [-2.0, -2.0, 6.0, 12.0, 
14.0], [-8.0, 14.0, 0.0, 12.0, -14.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 
0.0, 0.0, 0.0, 0.0]], [[21.0, -18.0, -21.0, -15.0, 3.0], [9.0, 3.0, -18.0, 21.0, -9.0], [3.0, 3.0, -9.0, -18.0, -21.0], [12.0, 
-21.0, 0.0, -18.0, 21.0]], [[21.0, -18.0, -21.0, -15.0, 3.0], [9.0, 3.0, -18.0, 21.0, -9.0], [3.0, 3.0, -9.0, -18.0, -21.0], 
[12.0, -21.0, 0.0, -18.0, 21.0]]], [[[-49.0, 42.0, 49.0, 35.0, -7.0], [-21.0, -7.0, 42.0, -49.0, 21.0], [-7.0, -7.0, 21.0, 
42.0, 49.0], [-28.0, 49.0, 0.0, 42.0, -49.0]], [[-28.0, 24.0, 28.0, 20.0, -4.0], [-12.0, -4.0, 24.0, -28.0, 12.0], [-4.0, -4.0, 
12.0, 24.0, 28.0], [-16.0, 28.0, 0.0, 24.0, -28.0]], [[42.0, -36.0, -42.0, -30.0, 6.0], [18.0, 6.0, -36.0, 42.0, -18.0], [6.0, 
6.0, -18.0, -36.0, -42.0], [24.0, -42.0, 0.0, -36.0, 42.0]], [[21.0, -18.0, -21.0, -15.0, 3.0], [9.0, 3.0, -18.0, 21.0, -9.0], 
[3.0, 3.0, -9.0, -18.0, -21.0], [12.0, -21.0, 0.0, -18.0, 21.0]], [[-28.0, 24.0, 28.0, 20.0, -4.0], [-12.0, -4.0, 24.0, -28.0, 
12.0], [-4.0, -4.0, 12.0, 24.0, 28.0], [-16.0, 28.0, 0.0, 24.0, -28.0]]], [[[49.0, -42.0, -49.0, -35.0, 7.0], [21.0, 7.0, 
-42.0, 49.0, -21.0], [7.0, 7.0, -21.0, -42.0, -49.0], [28.0, -49.0, 0.0, -42.0, 49.0]], [[42.0, -36.0, -42.0, -30.0, 6.0], 
[18.0, 6.0, -36.0, 42.0, -18.0], [6.0, 6.0, -18.0, -36.0, -42.0], [24.0, -42.0, 0.0, -36.0, 42.0]], [[-28.0, 24.0, 28.0, 20.0, 
-4.0], [-12.0, -4.0, 24.0, -28.0, 12.0], [-4.0, -4.0, 12.0, 24.0, 28.0], [-16.0, 28.0, 0.0, 24.0, -28.0]], [[0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[-28.0, 24.0, 28.0, 20.0, -4.0], 
[-12.0, -4.0, 24.0, -28.0, 12.0], [-4.0, -4.0, 12.0, 24.0, 28.0], [-16.0, 28.0, 0.0, 24.0, -28.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank3_offset1(self):
      arg0=Data(numpy.array([[[0.0, -5.0, 0.0], [-5.0, -3.0, 7.0], [5.0, 6.0, -4.0], [3.0, -4.0, 7.0], [0.0, -1.0, -4.0]], 
[[4.0, -5.0, -6.0], [-7.0, 2.0, -6.0], [3.0, -6.0, -5.0], [1.0, 6.0, 2.0], [5.0, -3.0, 2.0]], [[0.0, 2.0, -5.0], [5.0, 4.0, 
-3.0], [-6.0, 7.0, 2.0], [0.0, -4.0, -7.0], [1.0, 1.0, -4.0]], [[2.0, -5.0, 5.0], [6.0, 7.0, -5.0], [0.0, 6.0, 4.0], [1.0, 0.0, 
4.0], [0.0, -7.0, 3.0]]]),self.functionspace)
      arg1=numpy.array([[[-7.0, -2.0, 7.0, 0.0, -4.0], [-6.0, -2.0, 5.0, 6.0, -3.0], [0.0, -2.0, 6.0, -1.0, -3.0], [0.0, -5.0, 
2.0, -7.0, 0.0]], [[-1.0, 7.0, 3.0, 3.0, 3.0], [-2.0, -7.0, -2.0, 2.0, 4.0], [-6.0, 2.0, 3.0, -2.0, -3.0], [-4.0, 5.0, -1.0, 
3.0, 1.0]], [[6.0, -1.0, -7.0, -2.0, -4.0], [-1.0, -3.0, 2.0, -1.0, -1.0], [-5.0, -3.0, 1.0, -3.0, -7.0], [-4.0, -2.0, 4.0, 
0.0, 1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[5.0, -35.0, -15.0, -15.0, -15.0], [10.0, 35.0, 10.0, -10.0, -20.0], [30.0, -10.0, -15.0, 10.0, 
15.0], [20.0, -25.0, 5.0, -15.0, -5.0]], [[80.0, -18.0, -93.0, -23.0, -17.0], [29.0, 10.0, -5.0, -43.0, -4.0], [-17.0, -17.0, 
-32.0, -10.0, -25.0], [-16.0, -4.0, 21.0, 26.0, 4.0]], [[-65.0, 36.0, 81.0, 26.0, 14.0], [-38.0, -40.0, 5.0, 46.0, 13.0], 
[-16.0, 14.0, 44.0, -5.0, -5.0], [-8.0, 13.0, -12.0, -17.0, 2.0]], [[25.0, -41.0, -40.0, -26.0, -52.0], [-17.0, 1.0, 37.0, 3.0, 
-32.0], [-11.0, -35.0, 13.0, -16.0, -46.0], [-12.0, -49.0, 38.0, -33.0, 3.0]], [[-23.0, -3.0, 25.0, 5.0, 13.0], [6.0, 19.0, 
-6.0, 2.0, 0.0], [26.0, 10.0, -7.0, 14.0, 31.0], [20.0, 3.0, -15.0, -3.0, -5.0]]], [[[-59.0, -37.0, 55.0, -3.0, -7.0], [-8.0, 
45.0, 18.0, 20.0, -26.0], [60.0, 0.0, 3.0, 24.0, 45.0], [44.0, -33.0, -11.0, -43.0, -11.0]], [[11.0, 34.0, -1.0, 18.0, 58.0], 
[44.0, 18.0, -51.0, -32.0, 35.0], [18.0, 36.0, -42.0, 21.0, 57.0], [16.0, 57.0, -40.0, 55.0, -4.0]], [[-45.0, -43.0, 38.0, 
-8.0, -10.0], [-1.0, 51.0, 17.0, 11.0, -28.0], [61.0, -3.0, -5.0, 24.0, 44.0], [44.0, -35.0, -8.0, -39.0, -11.0]], [[-1.0, 
38.0, 11.0, 14.0, 6.0], [-20.0, -50.0, -3.0, 16.0, 19.0], [-46.0, 4.0, 26.0, -19.0, -35.0], [-32.0, 21.0, 4.0, 11.0, 8.0]], 
[[-20.0, -33.0, 12.0, -13.0, -37.0], [-26.0, 5.0, 35.0, 22.0, -29.0], [8.0, -22.0, 23.0, -5.0, -20.0], [4.0, -44.0, 21.0, 
-44.0, -1.0]]], [[[-32.0, 19.0, 41.0, 16.0, 26.0], [1.0, 1.0, -14.0, 9.0, 13.0], [13.0, 19.0, 1.0, 11.0, 29.0], [12.0, 20.0, 
-22.0, 6.0, -3.0]], [[-57.0, 21.0, 68.0, 18.0, 4.0], [-35.0, -29.0, 11.0, 41.0, 4.0], [-9.0, 7.0, 39.0, -4.0, -6.0], [-4.0, 
1.0, -6.0, -23.0, 1.0]], [[47.0, 59.0, -35.0, 17.0, 37.0], [20.0, -43.0, -40.0, -24.0, 44.0], [-52.0, 20.0, -13.0, -14.0, 
-17.0], [-36.0, 61.0, -11.0, 63.0, 9.0]], [[-38.0, -21.0, 37.0, 2.0, 16.0], [15.0, 49.0, -6.0, -1.0, -9.0], [59.0, 13.0, -19.0, 
29.0, 61.0], [44.0, -6.0, -24.0, -12.0, -11.0]], [[-32.0, 9.0, 38.0, 11.0, 15.0], [-4.0, 3.0, -5.0, 12.0, 5.0], [14.0, 12.0, 
5.0, 9.0, 22.0], [12.0, 8.0, -15.0, -4.0, -3.0]]], [[[21.0, -44.0, -36.0, -25.0, -43.0], [-7.0, 16.0, 30.0, -3.0, -31.0], [5.0, 
-29.0, 2.0, -7.0, -26.0], [0.0, -45.0, 29.0, -29.0, 0.0]], [[-79.0, 42.0, 98.0, 31.0, 17.0], [-45.0, -46.0, 6.0, 55.0, 15.0], 
[-17.0, 17.0, 52.0, -5.0, -4.0], [-8.0, 15.0, -15.0, -21.0, 2.0]], [[18.0, 38.0, -10.0, 10.0, 2.0], [-16.0, -54.0, -4.0, 8.0, 
20.0], [-56.0, 0.0, 22.0, -24.0, -46.0], [-40.0, 22.0, 10.0, 18.0, 10.0]], [[17.0, -6.0, -21.0, -8.0, -20.0], [-10.0, -14.0, 
13.0, 2.0, -7.0], [-20.0, -14.0, 10.0, -13.0, -31.0], [-16.0, -13.0, 18.0, -7.0, 4.0]], [[25.0, -52.0, -42.0, -27.0, -33.0], 
[11.0, 40.0, 20.0, -17.0, -31.0], [27.0, -23.0, -18.0, 5.0, 0.0], [16.0, -41.0, 19.0, -21.0, -4.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank4_offset2(self):
      arg0=Data(numpy.array([[[[-6.0, 7.0, 1.0], [0.0, 0.0, -5.0]], [[-4.0, 7.0, -5.0], [2.0, 0.0, -7.0]], [[3.0, -1.0, 4.0], 
[-1.0, 1.0, -5.0]], [[6.0, 2.0, 2.0], [-6.0, 1.0, 7.0]], [[7.0, 7.0, 7.0], [4.0, -2.0, 7.0]]], [[[-6.0, 0.0, -6.0], [-4.0, 
-7.0, 1.0]], [[0.0, -7.0, -7.0], [-4.0, 3.0, -3.0]], [[-3.0, 4.0, 0.0], [5.0, 0.0, 3.0]], [[-4.0, -7.0, -5.0], [1.0, 4.0, 
-4.0]], [[7.0, 7.0, 7.0], [-1.0, 1.0, 3.0]]], [[[-4.0, -2.0, 4.0], [2.0, 5.0, 7.0]], [[1.0, 0.0, -7.0], [0.0, -3.0, -1.0]], 
[[4.0, 0.0, -3.0], [-7.0, 5.0, -7.0]], [[-5.0, -1.0, 0.0], [-7.0, 3.0, 0.0]], [[0.0, -1.0, -7.0], [7.0, 5.0, -5.0]]], [[[-1.0, 
7.0, -6.0], [-3.0, 5.0, 5.0]], [[4.0, 0.0, 4.0], [5.0, -7.0, 3.0]], [[4.0, -6.0, 5.0], [6.0, 5.0, 1.0]], [[-7.0, -1.0, -7.0], 
[0.0, -5.0, -7.0]], [[6.0, 0.0, 4.0], [4.0, 4.0, -6.0]]]]),self.functionspace)
      arg1=numpy.array([[[[1.0, 0.0, 2.0, -6.0, -4.0], [2.0, 6.0, 1.0, 0.0, 3.0], [-4.0, 4.0, -5.0, 3.0, -1.0], [-6.0, -7.0, 
3.0, -7.0, -1.0]], [[5.0, 1.0, -7.0, 2.0, -5.0], [4.0, 5.0, 0.0, 7.0, -1.0], [0.0, 4.0, -6.0, 0.0, -3.0], [0.0, -7.0, -4.0, 
7.0, -2.0]], [[-1.0, 3.0, -7.0, -3.0, -2.0], [6.0, -2.0, -4.0, 1.0, -5.0], [4.0, -3.0, 4.0, 0.0, 1.0], [0.0, 5.0, 0.0, 0.0, 
-6.0]]], [[[1.0, 1.0, -6.0, 6.0, -3.0], [-7.0, -1.0, -3.0, -7.0, 7.0], [7.0, 6.0, -2.0, 5.0, -4.0], [-4.0, 5.0, 4.0, -5.0, 
0.0]], [[-1.0, 6.0, 0.0, -5.0, 4.0], [7.0, 7.0, -2.0, -7.0, -6.0], [-2.0, 0.0, -5.0, 0.0, 2.0], [-1.0, -4.0, 7.0, 4.0, -5.0]], 
[[4.0, 7.0, -7.0, 6.0, -3.0], [-2.0, 7.0, -3.0, 0.0, 4.0], [6.0, 0.0, -7.0, 5.0, -2.0], [3.0, 0.0, -3.0, 0.0, 3.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[[8.0, -25.0, -33.0, 17.0, 2.0], [32.0, -38.0, 5.0, 50.0, -50.0], [-2.0, 1.0, 27.0, -43.0, -4.0], 
[21.0, -2.0, -31.0, 91.0, -29.0]], [[10.0, -55.0, 15.0, 23.0, 6.0], [-10.0, -30.0, 31.0, 30.0, -8.0], [-32.0, 39.0, 3.0, -37.0, 
-16.0], [-5.0, -36.0, -11.0, 67.0, -1.0]], [[-28.0, -19.0, 26.0, -73.0, 7.0], [50.0, -22.0, 3.0, -3.0, -43.0], [-35.0, -10.0, 
39.0, -21.0, 20.0], [-30.0, -3.0, 31.0, -19.0, -45.0]], [[35.0, 57.0, -29.0, -37.0, -37.0], [67.0, 104.0, -7.0, 51.0, -14.0], 
[-18.0, -10.0, -76.0, 23.0, 2.0], [8.0, -80.0, -28.0, 6.0, -6.0]], [[69.0, 69.0, -157.0, 27.0, -118.0], [28.0, 94.0, -50.0, 
42.0, 47.0], [74.0, 59.0, -96.0, 76.0, -55.0], [-35.0, -35.0, -26.0, -28.0, -32.0]]], [[[7.0, -57.0, 47.0, 71.0, 17.0], [-71.0, 
-62.0, 41.0, 71.0, 30.0], [-8.0, -30.0, 42.0, -33.0, 0.0], [62.0, 20.0, -86.0, 34.0, 80.0]], [[-47.0, -35.0, 143.0, -50.0, 
82.0], [-15.0, -17.0, 43.0, -49.0, -16.0], [-80.0, -31.0, 28.0, -35.0, 42.0], [4.0, -18.0, 42.0, -17.0, 32.0]], [[34.0, 30.0, 
-85.0, 74.0, -32.0], [-31.0, 18.0, -27.0, -7.0, 34.0], [65.0, 34.0, -40.0, 31.0, -35.0], [7.0, 18.0, -14.0, 24.0, 4.0]], 
[[-53.0, -25.0, 98.0, -13.0, 86.0], [-37.0, -50.0, 17.0, -89.0, -13.0], [-29.0, -23.0, 48.0, -27.0, 32.0], [4.0, 41.0, 60.0, 
-10.0, 16.0]], [[45.0, 54.0, -99.0, -42.0, -79.0], [92.0, 92.0, -29.0, 56.0, -22.0], [9.0, 29.0, -73.0, 31.0, -21.0], [-30.0, 
-72.0, -13.0, 9.0, -59.0]]], [[[7.0, 91.0, -83.0, 37.0, 11.0], [15.0, 40.0, -57.0, -59.0, -18.0], [78.0, -24.0, -30.0, 33.0, 
2.0], [32.0, 52.0, 18.0, 24.0, -20.0]], [[7.0, -46.0, 58.0, 24.0, 1.0], [-59.0, -8.0, 38.0, 14.0, 52.0], [-32.0, 25.0, -11.0, 
-2.0, -12.0], [-6.0, -30.0, -15.0, -19.0, 53.0]], [[-33.0, -35.0, 120.0, -124.0, 52.0], [88.0, 23.0, 48.0, 11.0, -80.0], 
[-129.0, -17.0, 6.0, -58.0, 45.0], [-22.0, -98.0, 40.0, 27.0, -32.0]], [[-20.0, 10.0, 39.0, -29.0, 58.0], [56.0, -7.0, 10.0, 
21.0, -81.0], [-35.0, -66.0, 30.0, -50.0, 42.0], [55.0, -5.0, -18.0, 75.0, -8.0]], [[-16.0, -20.0, 49.0, 6.0, 33.0], [-50.0, 
2.0, 12.0, -98.0, 35.0], [-19.0, 59.0, -26.0, 10.0, -12.0], [-48.0, -13.0, 82.0, -22.0, 4.0]]], [[[52.0, 51.0, -26.0, 25.0, 
-5.0], [36.0, 114.0, 7.0, 29.0, -11.0], [-21.0, 24.0, -115.0, 7.0, -14.0], [28.0, -107.0, -23.0, 91.0, 13.0]], [[24.0, -4.0, 
-71.0, 47.0, -76.0], [-58.0, -17.0, -22.0, 18.0, 81.0], [67.0, 34.0, 0.0, 52.0, -40.0], [-28.0, 45.0, -26.0, -81.0, 16.0]], 
[[-26.0, 52.0, -28.0, -34.0, 3.0], [5.0, 20.0, -47.0, -114.0, 9.0], [42.0, 13.0, -8.0, 47.0, 3.0], [-50.0, 49.0, 92.0, -80.0, 
-44.0]], [[-28.0, -101.0, 91.0, 44.0, 48.0], [-81.0, -117.0, 52.0, 21.0, 17.0], [-32.0, -11.0, 87.0, -56.0, 7.0], [26.0, 41.0, 
-31.0, 22.0, 55.0]], [[-22.0, -2.0, 2.0, -80.0, -10.0], [48.0, 10.0, -12.0, -52.0, -22.0], [-24.0, 36.0, 0.0, 8.0, 2.0], 
[-74.0, -18.0, 80.0, -46.0, -68.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank0_offset0(self):
      arg0=Data(numpy.array([[7.0, -4.0, -1.0, 0.0, -1.0], [-5.0, 2.0, -5.0, -2.0, 2.0], [-2.0, -7.0, 5.0, -3.0, -1.0], [-7.0, 
0.0, 4.0, 3.0, 1.0]]),self.functionspace)
      arg1=Data(-5.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-35.0, 20.0, 5.0, -0.0, 5.0], [25.0, -10.0, 25.0, 10.0, -10.0], [10.0, 35.0, -25.0, 15.0, 5.0], 
[35.0, -0.0, -20.0, -15.0, -5.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank1_offset1(self):
      arg0=Data(numpy.array([[[0.0, -4.0, 3.0], [2.0, 5.0, 1.0], [-6.0, -7.0, 7.0], [6.0, -7.0, 5.0], [-2.0, 1.0, 4.0]], [[7.0, 
-6.0, 0.0], [3.0, 3.0, -5.0], [4.0, -2.0, 0.0], [4.0, -4.0, -4.0], [5.0, 7.0, 4.0]], [[-5.0, -4.0, 7.0], [-1.0, -1.0, -6.0], 
[7.0, -4.0, 6.0], [3.0, -6.0, 1.0], [4.0, 0.0, 6.0]], [[3.0, 1.0, 6.0], [5.0, -7.0, 1.0], [-3.0, -3.0, -2.0], [-6.0, 3.0, 6.0], 
[0.0, 4.0, 4.0]]]),self.functionspace)
      arg1=Data(numpy.array([-6.0, 5.0, 2.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-14.0, 15.0, 15.0, -61.0, 25.0], [-72.0, -13.0, -34.0, -52.0, 13.0], [24.0, -11.0, -50.0, -46.0, 
-12.0], [-1.0, -63.0, -1.0, 63.0, 28.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank2_offset2(self):
      arg0=Data(numpy.array([[[[7.0, 4.0, 0.0], [2.0, 5.0, 7.0]], [[-1.0, 0.0, 3.0], [6.0, 0.0, -2.0]], [[2.0, 5.0, -7.0], 
[-3.0, 0.0, 7.0]], [[-5.0, 7.0, 2.0], [-4.0, 7.0, 7.0]], [[3.0, -1.0, 0.0], [4.0, -5.0, 5.0]]], [[[-4.0, -1.0, 2.0], [1.0, 2.0, 
2.0]], [[0.0, 0.0, -5.0], [-4.0, 7.0, -6.0]], [[-1.0, 6.0, 1.0], [7.0, 0.0, 7.0]], [[0.0, 6.0, -7.0], [-7.0, 5.0, -1.0]], 
[[7.0, 4.0, -2.0], [5.0, 6.0, -1.0]]], [[[-3.0, -2.0, 3.0], [-4.0, 3.0, 0.0]], [[7.0, -7.0, 4.0], [7.0, 0.0, -7.0]], [[0.0, 
3.0, -7.0], [-7.0, -1.0, 3.0]], [[0.0, 0.0, -7.0], [0.0, 1.0, 5.0]], [[-4.0, 0.0, 5.0], [4.0, -5.0, 2.0]]], [[[0.0, 2.0, -5.0], 
[7.0, 0.0, 2.0]], [[1.0, 0.0, 6.0], [-1.0, 0.0, -5.0]], [[2.0, 0.0, 5.0], [-1.0, -5.0, 1.0]], [[-2.0, -2.0, -6.0], [-5.0, 4.0, 
-3.0]], [[2.0, 0.0, 0.0], [0.0, -7.0, -4.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[-5.0, 0.0, -2.0], [0.0, 0.0, -6.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-77.0, 11.0, -38.0, -21.0, -45.0], [4.0, 46.0, -39.0, 20.0, -25.0], [9.0, -1.0, -4.0, -16.0, 
-2.0], [-2.0, 13.0, -26.0, 40.0, 14.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank1_offset0(self):
      arg0=Data(numpy.array([[-4.0, 7.0, 6.0, 4.0, 6.0], [0.0, -3.0, -6.0, 3.0, -7.0], [5.0, 4.0, -5.0, -4.0, -5.0], [6.0, 
-3.0, -4.0, -6.0, 5.0]]),self.functionspace)
      arg1=Data(numpy.array([2.0, -6.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-8.0, 24.0], [14.0, -42.0], [12.0, -36.0], [8.0, -24.0], [12.0, -36.0]], [[0.0, 0.0], [-6.0, 
18.0], [-12.0, 36.0], [6.0, -18.0], [-14.0, 42.0]], [[10.0, -30.0], [8.0, -24.0], [-10.0, 30.0], [-8.0, 24.0], [-10.0, 30.0]], 
[[12.0, -36.0], [-6.0, 18.0], [-8.0, 24.0], [-12.0, 36.0], [10.0, -30.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank2_offset1(self):
      arg0=Data(numpy.array([[[3.0, 0.0, -5.0], [-7.0, -7.0, 3.0], [-4.0, -4.0, -4.0], [-4.0, -2.0, -7.0], [5.0, -7.0, 0.0]], 
[[-4.0, 3.0, -6.0], [6.0, 6.0, -2.0], [-7.0, 3.0, 3.0], [0.0, -5.0, -6.0], [-2.0, -3.0, -3.0]], [[5.0, 1.0, 4.0], [-6.0, 1.0, 
7.0], [0.0, -2.0, 4.0], [6.0, -1.0, -6.0], [-2.0, -2.0, 6.0]], [[-5.0, 2.0, -2.0], [-7.0, 3.0, -6.0], [7.0, 1.0, -3.0], [-4.0, 
-1.0, 7.0], [-5.0, -6.0, -4.0]]]),self.functionspace)
      arg1=Data(numpy.array([[1.0, -7.0], [6.0, -5.0], [3.0, 5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-12.0, -46.0], [-40.0, 99.0], [-40.0, 28.0], [-37.0, 3.0], [-37.0, 0.0]], [[-4.0, -17.0], [36.0, 
-82.0], [20.0, 49.0], [-48.0, -5.0], [-29.0, 14.0]], [[23.0, -20.0], [21.0, 72.0], [0.0, 30.0], [-18.0, -67.0], [4.0, 54.0]], 
[[1.0, 15.0], [-7.0, 4.0], [4.0, -69.0], [11.0, 68.0], [-53.0, 45.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank3_offset2(self):
      arg0=Data(numpy.array([[[[-2.0, -1.0, 6.0], [3.0, 0.0, -1.0]], [[-4.0, -3.0, -4.0], [0.0, 2.0, -4.0]], [[-6.0, 2.0, 3.0], 
[7.0, -1.0, 0.0]], [[-4.0, 3.0, 4.0], [0.0, 0.0, 4.0]], [[5.0, 1.0, -5.0], [5.0, 0.0, 6.0]]], [[[2.0, 1.0, 1.0], [-5.0, 7.0, 
6.0]], [[-7.0, 1.0, 4.0], [0.0, 6.0, 1.0]], [[-3.0, -2.0, 3.0], [2.0, 7.0, 0.0]], [[-4.0, -7.0, -5.0], [-7.0, -6.0, 0.0]], 
[[-1.0, 2.0, 6.0], [4.0, 4.0, 6.0]]], [[[6.0, 0.0, 1.0], [0.0, 0.0, 3.0]], [[-4.0, -5.0, 0.0], [7.0, 0.0, 4.0]], [[-1.0, 7.0, 
0.0], [0.0, -4.0, 4.0]], [[-2.0, -3.0, -1.0], [-4.0, 0.0, 2.0]], [[-2.0, 7.0, 6.0], [-4.0, 3.0, 2.0]]], [[[7.0, -3.0, 4.0], 
[7.0, -7.0, -2.0]], [[-1.0, -3.0, -2.0], [2.0, 3.0, 1.0]], [[-7.0, 3.0, -5.0], [-3.0, -5.0, -3.0]], [[7.0, -3.0, 6.0], [-5.0, 
1.0, -6.0]], [[6.0, -4.0, 7.0], [4.0, 0.0, -2.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[-7.0, -5.0], [6.0, -3.0], [-2.0, 6.0]], [[0.0, -1.0], [0.0, -6.0], [-5.0, 
7.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[1.0, 39.0], [38.0, -35.0], [48.0, 41.0], [18.0, 63.0], [-49.0, -21.0]], [[-40.0, -2.0], [42.0, 
27.0], [3.0, -5.0], [-4.0, 54.0], [-23.0, 49.0]], [[-59.0, -3.0], [-22.0, 56.0], [29.0, 36.0], [-12.0, 31.0], [34.0, 25.0]], 
[[-65.0, 19.0], [-12.0, -11.0], [92.0, 8.0], [-49.0, -33.0], [-70.0, 6.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_constData_rank2_offset0(self):
      arg0=Data(numpy.array([[-4.0, 5.0, -4.0, 3.0, 2.0], [7.0, 5.0, 7.0, -2.0, 3.0], [1.0, 5.0, -2.0, 0.0, -4.0], [3.0, -7.0, 
3.0, -6.0, -5.0]]),self.functionspace)
      arg1=Data(numpy.array([[-4.0, -1.0, 3.0, -5.0, 5.0], [6.0, 1.0, 3.0, 0.0, -2.0], [4.0, 3.0, 0.0, 0.0, -4.0], [-5.0, -5.0, 
5.0, 5.0, -7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[16.0, 4.0, -12.0, 20.0, -20.0], [-24.0, -4.0, -12.0, 0.0, 8.0], [-16.0, -12.0, 0.0, 0.0, 16.0], 
[20.0, 20.0, -20.0, -20.0, 28.0]], [[-20.0, -5.0, 15.0, -25.0, 25.0], [30.0, 5.0, 15.0, 0.0, -10.0], [20.0, 15.0, 0.0, 0.0, 
-20.0], [-25.0, -25.0, 25.0, 25.0, -35.0]], [[16.0, 4.0, -12.0, 20.0, -20.0], [-24.0, -4.0, -12.0, 0.0, 8.0], [-16.0, -12.0, 
0.0, 0.0, 16.0], [20.0, 20.0, -20.0, -20.0, 28.0]], [[-12.0, -3.0, 9.0, -15.0, 15.0], [18.0, 3.0, 9.0, 0.0, -6.0], [12.0, 9.0, 
0.0, 0.0, -12.0], [-15.0, -15.0, 15.0, 15.0, -21.0]], [[-8.0, -2.0, 6.0, -10.0, 10.0], [12.0, 2.0, 6.0, 0.0, -4.0], [8.0, 6.0, 
0.0, 0.0, -8.0], [-10.0, -10.0, 10.0, 10.0, -14.0]]], [[[-28.0, -7.0, 21.0, -35.0, 35.0], [42.0, 7.0, 21.0, 0.0, -14.0], [28.0, 
21.0, 0.0, 0.0, -28.0], [-35.0, -35.0, 35.0, 35.0, -49.0]], [[-20.0, -5.0, 15.0, -25.0, 25.0], [30.0, 5.0, 15.0, 0.0, -10.0], 
[20.0, 15.0, 0.0, 0.0, -20.0], [-25.0, -25.0, 25.0, 25.0, -35.0]], [[-28.0, -7.0, 21.0, -35.0, 35.0], [42.0, 7.0, 21.0, 0.0, 
-14.0], [28.0, 21.0, 0.0, 0.0, -28.0], [-35.0, -35.0, 35.0, 35.0, -49.0]], [[8.0, 2.0, -6.0, 10.0, -10.0], [-12.0, -2.0, -6.0, 
0.0, 4.0], [-8.0, -6.0, 0.0, 0.0, 8.0], [10.0, 10.0, -10.0, -10.0, 14.0]], [[-12.0, -3.0, 9.0, -15.0, 15.0], [18.0, 3.0, 9.0, 
0.0, -6.0], [12.0, 9.0, 0.0, 0.0, -12.0], [-15.0, -15.0, 15.0, 15.0, -21.0]]], [[[-4.0, -1.0, 3.0, -5.0, 5.0], [6.0, 1.0, 3.0, 
0.0, -2.0], [4.0, 3.0, 0.0, 0.0, -4.0], [-5.0, -5.0, 5.0, 5.0, -7.0]], [[-20.0, -5.0, 15.0, -25.0, 25.0], [30.0, 5.0, 15.0, 
0.0, -10.0], [20.0, 15.0, 0.0, 0.0, -20.0], [-25.0, -25.0, 25.0, 25.0, -35.0]], [[8.0, 2.0, -6.0, 10.0, -10.0], [-12.0, -2.0, 
-6.0, 0.0, 4.0], [-8.0, -6.0, 0.0, 0.0, 8.0], [10.0, 10.0, -10.0, -10.0, 14.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[16.0, 4.0, -12.0, 20.0, -20.0], [-24.0, -4.0, -12.0, 0.0, 
8.0], [-16.0, -12.0, 0.0, 0.0, 16.0], [20.0, 20.0, -20.0, -20.0, 28.0]]], [[[-12.0, -3.0, 9.0, -15.0, 15.0], [18.0, 3.0, 9.0, 
0.0, -6.0], [12.0, 9.0, 0.0, 0.0, -12.0], [-15.0, -15.0, 15.0, 15.0, -21.0]], [[28.0, 7.0, -21.0, 35.0, -35.0], [-42.0, -7.0, 
-21.0, 0.0, 14.0], [-28.0, -21.0, 0.0, 0.0, 28.0], [35.0, 35.0, -35.0, -35.0, 49.0]], [[-12.0, -3.0, 9.0, -15.0, 15.0], [18.0, 
3.0, 9.0, 0.0, -6.0], [12.0, 9.0, 0.0, 0.0, -12.0], [-15.0, -15.0, 15.0, 15.0, -21.0]], [[24.0, 6.0, -18.0, 30.0, -30.0], 
[-36.0, -6.0, -18.0, 0.0, 12.0], [-24.0, -18.0, 0.0, 0.0, 24.0], [30.0, 30.0, -30.0, -30.0, 42.0]], [[20.0, 5.0, -15.0, 25.0, 
-25.0], [-30.0, -5.0, -15.0, 0.0, 10.0], [-20.0, -15.0, 0.0, 0.0, 20.0], [25.0, 25.0, -25.0, -25.0, 
35.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank3_offset1(self):
      arg0=Data(numpy.array([[[-1.0, 4.0, 0.0], [-3.0, 6.0, -1.0], [2.0, 7.0, 6.0], [-3.0, 7.0, 0.0], [6.0, 7.0, 0.0]], [[-1.0, 
0.0, 2.0], [-4.0, -1.0, -7.0], [-2.0, 1.0, -5.0], [-1.0, -4.0, -1.0], [-4.0, 1.0, -5.0]], [[1.0, -4.0, -7.0], [-2.0, -3.0, 
-7.0], [3.0, 7.0, 3.0], [1.0, 0.0, -4.0], [-2.0, 6.0, -1.0]], [[6.0, 4.0, 0.0], [-7.0, 0.0, 0.0], [5.0, -4.0, -6.0], [1.0, 7.0, 
-5.0], [6.0, -7.0, -3.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[-6.0, 3.0, 0.0, -7.0, 0.0], [5.0, -2.0, -5.0, -5.0, -5.0], [2.0, -1.0, 5.0, -2.0, -2.0], [0.0, 
-7.0, -3.0, 5.0, 6.0]], [[2.0, -6.0, 0.0, -3.0, 6.0], [6.0, -1.0, 6.0, 6.0, 2.0], [-2.0, 7.0, 1.0, -7.0, 3.0], [-7.0, 7.0, 
-6.0, -4.0, 4.0]], [[-3.0, -2.0, -1.0, 0.0, -7.0], [-6.0, 7.0, -1.0, -3.0, 7.0], [-4.0, 1.0, -4.0, -7.0, 6.0], [5.0, 7.0, -3.0, 
-1.0, -3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[14.0, -27.0, 0.0, -5.0, 24.0], [19.0, -2.0, 29.0, 29.0, 13.0], [-10.0, 29.0, -1.0, -26.0, 14.0], 
[-28.0, 35.0, -21.0, -21.0, 10.0]], [[33.0, -43.0, 1.0, 3.0, 43.0], [27.0, -7.0, 52.0, 54.0, 20.0], [-14.0, 44.0, -5.0, -29.0, 
18.0], [-47.0, 56.0, -24.0, -38.0, 9.0]], [[-16.0, -48.0, -6.0, -35.0, 0.0], [16.0, 31.0, 26.0, 14.0, 46.0], [-34.0, 53.0, 
-7.0, -95.0, 53.0], [-19.0, 77.0, -66.0, -24.0, 22.0]], [[32.0, -51.0, 0.0, 0.0, 42.0], [27.0, -1.0, 57.0, 57.0, 29.0], [-20.0, 
52.0, -8.0, -43.0, 27.0], [-49.0, 70.0, -33.0, -43.0, 10.0]], [[-22.0, -24.0, 0.0, -63.0, 42.0], [72.0, -19.0, 12.0, 12.0, 
-16.0], [-2.0, 43.0, 37.0, -61.0, 9.0], [-49.0, 7.0, -60.0, 2.0, 64.0]]], [[[0.0, -7.0, -2.0, 7.0, -14.0], [-17.0, 16.0, 3.0, 
-1.0, 19.0], [-10.0, 3.0, -13.0, -12.0, 14.0], [10.0, 21.0, -3.0, -7.0, -12.0]], [[43.0, 8.0, 7.0, 31.0, 43.0], [16.0, -40.0, 
21.0, 35.0, -31.0], [22.0, -10.0, 7.0, 64.0, -37.0], [-28.0, -28.0, 39.0, -9.0, -7.0]], [[29.0, -2.0, 5.0, 11.0, 41.0], [26.0, 
-32.0, 21.0, 31.0, -23.0], [14.0, 4.0, 11.0, 32.0, -23.0], [-32.0, -14.0, 15.0, -9.0, 7.0]], [[1.0, 23.0, 1.0, 19.0, -17.0], 
[-23.0, -1.0, -18.0, -16.0, -10.0], [10.0, -28.0, -5.0, 37.0, -16.0], [23.0, -28.0, 30.0, 12.0, -19.0]], [[41.0, -8.0, 5.0, 
25.0, 41.0], [16.0, -28.0, 31.0, 41.0, -13.0], [10.0, 6.0, 1.0, 36.0, -19.0], [-32.0, 0.0, 21.0, -19.0, -5.0]]], [[[7.0, 41.0, 
7.0, 5.0, 25.0], [23.0, -47.0, -22.0, -8.0, -62.0], [38.0, -36.0, 29.0, 75.0, -56.0], [-7.0, -84.0, 42.0, 28.0, 11.0]], [[27.0, 
26.0, 7.0, 23.0, 31.0], [14.0, -42.0, -1.0, 13.0, -45.0], [30.0, -26.0, 15.0, 74.0, -47.0], [-14.0, -56.0, 45.0, 9.0, -3.0]], 
[[-13.0, -39.0, -3.0, -42.0, 21.0], [39.0, 8.0, 24.0, 18.0, 20.0], [-20.0, 49.0, 10.0, -76.0, 33.0], [-34.0, 49.0, -60.0, 
-16.0, 37.0]], [[6.0, 11.0, 4.0, -7.0, 28.0], [29.0, -30.0, -1.0, 7.0, -33.0], [18.0, -5.0, 21.0, 26.0, -26.0], [-20.0, -35.0, 
9.0, 9.0, 18.0]], [[27.0, -40.0, 1.0, -4.0, 43.0], [32.0, -9.0, 47.0, 49.0, 15.0], [-12.0, 43.0, 0.0, -31.0, 16.0], [-47.0, 
49.0, -27.0, -33.0, 15.0]]], [[[-28.0, -6.0, 0.0, -54.0, 24.0], [54.0, -16.0, -6.0, -6.0, -22.0], [4.0, 22.0, 34.0, -40.0, 
0.0], [-28.0, -14.0, -42.0, 14.0, 52.0]], [[42.0, -21.0, 0.0, 49.0, 0.0], [-35.0, 14.0, 35.0, 35.0, 35.0], [-14.0, 7.0, -35.0, 
14.0, 14.0], [0.0, 49.0, 21.0, -35.0, -42.0]], [[-20.0, 51.0, 6.0, -23.0, 18.0], [37.0, -48.0, -43.0, -31.0, -75.0], [42.0, 
-39.0, 45.0, 60.0, -58.0], [-2.0, -105.0, 27.0, 47.0, 32.0]], [[23.0, -29.0, 5.0, -28.0, 77.0], [77.0, -44.0, 42.0, 52.0, 
-26.0], [8.0, 43.0, 32.0, -16.0, -11.0], [-74.0, 7.0, -30.0, -18.0, 49.0]], [[-41.0, 66.0, 3.0, -21.0, -21.0], [6.0, -26.0, 
-69.0, -63.0, -65.0], [38.0, -58.0, 35.0, 58.0, -51.0], [34.0, -112.0, 33.0, 61.0, 17.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank4_offset2(self):
      arg0=Data(numpy.array([[[[-7.0, 0.0, -7.0], [6.0, 6.0, -3.0]], [[-7.0, 7.0, -1.0], [6.0, 5.0, -2.0]], [[0.0, -2.0, -6.0], 
[-6.0, -1.0, -5.0]], [[-4.0, 2.0, -5.0], [1.0, 5.0, -2.0]], [[-7.0, -1.0, -1.0], [-7.0, 2.0, 1.0]]], [[[-5.0, 7.0, 2.0], [7.0, 
5.0, 2.0]], [[5.0, 2.0, -5.0], [4.0, 6.0, -3.0]], [[3.0, 0.0, 1.0], [-6.0, -2.0, -1.0]], [[6.0, -6.0, -6.0], [4.0, 4.0, -1.0]], 
[[-2.0, -7.0, 6.0], [4.0, 7.0, -4.0]]], [[[7.0, 0.0, 7.0], [-6.0, -6.0, 4.0]], [[-7.0, -2.0, -2.0], [-1.0, -4.0, -5.0]], [[5.0, 
3.0, -3.0], [7.0, 0.0, -4.0]], [[5.0, -3.0, 5.0], [0.0, -4.0, -7.0]], [[0.0, -4.0, 6.0], [2.0, -7.0, 7.0]]], [[[2.0, 7.0, 
-2.0], [6.0, -2.0, 5.0]], [[-3.0, -5.0, 2.0], [-6.0, 2.0, -5.0]], [[-1.0, 7.0, -2.0], [3.0, 7.0, 5.0]], [[-3.0, -5.0, -4.0], 
[-2.0, -3.0, 0.0]], [[-3.0, 0.0, 7.0], [-5.0, -1.0, 6.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-3.0, 4.0, -2.0, 4.0, -7.0], [-5.0, -3.0, -6.0, -4.0, -4.0], [7.0, -5.0, 4.0, -6.0, 2.0], 
[-6.0, 3.0, -4.0, -7.0, 3.0]], [[7.0, -5.0, 5.0, 6.0, 7.0], [-2.0, 2.0, -3.0, 1.0, -6.0], [-7.0, -5.0, 7.0, 5.0, 3.0], [0.0, 
2.0, -4.0, -4.0, -4.0]], [[-2.0, 4.0, 5.0, -4.0, -6.0], [-5.0, 3.0, -6.0, -4.0, 3.0], [0.0, -3.0, -4.0, -2.0, 6.0], [-3.0, 
-5.0, -3.0, -5.0, -6.0]]], [[[1.0, -2.0, -1.0, -4.0, 4.0], [1.0, 7.0, -2.0, 3.0, 1.0], [0.0, 0.0, 6.0, 2.0, 0.0], [-2.0, 0.0, 
2.0, 0.0, -4.0]], [[0.0, -4.0, 3.0, -5.0, 2.0], [5.0, -7.0, -1.0, -3.0, 0.0], [5.0, 2.0, 4.0, -2.0, 5.0], [-6.0, -3.0, -1.0, 
0.0, 6.0]], [[-1.0, 3.0, 0.0, 7.0, 2.0], [-3.0, 0.0, -4.0, 5.0, 0.0], [2.0, 5.0, 3.0, -5.0, -1.0], [-5.0, 3.0, 3.0, 5.0, 
-4.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[[44.0, -101.0, -9.0, -75.0, 121.0], [115.0, 0.0, 78.0, 41.0, 13.0], [-25.0, 53.0, 51.0, 71.0, 
-23.0], [30.0, -13.0, 46.0, 69.0, 45.0]], [[80.0, -105.0, 53.0, -45.0, 134.0], [63.0, 39.0, 18.0, 32.0, -11.0], [-77.0, 3.0, 
75.0, 91.0, 28.0], [13.0, -23.0, 4.0, 16.0, -29.0]], [[-3.0, -13.0, -37.0, 6.0, -14.0], [38.0, -57.0, 75.0, -18.0, -12.0], 
[-1.0, 1.0, -45.0, 17.0, -42.0], [61.0, 14.0, 0.0, 13.0, 82.0]], [[39.0, -74.0, 7.0, -27.0, 82.0], [73.0, -27.0, 49.0, 16.0, 
-10.0], [-21.0, 25.0, 38.0, 46.0, -5.0], [17.0, -4.0, 14.0, 35.0, 44.0]], [[8.0, -18.0, 17.0, -5.0, 26.0], [42.0, -47.0, 59.0, 
9.0, 24.0], [-30.0, 52.0, -62.0, 16.0, -14.0], [42.0, -21.0, 22.0, 63.0, 25.0]]], [[[65.0, -75.0, 63.0, -25.0, 114.0], [27.0, 
49.0, -30.0, 35.0, -9.0], [-55.0, 4.0, 89.0, 55.0, 46.0], [-30.0, -20.0, 1.0, 7.0, -61.0]], [[16.0, -51.0, -11.0, -15.0, 31.0], 
[39.0, -40.0, -8.0, -19.0, -43.0], [45.0, -23.0, 93.0, 1.0, 19.0], [-44.0, 17.0, -20.0, -33.0, 69.0]], [[-16.0, 33.0, -1.0, 
35.0, -57.0], [-33.0, -34.0, -6.0, -33.0, -15.0], [9.0, -27.0, -39.0, -23.0, 3.0], [8.0, 7.0, -28.0, -31.0, 19.0]], [[-43.0, 
3.0, -64.0, -31.0, -26.0], [39.0, -48.0, 10.0, -11.0, -2.0], [102.0, 21.0, 43.0, -49.0, -21.0], [-45.0, 21.0, 19.0, 7.0, 
90.0]], [[-47.0, 3.0, 16.0, -153.0, -49.0], [45.0, -11.0, -2.0, -52.0, 72.0], [62.0, 21.0, -41.0, -21.0, 50.0], [-36.0, -83.0, 
7.0, -8.0, 28.0]]], [[[-45.0, 104.0, 9.0, 82.0, -119.0], [-118.0, 0.0, -82.0, -36.0, -13.0], [27.0, -48.0, -48.0, -76.0, 22.0], 
[-35.0, 16.0, -43.0, -64.0, -49.0]], [[15.0, -23.0, -17.0, -43.0, 25.0], [43.0, 32.0, 86.0, 18.0, 33.0], [-65.0, 18.0, -71.0, 
67.0, -47.0], [99.0, -18.0, 29.0, 42.0, -1.0]], [[23.0, -33.0, -17.0, -6.0, 24.0], [3.0, 31.0, -19.0, -4.0, -40.0], [6.0, 
-51.0, 83.0, 25.0, 5.0], [-15.0, 24.0, -21.0, -52.0, 9.0]], [[-39.0, 50.0, -12.0, -47.0, -108.0], [-43.0, 22.0, -19.0, -66.0, 
13.0], [22.0, -68.0, -58.0, -12.0, 18.0], [14.0, -25.0, -40.0, -83.0, 1.0]], [[-45.0, 89.0, -13.0, 28.0, -56.0], [-76.0, 73.0, 
-49.0, 34.0, 44.0], [7.0, 23.0, -47.0, -49.0, -18.0], [-15.0, 4.0, 30.0, 21.0, -98.0]]], [[[48.0, -24.0, 9.0, 79.0, 77.0], 
[-33.0, 58.0, -51.0, 56.0, -50.0], [-35.0, -18.0, 108.0, 18.0, -2.0], [-31.0, 51.0, -1.0, -7.0, -66.0]], [[-31.0, 10.0, 3.0, 
-71.0, -56.0], [34.0, -51.0, 51.0, -50.0, 42.0], [14.0, 13.0, -98.0, -2.0, 6.0], [37.0, -50.0, -3.0, 6.0, 55.0]], [[54.0, 
-66.0, 45.0, 34.0, 104.0], [24.0, -17.0, -36.0, 32.0, -41.0], [-11.0, 15.0, 114.0, 12.0, 37.0], [-61.0, 15.0, -4.0, 14.0, 
-9.0]], [[-20.0, 13.0, -46.0, -3.0, -4.0], [28.0, -6.0, 64.0, 26.0, 28.0], [-1.0, 46.0, -55.0, 3.0, -60.0], [52.0, 10.0, 43.0, 
61.0, 25.0]], [[-16.0, 48.0, 43.0, 27.0, -31.0], [-48.0, 2.0, -37.0, 2.0, 28.0], [-14.0, 22.0, -56.0, -34.0, 25.0], [-17.0, 
-23.0, 0.0, 16.0, -61.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank0_offset0(self):
      arg0=Data(numpy.array([[1.0, 6.0, 0.0, 3.0, -2.0], [6.0, 3.0, 2.0, -7.0, 5.0], [2.0, 7.0, 1.0, 2.0, -4.0], [5.0, 4.0, 
-3.0, -1.0, 7.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-4.0)+(1-msk_arg1)*(-4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-4.0, -24.0, -0.0, -12.0, 8.0], [-24.0, -12.0, -8.0, 28.0, -20.0], [-8.0, -28.0, -4.0, -8.0, 
16.0], [-20.0, -16.0, 12.0, 4.0, -28.0]])+(1.-msk_ref)*numpy.array([[-4.0, -24.0, -0.0, -12.0, 8.0], [-24.0, -12.0, -8.0, 28.0, 
-20.0], [-8.0, -28.0, -4.0, -8.0, 16.0], [-20.0, -16.0, 12.0, 4.0, -28.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank1_offset1(self):
      arg0=Data(numpy.array([[[-4.0, -6.0, 3.0], [3.0, 5.0, -4.0], [1.0, 1.0, 6.0], [-7.0, -2.0, -7.0], [-7.0, -2.0, -6.0]], 
[[-4.0, -5.0, 7.0], [-7.0, 0.0, 2.0], [2.0, -6.0, -6.0], [7.0, 5.0, 3.0], [-5.0, -4.0, 3.0]], [[4.0, 7.0, -7.0], [-4.0, -1.0, 
6.0], [-6.0, -1.0, -7.0], [7.0, -1.0, -1.0], [0.0, 5.0, -2.0]], [[-7.0, -3.0, 7.0], [-5.0, -7.0, 2.0], [-2.0, 0.0, 0.0], [-6.0, 
-3.0, 2.0], [7.0, -2.0, -4.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-4.0, -5.0, 2.0])+(1.-msk_arg1)*numpy.array([1.0, -3.0, -4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[52.0, -45.0, 3.0, 24.0, 26.0], [55.0, 32.0, 10.0, -47.0, 46.0], [-65.0, 33.0, 15.0, -25.0, 
-29.0], [57.0, 59.0, 8.0, 43.0, -26.0]])+(1.-msk_ref)*numpy.array([[2.0, 4.0, -26.0, 27.0, 23.0], [-17.0, -15.0, 44.0, -20.0, 
-5.0], [11.0, -25.0, 25.0, 14.0, -7.0], [-26.0, 8.0, -2.0, -5.0, 29.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank2_offset2(self):
      arg0=Data(numpy.array([[[[-3.0, -7.0, -3.0], [-4.0, 3.0, -4.0]], [[-7.0, -2.0, -5.0], [0.0, -2.0, 7.0]], [[2.0, -4.0, 
3.0], [-1.0, -1.0, 4.0]], [[1.0, 1.0, 7.0], [-1.0, 0.0, -2.0]], [[-2.0, 1.0, -2.0], [-5.0, 0.0, 6.0]]], [[[-3.0, -5.0, 0.0], 
[-1.0, -1.0, 1.0]], [[-7.0, -4.0, -6.0], [1.0, 7.0, -2.0]], [[1.0, -2.0, -4.0], [4.0, -2.0, 0.0]], [[0.0, 1.0, -5.0], [-1.0, 
-7.0, -7.0]], [[-5.0, 0.0, 2.0], [0.0, 0.0, 1.0]]], [[[0.0, -6.0, 2.0], [0.0, -1.0, -4.0]], [[-7.0, -1.0, 7.0], [3.0, -7.0, 
-4.0]], [[4.0, 1.0, -3.0], [7.0, -5.0, 4.0]], [[0.0, 2.0, -4.0], [7.0, 0.0, 0.0]], [[4.0, -3.0, -5.0], [1.0, -1.0, -6.0]]], 
[[[6.0, -2.0, -4.0], [-7.0, 3.0, -2.0]], [[-1.0, 3.0, 1.0], [4.0, 0.0, 7.0]], [[6.0, 1.0, -1.0], [-3.0, -1.0, -7.0]], [[-2.0, 
-6.0, -1.0], [-7.0, -4.0, -3.0]], [[-6.0, -5.0, -1.0], [-4.0, -4.0, 4.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[2.0, -5.0, 5.0], [-4.0, -1.0, 0.0]])+(1.-msk_arg1)*numpy.array([[0.0, -2.0, 0.0], [1.0, 6.0, 
5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[27.0, -27.0, 44.0, 36.0, 1.0], [24.0, -35.0, -22.0, -19.0, 0.0], [41.0, 21.0, -35.0, -58.0, 
-5.0], [27.0, -28.0, 15.0, 53.0, 28.0]])+(1.-msk_ref)*numpy.array([[8.0, 27.0, 21.0, -13.0, 23.0], [8.0, 41.0, -4.0, -80.0, 
5.0], [-14.0, -57.0, -5.0, 3.0, -29.0], [5.0, 33.0, -46.0, -34.0, 2.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank1_offset0(self):
      arg0=Data(numpy.array([[2.0, 5.0, 1.0, -7.0, -5.0], [7.0, 2.0, 2.0, -5.0, 0.0], [-6.0, 0.0, 5.0, -5.0, 0.0], [6.0, 5.0, 
-5.0, 1.0, 1.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([7.0, -2.0])+(1.-msk_arg1)*numpy.array([0.0, 4.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[14.0, -4.0], [35.0, -10.0], [7.0, -2.0], [-49.0, 14.0], [-35.0, 10.0]], [[49.0, -14.0], [14.0, 
-4.0], [14.0, -4.0], [-35.0, 10.0], [0.0, 0.0]], [[-42.0, 12.0], [0.0, 0.0], [35.0, -10.0], [-35.0, 10.0], [0.0, 0.0]], [[42.0, 
-12.0], [35.0, -10.0], [-35.0, 10.0], [7.0, -2.0], [7.0, -2.0]]])+(1.-msk_ref)*numpy.array([[[0.0, 8.0], [0.0, 20.0], [0.0, 
4.0], [0.0, -28.0], [0.0, -20.0]], [[0.0, 28.0], [0.0, 8.0], [0.0, 8.0], [0.0, -20.0], [0.0, 0.0]], [[0.0, -24.0], [0.0, 0.0], 
[0.0, 20.0], [0.0, -20.0], [0.0, 0.0]], [[0.0, 24.0], [0.0, 20.0], [0.0, -20.0], [0.0, 4.0], [0.0, 4.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank2_offset1(self):
      arg0=Data(numpy.array([[[4.0, 1.0, -3.0], [-3.0, -6.0, 3.0], [-1.0, -4.0, 1.0], [-3.0, 6.0, -7.0], [-5.0, -1.0, -4.0]], 
[[1.0, 7.0, -2.0], [7.0, 4.0, -5.0], [-3.0, -6.0, 1.0], [-6.0, 0.0, -7.0], [-3.0, -3.0, -5.0]], [[7.0, 6.0, 4.0], [5.0, 5.0, 
-6.0], [7.0, -3.0, 2.0], [4.0, -5.0, -4.0], [-1.0, 7.0, 1.0]], [[-5.0, -1.0, 0.0], [-2.0, -4.0, 6.0], [-1.0, 5.0, 0.0], [6.0, 
0.0, -6.0], [-6.0, 0.0, -4.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-6.0, 0.0], [-6.0, -4.0], [-6.0, 4.0]])+(1.-msk_arg1)*numpy.array([[4.0, -6.0], [-3.0, 4.0], 
[-3.0, -3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-12.0, -16.0], [36.0, 36.0], [24.0, 20.0], [24.0, -52.0], [60.0, -12.0]], [[-36.0, -36.0], 
[-36.0, -36.0], [48.0, 28.0], [78.0, -28.0], [66.0, -8.0]], [[-102.0, -8.0], [-24.0, -44.0], [-36.0, 20.0], [30.0, 4.0], 
[-42.0, -24.0]], [[36.0, 4.0], [0.0, 40.0], [-24.0, -20.0], [0.0, -24.0], [60.0, -16.0]]])+(1.-msk_ref)*numpy.array([[[22.0, 
-11.0], [-3.0, -15.0], [5.0, -13.0], [-9.0, 63.0], [-5.0, 38.0]], [[-11.0, 28.0], [31.0, -11.0], [3.0, -9.0], [-3.0, 57.0], 
[12.0, 21.0]], [[-2.0, -30.0], [23.0, 8.0], [31.0, -60.0], [43.0, -32.0], [-28.0, 31.0]], [[-17.0, 26.0], [-14.0, -22.0], 
[-19.0, 26.0], [42.0, -18.0], [-12.0, 48.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank3_offset2(self):
      arg0=Data(numpy.array([[[[-1.0, 7.0, -2.0], [2.0, -2.0, 6.0]], [[-3.0, 5.0, 0.0], [-7.0, 0.0, -6.0]], [[0.0, 0.0, 1.0], 
[4.0, 2.0, 3.0]], [[7.0, -5.0, 0.0], [2.0, 0.0, -5.0]], [[0.0, -4.0, 1.0], [7.0, -6.0, -3.0]]], [[[0.0, 0.0, -1.0], [-6.0, 1.0, 
-2.0]], [[0.0, 3.0, 5.0], [-3.0, -3.0, 0.0]], [[-2.0, 7.0, -2.0], [6.0, -3.0, -6.0]], [[-6.0, -3.0, 6.0], [5.0, 7.0, 2.0]], 
[[-5.0, -5.0, 0.0], [-6.0, -1.0, -7.0]]], [[[-5.0, -7.0, -5.0], [5.0, -7.0, -3.0]], [[-3.0, 2.0, 4.0], [-1.0, -1.0, 1.0]], 
[[-1.0, 6.0, -3.0], [0.0, -3.0, -4.0]], [[6.0, 3.0, 7.0], [-6.0, -1.0, 0.0]], [[7.0, 1.0, -3.0], [-1.0, -3.0, 5.0]]], [[[5.0, 
-6.0, -7.0], [6.0, -6.0, 4.0]], [[7.0, -6.0, -5.0], [-3.0, -5.0, 7.0]], [[1.0, -2.0, -2.0], [0.0, 1.0, 0.0]], [[-2.0, -7.0, 
7.0], [-3.0, 4.0, 0.0]], [[3.0, -2.0, 3.0], [-2.0, -4.0, -1.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-1.0, 0.0], [4.0, -6.0], [-6.0, -2.0]], [[-3.0, 2.0], [-1.0, -2.0], [2.0, 
-3.0]]])+(1.-msk_arg1)*numpy.array([[[-6.0, 4.0], [2.0, -3.0], [-4.0, -1.0]], [[5.0, -2.0], [1.0, 0.0], [6.0, -6.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[49.0, -48.0], [32.0, -26.0], [-14.0, -7.0], [-43.0, 49.0], [-43.0, 57.0]], [[19.0, -6.0], 
[-6.0, -28.0], [15.0, -2.0], [-60.0, -4.0], [-10.0, 41.0]], [[-7.0, 85.0], [-7.0, -23.0], [38.0, -12.0], [-17.0, -42.0], [31.0, 
-11.0]], [[9.0, 62.0], [27.0, 29.0], [2.0, 14.0], [-63.0, 14.0], [-21.0, 13.0]]])+(1.-msk_ref)*numpy.array([[[72.0, -63.0], 
[-43.0, 23.0], [36.0, -27.0], [-72.0, 69.0], [-1.0, 15.0]], [[-37.0, 25.0], [-32.0, -8.0], [25.0, -3.0], [50.0, -43.0], [-53.0, 
49.0]], [[36.0, 14.0], [6.0, -26.0], [3.0, 5.0], [-89.0, 20.0], [-6.0, 0.0]], [[34.0, 9.0], [-12.0, 15.0], [-1.0, 12.0], 
[-41.0, 12.0], [-54.0, 25.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank2_expandedData_rank2_offset0(self):
      arg0=Data(numpy.array([[2.0, -1.0, 0.0, -2.0, -1.0], [-5.0, 3.0, -4.0, -7.0, 7.0], [-1.0, 7.0, -5.0, -1.0, -4.0], [7.0, 
-3.0, 2.0, 2.0, 0.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[5.0, 4.0, 1.0, -2.0, -4.0], [7.0, 5.0, -5.0, 0.0, -4.0], [4.0, 4.0, 1.0, 5.0, -3.0], [-3.0, 
-4.0, 0.0, -5.0, -6.0]])+(1.-msk_arg1)*numpy.array([[-2.0, -1.0, 4.0, 4.0, 4.0], [-4.0, 2.0, 3.0, 3.0, 7.0], [3.0, -4.0, -1.0, 
2.0, -7.0], [-4.0, -7.0, -3.0, -7.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[10.0, 8.0, 2.0, -4.0, -8.0], [14.0, 10.0, -10.0, 0.0, -8.0], [8.0, 8.0, 2.0, 10.0, -6.0], 
[-6.0, -8.0, 0.0, -10.0, -12.0]], [[-5.0, -4.0, -1.0, 2.0, 4.0], [-7.0, -5.0, 5.0, 0.0, 4.0], [-4.0, -4.0, -1.0, -5.0, 3.0], 
[3.0, 4.0, 0.0, 5.0, 6.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0]], [[-10.0, -8.0, -2.0, 4.0, 8.0], [-14.0, -10.0, 10.0, 0.0, 8.0], [-8.0, -8.0, -2.0, -10.0, 6.0], [6.0, 8.0, 0.0, 
10.0, 12.0]], [[-5.0, -4.0, -1.0, 2.0, 4.0], [-7.0, -5.0, 5.0, 0.0, 4.0], [-4.0, -4.0, -1.0, -5.0, 3.0], [3.0, 4.0, 0.0, 5.0, 
6.0]]], [[[-25.0, -20.0, -5.0, 10.0, 20.0], [-35.0, -25.0, 25.0, 0.0, 20.0], [-20.0, -20.0, -5.0, -25.0, 15.0], [15.0, 20.0, 
0.0, 25.0, 30.0]], [[15.0, 12.0, 3.0, -6.0, -12.0], [21.0, 15.0, -15.0, 0.0, -12.0], [12.0, 12.0, 3.0, 15.0, -9.0], [-9.0, 
-12.0, 0.0, -15.0, -18.0]], [[-20.0, -16.0, -4.0, 8.0, 16.0], [-28.0, -20.0, 20.0, 0.0, 16.0], [-16.0, -16.0, -4.0, -20.0, 
12.0], [12.0, 16.0, 0.0, 20.0, 24.0]], [[-35.0, -28.0, -7.0, 14.0, 28.0], [-49.0, -35.0, 35.0, 0.0, 28.0], [-28.0, -28.0, -7.0, 
-35.0, 21.0], [21.0, 28.0, 0.0, 35.0, 42.0]], [[35.0, 28.0, 7.0, -14.0, -28.0], [49.0, 35.0, -35.0, 0.0, -28.0], [28.0, 28.0, 
7.0, 35.0, -21.0], [-21.0, -28.0, 0.0, -35.0, -42.0]]], [[[-5.0, -4.0, -1.0, 2.0, 4.0], [-7.0, -5.0, 5.0, 0.0, 4.0], [-4.0, 
-4.0, -1.0, -5.0, 3.0], [3.0, 4.0, 0.0, 5.0, 6.0]], [[35.0, 28.0, 7.0, -14.0, -28.0], [49.0, 35.0, -35.0, 0.0, -28.0], [28.0, 
28.0, 7.0, 35.0, -21.0], [-21.0, -28.0, 0.0, -35.0, -42.0]], [[-25.0, -20.0, -5.0, 10.0, 20.0], [-35.0, -25.0, 25.0, 0.0, 
20.0], [-20.0, -20.0, -5.0, -25.0, 15.0], [15.0, 20.0, 0.0, 25.0, 30.0]], [[-5.0, -4.0, -1.0, 2.0, 4.0], [-7.0, -5.0, 5.0, 0.0, 
4.0], [-4.0, -4.0, -1.0, -5.0, 3.0], [3.0, 4.0, 0.0, 5.0, 6.0]], [[-20.0, -16.0, -4.0, 8.0, 16.0], [-28.0, -20.0, 20.0, 0.0, 
16.0], [-16.0, -16.0, -4.0, -20.0, 12.0], [12.0, 16.0, 0.0, 20.0, 24.0]]], [[[35.0, 28.0, 7.0, -14.0, -28.0], [49.0, 35.0, 
-35.0, 0.0, -28.0], [28.0, 28.0, 7.0, 35.0, -21.0], [-21.0, -28.0, 0.0, -35.0, -42.0]], [[-15.0, -12.0, -3.0, 6.0, 12.0], 
[-21.0, -15.0, 15.0, 0.0, 12.0], [-12.0, -12.0, -3.0, -15.0, 9.0], [9.0, 12.0, 0.0, 15.0, 18.0]], [[10.0, 8.0, 2.0, -4.0, 
-8.0], [14.0, 10.0, -10.0, 0.0, -8.0], [8.0, 8.0, 2.0, 10.0, -6.0], [-6.0, -8.0, 0.0, -10.0, -12.0]], [[10.0, 8.0, 2.0, -4.0, 
-8.0], [14.0, 10.0, -10.0, 0.0, -8.0], [8.0, 8.0, 2.0, 10.0, -6.0], [-6.0, -8.0, 0.0, -10.0, -12.0]], [[0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[-4.0, 
-2.0, 8.0, 8.0, 8.0], [-8.0, 4.0, 6.0, 6.0, 14.0], [6.0, -8.0, -2.0, 4.0, -14.0], [-8.0, -14.0, -6.0, -14.0, 0.0]], [[2.0, 1.0, 
-4.0, -4.0, -4.0], [4.0, -2.0, -3.0, -3.0, -7.0], [-3.0, 4.0, 1.0, -2.0, 7.0], [4.0, 7.0, 3.0, 7.0, 0.0]], [[0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[4.0, 2.0, -8.0, -8.0, -8.0], 
[8.0, -4.0, -6.0, -6.0, -14.0], [-6.0, 8.0, 2.0, -4.0, 14.0], [8.0, 14.0, 6.0, 14.0, 0.0]], [[2.0, 1.0, -4.0, -4.0, -4.0], 
[4.0, -2.0, -3.0, -3.0, -7.0], [-3.0, 4.0, 1.0, -2.0, 7.0], [4.0, 7.0, 3.0, 7.0, 0.0]]], [[[10.0, 5.0, -20.0, -20.0, -20.0], 
[20.0, -10.0, -15.0, -15.0, -35.0], [-15.0, 20.0, 5.0, -10.0, 35.0], [20.0, 35.0, 15.0, 35.0, 0.0]], [[-6.0, -3.0, 12.0, 12.0, 
12.0], [-12.0, 6.0, 9.0, 9.0, 21.0], [9.0, -12.0, -3.0, 6.0, -21.0], [-12.0, -21.0, -9.0, -21.0, 0.0]], [[8.0, 4.0, -16.0, 
-16.0, -16.0], [16.0, -8.0, -12.0, -12.0, -28.0], [-12.0, 16.0, 4.0, -8.0, 28.0], [16.0, 28.0, 12.0, 28.0, 0.0]], [[14.0, 7.0, 
-28.0, -28.0, -28.0], [28.0, -14.0, -21.0, -21.0, -49.0], [-21.0, 28.0, 7.0, -14.0, 49.0], [28.0, 49.0, 21.0, 49.0, 0.0]], 
[[-14.0, -7.0, 28.0, 28.0, 28.0], [-28.0, 14.0, 21.0, 21.0, 49.0], [21.0, -28.0, -7.0, 14.0, -49.0], [-28.0, -49.0, -21.0, 
-49.0, 0.0]]], [[[2.0, 1.0, -4.0, -4.0, -4.0], [4.0, -2.0, -3.0, -3.0, -7.0], [-3.0, 4.0, 1.0, -2.0, 7.0], [4.0, 7.0, 3.0, 7.0, 
0.0]], [[-14.0, -7.0, 28.0, 28.0, 28.0], [-28.0, 14.0, 21.0, 21.0, 49.0], [21.0, -28.0, -7.0, 14.0, -49.0], [-28.0, -49.0, 
-21.0, -49.0, 0.0]], [[10.0, 5.0, -20.0, -20.0, -20.0], [20.0, -10.0, -15.0, -15.0, -35.0], [-15.0, 20.0, 5.0, -10.0, 35.0], 
[20.0, 35.0, 15.0, 35.0, 0.0]], [[2.0, 1.0, -4.0, -4.0, -4.0], [4.0, -2.0, -3.0, -3.0, -7.0], [-3.0, 4.0, 1.0, -2.0, 7.0], 
[4.0, 7.0, 3.0, 7.0, 0.0]], [[8.0, 4.0, -16.0, -16.0, -16.0], [16.0, -8.0, -12.0, -12.0, -28.0], [-12.0, 16.0, 4.0, -8.0, 
28.0], [16.0, 28.0, 12.0, 28.0, 0.0]]], [[[-14.0, -7.0, 28.0, 28.0, 28.0], [-28.0, 14.0, 21.0, 21.0, 49.0], [21.0, -28.0, -7.0, 
14.0, -49.0], [-28.0, -49.0, -21.0, -49.0, 0.0]], [[6.0, 3.0, -12.0, -12.0, -12.0], [12.0, -6.0, -9.0, -9.0, -21.0], [-9.0, 
12.0, 3.0, -6.0, 21.0], [12.0, 21.0, 9.0, 21.0, 0.0]], [[-4.0, -2.0, 8.0, 8.0, 8.0], [-8.0, 4.0, 6.0, 6.0, 14.0], [6.0, -8.0, 
-2.0, 4.0, -14.0], [-8.0, -14.0, -6.0, -14.0, 0.0]], [[-4.0, -2.0, 8.0, 8.0, 8.0], [-8.0, 4.0, 6.0, 6.0, 14.0], [6.0, -8.0, 
-2.0, 4.0, -14.0], [-8.0, -14.0, -6.0, -14.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank3_offset1(self):
      arg0=Data(numpy.array([[[5.0, -7.0, 0.0], [2.0, 0.0, -3.0], [-1.0, -5.0, 3.0], [-2.0, -4.0, -4.0], [2.0, -1.0, 5.0]], 
[[-6.0, -7.0, -4.0], [7.0, 2.0, 5.0], [5.0, 0.0, 4.0], [4.0, -2.0, -2.0], [-1.0, -5.0, -3.0]], [[0.0, 4.0, 7.0], [3.0, 1.0, 
2.0], [3.0, 3.0, 5.0], [0.0, 7.0, 5.0], [-1.0, 2.0, -7.0]], [[-5.0, 0.0, 0.0], [1.0, 5.0, 0.0], [-7.0, 5.0, -4.0], [-3.0, 5.0, 
5.0], [-6.0, -5.0, 6.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-1.0, 1.0, -5.0, -5.0, -2.0], [5.0, 7.0, -7.0, -5.0, -3.0], [3.0, 5.0, 4.0, 0.0, 2.0], 
[-2.0, 0.0, -3.0, -5.0, 6.0]], [[3.0, 4.0, 6.0, -4.0, -7.0], [-3.0, 6.0, 3.0, 5.0, 1.0], [7.0, 4.0, -4.0, -4.0, -3.0], [3.0, 
-2.0, -1.0, 6.0, -3.0]], [[5.0, -3.0, -1.0, 1.0, 0.0], [1.0, 7.0, -3.0, -4.0, 7.0], [-6.0, -6.0, 6.0, -5.0, -4.0], [-3.0, -1.0, 
-5.0, 7.0, 2.0]]])+(1.-msk_arg1)*numpy.array([[[6.0, 4.0, -4.0, -7.0, 6.0], [-7.0, 2.0, 4.0, 4.0, -1.0], [4.0, -1.0, 6.0, 6.0, 
-5.0], [1.0, -7.0, 7.0, -5.0, 3.0]], [[-2.0, 3.0, 1.0, -1.0, -2.0], [-6.0, -5.0, 6.0, 4.0, 7.0], [-1.0, -1.0, 7.0, -7.0, -4.0], 
[-6.0, 0.0, -6.0, -5.0, 0.0]], [[5.0, 5.0, 1.0, 2.0, 5.0], [7.0, -6.0, -1.0, 1.0, 0.0], [7.0, -2.0, -1.0, -2.0, -1.0], [2.0, 
-3.0, 1.0, 7.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-26.0, -23.0, -67.0, 3.0, 39.0], [46.0, -7.0, -56.0, -60.0, -22.0], [-34.0, -3.0, 48.0, 28.0, 
31.0], [-31.0, 14.0, -8.0, -67.0, 51.0]], [[-17.0, 11.0, -7.0, -13.0, -4.0], [7.0, -7.0, -5.0, 2.0, -27.0], [24.0, 28.0, -10.0, 
15.0, 16.0], [5.0, 3.0, 9.0, -31.0, 6.0]], [[1.0, -30.0, -28.0, 28.0, 37.0], [13.0, -16.0, -17.0, -32.0, 19.0], [-56.0, -43.0, 
34.0, 5.0, 1.0], [-22.0, 7.0, -7.0, -4.0, 15.0]], [[-30.0, -6.0, -10.0, 22.0, 32.0], [-2.0, -66.0, 14.0, 6.0, -26.0], [-10.0, 
-2.0, -16.0, 36.0, 24.0], [4.0, 12.0, 30.0, -42.0, -8.0]], [[20.0, -17.0, -21.0, -1.0, 3.0], [18.0, 43.0, -32.0, -35.0, 28.0], 
[-31.0, -24.0, 42.0, -21.0, -13.0], [-22.0, -3.0, -30.0, 19.0, 25.0]]], [[[-35.0, -22.0, -8.0, 54.0, 61.0], [-13.0, -112.0, 
33.0, 11.0, -17.0], [-43.0, -34.0, -20.0, 48.0, 25.0], [3.0, 18.0, 45.0, -40.0, -23.0]], [[24.0, 0.0, -28.0, -38.0, -28.0], 
[34.0, 96.0, -58.0, -45.0, 16.0], [5.0, 13.0, 50.0, -33.0, -12.0], [-23.0, -9.0, -48.0, 12.0, 46.0]], [[15.0, -7.0, -29.0, 
-21.0, -10.0], [29.0, 63.0, -47.0, -41.0, 13.0], [-9.0, 1.0, 44.0, -20.0, -6.0], [-22.0, -4.0, -35.0, 3.0, 38.0]], [[-20.0, 
2.0, -30.0, -14.0, 6.0], [24.0, 2.0, -28.0, -22.0, -28.0], [10.0, 24.0, 12.0, 18.0, 22.0], [-8.0, 6.0, 0.0, -46.0, 26.0]], 
[[-29.0, -12.0, -22.0, 22.0, 37.0], [7.0, -58.0, 1.0, -8.0, -23.0], [-20.0, -7.0, -2.0, 35.0, 25.0], [-4.0, 13.0, 23.0, -46.0, 
3.0]]], [[[47.0, -5.0, 17.0, -9.0, -28.0], [-5.0, 73.0, -9.0, -8.0, 53.0], [-14.0, -26.0, 26.0, -51.0, -40.0], [-9.0, -15.0, 
-39.0, 73.0, 2.0]], [[10.0, 1.0, -11.0, -17.0, -13.0], [14.0, 41.0, -24.0, -18.0, 6.0], [4.0, 7.0, 20.0, -14.0, -5.0], [-9.0, 
-4.0, -20.0, 5.0, 19.0]], [[31.0, 0.0, -2.0, -22.0, -27.0], [11.0, 74.0, -27.0, -20.0, 29.0], [0.0, -3.0, 30.0, -37.0, -23.0], 
[-12.0, -11.0, -37.0, 38.0, 19.0]], [[46.0, 13.0, 37.0, -23.0, -49.0], [-16.0, 77.0, 6.0, 15.0, 42.0], [19.0, -2.0, 2.0, -53.0, 
-41.0], [6.0, -19.0, -32.0, 77.0, -11.0]], [[-28.0, 28.0, 24.0, -10.0, -12.0], [-18.0, -44.0, 34.0, 43.0, -44.0], [53.0, 45.0, 
-54.0, 27.0, 20.0], [29.0, 3.0, 36.0, -32.0, -26.0]]], [[[5.0, -5.0, 25.0, 25.0, 10.0], [-25.0, -35.0, 35.0, 25.0, 15.0], 
[-15.0, -25.0, -20.0, 0.0, -10.0], [10.0, 0.0, 15.0, 25.0, -30.0]], [[14.0, 21.0, 25.0, -25.0, -37.0], [-10.0, 37.0, 8.0, 20.0, 
2.0], [38.0, 25.0, -16.0, -20.0, -13.0], [13.0, -10.0, -8.0, 25.0, -9.0]], [[2.0, 25.0, 69.0, 11.0, -21.0], [-54.0, -47.0, 
76.0, 76.0, -2.0], [38.0, 9.0, -72.0, 0.0, -13.0], [41.0, -6.0, 36.0, 37.0, -65.0]], [[43.0, 2.0, 40.0, 0.0, -29.0], [-25.0, 
44.0, 21.0, 20.0, 49.0], [-4.0, -25.0, -2.0, -45.0, -41.0], [6.0, -15.0, -21.0, 80.0, -23.0]], [[21.0, -44.0, -6.0, 56.0, 
47.0], [-9.0, -30.0, 9.0, -19.0, 55.0], [-89.0, -86.0, 32.0, -10.0, -21.0], [-21.0, 4.0, -7.0, 42.0, 
-9.0]]]])+(1.-msk_ref)*numpy.array([[[[44.0, -1.0, -27.0, -28.0, 44.0], [7.0, 45.0, -22.0, -8.0, -54.0], [27.0, 2.0, -19.0, 
79.0, 3.0], [47.0, -35.0, 77.0, 10.0, 15.0]], [[-3.0, -7.0, -11.0, -20.0, -3.0], [-35.0, 22.0, 11.0, 5.0, -2.0], [-13.0, 4.0, 
15.0, 18.0, -7.0], [-4.0, -5.0, 11.0, -31.0, 6.0]], [[19.0, -4.0, 2.0, 18.0, 19.0], [58.0, 5.0, -37.0, -21.0, -34.0], [22.0, 
0.0, -44.0, 23.0, 22.0], [35.0, -2.0, 26.0, 51.0, -3.0]], [[-24.0, -40.0, 0.0, 10.0, -24.0], [10.0, 40.0, -28.0, -28.0, -26.0], 
[-32.0, 14.0, -36.0, 24.0, 30.0], [14.0, 26.0, 6.0, 2.0, -6.0]], [[39.0, 30.0, -4.0, -3.0, 39.0], [27.0, -21.0, -3.0, 9.0, 
-9.0], [44.0, -11.0, 0.0, 9.0, -11.0], [18.0, -29.0, 25.0, 30.0, 6.0]]], [[[-42.0, -65.0, 13.0, 41.0, -42.0], [56.0, 47.0, 
-62.0, -56.0, -43.0], [-45.0, 21.0, -81.0, 21.0, 62.0], [28.0, 54.0, -4.0, 37.0, -18.0]], [[63.0, 59.0, -21.0, -41.0, 63.0], 
[-26.0, -26.0, 35.0, 41.0, 7.0], [61.0, -19.0, 51.0, 18.0, -48.0], [5.0, -64.0, 42.0, -10.0, 21.0]], [[50.0, 40.0, -16.0, 
-27.0, 50.0], [-7.0, -14.0, 16.0, 24.0, -5.0], [48.0, -13.0, 26.0, 22.0, -29.0], [13.0, -47.0, 39.0, 3.0, 15.0]], [[18.0, 0.0, 
-20.0, -30.0, 18.0], [-30.0, 30.0, 6.0, 6.0, -18.0], [4.0, 2.0, 12.0, 42.0, -10.0], [12.0, -22.0, 38.0, -24.0, 12.0]], [[-11.0, 
-34.0, -4.0, 6.0, -11.0], [16.0, 41.0, -31.0, -27.0, -34.0], [-20.0, 12.0, -38.0, 35.0, 28.0], [23.0, 16.0, 20.0, 9.0, -3.0]]], 
[[[27.0, 47.0, 11.0, 10.0, 27.0], [25.0, -62.0, 17.0, 23.0, 28.0], [45.0, -18.0, 21.0, -42.0, -23.0], [-10.0, -21.0, -17.0, 
29.0, 0.0]], [[26.0, 25.0, -9.0, -18.0, 26.0], [-13.0, -11.0, 16.0, 18.0, 4.0], [25.0, -8.0, 23.0, 7.0, -21.0], [1.0, -27.0, 
17.0, -6.0, 9.0]], [[37.0, 46.0, -4.0, -14.0, 37.0], [-4.0, -39.0, 25.0, 29.0, 18.0], [44.0, -16.0, 34.0, -13.0, -32.0], [-5.0, 
-36.0, 8.0, 5.0, 9.0]], [[11.0, 46.0, 12.0, 3.0, 11.0], [-7.0, -65.0, 37.0, 33.0, 49.0], [28.0, -17.0, 44.0, -59.0, -33.0], 
[-32.0, -15.0, -37.0, 0.0, 0.0]], [[-45.0, -33.0, -1.0, -9.0, -45.0], [-54.0, 30.0, 15.0, -3.0, 15.0], [-55.0, 13.0, 15.0, 
-6.0, 4.0], [-27.0, 28.0, -26.0, -54.0, -3.0]]], [[[-30.0, -20.0, 20.0, 35.0, -30.0], [35.0, -10.0, -20.0, -20.0, 5.0], [-20.0, 
5.0, -30.0, -30.0, 25.0], [-5.0, 35.0, -35.0, 25.0, -15.0]], [[-4.0, 19.0, 1.0, -12.0, -4.0], [-37.0, -23.0, 34.0, 24.0, 34.0], 
[-1.0, -6.0, 41.0, -29.0, -25.0], [-29.0, -7.0, -23.0, -30.0, 3.0]], [[-72.0, -33.0, 29.0, 36.0, -72.0], [-9.0, -15.0, 6.0, 
-12.0, 42.0], [-61.0, 10.0, -3.0, -69.0, 19.0], [-45.0, 61.0, -83.0, -18.0, -21.0]], [[-3.0, 28.0, 22.0, 26.0, -3.0], [26.0, 
-61.0, 13.0, 13.0, 38.0], [18.0, -12.0, 12.0, -63.0, -10.0], [-23.0, 6.0, -46.0, 25.0, -9.0]], [[4.0, -9.0, 25.0, 59.0, 4.0], 
[114.0, -23.0, -60.0, -38.0, -29.0], [23.0, -1.0, -77.0, -13.0, 44.0], [36.0, 24.0, -6.0, 97.0, -18.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank4_offset2(self):
      arg0=Data(numpy.array([[[[-5.0, -3.0, -5.0], [0.0, 0.0, 0.0]], [[6.0, 3.0, 0.0], [0.0, -7.0, -2.0]], [[4.0, -6.0, 4.0], 
[2.0, 2.0, 7.0]], [[3.0, 3.0, 4.0], [1.0, -6.0, 4.0]], [[4.0, 6.0, -1.0], [-6.0, 6.0, 7.0]]], [[[1.0, -2.0, 2.0], [5.0, 7.0, 
-5.0]], [[-3.0, -3.0, 0.0], [6.0, -5.0, -4.0]], [[5.0, 0.0, -3.0], [-3.0, -7.0, 4.0]], [[-5.0, 1.0, 0.0], [-2.0, 0.0, 0.0]], 
[[5.0, -3.0, -1.0], [1.0, -6.0, 7.0]]], [[[4.0, -3.0, 4.0], [3.0, 0.0, 7.0]], [[-3.0, 7.0, -6.0], [1.0, 1.0, -4.0]], [[2.0, 
-2.0, -3.0], [7.0, -2.0, -1.0]], [[-2.0, 7.0, 2.0], [-7.0, -4.0, -3.0]], [[-3.0, -5.0, -1.0], [-4.0, -3.0, 3.0]]], [[[7.0, 
-7.0, 3.0], [0.0, 0.0, -2.0]], [[-5.0, -7.0, -3.0], [-3.0, 6.0, 0.0]], [[-3.0, -4.0, 2.0], [6.0, -4.0, -4.0]], [[5.0, 2.0, 
-4.0], [3.0, -3.0, 0.0]], [[7.0, 2.0, 0.0], [5.0, -1.0, 0.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-3.0, 3.0, 0.0, -1.0, 0.0], [-6.0, -1.0, -2.0, -2.0, -4.0], [6.0, 2.0, 3.0, -6.0, -4.0], 
[-4.0, 1.0, -2.0, -7.0, -6.0]], [[6.0, -7.0, -3.0, 3.0, 0.0], [7.0, -4.0, 4.0, 1.0, 6.0], [4.0, 4.0, 4.0, -2.0, -1.0], [-2.0, 
4.0, -3.0, -4.0, 5.0]], [[4.0, -5.0, -6.0, 1.0, 0.0], [3.0, -6.0, -6.0, 1.0, 4.0], [-2.0, 7.0, -3.0, -5.0, -4.0], [0.0, 5.0, 
-1.0, -7.0, 0.0]]], [[[-3.0, -4.0, -2.0, 2.0, 2.0], [6.0, 1.0, -2.0, -5.0, -1.0], [6.0, 1.0, -6.0, 0.0, 5.0], [0.0, -3.0, 5.0, 
-5.0, 6.0]], [[1.0, -1.0, -1.0, -3.0, 1.0], [6.0, 0.0, 3.0, 0.0, 3.0], [2.0, -2.0, 1.0, -7.0, 6.0], [-7.0, 7.0, -6.0, 6.0, 
1.0]], [[-2.0, -6.0, -2.0, -4.0, 0.0], [-3.0, -2.0, -4.0, 4.0, -2.0], [1.0, -5.0, 6.0, 0.0, 6.0], [4.0, 5.0, 5.0, 6.0, 
3.0]]]])+(1.-msk_arg1)*numpy.array([[[[6.0, 1.0, -3.0, -3.0, -7.0], [4.0, 3.0, 4.0, 1.0, -1.0], [0.0, -5.0, 2.0, -4.0, -7.0], 
[-1.0, -2.0, 1.0, -4.0, 6.0]], [[-7.0, 6.0, -2.0, -4.0, 1.0], [1.0, 6.0, 5.0, 4.0, 1.0], [-1.0, 2.0, -5.0, -2.0, 7.0], [0.0, 
0.0, 4.0, -1.0, -5.0]], [[7.0, -1.0, 0.0, 7.0, -5.0], [-1.0, -7.0, -7.0, -2.0, 4.0], [-4.0, -5.0, -2.0, 5.0, -6.0], [0.0, -4.0, 
5.0, -1.0, -3.0]]], [[[2.0, 0.0, 2.0, 4.0, 4.0], [-6.0, 5.0, 2.0, 0.0, -5.0], [-7.0, 0.0, 7.0, 2.0, 2.0], [6.0, 0.0, -3.0, 
-1.0, -7.0]], [[-5.0, 1.0, 0.0, -3.0, 7.0], [7.0, 3.0, -6.0, 0.0, 5.0], [-2.0, 0.0, 0.0, -6.0, 0.0], [1.0, -7.0, -7.0, 7.0, 
-3.0]], [[7.0, -2.0, 4.0, -5.0, -5.0], [-4.0, -4.0, -1.0, 7.0, 7.0], [-5.0, -1.0, 1.0, 0.0, -7.0], [-7.0, -1.0, 0.0, 4.0, 
-6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-23.0, 31.0, 39.0, -9.0, 0.0], [-6.0, 47.0, 28.0, 2.0, -18.0], [-32.0, -57.0, -12.0, 61.0, 
43.0], [26.0, -42.0, 24.0, 82.0, 15.0]], [[-3.0, 16.0, 2.0, 32.0, -7.0], [-51.0, -14.0, -13.0, -17.0, -23.0], [32.0, 48.0, 
11.0, 7.0, -81.0], [11.0, -41.0, 11.0, -108.0, -34.0]], [[-50.0, -18.0, -26.0, -48.0, 6.0], [-51.0, -16.0, -82.0, 8.0, -46.0], 
[15.0, -25.0, 8.0, -46.0, 38.0], [10.0, 43.0, 39.0, 12.0, -19.0]], [[8.0, -54.0, -37.0, 14.0, -4.0], [-27.0, -46.0, -54.0, 
12.0, -5.0], [20.0, 39.0, 21.0, -2.0, -38.0], [40.0, 10.0, 42.0, -78.0, 9.0]], [[30.0, -49.0, -20.0, -45.0, -6.0], [-6.0, 
-42.0, 24.0, 55.0, 26.0], [33.0, -28.0, 123.0, -73.0, 30.0], [-42.0, 118.0, -56.0, 63.0, -3.0]]], [[[-5.0, 10.0, -13.0, 4.0, 
17.0], [73.0, 10.0, 9.0, -47.0, 18.0], [33.0, 24.0, -64.0, -61.0, 27.0], [-69.0, 12.0, -40.0, -26.0, 6.0]], [[-24.0, 17.0, 
10.0, 37.0, 7.0], [15.0, 29.0, -17.0, -43.0, -19.0], [-8.0, 18.0, -86.0, 59.0, -9.0], [37.0, -88.0, 55.0, -51.0, 22.0]], 
[[-33.0, 25.0, 23.0, -9.0, -13.0], [-111.0, 2.0, -23.0, 18.0, -58.0], [8.0, -20.0, 59.0, 34.0, -41.0], [45.0, -30.0, 40.0, 
-17.0, -43.0]], [[27.0, -14.0, 1.0, 4.0, -4.0], [25.0, -1.0, 18.0, 21.0, 28.0], [-38.0, -8.0, 1.0, 28.0, 9.0], [18.0, 5.0, 
-3.0, 41.0, 23.0]], [[-60.0, 1.0, 5.0, -23.0, -4.0], [-105.0, 0.0, -64.0, 9.0, -75.0], [21.0, -31.0, 36.0, 23.0, -2.0], [56.0, 
-22.0, 76.0, -15.0, -24.0]]], [[[-37.0, -41.0, -35.0, -31.0, 6.0], [-36.0, -27.0, -78.0, 6.0, -35.0], [29.0, -8.0, 12.0, -38.0, 
28.0], [18.0, 38.0, 47.0, -17.0, 0.0]], [[33.0, -9.0, 20.0, 33.0, 3.0], [73.0, 20.0, 87.0, -14.0, 40.0], [26.0, -1.0, 8.0, 
27.0, 16.0], [-25.0, -21.0, -30.0, 12.0, 48.0]], [[-51.0, 15.0, 14.0, 13.0, 12.0], [-2.0, 33.0, -10.0, -48.0, -43.0], [47.0, 
-9.0, -43.0, 21.0, 23.0], [6.0, -61.0, 47.0, -38.0, 15.0]], [[79.0, -15.0, -9.0, 35.0, -18.0], [10.0, -39.0, 34.0, 36.0, 59.0], 
[-41.0, 54.0, 36.0, 16.0, -84.0], [10.0, 14.0, -45.0, -35.0, -8.0]], [[-22.0, 32.0, 26.0, -24.0, -11.0], [-71.0, 19.0, -21.0, 
32.0, -33.0], [-63.0, -46.0, 13.0, 54.0, 1.0], [55.0, -22.0, 35.0, 68.0, -25.0]]], [[[-47.0, 67.0, 7.0, -17.0, 0.0], [-76.0, 
7.0, -52.0, -26.0, -54.0], [6.0, 17.0, -28.0, -43.0, -45.0], [-22.0, -16.0, -6.0, -54.0, -83.0]], [[-24.0, 55.0, 39.0, -43.0, 
0.0], [-10.0, 48.0, 24.0, 15.0, -13.0], [-58.0, -74.0, -10.0, 17.0, 60.0], [-8.0, 3.0, -17.0, 135.0, -17.0]], [[-21.0, 13.0, 
0.0, 33.0, 8.0], [20.0, 21.0, -30.0, -42.0, -14.0], [-14.0, 26.0, -95.0, 44.0, -10.0], [32.0, -75.0, 50.0, -55.0, 18.0]], 
[[-31.0, 12.0, 15.0, 12.0, 3.0], [-28.0, 14.0, 7.0, -27.0, -36.0], [58.0, -1.0, 14.0, 7.0, -9.0], [-3.0, -37.0, 21.0, -48.0, 
-5.0]], [[-25.0, -12.0, -15.0, 12.0, 9.0], [-4.0, -10.0, -19.0, -37.0, -24.0], [78.0, 29.0, -2.0, -39.0, -11.0], [-25.0, -7.0, 
11.0, -88.0, -3.0]]]])+(1.-msk_ref)*numpy.array([[[[-44.0, -18.0, 21.0, -8.0, 57.0], [-18.0, 2.0, 0.0, -7.0, -18.0], [23.0, 
44.0, 15.0, 1.0, 44.0], [5.0, 30.0, -42.0, 28.0, 0.0]], [[36.0, 21.0, -32.0, 1.0, -78.0], [-14.0, 23.0, 83.0, 4.0, -52.0], 
[21.0, -22.0, -5.0, 12.0, -7.0], [1.0, 39.0, 67.0, -84.0, 54.0]], [[137.0, -48.0, 32.0, 7.0, -67.0], [-20.0, -64.0, -57.0, 
21.0, 55.0], [-63.0, -59.0, 51.0, 8.0, -139.0], [-39.0, -45.0, -20.0, 26.0, -20.0]], [[85.0, 3.0, 3.0, 9.0, -96.0], [-53.0, 
-30.0, 33.0, 35.0, 9.0], [-34.0, -33.0, -6.0, 40.0, -50.0], [-31.0, 16.0, 74.0, -46.0, -22.0]], [[-18.0, 33.0, -8.0, -120.0, 
-34.0], [73.0, 15.0, -2.0, 79.0, 107.0], [-7.0, -10.0, -55.0, -81.0, -41.0], [-83.0, -53.0, -1.0, 55.0, -21.0]]], [[[-26.0, 
4.0, -9.0, 43.0, 75.0], [39.0, 43.0, -47.0, -46.0, -20.0], [-30.0, -14.0, 38.0, -22.0, 12.0], [71.0, -54.0, -61.0, 20.0, 
-16.0]], [[12.0, -18.0, 11.0, 80.0, 27.0], [-70.0, 4.0, 19.0, -43.0, -83.0], [-9.0, 13.0, 47.0, 60.0, 40.0], [62.0, 45.0, 2.0, 
-42.0, -6.0]], [[66.0, -7.0, -5.0, -47.0, -101.0], [-24.0, -16.0, 73.0, 39.0, -9.0], [27.0, -14.0, -1.0, 1.0, -51.0], [-58.0, 
47.0, 48.0, -47.0, 57.0]], [[-41.0, 1.0, 9.0, 3.0, 28.0], [-7.0, -19.0, -19.0, -1.0, 16.0], [13.0, 27.0, -29.0, 14.0, 38.0], 
[-7.0, 10.0, 5.0, 21.0, -21.0]], [[125.0, -32.0, 21.0, -23.0, -106.0], [-58.0, -37.0, 43.0, 44.0, 2.0], [-23.0, -33.0, 41.0, 
19.0, -97.0], [-54.0, 29.0, 27.0, -31.0, 17.0]]], [[[128.0, -32.0, 28.0, 5.0, -74.0], [-37.0, -47.0, -28.0, 33.0, 43.0], 
[-69.0, -53.0, 43.0, 16.0, -116.0], [-35.0, -31.0, 3.0, 8.0, -36.0]], [[-140.0, 54.0, -19.0, -40.0, 89.0], [18.0, 99.0, 65.0, 
9.0, -42.0], [28.0, 63.0, -26.0, -36.0, 136.0], [38.0, 27.0, -15.0, 1.0, -21.0]], [[22.0, -7.0, 8.0, 20.0, 18.0], [-43.0, 48.0, 
46.0, -7.0, -68.0], [-26.0, 2.0, 68.0, 7.0, 11.0], [45.0, 23.0, -28.0, -28.0, -6.0]], [[-62.0, 40.0, -34.0, -9.0, -30.0], 
[23.0, -13.0, 26.0, 1.0, 11.0], [57.0, 17.0, -95.0, 14.0, 58.0], [-23.0, 27.0, 85.0, -34.0, 26.0]], [[38.0, -41.0, 23.0, 0.0, 
-31.0], [-25.0, -73.0, -23.0, 0.0, 20.0], [28.0, 7.0, -4.0, 27.0, -37.0], [-45.0, 28.0, 5.0, 13.0, 29.0]]], [[[98.0, -34.0, 
-15.0, 38.0, -61.0], [26.0, -34.0, -26.0, -41.0, -16.0], [5.0, -62.0, 41.0, 1.0, -102.0], [7.0, -24.0, -6.0, -32.0, 80.0]], 
[[-38.0, -38.0, 23.0, -8.0, 73.0], [36.0, -33.0, -76.0, -27.0, 31.0], [28.0, 26.0, 10.0, -23.0, -2.0], [-7.0, -20.0, -81.0, 
75.0, 17.0]], [[28.0, -25.0, 13.0, 95.0, 23.0], [-66.0, -13.0, -6.0, -51.0, -71.0], [-18.0, 1.0, 48.0, 66.0, 21.0], [63.0, 
30.0, 1.0, -36.0, -10.0]], [[9.0, 18.0, -13.0, -30.0, -22.0], [-13.0, 61.0, 82.0, 21.0, -49.0], [-1.0, -1.0, 29.0, -20.0, 9.0], 
[10.0, 27.0, 5.0, -42.0, 20.0]], [[43.0, 18.0, -15.0, -6.0, -34.0], [-7.0, 55.0, 54.0, 15.0, -35.0], [-35.0, -31.0, 39.0, 
-16.0, -25.0], [22.0, -7.0, 7.0, -42.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_float_rank0_offset0(self):
      arg0=Data(numpy.array([[[4.0, 2.0], [-1.0, 6.0]], [[3.0, 3.0], [7.0, 2.0]], [[-2.0, -4.0], [1.0, -6.0]], [[-6.0, -5.0], 
[-6.0, 1.0]], [[6.0, 4.0], [-1.0, 5.0]], [[-3.0, 5.0], [0.0, 5.0]]]),self.functionspace)
      arg1=-5.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-20.0, -10.0], [5.0, -30.0]], [[-15.0, -15.0], [-35.0, -10.0]], [[10.0, 20.0], [-5.0, 30.0]], 
[[30.0, 25.0], [30.0, -5.0]], [[-30.0, -20.0], [5.0, -25.0]], [[15.0, -25.0], [-0.0, -25.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank0_offset0(self):
      arg0=Data(numpy.array([[[-4.0, -3.0], [3.0, 0.0]], [[3.0, -6.0], [5.0, -4.0]], [[-7.0, -3.0], [4.0, -6.0]], [[-3.0, 0.0], 
[-4.0, -6.0]], [[7.0, -2.0], [0.0, -1.0]], [[-4.0, -1.0], [0.0, 0.0]]]),self.functionspace)
      arg1=numpy.array(-4.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[16.0, 12.0], [-12.0, -0.0]], [[-12.0, 24.0], [-20.0, 16.0]], [[28.0, 12.0], [-16.0, 24.0]], 
[[12.0, -0.0], [16.0, 24.0]], [[-28.0, 8.0], [-0.0, 4.0]], [[16.0, 4.0], [-0.0, -0.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank1_offset1(self):
      arg0=Data(numpy.array([[[[2.0, 6.0, -1.0], [4.0, -1.0, 3.0]], [[-5.0, 7.0, -6.0], [-2.0, 0.0, -7.0]]], [[[6.0, -2.0, 
2.0], [3.0, 1.0, 6.0]], [[2.0, -3.0, 0.0], [2.0, 7.0, 7.0]]], [[[0.0, -3.0, -5.0], [-4.0, 3.0, 2.0]], [[-1.0, 1.0, 6.0], [-2.0, 
-1.0, 3.0]]], [[[2.0, 0.0, 5.0], [-5.0, 7.0, 3.0]], [[-1.0, -5.0, -5.0], [-2.0, 5.0, -1.0]]], [[[-5.0, -3.0, -4.0], [6.0, 3.0, 
4.0]], [[-3.0, 7.0, -4.0], [-5.0, 2.0, 5.0]]], [[[6.0, 0.0, -5.0], [-6.0, -5.0, 0.0]], [[-7.0, -3.0, 0.0], [0.0, 3.0, 
0.0]]]]),self.functionspace)
      arg1=numpy.array([-7.0, -6.0, -5.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-45.0, -37.0], [23.0, 49.0]], [[-40.0, -57.0], [4.0, -91.0]], [[43.0, 0.0], [-29.0, 5.0]], 
[[-39.0, -22.0], [62.0, -11.0]], [[73.0, -80.0], [-1.0, -2.0]], [[-17.0, 72.0], [67.0, -18.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_array_rank1_offset0(self):
      arg0=Data(numpy.array([[[0.0, -2.0], [-4.0, -2.0]], [[2.0, -4.0], [0.0, 5.0]], [[7.0, 3.0], [5.0, -4.0]], [[-3.0, 6.0], 
[2.0, 5.0]], [[-1.0, 0.0], [2.0, 2.0]], [[-6.0, 1.0], [4.0, 4.0]]]),self.functionspace)
      arg1=numpy.array([-3.0, -7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[0.0, 0.0], [6.0, 14.0]], [[12.0, 28.0], [6.0, 14.0]]], [[[-6.0, -14.0], [12.0, 28.0]], [[0.0, 
0.0], [-15.0, -35.0]]], [[[-21.0, -49.0], [-9.0, -21.0]], [[-15.0, -35.0], [12.0, 28.0]]], [[[9.0, 21.0], [-18.0, -42.0]], 
[[-6.0, -14.0], [-15.0, -35.0]]], [[[3.0, 7.0], [0.0, 0.0]], [[-6.0, -14.0], [-6.0, -14.0]]], [[[18.0, 42.0], [-3.0, -7.0]], 
[[-12.0, -28.0], [-12.0, -28.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank2_offset1(self):
      arg0=Data(numpy.array([[[[-6.0, -4.0, 3.0], [3.0, 6.0, -4.0]], [[6.0, 5.0, 6.0], [-3.0, -4.0, 5.0]]], [[[0.0, 5.0, 0.0], 
[0.0, 5.0, 0.0]], [[5.0, -5.0, 7.0], [-3.0, 4.0, 1.0]]], [[[4.0, -6.0, 0.0], [-6.0, 0.0, -7.0]], [[7.0, -1.0, -1.0], [6.0, 5.0, 
-3.0]]], [[[4.0, 6.0, 5.0], [0.0, 0.0, -5.0]], [[1.0, 3.0, -5.0], [-1.0, -6.0, 4.0]]], [[[0.0, 6.0, -1.0], [-7.0, -2.0, -5.0]], 
[[-6.0, -7.0, 5.0], [-6.0, 7.0, -6.0]]], [[[3.0, 3.0, 2.0], [0.0, 7.0, -4.0]], [[-1.0, -3.0, -1.0], [-6.0, -6.0, 
0.0]]]]),self.functionspace)
      arg1=numpy.array([[4.0, -5.0], [-4.0, 1.0], [5.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[7.0, 44.0], [-32.0, -33.0]], [[34.0, 11.0], [29.0, 41.0]]], [[[-20.0, 5.0], [-20.0, 5.0]], 
[[75.0, 12.0], [-23.0, 25.0]]], [[[40.0, -26.0], [-59.0, -12.0]], [[27.0, -42.0], [-11.0, -43.0]]], [[[17.0, 16.0], [-25.0, 
-30.0]], [[-33.0, -32.0], [40.0, 23.0]]], [[[-29.0, 0.0], [-45.0, 3.0]], [[29.0, 53.0], [-82.0, 1.0]]], [[[10.0, 0.0], [-48.0, 
-17.0]], [[3.0, -4.0], [0.0, 24.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank0_offset0(self):
      arg0=Data(numpy.array([[[1.0, -7.0], [0.0, 2.0]], [[-2.0, 3.0], [-4.0, -6.0]], [[-2.0, -4.0], [7.0, 4.0]], [[5.0, -2.0], 
[6.0, -2.0]], [[-4.0, 7.0], [3.0, -3.0]], [[-1.0, 1.0], [0.0, -5.0]]]),self.functionspace)
      arg1=Data(-6.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-6.0, 42.0], [-0.0, -12.0]], [[12.0, -18.0], [24.0, 36.0]], [[12.0, 24.0], [-42.0, -24.0]], 
[[-30.0, 12.0], [-36.0, 12.0]], [[24.0, -42.0], [-18.0, 18.0]], [[6.0, -6.0], [-0.0, 30.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank1_offset1(self):
      arg0=Data(numpy.array([[[[-1.0, -2.0, -2.0], [-2.0, 6.0, -2.0]], [[-2.0, 1.0, -2.0], [-1.0, 4.0, 1.0]]], [[[-2.0, 0.0, 
0.0], [-3.0, 4.0, 2.0]], [[0.0, 3.0, 4.0], [6.0, -7.0, 5.0]]], [[[-5.0, 0.0, 2.0], [0.0, 1.0, -7.0]], [[-5.0, -7.0, -7.0], 
[7.0, 7.0, 5.0]]], [[[0.0, -7.0, 3.0], [-1.0, 7.0, -4.0]], [[0.0, 7.0, 0.0], [4.0, 2.0, -6.0]]], [[[0.0, -3.0, -2.0], [-4.0, 
-1.0, 6.0]], [[-5.0, -1.0, -3.0], [7.0, 0.0, 4.0]]], [[[0.0, -5.0, 3.0], [-7.0, 1.0, -2.0]], [[-5.0, 3.0, 5.0], [-6.0, 1.0, 
6.0]]]]),self.functionspace)
      arg1=Data(numpy.array([-3.0, 5.0, -2.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-3.0, 40.0], [15.0, 21.0]], [[6.0, 25.0], [7.0, -63.0]], [[11.0, 19.0], [-6.0, 4.0]], [[-41.0, 
46.0], [35.0, 10.0]], [[-11.0, -5.0], [16.0, -29.0]], [[-31.0, 30.0], [20.0, 11.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_constData_rank1_offset0(self):
      arg0=Data(numpy.array([[[6.0, 4.0], [0.0, 5.0]], [[7.0, -2.0], [-6.0, 0.0]], [[4.0, -4.0], [5.0, 4.0]], [[1.0, -5.0], 
[-3.0, -5.0]], [[6.0, 3.0], [5.0, 5.0]], [[1.0, 0.0], [-5.0, -7.0]]]),self.functionspace)
      arg1=Data(numpy.array([3.0, 0.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[18.0, 0.0], [12.0, 0.0]], [[0.0, 0.0], [15.0, 0.0]]], [[[21.0, 0.0], [-6.0, 0.0]], [[-18.0, 
0.0], [0.0, 0.0]]], [[[12.0, 0.0], [-12.0, 0.0]], [[15.0, 0.0], [12.0, 0.0]]], [[[3.0, 0.0], [-15.0, 0.0]], [[-9.0, 0.0], 
[-15.0, 0.0]]], [[[18.0, 0.0], [9.0, 0.0]], [[15.0, 0.0], [15.0, 0.0]]], [[[3.0, 0.0], [0.0, 0.0]], [[-15.0, 0.0], [-21.0, 
0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank2_offset1(self):
      arg0=Data(numpy.array([[[[0.0, 3.0, 6.0], [2.0, -6.0, -4.0]], [[0.0, 2.0, 4.0], [-3.0, 7.0, 5.0]]], [[[2.0, 0.0, 0.0], 
[-2.0, 3.0, -6.0]], [[-7.0, 6.0, -3.0], [7.0, -3.0, 6.0]]], [[[0.0, 1.0, -7.0], [-2.0, 7.0, -2.0]], [[-6.0, -1.0, 2.0], [2.0, 
-7.0, 5.0]]], [[[-3.0, 7.0, 5.0], [2.0, -2.0, 3.0]], [[7.0, -3.0, -4.0], [1.0, -1.0, 6.0]]], [[[1.0, -3.0, 0.0], [6.0, 7.0, 
4.0]], [[-7.0, -3.0, 7.0], [-3.0, -7.0, -4.0]]], [[[0.0, -5.0, -4.0], [-2.0, 0.0, -1.0]], [[0.0, -7.0, 3.0], [-6.0, -5.0, 
0.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[-1.0, 3.0], [2.0, 0.0], [-7.0, -2.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-36.0, -12.0], [14.0, 14.0]], [[-24.0, -8.0], [-18.0, -19.0]]], [[[-2.0, 6.0], [50.0, 6.0]], 
[[40.0, -15.0], [-55.0, 9.0]]], [[[51.0, 14.0], [30.0, -2.0]], [[-10.0, -22.0], [-51.0, -4.0]]], [[[-18.0, -19.0], [-27.0, 
0.0]], [[15.0, 29.0], [-45.0, -9.0]]], [[[-7.0, 3.0], [-20.0, 10.0]], [[-48.0, -35.0], [17.0, -1.0]]], [[[18.0, 8.0], [9.0, 
-4.0]], [[-35.0, -6.0], [-4.0, -18.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank0_offset0(self):
      arg0=Data(numpy.array([[[4.0, 0.0], [-7.0, 7.0]], [[-1.0, -6.0], [-3.0, -1.0]], [[1.0, -2.0], [6.0, -5.0]], [[0.0, 3.0], 
[-5.0, 6.0]], [[-4.0, 1.0], [0.0, 6.0]], [[0.0, 4.0], [-4.0, 4.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-7.0)+(1-msk_arg1)*(-1.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-28.0, -0.0], [49.0, -49.0]], [[7.0, 42.0], [21.0, 7.0]], [[-7.0, 14.0], [-42.0, 35.0]], 
[[-0.0, -21.0], [35.0, -42.0]], [[28.0, -7.0], [-0.0, -42.0]], [[-0.0, -28.0], [28.0, 
-28.0]]])+(1.-msk_ref)*numpy.array([[[-4.0, -0.0], [7.0, -7.0]], [[1.0, 6.0], [3.0, 1.0]], [[-1.0, 2.0], [-6.0, 5.0]], [[-0.0, 
-3.0], [5.0, -6.0]], [[4.0, -1.0], [-0.0, -6.0]], [[-0.0, -4.0], [4.0, -4.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank1_offset1(self):
      arg0=Data(numpy.array([[[[-1.0, -2.0, -4.0], [0.0, 6.0, 7.0]], [[0.0, 4.0, -1.0], [-5.0, 0.0, -7.0]]], [[[6.0, -6.0, 
-7.0], [-3.0, -6.0, 3.0]], [[-4.0, -2.0, 1.0], [-4.0, -6.0, 5.0]]], [[[4.0, 1.0, -1.0], [1.0, -1.0, 3.0]], [[4.0, 0.0, 4.0], 
[2.0, -5.0, -6.0]]], [[[5.0, -1.0, 1.0], [3.0, 4.0, -6.0]], [[-7.0, 6.0, 0.0], [2.0, -1.0, 4.0]]], [[[2.0, 6.0, 5.0], [7.0, 
-5.0, 2.0]], [[-1.0, -5.0, 0.0], [-7.0, 3.0, 5.0]]], [[[1.0, 1.0, 6.0], [6.0, -3.0, 7.0]], [[-6.0, 2.0, 0.0], [7.0, 0.0, 
-5.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-6.0, -2.0, -3.0])+(1.-msk_arg1)*numpy.array([-3.0, -2.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[22.0, -33.0], [-5.0, 51.0]], [[-3.0, 21.0], [25.0, 21.0]], [[-23.0, -13.0], [-36.0, 16.0]], 
[[-31.0, -8.0], [30.0, -22.0]], [[-39.0, -38.0], [16.0, 21.0]], [[-26.0, -51.0], [32.0, 
-27.0]]])+(1.-msk_ref)*numpy.array([[[7.0, -12.0], [-8.0, 15.0]], [[-6.0, 21.0], [16.0, 24.0]], [[-14.0, -1.0], [-12.0, 4.0]], 
[[-13.0, -17.0], [9.0, -4.0]], [[-18.0, -11.0], [13.0, 15.0]], [[-5.0, -12.0], [14.0, -21.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank3_expandedData_rank1_offset0(self):
      arg0=Data(numpy.array([[[0.0, -2.0], [-7.0, -4.0]], [[-3.0, 3.0], [-2.0, -3.0]], [[4.0, -3.0], [-5.0, -2.0]], [[1.0, 
0.0], [0.0, -5.0]], [[3.0, 5.0], [6.0, 0.0]], [[6.0, -7.0], [2.0, 1.0]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([1.0, 2.0])+(1.-msk_arg1)*numpy.array([6.0, -1.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 0.0], [-2.0, -4.0]], [[-7.0, -14.0], [-4.0, -8.0]]], [[[-3.0, -6.0], [3.0, 6.0]], 
[[-2.0, -4.0], [-3.0, -6.0]]], [[[4.0, 8.0], [-3.0, -6.0]], [[-5.0, -10.0], [-2.0, -4.0]]], [[[1.0, 2.0], [0.0, 0.0]], [[0.0, 
0.0], [-5.0, -10.0]]], [[[3.0, 6.0], [5.0, 10.0]], [[6.0, 12.0], [0.0, 0.0]]], [[[6.0, 12.0], [-7.0, -14.0]], [[2.0, 4.0], 
[1.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, 0.0], [-12.0, 2.0]], [[-42.0, 7.0], [-24.0, 4.0]]], [[[-18.0, 3.0], [18.0, 
-3.0]], [[-12.0, 2.0], [-18.0, 3.0]]], [[[24.0, -4.0], [-18.0, 3.0]], [[-30.0, 5.0], [-12.0, 2.0]]], [[[6.0, -1.0], [0.0, 
0.0]], [[0.0, 0.0], [-30.0, 5.0]]], [[[18.0, -3.0], [30.0, -5.0]], [[36.0, -6.0], [0.0, 0.0]]], [[[36.0, -6.0], [-42.0, 7.0]], 
[[12.0, -2.0], [6.0, -1.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank2_offset1(self):
      arg0=Data(numpy.array([[[[-2.0, 0.0, 1.0], [1.0, -4.0, 1.0]], [[-4.0, -6.0, -1.0], [5.0, 1.0, 0.0]]], [[[-5.0, 6.0, 
-4.0], [-6.0, 3.0, 5.0]], [[0.0, 4.0, 6.0], [-1.0, 2.0, -6.0]]], [[[6.0, 4.0, 2.0], [7.0, 1.0, -5.0]], [[6.0, -1.0, 5.0], 
[-3.0, -7.0, 4.0]]], [[[1.0, 0.0, -7.0], [7.0, 0.0, -3.0]], [[-4.0, -7.0, -5.0], [-1.0, 4.0, -2.0]]], [[[7.0, 6.0, 5.0], [4.0, 
-2.0, -4.0]], [[5.0, 7.0, 6.0], [-5.0, 2.0, 0.0]]], [[[6.0, -7.0, -1.0], [-2.0, 0.0, -2.0]], [[6.0, 0.0, -7.0], [-5.0, -7.0, 
0.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, -1.0], [-1.0, -7.0], [6.0, -3.0]])+(1.-msk_arg1)*numpy.array([[0.0, 5.0], [-1.0, 3.0], 
[0.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[16.0, -1.0], [5.0, 24.0]], [[20.0, 49.0], [-26.0, -12.0]]], [[[-5.0, -25.0], [57.0, -30.0]], 
[[32.0, -46.0], [-33.0, 5.0]]], [[[-22.0, -40.0], [-66.0, 1.0]], [[1.0, -14.0], [46.0, 40.0]]], [[[-47.0, 20.0], [-53.0, 2.0]], 
[[-3.0, 68.0], [-11.0, -21.0]]], [[[-11.0, -64.0], [-42.0, 22.0]], [[4.0, -72.0], [23.0, -9.0]]], [[[-29.0, 46.0], [-2.0, 
8.0]], [[-72.0, 15.0], [32.0, 54.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, -10.0], [4.0, -7.0]], [[6.0, -38.0], [-1.0, 28.0]]], 
[[[-6.0, -7.0], [-3.0, -21.0]], [[-4.0, 12.0], [-2.0, 1.0]]], [[[-4.0, 42.0], [-1.0, 38.0]], [[1.0, 27.0], [7.0, -36.0]]], 
[[[0.0, 5.0], [0.0, 35.0]], [[7.0, -41.0], [-4.0, 7.0]]], [[[-6.0, 53.0], [2.0, 14.0]], [[-7.0, 46.0], [-2.0, -19.0]]], [[[7.0, 
9.0], [0.0, -10.0]], [[0.0, 30.0], [7.0, -46.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_float_rank0_offset0(self):
      arg0=Data(numpy.array([[[[-3.0, 4.0, 5.0, -5.0], [4.0, 1.0, -1.0, 2.0], [7.0, -3.0, 2.0, 3.0]], [[-7.0, 1.0, 5.0, 7.0], 
[-7.0, 0.0, -4.0, 5.0], [-6.0, 6.0, -6.0, 5.0]]], [[[-2.0, -7.0, 0.0, -1.0], [-1.0, 0.0, -6.0, -1.0], [0.0, 2.0, 6.0, -5.0]], 
[[6.0, -4.0, 0.0, 7.0], [3.0, 4.0, 2.0, -7.0], [5.0, -7.0, -6.0, -3.0]]], [[[-1.0, 3.0, -5.0, -2.0], [-7.0, -7.0, 0.0, -7.0], 
[-7.0, 7.0, 6.0, 1.0]], [[7.0, -7.0, -5.0, -6.0], [-7.0, 7.0, 7.0, 0.0], [7.0, -5.0, -4.0, 3.0]]]]),self.functionspace)
      arg1=-3.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[9.0, -12.0, -15.0, 15.0], [-12.0, -3.0, 3.0, -6.0], [-21.0, 9.0, -6.0, -9.0]], [[21.0, -3.0, 
-15.0, -21.0], [21.0, -0.0, 12.0, -15.0], [18.0, -18.0, 18.0, -15.0]]], [[[6.0, 21.0, -0.0, 3.0], [3.0, -0.0, 18.0, 3.0], 
[-0.0, -6.0, -18.0, 15.0]], [[-18.0, 12.0, -0.0, -21.0], [-9.0, -12.0, -6.0, 21.0], [-15.0, 21.0, 18.0, 9.0]]], [[[3.0, -9.0, 
15.0, 6.0], [21.0, 21.0, -0.0, 21.0], [21.0, -21.0, -18.0, -3.0]], [[-21.0, 21.0, 15.0, 18.0], [21.0, -21.0, -21.0, -0.0], 
[-21.0, 15.0, 12.0, -9.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_array_rank0_offset0(self):
      arg0=Data(numpy.array([[[[4.0, 0.0, -5.0, 6.0], [7.0, -1.0, -5.0, -5.0], [2.0, -1.0, -7.0, -3.0]], [[2.0, -3.0, 4.0, 
6.0], [6.0, 2.0, 3.0, 6.0], [5.0, -1.0, 0.0, 0.0]]], [[[2.0, 7.0, 3.0, 2.0], [0.0, -1.0, -2.0, -3.0], [-7.0, 7.0, -3.0, -6.0]], 
[[2.0, 2.0, 6.0, -6.0], [6.0, 4.0, -3.0, 0.0], [-4.0, -1.0, 2.0, 6.0]]], [[[7.0, 2.0, 3.0, -1.0], [0.0, -4.0, -7.0, -7.0], 
[2.0, 1.0, -2.0, -6.0]], [[-7.0, -6.0, 0.0, 6.0], [4.0, -6.0, -4.0, 1.0], [5.0, 1.0, 7.0, 0.0]]]]),self.functionspace)
      arg1=numpy.array(7.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[28.0, 0.0, -35.0, 42.0], [49.0, -7.0, -35.0, -35.0], [14.0, -7.0, -49.0, -21.0]], [[14.0, -21.0, 
28.0, 42.0], [42.0, 14.0, 21.0, 42.0], [35.0, -7.0, 0.0, 0.0]]], [[[14.0, 49.0, 21.0, 14.0], [0.0, -7.0, -14.0, -21.0], [-49.0, 
49.0, -21.0, -42.0]], [[14.0, 14.0, 42.0, -42.0], [42.0, 28.0, -21.0, 0.0], [-28.0, -7.0, 14.0, 42.0]]], [[[49.0, 14.0, 21.0, 
-7.0], [0.0, -28.0, -49.0, -49.0], [14.0, 7.0, -14.0, -42.0]], [[-49.0, -42.0, 0.0, 42.0], [28.0, -42.0, -28.0, 7.0], [35.0, 
7.0, 49.0, 0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_constData_rank0_offset0(self):
      arg0=Data(numpy.array([[[[7.0, 2.0, 5.0, -3.0], [-6.0, -6.0, 1.0, -2.0], [-5.0, 4.0, 7.0, -1.0]], [[-1.0, -7.0, -2.0, 
-1.0], [4.0, 6.0, 0.0, 4.0], [7.0, 6.0, -7.0, -1.0]]], [[[-7.0, 7.0, 0.0, 7.0], [6.0, 0.0, -1.0, 0.0], [0.0, -3.0, -5.0, 
-6.0]], [[3.0, 1.0, 4.0, -6.0], [1.0, 2.0, -3.0, -4.0], [-3.0, 6.0, 2.0, -6.0]]], [[[4.0, 1.0, -7.0, -2.0], [-7.0, 2.0, 4.0, 
3.0], [5.0, 6.0, 1.0, 1.0]], [[-5.0, -4.0, 5.0, 1.0], [6.0, -5.0, -6.0, 6.0], [6.0, -1.0, 7.0, -2.0]]]]),self.functionspace)
      arg1=Data(-6.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-42.0, -12.0, -30.0, 18.0], [36.0, 36.0, -6.0, 12.0], [30.0, -24.0, -42.0, 6.0]], [[6.0, 42.0, 
12.0, 6.0], [-24.0, -36.0, -0.0, -24.0], [-42.0, -36.0, 42.0, 6.0]]], [[[42.0, -42.0, -0.0, -42.0], [-36.0, -0.0, 6.0, -0.0], 
[-0.0, 18.0, 30.0, 36.0]], [[-18.0, -6.0, -24.0, 36.0], [-6.0, -12.0, 18.0, 24.0], [18.0, -36.0, -12.0, 36.0]]], [[[-24.0, 
-6.0, 42.0, 12.0], [42.0, -12.0, -24.0, -18.0], [-30.0, -36.0, -6.0, -6.0]], [[30.0, 24.0, -30.0, -6.0], [-36.0, 30.0, 36.0, 
-36.0], [-36.0, 6.0, -42.0, 12.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_constData_rank4_expandedData_rank0_offset0(self):
      arg0=Data(numpy.array([[[[-4.0, 7.0, -3.0, -5.0], [6.0, -3.0, -6.0, -2.0], [0.0, 0.0, -5.0, 4.0]], [[-1.0, 3.0, -5.0, 
0.0], [3.0, 0.0, -5.0, -2.0], [-6.0, 1.0, 0.0, 1.0]]], [[[3.0, 5.0, -1.0, -2.0], [-6.0, -6.0, -3.0, -5.0], [-3.0, -2.0, -3.0, 
-5.0]], [[0.0, -1.0, -3.0, -7.0], [-2.0, 4.0, -7.0, 3.0], [-5.0, -6.0, 6.0, -5.0]]], [[[7.0, -2.0, -4.0, -3.0], [-2.0, 3.0, 
1.0, 7.0], [-5.0, -1.0, 5.0, -6.0]], [[-5.0, 2.0, 5.0, 3.0], [0.0, 7.0, 5.0, -5.0], [-6.0, -5.0, -5.0, 
-3.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-3.0)+(1-msk_arg1)*(-7.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[12.0, -21.0, 9.0, 15.0], [-18.0, 9.0, 18.0, 6.0], [-0.0, -0.0, 15.0, -12.0]], [[3.0, -9.0, 
15.0, -0.0], [-9.0, -0.0, 15.0, 6.0], [18.0, -3.0, -0.0, -3.0]]], [[[-9.0, -15.0, 3.0, 6.0], [18.0, 18.0, 9.0, 15.0], [9.0, 
6.0, 9.0, 15.0]], [[-0.0, 3.0, 9.0, 21.0], [6.0, -12.0, 21.0, -9.0], [15.0, 18.0, -18.0, 15.0]]], [[[-21.0, 6.0, 12.0, 9.0], 
[6.0, -9.0, -3.0, -21.0], [15.0, 3.0, -15.0, 18.0]], [[15.0, -6.0, -15.0, -9.0], [-0.0, -21.0, -15.0, 15.0], [18.0, 15.0, 15.0, 
9.0]]]])+(1.-msk_ref)*numpy.array([[[[28.0, -49.0, 21.0, 35.0], [-42.0, 21.0, 42.0, 14.0], [-0.0, -0.0, 35.0, -28.0]], [[7.0, 
-21.0, 35.0, -0.0], [-21.0, -0.0, 35.0, 14.0], [42.0, -7.0, -0.0, -7.0]]], [[[-21.0, -35.0, 7.0, 14.0], [42.0, 42.0, 21.0, 
35.0], [21.0, 14.0, 21.0, 35.0]], [[-0.0, 7.0, 21.0, 49.0], [14.0, -28.0, 49.0, -21.0], [35.0, 42.0, -42.0, 35.0]]], [[[-49.0, 
14.0, 28.0, 21.0], [14.0, -21.0, -7.0, -49.0], [35.0, 7.0, -35.0, 42.0]], [[35.0, -14.0, -35.0, -21.0], [-0.0, -49.0, -35.0, 
35.0], [42.0, 35.0, 35.0, 21.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_float_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-6.0)+(1-msk_arg0)*(-3.0)
      arg1=5.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-30.0)+(1.-msk_ref)*numpy.array(-15.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_array_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-3.0)+(1-msk_arg0)*(4.0)
      arg1=numpy.array(-5.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(15.0)+(1.-msk_ref)*numpy.array(-20.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-3.0, -2.0, -6.0])+(1.-msk_arg0)*numpy.array([0.0, 2.0, 3.0])
      arg1=numpy.array([-4.0, -6.0, -1.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(30.0)+(1.-msk_ref)*numpy.array(-15.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[0.0, -7.0, 0.0], [3.0, -4.0, -6.0]])+(1.-msk_arg0)*numpy.array([[-3.0, -4.0, -7.0], [-1.0, 
-6.0, 5.0]])
      arg1=numpy.array([[0.0, -7.0, 6.0], [-5.0, 7.0, -6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(42.0)+(1.-msk_ref)*numpy.array(-81.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-3.0, -5.0, 5.0], [0.0, -3.0, -3.0], [-6.0, -3.0, -3.0], [-2.0, -6.0, 2.0]], [[7.0, -4.0, 
-7.0], [6.0, 0.0, 0.0], [-3.0, 4.0, -3.0], [-4.0, -2.0, 7.0]]])+(1.-msk_arg0)*numpy.array([[[-4.0, -2.0, 2.0], [0.0, 7.0, 
-3.0], [-7.0, 1.0, -2.0], [0.0, 4.0, 5.0]], [[-5.0, -3.0, 0.0], [-4.0, 5.0, 3.0], [-1.0, -7.0, 3.0], [6.0, 0.0, 7.0]]])
      arg1=numpy.array([[[4.0, 4.0, 0.0], [5.0, -7.0, -6.0], [3.0, -7.0, -4.0], [7.0, 3.0, 0.0]], [[-5.0, 6.0, -6.0], [-5.0, 
2.0, 5.0], [5.0, 5.0, -1.0], [1.0, -4.0, 5.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-10.0)+(1.-msk_ref)*numpy.array(-13.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank4_offset4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[4.0, -5.0], [-1.0, 0.0], [-4.0, -2.0]], [[5.0, 0.0], [3.0, 3.0], [-3.0, 0.0]]], [[[7.0, 
-6.0], [-5.0, 4.0], [-3.0, -2.0]], [[-6.0, -3.0], [5.0, -5.0], [0.0, 4.0]]], [[[1.0, -6.0], [6.0, -5.0], [-1.0, -5.0]], [[-5.0, 
-5.0], [0.0, 2.0], [-4.0, -5.0]]], [[[3.0, 0.0], [4.0, -4.0], [6.0, 4.0]], [[3.0, -2.0], [0.0, 0.0], [-1.0, 
-3.0]]]])+(1.-msk_arg0)*numpy.array([[[[2.0, -2.0], [6.0, -1.0], [5.0, -7.0]], [[3.0, 3.0], [7.0, -5.0], [-2.0, -3.0]]], 
[[[0.0, -5.0], [5.0, 1.0], [-1.0, 5.0]], [[2.0, 0.0], [-3.0, 1.0], [-1.0, 5.0]]], [[[-2.0, 1.0], [-5.0, 5.0], [1.0, -7.0]], 
[[0.0, 0.0], [2.0, -1.0], [-5.0, 2.0]]], [[[-1.0, 0.0], [0.0, 0.0], [5.0, -4.0]], [[2.0, 6.0], [1.0, -5.0], [0.0, 6.0]]]])
      arg1=numpy.array([[[[0.0, 3.0], [-2.0, -2.0], [1.0, 1.0]], [[0.0, -1.0], [-2.0, 4.0], [-2.0, -3.0]]], [[[-7.0, -2.0], 
[-2.0, -3.0], [3.0, 7.0]], [[1.0, 7.0], [5.0, -5.0], [0.0, 2.0]]], [[[1.0, -3.0], [4.0, 3.0], [2.0, -5.0]], [[7.0, -4.0], [6.0, 
4.0], [-1.0, -2.0]]], [[[3.0, 3.0], [7.0, -2.0], [-7.0, 6.0]], [[6.0, -7.0], [-5.0, -7.0], [-4.0, -4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(95.0)+(1.-msk_ref)*numpy.array(-71.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_array_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-2.0)+(1-msk_arg0)*(-4.0)
      arg1=numpy.array([-1.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([2.0, -0.0])+(1.-msk_ref)*numpy.array([4.0, -0.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([3.0, 5.0, 2.0])+(1.-msk_arg0)*numpy.array([5.0, 2.0, -2.0])
      arg1=numpy.array([[-5.0, -2.0], [6.0, -7.0], [-2.0, 5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([11.0, -31.0])+(1.-msk_ref)*numpy.array([-9.0, -34.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[3.0, 5.0, -2.0], [-4.0, 2.0, 0.0]])+(1.-msk_arg0)*numpy.array([[-7.0, -5.0, 2.0], [-2.0, 2.0, 
2.0]])
      arg1=numpy.array([[[2.0, 7.0], [1.0, -1.0], [-6.0, -4.0]], [[-1.0, 0.0], [-6.0, 6.0], [7.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([15.0, 36.0])+(1.-msk_ref)*numpy.array([-27.0, -40.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[6.0, 2.0, -3.0], [3.0, -7.0, -2.0], [6.0, -5.0, -2.0], [-1.0, -5.0, -1.0]], [[-7.0, -2.0, 
-4.0], [5.0, -5.0, -2.0], [4.0, -3.0, 2.0], [2.0, 0.0, 6.0]]])+(1.-msk_arg0)*numpy.array([[[2.0, -5.0, 7.0], [5.0, 0.0, -6.0], 
[-1.0, 2.0, -5.0], [-5.0, 1.0, 0.0]], [[-3.0, 0.0, -2.0], [-3.0, 5.0, 0.0], [5.0, -2.0, 0.0], [0.0, 5.0, 2.0]]])
      arg1=numpy.array([[[[-2.0, 7.0], [4.0, -1.0], [-7.0, 1.0]], [[-3.0, 0.0], [-2.0, -2.0], [-4.0, -1.0]], [[6.0, 6.0], 
[-6.0, -4.0], [-2.0, 6.0]], [[0.0, 7.0], [4.0, -2.0], [7.0, 1.0]]], [[[-3.0, -1.0], [-6.0, -6.0], [4.0, 6.0]], [[0.0, -1.0], 
[0.0, -1.0], [5.0, 0.0]], [[1.0, -4.0], [1.0, 2.0], [-4.0, 5.0]], [[1.0, -3.0], [7.0, 0.0], [0.0, 4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([75.0, 100.0])+(1.-msk_ref)*numpy.array([-29.0, -76.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_array_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(0.0)+(1-msk_arg0)*(-5.0)
      arg1=numpy.array([[3.0, -3.0, 2.0, 1.0, -7.0], [2.0, 0.0, -1.0, 5.0, 6.0], [-6.0, 6.0, 7.0, 0.0, -3.0], [-5.0, 7.0, -6.0, 
2.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, -0.0, 0.0, 0.0, -0.0], [0.0, 0.0, -0.0, 0.0, 0.0], [-0.0, 0.0, 0.0, 0.0, -0.0], [-0.0, 
0.0, -0.0, 0.0, 0.0]])+(1.-msk_ref)*numpy.array([[-15.0, 15.0, -10.0, -5.0, 35.0], [-10.0, -0.0, 5.0, -25.0, -30.0], [30.0, 
-30.0, -35.0, -0.0, 15.0], [25.0, -35.0, 30.0, -10.0, -0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-4.0, 0.0, 5.0])+(1.-msk_arg0)*numpy.array([3.0, 3.0, 0.0])
      arg1=numpy.array([[[7.0, 5.0, -7.0, -6.0, -1.0], [-6.0, 4.0, -5.0, 3.0, -2.0], [-5.0, 2.0, -2.0, -7.0, 3.0], [5.0, -1.0, 
5.0, -2.0, 3.0]], [[7.0, -6.0, 7.0, -4.0, -7.0], [-6.0, 6.0, 6.0, 3.0, 4.0], [-4.0, -7.0, 4.0, 3.0, -1.0], [4.0, -2.0, -4.0, 
6.0, 3.0]], [[3.0, -5.0, -7.0, 3.0, -5.0], [0.0, 5.0, 7.0, 2.0, -1.0], [-5.0, 4.0, -2.0, 0.0, -6.0], [-6.0, 4.0, 3.0, -1.0, 
4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-13.0, -45.0, -7.0, 39.0, -21.0], [24.0, 9.0, 55.0, -2.0, 3.0], [-5.0, 12.0, -2.0, 28.0, 
-42.0], [-50.0, 24.0, -5.0, 3.0, 8.0]])+(1.-msk_ref)*numpy.array([[42.0, -3.0, 0.0, -30.0, -24.0], [-36.0, 30.0, 3.0, 18.0, 
6.0], [-27.0, -15.0, 6.0, -12.0, 6.0], [27.0, -9.0, 3.0, 12.0, 18.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-3.0, 3.0, -7.0], [-3.0, 4.0, -4.0]])+(1.-msk_arg0)*numpy.array([[-4.0, -4.0, -3.0], [4.0, 
1.0, 2.0]])
      arg1=numpy.array([[[[-3.0, -6.0, -6.0, 0.0, 4.0], [-4.0, 1.0, 7.0, 2.0, 4.0], [0.0, 3.0, -3.0, -6.0, -4.0], [1.0, 0.0, 
0.0, 4.0, 0.0]], [[0.0, -5.0, -6.0, -4.0, 1.0], [0.0, 0.0, -7.0, -2.0, -6.0], [-6.0, -6.0, -2.0, -4.0, 4.0], [1.0, 3.0, -6.0, 
0.0, -2.0]], [[6.0, -5.0, -7.0, -5.0, 5.0], [-7.0, -1.0, 3.0, 2.0, 5.0], [-7.0, -2.0, -2.0, -6.0, 6.0], [5.0, 4.0, 7.0, -5.0, 
-5.0]]], [[[5.0, 0.0, -1.0, -1.0, 5.0], [6.0, -3.0, -7.0, -7.0, -4.0], [-4.0, -1.0, 1.0, -6.0, -2.0], [-1.0, -5.0, 3.0, 3.0, 
-6.0]], [[-3.0, 2.0, -6.0, 7.0, 1.0], [1.0, -7.0, 6.0, 5.0, 7.0], [-2.0, -3.0, -6.0, 6.0, -6.0], [-3.0, 6.0, -7.0, 1.0, 1.0]], 
[[1.0, 0.0, 0.0, -3.0, -2.0], [-1.0, -6.0, 2.0, -3.0, -7.0], [0.0, 5.0, -3.0, -4.0, 6.0], [0.0, 6.0, 6.0, 4.0, -6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-64.0, 46.0, 28.0, 66.0, -47.0], [51.0, 9.0, -26.0, 27.0, 3.0], [35.0, -42.0, 2.0, 106.0, 
-60.0], [-44.0, -4.0, -128.0, 2.0, 75.0]])+(1.-msk_ref)*numpy.array([[13.0, 61.0, 59.0, 28.0, -18.0], [60.0, -32.0, -27.0, 
-35.0, -30.0], [27.0, 21.0, 18.0, 32.0, -20.0], [-30.0, -26.0, 20.0, 20.0, -12.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_array_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(7.0)+(1-msk_arg0)*(6.0)
      arg1=numpy.array([[[-5.0, 5.0], [3.0, 0.0]], [[-2.0, -2.0], [6.0, 3.0]], [[0.0, 1.0], [4.0, -4.0]], [[1.0, -4.0], [7.0, 
0.0]], [[5.0, 4.0], [-2.0, -6.0]], [[6.0, 2.0], [2.0, 3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-35.0, 35.0], [21.0, 0.0]], [[-14.0, -14.0], [42.0, 21.0]], [[0.0, 7.0], [28.0, -28.0]], 
[[7.0, -28.0], [49.0, 0.0]], [[35.0, 28.0], [-14.0, -42.0]], [[42.0, 14.0], [14.0, 21.0]]])+(1.-msk_ref)*numpy.array([[[-30.0, 
30.0], [18.0, 0.0]], [[-12.0, -12.0], [36.0, 18.0]], [[0.0, 6.0], [24.0, -24.0]], [[6.0, -24.0], [42.0, 0.0]], [[30.0, 24.0], 
[-12.0, -36.0]], [[36.0, 12.0], [12.0, 18.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-3.0, 2.0, -1.0])+(1.-msk_arg0)*numpy.array([6.0, 6.0, 7.0])
      arg1=numpy.array([[[[-3.0, 2.0], [3.0, -6.0]], [[-5.0, 6.0], [2.0, 7.0]], [[-6.0, 1.0], [1.0, -5.0]], [[-3.0, -3.0], 
[7.0, -4.0]], [[-1.0, -5.0], [-3.0, 1.0]], [[-3.0, -7.0], [7.0, 0.0]]], [[[5.0, 7.0], [4.0, -2.0]], [[-4.0, 7.0], [0.0, 6.0]], 
[[1.0, 3.0], [0.0, -2.0]], [[6.0, -5.0], [-4.0, 0.0]], [[-1.0, -7.0], [0.0, 2.0]], [[6.0, -4.0], [-1.0, -5.0]]], [[[2.0, 7.0], 
[7.0, 1.0]], [[-1.0, -5.0], [4.0, 6.0]], [[5.0, -7.0], [-5.0, 7.0]], [[4.0, -2.0], [-1.0, 0.0]], [[7.0, -6.0], [2.0, -4.0]], 
[[-5.0, -7.0], [0.0, 2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[17.0, 1.0], [-8.0, 13.0]], [[8.0, 1.0], [-10.0, -15.0]], [[15.0, 10.0], [2.0, 4.0]], [[17.0, 
1.0], [-28.0, 12.0]], [[-6.0, 7.0], [7.0, 5.0]], [[26.0, 20.0], [-23.0, -12.0]]])+(1.-msk_ref)*numpy.array([[[26.0, 103.0], 
[91.0, -41.0]], [[-61.0, 43.0], [40.0, 120.0]], [[5.0, -25.0], [-29.0, 7.0]], [[46.0, -62.0], [11.0, -24.0]], [[37.0, -114.0], 
[-4.0, -10.0]], [[-17.0, -115.0], [36.0, -16.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_array_rank4_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-5.0)+(1-msk_arg0)*(0.0)
      arg1=numpy.array([[[[-2.0, -1.0, -2.0, -6.0], [4.0, -1.0, 6.0, -1.0], [-4.0, -2.0, -5.0, 4.0]], [[-1.0, -1.0, -2.0, 6.0], 
[5.0, 4.0, -6.0, -3.0], [-2.0, -1.0, 4.0, -7.0]]], [[[0.0, 3.0, -2.0, 2.0], [-6.0, 0.0, 1.0, -4.0], [-7.0, -7.0, -5.0, 2.0]], 
[[6.0, -3.0, 5.0, 6.0], [-5.0, -3.0, 0.0, -2.0], [-3.0, -5.0, 0.0, 0.0]]], [[[-6.0, 3.0, -5.0, 5.0], [7.0, 6.0, 5.0, 4.0], 
[0.0, -5.0, -1.0, 0.0]], [[-6.0, 5.0, 3.0, -7.0], [-5.0, -2.0, 0.0, 2.0], [-1.0, 6.0, -1.0, -5.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[10.0, 5.0, 10.0, 30.0], [-20.0, 5.0, -30.0, 5.0], [20.0, 10.0, 25.0, -20.0]], [[5.0, 5.0, 
10.0, -30.0], [-25.0, -20.0, 30.0, 15.0], [10.0, 5.0, -20.0, 35.0]]], [[[-0.0, -15.0, 10.0, -10.0], [30.0, -0.0, -5.0, 20.0], 
[35.0, 35.0, 25.0, -10.0]], [[-30.0, 15.0, -25.0, -30.0], [25.0, 15.0, -0.0, 10.0], [15.0, 25.0, -0.0, -0.0]]], [[[30.0, -15.0, 
25.0, -25.0], [-35.0, -30.0, -25.0, -20.0], [-0.0, 25.0, 5.0, -0.0]], [[30.0, -25.0, -15.0, 35.0], [25.0, 10.0, -0.0, -10.0], 
[5.0, -30.0, 5.0, 25.0]]]])+(1.-msk_ref)*numpy.array([[[[-0.0, -0.0, -0.0, -0.0], [0.0, -0.0, 0.0, -0.0], [-0.0, -0.0, -0.0, 
0.0]], [[-0.0, -0.0, -0.0, 0.0], [0.0, 0.0, -0.0, -0.0], [-0.0, -0.0, 0.0, -0.0]]], [[[0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, 0.0, 
-0.0], [-0.0, -0.0, -0.0, 0.0]], [[0.0, -0.0, 0.0, 0.0], [-0.0, -0.0, 0.0, -0.0], [-0.0, -0.0, 0.0, 0.0]]], [[[-0.0, 0.0, -0.0, 
0.0], [0.0, 0.0, 0.0, 0.0], [0.0, -0.0, -0.0, 0.0]], [[-0.0, 0.0, 0.0, -0.0], [-0.0, -0.0, 0.0, 0.0], [-0.0, 0.0, -0.0, 
-0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_constData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-5.0)+(1-msk_arg0)*(-5.0)
      arg1=Data(-7.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(35.0)+(1.-msk_ref)*numpy.array(35.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-1.0, 3.0, 2.0])+(1.-msk_arg0)*numpy.array([1.0, -4.0, -5.0])
      arg1=Data(numpy.array([3.0, 3.0, -3.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(0.0)+(1.-msk_ref)*numpy.array(6.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-3.0, -5.0, -3.0], [3.0, 5.0, 5.0]])+(1.-msk_arg0)*numpy.array([[-5.0, -1.0, 0.0], [0.0, 1.0, 
0.0]])
      arg1=Data(numpy.array([[-3.0, -3.0, 3.0], [0.0, 6.0, -2.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(35.0)+(1.-msk_ref)*numpy.array(24.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-1.0, 7.0, 0.0], [-6.0, 4.0, 5.0], [3.0, -3.0, 3.0], [6.0, -7.0, 7.0]], [[-3.0, 4.0, 2.0], 
[-5.0, -3.0, -2.0], [3.0, -6.0, -7.0], [4.0, 2.0, 0.0]]])+(1.-msk_arg0)*numpy.array([[[6.0, 4.0, 4.0], [-4.0, 1.0, 0.0], [6.0, 
0.0, -6.0], [5.0, -4.0, -7.0]], [[-1.0, 4.0, 3.0], [-1.0, -5.0, 4.0], [1.0, 1.0, -6.0], [-7.0, 6.0, 6.0]]])
      arg1=Data(numpy.array([[[-6.0, 0.0, 5.0], [3.0, -4.0, -6.0], [6.0, 0.0, -3.0], [5.0, 2.0, 7.0]], [[-5.0, 0.0, -3.0], 
[5.0, 0.0, 3.0], [2.0, 4.0, 7.0], [-7.0, -1.0, -3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-103.0)+(1.-msk_ref)*numpy.array(-18.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank4_offset4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[6.0, -7.0], [0.0, -7.0], [-7.0, 0.0]], [[-5.0, 5.0], [2.0, -5.0], [0.0, 1.0]]], [[[4.0, 
6.0], [-2.0, 0.0], [-5.0, 5.0]], [[5.0, -5.0], [3.0, -2.0], [-7.0, 1.0]]], [[[1.0, 7.0], [-7.0, 6.0], [0.0, 0.0]], [[4.0, 
-4.0], [-2.0, 2.0], [-3.0, -7.0]]], [[[5.0, -5.0], [-1.0, -1.0], [0.0, 4.0]], [[1.0, 5.0], [7.0, 0.0], [5.0, 
-1.0]]]])+(1.-msk_arg0)*numpy.array([[[[-4.0, 3.0], [-4.0, 2.0], [-1.0, -6.0]], [[6.0, 4.0], [5.0, 7.0], [0.0, -5.0]]], [[[7.0, 
-2.0], [-2.0, 0.0], [-6.0, -7.0]], [[-2.0, 0.0], [7.0, 4.0], [3.0, 0.0]]], [[[0.0, -5.0], [-5.0, 0.0], [5.0, 4.0]], [[-3.0, 
6.0], [0.0, 0.0], [-7.0, 5.0]]], [[[-2.0, 3.0], [0.0, 6.0], [-4.0, -4.0]], [[-5.0, 0.0], [-7.0, -3.0], [-5.0, 1.0]]]])
      arg1=Data(numpy.array([[[[-7.0, 6.0], [-4.0, 1.0], [-4.0, 0.0]], [[-4.0, 3.0], [0.0, -6.0], [-1.0, -5.0]]], [[[2.0, 
-6.0], [-7.0, -6.0], [1.0, -6.0]], [[-1.0, 2.0], [6.0, -1.0], [-1.0, 1.0]]], [[[-6.0, -5.0], [-5.0, -1.0], [-7.0, 6.0]], [[0.0, 
0.0], [-6.0, -2.0], [6.0, -2.0]]], [[[-5.0, -4.0], [7.0, 0.0], [-3.0, 3.0]], [[6.0, 7.0], [5.0, -4.0], [6.0, 
-3.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(62.0)+(1.-msk_ref)*numpy.array(51.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_constData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-6.0)+(1-msk_arg0)*(1.0)
      arg1=Data(numpy.array([0.0, -5.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-0.0, 30.0])+(1.-msk_ref)*numpy.array([0.0, -5.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-1.0, 6.0, -1.0])+(1.-msk_arg0)*numpy.array([4.0, -5.0, -2.0])
      arg1=Data(numpy.array([[0.0, -3.0], [0.0, 1.0], [6.0, -5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-6.0, 14.0])+(1.-msk_ref)*numpy.array([-12.0, -7.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-2.0, 1.0, 7.0], [-2.0, 0.0, -3.0]])+(1.-msk_arg0)*numpy.array([[1.0, 3.0, 1.0], [7.0, 6.0, 
-2.0]])
      arg1=Data(numpy.array([[[-2.0, -6.0], [-5.0, -3.0], [2.0, 1.0]], [[-6.0, -3.0], [3.0, -3.0], [-5.0, 
-7.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([40.0, 43.0])+(1.-msk_ref)*numpy.array([-29.0, -39.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[6.0, -5.0, -3.0], [5.0, 0.0, -7.0], [4.0, 5.0, 0.0], [-2.0, 6.0, 0.0]], [[-4.0, -1.0, -2.0], 
[-3.0, 2.0, -5.0], [3.0, -6.0, 1.0], [6.0, -3.0, -1.0]]])+(1.-msk_arg0)*numpy.array([[[5.0, -2.0, 0.0], [7.0, 3.0, -3.0], 
[-5.0, -4.0, 2.0], [6.0, -3.0, -5.0]], [[5.0, -5.0, -4.0], [-5.0, -4.0, 5.0], [5.0, 4.0, 1.0], [0.0, 4.0, 4.0]]])
      arg1=Data(numpy.array([[[[3.0, -3.0], [0.0, -1.0], [-2.0, 6.0]], [[-7.0, 7.0], [-6.0, -3.0], [-2.0, 5.0]], [[-6.0, -7.0], 
[-3.0, -5.0], [-7.0, 2.0]], [[6.0, -1.0], [0.0, -4.0], [1.0, 1.0]]], [[[-5.0, -4.0], [0.0, 5.0], [0.0, 0.0]], [[0.0, -6.0], 
[4.0, 4.0], [1.0, 5.0]], [[3.0, 4.0], [-1.0, 2.0], [1.0, 4.0]], [[-3.0, 2.0], [2.0, 7.0], [6.0, 0.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-39.0, -99.0])+(1.-msk_ref)*numpy.array([21.0, 126.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_constData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(0.0)+(1-msk_arg0)*(-6.0)
      arg1=Data(numpy.array([[6.0, 6.0, -5.0, -1.0, -2.0], [-4.0, 5.0, 0.0, -6.0, 6.0], [2.0, 7.0, 4.0, -5.0, 2.0], [1.0, 4.0, 
-4.0, 0.0, 5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, 0.0, -0.0, -0.0, -0.0], [-0.0, 0.0, 0.0, -0.0, 0.0], [0.0, 0.0, 0.0, -0.0, 0.0], [0.0, 
0.0, -0.0, 0.0, 0.0]])+(1.-msk_ref)*numpy.array([[-36.0, -36.0, 30.0, 6.0, 12.0], [24.0, -30.0, -0.0, 36.0, -36.0], [-12.0, 
-42.0, -24.0, 30.0, -12.0], [-6.0, -24.0, 24.0, -0.0, -30.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([7.0, 2.0, 5.0])+(1.-msk_arg0)*numpy.array([-7.0, 3.0, 5.0])
      arg1=Data(numpy.array([[[5.0, 5.0, 0.0, 3.0, 1.0], [6.0, -5.0, -7.0, -5.0, -5.0], [-1.0, -2.0, 5.0, 6.0, -6.0], [1.0, 
-7.0, 4.0, -1.0, 2.0]], [[3.0, 1.0, 7.0, -2.0, 1.0], [6.0, 3.0, 0.0, -1.0, 2.0], [0.0, -1.0, -3.0, -3.0, 5.0], [5.0, -4.0, 
-2.0, 5.0, -5.0]], [[2.0, -1.0, -6.0, 6.0, -4.0], [3.0, 0.0, -7.0, -2.0, 4.0], [-1.0, 3.0, 4.0, -3.0, -7.0], [-7.0, -3.0, -1.0, 
2.0, 5.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[51.0, 32.0, -16.0, 47.0, -11.0], [69.0, -29.0, -84.0, -47.0, -11.0], [-12.0, -1.0, 49.0, 21.0, 
-67.0], [-18.0, -72.0, 19.0, 13.0, 29.0]])+(1.-msk_ref)*numpy.array([[-16.0, -37.0, -9.0, 3.0, -24.0], [-9.0, 44.0, 14.0, 22.0, 
61.0], [2.0, 26.0, -24.0, -66.0, 22.0], [-27.0, 22.0, -39.0, 32.0, -4.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[2.0, 5.0, 7.0], [-5.0, -7.0, -1.0]])+(1.-msk_arg0)*numpy.array([[7.0, -4.0, 1.0], [-1.0, 
-4.0, -1.0]])
      arg1=Data(numpy.array([[[[-2.0, 0.0, 1.0, 3.0, -4.0], [0.0, -7.0, -5.0, -1.0, -5.0], [-6.0, -2.0, -1.0, 7.0, 1.0], [2.0, 
-5.0, 7.0, 4.0, 6.0]], [[6.0, 3.0, 4.0, -6.0, 4.0], [-4.0, 1.0, -6.0, -6.0, -1.0], [-6.0, 1.0, 0.0, 2.0, 0.0], [0.0, -3.0, 0.0, 
7.0, 3.0]], [[-4.0, -6.0, 3.0, -2.0, 4.0], [2.0, 4.0, 3.0, -3.0, -1.0], [-1.0, -2.0, 7.0, -7.0, 2.0], [0.0, -5.0, -6.0, -6.0, 
-1.0]]], [[[0.0, 0.0, 7.0, -5.0, 7.0], [3.0, -1.0, -4.0, 0.0, -5.0], [7.0, -7.0, -6.0, 2.0, 7.0], [-1.0, 7.0, -7.0, 2.0, 
-4.0]], [[7.0, -2.0, 2.0, 5.0, -7.0], [-7.0, -1.0, -1.0, 2.0, 3.0], [-6.0, 4.0, -2.0, 1.0, 2.0], [-2.0, -7.0, 7.0, 1.0, -1.0]], 
[[-7.0, 0.0, -4.0, -4.0, 1.0], [-3.0, -7.0, -6.0, -5.0, -1.0], [-7.0, 0.0, -4.0, 7.0, 7.0], [7.0, 4.0, 5.0, -4.0, 
-5.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-44.0, -13.0, -2.0, -44.0, 53.0], [31.0, 38.0, 14.0, -62.0, -17.0], [-35.0, -6.0, 95.0, -49.0, 
-40.0], [16.0, -50.0, -47.0, -12.0, 52.0]])+(1.-msk_ref)*numpy.array([[-63.0, -10.0, -17.0, 32.0, -20.0], [46.0, -37.0, 6.0, 
11.0, -38.0], [5.0, -29.0, 18.0, 21.0, -13.0], [16.0, -11.0, 17.0, -8.0, 42.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_constData_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(6.0)+(1-msk_arg0)*(3.0)
      arg1=Data(numpy.array([[[-6.0, -3.0], [2.0, -2.0]], [[1.0, 6.0], [4.0, 0.0]], [[-7.0, 7.0], [1.0, 4.0]], [[-3.0, 1.0], 
[-2.0, -3.0]], [[7.0, -6.0], [-6.0, 2.0]], [[5.0, 0.0], [-3.0, 0.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-36.0, -18.0], [12.0, -12.0]], [[6.0, 36.0], [24.0, 0.0]], [[-42.0, 42.0], [6.0, 24.0]], 
[[-18.0, 6.0], [-12.0, -18.0]], [[42.0, -36.0], [-36.0, 12.0]], [[30.0, 0.0], [-18.0, 
0.0]]])+(1.-msk_ref)*numpy.array([[[-18.0, -9.0], [6.0, -6.0]], [[3.0, 18.0], [12.0, 0.0]], [[-21.0, 21.0], [3.0, 12.0]], 
[[-9.0, 3.0], [-6.0, -9.0]], [[21.0, -18.0], [-18.0, 6.0]], [[15.0, 0.0], [-9.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([4.0, -5.0, -5.0])+(1.-msk_arg0)*numpy.array([-5.0, -7.0, 0.0])
      arg1=Data(numpy.array([[[[1.0, -1.0], [-7.0, -4.0]], [[-6.0, 6.0], [4.0, 2.0]], [[-5.0, -1.0], [6.0, -5.0]], [[0.0, 
-5.0], [-2.0, -3.0]], [[-6.0, 0.0], [5.0, 6.0]], [[-1.0, -7.0], [7.0, -2.0]]], [[[-4.0, 0.0], [2.0, -6.0]], [[5.0, -2.0], [1.0, 
7.0]], [[3.0, -7.0], [3.0, 2.0]], [[-2.0, 0.0], [3.0, -6.0]], [[7.0, 3.0], [-7.0, 5.0]], [[-7.0, -6.0], [-4.0, 3.0]]], [[[-4.0, 
7.0], [0.0, -7.0]], [[-6.0, -4.0], [-2.0, -2.0]], [[0.0, 5.0], [-4.0, 6.0]], [[6.0, 1.0], [-7.0, 3.0]], [[3.0, 3.0], [-4.0, 
-2.0]], [[-5.0, 6.0], [-5.0, -5.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[44.0, -39.0], [-38.0, 49.0]], [[-19.0, 54.0], [21.0, -17.0]], [[-35.0, 6.0], [29.0, -60.0]], 
[[-20.0, -25.0], [12.0, 3.0]], [[-74.0, -30.0], [75.0, 9.0]], [[56.0, -28.0], [73.0, 2.0]]])+(1.-msk_ref)*numpy.array([[[23.0, 
5.0], [21.0, 62.0]], [[-5.0, -16.0], [-27.0, -59.0]], [[4.0, 54.0], [-51.0, 11.0]], [[14.0, 25.0], [-11.0, 57.0]], [[-19.0, 
-21.0], [24.0, -65.0]], [[54.0, 77.0], [-7.0, -11.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_constData_rank4_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(2.0)+(1-msk_arg0)*(3.0)
      arg1=Data(numpy.array([[[[5.0, 1.0, -5.0, -7.0], [7.0, 4.0, 7.0, 2.0], [-4.0, 5.0, -3.0, 2.0]], [[5.0, 1.0, -6.0, -1.0], 
[-4.0, -6.0, -5.0, 0.0], [4.0, 2.0, 7.0, 0.0]]], [[[-6.0, 6.0, 0.0, 0.0], [5.0, 7.0, 6.0, -3.0], [-3.0, -6.0, 3.0, -1.0]], 
[[-2.0, 6.0, 7.0, -5.0], [-2.0, -7.0, 1.0, 5.0], [-5.0, 6.0, 3.0, 0.0]]], [[[1.0, 2.0, -6.0, 7.0], [2.0, 6.0, -5.0, -4.0], 
[-2.0, -7.0, 7.0, 5.0]], [[-2.0, -2.0, 3.0, 3.0], [4.0, 5.0, -4.0, -3.0], [2.0, -3.0, 5.0, -6.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[10.0, 2.0, -10.0, -14.0], [14.0, 8.0, 14.0, 4.0], [-8.0, 10.0, -6.0, 4.0]], [[10.0, 2.0, 
-12.0, -2.0], [-8.0, -12.0, -10.0, 0.0], [8.0, 4.0, 14.0, 0.0]]], [[[-12.0, 12.0, 0.0, 0.0], [10.0, 14.0, 12.0, -6.0], [-6.0, 
-12.0, 6.0, -2.0]], [[-4.0, 12.0, 14.0, -10.0], [-4.0, -14.0, 2.0, 10.0], [-10.0, 12.0, 6.0, 0.0]]], [[[2.0, 4.0, -12.0, 14.0], 
[4.0, 12.0, -10.0, -8.0], [-4.0, -14.0, 14.0, 10.0]], [[-4.0, -4.0, 6.0, 6.0], [8.0, 10.0, -8.0, -6.0], [4.0, -6.0, 10.0, 
-12.0]]]])+(1.-msk_ref)*numpy.array([[[[15.0, 3.0, -15.0, -21.0], [21.0, 12.0, 21.0, 6.0], [-12.0, 15.0, -9.0, 6.0]], [[15.0, 
3.0, -18.0, -3.0], [-12.0, -18.0, -15.0, 0.0], [12.0, 6.0, 21.0, 0.0]]], [[[-18.0, 18.0, 0.0, 0.0], [15.0, 21.0, 18.0, -9.0], 
[-9.0, -18.0, 9.0, -3.0]], [[-6.0, 18.0, 21.0, -15.0], [-6.0, -21.0, 3.0, 15.0], [-15.0, 18.0, 9.0, 0.0]]], [[[3.0, 6.0, -18.0, 
21.0], [6.0, 18.0, -15.0, -12.0], [-6.0, -21.0, 21.0, 15.0]], [[-6.0, -6.0, 9.0, 9.0], [12.0, 15.0, -12.0, -9.0], [6.0, -9.0, 
15.0, -18.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_expandedData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-3.0)+(1-msk_arg0)*(2.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(5.0)+(1-msk_arg1)*(2.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-15.0)+(1.-msk_ref)*numpy.array(4.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-5.0, 7.0, 0.0])+(1.-msk_arg0)*numpy.array([-5.0, -6.0, 6.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([5.0, 0.0, -6.0])+(1.-msk_arg1)*numpy.array([-2.0, -2.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-25.0)+(1.-msk_ref)*numpy.array(22.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-5.0, -6.0, 6.0], [0.0, 7.0, -5.0]])+(1.-msk_arg0)*numpy.array([[0.0, -7.0, 2.0], [-1.0, 5.0, 
-2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, -3.0, -1.0], [-7.0, 0.0, 0.0]])+(1.-msk_arg1)*numpy.array([[6.0, 3.0, 6.0], [1.0, 5.0, 
1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(47.0)+(1.-msk_ref)*numpy.array(13.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-5.0, 4.0, 1.0], [0.0, 0.0, 2.0], [0.0, -4.0, 2.0], [1.0, -2.0, -4.0]], [[-7.0, 6.0, 7.0], 
[-7.0, -3.0, 6.0], [1.0, 5.0, -4.0], [-4.0, 5.0, 3.0]]])+(1.-msk_arg0)*numpy.array([[[1.0, -7.0, -3.0], [4.0, 5.0, 0.0], [-2.0, 
-1.0, 7.0], [2.0, 5.0, 5.0]], [[7.0, 4.0, 2.0], [-3.0, -7.0, -4.0], [-5.0, -2.0, 4.0], [2.0, 3.0, 2.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[1.0, -2.0, -2.0], [2.0, 3.0, 1.0], [2.0, -7.0, 3.0], [-1.0, 3.0, -7.0]], [[-1.0, 0.0, -5.0], 
[5.0, -3.0, 5.0], [-6.0, -6.0, -3.0], [-4.0, -3.0, -4.0]]])+(1.-msk_arg1)*numpy.array([[[-3.0, 0.0, -3.0], [6.0, 0.0, -7.0], 
[-2.0, 1.0, 2.0], [-3.0, -7.0, 0.0]], [[-1.0, 5.0, 5.0], [3.0, -3.0, -4.0], [-2.0, 4.0, 0.0], [-5.0, -7.0, 2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-17.0)+(1.-msk_ref)*numpy.array(32.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank4_offset4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[1.0, -7.0], [-7.0, 3.0], [3.0, -2.0]], [[-7.0, 4.0], [1.0, -3.0], [6.0, -7.0]]], [[[-4.0, 
0.0], [-4.0, 5.0], [-4.0, -4.0]], [[0.0, 6.0], [5.0, 2.0], [1.0, 0.0]]], [[[0.0, 2.0], [-5.0, -7.0], [-5.0, 0.0]], [[-2.0, 
-4.0], [0.0, 1.0], [0.0, -7.0]]], [[[-6.0, 0.0], [-4.0, -3.0], [7.0, 3.0]], [[-5.0, -3.0], [-3.0, 2.0], [-3.0, 
7.0]]]])+(1.-msk_arg0)*numpy.array([[[[-6.0, 5.0], [-4.0, -1.0], [4.0, 0.0]], [[-2.0, 7.0], [-4.0, -5.0], [-5.0, 7.0]]], 
[[[-5.0, 3.0], [-7.0, -6.0], [-6.0, -4.0]], [[6.0, -3.0], [1.0, -2.0], [1.0, 2.0]]], [[[-1.0, -4.0], [6.0, -2.0], [1.0, 4.0]], 
[[0.0, 0.0], [-2.0, -6.0], [4.0, -7.0]]], [[[-3.0, -7.0], [0.0, -2.0], [-6.0, -1.0]], [[0.0, -3.0], [4.0, 1.0], [-1.0, 0.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[3.0, -5.0], [-7.0, 1.0], [-4.0, -6.0]], [[-6.0, -3.0], [-2.0, -2.0], [5.0, -7.0]]], [[[0.0, 
0.0], [0.0, 0.0], [2.0, 2.0]], [[4.0, -6.0], [-1.0, -7.0], [4.0, -7.0]]], [[[3.0, -1.0], [5.0, -3.0], [-7.0, -3.0]], [[-4.0, 
-4.0], [0.0, 2.0], [-5.0, 0.0]]], [[[2.0, 1.0], [-1.0, -6.0], [0.0, 3.0]], [[6.0, 0.0], [-4.0, -4.0], [-3.0, 
2.0]]]])+(1.-msk_arg1)*numpy.array([[[[-1.0, 0.0], [-1.0, 0.0], [-5.0, 3.0]], [[-5.0, -2.0], [1.0, 6.0], [2.0, 6.0]]], [[[-5.0, 
-5.0], [6.0, 6.0], [3.0, -4.0]], [[6.0, 6.0], [3.0, 6.0], [-7.0, -2.0]]], [[[5.0, -7.0], [-3.0, 7.0], [-2.0, 7.0]], [[-7.0, 
7.0], [7.0, 2.0], [7.0, 4.0]]], [[[-5.0, 5.0], [-4.0, -2.0], [0.0, -5.0]], [[3.0, 7.0], [5.0, -4.0], [-3.0, 2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(207.0)+(1.-msk_ref)*numpy.array(-110.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_expandedData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(6.0)+(1-msk_arg0)*(0.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-3.0, 1.0])+(1.-msk_arg1)*numpy.array([1.0, 3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-18.0, 6.0])+(1.-msk_ref)*numpy.array([0.0, 0.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([3.0, -7.0, -1.0])+(1.-msk_arg0)*numpy.array([2.0, 3.0, 6.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, 1.0], [-5.0, 2.0], [-4.0, 0.0]])+(1.-msk_arg1)*numpy.array([[5.0, 2.0], [0.0, -7.0], 
[-4.0, -6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([24.0, -11.0])+(1.-msk_ref)*numpy.array([-14.0, -53.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[5.0, 1.0, 0.0], [-2.0, 4.0, -5.0]])+(1.-msk_arg0)*numpy.array([[-5.0, -1.0, -1.0], [-3.0, 
3.0, 2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[4.0, 5.0], [-7.0, 1.0], [-4.0, 0.0]], [[1.0, -3.0], [2.0, 4.0], [2.0, 
-5.0]]])+(1.-msk_arg1)*numpy.array([[[-7.0, 7.0], [0.0, 2.0], [5.0, 7.0]], [[1.0, -7.0], [-4.0, 3.0], [-1.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([9.0, 73.0])+(1.-msk_ref)*numpy.array([13.0, -14.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-6.0, -4.0, 6.0], [1.0, -2.0, -5.0], [4.0, 4.0, 7.0], [2.0, -6.0, -5.0]], [[2.0, -1.0, 
-2.0], [2.0, 3.0, 3.0], [7.0, 2.0, -6.0], [5.0, -2.0, 3.0]]])+(1.-msk_arg0)*numpy.array([[[1.0, 3.0, 5.0], [3.0, 6.0, -5.0], 
[-4.0, -2.0, -5.0], [-1.0, 0.0, 6.0]], [[-2.0, 5.0, 5.0], [-4.0, 3.0, 5.0], [-6.0, 0.0, 7.0], [5.0, 3.0, 6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-5.0, -7.0], [6.0, -1.0], [-1.0, -5.0]], [[5.0, 1.0], [4.0, 6.0], [-5.0, 4.0]], [[-1.0, 
0.0], [2.0, -7.0], [0.0, 1.0]], [[5.0, 0.0], [0.0, -3.0], [-7.0, 1.0]]], [[[2.0, 0.0], [-5.0, 3.0], [3.0, 0.0]], [[2.0, -1.0], 
[-5.0, 6.0], [-4.0, 0.0]], [[-2.0, -3.0], [-4.0, -7.0], [0.0, -4.0]], [[0.0, 0.0], [2.0, 2.0], [-1.0, 
-6.0]]]])+(1.-msk_arg1)*numpy.array([[[[7.0, 5.0], [5.0, 0.0], [-2.0, 0.0]], [[-4.0, -4.0], [0.0, -1.0], [-6.0, 5.0]], [[6.0, 
7.0], [-7.0, 2.0], [7.0, 0.0]], [[7.0, -3.0], [-5.0, -3.0], [3.0, -3.0]]], [[[-6.0, -3.0], [5.0, -6.0], [3.0, -7.0]], [[3.0, 
-6.0], [-2.0, -2.0], [-4.0, 5.0]], [[4.0, -6.0], [1.0, -3.0], [6.0, 0.0]], [[-2.0, 6.0], [-6.0, -7.0], [-7.0, 7.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([22.0, -43.0])+(1.-msk_ref)*numpy.array([-42.0, -14.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=3)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_expandedData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(7.0)+(1-msk_arg0)*(4.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-2.0, -5.0, 0.0, 2.0, 3.0], [-7.0, -2.0, 5.0, -1.0, 5.0], [-4.0, 2.0, 6.0, 2.0, 2.0], [0.0, 
-7.0, 0.0, -2.0, -7.0]])+(1.-msk_arg1)*numpy.array([[5.0, 0.0, 0.0, -4.0, -4.0], [0.0, 6.0, -7.0, 6.0, 1.0], [0.0, 0.0, -4.0, 
-4.0, -6.0], [0.0, -7.0, 5.0, -1.0, -3.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-14.0, -35.0, 0.0, 14.0, 21.0], [-49.0, -14.0, 35.0, -7.0, 35.0], [-28.0, 14.0, 42.0, 14.0, 
14.0], [0.0, -49.0, 0.0, -14.0, -49.0]])+(1.-msk_ref)*numpy.array([[20.0, 0.0, 0.0, -16.0, -16.0], [0.0, 24.0, -28.0, 24.0, 
4.0], [0.0, 0.0, -16.0, -16.0, -24.0], [0.0, -28.0, 20.0, -4.0, -12.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-6.0, 0.0, 7.0])+(1.-msk_arg0)*numpy.array([5.0, -5.0, -5.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-5.0, 3.0, 7.0, 1.0, -7.0], [-5.0, -2.0, 2.0, -5.0, 0.0], [-1.0, 5.0, -1.0, 2.0, 2.0], [0.0, 
-4.0, 5.0, -5.0, -6.0]], [[-2.0, -6.0, 0.0, -2.0, -1.0], [0.0, 3.0, 3.0, 2.0, -5.0], [5.0, -1.0, -6.0, 1.0, -1.0], [-2.0, -5.0, 
1.0, -7.0, 4.0]], [[0.0, -7.0, 2.0, 0.0, 2.0], [-1.0, -3.0, -2.0, 0.0, 2.0], [-5.0, -4.0, 5.0, -4.0, -5.0], [7.0, -1.0, 4.0, 
-2.0, 5.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, 2.0, -5.0, -5.0, 7.0], [5.0, 0.0, 0.0, 2.0, -2.0], [3.0, -1.0, 7.0, -4.0, 2.0], 
[1.0, -1.0, 5.0, 0.0, -2.0]], [[0.0, 0.0, 5.0, -3.0, 7.0], [-4.0, -7.0, -3.0, 1.0, 5.0], [1.0, 6.0, -4.0, 0.0, -2.0], [-5.0, 
0.0, 7.0, 0.0, 0.0]], [[1.0, -7.0, -1.0, 2.0, 3.0], [-1.0, 1.0, -4.0, 5.0, 4.0], [5.0, -7.0, 0.0, -6.0, 0.0], [-2.0, -6.0, 
-4.0, -3.0, 2.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[30.0, -67.0, -28.0, -6.0, 56.0], [23.0, -9.0, -26.0, 30.0, 14.0], [-29.0, -58.0, 41.0, -40.0, 
-47.0], [49.0, 17.0, -2.0, 16.0, 71.0]])+(1.-msk_ref)*numpy.array([[10.0, 45.0, -45.0, -20.0, -15.0], [50.0, 30.0, 35.0, -20.0, 
-55.0], [-15.0, 0.0, 55.0, 10.0, 20.0], [40.0, 25.0, 10.0, 15.0, -20.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[7.0, 2.0, 5.0], [-7.0, -6.0, 0.0]])+(1.-msk_arg0)*numpy.array([[-5.0, 3.0, -1.0], [2.0, 2.0, 
4.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[0.0, 2.0, -3.0, 4.0, -1.0], [-7.0, -7.0, -5.0, 3.0, 4.0], [7.0, -6.0, -2.0, -2.0, -3.0], 
[1.0, 6.0, -7.0, -6.0, -6.0]], [[-6.0, -7.0, -7.0, 6.0, 0.0], [0.0, 2.0, 1.0, -4.0, -1.0], [3.0, -5.0, -6.0, 3.0, 7.0], [-3.0, 
-7.0, -7.0, 1.0, -7.0]], [[-4.0, 5.0, 6.0, 4.0, -7.0], [3.0, 6.0, 5.0, -6.0, 0.0], [0.0, 0.0, -1.0, 7.0, 2.0], [-6.0, 7.0, 
-6.0, 2.0, 6.0]]], [[[1.0, -1.0, -5.0, -4.0, -3.0], [0.0, 1.0, -7.0, 7.0, 7.0], [-7.0, 5.0, -1.0, -6.0, -1.0], [6.0, -6.0, 
-7.0, -1.0, 7.0]], [[-4.0, 3.0, 5.0, -3.0, 0.0], [-5.0, 2.0, 0.0, -4.0, -6.0], [-7.0, -1.0, 0.0, 0.0, 0.0], [4.0, 6.0, 4.0, 
0.0, -7.0]], [[7.0, 5.0, -3.0, -6.0, 1.0], [-5.0, -5.0, -6.0, 4.0, 0.0], [-3.0, 3.0, 4.0, 1.0, 1.0], [2.0, -1.0, 5.0, 4.0, 
-5.0]]]])+(1.-msk_arg1)*numpy.array([[[[4.0, 5.0, -7.0, -5.0, 2.0], [2.0, 3.0, -5.0, -2.0, 5.0], [4.0, -4.0, 2.0, 0.0, 7.0], 
[-2.0, 6.0, -3.0, -3.0, 4.0]], [[5.0, -2.0, -1.0, -4.0, 3.0], [0.0, -1.0, 6.0, -2.0, -6.0], [3.0, 4.0, 5.0, 0.0, 1.0], [-2.0, 
3.0, 4.0, -5.0, -1.0]], [[0.0, 5.0, -6.0, -6.0, -4.0], [2.0, 7.0, -1.0, 1.0, 5.0], [-1.0, -3.0, -3.0, -6.0, 4.0], [2.0, 5.0, 
0.0, 5.0, 0.0]]], [[[2.0, 0.0, 3.0, -3.0, -5.0], [-5.0, 0.0, 1.0, -3.0, -6.0], [6.0, 0.0, -3.0, 2.0, 0.0], [-7.0, 4.0, 0.0, 
-4.0, -1.0]], [[1.0, 7.0, -2.0, 1.0, -4.0], [0.0, -3.0, -2.0, -4.0, -5.0], [-2.0, 1.0, 4.0, 0.0, 6.0], [-6.0, -7.0, -3.0, 0.0, 
-6.0]], [[3.0, -6.0, 6.0, -1.0, -5.0], [0.0, 0.0, 7.0, 1.0, 7.0], [-2.0, 1.0, 7.0, 0.0, 0.0], [0.0, 1.0, 2.0, -6.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-15.0, 14.0, 0.0, 106.0, -21.0], [-4.0, -34.0, 41.0, -42.0, 13.0], [146.0, -81.0, -24.0, 69.0, 
10.0], [-95.0, 69.0, -68.0, -23.0, -33.0]])+(1.-msk_ref)*numpy.array([[13.0, -46.0, 64.0, 11.0, -35.0], [-22.0, -31.0, 70.0, 
-7.0, -42.0], [-10.0, 41.0, 38.0, 10.0, -24.0], [-24.0, -28.0, 29.0, -37.0, -37.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_expandedData_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-5.0)+(1-msk_arg0)*(7.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-5.0, 3.0], [3.0, 1.0]], [[7.0, -2.0], [-7.0, 4.0]], [[3.0, 6.0], [3.0, -1.0]], [[-2.0, 
7.0], [2.0, -4.0]], [[-7.0, 1.0], [-3.0, -3.0]], [[6.0, -3.0], [1.0, -6.0]]])+(1.-msk_arg1)*numpy.array([[[2.0, -4.0], [0.0, 
6.0]], [[1.0, 4.0], [-5.0, -7.0]], [[4.0, 5.0], [0.0, -7.0]], [[5.0, -2.0], [-1.0, -2.0]], [[2.0, 5.0], [-1.0, 7.0]], [[2.0, 
-7.0], [4.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[25.0, -15.0], [-15.0, -5.0]], [[-35.0, 10.0], [35.0, -20.0]], [[-15.0, -30.0], [-15.0, 5.0]], 
[[10.0, -35.0], [-10.0, 20.0]], [[35.0, -5.0], [15.0, 15.0]], [[-30.0, 15.0], [-5.0, 30.0]]])+(1.-msk_ref)*numpy.array([[[14.0, 
-28.0], [0.0, 42.0]], [[7.0, 28.0], [-35.0, -49.0]], [[28.0, 35.0], [0.0, -49.0]], [[35.0, -14.0], [-7.0, -14.0]], [[14.0, 
35.0], [-7.0, 49.0]], [[14.0, -49.0], [28.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-6.0, -1.0, -7.0])+(1.-msk_arg0)*numpy.array([-6.0, -4.0, 4.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[3.0, 6.0], [-1.0, 3.0]], [[-5.0, -2.0], [6.0, 2.0]], [[-5.0, -7.0], [-1.0, 2.0]], [[3.0, 
7.0], [4.0, 4.0]], [[-5.0, 0.0], [-5.0, -6.0]], [[3.0, 6.0], [-6.0, -7.0]]], [[[0.0, 1.0], [-2.0, 1.0]], [[-1.0, -4.0], [-5.0, 
-7.0]], [[5.0, 5.0], [0.0, -4.0]], [[4.0, 7.0], [-6.0, 3.0]], [[0.0, 6.0], [7.0, 5.0]], [[-3.0, 4.0], [-6.0, -6.0]]], [[[0.0, 
-1.0], [1.0, -6.0]], [[6.0, 2.0], [-6.0, 6.0]], [[1.0, 7.0], [-1.0, 4.0]], [[2.0, 7.0], [1.0, -2.0]], [[-5.0, -5.0], [-6.0, 
3.0]], [[0.0, -2.0], [0.0, 6.0]]]])+(1.-msk_arg1)*numpy.array([[[[-7.0, -2.0], [7.0, 3.0]], [[2.0, 0.0], [0.0, 4.0]], [[4.0, 
3.0], [0.0, -6.0]], [[-7.0, 5.0], [0.0, 0.0]], [[-4.0, 7.0], [4.0, -6.0]], [[7.0, 5.0], [7.0, -3.0]]], [[[-3.0, 7.0], [7.0, 
4.0]], [[4.0, -4.0], [-3.0, -3.0]], [[-1.0, 4.0], [-6.0, 3.0]], [[6.0, 7.0], [5.0, 3.0]], [[6.0, -6.0], [0.0, -5.0]], [[-7.0, 
-6.0], [5.0, 5.0]]], [[[0.0, 2.0], [-7.0, 5.0]], [[5.0, -4.0], [0.0, 7.0]], [[3.0, 5.0], [7.0, -4.0]], [[-5.0, -5.0], [-4.0, 
7.0]], [[-1.0, 0.0], [-1.0, -4.0]], [[-4.0, 2.0], [5.0, 4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-18.0, -30.0], [1.0, 23.0]], [[-11.0, 2.0], [11.0, -47.0]], [[18.0, -12.0], [13.0, -36.0]], 
[[-36.0, -98.0], [-25.0, -13.0]], [[65.0, 29.0], [65.0, 10.0]], [[-15.0, -26.0], [42.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[54.0, -8.0], [-98.0, -14.0]], [[-8.0, 0.0], [12.0, 16.0]], [[-8.0, -14.0], [52.0, 8.0]], 
[[-2.0, -78.0], [-36.0, 16.0]], [[-4.0, -18.0], [-28.0, 40.0]], [[-30.0, 2.0], [-42.0, 14.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank0_expandedData_rank4_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*(-6.0)+(1-msk_arg0)*(-7.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[2.0, -5.0, 3.0, 5.0], [-3.0, 3.0, 1.0, 7.0], [-3.0, -6.0, 0.0, -2.0]], [[-3.0, 3.0, 0.0, 
-5.0], [3.0, -1.0, 0.0, 3.0], [-7.0, -4.0, -5.0, -7.0]]], [[[1.0, 3.0, -4.0, 0.0], [-4.0, -7.0, -5.0, -2.0], [-3.0, -5.0, -4.0, 
5.0]], [[5.0, 0.0, 2.0, -5.0], [-4.0, 4.0, -1.0, -4.0], [-5.0, 3.0, -3.0, -5.0]]], [[[-3.0, 7.0, -6.0, -1.0], [-5.0, 7.0, -3.0, 
1.0], [-1.0, -2.0, 1.0, -1.0]], [[-6.0, -7.0, 3.0, -4.0], [3.0, 6.0, 0.0, 2.0], [6.0, -3.0, 1.0, 
5.0]]]])+(1.-msk_arg1)*numpy.array([[[[3.0, 2.0, 6.0, -7.0], [3.0, 0.0, 4.0, -5.0], [-4.0, 1.0, 4.0, 2.0]], [[-4.0, -1.0, 6.0, 
2.0], [-2.0, -5.0, -2.0, -2.0], [-3.0, -1.0, -7.0, 0.0]]], [[[4.0, -7.0, -5.0, -4.0], [-4.0, 5.0, 7.0, 3.0], [4.0, -7.0, 7.0, 
-5.0]], [[4.0, 2.0, 4.0, 0.0], [0.0, 5.0, 3.0, 0.0], [-7.0, 5.0, 2.0, 7.0]]], [[[1.0, -2.0, 4.0, 6.0], [0.0, 2.0, 0.0, 3.0], 
[6.0, -5.0, 0.0, -5.0]], [[-2.0, 4.0, -5.0, 0.0], [-4.0, 0.0, 5.0, 0.0], [1.0, -5.0, -1.0, 0.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-12.0, 30.0, -18.0, -30.0], [18.0, -18.0, -6.0, -42.0], [18.0, 36.0, -0.0, 12.0]], [[18.0, 
-18.0, -0.0, 30.0], [-18.0, 6.0, -0.0, -18.0], [42.0, 24.0, 30.0, 42.0]]], [[[-6.0, -18.0, 24.0, -0.0], [24.0, 42.0, 30.0, 
12.0], [18.0, 30.0, 24.0, -30.0]], [[-30.0, -0.0, -12.0, 30.0], [24.0, -24.0, 6.0, 24.0], [30.0, -18.0, 18.0, 30.0]]], [[[18.0, 
-42.0, 36.0, 6.0], [30.0, -42.0, 18.0, -6.0], [6.0, 12.0, -6.0, 6.0]], [[36.0, 42.0, -18.0, 24.0], [-18.0, -36.0, -0.0, -12.0], 
[-36.0, 18.0, -6.0, -30.0]]]])+(1.-msk_ref)*numpy.array([[[[-21.0, -14.0, -42.0, 49.0], [-21.0, -0.0, -28.0, 35.0], [28.0, 
-7.0, -28.0, -14.0]], [[28.0, 7.0, -42.0, -14.0], [14.0, 35.0, 14.0, 14.0], [21.0, 7.0, 49.0, -0.0]]], [[[-28.0, 49.0, 35.0, 
28.0], [28.0, -35.0, -49.0, -21.0], [-28.0, 49.0, -49.0, 35.0]], [[-28.0, -14.0, -28.0, -0.0], [-0.0, -35.0, -21.0, -0.0], 
[49.0, -35.0, -14.0, -49.0]]], [[[-7.0, 14.0, -28.0, -42.0], [-0.0, -14.0, -0.0, -21.0], [-42.0, 35.0, -0.0, 35.0]], [[14.0, 
-28.0, 35.0, -0.0], [28.0, -0.0, -35.0, -0.0], [-7.0, 35.0, 7.0, -0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_float_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([7.0, -3.0])+(1.-msk_arg0)*numpy.array([-7.0, 7.0])
      arg1=-6.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-42.0, 18.0])+(1.-msk_ref)*numpy.array([42.0, -42.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-1.0, 0.0])+(1.-msk_arg0)*numpy.array([-2.0, -3.0])
      arg1=numpy.array(-2.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([2.0, -0.0])+(1.-msk_ref)*numpy.array([4.0, 6.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[3.0, 2.0, 3.0], [-5.0, 5.0, -7.0]])+(1.-msk_arg0)*numpy.array([[6.0, -6.0, -7.0], [-2.0, 0.0, 
7.0]])
      arg1=numpy.array([6.0, -1.0, 3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([25.0, -56.0])+(1.-msk_ref)*numpy.array([21.0, 9.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[1.0, -6.0, -1.0], [-4.0, -4.0, 0.0]], [[0.0, -6.0, 3.0], [2.0, 0.0, 
-3.0]]])+(1.-msk_arg0)*numpy.array([[[3.0, 2.0, -3.0], [5.0, 2.0, -7.0]], [[1.0, -3.0, -3.0], [2.0, -7.0, -5.0]]])
      arg1=numpy.array([[6.0, -2.0, -3.0], [4.0, -4.0, 2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([21.0, 5.0])+(1.-msk_ref)*numpy.array([21.0, 47.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-6.0, 1.0, 0.0], [-5.0, 4.0, 1.0], [-1.0, 0.0, -7.0], [-3.0, 6.0, -3.0]], [[-6.0, -2.0, 
2.0], [-5.0, -5.0, 5.0], [-7.0, 5.0, -4.0], [6.0, 0.0, 6.0]]], [[[7.0, -6.0, 7.0], [0.0, -2.0, 6.0], [3.0, 5.0, 7.0], [-4.0, 
3.0, 2.0]], [[7.0, 7.0, -1.0], [0.0, 0.0, -5.0], [1.0, 3.0, -4.0], [-1.0, 1.0, 7.0]]]])+(1.-msk_arg0)*numpy.array([[[[-3.0, 
0.0, 2.0], [0.0, 0.0, 3.0], [-7.0, -2.0, 4.0], [-5.0, 4.0, 0.0]], [[0.0, 1.0, 6.0], [1.0, 1.0, 0.0], [3.0, 0.0, -2.0], [2.0, 
2.0, 5.0]]], [[[2.0, 0.0, -1.0], [1.0, 1.0, -6.0], [0.0, 4.0, -5.0], [2.0, -3.0, 3.0]], [[6.0, -6.0, 4.0], [-6.0, 0.0, -7.0], 
[0.0, 0.0, 3.0], [4.0, -2.0, -6.0]]]])
      arg1=numpy.array([[[1.0, -5.0, 7.0], [-7.0, -4.0, -1.0], [-2.0, 1.0, 7.0], [-7.0, 0.0, -5.0]], [[6.0, 0.0, 0.0], [-4.0, 
-6.0, 0.0], [-2.0, -6.0, -7.0], [6.0, -2.0, 7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([100.0, 245.0])+(1.-msk_ref)*numpy.array([124.0, -45.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-2.0, -1.0])+(1.-msk_arg0)*numpy.array([-7.0, -6.0])
      arg1=numpy.array([-4.0, 7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[8.0, -14.0], [4.0, -7.0]])+(1.-msk_ref)*numpy.array([[28.0, -49.0], [24.0, -42.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-3.0, 4.0, 0.0], [-2.0, 0.0, 0.0]])+(1.-msk_arg0)*numpy.array([[-5.0, 6.0, 6.0], [-1.0, 6.0, 
-7.0]])
      arg1=numpy.array([[0.0, 7.0], [1.0, -3.0], [7.0, 2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[4.0, -33.0], [0.0, -14.0]])+(1.-msk_ref)*numpy.array([[48.0, -41.0], [-43.0, -39.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[5.0, 3.0, 1.0], [-6.0, 0.0, -6.0]], [[-3.0, 0.0, 5.0], [-5.0, 3.0, 
-4.0]]])+(1.-msk_arg0)*numpy.array([[[1.0, 7.0, 1.0], [2.0, 7.0, -6.0]], [[-6.0, -2.0, -5.0], [-4.0, 3.0, 2.0]]])
      arg1=numpy.array([[[6.0, -4.0], [-6.0, -7.0], [-2.0, 6.0]], [[-6.0, 6.0], [5.0, 2.0], [-2.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[58.0, -53.0], [25.0, 30.0]])+(1.-msk_ref)*numpy.array([[-3.0, -3.0], [21.0, -16.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[3.0, -1.0, 3.0], [-5.0, -7.0, 0.0], [5.0, -5.0, -7.0], [-3.0, 7.0, -5.0]], [[1.0, -5.0, 
0.0], [-1.0, -6.0, -7.0], [-2.0, -2.0, 0.0], [4.0, 1.0, -2.0]]], [[[7.0, -5.0, 2.0], [4.0, -6.0, 0.0], [-5.0, 2.0, 3.0], [-1.0, 
6.0, 2.0]], [[0.0, 5.0, -4.0], [-7.0, -4.0, 3.0], [1.0, -2.0, 0.0], [-4.0, -4.0, -4.0]]]])+(1.-msk_arg0)*numpy.array([[[[-3.0, 
1.0, 1.0], [2.0, 2.0, 0.0], [7.0, 0.0, 0.0], [-6.0, 4.0, -3.0]], [[1.0, -2.0, -1.0], [0.0, 3.0, -1.0], [0.0, 5.0, 2.0], [-4.0, 
-5.0, -3.0]]], [[[-6.0, 0.0, -3.0], [0.0, 1.0, 4.0], [2.0, -3.0, -3.0], [4.0, 7.0, 6.0]], [[-6.0, -5.0, -6.0], [0.0, 3.0, 5.0], 
[2.0, -7.0, 6.0], [3.0, -2.0, 1.0]]]])
      arg1=numpy.array([[[[0.0, -2.0], [-2.0, 5.0], [4.0, 1.0]], [[3.0, 7.0], [1.0, -2.0], [-1.0, 1.0]], [[1.0, -1.0], [0.0, 
-4.0], [-6.0, -3.0]], [[-3.0, 1.0], [1.0, 6.0], [5.0, -3.0]]], [[[7.0, 7.0], [-6.0, 7.0], [0.0, 5.0]], [[4.0, -4.0], [-2.0, 
-7.0], [1.0, 2.0]], [[-6.0, 7.0], [-1.0, -6.0], [-4.0, 3.0]], [[6.0, 3.0], [-7.0, 4.0], [6.0, -2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[87.0, 83.0], [-51.0, 96.0]])+(1.-msk_ref)*numpy.array([[16.0, -43.0], [26.0, 13.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-6.0, 2.0])+(1.-msk_arg0)*numpy.array([-5.0, 3.0])
      arg1=numpy.array([[2.0, 2.0, -7.0, 1.0, -6.0], [-5.0, 5.0, 1.0, -6.0, -3.0], [5.0, 7.0, 1.0, -5.0, 6.0], [-2.0, -1.0, 
4.0, 5.0, -2.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-12.0, -12.0, 42.0, -6.0, 36.0], [30.0, -30.0, -6.0, 36.0, 18.0], [-30.0, -42.0, -6.0, 30.0, 
-36.0], [12.0, 6.0, -24.0, -30.0, 12.0]], [[4.0, 4.0, -14.0, 2.0, -12.0], [-10.0, 10.0, 2.0, -12.0, -6.0], [10.0, 14.0, 2.0, 
-10.0, 12.0], [-4.0, -2.0, 8.0, 10.0, -4.0]]])+(1.-msk_ref)*numpy.array([[[-10.0, -10.0, 35.0, -5.0, 30.0], [25.0, -25.0, -5.0, 
30.0, 15.0], [-25.0, -35.0, -5.0, 25.0, -30.0], [10.0, 5.0, -20.0, -25.0, 10.0]], [[6.0, 6.0, -21.0, 3.0, -18.0], [-15.0, 15.0, 
3.0, -18.0, -9.0], [15.0, 21.0, 3.0, -15.0, 18.0], [-6.0, -3.0, 12.0, 15.0, -6.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-3.0, -3.0, 0.0], [-7.0, -2.0, 7.0]])+(1.-msk_arg0)*numpy.array([[-2.0, 1.0, -4.0], [-1.0, 
-7.0, -6.0]])
      arg1=numpy.array([[[0.0, 2.0, 3.0, 7.0, -5.0], [3.0, -5.0, -1.0, -5.0, -6.0], [7.0, 3.0, 5.0, -3.0, -3.0], [1.0, -4.0, 
-2.0, 7.0, 0.0]], [[3.0, -7.0, -2.0, 0.0, -3.0], [7.0, 3.0, 3.0, 7.0, -7.0], [-6.0, 6.0, 5.0, -4.0, -2.0], [6.0, 7.0, 0.0, 1.0, 
5.0]], [[-2.0, -5.0, 0.0, 0.0, 0.0], [1.0, 0.0, -1.0, 6.0, 6.0], [-2.0, -3.0, -7.0, 0.0, -5.0], [4.0, -3.0, 7.0, 3.0, 7.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-9.0, 15.0, -3.0, -21.0, 24.0], [-30.0, 6.0, -6.0, -6.0, 39.0], [-3.0, -27.0, -30.0, 21.0, 
15.0], [-21.0, -9.0, 6.0, -24.0, -15.0]], [[-20.0, -35.0, -17.0, -49.0, 41.0], [-28.0, 29.0, -6.0, 63.0, 98.0], [-51.0, -54.0, 
-94.0, 29.0, -10.0], [9.0, -7.0, 63.0, -30.0, 39.0]]])+(1.-msk_ref)*numpy.array([[[11.0, 9.0, -8.0, -14.0, 7.0], [-3.0, 13.0, 
9.0, -7.0, -19.0], [-12.0, 12.0, 23.0, 2.0, 24.0], [-12.0, 27.0, -24.0, -25.0, -23.0]], [[-9.0, 77.0, 11.0, -7.0, 26.0], 
[-58.0, -16.0, -14.0, -80.0, 19.0], [47.0, -27.0, 2.0, 31.0, 47.0], [-67.0, -27.0, -40.0, -32.0, -77.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[0.0, -1.0, -3.0], [3.0, 5.0, 0.0]], [[1.0, 2.0, -5.0], [5.0, -5.0, 
-3.0]]])+(1.-msk_arg0)*numpy.array([[[-5.0, 0.0, -6.0], [2.0, -6.0, 5.0]], [[-4.0, -7.0, -1.0], [-5.0, 5.0, -3.0]]])
      arg1=numpy.array([[[[-5.0, -2.0, -4.0, -1.0, 4.0], [6.0, -4.0, -6.0, 5.0, -7.0], [0.0, 1.0, -2.0, -1.0, 0.0], [4.0, 5.0, 
-3.0, 2.0, -4.0]], [[-6.0, -3.0, -1.0, 2.0, -2.0], [0.0, -4.0, 0.0, 0.0, 4.0], [-3.0, 0.0, 4.0, -2.0, 6.0], [0.0, 5.0, 0.0, 
3.0, -7.0]], [[-7.0, 3.0, 1.0, -2.0, 2.0], [7.0, -2.0, -2.0, 7.0, -6.0], [-6.0, -7.0, -3.0, 4.0, -5.0], [-5.0, 0.0, 5.0, 3.0, 
2.0]]], [[[7.0, 0.0, 7.0, 3.0, 2.0], [0.0, 6.0, 5.0, -2.0, 0.0], [-1.0, 2.0, 1.0, -1.0, -2.0], [3.0, 4.0, 7.0, 6.0, 3.0]], 
[[-3.0, 0.0, -7.0, -2.0, 0.0], [3.0, -2.0, 2.0, 7.0, -2.0], [-2.0, -4.0, 0.0, -2.0, 7.0], [-7.0, 0.0, -1.0, 0.0, 4.0]], [[5.0, 
-7.0, 0.0, 6.0, 0.0], [-2.0, -7.0, -2.0, 3.0, 7.0], [-5.0, 3.0, 1.0, -3.0, -7.0], [0.0, -1.0, 4.0, -4.0, 6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[33.0, -6.0, -16.0, 3.0, 2.0], [-6.0, 18.0, 31.0, 8.0, 4.0], [8.0, 7.0, 8.0, -23.0, 38.0], 
[-11.0, 7.0, 1.0, 6.0, 30.0]], [[53.0, -2.0, 59.0, 20.0, 0.0], [-38.0, 59.0, 25.0, -84.0, 20.0], [44.0, 57.0, 23.0, -11.0, 
13.0], [79.0, 38.0, 0.0, 35.0, -51.0]]])+(1.-msk_ref)*numpy.array([[[124.0, -43.0, 70.0, 65.0, -28.0], [-100.0, 21.0, 30.0, 
-98.0, 118.0], [21.0, 80.0, 35.0, -24.0, -51.0], [58.0, -22.0, 25.0, -36.0, 20.0]], [[4.0, 47.0, -48.0, -51.0, -14.0], [-10.0, 
27.0, 17.0, 9.0, -25.0], [37.0, -36.0, -25.0, 18.0, 29.0], [-61.0, -72.0, -45.0, -50.0, 50.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_array_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([7.0, 6.0])+(1.-msk_arg0)*numpy.array([2.0, 0.0])
      arg1=numpy.array([[[-5.0, 3.0], [4.0, 7.0]], [[1.0, 1.0], [5.0, 7.0]], [[-4.0, 4.0], [-3.0, 0.0]], [[-7.0, 1.0], [5.0, 
-2.0]], [[6.0, 5.0], [0.0, 5.0]], [[5.0, 5.0], [-6.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-35.0, 21.0], [28.0, 49.0]], [[7.0, 7.0], [35.0, 49.0]], [[-28.0, 28.0], [-21.0, 0.0]], 
[[-49.0, 7.0], [35.0, -14.0]], [[42.0, 35.0], [0.0, 35.0]], [[35.0, 35.0], [-42.0, 0.0]]], [[[-30.0, 18.0], [24.0, 42.0]], 
[[6.0, 6.0], [30.0, 42.0]], [[-24.0, 24.0], [-18.0, 0.0]], [[-42.0, 6.0], [30.0, -12.0]], [[36.0, 30.0], [0.0, 30.0]], [[30.0, 
30.0], [-36.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[-10.0, 6.0], [8.0, 14.0]], [[2.0, 2.0], [10.0, 14.0]], [[-8.0, 8.0], 
[-6.0, 0.0]], [[-14.0, 2.0], [10.0, -4.0]], [[12.0, 10.0], [0.0, 10.0]], [[10.0, 10.0], [-12.0, 0.0]]], [[[0.0, 0.0], [0.0, 
0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-7.0, 4.0, 2.0], [-2.0, -1.0, 0.0]])+(1.-msk_arg0)*numpy.array([[6.0, 7.0, -7.0], [7.0, 6.0, 
-7.0]])
      arg1=numpy.array([[[[3.0, -5.0], [0.0, 1.0]], [[-7.0, -2.0], [-3.0, -3.0]], [[-6.0, -3.0], [0.0, 6.0]], [[-4.0, -6.0], 
[-1.0, 7.0]], [[0.0, 5.0], [6.0, 0.0]], [[4.0, -5.0], [-7.0, -7.0]]], [[[6.0, -6.0], [4.0, -2.0]], [[1.0, -5.0], [-4.0, 6.0]], 
[[-3.0, -3.0], [-4.0, -7.0]], [[-1.0, 0.0], [3.0, -6.0]], [[7.0, 4.0], [3.0, 7.0]], [[3.0, -3.0], [-6.0, -4.0]]], [[[2.0, 7.0], 
[0.0, -2.0]], [[7.0, 7.0], [-6.0, -3.0]], [[-4.0, 3.0], [-5.0, 6.0]], [[-6.0, 0.0], [-3.0, 1.0]], [[-7.0, -6.0], [6.0, 0.0]], 
[[-4.0, 5.0], [-2.0, -2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[7.0, 25.0], [16.0, -19.0]], [[67.0, 8.0], [-7.0, 39.0]], [[22.0, 15.0], [-26.0, -58.0]], 
[[12.0, 42.0], [13.0, -71.0]], [[14.0, -31.0], [-18.0, 28.0]], [[-24.0, 33.0], [21.0, 29.0]]], [[[-12.0, 16.0], [-4.0, 0.0]], 
[[13.0, 9.0], [10.0, 0.0]], [[15.0, 9.0], [4.0, -5.0]], [[9.0, 12.0], [-1.0, -8.0]], [[-7.0, -14.0], [-15.0, -7.0]], [[-11.0, 
13.0], [20.0, 18.0]]]])+(1.-msk_ref)*numpy.array([[[[46.0, -121.0], [28.0, 6.0]], [[-84.0, -96.0], [-4.0, 45.0]], [[-29.0, 
-60.0], [7.0, -55.0]], [[11.0, -36.0], [36.0, -7.0]], [[98.0, 100.0], [15.0, 49.0]], [[73.0, -86.0], [-70.0, -56.0]]], [[[43.0, 
-120.0], [24.0, 9.0]], [[-92.0, -93.0], [-3.0, 36.0]], [[-32.0, -60.0], [11.0, -42.0]], [[8.0, -42.0], [32.0, 6.0]], [[91.0, 
101.0], [18.0, 42.0]], [[74.0, -88.0], [-71.0, -59.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-7.0, 5.0])+(1.-msk_arg0)*numpy.array([0.0, -5.0])
      arg1=Data(7.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-49.0, 35.0])+(1.-msk_ref)*numpy.array([0.0, -35.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[5.0, 3.0, -4.0], [-2.0, 4.0, -4.0]])+(1.-msk_arg0)*numpy.array([[5.0, 5.0, -5.0], [4.0, 7.0, 
-6.0]])
      arg1=Data(numpy.array([6.0, -3.0, -1.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([25.0, -20.0])+(1.-msk_ref)*numpy.array([20.0, 9.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[1.0, 3.0, -5.0], [3.0, 5.0, 7.0]], [[0.0, -4.0, 6.0], [0.0, 1.0, 
3.0]]])+(1.-msk_arg0)*numpy.array([[[2.0, -2.0, -4.0], [1.0, 0.0, -2.0]], [[2.0, -6.0, -4.0], [-5.0, 5.0, -1.0]]])
      arg1=Data(numpy.array([[2.0, 7.0, 0.0], [1.0, 6.0, -5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([21.0, -37.0])+(1.-msk_ref)*numpy.array([1.0, -8.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[4.0, 0.0, -6.0], [-2.0, -2.0, 4.0], [-4.0, 7.0, -5.0], [1.0, -5.0, -7.0]], [[5.0, 6.0, 
-3.0], [7.0, -5.0, -5.0], [7.0, 2.0, -6.0], [3.0, 0.0, 7.0]]], [[[5.0, 1.0, -4.0], [0.0, -5.0, 4.0], [4.0, -2.0, 6.0], [-2.0, 
-4.0, 0.0]], [[-1.0, -3.0, -2.0], [0.0, -3.0, 5.0], [1.0, 5.0, 6.0], [0.0, 7.0, 3.0]]]])+(1.-msk_arg0)*numpy.array([[[[-1.0, 
-2.0, 0.0], [-5.0, -6.0, 7.0], [-2.0, -3.0, 4.0], [-3.0, -2.0, -1.0]], [[-6.0, 2.0, -5.0], [5.0, 3.0, 0.0], [3.0, 1.0, -7.0], 
[2.0, -2.0, 5.0]]], [[[6.0, 0.0, -4.0], [-6.0, -5.0, 1.0], [-3.0, 7.0, 7.0], [0.0, -5.0, -4.0]], [[2.0, 5.0, -6.0], [1.0, -3.0, 
5.0], [-6.0, 1.0, 6.0], [7.0, 7.0, 6.0]]]])
      arg1=Data(numpy.array([[[-5.0, 3.0, -6.0], [-7.0, 6.0, 0.0], [0.0, 4.0, 7.0], [-4.0, -3.0, -6.0]], [[2.0, 3.0, 5.0], 
[4.0, -7.0, 1.0], [5.0, 2.0, -3.0], [7.0, 6.0, -1.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([206.0, 67.0])+(1.-msk_ref)*numpy.array([41.0, 180.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-7.0, 6.0])+(1.-msk_arg0)*numpy.array([-5.0, -2.0])
      arg1=Data(numpy.array([-2.0, -3.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[14.0, 21.0], [-12.0, -18.0]])+(1.-msk_ref)*numpy.array([[10.0, 15.0], [4.0, 6.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-6.0, 0.0, 5.0], [-3.0, -5.0, -2.0]])+(1.-msk_arg0)*numpy.array([[-6.0, 0.0, 7.0], [0.0, 
-1.0, -2.0]])
      arg1=Data(numpy.array([[1.0, -5.0], [0.0, 0.0], [-3.0, 5.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-21.0, 55.0], [3.0, 5.0]])+(1.-msk_ref)*numpy.array([[-27.0, 65.0], [6.0, -10.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[0.0, -5.0, -1.0], [0.0, -2.0, 3.0]], [[2.0, -6.0, 1.0], [0.0, -4.0, 
2.0]]])+(1.-msk_arg0)*numpy.array([[[7.0, -5.0, 0.0], [0.0, -4.0, -1.0]], [[-6.0, -7.0, -3.0], [-1.0, 0.0, -6.0]]])
      arg1=Data(numpy.array([[[-5.0, -7.0], [5.0, 0.0], [-1.0, 0.0]], [[-4.0, -1.0], [-6.0, 1.0], [-4.0, 
-4.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-24.0, -14.0], [-25.0, -26.0]])+(1.-msk_ref)*numpy.array([[-32.0, -49.0], [26.0, 67.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[5.0, 3.0, -2.0], [-3.0, -6.0, 6.0], [1.0, 3.0, 6.0], [-2.0, -7.0, -2.0]], [[-7.0, -3.0, 
-3.0], [-1.0, 2.0, -6.0], [2.0, -5.0, 4.0], [3.0, -5.0, 0.0]]], [[[-6.0, -2.0, 5.0], [7.0, 4.0, 3.0], [7.0, 2.0, 3.0], [2.0, 
0.0, 2.0]], [[5.0, -1.0, 0.0], [-6.0, 0.0, 7.0], [0.0, 4.0, -2.0], [-5.0, 6.0, -3.0]]]])+(1.-msk_arg0)*numpy.array([[[[7.0, 
-6.0, -4.0], [4.0, 7.0, 3.0], [0.0, -2.0, 6.0], [2.0, 5.0, -4.0]], [[6.0, 0.0, 4.0], [-5.0, 2.0, 1.0], [-2.0, 3.0, -6.0], 
[-6.0, -5.0, -3.0]]], [[[0.0, -5.0, 7.0], [1.0, 6.0, 5.0], [5.0, 2.0, -1.0], [-1.0, -3.0, 5.0]], [[-1.0, 4.0, -2.0], [3.0, 5.0, 
-7.0], [2.0, 0.0, 3.0], [-2.0, 0.0, 0.0]]]])
      arg1=Data(numpy.array([[[[-2.0, 3.0], [1.0, 2.0], [2.0, 3.0]], [[3.0, -7.0], [-2.0, 1.0], [0.0, -1.0]], [[-6.0, 7.0], 
[0.0, -5.0], [0.0, 2.0]], [[-7.0, -2.0], [0.0, -1.0], [1.0, 0.0]]], [[[6.0, 5.0], [-2.0, -5.0], [-6.0, 5.0]], [[-2.0, 5.0], 
[-2.0, 1.0], [-7.0, -5.0]], [[-5.0, -2.0], [-1.0, -3.0], [-7.0, -1.0]], [[1.0, -1.0], [7.0, -5.0], [2.0, 
-1.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-45.0, 60.0], [15.0, -81.0]])+(1.-msk_ref)*numpy.array([[-35.0, 43.0], [-20.0, 48.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([4.0, 0.0])+(1.-msk_arg0)*numpy.array([0.0, -5.0])
      arg1=Data(numpy.array([[6.0, 1.0, -6.0, 6.0, 0.0], [-2.0, -3.0, 1.0, 2.0, 0.0], [4.0, 1.0, 4.0, 7.0, -6.0], [6.0, 0.0, 
5.0, -5.0, 0.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[24.0, 4.0, -24.0, 24.0, 0.0], [-8.0, -12.0, 4.0, 8.0, 0.0], [16.0, 4.0, 16.0, 28.0, -24.0], 
[24.0, 0.0, 20.0, -20.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0]], [[-30.0, -5.0, 30.0, -30.0, 0.0], [10.0, 15.0, -5.0, -10.0, 0.0], [-20.0, -5.0, -20.0, -35.0, 
30.0], [-30.0, 0.0, -25.0, 25.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-6.0, 1.0, 7.0], [1.0, 0.0, 1.0]])+(1.-msk_arg0)*numpy.array([[3.0, 4.0, -5.0], [-1.0, 3.0, 
6.0]])
      arg1=Data(numpy.array([[[7.0, -3.0, 2.0, 4.0, 6.0], [-2.0, 5.0, -7.0, -6.0, 1.0], [3.0, -1.0, -5.0, -7.0, 6.0], [-3.0, 
-1.0, -4.0, -6.0, 1.0]], [[-1.0, 1.0, -6.0, -5.0, -4.0], [5.0, -3.0, -2.0, -7.0, 0.0], [-7.0, 0.0, 4.0, 5.0, 6.0], [-5.0, 4.0, 
4.0, -3.0, -6.0]], [[-6.0, 1.0, 6.0, 6.0, 0.0], [5.0, 7.0, -3.0, -3.0, 7.0], [-4.0, -2.0, 3.0, -3.0, -7.0], [3.0, 2.0, -1.0, 
-4.0, -2.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-85.0, 26.0, 24.0, 13.0, -40.0], [52.0, 16.0, 19.0, 8.0, 43.0], [-53.0, -8.0, 55.0, 26.0, 
-79.0], [34.0, 24.0, 21.0, 5.0, -26.0]], [[1.0, -2.0, 8.0, 10.0, 6.0], [3.0, 12.0, -10.0, -9.0, 8.0], [-1.0, -3.0, -2.0, -10.0, 
-1.0], [0.0, 1.0, -5.0, -10.0, -1.0]]])+(1.-msk_ref)*numpy.array([[[47.0, -10.0, -48.0, -38.0, 2.0], [-11.0, -32.0, -14.0, 
-31.0, -32.0], [1.0, 7.0, -14.0, 14.0, 77.0], [-44.0, 3.0, 9.0, -10.0, -11.0]], [[-46.0, 12.0, 16.0, 17.0, -18.0], [47.0, 28.0, 
-17.0, -33.0, 41.0], [-48.0, -11.0, 35.0, 4.0, -30.0], [6.0, 25.0, 10.0, -27.0, -31.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[0.0, -2.0, -7.0], [-5.0, -3.0, -4.0]], [[6.0, -4.0, -1.0], [-5.0, 2.0, 
0.0]]])+(1.-msk_arg0)*numpy.array([[[-2.0, 4.0, 3.0], [-1.0, 5.0, -7.0]], [[-2.0, 1.0, -7.0], [2.0, 0.0, 0.0]]])
      arg1=Data(numpy.array([[[[0.0, 4.0, -4.0, 0.0, -4.0], [6.0, -5.0, -3.0, 5.0, 0.0], [1.0, 0.0, -5.0, 3.0, 4.0], [-6.0, 
6.0, -2.0, -2.0, -2.0]], [[2.0, 5.0, 5.0, -1.0, 0.0], [-5.0, -5.0, 4.0, -3.0, -1.0], [0.0, -5.0, 5.0, 0.0, -2.0], [0.0, 0.0, 
7.0, 3.0, -1.0]], [[-5.0, 1.0, -6.0, -6.0, -3.0], [-1.0, 4.0, -5.0, -3.0, -4.0], [-1.0, 4.0, 6.0, 3.0, 3.0], [2.0, -1.0, 0.0, 
7.0, 5.0]]], [[[4.0, 1.0, 1.0, -6.0, 0.0], [-5.0, 1.0, 1.0, 1.0, 6.0], [-7.0, 6.0, -1.0, 0.0, -7.0], [-6.0, 0.0, -2.0, 4.0, 
0.0]], [[1.0, -2.0, 2.0, -4.0, -2.0], [5.0, -6.0, 7.0, -2.0, -7.0], [0.0, 6.0, 7.0, 4.0, 6.0], [6.0, 6.0, 4.0, -7.0, -7.0]], 
[[6.0, 4.0, -2.0, -1.0, -1.0], [7.0, 4.0, 3.0, -2.0, 5.0], [0.0, 0.0, -4.0, -4.0, 4.0], [0.0, -5.0, -3.0, -4.0, 
3.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-16.0, -32.0, 29.0, 90.0, 31.0], [-1.0, -21.0, -11.0, 36.0, 1.0], [42.0, -66.0, -52.0, -17.0, 
-16.0], [-2.0, 9.0, -4.0, -38.0, -24.0]], [[-21.0, -6.0, -39.0, 32.0, -25.0], [92.0, -31.0, -20.0, 36.0, -36.0], [42.0, -2.0, 
-37.0, 23.0, 76.0], [4.0, 49.0, -22.0, -65.0, -27.0]]])+(1.-msk_ref)*numpy.array([[[-48.0, -24.0, 33.0, -29.0, -4.0], [-54.0, 
-57.0, 20.0, -28.0, -92.0], [2.0, 16.0, 112.0, 51.0, 2.0], [54.0, 50.0, 75.0, 26.0, -41.0]], [[45.0, -8.0, 57.0, 29.0, 29.0], 
[-20.0, -21.0, 47.0, 10.0, 39.0], [-9.0, -21.0, -29.0, -27.0, -45.0], [-14.0, -5.0, 7.0, -34.0, -32.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_constData_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([0.0, 3.0])+(1.-msk_arg0)*numpy.array([6.0, -1.0])
      arg1=Data(numpy.array([[[5.0, 2.0], [2.0, 5.0]], [[-7.0, -4.0], [-4.0, 4.0]], [[4.0, -1.0], [2.0, -5.0]], [[-5.0, -1.0], 
[0.0, 2.0]], [[-5.0, 4.0], [-7.0, -2.0]], [[2.0, -2.0], [7.0, -4.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]]], [[[15.0, 6.0], [6.0, 15.0]], [[-21.0, -12.0], [-12.0, 12.0]], 
[[12.0, -3.0], [6.0, -15.0]], [[-15.0, -3.0], [0.0, 6.0]], [[-15.0, 12.0], [-21.0, -6.0]], [[6.0, -6.0], [21.0, 
-12.0]]]])+(1.-msk_ref)*numpy.array([[[[30.0, 12.0], [12.0, 30.0]], [[-42.0, -24.0], [-24.0, 24.0]], [[24.0, -6.0], [12.0, 
-30.0]], [[-30.0, -6.0], [0.0, 12.0]], [[-30.0, 24.0], [-42.0, -12.0]], [[12.0, -12.0], [42.0, -24.0]]], [[[-5.0, -2.0], [-2.0, 
-5.0]], [[7.0, 4.0], [4.0, -4.0]], [[-4.0, 1.0], [-2.0, 5.0]], [[5.0, 1.0], [0.0, -2.0]], [[5.0, -4.0], [7.0, 2.0]], [[-2.0, 
2.0], [-7.0, 4.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[4.0, 6.0, -6.0], [-3.0, 5.0, 2.0]])+(1.-msk_arg0)*numpy.array([[5.0, 3.0, 6.0], [3.0, 6.0, 
3.0]])
      arg1=Data(numpy.array([[[[4.0, 6.0], [6.0, 1.0]], [[1.0, 2.0], [-4.0, 0.0]], [[6.0, -2.0], [-5.0, -5.0]], [[-4.0, 2.0], 
[3.0, -1.0]], [[2.0, -1.0], [2.0, -1.0]], [[0.0, 0.0], [0.0, 4.0]]], [[[-3.0, 3.0], [-1.0, -5.0]], [[-3.0, 0.0], [-4.0, 2.0]], 
[[3.0, -6.0], [1.0, -6.0]], [[7.0, 5.0], [2.0, -7.0]], [[6.0, -1.0], [-2.0, 4.0]], [[3.0, -7.0], [-5.0, -2.0]]], [[[-3.0, 
-7.0], [2.0, -5.0]], [[3.0, 2.0], [-7.0, 4.0]], [[6.0, 1.0], [-6.0, 4.0]], [[-1.0, -5.0], [4.0, -3.0]], [[0.0, -7.0], [-1.0, 
-6.0]], [[1.0, -5.0], [0.0, 4.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[16.0, 84.0], [6.0, 4.0]], [[-32.0, -4.0], [2.0, -12.0]], [[6.0, -50.0], [22.0, -80.0]], 
[[32.0, 68.0], [0.0, -28.0]], [[44.0, 32.0], [2.0, 56.0]], [[12.0, -12.0], [-30.0, -20.0]]], [[[-33.0, -17.0], [-19.0, -38.0]], 
[[-12.0, -2.0], [-22.0, 18.0]], [[9.0, -22.0], [8.0, -7.0]], [[45.0, 9.0], [9.0, -38.0]], [[24.0, -16.0], [-18.0, 11.0]], 
[[17.0, -45.0], [-25.0, -14.0]]]])+(1.-msk_ref)*numpy.array([[[[-7.0, -3.0], [39.0, -40.0]], [[14.0, 22.0], [-74.0, 30.0]], 
[[75.0, -22.0], [-58.0, -19.0]], [[-5.0, -5.0], [45.0, -44.0]], [[28.0, -50.0], [-2.0, -29.0]], [[15.0, -51.0], [-15.0, 
38.0]]], [[[-15.0, 15.0], [18.0, -42.0]], [[-6.0, 12.0], [-57.0, 24.0]], [[54.0, -39.0], [-27.0, -39.0]], [[27.0, 21.0], [33.0, 
-54.0]], [[42.0, -30.0], [-9.0, 3.0]], [[21.0, -57.0], [-30.0, 12.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([4.0, 0.0])+(1.-msk_arg0)*numpy.array([1.0, 1.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-2.0)+(1-msk_arg1)*(0.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-8.0, -0.0])+(1.-msk_ref)*numpy.array([0.0, 0.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-6.0, 4.0, -5.0], [-3.0, -5.0, 6.0]])+(1.-msk_arg0)*numpy.array([[2.0, 5.0, -4.0], [3.0, 
-3.0, 2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-7.0, -3.0, 3.0])+(1.-msk_arg1)*numpy.array([-7.0, 1.0, -3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([15.0, 54.0])+(1.-msk_ref)*numpy.array([3.0, -30.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-2.0, 1.0, -7.0], [5.0, -4.0, 4.0]], [[3.0, 7.0, 2.0], [-1.0, 5.0, 
1.0]]])+(1.-msk_arg0)*numpy.array([[[-1.0, 5.0, -5.0], [5.0, -1.0, 0.0]], [[-4.0, 6.0, 1.0], [-2.0, 3.0, -1.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[1.0, 2.0, 1.0], [2.0, -4.0, 6.0]])+(1.-msk_arg1)*numpy.array([[7.0, -1.0, 3.0], [-6.0, -2.0, 
4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([43.0, 3.0])+(1.-msk_ref)*numpy.array([-55.0, -29.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank3_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[7.0, 6.0, -7.0], [7.0, 2.0, -7.0], [0.0, 1.0, 1.0], [-5.0, -3.0, 5.0]], [[0.0, 3.0, -7.0], 
[-2.0, -3.0, 4.0], [6.0, -6.0, 0.0], [-6.0, 4.0, 6.0]]], [[[0.0, -4.0, 4.0], [7.0, 0.0, 0.0], [7.0, 4.0, 3.0], [-5.0, -4.0, 
3.0]], [[-5.0, -3.0, -2.0], [6.0, 0.0, -6.0], [7.0, 3.0, -2.0], [6.0, 0.0, 0.0]]]])+(1.-msk_arg0)*numpy.array([[[[6.0, 4.0, 
3.0], [-3.0, 4.0, -1.0], [5.0, -2.0, -7.0], [6.0, -7.0, 0.0]], [[0.0, 6.0, -6.0], [-6.0, -1.0, 0.0], [-4.0, -4.0, 2.0], [3.0, 
-2.0, 6.0]]], [[[-7.0, -5.0, 5.0], [-6.0, -2.0, 5.0], [-3.0, -3.0, 6.0], [3.0, -7.0, -3.0]], [[-2.0, 6.0, -5.0], [-7.0, -3.0, 
6.0], [-7.0, 7.0, 7.0], [1.0, -3.0, 0.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-4.0, 0.0, 6.0], [2.0, 3.0, -6.0], [-6.0, 5.0, 7.0], [5.0, -5.0, -5.0]], [[0.0, 6.0, -3.0], 
[4.0, -5.0, 1.0], [-5.0, -6.0, -6.0], [5.0, 4.0, 1.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, 3.0, 0.0], [-2.0, 1.0, 0.0], [-6.0, 
0.0, 0.0], [7.0, 3.0, -2.0]], [[1.0, -4.0, -4.0], [6.0, 5.0, 5.0], [0.0, -4.0, 0.0], [7.0, -5.0, 4.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([17.0, 12.0])+(1.-msk_ref)*numpy.array([61.0, -41.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([7.0, -3.0])+(1.-msk_arg0)*numpy.array([1.0, 7.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([6.0, -4.0])+(1.-msk_arg1)*numpy.array([1.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[42.0, -28.0], [-18.0, 12.0]])+(1.-msk_ref)*numpy.array([[1.0, 0.0], [7.0, 0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-1.0, 0.0, -5.0], [6.0, -2.0, 7.0]])+(1.-msk_arg0)*numpy.array([[0.0, 6.0, -5.0], [3.0, -2.0, 
4.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-2.0, -1.0], [4.0, 7.0], [2.0, -6.0]])+(1.-msk_arg1)*numpy.array([[-3.0, -4.0], [2.0, 5.0], 
[0.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-8.0, 31.0], [-6.0, -62.0]])+(1.-msk_ref)*numpy.array([[12.0, 30.0], [-13.0, -22.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[6.0, -1.0, 7.0], [2.0, 1.0, 3.0]], [[0.0, 0.0, -1.0], [2.0, 0.0, 
5.0]]])+(1.-msk_arg0)*numpy.array([[[-7.0, 3.0, 4.0], [-4.0, 4.0, 0.0]], [[-3.0, 3.0, 4.0], [-1.0, -3.0, 0.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, -3.0], [2.0, 0.0], [7.0, -3.0]], [[6.0, 1.0], [-1.0, -6.0], [-5.0, 
1.0]]])+(1.-msk_arg1)*numpy.array([[[0.0, -4.0], [-3.0, 1.0], [4.0, 5.0]], [[-4.0, -5.0], [7.0, -5.0], [0.0, -6.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[7.0, -40.0], [-20.0, 10.0]])+(1.-msk_ref)*numpy.array([[51.0, 51.0], [-10.0, 55.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank4_offset3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[7.0, -5.0, -5.0], [-1.0, 2.0, 1.0], [4.0, -6.0, 1.0], [-5.0, 0.0, -2.0]], [[-1.0, 6.0, 
-1.0], [-4.0, 0.0, -3.0], [2.0, 4.0, 6.0], [-3.0, 4.0, -1.0]]], [[[0.0, 1.0, 6.0], [-1.0, -3.0, 2.0], [6.0, 4.0, 5.0], [1.0, 
6.0, 0.0]], [[0.0, 2.0, 0.0], [-4.0, 0.0, 1.0], [7.0, -6.0, -6.0], [1.0, 7.0, -5.0]]]])+(1.-msk_arg0)*numpy.array([[[[-6.0, 
2.0, 7.0], [-5.0, 0.0, -4.0], [4.0, -1.0, 1.0], [3.0, -5.0, 3.0]], [[-7.0, 0.0, -3.0], [-4.0, -5.0, -6.0], [0.0, -4.0, 1.0], 
[-3.0, -5.0, -1.0]]], [[[-4.0, -2.0, 6.0], [2.0, -5.0, 0.0], [4.0, -5.0, 4.0], [5.0, -1.0, 0.0]], [[-6.0, 0.0, -2.0], [-7.0, 
3.0, -4.0], [-1.0, -1.0, -6.0], [4.0, 2.0, 5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-3.0, -3.0], [-5.0, 6.0], [-2.0, -1.0]], [[-3.0, 1.0], [-5.0, -5.0], [-1.0, 5.0]], [[-5.0, 
6.0], [3.0, -3.0], [-6.0, -7.0]], [[6.0, 2.0], [-4.0, -6.0], [3.0, -7.0]]], [[[-5.0, 0.0], [0.0, -5.0], [-2.0, -3.0]], [[0.0, 
5.0], [1.0, -5.0], [7.0, -4.0]], [[2.0, 0.0], [2.0, -1.0], [-7.0, -5.0]], [[-3.0, -7.0], [-1.0, 5.0], [2.0, 
-6.0]]]])+(1.-msk_arg1)*numpy.array([[[[4.0, -5.0], [7.0, 7.0], [5.0, 7.0]], [[-6.0, 0.0], [6.0, 4.0], [-5.0, -4.0]], [[-1.0, 
-1.0], [0.0, -7.0], [0.0, 6.0]], [[2.0, 0.0], [2.0, 0.0], [-5.0, -6.0]]], [[[-2.0, 3.0], [-2.0, -1.0], [-2.0, 0.0]], [[0.0, 
-1.0], [2.0, 4.0], [-3.0, -6.0]], [[-1.0, -1.0], [-5.0, 1.0], [2.0, -7.0]], [[4.0, 2.0], [3.0, 0.0], [-1.0, 1.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-115.0, -35.0], [-36.0, 39.0]])+(1.-msk_ref)*numpy.array([[76.0, 81.0], [7.0, 163.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([-7.0, -4.0])+(1.-msk_arg0)*numpy.array([1.0, 6.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-3.0, 6.0, -1.0, -7.0, 0.0], [6.0, -2.0, 0.0, 5.0, 5.0], [-3.0, 4.0, -6.0, -7.0, 0.0], [-4.0, 
-3.0, 5.0, -2.0, 3.0]])+(1.-msk_arg1)*numpy.array([[1.0, 2.0, -5.0, -7.0, -3.0], [0.0, -3.0, 1.0, 3.0, -1.0], [-5.0, 7.0, -1.0, 
7.0, -5.0], [6.0, 5.0, 6.0, -1.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[21.0, -42.0, 7.0, 49.0, 0.0], [-42.0, 14.0, 0.0, -35.0, -35.0], [21.0, -28.0, 42.0, 49.0, 
0.0], [28.0, 21.0, -35.0, 14.0, -21.0]], [[12.0, -24.0, 4.0, 28.0, 0.0], [-24.0, 8.0, 0.0, -20.0, -20.0], [12.0, -16.0, 24.0, 
28.0, 0.0], [16.0, 12.0, -20.0, 8.0, -12.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 2.0, -5.0, -7.0, -3.0], [0.0, -3.0, 1.0, 3.0, 
-1.0], [-5.0, 7.0, -1.0, 7.0, -5.0], [6.0, 5.0, 6.0, -1.0, 0.0]], [[6.0, 12.0, -30.0, -42.0, -18.0], [0.0, -18.0, 6.0, 18.0, 
-6.0], [-30.0, 42.0, -6.0, 42.0, -30.0], [36.0, 30.0, 36.0, -6.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-4.0, 1.0, -4.0], [-1.0, 5.0, -4.0]])+(1.-msk_arg0)*numpy.array([[5.0, -4.0, 3.0], [-4.0, 
-3.0, -5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[0.0, 3.0, 0.0, -4.0, -3.0], [7.0, -4.0, 0.0, 0.0, -5.0], [-7.0, 7.0, 1.0, 7.0, 5.0], [-6.0, 
5.0, 1.0, -6.0, 0.0]], [[1.0, -7.0, 3.0, -4.0, -7.0], [-4.0, -5.0, 4.0, 1.0, 2.0], [6.0, -1.0, -4.0, -1.0, 2.0], [1.0, -3.0, 
5.0, -7.0, 2.0]], [[3.0, -7.0, 0.0, -4.0, -1.0], [-4.0, -6.0, 7.0, 2.0, -7.0], [-3.0, 5.0, -7.0, 7.0, 0.0], [0.0, 3.0, -2.0, 
-2.0, 6.0]]])+(1.-msk_arg1)*numpy.array([[[-2.0, -1.0, 2.0, 4.0, 4.0], [0.0, 2.0, 2.0, 6.0, -2.0], [-3.0, 6.0, 3.0, -3.0, 
-6.0], [7.0, -2.0, -4.0, 4.0, 1.0]], [[0.0, -7.0, 4.0, 2.0, -5.0], [7.0, -5.0, -5.0, -1.0, -4.0], [-1.0, 7.0, -1.0, 6.0, 7.0], 
[-7.0, 5.0, -2.0, -2.0, 6.0]], [[-3.0, 7.0, 4.0, 1.0, -1.0], [6.0, -6.0, -7.0, 0.0, -4.0], [5.0, 3.0, -3.0, -2.0, 5.0], [1.0, 
7.0, -7.0, -6.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-11.0, 9.0, 3.0, 28.0, 9.0], [-16.0, 35.0, -24.0, -7.0, 50.0], [46.0, -49.0, 20.0, -57.0, 
-18.0], [25.0, -35.0, 9.0, 25.0, -22.0]], [[-7.0, -10.0, 15.0, 0.0, -28.0], [-11.0, 3.0, -8.0, -3.0, 43.0], [49.0, -32.0, 7.0, 
-40.0, 5.0], [11.0, -32.0, 32.0, -21.0, -14.0]]])+(1.-msk_ref)*numpy.array([[[-19.0, 44.0, 6.0, 15.0, 37.0], [-10.0, 12.0, 9.0, 
34.0, -6.0], [4.0, 11.0, 10.0, -45.0, -43.0], [66.0, -9.0, -33.0, 10.0, -19.0]], [[23.0, -10.0, -40.0, -27.0, 4.0], [-51.0, 
37.0, 42.0, -21.0, 40.0], [-10.0, -60.0, 6.0, 4.0, -22.0], [-12.0, -42.0, 57.0, 20.0, -22.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-3.0, 4.0, -3.0], [-6.0, 3.0, -1.0]], [[0.0, -3.0, -5.0], [-1.0, -6.0, 
-3.0]]])+(1.-msk_arg0)*numpy.array([[[-2.0, 1.0, 6.0], [-6.0, -6.0, -1.0]], [[-2.0, 6.0, -7.0], [-3.0, -6.0, -2.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[7.0, -6.0, -5.0, -7.0, 5.0], [2.0, -6.0, 4.0, -5.0, 5.0], [-1.0, -5.0, -5.0, 5.0, -1.0], 
[0.0, 4.0, -2.0, -3.0, -4.0]], [[-1.0, -2.0, -7.0, -1.0, -3.0], [6.0, -5.0, 0.0, -3.0, 3.0], [-4.0, 0.0, 3.0, 0.0, 5.0], [-7.0, 
-1.0, -6.0, 5.0, -2.0]], [[-2.0, 3.0, 0.0, -6.0, 4.0], [-3.0, -5.0, 0.0, 5.0, -4.0], [0.0, 5.0, 4.0, -7.0, 5.0], [7.0, -6.0, 
0.0, -7.0, -4.0]]], [[[3.0, 7.0, 0.0, 1.0, 6.0], [2.0, 6.0, -4.0, 2.0, -5.0], [6.0, -4.0, 0.0, -2.0, 1.0], [-3.0, 2.0, -7.0, 
-3.0, 6.0]], [[6.0, 1.0, -6.0, 7.0, -5.0], [2.0, -5.0, 0.0, 3.0, 4.0], [2.0, 1.0, -5.0, 0.0, 5.0], [4.0, 0.0, -3.0, 2.0, 2.0]], 
[[5.0, -4.0, -3.0, 7.0, 4.0], [-4.0, -6.0, 4.0, 3.0, 4.0], [6.0, 5.0, 5.0, 3.0, -5.0], [0.0, 3.0, 6.0, 6.0, 
-1.0]]]])+(1.-msk_arg1)*numpy.array([[[[-4.0, -5.0, 7.0, 7.0, -4.0], [0.0, -3.0, 0.0, -2.0, 1.0], [-5.0, -5.0, -7.0, 2.0, 1.0], 
[3.0, 0.0, -5.0, -1.0, -2.0]], [[-4.0, 5.0, -4.0, 1.0, 3.0], [6.0, 5.0, -6.0, -2.0, -3.0], [5.0, 0.0, -7.0, 3.0, 0.0], [0.0, 
-6.0, -5.0, 4.0, 0.0]], [[-2.0, -7.0, 6.0, -5.0, -2.0], [-3.0, 2.0, 5.0, 2.0, -5.0], [2.0, -3.0, 1.0, 1.0, 3.0], [-3.0, 5.0, 
-5.0, -5.0, -2.0]]], [[[1.0, 4.0, -6.0, 0.0, -7.0], [-7.0, 5.0, -7.0, 1.0, 2.0], [0.0, 0.0, 5.0, -3.0, -1.0], [5.0, 4.0, 0.0, 
-4.0, 0.0]], [[3.0, 0.0, 6.0, 5.0, 4.0], [-1.0, 7.0, 0.0, 2.0, -7.0], [5.0, -2.0, 6.0, 5.0, -4.0], [6.0, -1.0, -2.0, 4.0, 
2.0]], [[-7.0, 0.0, -3.0, -1.0, -5.0], [2.0, 0.0, -5.0, -7.0, -4.0], [7.0, 7.0, -6.0, -6.0, 7.0], [1.0, 3.0, -4.0, 0.0, 2.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-24.0, -34.0, -28.0, 43.0, -94.0], [25.0, -32.0, 8.0, -18.0, 47.0], [-49.0, 22.0, -5.0, 15.0, 
22.0], [-19.0, -13.0, 9.0, 68.0, -13.0]], [[-41.0, -10.0, 66.0, -31.0, 1.0], [-5.0, 82.0, -8.0, -45.0, -20.0], [-24.0, -42.0, 
-14.0, 28.0, -56.0], [-35.0, 22.0, 25.0, -7.0, 11.0]]])+(1.-msk_ref)*numpy.array([[[-25.0, -51.0, 21.0, -72.0, 22.0], [34.0, 
-49.0, 71.0, 3.0, -1.0], [-10.0, -3.0, -47.0, -1.0, 39.0], [-91.0, 3.0, -9.0, -24.0, -22.0]], [[-9.0, 77.0, -92.0, -1.0, 47.0], 
[80.0, -35.0, -40.0, -23.0, 59.0], [-18.0, 29.0, -74.0, -2.0, -10.0], [-38.0, -83.0, 35.0, 49.0, 2.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank1_expandedData_rank3_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([6.0, -2.0])+(1.-msk_arg0)*numpy.array([-3.0, 0.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[4.0, 4.0], [3.0, 6.0]], [[-1.0, 3.0], [6.0, -7.0]], [[-7.0, 5.0], [-5.0, -6.0]], [[-6.0, 
4.0], [5.0, 2.0]], [[-7.0, 0.0], [-2.0, -5.0]], [[-2.0, 5.0], [0.0, 3.0]]])+(1.-msk_arg1)*numpy.array([[[-7.0, -6.0], [-7.0, 
2.0]], [[3.0, 6.0], [2.0, 0.0]], [[-4.0, 4.0], [6.0, 1.0]], [[-3.0, -4.0], [-4.0, -4.0]], [[6.0, 7.0], [0.0, -4.0]], [[7.0, 
0.0], [-1.0, -1.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[24.0, 24.0], [18.0, 36.0]], [[-6.0, 18.0], [36.0, -42.0]], [[-42.0, 30.0], [-30.0, -36.0]], 
[[-36.0, 24.0], [30.0, 12.0]], [[-42.0, 0.0], [-12.0, -30.0]], [[-12.0, 30.0], [0.0, 18.0]]], [[[-8.0, -8.0], [-6.0, -12.0]], 
[[2.0, -6.0], [-12.0, 14.0]], [[14.0, -10.0], [10.0, 12.0]], [[12.0, -8.0], [-10.0, -4.0]], [[14.0, 0.0], [4.0, 10.0]], [[4.0, 
-10.0], [0.0, -6.0]]]])+(1.-msk_ref)*numpy.array([[[[21.0, 18.0], [21.0, -6.0]], [[-9.0, -18.0], [-6.0, 0.0]], [[12.0, -12.0], 
[-18.0, -3.0]], [[9.0, 12.0], [12.0, 12.0]], [[-18.0, -21.0], [0.0, 12.0]], [[-21.0, 0.0], [3.0, 3.0]]], [[[0.0, 0.0], [0.0, 
0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank4_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[0.0, 2.0, 0.0], [-5.0, -1.0, 4.0]])+(1.-msk_arg0)*numpy.array([[1.0, 0.0, -1.0], [-6.0, -3.0, 
0.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-6.0, -7.0], [-1.0, 7.0]], [[0.0, 0.0], [4.0, -4.0]], [[-4.0, -6.0], [-5.0, 4.0]], [[-1.0, 
-6.0], [-3.0, 1.0]], [[0.0, -3.0], [-4.0, 0.0]], [[-5.0, 6.0], [6.0, -4.0]]], [[[-7.0, 5.0], [0.0, 5.0]], [[3.0, -1.0], [7.0, 
-3.0]], [[-6.0, 5.0], [5.0, 0.0]], [[-4.0, 1.0], [-2.0, 5.0]], [[-5.0, 2.0], [-5.0, -3.0]], [[3.0, 7.0], [-3.0, -2.0]]], 
[[[6.0, -3.0], [6.0, -6.0]], [[-1.0, 4.0], [4.0, -2.0]], [[4.0, 5.0], [-2.0, -3.0]], [[0.0, -3.0], [3.0, 3.0]], [[-6.0, -2.0], 
[-4.0, -3.0]], [[5.0, 0.0], [2.0, -5.0]]]])+(1.-msk_arg1)*numpy.array([[[[-5.0, 7.0], [-2.0, -2.0]], [[-2.0, 4.0], [0.0, 
-5.0]], [[5.0, 5.0], [5.0, -7.0]], [[-3.0, 0.0], [0.0, 0.0]], [[-3.0, -4.0], [-6.0, -5.0]], [[0.0, -5.0], [0.0, 7.0]]], [[[6.0, 
-7.0], [4.0, -5.0]], [[0.0, 1.0], [-2.0, 0.0]], [[-3.0, -2.0], [-1.0, -1.0]], [[-4.0, 1.0], [0.0, -4.0]], [[-7.0, -2.0], [-7.0, 
1.0]], [[-2.0, 6.0], [-3.0, -4.0]]], [[[6.0, 0.0], [0.0, 2.0]], [[3.0, 6.0], [-2.0, -7.0]], [[-3.0, 1.0], [-3.0, 2.0]], [[0.0, 
4.0], [-4.0, -5.0]], [[0.0, 4.0], [3.0, 7.0]], [[2.0, 4.0], [0.0, 6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-14.0, 10.0], [0.0, 10.0]], [[6.0, -2.0], [14.0, -6.0]], [[-12.0, 10.0], [10.0, 0.0]], 
[[-8.0, 2.0], [-4.0, 10.0]], [[-10.0, 4.0], [-10.0, -6.0]], [[6.0, 14.0], [-6.0, -4.0]]], [[[61.0, 18.0], [29.0, -64.0]], 
[[-7.0, 17.0], [-11.0, 15.0]], [[42.0, 45.0], [12.0, -32.0]], [[9.0, 17.0], [29.0, 2.0]], [[-19.0, 5.0], [9.0, -9.0]], [[42.0, 
-37.0], [-19.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[-11.0, 7.0], [-2.0, -4.0]], [[-5.0, -2.0], [2.0, 2.0]], [[8.0, 4.0], 
[8.0, -9.0]], [[-3.0, -4.0], [4.0, 5.0]], [[-3.0, -8.0], [-9.0, -12.0]], [[-2.0, -9.0], [0.0, 1.0]]], [[[12.0, -21.0], [0.0, 
27.0]], [[12.0, -27.0], [6.0, 30.0]], [[-21.0, -24.0], [-27.0, 45.0]], [[30.0, -3.0], [0.0, 12.0]], [[39.0, 30.0], [57.0, 
27.0]], [[6.0, 12.0], [9.0, -30.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_float_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[3.0, -3.0, -5.0, 5.0, 0.0], [-1.0, 3.0, 0.0, -3.0, 7.0], [0.0, 7.0, 0.0, -2.0, -3.0], [-5.0, 
2.0, 5.0, 6.0, 5.0]])+(1.-msk_arg0)*numpy.array([[-7.0, 2.0, -1.0, 0.0, 2.0], [-6.0, -4.0, -2.0, 3.0, -5.0], [0.0, -1.0, 6.0, 
0.0, -1.0], [-5.0, -2.0, -7.0, -3.0, 7.0]])
      arg1=-7.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-21.0, 21.0, 35.0, -35.0, -0.0], [7.0, -21.0, -0.0, 21.0, -49.0], [-0.0, -49.0, -0.0, 14.0, 
21.0], [35.0, -14.0, -35.0, -42.0, -35.0]])+(1.-msk_ref)*numpy.array([[49.0, -14.0, 7.0, -0.0, -14.0], [42.0, 28.0, 14.0, 
-21.0, 35.0], [-0.0, 7.0, -42.0, -0.0, 7.0], [35.0, 14.0, 49.0, 21.0, -49.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[5.0, -5.0, 7.0, 2.0, 7.0], [6.0, 1.0, 6.0, -7.0, -6.0], [-4.0, 4.0, -6.0, -7.0, -3.0], [7.0, 
-2.0, 4.0, 0.0, -5.0]])+(1.-msk_arg0)*numpy.array([[-4.0, 3.0, 1.0, 5.0, -4.0], [-4.0, 6.0, -5.0, -5.0, -1.0], [-4.0, 6.0, 0.0, 
-2.0, 0.0], [0.0, -3.0, 6.0, 1.0, 7.0]])
      arg1=numpy.array(0.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, -0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.0, -0.0], [-0.0, 0.0, -0.0, -0.0, -0.0], [0.0, 
-0.0, 0.0, 0.0, -0.0]])+(1.-msk_ref)*numpy.array([[-0.0, 0.0, 0.0, 0.0, -0.0], [-0.0, 0.0, -0.0, -0.0, -0.0], [-0.0, 0.0, 0.0, 
-0.0, 0.0], [0.0, -0.0, 0.0, 0.0, 0.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-2.0, 1.0, -5.0], [0.0, 5.0, 4.0], [0.0, -5.0, -3.0], [6.0, 7.0, 5.0], [0.0, -7.0, 5.0]], 
[[2.0, 0.0, -6.0], [-3.0, 2.0, 5.0], [0.0, 2.0, 5.0], [4.0, -6.0, 0.0], [-6.0, 0.0, 0.0]], [[-3.0, 2.0, -2.0], [-7.0, -4.0, 
-2.0], [5.0, 0.0, -1.0], [-3.0, -3.0, 6.0], [5.0, 7.0, 2.0]], [[-3.0, 0.0, -5.0], [0.0, 0.0, 4.0], [6.0, 2.0, -6.0], [0.0, 
-7.0, -3.0], [5.0, -3.0, -5.0]]])+(1.-msk_arg0)*numpy.array([[[7.0, 5.0, -7.0], [-6.0, -1.0, 2.0], [-4.0, -6.0, 1.0], [-4.0, 
-3.0, 2.0], [-4.0, -3.0, -1.0]], [[-4.0, -5.0, 7.0], [2.0, -2.0, 0.0], [2.0, 3.0, -1.0], [-5.0, 5.0, -5.0], [0.0, 0.0, 1.0]], 
[[-4.0, -7.0, -1.0], [7.0, -5.0, 3.0], [0.0, 0.0, -5.0], [-1.0, 7.0, 6.0], [0.0, -6.0, -1.0]], [[3.0, 5.0, 0.0], [1.0, -5.0, 
7.0], [-3.0, -6.0, 6.0], [0.0, -1.0, -1.0], [-4.0, 3.0, 2.0]]])
      arg1=numpy.array([0.0, 6.0, -7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[41.0, 2.0, -9.0, 7.0, -77.0], [42.0, -23.0, -23.0, -36.0, 0.0], [26.0, -10.0, 7.0, -60.0, 
28.0], [35.0, -28.0, 54.0, -21.0, 17.0]])+(1.-msk_ref)*numpy.array([[79.0, -20.0, -43.0, -32.0, -11.0], [-79.0, -12.0, 25.0, 
65.0, -7.0], [-35.0, -51.0, 35.0, 0.0, -29.0], [30.0, -79.0, -78.0, 1.0, 4.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[0.0, 1.0, 3.0], [2.0, -3.0, 4.0]], [[-6.0, 7.0, -4.0], [-4.0, 3.0, 5.0]], [[-3.0, -5.0, 
3.0], [-3.0, 2.0, 3.0]], [[-6.0, 6.0, 3.0], [4.0, 3.0, 2.0]], [[-5.0, 6.0, 5.0], [0.0, -5.0, 6.0]]], [[[-4.0, 6.0, -4.0], 
[-2.0, -4.0, 0.0]], [[4.0, -1.0, -4.0], [7.0, -5.0, -3.0]], [[-1.0, 3.0, -6.0], [-3.0, -2.0, 4.0]], [[5.0, -3.0, -1.0], [-3.0, 
2.0, -1.0]], [[0.0, -6.0, 1.0], [3.0, 5.0, 2.0]]], [[[-5.0, -3.0, -4.0], [4.0, 3.0, 0.0]], [[4.0, -1.0, -2.0], [-3.0, -1.0, 
6.0]], [[2.0, -3.0, 5.0], [-4.0, 4.0, -4.0]], [[4.0, -6.0, 3.0], [-2.0, 4.0, -1.0]], [[-1.0, -6.0, 1.0], [-5.0, -6.0, 0.0]]], 
[[[-5.0, 3.0, 6.0], [2.0, 7.0, 2.0]], [[5.0, -2.0, 0.0], [0.0, -6.0, 5.0]], [[4.0, 3.0, 0.0], [5.0, 0.0, 2.0]], [[5.0, -4.0, 
-5.0], [-1.0, -4.0, 2.0]], [[1.0, -6.0, -4.0], [5.0, -4.0, -5.0]]]])+(1.-msk_arg0)*numpy.array([[[[0.0, -5.0, -1.0], [5.0, 
-6.0, 6.0]], [[-4.0, 0.0, -7.0], [-7.0, 0.0, -1.0]], [[0.0, 5.0, 2.0], [-2.0, 5.0, 2.0]], [[-2.0, -5.0, 5.0], [-1.0, 7.0, 
-2.0]], [[4.0, 3.0, -7.0], [-6.0, 0.0, 3.0]]], [[[-4.0, -4.0, -3.0], [-4.0, -5.0, -7.0]], [[1.0, 2.0, 6.0], [1.0, 3.0, -5.0]], 
[[5.0, 0.0, 0.0], [5.0, 3.0, -4.0]], [[6.0, -7.0, -4.0], [-4.0, 7.0, 7.0]], [[6.0, 4.0, 7.0], [-2.0, 6.0, 4.0]]], [[[2.0, 3.0, 
1.0], [0.0, 7.0, -6.0]], [[-1.0, 6.0, -6.0], [0.0, -5.0, 0.0]], [[6.0, -2.0, -3.0], [1.0, -2.0, -5.0]], [[4.0, 4.0, 7.0], [7.0, 
-5.0, -7.0]], [[4.0, 2.0, 0.0], [-1.0, -3.0, -2.0]]], [[[3.0, -4.0, 4.0], [0.0, 5.0, -2.0]], [[-5.0, 0.0, -5.0], [-5.0, 6.0, 
-5.0]], [[6.0, -3.0, 3.0], [-7.0, -6.0, 3.0]], [[-4.0, 2.0, 6.0], [-6.0, -2.0, -7.0]], [[-2.0, 5.0, -5.0], [-4.0, 0.0, -3.0]]]])
      arg1=numpy.array([[5.0, -6.0, -3.0], [-3.0, 5.0, 0.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-36.0, -33.0, 25.0, -72.0, -101.0], [-58.0, -8.0, -6.0, 65.0, 49.0], [8.0, 36.0, 45.0, 73.0, 
13.0], [-32.0, 7.0, -13.0, 47.0, 18.0]])+(1.-msk_ref)*numpy.array([[-12.0, 22.0, -5.0, 43.0, 41.0], [0.0, -13.0, 25.0, 131.0, 
21.0], [24.0, -48.0, 38.0, -71.0, -4.0], [52.0, 35.0, 30.0, -42.0, -13.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[6.0, 1.0, 5.0, 7.0, 2.0], [0.0, 5.0, 5.0, 3.0, 2.0], [7.0, 0.0, 3.0, 0.0, 4.0], [-1.0, 5.0, 
-3.0, -6.0, -4.0]])+(1.-msk_arg0)*numpy.array([[2.0, 4.0, 3.0, -3.0, -1.0], [1.0, 6.0, 6.0, -2.0, -3.0], [-2.0, -4.0, 2.0, 0.0, 
7.0], [-4.0, 5.0, -6.0, -6.0, 0.0]])
      arg1=numpy.array([6.0, -3.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[36.0, -18.0], [6.0, -3.0], [30.0, -15.0], [42.0, -21.0], [12.0, -6.0]], [[0.0, 0.0], [30.0, 
-15.0], [30.0, -15.0], [18.0, -9.0], [12.0, -6.0]], [[42.0, -21.0], [0.0, 0.0], [18.0, -9.0], [0.0, 0.0], [24.0, -12.0]], 
[[-6.0, 3.0], [30.0, -15.0], [-18.0, 9.0], [-36.0, 18.0], [-24.0, 12.0]]])+(1.-msk_ref)*numpy.array([[[12.0, -6.0], [24.0, 
-12.0], [18.0, -9.0], [-18.0, 9.0], [-6.0, 3.0]], [[6.0, -3.0], [36.0, -18.0], [36.0, -18.0], [-12.0, 6.0], [-18.0, 9.0]], 
[[-12.0, 6.0], [-24.0, 12.0], [12.0, -6.0], [0.0, 0.0], [42.0, -21.0]], [[-24.0, 12.0], [30.0, -15.0], [-36.0, 18.0], [-36.0, 
18.0], [0.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-5.0, 1.0, -3.0], [-6.0, -3.0, -3.0], [-4.0, 4.0, -1.0], [-5.0, 3.0, -5.0], [-3.0, 1.0, 
5.0]], [[-6.0, -3.0, 4.0], [2.0, -6.0, -1.0], [6.0, 5.0, 0.0], [-1.0, -2.0, 7.0], [1.0, -3.0, -3.0]], [[-5.0, -5.0, -1.0], 
[-3.0, 7.0, -7.0], [0.0, 1.0, 0.0], [-7.0, 4.0, 1.0], [-1.0, 7.0, -6.0]], [[-5.0, 1.0, -2.0], [-2.0, -7.0, -2.0], [7.0, 6.0, 
-6.0], [-4.0, 0.0, 3.0], [-6.0, -1.0, 1.0]]])+(1.-msk_arg0)*numpy.array([[[3.0, -4.0, 0.0], [-1.0, -5.0, -5.0], [-4.0, -1.0, 
6.0], [3.0, -7.0, -7.0], [-6.0, 7.0, -2.0]], [[1.0, -3.0, -4.0], [1.0, -4.0, 1.0], [-5.0, 5.0, 7.0], [6.0, -7.0, -7.0], [-1.0, 
2.0, 7.0]], [[7.0, -7.0, -4.0], [-5.0, -1.0, 3.0], [-7.0, 7.0, 3.0], [-6.0, -7.0, 6.0], [3.0, 0.0, 7.0]], [[-7.0, 0.0, -7.0], 
[0.0, -5.0, 0.0], [6.0, 6.0, 7.0], [5.0, 6.0, -5.0], [7.0, 5.0, -7.0]]])
      arg1=numpy.array([[-3.0, 5.0], [4.0, -1.0], [2.0, -7.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[13.0, -5.0], [0.0, -6.0], [26.0, -17.0], [17.0, 7.0], [23.0, -51.0]], [[14.0, -55.0], [-32.0, 
23.0], [2.0, 25.0], [9.0, -52.0], [-21.0, 29.0]], [[-7.0, -13.0], [23.0, 27.0], [4.0, -1.0], [39.0, -46.0], [19.0, 30.0]], 
[[15.0, -12.0], [-26.0, 11.0], [-9.0, 71.0], [18.0, -41.0], [16.0, -36.0]]])+(1.-msk_ref)*numpy.array([[[-25.0, 19.0], [-27.0, 
35.0], [20.0, -61.0], [-51.0, 71.0], [42.0, -23.0]], [[-23.0, 36.0], [-17.0, 2.0], [49.0, -79.0], [-60.0, 86.0], [25.0, 
-56.0]], [[-57.0, 70.0], [17.0, -45.0], [55.0, -63.0], [2.0, -65.0], [5.0, -34.0]], [[7.0, 14.0], [-20.0, 5.0], [20.0, -25.0], 
[-1.0, 54.0], [-15.0, 79.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[4.0, -4.0, 0.0], [-1.0, 5.0, -3.0]], [[-2.0, 2.0, 7.0], [6.0, 0.0, 7.0]], [[-3.0, 6.0, 
0.0], [-3.0, 4.0, 0.0]], [[0.0, 0.0, -5.0], [-7.0, 6.0, 4.0]], [[-2.0, 5.0, 5.0], [4.0, -6.0, 6.0]]], [[[5.0, 1.0, 0.0], [-5.0, 
7.0, -3.0]], [[5.0, 0.0, 5.0], [-3.0, 7.0, 6.0]], [[-3.0, -1.0, 1.0], [-5.0, 1.0, -4.0]], [[2.0, 6.0, -2.0], [-3.0, -6.0, 
-5.0]], [[5.0, 2.0, 2.0], [-6.0, 1.0, 3.0]]], [[[-2.0, 5.0, 0.0], [-7.0, 4.0, 0.0]], [[2.0, -6.0, 3.0], [4.0, 2.0, -1.0]], 
[[0.0, -4.0, 7.0], [4.0, -3.0, -3.0]], [[4.0, 4.0, -2.0], [1.0, -2.0, -7.0]], [[5.0, 1.0, 7.0], [0.0, 7.0, -7.0]]], [[[-4.0, 
7.0, 6.0], [0.0, 2.0, 5.0]], [[3.0, -1.0, -5.0], [-7.0, 7.0, -3.0]], [[-5.0, 2.0, -5.0], [5.0, 7.0, 3.0]], [[-5.0, -4.0, 1.0], 
[-4.0, -1.0, -6.0]], [[3.0, -1.0, 2.0], [0.0, 3.0, 3.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, 0.0, -1.0], [6.0, 1.0, -1.0]], 
[[0.0, 1.0, 7.0], [5.0, 7.0, 0.0]], [[-1.0, 6.0, 6.0], [1.0, -6.0, 5.0]], [[-2.0, 0.0, 2.0], [0.0, -4.0, -7.0]], [[0.0, -6.0, 
4.0], [7.0, 0.0, 2.0]]], [[[0.0, 7.0, -7.0], [6.0, -1.0, -5.0]], [[4.0, 1.0, 7.0], [0.0, 1.0, 2.0]], [[-4.0, 7.0, -6.0], [-7.0, 
-3.0, 3.0]], [[1.0, 6.0, 2.0], [5.0, -5.0, 2.0]], [[-3.0, 7.0, -2.0], [0.0, 5.0, -5.0]]], [[[1.0, -4.0, 4.0], [-1.0, -6.0, 
7.0]], [[-1.0, 0.0, -5.0], [3.0, -1.0, 6.0]], [[-6.0, 2.0, -2.0], [7.0, 7.0, 0.0]], [[5.0, -6.0, -1.0], [-4.0, 0.0, 3.0]], 
[[4.0, -1.0, 0.0], [-3.0, 5.0, -4.0]]], [[[1.0, -1.0, -7.0], [0.0, -1.0, 7.0]], [[6.0, 3.0, 0.0], [-7.0, -2.0, -2.0]], [[0.0, 
-1.0, -5.0], [-5.0, -7.0, -1.0]], [[-5.0, 4.0, -1.0], [-7.0, 4.0, 0.0]], [[-6.0, 1.0, 6.0], [3.0, 4.0, 3.0]]]])
      arg1=numpy.array([[[3.0, 6.0], [2.0, 6.0], [2.0, 0.0]], [[-3.0, 4.0], [-5.0, -4.0], [1.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-21.0, -15.0], [1.0, 3.0], [-8.0, -10.0], [-15.0, -64.0], [38.0, 40.0]], [[-6.0, -3.0], [5.0, 
-28.0], [-3.0, -36.0], [48.0, 75.0], [39.0, 5.0]], [[5.0, -26.0], [-23.0, -13.0], [6.0, 13.0], [16.0, 81.0], [-11.0, 29.0]], 
[[9.0, -5.0], [-20.0, -35.0], [-68.0, -35.0], [-10.0, -48.0], [-1.0, -9.0]]])+(1.-msk_ref)*numpy.array([[[-47.0, -19.0], 
[-34.0, -2.0], [53.0, 43.0], [11.0, 25.0], [-23.0, -14.0]], [[-18.0, 85.0], [25.0, 20.0], [29.0, -7.0], [31.0, 76.0], [-29.0, 
19.0]], [[43.0, -19.0], [-11.0, -8.0], [-74.0, -24.0], [16.0, -31.0], [-10.0, -2.0]], [[-1.0, -17.0], [53.0, 40.0], [37.0, 
5.0], [-8.0, -50.0], [-30.0, -43.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_array_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[3.0, -4.0, -7.0, -6.0, -2.0], [0.0, 6.0, -2.0, 7.0, 7.0], [-2.0, 4.0, 1.0, 0.0, 2.0], [-7.0, 
-4.0, -5.0, 2.0, 7.0]])+(1.-msk_arg0)*numpy.array([[7.0, -3.0, 5.0, -3.0, -2.0], [2.0, -1.0, -3.0, -5.0, 3.0], [5.0, 5.0, 7.0, 
1.0, 7.0], [5.0, 7.0, -2.0, -5.0, -1.0]])
      arg1=numpy.array([[0.0, 1.0, 5.0, -6.0, -1.0], [-6.0, 0.0, 1.0, 5.0, 0.0], [-4.0, 1.0, 0.0, -2.0, 7.0], [0.0, -3.0, 7.0, 
3.0, -4.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 3.0, 15.0, -18.0, -3.0], [-18.0, 0.0, 3.0, 15.0, 0.0], [-12.0, 3.0, 0.0, -6.0, 21.0], 
[0.0, -9.0, 21.0, 9.0, -12.0]], [[0.0, -4.0, -20.0, 24.0, 4.0], [24.0, 0.0, -4.0, -20.0, 0.0], [16.0, -4.0, 0.0, 8.0, -28.0], 
[0.0, 12.0, -28.0, -12.0, 16.0]], [[0.0, -7.0, -35.0, 42.0, 7.0], [42.0, 0.0, -7.0, -35.0, 0.0], [28.0, -7.0, 0.0, 14.0, 
-49.0], [0.0, 21.0, -49.0, -21.0, 28.0]], [[0.0, -6.0, -30.0, 36.0, 6.0], [36.0, 0.0, -6.0, -30.0, 0.0], [24.0, -6.0, 0.0, 
12.0, -42.0], [0.0, 18.0, -42.0, -18.0, 24.0]], [[0.0, -2.0, -10.0, 12.0, 2.0], [12.0, 0.0, -2.0, -10.0, 0.0], [8.0, -2.0, 0.0, 
4.0, -14.0], [0.0, 6.0, -14.0, -6.0, 8.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 6.0, 30.0, -36.0, -6.0], [-36.0, 0.0, 6.0, 30.0, 0.0], [-24.0, 6.0, 0.0, -12.0, 42.0], [0.0, 
-18.0, 42.0, 18.0, -24.0]], [[0.0, -2.0, -10.0, 12.0, 2.0], [12.0, 0.0, -2.0, -10.0, 0.0], [8.0, -2.0, 0.0, 4.0, -14.0], [0.0, 
6.0, -14.0, -6.0, 8.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 0.0, -14.0, 49.0], [0.0, 
-21.0, 49.0, 21.0, -28.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 0.0, -14.0, 49.0], [0.0, 
-21.0, 49.0, 21.0, -28.0]]], [[[0.0, -2.0, -10.0, 12.0, 2.0], [12.0, 0.0, -2.0, -10.0, 0.0], [8.0, -2.0, 0.0, 4.0, -14.0], 
[0.0, 6.0, -14.0, -6.0, 8.0]], [[0.0, 4.0, 20.0, -24.0, -4.0], [-24.0, 0.0, 4.0, 20.0, 0.0], [-16.0, 4.0, 0.0, -8.0, 28.0], 
[0.0, -12.0, 28.0, 12.0, -16.0]], [[0.0, 1.0, 5.0, -6.0, -1.0], [-6.0, 0.0, 1.0, 5.0, 0.0], [-4.0, 1.0, 0.0, -2.0, 7.0], [0.0, 
-3.0, 7.0, 3.0, -4.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0]], [[0.0, 2.0, 10.0, -12.0, -2.0], [-12.0, 0.0, 2.0, 10.0, 0.0], [-8.0, 2.0, 0.0, -4.0, 14.0], [0.0, -6.0, 14.0, 6.0, 
-8.0]]], [[[0.0, -7.0, -35.0, 42.0, 7.0], [42.0, 0.0, -7.0, -35.0, 0.0], [28.0, -7.0, 0.0, 14.0, -49.0], [0.0, 21.0, -49.0, 
-21.0, 28.0]], [[0.0, -4.0, -20.0, 24.0, 4.0], [24.0, 0.0, -4.0, -20.0, 0.0], [16.0, -4.0, 0.0, 8.0, -28.0], [0.0, 12.0, -28.0, 
-12.0, 16.0]], [[0.0, -5.0, -25.0, 30.0, 5.0], [30.0, 0.0, -5.0, -25.0, 0.0], [20.0, -5.0, 0.0, 10.0, -35.0], [0.0, 15.0, 
-35.0, -15.0, 20.0]], [[0.0, 2.0, 10.0, -12.0, -2.0], [-12.0, 0.0, 2.0, 10.0, 0.0], [-8.0, 2.0, 0.0, -4.0, 14.0], [0.0, -6.0, 
14.0, 6.0, -8.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 0.0, -14.0, 49.0], [0.0, -21.0, 
49.0, 21.0, -28.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 
0.0, -14.0, 49.0], [0.0, -21.0, 49.0, 21.0, -28.0]], [[0.0, -3.0, -15.0, 18.0, 3.0], [18.0, 0.0, -3.0, -15.0, 0.0], [12.0, 
-3.0, 0.0, 6.0, -21.0], [0.0, 9.0, -21.0, -9.0, 12.0]], [[0.0, 5.0, 25.0, -30.0, -5.0], [-30.0, 0.0, 5.0, 25.0, 0.0], [-20.0, 
5.0, 0.0, -10.0, 35.0], [0.0, -15.0, 35.0, 15.0, -20.0]], [[0.0, -3.0, -15.0, 18.0, 3.0], [18.0, 0.0, -3.0, -15.0, 0.0], [12.0, 
-3.0, 0.0, 6.0, -21.0], [0.0, 9.0, -21.0, -9.0, 12.0]], [[0.0, -2.0, -10.0, 12.0, 2.0], [12.0, 0.0, -2.0, -10.0, 0.0], [8.0, 
-2.0, 0.0, 4.0, -14.0], [0.0, 6.0, -14.0, -6.0, 8.0]]], [[[0.0, 2.0, 10.0, -12.0, -2.0], [-12.0, 0.0, 2.0, 10.0, 0.0], [-8.0, 
2.0, 0.0, -4.0, 14.0], [0.0, -6.0, 14.0, 6.0, -8.0]], [[0.0, -1.0, -5.0, 6.0, 1.0], [6.0, 0.0, -1.0, -5.0, 0.0], [4.0, -1.0, 
0.0, 2.0, -7.0], [0.0, 3.0, -7.0, -3.0, 4.0]], [[0.0, -3.0, -15.0, 18.0, 3.0], [18.0, 0.0, -3.0, -15.0, 0.0], [12.0, -3.0, 0.0, 
6.0, -21.0], [0.0, 9.0, -21.0, -9.0, 12.0]], [[0.0, -5.0, -25.0, 30.0, 5.0], [30.0, 0.0, -5.0, -25.0, 0.0], [20.0, -5.0, 0.0, 
10.0, -35.0], [0.0, 15.0, -35.0, -15.0, 20.0]], [[0.0, 3.0, 15.0, -18.0, -3.0], [-18.0, 0.0, 3.0, 15.0, 0.0], [-12.0, 3.0, 0.0, 
-6.0, 21.0], [0.0, -9.0, 21.0, 9.0, -12.0]]], [[[0.0, 5.0, 25.0, -30.0, -5.0], [-30.0, 0.0, 5.0, 25.0, 0.0], [-20.0, 5.0, 0.0, 
-10.0, 35.0], [0.0, -15.0, 35.0, 15.0, -20.0]], [[0.0, 5.0, 25.0, -30.0, -5.0], [-30.0, 0.0, 5.0, 25.0, 0.0], [-20.0, 5.0, 0.0, 
-10.0, 35.0], [0.0, -15.0, 35.0, 15.0, -20.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 0.0, 
-14.0, 49.0], [0.0, -21.0, 49.0, 21.0, -28.0]], [[0.0, 1.0, 5.0, -6.0, -1.0], [-6.0, 0.0, 1.0, 5.0, 0.0], [-4.0, 1.0, 0.0, 
-2.0, 7.0], [0.0, -3.0, 7.0, 3.0, -4.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 0.0, 
-14.0, 49.0], [0.0, -21.0, 49.0, 21.0, -28.0]]], [[[0.0, 5.0, 25.0, -30.0, -5.0], [-30.0, 0.0, 5.0, 25.0, 0.0], [-20.0, 5.0, 
0.0, -10.0, 35.0], [0.0, -15.0, 35.0, 15.0, -20.0]], [[0.0, 7.0, 35.0, -42.0, -7.0], [-42.0, 0.0, 7.0, 35.0, 0.0], [-28.0, 7.0, 
0.0, -14.0, 49.0], [0.0, -21.0, 49.0, 21.0, -28.0]], [[0.0, -2.0, -10.0, 12.0, 2.0], [12.0, 0.0, -2.0, -10.0, 0.0], [8.0, -2.0, 
0.0, 4.0, -14.0], [0.0, 6.0, -14.0, -6.0, 8.0]], [[0.0, -5.0, -25.0, 30.0, 5.0], [30.0, 0.0, -5.0, -25.0, 0.0], [20.0, -5.0, 
0.0, 10.0, -35.0], [0.0, 15.0, -35.0, -15.0, 20.0]], [[0.0, -1.0, -5.0, 6.0, 1.0], [6.0, 0.0, -1.0, -5.0, 0.0], [4.0, -1.0, 
0.0, 2.0, -7.0], [0.0, 3.0, -7.0, -3.0, 4.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[4.0, -5.0, 2.0], [-2.0, 2.0, -3.0], [1.0, 0.0, -5.0], [-3.0, 4.0, -7.0], [-5.0, 0.0, -3.0]], 
[[0.0, -6.0, -5.0], [4.0, 3.0, -4.0], [-1.0, 7.0, 0.0], [-2.0, 1.0, 7.0], [-3.0, 4.0, -4.0]], [[-3.0, -5.0, -5.0], [0.0, -1.0, 
-5.0], [-7.0, 7.0, -7.0], [-5.0, -4.0, -6.0], [6.0, 1.0, 3.0]], [[4.0, 7.0, -6.0], [3.0, 3.0, 1.0], [1.0, 3.0, 1.0], [7.0, 4.0, 
4.0], [0.0, -7.0, -6.0]]])+(1.-msk_arg0)*numpy.array([[[7.0, 5.0, -5.0], [-6.0, -6.0, 3.0], [7.0, -7.0, -4.0], [3.0, -1.0, 
-3.0], [-4.0, -1.0, 1.0]], [[3.0, -5.0, 0.0], [-4.0, -6.0, 7.0], [5.0, 3.0, -7.0], [3.0, 6.0, 6.0], [4.0, -7.0, -1.0]], [[-6.0, 
-3.0, -3.0], [-3.0, 2.0, -4.0], [5.0, -3.0, -3.0], [-2.0, 2.0, -3.0], [-7.0, 0.0, 1.0]], [[0.0, 2.0, 2.0], [-4.0, -4.0, 2.0], 
[-7.0, 5.0, 5.0], [-1.0, 5.0, 0.0], [0.0, -3.0, -6.0]]])
      arg1=numpy.array([[[-5.0, 3.0, 0.0, -1.0, -7.0], [7.0, -7.0, -5.0, 2.0, 2.0], [-6.0, -5.0, -1.0, -2.0, 7.0], [-4.0, -4.0, 
7.0, 0.0, -5.0]], [[2.0, 0.0, -2.0, 0.0, -1.0], [2.0, 4.0, 3.0, 2.0, -2.0], [-6.0, -1.0, 3.0, 3.0, 4.0], [2.0, -7.0, 4.0, 1.0, 
-1.0]], [[0.0, -4.0, -5.0, 5.0, -5.0], [-3.0, -2.0, 0.0, 5.0, -1.0], [0.0, 1.0, -5.0, 4.0, 0.0], [-6.0, 5.0, 3.0, 3.0, 6.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-30.0, 4.0, 0.0, 6.0, -33.0], [12.0, -52.0, -35.0, 8.0, 16.0], [6.0, -13.0, -29.0, -15.0, 
8.0], [-38.0, 29.0, 14.0, 1.0, -3.0]], [[14.0, 6.0, 11.0, -13.0, 27.0], [-1.0, 28.0, 16.0, -15.0, -5.0], [0.0, 5.0, 23.0, -2.0, 
-6.0], [30.0, -21.0, -15.0, -7.0, -10.0]], [[-5.0, 23.0, 25.0, -26.0, 18.0], [22.0, 3.0, -5.0, -23.0, 7.0], [-6.0, -10.0, 24.0, 
-22.0, 7.0], [26.0, -29.0, -8.0, -15.0, -35.0]], [[23.0, 19.0, 27.0, -32.0, 52.0], [8.0, 51.0, 27.0, -33.0, -7.0], [-6.0, 4.0, 
50.0, -10.0, -5.0], [62.0, -51.0, -26.0, -17.0, -31.0]], [[25.0, -3.0, 15.0, -10.0, 50.0], [-26.0, 41.0, 25.0, -25.0, -7.0], 
[30.0, 22.0, 20.0, -2.0, -35.0], [38.0, 5.0, -44.0, -9.0, 7.0]]], [[[-12.0, 20.0, 37.0, -25.0, 31.0], [3.0, -14.0, -18.0, 
-37.0, 17.0], [36.0, 1.0, 7.0, -38.0, -24.0], [18.0, 17.0, -39.0, -21.0, -24.0]], [[-14.0, 28.0, 14.0, -24.0, -11.0], [46.0, 
-8.0, -11.0, -6.0, 6.0], [-42.0, -27.0, 25.0, -15.0, 40.0], [14.0, -57.0, 28.0, -9.0, -47.0]], [[19.0, -3.0, -14.0, 1.0, 0.0], 
[7.0, 35.0, 26.0, 12.0, -16.0], [-36.0, -2.0, 22.0, 23.0, 21.0], [18.0, -45.0, 21.0, 7.0, -2.0]], [[12.0, -34.0, -37.0, 37.0, 
-22.0], [-33.0, 4.0, 13.0, 33.0, -13.0], [6.0, 16.0, -30.0, 35.0, -10.0], [-32.0, 36.0, 11.0, 22.0, 51.0]], [[23.0, 7.0, 12.0, 
-17.0, 37.0], [-1.0, 45.0, 27.0, -18.0, -10.0], [-6.0, 7.0, 35.0, 2.0, -5.0], [44.0, -36.0, -17.0, -8.0, -13.0]]], [[[5.0, 
11.0, 35.0, -22.0, 51.0], [-16.0, 11.0, 0.0, -41.0, 9.0], [48.0, 15.0, 13.0, -29.0, -41.0], [32.0, 22.0, -56.0, -20.0, -10.0]], 
[[-2.0, 20.0, 27.0, -25.0, 26.0], [13.0, 6.0, -3.0, -27.0, 7.0], [6.0, -4.0, 22.0, -23.0, -4.0], [28.0, -18.0, -19.0, -16.0, 
-29.0]], [[49.0, 7.0, 21.0, -28.0, 77.0], [-14.0, 91.0, 56.0, -35.0, -21.0], [0.0, 21.0, 63.0, 7.0, -21.0], [84.0, -56.0, 
-42.0, -14.0, -14.0]], [[17.0, 9.0, 38.0, -25.0, 69.0], [-25.0, 31.0, 13.0, -48.0, 4.0], [54.0, 23.0, 23.0, -26.0, -51.0], 
[48.0, 18.0, -69.0, -22.0, -7.0]], [[-28.0, 6.0, -17.0, 9.0, -58.0], [35.0, -44.0, -27.0, 29.0, 7.0], [-42.0, -28.0, -18.0, 
3.0, 46.0], [-40.0, -16.0, 55.0, 10.0, -13.0]]], [[[-6.0, 36.0, 16.0, -34.0, -5.0], [60.0, 12.0, 1.0, -8.0, 0.0], [-66.0, 
-33.0, 47.0, -11.0, 56.0], [34.0, -95.0, 38.0, -11.0, -63.0]], [[-9.0, 5.0, -11.0, 2.0, -29.0], [24.0, -11.0, -6.0, 17.0, 
-1.0], [-36.0, -17.0, 1.0, 7.0, 33.0], [-12.0, -28.0, 36.0, 6.0, -12.0]], [[1.0, -1.0, -11.0, 4.0, -15.0], [10.0, 3.0, 4.0, 
13.0, -5.0], [-24.0, -7.0, 3.0, 11.0, 19.0], [-4.0, -20.0, 22.0, 6.0, -2.0]], [[-27.0, 5.0, -28.0, 13.0, -73.0], [45.0, -41.0, 
-23.0, 42.0, 2.0], [-66.0, -35.0, -15.0, 14.0, 65.0], [-44.0, -36.0, 77.0, 16.0, -15.0]], [[-14.0, 24.0, 44.0, -30.0, 37.0], 
[4.0, -16.0, -21.0, -44.0, 20.0], [42.0, 1.0, 9.0, -45.0, -28.0], [22.0, 19.0, -46.0, -25.0, 
-29.0]]]])+(1.-msk_ref)*numpy.array([[[[-25.0, 41.0, 15.0, -32.0, -29.0], [74.0, -19.0, -20.0, -1.0, 9.0], [-72.0, -45.0, 33.0, 
-19.0, 69.0], [12.0, -88.0, 54.0, -10.0, -70.0]], [[18.0, -30.0, -3.0, 21.0, 33.0], [-63.0, 12.0, 12.0, -9.0, -3.0], [72.0, 
39.0, -27.0, 6.0, -66.0], [-6.0, 81.0, -57.0, 3.0, 54.0]], [[-49.0, 37.0, 34.0, -27.0, -22.0], [47.0, -69.0, -56.0, -20.0, 
32.0], [0.0, -32.0, -8.0, -51.0, 21.0], [-18.0, 1.0, 9.0, -19.0, -52.0]], [[-17.0, 21.0, 17.0, -18.0, -5.0], [28.0, -19.0, 
-18.0, -11.0, 11.0], [-12.0, -17.0, 9.0, -21.0, 17.0], [4.0, -20.0, 8.0, -10.0, -32.0]], [[18.0, -16.0, -3.0, 9.0, 24.0], 
[-33.0, 22.0, 17.0, -5.0, -7.0], [30.0, 22.0, -4.0, 9.0, -32.0], [8.0, 28.0, -29.0, 2.0, 27.0]]], [[[-25.0, 9.0, 10.0, -3.0, 
-16.0], [11.0, -41.0, -30.0, -4.0, 16.0], [12.0, -10.0, -18.0, -21.0, 1.0], [-22.0, 23.0, 1.0, -5.0, -10.0]], [[8.0, -40.0, 
-23.0, 39.0, -1.0], [-61.0, -10.0, 2.0, 15.0, -3.0], [60.0, 33.0, -49.0, 18.0, -52.0], [-38.0, 93.0, -31.0, 15.0, 68.0]], 
[[-19.0, 43.0, 29.0, -40.0, -3.0], [62.0, -9.0, -16.0, -19.0, 11.0], [-48.0, -35.0, 39.0, -29.0, 47.0], [28.0, -76.0, 26.0, 
-18.0, -70.0]], [[-3.0, -15.0, -42.0, 27.0, -57.0], [15.0, -9.0, 3.0, 48.0, -12.0], [-54.0, -15.0, -15.0, 36.0, 45.0], [-36.0, 
-24.0, 63.0, 24.0, 15.0]], [[-34.0, 16.0, 19.0, -9.0, -16.0], [17.0, -54.0, -41.0, -11.0, 23.0], [18.0, -14.0, -20.0, -33.0, 
0.0], [-24.0, 28.0, -3.0, -10.0, -19.0]]], [[[24.0, -6.0, 21.0, -9.0, 60.0], [-39.0, 36.0, 21.0, -33.0, -3.0], [54.0, 30.0, 
12.0, -9.0, -54.0], [36.0, 30.0, -63.0, -12.0, 15.0]], [[19.0, 7.0, 16.0, -17.0, 39.0], [-5.0, 37.0, 21.0, -22.0, -6.0], [6.0, 
9.0, 29.0, -4.0, -13.0], [40.0, -22.0, -25.0, -10.0, -11.0]], [[-31.0, 27.0, 21.0, -20.0, -17.0], [38.0, -41.0, -34.0, -11.0, 
19.0], [-12.0, -25.0, 1.0, -31.0, 23.0], [-8.0, -14.0, 14.0, -12.0, -40.0]], [[14.0, 6.0, 11.0, -13.0, 27.0], [-1.0, 28.0, 
16.0, -15.0, -5.0], [0.0, 5.0, 23.0, -2.0, -6.0], [30.0, -21.0, -15.0, -7.0, -10.0]], [[35.0, -25.0, -5.0, 12.0, 44.0], [-52.0, 
47.0, 35.0, -9.0, -15.0], [42.0, 36.0, 2.0, 18.0, -49.0], [22.0, 33.0, -46.0, 3.0, 41.0]]], [[[4.0, -8.0, -14.0, 10.0, -12.0], 
[-2.0, 4.0, 6.0, 14.0, -6.0], [-12.0, 0.0, -4.0, 14.0, 8.0], [-8.0, -4.0, 14.0, 8.0, 10.0]], [[12.0, -20.0, -2.0, 14.0, 22.0], 
[-42.0, 8.0, 8.0, -6.0, -2.0], [48.0, 26.0, -18.0, 4.0, -44.0], [-4.0, 54.0, -38.0, 2.0, 36.0]], [[45.0, -41.0, -35.0, 32.0, 
19.0], [-54.0, 59.0, 50.0, 21.0, -29.0], [12.0, 35.0, -3.0, 49.0, -29.0], [8.0, 18.0, -14.0, 20.0, 60.0]], [[15.0, -3.0, -10.0, 
1.0, 2.0], [3.0, 27.0, 20.0, 8.0, -12.0], [-24.0, 0.0, 16.0, 17.0, 13.0], [14.0, -31.0, 13.0, 5.0, 0.0]], [[-6.0, 24.0, 36.0, 
-30.0, 33.0], [12.0, 0.0, -9.0, -36.0, 12.0], [18.0, -3.0, 21.0, -33.0, -12.0], [30.0, -9.0, -30.0, -21.0, -33.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[1.0, -7.0, 6.0], [-3.0, -3.0, -2.0]], [[-3.0, -5.0, 0.0], [1.0, 5.0, 4.0]], [[-6.0, 7.0, 
-7.0], [0.0, 4.0, -7.0]], [[1.0, 0.0, 0.0], [6.0, 3.0, 5.0]], [[6.0, 0.0, -4.0], [6.0, -1.0, -6.0]]], [[[-5.0, 6.0, -5.0], 
[1.0, -6.0, 2.0]], [[-5.0, -2.0, -6.0], [-2.0, 2.0, -1.0]], [[-7.0, -4.0, -1.0], [4.0, -1.0, 3.0]], [[6.0, -2.0, 0.0], [5.0, 
0.0, 3.0]], [[-1.0, 7.0, 0.0], [0.0, 0.0, 4.0]]], [[[-4.0, 4.0, -6.0], [-6.0, -7.0, 0.0]], [[1.0, 3.0, 1.0], [4.0, -6.0, 
-3.0]], [[3.0, 0.0, 7.0], [0.0, 2.0, -3.0]], [[-2.0, 1.0, 6.0], [-6.0, 3.0, 0.0]], [[-3.0, 4.0, 4.0], [0.0, 3.0, 7.0]]], 
[[[0.0, 2.0, -7.0], [-2.0, 6.0, 5.0]], [[6.0, 3.0, -6.0], [2.0, -7.0, 6.0]], [[6.0, 4.0, -7.0], [-7.0, -1.0, -2.0]], [[-2.0, 
7.0, 6.0], [-2.0, 1.0, 0.0]], [[7.0, 7.0, 2.0], [-1.0, 1.0, -4.0]]]])+(1.-msk_arg0)*numpy.array([[[[6.0, 6.0, 0.0], [-5.0, 0.0, 
5.0]], [[-5.0, -4.0, 3.0], [1.0, -4.0, -5.0]], [[4.0, 2.0, 3.0], [2.0, 3.0, 6.0]], [[5.0, -6.0, -7.0], [0.0, -4.0, 0.0]], 
[[-5.0, 0.0, 4.0], [7.0, 5.0, 4.0]]], [[[-2.0, -2.0, 3.0], [3.0, -5.0, -2.0]], [[-1.0, 5.0, 0.0], [1.0, 0.0, 4.0]], [[1.0, 7.0, 
1.0], [0.0, 2.0, 4.0]], [[0.0, -4.0, -6.0], [2.0, -6.0, 4.0]], [[-2.0, -3.0, 6.0], [-4.0, -4.0, 0.0]]], [[[-2.0, -6.0, -4.0], 
[2.0, -6.0, -4.0]], [[-6.0, -3.0, -3.0], [0.0, 0.0, -7.0]], [[-5.0, -3.0, 4.0], [-1.0, 4.0, -1.0]], [[-5.0, -5.0, 0.0], [1.0, 
-1.0, -1.0]], [[0.0, -3.0, -6.0], [5.0, -4.0, -5.0]]], [[[7.0, 5.0, 0.0], [1.0, -4.0, 6.0]], [[0.0, -5.0, -4.0], [4.0, -6.0, 
-5.0]], [[-7.0, 1.0, 0.0], [7.0, 2.0, 6.0]], [[4.0, 0.0, 6.0], [-3.0, 3.0, 6.0]], [[0.0, 1.0, -2.0], [2.0, 4.0, 5.0]]]])
      arg1=numpy.array([[[[4.0, -6.0, -7.0, 2.0, 4.0], [6.0, 7.0, 0.0, 1.0, 0.0], [-3.0, -6.0, -5.0, 0.0, -6.0], [4.0, -1.0, 
3.0, 6.0, -2.0]], [[4.0, 2.0, -3.0, 5.0, 7.0], [0.0, -2.0, -6.0, 4.0, 5.0], [5.0, -1.0, -4.0, 5.0, -6.0], [4.0, -3.0, -7.0, 
3.0, -7.0]], [[3.0, -3.0, -1.0, 0.0, -7.0], [-1.0, -1.0, 1.0, 5.0, 2.0], [-2.0, -7.0, 7.0, 2.0, 2.0], [7.0, -7.0, 5.0, -5.0, 
7.0]]], [[[2.0, 5.0, 7.0, -4.0, 1.0], [7.0, -7.0, -6.0, 6.0, -1.0], [4.0, 2.0, -3.0, 5.0, -3.0], [2.0, 2.0, 7.0, -5.0, -1.0]], 
[[-1.0, 2.0, 3.0, -1.0, -6.0], [0.0, 7.0, -3.0, 5.0, 0.0], [5.0, 7.0, 0.0, -6.0, 2.0], [-7.0, 4.0, -1.0, 6.0, -2.0]], [[-2.0, 
7.0, 6.0, 4.0, -5.0], [6.0, 6.0, -6.0, -5.0, -6.0], [-5.0, 6.0, -4.0, -7.0, -2.0], [0.0, -1.0, 0.0, 1.0, 4.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-5.0, -73.0, -34.0, -26.0, -62.0], [-33.0, 3.0, 87.0, -20.0, -8.0], [-67.0, -80.0, 82.0, 
-6.0, 55.0], [33.0, -38.0, 64.0, -50.0, 90.0]], [[-43.0, 51.0, 82.0, -24.0, -96.0], [13.0, 41.0, -15.0, -12.0, -50.0], [-7.0, 
84.0, 16.0, -78.0, 47.0], [-65.0, 36.0, 28.0, -4.0, 46.0]], [[-7.0, 30.0, -2.0, -9.0, 85.0], [-71.0, -63.0, -19.0, 42.0, 63.0], 
[122.0, 64.0, -19.0, 46.0, 2.0], [-73.0, 57.0, -106.0, 37.0, -122.0]], [[3.0, 65.0, 74.0, -5.0, -33.0], [78.0, 16.0, -75.0, 
27.0, -36.0], [11.0, 57.0, -43.0, -23.0, -28.0], [-5.0, 18.0, 42.0, -1.0, 6.0]], [[37.0, -38.0, -35.0, -35.0, 94.0], [46.0, 
-39.0, -1.0, 47.0, 22.0], [39.0, -39.0, -52.0, 70.0, -52.0], [15.0, 36.0, 41.0, 14.0, -68.0]]], [[[-7.0, 64.0, 23.0, 30.0, 
84.0], [-6.0, -79.0, -41.0, -40.0, 7.0], [19.0, 31.0, -45.0, 47.0, -35.0], [13.0, -2.0, -69.0, -26.0, -48.0]], [[-50.0, 31.0, 
33.0, -18.0, -1.0], [-44.0, -3.0, 18.0, -40.0, -14.0], [24.0, 78.0, 1.0, -37.0, 42.0], [-88.0, 58.0, -47.0, 15.0, -24.0]], 
[[-44.0, 76.0, 105.0, -37.0, -54.0], [5.0, -57.0, -16.0, -24.0, -44.0], [-1.0, 72.0, 20.0, -17.0, 44.0], [-36.0, 27.0, 31.0, 
-72.0, 45.0]], [[20.0, 6.0, 17.0, -6.0, 0.0], [89.0, 29.0, -36.0, 13.0, -33.0], [-23.0, -6.0, -49.0, -6.0, -45.0], [26.0, 7.0, 
67.0, 8.0, 9.0]], [[16.0, 48.0, 10.0, 49.0, 25.0], [18.0, 3.0, -66.0, 7.0, 11.0], [18.0, 23.0, -39.0, 7.0, -44.0], [24.0, 
-24.0, -52.0, 19.0, -31.0]]], [[[-23.0, 6.0, -41.0, 43.0, 90.0], [-60.0, -37.0, 27.0, -89.0, 14.0], [-15.0, 1.0, -20.0, 20.0, 
-8.0], [-5.0, -6.0, -105.0, 6.0, -42.0]], [[39.0, -16.0, -25.0, -5.0, 73.0], [15.0, -88.0, -5.0, 27.0, 31.0], [11.0, -68.0, 
-10.0, 94.0, -40.0], [73.0, -30.0, 21.0, -49.0, -20.0]], [[37.0, -56.0, -40.0, -8.0, -34.0], [-7.0, 10.0, 19.0, 63.0, 32.0], 
[2.0, -71.0, 46.0, 23.0, 6.0], [47.0, -41.0, 42.0, -8.0, 27.0]], [[-1.0, -28.0, -28.0, 22.0, -67.0], [-60.0, 41.0, 27.0, 11.0, 
23.0], [-10.0, -22.0, 66.0, -31.0, 42.0], [5.0, -43.0, -28.0, 9.0, 39.0]], [[-1.0, 69.0, 56.0, 39.0, -65.0], [20.0, 30.0, 
-71.0, 13.0, -14.0], [1.0, 49.0, -1.0, -39.0, -6.0], [11.0, -32.0, -20.0, -1.0, 28.0]]], [[[-33.0, 62.0, 35.0, 32.0, 0.0], 
[23.0, 89.0, -55.0, -34.0, -32.0], [21.0, 115.0, -71.0, -85.0, -18.0], [-87.0, 58.0, -69.0, 92.0, -53.0]], [[17.0, 26.0, -16.0, 
50.0, 101.0], [92.0, 15.0, -51.0, -65.0, -35.0], [-48.0, -6.0, -114.0, 13.0, -98.0], [47.0, -3.0, -12.0, 29.0, -39.0]], [[10.0, 
-58.0, -111.0, 53.0, 110.0], [-18.0, 71.0, 26.0, -50.0, 25.0], [-7.0, -24.0, -66.0, -9.0, -51.0], [-16.0, 15.0, -93.0, 110.0, 
-88.0]], [[33.0, 0.0, -24.0, 38.0, -9.0], [-32.0, -13.0, -27.0, 49.0, 49.0], [26.0, -34.0, 30.0, 31.0, -10.0], [51.0, -61.0, 
-40.0, -5.0, -3.0]], [[67.0, -65.0, -100.0, 36.0, 76.0], [9.0, 23.0, -13.0, 64.0, 64.0], [31.0, -82.0, -30.0, 56.0, -67.0], 
[61.0, -36.0, -26.0, 60.0, -66.0]]]])+(1.-msk_ref)*numpy.array([[[[28.0, -14.0, -65.0, 82.0, 36.0], [31.0, 95.0, -36.0, -25.0, 
5.0], [-33.0, -22.0, -59.0, -30.0, -67.0], [38.0, -39.0, -59.0, 84.0, -29.0]], [[-11.0, -25.0, 9.0, -50.0, -19.0], [-56.0, 
-95.0, 63.0, 5.0, 15.0], [-2.0, -43.0, 79.0, 50.0, 59.0], [15.0, -13.0, 39.0, -91.0, 46.0]], [[22.0, 29.0, 22.0, 31.0, -37.0], 
[71.0, 64.0, -66.0, 24.0, -22.0], [-15.0, 14.0, -37.0, -34.0, -42.0], [28.0, -21.0, 24.0, 29.0, 15.0]], [[-21.0, -29.0, -22.0, 
-16.0, 51.0], [37.0, 26.0, 41.0, -74.0, -44.0], [-51.0, -3.0, -50.0, -20.0, -16.0], [-25.0, 46.0, 26.0, 23.0, -9.0]], [[-7.0, 
91.0, 119.0, -27.0, -91.0], [39.0, -29.0, -77.0, 62.0, -23.0], [40.0, 75.0, 16.0, -15.0, 19.0], [-13.0, 7.0, 49.0, -51.0, 
37.0]]], [[[8.0, -10.0, 11.0, -29.0, 0.0], [-6.0, -81.0, 24.0, 8.0, 5.0], [-13.0, -48.0, 38.0, 55.0, 15.0], [46.0, -25.0, 49.0, 
-80.0, 38.0]], [[10.0, 49.0, 23.0, 35.0, 12.0], [25.0, 0.0, -60.0, 5.0, 0.0], [12.0, 27.0, -34.0, 2.0, -35.0], [18.0, -16.0, 
-31.0, 8.0, -18.0]], [[25.0, 37.0, 1.0, 51.0, 14.0], [29.0, 30.0, -71.0, 24.0, 13.0], [20.0, 18.0, -42.0, -3.0, -50.0], [25.0, 
-25.0, -43.0, 38.0, -32.0]], [[-32.0, 36.0, 38.0, -6.0, 32.0], [44.0, -18.0, 0.0, -84.0, -58.0], [-50.0, 32.0, -48.0, -14.0, 
-14.0], [-12.0, 30.0, 18.0, -24.0, 12.0]], [[-6.0, -40.0, -23.0, 1.0, -51.0], [-46.0, -14.0, 60.0, -28.0, 1.0], [-57.0, -63.0, 
76.0, 1.0, 46.0], [42.0, -55.0, 21.0, -55.0, 79.0]]], [[[-26.0, -18.0, 8.0, -52.0, 36.0], [-18.0, -78.0, 62.0, -44.0, -16.0], 
[-18.0, -16.0, 16.0, 36.0, 30.0], [-14.0, 32.0, 36.0, -60.0, 12.0]], [[-31.0, -10.0, 12.0, -55.0, 11.0], [-75.0, -75.0, 57.0, 
2.0, 21.0], [44.0, 18.0, 49.0, 28.0, 62.0], [-57.0, 43.0, -12.0, -37.0, -16.0]], [[-24.0, 8.0, 39.0, -29.0, -89.0], [-47.0, 
-4.0, 22.0, 22.0, 0.0], [13.0, 25.0, 72.0, -29.0, 69.0], [-34.0, 1.0, 15.0, -31.0, 48.0]], [[-35.0, 16.0, 48.0, -42.0, -43.0], 
[-29.0, -45.0, 33.0, -19.0, -20.0], [-6.0, 24.0, 46.0, -7.0, 57.0], [-31.0, 19.0, 28.0, -57.0, 42.0]], [[-6.0, -6.0, 8.0, 
-51.0, 75.0], [11.0, -81.0, 24.0, -7.0, -2.0], [22.0, -3.0, -25.0, 57.0, -7.0], [-16.0, 50.0, 30.0, -33.0, -38.0]]], [[[42.0, 
7.0, -33.0, 63.0, 58.0], [85.0, 40.0, -60.0, -17.0, -12.0], [-42.0, -37.0, -82.0, 12.0, -95.0], [78.0, -42.0, -3.0, 34.0, 
-18.0]], [[-8.0, -25.0, -1.0, -55.0, 58.0], [2.0, -86.0, 50.0, -21.0, -7.0], [-6.0, -31.0, 0.0, 58.0, 8.0], [2.0, 32.0, 49.0, 
-56.0, -5.0]], [[-24.0, 125.0, 137.0, -15.0, -56.0], [43.0, -50.0, -90.0, 19.0, -38.0], [34.0, 105.0, -14.0, -14.0, 7.0], 
[-24.0, 20.0, 19.0, -56.0, 20.0]], [[13.0, -9.0, -10.0, 41.0, -77.0], [33.0, 100.0, -21.0, 1.0, -21.0], [-51.0, -15.0, 7.0, 
-63.0, -9.0], [31.0, -46.0, 18.0, 33.0, 55.0]], [[-12.0, 61.0, 55.0, 13.0, -26.0], [46.0, 44.0, -62.0, 1.0, -31.0], [12.0, 
75.0, -44.0, -48.0, -18.0], [-34.0, 26.0, -7.0, 32.0, -11.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[0.0, 7.0, 6.0, 0.0, -1.0], [-7.0, -6.0, -5.0, 7.0, -3.0], [3.0, 7.0, 1.0, 0.0, 0.0], [4.0, 
2.0, -3.0, 4.0, -2.0]])+(1.-msk_arg0)*numpy.array([[-5.0, -1.0, 1.0, 4.0, 1.0], [0.0, 2.0, 0.0, 3.0, 1.0], [5.0, 2.0, 1.0, 4.0, 
-5.0], [0.0, -6.0, 2.0, 7.0, 3.0]])
      arg1=Data(-7.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-0.0, -49.0, -42.0, -0.0, 7.0], [49.0, 42.0, 35.0, -49.0, 21.0], [-21.0, -49.0, -7.0, -0.0, 
-0.0], [-28.0, -14.0, 21.0, -28.0, 14.0]])+(1.-msk_ref)*numpy.array([[35.0, 7.0, -7.0, -28.0, -7.0], [-0.0, -14.0, -0.0, -21.0, 
-7.0], [-35.0, -14.0, -7.0, -28.0, 35.0], [-0.0, 42.0, -14.0, -49.0, -21.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=0)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[5.0, 3.0, 3.0], [-4.0, -1.0, 6.0], [5.0, 1.0, 2.0], [-2.0, -5.0, -2.0], [0.0, 2.0, 5.0]], 
[[-3.0, -1.0, -4.0], [5.0, 2.0, 2.0], [0.0, 4.0, -7.0], [-2.0, 5.0, -2.0], [1.0, 4.0, 1.0]], [[0.0, -5.0, -1.0], [-7.0, 1.0, 
3.0], [-3.0, 6.0, 6.0], [0.0, -1.0, -2.0], [1.0, 0.0, -5.0]], [[2.0, -7.0, 2.0], [-7.0, 0.0, -6.0], [-6.0, -7.0, -5.0], [-3.0, 
-4.0, -3.0], [1.0, 0.0, -6.0]]])+(1.-msk_arg0)*numpy.array([[[-4.0, -5.0, 5.0], [0.0, -6.0, 2.0], [7.0, 4.0, -3.0], [2.0, 4.0, 
7.0], [4.0, 5.0, 1.0]], [[-7.0, 6.0, 0.0], [0.0, -5.0, 1.0], [-3.0, 6.0, 0.0], [0.0, -5.0, 7.0], [-5.0, 1.0, 0.0]], [[7.0, 
-1.0, -4.0], [4.0, 3.0, 1.0], [-2.0, 0.0, 7.0], [-5.0, 6.0, 6.0], [7.0, 4.0, 4.0]], [[7.0, 7.0, 7.0], [3.0, -5.0, 0.0], [0.0, 
-2.0, 5.0], [0.0, -3.0, 0.0], [3.0, 2.0, -1.0]]])
      arg1=Data(numpy.array([-1.0, -6.0, 4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-11.0, 34.0, -3.0, 24.0, 8.0], [-7.0, -9.0, -52.0, -36.0, -21.0], [26.0, 13.0, -9.0, -2.0, 
-21.0], [48.0, -17.0, 28.0, 15.0, -25.0]])+(1.-msk_ref)*numpy.array([[54.0, 44.0, -43.0, 2.0, -30.0], [-29.0, 34.0, -33.0, 
58.0, -1.0], [-17.0, -18.0, 30.0, -7.0, -15.0], [-21.0, 27.0, 32.0, 18.0, -19.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-7.0, 0.0, -6.0], [7.0, 2.0, -3.0]], [[0.0, -3.0, -1.0], [7.0, 7.0, -3.0]], [[7.0, -3.0, 
-2.0], [6.0, 3.0, -3.0]], [[3.0, -6.0, 2.0], [-2.0, -3.0, -1.0]], [[-4.0, 0.0, -1.0], [-2.0, -7.0, 1.0]]], [[[4.0, -5.0, 2.0], 
[-4.0, 3.0, 4.0]], [[4.0, -7.0, 3.0], [0.0, 6.0, -3.0]], [[4.0, 3.0, -5.0], [6.0, -1.0, 6.0]], [[-1.0, -5.0, 3.0], [-1.0, -2.0, 
-2.0]], [[-1.0, 7.0, -5.0], [1.0, -5.0, 6.0]]], [[[-7.0, -5.0, 1.0], [0.0, 0.0, 0.0]], [[7.0, 4.0, 0.0], [2.0, 0.0, 4.0]], 
[[7.0, -3.0, -4.0], [-7.0, -5.0, -4.0]], [[-7.0, 6.0, 6.0], [-5.0, -1.0, 3.0]], [[-5.0, 5.0, -7.0], [5.0, 4.0, -5.0]]], [[[1.0, 
-5.0, -5.0], [4.0, 2.0, -6.0]], [[0.0, 1.0, -7.0], [-5.0, 7.0, -7.0]], [[2.0, 0.0, 1.0], [-3.0, -5.0, 0.0]], [[7.0, 2.0, 2.0], 
[3.0, 3.0, 6.0]], [[7.0, 6.0, 4.0], [4.0, -7.0, 3.0]]]])+(1.-msk_arg0)*numpy.array([[[[2.0, -7.0, -4.0], [-3.0, 2.0, 3.0]], 
[[-7.0, -6.0, 0.0], [-3.0, -6.0, 1.0]], [[2.0, -7.0, 6.0], [-3.0, -5.0, 0.0]], [[-2.0, 6.0, -3.0], [-7.0, 2.0, -6.0]], [[5.0, 
-6.0, 6.0], [4.0, 1.0, -1.0]]], [[[-6.0, -6.0, 2.0], [-2.0, 7.0, 4.0]], [[-1.0, 3.0, 2.0], [-1.0, 4.0, -5.0]], [[2.0, -1.0, 
-1.0], [-4.0, -4.0, 4.0]], [[5.0, 0.0, -5.0], [-2.0, -5.0, -1.0]], [[5.0, -1.0, 5.0], [-3.0, -6.0, 3.0]]], [[[-3.0, 0.0, 1.0], 
[-6.0, -4.0, 1.0]], [[6.0, 0.0, 0.0], [0.0, 0.0, 0.0]], [[-4.0, 7.0, 6.0], [-7.0, -4.0, -2.0]], [[0.0, 4.0, -4.0], [-6.0, -6.0, 
4.0]], [[4.0, -1.0, 5.0], [6.0, 7.0, 0.0]]], [[[-4.0, 0.0, -2.0], [0.0, -1.0, 3.0]], [[7.0, -3.0, -4.0], [4.0, 7.0, -5.0]], 
[[3.0, 7.0, 2.0], [-5.0, 4.0, 2.0]], [[5.0, 0.0, 3.0], [-2.0, 3.0, -1.0]], [[-2.0, -2.0, -2.0], [6.0, 2.0, -3.0]]]])
      arg1=Data(numpy.array([[2.0, -5.0, 0.0], [-3.0, -3.0, 7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-62.0, -48.0, -19.0, 44.0, 26.0], [64.0, 4.0, 20.0, 18.0, 17.0], [11.0, 16.0, 37.0, -5.0, 
-97.0], [-33.0, -60.0, 28.0, 28.0, 14.0]])+(1.-msk_ref)*numpy.array([[63.0, 50.0, 63.0, -61.0, 18.0], [31.0, -61.0, 61.0, 24.0, 
63.0], [31.0, 12.0, -24.0, 44.0, -26.0], [16.0, -39.0, -12.0, 0.0, -39.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[6.0, 0.0, 3.0, 0.0, 6.0], [-6.0, -7.0, -5.0, -4.0, -7.0], [3.0, 7.0, 4.0, 1.0, -1.0], [-3.0, 
2.0, 5.0, 3.0, 6.0]])+(1.-msk_arg0)*numpy.array([[-7.0, -2.0, -1.0, 6.0, 6.0], [2.0, 3.0, 7.0, 7.0, -4.0], [7.0, 0.0, 1.0, 2.0, 
-5.0], [-7.0, -5.0, 5.0, 6.0, -4.0]])
      arg1=Data(numpy.array([5.0, 0.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[30.0, 0.0], [0.0, 0.0], [15.0, 0.0], [0.0, 0.0], [30.0, 0.0]], [[-30.0, 0.0], [-35.0, 0.0], 
[-25.0, 0.0], [-20.0, 0.0], [-35.0, 0.0]], [[15.0, 0.0], [35.0, 0.0], [20.0, 0.0], [5.0, 0.0], [-5.0, 0.0]], [[-15.0, 0.0], 
[10.0, 0.0], [25.0, 0.0], [15.0, 0.0], [30.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[-35.0, 0.0], [-10.0, 0.0], [-5.0, 0.0], 
[30.0, 0.0], [30.0, 0.0]], [[10.0, 0.0], [15.0, 0.0], [35.0, 0.0], [35.0, 0.0], [-20.0, 0.0]], [[35.0, 0.0], [0.0, 0.0], [5.0, 
0.0], [10.0, 0.0], [-25.0, 0.0]], [[-35.0, 0.0], [-25.0, 0.0], [25.0, 0.0], [30.0, 0.0], [-20.0, 0.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[4.0, 3.0, -5.0], [-4.0, 5.0, 0.0], [-3.0, 1.0, 0.0], [-3.0, -5.0, 5.0], [6.0, -6.0, 4.0]], 
[[-4.0, 5.0, 6.0], [-2.0, 0.0, 0.0], [-2.0, -1.0, -2.0], [-2.0, -5.0, -3.0], [4.0, 4.0, 4.0]], [[-7.0, 1.0, -6.0], [5.0, -4.0, 
2.0], [-2.0, 2.0, 4.0], [-2.0, -7.0, 6.0], [2.0, -4.0, -7.0]], [[3.0, 0.0, -4.0], [-6.0, -3.0, 5.0], [-3.0, -1.0, -4.0], [-1.0, 
2.0, 5.0], [0.0, 0.0, 0.0]]])+(1.-msk_arg0)*numpy.array([[[-5.0, 7.0, 3.0], [0.0, -5.0, 0.0], [0.0, -7.0, 7.0], [5.0, 4.0, 
3.0], [3.0, 7.0, 4.0]], [[-2.0, -6.0, 7.0], [-4.0, -5.0, 2.0], [4.0, -1.0, 1.0], [3.0, 6.0, 2.0], [-6.0, -7.0, -3.0]], [[6.0, 
-7.0, 2.0], [0.0, 3.0, 2.0], [6.0, -7.0, 7.0], [1.0, 3.0, 1.0], [-1.0, 0.0, -6.0]], [[-3.0, -2.0, 1.0], [-6.0, -1.0, -6.0], 
[-3.0, 1.0, -1.0], [-1.0, -4.0, 6.0], [7.0, -2.0, -6.0]]])
      arg1=Data(numpy.array([[3.0, 6.0], [7.0, 7.0], [7.0, 7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-2.0, 10.0], [23.0, 11.0], [-2.0, -11.0], [-9.0, -18.0], [4.0, 22.0]], [[65.0, 53.0], [-6.0, 
-12.0], [-27.0, -33.0], [-62.0, -68.0], [68.0, 80.0]], [[-56.0, -77.0], [1.0, 16.0], [36.0, 30.0], [-13.0, -19.0], [-71.0, 
-65.0]], [[-19.0, -10.0], [-4.0, -22.0], [-44.0, -53.0], [46.0, 43.0], [0.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[55.0, 40.0], 
[-35.0, -35.0], [0.0, 0.0], [64.0, 79.0], [86.0, 95.0]], [[1.0, -5.0], [-33.0, -45.0], [12.0, 24.0], [65.0, 74.0], [-88.0, 
-106.0]], [[-17.0, 1.0], [35.0, 35.0], [18.0, 36.0], [31.0, 34.0], [-45.0, -48.0]], [[-16.0, -25.0], [-67.0, -85.0], [-9.0, 
-18.0], [11.0, 8.0], [-35.0, -14.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[1.0, -3.0, 7.0], [-3.0, 0.0, 6.0]], [[-1.0, 7.0, -3.0], [-7.0, -7.0, 2.0]], [[2.0, -6.0, 
1.0], [-6.0, -2.0, 6.0]], [[0.0, 7.0, 4.0], [3.0, 7.0, 7.0]], [[-4.0, 4.0, -5.0], [-4.0, -3.0, -5.0]]], [[[-3.0, 0.0, -5.0], 
[6.0, 4.0, 1.0]], [[7.0, 1.0, -4.0], [0.0, 1.0, 0.0]], [[-7.0, 4.0, 4.0], [5.0, -3.0, 5.0]], [[6.0, -4.0, -4.0], [7.0, 0.0, 
-5.0]], [[0.0, 4.0, 1.0], [7.0, 3.0, 6.0]]], [[[7.0, 1.0, 0.0], [-6.0, -5.0, -7.0]], [[-7.0, -4.0, -2.0], [5.0, 5.0, 1.0]], 
[[0.0, -7.0, 7.0], [-5.0, -7.0, 4.0]], [[0.0, 0.0, 6.0], [-2.0, 3.0, 1.0]], [[7.0, 7.0, 0.0], [-7.0, -2.0, 0.0]]], [[[-1.0, 
0.0, -4.0], [0.0, -7.0, 5.0]], [[6.0, -2.0, -4.0], [-1.0, -7.0, -1.0]], [[1.0, 7.0, -6.0], [2.0, -4.0, -1.0]], [[0.0, 2.0, 
-2.0], [3.0, 3.0, 4.0]], [[-2.0, -2.0, 7.0], [-5.0, -7.0, 3.0]]]])+(1.-msk_arg0)*numpy.array([[[[-4.0, 1.0, 0.0], [6.0, -5.0, 
0.0]], [[1.0, -6.0, 5.0], [-7.0, 1.0, -7.0]], [[3.0, 5.0, -1.0], [-7.0, 3.0, 4.0]], [[4.0, -5.0, 3.0], [-6.0, -7.0, -2.0]], 
[[1.0, -4.0, 5.0], [4.0, -2.0, 3.0]]], [[[3.0, -3.0, -4.0], [2.0, -4.0, -1.0]], [[5.0, 2.0, 4.0], [2.0, 5.0, 0.0]], [[-3.0, 
1.0, 3.0], [-6.0, -4.0, 5.0]], [[-4.0, 0.0, 1.0], [-1.0, 4.0, -5.0]], [[-1.0, -3.0, -2.0], [0.0, 4.0, 7.0]]], [[[-5.0, -2.0, 
6.0], [-6.0, -5.0, -7.0]], [[4.0, -1.0, -1.0], [-2.0, -6.0, -3.0]], [[-6.0, -4.0, 7.0], [0.0, -7.0, -5.0]], [[2.0, -2.0, 0.0], 
[1.0, -1.0, 5.0]], [[7.0, -7.0, -4.0], [-6.0, 5.0, 3.0]]], [[[-7.0, 0.0, 1.0], [-5.0, -6.0, 4.0]], [[-4.0, -1.0, -2.0], [6.0, 
-3.0, 2.0]], [[0.0, 5.0, -5.0], [-2.0, 3.0, 5.0]], [[-2.0, 6.0, -5.0], [-6.0, -4.0, 0.0]], [[4.0, -7.0, 1.0], [-6.0, 4.0, 
0.0]]]])
      arg1=Data(numpy.array([[[-5.0, 5.0], [-4.0, -6.0], [-2.0, -4.0]], [[-3.0, 1.0], [-7.0, -3.0], [1.0, 
-3.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, -26.0], [55.0, -27.0], [50.0, 24.0], [-87.0, -97.0], [42.0, -4.0]], [[-20.0, -4.0], 
[-38.0, 42.0], [22.0, -76.0], [-32.0, 92.0], [-54.0, -48.0]], [[7.0, 59.0], [6.0, -16.0], [82.0, 18.0], [-26.0, -38.0], [-28.0, 
-8.0]], [[67.0, 17.0], [37.0, 81.0], [0.0, 4.0], [-30.0, -22.0], [71.0, -19.0]]])+(1.-msk_ref)*numpy.array([[[33.0, -5.0], 
[16.0, 32.0], [-29.0, -39.0], [59.0, 59.0], [6.0, 10.0]], [[26.0, 66.0], [-82.0, -16.0], [56.0, -42.0], [-12.0, -22.0], [0.0, 
-12.0]], [[67.0, -7.0], [31.0, 55.0], [76.0, 2.0], [7.0, 11.0], [-13.0, 63.0]], [[94.0, -38.0], [33.0, 3.0], [-20.0, -36.0], 
[42.0, -20.0], [-4.0, 40.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_constData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[1.0, -1.0, 6.0, 6.0, -7.0], [6.0, 1.0, 5.0, 2.0, -4.0], [0.0, -6.0, 2.0, -2.0, 0.0], [-5.0, 
-7.0, 0.0, 0.0, -3.0]])+(1.-msk_arg0)*numpy.array([[-2.0, -5.0, 5.0, 0.0, 7.0], [0.0, 0.0, 6.0, 6.0, 4.0], [1.0, -6.0, -7.0, 
-6.0, 6.0], [3.0, -4.0, 5.0, -3.0, 0.0]])
      arg1=Data(numpy.array([[-5.0, 5.0, -4.0, 6.0, -7.0], [-5.0, 2.0, 0.0, 6.0, 2.0], [0.0, 3.0, -3.0, 1.0, -7.0], [3.0, -2.0, 
-7.0, -2.0, 0.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-5.0, 5.0, -4.0, 6.0, -7.0], [-5.0, 2.0, 0.0, 6.0, 2.0], [0.0, 3.0, -3.0, 1.0, -7.0], [3.0, 
-2.0, -7.0, -2.0, 0.0]], [[5.0, -5.0, 4.0, -6.0, 7.0], [5.0, -2.0, 0.0, -6.0, -2.0], [0.0, -3.0, 3.0, -1.0, 7.0], [-3.0, 2.0, 
7.0, 2.0, 0.0]], [[-30.0, 30.0, -24.0, 36.0, -42.0], [-30.0, 12.0, 0.0, 36.0, 12.0], [0.0, 18.0, -18.0, 6.0, -42.0], [18.0, 
-12.0, -42.0, -12.0, 0.0]], [[-30.0, 30.0, -24.0, 36.0, -42.0], [-30.0, 12.0, 0.0, 36.0, 12.0], [0.0, 18.0, -18.0, 6.0, -42.0], 
[18.0, -12.0, -42.0, -12.0, 0.0]], [[35.0, -35.0, 28.0, -42.0, 49.0], [35.0, -14.0, 0.0, -42.0, -14.0], [0.0, -21.0, 21.0, 
-7.0, 49.0], [-21.0, 14.0, 49.0, 14.0, 0.0]]], [[[-30.0, 30.0, -24.0, 36.0, -42.0], [-30.0, 12.0, 0.0, 36.0, 12.0], [0.0, 18.0, 
-18.0, 6.0, -42.0], [18.0, -12.0, -42.0, -12.0, 0.0]], [[-5.0, 5.0, -4.0, 6.0, -7.0], [-5.0, 2.0, 0.0, 6.0, 2.0], [0.0, 3.0, 
-3.0, 1.0, -7.0], [3.0, -2.0, -7.0, -2.0, 0.0]], [[-25.0, 25.0, -20.0, 30.0, -35.0], [-25.0, 10.0, 0.0, 30.0, 10.0], [0.0, 
15.0, -15.0, 5.0, -35.0], [15.0, -10.0, -35.0, -10.0, 0.0]], [[-10.0, 10.0, -8.0, 12.0, -14.0], [-10.0, 4.0, 0.0, 12.0, 4.0], 
[0.0, 6.0, -6.0, 2.0, -14.0], [6.0, -4.0, -14.0, -4.0, 0.0]], [[20.0, -20.0, 16.0, -24.0, 28.0], [20.0, -8.0, 0.0, -24.0, 
-8.0], [0.0, -12.0, 12.0, -4.0, 28.0], [-12.0, 8.0, 28.0, 8.0, 0.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[30.0, -30.0, 24.0, -36.0, 42.0], [30.0, -12.0, 0.0, -36.0, -12.0], 
[0.0, -18.0, 18.0, -6.0, 42.0], [-18.0, 12.0, 42.0, 12.0, 0.0]], [[-10.0, 10.0, -8.0, 12.0, -14.0], [-10.0, 4.0, 0.0, 12.0, 
4.0], [0.0, 6.0, -6.0, 2.0, -14.0], [6.0, -4.0, -14.0, -4.0, 0.0]], [[10.0, -10.0, 8.0, -12.0, 14.0], [10.0, -4.0, 0.0, -12.0, 
-4.0], [0.0, -6.0, 6.0, -2.0, 14.0], [-6.0, 4.0, 14.0, 4.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 
0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[25.0, -25.0, 20.0, -30.0, 35.0], [25.0, -10.0, 0.0, -30.0, -10.0], [0.0, 
-15.0, 15.0, -5.0, 35.0], [-15.0, 10.0, 35.0, 10.0, 0.0]], [[35.0, -35.0, 28.0, -42.0, 49.0], [35.0, -14.0, 0.0, -42.0, -14.0], 
[0.0, -21.0, 21.0, -7.0, 49.0], [-21.0, 14.0, 49.0, 14.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 
0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[15.0, -15.0, 12.0, -18.0, 21.0], [15.0, -6.0, 0.0, -18.0, -6.0], [0.0, -9.0, 9.0, -3.0, 
21.0], [-9.0, 6.0, 21.0, 6.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[10.0, -10.0, 8.0, -12.0, 14.0], [10.0, -4.0, 0.0, -12.0, 
-4.0], [0.0, -6.0, 6.0, -2.0, 14.0], [-6.0, 4.0, 14.0, 4.0, 0.0]], [[25.0, -25.0, 20.0, -30.0, 35.0], [25.0, -10.0, 0.0, -30.0, 
-10.0], [0.0, -15.0, 15.0, -5.0, 35.0], [-15.0, 10.0, 35.0, 10.0, 0.0]], [[-25.0, 25.0, -20.0, 30.0, -35.0], [-25.0, 10.0, 0.0, 
30.0, 10.0], [0.0, 15.0, -15.0, 5.0, -35.0], [15.0, -10.0, -35.0, -10.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[-35.0, 35.0, -28.0, 42.0, -49.0], [-35.0, 14.0, 0.0, 42.0, 
14.0], [0.0, 21.0, -21.0, 7.0, -49.0], [21.0, -14.0, -49.0, -14.0, 0.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[-30.0, 30.0, -24.0, 36.0, -42.0], [-30.0, 12.0, 0.0, 36.0, 12.0], [0.0, 18.0, 
-18.0, 6.0, -42.0], [18.0, -12.0, -42.0, -12.0, 0.0]], [[-30.0, 30.0, -24.0, 36.0, -42.0], [-30.0, 12.0, 0.0, 36.0, 12.0], 
[0.0, 18.0, -18.0, 6.0, -42.0], [18.0, -12.0, -42.0, -12.0, 0.0]], [[-20.0, 20.0, -16.0, 24.0, -28.0], [-20.0, 8.0, 0.0, 24.0, 
8.0], [0.0, 12.0, -12.0, 4.0, -28.0], [12.0, -8.0, -28.0, -8.0, 0.0]]], [[[-5.0, 5.0, -4.0, 6.0, -7.0], [-5.0, 2.0, 0.0, 6.0, 
2.0], [0.0, 3.0, -3.0, 1.0, -7.0], [3.0, -2.0, -7.0, -2.0, 0.0]], [[30.0, -30.0, 24.0, -36.0, 42.0], [30.0, -12.0, 0.0, -36.0, 
-12.0], [0.0, -18.0, 18.0, -6.0, 42.0], [-18.0, 12.0, 42.0, 12.0, 0.0]], [[35.0, -35.0, 28.0, -42.0, 49.0], [35.0, -14.0, 0.0, 
-42.0, -14.0], [0.0, -21.0, 21.0, -7.0, 49.0], [-21.0, 14.0, 49.0, 14.0, 0.0]], [[30.0, -30.0, 24.0, -36.0, 42.0], [30.0, 
-12.0, 0.0, -36.0, -12.0], [0.0, -18.0, 18.0, -6.0, 42.0], [-18.0, 12.0, 42.0, 12.0, 0.0]], [[-30.0, 30.0, -24.0, 36.0, -42.0], 
[-30.0, 12.0, 0.0, 36.0, 12.0], [0.0, 18.0, -18.0, 6.0, -42.0], [18.0, -12.0, -42.0, -12.0, 0.0]]], [[[-15.0, 15.0, -12.0, 
18.0, -21.0], [-15.0, 6.0, 0.0, 18.0, 6.0], [0.0, 9.0, -9.0, 3.0, -21.0], [9.0, -6.0, -21.0, -6.0, 0.0]], [[20.0, -20.0, 16.0, 
-24.0, 28.0], [20.0, -8.0, 0.0, -24.0, -8.0], [0.0, -12.0, 12.0, -4.0, 28.0], [-12.0, 8.0, 28.0, 8.0, 0.0]], [[-25.0, 25.0, 
-20.0, 30.0, -35.0], [-25.0, 10.0, 0.0, 30.0, 10.0], [0.0, 15.0, -15.0, 5.0, -35.0], [15.0, -10.0, -35.0, -10.0, 0.0]], [[15.0, 
-15.0, 12.0, -18.0, 21.0], [15.0, -6.0, 0.0, -18.0, -6.0], [0.0, -9.0, 9.0, -3.0, 21.0], [-9.0, 6.0, 21.0, 6.0, 0.0]], [[0.0, 
0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[5.0, -1.0, 0.0], [0.0, -2.0, 5.0], [-1.0, -6.0, -5.0], [-1.0, -6.0, 3.0], [-1.0, -3.0, 
1.0]], [[6.0, 0.0, 5.0], [3.0, 0.0, -7.0], [-1.0, 3.0, 4.0], [5.0, -6.0, -1.0], [-3.0, 5.0, -6.0]], [[1.0, -4.0, -3.0], [-3.0, 
4.0, 1.0], [5.0, 5.0, 1.0], [-3.0, -6.0, -4.0], [-2.0, 0.0, 6.0]], [[2.0, -4.0, -1.0], [5.0, -4.0, 0.0], [5.0, -7.0, 3.0], 
[1.0, 7.0, -1.0], [0.0, -7.0, -3.0]]])+(1.-msk_arg0)*numpy.array([[[6.0, 0.0, -6.0], [4.0, -2.0, -4.0], [4.0, 5.0, 4.0], [5.0, 
-1.0, 0.0], [4.0, -2.0, -2.0]], [[6.0, 0.0, -1.0], [3.0, 3.0, 2.0], [7.0, 2.0, -5.0], [4.0, -2.0, 5.0], [0.0, 5.0, -6.0]], 
[[-4.0, -1.0, -1.0], [7.0, -7.0, 7.0], [3.0, 0.0, 5.0], [-2.0, -6.0, 3.0], [7.0, 1.0, -7.0]], [[-7.0, 4.0, 2.0], [6.0, -2.0, 
5.0], [5.0, -4.0, 0.0], [4.0, 0.0, -6.0], [5.0, 7.0, 5.0]]])
      arg1=Data(numpy.array([[[-6.0, -7.0, 1.0, -5.0, -5.0], [0.0, -5.0, 2.0, -1.0, 6.0], [0.0, 0.0, -3.0, 1.0, -6.0], [0.0, 
3.0, -4.0, 4.0, 0.0]], [[-1.0, 2.0, -2.0, -3.0, -3.0], [2.0, 4.0, 2.0, 6.0, -1.0], [3.0, -2.0, -1.0, 2.0, 6.0], [3.0, 4.0, 
-6.0, 2.0, 2.0]], [[-5.0, -1.0, 3.0, 4.0, 6.0], [1.0, 4.0, 3.0, -1.0, -7.0], [-5.0, -3.0, 1.0, 1.0, 4.0], [-6.0, -3.0, -1.0, 
-6.0, 0.0]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-29.0, -37.0, 7.0, -22.0, -22.0], [-2.0, -29.0, 8.0, -11.0, 31.0], [-3.0, 2.0, -14.0, 3.0, 
-36.0], [-3.0, 11.0, -14.0, 18.0, -2.0]], [[-23.0, -9.0, 19.0, 26.0, 36.0], [1.0, 12.0, 11.0, -17.0, -33.0], [-31.0, -11.0, 
7.0, 1.0, 8.0], [-36.0, -23.0, 7.0, -34.0, -4.0]], [[37.0, 0.0, -4.0, 3.0, -7.0], [-17.0, -39.0, -29.0, -30.0, 35.0], [7.0, 
27.0, 4.0, -18.0, -50.0], [12.0, -12.0, 45.0, 14.0, -12.0]], [[-3.0, -8.0, 20.0, 35.0, 41.0], [-9.0, -7.0, -5.0, -38.0, -21.0], 
[-33.0, 3.0, 12.0, -10.0, -18.0], [-36.0, -36.0, 37.0, -34.0, -12.0]], [[4.0, 0.0, 8.0, 18.0, 20.0], [-5.0, -3.0, -5.0, -18.0, 
-10.0], [-14.0, 3.0, 7.0, -6.0, -8.0], [-15.0, -18.0, 21.0, -16.0, -6.0]]], [[[-61.0, -47.0, 21.0, -10.0, 0.0], [5.0, -10.0, 
27.0, -11.0, 1.0], [-25.0, -15.0, -13.0, 11.0, -16.0], [-30.0, 3.0, -29.0, -6.0, 0.0]], [[17.0, -14.0, -18.0, -43.0, -57.0], 
[-7.0, -43.0, -15.0, 4.0, 67.0], [35.0, 21.0, -16.0, -4.0, -46.0], [42.0, 30.0, -5.0, 54.0, 0.0]], [[-17.0, 9.0, 5.0, 12.0, 
20.0], [10.0, 33.0, 16.0, 15.0, -37.0], [-11.0, -18.0, 4.0, 9.0, 40.0], [-15.0, -3.0, -18.0, -22.0, 6.0]], [[-19.0, -46.0, 
14.0, -11.0, -13.0], [-13.0, -53.0, -5.0, -40.0, 43.0], [-13.0, 15.0, -10.0, -8.0, -70.0], [-12.0, -6.0, 17.0, 14.0, -12.0]], 
[[43.0, 37.0, -31.0, -24.0, -36.0], [4.0, 11.0, -14.0, 39.0, 19.0], [45.0, 8.0, -2.0, 1.0, 24.0], [51.0, 29.0, -12.0, 34.0, 
10.0]]], [[[13.0, -12.0, 0.0, -5.0, -11.0], [-11.0, -33.0, -15.0, -22.0, 31.0], [3.0, 17.0, -2.0, -10.0, -42.0], [6.0, -4.0, 
23.0, 14.0, -8.0]], [[9.0, 28.0, -8.0, 7.0, 9.0], [9.0, 35.0, 5.0, 26.0, -29.0], [7.0, -11.0, 6.0, 6.0, 46.0], [6.0, 4.0, 
-13.0, -10.0, 8.0]], [[-40.0, -26.0, -2.0, -36.0, -34.0], [11.0, -1.0, 23.0, 24.0, 18.0], [10.0, -13.0, -19.0, 16.0, 4.0], 
[9.0, 32.0, -51.0, 24.0, 10.0]], [[44.0, 13.0, -3.0, 17.0, 9.0], [-16.0, -25.0, -30.0, -29.0, 16.0], [2.0, 24.0, 11.0, -19.0, 
-34.0], [6.0, -21.0, 52.0, 0.0, -12.0]], [[-18.0, 8.0, 16.0, 34.0, 46.0], [6.0, 34.0, 14.0, -4.0, -54.0], [-30.0, -18.0, 12.0, 
4.0, 36.0], [-36.0, -24.0, 2.0, -44.0, 0.0]]], [[[-3.0, -21.0, 7.0, -2.0, -4.0], [-9.0, -30.0, -7.0, -25.0, 23.0], [-7.0, 11.0, 
-3.0, -7.0, -40.0], [-6.0, -7.0, 17.0, 6.0, -8.0]], [[-26.0, -43.0, 13.0, -13.0, -13.0], [-8.0, -41.0, 2.0, -29.0, 34.0], 
[-12.0, 8.0, -11.0, -3.0, -54.0], [-12.0, -1.0, 4.0, 12.0, -8.0]], [[-38.0, -52.0, 28.0, 8.0, 14.0], [-11.0, -41.0, 5.0, -50.0, 
16.0], [-36.0, 5.0, -5.0, -6.0, -60.0], [-39.0, -22.0, 19.0, -12.0, -14.0]], [[-8.0, 8.0, -16.0, -30.0, -32.0], [13.0, 19.0, 
13.0, 42.0, 6.0], [26.0, -11.0, -11.0, 14.0, 32.0], [27.0, 34.0, -45.0, 24.0, 14.0]], [[22.0, -11.0, 5.0, 9.0, 3.0], [-17.0, 
-40.0, -23.0, -39.0, 28.0], [-6.0, 23.0, 4.0, -17.0, -54.0], [-3.0, -19.0, 45.0, 4.0, 
-14.0]]]])+(1.-msk_ref)*numpy.array([[[[-6.0, -36.0, -12.0, -54.0, -66.0], [-6.0, -54.0, -6.0, 0.0, 78.0], [30.0, 18.0, -24.0, 
0.0, -60.0], [36.0, 36.0, -18.0, 60.0, 0.0]], [[-2.0, -28.0, -4.0, -30.0, -38.0], [-8.0, -44.0, -8.0, -12.0, 54.0], [14.0, 
16.0, -14.0, -4.0, -52.0], [18.0, 16.0, 0.0, 36.0, -4.0]], [[-49.0, -22.0, 6.0, -19.0, -11.0], [14.0, 16.0, 30.0, 22.0, -9.0], 
[-5.0, -22.0, -13.0, 18.0, 22.0], [-9.0, 20.0, -50.0, 2.0, 10.0]], [[-29.0, -37.0, 7.0, -22.0, -22.0], [-2.0, -29.0, 8.0, 
-11.0, 31.0], [-3.0, 2.0, -14.0, 3.0, -36.0], [-3.0, 11.0, -14.0, 18.0, -2.0]], [[-12.0, -30.0, 2.0, -22.0, -26.0], [-6.0, 
-36.0, -2.0, -14.0, 40.0], [4.0, 10.0, -12.0, -2.0, -44.0], [6.0, 10.0, -2.0, 24.0, -4.0]]], [[[-31.0, -41.0, 3.0, -34.0, 
-36.0], [-1.0, -34.0, 9.0, -5.0, 43.0], [5.0, 3.0, -19.0, 5.0, -40.0], [6.0, 21.0, -23.0, 30.0, 0.0]], [[-31.0, -17.0, 3.0, 
-16.0, -12.0], [8.0, 5.0, 18.0, 13.0, 1.0], [-1.0, -12.0, -10.0, 11.0, 8.0], [-3.0, 15.0, -32.0, 6.0, 6.0]], [[-19.0, -40.0, 
-12.0, -61.0, -71.0], [-1.0, -47.0, 3.0, 10.0, 75.0], [31.0, 11.0, -28.0, 6.0, -50.0], [36.0, 44.0, -35.0, 62.0, 4.0]], 
[[-47.0, -37.0, 23.0, 6.0, 16.0], [1.0, -8.0, 19.0, -21.0, -9.0], [-31.0, -11.0, -5.0, 5.0, -16.0], [-36.0, -11.0, -9.0, -18.0, 
-4.0]], [[25.0, 16.0, -28.0, -39.0, -51.0], [4.0, -4.0, -8.0, 36.0, 37.0], [45.0, 8.0, -11.0, 4.0, 6.0], [51.0, 38.0, -24.0, 
46.0, 10.0]]], [[[30.0, 27.0, -5.0, 19.0, 17.0], [-3.0, 12.0, -13.0, -1.0, -16.0], [2.0, 5.0, 12.0, -7.0, 14.0], [3.0, -13.0, 
23.0, -12.0, -2.0]], [[-70.0, -70.0, 42.0, 14.0, 28.0], [-7.0, -35.0, 21.0, -56.0, 0.0], [-56.0, -7.0, -7.0, 0.0, -56.0], 
[-63.0, -28.0, 7.0, -28.0, -14.0]], [[-43.0, -26.0, 18.0, 5.0, 15.0], [5.0, 5.0, 21.0, -8.0, -17.0], [-25.0, -15.0, -4.0, 8.0, 
2.0], [-30.0, -6.0, -17.0, -18.0, 0.0]], [[3.0, -1.0, 19.0, 40.0, 46.0], [-9.0, -2.0, -7.0, -37.0, -27.0], [-33.0, 3.0, 15.0, 
-11.0, -12.0], [-36.0, -39.0, 41.0, -38.0, -12.0]], [[-8.0, -40.0, -16.0, -66.0, -80.0], [-5.0, -59.0, -5.0, 6.0, 90.0], [38.0, 
19.0, -29.0, 2.0, -64.0], [45.0, 46.0, -27.0, 72.0, 2.0]]], [[[28.0, 55.0, -9.0, 31.0, 35.0], [10.0, 59.0, 0.0, 29.0, -60.0], 
[2.0, -14.0, 19.0, 3.0, 74.0], [0.0, -11.0, 2.0, -32.0, 8.0]], [[-59.0, -51.0, 25.0, -4.0, 6.0], [1.0, -18.0, 23.0, -23.0, 
3.0], [-31.0, -11.0, -11.0, 7.0, -28.0], [-36.0, -5.0, -17.0, -10.0, -4.0]], [[-26.0, -43.0, 13.0, -13.0, -13.0], [-8.0, -41.0, 
2.0, -29.0, 34.0], [-12.0, 8.0, -11.0, -3.0, -54.0], [-12.0, -1.0, 4.0, 12.0, -8.0]], [[6.0, -22.0, -14.0, -44.0, -56.0], 
[-6.0, -44.0, -10.0, 2.0, 66.0], [30.0, 18.0, -18.0, -2.0, -48.0], [36.0, 30.0, -10.0, 52.0, 0.0]], [[-62.0, -26.0, 6.0, -26.0, 
-16.0], [19.0, 23.0, 39.0, 32.0, -12.0], [-4.0, -29.0, -17.0, 24.0, 32.0], [-9.0, 28.0, -67.0, 4.0, 14.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[6.0, -1.0, 5.0], [-5.0, 0.0, 5.0]], [[4.0, 6.0, 0.0], [0.0, -5.0, -2.0]], [[-1.0, -4.0, 
1.0], [6.0, 0.0, 0.0]], [[-6.0, 6.0, 7.0], [7.0, 7.0, 2.0]], [[7.0, 1.0, 7.0], [5.0, -6.0, 2.0]]], [[[-3.0, 2.0, 4.0], [-5.0, 
5.0, 0.0]], [[0.0, 3.0, 1.0], [7.0, 7.0, 6.0]], [[-3.0, -1.0, 3.0], [2.0, 6.0, -7.0]], [[3.0, 2.0, 1.0], [4.0, 7.0, -2.0]], 
[[-2.0, -6.0, -7.0], [0.0, -6.0, -7.0]]], [[[-1.0, -5.0, -5.0], [-4.0, 7.0, 0.0]], [[3.0, -4.0, 1.0], [1.0, -1.0, -7.0]], 
[[3.0, 6.0, 5.0], [5.0, 4.0, 0.0]], [[0.0, 1.0, 2.0], [3.0, 4.0, -4.0]], [[-6.0, -6.0, 5.0], [-7.0, 0.0, 7.0]]], [[[-2.0, 0.0, 
7.0], [0.0, -7.0, -2.0]], [[-1.0, 0.0, -2.0], [-1.0, 4.0, 1.0]], [[-5.0, -7.0, -1.0], [-7.0, -3.0, -1.0]], [[-6.0, 0.0, -4.0], 
[-5.0, 0.0, -7.0]], [[4.0, 3.0, 1.0], [-2.0, 0.0, -7.0]]]])+(1.-msk_arg0)*numpy.array([[[[7.0, 7.0, 2.0], [5.0, -5.0, 1.0]], 
[[2.0, 4.0, 1.0], [-6.0, -6.0, -7.0]], [[0.0, -5.0, 5.0], [-7.0, -5.0, 0.0]], [[4.0, 2.0, -5.0], [5.0, 2.0, 0.0]], [[-6.0, 
-4.0, -4.0], [6.0, 3.0, 1.0]]], [[[-4.0, -1.0, -4.0], [-5.0, 1.0, 1.0]], [[-1.0, -1.0, 1.0], [0.0, -1.0, 4.0]], [[-6.0, 4.0, 
5.0], [-4.0, 1.0, 1.0]], [[-7.0, -1.0, -3.0], [0.0, 0.0, 1.0]], [[4.0, 1.0, 0.0], [6.0, 0.0, -4.0]]], [[[-4.0, -2.0, -6.0], 
[-3.0, 6.0, -3.0]], [[2.0, -2.0, -4.0], [-1.0, -5.0, 4.0]], [[3.0, 0.0, -3.0], [7.0, 7.0, -3.0]], [[-1.0, 1.0, -5.0], [4.0, 
-6.0, 6.0]], [[-7.0, 7.0, 1.0], [4.0, -3.0, -6.0]]], [[[3.0, -4.0, -7.0], [5.0, 6.0, -2.0]], [[-6.0, 0.0, -1.0], [-2.0, -2.0, 
-3.0]], [[6.0, 7.0, 7.0], [0.0, 0.0, -7.0]], [[2.0, 3.0, -6.0], [-6.0, 7.0, 3.0]], [[2.0, 0.0, -3.0], [5.0, -5.0, 6.0]]]])
      arg1=Data(numpy.array([[[[-4.0, -3.0, -1.0, -6.0, -3.0], [2.0, 4.0, 5.0, -3.0, -5.0], [0.0, -5.0, 3.0, -1.0, 6.0], [1.0, 
-2.0, 7.0, -5.0, -3.0]], [[7.0, -3.0, -1.0, 0.0, -6.0], [-2.0, -1.0, 6.0, -6.0, -7.0], [5.0, -1.0, 0.0, -2.0, -3.0], [-7.0, 
0.0, -5.0, 2.0, 7.0]], [[3.0, 0.0, 0.0, 2.0, 2.0], [6.0, 3.0, 2.0, 5.0, 0.0], [7.0, -3.0, 4.0, 1.0, 5.0], [4.0, 7.0, 6.0, -3.0, 
6.0]]], [[[-3.0, -4.0, 0.0, 0.0, -1.0], [1.0, 1.0, -1.0, -1.0, -6.0], [0.0, 0.0, 7.0, 7.0, 4.0], [-5.0, -6.0, 3.0, -7.0, 
-4.0]], [[-4.0, 5.0, 6.0, 7.0, 3.0], [6.0, 0.0, 4.0, -2.0, -2.0], [0.0, 4.0, -4.0, -7.0, 2.0], [-2.0, 6.0, -5.0, -5.0, -6.0]], 
[[5.0, 4.0, -6.0, 4.0, -7.0], [-6.0, -3.0, -5.0, 3.0, 4.0], [-7.0, 2.0, -4.0, -6.0, 4.0], [-7.0, -1.0, 5.0, -6.0, 
-5.0]]]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[24.0, 25.0, -35.0, -6.0, -32.0], [9.0, 20.0, 14.0, 33.0, 27.0], [-5.0, -34.0, -17.0, -64.0, 
64.0], [23.0, 48.0, 87.0, -42.0, 0.0]], [[36.0, -63.0, -28.0, -67.0, -49.0], [-22.0, 16.0, 46.0, -44.0, -60.0], [44.0, -50.0, 
40.0, 31.0, -12.0], [-14.0, -36.0, 13.0, 29.0, 70.0]], [[-39.0, -9.0, 5.0, 8.0, 23.0], [18.0, 9.0, -33.0, 26.0, -3.0], [-13.0, 
6.0, 43.0, 52.0, 35.0], [1.0, -27.0, 37.0, -48.0, -43.0]], [[48.0, 15.0, 30.0, 107.0, -4.0], [55.0, -8.0, 31.0, 2.0, -60.0], 
[65.0, 35.0, 23.0, -11.0, 31.0], [-83.0, 59.0, -34.0, -75.0, 22.0]], [[19.0, -66.0, -56.0, -62.0, -50.0], [11.0, 47.0, 16.0, 
21.0, -52.0], [40.0, -77.0, 100.0, 63.0, 90.0], [1.0, -33.0, 141.0, -71.0, 34.0]]], [[[33.0, 48.0, 31.0, 61.0, 25.0], [39.0, 
-7.0, 30.0, 12.0, 21.0], [38.0, 21.0, -48.0, -67.0, -14.0], [14.0, 94.0, -47.0, 17.0, 37.0]], [[5.0, 22.0, 3.0, 75.0, -44.0], 
[13.0, -11.0, 11.0, -16.0, -53.0], [-20.0, 34.0, 1.0, -41.0, 62.0], [-108.0, 1.0, 7.0, -117.0, -73.0]], [[-51.0, 6.0, 82.0, 
38.0, 86.0], [94.0, 21.0, 42.0, -5.0, -30.0], [65.0, 17.0, 21.0, 22.0, -8.0], [43.0, 58.0, -57.0, 2.0, 11.0]], [[-45.0, -4.0, 
49.0, 25.0, 12.0], [66.0, 23.0, 63.0, -40.0, -75.0], [31.0, 4.0, 21.0, -15.0, 39.0], [-27.0, 21.0, -16.0, -65.0, -37.0]], 
[[-66.0, -34.0, 14.0, -72.0, 59.0], [-28.0, -2.0, -49.0, -2.0, 36.0], [-30.0, -1.0, 18.0, 91.0, -69.0], [73.0, -74.0, -31.0, 
91.0, -7.0]]], [[[-62.0, 69.0, 48.0, 45.0, 48.0], [16.0, -18.0, -13.0, -2.0, 50.0], [-60.0, 53.0, -79.0, -71.0, -18.0], [20.0, 
33.0, -59.0, 3.0, -88.0]], [[-71.0, -34.0, 37.0, -51.0, 62.0], [57.0, 41.0, 23.0, 0.0, -19.0], [36.0, -32.0, 52.0, 62.0, 9.0], 
[81.0, -4.0, 20.0, 14.0, 6.0]], [[14.0, -27.0, 15.0, 20.0, -28.0], [53.0, 26.0, 72.0, -33.0, -95.0], [65.0, -20.0, 48.0, -3.0, 
53.0], [-52.0, 23.0, 16.0, -73.0, 19.0]], [[-32.0, -11.0, 47.0, 16.0, 35.0], [61.0, 20.0, 43.0, -19.0, -49.0], [47.0, 1.0, 
29.0, 17.0, 11.0], [6.0, 24.0, -24.0, -21.0, 3.0]], [[53.0, 92.0, -30.0, 74.0, 22.0], [-19.0, -31.0, -84.0, 107.0, 142.0], 
[-44.0, 35.0, -75.0, -68.0, 7.0], [42.0, 82.0, 32.0, 10.0, -1.0]]], [[[47.0, -37.0, -28.0, -31.0, 13.0], [8.0, 19.0, -14.0, 
49.0, 16.0], [63.0, -43.0, 58.0, 70.0, 1.0], [54.0, 13.0, 53.0, 36.0, 100.0]], [[-10.0, 31.0, 19.0, 34.0, 5.0], [3.0, -14.0, 
3.0, -11.0, 7.0], [-21.0, 29.0, -38.0, -42.0, -8.0], [-19.0, 17.0, -37.0, -8.0, -34.0]], [[-4.0, 45.0, 0.0, 3.0, 60.0], [-21.0, 
-20.0, -69.0, 62.0, 118.0], [-35.0, 21.0, -52.0, -4.0, -52.0], [88.0, 28.0, -17.0, 84.0, 11.0]], [[-8.0, 10.0, 48.0, 0.0, 
64.0], [1.0, -20.0, 2.0, -18.0, 32.0], [21.0, 28.0, -41.0, 9.0, -104.0], [52.0, 21.0, -116.0, 119.0, 49.0]], [[-21.0, -41.0, 
35.0, -50.0, 23.0], [48.0, 35.0, 77.0, -44.0, -57.0], [71.0, -40.0, 30.0, 19.0, -16.0], [46.0, 18.0, -22.0, 39.0, 
58.0]]]])+(1.-msk_ref)*numpy.array([[[[37.0, -83.0, -50.0, -69.0, -86.0], [-19.0, 29.0, 51.0, -45.0, -100.0], [42.0, -66.0, 
80.0, 45.0, 45.0], [-56.0, -61.0, 71.0, -43.0, 45.0]], [[30.0, -52.0, 0.0, -80.0, 9.0], [2.0, 22.0, 53.0, -28.0, -18.0], [76.0, 
-55.0, 20.0, 33.0, -59.0], [69.0, 10.0, -23.0, 109.0, 123.0]], [[21.0, 18.0, -25.0, -25.0, 32.0], [3.0, 13.0, -33.0, 72.0, 
87.0], [10.0, -30.0, -9.0, 1.0, 2.0], [100.0, 47.0, 59.0, 49.0, 53.0]], [[-40.0, -28.0, 6.0, -20.0, -33.0], [-9.0, 4.0, 25.0, 
-58.0, -68.0], [-25.0, 1.0, 19.0, 8.0, 17.0], [-59.0, -61.0, -7.0, -46.0, -60.0]], [[-41.0, 25.0, 22.0, 53.0, 30.0], [-10.0, 
-29.0, -61.0, 13.0, 20.0], [-55.0, 60.0, -8.0, 25.0, -10.0], [-37.0, -35.0, -38.0, -29.0, -81.0]]], [[[13.0, 44.0, 5.0, 27.0, 
11.0], [-35.0, -35.0, -30.0, 4.0, 59.0], [-40.0, 39.0, -71.0, -46.0, -55.0], [3.0, 15.0, -62.0, 54.0, -10.0]], [[24.0, 17.0, 
-28.0, 17.0, -20.0], [-24.0, -12.0, -33.0, 28.0, 30.0], [-26.0, 7.0, -11.0, -13.0, 16.0], [-16.0, -1.0, 29.0, -19.0, -12.0]], 
[[80.0, 31.0, 2.0, 57.0, 4.0], [6.0, -20.0, 7.0, 24.0, 28.0], [48.0, 17.0, -34.0, -38.0, -33.0], [-3.0, 76.0, -44.0, 40.0, 
81.0]], [[17.0, 28.0, 2.0, 40.0, 14.0], [-36.0, -39.0, -52.0, 15.0, 46.0], [-33.0, 47.0, -37.0, 0.0, -50.0], [-19.0, -8.0, 
-57.0, 36.0, -9.0]], [[-47.0, -55.0, 19.0, -40.0, 4.0], [36.0, 33.0, 40.0, -36.0, -79.0], [33.0, -29.0, 70.0, 60.0, 29.0], 
[-5.0, -40.0, 21.0, -36.0, -9.0]]], [[[-46.0, 48.0, 60.0, 42.0, 54.0], [11.0, -26.0, -2.0, -24.0, 28.0], [-31.0, 58.0, -69.0, 
-43.0, -60.0], [10.0, 23.0, -108.0, 43.0, -47.0]], [[9.0, -5.0, -54.0, -39.0, -44.0], [-71.0, -15.0, -49.0, 9.0, 36.0], [-66.0, 
-8.0, -13.0, 2.0, 0.0], [-13.0, -60.0, 42.0, 6.0, -30.0]], [[-85.0, -14.0, 57.0, 13.0, 20.0], [55.0, 19.0, 45.0, -54.0, -83.0], 
[0.0, 16.0, 30.0, 12.0, 33.0], [-37.0, -24.0, -26.0, -72.0, -82.0]], [[38.0, -22.0, -72.0, -22.0, -77.0], [-102.0, -34.0, 
-67.0, -2.0, 10.0], [-72.0, 7.0, 5.0, 28.0, -6.0], [-78.0, -99.0, 30.0, -12.0, -30.0]], [[50.0, -55.0, 18.0, -1.0, 10.0], [0.0, 
-10.0, 23.0, -32.0, -56.0], [84.0, 1.0, 47.0, 79.0, -72.0], [-24.0, -15.0, -81.0, 69.0, 108.0]]], [[[-110.0, 5.0, 49.0, 2.0, 
28.0], [25.0, 6.0, 6.0, -43.0, -37.0], [-55.0, 30.0, 0.0, 3.0, 19.0], [-20.0, -47.0, -26.0, -55.0, -125.0]], [[20.0, 4.0, 12.0, 
8.0, 33.0], [-14.0, -20.0, -23.0, 10.0, 34.0], [14.0, 19.0, -16.0, 23.0, -65.0], [25.0, 8.0, -59.0, 75.0, 47.0]], [[11.0, 
-67.0, 29.0, -50.0, 3.0], [82.0, 59.0, 121.0, -46.0, -107.0], [133.0, -72.0, 74.0, 29.0, 22.0], [34.0, 44.0, 14.0, 5.0, 
108.0]], [[0.0, 56.0, 19.0, 37.0, -30.0], [-20.0, -28.0, 35.0, -53.0, 3.0], [-48.0, 39.0, -100.0, -123.0, -25.0], [-48.0, 29.0, 
-75.0, 3.0, -54.0]], [[18.0, -27.0, -68.0, -29.0, -74.0], [-75.0, -14.0, -51.0, 2.0, -6.0], [-63.0, -9.0, 25.0, 29.0, 31.0], 
[-67.0, -91.0, 66.0, -47.0, -44.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-4.0, -7.0, 2.0, 6.0, -6.0], [-3.0, 4.0, -6.0, -2.0, -3.0], [-2.0, 0.0, 0.0, -5.0, 6.0], 
[2.0, -3.0, 3.0, -3.0, 6.0]])+(1.-msk_arg0)*numpy.array([[0.0, -3.0, -7.0, -6.0, -2.0], [-7.0, 0.0, 6.0, 2.0, -4.0], [0.0, 
-1.0, 5.0, 7.0, 2.0], [7.0, 5.0, 2.0, -6.0, -3.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-7.0)+(1-msk_arg1)*(-6.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[28.0, 49.0, -14.0, -42.0, 42.0], [21.0, -28.0, 42.0, 14.0, 21.0], [14.0, -0.0, -0.0, 35.0, 
-42.0], [-14.0, 21.0, -21.0, 21.0, -42.0]])+(1.-msk_ref)*numpy.array([[-0.0, 18.0, 42.0, 36.0, 12.0], [42.0, -0.0, -36.0, 
-12.0, 24.0], [-0.0, 6.0, -30.0, -42.0, -12.0], [-42.0, -30.0, -12.0, 36.0, 18.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[4.0, 0.0, -4.0], [4.0, 3.0, -7.0], [4.0, 0.0, -2.0], [-7.0, 4.0, 5.0], [-7.0, -1.0, -3.0]], 
[[0.0, 4.0, 2.0], [-7.0, 4.0, 2.0], [0.0, -5.0, 0.0], [0.0, 6.0, -5.0], [5.0, -4.0, -5.0]], [[-5.0, 1.0, -3.0], [-6.0, 3.0, 
2.0], [0.0, -2.0, -7.0], [-2.0, -5.0, -6.0], [-2.0, -5.0, -1.0]], [[-3.0, -1.0, 4.0], [0.0, 6.0, -5.0], [-3.0, -6.0, 5.0], 
[3.0, -5.0, -4.0], [-2.0, 4.0, -5.0]]])+(1.-msk_arg0)*numpy.array([[[-4.0, 0.0, 7.0], [-7.0, 1.0, 0.0], [7.0, -7.0, 4.0], [0.0, 
0.0, 2.0], [-4.0, 4.0, -7.0]], [[3.0, 2.0, 4.0], [0.0, -3.0, -4.0], [-6.0, -7.0, -4.0], [6.0, -4.0, -3.0], [6.0, -2.0, 0.0]], 
[[-5.0, 5.0, 7.0], [3.0, 5.0, 0.0], [3.0, -7.0, 3.0], [6.0, 2.0, -3.0], [0.0, -3.0, 1.0]], [[-1.0, -1.0, 6.0], [4.0, 7.0, 6.0], 
[3.0, -7.0, 4.0], [2.0, 7.0, 0.0], [7.0, 3.0, -3.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, 4.0, -3.0])+(1.-msk_arg1)*numpy.array([-2.0, 7.0, 2.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[28.0, 49.0, 22.0, -27.0, -23.0], [10.0, -18.0, -20.0, 39.0, 19.0], [-7.0, -18.0, 13.0, -10.0, 
-25.0], [-28.0, 39.0, -51.0, 4.0, 23.0]])+(1.-msk_ref)*numpy.array([[22.0, 21.0, -55.0, 4.0, 22.0], [16.0, -29.0, -45.0, -46.0, 
-26.0], [59.0, 29.0, -49.0, -4.0, -19.0], [7.0, 53.0, -47.0, 45.0, 1.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank2_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-4.0, 2.0, -6.0], [2.0, -4.0, -6.0]], [[2.0, -3.0, 1.0], [3.0, 1.0, -3.0]], [[0.0, 0.0, 
4.0], [0.0, 5.0, 0.0]], [[0.0, 0.0, 7.0], [5.0, -4.0, 5.0]], [[-4.0, -5.0, -2.0], [4.0, -4.0, -1.0]]], [[[-1.0, -4.0, 0.0], 
[5.0, 0.0, -2.0]], [[3.0, 4.0, 2.0], [-7.0, 3.0, -2.0]], [[-2.0, 0.0, -4.0], [6.0, 3.0, -7.0]], [[0.0, 7.0, -1.0], [0.0, 2.0, 
2.0]], [[-5.0, 5.0, 6.0], [6.0, -4.0, 2.0]]], [[[-2.0, 4.0, -5.0], [2.0, 4.0, 4.0]], [[5.0, 3.0, 4.0], [-6.0, -7.0, -7.0]], 
[[-7.0, -1.0, 4.0], [0.0, -2.0, -3.0]], [[-2.0, -7.0, -3.0], [0.0, -2.0, -1.0]], [[6.0, 6.0, -5.0], [3.0, -7.0, -1.0]]], 
[[[-2.0, 4.0, -6.0], [6.0, 6.0, 2.0]], [[7.0, 2.0, 6.0], [2.0, 5.0, -4.0]], [[0.0, 5.0, 0.0], [6.0, 4.0, 7.0]], [[2.0, -4.0, 
-2.0], [5.0, 2.0, -4.0]], [[5.0, 0.0, -5.0], [-3.0, 2.0, 0.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, -5.0, -5.0], [0.0, 3.0, 
-2.0]], [[1.0, -2.0, -1.0], [-6.0, 7.0, 2.0]], [[7.0, -3.0, 1.0], [7.0, -6.0, 1.0]], [[4.0, 4.0, -5.0], [-7.0, -7.0, -1.0]], 
[[0.0, -5.0, 2.0], [7.0, 1.0, 0.0]]], [[[4.0, -6.0, 2.0], [-4.0, -5.0, -7.0]], [[2.0, 1.0, 2.0], [-5.0, 6.0, -1.0]], [[-2.0, 
1.0, 0.0], [-4.0, -5.0, -6.0]], [[7.0, 3.0, -6.0], [2.0, 0.0, -6.0]], [[4.0, 2.0, -4.0], [-1.0, 3.0, -2.0]]], [[[7.0, 0.0, 
7.0], [4.0, 2.0, 1.0]], [[-6.0, 3.0, -3.0], [-7.0, -2.0, 0.0]], [[-5.0, -3.0, 1.0], [-2.0, -3.0, 1.0]], [[6.0, -5.0, 6.0], 
[0.0, 4.0, -2.0]], [[-3.0, 1.0, -4.0], [0.0, 6.0, -6.0]]], [[[-1.0, -2.0, -4.0], [-7.0, -7.0, -7.0]], [[-6.0, -2.0, 5.0], [0.0, 
-3.0, -3.0]], [[0.0, 6.0, 7.0], [2.0, -5.0, 7.0]], [[1.0, 6.0, 4.0], [-4.0, -6.0, -1.0]], [[-1.0, 7.0, 0.0], [6.0, -7.0, 
-3.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-3.0, 3.0, 0.0], [-4.0, -2.0, 5.0]])+(1.-msk_arg1)*numpy.array([[0.0, -1.0, -7.0], [-7.0, 
7.0, 7.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-12.0, -44.0, -10.0, 13.0, -16.0], [-39.0, 15.0, -59.0, 27.0, 24.0], [22.0, -3.0, 7.0, -16.0, 
-3.0], [-8.0, -53.0, 18.0, -62.0, -7.0]])+(1.-msk_ref)*numpy.array([[47.0, 114.0, -88.0, 24.0, -51.0], [-64.0, 55.0, -50.0, 
-17.0, 40.0], [-56.0, 53.0, -4.0, -23.0, 27.0], [-19.0, -75.0, -55.0, -55.0, -119.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-6.0, 6.0, 7.0, 7.0, 1.0], [1.0, -7.0, -3.0, 6.0, 0.0], [-5.0, -6.0, 1.0, -3.0, -7.0], [4.0, 
3.0, 1.0, 0.0, -1.0]])+(1.-msk_arg0)*numpy.array([[1.0, -2.0, 4.0, 6.0, 7.0], [0.0, -5.0, 4.0, -7.0, 0.0], [-2.0, -1.0, 4.0, 
-3.0, -6.0], [3.0, 1.0, 3.0, 4.0, 4.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, -7.0])+(1.-msk_arg1)*numpy.array([3.0, -7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-24.0, 42.0], [24.0, -42.0], [28.0, -49.0], [28.0, -49.0], [4.0, -7.0]], [[4.0, -7.0], [-28.0, 
49.0], [-12.0, 21.0], [24.0, -42.0], [0.0, 0.0]], [[-20.0, 35.0], [-24.0, 42.0], [4.0, -7.0], [-12.0, 21.0], [-28.0, 49.0]], 
[[16.0, -28.0], [12.0, -21.0], [4.0, -7.0], [0.0, 0.0], [-4.0, 7.0]]])+(1.-msk_ref)*numpy.array([[[3.0, -7.0], [-6.0, 14.0], 
[12.0, -28.0], [18.0, -42.0], [21.0, -49.0]], [[0.0, 0.0], [-15.0, 35.0], [12.0, -28.0], [-21.0, 49.0], [0.0, 0.0]], [[-6.0, 
14.0], [-3.0, 7.0], [12.0, -28.0], [-9.0, 21.0], [-18.0, 42.0]], [[9.0, -21.0], [3.0, -7.0], [9.0, -21.0], [12.0, -28.0], 
[12.0, -28.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[1.0, 0.0, -1.0], [-2.0, -4.0, 5.0], [1.0, 6.0, 6.0], [-7.0, -6.0, 0.0], [-6.0, 7.0, 3.0]], 
[[3.0, -2.0, 5.0], [-1.0, 2.0, -5.0], [7.0, 0.0, 5.0], [-1.0, 2.0, 4.0], [-2.0, 3.0, -1.0]], [[-6.0, 6.0, 3.0], [-2.0, 6.0, 
-7.0], [-5.0, 3.0, -4.0], [-3.0, 0.0, -6.0], [3.0, 4.0, 2.0]], [[-4.0, 3.0, 6.0], [-7.0, -6.0, -3.0], [5.0, 5.0, 0.0], [7.0, 
5.0, 3.0], [0.0, 3.0, -5.0]]])+(1.-msk_arg0)*numpy.array([[[1.0, 5.0, -3.0], [-1.0, -3.0, 6.0], [5.0, -3.0, 7.0], [7.0, 2.0, 
3.0], [7.0, -1.0, 3.0]], [[-5.0, -4.0, 4.0], [3.0, 6.0, -4.0], [-2.0, 0.0, 0.0], [7.0, 1.0, 2.0], [-5.0, 5.0, 5.0]], [[1.0, 
6.0, 2.0], [3.0, 3.0, -5.0], [4.0, -2.0, -3.0], [-3.0, 0.0, 5.0], [1.0, 5.0, -2.0]], [[7.0, 6.0, 3.0], [-1.0, -1.0, 2.0], [2.0, 
5.0, 4.0], [-6.0, 0.0, 0.0], [-5.0, 2.0, 6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-3.0, -3.0], [6.0, 3.0], [-7.0, -1.0]])+(1.-msk_arg1)*numpy.array([[0.0, 2.0], [4.0, 3.0], 
[-7.0, 6.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, -2.0], [-53.0, -11.0], [-9.0, 9.0], [-15.0, 3.0], [39.0, 36.0]], [[-56.0, -20.0], [50.0, 
14.0], [-56.0, -26.0], [-13.0, 5.0], [31.0, 16.0]], [[33.0, 33.0], [91.0, 31.0], [61.0, 28.0], [51.0, 15.0], [1.0, 1.0]], 
[[-12.0, 15.0], [6.0, 6.0], [15.0, 0.0], [-12.0, -9.0], [53.0, 14.0]]])+(1.-msk_ref)*numpy.array([[[41.0, -1.0], [-54.0, 25.0], 
[-61.0, 43.0], [-13.0, 38.0], [-25.0, 29.0]], [[-44.0, 2.0], [52.0, 0.0], [0.0, -4.0], [-10.0, 29.0], [-15.0, 35.0]], [[10.0, 
32.0], [47.0, -15.0], [13.0, -16.0], [-35.0, 24.0], [34.0, 5.0]], [[3.0, 50.0], [-18.0, 7.0], [-8.0, 43.0], [0.0, -12.0], 
[-34.0, 32.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank3_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[0.0, 3.0, -4.0], [-6.0, -2.0, 2.0]], [[2.0, -3.0, 1.0], [5.0, -1.0, -5.0]], [[4.0, -2.0, 
3.0], [-2.0, 4.0, -2.0]], [[-3.0, -4.0, -2.0], [1.0, -7.0, 0.0]], [[3.0, -3.0, -2.0], [-6.0, 0.0, 1.0]]], [[[0.0, -5.0, -2.0], 
[0.0, 1.0, 3.0]], [[0.0, 5.0, 3.0], [4.0, 3.0, -6.0]], [[4.0, -7.0, 3.0], [2.0, 0.0, 7.0]], [[2.0, -7.0, 7.0], [-5.0, 2.0, 
-2.0]], [[7.0, 0.0, -5.0], [0.0, 0.0, -4.0]]], [[[1.0, 3.0, 6.0], [4.0, 1.0, 2.0]], [[-2.0, 4.0, 2.0], [0.0, -5.0, 6.0]], 
[[-1.0, -1.0, -2.0], [1.0, -6.0, -2.0]], [[0.0, 5.0, -2.0], [-3.0, -4.0, 0.0]], [[-6.0, 1.0, -1.0], [0.0, -1.0, -6.0]]], 
[[[5.0, -6.0, -5.0], [7.0, -4.0, 0.0]], [[5.0, -6.0, 4.0], [-7.0, 7.0, 4.0]], [[-7.0, 0.0, -3.0], [3.0, -1.0, -6.0]], [[6.0, 
-6.0, -7.0], [-6.0, -4.0, 4.0]], [[0.0, -5.0, -2.0], [4.0, -1.0, -2.0]]]])+(1.-msk_arg0)*numpy.array([[[[1.0, -6.0, 6.0], [0.0, 
2.0, 5.0]], [[0.0, 3.0, 7.0], [-7.0, -4.0, -1.0]], [[2.0, 2.0, 0.0], [3.0, 0.0, -1.0]], [[-1.0, -3.0, 3.0], [-2.0, 3.0, 0.0]], 
[[-2.0, -6.0, 0.0], [-3.0, -6.0, 2.0]]], [[[-4.0, 7.0, -5.0], [-1.0, 7.0, 4.0]], [[3.0, 0.0, 2.0], [0.0, 4.0, 6.0]], [[-2.0, 
-2.0, 0.0], [3.0, -3.0, -5.0]], [[5.0, -4.0, 1.0], [-5.0, -3.0, 5.0]], [[6.0, 0.0, 7.0], [0.0, -6.0, 5.0]]], [[[7.0, 2.0, 7.0], 
[6.0, 0.0, 7.0]], [[3.0, 5.0, -2.0], [-3.0, 0.0, -7.0]], [[3.0, -5.0, 3.0], [-6.0, -2.0, 0.0]], [[6.0, -5.0, -3.0], [0.0, 1.0, 
0.0]], [[1.0, -4.0, -6.0], [3.0, 6.0, -5.0]]], [[[-1.0, -3.0, -6.0], [3.0, 6.0, -4.0]], [[3.0, 0.0, 3.0], [0.0, -4.0, 7.0]], 
[[0.0, 1.0, -5.0], [-5.0, -6.0, 4.0]], [[4.0, -5.0, -5.0], [-4.0, -5.0, 7.0]], [[6.0, -3.0, -4.0], [6.0, 6.0, 0.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[1.0, 3.0], [6.0, 0.0], [6.0, 6.0]], [[-3.0, 2.0], [7.0, 4.0], [3.0, 
-3.0]]])+(1.-msk_arg1)*numpy.array([[[7.0, 6.0], [-2.0, -3.0], [-4.0, 5.0]], [[-4.0, 3.0], [-5.0, -6.0], [1.0, -3.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, -50.0], [-47.0, 33.0], [38.0, 48.0], [-91.0, -47.0], [-6.0, -18.0]], [[-26.0, -17.0], 
[39.0, 56.0], [-5.0, 13.0], [25.0, 52.0], [-35.0, 3.0]], [[56.0, 45.0], [17.0, -32.0], [-70.0, -31.0], [-1.0, -34.0], [-31.0, 
-10.0]], [[-110.0, -17.0], [75.0, 41.0], [-59.0, -19.0], [-70.0, -64.0], [-67.0, -2.0]]])+(1.-msk_ref)*numpy.array([[[-10.0, 
27.0], [13.0, 32.0], [-3.0, 18.0], [-20.0, -6.0], [42.0, 27.0]], [[-49.0, -127.0], [-1.0, -14.0], [-12.0, 36.0], [79.0, 35.0], 
[49.0, 92.0]], [[0.0, 68.0], [24.0, 5.0], [53.0, 42.0], [59.0, 30.0], [-8.0, -24.0]], [[-23.0, -42.0], [36.0, 36.0], [72.0, 
-19.0], [106.0, 11.0], [10.0, 7.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank2_expandedData_rank2_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[5.0, 0.0, -7.0, -4.0, 1.0], [2.0, -5.0, -7.0, -1.0, 2.0], [0.0, -4.0, 5.0, -7.0, 1.0], [-1.0, 
-7.0, -6.0, -1.0, 5.0]])+(1.-msk_arg0)*numpy.array([[-3.0, -1.0, -1.0, -5.0, 3.0], [3.0, -2.0, -5.0, 6.0, 3.0], [6.0, 3.0, 
-3.0, 2.0, -6.0], [4.0, 3.0, 6.0, 2.0, 5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[5.0, 6.0, 6.0, 0.0, 1.0], [-1.0, 4.0, -5.0, -3.0, -6.0], [-1.0, 2.0, 5.0, 4.0, 0.0], [-4.0, 
6.0, 6.0, -1.0, -6.0]])+(1.-msk_arg1)*numpy.array([[-6.0, -7.0, -4.0, -1.0, 7.0], [0.0, 7.0, -5.0, 0.0, 0.0], [-2.0, 0.0, 4.0, 
-1.0, -3.0], [-7.0, 7.0, 2.0, 0.0, -1.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[25.0, 30.0, 30.0, 0.0, 5.0], [-5.0, 20.0, -25.0, -15.0, -30.0], [-5.0, 10.0, 25.0, 20.0, 
0.0], [-20.0, 30.0, 30.0, -5.0, -30.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0]], [[-35.0, -42.0, -42.0, 0.0, -7.0], [7.0, -28.0, 35.0, 21.0, 42.0], [7.0, -14.0, -35.0, -28.0, 0.0], 
[28.0, -42.0, -42.0, 7.0, 42.0]], [[-20.0, -24.0, -24.0, 0.0, -4.0], [4.0, -16.0, 20.0, 12.0, 24.0], [4.0, -8.0, -20.0, -16.0, 
0.0], [16.0, -24.0, -24.0, 4.0, 24.0]], [[5.0, 6.0, 6.0, 0.0, 1.0], [-1.0, 4.0, -5.0, -3.0, -6.0], [-1.0, 2.0, 5.0, 4.0, 0.0], 
[-4.0, 6.0, 6.0, -1.0, -6.0]]], [[[10.0, 12.0, 12.0, 0.0, 2.0], [-2.0, 8.0, -10.0, -6.0, -12.0], [-2.0, 4.0, 10.0, 8.0, 0.0], 
[-8.0, 12.0, 12.0, -2.0, -12.0]], [[-25.0, -30.0, -30.0, 0.0, -5.0], [5.0, -20.0, 25.0, 15.0, 30.0], [5.0, -10.0, -25.0, -20.0, 
0.0], [20.0, -30.0, -30.0, 5.0, 30.0]], [[-35.0, -42.0, -42.0, 0.0, -7.0], [7.0, -28.0, 35.0, 21.0, 42.0], [7.0, -14.0, -35.0, 
-28.0, 0.0], [28.0, -42.0, -42.0, 7.0, 42.0]], [[-5.0, -6.0, -6.0, 0.0, -1.0], [1.0, -4.0, 5.0, 3.0, 6.0], [1.0, -2.0, -5.0, 
-4.0, 0.0], [4.0, -6.0, -6.0, 1.0, 6.0]], [[10.0, 12.0, 12.0, 0.0, 2.0], [-2.0, 8.0, -10.0, -6.0, -12.0], [-2.0, 4.0, 10.0, 
8.0, 0.0], [-8.0, 12.0, 12.0, -2.0, -12.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[-20.0, -24.0, -24.0, 0.0, -4.0], [4.0, -16.0, 20.0, 12.0, 24.0], [4.0, -8.0, -20.0, -16.0, 
0.0], [16.0, -24.0, -24.0, 4.0, 24.0]], [[25.0, 30.0, 30.0, 0.0, 5.0], [-5.0, 20.0, -25.0, -15.0, -30.0], [-5.0, 10.0, 25.0, 
20.0, 0.0], [-20.0, 30.0, 30.0, -5.0, -30.0]], [[-35.0, -42.0, -42.0, 0.0, -7.0], [7.0, -28.0, 35.0, 21.0, 42.0], [7.0, -14.0, 
-35.0, -28.0, 0.0], [28.0, -42.0, -42.0, 7.0, 42.0]], [[5.0, 6.0, 6.0, 0.0, 1.0], [-1.0, 4.0, -5.0, -3.0, -6.0], [-1.0, 2.0, 
5.0, 4.0, 0.0], [-4.0, 6.0, 6.0, -1.0, -6.0]]], [[[-5.0, -6.0, -6.0, 0.0, -1.0], [1.0, -4.0, 5.0, 3.0, 6.0], [1.0, -2.0, -5.0, 
-4.0, 0.0], [4.0, -6.0, -6.0, 1.0, 6.0]], [[-35.0, -42.0, -42.0, 0.0, -7.0], [7.0, -28.0, 35.0, 21.0, 42.0], [7.0, -14.0, 
-35.0, -28.0, 0.0], [28.0, -42.0, -42.0, 7.0, 42.0]], [[-30.0, -36.0, -36.0, 0.0, -6.0], [6.0, -24.0, 30.0, 18.0, 36.0], [6.0, 
-12.0, -30.0, -24.0, 0.0], [24.0, -36.0, -36.0, 6.0, 36.0]], [[-5.0, -6.0, -6.0, 0.0, -1.0], [1.0, -4.0, 5.0, 3.0, 6.0], [1.0, 
-2.0, -5.0, -4.0, 0.0], [4.0, -6.0, -6.0, 1.0, 6.0]], [[25.0, 30.0, 30.0, 0.0, 5.0], [-5.0, 20.0, -25.0, -15.0, -30.0], [-5.0, 
10.0, 25.0, 20.0, 0.0], [-20.0, 30.0, 30.0, -5.0, -30.0]]]])+(1.-msk_ref)*numpy.array([[[[18.0, 21.0, 12.0, 3.0, -21.0], [0.0, 
-21.0, 15.0, 0.0, 0.0], [6.0, 0.0, -12.0, 3.0, 9.0], [21.0, -21.0, -6.0, 0.0, 3.0]], [[6.0, 7.0, 4.0, 1.0, -7.0], [0.0, -7.0, 
5.0, 0.0, 0.0], [2.0, 0.0, -4.0, 1.0, 3.0], [7.0, -7.0, -2.0, 0.0, 1.0]], [[6.0, 7.0, 4.0, 1.0, -7.0], [0.0, -7.0, 5.0, 0.0, 
0.0], [2.0, 0.0, -4.0, 1.0, 3.0], [7.0, -7.0, -2.0, 0.0, 1.0]], [[30.0, 35.0, 20.0, 5.0, -35.0], [0.0, -35.0, 25.0, 0.0, 0.0], 
[10.0, 0.0, -20.0, 5.0, 15.0], [35.0, -35.0, -10.0, 0.0, 5.0]], [[-18.0, -21.0, -12.0, -3.0, 21.0], [0.0, 21.0, -15.0, 0.0, 
0.0], [-6.0, 0.0, 12.0, -3.0, -9.0], [-21.0, 21.0, 6.0, 0.0, -3.0]]], [[[-18.0, -21.0, -12.0, -3.0, 21.0], [0.0, 21.0, -15.0, 
0.0, 0.0], [-6.0, 0.0, 12.0, -3.0, -9.0], [-21.0, 21.0, 6.0, 0.0, -3.0]], [[12.0, 14.0, 8.0, 2.0, -14.0], [0.0, -14.0, 10.0, 
0.0, 0.0], [4.0, 0.0, -8.0, 2.0, 6.0], [14.0, -14.0, -4.0, 0.0, 2.0]], [[30.0, 35.0, 20.0, 5.0, -35.0], [0.0, -35.0, 25.0, 0.0, 
0.0], [10.0, 0.0, -20.0, 5.0, 15.0], [35.0, -35.0, -10.0, 0.0, 5.0]], [[-36.0, -42.0, -24.0, -6.0, 42.0], [0.0, 42.0, -30.0, 
0.0, 0.0], [-12.0, 0.0, 24.0, -6.0, -18.0], [-42.0, 42.0, 12.0, 0.0, -6.0]], [[-18.0, -21.0, -12.0, -3.0, 21.0], [0.0, 21.0, 
-15.0, 0.0, 0.0], [-6.0, 0.0, 12.0, -3.0, -9.0], [-21.0, 21.0, 6.0, 0.0, -3.0]]], [[[-36.0, -42.0, -24.0, -6.0, 42.0], [0.0, 
42.0, -30.0, 0.0, 0.0], [-12.0, 0.0, 24.0, -6.0, -18.0], [-42.0, 42.0, 12.0, 0.0, -6.0]], [[-18.0, -21.0, -12.0, -3.0, 21.0], 
[0.0, 21.0, -15.0, 0.0, 0.0], [-6.0, 0.0, 12.0, -3.0, -9.0], [-21.0, 21.0, 6.0, 0.0, -3.0]], [[18.0, 21.0, 12.0, 3.0, -21.0], 
[0.0, -21.0, 15.0, 0.0, 0.0], [6.0, 0.0, -12.0, 3.0, 9.0], [21.0, -21.0, -6.0, 0.0, 3.0]], [[-12.0, -14.0, -8.0, -2.0, 14.0], 
[0.0, 14.0, -10.0, 0.0, 0.0], [-4.0, 0.0, 8.0, -2.0, -6.0], [-14.0, 14.0, 4.0, 0.0, -2.0]], [[36.0, 42.0, 24.0, 6.0, -42.0], 
[0.0, -42.0, 30.0, 0.0, 0.0], [12.0, 0.0, -24.0, 6.0, 18.0], [42.0, -42.0, -12.0, 0.0, 6.0]]], [[[-24.0, -28.0, -16.0, -4.0, 
28.0], [0.0, 28.0, -20.0, 0.0, 0.0], [-8.0, 0.0, 16.0, -4.0, -12.0], [-28.0, 28.0, 8.0, 0.0, -4.0]], [[-18.0, -21.0, -12.0, 
-3.0, 21.0], [0.0, 21.0, -15.0, 0.0, 0.0], [-6.0, 0.0, 12.0, -3.0, -9.0], [-21.0, 21.0, 6.0, 0.0, -3.0]], [[-36.0, -42.0, 
-24.0, -6.0, 42.0], [0.0, 42.0, -30.0, 0.0, 0.0], [-12.0, 0.0, 24.0, -6.0, -18.0], [-42.0, 42.0, 12.0, 0.0, -6.0]], [[-12.0, 
-14.0, -8.0, -2.0, 14.0], [0.0, 14.0, -10.0, 0.0, 0.0], [-4.0, 0.0, 8.0, -2.0, -6.0], [-14.0, 14.0, 4.0, 0.0, -2.0]], [[-30.0, 
-35.0, -20.0, -5.0, 35.0], [0.0, 35.0, -25.0, 0.0, 0.0], [-10.0, 0.0, 20.0, -5.0, -15.0], [-35.0, 35.0, 10.0, 0.0, -5.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank3_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-7.0, 7.0, 4.0], [0.0, 5.0, -3.0], [-2.0, 7.0, -3.0], [0.0, -4.0, 0.0], [0.0, -2.0, 2.0]], 
[[-5.0, -1.0, 4.0], [-6.0, 4.0, -3.0], [-3.0, 7.0, -1.0], [-1.0, 3.0, 5.0], [-4.0, -3.0, 6.0]], [[-6.0, -3.0, 7.0], [7.0, 6.0, 
2.0], [2.0, 5.0, -6.0], [6.0, -7.0, -5.0], [-4.0, 0.0, -2.0]], [[4.0, -1.0, -3.0], [-7.0, 7.0, -1.0], [-6.0, -4.0, 7.0], [-7.0, 
-3.0, 0.0], [1.0, 5.0, 7.0]]])+(1.-msk_arg0)*numpy.array([[[-7.0, 0.0, -1.0], [-7.0, -7.0, 6.0], [-5.0, 5.0, -5.0], [-1.0, 
-5.0, -2.0], [-5.0, -3.0, 5.0]], [[-5.0, 7.0, 3.0], [1.0, -1.0, 4.0], [1.0, 2.0, 2.0], [2.0, -2.0, -7.0], [-1.0, 6.0, 1.0]], 
[[7.0, -1.0, -3.0], [-4.0, 2.0, 6.0], [-3.0, 0.0, -7.0], [-2.0, -1.0, -6.0], [-7.0, 0.0, -4.0]], [[-3.0, -1.0, 2.0], [-7.0, 
0.0, -6.0], [6.0, -1.0, 5.0], [0.0, -3.0, -2.0], [0.0, 5.0, 7.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-2.0, -1.0, -6.0, 0.0, -6.0], [-1.0, -7.0, -5.0, 5.0, -6.0], [1.0, -5.0, -7.0, 6.0, -5.0], 
[4.0, -1.0, -1.0, -1.0, 0.0]], [[-4.0, 7.0, -7.0, 1.0, 2.0], [1.0, -7.0, -1.0, -5.0, -6.0], [0.0, 2.0, 5.0, 7.0, -1.0], [7.0, 
4.0, -2.0, -3.0, 5.0]], [[-4.0, 0.0, 0.0, 4.0, 7.0], [-3.0, 0.0, -5.0, -4.0, -3.0], [-1.0, 7.0, -2.0, -3.0, 6.0], [0.0, 2.0, 
7.0, 5.0, 1.0]]])+(1.-msk_arg1)*numpy.array([[[-1.0, -4.0, -5.0, -7.0, 4.0], [1.0, 2.0, 2.0, -3.0, -3.0], [0.0, -6.0, 5.0, 2.0, 
-6.0], [0.0, -4.0, 1.0, -7.0, 0.0]], [[-7.0, -7.0, -2.0, 7.0, -6.0], [-1.0, 2.0, -7.0, 3.0, -4.0], [6.0, -6.0, -3.0, 7.0, 4.0], 
[7.0, 0.0, -5.0, -6.0, -5.0]], [[-6.0, 5.0, -4.0, 6.0, -1.0], [-1.0, -3.0, 7.0, 5.0, 0.0], [-7.0, 5.0, 2.0, -1.0, -4.0], [-6.0, 
-1.0, -2.0, 4.0, 0.0]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-30.0, 56.0, -7.0, 23.0, 84.0], [2.0, 0.0, 8.0, -86.0, -12.0], [-11.0, 77.0, 76.0, -5.0, 
52.0], [21.0, 43.0, 21.0, 6.0, 39.0]], [[-8.0, 35.0, -35.0, -7.0, -11.0], [14.0, -35.0, 10.0, -13.0, -21.0], [3.0, -11.0, 31.0, 
44.0, -23.0], [35.0, 14.0, -31.0, -30.0, 22.0]], [[-12.0, 51.0, -37.0, -5.0, 5.0], [18.0, -35.0, 18.0, -33.0, -21.0], [1.0, 
3.0, 55.0, 46.0, -15.0], [41.0, 24.0, -33.0, -34.0, 32.0]], [[16.0, -28.0, 28.0, -4.0, -8.0], [-4.0, 28.0, 4.0, 20.0, 24.0], 
[0.0, -8.0, -20.0, -28.0, 4.0], [-28.0, -16.0, 8.0, 12.0, -20.0]], [[0.0, -14.0, 14.0, 6.0, 10.0], [-8.0, 14.0, -8.0, 2.0, 
6.0], [-2.0, 10.0, -14.0, -20.0, 14.0], [-14.0, -4.0, 18.0, 16.0, -8.0]]], [[[-2.0, -2.0, 37.0, 15.0, 56.0], [-8.0, 42.0, 6.0, 
-36.0, 24.0], [-9.0, 51.0, 22.0, -49.0, 50.0], [-27.0, 9.0, 35.0, 28.0, -1.0]], [[8.0, 34.0, 8.0, -8.0, 23.0], [19.0, 14.0, 
41.0, -38.0, 21.0], [-3.0, 17.0, 68.0, 1.0, 8.0], [4.0, 16.0, -23.0, -21.0, 17.0]], [[-18.0, 52.0, -31.0, 3.0, 25.0], [13.0, 
-28.0, 13.0, -46.0, -21.0], [-2.0, 22.0, 58.0, 34.0, 2.0], [37.0, 29.0, -18.0, -23.0, 34.0]], [[-30.0, 22.0, -15.0, 23.0, 
47.0], [-11.0, -14.0, -23.0, -40.0, -27.0], [-6.0, 46.0, 12.0, 0.0, 32.0], [17.0, 23.0, 30.0, 17.0, 20.0]], [[-4.0, -17.0, 
45.0, 21.0, 60.0], [-17.0, 49.0, -7.0, -29.0, 24.0], [-10.0, 56.0, 1.0, -63.0, 59.0], [-37.0, 4.0, 52.0, 43.0, -9.0]]], 
[[[-4.0, -15.0, 57.0, 25.0, 79.0], [-18.0, 63.0, -2.0, -43.0, 33.0], [-13.0, 73.0, 13.0, -78.0, 75.0], [-45.0, 8.0, 61.0, 50.0, 
-8.0]], [[-46.0, 35.0, -84.0, 14.0, -16.0], [-7.0, -91.0, -51.0, -3.0, -84.0], [5.0, -9.0, -23.0, 78.0, -29.0], [70.0, 21.0, 
-5.0, -15.0, 32.0]], [[0.0, 33.0, -47.0, -19.0, -44.0], [21.0, -49.0, 15.0, 9.0, -24.0], [8.0, -42.0, 23.0, 65.0, -51.0], 
[43.0, 6.0, -54.0, -47.0, 19.0]], [[36.0, -55.0, 13.0, -27.0, -85.0], [2.0, 7.0, 2.0, 85.0, 21.0], [11.0, -79.0, -67.0, 2.0, 
-53.0], [-25.0, -44.0, -27.0, -10.0, -40.0]], [[16.0, 4.0, 24.0, -8.0, 10.0], [10.0, 28.0, 30.0, -12.0, 30.0], [-2.0, 6.0, 
32.0, -18.0, 8.0], [-16.0, 0.0, -10.0, -6.0, -2.0]]], [[[8.0, -11.0, -17.0, -13.0, -47.0], [4.0, -21.0, -4.0, 37.0, -9.0], 
[7.0, -43.0, -27.0, 26.0, -37.0], [9.0, -14.0, -23.0, -16.0, -8.0]], [[-10.0, 56.0, -7.0, 3.0, 49.0], [17.0, 0.0, 33.0, -66.0, 
3.0], [-6.0, 42.0, 86.0, 10.0, 22.0], [21.0, 33.0, -14.0, -19.0, 34.0]], [[0.0, -22.0, 64.0, 24.0, 77.0], [-19.0, 70.0, -1.0, 
-38.0, 39.0], [-13.0, 71.0, 8.0, -85.0, 76.0], [-52.0, 4.0, 63.0, 53.0, -13.0]], [[26.0, -14.0, 63.0, -3.0, 36.0], [4.0, 70.0, 
38.0, -20.0, 60.0], [-7.0, 29.0, 34.0, -63.0, 38.0], [-49.0, -5.0, 13.0, 16.0, -15.0]], [[-50.0, 34.0, -41.0, 33.0, 53.0], 
[-17.0, -42.0, -45.0, -48.0, -57.0], [-6.0, 54.0, 4.0, 20.0, 32.0], [39.0, 33.0, 38.0, 19.0, 
32.0]]]])+(1.-msk_ref)*numpy.array([[[[13.0, 23.0, 39.0, 43.0, -27.0], [-6.0, -11.0, -21.0, 16.0, 21.0], [7.0, 37.0, -37.0, 
-13.0, 46.0], [6.0, 29.0, -5.0, 45.0, 0.0]], [[20.0, 107.0, 25.0, 36.0, 8.0], [-6.0, -46.0, 77.0, 30.0, 49.0], [-84.0, 114.0, 
-2.0, -69.0, -10.0], [-85.0, 22.0, 16.0, 115.0, 35.0]], [[0.0, -40.0, 35.0, 40.0, -45.0], [-5.0, 15.0, -80.0, 5.0, -5.0], 
[65.0, -25.0, -50.0, 30.0, 70.0], [65.0, 25.0, -20.0, -15.0, -25.0]], [[48.0, 29.0, 23.0, -40.0, 28.0], [6.0, -6.0, 19.0, 
-22.0, 23.0], [-16.0, 26.0, 6.0, -35.0, -6.0], [-23.0, 6.0, 28.0, 29.0, 25.0]], [[-4.0, 66.0, 11.0, 44.0, -7.0], [-7.0, -31.0, 
46.0, 31.0, 27.0], [-53.0, 73.0, -6.0, -36.0, -2.0], [-51.0, 15.0, 0.0, 73.0, 15.0]]], [[[-62.0, -14.0, -1.0, 102.0, -65.0], 
[-15.0, -5.0, -38.0, 51.0, -13.0], [21.0, 3.0, -40.0, 36.0, 46.0], [31.0, 17.0, -46.0, 5.0, -35.0]], [[-18.0, 23.0, -19.0, 
10.0, 6.0], [-2.0, -12.0, 37.0, 14.0, 1.0], [-34.0, 20.0, 16.0, -9.0, -26.0], [-31.0, -8.0, -2.0, 15.0, 5.0]], [[-27.0, -8.0, 
-17.0, 19.0, -10.0], [-3.0, 0.0, 2.0, 13.0, -11.0], [-2.0, -8.0, 3.0, 14.0, -6.0], [2.0, -6.0, -13.0, -11.0, -10.0]], [[54.0, 
-29.0, 22.0, -70.0, 27.0], [11.0, 21.0, -31.0, -47.0, 2.0], [37.0, -35.0, 2.0, -3.0, 8.0], [28.0, -1.0, 26.0, -30.0, 10.0]], 
[[-47.0, -33.0, -11.0, 55.0, -41.0], [-8.0, 7.0, -37.0, 26.0, -21.0], [29.0, -25.0, -21.0, 39.0, 26.0], [36.0, 3.0, -33.0, 
-25.0, -30.0]]], [[[18.0, -36.0, -21.0, -74.0, 37.0], [11.0, 21.0, 0.0, -39.0, -17.0], [15.0, -51.0, 32.0, 10.0, -34.0], [11.0, 
-25.0, 18.0, -55.0, 5.0]], [[-46.0, 32.0, -8.0, 78.0, -34.0], [-12.0, -22.0, 20.0, 48.0, 4.0], [-30.0, 42.0, -14.0, 0.0, 8.0], 
[-22.0, 10.0, -26.0, 40.0, -10.0]], [[45.0, -23.0, 43.0, -21.0, -5.0], [4.0, 15.0, -55.0, -26.0, 9.0], [49.0, -17.0, -29.0, 
1.0, 46.0], [42.0, 19.0, 11.0, -7.0, 0.0]], [[45.0, -15.0, 36.0, -29.0, 4.0], [5.0, 12.0, -39.0, -27.0, 10.0], [36.0, -12.0, 
-19.0, -5.0, 32.0], [29.0, 14.0, 15.0, -4.0, 5.0]], [[31.0, 8.0, 51.0, 25.0, -24.0], [-3.0, -2.0, -42.0, 1.0, 21.0], [28.0, 
22.0, -43.0, -10.0, 58.0], [24.0, 32.0, 1.0, 33.0, 0.0]]], [[[-2.0, 29.0, 9.0, 26.0, -8.0], [-4.0, -14.0, 15.0, 16.0, 13.0], 
[-20.0, 34.0, -8.0, -15.0, 6.0], [-19.0, 10.0, -2.0, 35.0, 5.0]], [[43.0, -2.0, 59.0, 13.0, -22.0], [-1.0, 4.0, -56.0, -9.0, 
21.0], [42.0, 12.0, -47.0, -8.0, 66.0], [36.0, 34.0, 5.0, 25.0, 0.0]], [[-29.0, 8.0, -48.0, -19.0, 25.0], [2.0, -5.0, 54.0, 
4.0, -14.0], [-41.0, -5.0, 43.0, 0.0, -60.0], [-37.0, -29.0, 1.0, -16.0, 5.0]], [[33.0, 11.0, 14.0, -33.0, 20.0], [5.0, 0.0, 
7.0, -19.0, 12.0], [-4.0, 8.0, 5.0, -19.0, -4.0], [-9.0, 2.0, 19.0, 10.0, 15.0]], [[-77.0, 0.0, -38.0, 77.0, -37.0], [-12.0, 
-11.0, 14.0, 50.0, -20.0], [-19.0, 5.0, -1.0, 28.0, -8.0], [-7.0, -7.0, -39.0, -2.0, -25.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank4_offset2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[6.0, -3.0, -7.0], [7.0, 1.0, 0.0]], [[3.0, -4.0, 7.0], [7.0, 1.0, 3.0]], [[6.0, 0.0, 2.0], 
[0.0, -1.0, 3.0]], [[-3.0, 5.0, 1.0], [-6.0, -7.0, 0.0]], [[-7.0, 2.0, -6.0], [0.0, 7.0, -1.0]]], [[[4.0, 5.0, -4.0], [5.0, 
-7.0, -6.0]], [[6.0, -1.0, -7.0], [-6.0, 4.0, -7.0]], [[-7.0, -6.0, -5.0], [6.0, -4.0, 1.0]], [[3.0, -6.0, -6.0], [0.0, -1.0, 
-4.0]], [[-2.0, 0.0, 3.0], [0.0, 4.0, -6.0]]], [[[3.0, -6.0, -2.0], [5.0, 0.0, -5.0]], [[-1.0, 4.0, 7.0], [5.0, -7.0, -5.0]], 
[[-1.0, 4.0, -2.0], [-3.0, 2.0, 7.0]], [[7.0, 6.0, -2.0], [-6.0, 0.0, 0.0]], [[-3.0, 5.0, 3.0], [3.0, 0.0, -5.0]]], [[[-4.0, 
-7.0, 7.0], [5.0, -3.0, -2.0]], [[0.0, 3.0, 0.0], [-7.0, 4.0, -5.0]], [[1.0, -6.0, 5.0], [6.0, 1.0, 1.0]], [[7.0, 2.0, 4.0], 
[4.0, -5.0, 2.0]], [[3.0, -4.0, 5.0], [4.0, 5.0, -2.0]]]])+(1.-msk_arg0)*numpy.array([[[[0.0, -5.0, -5.0], [6.0, 0.0, 5.0]], 
[[6.0, 5.0, 4.0], [-6.0, 4.0, -5.0]], [[4.0, -7.0, -5.0], [2.0, 7.0, -1.0]], [[-2.0, -5.0, 0.0], [7.0, -7.0, 6.0]], [[7.0, 
-4.0, 2.0], [-2.0, 0.0, -4.0]]], [[[-1.0, -1.0, 5.0], [7.0, 5.0, -5.0]], [[2.0, 4.0, 0.0], [2.0, -4.0, 4.0]], [[-7.0, 0.0, 
-4.0], [5.0, 1.0, -1.0]], [[-5.0, 1.0, -7.0], [-7.0, -3.0, 4.0]], [[2.0, -6.0, 6.0], [-6.0, 3.0, 0.0]]], [[[-1.0, -2.0, 5.0], 
[-1.0, 5.0, -5.0]], [[-4.0, 0.0, -3.0], [-7.0, 4.0, 0.0]], [[5.0, -1.0, 0.0], [6.0, 6.0, -1.0]], [[2.0, -6.0, -6.0], [6.0, 4.0, 
4.0]], [[2.0, -2.0, -6.0], [4.0, 5.0, 4.0]]], [[[1.0, -2.0, -7.0], [2.0, 0.0, -1.0]], [[0.0, 4.0, 5.0], [7.0, -2.0, 7.0]], 
[[5.0, 7.0, 1.0], [3.0, -7.0, -5.0]], [[-7.0, -2.0, 2.0], [0.0, -3.0, -5.0]], [[-2.0, 7.0, 6.0], [-7.0, -6.0, -3.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-6.0, 1.0, -6.0, -2.0, -1.0], [0.0, 0.0, 3.0, 0.0, -5.0], [-5.0, -7.0, -2.0, -6.0, 6.0], 
[2.0, -4.0, -2.0, -2.0, 0.0]], [[3.0, -6.0, 2.0, -4.0, 2.0], [5.0, 2.0, 4.0, -3.0, 1.0], [-6.0, 2.0, 2.0, 7.0, 0.0], [3.0, 7.0, 
-1.0, -2.0, 4.0]], [[7.0, 4.0, 0.0, -3.0, 0.0], [1.0, -4.0, 4.0, -1.0, -4.0], [0.0, 0.0, 5.0, -1.0, -4.0], [-1.0, 6.0, 4.0, 
-3.0, -6.0]]], [[[0.0, -4.0, 1.0, 6.0, 0.0], [0.0, 4.0, -7.0, 5.0, 6.0], [-7.0, 0.0, -6.0, -3.0, 0.0], [7.0, -6.0, 0.0, -3.0, 
-7.0]], [[0.0, 0.0, 3.0, 3.0, -4.0], [4.0, -5.0, -5.0, 6.0, 2.0], [0.0, -2.0, 3.0, -7.0, 2.0], [0.0, -3.0, 0.0, 1.0, 5.0]], 
[[-4.0, 2.0, 0.0, 2.0, -7.0], [7.0, -5.0, -4.0, -7.0, 6.0], [-7.0, 0.0, 1.0, -5.0, 0.0], [1.0, 6.0, 7.0, 5.0, 
3.0]]]])+(1.-msk_arg1)*numpy.array([[[[5.0, 7.0, -2.0, -4.0, 0.0], [-4.0, 6.0, 3.0, 0.0, 7.0], [6.0, 2.0, 1.0, 1.0, 5.0], 
[-1.0, -5.0, -5.0, -7.0, -4.0]], [[2.0, 6.0, -3.0, 0.0, 6.0], [7.0, -6.0, -1.0, 0.0, 0.0], [5.0, 4.0, 6.0, 4.0, -4.0], [5.0, 
1.0, -6.0, 1.0, -4.0]], [[2.0, -7.0, 0.0, 2.0, 3.0], [0.0, -1.0, 4.0, -3.0, -1.0], [4.0, 2.0, -6.0, 0.0, 7.0], [-2.0, -5.0, 
-3.0, 0.0, 0.0]]], [[[-6.0, 3.0, 0.0, -3.0, -3.0], [0.0, 2.0, 3.0, -5.0, -2.0], [7.0, 6.0, 2.0, 1.0, -5.0], [1.0, -2.0, -7.0, 
3.0, 6.0]], [[5.0, 2.0, -1.0, 0.0, 0.0], [-3.0, 7.0, -3.0, 3.0, 0.0], [-7.0, 7.0, -2.0, 2.0, 7.0], [6.0, 3.0, -2.0, -2.0, 
-6.0]], [[7.0, -1.0, 6.0, -6.0, -5.0], [0.0, 4.0, 0.0, 2.0, 1.0], [-2.0, -7.0, 6.0, 0.0, -2.0], [-7.0, 4.0, -4.0, 5.0, -6.0]]]])
      res=generalTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-94.0, -32.0, -32.0, 66.0, -16.0], [-18.0, 45.0, -76.0, 57.0, 39.0], [-61.0, -50.0, -92.0, 
-78.0, 66.0], [59.0, -132.0, -37.0, -5.0, -14.0]], [[7.0, 33.0, -16.0, 40.0, -36.0], [12.0, -28.0, -45.0, 25.0, 15.0], [-61.0, 
-31.0, -15.0, -96.0, -8.0], [39.0, -25.0, 47.0, -24.0, -93.0]], [[-34.0, 20.0, -39.0, -15.0, -23.0], [19.0, -18.0, 19.0, -29.0, 
-22.0], [-51.0, -40.0, -2.0, -46.0, 26.0], [13.0, 9.0, 17.0, -4.0, -8.0]], [[40.0, -5.0, 1.0, -74.0, 41.0], [-2.0, 17.0, 92.0, 
-88.0, -34.0], [27.0, 45.0, 36.0, 119.0, -36.0], [-34.0, 110.0, 5.0, 4.0, 21.0]], [[10.0, -45.0, 67.0, 43.0, -10.0], [25.0, 
-2.0, -68.0, 49.0, 69.0], [30.0, 39.0, 8.0, 18.0, -4.0], [-3.0, -21.0, -19.0, 30.0, 76.0]]], [[[-13.0, -74.0, -30.0, -19.0, 
76.0], [-49.0, 111.0, 40.0, 14.0, -19.0], [-43.0, -4.0, -75.0, 79.0, 26.0], [56.0, -50.0, -71.0, -58.0, -44.0]], [[-60.0, -6.0, 
-32.0, -25.0, 25.0], [-45.0, 17.0, 36.0, 53.0, -73.0], [67.0, -52.0, -8.0, -11.0, 72.0], [-33.0, -91.0, -88.0, -2.0, 79.0]], 
[[-15.0, -13.0, 24.0, 79.0, 4.0], [-44.0, 47.0, -91.0, 22.0, 83.0], [22.0, 45.0, -70.0, 10.0, -30.0], [16.0, -62.0, 7.0, 24.0, 
-53.0]], [[-62.0, 7.0, -33.0, 25.0, 17.0], [-68.0, 37.0, -18.0, 46.0, -23.0], [49.0, -31.0, -55.0, -27.0, 40.0], [-10.0, 
-111.0, -52.0, 3.0, -5.0]], [[57.0, -2.0, 24.0, -5.0, 28.0], [-23.0, -2.0, 10.0, 63.0, -30.0], [52.0, 6.0, 25.0, 11.0, -16.0], 
[-13.0, -22.0, -26.0, -31.0, -16.0]]], [[[-30.0, 1.0, -25.0, 44.0, 20.0], [-67.0, 41.0, -38.0, 80.0, -13.0], [21.0, -33.0, 
-63.0, -48.0, 26.0], [20.0, -126.0, -43.0, -28.0, -62.0]], [[87.0, -27.0, -2.0, -36.0, 72.0], [-36.0, 60.0, 61.0, -1.0, -33.0], 
[-19.0, 29.0, -11.0, 86.0, -48.0], [33.0, 35.0, -9.0, -74.0, -111.0]], [[-24.0, -7.0, 17.0, -6.0, -48.0], [75.0, -41.0, -12.0, 
-62.0, 45.0], [-47.0, 11.0, 31.0, -4.0, 6.0], [-2.0, 74.0, 39.0, 46.0, 80.0]], [[-38.0, -13.0, -36.0, -68.0, 5.0], [28.0, -4.0, 
79.0, -46.0, -57.0], [-29.0, -37.0, 24.0, 20.0, 50.0], [-8.0, 38.0, -28.0, -2.0, 78.0]], [[74.0, -43.0, 31.0, -15.0, 48.0], 
[-7.0, 35.0, 22.0, 32.0, -4.0], [-1.0, 31.0, 8.0, 66.0, -30.0], [22.0, 17.0, -22.0, -47.0, -34.0]]], [[[60.0, 42.0, 6.0, 32.0, 
16.0], [-54.0, 3.0, -24.0, 35.0, -3.0], [41.0, 20.0, -12.0, -16.0, -58.0], [-3.0, -24.0, 29.0, -27.0, -126.0]], [[29.0, 0.0, 
11.0, -52.0, 25.0], [-4.0, -17.0, 61.0, 15.0, -61.0], [66.0, -2.0, 55.0, 39.0, 8.0], [-45.0, 21.0, -38.0, -6.0, 66.0]], [[7.0, 
35.0, -9.0, 48.0, -24.0], [-14.0, -18.0, -52.0, 42.0, 13.0], [-18.0, -21.0, -21.0, -83.0, -12.0], [22.0, -49.0, 31.0, -17.0, 
-88.0]], [[-16.0, -1.0, -49.0, -21.0, 3.0], [8.0, 19.0, 34.0, -34.0, -23.0], [-89.0, -35.0, -27.0, -19.0, 16.0], [46.0, 13.0, 
14.0, -37.0, -63.0]], [[13.0, 27.0, -7.0, 30.0, -17.0], [-9.0, -27.0, -32.0, 71.0, -17.0], [-5.0, -39.0, 0.0, -88.0, 8.0], 
[15.0, -61.0, 4.0, -30.0, -55.0]]]])+(1.-msk_ref)*numpy.array([[[[-21.0, 18.0, 45.0, -58.0, -88.0], [-35.0, 67.0, 3.0, -5.0, 
-2.0], [-13.0, -29.0, 42.0, -14.0, -55.0], [-44.0, 28.0, -17.0, 38.0, 26.0]], [[69.0, 39.0, -61.0, 32.0, 85.0], [-1.0, -2.0, 
-1.0, 20.0, 45.0], [17.0, 67.0, -38.0, 28.0, 106.0], [64.0, -41.0, -18.0, -88.0, -74.0]], [[12.0, 42.0, 0.0, -26.0, -58.0], 
[-86.0, 120.0, -16.0, 24.0, 28.0], [-64.0, 38.0, -24.0, -8.0, 54.0], [22.0, 11.0, 13.0, -48.0, -12.0]], [[-55.0, -43.0, 62.0, 
-49.0, -81.0], [-6.0, 7.0, 41.0, -44.0, -22.0], [49.0, -73.0, 32.0, -29.0, -86.0], [-100.0, -6.0, -19.0, 74.0, 76.0]], [[15.0, 
9.0, -26.0, 6.0, 8.0], [-56.0, 44.0, 27.0, -4.0, 47.0], [24.0, 18.0, -57.0, -11.0, 83.0], [-5.0, -61.0, 13.0, -79.0, 0.0]]], 
[[[-49.0, -12.0, -30.0, 23.0, 13.0], [-18.0, 24.0, 24.0, -45.0, -31.0], [33.0, 116.0, -63.0, 12.0, 44.0], [58.0, -40.0, -43.0, 
-8.0, 50.0]], [[14.0, 32.0, 12.0, -38.0, -2.0], [32.0, -20.0, 20.0, -14.0, 14.0], [66.0, -24.0, 62.0, 12.0, -52.0], [-32.0, 
-6.0, -56.0, 24.0, -12.0]], [[-75.0, -3.0, 7.0, 11.0, -22.0], [25.0, -25.0, -25.0, -12.0, -56.0], [-28.0, 22.0, 19.0, 0.0, 
-79.0], [33.0, 44.0, 14.0, 57.0, 58.0]], [[18.0, -11.0, 34.0, 3.0, -14.0], [36.0, -48.0, -56.0, 55.0, -10.0], [-89.0, -111.0, 
59.0, -14.0, -72.0], [-29.0, 82.0, 79.0, 41.0, -32.0]], [[61.0, -76.0, 11.0, 22.0, 0.0], [-59.0, 51.0, 9.0, 21.0, 20.0], 
[-57.0, -23.0, -88.0, -22.0, 127.0], [-32.0, -25.0, 44.0, -44.0, -38.0]]], [[[-3.0, -42.0, -27.0, 47.0, 31.0], [-25.0, 14.0, 
1.0, -5.0, -15.0], [-28.0, 64.0, -85.0, 0.0, 88.0], [45.0, -25.0, 19.0, -33.0, 6.0]], [[36.0, -20.0, 4.0, 31.0, 12.0], [4.0, 
-7.0, -57.0, 56.0, -11.0], [-113.0, -28.0, -8.0, -3.0, 22.0], [27.0, 61.0, 70.0, -1.0, -50.0]], [[10.0, 60.0, -19.0, -32.0, 
-19.0], [-45.0, 86.0, 16.0, -14.0, 22.0], [27.0, 91.0, -7.0, 19.0, 43.0], [39.0, -24.0, -69.0, -35.0, -10.0]], [[-2.0, 42.0, 
34.0, -62.0, -92.0], [-62.0, 110.0, -6.0, 8.0, 12.0], [-36.0, 4.0, 30.0, -8.0, -18.0], [-18.0, 30.0, -22.0, 10.0, 4.0]], 
[[23.0, 62.0, 21.0, -56.0, -62.0], [-37.0, 89.0, -19.0, 21.0, 16.0], [-37.0, 15.0, 48.0, 8.0, -17.0], [6.0, 41.0, -34.0, 6.0, 
-30.0]]], [[[-32.0, 51.0, -2.0, -18.0, -34.0], [-18.0, 25.0, -17.0, 9.0, 9.0], [-16.0, -1.0, 29.0, -5.0, -44.0], [12.0, 20.0, 
18.0, -8.0, 22.0]], [[15.0, -1.0, 32.0, -53.0, -17.0], [34.0, -1.0, 43.0, -42.0, -12.0], [89.0, 5.0, 54.0, 19.0, -44.0], 
[-44.0, -13.0, -112.0, 64.0, -4.0]], [[-47.0, 70.0, -54.0, 3.0, 61.0], [50.0, -76.0, 42.0, -49.0, 23.0], [149.0, 44.0, 31.0, 
22.0, -50.0], [24.0, -70.0, -57.0, -30.0, 42.0]], [[-85.0, -76.0, -7.0, 62.0, 19.0], [23.0, -73.0, -2.0, -25.0, -56.0], [-13.0, 
-4.0, -55.0, -21.0, -24.0], [10.0, -6.0, 67.0, 28.0, 84.0]], [[7.0, -44.0, -29.0, 59.0, 96.0], [75.0, -128.0, 8.0, -7.0, -9.0], 
[46.0, -27.0, -16.0, 7.0, 3.0], [3.0, -29.0, 23.0, -3.0, -8.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_float_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[7.0, 7.0], [-1.0, -5.0]], [[-6.0, -6.0], [4.0, -3.0]], [[-4.0, -6.0], [-4.0, 7.0]], [[-3.0, 
-7.0], [-6.0, 0.0]], [[-4.0, 6.0], [0.0, -2.0]], [[-4.0, 1.0], [-5.0, 5.0]]])+(1.-msk_arg0)*numpy.array([[[1.0, 5.0], [7.0, 
-1.0]], [[6.0, 7.0], [-2.0, 5.0]], [[3.0, 5.0], [0.0, -2.0]], [[5.0, 0.0], [-1.0, -6.0]], [[6.0, 4.0], [5.0, 0.0]], [[-3.0, 
0.0], [7.0, 7.0]]])
      arg1=-5.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-35.0, -35.0], [5.0, 25.0]], [[30.0, 30.0], [-20.0, 15.0]], [[20.0, 30.0], [20.0, -35.0]], 
[[15.0, 35.0], [30.0, -0.0]], [[20.0, -30.0], [-0.0, 10.0]], [[20.0, -5.0], [25.0, -25.0]]])+(1.-msk_ref)*numpy.array([[[-5.0, 
-25.0], [-35.0, 5.0]], [[-30.0, -35.0], [10.0, -25.0]], [[-15.0, -25.0], [-0.0, 10.0]], [[-25.0, -0.0], [5.0, 30.0]], [[-30.0, 
-20.0], [-25.0, -0.0]], [[15.0, -0.0], [-35.0, -35.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-1.0, -1.0], [-4.0, 5.0]], [[-3.0, 5.0], [6.0, 2.0]], [[0.0, -2.0], [2.0, 3.0]], [[6.0, 
7.0], [2.0, 5.0]], [[0.0, 4.0], [1.0, 3.0]], [[-5.0, 0.0], [-6.0, 1.0]]])+(1.-msk_arg0)*numpy.array([[[0.0, -6.0], [-6.0, 
-4.0]], [[-2.0, -2.0], [7.0, -5.0]], [[5.0, 3.0], [2.0, 1.0]], [[1.0, 0.0], [0.0, 2.0]], [[-5.0, -7.0], [4.0, 7.0]], [[3.0, 
-4.0], [5.0, -2.0]]])
      arg1=numpy.array(6.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-6.0, -6.0], [-24.0, 30.0]], [[-18.0, 30.0], [36.0, 12.0]], [[0.0, -12.0], [12.0, 18.0]], 
[[36.0, 42.0], [12.0, 30.0]], [[0.0, 24.0], [6.0, 18.0]], [[-30.0, 0.0], [-36.0, 6.0]]])+(1.-msk_ref)*numpy.array([[[0.0, 
-36.0], [-36.0, -24.0]], [[-12.0, -12.0], [42.0, -30.0]], [[30.0, 18.0], [12.0, 6.0]], [[6.0, 0.0], [0.0, 12.0]], [[-30.0, 
-42.0], [24.0, 42.0]], [[18.0, -24.0], [30.0, -12.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[0.0, -7.0, 2.0], [-2.0, -4.0, 1.0]], [[3.0, -4.0, 3.0], [5.0, 5.0, -2.0]]], [[[7.0, -7.0, 
-6.0], [3.0, -2.0, 0.0]], [[-3.0, -3.0, -4.0], [6.0, 2.0, -2.0]]], [[[1.0, -6.0, -3.0], [6.0, -1.0, -7.0]], [[-7.0, 6.0, -5.0], 
[-7.0, 6.0, 2.0]]], [[[-4.0, 5.0, 7.0], [2.0, 1.0, -3.0]], [[2.0, 0.0, -4.0], [7.0, -4.0, -2.0]]], [[[4.0, -1.0, -4.0], [-6.0, 
-5.0, 4.0]], [[-6.0, 0.0, -7.0], [-5.0, 7.0, 0.0]]], [[[2.0, 0.0, 1.0], [7.0, -7.0, 6.0]], [[0.0, -3.0, 7.0], [3.0, 4.0, 
0.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, -5.0, -3.0], [-1.0, 0.0, 7.0]], [[1.0, 1.0, 3.0], [2.0, -1.0, -6.0]]], [[[-6.0, 
6.0, 3.0], [-4.0, 7.0, 0.0]], [[-1.0, 7.0, -3.0], [4.0, 7.0, -6.0]]], [[[0.0, -2.0, -7.0], [-5.0, 1.0, 5.0]], [[4.0, -2.0, 
0.0], [5.0, 6.0, -6.0]]], [[[4.0, 7.0, 7.0], [0.0, 0.0, 3.0]], [[-7.0, -2.0, -5.0], [6.0, -5.0, 7.0]]], [[[-1.0, 0.0, -2.0], 
[-2.0, 7.0, 2.0]], [[0.0, 5.0, -2.0], [-4.0, 5.0, 1.0]]], [[[3.0, -3.0, -4.0], [-3.0, 0.0, 1.0]], [[2.0, 3.0, -7.0], [0.0, 
-5.0, 3.0]]]])
      arg1=numpy.array([-1.0, 0.0, -7.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-14.0, -5.0], [-24.0, 9.0]], [[35.0, -3.0], [31.0, 8.0]], [[20.0, 43.0], [42.0, -7.0]], 
[[-45.0, 19.0], [26.0, 7.0]], [[24.0, -22.0], [55.0, 5.0]], [[-9.0, -49.0], [-49.0, -3.0]]])+(1.-msk_ref)*numpy.array([[[28.0, 
-48.0], [-22.0, 40.0]], [[-15.0, 4.0], [22.0, 38.0]], [[49.0, -30.0], [-4.0, 37.0]], [[-53.0, -21.0], [42.0, -55.0]], [[15.0, 
-12.0], [14.0, -3.0]], [[25.0, -4.0], [47.0, -21.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_array_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[-1.0, 0.0], [-5.0, 1.0]], [[6.0, 5.0], [6.0, -6.0]], [[1.0, -6.0], [7.0, -7.0]], [[0.0, 
-5.0], [-5.0, -1.0]], [[-6.0, 6.0], [0.0, -2.0]], [[3.0, -4.0], [0.0, 2.0]]])+(1.-msk_arg0)*numpy.array([[[6.0, -5.0], [-2.0, 
4.0]], [[0.0, 6.0], [6.0, 6.0]], [[1.0, 1.0], [6.0, -2.0]], [[-3.0, -7.0], [6.0, -5.0]], [[2.0, 6.0], [-7.0, -3.0]], [[7.0, 
2.0], [-6.0, 1.0]]])
      arg1=numpy.array([6.0, -6.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-6.0, 6.0], [0.0, 0.0]], [[-30.0, 30.0], [6.0, -6.0]]], [[[36.0, -36.0], [30.0, -30.0]], 
[[36.0, -36.0], [-36.0, 36.0]]], [[[6.0, -6.0], [-36.0, 36.0]], [[42.0, -42.0], [-42.0, 42.0]]], [[[0.0, 0.0], [-30.0, 30.0]], 
[[-30.0, 30.0], [-6.0, 6.0]]], [[[-36.0, 36.0], [36.0, -36.0]], [[0.0, 0.0], [-12.0, 12.0]]], [[[18.0, -18.0], [-24.0, 24.0]], 
[[0.0, 0.0], [12.0, -12.0]]]])+(1.-msk_ref)*numpy.array([[[[36.0, -36.0], [-30.0, 30.0]], [[-12.0, 12.0], [24.0, -24.0]]], 
[[[0.0, 0.0], [36.0, -36.0]], [[36.0, -36.0], [36.0, -36.0]]], [[[6.0, -6.0], [6.0, -6.0]], [[36.0, -36.0], [-12.0, 12.0]]], 
[[[-18.0, 18.0], [-42.0, 42.0]], [[36.0, -36.0], [-30.0, 30.0]]], [[[12.0, -12.0], [36.0, -36.0]], [[-42.0, 42.0], [-18.0, 
18.0]]], [[[42.0, -42.0], [12.0, -12.0]], [[-36.0, 36.0], [6.0, -6.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[6.0, -7.0, 4.0], [-6.0, -1.0, -5.0]], [[-1.0, 6.0, 1.0], [6.0, -3.0, 3.0]]], [[[-7.0, 7.0, 
-6.0], [-1.0, -2.0, 5.0]], [[7.0, -6.0, -4.0], [0.0, -6.0, 3.0]]], [[[-1.0, 3.0, 0.0], [-3.0, 3.0, 3.0]], [[0.0, 7.0, 5.0], 
[5.0, 5.0, 2.0]]], [[[5.0, -3.0, -1.0], [5.0, 4.0, -6.0]], [[-2.0, -5.0, 6.0], [6.0, 7.0, -2.0]]], [[[-6.0, 4.0, 1.0], [3.0, 
-3.0, 7.0]], [[2.0, -5.0, 0.0], [0.0, 0.0, -1.0]]], [[[0.0, 3.0, 1.0], [3.0, 5.0, 6.0]], [[-5.0, -2.0, -6.0], [4.0, 0.0, 
-6.0]]]])+(1.-msk_arg0)*numpy.array([[[[-6.0, 6.0, 7.0], [0.0, 0.0, 4.0]], [[-2.0, -5.0, 5.0], [1.0, -7.0, 4.0]]], [[[-5.0, 
5.0, -1.0], [7.0, 0.0, 2.0]], [[2.0, 0.0, -2.0], [-3.0, 5.0, -1.0]]], [[[5.0, 3.0, -7.0], [-1.0, 0.0, 0.0]], [[-7.0, 3.0, 
-5.0], [7.0, -1.0, 0.0]]], [[[0.0, 4.0, 2.0], [2.0, 1.0, -2.0]], [[7.0, 2.0, -6.0], [-2.0, -4.0, 3.0]]], [[[3.0, -2.0, 0.0], 
[7.0, -4.0, -2.0]], [[-1.0, -1.0, -4.0], [-3.0, 1.0, 0.0]]], [[[-4.0, 4.0, -3.0], [-1.0, -3.0, -2.0]], [[-7.0, -2.0, 7.0], 
[-6.0, -5.0, 3.0]]]])
      arg1=numpy.array([[0.0, -1.0], [5.0, -3.0], [-7.0, -5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-63.0, -5.0], [30.0, 34.0]], [[23.0, -22.0], [-36.0, -12.0]]], [[[77.0, 16.0], [-45.0, 
-18.0]], [[-2.0, 31.0], [-51.0, 3.0]]], [[[15.0, -8.0], [-6.0, -21.0]], [[0.0, -46.0], [11.0, -30.0]]], [[[-8.0, 9.0], [62.0, 
13.0]], [[-67.0, -13.0], [49.0, -17.0]]], [[[13.0, -11.0], [-64.0, -29.0]], [[-25.0, 13.0], [7.0, 5.0]]], [[[8.0, -14.0], 
[-17.0, -48.0]], [[32.0, 41.0], [42.0, 26.0]]]])+(1.-msk_ref)*numpy.array([[[[-19.0, -47.0], [-28.0, -20.0]], [[-60.0, -8.0], 
[-63.0, 0.0]]], [[[32.0, -5.0], [-14.0, -17.0]], [[14.0, 8.0], [32.0, -7.0]]], [[[64.0, 21.0], [0.0, 1.0]], [[50.0, 23.0], 
[-5.0, -4.0]]], [[[6.0, -22.0], [19.0, 5.0]], [[52.0, 17.0], [-41.0, -1.0]]], [[[-10.0, 3.0], [-6.0, 15.0]], [[23.0, 24.0], 
[5.0, 0.0]]], [[[41.0, 7.0], [-1.0, 20.0]], [[-59.0, -22.0], [-46.0, 6.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[1.0, -4.0], [-2.0, 2.0]], [[-1.0, -2.0], [-2.0, 2.0]], [[-5.0, 4.0], [5.0, 7.0]], [[0.0, 
0.0], [7.0, 4.0]], [[3.0, 3.0], [6.0, 0.0]], [[5.0, 3.0], [0.0, -7.0]]])+(1.-msk_arg0)*numpy.array([[[2.0, 0.0], [7.0, -6.0]], 
[[7.0, 0.0], [4.0, 2.0]], [[-6.0, -7.0], [-2.0, 7.0]], [[6.0, -7.0], [2.0, 7.0]], [[1.0, 6.0], [-2.0, 4.0]], [[0.0, 2.0], 
[-3.0, -5.0]]])
      arg1=Data(-1.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-1.0, 4.0], [2.0, -2.0]], [[1.0, 2.0], [2.0, -2.0]], [[5.0, -4.0], [-5.0, -7.0]], [[-0.0, 
-0.0], [-7.0, -4.0]], [[-3.0, -3.0], [-6.0, -0.0]], [[-5.0, -3.0], [-0.0, 7.0]]])+(1.-msk_ref)*numpy.array([[[-2.0, -0.0], 
[-7.0, 6.0]], [[-7.0, -0.0], [-4.0, -2.0]], [[6.0, 7.0], [2.0, -7.0]], [[-6.0, 7.0], [-2.0, -7.0]], [[-1.0, -6.0], [2.0, 
-4.0]], [[-0.0, -2.0], [3.0, 5.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTensorProduct(arg0,arg1,axis_offset=0)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[7.0, 0.0, 5.0], [3.0, -3.0, 4.0]], [[7.0, 5.0, -1.0], [-6.0, -2.0, 7.0]]], [[[7.0, 5.0, 
4.0], [-6.0, 3.0, -4.0]], [[4.0, 0.0, 2.0], [1.0, -3.0, 0.0]]], [[[-6.0, 5.0, 5.0], [6.0, -3.0, 5.0]], [[5.0, -4.0, -2.0], 
[4.0, 5.0, 2.0]]], [[[-6.0, 5.0, -7.0], [0.0, 2.0, -4.0]], [[1.0, -5.0, -1.0], [5.0, 7.0, -4.0]]], [[[6.0, -6.0, 6.0], [4.0, 
4.0, 6.0]], [[-5.0, 7.0, 7.0], [0.0, -6.0, 2.0]]], [[[0.0, 7.0, 2.0], [0.0, -7.0, 0.0]], [[-1.0, 2.0, -4.0], [-6.0, 3.0, 
4.0]]]])+(1.-msk_arg0)*numpy.array([[[[2.0, -5.0, -2.0], [1.0, 7.0, -6.0]], [[5.0, 6.0, 7.0], [0.0, -6.0, -4.0]]], [[[3.0, 
-6.0, -7.0], [0.0, 6.0, 0.0]], [[-5.0, 6.0, -1.0], [-4.0, 0.0, -2.0]]], [[[2.0, 3.0, -5.0], [3.0, 3.0, -4.0]], [[0.0, 7.0, 
-5.0], [-5.0, -7.0, 0.0]]], [[[4.0, 7.0, 4.0], [-2.0, 2.0, -3.0]], [[-2.0, -2.0, 0.0], [-2.0, 5.0, -2.0]]], [[[1.0, 3.0, 0.0], 
[7.0, 4.0, 2.0]], [[6.0, 1.0, -2.0], [5.0, 3.0, -5.0]]], [[[2.0, 0.0, 0.0], [3.0, -1.0, -4.0]], [[-4.0, -2.0, 0.0], [0.0, -5.0, 
2.0]]]])
      arg1=Data(numpy.array([-4.0, 2.0, -6.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-58.0, -42.0], [-12.0, -22.0]], [[-42.0, 54.0], [-28.0, -10.0]], [[4.0, -60.0], [-16.0, 
-18.0]], [[76.0, 28.0], [-8.0, 18.0]], [[-72.0, -44.0], [-8.0, -24.0]], [[2.0, -14.0], [32.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[-6.0, 46.0], [-50.0, 12.0]], [[18.0, 12.0], [38.0, 28.0]], [[28.0, 18.0], [44.0, 6.0]], 
[[-26.0, 30.0], [4.0, 30.0]], [[2.0, -32.0], [-10.0, 16.0]], [[-8.0, 10.0], [12.0, -22.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_constData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[0.0, -5.0], [-7.0, -5.0]], [[2.0, -6.0], [-3.0, 5.0]], [[-6.0, -2.0], [1.0, -3.0]], [[-7.0, 
3.0], [0.0, -4.0]], [[-4.0, 3.0], [-3.0, 3.0]], [[2.0, -6.0], [-3.0, 0.0]]])+(1.-msk_arg0)*numpy.array([[[0.0, -4.0], [-2.0, 
7.0]], [[5.0, 0.0], [3.0, -6.0]], [[-1.0, -5.0], [4.0, -1.0]], [[-2.0, 6.0], [7.0, 5.0]], [[-5.0, -1.0], [4.0, -7.0]], [[6.0, 
-3.0], [0.0, -3.0]]])
      arg1=Data(numpy.array([2.0, -4.0]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 0.0], [-10.0, 20.0]], [[-14.0, 28.0], [-10.0, 20.0]]], [[[4.0, -8.0], [-12.0, 24.0]], 
[[-6.0, 12.0], [10.0, -20.0]]], [[[-12.0, 24.0], [-4.0, 8.0]], [[2.0, -4.0], [-6.0, 12.0]]], [[[-14.0, 28.0], [6.0, -12.0]], 
[[0.0, 0.0], [-8.0, 16.0]]], [[[-8.0, 16.0], [6.0, -12.0]], [[-6.0, 12.0], [6.0, -12.0]]], [[[4.0, -8.0], [-12.0, 24.0]], 
[[-6.0, 12.0], [0.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, 0.0], [-8.0, 16.0]], [[-4.0, 8.0], [14.0, -28.0]]], [[[10.0, 
-20.0], [0.0, 0.0]], [[6.0, -12.0], [-12.0, 24.0]]], [[[-2.0, 4.0], [-10.0, 20.0]], [[8.0, -16.0], [-2.0, 4.0]]], [[[-4.0, 
8.0], [12.0, -24.0]], [[14.0, -28.0], [10.0, -20.0]]], [[[-10.0, 20.0], [-2.0, 4.0]], [[8.0, -16.0], [-14.0, 28.0]]], [[[12.0, 
-24.0], [-6.0, 12.0]], [[0.0, 0.0], [-6.0, 12.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-7.0, -6.0, 0.0], [4.0, -4.0, 7.0]], [[-7.0, -3.0, 5.0], [1.0, -2.0, 1.0]]], [[[2.0, 0.0, 
-3.0], [0.0, 0.0, 7.0]], [[5.0, 7.0, -4.0], [2.0, -1.0, 0.0]]], [[[1.0, 2.0, 6.0], [-2.0, 5.0, 7.0]], [[-3.0, -2.0, 3.0], 
[-7.0, 4.0, -6.0]]], [[[-2.0, 7.0, 5.0], [4.0, -2.0, -6.0]], [[5.0, -4.0, -4.0], [5.0, -6.0, 2.0]]], [[[-4.0, 0.0, 7.0], [-3.0, 
0.0, -3.0]], [[-4.0, -7.0, -7.0], [-1.0, 0.0, -6.0]]], [[[5.0, 1.0, -6.0], [0.0, 4.0, 1.0]], [[1.0, 4.0, -3.0], [3.0, 0.0, 
-3.0]]]])+(1.-msk_arg0)*numpy.array([[[[3.0, -2.0, 7.0], [0.0, 2.0, -4.0]], [[-4.0, 0.0, 2.0], [0.0, 4.0, 5.0]]], [[[-1.0, 6.0, 
-3.0], [0.0, -1.0, -1.0]], [[-3.0, 5.0, 6.0], [-1.0, 7.0, 3.0]]], [[[-6.0, 1.0, -3.0], [0.0, -4.0, -7.0]], [[1.0, -4.0, -7.0], 
[4.0, 7.0, -4.0]]], [[[1.0, 0.0, -7.0], [3.0, 0.0, 6.0]], [[-2.0, -1.0, 0.0], [-4.0, 0.0, 2.0]]], [[[7.0, 4.0, -5.0], [0.0, 
-5.0, 2.0]], [[-3.0, 1.0, -5.0], [-6.0, 7.0, 2.0]]], [[[7.0, 3.0, 7.0], [-3.0, 0.0, 1.0]], [[0.0, 2.0, 0.0], [-3.0, -6.0, 
4.0]]]])
      arg1=Data(numpy.array([[4.0, -4.0], [-6.0, 1.0], [5.0, -7.0]]),self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 22.0], [75.0, -69.0]], [[15.0, -10.0], [21.0, -13.0]]], [[[-7.0, 13.0], [35.0, -49.0]], 
[[-42.0, 15.0], [14.0, -9.0]]], [[[22.0, -44.0], [-3.0, -36.0]], [[15.0, -11.0], [-82.0, 74.0]]], [[[-25.0, -20.0], [-2.0, 
24.0]], [[24.0, 4.0], [66.0, -40.0]]], [[[19.0, -33.0], [-27.0, 33.0]], [[-9.0, 58.0], [-34.0, 46.0]]], [[[-16.0, 23.0], 
[-19.0, -3.0]], [[-35.0, 21.0], [-3.0, 9.0]]]])+(1.-msk_ref)*numpy.array([[[[59.0, -63.0], [-32.0, 30.0]], [[-6.0, 2.0], [1.0, 
-31.0]]], [[[-55.0, 31.0], [1.0, 6.0]], [[-12.0, -25.0], [-31.0, -10.0]]], [[[-45.0, 46.0], [-11.0, 45.0]], [[-7.0, 41.0], 
[-46.0, 19.0]]], [[[-31.0, 45.0], [42.0, -54.0]], [[-2.0, 7.0], [-6.0, 2.0]]], [[[-21.0, 11.0], [40.0, -19.0]], [[-43.0, 48.0], 
[-56.0, 17.0]]], [[[45.0, -74.0], [-7.0, 5.0]], [[-12.0, 2.0], [44.0, -22.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[7.0, 6.0], [5.0, 1.0]], [[-6.0, -1.0], [-6.0, -2.0]], [[2.0, -4.0], [0.0, 4.0]], [[6.0, 
3.0], [7.0, 6.0]], [[-5.0, 4.0], [-2.0, -6.0]], [[-5.0, -5.0], [6.0, -5.0]]])+(1.-msk_arg0)*numpy.array([[[0.0, 0.0], [1.0, 
3.0]], [[4.0, -7.0], [-4.0, 7.0]], [[-2.0, 0.0], [-5.0, -5.0]], [[2.0, -2.0], [-3.0, 0.0]], [[4.0, -5.0], [6.0, 5.0]], [[1.0, 
1.0], [3.0, -1.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(1.0)+(1-msk_arg1)*(2.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 6.0], [5.0, 1.0]], [[-6.0, -1.0], [-6.0, -2.0]], [[2.0, -4.0], [0.0, 4.0]], [[6.0, 3.0], 
[7.0, 6.0]], [[-5.0, 4.0], [-2.0, -6.0]], [[-5.0, -5.0], [6.0, -5.0]]])+(1.-msk_ref)*numpy.array([[[0.0, 0.0], [2.0, 6.0]], 
[[8.0, -14.0], [-8.0, 14.0]], [[-4.0, 0.0], [-10.0, -10.0]], [[4.0, -4.0], [-6.0, 0.0]], [[8.0, -10.0], [12.0, 10.0]], [[2.0, 
2.0], [6.0, -2.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank1_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-1.0, -5.0, 3.0], [1.0, 0.0, -3.0]], [[6.0, -6.0, 0.0], [1.0, -4.0, 3.0]]], [[[-5.0, -6.0, 
-4.0], [-4.0, -3.0, -5.0]], [[-4.0, -5.0, -1.0], [-7.0, -6.0, -3.0]]], [[[-3.0, -7.0, -6.0], [6.0, -3.0, -5.0]], [[-3.0, -1.0, 
1.0], [5.0, -1.0, -5.0]]], [[[0.0, 6.0, 4.0], [6.0, -3.0, 0.0]], [[-1.0, -3.0, -2.0], [6.0, 4.0, -6.0]]], [[[4.0, 7.0, -5.0], 
[-4.0, 4.0, 4.0]], [[5.0, -5.0, -2.0], [-2.0, 2.0, 7.0]]], [[[7.0, -4.0, 1.0], [0.0, 5.0, 5.0]], [[-2.0, -3.0, -3.0], [7.0, 
-2.0, -3.0]]]])+(1.-msk_arg0)*numpy.array([[[[0.0, 6.0, 2.0], [-6.0, -1.0, -6.0]], [[1.0, 2.0, -2.0], [0.0, 0.0, -1.0]]], 
[[[-4.0, 0.0, -7.0], [2.0, 1.0, -2.0]], [[-6.0, 1.0, 6.0], [7.0, -5.0, 4.0]]], [[[5.0, 7.0, -1.0], [-1.0, 5.0, -4.0]], [[4.0, 
-1.0, 0.0], [2.0, -2.0, 5.0]]], [[[-7.0, -7.0, -2.0], [1.0, -4.0, -3.0]], [[3.0, -4.0, 3.0], [-3.0, -2.0, 1.0]]], [[[-1.0, 7.0, 
2.0], [0.0, -6.0, 7.0]], [[-3.0, -7.0, 0.0], [3.0, 7.0, 5.0]]], [[[0.0, 1.0, 3.0], [5.0, 4.0, 2.0]], [[-4.0, -6.0, 4.0], [-4.0, 
1.0, -2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([5.0, 4.0, -5.0])+(1.-msk_arg1)*numpy.array([7.0, -4.0, 2.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-40.0, 20.0], [6.0, -26.0]], [[-29.0, -7.0], [-35.0, -44.0]], [[-13.0, 43.0], [-24.0, 46.0]], 
[[4.0, 18.0], [-7.0, 76.0]], [[73.0, -24.0], [15.0, -37.0]], [[14.0, -5.0], [-7.0, 42.0]]])+(1.-msk_ref)*numpy.array([[[-20.0, 
-50.0], [-5.0, -2.0]], [[-42.0, 6.0], [-34.0, 77.0]], [[5.0, -35.0], [32.0, 32.0]], [[-25.0, 17.0], [43.0, -11.0]], [[-31.0, 
38.0], [7.0, 3.0]], [[2.0, 23.0], [4.0, -36.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank3_expandedData_rank1_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[1.0, 0.0], [3.0, 6.0]], [[1.0, 0.0], [-5.0, 2.0]], [[-2.0, -7.0], [2.0, -1.0]], [[7.0, 
-3.0], [4.0, -4.0]], [[-5.0, -5.0], [-1.0, 1.0]], [[-2.0, -3.0], [-5.0, 0.0]]])+(1.-msk_arg0)*numpy.array([[[-1.0, 3.0], [-4.0, 
0.0]], [[-4.0, 5.0], [-3.0, -2.0]], [[7.0, 7.0], [-6.0, 1.0]], [[4.0, 0.0], [3.0, -3.0]], [[-3.0, 5.0], [0.0, 7.0]], [[-6.0, 
-3.0], [6.0, 5.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-3.0, -6.0])+(1.-msk_arg1)*numpy.array([-5.0, 0.0])
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-3.0, -6.0], [0.0, 0.0]], [[-9.0, -18.0], [-18.0, -36.0]]], [[[-3.0, -6.0], [0.0, 0.0]], 
[[15.0, 30.0], [-6.0, -12.0]]], [[[6.0, 12.0], [21.0, 42.0]], [[-6.0, -12.0], [3.0, 6.0]]], [[[-21.0, -42.0], [9.0, 18.0]], 
[[-12.0, -24.0], [12.0, 24.0]]], [[[15.0, 30.0], [15.0, 30.0]], [[3.0, 6.0], [-3.0, -6.0]]], [[[6.0, 12.0], [9.0, 18.0]], 
[[15.0, 30.0], [0.0, 0.0]]]])+(1.-msk_ref)*numpy.array([[[[5.0, 0.0], [-15.0, 0.0]], [[20.0, 0.0], [0.0, 0.0]]], [[[20.0, 0.0], 
[-25.0, 0.0]], [[15.0, 0.0], [10.0, 0.0]]], [[[-35.0, 0.0], [-35.0, 0.0]], [[30.0, 0.0], [-5.0, 0.0]]], [[[-20.0, 0.0], [0.0, 
0.0]], [[-15.0, 0.0], [15.0, 0.0]]], [[[15.0, 0.0], [-25.0, 0.0]], [[0.0, 0.0], [-35.0, 0.0]]], [[[30.0, 0.0], [15.0, 0.0]], 
[[-30.0, 0.0], [-25.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank2_offset1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-7.0, -2.0, 6.0], [-6.0, -3.0, -5.0]], [[-1.0, 4.0, 0.0], [-4.0, -4.0, 3.0]]], [[[-7.0, 
5.0, 3.0], [-1.0, 7.0, 0.0]], [[0.0, -3.0, -2.0], [-7.0, 1.0, 2.0]]], [[[-4.0, 2.0, -1.0], [1.0, 1.0, -4.0]], [[-5.0, -4.0, 
3.0], [0.0, -4.0, -2.0]]], [[[0.0, 0.0, -3.0], [1.0, -1.0, 4.0]], [[7.0, 0.0, -5.0], [5.0, 2.0, -4.0]]], [[[5.0, -4.0, 2.0], 
[3.0, -1.0, 7.0]], [[-2.0, 6.0, -4.0], [-3.0, 4.0, 1.0]]], [[[-6.0, -2.0, -3.0], [-6.0, -3.0, 2.0]], [[-1.0, 0.0, 6.0], [3.0, 
4.0, 0.0]]]])+(1.-msk_arg0)*numpy.array([[[[3.0, 2.0, -6.0], [-1.0, 3.0, 5.0]], [[-6.0, -4.0, -4.0], [0.0, 0.0, -1.0]]], 
[[[-4.0, 4.0, 7.0], [0.0, 1.0, -6.0]], [[-5.0, 0.0, 1.0], [3.0, 3.0, -5.0]]], [[[-5.0, 0.0, 1.0], [0.0, 0.0, 1.0]], [[4.0, 6.0, 
5.0], [1.0, -2.0, 0.0]]], [[[2.0, 5.0, -5.0], [4.0, 3.0, -6.0]], [[0.0, 0.0, -6.0], [-2.0, 4.0, -1.0]]], [[[-6.0, 2.0, -4.0], 
[-3.0, 6.0, -3.0]], [[-5.0, 6.0, 1.0], [-1.0, 2.0, -4.0]]], [[[-5.0, -4.0, -2.0], [1.0, 4.0, -3.0]], [[-5.0, 2.0, -2.0], [-6.0, 
-2.0, 2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, 4.0], [5.0, -1.0], [6.0, 4.0]])+(1.-msk_arg1)*numpy.array([[3.0, 1.0], [4.0, -6.0], 
[-4.0, 5.0]])
      res=generalTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[54.0, -2.0], [-21.0, -41.0]], [[24.0, -8.0], [14.0, 0.0]]], [[[71.0, -21.0], [39.0, -11.0]], 
[[-27.0, -5.0], [45.0, -21.0]]], [[[20.0, -22.0], [-23.0, -13.0]], [[18.0, -4.0], [-32.0, -4.0]]], [[[-18.0, -12.0], [15.0, 
21.0]], [[-58.0, 8.0], [-34.0, 2.0]]], [[[-28.0, 32.0], [25.0, 41.0]], [[14.0, -30.0], [38.0, -12.0]]], [[[-4.0, -34.0], [21.0, 
-13.0]], [[40.0, 20.0], [8.0, 8.0]]]])+(1.-msk_ref)*numpy.array([[[[41.0, -39.0], [-11.0, 6.0]], [[-18.0, -2.0], [4.0, -5.0]]], 
[[[-24.0, 7.0], [28.0, -36.0]], [[-19.0, 0.0], [41.0, -40.0]]], [[[-19.0, 0.0], [-4.0, 5.0]], [[16.0, -7.0], [-5.0, 13.0]]], 
[[[46.0, -53.0], [48.0, -44.0]], [[24.0, -30.0], [14.0, -31.0]]], [[[6.0, -38.0], [27.0, -54.0]], [[5.0, -36.0], [21.0, 
-33.0]]], [[[-23.0, 9.0], [31.0, -38.0]], [[1.0, -27.0], [-34.0, 16.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_float_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[3.0, 4.0, -7.0, 3.0], [1.0, 5.0, -6.0, 3.0], [7.0, -1.0, -3.0, -2.0]], [[4.0, -3.0, -3.0, 
5.0], [-5.0, 3.0, 4.0, -7.0], [1.0, -4.0, -6.0, -3.0]]], [[[5.0, 6.0, -3.0, 2.0], [-2.0, 0.0, 6.0, 6.0], [-7.0, 4.0, -2.0, 
7.0]], [[-2.0, -7.0, 1.0, -5.0], [-7.0, 4.0, -1.0, -6.0], [-6.0, -4.0, -4.0, 3.0]]], [[[6.0, -7.0, 3.0, -6.0], [4.0, -3.0, 4.0, 
-3.0], [0.0, 1.0, 7.0, 0.0]], [[3.0, 5.0, -7.0, 2.0], [2.0, 2.0, 6.0, -5.0], [-4.0, 4.0, -1.0, 
-1.0]]]])+(1.-msk_arg0)*numpy.array([[[[-4.0, -2.0, 6.0, -4.0], [-2.0, 2.0, 0.0, -7.0], [0.0, 4.0, 0.0, 0.0]], [[-3.0, -6.0, 
-3.0, -2.0], [-7.0, 1.0, -7.0, 5.0], [1.0, 2.0, 3.0, 5.0]]], [[[-3.0, 6.0, 1.0, -2.0], [0.0, 0.0, -1.0, -6.0], [1.0, 7.0, 4.0, 
3.0]], [[-5.0, 1.0, 4.0, 4.0], [-2.0, 2.0, -4.0, 7.0], [0.0, 4.0, -2.0, 7.0]]], [[[-5.0, -4.0, 0.0, 2.0], [-2.0, -7.0, -1.0, 
4.0], [-6.0, -5.0, 6.0, 1.0]], [[2.0, 2.0, 6.0, 5.0], [1.0, 1.0, -3.0, 2.0], [0.0, 1.0, -4.0, -1.0]]]])
      arg1=-7.0
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-21.0, -28.0, 49.0, -21.0], [-7.0, -35.0, 42.0, -21.0], [-49.0, 7.0, 21.0, 14.0]], [[-28.0, 
21.0, 21.0, -35.0], [35.0, -21.0, -28.0, 49.0], [-7.0, 28.0, 42.0, 21.0]]], [[[-35.0, -42.0, 21.0, -14.0], [14.0, -0.0, -42.0, 
-42.0], [49.0, -28.0, 14.0, -49.0]], [[14.0, 49.0, -7.0, 35.0], [49.0, -28.0, 7.0, 42.0], [42.0, 28.0, 28.0, -21.0]]], 
[[[-42.0, 49.0, -21.0, 42.0], [-28.0, 21.0, -28.0, 21.0], [-0.0, -7.0, -49.0, -0.0]], [[-21.0, -35.0, 49.0, -14.0], [-14.0, 
-14.0, -42.0, 35.0], [28.0, -28.0, 7.0, 7.0]]]])+(1.-msk_ref)*numpy.array([[[[28.0, 14.0, -42.0, 28.0], [14.0, -14.0, -0.0, 
49.0], [-0.0, -28.0, -0.0, -0.0]], [[21.0, 42.0, 21.0, 14.0], [49.0, -7.0, 49.0, -35.0], [-7.0, -14.0, -21.0, -35.0]]], 
[[[21.0, -42.0, -7.0, 14.0], [-0.0, -0.0, 7.0, 42.0], [-7.0, -49.0, -28.0, -21.0]], [[35.0, -7.0, -28.0, -28.0], [14.0, -14.0, 
28.0, -49.0], [-0.0, -28.0, 14.0, -49.0]]], [[[35.0, 28.0, -0.0, -14.0], [14.0, 49.0, 7.0, -28.0], [42.0, 35.0, -42.0, -7.0]], 
[[-14.0, -14.0, -42.0, -35.0], [-7.0, -7.0, 21.0, -14.0], [-0.0, -7.0, 28.0, 7.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_array_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[4.0, -2.0, 1.0, 0.0], [3.0, 1.0, 0.0, -4.0], [1.0, 0.0, -1.0, -7.0]], [[2.0, 0.0, -1.0, 
-3.0], [1.0, 2.0, -6.0, 3.0], [-1.0, 1.0, -6.0, -1.0]]], [[[3.0, 0.0, -6.0, 0.0], [-4.0, 0.0, 3.0, 1.0], [-2.0, 1.0, 0.0, 
-1.0]], [[0.0, 3.0, -6.0, 2.0], [-7.0, 3.0, -4.0, -2.0], [6.0, 0.0, -6.0, -4.0]]], [[[4.0, -5.0, 3.0, 7.0], [2.0, 7.0, -3.0, 
3.0], [4.0, 5.0, -2.0, -5.0]], [[-2.0, -7.0, 3.0, -1.0], [1.0, 1.0, -1.0, -7.0], [-6.0, -5.0, -5.0, 
4.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, 5.0, -5.0, 1.0], [-3.0, 5.0, 6.0, 1.0], [4.0, 0.0, -1.0, 6.0]], [[-4.0, 0.0, 2.0, 
1.0], [7.0, 6.0, -1.0, -1.0], [4.0, 7.0, -3.0, -7.0]]], [[[1.0, -2.0, 6.0, 5.0], [2.0, 5.0, 7.0, 6.0], [-1.0, 0.0, -2.0, 
-6.0]], [[5.0, -1.0, -2.0, 4.0], [5.0, 4.0, 1.0, 3.0], [-2.0, 7.0, -1.0, -1.0]]], [[[0.0, -7.0, 6.0, -4.0], [-6.0, 3.0, -5.0, 
0.0], [0.0, 0.0, 4.0, -3.0]], [[-3.0, -6.0, 4.0, 0.0], [-5.0, -4.0, -3.0, 5.0], [5.0, -2.0, 1.0, 6.0]]]])
      arg1=numpy.array(0.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, -0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.0], [0.0, 0.0, -0.0, -0.0]], [[0.0, 0.0, -0.0, 
-0.0], [0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, -0.0, -0.0]]], [[[0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, 0.0, 0.0], [-0.0, 0.0, 0.0, 
-0.0]], [[0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, -0.0, -0.0], [0.0, 0.0, -0.0, -0.0]]], [[[0.0, -0.0, 0.0, 0.0], [0.0, 0.0, -0.0, 
0.0], [0.0, 0.0, -0.0, -0.0]], [[-0.0, -0.0, 0.0, -0.0], [0.0, 0.0, -0.0, -0.0], [-0.0, -0.0, -0.0, 
0.0]]]])+(1.-msk_ref)*numpy.array([[[[-0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -0.0, 0.0]], [[-0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, -0.0, -0.0], [0.0, 0.0, -0.0, -0.0]]], [[[0.0, -0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0], [-0.0, 0.0, -0.0, 
-0.0]], [[0.0, -0.0, -0.0, 0.0], [0.0, 0.0, 0.0, 0.0], [-0.0, 0.0, -0.0, -0.0]]], [[[0.0, -0.0, 0.0, -0.0], [-0.0, 0.0, -0.0, 
0.0], [0.0, 0.0, 0.0, -0.0]], [[-0.0, -0.0, 0.0, 0.0], [-0.0, -0.0, -0.0, 0.0], [0.0, -0.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_constData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[2.0, 1.0, 4.0, -7.0], [0.0, -6.0, 2.0, 1.0], [-6.0, 4.0, -6.0, 3.0]], [[-4.0, 7.0, 5.0, 
-5.0], [-2.0, -7.0, 4.0, 0.0], [5.0, 5.0, -6.0, 0.0]]], [[[-7.0, 4.0, 7.0, -6.0], [0.0, 0.0, 5.0, -5.0], [-1.0, -3.0, 3.0, 
-3.0]], [[4.0, 4.0, 0.0, -5.0], [-1.0, 0.0, -4.0, -5.0], [1.0, -5.0, 1.0, 4.0]]], [[[5.0, 4.0, 1.0, -3.0], [0.0, 7.0, -1.0, 
3.0], [1.0, -6.0, -5.0, -5.0]], [[-4.0, -1.0, 1.0, 6.0], [-3.0, 0.0, -2.0, 0.0], [-6.0, -3.0, 0.0, 
1.0]]]])+(1.-msk_arg0)*numpy.array([[[[3.0, -3.0, -3.0, 0.0], [-3.0, -4.0, -4.0, 6.0], [0.0, -6.0, -5.0, 5.0]], [[6.0, 1.0, 
2.0, 7.0], [0.0, 7.0, 1.0, 5.0], [-2.0, -4.0, 6.0, 5.0]]], [[[-3.0, -1.0, 5.0, -5.0], [3.0, 6.0, 6.0, 0.0], [6.0, 1.0, 1.0, 
5.0]], [[7.0, -7.0, -6.0, 7.0], [-3.0, 6.0, 6.0, -2.0], [-2.0, 1.0, -2.0, 5.0]]], [[[-6.0, 4.0, -6.0, 0.0], [-1.0, -7.0, 0.0, 
0.0], [4.0, -7.0, -4.0, -2.0]], [[3.0, -3.0, 6.0, -2.0], [5.0, -5.0, 3.0, -2.0], [0.0, -4.0, 4.0, 6.0]]]])
      arg1=Data(0.0,self.functionspace)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 0.0, 0.0, -0.0], [0.0, -0.0, 0.0, 0.0], [-0.0, 0.0, -0.0, 0.0]], [[-0.0, 0.0, 0.0, 
-0.0], [-0.0, -0.0, 0.0, 0.0], [0.0, 0.0, -0.0, 0.0]]], [[[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, -0.0], [-0.0, -0.0, 0.0, 
-0.0]], [[0.0, 0.0, 0.0, -0.0], [-0.0, 0.0, -0.0, -0.0], [0.0, -0.0, 0.0, 0.0]]], [[[0.0, 0.0, 0.0, -0.0], [0.0, 0.0, -0.0, 
0.0], [0.0, -0.0, -0.0, -0.0]], [[-0.0, -0.0, 0.0, 0.0], [-0.0, 0.0, -0.0, 0.0], [-0.0, -0.0, 0.0, 
0.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, -0.0, -0.0, 0.0], [-0.0, -0.0, -0.0, 0.0], [0.0, -0.0, -0.0, 0.0]], [[0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0], [-0.0, -0.0, 0.0, 0.0]]], [[[-0.0, -0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0]], 
[[0.0, -0.0, -0.0, 0.0], [-0.0, 0.0, 0.0, -0.0], [-0.0, 0.0, -0.0, 0.0]]], [[[-0.0, 0.0, -0.0, 0.0], [-0.0, -0.0, 0.0, 0.0], 
[0.0, -0.0, -0.0, -0.0]], [[0.0, -0.0, 0.0, -0.0], [0.0, -0.0, 0.0, -0.0], [0.0, -0.0, 0.0, 0.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTensorProduct_expandedData_rank4_expandedData_rank0_offset0(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[4.0, 0.0, -2.0, 6.0], [7.0, -4.0, 1.0, -5.0], [5.0, 4.0, -6.0, -4.0]], [[7.0, -7.0, -4.0, 
6.0], [2.0, -3.0, 0.0, -2.0], [-6.0, 4.0, -2.0, 1.0]]], [[[1.0, 3.0, -7.0, 2.0], [-7.0, -6.0, -4.0, 1.0], [0.0, -3.0, 0.0, 
-4.0]], [[-3.0, -3.0, -1.0, -7.0], [-3.0, 6.0, 7.0, 2.0], [5.0, 2.0, -7.0, -7.0]]], [[[7.0, -6.0, 7.0, -6.0], [7.0, 1.0, -3.0, 
-3.0], [-1.0, -1.0, -3.0, -1.0]], [[4.0, -1.0, -3.0, 0.0], [-4.0, -2.0, -4.0, -4.0], [-6.0, 6.0, -7.0, 
7.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, 7.0, -2.0, 7.0], [-6.0, -1.0, 3.0, -4.0], [0.0, 6.0, -2.0, 1.0]], [[3.0, 2.0, 
-2.0, 5.0], [-3.0, 7.0, 7.0, 5.0], [6.0, -2.0, -5.0, 0.0]]], [[[2.0, 6.0, -4.0, 6.0], [4.0, 2.0, 4.0, -2.0], [1.0, 3.0, 4.0, 
-7.0]], [[4.0, 0.0, -5.0, -2.0], [3.0, -5.0, 4.0, -2.0], [-3.0, 3.0, 2.0, -3.0]]], [[[-2.0, -6.0, 0.0, 3.0], [7.0, -2.0, -3.0, 
-3.0], [-7.0, 6.0, -3.0, 2.0]], [[6.0, -3.0, -1.0, 5.0], [-3.0, -1.0, -2.0, 3.0], [0.0, -4.0, 0.0, -4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(6.0)+(1-msk_arg1)*(1.0)
      res=generalTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[24.0, 0.0, -12.0, 36.0], [42.0, -24.0, 6.0, -30.0], [30.0, 24.0, -36.0, -24.0]], [[42.0, 
-42.0, -24.0, 36.0], [12.0, -18.0, 0.0, -12.0], [-36.0, 24.0, -12.0, 6.0]]], [[[6.0, 18.0, -42.0, 12.0], [-42.0, -36.0, -24.0, 
6.0], [0.0, -18.0, 0.0, -24.0]], [[-18.0, -18.0, -6.0, -42.0], [-18.0, 36.0, 42.0, 12.0], [30.0, 12.0, -42.0, -42.0]]], 
[[[42.0, -36.0, 42.0, -36.0], [42.0, 6.0, -18.0, -18.0], [-6.0, -6.0, -18.0, -6.0]], [[24.0, -6.0, -18.0, 0.0], [-24.0, -12.0, 
-24.0, -24.0], [-36.0, 36.0, -42.0, 42.0]]]])+(1.-msk_ref)*numpy.array([[[[-7.0, 7.0, -2.0, 7.0], [-6.0, -1.0, 3.0, -4.0], 
[0.0, 6.0, -2.0, 1.0]], [[3.0, 2.0, -2.0, 5.0], [-3.0, 7.0, 7.0, 5.0], [6.0, -2.0, -5.0, 0.0]]], [[[2.0, 6.0, -4.0, 6.0], [4.0, 
2.0, 4.0, -2.0], [1.0, 3.0, 4.0, -7.0]], [[4.0, 0.0, -5.0, -2.0], [3.0, -5.0, 4.0, -2.0], [-3.0, 3.0, 2.0, -3.0]]], [[[-2.0, 
-6.0, 0.0, 3.0], [7.0, -2.0, -3.0, -3.0], [-7.0, 6.0, -3.0, 2.0]], [[6.0, -3.0, -1.0, 5.0], [-3.0, -1.0, -2.0, 3.0], [0.0, 
-4.0, 0.0, -4.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")














   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_array_rank1(self):
      arg0=numpy.array([[-5.0, 6.0], [-1.0, -1.0], [1.0, -7.0]])
      arg1=numpy.array([-7.0, 0.0, -2.0])
      res=transposed_tensor_mult(arg0,arg1)
      ref=numpy.array([33.0, -28.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_array_rank2(self):
      arg0=numpy.array([[7.0, 5.0], [3.0, -7.0], [1.0, 2.0]])
      arg1=numpy.array([[-2.0, 5.0], [0.0, -1.0], [0.0, 3.0]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=numpy.array([[-14.0, 35.0], [-10.0, 38.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_constData_rank1(self):
      arg0=numpy.array([[-4.0, -2.0], [-1.0, -7.0], [-7.0, 0.0]])
      arg1=Data(numpy.array([-6.0, 7.0, 1.0]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([10.0, -37.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_constData_rank2(self):
      arg0=numpy.array([[-1.0, 0.0], [2.0, -6.0], [-2.0, 0.0]])
      arg1=Data(numpy.array([[5.0, 0.0], [7.0, -4.0], [-7.0, -5.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[23.0, 2.0], [-42.0, 24.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_expandedData_rank1(self):
      arg0=numpy.array([[7.0, 0.0], [-3.0, 4.0], [2.0, 7.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([2.0, -7.0, -6.0])+(1.-msk_arg1)*numpy.array([0.0, -7.0, -6.0])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([23.0, -70.0])+(1.-msk_ref)*numpy.array([9.0, -70.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank2_expandedData_rank2(self):
      arg0=numpy.array([[-4.0, -2.0], [4.0, -4.0], [1.0, 4.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[6.0, -7.0], [6.0, -1.0], [7.0, 4.0]])+(1.-msk_arg1)*numpy.array([[7.0, -3.0], [-3.0, -6.0], 
[-3.0, 0.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[7.0, 28.0], [-8.0, 34.0]])+(1.-msk_ref)*numpy.array([[-43.0, -12.0], [-14.0, 30.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_array_rank2(self):
      arg0=numpy.array([[[[-1.0, -6.0, 4.0, 4.0, -2.0], [5.0, 0.0, -2.0, -2.0, -4.0], [-1.0, -2.0, -7.0, -6.0, 3.0], [3.0, 
-2.0, 4.0, -1.0, 5.0]], [[6.0, 3.0, 6.0, 4.0, 7.0], [6.0, 7.0, 4.0, 5.0, -2.0], [-5.0, 6.0, 0.0, -7.0, 7.0], [1.0, -1.0, -2.0, 
0.0, 7.0]], [[-5.0, 7.0, -4.0, 2.0, -1.0], [-1.0, 0.0, 0.0, 7.0, -7.0], [-2.0, 3.0, -4.0, 5.0, 4.0], [-3.0, -2.0, 2.0, 0.0, 
6.0]]], [[[-5.0, -3.0, 2.0, -3.0, 3.0], [6.0, 1.0, 0.0, -7.0, -3.0], [-1.0, -7.0, 2.0, 5.0, 0.0], [1.0, -4.0, 5.0, 2.0, 7.0]], 
[[1.0, -3.0, -7.0, 7.0, -6.0], [6.0, -4.0, 2.0, 3.0, 7.0], [2.0, -1.0, 2.0, 1.0, 1.0], [-7.0, 3.0, -3.0, 7.0, 2.0]], [[6.0, 
-4.0, 3.0, 3.0, 5.0], [-3.0, -6.0, -7.0, 5.0, 0.0], [-7.0, 0.0, -3.0, -4.0, -6.0], [4.0, 4.0, 1.0, -2.0, -4.0]]]])
      arg1=numpy.array([[-7.0, -5.0, -5.0], [6.0, -6.0, -6.0]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=numpy.array([[-70.0, 16.0, -2.0, -136.0, 8.0], [-42.0, 31.0, 24.0, -136.0, 13.0], [66.0, -67.0, 87.0, 100.0, -46.0], 
[13.0, -37.0, 14.0, -11.0, -46.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_array_rank3(self):
      arg0=numpy.array([[[[-1.0, 4.0, 6.0, 6.0, 0.0], [0.0, -1.0, -4.0, -3.0, -3.0], [-1.0, 3.0, -3.0, -1.0, -6.0], [-7.0, 0.0, 
-3.0, 5.0, 2.0]], [[5.0, 0.0, -2.0, 0.0, 1.0], [7.0, -2.0, 0.0, -7.0, 3.0], [5.0, -7.0, 0.0, 6.0, -1.0], [-4.0, 3.0, -2.0, 
-1.0, 0.0]], [[5.0, 4.0, 3.0, 5.0, -7.0], [3.0, -7.0, 6.0, -3.0, 3.0], [7.0, -2.0, -7.0, 0.0, 0.0], [-6.0, 7.0, -6.0, 0.0, 
0.0]]], [[[6.0, -6.0, 4.0, 2.0, 7.0], [4.0, 6.0, -7.0, 6.0, 5.0], [-1.0, 6.0, -5.0, -2.0, 6.0], [5.0, 4.0, 6.0, 6.0, -1.0]], 
[[7.0, 3.0, 0.0, 2.0, -7.0], [0.0, 4.0, 3.0, -2.0, -6.0], [-7.0, 3.0, 5.0, -6.0, -6.0], [5.0, 5.0, 0.0, -2.0, 7.0]], [[6.0, 
-3.0, -2.0, 7.0, 7.0], [-3.0, -6.0, -2.0, -7.0, 3.0], [7.0, 4.0, -2.0, 5.0, 2.0], [-3.0, -6.0, -7.0, 0.0, -3.0]]]])
      arg1=numpy.array([[[3.0, 5.0], [-5.0, 1.0], [0.0, 0.0]], [[5.0, 3.0], [-5.0, 3.0], [-4.0, 6.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=numpy.array([[[-57.0, 75.0], [-21.0, -7.0], [56.0, 28.0], [-10.0, 84.0], [37.0, 43.0]], [[-3.0, 1.0], [41.0, -13.0], 
[-54.0, -44.0], [94.0, -52.0], [19.0, 3.0]], [[-26.0, 18.0], [43.0, 59.0], [-51.0, -27.0], [-33.0, 7.0], [39.0, -19.0]], 
[[11.0, -27.0], [4.0, -6.0], [59.0, -41.0], [60.0, 36.0], [-22.0, 10.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_array_rank4(self):
      arg0=numpy.array([[[[3.0, 6.0, -5.0, 0.0, -4.0], [-2.0, 3.0, 0.0, 2.0, 1.0], [4.0, 1.0, -1.0, 7.0, 2.0], [5.0, -3.0, 
-5.0, 0.0, -1.0]], [[5.0, 0.0, -2.0, -2.0, 3.0], [5.0, 7.0, 2.0, 1.0, 7.0], [4.0, -7.0, -2.0, 4.0, -7.0], [5.0, 0.0, 5.0, 5.0, 
0.0]], [[0.0, -4.0, 0.0, 0.0, -7.0], [-2.0, 6.0, -3.0, 1.0, 3.0], [-2.0, 5.0, -2.0, 2.0, 2.0], [4.0, -3.0, -3.0, -6.0, -4.0]]], 
[[[-3.0, -5.0, -1.0, 0.0, -7.0], [-4.0, 0.0, 1.0, -1.0, 4.0], [3.0, 2.0, 7.0, 2.0, 6.0], [-4.0, 4.0, 3.0, 7.0, 4.0]], [[-7.0, 
-3.0, 2.0, -3.0, 0.0], [-5.0, 5.0, 1.0, 6.0, -1.0], [3.0, 1.0, 5.0, -6.0, 0.0], [2.0, 0.0, 2.0, 6.0, 0.0]], [[5.0, 4.0, 0.0, 
-7.0, -6.0], [0.0, 3.0, 5.0, -2.0, -4.0], [4.0, -3.0, 1.0, 4.0, -2.0], [-6.0, -6.0, -6.0, 3.0, -7.0]]]])
      arg1=numpy.array([[[[2.0, 0.0, 4.0, -2.0, -3.0], [4.0, -1.0, 0.0, 2.0, -4.0], [-6.0, -4.0, 3.0, 5.0, 5.0], [-2.0, 0.0, 
4.0, -4.0, 3.0]], [[0.0, 4.0, 1.0, -5.0, 4.0], [1.0, -2.0, 7.0, 6.0, 1.0], [7.0, -3.0, 1.0, 2.0, -5.0], [-2.0, -3.0, 0.0, -2.0, 
-3.0]], [[5.0, 1.0, 5.0, 4.0, -3.0], [-3.0, 0.0, -1.0, -7.0, 7.0], [-1.0, -5.0, 4.0, 5.0, -4.0], [3.0, 0.0, -4.0, -6.0, 0.0]]], 
[[[-2.0, 5.0, -3.0, 0.0, 5.0], [-7.0, 3.0, 3.0, 3.0, -3.0], [-3.0, 3.0, -2.0, -7.0, 7.0], [-2.0, -1.0, 0.0, 0.0, -7.0]], [[3.0, 
4.0, -7.0, -3.0, 0.0], [7.0, -4.0, -2.0, 4.0, 2.0], [-7.0, -5.0, -6.0, -4.0, -3.0], [3.0, 0.0, 1.0, 0.0, 2.0]], [[5.0, -3.0, 
-7.0, -7.0, -3.0], [6.0, -4.0, -1.0, -5.0, 7.0], [3.0, -4.0, -6.0, -4.0, -4.0], [-5.0, -5.0, 1.0, 5.0, 1.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=numpy.array([[[[16.0, -38.0, 40.0, -45.0, -19.0], [19.0, -14.0, 35.0, -26.0, 23.0], [90.0, -21.0, 32.0, 54.0, -30.0], 
[-56.0, -37.0, 10.0, 3.0, 6.0]], [[13.0, -53.0, 12.0, -47.0, -43.0], [74.0, -25.0, -9.0, -7.0, -15.0], [16.0, -20.0, 6.0, 41.0, 
4.0], [-43.0, -15.0, 41.0, 20.0, 51.0]], [[-2.0, -5.0, -33.0, 14.0, 2.0], [-1.0, -2.0, -21.0, -17.0, 25.0], [5.0, 13.0, -27.0, 
-30.0, -28.0], [22.0, 7.0, -18.0, 24.0, 2.0]], [[-44.0, 1.0, 68.0, 68.0, 13.0], [-65.0, 44.0, -1.0, 11.0, -57.0], [-14.0, 49.0, 
58.0, 36.0, 47.0], [30.0, 41.0, -10.0, -31.0, -7.0]], [[-59.0, -12.0, 15.0, 7.0, 28.0], [21.0, 1.0, 13.0, 68.0, -51.0], [55.0, 
45.0, 13.0, 24.0, -32.0], [25.0, 28.0, 6.0, 22.0, 22.0]]], [[[-21.0, -22.0, 34.0, -14.0, 12.0], [-4.0, 0.0, 35.0, 8.0, 1.0], 
[96.0, 16.0, 29.0, 38.0, -40.0], [-19.0, -11.0, -5.0, 10.0, -3.0]], [[66.0, 45.0, -7.0, -53.0, -8.0], [54.0, -49.0, 30.0, 11.0, 
68.0], [-1.0, -100.0, -8.0, 27.0, -71.0], [-2.0, -36.0, -4.0, -47.0, 1.0]], [[11.0, -1.0, -58.0, -60.0, 7.0], [41.0, -25.0, 
13.0, 15.0, 15.0], [22.0, -13.0, -48.0, -42.0, -14.0], [-37.0, -32.0, 18.0, 39.0, -6.0]], [[19.0, 30.0, -11.0, -9.0, -4.0], 
[43.0, -23.0, -7.0, 34.0, 1.0], [-51.0, -41.0, -11.0, 8.0, -16.0], [27.0, 8.0, 8.0, -26.0, 20.0]], [[-14.0, 59.0, 49.0, 6.0, 
48.0], [-57.0, 17.0, 64.0, 51.0, -18.0], [23.0, -7.0, 44.0, 26.0, 5.0], [2.0, -5.0, -13.0, -56.0, -52.0]]], [[[21.0, 29.0, 
-48.0, -73.0, 13.0], [50.0, -31.0, 29.0, 47.0, -1.0], [-12.0, -40.0, -40.0, -31.0, 4.0], [-39.0, -35.0, 31.0, 8.0, -11.0]], 
[[11.0, 0.0, 30.0, 71.0, -27.0], [-43.0, 27.0, -47.0, -50.0, -1.0], [-82.0, 5.0, 24.0, 10.0, 43.0], [41.0, 34.0, -18.0, -35.0, 
9.0]], [[-6.0, 42.0, -79.0, -18.0, 33.0], [-8.0, 2.0, -2.0, 36.0, -16.0], [-59.0, 12.0, -63.0, -92.0, 43.0], [-4.0, -6.0, 10.0, 
25.0, -35.0]], [[22.0, -8.0, 50.0, -36.0, -13.0], [-6.0, -1.0, 40.0, -14.0, 0.0], [32.0, -30.0, 41.0, 47.0, 23.0], [-58.0, 
-34.0, 18.0, -28.0, -13.0]], [[-8.0, 10.0, 7.0, 53.0, -4.0], [-59.0, 38.0, -31.0, -24.0, -33.0], [-87.0, 29.0, 7.0, -28.0, 
87.0], [14.0, 25.0, -2.0, -16.0, -17.0]]], [[[14.0, 30.0, 85.0, 17.0, -9.0], [19.0, -11.0, 21.0, 38.0, -13.0], [-19.0, -53.0, 
68.0, 99.0, -26.0], [36.0, 19.0, 0.0, -84.0, 26.0]], [[-59.0, 35.0, 3.0, 36.0, 56.0], [-67.0, 39.0, 21.0, 57.0, -63.0], [-9.0, 
63.0, 7.0, -34.0, 49.0], [19.0, 26.0, -6.0, 0.0, -43.0]], [[-55.0, 58.0, -11.0, 9.0, 77.0], [-49.0, 20.0, 49.0, 88.0, -43.0], 
[27.0, 43.0, -4.0, -35.0, 1.0], [21.0, 12.0, -12.0, -2.0, -53.0]], [[-11.0, 64.0, -109.0, -88.0, 64.0], [34.0, -25.0, 47.0, 
102.0, -25.0], [-13.0, -6.0, -87.0, -105.0, 18.0], [-39.0, -37.0, 33.0, 41.0, -49.0]], [[-65.0, 37.0, 13.0, 35.0, 56.0], 
[-62.0, 41.0, 23.0, 73.0, -85.0], [-23.0, 64.0, 15.0, -25.0, 67.0], [17.0, 31.0, 5.0, -7.0, -38.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_constData_rank2(self):
      arg0=numpy.array([[[[0.0, 0.0, 3.0, 2.0, 0.0], [1.0, -6.0, -2.0, 0.0, 1.0], [-5.0, -6.0, -3.0, 1.0, -6.0], [-2.0, 2.0, 
6.0, 6.0, 5.0]], [[2.0, -1.0, -5.0, 0.0, 1.0], [0.0, 6.0, 0.0, 7.0, 0.0], [1.0, 7.0, 1.0, 0.0, -1.0], [2.0, 1.0, -3.0, 3.0, 
0.0]], [[1.0, 6.0, 6.0, 0.0, -7.0], [-7.0, 0.0, 3.0, 4.0, -1.0], [-6.0, 2.0, -4.0, 3.0, 0.0], [-5.0, 1.0, 3.0, 7.0, 0.0]]], 
[[[-7.0, -2.0, 2.0, 3.0, -5.0], [5.0, -6.0, 3.0, -7.0, -6.0], [2.0, 0.0, 3.0, 0.0, 2.0], [-1.0, -5.0, -7.0, 6.0, 2.0]], [[2.0, 
-2.0, -4.0, -3.0, 3.0], [5.0, 3.0, 0.0, -2.0, -6.0], [0.0, -5.0, -6.0, -5.0, -6.0], [-7.0, -1.0, 1.0, 1.0, -7.0]], [[2.0, -3.0, 
-4.0, 5.0, -6.0], [6.0, -7.0, -6.0, -3.0, 4.0], [0.0, -7.0, 5.0, 5.0, 0.0], [1.0, -1.0, 0.0, 2.0, 0.0]]]])
      arg1=Data(numpy.array([[6.0, 4.0, -3.0], [-6.0, 2.0, -1.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[49.0, -11.0, -36.0, -17.0, 67.0], [1.0, 37.0, -33.0, 57.0, 29.0], [-20.0, -17.0, -37.0, -18.0, 
-64.0], [2.0, 42.0, 59.0, -9.0, 4.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=transposed_tensor_mult(arg0,arg1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_constData_rank3(self):
      arg0=numpy.array([[[[-1.0, 3.0, 4.0, -3.0, 0.0], [7.0, 2.0, 6.0, -6.0, -4.0], [-5.0, -2.0, 4.0, 5.0, -7.0], [0.0, -4.0, 
-3.0, 4.0, 3.0]], [[1.0, 0.0, -3.0, -2.0, -5.0], [5.0, 0.0, 4.0, -5.0, -6.0], [0.0, 1.0, -6.0, 1.0, 0.0], [7.0, 5.0, -5.0, 5.0, 
5.0]], [[-3.0, -2.0, 0.0, -6.0, -1.0], [3.0, -2.0, 2.0, -4.0, 6.0], [-7.0, -4.0, 1.0, 5.0, -1.0], [7.0, 0.0, -3.0, -2.0, 
-2.0]]], [[[6.0, -7.0, -4.0, -2.0, 2.0], [-2.0, -7.0, -3.0, -1.0, 6.0], [3.0, 2.0, -1.0, -3.0, 0.0], [-6.0, 0.0, -3.0, 3.0, 
-6.0]], [[-4.0, -2.0, 2.0, 6.0, 3.0], [1.0, 0.0, 5.0, 3.0, -1.0], [-3.0, -3.0, 0.0, -7.0, 0.0], [7.0, -4.0, -7.0, 6.0, -4.0]], 
[[-6.0, -6.0, -5.0, 0.0, 2.0], [-6.0, 2.0, -5.0, 0.0, 2.0], [6.0, 5.0, -2.0, 3.0, 2.0], [-4.0, 0.0, 1.0, 2.0, 0.0]]]])
      arg1=Data(numpy.array([[[-6.0, 7.0], [0.0, 5.0], [-4.0, 0.0]], [[1.0, -3.0], [0.0, 4.0], [-2.0, 
-4.0]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[36.0, -12.0], [-5.0, 58.0], [-18.0, 53.0], [40.0, -1.0], [2.0, -27.0]], [[-44.0, 108.0], [-15.0, 
27.0], [-37.0, 111.0], [51.0, -52.0], [2.0, -88.0]], [[49.0, -80.0], [20.0, -47.0], [-25.0, 9.0], [-59.0, 9.0], [42.0, -57.0]], 
[[-26.0, 97.0], [24.0, -19.0], [25.0, -69.0], [-17.0, 60.0], [-16.0, 48.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_constData_rank4(self):
      arg0=numpy.array([[[[7.0, 2.0, -1.0, 0.0, 2.0], [6.0, 0.0, 5.0, -1.0, 0.0], [-7.0, -3.0, 6.0, 0.0, 4.0], [-4.0, -1.0, 
4.0, 6.0, -7.0]], [[-4.0, -5.0, 4.0, -7.0, -1.0], [6.0, -2.0, -5.0, 3.0, -2.0], [-7.0, 0.0, 3.0, 6.0, -3.0], [-3.0, -4.0, 0.0, 
2.0, -1.0]], [[-3.0, -3.0, 7.0, 2.0, 1.0], [-2.0, 1.0, 2.0, 0.0, -4.0], [-6.0, 0.0, -6.0, -1.0, -6.0], [6.0, -1.0, 0.0, 1.0, 
-4.0]]], [[[3.0, 5.0, 0.0, -1.0, -5.0], [7.0, 4.0, -2.0, -5.0, 0.0], [-2.0, -4.0, 1.0, -4.0, 2.0], [0.0, 6.0, -3.0, 0.0, 
-4.0]], [[1.0, 0.0, 4.0, 3.0, 3.0], [-2.0, 6.0, 4.0, 5.0, 0.0], [0.0, 0.0, 0.0, 7.0, -4.0], [4.0, 7.0, 5.0, 5.0, 5.0]], [[-3.0, 
-3.0, 3.0, 2.0, 3.0], [-4.0, 4.0, 7.0, 4.0, 3.0], [-2.0, -1.0, 4.0, 2.0, -7.0], [-2.0, -5.0, -3.0, 5.0, -2.0]]]])
      arg1=Data(numpy.array([[[[-3.0, 5.0, -6.0, -5.0, 0.0], [0.0, 3.0, 4.0, 7.0, -1.0], [-3.0, 5.0, -7.0, 4.0, 0.0], [-1.0, 
-1.0, 2.0, -7.0, 3.0]], [[-2.0, -2.0, 1.0, -7.0, 2.0], [5.0, 2.0, -3.0, 6.0, -1.0], [2.0, -7.0, -3.0, -2.0, 4.0], [5.0, 1.0, 
4.0, 6.0, 0.0]], [[-2.0, 2.0, 7.0, -7.0, -7.0], [4.0, -6.0, -2.0, 6.0, -4.0], [-3.0, 1.0, -4.0, -6.0, -5.0], [1.0, 0.0, 3.0, 
-1.0, -5.0]]], [[[-5.0, 0.0, -1.0, 0.0, 7.0], [5.0, 3.0, -2.0, -3.0, 2.0], [-5.0, 7.0, 1.0, 0.0, -1.0], [7.0, 2.0, 6.0, 1.0, 
2.0]], [[-4.0, -1.0, -3.0, -4.0, -4.0], [-6.0, -1.0, 4.0, 0.0, -4.0], [4.0, -2.0, -3.0, 0.0, -1.0], [7.0, 1.0, -2.0, 6.0, 
1.0]], [[-7.0, 1.0, -5.0, 5.0, -5.0], [0.0, -2.0, -2.0, 4.0, 6.0], [-7.0, 1.0, 1.0, 6.0, 4.0], [1.0, -4.0, 1.0, -5.0, 
-5.0]]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[[-5.0, 33.0, -58.0, -5.0, 45.0], [-23.0, 45.0, 50.0, -14.0, -7.0], [-10.0, 76.0, -28.0, 36.0, 
-17.0], [-5.0, 8.0, 2.0, -46.0, 58.0]], [[6.0, 11.0, -28.0, 31.0, 61.0], [-12.0, 35.0, 25.0, -61.0, 7.0], [-11.0, 74.0, 15.0, 
18.0, -22.0], [2.0, 15.0, 2.0, -21.0, 46.0]], [[-56.0, 0.0, 32.0, -73.0, -72.0], [24.0, -47.0, -20.0, 71.0, -29.0], [-15.0, 
-31.0, -42.0, -36.0, -11.0], [59.0, -3.0, 30.0, 33.0, -49.0]], [[-11.0, 17.0, -11.0, 33.0, -57.0], [-50.0, -36.0, 27.0, -19.0, 
-3.0], [-17.0, 40.0, 5.0, 14.0, -32.0], [-17.0, -14.0, -32.0, -37.0, -19.0]], [[-14.0, 14.0, -25.0, -7.0, -71.0], [-44.0, 
-26.0, 25.0, 41.0, -9.0], [5.0, -20.0, -26.0, 22.0, 5.0], [-17.0, -22.0, -30.0, -23.0, -21.0]]], [[[-25.0, 12.0, -25.0, -70.0, 
103.0], [69.0, 73.0, -4.0, 29.0, -6.0], [-15.0, 35.0, -43.0, 0.0, 13.0], [53.0, 28.0, 72.0, 11.0, 60.0]], [[-70.0, 4.0, -37.0, 
3.0, -27.0], [-22.0, -12.0, 12.0, -2.0, 6.0], [-31.0, 35.0, -8.0, 22.0, -7.0], [65.0, -4.0, 11.0, 7.0, -11.0]], [[-64.0, 42.0, 
-66.0, 15.0, -89.0], [-51.0, -31.0, 37.0, 51.0, 14.0], [-54.0, 47.0, -35.0, 60.0, -4.0], [-7.0, -38.0, -17.0, -80.0, -30.0]], 
[[-26.0, -12.0, -21.0, -16.0, -69.0], [-40.0, -25.0, 9.0, 42.0, -8.0], [26.0, -67.0, -18.0, 14.0, 28.0], [20.0, -17.0, -26.0, 
30.0, -28.0]], [[-9.0, -1.0, -45.0, 57.0, 9.0], [-26.0, 14.0, 8.0, -24.0, 36.0], [-13.0, 13.0, 25.0, 46.0, 24.0], [-11.0, 
-14.0, -17.0, -23.0, 5.0]]], [[[71.0, -35.0, 5.0, 116.0, 24.0], [-69.0, -1.0, 13.0, -129.0, 22.0], [49.0, -8.0, 90.0, 10.0, 
-4.0], [-50.0, 4.0, -74.0, 21.0, 15.0]], [[36.0, -16.0, 27.0, 10.0, -23.0], [-20.0, -19.0, -2.0, -13.0, -11.0], [36.0, -44.0, 
16.0, -18.0, 0.0], [-26.0, -1.0, -31.0, 22.0, -12.0]], [[-45.0, 16.0, -96.0, 11.0, 35.0], [-4.0, 55.0, 17.0, 37.0, 41.0], 
[-27.0, 14.0, -22.0, 78.0, 57.0], [14.0, -17.0, 16.0, -37.0, 30.0]], [[-32.0, -19.0, -28.0, -53.0, -47.0], [-36.0, -5.0, 16.0, 
50.0, -26.0], [49.0, -83.0, -37.0, 6.0, 34.0], [52.0, -3.0, -15.0, 65.0, -6.0]], [[61.0, 11.0, -24.0, 24.0, 101.0], [-5.0, 
66.0, 31.0, -60.0, 1.0], [23.0, 50.0, 12.0, 16.0, -8.0], [-46.0, 21.0, -9.0, -27.0, 77.0]]], [[[4.0, -8.0, 61.0, -27.0, -54.0], 
[-15.0, -54.0, 1.0, -18.0, -45.0], [18.0, -3.0, -1.0, -58.0, -54.0], [21.0, 13.0, -12.0, 38.0, -28.0]], [[-10.0, -11.0, -7.0, 
-13.0, 38.0], [-36.0, 16.0, 36.0, -75.0, -37.0], [31.0, 45.0, 3.0, -20.0, -44.0], [66.0, 36.0, -4.0, 57.0, 46.0]], [[4.0, 12.0, 
-21.0, -55.0, -26.0], [-45.0, 4.0, 48.0, 25.0, -48.0], [44.0, -14.0, -49.0, -2.0, -14.0], [7.0, 7.0, -23.0, 14.0, 26.0]], 
[[-79.0, 28.0, -67.0, -46.0, -48.0], [-16.0, 1.0, 26.0, 80.0, -2.0], [-32.0, 12.0, -62.0, 44.0, 18.0], [45.0, -19.0, 18.0, 
-26.0, -7.0]], [[45.0, -48.0, 12.0, 40.0, -12.0], [-71.0, -12.0, 15.0, -75.0, -16.0], [85.0, -72.0, 47.0, -14.0, 7.0], [3.0, 
11.0, -66.0, 83.0, 6.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_expandedData_rank2(self):
      arg0=numpy.array([[[[1.0, -1.0, 5.0, 5.0, 0.0], [-2.0, -4.0, 6.0, 3.0, -4.0], [-1.0, 2.0, -5.0, -5.0, 4.0], [1.0, -3.0, 
-6.0, 4.0, -7.0]], [[-6.0, 0.0, 2.0, 4.0, 1.0], [-2.0, 0.0, 7.0, 4.0, -3.0], [2.0, 6.0, 2.0, 0.0, 7.0], [-4.0, -5.0, 7.0, 6.0, 
2.0]], [[-6.0, 4.0, -2.0, 4.0, -5.0], [-5.0, -1.0, 7.0, 4.0, 7.0], [-1.0, -7.0, 0.0, 1.0, -6.0], [-7.0, -4.0, -5.0, 0.0, 
-3.0]]], [[[-2.0, -1.0, 4.0, 0.0, 1.0], [7.0, -1.0, 0.0, -3.0, -4.0], [6.0, 7.0, -4.0, -6.0, 0.0], [6.0, 5.0, 0.0, 7.0, 7.0]], 
[[-2.0, 0.0, 0.0, -2.0, -7.0], [-5.0, 0.0, -4.0, 6.0, -2.0], [6.0, 0.0, -1.0, -6.0, -1.0], [4.0, -7.0, -2.0, 5.0, 4.0]], [[4.0, 
0.0, -3.0, 7.0, 1.0], [5.0, 6.0, -2.0, 3.0, 1.0], [5.0, 3.0, 4.0, 0.0, -3.0], [-5.0, 1.0, 6.0, -7.0, -6.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[3.0, -1.0, 0.0], [-5.0, 5.0, 6.0]])+(1.-msk_arg1)*numpy.array([[-4.0, 0.0, -3.0], [-2.0, 
-1.0, 3.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[33.0, 2.0, -25.0, 43.0, -35.0], [-34.0, 29.0, -21.0, 68.0, 7.0], [25.0, -17.0, 22.0, -15.0, 
-18.0], [-33.0, -58.0, 1.0, -46.0, -74.0]])+(1.-msk_ref)*numpy.array([[32.0, -6.0, -31.0, -9.0, 23.0], [29.0, 39.0, -47.0, 
-15.0, 8.0], [4.0, 8.0, 41.0, 35.0, -6.0], [-14.0, 24.0, 59.0, -56.0, 1.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_expandedData_rank3(self):
      arg0=numpy.array([[[[-1.0, 3.0, 2.0, 2.0, -5.0], [-6.0, -7.0, 0.0, 0.0, -7.0], [2.0, -2.0, 7.0, 0.0, 6.0], [0.0, 5.0, 
4.0, 6.0, 2.0]], [[5.0, -5.0, 0.0, -2.0, 0.0], [-6.0, -6.0, -7.0, 0.0, -1.0], [6.0, -5.0, 1.0, -5.0, 5.0], [1.0, 1.0, -7.0, 
-3.0, 1.0]], [[-6.0, 0.0, 5.0, 0.0, -4.0], [-3.0, 4.0, -7.0, 6.0, 1.0], [0.0, -7.0, -4.0, 1.0, -4.0], [0.0, 2.0, 1.0, -2.0, 
3.0]]], [[[-7.0, 3.0, 7.0, 7.0, 1.0], [-7.0, -3.0, -4.0, 6.0, -2.0], [0.0, -7.0, 7.0, -3.0, -7.0], [7.0, -7.0, -1.0, 0.0, 
5.0]], [[0.0, 3.0, 5.0, 4.0, -1.0], [-1.0, 7.0, 2.0, 4.0, -5.0], [-2.0, 3.0, 4.0, 1.0, -2.0], [-2.0, -3.0, 0.0, 6.0, 3.0]], 
[[-5.0, -5.0, -7.0, 5.0, 2.0], [-6.0, 2.0, 6.0, 2.0, -5.0], [0.0, 1.0, 4.0, -3.0, -2.0], [-7.0, -6.0, 0.0, 1.0, 7.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[3.0, -4.0], [-7.0, -7.0], [-2.0, -5.0]], [[-6.0, 0.0], [-7.0, 1.0], [-6.0, 
0.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, -4.0], [0.0, -5.0], [6.0, 0.0]], [[-1.0, -5.0], [-7.0, -7.0], [-1.0, 0.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[46.0, -1.0], [35.0, 26.0], [-39.0, -28.0], [-80.0, 10.0], [-18.0, 39.0]], [[115.0, 80.0], 
[-30.0, 57.0], [37.0, 86.0], [-88.0, -26.0], [61.0, 25.0]], [[-22.0, -52.0], [58.0, 81.0], [-72.0, -11.0], [62.0, 31.0], [59.0, 
-41.0]], [[7.0, -9.0], [103.0, -40.0], [65.0, 28.0], [-5.0, 13.0], [-100.0, -27.0]]])+(1.-msk_ref)*numpy.array([[[-27.0, 14.0], 
[-10.0, -23.0], [1.0, -78.0], [-34.0, -61.0], [-35.0, 22.0]], [[-16.0, 96.0], [-45.0, 24.0], [-58.0, 41.0], [0.0, -58.0], 
[27.0, 78.0]], [[20.0, -24.0], [-63.0, 47.0], [-42.0, -96.0], [5.0, 33.0], [17.0, 0.0]], [[14.0, -26.0], [61.0, 31.0], [19.0, 
24.0], [-37.0, -51.0], [-9.0, -59.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_array_rank4_expandedData_rank4(self):
      arg0=numpy.array([[[[0.0, 5.0, 1.0, -4.0, -7.0], [7.0, 4.0, -3.0, -2.0, 4.0], [3.0, -2.0, 6.0, 7.0, -4.0], [-7.0, 3.0, 
-1.0, 4.0, -5.0]], [[-5.0, 0.0, -5.0, 4.0, -6.0], [-6.0, 7.0, 3.0, -5.0, -5.0], [-1.0, 6.0, 1.0, -6.0, -2.0], [0.0, -7.0, -1.0, 
5.0, 4.0]], [[-3.0, -1.0, 0.0, 4.0, 5.0], [0.0, -3.0, 1.0, 3.0, 4.0], [3.0, -6.0, 4.0, 6.0, -4.0], [5.0, 0.0, -5.0, -7.0, 
0.0]]], [[[0.0, -6.0, -5.0, 4.0, 6.0], [0.0, 0.0, -5.0, 4.0, 6.0], [-6.0, -4.0, -5.0, 6.0, -5.0], [6.0, -2.0, 2.0, 6.0, 0.0]], 
[[5.0, 0.0, -2.0, 4.0, 5.0], [7.0, 4.0, -3.0, -2.0, -6.0], [-6.0, 2.0, -4.0, -1.0, 5.0], [-5.0, -1.0, -4.0, 4.0, 6.0]], [[0.0, 
-2.0, -3.0, 5.0, -7.0], [5.0, -2.0, -7.0, 3.0, 0.0], [-5.0, 4.0, -4.0, -5.0, 3.0], [0.0, 6.0, -2.0, 1.0, 4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[2.0, 3.0, 2.0, -7.0, -6.0], [7.0, -6.0, 1.0, 5.0, 4.0], [0.0, -4.0, 2.0, -3.0, -5.0], 
[-1.0, -1.0, 5.0, -3.0, -3.0]], [[5.0, -5.0, 3.0, -7.0, -5.0], [0.0, 4.0, 2.0, 5.0, -2.0], [5.0, -6.0, -4.0, 1.0, 0.0], [3.0, 
3.0, 6.0, 2.0, 7.0]], [[0.0, -2.0, 6.0, 1.0, 5.0], [3.0, 5.0, 6.0, 0.0, 3.0], [6.0, -7.0, -4.0, -2.0, -4.0], [5.0, 0.0, -5.0, 
2.0, 5.0]]], [[[5.0, -2.0, -3.0, 6.0, -2.0], [3.0, -1.0, -5.0, 5.0, -2.0], [5.0, 3.0, -5.0, 6.0, 2.0], [-2.0, 2.0, -3.0, 3.0, 
-3.0]], [[-2.0, 0.0, 3.0, 5.0, -3.0], [2.0, 0.0, 6.0, -7.0, -4.0], [7.0, 6.0, -1.0, -6.0, -1.0], [1.0, 1.0, -5.0, -4.0, 5.0]], 
[[6.0, 5.0, 6.0, -2.0, 4.0], [-2.0, 7.0, 5.0, 6.0, -4.0], [4.0, 1.0, 0.0, -5.0, 1.0], [-7.0, -5.0, 0.0, 0.0, 
0.0]]]])+(1.-msk_arg1)*numpy.array([[[[7.0, -5.0, 1.0, -1.0, -3.0], [2.0, -7.0, 4.0, -6.0, -6.0], [-3.0, -4.0, 0.0, 7.0, 1.0], 
[0.0, -6.0, 7.0, 0.0, 1.0]], [[1.0, 0.0, -6.0, 5.0, 6.0], [-6.0, -7.0, 3.0, -4.0, 5.0], [-4.0, -2.0, -7.0, 3.0, 1.0], [-4.0, 
-7.0, -7.0, 0.0, -4.0]], [[0.0, -5.0, -4.0, -1.0, 6.0], [0.0, -7.0, 4.0, 5.0, 3.0], [7.0, -7.0, 3.0, -7.0, -4.0], [-7.0, 2.0, 
-5.0, 3.0, 7.0]]], [[[6.0, 5.0, -4.0, 0.0, 3.0], [2.0, -6.0, 1.0, -1.0, -3.0], [-1.0, -5.0, 3.0, -4.0, 0.0], [1.0, -5.0, -7.0, 
0.0, -4.0]], [[-6.0, -2.0, 2.0, -4.0, 0.0], [-3.0, -4.0, -6.0, -6.0, 5.0], [5.0, -4.0, 4.0, 1.0, 5.0], [2.0, -2.0, -3.0, 6.0, 
0.0]], [[-2.0, 0.0, 6.0, 7.0, -1.0], [2.0, 7.0, 0.0, -1.0, 4.0], [-2.0, 1.0, 2.0, 2.0, -2.0], [0.0, -7.0, -6.0, 2.0, 5.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-35.0, 31.0, -18.0, 57.0, -5.0], [1.0, -35.0, 2.0, -60.0, -19.0], [-8.0, 81.0, 27.0, -29.0, 
7.0], [-25.0, -10.0, -40.0, -36.0, -25.0]], [[-32.0, 19.0, 10.0, -68.0, -31.0], [18.0, -43.0, 19.0, -17.0, 37.0], [-44.0, 
-33.0, 44.0, -39.0, -35.0], [16.0, -7.0, 48.0, -35.0, -2.0]], [[-62.0, 23.0, -22.0, -6.0, 23.0], [-6.0, -42.0, -11.0, -49.0, 
44.0], [-76.0, -4.0, 49.0, -11.0, -16.0], [13.0, -13.0, 0.0, -20.0, -33.0]], [[54.0, -23.0, 58.0, 38.0, 24.0], [-6.0, 91.0, 
57.0, 22.0, -56.0], [112.0, 5.0, -64.0, -17.0, 13.0], [-3.0, 3.0, -48.0, 24.0, 68.0]], [[-66.0, -48.0, -47.0, 171.0, 42.0], 
[8.0, -12.0, -24.0, -112.0, -5.0], [37.0, 70.0, -45.0, 46.0, 15.0], [56.0, 41.0, -139.0, 17.0, 11.0]]], [[[0.0, 76.0, 47.0, 
18.0, -13.0], [53.0, -31.0, 62.0, -14.0, -8.0], [39.0, 55.0, 31.0, -94.0, -37.0], [-53.0, -43.0, -36.0, -61.0, -28.0]], [[23.0, 
-27.0, 11.0, -56.0, -94.0], [31.0, -25.0, 14.0, 15.0, -15.0], [37.0, -15.0, -12.0, -13.0, -14.0], [20.0, 31.0, 57.0, -20.0, 
42.0]], [[-52.0, -51.0, -27.0, -30.0, -1.0], [-25.0, -9.0, -19.0, -46.0, 35.0], [-53.0, -53.0, 6.0, 33.0, -3.0], [73.0, 34.0, 
28.0, 14.0, 35.0]], [[13.0, 20.0, -1.0, 60.0, 62.0], [-3.0, 24.0, -11.0, 17.0, -1.0], [11.0, 20.0, -14.0, 16.0, 11.0], [-29.0, 
-22.0, -57.0, 22.0, -36.0]], [[25.0, 17.0, -19.0, 17.0, 27.0], [46.0, -30.0, -48.0, 67.0, 50.0], [-13.0, -32.0, -12.0, 47.0, 
-18.0], [-17.0, -13.0, -18.0, 28.0, -75.0]]], [[[-47.0, -5.0, -9.0, -67.0, 12.0], [10.0, -36.0, -12.0, -8.0, 79.0], [-79.0, 
-86.0, 34.0, 9.0, -38.0], [50.0, 1.0, 42.0, 1.0, -13.0]], [[26.0, 4.0, 20.0, -56.0, -30.0], [-48.0, 38.0, 26.0, 10.0, -54.0], 
[4.0, 18.0, 14.0, -32.0, 28.0], [-28.0, -6.0, 58.0, -14.0, 40.0]], [[-24.0, -5.0, 18.0, -87.0, -15.0], [39.0, -35.0, 13.0, 
14.0, 76.0], [-40.0, -101.0, 21.0, -11.0, -56.0], [51.0, 3.0, 51.0, -7.0, 4.0]], [[-14.0, 2.0, -19.0, 40.0, -11.0], [93.0, 
-77.0, -30.0, 12.0, 70.0], [9.0, -27.0, -15.0, 28.0, -51.0], [27.0, 11.0, -44.0, 1.0, -56.0]], [[-35.0, 31.0, 10.0, 27.0, 
21.0], [-51.0, 22.0, 38.0, -72.0, -46.0], [-12.0, 74.0, 36.0, -57.0, 24.0], [-28.0, -22.0, -22.0, -35.0, 18.0]]], [[[26.0, 
-43.0, -17.0, 65.0, 70.0], [-26.0, 61.0, -37.0, 30.0, -5.0], [25.0, -19.0, -59.0, 77.0, 32.0], [15.0, 14.0, -53.0, 69.0, 3.0]], 
[[-1.0, 78.0, 24.0, -1.0, 48.0], [1.0, -2.0, 23.0, 13.0, 10.0], [-28.0, 24.0, 45.0, -52.0, -12.0], [-63.0, -59.0, -16.0, -25.0, 
-57.0]], [[-1.0, -2.0, -65.0, 5.0, -14.0], [-20.0, -39.0, -77.0, 16.0, 3.0], [-61.0, 25.0, 16.0, 58.0, 31.0], [-21.0, 8.0, 
28.0, 13.0, -55.0]], [[61.0, -6.0, -19.0, -16.0, -104.0], [31.0, -38.0, -29.0, 53.0, -47.0], [45.0, 46.0, -18.0, 14.0, 17.0], 
[-39.0, 22.0, 47.0, -14.0, -10.0]], [[22.0, -15.0, 44.0, 29.0, 8.0], [-31.0, 74.0, 59.0, -23.0, -68.0], [78.0, 36.0, -32.0, 
-37.0, 23.0], [-5.0, 3.0, -31.0, -1.0, 73.0]]]])+(1.-msk_ref)*numpy.array([[[[-35.0, 5.0, 52.0, -42.0, -48.0], [15.0, 36.0, 
-57.0, -25.0, -9.0], [24.0, 11.0, 46.0, 11.0, 32.0], [51.0, 19.0, 35.0, 21.0, -1.0]], [[3.0, -50.0, 21.0, -18.0, -37.0], [-6.0, 
-6.0, 10.0, -27.0, -23.0], [-12.0, 15.0, -25.0, 62.0, 13.0], [1.0, 12.0, 94.0, -7.0, 12.0]], [[-10.0, -26.0, 29.0, -39.0, 
-45.0], [22.0, 45.0, -4.0, 34.0, -38.0], [18.0, 36.0, 6.0, 4.0, -8.0], [11.0, 79.0, 101.0, -18.0, 26.0]], [[-34.0, 12.0, -22.0, 
39.0, 67.0], [-26.0, -33.0, -8.0, -5.0, 84.0], [30.0, -51.0, 22.0, -46.0, -6.0], [-32.0, -59.0, -146.0, 46.0, 17.0]], [[-35.0, 
30.0, -47.0, -97.0, 40.0], [5.0, -49.0, -50.0, 62.0, 6.0], [113.0, -52.0, 81.0, -135.0, 6.0], [5.0, 103.0, -47.0, 31.0, 
-7.0]]], [[[-9.0, -49.0, 87.0, -30.0, -62.0], [39.0, 0.0, -32.0, -65.0, -17.0], [28.0, -39.0, 80.0, 48.0, 26.0], [38.0, -49.0, 
40.0, 52.0, 56.0]], [[15.0, -13.0, -30.0, 4.0, 14.0], [-50.0, -86.0, 1.0, -89.0, 14.0], [-37.0, -27.0, -46.0, 70.0, 47.0], 
[1.0, -73.0, -6.0, 11.0, -55.0]], [[-16.0, -9.0, -53.0, -20.0, 25.0], [-39.0, -14.0, 14.0, 41.0, 8.0], [8.0, 29.0, -59.0, 
-16.0, -5.0], [-30.0, 79.0, 39.0, -29.0, -23.0]], [[11.0, 19.0, 14.0, 3.0, 3.0], [46.0, 33.0, 5.0, 52.0, -14.0], [27.0, -12.0, 
54.0, -62.0, -35.0], [-1.0, 16.0, -34.0, 3.0, 38.0]], [[95.0, 2.0, -18.0, -9.0, 0.0], [68.0, -33.0, 59.0, 46.0, -85.0], [0.0, 
-40.0, 41.0, -45.0, -47.0], [-14.0, 1.0, 19.0, -24.0, 28.0]]], [[[30.0, -48.0, -21.0, -22.0, -10.0], [8.0, -10.0, 51.0, 48.0, 
-46.0], [2.0, 18.0, -36.0, 5.0, -30.0], [-35.0, 72.0, 103.0, -37.0, 27.0]], [[-52.0, 16.0, 30.0, 58.0, -10.0], [-46.0, 58.0, 
-30.0, -54.0, 62.0], [-54.0, 54.0, -56.0, 72.0, 30.0], [18.0, -54.0, -28.0, 2.0, -32.0]], [[45.0, -67.0, -28.0, -17.0, 1.0], 
[0.0, -59.0, 62.0, 13.0, -40.0], [-1.0, -17.0, -34.0, 25.0, -21.0], [-45.0, 26.0, 86.0, -20.0, 30.0]], [[95.0, -33.0, -37.0, 
-74.0, 2.0], [55.0, -116.0, 46.0, 17.0, -97.0], [44.0, -89.0, 64.0, -46.0, -18.0], [-14.0, 19.0, 52.0, 2.0, 24.0]], [[-96.0, 
5.0, 72.0, -1.0, -42.0], [-15.0, 101.0, -73.0, -16.0, 54.0], [16.0, 56.0, 13.0, 25.0, 29.0], [41.0, 24.0, 8.0, 24.0, 11.0]]], 
[[[17.0, 50.0, -61.0, 22.0, 69.0], [13.0, -2.0, 28.0, 91.0, 14.0], [25.0, -17.0, 13.0, -113.0, -52.0], [-39.0, 32.0, -101.0, 
-15.0, 4.0]], [[-4.0, -23.0, 87.0, 8.0, -63.0], [59.0, 86.0, -5.0, 12.0, -28.0], [4.0, 22.0, 51.0, 19.0, -21.0], [24.0, 1.0, 
51.0, 6.0, 69.0]], [[32.0, 48.0, -3.0, 3.0, -25.0], [16.0, 39.0, -1.0, 9.0, -48.0], [-46.0, 45.0, -22.0, 9.0, 2.0], [33.0, 
15.0, 35.0, -43.0, -50.0]], [[43.0, 37.0, -8.0, 19.0, -7.0], [-20.0, -59.0, -15.0, -110.0, -14.0], [-69.0, -22.0, -20.0, 74.0, 
55.0], [43.0, -118.0, -32.0, 5.0, -84.0]], [[-75.0, 13.0, 7.0, 29.0, 35.0], [-44.0, 11.0, -44.0, -26.0, 96.0], [21.0, -8.0, 
4.0, -9.0, 21.0], [-4.0, -38.0, -105.0, 44.0, -1.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_array_rank1(self):
      arg0=Data(numpy.array([[3.0, -4.0], [-2.0, 5.0], [0.0, -7.0]]),self.functionspace)
      arg1=numpy.array([-1.0, 6.0, -3.0])
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([-15.0, 55.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=transposed_tensor_mult(arg0,arg1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")    
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_array_rank2(self):
      arg0=Data(numpy.array([[3.0, -3.0], [0.0, -6.0], [-2.0, 2.0]]),self.functionspace)
      arg1=numpy.array([[5.0, -1.0], [2.0, 0.0], [7.0, 6.0]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[1.0, -15.0], [-13.0, 15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_constData_rank1(self):
      arg0=Data(numpy.array([[0.0, -4.0], [3.0, -2.0], [7.0, -7.0]]),self.functionspace)
      arg1=Data(numpy.array([-3.0, -1.0, 5.0]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([32.0, -21.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_constData_rank2(self):
      arg0=Data(numpy.array([[6.0, 3.0], [1.0, 4.0], [2.0, 5.0]]),self.functionspace)
      arg1=Data(numpy.array([[-6.0, 0.0], [4.0, 0.0], [1.0, -3.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[-30.0, -6.0], [3.0, -15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_expandedData_rank1(self):
      arg0=Data(numpy.array([[5.0, -3.0], [0.0, -6.0], [4.0, -4.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, 4.0, 6.0])+(1.-msk_arg1)*numpy.array([-4.0, 7.0, -7.0])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([44.0, -60.0])+(1.-msk_ref)*numpy.array([-48.0, -2.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank2_expandedData_rank2(self):
      arg0=Data(numpy.array([[7.0, 6.0], [4.0, -5.0], [7.0, -4.0]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[1.0, 4.0], [-4.0, -5.0], [2.0, 7.0]])+(1.-msk_arg1)*numpy.array([[-3.0, 6.0], [-5.0, 1.0], 
[-5.0, 2.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[5.0, 57.0], [18.0, 21.0]])+(1.-msk_ref)*numpy.array([[-76.0, 60.0], [27.0, 23.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_array_rank2(self):
      arg0=Data(numpy.array([[[[7.0, 2.0, 4.0, 6.0, -4.0], [3.0, -4.0, 2.0, 7.0, 6.0], [7.0, 0.0, -5.0, 0.0, 6.0], [7.0, -4.0, 
6.0, -1.0, 5.0]], [[1.0, -5.0, -3.0, 0.0, 0.0], [-7.0, -7.0, 0.0, 5.0, 0.0], [-5.0, 7.0, -1.0, 6.0, -6.0], [1.0, 3.0, -5.0, 
7.0, 0.0]], [[0.0, 4.0, -1.0, 1.0, 6.0], [-7.0, 7.0, 7.0, 4.0, -2.0], [-7.0, -3.0, 0.0, 4.0, -4.0], [6.0, 1.0, 6.0, 2.0, 
-4.0]]], [[[-4.0, -4.0, -4.0, 6.0, -7.0], [-4.0, 2.0, -6.0, -6.0, -4.0], [-2.0, -7.0, 4.0, -1.0, 7.0], [0.0, -1.0, 2.0, -4.0, 
4.0]], [[-5.0, 2.0, -7.0, 1.0, 5.0], [1.0, -2.0, 0.0, -2.0, 5.0], [-6.0, 0.0, -6.0, -2.0, 2.0], [-2.0, 1.0, 0.0, 1.0, 2.0]], 
[[3.0, -6.0, 0.0, 0.0, 7.0], [-5.0, 3.0, 1.0, 4.0, 0.0], [-3.0, -1.0, -4.0, 7.0, 1.0], [7.0, -3.0, 2.0, 6.0, 
1.0]]]]),self.functionspace)
      arg1=numpy.array([[-1.0, 4.0, 0.0], [-1.0, 6.0, -4.0]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[-41.0, 18.0, -54.0, -6.0, 13.0], [-1.0, -50.0, 0.0, -9.0, 28.0], [-49.0, 39.0, -23.0, -15.0, 
-29.0], [-43.0, 35.0, -36.0, 15.0, -1.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_array_rank3(self):
      arg0=Data(numpy.array([[[[1.0, -5.0, -2.0, 0.0, -3.0], [-5.0, 0.0, 3.0, 0.0, 2.0], [-5.0, -4.0, 4.0, 0.0, 5.0], [4.0, 
5.0, -1.0, 0.0, 5.0]], [[-7.0, 7.0, 7.0, 4.0, -2.0], [4.0, -7.0, -6.0, -6.0, -4.0], [-2.0, 3.0, 2.0, -4.0, -6.0], [5.0, 0.0, 
-4.0, 4.0, -5.0]], [[-6.0, -1.0, -1.0, -7.0, 0.0], [-7.0, 3.0, -7.0, 6.0, 5.0], [6.0, -7.0, 0.0, -4.0, 4.0], [-1.0, -2.0, 1.0, 
1.0, -5.0]]], [[[0.0, 3.0, 0.0, 7.0, -4.0], [-1.0, 0.0, 5.0, 3.0, -6.0], [-5.0, -3.0, 0.0, 6.0, 0.0], [-4.0, -4.0, 5.0, 6.0, 
0.0]], [[-1.0, -2.0, 4.0, -6.0, -2.0], [6.0, -5.0, 6.0, 3.0, 2.0], [5.0, 4.0, 7.0, -1.0, -1.0], [-5.0, 0.0, -5.0, -6.0, -5.0]], 
[[2.0, -7.0, 0.0, -2.0, -4.0], [7.0, 3.0, 3.0, 0.0, 0.0], [-3.0, 6.0, -7.0, 1.0, -1.0], [1.0, -4.0, -3.0, 0.0, 
-4.0]]]]),self.functionspace)
      arg1=numpy.array([[[-5.0, -2.0], [2.0, 7.0], [-2.0, 1.0]], [[2.0, -4.0], [-1.0, 7.0], [-5.0, -2.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[-16.0, -68.0], [84.0, 46.0], [22.0, 80.0], [52.0, -45.0], [25.0, 2.0]], [[4.0, 63.0], [-30.0, 
-87.0], [-24.0, -39.0], [-21.0, -27.0], [-42.0, 11.0]], [[9.0, 63.0], [0.0, 50.0], [12.0, 69.0], [8.0, -65.0], [-39.0, -53.0]], 
[[-16.0, 5.0], [-9.0, 12.0], [25.0, -74.0], [24.0, -37.0], [0.0, -77.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_array_rank4(self):
      arg0=Data(numpy.array([[[[4.0, 3.0, -4.0, -2.0, 6.0], [-4.0, -7.0, 0.0, -4.0, 2.0], [-6.0, 7.0, 0.0, -7.0, -7.0], [2.0, 
1.0, -6.0, -4.0, -4.0]], [[-2.0, -6.0, 1.0, 4.0, 0.0], [0.0, 3.0, 7.0, 0.0, 5.0], [-4.0, 3.0, 6.0, -7.0, 1.0], [-6.0, 6.0, 4.0, 
0.0, -6.0]], [[-1.0, 6.0, 2.0, 4.0, 2.0], [-1.0, -3.0, 1.0, 0.0, 1.0], [-7.0, -2.0, -6.0, 0.0, 3.0], [7.0, 3.0, -6.0, -7.0, 
5.0]]], [[[-4.0, -6.0, -3.0, 0.0, -3.0], [-5.0, -3.0, -3.0, -7.0, 6.0], [0.0, 6.0, -3.0, -7.0, 0.0], [-1.0, -6.0, 0.0, 5.0, 
7.0]], [[-6.0, 0.0, 3.0, 5.0, 2.0], [1.0, 0.0, -3.0, 3.0, -2.0], [-6.0, 3.0, 4.0, 5.0, -1.0], [5.0, -7.0, 6.0, 5.0, -7.0]], 
[[-3.0, 6.0, -2.0, 0.0, -1.0], [-1.0, 0.0, -6.0, -4.0, -2.0], [2.0, 7.0, 4.0, 2.0, 7.0], [2.0, 2.0, 2.0, 6.0, 
-2.0]]]]),self.functionspace)
      arg1=numpy.array([[[[-6.0, 6.0, -5.0, 0.0, -6.0], [6.0, 7.0, -5.0, 5.0, -7.0], [-1.0, 3.0, -5.0, 0.0, 2.0], [2.0, -6.0, 
-6.0, 5.0, 2.0]], [[2.0, -1.0, 2.0, -4.0, 5.0], [-3.0, -3.0, 6.0, 0.0, -5.0], [-1.0, -2.0, 2.0, 3.0, 0.0], [-2.0, 2.0, 0.0, 
3.0, -6.0]], [[-3.0, -5.0, 3.0, 5.0, 2.0], [-5.0, 3.0, 1.0, -2.0, 5.0], [0.0, -3.0, -5.0, 7.0, 4.0], [6.0, -1.0, -1.0, 2.0, 
5.0]]], [[[-7.0, -1.0, -3.0, -2.0, 1.0], [2.0, 0.0, 0.0, 3.0, -2.0], [7.0, -1.0, 6.0, 6.0, -3.0], [0.0, -2.0, 0.0, 6.0, 7.0]], 
[[0.0, 6.0, 5.0, 4.0, 1.0], [-6.0, -4.0, -2.0, 0.0, -1.0], [-4.0, -6.0, -4.0, 4.0, -2.0], [7.0, 4.0, -2.0, -6.0, -5.0]], [[6.0, 
-1.0, 7.0, 1.0, 7.0], [-4.0, 6.0, -7.0, -3.0, 3.0], [-6.0, -1.0, -3.0, 0.0, 7.0], [-4.0, -3.0, -6.0, 3.0, -6.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[[-15.0, 2.0, -66.0, -16.0, -67.0], [75.0, 37.0, 0.0, 19.0, -18.0], [12.0, 62.0, -10.0, -61.0, 
7.0], [-24.0, -34.0, 7.0, 15.0, 35.0]], [[30.0, -6.0, 51.0, 72.0, 0.0], [-30.0, 93.0, -87.0, -33.0, 69.0], [-75.0, 3.0, -111.0, 
-12.0, 90.0], [30.0, -42.0, -60.0, -9.0, -6.0]], [[29.0, -12.0, 38.0, 22.0, 19.0], [-53.0, -49.0, 36.0, -27.0, 30.0], [-18.0, 
-33.0, -12.0, 11.0, -11.0], [31.0, 48.0, 28.0, -55.0, -28.0]], [[8.0, -6.0, 55.0, 24.0, 45.0], [-74.0, -34.0, 28.0, -18.0, 
9.0], [-22.0, -56.0, -22.0, 60.0, 2.0], [47.0, 36.0, -2.0, -20.0, -33.0]], [[-27.0, 42.0, -12.0, 23.0, -40.0], [12.0, 34.0, 
-25.0, 20.0, -31.0], [-29.0, 4.0, -63.0, 4.0, 18.0], [42.0, -21.0, -36.0, 1.0, -3.0]]], [[[56.0, -7.0, 30.0, 8.0, 11.0], 
[-31.0, -41.0, 24.0, -30.0, 29.0], [-29.0, -9.0, -6.0, -33.0, -6.0], [-3.0, 42.0, 29.0, -61.0, -47.0]], [[78.0, -27.0, 41.0, 
-21.0, 48.0], [-42.0, -67.0, 50.0, -38.0, 25.0], [-17.0, -15.0, 38.0, -30.0, -17.0], [-38.0, 57.0, 45.0, -50.0, -68.0]], 
[[-4.0, -21.0, -31.0, -35.0, -11.0], [10.0, -42.0, 91.0, 7.0, -39.0], [20.0, 10.0, 21.0, -2.0, -23.0], [-5.0, 25.0, 41.0, 5.0, 
-7.0]], [[49.0, 5.0, 28.0, 22.0, -8.0], [-40.0, -64.0, 42.0, -29.0, 27.0], [-33.0, -19.0, -22.0, -30.0, -21.0], [29.0, 62.0, 
42.0, -92.0, -48.0]], [[-59.0, -14.0, -39.0, -37.0, 5.0], [24.0, -2.0, 39.0, 32.0, -50.0], [55.0, 1.0, 45.0, 50.0, -20.0], 
[-6.0, -17.0, 3.0, 69.0, 43.0]]], [[[61.0, -35.0, -15.0, -41.0, 10.0], [39.0, -15.0, -3.0, -22.0, 39.0], [22.0, 45.0, 75.0, 
-85.0, -14.0], [-96.0, 5.0, 43.0, -14.0, -5.0]], [[-30.0, 54.0, 11.0, -15.0, 27.0], [9.0, 64.0, -74.0, 36.0, -68.0], [-22.0, 
-10.0, -16.0, 43.0, 31.0], [-11.0, -55.0, -88.0, 79.0, -29.0]], [[75.0, 47.0, 51.0, -28.0, 47.0], [-34.0, -28.0, -6.0, -9.0, 
-46.0], [-67.0, -19.0, -4.0, -26.0, 5.0], [-36.0, 28.0, -26.0, -24.0, -131.0]], [[89.0, 0.0, 81.0, 64.0, 19.0], [-73.0, -36.0, 
-31.0, -62.0, 99.0], [-67.0, -32.0, -47.0, -43.0, 11.0], [27.0, 56.0, 20.0, -122.0, -58.0]], [[77.0, -71.0, 90.0, 14.0, 101.0], 
[-82.0, 3.0, -3.0, -62.0, 81.0], [-32.0, -33.0, 5.0, 20.0, 49.0], [-33.0, 16.0, -1.0, 1.0, -42.0]]], [[[-26.0, 12.0, 41.0, 
83.0, -10.0], [-45.0, 45.0, -63.0, -13.0, 54.0], [-35.0, -34.0, -89.0, 45.0, 39.0], [85.0, -15.0, -41.0, -24.0, 31.0]], [[51.0, 
-53.0, 13.0, -23.0, 31.0], [-5.0, 38.0, 34.0, -25.0, 3.0], [-33.0, 28.0, -22.0, -25.0, 60.0], [-49.0, -19.0, -7.0, 41.0, 
-38.0]], [[74.0, 24.0, 64.0, -20.0, 64.0], [-62.0, -84.0, 22.0, -24.0, -8.0], [-34.0, -46.0, 38.0, -6.0, -34.0], [-22.0, 68.0, 
18.0, -60.0, -108.0]], [[46.0, 30.0, 51.0, -19.0, 62.0], [-33.0, -33.0, -39.0, -9.0, -4.0], [-17.0, -32.0, 47.0, 1.0, -19.0], 
[-39.0, 23.0, -15.0, -16.0, -69.0]], [[-64.0, -90.0, -47.0, 5.0, -10.0], [33.0, 21.0, 17.0, -3.0, 70.0], [99.0, 22.0, 59.0, 
31.0, -9.0], [-7.0, -29.0, 45.0, 50.0, 149.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_constData_rank2(self):
      arg0=Data(numpy.array([[[[-3.0, 0.0, -6.0, 5.0, 4.0], [-7.0, -4.0, 0.0, -7.0, -4.0], [0.0, 6.0, -6.0, -3.0, 4.0], [-1.0, 
5.0, -7.0, 6.0, -5.0]], [[-6.0, 3.0, 5.0, 3.0, 1.0], [0.0, 3.0, 6.0, 0.0, -4.0], [0.0, 0.0, -7.0, 1.0, 1.0], [-5.0, -6.0, 6.0, 
0.0, -2.0]], [[-6.0, 7.0, 7.0, 0.0, 6.0], [-1.0, -3.0, 4.0, 2.0, 0.0], [0.0, -4.0, 6.0, 1.0, -7.0], [0.0, 5.0, 7.0, -5.0, 
-7.0]]], [[[2.0, 2.0, -7.0, 7.0, 5.0], [-4.0, -4.0, -2.0, 3.0, 4.0], [-4.0, -3.0, 7.0, -6.0, -7.0], [-4.0, 0.0, -4.0, -2.0, 
7.0]], [[-3.0, -1.0, 0.0, 6.0, -5.0], [-2.0, -1.0, 4.0, 5.0, -3.0], [-7.0, -3.0, -5.0, -6.0, -2.0], [-5.0, 3.0, 4.0, 5.0, 
-1.0]], [[-4.0, -6.0, -4.0, 4.0, -4.0], [4.0, 6.0, -3.0, 3.0, 4.0], [-6.0, -2.0, 1.0, 7.0, 6.0], [3.0, -6.0, 5.0, 5.0, 
-3.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[4.0, 3.0, 3.0], [4.0, -6.0, -7.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[6.0, 86.0, 12.0, -7.0, 115.0], [-63.0, -68.0, 19.0, -61.0, -22.0], [68.0, 32.0, 24.0, -43.0, 
-60.0], [-26.0, 41.0, -64.0, -64.0, 8.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_constData_rank3(self):
      arg0=Data(numpy.array([[[[-7.0, 0.0, -4.0, 1.0, 6.0], [3.0, -3.0, 3.0, 1.0, 0.0], [-3.0, 3.0, 5.0, 0.0, 6.0], [5.0, -7.0, 
1.0, 0.0, -6.0]], [[1.0, -3.0, -7.0, 6.0, -5.0], [-3.0, -5.0, -5.0, -3.0, 3.0], [7.0, -7.0, -5.0, -7.0, 0.0], [5.0, 0.0, 1.0, 
6.0, 2.0]], [[3.0, -7.0, -3.0, 0.0, 6.0], [7.0, 2.0, -1.0, 5.0, -1.0], [-1.0, 7.0, -1.0, 0.0, 0.0], [-2.0, -5.0, 4.0, 0.0, 
-3.0]]], [[[4.0, -2.0, -2.0, -7.0, -6.0], [6.0, -6.0, 7.0, -6.0, 5.0], [-4.0, 7.0, 3.0, 6.0, 0.0], [7.0, 7.0, 3.0, -5.0, 2.0]], 
[[-3.0, -1.0, 5.0, 6.0, 2.0], [-6.0, 7.0, -1.0, -4.0, 2.0], [-6.0, -1.0, 0.0, 6.0, -2.0], [6.0, -4.0, 7.0, -2.0, 1.0]], [[2.0, 
-5.0, -6.0, 3.0, 2.0], [3.0, -4.0, -5.0, 2.0, -5.0], [2.0, -6.0, -1.0, -1.0, 3.0], [2.0, -2.0, -2.0, -2.0, 
-4.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[0.0, 7.0], [3.0, -2.0], [1.0, -3.0]], [[0.0, 7.0], [-2.0, -6.0], [2.0, 
0.0]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[16.0, -14.0], [-24.0, 19.0], [-46.0, -49.0], [12.0, -90.0], [-9.0, -20.0]], [[16.0, 84.0], 
[-35.0, -101.0], [-24.0, 89.0], [8.0, -20.0], [-6.0, 20.0]], [[36.0, -24.0], [-24.0, 69.0], [-18.0, 69.0], [-35.0, 20.0], 
[10.0, 54.0]], [[5.0, 44.0], [-1.0, 39.0], [-11.0, -28.0], [18.0, -35.0], [-7.0, -29.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_constData_rank4(self):
      arg0=Data(numpy.array([[[[-2.0, -2.0, -4.0, -1.0, -5.0], [5.0, -5.0, -1.0, 1.0, 7.0], [-3.0, 7.0, 0.0, 4.0, 0.0], [5.0, 
-5.0, 2.0, 3.0, -4.0]], [[-5.0, 2.0, 7.0, 6.0, -2.0], [-2.0, -3.0, -7.0, 3.0, 3.0], [-5.0, -7.0, -1.0, -2.0, 1.0], [-7.0, -1.0, 
3.0, -7.0, 0.0]], [[6.0, -5.0, -2.0, -5.0, 5.0], [0.0, -6.0, -7.0, 0.0, -2.0], [-6.0, 7.0, -1.0, 1.0, -1.0], [7.0, 6.0, 1.0, 
2.0, -5.0]]], [[[-6.0, 4.0, 0.0, 1.0, -6.0], [1.0, -3.0, -3.0, 4.0, 6.0], [-3.0, 1.0, -1.0, -2.0, -5.0], [-3.0, -5.0, 3.0, 
-5.0, -4.0]], [[0.0, -2.0, -6.0, 6.0, 5.0], [0.0, 1.0, 2.0, 4.0, 2.0], [-1.0, -7.0, -2.0, -3.0, 6.0], [2.0, -6.0, 5.0, -3.0, 
-1.0]], [[0.0, 2.0, -3.0, 2.0, 6.0], [3.0, -2.0, -3.0, -5.0, 7.0], [-1.0, -3.0, -4.0, 2.0, 0.0], [5.0, 7.0, 1.0, 0.0, 
-4.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-6.0, 1.0, 7.0, -7.0, 6.0], [5.0, -7.0, -4.0, -2.0, 0.0], [-4.0, -4.0, -1.0, 0.0, -1.0], [5.0, 
0.0, -7.0, -4.0, 4.0]], [[6.0, 6.0, 1.0, -4.0, -6.0], [2.0, -3.0, -2.0, 6.0, 0.0], [3.0, 5.0, -3.0, -6.0, 2.0], [0.0, -7.0, 
-2.0, -5.0, -4.0]], [[-3.0, -2.0, 7.0, 2.0, -3.0], [-4.0, 0.0, 7.0, 0.0, 7.0], [7.0, -2.0, -4.0, 6.0, -6.0], [7.0, -6.0, 7.0, 
-3.0, -4.0]]], [[[3.0, -1.0, -7.0, -4.0, 7.0], [0.0, 6.0, -3.0, 0.0, -5.0], [-1.0, 7.0, -4.0, 0.0, 0.0], [-4.0, 3.0, -7.0, 4.0, 
-3.0]], [[-6.0, -7.0, 0.0, -7.0, 2.0], [-2.0, 0.0, -5.0, -1.0, 6.0], [-2.0, 7.0, 0.0, 7.0, -1.0], [2.0, -4.0, 3.0, 2.0, -4.0]], 
[[-4.0, -4.0, 3.0, 5.0, -5.0], [-4.0, -1.0, 7.0, 4.0, -4.0], [-1.0, 1.0, 1.0, -3.0, 1.0], [4.0, -5.0, 6.0, 1.0, 
6.0]]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      ref=Data(numpy.array([[[[-54.0, -38.0, 65.0, 70.0, -42.0], [-44.0, -7.0, 78.0, -26.0, 72.0], [41.0, -71.0, 17.0, 66.0, 
-44.0], [56.0, -19.0, 108.0, -9.0, 6.0]], [[55.0, 22.0, -69.0, 4.0, 5.0], [10.0, 30.0, -19.0, 26.0, -75.0], [-23.0, 44.0, 2.0, 
-62.0, 40.0], [-57.0, 26.0, -47.0, 27.0, 12.0]], [[120.0, 96.0, -44.0, 23.0, -57.0], [26.0, 10.0, -3.0, 44.0, -38.0], [38.0, 
10.0, -12.0, -87.0, 33.0], [-58.0, 2.0, -36.0, -28.0, -30.0]], [[16.0, -6.0, -37.0, -63.0, -18.0], [7.0, -7.0, -62.0, 40.0, 
-12.0], [-28.0, 95.0, 1.0, -30.0, 39.0], [-24.0, -43.0, -17.0, 7.0, -23.0]], [[-69.0, -80.0, 58.0, 72.0, -95.0], [-83.0, -1.0, 
94.0, 17.0, 71.0], [39.0, -1.0, 21.0, 59.0, -28.0], [68.0, -84.0, 167.0, 7.0, 2.0]]], [[[-51.0, -20.0, 35.0, -16.0, 34.0], 
[9.0, -26.0, 2.0, -10.0, -17.0], [-30.0, -20.0, 0.0, 3.0, -6.0], [33.0, 2.0, -20.0, -3.0, 43.0]], [[23.0, -7.0, -65.0, 30.0, 
-3.0], [-1.0, 28.0, -26.0, -17.0, -13.0], [-28.0, 1.0, 48.0, -5.0, 32.0], [-61.0, 54.0, 11.0, 41.0, 9.0]], [[-24.0, -28.0, 
-51.0, 4.0, 55.0], [17.0, 13.0, -53.0, -54.0, -10.0], [-64.0, -27.0, 59.0, 23.0, 24.0], [-50.0, 89.0, -19.0, 49.0, 35.0]], 
[[20.0, 7.0, -33.0, -88.0, 49.0], [23.0, 13.0, -77.0, -8.0, 24.0], [-2.0, 62.0, -31.0, 25.0, -4.0], [-23.0, 0.0, -59.0, 0.0, 
-66.0]], [[-40.0, -19.0, 17.0, -68.0, 41.0], [17.0, -29.0, -27.0, 30.0, -60.0], [-50.0, 54.0, -25.0, -37.0, 16.0], [29.0, 
-34.0, -63.0, -2.0, 40.0]]], [[[7.0, -7.0, -50.0, 43.0, 12.0], [5.0, 19.0, -13.0, -27.0, -29.0], [-39.0, -30.0, 53.0, -10.0, 
29.0], [-51.0, 71.0, 1.0, 40.0, 39.0]], [[-48.0, 11.0, 75.0, 23.0, 71.0], [19.0, -19.0, 46.0, -61.0, 14.0], [16.0, -122.0, 
-21.0, 44.0, -59.0], [54.0, 53.0, -32.0, -27.0, 35.0]], [[22.0, 27.0, -13.0, 0.0, 18.0], [22.0, 1.0, -20.0, -20.0, 2.0], [-1.0, 
-28.0, 7.0, -2.0, 2.0], [-23.0, 38.0, -28.0, -4.0, -5.0]], [[-35.0, 5.0, 53.0, 21.0, 3.0], [10.0, -36.0, 30.0, -9.0, -9.0], 
[-9.0, -61.0, 8.0, -9.0, -9.0], [37.0, 4.0, 0.0, -21.0, 50.0]], [[-42.0, -29.0, 29.0, -28.0, -26.0], [-6.0, -33.0, -24.0, 0.0, 
54.0], [-11.0, 14.0, 21.0, 30.0, 2.0], [25.0, -40.0, 44.0, -10.0, -9.0]]], [[[-134.0, -82.0, 113.0, 30.0, 9.0], [-41.0, -37.0, 
77.0, -34.0, 56.0], [2.0, -71.0, 5.0, 83.0, -58.0], [110.0, -35.0, 85.0, -9.0, 51.0]], [[-1.0, -4.0, 62.0, 148.0, -124.0], 
[-67.0, 1.0, 158.0, 38.0, 3.0], [69.0, -67.0, 11.0, -21.0, -20.0], [53.0, -55.0, 138.0, -18.0, 41.0]], [[-22.0, -24.0, 6.0, 
-66.0, 17.0], [-2.0, -6.0, -34.0, 13.0, 18.0], [-6.0, 62.0, -26.0, 20.0, -6.0], [19.0, -43.0, -13.0, -3.0, -31.0]], [[-63.0, 
-17.0, 63.0, 52.0, 13.0], [-1.0, -30.0, 46.0, -45.0, 21.0], [-8.0, -107.0, 30.0, 33.0, -26.0], [43.0, 34.0, 33.0, -9.0, 59.0]], 
[[49.0, 33.0, -47.0, 21.0, -19.0], [18.0, 8.0, -30.0, -7.0, -5.0], [-9.0, -13.0, 36.0, -25.0, 31.0], [-57.0, 42.0, -6.0, 9.0, 
-4.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_expandedData_rank2(self):
      arg0=Data(numpy.array([[[[0.0, 6.0, 3.0, -6.0, 2.0], [-4.0, -3.0, -7.0, -7.0, -2.0], [-4.0, 1.0, 5.0, -3.0, 6.0], [0.0, 
3.0, 0.0, -2.0, 3.0]], [[7.0, 4.0, 5.0, -4.0, 1.0], [-7.0, -7.0, -3.0, 4.0, -1.0], [-2.0, 0.0, -6.0, -7.0, -7.0], [6.0, -1.0, 
7.0, -4.0, 4.0]], [[-1.0, 7.0, -7.0, 2.0, -5.0], [7.0, -4.0, 7.0, 0.0, -7.0], [0.0, -6.0, -4.0, -4.0, 5.0], [3.0, -2.0, 0.0, 
-3.0, 0.0]]], [[[1.0, -2.0, -3.0, -6.0, 1.0], [1.0, 7.0, 3.0, 7.0, -4.0], [0.0, 6.0, 4.0, 0.0, -5.0], [6.0, -4.0, 3.0, 3.0, 
6.0]], [[-5.0, 5.0, 0.0, 5.0, 4.0], [6.0, -5.0, 0.0, 3.0, 4.0], [-7.0, 2.0, -1.0, 0.0, -6.0], [-4.0, 4.0, 1.0, 4.0, 1.0]], 
[[7.0, -2.0, 5.0, 6.0, 4.0], [-7.0, -6.0, 1.0, 0.0, -2.0], [7.0, 3.0, 3.0, 4.0, 2.0], [-2.0, 1.0, 7.0, -3.0, 
-2.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[0.0, -2.0, 2.0], [-4.0, 0.0, -4.0]])+(1.-msk_arg1)*numpy.array([[-4.0, -3.0, 1.0], [-2.0, 
-3.0, 3.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-48.0, 22.0, -32.0, 12.0, -32.0], [52.0, 2.0, 4.0, -36.0, 12.0], [-24.0, -48.0, -24.0, -10.0, 
36.0], [-22.0, 10.0, -54.0, 2.0, -24.0]])+(1.-msk_ref)*numpy.array([[12.0, -46.0, -13.0, 53.0, -18.0], [3.0, 12.0, 41.0, -7.0, 
-6.0], [64.0, -19.0, -2.0, 41.0, 36.0], [-21.0, -12.0, -9.0, -10.0, -45.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_expandedData_rank3(self):
      arg0=Data(numpy.array([[[[3.0, -5.0, -6.0, -6.0, -5.0], [-4.0, -3.0, -5.0, -1.0, 6.0], [-6.0, -1.0, 1.0, -3.0, 2.0], 
[3.0, 3.0, -7.0, -7.0, 2.0]], [[-2.0, 2.0, 4.0, 0.0, 6.0], [-5.0, 7.0, 5.0, 4.0, 3.0], [-3.0, 6.0, -5.0, 4.0, -5.0], [1.0, 7.0, 
0.0, 6.0, -3.0]], [[-1.0, -2.0, 3.0, 3.0, 1.0], [0.0, -1.0, -1.0, -3.0, -2.0], [-6.0, 0.0, 0.0, -7.0, 5.0], [1.0, 7.0, 6.0, 
2.0, -6.0]]], [[[-2.0, -2.0, -1.0, 2.0, 7.0], [-2.0, -1.0, 0.0, -4.0, -6.0], [3.0, 6.0, -4.0, 1.0, 1.0], [3.0, -3.0, -4.0, 1.0, 
-6.0]], [[-1.0, 1.0, -4.0, -3.0, -1.0], [2.0, -4.0, -5.0, -6.0, -1.0], [2.0, 3.0, -7.0, -7.0, 1.0], [4.0, -1.0, -5.0, 7.0, 
2.0]], [[-6.0, 1.0, -5.0, 5.0, 4.0], [4.0, 3.0, 1.0, 7.0, 4.0], [2.0, 0.0, 1.0, 0.0, 1.0], [-5.0, 6.0, -7.0, -6.0, 
6.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[0.0, 2.0], [-4.0, 6.0], [6.0, 2.0]], [[3.0, 3.0], [0.0, -3.0], [-2.0, 
-3.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, 0.0], [-2.0, -4.0], [0.0, 0.0]], [[-1.0, 3.0], [-5.0, -5.0], [0.0, 0.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 7.0], [-28.0, -14.0], [9.0, 42.0], [14.0, -6.0], [-5.0, 40.0]], [[6.0, -62.0], [-43.0, 
34.0], [-28.0, 30.0], [-60.0, 1.0], [-50.0, -1.0]], [[-19.0, -45.0], [-6.0, 43.0], [6.0, -22.0], [-55.0, 28.0], [51.0, -19.0]], 
[[21.0, 26.0], [-7.0, 38.0], [38.0, 22.0], [3.0, 26.0], [-54.0, -68.0]]])+(1.-msk_ref)*numpy.array([[[20.0, 7.0], [-22.0, 
-19.0], [-5.0, 1.0], [-5.0, 21.0], [-29.0, 2.0]], [[-10.0, 4.0], [-2.0, -11.0], [0.0, 5.0], [23.0, 2.0], [23.0, -25.0]], 
[[-25.0, 11.0], [-36.0, -21.0], [52.0, 43.0], [17.0, 22.0], [10.0, 18.0]], [[-16.0, -15.0], [3.0, -32.0], [8.0, 13.0], [-69.0, 
-56.0], [8.0, -16.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_constData_rank4_expandedData_rank4(self):
      arg0=Data(numpy.array([[[[-1.0, -3.0, 1.0, 2.0, 3.0], [4.0, 3.0, -3.0, 3.0, -2.0], [7.0, -5.0, 5.0, -7.0, -5.0], [0.0, 
0.0, 3.0, 2.0, -6.0]], [[-7.0, 7.0, -1.0, -2.0, -6.0], [0.0, -3.0, -2.0, -1.0, 3.0], [4.0, 0.0, 3.0, -6.0, -5.0], [-3.0, 3.0, 
-3.0, 0.0, -1.0]], [[-1.0, 3.0, 6.0, -5.0, 5.0], [-7.0, -4.0, -2.0, 3.0, -7.0], [7.0, -2.0, 3.0, -2.0, 0.0], [-4.0, 0.0, -3.0, 
-4.0, 3.0]]], [[[1.0, -2.0, -5.0, 0.0, 5.0], [0.0, -4.0, 1.0, 1.0, -6.0], [5.0, 0.0, 1.0, 2.0, -6.0], [0.0, 0.0, 7.0, -6.0, 
1.0]], [[-2.0, -7.0, 4.0, 4.0, -7.0], [1.0, -1.0, -4.0, 6.0, 1.0], [0.0, 4.0, 6.0, 0.0, -2.0], [4.0, 5.0, 5.0, 3.0, 1.0]], 
[[-6.0, 4.0, 5.0, 0.0, -4.0], [1.0, -2.0, -6.0, -4.0, 0.0], [-6.0, 6.0, 1.0, 0.0, -4.0], [7.0, 6.0, 2.0, -3.0, 
5.0]]]]),self.functionspace)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[4.0, -4.0, 3.0, 2.0, 3.0], [-6.0, 3.0, 0.0, 0.0, 1.0], [0.0, 4.0, -5.0, -5.0, 0.0], [-4.0, 
4.0, -6.0, -5.0, -7.0]], [[-5.0, 4.0, 0.0, 6.0, -6.0], [-3.0, -2.0, 1.0, -2.0, 7.0], [7.0, -1.0, 2.0, 4.0, 0.0], [-6.0, 3.0, 
5.0, -6.0, 5.0]], [[0.0, -5.0, -1.0, 7.0, -4.0], [-6.0, -7.0, -7.0, 4.0, 0.0], [0.0, 7.0, 2.0, 6.0, -6.0], [6.0, 0.0, 6.0, 
-4.0, -1.0]]], [[[3.0, 1.0, 2.0, 5.0, 0.0], [1.0, 4.0, -3.0, -5.0, -4.0], [-5.0, 4.0, -3.0, 1.0, -1.0], [4.0, -4.0, 3.0, -1.0, 
-6.0]], [[0.0, 6.0, -6.0, 1.0, 2.0], [-5.0, -4.0, -1.0, 0.0, 1.0], [-7.0, -6.0, 2.0, 0.0, -7.0], [-2.0, 0.0, -7.0, -5.0, 
-4.0]], [[-1.0, 6.0, 6.0, -5.0, 2.0], [0.0, 1.0, 6.0, -7.0, -5.0], [7.0, -4.0, 6.0, 1.0, -7.0], [5.0, 6.0, 3.0, 4.0, 
4.0]]]])+(1.-msk_arg1)*numpy.array([[[[6.0, -5.0, -1.0, 2.0, 3.0], [-6.0, 5.0, -1.0, 3.0, 7.0], [-6.0, 0.0, 0.0, -6.0, 3.0], 
[-7.0, -3.0, 6.0, 6.0, -4.0]], [[-1.0, 0.0, -3.0, -5.0, 0.0], [2.0, -4.0, 2.0, 0.0, -3.0], [5.0, 5.0, -6.0, -3.0, 6.0], [3.0, 
-7.0, 2.0, -5.0, 5.0]], [[1.0, -1.0, 6.0, 3.0, -1.0], [7.0, 6.0, 5.0, 3.0, -4.0], [6.0, -2.0, 0.0, -6.0, 7.0], [3.0, 0.0, 1.0, 
-2.0, -2.0]]], [[[7.0, 6.0, 2.0, 4.0, 4.0], [-7.0, -7.0, 6.0, 2.0, 7.0], [5.0, -3.0, -1.0, -3.0, 2.0], [-1.0, -4.0, 3.0, 5.0, 
6.0]], [[5.0, 7.0, -2.0, -3.0, 3.0], [-5.0, 2.0, 1.0, 6.0, 2.0], [6.0, 4.0, 2.0, 0.0, 0.0], [-4.0, 0.0, -7.0, 1.0, 0.0]], 
[[5.0, 0.0, 0.0, -4.0, -6.0], [-3.0, -6.0, 0.0, 0.0, -2.0], [1.0, 4.0, -4.0, 5.0, 1.0], [3.0, -6.0, 0.0, 4.0, -5.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[40.0, -66.0, -24.0, -18.0, 27.0], [44.0, 24.0, -37.0, 47.0, -26.0], [-82.0, 36.0, -54.0, 
-34.0, 61.0], [18.0, -65.0, -36.0, 36.0, -49.0]], [[-57.0, 5.0, 50.0, 20.0, -69.0], [12.0, -20.0, 23.0, -20.0, 27.0], [136.0, 
20.0, 51.0, 63.0, 5.0], [14.0, 41.0, 126.0, 14.0, 109.0]], [[-11.0, 11.0, -7.0, -8.0, 3.0], [-64.0, -68.0, -2.0, 16.0, -7.0], 
[25.0, -17.0, 58.0, 27.0, -94.0], [35.0, 51.0, -3.0, -18.0, 16.0]], [[18.0, 33.0, -13.0, -39.0, 46.0], [4.0, 29.0, 29.0, -16.0, 
-8.0], [-42.0, -49.0, -16.0, -48.0, 2.0], [-34.0, 2.0, -80.0, 2.0, -35.0]], [[61.0, -122.0, 32.0, 43.0, 3.0], [10.0, 30.0, 
-73.0, 35.0, -46.0], [-46.0, 131.0, -70.0, -8.0, 42.0], [68.0, -50.0, 34.0, 15.0, -74.0]]], [[[15.0, 31.0, 19.0, -45.0, 44.0], 
[13.0, 58.0, 54.0, -35.0, 0.0], [0.0, -43.0, -26.0, -61.0, 28.0], [-55.0, 22.0, -70.0, 7.0, -21.0]], [[17.0, -26.0, -1.0, 
-51.0, 37.0], [16.0, 29.0, 26.0, 24.0, 7.0], [-8.0, -15.0, -31.0, -57.0, 49.0], [-42.0, 7.0, -68.0, 20.0, -12.0]], [[7.0, 
-45.0, -17.0, -1.0, -9.0], [57.0, 23.0, -23.0, 33.0, 5.0], [-33.0, 28.0, -40.0, -10.0, 81.0], [-6.0, -58.0, 9.0, 30.0, -1.0]], 
[[24.0, -18.0, -52.0, 52.0, 7.0], [-62.0, -34.0, -55.0, 37.0, 18.0], [-82.0, 18.0, -26.0, -4.0, -33.0], [-16.0, -19.0, -56.0, 
-68.0, -75.0]], [[-41.0, 55.0, -17.0, -64.0, 6.0], [34.0, 9.0, 69.0, -4.0, 44.0], [44.0, -90.0, 22.0, -26.0, 41.0], [-78.0, 
25.0, -40.0, 21.0, 68.0]]], [[[29.0, -78.0, -12.0, 142.0, -43.0], [-91.0, -22.0, -96.0, 37.0, 45.0], [-39.0, 117.0, -64.0, 
22.0, -5.0], [-20.0, -16.0, 17.0, -116.0, -90.0]], [[-26.0, 90.0, -1.0, -50.0, 13.0], [22.0, -11.0, 46.0, -50.0, -31.0], [14.0, 
-82.0, 65.0, 19.0, -58.0], [30.0, 16.0, 8.0, 37.0, 45.0]], [[7.0, 20.0, -16.0, 55.0, -1.0], [-86.0, -31.0, -21.0, -6.0, 23.0], 
[-19.0, 2.0, 2.0, 7.0, -68.0], [-23.0, 31.0, -33.0, -82.0, -49.0]], [[8.0, 16.0, -15.0, -54.0, 23.0], [74.0, 13.0, 2.0, -6.0, 
-57.0], [-52.0, -28.0, 13.0, 1.0, 10.0], [60.0, -54.0, 6.0, 77.0, 9.0]], [[-9.0, -42.0, -39.0, -52.0, 3.0], [49.0, -25.0, -9.0, 
68.0, 2.0], [-19.0, -11.0, 5.0, -5.0, 48.0], [10.0, -35.0, -11.0, 55.0, 38.0]]], [[[8.0, 74.0, 22.0, -77.0, 56.0], [13.0, 25.0, 
63.0, -59.0, -52.0], [0.0, -77.0, 36.0, -29.0, -53.0], [21.0, 33.0, -46.0, 42.0, 1.0]], [[-21.0, 78.0, 6.0, -7.0, 4.0], [-34.0, 
-20.0, 34.0, -48.0, -4.0], [28.0, -57.0, 52.0, 18.0, -77.0], [2.0, 45.0, -2.0, -19.0, 19.0]], [[46.0, 40.0, 8.0, -3.0, 53.0], 
[-9.0, 46.0, 4.0, -55.0, -51.0], [-77.0, -16.0, -26.0, -36.0, -38.0], [16.0, -13.0, -59.0, -9.0, -87.0]], [[-7.0, 6.0, -38.0, 
-36.0, 22.0], [-9.0, -5.0, 25.0, 35.0, 44.0], [-12.0, -50.0, -12.0, -43.0, 30.0], [-77.0, 14.0, -84.0, -15.0, 2.0]], [[-21.0, 
42.0, 5.0, -16.0, -12.0], [17.0, -32.0, 4.0, -26.0, -41.0], [16.0, -24.0, 63.0, 50.0, -61.0], [75.0, -1.0, 60.0, 38.0, 
44.0]]]])+(1.-msk_ref)*numpy.array([[[[-33.0, -2.0, 22.0, 64.0, 32.0], [6.0, 42.0, -14.0, -16.0, 33.0], [-48.0, -68.0, 61.0, 
0.0, -56.0], [-28.0, 84.0, -4.0, 10.0, 7.0]], [[-51.0, -49.0, 10.0, -35.0, -65.0], [90.0, -49.0, 13.0, -46.0, -90.0], [23.0, 
23.0, -70.0, 5.0, 54.0], [93.0, -56.0, 42.0, -60.0, 9.0]], [[23.0, -13.0, 20.0, -27.0, -41.0], [34.0, 58.0, 1.0, 35.0, -51.0], 
[29.0, 34.0, -1.0, 1.0, 34.0], [12.0, -6.0, -33.0, -2.0, -76.0]], [[29.0, 23.0, -34.0, -13.0, 23.0], [-71.0, -4.0, -27.0, 15.0, 
48.0], [-28.0, 16.0, 20.0, 24.0, -41.0], [-51.0, 8.0, -25.0, 36.0, -8.0]], [[9.0, -39.0, 69.0, 108.0, 27.0], [17.0, 44.0, 33.0, 
-8.0, 48.0], [-39.0, -99.0, 33.0, -65.0, 14.0], [-13.0, 37.0, 75.0, 40.0, -2.0]]], [[[27.0, -6.0, -48.0, -20.0, 16.0], [-81.0, 
-26.0, -38.0, -3.0, 56.0], [-59.0, 22.0, -2.0, 23.0, -36.0], [-50.0, -18.0, 10.0, 43.0, -7.0]], [[-26.0, -42.0, -24.0, 4.0, 
6.0], [-13.0, 41.0, -54.0, -17.0, 20.0], [-85.0, -7.0, 28.0, 17.0, -47.0], [-40.0, 40.0, 3.0, 12.0, -33.0]], [[-61.0, -5.0, 
7.0, 38.0, 21.0], [31.0, 2.0, -9.0, -37.0, 4.0], [-29.0, -49.0, 27.0, 3.0, -39.0], [6.0, 55.0, 7.0, -27.0, 42.0]], [[39.0, 
30.0, 8.0, 22.0, 52.0], [-24.0, 66.0, 22.0, 56.0, 39.0], [32.0, -6.0, 33.0, -56.0, 22.0], [-52.0, 18.0, -20.0, 12.0, 3.0]], 
[[-59.0, -12.0, -63.0, -67.0, -20.0], [6.0, -20.0, -62.0, -33.0, -35.0], [-39.0, 51.0, -10.0, 63.0, -49.0], [4.0, 9.0, -38.0, 
-42.0, 1.0]]], [[[50.0, -12.0, 33.0, 59.0, 70.0], [-2.0, 62.0, 66.0, 52.0, 56.0], [39.0, -33.0, -5.0, -141.0, 98.0], [-39.0, 
-33.0, 72.0, 9.0, 38.0]], [[18.0, 55.0, -15.0, -52.0, -37.0], [-22.0, -65.0, -1.0, 3.0, -31.0], [48.0, 44.0, -16.0, 72.0, 
-23.0], [31.0, -21.0, -60.0, 2.0, -6.0]], [[72.0, 20.0, -6.0, -14.0, 28.0], [-43.0, 30.0, 28.0, 62.0, 31.0], [45.0, 34.0, 
-11.0, -55.0, 57.0], [-39.0, -46.0, 0.0, 24.0, -10.0]], [[-24.0, 49.0, 17.0, 18.0, -11.0], [2.0, -37.0, -3.0, -23.0, -9.0], 
[10.0, -32.0, 34.0, 66.0, -67.0], [23.0, 55.0, -50.0, 2.0, 14.0]], [[-97.0, -25.0, 12.0, 13.0, -21.0], [84.0, 57.0, -43.0, 
-39.0, -58.0], [-41.0, -31.0, 48.0, 43.0, -61.0], [22.0, 98.0, -44.0, -53.0, -21.0]]], [[[54.0, 32.0, -23.0, -37.0, -26.0], 
[-75.0, -46.0, -22.0, 12.0, 19.0], [-8.0, 37.0, -2.0, 68.0, -39.0], [-16.0, -21.0, -38.0, 55.0, -42.0]], [[52.0, 35.0, -19.0, 
-54.0, -21.0], [-37.0, -38.0, 11.0, 30.0, -11.0], [51.0, 59.0, -32.0, 21.0, 24.0], [7.0, -57.0, -29.0, 14.0, -15.0]], [[102.0, 
65.0, -8.0, 17.0, 43.0], [-125.0, -42.0, 23.0, 44.0, 97.0], [16.0, -2.0, 13.0, -2.0, -14.0], [-60.0, -28.0, -5.0, 87.0, 11.0]], 
[[-34.0, -21.0, -44.0, -29.0, 13.0], [-4.0, 52.0, -55.0, 0.0, 0.0], [-51.0, 26.0, 24.0, 15.0, -37.0], [-41.0, 36.0, -31.0, 
-19.0, -21.0]], [[5.0, 40.0, 27.0, -17.0, -44.0], [28.0, -43.0, 26.0, -1.0, -52.0], [65.0, 10.0, -13.0, 43.0, 4.0], [58.0, 
-9.0, -39.0, -11.0, -6.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_array_rank1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[1.0, 0.0], [-1.0, -7.0], [1.0, 7.0]])+(1.-msk_arg0)*numpy.array([[-6.0, 7.0], [5.0, -7.0], 
[-1.0, 4.0]])
      arg1=numpy.array([-5.0, 1.0, -4.0])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-10.0, -35.0])+(1.-msk_ref)*numpy.array([39.0, -58.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_array_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-1.0, 1.0], [-2.0, 7.0], [6.0, 0.0]])+(1.-msk_arg0)*numpy.array([[5.0, -7.0], [-3.0, 6.0], 
[1.0, 0.0]])
      arg1=numpy.array([[-3.0, -6.0], [-7.0, 5.0], [-1.0, 3.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[11.0, 14.0], [-52.0, 29.0]])+(1.-msk_ref)*numpy.array([[5.0, -42.0], [-21.0, 72.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_constData_rank1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-1.0, 4.0], [0.0, 0.0], [-5.0, -2.0]])+(1.-msk_arg0)*numpy.array([[2.0, -3.0], [-5.0, -5.0], 
[-4.0, 5.0]])
      arg1=Data(numpy.array([0.0, 4.0, -4.0]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([20.0, 8.0])+(1.-msk_ref)*numpy.array([-4.0, -40.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_constData_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[-6.0, 2.0], [4.0, -6.0], [4.0, 1.0]])+(1.-msk_arg0)*numpy.array([[0.0, 6.0], [2.0, 4.0], 
[2.0, -7.0]])
      arg1=Data(numpy.array([[7.0, -2.0], [4.0, 2.0], [7.0, -7.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.0, -8.0], [-3.0, -23.0]])+(1.-msk_ref)*numpy.array([[22.0, -10.0], [9.0, 45.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_expandedData_rank1(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[4.0, 2.0], [0.0, 2.0], [6.0, -5.0]])+(1.-msk_arg0)*numpy.array([[-3.0, -4.0], [-6.0, 3.0], 
[-3.0, 2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([1.0, -2.0, 7.0])+(1.-msk_arg1)*numpy.array([0.0, 5.0, 1.0])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([46.0, -37.0])+(1.-msk_ref)*numpy.array([-33.0, 17.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank2_expandedData_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[3.0, 0.0], [-4.0, 4.0], [-7.0, 1.0]])+(1.-msk_arg0)*numpy.array([[1.0, 3.0], [-6.0, 6.0], 
[-7.0, -1.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, 1.0], [-3.0, 0.0], [2.0, 0.0]])+(1.-msk_arg1)*numpy.array([[4.0, -3.0], [-3.0, -3.0], 
[2.0, 0.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-14.0, 3.0], [-10.0, 0.0]])+(1.-msk_ref)*numpy.array([[8.0, 15.0], [-8.0, -27.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_array_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[3.0, 1.0, -6.0, 0.0, -3.0], [5.0, -5.0, 5.0, -7.0, 0.0], [2.0, 5.0, -6.0, -1.0, 7.0], 
[-3.0, 0.0, 0.0, 4.0, -1.0]], [[0.0, -5.0, -7.0, -2.0, -7.0], [5.0, 0.0, 0.0, -2.0, -4.0], [-6.0, 6.0, 3.0, 0.0, 0.0], [2.0, 
2.0, 6.0, 0.0, -7.0]], [[-3.0, 7.0, 2.0, 0.0, -3.0], [-5.0, -3.0, -1.0, -4.0, 5.0], [4.0, -3.0, -3.0, -3.0, 1.0], [-7.0, 3.0, 
0.0, -1.0, 1.0]]], [[[5.0, -1.0, 6.0, -3.0, 1.0], [1.0, 3.0, -5.0, 6.0, 5.0], [1.0, 0.0, -2.0, -3.0, 0.0], [-1.0, 5.0, 6.0, 
2.0, 4.0]], [[7.0, 5.0, -3.0, -5.0, 6.0], [-4.0, 5.0, 6.0, -4.0, 0.0], [-5.0, -5.0, -3.0, -1.0, -2.0], [0.0, 7.0, -4.0, -4.0, 
0.0]], [[-7.0, 7.0, -4.0, 0.0, 0.0], [-2.0, -3.0, 3.0, 3.0, -1.0], [-2.0, 1.0, 6.0, 5.0, -2.0], [-3.0, 2.0, -6.0, 6.0, 
4.0]]]])+(1.-msk_arg0)*numpy.array([[[[6.0, 4.0, 0.0, -3.0, 6.0], [6.0, 2.0, 3.0, -2.0, -2.0], [-3.0, -1.0, 3.0, -4.0, -3.0], 
[3.0, -4.0, -7.0, -5.0, 6.0]], [[-5.0, -6.0, 4.0, -7.0, -2.0], [-4.0, 4.0, 1.0, 7.0, 2.0], [7.0, -3.0, -4.0, -1.0, -5.0], [1.0, 
4.0, -2.0, -6.0, 4.0]], [[-4.0, 2.0, 4.0, 0.0, -1.0], [-1.0, 3.0, 0.0, -3.0, -7.0], [-2.0, -1.0, 6.0, -7.0, -4.0], [-2.0, 5.0, 
7.0, -5.0, -4.0]]], [[[7.0, -1.0, 4.0, -4.0, -1.0], [2.0, -1.0, -5.0, 7.0, 0.0], [5.0, 0.0, -7.0, 3.0, 3.0], [4.0, -2.0, 4.0, 
-3.0, 2.0]], [[6.0, 0.0, -3.0, -7.0, 1.0], [-4.0, -6.0, -7.0, 6.0, -3.0], [-3.0, -3.0, -3.0, 1.0, 5.0], [-3.0, 7.0, -3.0, -4.0, 
-3.0]], [[6.0, 0.0, 6.0, -6.0, -5.0], [4.0, 7.0, 1.0, -3.0, 5.0], [4.0, -7.0, 0.0, 1.0, 0.0], [-4.0, 5.0, 4.0, -3.0, 2.0]]]])
      arg1=numpy.array([[-1.0, -3.0, -7.0], [7.0, 5.0, -3.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[109.0, -38.0, 52.0, -40.0, 82.0], [8.0, 81.0, -12.0, 54.0, 15.0], [-24.0, -30.0, -29.0, -19.0, 
-18.0], [48.0, 37.0, 22.0, -21.0, 31.0]])+(1.-msk_ref)*numpy.array([[98.0, -7.0, -45.0, -21.0, 20.0], [-5.0, -93.0, -79.0, 
90.0, 15.0], [4.0, 23.0, -97.0, 79.0, 92.0], [33.0, -37.0, -35.0, 26.0, 3.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_array_rank3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[3.0, -3.0, 6.0, -2.0, -1.0], [7.0, 3.0, 3.0, -1.0, 0.0], [0.0, 0.0, -7.0, 0.0, 3.0], [-5.0, 
2.0, 6.0, 5.0, -7.0]], [[0.0, -4.0, 3.0, 1.0, 3.0], [0.0, 5.0, 0.0, 0.0, 2.0], [-4.0, -5.0, -3.0, 0.0, 4.0], [-5.0, 7.0, 1.0, 
-7.0, 0.0]], [[-4.0, -7.0, -3.0, -4.0, 5.0], [-6.0, -3.0, -3.0, -4.0, 0.0], [-2.0, 6.0, 0.0, -6.0, 6.0], [0.0, 0.0, -6.0, -6.0, 
3.0]]], [[[4.0, 0.0, 0.0, 2.0, 3.0], [4.0, -2.0, -2.0, -4.0, 1.0], [0.0, -1.0, -3.0, 6.0, 3.0], [-3.0, -3.0, 2.0, -5.0, -1.0]], 
[[5.0, -2.0, 0.0, 1.0, 2.0], [-1.0, 3.0, 4.0, -2.0, -7.0], [4.0, -4.0, -1.0, -6.0, 2.0], [-2.0, 4.0, -2.0, 3.0, 7.0]], [[5.0, 
-5.0, -3.0, 7.0, -3.0], [-5.0, -4.0, -4.0, 7.0, 7.0], [3.0, 1.0, 0.0, 2.0, 4.0], [0.0, -4.0, 4.0, -1.0, 
3.0]]]])+(1.-msk_arg0)*numpy.array([[[[0.0, 1.0, 1.0, -5.0, -6.0], [-5.0, 1.0, -3.0, -2.0, 0.0], [-1.0, -1.0, 0.0, 5.0, 4.0], 
[1.0, 0.0, 2.0, -6.0, -7.0]], [[7.0, 6.0, -7.0, 4.0, -2.0], [-6.0, 5.0, -4.0, -3.0, -6.0], [0.0, -3.0, -7.0, -2.0, -2.0], [7.0, 
4.0, 5.0, 0.0, 4.0]], [[3.0, 5.0, 7.0, -7.0, -4.0], [1.0, 2.0, 3.0, 6.0, -3.0], [2.0, 5.0, -5.0, 5.0, 7.0], [-7.0, 3.0, 0.0, 
1.0, -6.0]]], [[[5.0, 7.0, 4.0, 7.0, -1.0], [-7.0, 1.0, 4.0, 0.0, -2.0], [1.0, 2.0, 2.0, 0.0, -2.0], [-7.0, -1.0, 0.0, -2.0, 
-4.0]], [[6.0, -4.0, -7.0, 7.0, 6.0], [-5.0, -1.0, 0.0, -3.0, 4.0], [3.0, -3.0, 0.0, 4.0, -1.0], [-6.0, -1.0, 0.0, 2.0, -1.0]], 
[[-3.0, 7.0, 2.0, 3.0, -7.0], [6.0, 7.0, 4.0, 3.0, 5.0], [-3.0, 5.0, 5.0, -7.0, -1.0], [-6.0, 3.0, -4.0, -7.0, 1.0]]]])
      arg1=numpy.array([[[-2.0, 1.0], [0.0, -2.0], [-6.0, -7.0]], [[4.0, 4.0], [-6.0, 6.0], [-7.0, -4.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-31.0, 57.0], [95.0, 62.0], [27.0, 33.0], [-19.0, 10.0], [-7.0, -6.0]], [[79.0, 79.0], [14.0, 
40.0], [8.0, 56.0], [-27.0, -29.0], [-3.0, -70.0]], [[-33.0, 34.0], [-23.0, -64.0], [8.0, -19.0], [82.0, 22.0], [-70.0, 
-39.0]], [[10.0, -19.0], [-12.0, 16.0], [16.0, 26.0], [-5.0, 63.0], [-71.0, -2.0]]])+(1.-msk_ref)*numpy.array([[[-13.0, 33.0], 
[-29.0, -70.0], [0.0, -68.0], [17.0, 94.0], [45.0, 86.0]], [[-36.0, -82.0], [-53.0, -53.0], [-24.0, -16.0], [-35.0, -68.0], 
[-49.0, 29.0]], [[-3.0, 19.0], [-37.0, -60.0], [3.0, 37.0], [-15.0, 26.0], [-45.0, -51.0]], [[90.0, -4.0], [-37.0, -51.0], 
[24.0, 8.0], [35.0, 19.0], [33.0, 1.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_array_rank4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-6.0, 4.0, -4.0, 7.0, -7.0], [-4.0, -6.0, 7.0, 0.0, -5.0], [6.0, 3.0, -7.0, 0.0, 6.0], 
[3.0, 7.0, 2.0, -5.0, -4.0]], [[-6.0, 0.0, 1.0, -3.0, -2.0], [0.0, 7.0, 1.0, 5.0, 7.0], [1.0, 7.0, 1.0, 2.0, 4.0], [-1.0, 2.0, 
-5.0, -5.0, 3.0]], [[1.0, 3.0, 0.0, 1.0, -3.0], [6.0, -4.0, 2.0, 0.0, 7.0], [6.0, 2.0, 0.0, -5.0, -4.0], [5.0, -4.0, 2.0, -5.0, 
0.0]]], [[[5.0, 4.0, 2.0, -2.0, 2.0], [-6.0, -3.0, -6.0, 7.0, -5.0], [6.0, -7.0, 4.0, -7.0, -3.0], [-2.0, 6.0, 5.0, -5.0, 
-3.0]], [[6.0, -4.0, -7.0, 1.0, 0.0], [-3.0, 0.0, 7.0, 0.0, 5.0], [2.0, 4.0, -2.0, 7.0, 2.0], [1.0, -4.0, 5.0, 0.0, -2.0]], 
[[2.0, -7.0, 5.0, 0.0, 5.0], [-5.0, 3.0, -6.0, -2.0, 0.0], [0.0, 7.0, -5.0, -2.0, 0.0], [0.0, -6.0, -5.0, -1.0, 
5.0]]]])+(1.-msk_arg0)*numpy.array([[[[-3.0, 7.0, 6.0, 6.0, -3.0], [7.0, 7.0, -6.0, -1.0, -1.0], [-5.0, -4.0, 6.0, 1.0, -3.0], 
[-4.0, -7.0, -3.0, 1.0, -4.0]], [[-7.0, 7.0, 0.0, -1.0, -5.0], [-7.0, 2.0, -2.0, 0.0, -5.0], [5.0, -1.0, 6.0, 0.0, 1.0], [-1.0, 
6.0, 1.0, -5.0, 5.0]], [[5.0, -1.0, -2.0, 0.0, 5.0], [-1.0, -4.0, -4.0, -7.0, 0.0], [0.0, 5.0, 1.0, -1.0, 1.0], [0.0, 0.0, 5.0, 
6.0, 3.0]]], [[[-7.0, -2.0, -7.0, -7.0, -2.0], [-6.0, 1.0, -1.0, -4.0, -2.0], [1.0, -7.0, -4.0, 6.0, -5.0], [-2.0, -5.0, -3.0, 
0.0, -6.0]], [[7.0, 5.0, 4.0, 3.0, 2.0], [-4.0, -1.0, 4.0, 5.0, -2.0], [-4.0, -2.0, 6.0, -7.0, -2.0], [7.0, 2.0, -6.0, 4.0, 
-2.0]], [[5.0, 6.0, -2.0, 0.0, -4.0], [-1.0, 6.0, 1.0, 3.0, -5.0], [-4.0, -7.0, -7.0, 3.0, 3.0], [-1.0, -7.0, 2.0, -6.0, 
3.0]]]])
      arg1=numpy.array([[[[-6.0, -4.0, -6.0, 0.0, -4.0], [2.0, 0.0, 6.0, 4.0, -4.0], [0.0, 4.0, -7.0, -6.0, 1.0], [1.0, 3.0, 
-6.0, -3.0, 5.0]], [[0.0, -1.0, -4.0, -2.0, 5.0], [-4.0, -5.0, 5.0, 0.0, -4.0], [-1.0, 0.0, -1.0, 5.0, -1.0], [4.0, -6.0, 7.0, 
4.0, 2.0]], [[-7.0, 0.0, 0.0, -4.0, 4.0], [4.0, 2.0, -6.0, 5.0, 0.0], [-6.0, -7.0, -1.0, 0.0, 5.0], [0.0, 0.0, 5.0, 7.0, 
-3.0]]], [[[-3.0, -3.0, 0.0, 3.0, 3.0], [-1.0, 7.0, -5.0, -1.0, -4.0], [1.0, 4.0, 1.0, 3.0, 1.0], [7.0, 7.0, 0.0, -3.0, 6.0]], 
[[-2.0, 2.0, -6.0, 7.0, -3.0], [0.0, -2.0, 1.0, -7.0, 4.0], [-2.0, -4.0, 0.0, -2.0, -6.0], [3.0, 2.0, -2.0, 5.0, -2.0]], 
[[-1.0, 5.0, -1.0, 4.0, 3.0], [4.0, 0.0, 4.0, -1.0, -3.0], [-4.0, 0.0, 6.0, -4.0, -7.0], [-5.0, -3.0, -7.0, 4.0, 0.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 37.0, 22.0, 73.0, 1.0], [19.0, 55.0, -83.0, -68.0, 46.0], [-15.0, -35.0, 64.0, 1.0, 
-40.0], [13.0, 59.0, -27.0, 24.0, -27.0]], [[-42.0, -71.0, 7.0, -56.0, -1.0], [-12.0, 42.0, -46.0, 62.0, -27.0], [22.0, 27.0, 
-69.0, 24.0, 96.0], [55.0, 53.0, 48.0, -51.0, 43.0]], [[27.0, 20.0, 57.0, -25.0, 63.0], [6.0, 23.0, -16.0, 26.0, -39.0], [-5.0, 
20.0, 59.0, 29.0, 4.0], [-32.0, -33.0, 10.0, -5.0, 8.0]], [[-45.0, -17.0, -36.0, 3.0, -48.0], [32.0, 1.0, 32.0, 28.0, -4.0], 
[-7.0, 9.0, -49.0, -65.0, 7.0], [-16.0, 27.0, -60.0, -15.0, 12.0]], [[52.0, 49.0, 45.0, 42.0, 27.0], [0.0, 18.0, -24.0, -50.0, 
13.0], [2.0, 1.0, 86.0, 18.0, -53.0], [-26.0, -10.0, -22.0, 6.0, -18.0]]], [[[11.0, 3.0, 47.0, -83.0, 16.0], [2.0, -24.0, 
-53.0, 46.0, 43.0], [-16.0, -70.0, -14.0, 32.0, 73.0], [-30.0, -45.0, 95.0, 37.0, -68.0]], [[70.0, 41.0, 5.0, 5.0, 43.0], 
[-41.0, -64.0, 50.0, -44.0, -1.0], [2.0, -8.0, 54.0, 50.0, -57.0], [-14.0, -90.0, 44.0, 39.0, -22.0]], [[-46.0, -27.0, -82.0, 
-3.0, -72.0], [0.0, -57.0, 48.0, 1.0, 38.0], [-9.0, -38.0, -94.0, -45.0, 10.0], [20.0, 5.0, 3.0, 26.0, -19.0]], [[-19.0, -36.0, 
-18.0, 3.0, 40.0], [-35.0, 24.0, -18.0, -5.0, -42.0], [10.0, 28.0, -10.0, 54.0, 16.0], [79.0, 25.0, 49.0, -9.0, 52.0]], 
[[-14.0, 38.0, -28.0, -22.0, 53.0], [-5.0, -66.0, -7.0, -15.0, 32.0], [-64.0, -109.0, 16.0, 40.0, -12.0], [3.0, -82.0, 104.0, 
132.0, -72.0]]], [[[-100.0, -39.0, -52.0, 6.0, 17.0], [26.0, 45.0, -23.0, 34.0, -44.0], [-35.0, -2.0, -43.0, -17.0, 29.0], 
[58.0, 58.0, -3.0, 20.0, 46.0]], [[-26.0, 45.0, -77.0, 13.0, 19.0], [21.0, -88.0, 108.0, -6.0, -17.0], [-62.0, -46.0, 5.0, 
-40.0, -74.0], [-41.0, -95.0, -16.0, 102.0, -27.0]], [[39.0, -14.0, 55.0, -24.0, 36.0], [-42.0, 27.0, -79.0, -13.0, 15.0], 
[27.0, -4.0, 22.0, 83.0, 43.0], [44.0, 12.0, 88.0, -17.0, -5.0]], [[44.0, 23.0, -48.0, 36.0, -58.0], [-29.0, -83.0, 74.0, 
-65.0, 54.0], [15.0, -21.0, -16.0, -17.0, -62.0], [-10.0, -41.0, -11.0, 21.0, -37.0]], [[-3.0, -15.0, -64.0, 13.0, -35.0], 
[-17.0, -53.0, 97.0, -7.0, -20.0], [13.0, 32.0, -45.0, -29.0, -33.0], [7.0, -23.0, -32.0, -11.0, 28.0]]], [[[-49.0, -3.0, 
-20.0, -17.0, -6.0], [32.0, -1.0, -6.0, 32.0, 4.0], [-33.0, -35.0, -27.0, -31.0, 21.0], [-12.0, 3.0, -2.0, 33.0, -16.0]], 
[[-18.0, -86.0, -20.0, -22.0, -22.0], [-40.0, 32.0, 18.0, 36.0, -58.0], [60.0, 96.0, -77.0, 18.0, 57.0], [75.0, 61.0, 2.0, 
-103.0, 95.0]], [[-46.0, -33.0, -17.0, 32.0, -40.0], [7.0, 54.0, -65.0, -17.0, 27.0], [8.0, -6.0, -36.0, -12.0, 27.0], [57.0, 
96.0, -12.0, -22.0, 14.0]], [[81.0, 35.0, 51.0, 11.0, -43.0], [-9.0, -20.0, -4.0, -39.0, 63.0], [34.0, -5.0, 34.0, -6.0, 
-23.0], [-55.0, -17.0, -23.0, -29.0, -50.0]], [[32.0, 43.0, 19.0, -9.0, 43.0], [3.0, -32.0, 24.0, -4.0, -7.0], [-22.0, -20.0, 
52.0, 14.0, -33.0], [-44.0, -70.0, 14.0, 43.0, -28.0]]]])+(1.-msk_ref)*numpy.array([[[[-15.0, 79.0, -1.0, 42.0, -30.0], [69.0, 
-18.0, -21.0, -34.0, 81.0], [-64.0, -103.0, 46.0, -72.0, -55.0], [-84.0, -17.0, -55.0, 92.0, -100.0]], [[-45.0, 11.0, -106.0, 
43.0, 0.0], [8.0, -61.0, 122.0, -16.0, -46.0], [-37.0, 7.0, -21.0, -47.0, -79.0], [6.0, -43.0, -50.0, 55.0, 30.0]], [[-7.0, 
-5.0, -58.0, 7.0, -71.0], [3.0, -61.0, 79.0, -5.0, 26.0], [5.0, -6.0, -59.0, -57.0, -21.0], [-21.0, -17.0, -40.0, 1.0, -14.0]], 
[[-21.0, 4.0, -50.0, 2.0, -59.0], [23.0, -50.0, 69.0, 10.0, 20.0], [-12.0, -16.0, -48.0, -68.0, -18.0], [-38.0, -19.0, -49.0, 
14.0, -20.0]], [[-11.0, 7.0, 30.0, -18.0, -17.0], [20.0, 17.0, -77.0, 5.0, 60.0], [-15.0, -63.0, -5.0, -1.0, 41.0], [-11.0, 
23.0, 32.0, 24.0, -56.0]]], [[[-8.0, -16.0, 11.0, -32.0, -76.0], [40.0, -1.0, 35.0, 58.0, 11.0], [19.0, 27.0, -53.0, -83.0, 
34.0], [-70.0, 16.0, -81.0, -62.0, -4.0]], [[-21.0, -5.0, -50.0, 32.0, -10.0], [13.0, -9.0, 94.0, 8.0, -62.0], [1.0, 64.0, 
-10.0, -51.0, -50.0], [-11.0, -4.0, -88.0, -25.0, 59.0]], [[58.0, 42.0, 19.0, 49.0, -14.0], [-15.0, -13.0, -9.0, -72.0, 49.0], 
[13.0, -16.0, 53.0, 11.0, -56.0], [-14.0, -8.0, -13.0, 9.0, -36.0]], [[54.0, 41.0, -27.0, 63.0, -42.0], [-14.0, -52.0, 73.0, 
-73.0, 31.0], [16.0, 9.0, 28.0, -28.0, -91.0], [-29.0, -30.0, -60.0, 3.0, -18.0]], [[21.0, -14.0, 43.0, -30.0, -36.0], [0.0, 
15.0, -43.0, 17.0, 39.0], [27.0, -4.0, -20.0, -1.0, 49.0], [-16.0, 24.0, 10.0, -41.0, -23.0]]], [[[39.0, -16.0, 38.0, -51.0, 
48.0], [-47.0, -10.0, -30.0, 11.0, -8.0], [20.0, 0.0, 7.0, 82.0, 43.0], [30.0, -34.0, 101.0, -4.0, -1.0]], [[21.0, -1.0, 47.0, 
-81.0, -5.0], [-5.0, -30.0, -54.0, 37.0, 61.0], [-4.0, -71.0, -25.0, 30.0, 76.0], [-28.0, -38.0, 95.0, 26.0, -75.0]], [[-36.0, 
-41.0, -89.0, -14.0, -41.0], [-32.0, -68.0, 58.0, -2.0, 13.0], [0.0, -23.0, -95.0, -2.0, 14.0], [55.0, -13.0, 48.0, 27.0, 
3.0]], [[-6.0, -21.0, 33.0, -15.0, 40.0], [4.0, 54.0, -13.0, 39.0, -65.0], [14.0, 63.0, 18.0, 14.0, 23.0], [7.0, 22.0, -18.0, 
-51.0, 58.0]], [[27.0, 37.0, 23.0, -23.0, 21.0], [11.0, -34.0, 16.0, 9.0, 11.0], [-20.0, -31.0, 32.0, 0.0, -13.0], [-55.0, 
-63.0, 13.0, 37.0, -42.0]]], [[[17.0, 32.0, -13.0, 41.0, -19.0], [-6.0, -23.0, -16.0, -62.0, 59.0], [-11.0, -52.0, 21.0, 3.0, 
-40.0], [4.0, -3.0, 10.0, 45.0, -48.0]], [[60.0, 6.0, 13.0, -41.0, 16.0], [-61.0, -69.0, -13.0, -30.0, 53.0], [13.0, -56.0, 
-4.0, 81.0, 19.0], [23.0, -67.0, 129.0, 42.0, -57.0]], [[2.0, 18.0, 48.0, -65.0, 52.0], [21.0, -4.0, -26.0, 56.0, -10.0], 
[-30.0, -35.0, 24.0, 18.0, 40.0], [-48.0, -54.0, 48.0, 35.0, -34.0]], [[-50.0, -21.0, -4.0, -10.0, -35.0], [22.0, 29.0, -75.0, 
12.0, 50.0], [-15.0, -54.0, -44.0, -15.0, 54.0], [23.0, 59.0, 23.0, 15.0, -31.0]], [[22.0, 40.0, 13.0, -42.0, 50.0], [2.0, 
-57.0, 23.0, 16.0, 3.0], [-37.0, -53.0, 32.0, 23.0, -9.0], [-47.0, -97.0, 57.0, 73.0, -51.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_constData_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-3.0, -4.0, -4.0, -2.0, -3.0], [3.0, 4.0, -3.0, 0.0, -7.0], [0.0, 3.0, -4.0, -1.0, 3.0], 
[0.0, 4.0, 0.0, 0.0, 6.0]], [[-1.0, 4.0, -5.0, 5.0, 6.0], [3.0, -3.0, -6.0, 0.0, 7.0], [-6.0, 0.0, -4.0, -1.0, -6.0], [1.0, 
-2.0, 0.0, -1.0, 4.0]], [[5.0, 5.0, 3.0, -3.0, 1.0], [7.0, 4.0, 4.0, 5.0, -4.0], [4.0, -5.0, -1.0, -1.0, -6.0], [5.0, 0.0, 
-6.0, -2.0, -7.0]]], [[[1.0, 0.0, -4.0, -3.0, -3.0], [0.0, -3.0, -2.0, 0.0, -4.0], [2.0, -2.0, -5.0, -5.0, 5.0], [4.0, -6.0, 
-1.0, 0.0, -4.0]], [[5.0, -6.0, -7.0, -4.0, 2.0], [0.0, -5.0, 2.0, 5.0, 0.0], [4.0, 0.0, 6.0, 5.0, 2.0], [-1.0, 0.0, 0.0, 3.0, 
-1.0]], [[5.0, -4.0, 5.0, -2.0, -6.0], [5.0, 4.0, 0.0, 0.0, -7.0], [-7.0, 4.0, -7.0, 1.0, -1.0], [-7.0, -3.0, 7.0, 0.0, 
6.0]]]])+(1.-msk_arg0)*numpy.array([[[[-1.0, -5.0, 0.0, 4.0, 2.0], [0.0, -6.0, -3.0, 2.0, 7.0], [6.0, -2.0, -3.0, 5.0, 3.0], 
[0.0, -4.0, 7.0, 2.0, 4.0]], [[-7.0, -7.0, 2.0, 4.0, 7.0], [0.0, -4.0, -2.0, 7.0, 6.0], [7.0, 2.0, -4.0, 2.0, 3.0], [4.0, 7.0, 
-6.0, 4.0, 4.0]], [[1.0, -2.0, 2.0, -7.0, 5.0], [6.0, -5.0, -7.0, 0.0, -1.0], [7.0, -4.0, 6.0, -1.0, 0.0], [-5.0, 0.0, 6.0, 
-1.0, 1.0]]], [[[-2.0, 6.0, -1.0, -5.0, 4.0], [-1.0, 1.0, 3.0, -6.0, -3.0], [-6.0, 6.0, 3.0, 2.0, -2.0], [5.0, -7.0, 4.0, -2.0, 
0.0]], [[-6.0, 5.0, 2.0, -5.0, 7.0], [4.0, -4.0, -4.0, -2.0, 5.0], [4.0, -6.0, 2.0, -6.0, 4.0], [-2.0, 1.0, 2.0, -2.0, -6.0]], 
[[-6.0, -2.0, 0.0, 4.0, -4.0], [-7.0, -5.0, -3.0, -1.0, 1.0], [-3.0, -2.0, -4.0, 6.0, 3.0], [1.0, 0.0, -2.0, 3.0, 4.0]]]])
      arg1=Data(numpy.array([[-2.0, 5.0, -2.0], [-7.0, 0.0, 7.0]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[19.0, -10.0, 40.0, 42.0, 13.0], [30.0, 18.0, -18.0, -10.0, 36.0], [-101.0, 46.0, -24.0, 41.0, 
-66.0], [-82.0, 3.0, 68.0, -1.0, 92.0]])+(1.-msk_ref)*numpy.array([[-63.0, -77.0, 13.0, 89.0, -35.0], [-54.0, -40.0, -32.0, 
66.0, 46.0], [30.0, -34.0, -75.0, 30.0, 44.0], [2.0, 92.0, -98.0, 53.0, 38.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_constData_rank3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[2.0, -2.0, 5.0, -3.0, -5.0], [-4.0, 7.0, 0.0, 4.0, 0.0], [-6.0, -4.0, 6.0, -5.0, -3.0], 
[-1.0, 7.0, 4.0, -3.0, 4.0]], [[-6.0, -4.0, -6.0, 6.0, -1.0], [1.0, 7.0, -6.0, 5.0, -2.0], [-5.0, -1.0, 0.0, 4.0, 0.0], [-7.0, 
-2.0, 3.0, -2.0, -2.0]], [[1.0, -2.0, 4.0, 4.0, -2.0], [1.0, 0.0, -7.0, 3.0, -7.0], [5.0, -4.0, -1.0, 3.0, -3.0], [-7.0, -1.0, 
-2.0, -1.0, -3.0]]], [[[0.0, 5.0, 3.0, 0.0, -2.0], [5.0, -6.0, 1.0, -3.0, -6.0], [0.0, 3.0, 7.0, 0.0, -7.0], [-6.0, -2.0, 7.0, 
-2.0, -5.0]], [[6.0, -5.0, -2.0, 4.0, 3.0], [3.0, 5.0, 2.0, -2.0, 4.0], [0.0, 7.0, -6.0, 4.0, 0.0], [0.0, 6.0, 0.0, -7.0, 
1.0]], [[2.0, 3.0, -7.0, -2.0, 0.0], [7.0, 6.0, 7.0, -1.0, 6.0], [7.0, -1.0, -4.0, 3.0, 0.0], [1.0, 3.0, 3.0, 7.0, 
-4.0]]]])+(1.-msk_arg0)*numpy.array([[[[-4.0, 3.0, 3.0, 0.0, 7.0], [6.0, 7.0, -1.0, 2.0, -6.0], [5.0, -4.0, 0.0, -2.0, 4.0], 
[-7.0, 6.0, -5.0, 2.0, -7.0]], [[-4.0, -6.0, 4.0, -1.0, 7.0], [0.0, -4.0, 2.0, -6.0, -3.0], [3.0, 0.0, 3.0, -6.0, -1.0], [-6.0, 
6.0, 5.0, -3.0, -4.0]], [[-7.0, 6.0, 6.0, 5.0, 2.0], [-6.0, 5.0, 3.0, -5.0, 0.0], [-5.0, -4.0, 2.0, -7.0, 3.0], [4.0, 2.0, 4.0, 
4.0, -4.0]]], [[[0.0, -4.0, -4.0, -2.0, 0.0], [-2.0, -6.0, -2.0, 5.0, -3.0], [4.0, 3.0, -3.0, -2.0, 3.0], [6.0, -2.0, -6.0, 
0.0, 3.0]], [[6.0, -7.0, 0.0, 6.0, -7.0], [4.0, 2.0, 0.0, 6.0, -5.0], [-5.0, 3.0, -3.0, 5.0, 0.0], [-1.0, 0.0, 6.0, 5.0, 
-2.0]], [[-6.0, -3.0, 0.0, -1.0, -5.0], [0.0, -7.0, -3.0, 4.0, -5.0], [0.0, 5.0, 5.0, -3.0, -2.0], [-1.0, -3.0, -1.0, -1.0, 
-7.0]]]])
      arg1=Data(numpy.array([[[-4.0, -7.0], [3.0, 5.0], [0.0, -1.0]], [[-1.0, 4.0], [-6.0, -4.0], [2.0, 
-6.0]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-58.0, -81.0], [27.0, 18.0], [-43.0, -7.0], [2.0, 43.0], [1.0, 12.0]], [[10.0, -2.0], [-19.0, 
-94.0], [-17.0, -69.0], [12.0, -4.0], [-12.0, -79.0]], [[23.0, -30.0], [-34.0, 17.0], [-3.0, 35.0], [14.0, 18.0], [19.0, 
-4.0]], [[-9.0, -51.0], [-62.0, -108.0], [-8.0, -1.0], [64.0, -10.0], [-31.0, -35.0]]])+(1.-msk_ref)*numpy.array([[[-44.0, 
27.0], [10.0, -27.0], [4.0, -23.0], [-39.0, -36.0], [25.0, 42.0]], [[-46.0, -60.0], [-60.0, -64.0], [6.0, 24.0], [-59.0, 
-67.0], [38.0, 65.0]], [[15.0, 21.0], [5.0, 2.0], [40.0, -17.0], [-44.0, -19.0], [-26.0, -12.0]], [[8.0, 49.0], [-10.0, -4.0], 
[3.0, 14.0], [-49.0, -47.0], [11.0, 95.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_constData_rank4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-1.0, 0.0, 2.0, 3.0, 7.0], [4.0, 0.0, 3.0, 0.0, -4.0], [2.0, -7.0, 3.0, 0.0, 7.0], [5.0, 
1.0, -4.0, 5.0, 2.0]], [[5.0, -3.0, -2.0, 3.0, -4.0], [7.0, -1.0, 5.0, -2.0, 0.0], [4.0, 7.0, -5.0, -5.0, -4.0], [-3.0, -6.0, 
6.0, -4.0, -6.0]], [[-1.0, -1.0, 0.0, 6.0, 2.0], [-2.0, 2.0, -5.0, 0.0, -7.0], [-1.0, -4.0, -1.0, -3.0, 4.0], [-7.0, -3.0, 7.0, 
-1.0, 3.0]]], [[[1.0, -4.0, 2.0, -5.0, -5.0], [7.0, -7.0, -2.0, 7.0, -5.0], [-7.0, 2.0, -5.0, 2.0, -6.0], [-4.0, 6.0, 3.0, 1.0, 
-7.0]], [[1.0, 1.0, -6.0, 2.0, -5.0], [3.0, 2.0, -2.0, 4.0, 6.0], [-7.0, -2.0, -4.0, 1.0, 2.0], [7.0, -3.0, 0.0, 1.0, -5.0]], 
[[6.0, 5.0, 0.0, -1.0, 1.0], [-7.0, 1.0, 2.0, -5.0, 5.0], [-3.0, 0.0, -7.0, -3.0, -7.0], [4.0, 6.0, 5.0, -6.0, 
-5.0]]]])+(1.-msk_arg0)*numpy.array([[[[1.0, -4.0, 5.0, -7.0, -4.0], [2.0, -5.0, 7.0, -3.0, -6.0], [5.0, 3.0, -1.0, 2.0, -2.0], 
[-6.0, -1.0, 3.0, -2.0, 2.0]], [[-6.0, -3.0, -7.0, 2.0, -7.0], [-5.0, 7.0, 7.0, 7.0, -3.0], [-1.0, 1.0, 0.0, -6.0, -5.0], [7.0, 
4.0, -7.0, 3.0, -4.0]], [[5.0, 5.0, 6.0, 6.0, 6.0], [-4.0, -7.0, -7.0, -1.0, -2.0], [4.0, -4.0, 1.0, 7.0, -7.0], [4.0, -4.0, 
-1.0, 0.0, 0.0]]], [[[0.0, 5.0, 7.0, -4.0, 1.0], [-1.0, -1.0, -7.0, 4.0, 0.0], [7.0, 2.0, -1.0, 1.0, -2.0], [-4.0, -4.0, -3.0, 
0.0, -3.0]], [[-7.0, -3.0, 3.0, 5.0, 4.0], [2.0, -7.0, -6.0, 6.0, 5.0], [0.0, 4.0, -7.0, -1.0, 4.0], [-1.0, 0.0, -6.0, 0.0, 
7.0]], [[-7.0, -1.0, -5.0, -1.0, -7.0], [6.0, 5.0, 6.0, 2.0, 2.0], [1.0, -4.0, -1.0, 1.0, 2.0], [6.0, -3.0, 2.0, -3.0, 2.0]]]])
      arg1=Data(numpy.array([[[[-3.0, -3.0, -6.0, -5.0, 0.0], [4.0, 6.0, -6.0, 0.0, 1.0], [-5.0, 5.0, -4.0, 3.0, -6.0], [5.0, 
-3.0, 6.0, -6.0, -4.0]], [[6.0, 2.0, -4.0, 0.0, 7.0], [4.0, -4.0, 3.0, 4.0, -4.0], [-2.0, 4.0, 0.0, 2.0, 7.0], [1.0, -6.0, 7.0, 
-6.0, 3.0]], [[3.0, 3.0, 3.0, 3.0, -3.0], [-3.0, 0.0, 7.0, 6.0, 0.0], [6.0, 5.0, -2.0, 0.0, -2.0], [-1.0, -1.0, 5.0, -6.0, 
6.0]]], [[[5.0, -5.0, 4.0, 7.0, -1.0], [4.0, -6.0, -2.0, -3.0, -6.0], [6.0, 7.0, -2.0, 1.0, 6.0], [-6.0, -7.0, 0.0, 4.0, 1.0]], 
[[5.0, 3.0, -6.0, 0.0, 4.0], [3.0, -4.0, 7.0, 5.0, -1.0], [6.0, 0.0, -4.0, 6.0, 6.0], [-6.0, -4.0, 0.0, -5.0, 5.0]], [[1.0, 
4.0, -3.0, 4.0, 6.0], [2.0, -1.0, 4.0, 4.0, 4.0], [-7.0, 0.0, -4.0, 0.0, -1.0], [6.0, -1.0, 3.0, -6.0, 
5.0]]]]),self.functionspace)
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[46.0, 32.0, -37.0, 33.0, 77.0], [38.0, -42.0, 43.0, 40.0, -4.0], [-41.0, 17.0, -24.0, 14.0, 
49.0], [25.0, -43.0, 42.0, -55.0, 49.0]], [[-31.0, 34.0, -28.0, -11.0, 20.0], [-12.0, 27.0, 19.0, 19.0, 55.0], [-53.0, -45.0, 
-14.0, -4.0, -42.0], [46.0, 38.0, -11.0, -27.0, 11.0]], [[-38.0, -38.0, 40.0, 4.0, -40.0], [-10.0, 32.0, -64.0, -44.0, 4.0], 
[-30.0, 16.0, 12.0, -32.0, -50.0], [32.0, 16.0, -2.0, 38.0, -42.0]], [[11.0, 42.0, -41.0, -36.0, 10.0], [-10.0, 29.0, 53.0, 
69.0, 15.0], [4.0, 22.0, -18.0, 22.0, -26.0], [24.0, -5.0, 66.0, -96.0, 33.0]], [[-88.0, -9.0, -13.0, -60.0, -43.0], [-27.0, 
107.0, -61.0, -10.0, 62.0], [-82.0, -6.0, -6.0, -22.0, -135.0], [95.0, 55.0, 27.0, -31.0, -53.0]]], [[[67.0, -58.0, -27.0, 
-5.0, 18.0], [73.0, -51.0, -38.0, -18.0, -97.0], [63.0, 87.0, -10.0, 51.0, 96.0], [-73.0, -106.0, 42.0, 1.0, -20.0]], [[-24.0, 
49.0, -33.0, -39.0, 8.0], [-30.0, 37.0, 43.0, 43.0, 48.0], [-23.0, -43.0, -2.0, 3.0, -42.0], [33.0, 44.0, 6.0, -50.0, 17.0]], 
[[-12.0, -2.0, -55.0, -36.0, 56.0], [37.0, 16.0, -40.0, -6.0, 5.0], [-93.0, -4.0, 2.0, 5.0, 1.0], [61.0, -14.0, 34.0, -28.0, 
-29.0]], [[38.0, -47.0, 27.0, 29.0, -35.0], [22.0, -45.0, -12.0, -29.0, -58.0], [105.0, 41.0, -10.0, 27.0, 57.0], [-98.0, 
-48.0, -29.0, 50.0, -4.0]], [[1.0, 54.0, -68.0, -16.0, 80.0], [13.0, -23.0, 47.0, 23.0, 40.0], [-51.0, -90.0, -4.0, 19.0, 
39.0], [11.0, 25.0, -44.0, -14.0, 24.0]]], [[[-58.0, 1.0, -8.0, -74.0, -8.0], [-28.0, 69.0, -54.0, -16.0, 23.0], [-87.0, -28.0, 
48.0, -35.0, -63.0], [81.0, 51.0, 26.0, -5.0, -59.0]], [[51.0, 7.0, 22.0, 37.0, 51.0], [14.0, -74.0, 17.0, -12.0, -45.0], 
[-3.0, -13.0, 40.0, -17.0, 99.0], [-24.0, -23.0, -13.0, 42.0, 17.0]], [[-94.0, -37.0, 24.0, -81.0, -85.0], [-51.0, 91.0, -86.0, 
-59.0, 29.0], [-16.0, -45.0, 44.0, -30.0, -98.0], [23.0, 80.0, -43.0, 60.0, -93.0]], [[-27.0, -38.0, 22.0, -7.0, -42.0], [-6.0, 
7.0, -45.0, -51.0, -5.0], [31.0, -21.0, 10.0, -2.0, -8.0], [-38.0, 18.0, -59.0, 69.0, -41.0]], [[-60.0, -9.0, -29.0, -93.0, 
-68.0], [-32.0, 93.0, -28.0, 8.0, 29.0], [22.0, -3.0, -4.0, 19.0, -95.0], [9.0, 40.0, 13.0, -34.0, -47.0]]], [[[-35.0, 15.0, 
-109.0, -58.0, 56.0], [42.0, 34.0, -15.0, 9.0, 50.0], [-71.0, -50.0, -42.0, 47.0, -23.0], [35.0, 6.0, -14.0, -45.0, -20.0]], 
[[-27.0, -39.0, 33.0, 52.0, -15.0], [16.0, 0.0, -54.0, -51.0, 16.0], [-35.0, 8.0, -22.0, -21.0, -30.0], [20.0, 0.0, -33.0, 
51.0, -19.0]], [[89.0, 50.0, 18.0, 82.0, 48.0], [9.0, -71.0, 105.0, 77.0, -26.0], [33.0, 60.0, -24.0, 3.0, 65.0], [-9.0, -57.0, 
68.0, -72.0, 104.0]], [[-38.0, -52.0, -1.0, -45.0, -58.0], [2.0, 42.0, -68.0, -44.0, -10.0], [31.0, 11.0, 0.0, 14.0, -38.0], 
[-26.0, 5.0, -21.0, 35.0, -62.0]], [[-98.0, -9.0, 38.0, -70.0, -94.0], [-78.0, 103.0, -50.0, -30.0, 53.0], [-17.0, -48.0, 40.0, 
-43.0, -127.0], [43.0, 101.0, -30.0, 33.0, -65.0]]]])+(1.-msk_ref)*numpy.array([[[[-66.0, -49.0, 96.0, -18.0, -127.0], [-70.0, 
65.0, -66.0, -57.0, 4.0], [44.0, 6.0, 42.0, -51.0, -93.0], [-6.0, 63.0, -32.0, 77.0, -62.0]], [[18.0, -17.0, 92.0, 66.0, 
-59.0], [-34.0, -29.0, 15.0, -16.0, -23.0], [75.0, 28.0, 12.0, -31.0, 6.0], [-46.0, 3.0, -23.0, 53.0, 22.0]], [[6.0, -57.0, 
41.0, 22.0, -92.0], [1.0, 9.0, -22.0, -18.0, -32.0], [120.0, 76.0, -38.0, 26.0, -26.0], [-78.0, -35.0, -4.0, 19.0, -8.0]], 
[[55.0, 74.0, 9.0, 21.0, 14.0], [-41.0, -45.0, 129.0, 77.0, 0.0], [80.0, -25.0, 8.0, 9.0, 51.0], [-51.0, 12.0, -1.0, -41.0, 
86.0]], [[6.0, -5.0, 71.0, 17.0, -94.0], [-60.0, -11.0, 43.0, -3.0, -14.0], [149.0, -11.0, 14.0, -1.0, 0.0], [-105.0, 32.0, 
-64.0, 56.0, 17.0]]], [[[-37.0, 7.0, -38.0, -5.0, 22.0], [14.0, 24.0, -15.0, -7.0, 50.0], [-60.0, -37.0, -30.0, 7.0, -39.0], 
[39.0, 21.0, -25.0, -8.0, -8.0]], [[1.0, 12.0, 4.0, 17.0, 73.0], [14.0, -29.0, -25.0, -26.0, 0.0], [-114.0, -39.0, 44.0, -44.0, 
40.0], [67.0, 10.0, -1.0, 31.0, -12.0]], [[-59.0, 13.0, -101.0, -81.0, 89.0], [43.0, 74.0, -74.0, 1.0, 51.0], [-211.0, -21.0, 
0.0, -8.0, -63.0], [163.0, 11.0, 74.0, -76.0, -56.0]], [[100.0, 26.0, -39.0, 48.0, 84.0], [57.0, -96.0, 74.0, 48.0, -53.0], 
[41.0, 36.0, -26.0, 45.0, 127.0], [-55.0, -86.0, 32.0, -44.0, 71.0]], [[21.0, 29.0, 6.0, 32.0, 17.0], [-11.0, -46.0, 56.0, 9.0, 
9.0], [40.0, -52.0, 0.0, 6.0, 47.0], [-49.0, 16.0, -61.0, 29.0, 38.0]]], [[[27.0, -36.0, 11.0, 40.0, -20.0], [34.0, -9.0, 
-15.0, 3.0, -29.0], [36.0, 90.0, -46.0, 20.0, -4.0], [-16.0, -63.0, 46.0, -26.0, 13.0]], [[11.0, -33.0, -38.0, -29.0, 9.0], 
[40.0, -10.0, -35.0, -22.0, -33.0], [23.0, 13.0, -8.0, 37.0, 37.0], [-40.0, -37.0, -7.0, 12.0, -31.0]], [[-35.0, -14.0, 50.0, 
-3.0, -36.0], [-34.0, 29.0, -38.0, -30.0, 8.0], [-30.0, -7.0, 36.0, -46.0, -43.0], [36.0, 38.0, -4.0, 37.0, -31.0]], [[-20.0, 
-1.0, 40.0, 22.0, -62.0], [-34.0, 33.0, 14.0, 14.0, 25.0], [37.0, 28.0, -24.0, -11.0, -69.0], [3.0, 19.0, 8.0, -15.0, 17.0]], 
[[-33.0, 5.0, -27.0, -17.0, 16.0], [1.0, 2.0, -12.0, -28.0, 34.0], [-24.0, -79.0, 2.0, 6.0, 1.0], [-8.0, 39.0, -76.0, 44.0, 
-21.0]]], [[[53.0, 85.0, -8.0, 38.0, 73.0], [-15.0, -42.0, 110.0, 83.0, 15.0], [-32.0, -10.0, 4.0, -14.0, 41.0], [39.0, -2.0, 
51.0, -77.0, 90.0]], [[-8.0, 7.0, -29.0, -47.0, 26.0], [2.0, 5.0, -14.0, -8.0, -5.0], [-30.0, -37.0, 32.0, 1.0, 21.0], [9.0, 
14.0, -7.0, 8.0, -27.0]], [[-97.0, -21.0, 25.0, -31.0, -55.0], [-39.0, 86.0, -74.0, -47.0, 63.0], [-75.0, -39.0, 12.0, -44.0, 
-121.0], [75.0, 77.0, -30.0, 36.0, -62.0]], [[21.0, 0.0, 9.0, -2.0, 3.0], [-2.0, -21.0, 9.0, 0.0, -26.0], [25.0, 2.0, 20.0, 
0.0, 36.0], [-25.0, -9.0, 0.0, 12.0, 2.0]], [[-8.0, 30.0, -56.0, -23.0, 15.0], [5.0, 16.0, 39.0, 36.0, 37.0], [8.0, -27.0, 
-38.0, 37.0, -18.0], [-6.0, 9.0, -10.0, -47.0, 22.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_expandedData_rank2(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[-7.0, 1.0, 4.0, 2.0, 0.0], [5.0, -7.0, 5.0, -6.0, 3.0], [0.0, 3.0, 4.0, 3.0, 0.0], [5.0, 
6.0, 2.0, 1.0, 5.0]], [[6.0, -6.0, 0.0, -4.0, 1.0], [3.0, -6.0, 0.0, 2.0, 5.0], [0.0, 2.0, 6.0, 0.0, -4.0], [0.0, -2.0, -7.0, 
-5.0, 1.0]], [[0.0, 6.0, -4.0, 0.0, -2.0], [-6.0, 2.0, -3.0, 7.0, 0.0], [-3.0, 7.0, -2.0, 5.0, 0.0], [0.0, 6.0, -4.0, 0.0, 
-7.0]]], [[[-6.0, 5.0, 5.0, -3.0, 0.0], [0.0, 1.0, -3.0, 7.0, -1.0], [-1.0, 0.0, 1.0, 7.0, 6.0], [-7.0, -2.0, 6.0, 1.0, 7.0]], 
[[-3.0, 0.0, -2.0, 6.0, 4.0], [-6.0, -4.0, -5.0, -6.0, -1.0], [-2.0, 2.0, -4.0, 4.0, -2.0], [6.0, -4.0, 5.0, -2.0, -3.0]], 
[[-4.0, 1.0, -7.0, -4.0, -6.0], [-1.0, 1.0, 3.0, -3.0, -7.0], [6.0, 3.0, 7.0, -5.0, -6.0], [0.0, -2.0, 0.0, -6.0, 
-6.0]]]])+(1.-msk_arg0)*numpy.array([[[[-3.0, -6.0, -6.0, 0.0, 6.0], [5.0, 5.0, -7.0, -6.0, 6.0], [-4.0, -3.0, -5.0, 7.0, 6.0], 
[5.0, 3.0, 7.0, -1.0, -6.0]], [[-4.0, 7.0, 6.0, -1.0, 7.0], [5.0, -1.0, 3.0, 3.0, -3.0], [0.0, 0.0, 7.0, 7.0, 1.0], [3.0, -2.0, 
0.0, -7.0, 4.0]], [[1.0, 3.0, 0.0, 4.0, 7.0], [-3.0, 0.0, 1.0, -5.0, -6.0], [7.0, -7.0, 4.0, 7.0, -1.0], [-1.0, 0.0, -4.0, 
-7.0, 5.0]]], [[[-5.0, 7.0, 0.0, -6.0, 0.0], [4.0, -5.0, -2.0, -6.0, 0.0], [1.0, -2.0, 7.0, 4.0, 5.0], [-6.0, -6.0, -7.0, -3.0, 
-4.0]], [[-1.0, -2.0, 0.0, -5.0, 0.0], [-3.0, 0.0, 0.0, 2.0, 1.0], [-4.0, 0.0, 3.0, 0.0, 2.0], [-5.0, -3.0, 3.0, 0.0, -5.0]], 
[[4.0, -7.0, -3.0, 2.0, -5.0], [2.0, 3.0, -2.0, 3.0, -4.0], [-3.0, 4.0, -4.0, -4.0, -3.0], [7.0, 2.0, -5.0, 0.0, -2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, -1.0, 5.0], [-5.0, 4.0, 0.0]])+(1.-msk_arg1)*numpy.array([[5.0, 2.0, -7.0], [5.0, 7.0, 
6.0]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[61.0, 4.0, -81.0, 29.0, 5.0], [-92.0, 44.0, -55.0, 16.0, -25.0], [-18.0, 20.0, -65.0, -15.0, 
-34.0], [24.0, -16.0, -37.0, -15.0, -118.0]])+(1.-msk_ref)*numpy.array([[-38.0, -58.0, -36.0, -83.0, -35.0], [67.0, 16.0, 
-58.0, 13.0, 49.0], [-110.0, 48.0, -7.0, -4.0, 60.0], [15.0, -28.0, 19.0, 15.0, -124.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_expandedData_rank3(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[7.0, 2.0, -4.0, -4.0, 0.0], [4.0, 3.0, 0.0, -3.0, -5.0], [-7.0, 5.0, 4.0, 3.0, -2.0], 
[-3.0, -3.0, -4.0, -5.0, 6.0]], [[6.0, 7.0, -7.0, 2.0, 6.0], [-4.0, 6.0, 1.0, 6.0, -5.0], [-3.0, 4.0, 0.0, 4.0, 3.0], [-5.0, 
2.0, 1.0, -5.0, -7.0]], [[-5.0, -7.0, -2.0, -4.0, 3.0], [2.0, 3.0, 0.0, -4.0, 4.0], [-4.0, -6.0, -3.0, -3.0, 7.0], [1.0, -4.0, 
6.0, -5.0, -6.0]]], [[[-7.0, 0.0, 7.0, -1.0, -6.0], [-3.0, -7.0, -6.0, 0.0, -2.0], [1.0, -1.0, -3.0, 1.0, 1.0], [4.0, 3.0, 0.0, 
-6.0, -1.0]], [[7.0, -3.0, 0.0, -5.0, -4.0], [5.0, -3.0, -5.0, -7.0, -5.0], [6.0, 1.0, -5.0, 0.0, 3.0], [3.0, 3.0, 0.0, 2.0, 
-4.0]], [[4.0, 4.0, -5.0, -2.0, 6.0], [6.0, 7.0, 0.0, 3.0, -6.0], [5.0, 1.0, 3.0, -1.0, -2.0], [-2.0, -3.0, 3.0, -4.0, 
0.0]]]])+(1.-msk_arg0)*numpy.array([[[[5.0, -4.0, -7.0, -6.0, 2.0], [-1.0, 1.0, 3.0, -2.0, -5.0], [-3.0, -3.0, -3.0, 3.0, 0.0], 
[-6.0, -1.0, -2.0, 7.0, 3.0]], [[5.0, -7.0, 3.0, -6.0, 4.0], [3.0, 7.0, 0.0, 0.0, -2.0], [3.0, -5.0, 5.0, -4.0, 2.0], [1.0, 
4.0, -2.0, -6.0, 0.0]], [[1.0, 0.0, -5.0, -6.0, 7.0], [4.0, 4.0, -1.0, 5.0, 1.0], [0.0, -3.0, 6.0, -3.0, -3.0], [4.0, -1.0, 
3.0, 0.0, 5.0]]], [[[-6.0, -6.0, 1.0, -1.0, 5.0], [-7.0, 2.0, -1.0, -2.0, -2.0], [-7.0, 1.0, -6.0, -4.0, 5.0], [2.0, -5.0, 
-3.0, 0.0, -7.0]], [[4.0, 1.0, 1.0, 0.0, 6.0], [-6.0, 4.0, 0.0, 3.0, -5.0], [4.0, -1.0, 5.0, -2.0, -1.0], [4.0, -7.0, 2.0, 1.0, 
4.0]], [[7.0, 5.0, 5.0, 5.0, -7.0], [-2.0, 5.0, -6.0, -5.0, -7.0], [-3.0, -4.0, -3.0, 3.0, 4.0], [6.0, 2.0, 2.0, -6.0, 5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[2.0, 4.0], [-6.0, 5.0], [2.0, 1.0]], [[6.0, 0.0], [2.0, -4.0], [0.0, 
-4.0]]])+(1.-msk_arg1)*numpy.array([[[0.0, 6.0], [6.0, -4.0], [2.0, 5.0]], [[-4.0, 7.0], [-3.0, -7.0], [-5.0, -7.0]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-60.0, 9.0], [-58.0, 32.0], [72.0, -33.0], [-44.0, 18.0], [-74.0, 25.0]], [[28.0, -46.0], 
[-72.0, 29.0], [-52.0, 25.0], [-64.0, 30.0], [6.0, 3.0]], [[14.0, -91.0], [-30.0, 26.0], [-26.0, 21.0], [-18.0, 33.0], [4.0, 
10.0]], [[56.0, -40.0], [-2.0, -6.0], [-2.0, -17.0], [-22.0, -42.0], [28.0, -1.0]]])+(1.-msk_ref)*numpy.array([[[9.0, -104.0], 
[-46.0, -80.0], [-24.0, -114.0], [-69.0, -84.0], [35.0, 73.0]], [[82.0, 9.0], [5.0, -51.0], [32.0, 48.0], [34.0, 13.0], [48.0, 
53.0]], [[49.0, -86.0], [-17.0, 29.0], [66.0, -64.0], [-23.0, -16.0], [-31.0, -9.0]], [[-36.0, -76.0], [53.0, -27.0], [-10.0, 
-38.0], [-9.0, 101.0], [1.0, -69.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_transposed_tensor_mult_expandedData_rank4_expandedData_rank4(self):
      msk_arg0=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg0=msk_arg0*numpy.array([[[[7.0, 0.0, 3.0, 2.0, -2.0], [0.0, 7.0, 7.0, -1.0, -4.0], [2.0, 3.0, 0.0, 7.0, 4.0], [-5.0, 
4.0, 0.0, 7.0, 2.0]], [[-3.0, -4.0, -7.0, 0.0, -4.0], [3.0, -1.0, -7.0, 4.0, 1.0], [1.0, 0.0, -5.0, 0.0, 5.0], [0.0, 2.0, 7.0, 
6.0, -3.0]], [[6.0, 5.0, -2.0, 5.0, 0.0], [0.0, -3.0, 3.0, -4.0, 0.0], [-4.0, 2.0, -4.0, -4.0, -6.0], [4.0, 3.0, -2.0, -1.0, 
3.0]]], [[[-3.0, -6.0, 2.0, 5.0, 1.0], [1.0, 0.0, -7.0, 4.0, 5.0], [-5.0, 4.0, 5.0, -3.0, -4.0], [-1.0, 5.0, 2.0, -5.0, -4.0]], 
[[1.0, 6.0, -4.0, 5.0, 2.0], [-2.0, 3.0, 6.0, 0.0, -7.0], [-4.0, -5.0, 6.0, 1.0, -5.0], [-7.0, 1.0, -4.0, -5.0, 0.0]], [[6.0, 
4.0, -6.0, -4.0, -4.0], [-6.0, 6.0, -3.0, 3.0, 6.0], [2.0, 4.0, -2.0, 7.0, -5.0], [-4.0, 7.0, -2.0, -1.0, 
4.0]]]])+(1.-msk_arg0)*numpy.array([[[[-7.0, 7.0, 5.0, 3.0, -3.0], [5.0, 3.0, -2.0, 6.0, 0.0], [5.0, 0.0, -1.0, -4.0, -5.0], 
[2.0, -6.0, -5.0, -3.0, 7.0]], [[-2.0, -4.0, 3.0, 7.0, 0.0], [7.0, 0.0, 4.0, 0.0, 1.0], [1.0, 0.0, -3.0, -4.0, 5.0], [-6.0, 
6.0, 3.0, -5.0, -5.0]], [[4.0, 6.0, -7.0, -3.0, 3.0], [-2.0, -2.0, 2.0, -5.0, 2.0], [4.0, 0.0, 4.0, -7.0, -4.0], [-2.0, -4.0, 
4.0, -4.0, -3.0]]], [[[-3.0, 3.0, -6.0, 1.0, -2.0], [-4.0, 6.0, -3.0, -5.0, 1.0], [2.0, -2.0, 0.0, -7.0, -4.0], [5.0, 6.0, 5.0, 
-2.0, -6.0]], [[-4.0, 0.0, 2.0, -2.0, -5.0], [4.0, 6.0, 6.0, -6.0, -7.0], [-7.0, 5.0, 2.0, -6.0, -4.0], [4.0, 6.0, -4.0, -1.0, 
3.0]], [[1.0, 2.0, 4.0, 7.0, 0.0], [-6.0, 0.0, 6.0, -7.0, -3.0], [-4.0, 5.0, 1.0, -4.0, 5.0], [3.0, 1.0, -4.0, -4.0, -1.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[7.0, 2.0, -4.0, -2.0, 0.0], [-1.0, 0.0, -2.0, 5.0, -6.0], [1.0, 4.0, 6.0, -4.0, 0.0], [7.0, 
6.0, -6.0, 3.0, 6.0]], [[-1.0, 7.0, -2.0, 7.0, 2.0], [-6.0, 6.0, -6.0, 2.0, -3.0], [1.0, -6.0, 4.0, -2.0, 0.0], [-5.0, 0.0, 
0.0, 7.0, -6.0]], [[0.0, -4.0, -1.0, 5.0, 0.0], [-4.0, 2.0, 2.0, -3.0, 0.0], [5.0, -7.0, 0.0, -7.0, -7.0], [7.0, 3.0, -7.0, 
-6.0, -1.0]]], [[[-1.0, -5.0, -5.0, -5.0, 1.0], [4.0, -3.0, 1.0, -4.0, -5.0], [0.0, -7.0, 0.0, 3.0, 2.0], [-2.0, -1.0, 0.0, 
-5.0, -3.0]], [[-1.0, 1.0, 3.0, -4.0, -5.0], [-4.0, 5.0, -3.0, 0.0, 5.0], [7.0, -2.0, -2.0, -1.0, -7.0], [-5.0, -2.0, -2.0, 
0.0, 6.0]], [[-4.0, 5.0, -3.0, -1.0, -2.0], [2.0, -4.0, -4.0, 5.0, 2.0], [5.0, 3.0, -2.0, 4.0, -3.0], [-7.0, -2.0, 5.0, -4.0, 
6.0]]]])+(1.-msk_arg1)*numpy.array([[[[2.0, -6.0, 0.0, 2.0, -7.0], [-4.0, -6.0, -2.0, 5.0, -7.0], [0.0, -7.0, -6.0, -7.0, 1.0], 
[0.0, 2.0, 0.0, -1.0, 5.0]], [[1.0, 7.0, 2.0, 5.0, 3.0], [6.0, 2.0, -2.0, 0.0, -2.0], [4.0, 0.0, 5.0, 4.0, 6.0], [-4.0, 4.0, 
5.0, 5.0, -2.0]], [[-2.0, 2.0, 5.0, -5.0, 4.0], [4.0, 1.0, -7.0, -6.0, -6.0], [2.0, 4.0, -5.0, 7.0, 7.0], [-2.0, -4.0, -2.0, 
-4.0, 2.0]]], [[[0.0, -6.0, 1.0, 5.0, 1.0], [-2.0, 0.0, -1.0, 6.0, 3.0], [4.0, 3.0, 6.0, 0.0, 0.0], [7.0, 2.0, 2.0, -7.0, 
-6.0]], [[-5.0, -1.0, 0.0, -2.0, -2.0], [-3.0, 4.0, -6.0, -3.0, 2.0], [6.0, 6.0, 3.0, -5.0, 7.0], [-3.0, -1.0, 0.0, -6.0, 
-6.0]], [[0.0, 0.0, -4.0, 3.0, 5.0], [3.0, -1.0, 2.0, 7.0, 6.0], [4.0, -5.0, 3.0, 6.0, 0.0], [4.0, 6.0, -4.0, 7.0, 2.0]]]])
      res=transposed_tensor_mult(arg0,arg1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[30.0, 15.0, -28.0, 0.0, -26.0], [-17.0, -16.0, -14.0, 53.0, -1.0], [71.0, 41.0, 16.0, -50.0, 
-73.0], [65.0, 49.0, -56.0, -45.0, 105.0]], [[-12.0, 8.0, 39.0, -1.0, -52.0], [-36.0, 18.0, -6.0, 21.0, 80.0], [83.0, 31.0, 
-36.0, -35.0, -101.0], [9.0, 1.0, -27.0, -44.0, 97.0]], [[54.0, -79.0, 0.0, -53.0, 20.0], [59.0, -48.0, 70.0, -31.0, -39.0], 
[-72.0, 44.0, 10.0, 2.0, 64.0], [100.0, 30.0, -26.0, -14.0, -4.0]], [[20.0, -56.0, -11.0, -20.0, -12.0], [-30.0, 36.0, 12.0, 
-45.0, -20.0], [42.0, -84.0, 10.0, -49.0, -48.0], [42.0, 20.0, -77.0, -33.0, -2.0]], [[3.0, -55.0, 29.0, -33.0, -9.0], [14.0, 
-1.0, 39.0, -42.0, 21.0], [-12.0, -7.0, -24.0, 1.0, 0.0], [22.0, -9.0, -12.0, -23.0, -3.0]]], [[[22.0, -16.0, 1.0, 30.0, 29.0], 
[-18.0, 29.0, 13.0, -28.0, -36.0], [-41.0, -39.0, 28.0, -25.0, 34.0], [35.0, 15.0, -26.0, 40.0, -69.0]], [[23.0, 52.0, -32.0, 
-54.0, -29.0], [11.0, -21.0, -47.0, 72.0, -12.0], [42.0, 67.0, 20.0, 16.0, -18.0], [-24.0, 15.0, 3.0, 8.0, 105.0]], [[69.0, 
-21.0, 45.0, -34.0, -45.0], [-35.0, 27.0, 21.0, 25.0, 38.0], [42.0, 77.0, 8.0, -74.0, -68.0], [110.0, 52.0, -90.0, 1.0, 
120.0]], [[-27.0, 37.0, -29.0, -13.0, 6.0], [15.0, -8.0, -38.0, 14.0, -20.0], [-2.0, -19.0, 4.0, 48.0, 27.0], [-84.0, -28.0, 
49.0, 17.0, -20.0]], [[-51.0, -3.0, -50.0, 12.0, 30.0], [58.0, -68.0, 4.0, -8.0, -27.0], [-22.0, -25.0, -18.0, 60.0, 41.0], 
[-50.0, -27.0, 68.0, -54.0, -51.0]]], [[[14.0, 58.0, 1.0, 22.0, 13.0], [8.0, -15.0, -19.0, 54.0, -6.0], [-35.0, 79.0, 20.0, 
15.0, 40.0], [-3.0, 9.0, 34.0, 54.0, 13.0]], [[6.0, -7.0, -61.0, 0.0, 21.0], [33.0, -49.0, 1.0, 13.0, -55.0], [-2.0, -8.0, 
20.0, 7.0, 17.0], [24.0, 22.0, -2.0, -39.0, -2.0]], [[2.0, -48.0, 13.0, -102.0, -31.0], [38.0, -15.0, 17.0, -28.0, 16.0], [7.0, 
5.0, -28.0, 39.0, 2.0], [-29.0, -25.0, 6.0, -28.0, 43.0]], [[23.0, 81.0, -27.0, -30.0, -22.0], [7.0, -22.0, -56.0, 94.0, -8.0], 
[29.0, 96.0, 26.0, 18.0, -6.0], [-27.0, 17.0, 19.0, 32.0, 103.0]], [[52.0, 57.0, 0.0, 42.0, 41.0], [-16.0, 25.0, -19.0, 39.0, 
-54.0], [-81.0, 51.0, 64.0, -11.0, 84.0], [29.0, 30.0, 3.0, 123.0, -48.0]]], [[[-11.0, -48.0, 12.0, 67.0, 42.0], [5.0, -8.0, 
54.0, -53.0, -8.0], [-54.0, -39.0, -8.0, -20.0, 31.0], [58.0, 5.0, -4.0, -18.0, -97.0]], [[-8.0, 21.0, -66.0, -15.0, -10.0], 
[2.0, -20.0, -40.0, 30.0, -36.0], [63.0, -33.0, 16.0, 1.0, -39.0], [-25.0, 12.0, -12.0, -45.0, 42.0]], [[3.0, 33.0, -28.0, 
47.0, 40.0], [-14.0, 20.0, -24.0, 2.0, -55.0], [-41.0, -40.0, 40.0, 2.0, 52.0], [-19.0, 4.0, 12.0, 59.0, -82.0]], [[57.0, 75.0, 
-26.0, 69.0, 34.0], [-41.0, 28.0, -38.0, 65.0, -62.0], [-32.0, 41.0, 78.0, -47.0, 35.0], [54.0, 56.0, -30.0, 98.0, -14.0]], 
[[5.0, 11.0, 3.0, 6.0, -18.0], [-4.0, -16.0, 0.0, 31.0, 25.0], [34.0, 45.0, -8.0, -19.0, -41.0], [30.0, 17.0, -13.0, -29.0, 
63.0]]]])+(1.-msk_ref)*numpy.array([[[[-4.0, 58.0, 9.0, -48.0, 69.0], [53.0, 25.0, 19.0, -58.0, 18.0], [-32.0, 27.0, -15.0, 
95.0, -19.0], [-5.0, -34.0, -28.0, 33.0, 21.0]], [[-2.0, -76.0, 17.0, -15.0, -24.0], [-28.0, -46.0, -47.0, 31.0, -56.0], [16.0, 
-26.0, -68.0, -11.0, 25.0], [33.0, -8.0, -34.0, -58.0, 41.0]], [[17.0, 11.0, -51.0, 38.0, -44.0], [-12.0, -27.0, 35.0, 53.0, 
11.0], [2.0, -89.0, 2.0, -58.0, -12.0], [-30.0, 60.0, 1.0, 96.0, 37.0]], [[29.0, 21.0, -28.0, 86.0, 28.0], [43.0, -22.0, 26.0, 
94.0, 24.0], [42.0, -77.0, 53.0, 38.0, 10.0], [19.0, 92.0, 15.0, 98.0, 15.0]], [[13.0, 41.0, 13.0, -21.0, 41.0], [43.0, 1.0, 
17.0, -30.0, -13.0], [-32.0, -3.0, -24.0, 67.0, -17.0], [-5.0, -17.0, -10.0, 35.0, 33.0]]], [[[1.0, 35.0, 24.0, 9.0, -64.0], 
[-8.0, 4.0, -42.0, -41.0, -77.0], [8.0, -1.0, -15.0, -77.0, 61.0], [-88.0, -2.0, 55.0, 0.0, -5.0]], [[-20.0, -64.0, -4.0, 34.0, 
-35.0], [-50.0, 4.0, -34.0, 45.0, 21.0], [56.0, 25.0, 46.0, -65.0, 31.0], [28.0, 20.0, 16.0, -73.0, -61.0]], [[-34.0, 56.0, 
-9.0, -3.0, 49.0], [46.0, 40.0, -39.0, -16.0, 33.0], [68.0, 19.0, 40.0, 50.0, 78.0], [-35.0, 28.0, -14.0, 41.0, -20.0]], 
[[52.0, -10.0, -2.0, 3.0, -90.0], [-37.0, -58.0, 50.0, -1.0, -81.0], [-94.0, -78.0, -80.0, -89.0, -71.0], [-35.0, -14.0, 28.0, 
36.0, 72.0]], [[32.0, 12.0, 25.0, 5.0, 11.0], [24.0, -21.0, 19.0, -6.0, -43.0], [-42.0, -16.0, -29.0, 35.0, -29.0], [8.0, 
-13.0, 15.0, 11.0, 32.0]]], [[[38.0, -20.0, 40.0, 7.0, -20.0], [7.0, -48.0, -8.0, 6.0, -93.0], [-38.0, -35.0, -66.0, 8.0, 
-10.0], [7.0, -15.0, 17.0, -16.0, 53.0]], [[-25.0, 7.0, -22.0, -5.0, 13.0], [4.0, 15.0, -18.0, 8.0, 34.0], [42.0, -1.0, 18.0, 
5.0, 35.0], [-9.0, 21.0, -24.0, 19.0, -8.0]], [[-23.0, -9.0, 10.0, -38.0, 15.0], [-1.0, 11.0, -30.0, -28.0, -1.0], [12.0, 30.0, 
-20.0, 19.0, 23.0], [2.0, -26.0, -27.0, -35.0, -1.0]], [[32.0, 30.0, -34.0, -28.0, -27.0], [-16.0, -11.0, 100.0, -30.0, 21.0], 
[-110.0, -37.0, -33.0, -31.0, -119.0], [-17.0, -28.0, -4.0, 69.0, 44.0]], [[23.0, 85.0, -34.0, 38.0, 63.0], [69.0, 15.0, 66.0, 
22.0, 59.0], [-8.0, -42.0, 54.0, 77.0, -31.0], [-8.0, 52.0, 5.0, 133.0, 15.0]]], [[[-18.0, -92.0, -29.0, 10.0, -28.0], [-65.0, 
-13.0, -1.0, 61.0, 51.0], [28.0, 2.0, 19.0, -54.0, -20.0], [63.0, 12.0, -28.0, -62.0, -30.0]], [[-28.0, 28.0, -6.0, 59.0, 
43.0], [17.0, 67.0, -12.0, 19.0, 90.0], [80.0, 75.0, 143.0, 14.0, 44.0], [12.0, 40.0, 46.0, -19.0, -120.0]], [[5.0, 33.0, 47.0, 
6.0, 53.0], [44.0, 28.0, -13.0, -35.0, -12.0], [0.0, 62.0, 31.0, 71.0, 13.0], [11.0, -24.0, 33.0, -35.0, -37.0]], [[2.0, -12.0, 
-16.0, -31.0, -30.0], [-39.0, 4.0, 44.0, -28.0, 23.0], [-58.0, 13.0, -14.0, -46.0, -68.0], [1.0, -37.0, -5.0, -14.0, -3.0]], 
[[0.0, -50.0, -27.0, -35.0, -93.0], [-70.0, -42.0, 3.0, 1.0, -39.0], [-36.0, -56.0, -82.0, -111.0, -23.0], [-29.0, -15.0, 
-27.0, -3.0, 55.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg0.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=transposed_tensor_mult(arg0,arg1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")       
        
        
        
        
        
        
        
        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_float_rank0_offset0(self):
      arg0=-3.0
      arg1=1.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=-3.0
      self.assertTrue(isinstance(res,float),"wrong type of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,complex),"wrong type of result. Got "+str(type(res)))
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_array_rank0_offset0(self):
      arg0=-3.0
      arg1=numpy.array(-2.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(6.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_array_rank1_offset0(self):
      arg0=4.0
      arg1=numpy.array([-1.0, 0.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([-4.0, 0.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_array_rank2_offset0(self):
      arg0=-6.0
      arg1=numpy.array([[-3.0, 3.0, 0.0, -4.0, 4.0], [-7.0, 6.0, -5.0, -1.0, -1.0], [1.0, 0.0, 0.0, -2.0, 5.0], [-7.0, 6.0, 
3.0, -1.0, 1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[18.0, -18.0, -0.0, 24.0, -24.0], [42.0, -36.0, 30.0, 6.0, 6.0], [-6.0, -0.0, -0.0, 12.0, -30.0], [42.0, 
-36.0, -18.0, 6.0, -6.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_array_rank3_offset0(self):
      arg0=0.0
      arg1=numpy.array([[[-4.0, 6.0], [6.0, -4.0]], [[0.0, 7.0], [6.0, -3.0]], [[3.0, -7.0], [-3.0, -2.0]], [[-6.0, -6.0], 
[-7.0, 5.0]], [[-5.0, -4.0], [-6.0, 2.0]], [[0.0, 7.0], [2.0, 0.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-0.0, 0.0], [0.0, -0.0]], [[0.0, 0.0], [0.0, -0.0]], [[0.0, -0.0], [-0.0, -0.0]], [[-0.0, -0.0], 
[-0.0, 0.0]], [[-0.0, -0.0], [-0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_array_rank4_offset0(self):
      arg0=-6.0
      arg1=numpy.array([[[[-1.0, 3.0, 7.0, -6.0], [-4.0, 5.0, -4.0, -7.0], [2.0, -4.0, 3.0, 5.0]], [[-1.0, 6.0, -4.0, 5.0], 
[-3.0, 0.0, -3.0, -1.0], [-1.0, -4.0, -1.0, 7.0]]], [[[6.0, -2.0, 0.0, -7.0], [-2.0, -4.0, -2.0, 7.0], [-4.0, -2.0, 5.0, 
-5.0]], [[2.0, 4.0, 7.0, 0.0], [6.0, 0.0, 3.0, 7.0], [-6.0, -6.0, -7.0, -4.0]]], [[[-3.0, 5.0, 1.0, 4.0], [-1.0, 0.0, -6.0, 
-5.0], [-5.0, 6.0, 6.0, 0.0]], [[6.0, 3.0, -7.0, -3.0], [3.0, -5.0, -6.0, -2.0], [7.0, -5.0, 7.0, 5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[6.0, -18.0, -42.0, 36.0], [24.0, -30.0, 24.0, 42.0], [-12.0, 24.0, -18.0, -30.0]], [[6.0, -36.0, 
24.0, -30.0], [18.0, -0.0, 18.0, 6.0], [6.0, 24.0, 6.0, -42.0]]], [[[-36.0, 12.0, -0.0, 42.0], [12.0, 24.0, 12.0, -42.0], 
[24.0, 12.0, -30.0, 30.0]], [[-12.0, -24.0, -42.0, -0.0], [-36.0, -0.0, -18.0, -42.0], [36.0, 36.0, 42.0, 24.0]]], [[[18.0, 
-30.0, -6.0, -24.0], [6.0, -0.0, 36.0, 30.0], [30.0, -36.0, -36.0, -0.0]], [[-36.0, -18.0, 42.0, 18.0], [-18.0, 30.0, 36.0, 
12.0], [-42.0, 30.0, -42.0, -30.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_constData_rank0_offset0(self):
      arg0=6.0
      arg1=Data(-3.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-18.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_constData_rank1_offset0(self):
      arg0=-7.0
      arg1=Data(numpy.array([-3.0, -3.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([21.0, 21.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_constData_rank2_offset0(self):
      arg0=-2.0
      arg1=Data(numpy.array([[-2.0, -7.0, 2.0, 5.0, 0.0], [0.0, -3.0, -7.0, -2.0, -3.0], [-6.0, -3.0, -1.0, 3.0, 4.0], [0.0, 
7.0, 0.0, 7.0, 4.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[4.0, 14.0, -4.0, -10.0, -0.0], [-0.0, 6.0, 14.0, 4.0, 6.0], [12.0, 6.0, 2.0, -6.0, -8.0], [-0.0, 
-14.0, -0.0, -14.0, -8.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_constData_rank3_offset0(self):
      arg0=2.0
      arg1=Data(numpy.array([[[-7.0, -2.0], [5.0, -6.0]], [[7.0, -4.0], [6.0, 1.0]], [[7.0, -7.0], [1.0, 4.0]], [[-7.0, -2.0], 
[0.0, 1.0]], [[-1.0, 7.0], [-1.0, -7.0]], [[1.0, 0.0], [-6.0, -6.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-14.0, -4.0], [10.0, -12.0]], [[14.0, -8.0], [12.0, 2.0]], [[14.0, -14.0], [2.0, 8.0]], [[-14.0, 
-4.0], [0.0, 2.0]], [[-2.0, 14.0], [-2.0, -14.0]], [[2.0, 0.0], [-12.0, -12.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_constData_rank4_offset0(self):
      arg0=2.0
      arg1=Data(numpy.array([[[[-4.0, -6.0, -6.0, 5.0], [5.0, -6.0, 1.0, 0.0], [2.0, -7.0, -6.0, 3.0]], [[5.0, -5.0, 6.0, 
-1.0], [-1.0, 4.0, -1.0, 3.0], [7.0, 3.0, 2.0, 0.0]]], [[[-4.0, 1.0, 5.0, 3.0], [-5.0, 1.0, -4.0, -4.0], [-5.0, -3.0, 0.0, 
-2.0]], [[4.0, 3.0, -5.0, 2.0], [-2.0, -6.0, 4.0, -1.0], [0.0, -5.0, -6.0, -4.0]]], [[[5.0, -3.0, 4.0, -6.0], [1.0, 0.0, -4.0, 
-1.0], [-4.0, -7.0, 1.0, -1.0]], [[-6.0, -3.0, 0.0, -2.0], [-1.0, 0.0, 1.0, -6.0], [-2.0, 4.0, -6.0, 
-1.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-8.0, -12.0, -12.0, 10.0], [10.0, -12.0, 2.0, 0.0], [4.0, -14.0, -12.0, 6.0]], [[10.0, -10.0, 
12.0, -2.0], [-2.0, 8.0, -2.0, 6.0], [14.0, 6.0, 4.0, 0.0]]], [[[-8.0, 2.0, 10.0, 6.0], [-10.0, 2.0, -8.0, -8.0], [-10.0, -6.0, 
0.0, -4.0]], [[8.0, 6.0, -10.0, 4.0], [-4.0, -12.0, 8.0, -2.0], [0.0, -10.0, -12.0, -8.0]]], [[[10.0, -6.0, 8.0, -12.0], [2.0, 
0.0, -8.0, -2.0], [-8.0, -14.0, 2.0, -2.0]], [[-12.0, -6.0, 0.0, -4.0], [-2.0, 0.0, 2.0, -12.0], [-4.0, 8.0, -12.0, 
-2.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_expandedData_rank0_offset0(self):
      arg0=-2.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(6.0)+(1-msk_arg1)*(2.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-12.0)+(1.-msk_ref)*numpy.array(-4.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_expandedData_rank1_offset0(self):
      arg0=4.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([3.0, -2.0])+(1.-msk_arg1)*numpy.array([-4.0, 1.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([12.0, -8.0])+(1.-msk_ref)*numpy.array([-16.0, 4.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_expandedData_rank2_offset0(self):
      arg0=-7.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[7.0, 6.0, -6.0, 3.0, 5.0], [6.0, -7.0, -4.0, -6.0, 6.0], [-2.0, 5.0, -7.0, -5.0, 3.0], [3.0, 
0.0, 1.0, 5.0, 5.0]])+(1.-msk_arg1)*numpy.array([[-6.0, -6.0, 3.0, 2.0, -1.0], [-4.0, -6.0, -1.0, 0.0, 6.0], [-7.0, 6.0, -6.0, 
7.0, 0.0], [4.0, -6.0, 5.0, 1.0, 4.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-49.0, -42.0, 42.0, -21.0, -35.0], [-42.0, 49.0, 28.0, 42.0, -42.0], [14.0, -35.0, 49.0, 35.0, 
-21.0], [-21.0, -0.0, -7.0, -35.0, -35.0]])+(1.-msk_ref)*numpy.array([[42.0, 42.0, -21.0, -14.0, 7.0], [28.0, 42.0, 7.0, -0.0, 
-42.0], [49.0, -42.0, 42.0, -49.0, -0.0], [-28.0, 42.0, -35.0, -7.0, -28.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_expandedData_rank3_offset0(self):
      arg0=1.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[0.0, -4.0], [1.0, 2.0]], [[1.0, -6.0], [-6.0, -7.0]], [[-5.0, 5.0], [0.0, -6.0]], [[-5.0, 
-2.0], [-7.0, 7.0]], [[0.0, 6.0], [2.0, -6.0]], [[6.0, -5.0], [-3.0, 0.0]]])+(1.-msk_arg1)*numpy.array([[[-4.0, -1.0], [-1.0, 
-7.0]], [[-6.0, 1.0], [6.0, 0.0]], [[-3.0, -7.0], [-4.0, -7.0]], [[-5.0, -4.0], [6.0, -2.0]], [[-3.0, -3.0], [-7.0, 0.0]], 
[[4.0, 5.0], [0.0, 4.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.0, -4.0], [1.0, 2.0]], [[1.0, -6.0], [-6.0, -7.0]], [[-5.0, 5.0], [0.0, -6.0]], [[-5.0, 
-2.0], [-7.0, 7.0]], [[0.0, 6.0], [2.0, -6.0]], [[6.0, -5.0], [-3.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[-4.0, -1.0], [-1.0, 
-7.0]], [[-6.0, 1.0], [6.0, 0.0]], [[-3.0, -7.0], [-4.0, -7.0]], [[-5.0, -4.0], [6.0, -2.0]], [[-3.0, -3.0], [-7.0, 0.0]], 
[[4.0, 5.0], [0.0, 4.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_float_rank0_expandedData_rank4_offset0(self):
      arg0=-5.0
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[4.0, -6.0, 7.0, 4.0], [4.0, 2.0, 3.0, -2.0], [4.0, 7.0, 4.0, 0.0]], [[1.0, -4.0, 6.0, 
-6.0], [-7.0, -2.0, 3.0, -4.0], [6.0, -4.0, -6.0, 2.0]]], [[[-6.0, -7.0, 5.0, -3.0], [0.0, -1.0, -2.0, 3.0], [5.0, 5.0, 7.0, 
-6.0]], [[-1.0, 0.0, -2.0, -4.0], [-3.0, -1.0, 3.0, -3.0], [-1.0, 1.0, 1.0, 2.0]]], [[[2.0, -7.0, 0.0, 0.0], [1.0, 4.0, 3.0, 
-4.0], [-3.0, 7.0, 6.0, -4.0]], [[0.0, 6.0, -5.0, 0.0], [4.0, 3.0, 4.0, -1.0], [-7.0, -2.0, 3.0, 
-5.0]]]])+(1.-msk_arg1)*numpy.array([[[[-3.0, -4.0, 3.0, -6.0], [-7.0, -2.0, -2.0, 3.0], [7.0, 1.0, 2.0, -7.0]], [[0.0, -2.0, 
-4.0, 6.0], [-5.0, 6.0, 1.0, 3.0], [3.0, 7.0, -2.0, -1.0]]], [[[4.0, -7.0, 6.0, 2.0], [-4.0, -7.0, 5.0, 1.0], [2.0, 5.0, 3.0, 
0.0]], [[-5.0, 4.0, -1.0, 0.0], [3.0, -3.0, 0.0, 1.0], [1.0, 2.0, 1.0, -3.0]]], [[[-1.0, -5.0, 5.0, 0.0], [5.0, 7.0, -3.0, 
5.0], [0.0, -4.0, -4.0, -7.0]], [[-4.0, 1.0, 3.0, -2.0], [-7.0, 3.0, 6.0, 0.0], [3.0, -5.0, -6.0, -4.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-20.0, 30.0, -35.0, -20.0], [-20.0, -10.0, -15.0, 10.0], [-20.0, -35.0, -20.0, -0.0]], 
[[-5.0, 20.0, -30.0, 30.0], [35.0, 10.0, -15.0, 20.0], [-30.0, 20.0, 30.0, -10.0]]], [[[30.0, 35.0, -25.0, 15.0], [-0.0, 5.0, 
10.0, -15.0], [-25.0, -25.0, -35.0, 30.0]], [[5.0, -0.0, 10.0, 20.0], [15.0, 5.0, -15.0, 15.0], [5.0, -5.0, -5.0, -10.0]]], 
[[[-10.0, 35.0, -0.0, -0.0], [-5.0, -20.0, -15.0, 20.0], [15.0, -35.0, -30.0, 20.0]], [[-0.0, -30.0, 25.0, -0.0], [-20.0, 
-15.0, -20.0, 5.0], [35.0, 10.0, -15.0, 25.0]]]])+(1.-msk_ref)*numpy.array([[[[15.0, 20.0, -15.0, 30.0], [35.0, 10.0, 10.0, 
-15.0], [-35.0, -5.0, -10.0, 35.0]], [[-0.0, 10.0, 20.0, -30.0], [25.0, -30.0, -5.0, -15.0], [-15.0, -35.0, 10.0, 5.0]]], 
[[[-20.0, 35.0, -30.0, -10.0], [20.0, 35.0, -25.0, -5.0], [-10.0, -25.0, -15.0, -0.0]], [[25.0, -20.0, 5.0, -0.0], [-15.0, 
15.0, -0.0, -5.0], [-5.0, -10.0, -5.0, 15.0]]], [[[5.0, 25.0, -25.0, -0.0], [-25.0, -35.0, 15.0, -25.0], [-0.0, 20.0, 20.0, 
35.0]], [[20.0, -5.0, -15.0, 10.0], [35.0, -15.0, -30.0, -0.0], [-15.0, 25.0, 30.0, 20.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_float_rank0_offset0(self):
      arg0=numpy.array(-1.0)
      arg1=5.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(-5.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_array_rank0_offset0(self):
      arg0=numpy.array(-1.0)
      arg1=numpy.array(1.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array(-1.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank1_offset1(self):
      arg0=numpy.array([-7.0, 1.0, 3.0])
      arg1=numpy.array([-1.0, -3.0, 0.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array(4.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank2_offset2(self):
      arg0=numpy.array([[5.0, 0.0, 0.0], [3.0, 0.0, -5.0]])
      arg1=numpy.array([[-4.0, 0.0, 6.0], [4.0, 2.0, 3.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array(-23.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank3_offset3(self):
      arg0=numpy.array([[[4.0, -6.0, 1.0], [-1.0, -5.0, 7.0], [-4.0, 0.0, 4.0], [-2.0, 4.0, 7.0]], [[5.0, 4.0, 5.0], [-6.0, 
-7.0, -5.0], [-7.0, 3.0, -3.0], [2.0, 0.0, 0.0]]])
      arg1=numpy.array([[[-4.0, 1.0, -6.0], [-5.0, -3.0, -4.0], [3.0, -5.0, 0.0], [4.0, -5.0, 4.0]], [[5.0, 7.0, 6.0], [0.0, 
2.0, -7.0], [0.0, 3.0, 7.0], [-1.0, 3.0, 5.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array(42.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank4_offset4(self):
      arg0=numpy.array([[[[-7.0, -2.0], [1.0, -7.0], [3.0, -2.0]], [[4.0, -3.0], [1.0, -6.0], [-5.0, 2.0]]], [[[-1.0, 1.0], 
[5.0, 5.0], [0.0, 4.0]], [[7.0, 4.0], [-6.0, 2.0], [2.0, 4.0]]], [[[7.0, 4.0], [0.0, 2.0], [-3.0, 5.0]], [[-1.0, 1.0], [-3.0, 
1.0], [4.0, -4.0]]], [[[3.0, 0.0], [-3.0, 5.0], [-7.0, -1.0]], [[-1.0, 3.0], [0.0, -6.0], [1.0, -4.0]]]])
      arg1=numpy.array([[[[-7.0, 4.0], [6.0, 3.0], [0.0, 6.0]], [[6.0, 3.0], [-5.0, 1.0], [-7.0, 6.0]]], [[[7.0, 5.0], [-6.0, 
5.0], [4.0, 5.0]], [[6.0, 6.0], [5.0, 4.0], [5.0, -1.0]]], [[[4.0, -6.0], [5.0, 6.0], [6.0, -6.0]], [[-2.0, 7.0], [-4.0, 7.0], 
[-2.0, 0.0]]], [[[0.0, 1.0], [-2.0, 4.0], [0.0, -2.0]], [[2.0, -2.0], [-2.0, -6.0], [7.0, 5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=4)
      ref=numpy.array(159.0)
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_array_rank1_offset0(self):
      arg0=numpy.array(-3.0)
      arg1=numpy.array([-4.0, 6.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([12.0, -18.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank2_offset1(self):
      arg0=numpy.array([-7.0, 6.0, 2.0])
      arg1=numpy.array([[6.0, 1.0], [-1.0, -7.0], [3.0, -4.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([-42.0, -57.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank3_offset2(self):
      arg0=numpy.array([[6.0, 0.0, -6.0], [2.0, -2.0, -6.0]])
      arg1=numpy.array([[[-1.0, 4.0], [6.0, -1.0], [1.0, -3.0]], [[-5.0, 7.0], [0.0, -7.0], [-2.0, 4.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([-10.0, 46.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank4_offset3(self):
      arg0=numpy.array([[[1.0, -2.0, 0.0], [7.0, 7.0, -6.0], [-7.0, -1.0, 0.0], [-3.0, 0.0, -4.0]], [[-1.0, -5.0, 1.0], [6.0, 
7.0, 5.0], [6.0, -1.0, -7.0], [5.0, 7.0, 3.0]]])
      arg1=numpy.array([[[[1.0, -4.0], [2.0, -2.0], [-1.0, 4.0]], [[-5.0, -7.0], [-6.0, 4.0], [0.0, 1.0]], [[-4.0, -1.0], [0.0, 
7.0], [5.0, 1.0]], [[-5.0, -5.0], [-6.0, 7.0], [-3.0, 6.0]]], [[[7.0, -1.0], [-2.0, 1.0], [3.0, -6.0]], [[6.0, -5.0], [2.0, 
2.0], [1.0, 2.0]], [[-2.0, 7.0], [-7.0, -5.0], [7.0, -4.0]], [[7.0, -4.0], [-4.0, 2.0], [-2.0, -3.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([-17.0, 8.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_array_rank2_offset0(self):
      arg0=numpy.array(1.0)
      arg1=numpy.array([[7.0, 4.0, -6.0, -7.0, 6.0], [-1.0, 4.0, -3.0, -7.0, 1.0], [-5.0, -4.0, -4.0, 7.0, -4.0], [0.0, 5.0, 
7.0, 0.0, -1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[7.0, 4.0, -6.0, -7.0, 6.0], [-1.0, 4.0, -3.0, -7.0, 1.0], [-5.0, -4.0, -4.0, 7.0, -4.0], [0.0, 5.0, 
7.0, 0.0, -1.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank3_offset1(self):
      arg0=numpy.array([2.0, 0.0, 4.0])
      arg1=numpy.array([[[-7.0, 5.0, -6.0, -5.0, -2.0], [1.0, 1.0, 4.0, 0.0, 0.0], [-6.0, 1.0, 1.0, -7.0, 5.0], [0.0, 4.0, 7.0, 
0.0, -5.0]], [[-3.0, -2.0, 5.0, 0.0, -5.0], [0.0, 1.0, 7.0, 7.0, 6.0], [-5.0, -5.0, -4.0, -6.0, -3.0], [4.0, 0.0, 7.0, -1.0, 
-4.0]], [[3.0, 0.0, -5.0, -6.0, -7.0], [5.0, 6.0, -4.0, 5.0, -7.0], [-6.0, -2.0, 4.0, 0.0, -4.0], [0.0, -7.0, 2.0, -2.0, 
-5.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[-2.0, 10.0, -32.0, -34.0, -32.0], [22.0, 26.0, -8.0, 20.0, -28.0], [-36.0, -6.0, 18.0, -14.0, -6.0], 
[0.0, -20.0, 22.0, -8.0, -30.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank4_offset2(self):
      arg0=numpy.array([[-3.0, 5.0, -7.0], [-1.0, -6.0, -1.0]])
      arg1=numpy.array([[[[-4.0, 4.0, 3.0, -7.0, 0.0], [-1.0, -7.0, 0.0, 4.0, -1.0], [0.0, -6.0, 3.0, 3.0, 1.0], [-3.0, -5.0, 
-1.0, 3.0, -3.0]], [[-5.0, 6.0, 0.0, 5.0, 6.0], [0.0, 0.0, 3.0, 4.0, -3.0], [-7.0, 7.0, -7.0, -7.0, -3.0], [-3.0, 0.0, -1.0, 
-6.0, -4.0]], [[-7.0, 3.0, 1.0, -2.0, 5.0], [-2.0, -2.0, -2.0, -4.0, -7.0], [3.0, 4.0, 5.0, 4.0, -6.0], [5.0, 0.0, 6.0, 2.0, 
-1.0]]], [[[-3.0, 4.0, -2.0, 0.0, -1.0], [2.0, 0.0, -5.0, 7.0, -3.0], [2.0, -1.0, -1.0, 5.0, -6.0], [-7.0, 1.0, 2.0, -7.0, 
-6.0]], [[4.0, -2.0, 6.0, 7.0, -2.0], [0.0, 2.0, -2.0, -4.0, -2.0], [-3.0, 0.0, 0.0, -2.0, -3.0], [-7.0, -1.0, -1.0, 5.0, 
0.0]], [[3.0, 7.0, -6.0, 4.0, 5.0], [-1.0, -7.0, -7.0, -4.0, 2.0], [5.0, 1.0, -3.0, -5.0, -3.0], [5.0, -1.0, 0.0, 1.0, -1.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[12.0, -2.0, -44.0, 14.0, 3.0], [16.0, 30.0, 53.0, 57.0, 50.0], [-45.0, 25.0, -75.0, -60.0, 51.0], [3.0, 
21.0, -40.0, -77.0, 3.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_array_rank3_offset0(self):
      arg0=numpy.array(0.0)
      arg1=numpy.array([[[-1.0, -1.0], [-1.0, 4.0]], [[-3.0, -5.0], [4.0, 5.0]], [[-1.0, -4.0], [0.0, -2.0]], [[-5.0, 3.0], 
[2.0, -4.0]], [[-2.0, 0.0], [3.0, 0.0]], [[0.0, -4.0], [-5.0, 3.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-0.0, -0.0], [-0.0, 0.0]], [[-0.0, -0.0], [0.0, 0.0]], [[-0.0, -0.0], [0.0, -0.0]], [[-0.0, 0.0], 
[0.0, -0.0]], [[-0.0, 0.0], [0.0, 0.0]], [[0.0, -0.0], [-0.0, 0.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank4_offset1(self):
      arg0=numpy.array([2.0, -4.0, 5.0])
      arg1=numpy.array([[[[-7.0, 7.0], [2.0, 4.0]], [[4.0, -1.0], [3.0, 6.0]], [[-3.0, -3.0], [3.0, 6.0]], [[2.0, -4.0], [-1.0, 
0.0]], [[-2.0, 7.0], [4.0, 6.0]], [[-4.0, 2.0], [4.0, -5.0]]], [[[5.0, 3.0], [0.0, 5.0]], [[-4.0, -5.0], [-2.0, -2.0]], [[-6.0, 
-7.0], [1.0, -5.0]], [[0.0, -3.0], [-6.0, -1.0]], [[-1.0, 5.0], [5.0, -5.0]], [[3.0, 4.0], [-3.0, -2.0]]], [[[-6.0, 6.0], [6.0, 
-3.0]], [[-2.0, -2.0], [-3.0, 0.0]], [[4.0, 7.0], [-2.0, 5.0]], [[-2.0, 3.0], [0.0, 1.0]], [[-1.0, 0.0], [6.0, 6.0]], [[2.0, 
-3.0], [-5.0, -5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-64.0, 32.0], [34.0, -27.0]], [[14.0, 8.0], [-1.0, 20.0]], [[38.0, 57.0], [-8.0, 57.0]], [[-6.0, 
19.0], [22.0, 9.0]], [[-5.0, -6.0], [18.0, 62.0]], [[-10.0, -27.0], [-5.0, -27.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_array_rank4_offset0(self):
      arg0=numpy.array(6.0)
      arg1=numpy.array([[[[-6.0, 6.0, 0.0, -7.0], [-3.0, 1.0, 0.0, 3.0], [3.0, -2.0, -2.0, -3.0]], [[0.0, 2.0, -7.0, -1.0], 
[-1.0, -7.0, -3.0, 5.0], [2.0, 6.0, -1.0, 7.0]]], [[[-6.0, -5.0, 5.0, 1.0], [6.0, 7.0, 6.0, 4.0], [6.0, 0.0, 5.0, 0.0]], 
[[-5.0, -3.0, -2.0, -5.0], [0.0, 4.0, -7.0, 0.0], [-7.0, -7.0, 2.0, -2.0]]], [[[-5.0, -3.0, 6.0, -3.0], [0.0, 2.0, -5.0, 3.0], 
[0.0, -6.0, 3.0, 4.0]], [[1.0, 1.0, -4.0, 0.0], [6.0, -1.0, -6.0, -6.0], [-6.0, 1.0, 1.0, -5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[-36.0, 36.0, 0.0, -42.0], [-18.0, 6.0, 0.0, 18.0], [18.0, -12.0, -12.0, -18.0]], [[0.0, 12.0, -42.0, 
-6.0], [-6.0, -42.0, -18.0, 30.0], [12.0, 36.0, -6.0, 42.0]]], [[[-36.0, -30.0, 30.0, 6.0], [36.0, 42.0, 36.0, 24.0], [36.0, 
0.0, 30.0, 0.0]], [[-30.0, -18.0, -12.0, -30.0], [0.0, 24.0, -42.0, 0.0], [-42.0, -42.0, 12.0, -12.0]]], [[[-30.0, -18.0, 36.0, 
-18.0], [0.0, 12.0, -30.0, 18.0], [0.0, -36.0, 18.0, 24.0]], [[6.0, 6.0, -24.0, 0.0], [36.0, -6.0, -36.0, -36.0], [-36.0, 6.0, 
6.0, -30.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=-ref
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_constData_rank0_offset0(self):
      arg0=numpy.array(4.0)
      arg1=Data(7.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(28.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank1_offset1(self):
      arg0=numpy.array([-5.0, -6.0, -5.0])
      arg1=Data(numpy.array([1.0, -1.0, 7.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(-34.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank2_offset2(self):
      arg0=numpy.array([[6.0, 0.0, 1.0], [-6.0, 6.0, -5.0]])
      arg1=Data(numpy.array([[7.0, 0.0, 4.0], [6.0, -1.0, 4.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(-16.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank3_offset3(self):
      arg0=numpy.array([[[0.0, -7.0, 7.0], [-1.0, -3.0, -6.0], [0.0, -5.0, 2.0], [-5.0, 0.0, 5.0]], [[-2.0, -7.0, -4.0], [4.0, 
-1.0, 5.0], [2.0, 0.0, 5.0], [7.0, 7.0, 0.0]]])
      arg1=Data(numpy.array([[[4.0, -2.0, 5.0], [-2.0, 7.0, 7.0], [7.0, -7.0, 4.0], [2.0, 0.0, 6.0]], [[-1.0, 1.0, 4.0], [7.0, 
3.0, -1.0], [3.0, -1.0, -1.0], [-3.0, -7.0, -6.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(-19.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank4_offset4(self):
      arg0=numpy.array([[[[1.0, -7.0], [-1.0, 3.0], [6.0, -1.0]], [[-6.0, 4.0], [0.0, 3.0], [-2.0, 2.0]]], [[[-3.0, -2.0], 
[-4.0, 6.0], [-3.0, 6.0]], [[0.0, 2.0], [-7.0, 0.0], [-7.0, 2.0]]], [[[2.0, 4.0], [7.0, 4.0], [1.0, 0.0]], [[6.0, 6.0], [-3.0, 
-7.0], [-4.0, 7.0]]], [[[6.0, 2.0], [-3.0, 0.0], [-3.0, -5.0]], [[-3.0, 0.0], [0.0, 7.0], [-4.0, -1.0]]]])
      arg1=Data(numpy.array([[[[5.0, 3.0], [3.0, 1.0], [-2.0, 5.0]], [[-7.0, 0.0], [-5.0, -1.0], [7.0, 0.0]]], [[[3.0, -1.0], 
[6.0, -1.0], [7.0, -2.0]], [[2.0, 5.0], [4.0, -6.0], [0.0, -5.0]]], [[[7.0, -1.0], [-3.0, 3.0], [-1.0, 7.0]], [[-2.0, -6.0], 
[-7.0, 2.0], [2.0, 5.0]]], [[[-7.0, 0.0], [5.0, 1.0], [-6.0, 6.0]], [[-6.0, 0.0], [-7.0, 0.0], [-5.0, 
-1.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(-150.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_constData_rank1_offset0(self):
      arg0=numpy.array(5.0)
      arg1=Data(numpy.array([-5.0, -6.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-25.0, -30.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank2_offset1(self):
      arg0=numpy.array([-6.0, 7.0, 6.0])
      arg1=Data(numpy.array([[6.0, -6.0], [-6.0, 6.0], [-4.0, -6.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-102.0, 42.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank3_offset2(self):
      arg0=numpy.array([[7.0, -6.0, 6.0], [5.0, 0.0, -6.0]])
      arg1=Data(numpy.array([[[-7.0, -1.0], [4.0, 4.0], [3.0, -2.0]], [[-7.0, 3.0], [-6.0, -1.0], [-6.0, 
4.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-54.0, -52.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank4_offset3(self):
      arg0=numpy.array([[[-3.0, 1.0, 3.0], [2.0, 5.0, -4.0], [7.0, -3.0, 2.0], [-3.0, -6.0, -4.0]], [[-5.0, 0.0, 4.0], [-6.0, 
3.0, 1.0], [1.0, 0.0, -2.0], [-5.0, -4.0, 4.0]]])
      arg1=Data(numpy.array([[[[-4.0, 3.0], [3.0, -6.0], [-4.0, 4.0]], [[-1.0, -4.0], [3.0, -2.0], [6.0, -3.0]], [[0.0, -1.0], 
[7.0, 0.0], [-4.0, 0.0]], [[-2.0, -5.0], [3.0, -3.0], [-6.0, 2.0]]], [[[4.0, 0.0], [0.0, -4.0], [-3.0, 5.0]], [[-3.0, 0.0], 
[6.0, -5.0], [-5.0, -2.0]], [[2.0, 2.0], [3.0, 0.0], [0.0, 3.0]], [[1.0, -7.0], [3.0, -3.0], [4.0, -1.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([-25.0, 51.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_constData_rank2_offset0(self):
      arg0=numpy.array(-3.0)
      arg1=Data(numpy.array([[-6.0, 0.0, 2.0, -5.0, -6.0], [2.0, 2.0, 7.0, 4.0, 0.0], [-7.0, 4.0, 1.0, 6.0, -1.0], [7.0, 1.0, 
-5.0, -7.0, 2.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[18.0, -0.0, -6.0, 15.0, 18.0], [-6.0, -6.0, -21.0, -12.0, -0.0], [21.0, -12.0, -3.0, -18.0, 3.0], 
[-21.0, -3.0, 15.0, 21.0, -6.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank3_offset1(self):
      arg0=numpy.array([2.0, 7.0, 1.0])
      arg1=Data(numpy.array([[[-5.0, 3.0, -4.0, 1.0, 1.0], [7.0, -6.0, 2.0, 4.0, 2.0], [5.0, -1.0, 1.0, 2.0, 0.0], [6.0, 7.0, 
3.0, -4.0, 5.0]], [[1.0, 0.0, -2.0, -6.0, -3.0], [0.0, 0.0, 1.0, -5.0, -7.0], [1.0, -2.0, -6.0, 6.0, 6.0], [-3.0, -4.0, 3.0, 
-6.0, -7.0]], [[-3.0, -1.0, -4.0, 7.0, 2.0], [0.0, 5.0, 2.0, -5.0, 6.0], [-4.0, 7.0, 0.0, 0.0, -6.0], [-6.0, 0.0, -2.0, 6.0, 
3.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-6.0, 5.0, -26.0, -33.0, -17.0], [14.0, -7.0, 13.0, -32.0, -39.0], [13.0, -9.0, -40.0, 46.0, 
36.0], [-15.0, -14.0, 25.0, -44.0, -36.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank4_offset2(self):
      arg0=numpy.array([[-6.0, -3.0, -4.0], [-7.0, -1.0, 2.0]])
      arg1=Data(numpy.array([[[[-5.0, 4.0, -1.0, 1.0, -6.0], [1.0, 0.0, -4.0, -2.0, 3.0], [-5.0, -3.0, 7.0, 4.0, 0.0], [-2.0, 
4.0, -2.0, 1.0, 6.0]], [[-1.0, -4.0, 7.0, 5.0, -4.0], [-4.0, 7.0, 2.0, 5.0, -3.0], [5.0, -5.0, -6.0, 1.0, 3.0], [0.0, -5.0, 
0.0, 2.0, 1.0]], [[-6.0, 1.0, 0.0, 6.0, 0.0], [-6.0, 0.0, 2.0, 0.0, 6.0], [2.0, -3.0, 4.0, -4.0, 2.0], [0.0, 3.0, -7.0, 5.0, 
0.0]]], [[[-7.0, -7.0, -2.0, 3.0, 5.0], [-1.0, 0.0, -1.0, 7.0, -6.0], [-1.0, 3.0, 5.0, 3.0, -1.0], [2.0, 7.0, -4.0, 6.0, 7.0]], 
[[-1.0, 7.0, 5.0, -7.0, 7.0], [0.0, -1.0, 2.0, -4.0, 6.0], [-4.0, -4.0, 4.0, -7.0, -5.0], [5.0, -2.0, -5.0, -3.0, 0.0]], 
[[-2.0, 4.0, 7.0, -6.0, 3.0], [7.0, 2.0, -2.0, 4.0, -1.0], [-3.0, 5.0, 1.0, 4.0, -6.0], [3.0, -3.0, 7.0, 3.0, 
4.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[103.0, 34.0, 8.0, -71.0, 12.0], [51.0, -16.0, 11.0, -40.0, 1.0], [12.0, 38.0, -77.0, -17.0, 
-17.0], [-1.0, -74.0, 87.0, -65.0, -80.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_constData_rank3_offset0(self):
      arg0=numpy.array(1.0)
      arg1=Data(numpy.array([[[-2.0, 0.0], [-4.0, -7.0]], [[-6.0, -2.0], [3.0, 4.0]], [[0.0, 4.0], [-6.0, 0.0]], [[0.0, -6.0], 
[5.0, -1.0]], [[-4.0, 1.0], [-7.0, 5.0]], [[2.0, -5.0], [4.0, -4.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-2.0, 0.0], [-4.0, -7.0]], [[-6.0, -2.0], [3.0, 4.0]], [[0.0, 4.0], [-6.0, 0.0]], [[0.0, -6.0], 
[5.0, -1.0]], [[-4.0, 1.0], [-7.0, 5.0]], [[2.0, -5.0], [4.0, -4.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank4_offset1(self):
      arg0=numpy.array([-5.0, -6.0, 2.0])
      arg1=Data(numpy.array([[[[0.0, 4.0], [0.0, 7.0]], [[7.0, -6.0], [-1.0, -4.0]], [[-3.0, -6.0], [-1.0, 5.0]], [[7.0, 4.0], 
[-6.0, 0.0]], [[3.0, -3.0], [-4.0, -3.0]], [[0.0, -6.0], [1.0, 6.0]]], [[[-1.0, 0.0], [0.0, -4.0]], [[7.0, -4.0], [1.0, 2.0]], 
[[-1.0, 0.0], [-6.0, -5.0]], [[1.0, -1.0], [2.0, -4.0]], [[-3.0, -3.0], [3.0, -3.0]], [[-1.0, -5.0], [-1.0, -2.0]]], [[[-6.0, 
1.0], [-7.0, 6.0]], [[-7.0, -5.0], [7.0, 4.0]], [[-4.0, -5.0], [-6.0, 0.0]], [[4.0, 2.0], [-6.0, -6.0]], [[3.0, 7.0], [-4.0, 
1.0]], [[-2.0, 0.0], [6.0, 7.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-6.0, -18.0], [-14.0, 1.0]], [[-91.0, 44.0], [13.0, 16.0]], [[13.0, 20.0], [29.0, 5.0]], [[-33.0, 
-10.0], [6.0, 12.0]], [[9.0, 47.0], [-6.0, 35.0]], [[2.0, 60.0], [13.0, -4.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_constData_rank4_offset0(self):
      arg0=numpy.array(-3.0)
      arg1=Data(numpy.array([[[[1.0, 0.0, -6.0, 0.0], [4.0, -2.0, -5.0, -5.0], [3.0, 7.0, 5.0, -4.0]], [[4.0, 0.0, 4.0, 4.0], 
[6.0, 0.0, -1.0, 7.0], [7.0, -2.0, -5.0, -1.0]]], [[[-4.0, 0.0, 2.0, 6.0], [0.0, 0.0, 3.0, 0.0], [-2.0, 5.0, -3.0, 4.0]], 
[[-5.0, -1.0, -7.0, 0.0], [1.0, 4.0, 4.0, 3.0], [0.0, -5.0, -5.0, -7.0]]], [[[-1.0, 5.0, -5.0, 0.0], [5.0, -3.0, -4.0, -3.0], 
[-4.0, 1.0, 0.0, -5.0]], [[3.0, -6.0, 1.0, 4.0], [-6.0, -4.0, 3.0, -7.0], [0.0, -3.0, -4.0, -1.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-3.0, -0.0, 18.0, -0.0], [-12.0, 6.0, 15.0, 15.0], [-9.0, -21.0, -15.0, 12.0]], [[-12.0, -0.0, 
-12.0, -12.0], [-18.0, -0.0, 3.0, -21.0], [-21.0, 6.0, 15.0, 3.0]]], [[[12.0, -0.0, -6.0, -18.0], [-0.0, -0.0, -9.0, -0.0], 
[6.0, -15.0, 9.0, -12.0]], [[15.0, 3.0, 21.0, -0.0], [-3.0, -12.0, -12.0, -9.0], [-0.0, 15.0, 15.0, 21.0]]], [[[3.0, -15.0, 
15.0, -0.0], [-15.0, 9.0, 12.0, 9.0], [12.0, -3.0, -0.0, 15.0]], [[-9.0, 18.0, -3.0, -12.0], [18.0, 12.0, -9.0, 21.0], [-0.0, 
9.0, 12.0, 3.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_expandedData_rank0_offset0(self):
      arg0=numpy.array(-4.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(0.0)+(1-msk_arg1)*(-5.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-0.0)+(1.-msk_ref)*numpy.array(20.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank1_offset1(self):
      arg0=numpy.array([7.0, 4.0, -1.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, 1.0, 0.0])+(1.-msk_arg1)*numpy.array([-5.0, -7.0, -2.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(32.0)+(1.-msk_ref)*numpy.array(-61.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank2_offset2(self):
      arg0=numpy.array([[-5.0, 4.0, -2.0], [6.0, 4.0, 7.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[2.0, 1.0, 0.0], [5.0, -6.0, 1.0]])+(1.-msk_arg1)*numpy.array([[1.0, -4.0, -7.0], [-5.0, 3.0, 
6.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(7.0)+(1.-msk_ref)*numpy.array(17.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank3_offset3(self):
      arg0=numpy.array([[[5.0, -7.0, 1.0], [0.0, 1.0, 1.0], [-5.0, -2.0, -5.0], [-2.0, 1.0, 6.0]], [[-1.0, -5.0, 7.0], [-3.0, 
6.0, -4.0], [2.0, -7.0, 7.0], [-7.0, 1.0, -6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, 3.0, -5.0], [-3.0, 4.0, 1.0], [-5.0, 2.0, 6.0], [-7.0, -4.0, 3.0]], [[0.0, 2.0, -3.0], 
[6.0, -7.0, -1.0], [0.0, 2.0, 3.0], [4.0, 0.0, 6.0]]])+(1.-msk_arg1)*numpy.array([[[3.0, 6.0, -5.0], [-5.0, -6.0, -4.0], [3.0, 
3.0, -6.0], [0.0, -4.0, -4.0]], [[3.0, 2.0, 2.0], [3.0, 6.0, 5.0], [0.0, -1.0, 7.0], [5.0, 6.0, 4.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(-176.0)+(1.-msk_ref)*numpy.array(-50.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank4_offset4(self):
      arg0=numpy.array([[[[-1.0, 6.0], [0.0, 0.0], [-4.0, -5.0]], [[-7.0, 0.0], [-6.0, -2.0], [3.0, 4.0]]], [[[2.0, 0.0], [5.0, 
-3.0], [-1.0, 7.0]], [[4.0, 1.0], [6.0, 0.0], [7.0, 7.0]]], [[[4.0, 2.0], [1.0, 2.0], [-7.0, -3.0]], [[-1.0, 0.0], [7.0, 0.0], 
[-5.0, 3.0]]], [[[0.0, -3.0], [2.0, 6.0], [0.0, 1.0]], [[5.0, -4.0], [5.0, -6.0], [-1.0, -5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-6.0, 5.0], [3.0, 2.0], [7.0, 7.0]], [[-2.0, 7.0], [-1.0, -7.0], [0.0, -6.0]]], [[[-7.0, 
1.0], [5.0, 1.0], [-4.0, 5.0]], [[-6.0, 7.0], [1.0, -1.0], [1.0, -3.0]]], [[[6.0, -4.0], [-6.0, 6.0], [0.0, -4.0]], [[-6.0, 
-5.0], [7.0, 0.0], [-1.0, 0.0]]], [[[6.0, 6.0], [-2.0, -3.0], [-6.0, -2.0]], [[-2.0, 2.0], [-5.0, -4.0], [6.0, 
-7.0]]]])+(1.-msk_arg1)*numpy.array([[[[3.0, 1.0], [2.0, -2.0], [-4.0, 7.0]], [[0.0, -2.0], [-5.0, -2.0], [-1.0, -5.0]]], 
[[[5.0, 2.0], [-1.0, -3.0], [-1.0, 0.0]], [[1.0, -3.0], [0.0, -7.0], [-5.0, -2.0]]], [[[-6.0, -4.0], [-6.0, 5.0], [4.0, -1.0]], 
[[-1.0, 6.0], [-7.0, 1.0], [0.0, 3.0]]], [[[1.0, -2.0], [-3.0, 0.0], [3.0, 2.0]], [[1.0, 1.0], [-2.0, -5.0], [-2.0, -1.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=4)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array(67.0)+(1.-msk_ref)*numpy.array(-100.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_expandedData_rank1_offset0(self):
      arg0=numpy.array(3.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, 0.0])+(1.-msk_arg1)*numpy.array([2.0, 6.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([12.0, 0.0])+(1.-msk_ref)*numpy.array([6.0, 18.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank2_offset1(self):
      arg0=numpy.array([0.0, 1.0, -7.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, 2.0], [-2.0, 0.0], [6.0, 2.0]])+(1.-msk_arg1)*numpy.array([[0.0, -5.0], [0.0, -7.0], 
[-5.0, 0.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-44.0, -14.0])+(1.-msk_ref)*numpy.array([35.0, -7.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank3_offset2(self):
      arg0=numpy.array([[-7.0, -6.0, -4.0], [-6.0, 0.0, 5.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[7.0, 2.0], [0.0, -4.0], [0.0, -2.0]], [[0.0, -5.0], [5.0, -7.0], [7.0, 
2.0]]])+(1.-msk_arg1)*numpy.array([[[1.0, 5.0], [-3.0, 0.0], [-1.0, -3.0]], [[-4.0, 0.0], [3.0, -1.0], [-7.0, -6.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-14.0, 58.0])+(1.-msk_ref)*numpy.array([4.0, -53.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank4_offset3(self):
      arg0=numpy.array([[[-2.0, 5.0, 1.0], [0.0, 4.0, 1.0], [0.0, 2.0, -1.0], [-4.0, 3.0, -4.0]], [[-7.0, -3.0, -5.0], [-6.0, 
-5.0, -5.0], [5.0, -3.0, 5.0], [5.0, -7.0, 0.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[1.0, 4.0], [0.0, -5.0], [-5.0, -7.0]], [[6.0, 5.0], [-5.0, 1.0], [4.0, -2.0]], [[0.0, 
-5.0], [2.0, 0.0], [-1.0, -6.0]], [[7.0, -1.0], [1.0, -7.0], [7.0, 4.0]]], [[[0.0, -1.0], [-4.0, -6.0], [-3.0, -5.0]], [[6.0, 
3.0], [1.0, 2.0], [3.0, -5.0]], [[2.0, 2.0], [-5.0, 0.0], [1.0, -1.0]], [[0.0, 2.0], [-5.0, -1.0], [5.0, 
-4.0]]]])+(1.-msk_arg1)*numpy.array([[[[6.0, 4.0], [4.0, 1.0], [0.0, 1.0]], [[-2.0, 7.0], [-7.0, 3.0], [-4.0, 7.0]], [[-4.0, 
2.0], [-6.0, -4.0], [5.0, -1.0]], [[-3.0, 1.0], [2.0, -4.0], [-1.0, 5.0]]], [[[4.0, -2.0], [5.0, 0.0], [6.0, 3.0]], [[-5.0, 
-2.0], [0.0, 4.0], [6.0, -1.0]], [[-1.0, 0.0], [3.0, 7.0], [1.0, -2.0]], [[-2.0, 0.0], [0.0, -7.0], [6.0, 0.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-35.0, 4.0])+(1.-msk_ref)*numpy.array([-111.0, -12.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_expandedData_rank2_offset0(self):
      arg0=numpy.array(1.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[4.0, 0.0, 6.0, -5.0, 5.0], [-6.0, 2.0, -1.0, -1.0, 1.0], [1.0, 2.0, 2.0, -7.0, 1.0], [3.0, 
7.0, 0.0, -7.0, 7.0]])+(1.-msk_arg1)*numpy.array([[-7.0, -1.0, 2.0, -6.0, 0.0], [-7.0, -3.0, -6.0, -6.0, 0.0], [-4.0, 6.0, 2.0, 
7.0, 6.0], [0.0, 4.0, 1.0, 4.0, -2.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[4.0, 0.0, 6.0, -5.0, 5.0], [-6.0, 2.0, -1.0, -1.0, 1.0], [1.0, 2.0, 2.0, -7.0, 1.0], [3.0, 7.0, 
0.0, -7.0, 7.0]])+(1.-msk_ref)*numpy.array([[-7.0, -1.0, 2.0, -6.0, 0.0], [-7.0, -3.0, -6.0, -6.0, 0.0], [-4.0, 6.0, 2.0, 7.0, 
6.0], [0.0, 4.0, 1.0, 4.0, -2.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank3_offset1(self):
      arg0=numpy.array([-4.0, -6.0, 1.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-7.0, -4.0, 0.0, -5.0, 3.0], [-2.0, -6.0, -1.0, -5.0, 0.0], [-1.0, 6.0, 5.0, 0.0, -3.0], 
[7.0, 5.0, 1.0, -3.0, -7.0]], [[6.0, -6.0, -3.0, -7.0, 5.0], [-5.0, 3.0, 1.0, -1.0, 1.0], [1.0, -3.0, -6.0, 3.0, 0.0], [6.0, 
-1.0, -5.0, -3.0, -6.0]], [[-2.0, -3.0, 6.0, -2.0, 0.0], [-1.0, 1.0, -6.0, -5.0, 4.0], [6.0, -7.0, -4.0, 2.0, -1.0], [-3.0, 
-2.0, -5.0, -4.0, -7.0]]])+(1.-msk_arg1)*numpy.array([[[0.0, 1.0, 0.0, 0.0, 1.0], [-2.0, 4.0, 6.0, 5.0, 0.0], [-2.0, 5.0, 0.0, 
2.0, 0.0], [3.0, -7.0, -1.0, 5.0, -2.0]], [[-1.0, -7.0, -4.0, -3.0, -2.0], [4.0, 4.0, -6.0, 4.0, 0.0], [0.0, 2.0, -2.0, -2.0, 
7.0], [7.0, -5.0, -1.0, 3.0, -7.0]], [[-5.0, -2.0, 0.0, -3.0, -7.0], [6.0, 3.0, 4.0, -5.0, -3.0], [-2.0, -7.0, -6.0, 3.0, 0.0], 
[2.0, -5.0, 7.0, 1.0, 2.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-10.0, 49.0, 24.0, 60.0, -42.0], [37.0, 7.0, -8.0, 21.0, -2.0], [4.0, -13.0, 12.0, -16.0, 
11.0], [-67.0, -16.0, 21.0, 26.0, 57.0]])+(1.-msk_ref)*numpy.array([[1.0, 36.0, 24.0, 15.0, 1.0], [-10.0, -37.0, 16.0, -49.0, 
-3.0], [6.0, -39.0, 6.0, 7.0, -42.0], [-52.0, 53.0, 17.0, -37.0, 52.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank4_offset2(self):
      arg0=numpy.array([[-1.0, -7.0, -5.0], [1.0, 0.0, 1.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[6.0, 5.0, -5.0, -3.0, 5.0], [6.0, -7.0, 4.0, -6.0, 3.0], [-2.0, -6.0, 4.0, 2.0, -4.0], 
[-6.0, -5.0, 2.0, 7.0, -7.0]], [[-1.0, -3.0, -1.0, -6.0, -2.0], [-1.0, 1.0, 6.0, -2.0, -4.0], [5.0, 0.0, 7.0, -6.0, -7.0], 
[7.0, 0.0, -2.0, 1.0, 5.0]], [[-6.0, -5.0, 0.0, 0.0, -6.0], [-7.0, 5.0, 4.0, -1.0, 6.0], [-4.0, 0.0, 0.0, 0.0, -6.0], [-5.0, 
-5.0, 4.0, -2.0, 4.0]]], [[[4.0, -6.0, -4.0, 4.0, 6.0], [-1.0, 2.0, 0.0, 5.0, 0.0], [7.0, 7.0, -6.0, 5.0, -5.0], [0.0, -2.0, 
2.0, -5.0, -3.0]], [[-7.0, 0.0, 3.0, 5.0, 3.0], [1.0, -5.0, -2.0, -3.0, 5.0], [4.0, -1.0, -6.0, 4.0, 1.0], [-3.0, 0.0, -4.0, 
7.0, 3.0]], [[-1.0, 7.0, -3.0, -5.0, -3.0], [5.0, -3.0, -2.0, 7.0, 0.0], [3.0, -3.0, -5.0, 1.0, -7.0], [3.0, 1.0, 4.0, -4.0, 
-7.0]]]])+(1.-msk_arg1)*numpy.array([[[[6.0, -7.0, 0.0, 5.0, -5.0], [2.0, 1.0, 5.0, 7.0, 4.0], [2.0, -7.0, -4.0, -1.0, -2.0], 
[5.0, 2.0, -3.0, -3.0, -6.0]], [[-2.0, 0.0, 0.0, -5.0, -2.0], [7.0, 5.0, 0.0, 0.0, 3.0], [0.0, 7.0, 5.0, 5.0, -1.0], [4.0, 4.0, 
-7.0, 0.0, 1.0]], [[1.0, -4.0, 3.0, 3.0, 5.0], [-7.0, -4.0, 1.0, 2.0, -3.0], [-4.0, -5.0, 6.0, -2.0, -7.0], [-7.0, 3.0, -6.0, 
5.0, -5.0]]], [[[-6.0, -4.0, 6.0, -3.0, 4.0], [6.0, 5.0, 0.0, 3.0, 1.0], [-1.0, -2.0, -4.0, 6.0, 1.0], [-4.0, -4.0, 5.0, 1.0, 
0.0]], [[-3.0, 2.0, 0.0, 7.0, -4.0], [3.0, 3.0, -1.0, 1.0, -5.0], [4.0, 0.0, -3.0, 2.0, -6.0], [3.0, 5.0, 2.0, 0.0, 5.0]], 
[[3.0, -7.0, -1.0, 2.0, 6.0], [-2.0, -1.0, -5.0, 3.0, -2.0], [0.0, -1.0, 0.0, -7.0, 1.0], [7.0, 2.0, 0.0, 4.0, 3.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[34.0, 42.0, 5.0, 44.0, 42.0], [40.0, -26.0, -68.0, 37.0, -5.0], [-3.0, 10.0, -64.0, 46.0, 
71.0], [-15.0, 29.0, -2.0, -13.0, -58.0]])+(1.-msk_ref)*numpy.array([[0.0, 16.0, -10.0, 14.0, 4.0], [-12.0, -12.0, -15.0, 
-11.0, -11.0], [17.0, -20.0, -65.0, -25.0, 46.0], [5.0, -47.0, 87.0, -17.0, 27.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_expandedData_rank3_offset0(self):
      arg0=numpy.array(3.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[1.0, 5.0], [-5.0, 4.0]], [[0.0, 4.0], [3.0, 4.0]], [[-2.0, 0.0], [3.0, -1.0]], [[-1.0, 5.0], 
[-5.0, 0.0]], [[-7.0, 5.0], [-7.0, -2.0]], [[-1.0, 3.0], [-3.0, 0.0]]])+(1.-msk_arg1)*numpy.array([[[2.0, -3.0], [5.0, -2.0]], 
[[-2.0, -2.0], [0.0, -1.0]], [[-7.0, -4.0], [-4.0, -2.0]], [[-3.0, -7.0], [6.0, -6.0]], [[1.0, -7.0], [-1.0, -5.0]], [[7.0, 
-6.0], [6.0, 1.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 15.0], [-15.0, 12.0]], [[0.0, 12.0], [9.0, 12.0]], [[-6.0, 0.0], [9.0, -3.0]], [[-3.0, 
15.0], [-15.0, 0.0]], [[-21.0, 15.0], [-21.0, -6.0]], [[-3.0, 9.0], [-9.0, 0.0]]])+(1.-msk_ref)*numpy.array([[[6.0, -9.0], 
[15.0, -6.0]], [[-6.0, -6.0], [0.0, -3.0]], [[-21.0, -12.0], [-12.0, -6.0]], [[-9.0, -21.0], [18.0, -18.0]], [[3.0, -21.0], 
[-3.0, -15.0]], [[21.0, -18.0], [18.0, 3.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank4_offset1(self):
      arg0=numpy.array([3.0, 7.0, -6.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[0.0, -5.0], [2.0, -4.0]], [[3.0, 1.0], [7.0, -6.0]], [[-5.0, -3.0], [-6.0, 6.0]], [[-3.0, 
-5.0], [-6.0, -2.0]], [[4.0, 7.0], [7.0, 0.0]], [[0.0, 0.0], [7.0, 7.0]]], [[[7.0, 3.0], [-3.0, 6.0]], [[-1.0, 7.0], [-1.0, 
-6.0]], [[6.0, 6.0], [-2.0, -2.0]], [[-3.0, -7.0], [5.0, 7.0]], [[6.0, 0.0], [4.0, 4.0]], [[3.0, 6.0], [1.0, 0.0]]], [[[-5.0, 
-6.0], [-2.0, 0.0]], [[1.0, -3.0], [2.0, -6.0]], [[-6.0, -6.0], [3.0, 1.0]], [[-6.0, 4.0], [-7.0, 2.0]], [[5.0, -2.0], [0.0, 
-7.0]], [[-2.0, 1.0], [-1.0, 5.0]]]])+(1.-msk_arg1)*numpy.array([[[[1.0, -2.0], [6.0, 6.0]], [[-6.0, -4.0], [-2.0, -7.0]], 
[[2.0, 3.0], [-2.0, 1.0]], [[4.0, 0.0], [-7.0, 0.0]], [[0.0, -7.0], [0.0, 5.0]], [[-1.0, 2.0], [-5.0, 6.0]]], [[[-2.0, 7.0], 
[-2.0, 7.0]], [[-1.0, -5.0], [-5.0, 0.0]], [[-6.0, 6.0], [4.0, 3.0]], [[5.0, 7.0], [5.0, -3.0]], [[5.0, 5.0], [7.0, -6.0]], 
[[1.0, 5.0], [-6.0, -6.0]]], [[[2.0, -4.0], [5.0, 0.0]], [[-1.0, 0.0], [-4.0, 0.0]], [[-5.0, 6.0], [5.0, 0.0]], [[1.0, -1.0], 
[-2.0, 0.0]], [[-6.0, -5.0], [-5.0, 7.0]], [[1.0, 4.0], [3.0, 0.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[79.0, 42.0], [-3.0, 30.0]], [[-4.0, 70.0], [2.0, -24.0]], [[63.0, 69.0], [-50.0, -2.0]], 
[[6.0, -88.0], [59.0, 31.0]], [[24.0, 33.0], [49.0, 70.0]], [[33.0, 36.0], [34.0, -9.0]]])+(1.-msk_ref)*numpy.array([[[-23.0, 
67.0], [-26.0, 67.0]], [[-19.0, -47.0], [-17.0, -21.0]], [[-6.0, 15.0], [-8.0, 24.0]], [[41.0, 55.0], [26.0, -21.0]], [[71.0, 
44.0], [79.0, -69.0]], [[-2.0, 17.0], [-75.0, -24.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank0_expandedData_rank4_offset0(self):
      arg0=numpy.array(7.0)
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[1.0, 1.0, -7.0, 4.0], [-6.0, 4.0, 2.0, 4.0], [-6.0, 4.0, -4.0, -3.0]], [[-4.0, -5.0, 0.0, 
0.0], [-6.0, -5.0, 7.0, 2.0], [-6.0, 6.0, -4.0, 1.0]]], [[[6.0, 2.0, 4.0, 6.0], [-4.0, 3.0, -3.0, 5.0], [7.0, 0.0, 3.0, 6.0]], 
[[2.0, 7.0, -7.0, -2.0], [-6.0, -2.0, 0.0, 3.0], [-4.0, 6.0, 0.0, -6.0]]], [[[6.0, -1.0, -2.0, 5.0], [1.0, -5.0, -6.0, 1.0], 
[6.0, -4.0, 0.0, -5.0]], [[-1.0, 4.0, -3.0, 3.0], [4.0, -6.0, -3.0, -3.0], [4.0, -2.0, 1.0, 
4.0]]]])+(1.-msk_arg1)*numpy.array([[[[1.0, 7.0, -1.0, -5.0], [4.0, -6.0, 5.0, 7.0], [5.0, -1.0, -5.0, 6.0]], [[7.0, 4.0, 5.0, 
2.0], [7.0, -3.0, 0.0, 5.0], [4.0, 3.0, 1.0, 5.0]]], [[[4.0, -7.0, -6.0, 2.0], [1.0, 0.0, 5.0, 4.0], [2.0, -4.0, 0.0, 1.0]], 
[[-4.0, -5.0, 0.0, 7.0], [5.0, -1.0, -5.0, 0.0], [7.0, 7.0, 0.0, -7.0]]], [[[-3.0, 5.0, 0.0, -7.0], [7.0, 7.0, -2.0, 7.0], 
[-3.0, -3.0, -1.0, 5.0]], [[-5.0, -4.0, -1.0, 1.0], [5.0, -2.0, 4.0, -4.0], [0.0, 7.0, 5.0, 2.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[7.0, 7.0, -49.0, 28.0], [-42.0, 28.0, 14.0, 28.0], [-42.0, 28.0, -28.0, -21.0]], [[-28.0, 
-35.0, 0.0, 0.0], [-42.0, -35.0, 49.0, 14.0], [-42.0, 42.0, -28.0, 7.0]]], [[[42.0, 14.0, 28.0, 42.0], [-28.0, 21.0, -21.0, 
35.0], [49.0, 0.0, 21.0, 42.0]], [[14.0, 49.0, -49.0, -14.0], [-42.0, -14.0, 0.0, 21.0], [-28.0, 42.0, 0.0, -42.0]]], [[[42.0, 
-7.0, -14.0, 35.0], [7.0, -35.0, -42.0, 7.0], [42.0, -28.0, 0.0, -35.0]], [[-7.0, 28.0, -21.0, 21.0], [28.0, -42.0, -21.0, 
-21.0], [28.0, -14.0, 7.0, 28.0]]]])+(1.-msk_ref)*numpy.array([[[[7.0, 49.0, -7.0, -35.0], [28.0, -42.0, 35.0, 49.0], [35.0, 
-7.0, -35.0, 42.0]], [[49.0, 28.0, 35.0, 14.0], [49.0, -21.0, 0.0, 35.0], [28.0, 21.0, 7.0, 35.0]]], [[[28.0, -49.0, -42.0, 
14.0], [7.0, 0.0, 35.0, 28.0], [14.0, -28.0, 0.0, 7.0]], [[-28.0, -35.0, 0.0, 49.0], [35.0, -7.0, -35.0, 0.0], [49.0, 49.0, 
0.0, -49.0]]], [[[-21.0, 35.0, 0.0, -49.0], [49.0, 49.0, -14.0, 49.0], [-21.0, -21.0, -7.0, 35.0]], [[-35.0, -28.0, -7.0, 7.0], 
[35.0, -14.0, 28.0, -28.0], [0.0, 49.0, 35.0, 14.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_float_rank0_offset0(self):
      arg0=numpy.array([-5.0, -3.0])
      arg1=-5.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([25.0, 15.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank0_offset0(self):
      arg0=numpy.array([6.0, -7.0])
      arg1=numpy.array(-3.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([-18.0, 21.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank1_offset1(self):
      arg0=numpy.array([[-4.0, -6.0], [-4.0, -6.0], [-7.0, -7.0]])
      arg1=numpy.array([4.0, -1.0, 4.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([-40.0, -46.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank2_offset2(self):
      arg0=numpy.array([[[3.0, 4.0], [0.0, 7.0], [-4.0, -6.0]], [[3.0, 0.0], [5.0, 0.0], [6.0, 5.0]]])
      arg1=numpy.array([[-4.0, 1.0, 3.0], [-3.0, 4.0, 7.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([29.0, 8.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank3_offset3(self):
      arg0=numpy.array([[[[0.0, -1.0], [-7.0, -5.0], [-5.0, 2.0]], [[0.0, -1.0], [4.0, 4.0], [1.0, 4.0]], [[0.0, 2.0], [-4.0, 
-2.0], [5.0, -1.0]], [[5.0, 2.0], [-7.0, -4.0], [-6.0, 6.0]]], [[[7.0, 3.0], [0.0, -3.0], [4.0, 4.0]], [[1.0, 0.0], [6.0, 
-4.0], [0.0, -6.0]], [[4.0, -6.0], [1.0, -6.0], [5.0, 0.0]], [[-3.0, 0.0], [-4.0, 4.0], [5.0, -1.0]]]])
      arg1=numpy.array([[[2.0, 4.0, 0.0], [-5.0, -2.0, 0.0], [7.0, -7.0, -3.0], [4.0, 4.0, 0.0]], [[0.0, 1.0, 6.0], [7.0, 4.0, 
-6.0], [2.0, 7.0, 4.0], [2.0, 7.0, 6.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([55.0, 7.0])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank1_offset0(self):
      arg0=numpy.array([-3.0, -6.0])
      arg1=numpy.array([5.0, 1.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[-15.0, -3.0], [-30.0, -6.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank2_offset1(self):
      arg0=numpy.array([[-4.0, -5.0], [-7.0, 5.0], [-3.0, -1.0]])
      arg1=numpy.array([[3.0, -4.0], [-6.0, -3.0], [0.0, 0.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[30.0, 37.0], [-45.0, 5.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank3_offset2(self):
      arg0=numpy.array([[[3.0, -5.0], [0.0, -4.0], [-6.0, -7.0]], [[-7.0, -6.0], [2.0, 1.0], [3.0, -2.0]]])
      arg1=numpy.array([[[-2.0, 4.0], [-6.0, -5.0], [6.0, 5.0]], [[3.0, -6.0], [-6.0, -3.0], [-6.0, -2.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[-93.0, 12.0], [-20.0, 2.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank4_offset3(self):
      arg0=numpy.array([[[[-1.0, 6.0], [-6.0, 0.0], [-1.0, -7.0]], [[1.0, 0.0], [5.0, -1.0], [-4.0, -7.0]], [[-6.0, -7.0], 
[-4.0, -7.0], [-7.0, 0.0]], [[-6.0, 0.0], [-1.0, 1.0], [6.0, 6.0]]], [[[3.0, 0.0], [4.0, -1.0], [-7.0, 0.0]], [[6.0, 1.0], 
[0.0, -6.0], [3.0, -3.0]], [[-7.0, 2.0], [4.0, 5.0], [6.0, 4.0]], [[-3.0, 2.0], [4.0, 6.0], [2.0, -2.0]]]])
      arg1=numpy.array([[[[1.0, 0.0], [0.0, 7.0], [1.0, 1.0]], [[5.0, -1.0], [-6.0, 0.0], [0.0, 6.0]], [[0.0, -3.0], [-1.0, 
5.0], [7.0, -3.0]], [[-2.0, 1.0], [0.0, -2.0], [0.0, 0.0]]], [[[-1.0, -4.0], [-2.0, 1.0], [-5.0, -7.0]], [[2.0, 4.0], [4.0, 
-5.0], [4.0, 1.0]], [[4.0, 4.0], [2.0, 1.0], [2.0, 2.0]], [[-3.0, 6.0], [-5.0, 6.0], [-3.0, 1.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=numpy.array([[-37.0, 11.0], [-24.0, 32.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank2_offset0(self):
      arg0=numpy.array([3.0, -5.0])
      arg1=numpy.array([[3.0, 6.0, -3.0, -4.0, 2.0], [-6.0, -1.0, 3.0, 0.0, 2.0], [4.0, 0.0, 4.0, 6.0, -3.0], [0.0, 3.0, -4.0, 
-2.0, -6.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[9.0, 18.0, -9.0, -12.0, 6.0], [-18.0, -3.0, 9.0, 0.0, 6.0], [12.0, 0.0, 12.0, 18.0, -9.0], [0.0, 9.0, 
-12.0, -6.0, -18.0]], [[-15.0, -30.0, 15.0, 20.0, -10.0], [30.0, 5.0, -15.0, 0.0, -10.0], [-20.0, 0.0, -20.0, -30.0, 15.0], 
[0.0, -15.0, 20.0, 10.0, 30.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank3_offset1(self):
      arg0=numpy.array([[3.0, -7.0], [-2.0, -1.0], [-4.0, -1.0]])
      arg1=numpy.array([[[-7.0, -4.0, 5.0, 7.0, 3.0], [0.0, -4.0, 6.0, 5.0, 6.0], [1.0, 5.0, 5.0, 2.0, 3.0], [-6.0, 4.0, 4.0, 
2.0, -1.0]], [[-7.0, 1.0, 2.0, -4.0, -2.0], [7.0, -4.0, 0.0, 0.0, 2.0], [5.0, -7.0, -6.0, 7.0, 0.0], [-1.0, -2.0, 4.0, -7.0, 
-3.0]], [[-1.0, -4.0, 5.0, -6.0, 1.0], [3.0, 5.0, 3.0, 2.0, 3.0], [-2.0, -5.0, -5.0, 0.0, -1.0], [0.0, 0.0, 1.0, 1.0, -7.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-3.0, 2.0, -9.0, 53.0, 9.0], [-26.0, -24.0, 6.0, 7.0, 2.0], [1.0, 49.0, 47.0, -8.0, 13.0], [-16.0, 
16.0, 0.0, 16.0, 31.0]], [[57.0, 31.0, -42.0, -39.0, -20.0], [-10.0, 27.0, -45.0, -37.0, -47.0], [-10.0, -23.0, -24.0, -21.0, 
-20.0], [43.0, -26.0, -33.0, -8.0, 17.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank4_offset2(self):
      arg0=numpy.array([[[0.0, 7.0], [0.0, 3.0], [-5.0, 3.0]], [[3.0, -2.0], [0.0, 5.0], [0.0, -1.0]]])
      arg1=numpy.array([[[[0.0, 2.0, -2.0, 7.0, 5.0], [6.0, 2.0, 3.0, 0.0, 0.0], [4.0, 5.0, -1.0, 0.0, -4.0], [2.0, -6.0, 7.0, 
3.0, 0.0]], [[-6.0, 0.0, -7.0, -4.0, 6.0], [6.0, 3.0, 1.0, 2.0, 7.0], [-6.0, 6.0, 3.0, -6.0, 1.0], [-7.0, -6.0, 7.0, -3.0, 
-1.0]], [[2.0, -7.0, 6.0, -2.0, -3.0], [5.0, -6.0, -5.0, -2.0, 5.0], [0.0, 3.0, 6.0, 5.0, 1.0], [-7.0, -3.0, 5.0, 7.0, 3.0]]], 
[[[3.0, -7.0, -5.0, 0.0, 6.0], [0.0, -6.0, -1.0, 6.0, 2.0], [-4.0, -3.0, 2.0, 0.0, -5.0], [1.0, 5.0, 1.0, 4.0, -5.0]], [[3.0, 
5.0, 0.0, 0.0, 3.0], [0.0, 7.0, -1.0, 0.0, 4.0], [-4.0, 6.0, 1.0, -2.0, 7.0], [1.0, 1.0, -1.0, 0.0, 5.0]], [[-7.0, 2.0, -4.0, 
4.0, 1.0], [5.0, -3.0, 6.0, 1.0, -3.0], [0.0, 4.0, 5.0, 3.0, 4.0], [7.0, 0.0, -3.0, 4.0, -3.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[-1.0, 14.0, -45.0, 10.0, 33.0], [-25.0, 12.0, 22.0, 28.0, -19.0], [-12.0, -24.0, -24.0, -25.0, -20.0], 
[38.0, 30.0, -22.0, -23.0, -30.0]], [[4.0, 30.0, -3.0, 27.0, 46.0], [70.0, 55.0, 0.0, -13.0, 55.0], [-2.0, 94.0, 16.0, -16.0, 
19.0], [-32.0, -74.0, 81.0, 21.0, 44.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_array_rank3_offset0(self):
      arg0=numpy.array([-3.0, 5.0])
      arg1=numpy.array([[[-6.0, 0.0], [-5.0, 5.0]], [[6.0, 4.0], [0.0, 1.0]], [[-1.0, -7.0], [-1.0, 7.0]], [[-4.0, -6.0], [6.0, 
0.0]], [[-1.0, 0.0], [2.0, -4.0]], [[-6.0, -3.0], [7.0, 1.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[18.0, 0.0], [15.0, -15.0]], [[-18.0, -12.0], [0.0, -3.0]], [[3.0, 21.0], [3.0, -21.0]], [[12.0, 
18.0], [-18.0, 0.0]], [[3.0, 0.0], [-6.0, 12.0]], [[18.0, 9.0], [-21.0, -3.0]]], [[[-30.0, 0.0], [-25.0, 25.0]], [[30.0, 20.0], 
[0.0, 5.0]], [[-5.0, -35.0], [-5.0, 35.0]], [[-20.0, -30.0], [30.0, 0.0]], [[-5.0, 0.0], [10.0, -20.0]], [[-30.0, -15.0], 
[35.0, 5.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank4_offset1(self):
      arg0=numpy.array([[1.0, -1.0], [-5.0, 0.0], [1.0, -7.0]])
      arg1=numpy.array([[[[2.0, -2.0], [1.0, -6.0]], [[0.0, -7.0], [-3.0, -3.0]], [[-2.0, 7.0], [2.0, 4.0]], [[-6.0, 3.0], 
[4.0, 4.0]], [[0.0, 4.0], [3.0, -7.0]], [[-6.0, 2.0], [3.0, -3.0]]], [[[0.0, -2.0], [-3.0, 5.0]], [[-6.0, 1.0], [2.0, -3.0]], 
[[-6.0, -5.0], [0.0, -2.0]], [[0.0, -4.0], [3.0, -4.0]], [[7.0, -1.0], [-7.0, 0.0]], [[-4.0, -5.0], [-2.0, 0.0]]], [[[-2.0, 
-2.0], [-6.0, -2.0]], [[7.0, 7.0], [-6.0, -4.0]], [[-5.0, 0.0], [-2.0, 4.0]], [[-2.0, 7.0], [-2.0, 7.0]], [[-5.0, -2.0], [1.0, 
-7.0]], [[-3.0, -5.0], [-5.0, 6.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[0.0, 6.0], [10.0, -33.0]], [[37.0, -5.0], [-19.0, 8.0]], [[23.0, 32.0], [0.0, 18.0]], [[-8.0, 30.0], 
[-13.0, 31.0]], [[-40.0, 7.0], [39.0, -14.0]], [[11.0, 22.0], [8.0, 3.0]]], [[[12.0, 16.0], [41.0, 20.0]], [[-49.0, -42.0], 
[45.0, 31.0]], [[37.0, -7.0], [12.0, -32.0]], [[20.0, -52.0], [10.0, -53.0]], [[35.0, 10.0], [-10.0, 56.0]], [[27.0, 33.0], 
[32.0, -39.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank0_offset0(self):
      arg0=numpy.array([-1.0, 3.0])
      arg1=Data(0.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-0.0, 0.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank1_offset1(self):
      arg0=numpy.array([[1.0, 3.0], [1.0, -2.0], [5.0, 0.0]])
      arg1=Data(numpy.array([2.0, -1.0, 4.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([21.0, 8.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank2_offset2(self):
      arg0=numpy.array([[[-2.0, 0.0], [-5.0, -1.0], [-3.0, -4.0]], [[5.0, -5.0], [7.0, 7.0], [4.0, -6.0]]])
      arg1=Data(numpy.array([[-7.0, -3.0, -5.0], [-4.0, -5.0, -5.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-31.0, 38.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank3_offset3(self):
      arg0=numpy.array([[[[-7.0, 2.0], [5.0, -2.0], [6.0, -6.0]], [[-7.0, -2.0], [-6.0, 7.0], [5.0, 7.0]], [[1.0, 4.0], [4.0, 
-3.0], [-7.0, -2.0]], [[-3.0, 1.0], [-7.0, 3.0], [4.0, -5.0]]], [[[4.0, -1.0], [2.0, -5.0], [1.0, -7.0]], [[-6.0, 0.0], [-3.0, 
4.0], [7.0, -4.0]], [[7.0, -3.0], [-7.0, -1.0], [7.0, 1.0]], [[0.0, -3.0], [5.0, -5.0], [-1.0, 3.0]]]])
      arg1=Data(numpy.array([[[2.0, 7.0, -6.0], [-2.0, -3.0, 6.0], [0.0, -2.0, -4.0], [-2.0, 7.0, 6.0]], [[-5.0, -2.0, -7.0], 
[-3.0, 0.0, 5.0], [-1.0, 1.0, -1.0], [-2.0, -3.0, 0.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([34.0, 120.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank1_offset0(self):
      arg0=numpy.array([-4.0, -4.0])
      arg1=Data(numpy.array([-6.0, 2.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[24.0, -8.0], [24.0, -8.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank2_offset1(self):
      arg0=numpy.array([[-6.0, 1.0], [0.0, -2.0], [-7.0, -5.0]])
      arg1=Data(numpy.array([[-7.0, -2.0], [-6.0, 1.0], [-7.0, 0.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[91.0, 12.0], [40.0, -4.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank3_offset2(self):
      arg0=numpy.array([[[0.0, 2.0], [2.0, 5.0], [3.0, 1.0]], [[-2.0, -3.0], [-3.0, 0.0], [-2.0, -1.0]]])
      arg1=Data(numpy.array([[[1.0, 6.0], [-7.0, -3.0], [-7.0, 2.0]], [[-1.0, 7.0], [1.0, -2.0], [7.0, 
-6.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[-50.0, 4.0], [-44.0, -16.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank4_offset3(self):
      arg0=numpy.array([[[[0.0, -1.0], [-6.0, 1.0], [0.0, 2.0]], [[-5.0, 0.0], [-2.0, 5.0], [2.0, -2.0]], [[-4.0, -1.0], [-3.0, 
1.0], [6.0, 1.0]], [[-1.0, 3.0], [2.0, 0.0], [0.0, 5.0]]], [[[0.0, 6.0], [-3.0, -1.0], [-7.0, -7.0]], [[-3.0, 0.0], [-1.0, 
-6.0], [2.0, -6.0]], [[-5.0, 3.0], [-4.0, -3.0], [-2.0, -2.0]], [[3.0, 0.0], [4.0, -1.0], [-3.0, 0.0]]]])
      arg1=Data(numpy.array([[[[3.0, 7.0], [-2.0, 2.0], [2.0, -1.0]], [[0.0, 1.0], [4.0, 5.0], [-6.0, -5.0]], [[1.0, -2.0], 
[3.0, -6.0], [-2.0, 6.0]], [[7.0, -1.0], [7.0, 1.0], [-3.0, -3.0]]], [[[3.0, -1.0], [2.0, -3.0], [2.0, -4.0]], [[5.0, 3.0], 
[0.0, -5.0], [-4.0, -6.0]], [[0.0, 0.0], [-5.0, -5.0], [4.0, 1.0]], [[-4.0, -2.0], [-2.0, -2.0], [-2.0, 
0.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([[-71.0, 53.0], [72.0, 118.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank2_offset0(self):
      arg0=numpy.array([5.0, -6.0])
      arg1=Data(numpy.array([[0.0, 6.0, -4.0, -6.0, -5.0], [4.0, 2.0, 7.0, 0.0, 0.0], [-1.0, -1.0, -6.0, -1.0, 1.0], [1.0, 
-7.0, 6.0, -1.0, -3.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[0.0, 30.0, -20.0, -30.0, -25.0], [20.0, 10.0, 35.0, 0.0, 0.0], [-5.0, -5.0, -30.0, -5.0, 5.0], 
[5.0, -35.0, 30.0, -5.0, -15.0]], [[0.0, -36.0, 24.0, 36.0, 30.0], [-24.0, -12.0, -42.0, 0.0, 0.0], [6.0, 6.0, 36.0, 6.0, 
-6.0], [-6.0, 42.0, -36.0, 6.0, 18.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank3_offset1(self):
      arg0=numpy.array([[-6.0, 7.0], [3.0, 4.0], [-7.0, -3.0]])
      arg1=Data(numpy.array([[[5.0, 3.0, 4.0, 3.0, 4.0], [4.0, 3.0, -4.0, -5.0, -6.0], [2.0, -6.0, -6.0, 2.0, -1.0], [0.0, 
-6.0, 1.0, -1.0, -1.0]], [[0.0, -3.0, 0.0, -1.0, 6.0], [7.0, -3.0, -2.0, -3.0, 2.0], [-1.0, 1.0, 7.0, -5.0, -5.0], [-1.0, 6.0, 
6.0, 2.0, -5.0]], [[1.0, 4.0, -3.0, 6.0, -1.0], [5.0, -2.0, -6.0, 1.0, 2.0], [-5.0, 1.0, -7.0, 7.0, -3.0], [5.0, 1.0, 5.0, 7.0, 
-4.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-37.0, -55.0, -3.0, -63.0, 1.0], [-38.0, -13.0, 60.0, 14.0, 28.0], [20.0, 32.0, 106.0, -76.0, 
12.0], [-38.0, 47.0, -23.0, -37.0, 19.0]], [[32.0, -3.0, 37.0, -1.0, 55.0], [41.0, 15.0, -18.0, -50.0, -40.0], [25.0, -41.0, 
7.0, -27.0, -18.0], [-19.0, -21.0, 16.0, -20.0, -15.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank4_offset2(self):
      arg0=numpy.array([[[4.0, -3.0], [-3.0, 6.0], [-4.0, 5.0]], [[1.0, 4.0], [1.0, -1.0], [6.0, -7.0]]])
      arg1=Data(numpy.array([[[[7.0, 1.0, -4.0, -6.0, -7.0], [0.0, -2.0, -4.0, -2.0, 1.0], [-3.0, 1.0, -6.0, -3.0, -7.0], 
[-2.0, 7.0, 6.0, 7.0, 5.0]], [[7.0, -3.0, -4.0, 3.0, 0.0], [-4.0, 4.0, 0.0, 0.0, 4.0], [1.0, -3.0, 3.0, -6.0, -2.0], [-4.0, 
4.0, 5.0, -2.0, -2.0]], [[-3.0, -2.0, 5.0, 7.0, -4.0], [2.0, -5.0, 1.0, -1.0, 1.0], [-3.0, 2.0, -6.0, 0.0, -1.0], [0.0, -1.0, 
-5.0, -2.0, 4.0]]], [[[5.0, 4.0, 5.0, 0.0, -5.0], [1.0, 5.0, -2.0, 5.0, 5.0], [1.0, 1.0, -4.0, -1.0, 5.0], [4.0, -6.0, 6.0, 
-6.0, 3.0]], [[0.0, 0.0, 2.0, 7.0, 6.0], [3.0, -4.0, 7.0, -6.0, -4.0], [-5.0, 0.0, 3.0, -3.0, -7.0], [1.0, -6.0, -2.0, 1.0, 
3.0]], [[7.0, 6.0, 0.0, 0.0, -2.0], [0.0, -3.0, -1.0, -5.0, -6.0], [0.0, -4.0, 6.0, -7.0, -5.0], [5.0, 6.0, -3.0, -4.0, 
7.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[66.0, 61.0, -17.0, -54.0, -23.0], [8.0, -17.0, -21.0, -35.0, -47.0], [-7.0, -18.0, 26.0, -40.0, 
-50.0], [39.0, 44.0, 15.0, 13.0, 58.0]], [[-23.0, -57.0, 31.0, 64.0, -11.0], [-13.0, 50.0, 9.0, 62.0, 92.0], [9.0, 21.0, -55.0, 
21.0, 66.0], [-38.0, -62.0, 34.0, -40.0, -47.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_constData_rank3_offset0(self):
      arg0=numpy.array([-1.0, 6.0])
      arg1=Data(numpy.array([[[2.0, -6.0], [7.0, -5.0]], [[2.0, 7.0], [-6.0, -1.0]], [[6.0, 4.0], [-2.0, 2.0]], [[-4.0, 0.0], 
[2.0, 0.0]], [[4.0, -5.0], [-1.0, 6.0]], [[0.0, -1.0], [-1.0, -7.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-2.0, 6.0], [-7.0, 5.0]], [[-2.0, -7.0], [6.0, 1.0]], [[-6.0, -4.0], [2.0, -2.0]], [[4.0, 0.0], 
[-2.0, 0.0]], [[-4.0, 5.0], [1.0, -6.0]], [[0.0, 1.0], [1.0, 7.0]]], [[[12.0, -36.0], [42.0, -30.0]], [[12.0, 42.0], [-36.0, 
-6.0]], [[36.0, 24.0], [-12.0, 12.0]], [[-24.0, 0.0], [12.0, 0.0]], [[24.0, -30.0], [-6.0, 36.0]], [[0.0, -6.0], [-6.0, 
-42.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank4_offset1(self):
      arg0=numpy.array([[-3.0, -2.0], [4.0, 1.0], [6.0, 0.0]])
      arg1=Data(numpy.array([[[[-3.0, -7.0], [7.0, -6.0]], [[-5.0, -5.0], [6.0, -2.0]], [[7.0, 0.0], [-2.0, -1.0]], [[-1.0, 
-4.0], [1.0, -3.0]], [[3.0, 7.0], [-7.0, -1.0]], [[-6.0, 0.0], [5.0, 2.0]]], [[[-6.0, 3.0], [5.0, -3.0]], [[1.0, 1.0], [-4.0, 
-7.0]], [[2.0, -6.0], [3.0, 7.0]], [[2.0, 1.0], [-3.0, -1.0]], [[6.0, 7.0], [-4.0, 6.0]], [[-1.0, -5.0], [-4.0, -7.0]]], 
[[[-2.0, -5.0], [1.0, -1.0]], [[-2.0, 3.0], [3.0, -7.0]], [[5.0, 1.0], [0.0, -1.0]], [[-4.0, -3.0], [-7.0, -4.0]], [[-7.0, 
6.0], [7.0, 3.0]], [[3.0, -6.0], [5.0, 0.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-27.0, 3.0], [5.0, 0.0]], [[7.0, 37.0], [-16.0, -64.0]], [[17.0, -18.0], [18.0, 25.0]], [[-13.0, 
-2.0], [-57.0, -19.0]], [[-27.0, 43.0], [47.0, 45.0]], [[32.0, -56.0], [-1.0, -34.0]]], [[[0.0, 17.0], [-9.0, 9.0]], [[11.0, 
11.0], [-16.0, -3.0]], [[-12.0, -6.0], [7.0, 9.0]], [[4.0, 9.0], [-5.0, 5.0]], [[0.0, -7.0], [10.0, 8.0]], [[11.0, -5.0], 
[-14.0, -11.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank0_offset0(self):
      arg0=numpy.array([6.0, 5.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(-2.0)+(1-msk_arg1)*(-2.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-12.0, -10.0])+(1.-msk_ref)*numpy.array([-12.0, -10.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank1_offset1(self):
      arg0=numpy.array([[-2.0, 0.0], [7.0, 6.0], [3.0, 3.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([4.0, -7.0, 1.0])+(1.-msk_arg1)*numpy.array([0.0, 6.0, -3.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-54.0, -39.0])+(1.-msk_ref)*numpy.array([33.0, 27.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank2_offset2(self):
      arg0=numpy.array([[[5.0, 1.0], [0.0, 0.0], [-4.0, -6.0]], [[7.0, -4.0], [-3.0, -7.0], [6.0, 3.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[6.0, -5.0, -4.0], [-5.0, 3.0, -4.0]])+(1.-msk_arg1)*numpy.array([[5.0, 0.0, 0.0], [6.0, 7.0, 
-2.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-22.0, 17.0])+(1.-msk_ref)*numpy.array([34.0, -74.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank3_offset3(self):
      arg0=numpy.array([[[[-5.0, -1.0], [-3.0, 1.0], [-5.0, 4.0]], [[2.0, -6.0], [4.0, 6.0], [3.0, -1.0]], [[3.0, -4.0], [1.0, 
7.0], [-3.0, -5.0]], [[-3.0, -6.0], [4.0, -6.0], [-5.0, 1.0]]], [[[0.0, 0.0], [1.0, 1.0], [-3.0, 6.0]], [[7.0, -1.0], [0.0, 
-4.0], [4.0, 2.0]], [[4.0, 6.0], [3.0, 5.0], [-7.0, -2.0]], [[1.0, 1.0], [0.0, -6.0], [3.0, -3.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[3.0, 5.0, 1.0], [3.0, 0.0, -2.0], [0.0, 1.0, -7.0], [3.0, -3.0, -3.0]], [[5.0, 6.0, 0.0], 
[6.0, -4.0, -6.0], [5.0, 3.0, -3.0], [-1.0, -6.0, 6.0]]])+(1.-msk_arg1)*numpy.array([[[5.0, -5.0, 0.0], [-7.0, 7.0, 7.0], 
[-2.0, -4.0, 1.0], [0.0, 3.0, -1.0]], [[7.0, 3.0, 2.0], [4.0, 4.0, -6.0], [7.0, -7.0, -1.0], [-1.0, 0.0, -7.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([72.0, 101.0])+(1.-msk_ref)*numpy.array([22.0, 35.0])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank1_offset0(self):
      arg0=numpy.array([0.0, -3.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([7.0, 4.0])+(1.-msk_arg1)*numpy.array([0.0, 4.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, 0.0], [-21.0, -12.0]])+(1.-msk_ref)*numpy.array([[0.0, 0.0], [0.0, -12.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank2_offset1(self):
      arg0=numpy.array([[3.0, -7.0], [0.0, -6.0], [2.0, -2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, -3.0], [-2.0, 0.0], [-6.0, -2.0]])+(1.-msk_arg1)*numpy.array([[-3.0, -7.0], [-5.0, 
4.0], [5.0, -2.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-24.0, -13.0], [52.0, 25.0]])+(1.-msk_ref)*numpy.array([[1.0, -25.0], [41.0, 29.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank3_offset2(self):
      arg0=numpy.array([[[3.0, 3.0], [6.0, 0.0], [0.0, -6.0]], [[-6.0, 2.0], [6.0, -4.0], [7.0, -6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-4.0, -7.0], [-4.0, -5.0], [-1.0, 6.0]], [[6.0, -2.0], [5.0, -4.0], [-5.0, 
0.0]]])+(1.-msk_arg1)*numpy.array([[[-3.0, 1.0], [7.0, 5.0], [-5.0, -2.0]], [[2.0, -4.0], [4.0, 0.0], [0.0, 7.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-77.0, -63.0], [16.0, -45.0]])+(1.-msk_ref)*numpy.array([[45.0, 106.0], [9.0, -35.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank4_offset3(self):
      arg0=numpy.array([[[[5.0, -7.0], [7.0, 5.0], [7.0, 7.0]], [[-5.0, -1.0], [-5.0, -4.0], [-3.0, -7.0]], [[-6.0, 3.0], [1.0, 
-3.0], [5.0, 3.0]], [[3.0, 7.0], [-6.0, 2.0], [-5.0, 5.0]]], [[[0.0, 0.0], [-6.0, 3.0], [-3.0, 1.0]], [[0.0, -7.0], [5.0, 
-3.0], [0.0, 3.0]], [[0.0, 2.0], [-3.0, 0.0], [-7.0, 1.0]], [[2.0, 0.0], [-2.0, 3.0], [-6.0, 4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-6.0, 6.0], [-6.0, 0.0], [1.0, 0.0]], [[3.0, -4.0], [-4.0, 7.0], [0.0, 1.0]], [[-1.0, 3.0], 
[7.0, -5.0], [3.0, 6.0]], [[2.0, -4.0], [-5.0, -3.0], [0.0, 1.0]]], [[[-2.0, 2.0], [0.0, -6.0], [0.0, -4.0]], [[5.0, 6.0], 
[-5.0, -4.0], [0.0, -2.0]], [[-1.0, -1.0], [3.0, -6.0], [7.0, -5.0]], [[1.0, -6.0], [4.0, 3.0], [-5.0, 
7.0]]]])+(1.-msk_arg1)*numpy.array([[[[-2.0, 1.0], [-5.0, 4.0], [6.0, -6.0]], [[1.0, 1.0], [0.0, -3.0], [1.0, 7.0]], [[-7.0, 
0.0], [3.0, 2.0], [-1.0, 3.0]], [[1.0, 5.0], [4.0, 6.0], [7.0, 6.0]]], [[[5.0, -4.0], [-4.0, 1.0], [-4.0, 6.0]], [[-1.0, -5.0], 
[-6.0, 2.0], [7.0, -2.0]], [[-5.0, -4.0], [2.0, -4.0], [-6.0, 4.0]], [[-5.0, -2.0], [-3.0, 1.0], [6.0, -1.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-55.0, 41.0], [-2.0, -88.0]])+(1.-msk_ref)*numpy.array([[-25.0, -84.0], [69.0, 40.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank2_offset0(self):
      arg0=numpy.array([-4.0, -3.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-4.0, 3.0, -3.0, -7.0, 4.0], [6.0, 0.0, -4.0, -2.0, -2.0], [-6.0, 2.0, 2.0, 7.0, -5.0], 
[-3.0, 2.0, 0.0, 1.0, -7.0]])+(1.-msk_arg1)*numpy.array([[0.0, 5.0, 2.0, -6.0, 7.0], [-2.0, -5.0, 7.0, -2.0, 6.0], [-4.0, 3.0, 
7.0, -7.0, -7.0], [-5.0, -5.0, 0.0, -2.0, 4.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[16.0, -12.0, 12.0, 28.0, -16.0], [-24.0, 0.0, 16.0, 8.0, 8.0], [24.0, -8.0, -8.0, -28.0, 
20.0], [12.0, -8.0, 0.0, -4.0, 28.0]], [[12.0, -9.0, 9.0, 21.0, -12.0], [-18.0, 0.0, 12.0, 6.0, 6.0], [18.0, -6.0, -6.0, -21.0, 
15.0], [9.0, -6.0, 0.0, -3.0, 21.0]]])+(1.-msk_ref)*numpy.array([[[0.0, -20.0, -8.0, 24.0, -28.0], [8.0, 20.0, -28.0, 8.0, 
-24.0], [16.0, -12.0, -28.0, 28.0, 28.0], [20.0, 20.0, 0.0, 8.0, -16.0]], [[0.0, -15.0, -6.0, 18.0, -21.0], [6.0, 15.0, -21.0, 
6.0, -18.0], [12.0, -9.0, -21.0, 21.0, 21.0], [15.0, 15.0, 0.0, 6.0, -12.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank3_offset1(self):
      arg0=numpy.array([[-1.0, 4.0], [-4.0, 1.0], [-6.0, -1.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[-6.0, -2.0, 3.0, -7.0, 1.0], [4.0, -6.0, 4.0, -1.0, -1.0], [2.0, -7.0, -3.0, -3.0, -4.0], 
[7.0, 1.0, 3.0, 0.0, 4.0]], [[0.0, 6.0, -5.0, 6.0, -3.0], [1.0, -6.0, -1.0, -6.0, 4.0], [-5.0, 4.0, 1.0, 7.0, 4.0], [-2.0, 
-5.0, 1.0, 3.0, 0.0]], [[3.0, 3.0, 0.0, 3.0, 4.0], [-6.0, 0.0, 6.0, 4.0, -5.0], [-3.0, -1.0, -1.0, -3.0, 2.0], [4.0, 6.0, -6.0, 
-2.0, 7.0]]])+(1.-msk_arg1)*numpy.array([[[-6.0, 7.0, 6.0, 6.0, -1.0], [2.0, -5.0, -1.0, -3.0, -1.0], [1.0, 1.0, -7.0, -5.0, 
5.0], [1.0, -1.0, 4.0, 6.0, -4.0]], [[0.0, -6.0, -5.0, -2.0, -3.0], [-6.0, 6.0, 0.0, 7.0, -6.0], [1.0, 0.0, -5.0, 5.0, 1.0], 
[-3.0, -1.0, 2.0, -6.0, 7.0]], [[6.0, 2.0, -4.0, -6.0, 1.0], [7.0, -1.0, -6.0, -5.0, -7.0], [-1.0, 0.0, 7.0, 3.0, -1.0], [-2.0, 
-2.0, 0.0, 2.0, 3.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-12.0, -40.0, 17.0, -35.0, -13.0], [28.0, 30.0, -36.0, 1.0, 15.0], [36.0, -3.0, 5.0, -7.0, 
-24.0], [-23.0, -17.0, 29.0, 0.0, -46.0]], [[-27.0, -5.0, 7.0, -25.0, -3.0], [23.0, -30.0, 9.0, -14.0, 5.0], [6.0, -23.0, 
-10.0, -2.0, -14.0], [22.0, -7.0, 19.0, 5.0, 9.0]]])+(1.-msk_ref)*numpy.array([[[-30.0, 5.0, 38.0, 38.0, 7.0], [-20.0, -13.0, 
37.0, 5.0, 67.0], [1.0, -1.0, -15.0, -33.0, -3.0], [23.0, 17.0, -12.0, 6.0, -42.0]], [[-30.0, 20.0, 23.0, 28.0, -8.0], [-5.0, 
-13.0, 2.0, 0.0, -3.0], [6.0, 4.0, -40.0, -18.0, 22.0], [3.0, -3.0, 18.0, 16.0, -12.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank4_offset2(self):
      arg0=numpy.array([[[-7.0, -1.0], [-7.0, 0.0], [-1.0, 2.0]], [[-1.0, -3.0], [6.0, 0.0], [1.0, -5.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-2.0, 2.0, -1.0, -5.0, -1.0], [-7.0, -3.0, -5.0, 3.0, 5.0], [-2.0, -3.0, -4.0, 0.0, 1.0], 
[-5.0, 0.0, 3.0, 1.0, 3.0]], [[2.0, 3.0, 7.0, -4.0, -4.0], [-7.0, 2.0, 1.0, -7.0, 2.0], [3.0, -2.0, 7.0, 6.0, -1.0], [-2.0, 
1.0, 5.0, -5.0, -1.0]], [[0.0, -5.0, -7.0, -6.0, 6.0], [-1.0, 0.0, -3.0, -4.0, 0.0], [0.0, -4.0, -3.0, 4.0, -3.0], [-2.0, -1.0, 
-5.0, 1.0, 5.0]]], [[[4.0, -3.0, -6.0, 5.0, 0.0], [7.0, -2.0, -6.0, -5.0, 0.0], [-2.0, -7.0, 1.0, -7.0, -4.0], [-7.0, 7.0, 2.0, 
-4.0, -3.0]], [[0.0, -4.0, 0.0, -4.0, 7.0], [7.0, 4.0, -1.0, 0.0, -7.0], [4.0, 7.0, 7.0, 1.0, -3.0], [1.0, 5.0, 5.0, -6.0, 
-2.0]], [[-5.0, 2.0, 3.0, -7.0, 2.0], [-6.0, 2.0, 1.0, -1.0, 5.0], [0.0, -5.0, 1.0, -7.0, -5.0], [6.0, 6.0, -2.0, -1.0, 
0.0]]]])+(1.-msk_arg1)*numpy.array([[[[4.0, 0.0, -7.0, 4.0, -4.0], [0.0, -5.0, 0.0, -1.0, 0.0], [-3.0, -3.0, 0.0, 7.0, -6.0], 
[-2.0, 1.0, -1.0, -3.0, -5.0]], [[-3.0, -1.0, -1.0, 0.0, 0.0], [-5.0, -5.0, 4.0, -7.0, 0.0], [4.0, 5.0, -4.0, -7.0, -6.0], 
[5.0, 7.0, -1.0, 7.0, 3.0]], [[0.0, -1.0, -2.0, -1.0, 2.0], [6.0, -3.0, -5.0, -4.0, -1.0], [3.0, 0.0, -2.0, -4.0, -4.0], [0.0, 
-6.0, 0.0, 3.0, 3.0]]], [[[-2.0, 3.0, -4.0, -4.0, 6.0], [-2.0, 5.0, 2.0, 7.0, 5.0], [-4.0, 6.0, 3.0, -2.0, 7.0], [-3.0, -7.0, 
-7.0, -3.0, -7.0]], [[-4.0, -3.0, -3.0, 7.0, 0.0], [1.0, 4.0, -2.0, -6.0, -4.0], [1.0, -5.0, -7.0, -6.0, 7.0], [-2.0, 2.0, 
-4.0, -3.0, 6.0]], [[5.0, -3.0, -5.0, -3.0, 0.0], [3.0, -2.0, -6.0, 0.0, -3.0], [3.0, -7.0, 5.0, 6.0, 0.0], [-7.0, 7.0, 0.0, 
-1.0, -5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-9.0, -49.0, -26.0, 33.0, 73.0], [128.0, 35.0, 32.0, 36.0, -86.0], [19.0, 83.0, 24.0, -40.0, 
-16.0], [70.0, 23.0, -25.0, -6.0, -28.0]], [[15.0, -13.0, -10.0, 13.0, 3.0], [14.0, -1.0, 12.0, 9.0, -30.0], [8.0, 41.0, -10.0, 
64.0, 30.0], [-8.0, -53.0, -9.0, 18.0, 16.0]]])+(1.-msk_ref)*numpy.array([[[-24.0, -16.0, 39.0, 16.0, 20.0], [40.0, 90.0, 
-43.0, 17.0, -31.0], [3.0, -57.0, -10.0, -24.0, 123.0], [-37.0, -24.0, -3.0, -47.0, 49.0]], [[-23.0, 4.0, 40.0, 21.0, -10.0], 
[3.0, -6.0, 14.0, -28.0, -2.0], [6.0, 20.0, -38.0, -39.0, -23.0], [46.0, -27.0, 22.0, 23.0, 57.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(2, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank1_expandedData_rank3_offset0(self):
      arg0=numpy.array([0.0, -3.0])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[6.0, 0.0], [0.0, 5.0]], [[7.0, -3.0], [5.0, -5.0]], [[-6.0, 0.0], [-6.0, 0.0]], [[-1.0, 
1.0], [-5.0, 6.0]], [[-6.0, -4.0], [6.0, 6.0]], [[3.0, 6.0], [2.0, -7.0]]])+(1.-msk_arg1)*numpy.array([[[1.0, -5.0], [-5.0, 
-7.0]], [[5.0, 0.0], [6.0, -3.0]], [[0.0, 5.0], [2.0, -5.0]], [[5.0, -6.0], [0.0, -3.0]], [[-3.0, 7.0], [6.0, -6.0]], [[4.0, 
3.0], [-6.0, -7.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]]], [[[-18.0, 0.0], [0.0, -15.0]], [[-21.0, 9.0], [-15.0, 15.0]], 
[[18.0, 0.0], [18.0, 0.0]], [[3.0, -3.0], [15.0, -18.0]], [[18.0, 12.0], [-18.0, -18.0]], [[-9.0, -18.0], [-6.0, 
21.0]]]])+(1.-msk_ref)*numpy.array([[[[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], 
[0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]]], [[[-3.0, 15.0], [15.0, 21.0]], [[-15.0, 0.0], [-18.0, 9.0]], 
[[0.0, -15.0], [-6.0, 15.0]], [[-15.0, 18.0], [0.0, 9.0]], [[9.0, -21.0], [-18.0, 18.0]], [[-12.0, -9.0], [18.0, 21.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank4_offset1(self):
      arg0=numpy.array([[-1.0, 3.0], [-2.0, 4.0], [-4.0, -3.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-2.0, -3.0], [7.0, 1.0]], [[3.0, -7.0], [-3.0, 1.0]], [[2.0, 7.0], [1.0, -1.0]], [[-4.0, 
4.0], [0.0, -2.0]], [[3.0, 0.0], [6.0, -7.0]], [[-4.0, -4.0], [0.0, 4.0]]], [[[-3.0, 2.0], [3.0, 5.0]], [[1.0, -3.0], [0.0, 
-1.0]], [[-1.0, -1.0], [5.0, 6.0]], [[0.0, 1.0], [-1.0, 5.0]], [[-7.0, -7.0], [0.0, -6.0]], [[7.0, -5.0], [4.0, 2.0]]], [[[0.0, 
7.0], [3.0, -4.0]], [[0.0, 4.0], [5.0, 7.0]], [[-2.0, -3.0], [-1.0, 4.0]], [[-6.0, 0.0], [0.0, -4.0]], [[7.0, -5.0], [-1.0, 
-6.0]], [[-7.0, -4.0], [0.0, -3.0]]]])+(1.-msk_arg1)*numpy.array([[[[0.0, 6.0], [3.0, 5.0]], [[7.0, 6.0], [-4.0, 5.0]], [[-4.0, 
0.0], [-2.0, -1.0]], [[1.0, -1.0], [-2.0, 3.0]], [[1.0, 0.0], [-6.0, -5.0]], [[2.0, 2.0], [-6.0, -6.0]]], [[[-1.0, -4.0], [2.0, 
5.0]], [[-6.0, 2.0], [0.0, 2.0]], [[-7.0, 1.0], [-6.0, -3.0]], [[6.0, -3.0], [7.0, -5.0]], [[-3.0, 0.0], [-3.0, -5.0]], [[0.0, 
-4.0], [0.0, 2.0]]], [[[2.0, 0.0], [0.0, 4.0]], [[-4.0, -3.0], [0.0, 5.0]], [[3.0, -2.0], [7.0, 0.0]], [[-3.0, -2.0], [-3.0, 
5.0]], [[-2.0, 4.0], [-3.0, 0.0]], [[1.0, 2.0], [5.0, 0.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, -29.0], [-25.0, 5.0]], [[-5.0, -3.0], [-17.0, -27.0]], [[8.0, 7.0], [-7.0, -27.0]], 
[[28.0, -6.0], [2.0, 8.0]], [[-17.0, 34.0], [-2.0, 43.0]], [[18.0, 30.0], [-8.0, 4.0]]], [[[-18.0, -22.0], [24.0, 35.0]], 
[[13.0, -45.0], [-24.0, -22.0]], [[8.0, 26.0], [26.0, 9.0]], [[6.0, 16.0], [-4.0, 26.0]], [[-40.0, -13.0], [21.0, -27.0]], 
[[37.0, -20.0], [16.0, 29.0]]]])+(1.-msk_ref)*numpy.array([[[[-6.0, 2.0], [-7.0, -31.0]], [[21.0, 2.0], [4.0, -29.0]], [[6.0, 
6.0], [-14.0, 7.0]], [[-1.0, 15.0], [0.0, -13.0]], [[13.0, -16.0], [24.0, 15.0]], [[-6.0, -2.0], [-14.0, 2.0]]], [[[-10.0, 
2.0], [17.0, 23.0]], [[9.0, 35.0], [-12.0, 8.0]], [[-49.0, 10.0], [-51.0, -15.0]], [[36.0, -9.0], [31.0, -26.0]], [[-3.0, 
-12.0], [-21.0, -35.0]], [[3.0, -16.0], [-33.0, -10.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_float_rank0_offset0(self):
      arg0=numpy.array([[-2.0, -5.0, 1.0, -3.0, -2.0], [3.0, 1.0, -5.0, 4.0, -5.0], [-1.0, -2.0, -7.0, 4.0, 3.0], [0.0, 5.0, 
3.0, 3.0, 5.0]])
      arg1=0.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[-0.0, -0.0, 0.0, -0.0, -0.0], [0.0, 0.0, -0.0, 0.0, -0.0], [-0.0, -0.0, -0.0, 0.0, 0.0], [0.0, 0.0, 
0.0, 0.0, 0.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank0_offset0(self):
      arg0=numpy.array([[4.0, 0.0, -1.0, -6.0, -4.0], [-7.0, 0.0, -4.0, -4.0, 4.0], [-5.0, 0.0, 3.0, -6.0, 2.0], [1.0, 7.0, 
-2.0, 6.0, 4.0]])
      arg1=numpy.array(-5.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[-20.0, -0.0, 5.0, 30.0, 20.0], [35.0, -0.0, 20.0, 20.0, -20.0], [25.0, -0.0, -15.0, 30.0, -10.0], 
[-5.0, -35.0, 10.0, -30.0, -20.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank1_offset1(self):
      arg0=numpy.array([[[-4.0, -6.0, 0.0, 0.0, -5.0], [2.0, 5.0, 7.0, -2.0, 7.0], [-1.0, 7.0, 1.0, -5.0, -4.0], [-2.0, 4.0, 
5.0, -3.0, 5.0]], [[2.0, 0.0, -6.0, -7.0, -2.0], [-6.0, 5.0, 4.0, -2.0, 4.0], [-1.0, 6.0, -3.0, -2.0, 6.0], [-1.0, 2.0, 6.0, 
1.0, 1.0]], [[7.0, -6.0, -3.0, 5.0, -6.0], [-5.0, 6.0, -7.0, -6.0, 4.0], [-1.0, 7.0, -7.0, -4.0, 4.0], [-7.0, -3.0, 0.0, 6.0, 
0.0]]])
      arg1=numpy.array([-7.0, 0.0, 0.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[28.0, 42.0, 0.0, 0.0, 35.0], [-14.0, -35.0, -49.0, 14.0, -49.0], [7.0, -49.0, -7.0, 35.0, 28.0], [14.0, 
-28.0, -35.0, 21.0, -35.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank2_offset2(self):
      arg0=numpy.array([[[[-7.0, 3.0, 3.0, -2.0, -5.0], [0.0, 7.0, -6.0, 0.0, 4.0], [-2.0, -3.0, -7.0, 0.0, 2.0], [-3.0, -2.0, 
6.0, 4.0, -1.0]], [[-5.0, -5.0, -2.0, -1.0, 3.0], [1.0, 4.0, 0.0, -7.0, -4.0], [0.0, -5.0, 7.0, 0.0, -4.0], [-1.0, 4.0, 0.0, 
-2.0, -3.0]], [[-4.0, 5.0, -2.0, 6.0, 0.0], [-2.0, 1.0, 7.0, -5.0, -6.0], [4.0, 0.0, 3.0, 0.0, -5.0], [5.0, -7.0, -5.0, 5.0, 
0.0]]], [[[-7.0, 6.0, -5.0, -1.0, -5.0], [2.0, -6.0, 7.0, -2.0, 3.0], [-3.0, 1.0, -2.0, -2.0, 6.0], [-6.0, 6.0, -5.0, 5.0, 
-7.0]], [[7.0, 5.0, -7.0, 0.0, -7.0], [-7.0, 0.0, 4.0, -7.0, 0.0], [-3.0, 1.0, -5.0, -3.0, -6.0], [6.0, 2.0, 1.0, 5.0, -5.0]], 
[[-1.0, 2.0, 7.0, -4.0, 0.0], [3.0, 5.0, -4.0, -2.0, -4.0], [-2.0, 0.0, 0.0, 0.0, 0.0], [0.0, -2.0, -1.0, 2.0, 5.0]]]])
      arg1=numpy.array([[-1.0, 6.0, -5.0], [-1.0, -5.0, 0.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[-31.0, -89.0, 35.0, -33.0, 63.0], [49.0, 18.0, -56.0, 20.0, -1.0], [0.0, -33.0, 61.0, 17.0, 23.0], 
[-52.0, 45.0, 19.0, -71.0, 15.0]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank1_offset0(self):
      arg0=numpy.array([[3.0, -5.0, -2.0, 1.0, -6.0], [3.0, 0.0, 4.0, 6.0, -2.0], [1.0, -5.0, -4.0, 0.0, 5.0], [7.0, 0.0, -2.0, 
-2.0, 0.0]])
      arg1=numpy.array([-2.0, 0.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-6.0, 0.0], [10.0, 0.0], [4.0, 0.0], [-2.0, 0.0], [12.0, 0.0]], [[-6.0, 0.0], [0.0, 0.0], [-8.0, 0.0], 
[-12.0, 0.0], [4.0, 0.0]], [[-2.0, 0.0], [10.0, 0.0], [8.0, 0.0], [0.0, 0.0], [-10.0, 0.0]], [[-14.0, 0.0], [0.0, 0.0], [4.0, 
0.0], [4.0, 0.0], [0.0, 0.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank2_offset1(self):
      arg0=numpy.array([[[-3.0, -5.0, 0.0, 5.0, 4.0], [2.0, 4.0, -3.0, -6.0, 0.0], [-1.0, -4.0, 3.0, 3.0, 4.0], [5.0, 4.0, 
-3.0, 5.0, -2.0]], [[6.0, -5.0, 5.0, -3.0, 2.0], [4.0, 6.0, 0.0, 4.0, -1.0], [-4.0, 6.0, 3.0, 3.0, -2.0], [1.0, -4.0, -2.0, 
6.0, -6.0]], [[-5.0, 7.0, -7.0, 2.0, 0.0], [-7.0, -7.0, -3.0, -4.0, 4.0], [5.0, -7.0, -2.0, -5.0, 0.0], [-1.0, 7.0, 0.0, 5.0, 
-3.0]]])
      arg1=numpy.array([[3.0, 2.0], [2.0, 0.0], [1.0, -3.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-2.0, 9.0], [-18.0, -31.0], [3.0, 21.0], [11.0, 4.0], [16.0, 8.0]], [[7.0, 25.0], [17.0, 29.0], 
[-12.0, 3.0], [-14.0, 0.0], [2.0, -12.0]], [[-6.0, -17.0], [-7.0, 13.0], [13.0, 12.0], [10.0, 21.0], [8.0, 8.0]], [[16.0, 
13.0], [11.0, -13.0], [-13.0, -6.0], [32.0, -5.0], [-21.0, 5.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank3_offset2(self):
      arg0=numpy.array([[[[2.0, -4.0, 2.0, -6.0, 4.0], [-6.0, 4.0, 7.0, 0.0, 1.0], [-6.0, 3.0, 2.0, -2.0, 2.0], [5.0, 1.0, 1.0, 
0.0, 7.0]], [[3.0, 0.0, -4.0, -3.0, -3.0], [0.0, 0.0, 5.0, 0.0, -5.0], [-6.0, 1.0, 7.0, -2.0, 2.0], [-3.0, -3.0, 0.0, 2.0, 
-3.0]], [[4.0, 0.0, 3.0, 2.0, -4.0], [-1.0, -3.0, 5.0, -5.0, -4.0], [6.0, 6.0, -7.0, -4.0, 7.0], [-4.0, 5.0, 3.0, -1.0, 5.0]]], 
[[[-1.0, 7.0, 2.0, -7.0, 0.0], [2.0, -4.0, -2.0, 1.0, -3.0], [-4.0, 6.0, 3.0, 6.0, 0.0], [-1.0, -7.0, -3.0, 2.0, 6.0]], [[5.0, 
7.0, -3.0, 0.0, 4.0], [-1.0, 3.0, -1.0, 2.0, -7.0], [-5.0, 4.0, 4.0, -2.0, 6.0], [5.0, -4.0, 4.0, 0.0, -4.0]], [[-6.0, 3.0, 
4.0, -2.0, 0.0], [-2.0, 4.0, -2.0, 7.0, 2.0], [-3.0, 0.0, 0.0, 0.0, -2.0], [3.0, -2.0, 0.0, 0.0, -7.0]]]])
      arg1=numpy.array([[[1.0, 6.0], [-3.0, -2.0], [3.0, 7.0]], [[-7.0, 0.0], [1.0, -1.0], [-5.0, 2.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[47.0, 17.0], [-61.0, -25.0], [-14.0, 52.0], [68.0, -20.0], [5.0, -2.0]], [[-14.0, -46.0], [6.0, 8.0], 
[30.0, 64.0], [-55.0, -23.0], [8.0, -1.0]], [[68.0, 17.0], [-20.0, 54.0], [-57.0, -55.0], [-52.0, -34.0], [33.0, 47.0]], 
[[-1.0, 9.0], [80.0, 47.0], [35.0, 23.0], [-23.0, -11.0], [20.0, 73.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_array_rank2_offset0(self):
      arg0=numpy.array([[4.0, -6.0, -1.0, -2.0, -5.0], [-2.0, -3.0, -7.0, 7.0, -5.0], [0.0, -5.0, -1.0, 2.0, 5.0], [4.0, 0.0, 
-3.0, -1.0, 6.0]])
      arg1=numpy.array([[0.0, 0.0, -4.0, -5.0, -5.0], [-5.0, 1.0, 1.0, -4.0, 3.0], [-4.0, -7.0, -1.0, -3.0, 5.0], [6.0, -3.0, 
-2.0, 6.0, 1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[0.0, 0.0, -16.0, -20.0, -20.0], [-20.0, 4.0, 4.0, -16.0, 12.0], [-16.0, -28.0, -4.0, -12.0, 20.0], 
[24.0, -12.0, -8.0, 24.0, 4.0]], [[0.0, 0.0, 24.0, 30.0, 30.0], [30.0, -6.0, -6.0, 24.0, -18.0], [24.0, 42.0, 6.0, 18.0, 
-30.0], [-36.0, 18.0, 12.0, -36.0, -6.0]], [[0.0, 0.0, 4.0, 5.0, 5.0], [5.0, -1.0, -1.0, 4.0, -3.0], [4.0, 7.0, 1.0, 3.0, 
-5.0], [-6.0, 3.0, 2.0, -6.0, -1.0]], [[0.0, 0.0, 8.0, 10.0, 10.0], [10.0, -2.0, -2.0, 8.0, -6.0], [8.0, 14.0, 2.0, 6.0, 
-10.0], [-12.0, 6.0, 4.0, -12.0, -2.0]], [[0.0, 0.0, 20.0, 25.0, 25.0], [25.0, -5.0, -5.0, 20.0, -15.0], [20.0, 35.0, 5.0, 
15.0, -25.0], [-30.0, 15.0, 10.0, -30.0, -5.0]]], [[[0.0, 0.0, 8.0, 10.0, 10.0], [10.0, -2.0, -2.0, 8.0, -6.0], [8.0, 14.0, 
2.0, 6.0, -10.0], [-12.0, 6.0, 4.0, -12.0, -2.0]], [[0.0, 0.0, 12.0, 15.0, 15.0], [15.0, -3.0, -3.0, 12.0, -9.0], [12.0, 21.0, 
3.0, 9.0, -15.0], [-18.0, 9.0, 6.0, -18.0, -3.0]], [[0.0, 0.0, 28.0, 35.0, 35.0], [35.0, -7.0, -7.0, 28.0, -21.0], [28.0, 49.0, 
7.0, 21.0, -35.0], [-42.0, 21.0, 14.0, -42.0, -7.0]], [[0.0, 0.0, -28.0, -35.0, -35.0], [-35.0, 7.0, 7.0, -28.0, 21.0], [-28.0, 
-49.0, -7.0, -21.0, 35.0], [42.0, -21.0, -14.0, 42.0, 7.0]], [[0.0, 0.0, 20.0, 25.0, 25.0], [25.0, -5.0, -5.0, 20.0, -15.0], 
[20.0, 35.0, 5.0, 15.0, -25.0], [-30.0, 15.0, 10.0, -30.0, -5.0]]], [[[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 20.0, 25.0, 25.0], [25.0, -5.0, -5.0, 20.0, -15.0], [20.0, 
35.0, 5.0, 15.0, -25.0], [-30.0, 15.0, 10.0, -30.0, -5.0]], [[0.0, 0.0, 4.0, 5.0, 5.0], [5.0, -1.0, -1.0, 4.0, -3.0], [4.0, 
7.0, 1.0, 3.0, -5.0], [-6.0, 3.0, 2.0, -6.0, -1.0]], [[0.0, 0.0, -8.0, -10.0, -10.0], [-10.0, 2.0, 2.0, -8.0, 6.0], [-8.0, 
-14.0, -2.0, -6.0, 10.0], [12.0, -6.0, -4.0, 12.0, 2.0]], [[0.0, 0.0, -20.0, -25.0, -25.0], [-25.0, 5.0, 5.0, -20.0, 15.0], 
[-20.0, -35.0, -5.0, -15.0, 25.0], [30.0, -15.0, -10.0, 30.0, 5.0]]], [[[0.0, 0.0, -16.0, -20.0, -20.0], [-20.0, 4.0, 4.0, 
-16.0, 12.0], [-16.0, -28.0, -4.0, -12.0, 20.0], [24.0, -12.0, -8.0, 24.0, 4.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 12.0, 15.0, 15.0], [15.0, -3.0, -3.0, 12.0, 
-9.0], [12.0, 21.0, 3.0, 9.0, -15.0], [-18.0, 9.0, 6.0, -18.0, -3.0]], [[0.0, 0.0, 4.0, 5.0, 5.0], [5.0, -1.0, -1.0, 4.0, 
-3.0], [4.0, 7.0, 1.0, 3.0, -5.0], [-6.0, 3.0, 2.0, -6.0, -1.0]], [[0.0, 0.0, -24.0, -30.0, -30.0], [-30.0, 6.0, 6.0, -24.0, 
18.0], [-24.0, -42.0, -6.0, -18.0, 30.0], [36.0, -18.0, -12.0, 36.0, 6.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank3_offset1(self):
      arg0=numpy.array([[[7.0, -2.0, -2.0, -4.0, 7.0], [-7.0, 0.0, -7.0, 5.0, 3.0], [-5.0, -6.0, -4.0, -3.0, 4.0], [-4.0, -6.0, 
-7.0, 0.0, 0.0]], [[2.0, -7.0, -2.0, 0.0, 5.0], [-3.0, 7.0, -2.0, 7.0, 1.0], [3.0, 7.0, -2.0, 5.0, -7.0], [0.0, 5.0, 0.0, -1.0, 
-5.0]], [[2.0, 1.0, -1.0, -5.0, -7.0], [4.0, 6.0, 4.0, 1.0, 2.0], [2.0, -6.0, -1.0, 4.0, -7.0], [6.0, -6.0, -2.0, -3.0, 3.0]]])
      arg1=numpy.array([[[2.0, 5.0, -7.0, -6.0, -2.0], [4.0, 1.0, -1.0, 4.0, 3.0], [7.0, -3.0, -5.0, -5.0, 5.0], [-3.0, 5.0, 
2.0, -5.0, -7.0]], [[0.0, 5.0, -3.0, -7.0, 6.0], [0.0, 4.0, 6.0, -6.0, 0.0], [6.0, 4.0, 0.0, -2.0, -6.0], [5.0, 2.0, 0.0, -3.0, 
4.0]], [[-3.0, -7.0, -6.0, 6.0, 4.0], [-1.0, -6.0, 7.0, -5.0, 1.0], [-1.0, 0.0, 1.0, 0.0, 0.0], [2.0, 5.0, 4.0, 7.0, 3.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[8.0, 31.0, -67.0, -44.0, 6.0], [26.0, 3.0, 19.0, 6.0, 23.0], [59.0, -13.0, -33.0, -39.0, 23.0], 
[-7.0, 49.0, 22.0, -27.0, -35.0]], [[-7.0, -52.0, 29.0, 67.0, -34.0], [-9.0, -36.0, -33.0, 29.0, -5.0], [-57.0, -22.0, 11.0, 
24.0, 32.0], [-27.0, -19.0, 0.0, 38.0, -11.0]], [[-1.0, -13.0, 26.0, 20.0, -12.0], [-7.0, -4.0, -17.0, 9.0, -7.0], [-25.0, 
-2.0, 9.0, 14.0, 2.0], [-6.0, -19.0, -8.0, 9.0, 3.0]], [[7.0, 15.0, 58.0, -6.0, -12.0], [-11.0, 26.0, -31.0, 9.0, -17.0], 
[-23.0, 12.0, 15.0, 20.0, -20.0], [2.0, -45.0, -28.0, -15.0, 13.0]], [[35.0, 109.0, -22.0, -119.0, -12.0], [35.0, 69.0, -26.0, 
33.0, 14.0], [86.0, -1.0, -42.0, -45.0, 5.0], [-10.0, 10.0, -14.0, -99.0, -50.0]]], [[[-26.0, -78.0, 34.0, 87.0, 12.0], [-32.0, 
-43.0, 17.0, -30.0, -17.0], [-71.0, 9.0, 39.0, 41.0, -17.0], [14.0, -21.0, 2.0, 72.0, 49.0]], [[-18.0, -7.0, -57.0, -13.0, 
66.0], [-6.0, -8.0, 84.0, -72.0, 6.0], [36.0, 28.0, 6.0, -14.0, -42.0], [47.0, 44.0, 24.0, 21.0, 46.0]], [[-26.0, -73.0, 31.0, 
80.0, 18.0], [-32.0, -39.0, 23.0, -36.0, -17.0], [-65.0, 13.0, 39.0, 39.0, -23.0], [19.0, -19.0, 2.0, 69.0, 53.0]], [[7.0, 
53.0, -62.0, -73.0, 36.0], [19.0, 27.0, 44.0, -27.0, 16.0], [76.0, 13.0, -24.0, -39.0, -17.0], [22.0, 44.0, 14.0, -39.0, 
-4.0]], [[0.0, 6.0, -36.0, -13.0, 8.0], [10.0, -5.0, 17.0, -4.0, 11.0], [25.0, -5.0, -13.0, -17.0, 9.0], [0.0, 27.0, 14.0, 
-4.0, -11.0]]], [[[-16.0, -24.0, 14.0, 21.0, 36.0], [-22.0, -5.0, 37.0, -48.0, -13.0], [-19.0, 27.0, 27.0, 19.0, -43.0], [34.0, 
-9.0, -2.0, 30.0, 53.0]], [[6.0, 47.0, 57.0, -49.0, 30.0], [-18.0, 58.0, 6.0, -36.0, -24.0], [6.0, 46.0, 24.0, 16.0, -72.0], 
[41.0, -46.0, -36.0, -33.0, 52.0]], [[-5.0, -23.0, 40.0, 32.0, -8.0], [-15.0, -6.0, -15.0, 1.0, -13.0], [-39.0, 4.0, 19.0, 
24.0, -8.0], [0.0, -29.0, -12.0, 19.0, 17.0]], [[-18.0, -18.0, -18.0, 7.0, 52.0], [-16.0, -7.0, 61.0, -62.0, -5.0], [5.0, 29.0, 
19.0, 5.0, -45.0], [42.0, 15.0, 10.0, 28.0, 53.0]], [[29.0, 34.0, 35.0, -17.0, -78.0], [23.0, 18.0, -95.0, 93.0, 5.0], [-7.0, 
-40.0, -27.0, -6.0, 62.0], [-61.0, -29.0, -20.0, -48.0, -77.0]]], [[[-26.0, -62.0, -8.0, 60.0, 32.0], [-22.0, -40.0, 46.0, 
-46.0, -6.0], [-34.0, 12.0, 26.0, 20.0, -20.0], [24.0, 10.0, 16.0, 62.0, 46.0]], [[6.0, 37.0, 63.0, -35.0, 18.0], [-18.0, 50.0, 
-6.0, -24.0, -24.0], [-6.0, 38.0, 24.0, 20.0, -60.0], [31.0, -50.0, -36.0, -27.0, 44.0]], [[-8.0, -21.0, 61.0, 30.0, 6.0], 
[-26.0, 5.0, -7.0, -18.0, -23.0], [-47.0, 21.0, 33.0, 35.0, -35.0], [17.0, -45.0, -22.0, 21.0, 43.0]], [[9.0, 16.0, 21.0, 
-11.0, -18.0], [3.0, 14.0, -27.0, 21.0, -3.0], [-3.0, -4.0, -3.0, 2.0, 6.0], [-11.0, -17.0, -12.0, -18.0, -13.0]], [[-9.0, 
-46.0, -3.0, 53.0, -18.0], [-3.0, -38.0, -9.0, 15.0, 3.0], [-33.0, -20.0, 3.0, 10.0, 30.0], [-19.0, 5.0, 12.0, 36.0, -11.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank4_offset2(self):
      arg0=numpy.array([[[[0.0, 7.0, 2.0, 4.0, 5.0], [-6.0, 6.0, 5.0, -3.0, -7.0], [7.0, 0.0, -4.0, -4.0, 7.0], [3.0, -6.0, 
7.0, 0.0, -5.0]], [[5.0, 0.0, 3.0, -5.0, 1.0], [2.0, 3.0, 7.0, 0.0, 7.0], [-5.0, 5.0, 7.0, 5.0, 0.0], [6.0, -6.0, 4.0, -6.0, 
-3.0]], [[-3.0, 3.0, -3.0, 0.0, 5.0], [0.0, -5.0, -2.0, 4.0, -4.0], [-1.0, -4.0, 7.0, -7.0, -6.0], [-1.0, 6.0, 7.0, 2.0, 
0.0]]], [[[4.0, 5.0, 5.0, -5.0, 2.0], [-3.0, -4.0, 0.0, -7.0, 0.0], [-7.0, 6.0, -4.0, -6.0, -7.0], [6.0, 3.0, -5.0, 7.0, 4.0]], 
[[-7.0, 7.0, -3.0, -5.0, -5.0], [4.0, 5.0, 6.0, 4.0, -2.0], [5.0, -6.0, -3.0, -7.0, -4.0], [-4.0, -2.0, -3.0, 1.0, 3.0]], 
[[-6.0, 1.0, 4.0, 0.0, -3.0], [-1.0, 2.0, -6.0, 2.0, -5.0], [-5.0, -7.0, 5.0, 4.0, 7.0], [3.0, 2.0, -2.0, -7.0, 0.0]]]])
      arg1=numpy.array([[[[7.0, 1.0, -2.0, -6.0, -5.0], [0.0, 0.0, -6.0, -5.0, -5.0], [5.0, -4.0, 0.0, 7.0, -6.0], [-2.0, 7.0, 
-1.0, 0.0, -1.0]], [[-4.0, -1.0, -5.0, 0.0, 0.0], [-2.0, 0.0, 1.0, 3.0, 2.0], [-3.0, -7.0, -1.0, 7.0, -1.0], [-7.0, 3.0, 5.0, 
-5.0, 7.0]], [[4.0, 5.0, -1.0, -5.0, 0.0], [-4.0, 5.0, 0.0, 3.0, -1.0], [5.0, 0.0, 0.0, 3.0, 2.0], [-4.0, 3.0, 0.0, 2.0, 
3.0]]], [[[-1.0, 3.0, -2.0, -4.0, 5.0], [-6.0, -3.0, 3.0, 4.0, -6.0], [2.0, 3.0, -6.0, -1.0, -6.0], [5.0, 5.0, -4.0, -5.0, 
-6.0]], [[-2.0, -6.0, -7.0, -2.0, 5.0], [4.0, -4.0, -4.0, -5.0, -1.0], [-5.0, 0.0, -7.0, 2.0, 6.0], [0.0, 0.0, 0.0, -4.0, 
-2.0]], [[2.0, -7.0, 0.0, -3.0, 4.0], [-7.0, -6.0, -6.0, -6.0, 4.0], [6.0, -5.0, 0.0, 2.0, 7.0], [-4.0, 4.0, 0.0, -5.0, 
-7.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=numpy.array([[[[-34.0, 76.0, 19.0, 31.0, -39.0], [-8.0, 37.0, 81.0, 93.0, -28.0], [-23.0, 7.0, 20.0, -4.0, -119.0], 
[21.0, 2.0, 9.0, 7.0, 58.0]], [[44.0, -12.0, -76.0, -94.0, 29.0], [-21.0, -34.0, -61.0, -47.0, -71.0], [31.0, -18.0, -79.0, 
69.0, -17.0], [-5.0, 87.0, -27.0, -52.0, -49.0]], [[-1.0, -11.0, -5.0, -23.0, 16.0], [-64.0, -42.0, -6.0, 1.0, -12.0], [35.0, 
-34.0, -12.0, 23.0, -41.0], [-4.0, 55.0, -7.0, -54.0, -42.0]], [[63.0, 24.0, 62.0, 6.0, -70.0], [20.0, 35.0, -24.0, -30.0, 
5.0], [50.0, 4.0, 70.0, -12.0, -19.0], [2.0, -12.0, -9.0, 70.0, 1.0]], [[53.0, 86.0, 11.0, -44.0, -52.0], [-33.0, 57.0, 15.0, 
44.0, -47.0], [58.0, -6.0, 22.0, 39.0, -84.0], [-15.0, 51.0, -8.0, 30.0, 36.0]]], [[[-57.0, -34.0, -20.0, 43.0, 31.0], [37.0, 
-1.0, 19.0, 10.0, 44.0], [-68.0, 6.0, -12.0, -19.0, 69.0], [-13.0, -55.0, 28.0, -6.0, 37.0]], [[8.0, -78.0, -49.0, -11.0, 
-17.0], [44.0, -45.0, -77.0, -89.0, 8.0], [-25.0, -67.0, -14.0, 66.0, 19.0], [-41.0, 24.0, 25.0, -35.0, 0.0]], [[-25.0, -6.0, 
-85.0, -14.0, -19.0], [60.0, 2.0, -11.0, -4.0, -39.0], [-72.0, -39.0, -49.0, 78.0, -47.0], [-27.0, 26.0, 30.0, -33.0, 68.0]], 
[[-2.0, -42.0, -12.0, 12.0, 8.0], [28.0, 13.0, -31.0, -33.0, 57.0], [-17.0, -19.0, 14.0, 10.0, 106.0], [-53.0, -36.0, 31.0, 
17.0, 35.0]], [[-99.0, 13.0, -3.0, 81.0, 5.0], [29.0, 18.0, 87.0, 84.0, 35.0], [-96.0, 4.0, 7.0, -26.0, -20.0], [1.0, -60.0, 
42.0, -10.0, 83.0]]], [[[52.0, -9.0, -9.0, -4.0, -65.0], [111.0, 26.0, -58.0, -76.0, -27.0], [-24.0, 11.0, 12.0, 18.0, -2.0], 
[10.0, -24.0, -4.0, 63.0, 22.0]], [[-44.0, 78.0, 9.0, 29.0, -28.0], [-5.0, 28.0, 89.0, 99.0, -44.0], [-35.0, 18.0, 1.0, -9.0, 
-134.0], [39.0, 5.0, 1.0, -4.0, 48.0]], [[-8.0, -5.0, -5.0, -4.0, 5.0], [-65.0, 29.0, 1.0, 31.0, 74.0], [31.0, -70.0, 38.0, 
50.0, 72.0], [-109.0, 14.0, 55.0, -14.0, 69.0]], [[-48.0, -48.0, 51.0, 85.0, -29.0], [-2.0, -13.0, 15.0, 1.0, 96.0], [-23.0, 
-57.0, 80.0, -14.0, 27.0], [-45.0, -48.0, 53.0, -1.0, 40.0]], [[54.0, -69.0, 34.0, 3.0, -62.0], [1.0, -35.0, -89.0, -103.0, 
45.0], [53.0, -84.0, 70.0, 44.0, 13.0], [-53.0, 24.0, 21.0, 4.0, -24.0]]], [[[1.0, 13.0, -19.0, -38.0, 7.0], [-81.0, -25.0, 
4.0, 26.0, -22.0], [42.0, -51.0, -14.0, 52.0, -65.0], [-26.0, 78.0, 3.0, -61.0, -13.0]], [[11.0, 37.0, 44.0, -8.0, 43.0], 
[-52.0, 17.0, 35.0, 40.0, 4.0], [46.0, 65.0, 2.0, -69.0, 38.0], [37.0, -19.0, -36.0, 25.0, -46.0]], [[68.0, 55.0, -10.0, -45.0, 
-83.0], [-4.0, 74.0, -29.0, 5.0, -9.0], [51.0, -61.0, 47.0, 93.0, -34.0], [-87.0, 49.0, 33.0, 41.0, 92.0]], [[9.0, 80.0, 7.0, 
-19.0, 12.0], [15.0, 27.0, 53.0, 53.0, -85.0], [-5.0, 98.0, -43.0, -55.0, -75.0], [97.0, -5.0, -58.0, 30.0, -31.0]], [[-33.0, 
-8.0, -4.0, 8.0, 60.0], [-6.0, -24.0, 27.0, 17.0, -8.0], [-23.0, 53.0, -42.0, -54.0, 27.0], [51.0, -24.0, -26.0, -17.0, 
-46.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank0_offset0(self):
      arg0=numpy.array([[7.0, 6.0, 5.0, -5.0, 2.0], [-2.0, -7.0, 6.0, -4.0, 3.0], [-4.0, -2.0, -3.0, 0.0, 0.0], [-7.0, -6.0, 
3.0, 5.0, 0.0]])
      arg1=Data(1.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[7.0, 6.0, 5.0, -5.0, 2.0], [-2.0, -7.0, 6.0, -4.0, 3.0], [-4.0, -2.0, -3.0, 0.0, 0.0], [-7.0, 
-6.0, 3.0, 5.0, 0.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank1_offset1(self):
      arg0=numpy.array([[[-4.0, 7.0, 3.0, 3.0, 0.0], [5.0, 0.0, -1.0, 5.0, 5.0], [-3.0, 7.0, 5.0, -2.0, -2.0], [-3.0, 4.0, 5.0, 
6.0, 1.0]], [[0.0, 2.0, -6.0, 1.0, 3.0], [3.0, -7.0, -7.0, -2.0, -6.0], [0.0, -6.0, -1.0, -1.0, 6.0], [-5.0, -4.0, 1.0, -6.0, 
0.0]], [[5.0, -4.0, -6.0, -6.0, -5.0], [4.0, -6.0, -2.0, -1.0, 6.0], [3.0, -7.0, 1.0, 0.0, -4.0], [-6.0, -3.0, -1.0, -4.0, 
0.0]]])
      arg1=Data(numpy.array([-6.0, 7.0, 7.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[59.0, -56.0, -102.0, -53.0, -14.0], [19.0, -91.0, -57.0, -51.0, -30.0], [39.0, -133.0, -30.0, 5.0, 
26.0], [-59.0, -73.0, -30.0, -106.0, -6.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank2_offset2(self):
      arg0=numpy.array([[[[3.0, -7.0, 7.0, -6.0, 1.0], [0.0, 4.0, 6.0, 0.0, -7.0], [-7.0, -1.0, 2.0, -7.0, 6.0], [-7.0, 1.0, 
2.0, 0.0, -1.0]], [[2.0, 3.0, 2.0, -2.0, -3.0], [6.0, -1.0, 0.0, -6.0, 6.0], [-5.0, -1.0, -1.0, -3.0, -4.0], [-6.0, 1.0, -5.0, 
-1.0, -5.0]], [[4.0, -4.0, -5.0, 3.0, 7.0], [2.0, -4.0, -1.0, -7.0, -4.0], [-5.0, 0.0, -3.0, -5.0, 0.0], [-4.0, 4.0, 6.0, 3.0, 
0.0]]], [[[5.0, -4.0, 6.0, 4.0, 0.0], [-3.0, 1.0, -6.0, -3.0, -6.0], [-2.0, 7.0, 0.0, -6.0, 4.0], [4.0, -5.0, 0.0, 2.0, -1.0]], 
[[0.0, -3.0, 6.0, -3.0, 1.0], [-4.0, 6.0, 1.0, 3.0, 1.0], [-4.0, 4.0, 6.0, 0.0, 2.0], [7.0, -5.0, -3.0, 0.0, 4.0]], [[4.0, 2.0, 
6.0, -7.0, -1.0], [6.0, 0.0, 2.0, 4.0, 2.0], [-1.0, 0.0, 2.0, -1.0, 5.0], [-3.0, 0.0, -1.0, -3.0, 3.0]]]])
      arg1=Data(numpy.array([[6.0, 0.0, 6.0], [-7.0, 4.0, 4.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[23.0, -42.0, 18.0, -86.0, 48.0], [41.0, 17.0, 84.0, 7.0, -12.0], [-78.0, -39.0, 26.0, -34.0, 
36.0], [-78.0, 45.0, 32.0, -8.0, 29.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank1_offset0(self):
      arg0=numpy.array([[0.0, 7.0, 2.0, 7.0, 5.0], [6.0, -5.0, -4.0, -1.0, 3.0], [0.0, 7.0, -2.0, 2.0, 6.0], [-1.0, -4.0, 4.0, 
1.0, 7.0]])
      arg1=Data(numpy.array([5.0, 5.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[0.0, 0.0], [35.0, 35.0], [10.0, 10.0], [35.0, 35.0], [25.0, 25.0]], [[30.0, 30.0], [-25.0, 
-25.0], [-20.0, -20.0], [-5.0, -5.0], [15.0, 15.0]], [[0.0, 0.0], [35.0, 35.0], [-10.0, -10.0], [10.0, 10.0], [30.0, 30.0]], 
[[-5.0, -5.0], [-20.0, -20.0], [20.0, 20.0], [5.0, 5.0], [35.0, 35.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank2_offset1(self):
      arg0=numpy.array([[[-6.0, 3.0, -4.0, 0.0, 1.0], [2.0, -7.0, 1.0, -4.0, 0.0], [7.0, -1.0, -3.0, 3.0, 2.0], [4.0, 2.0, 0.0, 
0.0, -4.0]], [[0.0, 3.0, 0.0, 5.0, -4.0], [-1.0, -4.0, -5.0, 3.0, -2.0], [0.0, 6.0, -6.0, 1.0, -7.0], [-1.0, 1.0, 3.0, 0.0, 
-1.0]], [[-5.0, -4.0, 0.0, 3.0, 4.0], [5.0, -2.0, 0.0, -1.0, 3.0], [-6.0, 7.0, 7.0, -2.0, -1.0], [-5.0, 4.0, -3.0, -3.0, 
-5.0]]])
      arg1=Data(numpy.array([[0.0, 5.0], [0.0, 1.0], [4.0, 0.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-20.0, -30.0], [-16.0, 18.0], [0.0, -20.0], [12.0, 5.0], [16.0, 1.0]], [[20.0, 9.0], [-8.0, 
-39.0], [0.0, 0.0], [-4.0, -17.0], [12.0, -2.0]], [[-24.0, 35.0], [28.0, 1.0], [28.0, -21.0], [-8.0, 16.0], [-4.0, 3.0]], 
[[-20.0, 19.0], [16.0, 11.0], [-12.0, 3.0], [-12.0, 0.0], [-20.0, -21.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank3_offset2(self):
      arg0=numpy.array([[[[0.0, 4.0, -6.0, 5.0, -4.0], [-6.0, -3.0, 2.0, -4.0, -3.0], [-3.0, -7.0, -3.0, 0.0, -6.0], [6.0, 
-5.0, 1.0, -4.0, 1.0]], [[2.0, -5.0, -3.0, 5.0, 3.0], [1.0, -6.0, 0.0, 4.0, -6.0], [-2.0, 4.0, -6.0, -5.0, -4.0], [-2.0, 3.0, 
5.0, 0.0, -3.0]], [[-7.0, -1.0, -1.0, -7.0, 2.0], [-2.0, 5.0, -3.0, 1.0, 7.0], [-3.0, -2.0, 2.0, -4.0, -7.0], [0.0, 3.0, -2.0, 
4.0, 1.0]]], [[[-7.0, 7.0, 6.0, -3.0, 0.0], [2.0, -7.0, 1.0, -5.0, -5.0], [-2.0, 5.0, 1.0, 3.0, -2.0], [-4.0, 6.0, 4.0, -2.0, 
-5.0]], [[-2.0, -7.0, 1.0, -1.0, 7.0], [2.0, -2.0, -4.0, -6.0, -6.0], [-1.0, 6.0, 3.0, 2.0, 7.0], [-7.0, -5.0, -7.0, -3.0, 
-6.0]], [[-6.0, 5.0, -6.0, -7.0, 4.0], [-6.0, -4.0, 7.0, -3.0, 0.0], [7.0, 4.0, 7.0, 2.0, -4.0], [0.0, -1.0, 2.0, -6.0, 1.0]]]])
      arg1=Data(numpy.array([[[-5.0, 1.0], [-2.0, 7.0], [6.0, 0.0]], [[-6.0, -6.0], [-4.0, -3.0], [3.0, 
-1.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[-14.0, 68.0], [-15.0, -57.0], [-28.0, -60.0], [-76.0, 68.0], [10.0, -8.0]], [[-22.0, -11.0], 
[95.0, 7.0], [3.0, 1.0], [63.0, 75.0], [123.0, 3.0]], [[38.0, -9.0], [-27.0, -31.0], [42.0, -67.0], [-34.0, -61.0], [-32.0, 
-39.0]], [[26.0, 37.0], [18.0, -4.0], [-17.0, 31.0], [50.0, 23.0], [64.0, 27.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_constData_rank2_offset0(self):
      arg0=numpy.array([[6.0, -7.0, -5.0, -3.0, -3.0], [7.0, -6.0, -7.0, 6.0, -7.0], [3.0, 5.0, 1.0, -5.0, -3.0], [-3.0, -1.0, 
2.0, 2.0, -2.0]])
      arg1=Data(numpy.array([[2.0, -1.0, -6.0, -7.0, 3.0], [-5.0, 7.0, -2.0, -2.0, 0.0], [-7.0, 7.0, 5.0, 3.0, 4.0], [-5.0, 
4.0, -5.0, 2.0, 1.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[12.0, -6.0, -36.0, -42.0, 18.0], [-30.0, 42.0, -12.0, -12.0, 0.0], [-42.0, 42.0, 30.0, 18.0, 
24.0], [-30.0, 24.0, -30.0, 12.0, 6.0]], [[-14.0, 7.0, 42.0, 49.0, -21.0], [35.0, -49.0, 14.0, 14.0, 0.0], [49.0, -49.0, -35.0, 
-21.0, -28.0], [35.0, -28.0, 35.0, -14.0, -7.0]], [[-10.0, 5.0, 30.0, 35.0, -15.0], [25.0, -35.0, 10.0, 10.0, 0.0], [35.0, 
-35.0, -25.0, -15.0, -20.0], [25.0, -20.0, 25.0, -10.0, -5.0]], [[-6.0, 3.0, 18.0, 21.0, -9.0], [15.0, -21.0, 6.0, 6.0, 0.0], 
[21.0, -21.0, -15.0, -9.0, -12.0], [15.0, -12.0, 15.0, -6.0, -3.0]], [[-6.0, 3.0, 18.0, 21.0, -9.0], [15.0, -21.0, 6.0, 6.0, 
0.0], [21.0, -21.0, -15.0, -9.0, -12.0], [15.0, -12.0, 15.0, -6.0, -3.0]]], [[[14.0, -7.0, -42.0, -49.0, 21.0], [-35.0, 49.0, 
-14.0, -14.0, 0.0], [-49.0, 49.0, 35.0, 21.0, 28.0], [-35.0, 28.0, -35.0, 14.0, 7.0]], [[-12.0, 6.0, 36.0, 42.0, -18.0], [30.0, 
-42.0, 12.0, 12.0, 0.0], [42.0, -42.0, -30.0, -18.0, -24.0], [30.0, -24.0, 30.0, -12.0, -6.0]], [[-14.0, 7.0, 42.0, 49.0, 
-21.0], [35.0, -49.0, 14.0, 14.0, 0.0], [49.0, -49.0, -35.0, -21.0, -28.0], [35.0, -28.0, 35.0, -14.0, -7.0]], [[12.0, -6.0, 
-36.0, -42.0, 18.0], [-30.0, 42.0, -12.0, -12.0, 0.0], [-42.0, 42.0, 30.0, 18.0, 24.0], [-30.0, 24.0, -30.0, 12.0, 6.0]], 
[[-14.0, 7.0, 42.0, 49.0, -21.0], [35.0, -49.0, 14.0, 14.0, 0.0], [49.0, -49.0, -35.0, -21.0, -28.0], [35.0, -28.0, 35.0, 
-14.0, -7.0]]], [[[6.0, -3.0, -18.0, -21.0, 9.0], [-15.0, 21.0, -6.0, -6.0, 0.0], [-21.0, 21.0, 15.0, 9.0, 12.0], [-15.0, 12.0, 
-15.0, 6.0, 3.0]], [[10.0, -5.0, -30.0, -35.0, 15.0], [-25.0, 35.0, -10.0, -10.0, 0.0], [-35.0, 35.0, 25.0, 15.0, 20.0], 
[-25.0, 20.0, -25.0, 10.0, 5.0]], [[2.0, -1.0, -6.0, -7.0, 3.0], [-5.0, 7.0, -2.0, -2.0, 0.0], [-7.0, 7.0, 5.0, 3.0, 4.0], 
[-5.0, 4.0, -5.0, 2.0, 1.0]], [[-10.0, 5.0, 30.0, 35.0, -15.0], [25.0, -35.0, 10.0, 10.0, 0.0], [35.0, -35.0, -25.0, -15.0, 
-20.0], [25.0, -20.0, 25.0, -10.0, -5.0]], [[-6.0, 3.0, 18.0, 21.0, -9.0], [15.0, -21.0, 6.0, 6.0, 0.0], [21.0, -21.0, -15.0, 
-9.0, -12.0], [15.0, -12.0, 15.0, -6.0, -3.0]]], [[[-6.0, 3.0, 18.0, 21.0, -9.0], [15.0, -21.0, 6.0, 6.0, 0.0], [21.0, -21.0, 
-15.0, -9.0, -12.0], [15.0, -12.0, 15.0, -6.0, -3.0]], [[-2.0, 1.0, 6.0, 7.0, -3.0], [5.0, -7.0, 2.0, 2.0, 0.0], [7.0, -7.0, 
-5.0, -3.0, -4.0], [5.0, -4.0, 5.0, -2.0, -1.0]], [[4.0, -2.0, -12.0, -14.0, 6.0], [-10.0, 14.0, -4.0, -4.0, 0.0], [-14.0, 
14.0, 10.0, 6.0, 8.0], [-10.0, 8.0, -10.0, 4.0, 2.0]], [[4.0, -2.0, -12.0, -14.0, 6.0], [-10.0, 14.0, -4.0, -4.0, 0.0], [-14.0, 
14.0, 10.0, 6.0, 8.0], [-10.0, 8.0, -10.0, 4.0, 2.0]], [[-4.0, 2.0, 12.0, 14.0, -6.0], [10.0, -14.0, 4.0, 4.0, 0.0], [14.0, 
-14.0, -10.0, -6.0, -8.0], [10.0, -8.0, 10.0, -4.0, -2.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank3_offset1(self):
      arg0=numpy.array([[[6.0, -3.0, -7.0, 4.0, 5.0], [2.0, -7.0, -2.0, 5.0, 5.0], [-2.0, 6.0, -6.0, -6.0, -1.0], [-5.0, 0.0, 
4.0, -7.0, -3.0]], [[4.0, 1.0, 2.0, -6.0, -4.0], [-7.0, 1.0, -1.0, -1.0, -7.0], [-6.0, 6.0, -3.0, -6.0, 6.0], [-1.0, 0.0, -5.0, 
-5.0, 7.0]], [[-3.0, 4.0, -7.0, -7.0, 4.0], [3.0, -4.0, 4.0, -5.0, -1.0], [6.0, 5.0, 3.0, 0.0, -2.0], [-3.0, 7.0, 4.0, 3.0, 
0.0]]])
      arg1=Data(numpy.array([[[5.0, 4.0, 7.0, -3.0, 7.0], [4.0, -7.0, 1.0, 6.0, -3.0], [0.0, -4.0, -6.0, -7.0, -5.0], [-4.0, 
-1.0, 2.0, 6.0, 6.0]], [[0.0, -4.0, 5.0, -1.0, 4.0], [-7.0, 0.0, -2.0, -6.0, 7.0], [-3.0, 1.0, 4.0, -3.0, 5.0], [0.0, -5.0, 
5.0, 0.0, 4.0]], [[6.0, 5.0, -5.0, -2.0, 2.0], [-6.0, -2.0, 0.0, 7.0, -5.0], [-4.0, 1.0, -7.0, 4.0, -5.0], [-2.0, -2.0, 5.0, 
3.0, 3.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[12.0, -7.0, 77.0, -16.0, 52.0], [14.0, -36.0, -2.0, -9.0, 25.0], [0.0, -23.0, 1.0, -66.0, 5.0], 
[-18.0, -20.0, 17.0, 27.0, 43.0]], [[9.0, 4.0, -36.0, 0.0, -9.0], [-43.0, 13.0, -5.0, 4.0, -4.0], [-19.0, 17.0, -6.0, 34.0, 
0.0], [4.0, -10.0, 19.0, -6.0, -2.0]], [[-77.0, -71.0, -4.0, 33.0, -55.0], [0.0, 63.0, -11.0, -103.0, 70.0], [22.0, 23.0, 99.0, 
15.0, 80.0], [42.0, 11.0, -39.0, -63.0, -55.0]], [[-22.0, 5.0, 33.0, 8.0, -10.0], [100.0, -14.0, 16.0, 11.0, -19.0], [46.0, 
-29.0, 1.0, -38.0, -15.0], [-2.0, 40.0, -57.0, 3.0, -21.0]], [[49.0, 56.0, -5.0, -19.0, 27.0], [24.0, -43.0, 13.0, 82.0, 
-63.0], [-4.0, -20.0, -74.0, -7.0, -65.0], [-28.0, 7.0, 10.0, 42.0, 26.0]]], [[[28.0, 51.0, -36.0, -5.0, -8.0], [39.0, -20.0, 
16.0, 75.0, -70.0], [9.0, -12.0, -61.0, 19.0, -60.0], [-14.0, 27.0, -16.0, 21.0, -7.0]], [[-59.0, -52.0, -24.0, 28.0, -53.0], 
[-11.0, 57.0, -9.0, -76.0, 48.0], [13.0, 25.0, 74.0, 30.0, 60.0], [36.0, 10.0, -29.0, -54.0, -50.0]], [[14.0, 16.0, -39.0, 
-1.0, -10.0], [-25.0, 6.0, 0.0, 22.0, -21.0], [-13.0, 11.0, -20.0, 33.0, -15.0], [0.0, -1.0, 11.0, 0.0, -4.0]], [[-5.0, -1.0, 
55.0, -4.0, 21.0], [57.0, -25.0, 7.0, 1.0, 3.0], [23.0, -26.0, 1.0, -52.0, -5.0], [-10.0, 10.0, -20.0, 15.0, 11.0]], [[19.0, 
43.0, 5.0, -6.0, 5.0], [75.0, -33.0, 19.0, 65.0, -59.0], [25.0, -28.0, -51.0, -18.0, -55.0], [-18.0, 32.0, -30.0, 27.0, 
-1.0]]], [[[26.0, 46.0, -74.0, 0.0, -26.0], [-2.0, 2.0, 10.0, 66.0, -66.0], [-6.0, 8.0, -54.0, 56.0, -50.0], [-4.0, 20.0, -4.0, 
6.0, -18.0]], [[60.0, 25.0, 47.0, -34.0, 76.0], [-48.0, -52.0, -6.0, 35.0, -1.0], [-38.0, -13.0, -47.0, -40.0, -25.0], [-34.0, 
-46.0, 67.0, 51.0, 75.0]], [[-12.0, 3.0, -72.0, 15.0, -48.0], [-21.0, 36.0, 0.0, 3.0, -18.0], [-3.0, 24.0, 3.0, 63.0, 0.0], 
[18.0, 15.0, -12.0, -27.0, -39.0]], [[-30.0, 0.0, -72.0, 24.0, -66.0], [18.0, 42.0, 6.0, 0.0, -24.0], [18.0, 18.0, 12.0, 60.0, 
0.0], [24.0, 36.0, -42.0, -36.0, -60.0]], [[-17.0, -38.0, 33.0, 1.0, 13.0], [-34.0, 11.0, -13.0, -56.0, 55.0], [-10.0, 8.0, 
44.0, -19.0, 45.0], [8.0, -25.0, 18.0, -12.0, 12.0]]], [[[-43.0, -31.0, -25.0, 22.0, -45.0], [5.0, 41.0, -3.0, -45.0, 23.0], 
[15.0, 16.0, 47.0, 26.0, 35.0], [26.0, 16.0, -30.0, -39.0, -43.0]], [[42.0, 35.0, -35.0, -14.0, 14.0], [-42.0, -14.0, 0.0, 
49.0, -35.0], [-28.0, 7.0, -49.0, 28.0, -35.0], [-14.0, -14.0, 35.0, 21.0, 21.0]], [[44.0, 56.0, -17.0, -15.0, 16.0], [27.0, 
-36.0, 14.0, 82.0, -67.0], [-1.0, -17.0, -72.0, 3.0, -65.0], [-24.0, 13.0, 3.0, 36.0, 16.0]], [[-17.0, 7.0, -89.0, 20.0, 
-63.0], [-11.0, 43.0, 3.0, 9.0, -29.0], [3.0, 26.0, 1.0, 76.0, -5.0], [22.0, 26.0, -24.0, -33.0, -53.0]], [[-15.0, -40.0, 14.0, 
2.0, 7.0], [-61.0, 21.0, -17.0, -60.0, 58.0], [-21.0, 19.0, 46.0, 0.0, 50.0], [12.0, -32.0, 29.0, -18.0, 
10.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank4_offset2(self):
      arg0=numpy.array([[[[5.0, -6.0, -4.0, 6.0, 2.0], [4.0, -3.0, -3.0, 1.0, 3.0], [2.0, 7.0, 3.0, 7.0, 3.0], [6.0, 7.0, -1.0, 
-2.0, 0.0]], [[-5.0, 4.0, -2.0, 3.0, 2.0], [5.0, -1.0, -4.0, 2.0, -1.0], [6.0, -2.0, 4.0, -5.0, 5.0], [0.0, 7.0, -4.0, 4.0, 
0.0]], [[0.0, -5.0, 0.0, 1.0, 7.0], [1.0, 0.0, 6.0, -2.0, -2.0], [2.0, 0.0, 0.0, 7.0, 4.0], [-5.0, 3.0, 3.0, 5.0, 5.0]]], 
[[[5.0, 5.0, -5.0, -7.0, -2.0], [-3.0, -7.0, -1.0, -1.0, -1.0], [0.0, -2.0, 5.0, 6.0, -3.0], [6.0, -6.0, -3.0, 1.0, 1.0]], 
[[1.0, 4.0, -6.0, 4.0, 6.0], [2.0, 1.0, 5.0, -6.0, 2.0], [-4.0, -3.0, -4.0, -3.0, -7.0], [-7.0, 0.0, 1.0, 3.0, 7.0]], [[0.0, 
2.0, 7.0, 2.0, -5.0], [-6.0, -2.0, 6.0, 0.0, 0.0], [-1.0, 0.0, -6.0, 4.0, 4.0], [0.0, -3.0, 6.0, 2.0, -2.0]]]])
      arg1=Data(numpy.array([[[[0.0, -6.0, 6.0, 4.0, -3.0], [3.0, 2.0, 4.0, 5.0, -5.0], [5.0, -4.0, -4.0, 0.0, -5.0], [3.0, 
0.0, 0.0, -1.0, -2.0]], [[3.0, -4.0, 0.0, 7.0, 0.0], [0.0, 2.0, 4.0, 0.0, 4.0], [-6.0, 0.0, -3.0, 1.0, 3.0], [0.0, 1.0, 0.0, 
6.0, 3.0]], [[-7.0, -3.0, -1.0, 5.0, 0.0], [0.0, -1.0, -4.0, 0.0, -6.0], [1.0, -4.0, -1.0, -4.0, 7.0], [-2.0, -3.0, 5.0, 0.0, 
5.0]]], [[[0.0, 2.0, -2.0, -6.0, 6.0], [-2.0, 0.0, 1.0, 6.0, -6.0], [3.0, 0.0, 0.0, 5.0, 6.0], [2.0, 1.0, 3.0, -7.0, 3.0]], 
[[7.0, 4.0, -1.0, 4.0, 0.0], [-1.0, 1.0, -4.0, 0.0, 5.0], [6.0, -4.0, 5.0, 1.0, 5.0], [0.0, 0.0, 6.0, 4.0, 1.0]], [[0.0, 4.0, 
-1.0, 3.0, -7.0], [4.0, -5.0, 7.0, 7.0, 1.0], [0.0, -4.0, 0.0, -2.0, 3.0], [-5.0, -6.0, 5.0, 5.0, -3.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[[[-8.0, 4.0, 19.0, -41.0, 15.0], [4.0, 1.0, 1.0, 55.0, -70.0], [76.0, -24.0, 0.0, 21.0, -5.0], 
[25.0, 0.0, 21.0, -66.0, -9.0]], [[75.0, 69.0, -47.0, -29.0, 34.0], [-24.0, -5.0, 15.0, 14.0, 68.0], [-20.0, 20.0, 37.0, 49.0, 
63.0], [-8.0, 12.0, 24.0, 21.0, 12.0]], [[-48.0, 26.0, -15.0, -3.0, -67.0], [32.0, -53.0, 44.0, -1.0, 19.0], [-59.0, 12.0, 
-8.0, -47.0, -25.0], [-57.0, -49.0, -16.0, 38.0, -40.0]], [[30.0, -41.0, 43.0, 114.0, -74.0], [36.0, 11.0, 23.0, 2.0, 40.0], 
[16.0, -52.0, -14.0, -36.0, -30.0], [-8.0, -19.0, 18.0, 87.0, -21.0]], [[-1.0, -41.0, 8.0, 78.0, 17.0], [-16.0, 32.0, -73.0, 
-37.0, -7.0], [35.0, -40.0, 9.0, -20.0, 48.0], [13.0, 9.0, 40.0, 23.0, 52.0]]], [[[22.0, -69.0, 33.0, 64.0, 12.0], [-8.0, 49.0, 
-21.0, -40.0, 16.0], [-6.0, -4.0, -22.0, 0.0, -24.0], [34.0, 35.0, -22.0, 25.0, 23.0]], [[4.0, 4.0, -3.0, 21.0, -19.0], [-4.0, 
3.0, -41.0, -71.0, 56.0], [-24.0, 16.0, 20.0, -31.0, -31.0], [-13.0, 4.0, -25.0, 40.0, -11.0]], [[-19.0, 58.0, -33.0, 34.0, 
-39.0], [12.0, -45.0, -31.0, 21.0, 0.0], [42.0, -56.0, 43.0, -40.0, 82.0], [-53.0, -59.0, 87.0, 36.0, 8.0]], [[-22.0, -34.0, 
16.0, -10.0, -9.0], [11.0, 2.0, 43.0, -1.0, -9.0], [-48.0, 28.0, -38.0, -1.0, -49.0], [5.0, 7.0, -49.0, -6.0, -15.0]], [[25.0, 
-2.0, 20.0, 9.0, -15.0], [9.0, 8.0, 7.0, 9.0, 9.0], [28.0, -12.0, 3.0, 4.0, -28.0], [11.0, 4.0, -1.0, 6.0, -20.0]]], [[[-24.0, 
-62.0, 15.0, 41.0, 1.0], [6.0, 15.0, 33.0, 3.0, -19.0], [-48.0, 4.0, -48.0, -4.0, -1.0], [7.0, 6.0, -19.0, 13.0, 23.0]], 
[[-27.0, -50.0, 49.0, 14.0, -33.0], [28.0, 7.0, 30.0, 23.0, -46.0], [23.0, -16.0, -37.0, -15.0, -68.0], [17.0, -4.0, -24.0, 
-17.0, -29.0]], [[-16.0, -64.0, 18.0, -24.0, 63.0], [-21.0, 40.0, 7.0, 3.0, -55.0], [-18.0, 28.0, -44.0, 37.0, -11.0], [49.0, 
45.0, -39.0, -60.0, 35.0]], [[-85.0, -27.0, 22.0, -8.0, -13.0], [28.0, -26.0, 26.0, 99.0, -144.0], [72.0, -60.0, -35.0, -14.0, 
32.0], [-1.0, -44.0, 55.0, -71.0, 9.0]], [[-62.0, -68.0, 23.0, 69.0, -55.0], [38.0, -15.0, 69.0, 25.0, -32.0], [-62.0, -16.0, 
-66.0, -41.0, -13.0], [-25.0, -34.0, -11.0, 40.0, 1.0]]], [[[-14.0, -37.0, 36.0, -65.0, 18.0], [13.0, 10.0, 78.0, 66.0, -71.0], 
[1.0, 24.0, -54.0, 43.0, -64.0], [40.0, 21.0, -49.0, -76.0, -26.0]], [[0.0, -103.0, 54.0, 119.0, -36.0], [21.0, 40.0, 17.0, 
-22.0, 8.0], [-22.0, -28.0, -52.0, -29.0, -38.0], [18.0, 10.0, -18.0, 62.0, 13.0]], [[-26.0, 35.0, -10.0, 23.0, -57.0], [26.0, 
-42.0, 3.0, 19.0, 0.0], [19.0, -36.0, 18.0, -42.0, 19.0], [-45.0, -52.0, 42.0, 32.0, -21.0]], [[-2.0, 3.0, -24.0, 57.0, -2.0], 
[-3.0, -8.0, -9.0, 10.0, 7.0], [-8.0, -32.0, 6.0, -12.0, 84.0], [-24.0, -22.0, 56.0, 41.0, 41.0]], [[14.0, 7.0, -12.0, 41.0, 
20.0], [-17.0, 12.0, -61.0, -8.0, -3.0], [50.0, -40.0, 30.0, -4.0, 70.0], [2.0, -2.0, 60.0, 11.0, 41.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank0_offset0(self):
      arg0=numpy.array([[7.0, -2.0, 1.0, -3.0, 1.0], [-2.0, 0.0, 1.0, 4.0, 2.0], [1.0, -4.0, -5.0, -5.0, 5.0], [5.0, -6.0, 6.0, 
-2.0, -7.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(0.0)+(1-msk_arg1)*(-4.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.0, -0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.0, -0.0, -0.0, 0.0], [0.0, 
-0.0, 0.0, -0.0, -0.0]])+(1.-msk_ref)*numpy.array([[-28.0, 8.0, -4.0, 12.0, -4.0], [8.0, -0.0, -4.0, -16.0, -8.0], [-4.0, 16.0, 
20.0, 20.0, -20.0], [-20.0, 24.0, -24.0, 8.0, 28.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank1_offset1(self):
      arg0=numpy.array([[[6.0, -5.0, -5.0, 2.0, -1.0], [1.0, 0.0, 7.0, -1.0, -4.0], [7.0, 6.0, -7.0, -2.0, 7.0], [2.0, -5.0, 
1.0, -1.0, 2.0]], [[0.0, 2.0, -6.0, 0.0, -2.0], [-6.0, 3.0, 3.0, 3.0, -1.0], [-2.0, 4.0, 4.0, 7.0, 0.0], [-3.0, 7.0, 1.0, 7.0, 
0.0]], [[1.0, -2.0, 5.0, 4.0, -3.0], [7.0, -4.0, 5.0, 5.0, -4.0], [0.0, 7.0, 6.0, -4.0, 4.0], [-2.0, 0.0, -3.0, 3.0, -7.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-5.0, -3.0, 2.0])+(1.-msk_arg1)*numpy.array([2.0, 1.0, 0.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-28.0, 15.0, 53.0, -2.0, 5.0], [27.0, -17.0, -34.0, 6.0, 15.0], [-29.0, -28.0, 35.0, -19.0, 
-27.0], [-5.0, 4.0, -14.0, -10.0, -24.0]])+(1.-msk_ref)*numpy.array([[12.0, -8.0, -16.0, 4.0, -4.0], [-4.0, 3.0, 17.0, 1.0, 
-9.0], [12.0, 16.0, -10.0, 3.0, 14.0], [1.0, -3.0, 3.0, 5.0, 4.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank2_offset2(self):
      arg0=numpy.array([[[[-2.0, 3.0, 7.0, -4.0, -2.0], [0.0, -2.0, 0.0, -4.0, 0.0], [3.0, 0.0, -1.0, 6.0, -1.0], [6.0, 1.0, 
7.0, 7.0, -1.0]], [[-1.0, 4.0, -6.0, 5.0, 7.0], [4.0, 0.0, -5.0, -4.0, -5.0], [6.0, 6.0, -1.0, 1.0, 2.0], [-7.0, 5.0, -6.0, 
7.0, -7.0]], [[7.0, 0.0, 4.0, 6.0, 0.0], [-1.0, -3.0, 5.0, 7.0, 6.0], [1.0, -3.0, 6.0, 5.0, 0.0], [-2.0, -4.0, 0.0, 7.0, 
0.0]]], [[[1.0, 4.0, 0.0, 5.0, 5.0], [0.0, 6.0, 3.0, 5.0, -6.0], [-7.0, -4.0, -5.0, 0.0, 1.0], [5.0, -7.0, -4.0, 1.0, 1.0]], 
[[3.0, 1.0, -5.0, -7.0, -6.0], [4.0, -2.0, 0.0, -3.0, 3.0], [-5.0, 0.0, 1.0, 0.0, 2.0], [-2.0, -7.0, -2.0, 0.0, 3.0]], [[-5.0, 
3.0, 0.0, -1.0, 4.0], [4.0, 3.0, 3.0, -5.0, 0.0], [6.0, 5.0, 2.0, 0.0, 0.0], [-7.0, 1.0, -1.0, 2.0, -4.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[1.0, -1.0, 7.0], [1.0, -6.0, -7.0]])+(1.-msk_arg1)*numpy.array([[0.0, -5.0, 0.0], [-3.0, 0.0, 
0.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[66.0, -24.0, 71.0, 87.0, 4.0], [-63.0, -26.0, 22.0, 107.0, 23.0], [-15.0, -66.0, 17.0, 40.0, 
-14.0], [65.0, -4.0, 28.0, 36.0, 17.0]])+(1.-msk_ref)*numpy.array([[2.0, -32.0, 30.0, -40.0, -50.0], [-20.0, -18.0, 16.0, 5.0, 
43.0], [-9.0, -18.0, 20.0, -5.0, -13.0], [20.0, -4.0, 42.0, -38.0, 32.0]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank1_offset0(self):
      arg0=numpy.array([[-4.0, -3.0, 5.0, 0.0, 7.0], [-5.0, 5.0, 0.0, 2.0, -6.0], [-7.0, 7.0, -6.0, -4.0, -4.0], [-3.0, 0.0, 
0.0, 5.0, 2.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([6.0, -2.0])+(1.-msk_arg1)*numpy.array([-3.0, 3.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-24.0, 8.0], [-18.0, 6.0], [30.0, -10.0], [0.0, 0.0], [42.0, -14.0]], [[-30.0, 10.0], [30.0, 
-10.0], [0.0, 0.0], [12.0, -4.0], [-36.0, 12.0]], [[-42.0, 14.0], [42.0, -14.0], [-36.0, 12.0], [-24.0, 8.0], [-24.0, 8.0]], 
[[-18.0, 6.0], [0.0, 0.0], [0.0, 0.0], [30.0, -10.0], [12.0, -4.0]]])+(1.-msk_ref)*numpy.array([[[12.0, -12.0], [9.0, -9.0], 
[-15.0, 15.0], [0.0, 0.0], [-21.0, 21.0]], [[15.0, -15.0], [-15.0, 15.0], [0.0, 0.0], [-6.0, 6.0], [18.0, -18.0]], [[21.0, 
-21.0], [-21.0, 21.0], [18.0, -18.0], [12.0, -12.0], [12.0, -12.0]], [[9.0, -9.0], [0.0, 0.0], [0.0, 0.0], [-15.0, 15.0], 
[-6.0, 6.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank2_offset1(self):
      arg0=numpy.array([[[-3.0, -7.0, 6.0, -7.0, 6.0], [6.0, -7.0, 7.0, 3.0, 0.0], [-4.0, 0.0, -7.0, -6.0, -5.0], [0.0, 5.0, 
-6.0, -3.0, 0.0]], [[6.0, 0.0, -6.0, 6.0, -6.0], [-2.0, -3.0, -5.0, -3.0, 0.0], [-5.0, -3.0, -6.0, 6.0, 6.0], [2.0, -6.0, 0.0, 
1.0, 0.0]], [[0.0, -2.0, 5.0, -5.0, 6.0], [3.0, 5.0, -5.0, 0.0, -3.0], [7.0, 6.0, -5.0, 5.0, -5.0], [4.0, -6.0, -1.0, 3.0, 
-6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, -6.0], [-3.0, -7.0], [4.0, -7.0]])+(1.-msk_arg1)*numpy.array([[7.0, 1.0], [5.0, 0.0], 
[0.0, 1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-3.0, -24.0], [27.0, 56.0], [8.0, -29.0], [-3.0, 35.0], [12.0, -36.0]], [[-12.0, -43.0], 
[64.0, 28.0], [-40.0, 28.0], [-6.0, 3.0], [-12.0, 21.0]], [[63.0, 10.0], [33.0, -21.0], [33.0, 119.0], [32.0, -41.0], [-13.0, 
23.0]], [[10.0, -42.0], [-31.0, 54.0], [26.0, 43.0], [24.0, -10.0], [-24.0, 42.0]]])+(1.-msk_ref)*numpy.array([[[9.0, -3.0], 
[-49.0, -9.0], [12.0, 11.0], [-19.0, -12.0], [12.0, 12.0]], [[32.0, 9.0], [-64.0, -2.0], [24.0, 2.0], [6.0, 3.0], [0.0, -3.0]], 
[[-53.0, 3.0], [-15.0, 6.0], [-79.0, -12.0], [-12.0, -1.0], [-5.0, -10.0]], [[10.0, 4.0], [5.0, -1.0], [-42.0, -7.0], [-16.0, 
0.0], [0.0, -6.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank3_offset2(self):
      arg0=numpy.array([[[[-3.0, -3.0, 4.0, -6.0, 3.0], [1.0, 3.0, -1.0, 2.0, -5.0], [-2.0, -7.0, 7.0, -1.0, -6.0], [5.0, 6.0, 
-2.0, 6.0, -2.0]], [[4.0, 3.0, 2.0, -6.0, -3.0], [-2.0, -5.0, -1.0, 2.0, 0.0], [4.0, -2.0, 0.0, 3.0, -7.0], [6.0, 1.0, -2.0, 
0.0, 6.0]], [[4.0, 6.0, -4.0, -4.0, -5.0], [-5.0, -6.0, 7.0, -7.0, 6.0], [-4.0, 1.0, -7.0, 4.0, -3.0], [6.0, 0.0, 1.0, 3.0, 
-4.0]]], [[[-2.0, -6.0, 1.0, -7.0, 7.0], [1.0, -4.0, -5.0, 6.0, -5.0], [0.0, -5.0, -4.0, -6.0, 1.0], [-6.0, 7.0, 7.0, 2.0, 
2.0]], [[1.0, -1.0, -5.0, -6.0, 1.0], [-2.0, 6.0, -4.0, 0.0, 5.0], [5.0, -1.0, 5.0, -1.0, -1.0], [-7.0, -5.0, -4.0, -5.0, 
2.0]], [[-6.0, 7.0, -7.0, -7.0, -5.0], [2.0, 3.0, 0.0, -3.0, 7.0], [-4.0, 3.0, -7.0, -3.0, -1.0], [0.0, -4.0, 5.0, -4.0, 
-2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[5.0, -3.0], [2.0, -1.0], [2.0, -7.0]], [[-2.0, 2.0], [7.0, -4.0], [-7.0, 
3.0]]])+(1.-msk_arg1)*numpy.array([[[-3.0, 2.0], [0.0, -1.0], [0.0, -5.0]], [[1.0, -6.0], [3.0, -3.0], [3.0, 0.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[54.0, -49.0], [-41.0, -23.0], [28.0, 15.0], [-29.0, 41.0], [27.0, 24.0]], [[-39.0, 50.0], 
[22.0, 15.0], [-11.0, -39.0], [9.0, 44.0], [-17.0, -36.0]], [[53.0, -2.0], [-55.0, 19.0], [113.0, -21.0], [35.0, -45.0], 
[-52.0, 49.0]], [[12.0, -47.0], [11.0, 3.0], [-89.0, 46.0], [25.0, -27.0], [18.0, 18.0]]])+(1.-msk_ref)*numpy.array([[[-8.0, 
-21.0], [21.0, 0.0], [-47.0, 35.0], [-28.0, 74.0], [-14.0, -11.0]], [[-2.0, 29.0], [14.0, 47.0], [-14.0, 6.0], [-9.0, 1.0], 
[46.0, -25.0]], [[9.0, -3.0], [22.0, 16.0], [-31.0, 58.0], [-15.0, 14.0], [13.0, 7.0]], [[-42.0, 31.0], [-38.0, -16.0], [16.0, 
-37.0], [-43.0, 0.0], [8.0, -8.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank2_expandedData_rank2_offset0(self):
      arg0=numpy.array([[4.0, 0.0, 0.0, 3.0, 6.0], [-1.0, 3.0, 3.0, 5.0, 2.0], [5.0, 7.0, 6.0, -6.0, 0.0], [-7.0, 4.0, -5.0, 
-6.0, 1.0]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-5.0, -6.0, 0.0, 1.0, 2.0], [5.0, 7.0, 3.0, -4.0, 2.0], [0.0, -7.0, 4.0, -1.0, -7.0], [5.0, 
4.0, 5.0, -6.0, -4.0]])+(1.-msk_arg1)*numpy.array([[-7.0, 0.0, -5.0, -6.0, 5.0], [-4.0, 4.0, 0.0, 0.0, 2.0], [2.0, -6.0, 2.0, 
7.0, -2.0], [7.0, -2.0, 0.0, -3.0, 1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-20.0, -24.0, 0.0, 4.0, 8.0], [20.0, 28.0, 12.0, -16.0, 8.0], [0.0, -28.0, 16.0, -4.0, 
-28.0], [20.0, 16.0, 20.0, -24.0, -16.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], 
[0.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 
0.0, 0.0]], [[-15.0, -18.0, 0.0, 3.0, 6.0], [15.0, 21.0, 9.0, -12.0, 6.0], [0.0, -21.0, 12.0, -3.0, -21.0], [15.0, 12.0, 15.0, 
-18.0, -12.0]], [[-30.0, -36.0, 0.0, 6.0, 12.0], [30.0, 42.0, 18.0, -24.0, 12.0], [0.0, -42.0, 24.0, -6.0, -42.0], [30.0, 24.0, 
30.0, -36.0, -24.0]]], [[[5.0, 6.0, 0.0, -1.0, -2.0], [-5.0, -7.0, -3.0, 4.0, -2.0], [0.0, 7.0, -4.0, 1.0, 7.0], [-5.0, -4.0, 
-5.0, 6.0, 4.0]], [[-15.0, -18.0, 0.0, 3.0, 6.0], [15.0, 21.0, 9.0, -12.0, 6.0], [0.0, -21.0, 12.0, -3.0, -21.0], [15.0, 12.0, 
15.0, -18.0, -12.0]], [[-15.0, -18.0, 0.0, 3.0, 6.0], [15.0, 21.0, 9.0, -12.0, 6.0], [0.0, -21.0, 12.0, -3.0, -21.0], [15.0, 
12.0, 15.0, -18.0, -12.0]], [[-25.0, -30.0, 0.0, 5.0, 10.0], [25.0, 35.0, 15.0, -20.0, 10.0], [0.0, -35.0, 20.0, -5.0, -35.0], 
[25.0, 20.0, 25.0, -30.0, -20.0]], [[-10.0, -12.0, 0.0, 2.0, 4.0], [10.0, 14.0, 6.0, -8.0, 4.0], [0.0, -14.0, 8.0, -2.0, 
-14.0], [10.0, 8.0, 10.0, -12.0, -8.0]]], [[[-25.0, -30.0, 0.0, 5.0, 10.0], [25.0, 35.0, 15.0, -20.0, 10.0], [0.0, -35.0, 20.0, 
-5.0, -35.0], [25.0, 20.0, 25.0, -30.0, -20.0]], [[-35.0, -42.0, 0.0, 7.0, 14.0], [35.0, 49.0, 21.0, -28.0, 14.0], [0.0, -49.0, 
28.0, -7.0, -49.0], [35.0, 28.0, 35.0, -42.0, -28.0]], [[-30.0, -36.0, 0.0, 6.0, 12.0], [30.0, 42.0, 18.0, -24.0, 12.0], [0.0, 
-42.0, 24.0, -6.0, -42.0], [30.0, 24.0, 30.0, -36.0, -24.0]], [[30.0, 36.0, 0.0, -6.0, -12.0], [-30.0, -42.0, -18.0, 24.0, 
-12.0], [0.0, 42.0, -24.0, 6.0, 42.0], [-30.0, -24.0, -30.0, 36.0, 24.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[35.0, 42.0, 0.0, -7.0, -14.0], [-35.0, -49.0, -21.0, 28.0, 
-14.0], [0.0, 49.0, -28.0, 7.0, 49.0], [-35.0, -28.0, -35.0, 42.0, 28.0]], [[-20.0, -24.0, 0.0, 4.0, 8.0], [20.0, 28.0, 12.0, 
-16.0, 8.0], [0.0, -28.0, 16.0, -4.0, -28.0], [20.0, 16.0, 20.0, -24.0, -16.0]], [[25.0, 30.0, 0.0, -5.0, -10.0], [-25.0, 
-35.0, -15.0, 20.0, -10.0], [0.0, 35.0, -20.0, 5.0, 35.0], [-25.0, -20.0, -25.0, 30.0, 20.0]], [[30.0, 36.0, 0.0, -6.0, -12.0], 
[-30.0, -42.0, -18.0, 24.0, -12.0], [0.0, 42.0, -24.0, 6.0, 42.0], [-30.0, -24.0, -30.0, 36.0, 24.0]], [[-5.0, -6.0, 0.0, 1.0, 
2.0], [5.0, 7.0, 3.0, -4.0, 2.0], [0.0, -7.0, 4.0, -1.0, -7.0], [5.0, 4.0, 5.0, -6.0, 
-4.0]]]])+(1.-msk_ref)*numpy.array([[[[-28.0, 0.0, -20.0, -24.0, 20.0], [-16.0, 16.0, 0.0, 0.0, 8.0], [8.0, -24.0, 8.0, 28.0, 
-8.0], [28.0, -8.0, 0.0, -12.0, 4.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 
0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0]], [[-21.0, 0.0, -15.0, -18.0, 15.0], [-12.0, 12.0, 0.0, 0.0, 6.0], [6.0, -18.0, 6.0, 21.0, -6.0], [21.0, -6.0, 0.0, -9.0, 
3.0]], [[-42.0, 0.0, -30.0, -36.0, 30.0], [-24.0, 24.0, 0.0, 0.0, 12.0], [12.0, -36.0, 12.0, 42.0, -12.0], [42.0, -12.0, 0.0, 
-18.0, 6.0]]], [[[7.0, 0.0, 5.0, 6.0, -5.0], [4.0, -4.0, 0.0, 0.0, -2.0], [-2.0, 6.0, -2.0, -7.0, 2.0], [-7.0, 2.0, 0.0, 3.0, 
-1.0]], [[-21.0, 0.0, -15.0, -18.0, 15.0], [-12.0, 12.0, 0.0, 0.0, 6.0], [6.0, -18.0, 6.0, 21.0, -6.0], [21.0, -6.0, 0.0, -9.0, 
3.0]], [[-21.0, 0.0, -15.0, -18.0, 15.0], [-12.0, 12.0, 0.0, 0.0, 6.0], [6.0, -18.0, 6.0, 21.0, -6.0], [21.0, -6.0, 0.0, -9.0, 
3.0]], [[-35.0, 0.0, -25.0, -30.0, 25.0], [-20.0, 20.0, 0.0, 0.0, 10.0], [10.0, -30.0, 10.0, 35.0, -10.0], [35.0, -10.0, 0.0, 
-15.0, 5.0]], [[-14.0, 0.0, -10.0, -12.0, 10.0], [-8.0, 8.0, 0.0, 0.0, 4.0], [4.0, -12.0, 4.0, 14.0, -4.0], [14.0, -4.0, 0.0, 
-6.0, 2.0]]], [[[-35.0, 0.0, -25.0, -30.0, 25.0], [-20.0, 20.0, 0.0, 0.0, 10.0], [10.0, -30.0, 10.0, 35.0, -10.0], [35.0, 
-10.0, 0.0, -15.0, 5.0]], [[-49.0, 0.0, -35.0, -42.0, 35.0], [-28.0, 28.0, 0.0, 0.0, 14.0], [14.0, -42.0, 14.0, 49.0, -14.0], 
[49.0, -14.0, 0.0, -21.0, 7.0]], [[-42.0, 0.0, -30.0, -36.0, 30.0], [-24.0, 24.0, 0.0, 0.0, 12.0], [12.0, -36.0, 12.0, 42.0, 
-12.0], [42.0, -12.0, 0.0, -18.0, 6.0]], [[42.0, 0.0, 30.0, 36.0, -30.0], [24.0, -24.0, 0.0, 0.0, -12.0], [-12.0, 36.0, -12.0, 
-42.0, 12.0], [-42.0, 12.0, 0.0, 18.0, -6.0]], [[0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 
0.0], [0.0, 0.0, 0.0, 0.0, 0.0]]], [[[49.0, 0.0, 35.0, 42.0, -35.0], [28.0, -28.0, 0.0, 0.0, -14.0], [-14.0, 42.0, -14.0, 
-49.0, 14.0], [-49.0, 14.0, 0.0, 21.0, -7.0]], [[-28.0, 0.0, -20.0, -24.0, 20.0], [-16.0, 16.0, 0.0, 0.0, 8.0], [8.0, -24.0, 
8.0, 28.0, -8.0], [28.0, -8.0, 0.0, -12.0, 4.0]], [[35.0, 0.0, 25.0, 30.0, -25.0], [20.0, -20.0, 0.0, 0.0, -10.0], [-10.0, 
30.0, -10.0, -35.0, 10.0], [-35.0, 10.0, 0.0, 15.0, -5.0]], [[42.0, 0.0, 30.0, 36.0, -30.0], [24.0, -24.0, 0.0, 0.0, -12.0], 
[-12.0, 36.0, -12.0, -42.0, 12.0], [-42.0, 12.0, 0.0, 18.0, -6.0]], [[-7.0, 0.0, -5.0, -6.0, 5.0], [-4.0, 4.0, 0.0, 0.0, 2.0], 
[2.0, -6.0, 2.0, 7.0, -2.0], [7.0, -2.0, 0.0, -3.0, 1.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank3_offset1(self):
      arg0=numpy.array([[[3.0, -6.0, 2.0, -3.0, -5.0], [-6.0, 4.0, 0.0, 1.0, 6.0], [-3.0, -4.0, 3.0, 5.0, 0.0], [-6.0, 4.0, 
-4.0, 0.0, -5.0]], [[-4.0, -5.0, 1.0, 1.0, 4.0], [2.0, 0.0, 3.0, 4.0, 0.0], [-3.0, -5.0, 1.0, 6.0, 0.0], [7.0, 1.0, 2.0, -6.0, 
-1.0]], [[-7.0, -3.0, 0.0, -1.0, 0.0], [4.0, 1.0, 1.0, 0.0, -6.0], [4.0, -1.0, 0.0, -6.0, -4.0], [2.0, -6.0, -6.0, -2.0, 
-6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[2.0, 4.0, 6.0, 6.0, -6.0], [-6.0, -2.0, -7.0, 7.0, -1.0], [-1.0, 0.0, 2.0, -7.0, 3.0], [4.0, 
1.0, -7.0, 2.0, -6.0]], [[-6.0, -5.0, 7.0, -3.0, -4.0], [7.0, -5.0, 3.0, 4.0, -6.0], [5.0, -2.0, -6.0, 7.0, -3.0], [7.0, 6.0, 
1.0, -2.0, 5.0]], [[-1.0, 2.0, 3.0, 6.0, -4.0], [4.0, -5.0, 2.0, -4.0, -1.0], [7.0, 6.0, -1.0, 4.0, 2.0], [5.0, -2.0, -1.0, 
4.0, 7.0]]])+(1.-msk_arg1)*numpy.array([[[7.0, 7.0, -5.0, -2.0, 3.0], [1.0, 0.0, 0.0, 2.0, 0.0], [6.0, 7.0, 2.0, -6.0, 0.0], 
[7.0, 7.0, -3.0, -1.0, -3.0]], [[1.0, -4.0, -4.0, 1.0, -4.0], [5.0, -1.0, 7.0, -5.0, -7.0], [5.0, 3.0, -1.0, -2.0, -2.0], [1.0, 
6.0, -5.0, 3.0, 1.0]], [[-4.0, -7.0, -5.0, 0.0, 4.0], [2.0, -2.0, 5.0, -1.0, 5.0], [-6.0, 1.0, 7.0, -4.0, -3.0], [-1.0, -7.0, 
0.0, 1.0, 0.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[37.0, 18.0, -31.0, -12.0, 26.0], [-74.0, 49.0, -47.0, 33.0, 28.0], [-72.0, -34.0, 37.0, 
-77.0, 7.0], [-51.0, -7.0, -18.0, -14.0, -87.0]], [[21.0, -5.0, -80.0, -39.0, 68.0], [-11.0, 52.0, 21.0, -50.0, 39.0], [-40.0, 
-8.0, 21.0, -5.0, -9.0], [-74.0, -30.0, 40.0, -14.0, -10.0]], [[-2.0, 3.0, 19.0, 9.0, -16.0], [-5.0, -9.0, -11.0, 18.0, -8.0], 
[3.0, -2.0, -2.0, -7.0, 3.0], [15.0, 8.0, -13.0, 2.0, -7.0]], [[-11.0, -19.0, -14.0, -27.0, 18.0], [21.0, 6.0, 22.0, -13.0, 
-2.0], [1.0, -8.0, -11.0, 24.0, -14.0], [-10.0, 5.0, 23.0, -12.0, 16.0]], [[-34.0, -40.0, -2.0, -42.0, 14.0], [58.0, -10.0, 
47.0, -19.0, -19.0], [25.0, -8.0, -34.0, 63.0, -27.0], [8.0, 19.0, 39.0, -18.0, 50.0]]], [[[-28.0, -26.0, -10.0, -18.0, 12.0], 
[66.0, -18.0, 56.0, -50.0, -10.0], [44.0, 20.0, -28.0, 72.0, -16.0], [10.0, -2.0, 40.0, 0.0, 74.0]], [[7.0, 18.0, 27.0, 30.0, 
-28.0], [-20.0, -13.0, -26.0, 24.0, -5.0], [3.0, 6.0, 7.0, -24.0, 14.0], [21.0, 2.0, -29.0, 12.0, -17.0]], [[-19.0, -13.0, 
24.0, -3.0, -16.0], [25.0, -20.0, 11.0, 8.0, -19.0], [22.0, 0.0, -19.0, 25.0, -7.0], [26.0, 16.0, 2.0, -2.0, 22.0]], [[-22.0, 
-16.0, 34.0, -6.0, -22.0], [22.0, -22.0, 5.0, 23.0, -25.0], [19.0, -8.0, -22.0, 21.0, -9.0], [32.0, 25.0, -3.0, -6.0, 14.0]], 
[[18.0, 12.0, 18.0, 0.0, -12.0], [-60.0, 18.0, -54.0, 66.0, 0.0], [-48.0, -36.0, 18.0, -66.0, 6.0], [-6.0, 18.0, -36.0, -12.0, 
-78.0]]], [[[8.0, 11.0, -27.0, 15.0, 14.0], [13.0, 1.0, 20.0, -49.0, 17.0], [16.0, 30.0, 8.0, 16.0, 8.0], [-13.0, -29.0, 14.0, 
16.0, 31.0]], [[23.0, 7.0, -62.0, -15.0, 48.0], [-15.0, 38.0, 11.0, -44.0, 35.0], [-28.0, 4.0, 23.0, -11.0, 1.0], [-56.0, 
-32.0, 24.0, -2.0, -8.0]], [[0.0, 7.0, 25.0, 15.0, -22.0], [-11.0, -11.0, -18.0, 25.0, -9.0], [2.0, -2.0, 0.0, -14.0, 6.0], 
[19.0, 9.0, -20.0, 4.0, -13.0]], [[-20.0, -22.0, 54.0, -24.0, -30.0], [-12.0, -10.0, -29.0, 83.0, -35.0], [-17.0, -48.0, -20.0, 
-17.0, -15.0], [32.0, 53.0, -23.0, -26.0, -42.0]], [[4.0, -8.0, -12.0, -24.0, 16.0], [-16.0, 20.0, -8.0, 16.0, 4.0], [-28.0, 
-24.0, 4.0, -16.0, -8.0], [-20.0, 8.0, 4.0, -16.0, -28.0]]], [[[-56.0, -55.0, 19.0, -45.0, 0.0], [93.0, -33.0, 67.0, -22.0, 
-38.0], [55.0, -2.0, -56.0, 99.0, -35.0], [35.0, 32.0, 47.0, -18.0, 85.0]], [[8.0, -1.0, 13.0, -15.0, -4.0], [-41.0, 17.0, 
-37.0, 56.0, -4.0], [-41.0, -38.0, 8.0, -45.0, -3.0], [-7.0, 22.0, -21.0, -18.0, -61.0]], [[-14.0, -38.0, -28.0, -66.0, 40.0], 
[14.0, 28.0, 22.0, 4.0, -2.0], [-28.0, -40.0, -14.0, 18.0, -30.0], [-32.0, 20.0, 36.0, -36.0, -8.0]], [[38.0, 26.0, -48.0, 6.0, 
32.0], [-50.0, 40.0, -22.0, -16.0, 38.0], [-44.0, 0.0, 38.0, -50.0, 14.0], [-52.0, -32.0, -4.0, 4.0, -44.0]], [[2.0, -27.0, 
-55.0, -63.0, 58.0], [-1.0, 45.0, 20.0, -15.0, 17.0], [-42.0, -34.0, 2.0, 4.0, -24.0], [-57.0, 1.0, 40.0, -32.0, 
-17.0]]]])+(1.-msk_ref)*numpy.array([[[[45.0, 86.0, 36.0, -10.0, -3.0], [-31.0, 18.0, -63.0, 33.0, -7.0], [40.0, 2.0, -39.0, 
18.0, 29.0], [24.0, 46.0, 11.0, -22.0, -13.0]], [[-35.0, -1.0, 65.0, 7.0, -10.0], [-37.0, 11.0, -50.0, 16.0, 20.0], [-43.0, 
-60.0, -28.0, 58.0, 19.0], [-44.0, -51.0, 43.0, -12.0, 13.0]], [[15.0, 10.0, -14.0, -3.0, 2.0], [7.0, -1.0, 7.0, -1.0, -7.0], 
[17.0, 17.0, 3.0, -14.0, -2.0], [15.0, 20.0, -11.0, 1.0, -5.0]], [[-16.0, -18.0, 16.0, 7.0, -17.0], [0.0, 1.0, 2.0, -10.0, 
-12.0], [-7.0, -19.0, -14.0, 20.0, 1.0], [-19.0, -8.0, 4.0, 5.0, 10.0]], [[-31.0, -51.0, 9.0, 14.0, -31.0], [15.0, -4.0, 28.0, 
-30.0, -28.0], [-10.0, -23.0, -14.0, 22.0, -8.0], [-31.0, -11.0, -5.0, 17.0, 19.0]]], [[[-56.0, -78.0, 2.0, 14.0, -10.0], 
[12.0, -10.0, 34.0, -26.0, 6.0], [-50.0, -32.0, 14.0, 16.0, -16.0], [-44.0, -58.0, 8.0, 16.0, 20.0]], [[24.0, 21.0, -25.0, 
-8.0, 16.0], [6.0, -2.0, 5.0, 7.0, 5.0], [18.0, 29.0, 15.0, -28.0, -3.0], [27.0, 21.0, -12.0, -3.0, -12.0]], [[-1.0, -19.0, 
-17.0, 3.0, -8.0], [17.0, -5.0, 26.0, -16.0, -16.0], [9.0, 10.0, 4.0, -10.0, -9.0], [2.0, 11.0, -15.0, 10.0, 3.0]], [[11.0, 
-9.0, -21.0, 2.0, -13.0], [21.0, -4.0, 28.0, -18.0, -28.0], [26.0, 19.0, -2.0, -14.0, -8.0], [11.0, 31.0, -23.0, 11.0, 1.0]], 
[[66.0, 84.0, 0.0, -12.0, -6.0], [-6.0, 12.0, -30.0, 18.0, -30.0], [72.0, 36.0, -30.0, -12.0, 18.0], [48.0, 84.0, -18.0, -12.0, 
-18.0]]], [[[-40.0, -37.0, 7.0, 3.0, 19.0], [-10.0, -5.0, -1.0, 5.0, 41.0], [-57.0, -26.0, 25.0, 8.0, -6.0], [-28.0, -67.0, 
24.0, -2.0, 6.0]], [[-29.0, -1.0, 45.0, 3.0, 4.0], [-31.0, 7.0, -40.0, 18.0, 30.0], [-43.0, -44.0, -10.0, 38.0, 13.0], [-32.0, 
-51.0, 37.0, -12.0, 7.0]], [[22.0, 17.0, -19.0, -5.0, 5.0], [8.0, -1.0, 7.0, 1.0, -7.0], [23.0, 24.0, 5.0, -20.0, -2.0], [22.0, 
27.0, -14.0, 0.0, -8.0]], [[65.0, 53.0, -19.0, -4.0, -33.0], [23.0, 6.0, 12.0, -14.0, -72.0], [96.0, 47.0, -38.0, -18.0, 6.0], 
[47.0, 113.0, -45.0, 7.0, -9.0]], [[16.0, 28.0, 20.0, 0.0, -16.0], [-8.0, 8.0, -20.0, 4.0, -20.0], [24.0, -4.0, -28.0, 16.0, 
12.0], [4.0, 28.0, 0.0, -4.0, 0.0]]], [[[-43.0, -84.0, -8.0, 19.0, -38.0], [33.0, -11.0, 59.0, -49.0, -39.0], [-13.0, -19.0, 
-5.0, 14.0, -20.0], [-37.0, -14.0, -17.0, 29.0, 25.0]], [[53.0, 66.0, 6.0, -7.0, -16.0], [-3.0, 11.0, -23.0, 9.0, -37.0], 
[65.0, 25.0, -35.0, -2.0, 16.0], [35.0, 76.0, -17.0, -7.0, -11.0]], [[-2.0, 6.0, 42.0, 10.0, -44.0], [-6.0, 10.0, -16.0, -12.0, 
-44.0], [22.0, -28.0, -52.0, 44.0, 14.0], [-20.0, 26.0, 2.0, 4.0, 14.0]], [[2.0, 38.0, 34.0, -6.0, 16.0], [-34.0, 10.0, -52.0, 
32.0, 32.0], [-18.0, -20.0, -8.0, 20.0, 18.0], [-4.0, -22.0, 30.0, -20.0, -6.0]], [[-12.0, 11.0, 59.0, 9.0, -35.0], [-22.0, 
13.0, -37.0, 1.0, -23.0], [1.0, -44.0, -51.0, 56.0, 20.0], [-30.0, 1.0, 20.0, -4.0, 14.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      if not arg1.isLazy():
        arg0=arg0*1j
        arg1=arg1*1j
        ref=-ref
        res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
        self.assertTrue(isinstance(res,Data),"wrong type of result.")
        self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
        self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")        
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank4_offset2(self):
      arg0=numpy.array([[[[-6.0, -1.0, -3.0, -2.0, -7.0], [-1.0, -3.0, -6.0, 1.0, 3.0], [0.0, -1.0, -2.0, -5.0, 3.0], [-4.0, 
-5.0, 0.0, 1.0, -7.0]], [[-6.0, 2.0, 5.0, 3.0, -4.0], [-3.0, -3.0, -1.0, 1.0, 3.0], [-4.0, -3.0, -7.0, -5.0, -6.0], [-3.0, 
-7.0, 3.0, 1.0, -5.0]], [[0.0, -1.0, 2.0, 1.0, -5.0], [4.0, -7.0, 6.0, 4.0, -4.0], [-1.0, 1.0, -1.0, 6.0, -4.0], [-6.0, -1.0, 
0.0, 5.0, 6.0]]], [[[0.0, -4.0, 0.0, 4.0, -5.0], [-2.0, -4.0, 0.0, 3.0, 4.0], [2.0, 0.0, 6.0, -3.0, 3.0], [0.0, 2.0, -3.0, 
-3.0, -2.0]], [[1.0, 2.0, 3.0, 6.0, -4.0], [0.0, 3.0, -1.0, 7.0, -4.0], [-2.0, -3.0, -6.0, 6.0, 2.0], [-2.0, 1.0, -5.0, -3.0, 
-5.0]], [[7.0, -1.0, 0.0, 2.0, -7.0], [-2.0, 2.0, -7.0, -5.0, 3.0], [5.0, 6.0, 0.0, 4.0, 5.0], [4.0, 6.0, -5.0, 2.0, -1.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[[[-5.0, -3.0, 7.0, 4.0, -5.0], [7.0, -4.0, -1.0, 0.0, -6.0], [-3.0, -7.0, 2.0, -1.0, -5.0], 
[3.0, -2.0, -2.0, 5.0, 4.0]], [[-7.0, 7.0, 1.0, -3.0, 6.0], [2.0, -7.0, 0.0, 4.0, -5.0], [6.0, 0.0, 2.0, 0.0, 0.0], [-4.0, 
-1.0, 2.0, -6.0, 0.0]], [[-4.0, -3.0, 0.0, -5.0, -6.0], [2.0, 0.0, -7.0, -3.0, 3.0], [-2.0, -6.0, 3.0, 3.0, -3.0], [4.0, 0.0, 
-6.0, 1.0, 4.0]]], [[[3.0, 1.0, 6.0, -7.0, 0.0], [-7.0, 0.0, -7.0, 0.0, -7.0], [-7.0, 6.0, 4.0, -2.0, -6.0], [-5.0, -3.0, 6.0, 
-2.0, 7.0]], [[0.0, -3.0, -3.0, -4.0, 5.0], [-5.0, 5.0, -3.0, -6.0, 0.0], [-3.0, 1.0, 0.0, 0.0, -2.0], [-3.0, 7.0, 4.0, -7.0, 
-3.0]], [[-1.0, 2.0, -4.0, 6.0, -4.0], [5.0, 0.0, 0.0, -7.0, 0.0], [-1.0, -6.0, 2.0, 0.0, -3.0], [7.0, -1.0, -1.0, -1.0, 
-6.0]]]])+(1.-msk_arg1)*numpy.array([[[[-5.0, -1.0, -2.0, 1.0, 5.0], [7.0, 0.0, 0.0, -1.0, 0.0], [-6.0, -6.0, 5.0, -7.0, 0.0], 
[4.0, 1.0, 7.0, 5.0, 5.0]], [[0.0, 6.0, -2.0, 0.0, 3.0], [-2.0, 3.0, -2.0, -2.0, -5.0], [0.0, 0.0, -6.0, 4.0, 0.0], [-4.0, 0.0, 
2.0, 4.0, 4.0]], [[3.0, 5.0, 0.0, -3.0, 7.0], [4.0, 1.0, -1.0, -6.0, -1.0], [-6.0, 3.0, -5.0, -2.0, -7.0], [5.0, 0.0, -6.0, 
-4.0, -1.0]]], [[[-6.0, 0.0, 6.0, 1.0, 5.0], [0.0, -1.0, -6.0, -3.0, -5.0], [0.0, -5.0, -2.0, -7.0, 6.0], [3.0, -3.0, 2.0, 
-5.0, 3.0]], [[-6.0, 3.0, 2.0, 4.0, 0.0], [7.0, 2.0, 4.0, -4.0, 0.0], [4.0, 0.0, 5.0, -7.0, -7.0], [-7.0, -6.0, 0.0, 4.0, 
7.0]], [[7.0, 0.0, 3.0, -4.0, 4.0], [-5.0, 5.0, 0.0, -4.0, -2.0], [-5.0, -3.0, 6.0, -1.0, -6.0], [1.0, 5.0, 5.0, 1.0, -5.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[65.0, -13.0, -79.0, 32.0, -29.0], [-24.0, 71.0, 3.0, -79.0, 66.0], [-28.0, 1.0, -10.0, 6.0, 
7.0], [52.0, 18.0, -3.0, -8.0, -69.0]], [[-16.0, 8.0, -31.0, 9.0, 37.0], [8.0, 0.0, 30.0, 6.0, 21.0], [40.0, -3.0, -19.0, 6.0, 
31.0], [-8.0, 27.0, -3.0, -23.0, -36.0]], [[-28.0, 29.0, -25.0, -49.0, 48.0], [-22.0, -8.0, -20.0, -4.0, -1.0], [26.0, 12.0, 
10.0, 9.0, 3.0], [-30.0, 22.0, 16.0, -64.0, -13.0]], [[-5.0, 14.0, -13.0, -62.0, 44.0], [-54.0, 17.0, -51.0, -41.0, -28.0], 
[-26.0, 26.0, 25.0, -3.0, -35.0], [-38.0, 29.0, 50.0, -79.0, -6.0]], [[75.0, 1.0, -43.0, 18.0, 49.0], [-47.0, 36.0, 89.0, 72.0, 
82.0], [61.0, 87.0, -71.0, 2.0, 109.0], [-37.0, 12.0, -3.0, 29.0, -29.0]]], [[[6.0, -36.0, -14.0, -13.0, -29.0], [-1.0, 25.0, 
-13.0, -10.0, 47.0], [-7.0, -17.0, -8.0, 17.0, 11.0], [21.0, 13.0, -38.0, 23.0, 10.0]], [[50.0, 0.0, -65.0, 60.0, 46.0], 
[-18.0, 48.0, 71.0, -23.0, 40.0], [22.0, 30.0, -45.0, -10.0, 48.0], [0.0, 40.0, 28.0, -19.0, -89.0]], [[20.0, -18.0, -12.0, 
-89.0, 11.0], [-62.0, 26.0, -33.0, 33.0, 59.0], [10.0, 47.0, -10.0, 24.0, 35.0], [-36.0, 13.0, -23.0, -4.0, 45.0]], [[-14.0, 
-36.0, 25.0, -98.0, 32.0], [-64.0, 24.0, -71.0, -15.0, -20.0], [-42.0, 24.0, 18.0, 5.0, -34.0], [-56.0, 42.0, 27.0, -47.0, 
50.0]], [[-11.0, 46.0, 48.0, 29.0, -5.0], [26.0, -53.0, 9.0, 27.0, -73.0], [-2.0, 5.0, 22.0, -23.0, -28.0], [-6.0, -52.0, 29.0, 
10.0, 18.0]]], [[[33.0, -7.0, -6.0, 41.0, -48.0], [11.0, 18.0, -1.0, -36.0, 3.0], [-35.0, -14.0, 7.0, -7.0, -20.0], [43.0, 
-21.0, -3.0, 28.0, -14.0]], [[16.0, 0.0, -25.0, 48.0, -58.0], [34.0, 10.0, 3.0, -39.0, 24.0], [-14.0, -38.0, 7.0, 4.0, -10.0], 
[64.0, -22.0, -28.0, 29.0, -27.0]], [[81.0, -16.0, 33.0, 0.0, -56.0], [-42.0, 27.0, -15.0, 11.0, 2.0], [-58.0, 50.0, 3.0, 
-13.0, -11.0], [6.0, -49.0, 8.0, 61.0, 48.0]], [[23.0, -51.0, -92.0, -14.0, -27.0], [-22.0, 85.0, -34.0, -102.0, 94.0], [-28.0, 
-37.0, -6.0, 29.0, 1.0], [54.0, 62.0, -34.0, -29.0, -59.0]], [[47.0, -32.0, 7.0, 51.0, -37.0], [-5.0, 40.0, -2.0, -59.0, 
-21.0], [-69.0, -7.0, 4.0, -21.0, -40.0], [31.0, 0.0, 27.0, 22.0, -19.0]]], [[[61.0, 23.0, -41.0, 55.0, 12.0], [-16.0, 27.0, 
52.0, -10.0, 21.0], [8.0, 38.0, -24.0, -14.0, 30.0], [10.0, -7.0, 26.0, 2.0, -58.0]], [[78.0, -20.0, -57.0, 24.0, -30.0], 
[-40.0, 74.0, -5.0, -73.0, 48.0], [-48.0, 18.0, -7.0, -2.0, -4.0], [38.0, 12.0, 12.0, -1.0, -49.0]], [[-25.0, 23.0, 20.0, 2.0, 
13.0], [27.0, -46.0, 36.0, 77.0, 6.0], [59.0, 7.0, -16.0, 6.0, 43.0], [-17.0, -24.0, -27.0, 28.0, 24.0]], [[-43.0, -1.0, -9.0, 
21.0, -52.0], [65.0, -26.0, -6.0, -7.0, 25.0], [21.0, -70.0, 11.0, 20.0, -2.0], [57.0, -17.0, -62.0, 29.0, 0.0]], [[41.0, 
-21.0, -47.0, -15.0, -52.0], [-13.0, 38.0, -6.0, -1.0, 99.0], [9.0, 2.0, -16.0, 29.0, 42.0], [41.0, -9.0, -63.0, 41.0, 
3.0]]]])+(1.-msk_ref)*numpy.array([[[[73.0, -27.0, 47.0, -30.0, -20.0], [-58.0, 19.0, 16.0, -14.0, 16.0], [5.0, 15.0, 53.0, 
4.0, -49.0], [0.0, 23.0, -19.0, -43.0, -82.0]], [[7.0, 14.0, -25.0, 10.0, -30.0], [4.0, 8.0, 29.0, 11.0, 13.0], [25.0, 26.0, 
0.0, 32.0, -25.0], [-44.0, -6.0, -10.0, 34.0, 11.0]], [[3.0, 52.0, 2.0, 3.0, 14.0], [-2.0, 23.0, 0.0, -31.0, -27.0], [18.0, 
24.0, -40.0, 16.0, -35.0], [-43.0, -21.0, -23.0, 9.0, 24.0]], [[-33.0, 43.0, 40.0, 15.0, 34.0], [16.0, 28.0, -7.0, -54.0, 
-40.0], [20.0, -11.0, 1.0, -48.0, -37.0], [-43.0, -40.0, 4.0, 4.0, 45.0]], [[25.0, -54.0, -37.0, 15.0, -135.0], [-54.0, -55.0, 
27.0, 104.0, 64.0], [91.0, 73.0, -38.0, 113.0, 75.0], [-31.0, -3.0, -72.0, -29.0, -54.0]]], [[[15.0, 3.0, -10.0, -7.0, -4.0], 
[25.0, -13.0, 14.0, -3.0, 25.0], [-8.0, 34.0, -15.0, 3.0, -28.0], [20.0, -5.0, -51.0, -25.0, -17.0]], [[14.0, -41.0, 0.0, 18.0, 
-85.0], [-32.0, 4.0, 49.0, 43.0, 38.0], [62.0, 11.0, 73.0, 28.0, -8.0], [-66.0, 1.0, 17.0, 35.0, -21.0]], [[5.0, 27.0, -9.0, 
0.0, -19.0], [12.0, -34.0, -8.0, 4.0, 13.0], [31.0, 75.0, -101.0, 40.0, 7.0], [10.0, -35.0, -115.0, -69.0, -12.0]], [[-88.0, 
46.0, 13.0, 40.0, 31.0], [95.0, -7.0, 4.0, -44.0, -14.0], [23.0, 6.0, -22.0, -76.0, -29.0], [-25.0, -75.0, -34.0, 1.0, 88.0]], 
[[-6.0, -17.0, 13.0, -9.0, 28.0], [-44.0, 8.0, -42.0, 7.0, -37.0], [-25.0, -59.0, 7.0, -4.0, 62.0], [23.0, 30.0, 74.0, 10.0, 
0.0]]], [[[32.0, -35.0, 31.0, -23.0, 11.0], [-35.0, 6.0, -11.0, -4.0, 1.0], [-27.0, -28.0, 45.0, -19.0, 3.0], [36.0, 31.0, 
27.0, -25.0, -48.0]], [[68.0, -21.0, 20.0, -40.0, 17.0], [-48.0, 16.0, -7.0, -11.0, 2.0], [-42.0, -9.0, 29.0, 8.0, -22.0], 
[40.0, 47.0, 11.0, -27.0, -69.0]], [[7.0, -63.0, 42.0, -17.0, -8.0], [-46.0, -40.0, -45.0, 28.0, 6.0], [-6.0, -21.0, -5.0, 
-12.0, 85.0], [75.0, 16.0, -10.0, -88.0, -61.0]], [[53.0, 23.0, 26.0, -18.0, 3.0], [21.0, 26.0, 46.0, -52.0, 26.0], [-2.0, 
51.0, 35.0, -22.0, -126.0], [-17.0, -12.0, -67.0, -26.0, -38.0]], [[-22.0, -53.0, 43.0, 6.0, 4.0], [6.0, 4.0, 6.0, -4.0, 9.0], 
[-11.0, -60.0, 105.0, -77.0, 2.0], [16.0, 7.0, 64.0, 5.0, -7.0]]], [[[42.0, -50.0, 22.0, -10.0, -55.0], [-80.0, 1.0, 4.0, 38.0, 
13.0], [32.0, -6.0, 42.0, 38.0, 32.0], [-16.0, 28.0, 22.0, -12.0, -60.0]], [[46.0, -39.0, 56.0, -20.0, -19.0], [-48.0, 8.0, 
7.0, -9.0, 14.0], [10.0, -1.0, 59.0, -18.0, -24.0], [8.0, 13.0, -9.0, -49.0, -69.0]], [[13.0, 3.0, -49.0, -3.0, -26.0], [-16.0, 
-23.0, -8.0, 43.0, 10.0], [5.0, 30.0, -67.0, 73.0, 47.0], [9.0, 14.0, -25.0, 2.0, -7.0]], [[60.0, 21.0, -22.0, -37.0, 36.0], 
[-6.0, 15.0, -1.0, -20.0, 1.0], [-58.0, 18.0, -23.0, 27.0, -44.0], [39.0, 38.0, -17.0, -6.0, -36.0]], [[88.0, -8.0, -1.0, 
-43.0, -22.0], [-45.0, -22.0, -4.0, 11.0, 31.0], [-9.0, 73.0, -62.0, 67.0, -13.0], [50.0, 24.0, -104.0, -90.0, -97.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_float_rank0_offset0(self):
      arg0=numpy.array([[[-6.0, -7.0], [-7.0, -1.0]], [[1.0, -3.0], [7.0, -6.0]], [[-2.0, 7.0], [6.0, 7.0]], [[-3.0, -3.0], 
[-2.0, 4.0]], [[-3.0, 5.0], [-3.0, -7.0]], [[-7.0, -1.0], [3.0, 2.0]]])
      arg1=0.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[-0.0, -0.0], [-0.0, -0.0]], [[0.0, -0.0], [0.0, -0.0]], [[-0.0, 0.0], [0.0, 0.0]], [[-0.0, -0.0], 
[-0.0, 0.0]], [[-0.0, 0.0], [-0.0, -0.0]], [[-0.0, -0.0], [0.0, 0.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank0_offset0(self):
      arg0=numpy.array([[[3.0, -4.0], [-1.0, 6.0]], [[-4.0, -4.0], [-5.0, 7.0]], [[2.0, 4.0], [0.0, 0.0]], [[-4.0, -1.0], [6.0, 
7.0]], [[6.0, 5.0], [1.0, 0.0]], [[2.0, -1.0], [6.0, 4.0]]])
      arg1=numpy.array(0.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[0.0, -0.0], [-0.0, 0.0]], [[-0.0, -0.0], [-0.0, 0.0]], [[0.0, 0.0], [0.0, 0.0]], [[-0.0, -0.0], [0.0, 
0.0]], [[0.0, 0.0], [0.0, 0.0]], [[0.0, -0.0], [0.0, 0.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank1_offset1(self):
      arg0=numpy.array([[[[6.0, -6.0], [-1.0, -5.0]], [[0.0, 4.0], [3.0, 5.0]], [[5.0, -3.0], [6.0, 6.0]], [[7.0, -5.0], [-1.0, 
4.0]], [[0.0, -4.0], [2.0, 0.0]], [[6.0, -2.0], [2.0, -4.0]]], [[[6.0, -4.0], [-5.0, 0.0]], [[-2.0, 0.0], [6.0, 4.0]], [[5.0, 
-5.0], [-6.0, 0.0]], [[4.0, -1.0], [5.0, 3.0]], [[7.0, 1.0], [3.0, -6.0]], [[-7.0, -6.0], [-1.0, -4.0]]], [[[5.0, 3.0], [-2.0, 
6.0]], [[-2.0, 3.0], [-7.0, 7.0]], [[2.0, 7.0], [2.0, 3.0]], [[-6.0, 7.0], [3.0, -6.0]], [[0.0, 2.0], [0.0, -3.0]], [[-3.0, 
3.0], [0.0, -4.0]]]])
      arg1=numpy.array([-7.0, 6.0, -7.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[-41.0, -3.0], [-9.0, -7.0]], [[2.0, -49.0], [64.0, -60.0]], [[-19.0, -58.0], [-92.0, -63.0]], [[17.0, 
-20.0], [16.0, 32.0]], [[42.0, 20.0], [4.0, -15.0]], [[-63.0, -43.0], [-20.0, 32.0]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_array_rank1_offset0(self):
      arg0=numpy.array([[[-7.0, 1.0], [5.0, -6.0]], [[1.0, -6.0], [2.0, 7.0]], [[1.0, 7.0], [-3.0, -4.0]], [[2.0, 1.0], [-3.0, 
0.0]], [[1.0, 2.0], [-1.0, 0.0]], [[-3.0, 1.0], [0.0, 0.0]]])
      arg1=numpy.array([4.0, 5.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[-28.0, -35.0], [4.0, 5.0]], [[20.0, 25.0], [-24.0, -30.0]]], [[[4.0, 5.0], [-24.0, -30.0]], [[8.0, 
10.0], [28.0, 35.0]]], [[[4.0, 5.0], [28.0, 35.0]], [[-12.0, -15.0], [-16.0, -20.0]]], [[[8.0, 10.0], [4.0, 5.0]], [[-12.0, 
-15.0], [0.0, 0.0]]], [[[4.0, 5.0], [8.0, 10.0]], [[-4.0, -5.0], [0.0, 0.0]]], [[[-12.0, -15.0], [4.0, 5.0]], [[0.0, 0.0], 
[0.0, 0.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank2_offset1(self):
      arg0=numpy.array([[[[-6.0, -6.0], [-6.0, 7.0]], [[5.0, 7.0], [5.0, 4.0]], [[-7.0, 5.0], [-1.0, -2.0]], [[2.0, -2.0], 
[-7.0, -5.0]], [[4.0, 5.0], [4.0, -7.0]], [[4.0, -2.0], [7.0, -1.0]]], [[[4.0, -4.0], [7.0, 4.0]], [[6.0, 0.0], [-1.0, -2.0]], 
[[6.0, 4.0], [7.0, -5.0]], [[2.0, -4.0], [3.0, -7.0]], [[-7.0, 0.0], [-3.0, 1.0]], [[-6.0, 0.0], [-4.0, 7.0]]], [[[-5.0, -7.0], 
[-5.0, -6.0]], [[4.0, 6.0], [0.0, -6.0]], [[5.0, -1.0], [-7.0, -3.0]], [[-1.0, 0.0], [1.0, 0.0]], [[3.0, 1.0], [1.0, -7.0]], 
[[6.0, 6.0], [7.0, 0.0]]]])
      arg1=numpy.array([[0.0, -3.0], [-1.0, -7.0], [1.0, -4.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=numpy.array([[[[-9.0, 10.0], [-3.0, 74.0]], [[-12.0, -11.0], [-10.0, -25.0]]], [[[-2.0, -73.0], [6.0, -45.0]], [[1.0, 
-8.0], [-4.0, 26.0]]], [[[-1.0, -41.0], [-5.0, -39.0]], [[-14.0, -18.0], [2.0, 53.0]]], [[[-3.0, -16.0], [4.0, 34.0]], [[-2.0, 
-4.0], [7.0, 64.0]]], [[[10.0, 25.0], [1.0, -19.0]], [[4.0, 5.0], [-8.0, 42.0]]], [[[12.0, 6.0], [6.0, -18.0]], [[11.0, -21.0], 
[-7.0, -46.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank0_offset0(self):
      arg0=numpy.array([[[-6.0, 7.0], [-1.0, -1.0]], [[-4.0, 3.0], [0.0, 3.0]], [[-4.0, 0.0], [1.0, 6.0]], [[0.0, 4.0], [4.0, 
0.0]], [[5.0, -7.0], [4.0, 5.0]], [[-4.0, -2.0], [-4.0, 5.0]]])
      arg1=Data(5.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[-30.0, 35.0], [-5.0, -5.0]], [[-20.0, 15.0], [0.0, 15.0]], [[-20.0, 0.0], [5.0, 30.0]], [[0.0, 
20.0], [20.0, 0.0]], [[25.0, -35.0], [20.0, 25.0]], [[-20.0, -10.0], [-20.0, 25.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank1_offset1(self):
      arg0=numpy.array([[[[2.0, -4.0], [4.0, 2.0]], [[5.0, 0.0], [5.0, 5.0]], [[-4.0, 4.0], [-1.0, -4.0]], [[-1.0, 2.0], [6.0, 
7.0]], [[-4.0, -5.0], [3.0, -4.0]], [[6.0, 1.0], [-3.0, 7.0]]], [[[-1.0, 1.0], [-2.0, -1.0]], [[3.0, 5.0], [-7.0, 0.0]], 
[[-5.0, -6.0], [-6.0, 5.0]], [[2.0, -1.0], [7.0, 0.0]], [[1.0, 3.0], [-4.0, -1.0]], [[-3.0, -7.0], [7.0, -5.0]]], [[[3.0, 0.0], 
[-4.0, 6.0]], [[0.0, -1.0], [-3.0, 4.0]], [[6.0, 5.0], [5.0, 2.0]], [[5.0, 5.0], [0.0, -5.0]], [[7.0, -2.0], [6.0, 0.0]], 
[[-1.0, -6.0], [4.0, 2.0]]]])
      arg1=Data(numpy.array([7.0, -3.0, 3.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[26.0, -31.0], [22.0, 35.0]], [[26.0, -18.0], [47.0, 47.0]], [[5.0, 61.0], [26.0, -37.0]], [[2.0, 
32.0], [21.0, 34.0]], [[-10.0, -50.0], [51.0, -25.0]], [[48.0, 10.0], [-30.0, 70.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_constData_rank1_offset0(self):
      arg0=numpy.array([[[1.0, -2.0], [-4.0, 2.0]], [[6.0, 2.0], [-5.0, 7.0]], [[5.0, 6.0], [4.0, 2.0]], [[5.0, -7.0], [-7.0, 
-1.0]], [[1.0, 6.0], [7.0, -6.0]], [[-6.0, 0.0], [7.0, 0.0]]])
      arg1=Data(numpy.array([2.0, -5.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[2.0, -5.0], [-4.0, 10.0]], [[-8.0, 20.0], [4.0, -10.0]]], [[[12.0, -30.0], [4.0, -10.0]], 
[[-10.0, 25.0], [14.0, -35.0]]], [[[10.0, -25.0], [12.0, -30.0]], [[8.0, -20.0], [4.0, -10.0]]], [[[10.0, -25.0], [-14.0, 
35.0]], [[-14.0, 35.0], [-2.0, 5.0]]], [[[2.0, -5.0], [12.0, -30.0]], [[14.0, -35.0], [-12.0, 30.0]]], [[[-12.0, 30.0], [0.0, 
0.0]], [[14.0, -35.0], [0.0, 0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank2_offset1(self):
      arg0=numpy.array([[[[-6.0, 4.0], [5.0, -5.0]], [[-3.0, 5.0], [3.0, 1.0]], [[3.0, 4.0], [-7.0, 3.0]], [[-2.0, -1.0], [3.0, 
4.0]], [[7.0, 1.0], [-7.0, 1.0]], [[-4.0, 3.0], [-2.0, -3.0]]], [[[-5.0, 5.0], [0.0, 4.0]], [[-2.0, 0.0], [-2.0, 7.0]], [[-6.0, 
1.0], [-3.0, -3.0]], [[5.0, -3.0], [0.0, -4.0]], [[-2.0, 7.0], [3.0, -6.0]], [[2.0, -6.0], [-7.0, 1.0]]], [[[7.0, -1.0], [0.0, 
1.0]], [[0.0, 5.0], [2.0, -5.0]], [[2.0, 0.0], [0.0, 0.0]], [[-7.0, 2.0], [2.0, 0.0]], [[-4.0, -1.0], [-2.0, -6.0]], [[3.0, 
-5.0], [1.0, -5.0]]]])
      arg1=Data(numpy.array([[-2.0, 5.0], [-1.0, 3.0], [-5.0, -4.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[[-18.0, -73.0], [-8.0, 39.0]], [[-10.0, 25.0], [1.0, -17.0]]], [[[8.0, -21.0], [-35.0, 5.0]], 
[[-14.0, 1.0], [16.0, 46.0]]], [[[-10.0, -11.0], [-9.0, 23.0]], [[17.0, -44.0], [-3.0, 6.0]]], [[[34.0, 33.0], [-5.0, -22.0]], 
[[-16.0, 7.0], [-4.0, 8.0]]], [[[8.0, 45.0], [-4.0, 30.0]], [[21.0, -18.0], [34.0, 11.0]]], [[[-9.0, -26.0], [25.0, 17.0]], 
[[6.0, -35.0], [30.0, 8.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank0_offset0(self):
      arg0=numpy.array([[[0.0, -3.0], [1.0, 4.0]], [[-7.0, -2.0], [2.0, 1.0]], [[0.0, 0.0], [3.0, 5.0]], [[2.0, 1.0], [-4.0, 
3.0]], [[0.0, 5.0], [-6.0, -1.0]], [[1.0, -2.0], [-3.0, -6.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(7.0)+(1-msk_arg1)*(-3.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.0, -21.0], [7.0, 28.0]], [[-49.0, -14.0], [14.0, 7.0]], [[0.0, 0.0], [21.0, 35.0]], [[14.0, 
7.0], [-28.0, 21.0]], [[0.0, 35.0], [-42.0, -7.0]], [[7.0, -14.0], [-21.0, -42.0]]])+(1.-msk_ref)*numpy.array([[[-0.0, 9.0], 
[-3.0, -12.0]], [[21.0, 6.0], [-6.0, -3.0]], [[-0.0, -0.0], [-9.0, -15.0]], [[-6.0, -3.0], [12.0, -9.0]], [[-0.0, -15.0], 
[18.0, 3.0]], [[-3.0, 6.0], [9.0, 18.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank1_offset1(self):
      arg0=numpy.array([[[[5.0, 1.0], [0.0, 3.0]], [[0.0, 7.0], [2.0, -3.0]], [[0.0, 5.0], [-3.0, 1.0]], [[-2.0, 1.0], [-7.0, 
-5.0]], [[6.0, -2.0], [-7.0, 2.0]], [[2.0, -4.0], [-3.0, -7.0]]], [[[-3.0, -4.0], [-5.0, -5.0]], [[-4.0, -2.0], [-6.0, 1.0]], 
[[-6.0, -3.0], [0.0, 7.0]], [[3.0, 2.0], [3.0, -4.0]], [[1.0, 2.0], [-4.0, 7.0]], [[0.0, -2.0], [-3.0, -3.0]]], [[[1.0, 6.0], 
[-6.0, 0.0]], [[-2.0, -5.0], [-7.0, -6.0]], [[0.0, -7.0], [-2.0, -2.0]], [[-5.0, 1.0], [0.0, 6.0]], [[-4.0, -7.0], [-1.0, 
3.0]], [[-2.0, -3.0], [-5.0, -2.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([-1.0, -5.0, 1.0])+(1.-msk_arg1)*numpy.array([-2.0, -4.0, 7.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[11.0, 25.0], [19.0, 22.0]], [[18.0, -2.0], [21.0, -8.0]], [[30.0, 3.0], [1.0, -38.0]], 
[[-18.0, -10.0], [-8.0, 31.0]], [[-15.0, -15.0], [26.0, -34.0]], [[-4.0, 11.0], [13.0, 
20.0]]])+(1.-msk_ref)*numpy.array([[[9.0, 56.0], [-22.0, 14.0]], [[2.0, -41.0], [-29.0, -40.0]], [[24.0, -47.0], [-8.0, 
-44.0]], [[-43.0, -3.0], [2.0, 68.0]], [[-44.0, -53.0], [23.0, -11.0]], [[-18.0, -5.0], [-17.0, 12.0]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank3_expandedData_rank1_offset0(self):
      arg0=numpy.array([[[1.0, 0.0], [5.0, 0.0]], [[-6.0, -5.0], [4.0, 1.0]], [[5.0, -7.0], [-7.0, -2.0]], [[-7.0, -6.0], [7.0, 
-7.0]], [[6.0, -1.0], [-4.0, -1.0]], [[-5.0, -6.0], [-3.0, 3.0]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([0.0, -2.0])+(1.-msk_arg1)*numpy.array([-3.0, 2.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[0.0, -2.0], [0.0, 0.0]], [[0.0, -10.0], [0.0, 0.0]]], [[[0.0, 12.0], [0.0, 10.0]], [[0.0, 
-8.0], [0.0, -2.0]]], [[[0.0, -10.0], [0.0, 14.0]], [[0.0, 14.0], [0.0, 4.0]]], [[[0.0, 14.0], [0.0, 12.0]], [[0.0, -14.0], 
[0.0, 14.0]]], [[[0.0, -12.0], [0.0, 2.0]], [[0.0, 8.0], [0.0, 2.0]]], [[[0.0, 10.0], [0.0, 12.0]], [[0.0, 6.0], [0.0, 
-6.0]]]])+(1.-msk_ref)*numpy.array([[[[-3.0, 2.0], [0.0, 0.0]], [[-15.0, 10.0], [0.0, 0.0]]], [[[18.0, -12.0], [15.0, -10.0]], 
[[-12.0, 8.0], [-3.0, 2.0]]], [[[-15.0, 10.0], [21.0, -14.0]], [[21.0, -14.0], [6.0, -4.0]]], [[[21.0, -14.0], [18.0, -12.0]], 
[[-21.0, 14.0], [21.0, -14.0]]], [[[-18.0, 12.0], [3.0, -2.0]], [[12.0, -8.0], [3.0, -2.0]]], [[[15.0, -10.0], [18.0, -12.0]], 
[[9.0, -6.0], [-9.0, 6.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank2_offset1(self):
      arg0=numpy.array([[[[-5.0, -1.0], [-6.0, 5.0]], [[5.0, 5.0], [7.0, -2.0]], [[4.0, -2.0], [-3.0, 0.0]], [[-6.0, 3.0], 
[5.0, 1.0]], [[-3.0, 3.0], [0.0, 1.0]], [[6.0, 3.0], [-2.0, -6.0]]], [[[3.0, -1.0], [2.0, 1.0]], [[4.0, 1.0], [7.0, 5.0]], 
[[7.0, 3.0], [0.0, 0.0]], [[7.0, -2.0], [-5.0, -1.0]], [[0.0, 7.0], [-3.0, 7.0]], [[6.0, 2.0], [-6.0, 1.0]]], [[[6.0, 6.0], 
[-6.0, -3.0]], [[2.0, 2.0], [-6.0, -3.0]], [[0.0, 7.0], [-5.0, 4.0]], [[4.0, -4.0], [7.0, 6.0]], [[-6.0, -3.0], [3.0, 0.0]], 
[[4.0, -4.0], [-7.0, 5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*numpy.array([[-7.0, 0.0], [-3.0, 0.0], [-7.0, 1.0]])+(1.-msk_arg1)*numpy.array([[-4.0, 1.0], [-7.0, -7.0], 
[-6.0, -4.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-16.0, 6.0], [-32.0, 6.0]], [[78.0, -6.0], [-17.0, -3.0]]], [[[-61.0, 2.0], [-52.0, 2.0]], 
[[-28.0, -6.0], [20.0, -3.0]]], [[[-49.0, 0.0], [-44.0, 7.0]], [[56.0, -5.0], [-28.0, 4.0]]], [[[-7.0, 4.0], [13.0, -4.0]], 
[[-69.0, 7.0], [-46.0, 6.0]]], [[[63.0, -6.0], [-21.0, -3.0]], [[-12.0, 3.0], [-28.0, 0.0]]], [[[-88.0, 4.0], [1.0, -4.0]], 
[[81.0, -7.0], [4.0, 5.0]]]])+(1.-msk_ref)*numpy.array([[[[-37.0, -50.0], [-25.0, -18.0]], [[46.0, 4.0], [-9.0, 10.0]]], 
[[[-60.0, -31.0], [-39.0, -10.0]], [[-41.0, -18.0], [-9.0, -25.0]]], [[[-65.0, -45.0], [-55.0, -51.0]], [[42.0, 17.0], [-24.0, 
-16.0]]], [[[-49.0, -71.0], [26.0, 33.0]], [[-27.0, 12.0], [-33.0, -16.0]]], [[[48.0, 21.0], [-43.0, -34.0]], [[3.0, 9.0], 
[-53.0, -48.0]]], [[[-90.0, -52.0], [-2.0, 5.0]], [[92.0, 68.0], [-13.0, -33.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_float_rank0_offset0(self):
      arg0=numpy.array([[[[5.0, 6.0, 3.0, 5.0], [0.0, 2.0, 3.0, -4.0], [-1.0, 6.0, 6.0, -7.0]], [[-7.0, 0.0, 7.0, -7.0], [4.0, 
7.0, -5.0, 0.0], [-4.0, -6.0, -2.0, -3.0]]], [[[-6.0, -3.0, -4.0, 5.0], [1.0, 0.0, -7.0, 6.0], [2.0, -1.0, -1.0, 7.0]], [[2.0, 
0.0, 4.0, 3.0], [-4.0, -6.0, 0.0, 0.0], [-2.0, 7.0, -2.0, -3.0]]], [[[-3.0, -5.0, -6.0, -1.0], [-1.0, 0.0, -6.0, 1.0], [5.0, 
-3.0, 0.0, -6.0]], [[-1.0, 1.0, 7.0, -7.0], [-6.0, 7.0, 5.0, 5.0], [3.0, 7.0, 3.0, -7.0]]]])
      arg1=7.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[35.0, 42.0, 21.0, 35.0], [0.0, 14.0, 21.0, -28.0], [-7.0, 42.0, 42.0, -49.0]], [[-49.0, 0.0, 49.0, 
-49.0], [28.0, 49.0, -35.0, 0.0], [-28.0, -42.0, -14.0, -21.0]]], [[[-42.0, -21.0, -28.0, 35.0], [7.0, 0.0, -49.0, 42.0], 
[14.0, -7.0, -7.0, 49.0]], [[14.0, 0.0, 28.0, 21.0], [-28.0, -42.0, 0.0, 0.0], [-14.0, 49.0, -14.0, -21.0]]], [[[-21.0, -35.0, 
-42.0, -7.0], [-7.0, 0.0, -42.0, 7.0], [35.0, -21.0, 0.0, -42.0]], [[-7.0, 7.0, 49.0, -49.0], [-42.0, 49.0, 35.0, 35.0], [21.0, 
49.0, 21.0, -49.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_array_rank0_offset0(self):
      arg0=numpy.array([[[[4.0, -5.0, -7.0, 5.0], [0.0, -1.0, 0.0, 2.0], [2.0, -4.0, 0.0, 2.0]], [[-1.0, 3.0, -4.0, -4.0], 
[0.0, 6.0, -7.0, 5.0], [0.0, 7.0, -1.0, -4.0]]], [[[5.0, 5.0, 7.0, -7.0], [0.0, 7.0, 0.0, -4.0], [0.0, 2.0, 6.0, 5.0]], [[0.0, 
1.0, -4.0, 6.0], [0.0, -3.0, -6.0, 4.0], [-4.0, 6.0, -4.0, 2.0]]], [[[-6.0, 1.0, 0.0, -3.0], [1.0, -7.0, 6.0, -4.0], [1.0, 
-1.0, -1.0, 0.0]], [[-7.0, 6.0, 0.0, 4.0], [-7.0, -2.0, -4.0, -6.0], [-3.0, 4.0, 2.0, -6.0]]]])
      arg1=numpy.array(-4.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=numpy.array([[[[-16.0, 20.0, 28.0, -20.0], [-0.0, 4.0, -0.0, -8.0], [-8.0, 16.0, -0.0, -8.0]], [[4.0, -12.0, 16.0, 
16.0], [-0.0, -24.0, 28.0, -20.0], [-0.0, -28.0, 4.0, 16.0]]], [[[-20.0, -20.0, -28.0, 28.0], [-0.0, -28.0, -0.0, 16.0], [-0.0, 
-8.0, -24.0, -20.0]], [[-0.0, -4.0, 16.0, -24.0], [-0.0, 12.0, 24.0, -16.0], [16.0, -24.0, 16.0, -8.0]]], [[[24.0, -4.0, -0.0, 
12.0], [-4.0, 28.0, -24.0, 16.0], [-4.0, 4.0, 4.0, -0.0]], [[28.0, -24.0, -0.0, -16.0], [28.0, 8.0, 16.0, 24.0], [12.0, -16.0, 
-8.0, 24.0]]]])
      self.assertTrue(isinstance(res,numpy.ndarray),"wrong type of result.")
      self.assertEqual(res.shape,(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_constData_rank0_offset0(self):
      arg0=numpy.array([[[[-4.0, -6.0, 1.0, 3.0], [0.0, -7.0, -3.0, 6.0], [-5.0, 2.0, 1.0, 6.0]], [[-7.0, -7.0, 4.0, 2.0], 
[3.0, 1.0, 3.0, 1.0], [0.0, 0.0, 5.0, -2.0]]], [[[-1.0, 1.0, -1.0, -1.0], [7.0, 0.0, -4.0, -1.0], [5.0, 0.0, 7.0, -5.0]], 
[[4.0, 3.0, -7.0, 7.0], [2.0, 0.0, 4.0, 3.0], [-1.0, 3.0, -2.0, -5.0]]], [[[-5.0, 3.0, -5.0, -3.0], [0.0, -1.0, 3.0, 6.0], 
[-5.0, -3.0, -5.0, 1.0]], [[-1.0, 0.0, 1.0, -5.0], [1.0, -4.0, -5.0, -4.0], [-5.0, 4.0, 0.0, 3.0]]]])
      arg1=Data(7.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-28.0, -42.0, 7.0, 21.0], [0.0, -49.0, -21.0, 42.0], [-35.0, 14.0, 7.0, 42.0]], [[-49.0, -49.0, 
28.0, 14.0], [21.0, 7.0, 21.0, 7.0], [0.0, 0.0, 35.0, -14.0]]], [[[-7.0, 7.0, -7.0, -7.0], [49.0, 0.0, -28.0, -7.0], [35.0, 
0.0, 49.0, -35.0]], [[28.0, 21.0, -49.0, 49.0], [14.0, 0.0, 28.0, 21.0], [-7.0, 21.0, -14.0, -35.0]]], [[[-35.0, 21.0, -35.0, 
-21.0], [0.0, -7.0, 21.0, 42.0], [-35.0, -21.0, -35.0, 7.0]], [[-7.0, 0.0, 7.0, -35.0], [7.0, -28.0, -35.0, -28.0], [-35.0, 
28.0, 0.0, 21.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_array_rank4_expandedData_rank0_offset0(self):
      arg0=numpy.array([[[[3.0, 5.0, 6.0, 1.0], [3.0, 0.0, 6.0, -5.0], [4.0, 6.0, 0.0, -4.0]], [[-7.0, 0.0, 0.0, -5.0], [6.0, 
5.0, -7.0, -2.0], [-5.0, -6.0, -5.0, -6.0]]], [[[0.0, 6.0, 0.0, 3.0], [-4.0, 2.0, 3.0, 0.0], [-4.0, -3.0, 3.0, 5.0]], [[4.0, 
7.0, -1.0, -5.0], [0.0, 7.0, -5.0, -5.0], [-3.0, -1.0, 6.0, 6.0]]], [[[-7.0, 4.0, -2.0, 2.0], [3.0, 5.0, 7.0, -4.0], [5.0, 3.0, 
-5.0, -2.0]], [[4.0, -2.0, 3.0, 0.0], [-1.0, -5.0, -3.0, -4.0], [-6.0, 4.0, 7.0, -5.0]]]])
      msk_arg1=1-whereZero(self.functionspace.getX()[0],1.e-8)
      arg1=msk_arg1*(2.0)+(1-msk_arg1)*(-5.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      msk_ref=1-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[6.0, 10.0, 12.0, 2.0], [6.0, 0.0, 12.0, -10.0], [8.0, 12.0, 0.0, -8.0]], [[-14.0, 0.0, 0.0, 
-10.0], [12.0, 10.0, -14.0, -4.0], [-10.0, -12.0, -10.0, -12.0]]], [[[0.0, 12.0, 0.0, 6.0], [-8.0, 4.0, 6.0, 0.0], [-8.0, -6.0, 
6.0, 10.0]], [[8.0, 14.0, -2.0, -10.0], [0.0, 14.0, -10.0, -10.0], [-6.0, -2.0, 12.0, 12.0]]], [[[-14.0, 8.0, -4.0, 4.0], [6.0, 
10.0, 14.0, -8.0], [10.0, 6.0, -10.0, -4.0]], [[8.0, -4.0, 6.0, 0.0], [-2.0, -10.0, -6.0, -8.0], [-12.0, 8.0, 14.0, 
-10.0]]]])+(1.-msk_ref)*numpy.array([[[[-15.0, -25.0, -30.0, -5.0], [-15.0, -0.0, -30.0, 25.0], [-20.0, -30.0, -0.0, 20.0]], 
[[35.0, -0.0, -0.0, 25.0], [-30.0, -25.0, 35.0, 10.0], [25.0, 30.0, 25.0, 30.0]]], [[[-0.0, -30.0, -0.0, -15.0], [20.0, -10.0, 
-15.0, -0.0], [20.0, 15.0, -15.0, -25.0]], [[-20.0, -35.0, 5.0, 25.0], [-0.0, -35.0, 25.0, 25.0], [15.0, 5.0, -30.0, -30.0]]], 
[[[35.0, -20.0, 10.0, -10.0], [-15.0, -25.0, -35.0, 20.0], [-25.0, -15.0, 25.0, 10.0]], [[-20.0, 10.0, -15.0, -0.0], [5.0, 
25.0, 15.0, 20.0], [30.0, -20.0, -35.0, 25.0]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_float_rank0_offset0(self):
      arg0=Data(-1.0,self.functionspace)
      arg1=5.0
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-5.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_array_rank0_offset0(self):
      arg0=Data(2.0,self.functionspace)
      arg1=numpy.array(-4.0)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(-8.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_array_rank1_offset1(self):
      arg0=Data(numpy.array([3.0, -2.0, 6.0]),self.functionspace)
      arg1=numpy.array([-3.0, -7.0, -2.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(-7.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
      arg0=arg0*1j
      arg1=arg1*1j
      ref=-ref
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")      
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank2_array_rank2_offset2(self):
      arg0=Data(numpy.array([[-7.0, -2.0, 0.0], [-5.0, 0.0, -3.0]]),self.functionspace)
      arg1=numpy.array([[5.0, -5.0, 0.0], [-1.0, 0.0, -1.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(-17.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank3_array_rank3_offset3(self):
      arg0=Data(numpy.array([[[-3.0, 4.0, -1.0], [-3.0, 7.0, 1.0], [-6.0, 6.0, -7.0], [6.0, 7.0, -5.0]], [[-6.0, 7.0, 1.0], 
[3.0, -7.0, -1.0], [6.0, 4.0, -1.0], [-4.0, 7.0, 6.0]]]),self.functionspace)
      arg1=numpy.array([[[-5.0, -4.0, -5.0], [7.0, 0.0, -5.0], [-6.0, -3.0, -5.0], [-7.0, -3.0, 4.0]], [[-4.0, 1.0, 4.0], [3.0, 
3.0, -5.0], [2.0, 0.0, 6.0], [-4.0, 5.0, -6.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(-3.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank4_array_rank4_offset4(self):
      arg0=Data(numpy.array([[[[-7.0, -5.0], [-3.0, -4.0], [-1.0, 3.0]], [[0.0, -7.0], [-1.0, 0.0], [-5.0, 0.0]]], [[[0.0, 
5.0], [5.0, 1.0], [-5.0, 7.0]], [[3.0, -7.0], [-7.0, 5.0], [-6.0, 0.0]]], [[[-6.0, -3.0], [-4.0, 2.0], [5.0, 0.0]], [[-1.0, 
-5.0], [-2.0, 6.0], [6.0, 6.0]]], [[[-5.0, 5.0], [5.0, -2.0], [3.0, -7.0]], [[-4.0, -7.0], [1.0, 5.0], [0.0, 
-4.0]]]]),self.functionspace)
      arg1=numpy.array([[[[4.0, 6.0], [-1.0, 0.0], [-6.0, -5.0]], [[5.0, 6.0], [5.0, 6.0], [4.0, -7.0]]], [[[-2.0, -6.0], 
[-2.0, 6.0], [-1.0, -3.0]], [[-4.0, 4.0], [3.0, 0.0], [1.0, 0.0]]], [[[-5.0, 0.0], [7.0, 1.0], [-7.0, 0.0]], [[-7.0, -3.0], 
[-2.0, 0.0], [6.0, -4.0]]], [[[2.0, -6.0], [-3.0, -7.0], [7.0, -5.0]], [[4.0, -7.0], [6.0, 0.0], [4.0, -7.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(-159.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_array_rank1_offset0(self):
      arg0=Data(-1.0,self.functionspace)
      arg1=numpy.array([-7.0, -6.0])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([7.0, 6.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_array_rank2_offset1(self):
      arg0=Data(numpy.array([-3.0, 3.0, 7.0]),self.functionspace)
      arg1=numpy.array([[0.0, -1.0], [-7.0, 7.0], [-6.0, 6.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-63.0, 66.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank2_array_rank3_offset2(self):
      arg0=Data(numpy.array([[-5.0, 6.0, 6.0], [0.0, 0.0, -4.0]]),self.functionspace)
      arg1=numpy.array([[[-2.0, 0.0], [7.0, 6.0], [6.0, -1.0]], [[-2.0, 2.0], [-3.0, -3.0], [-2.0, -2.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([96.0, 38.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank3_array_rank4_offset3(self):
      arg0=Data(numpy.array([[[1.0, -5.0, 6.0], [-3.0, -3.0, 5.0], [-1.0, -1.0, -4.0], [7.0, -4.0, 3.0]], [[-7.0, 0.0, 0.0], 
[7.0, 5.0, 3.0], [1.0, -6.0, -5.0], [6.0, -3.0, -3.0]]]),self.functionspace)
      arg1=numpy.array([[[[4.0, 0.0], [-3.0, -5.0], [-3.0, -5.0]], [[5.0, 0.0], [3.0, -3.0], [6.0, -7.0]], [[2.0, 0.0], [-5.0, 
6.0], [0.0, -5.0]], [[0.0, 2.0], [-5.0, 4.0], [1.0, 7.0]]], [[[1.0, 0.0], [0.0, 0.0], [-6.0, 6.0]], [[6.0, 0.0], [6.0, 6.0], 
[-2.0, 7.0]], [[6.0, -4.0], [0.0, 3.0], [-2.0, 1.0]], [[-2.0, -3.0], [1.0, -6.0], [6.0, 2.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([75.0, 20.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_array_rank2_offset0(self):
      arg0=Data(5.0,self.functionspace)
      arg1=numpy.array([[-4.0, -1.0, 2.0, 6.0, 2.0], [-5.0, 4.0, 1.0, -4.0, 6.0], [7.0, 6.0, 7.0, -3.0, -2.0], [-6.0, 0.0, 6.0, 
3.0, 0.0]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-20.0, -5.0, 10.0, 30.0, 10.0], [-25.0, 20.0, 5.0, -20.0, 30.0], [35.0, 30.0, 35.0, -15.0, -10.0], 
[-30.0, 0.0, 30.0, 15.0, 0.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_array_rank3_offset1(self):
      arg0=Data(numpy.array([1.0, -4.0, 4.0]),self.functionspace)
      arg1=numpy.array([[[-7.0, -7.0, -3.0, 3.0, 0.0], [4.0, 2.0, -2.0, -3.0, -1.0], [-5.0, 4.0, -2.0, 7.0, 5.0], [0.0, -2.0, 
-1.0, -1.0, 1.0]], [[-7.0, 3.0, 0.0, -3.0, 7.0], [0.0, 2.0, 0.0, -3.0, -6.0], [4.0, 1.0, 6.0, -2.0, -4.0], [-3.0, -7.0, -4.0, 
-1.0, 1.0]], [[-2.0, 0.0, -5.0, 4.0, -1.0], [-7.0, 2.0, 0.0, -2.0, 7.0], [-2.0, 4.0, 5.0, 6.0, 5.0], [-7.0, 0.0, 4.0, 0.0, 
-3.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[13.0, -19.0, -23.0, 31.0, -32.0], [-24.0, 2.0, -2.0, 1.0, 51.0], [-29.0, 16.0, -6.0, 39.0, 41.0], 
[-16.0, 26.0, 31.0, 3.0, -15.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank2_array_rank4_offset2(self):
      arg0=Data(numpy.array([[-2.0, 5.0, -2.0], [1.0, 6.0, 0.0]]),self.functionspace)
      arg1=numpy.array([[[[2.0, 0.0, 2.0, -5.0, -2.0], [4.0, 0.0, -2.0, 1.0, 6.0], [-5.0, 7.0, -5.0, -3.0, -7.0], [-7.0, 3.0, 
6.0, 3.0, -3.0]], [[0.0, -4.0, -3.0, -5.0, -5.0], [6.0, 3.0, 1.0, 6.0, 5.0], [-3.0, -2.0, 1.0, -3.0, 0.0], [3.0, 3.0, 4.0, 
-4.0, 2.0]], [[-1.0, -1.0, -6.0, 4.0, -5.0], [-1.0, 1.0, 3.0, -4.0, -1.0], [0.0, -3.0, -4.0, 6.0, 7.0], [-5.0, 1.0, -4.0, -3.0, 
7.0]]], [[[-5.0, 7.0, -3.0, -2.0, -7.0], [-7.0, 3.0, -7.0, 4.0, -1.0], [4.0, 0.0, 7.0, 4.0, -4.0], [6.0, 4.0, -5.0, 7.0, 
-6.0]], [[3.0, -2.0, -3.0, 0.0, -5.0], [0.0, 3.0, 7.0, -1.0, -7.0], [0.0, -6.0, -5.0, -5.0, -2.0], [5.0, 3.0, 4.0, 1.0, 0.0]], 
[[1.0, 1.0, 0.0, 7.0, 7.0], [-1.0, 2.0, 5.0, 2.0, -3.0], [2.0, 3.0, -1.0, -7.0, 2.0], [7.0, -7.0, 7.0, 0.0, 6.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([[11.0, -23.0, -28.0, -25.0, -48.0], [17.0, 34.0, 38.0, 34.0, -28.0], [-1.0, -54.0, 0.0, -47.0, 
-16.0], [75.0, 29.0, 35.0, -7.0, -4.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_array_rank3_offset0(self):
      arg0=Data(6.0,self.functionspace)
      arg1=numpy.array([[[5.0, 0.0], [3.0, 5.0]], [[-5.0, 0.0], [-2.0, 7.0]], [[7.0, -4.0], [0.0, 0.0]], [[-1.0, 0.0], [-1.0, 
-4.0]], [[1.0, -4.0], [1.0, 1.0]], [[4.0, 5.0], [-1.0, 2.0]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[30.0, 0.0], [18.0, 30.0]], [[-30.0, 0.0], [-12.0, 42.0]], [[42.0, -24.0], [0.0, 0.0]], [[-6.0, 
0.0], [-6.0, -24.0]], [[6.0, -24.0], [6.0, 6.0]], [[24.0, 30.0], [-6.0, 12.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_array_rank4_offset1(self):
      arg0=Data(numpy.array([3.0, 1.0, 0.0]),self.functionspace)
      arg1=numpy.array([[[[-4.0, 3.0], [-5.0, -6.0]], [[5.0, 5.0], [0.0, -7.0]], [[-2.0, -4.0], [0.0, 6.0]], [[0.0, 6.0], [1.0, 
-7.0]], [[-4.0, 0.0], [3.0, 0.0]], [[0.0, -6.0], [6.0, 3.0]]], [[[7.0, 2.0], [2.0, 1.0]], [[-6.0, 2.0], [6.0, 2.0]], [[3.0, 
5.0], [0.0, -3.0]], [[4.0, -2.0], [-3.0, -5.0]], [[4.0, 0.0], [1.0, 5.0]], [[0.0, 3.0], [3.0, -5.0]]], [[[-6.0, 4.0], [-6.0, 
5.0]], [[-5.0, -6.0], [7.0, 3.0]], [[-4.0, -5.0], [2.0, -2.0]], [[6.0, 6.0], [-5.0, -7.0]], [[-4.0, -4.0], [3.0, 1.0]], [[0.0, 
-3.0], [3.0, -7.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[[-5.0, 11.0], [-13.0, -17.0]], [[9.0, 17.0], [6.0, -19.0]], [[-3.0, -7.0], [0.0, 15.0]], [[4.0, 
16.0], [0.0, -26.0]], [[-8.0, 0.0], [10.0, 5.0]], [[0.0, -15.0], [21.0, 4.0]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_array_rank4_offset0(self):
      arg0=Data(0.0,self.functionspace)
      arg1=numpy.array([[[[-7.0, 1.0, 0.0, -6.0], [0.0, 2.0, 4.0, 4.0], [-7.0, -1.0, -1.0, 0.0]], [[1.0, -2.0, 2.0, 0.0], [2.0, 
4.0, -1.0, 5.0], [0.0, 2.0, 6.0, -1.0]]], [[[-1.0, 5.0, 1.0, -5.0], [-7.0, 7.0, -1.0, -6.0], [-2.0, -6.0, -6.0, -4.0]], [[5.0, 
1.0, 2.0, 4.0], [-2.0, -4.0, -2.0, -3.0], [1.0, 3.0, 4.0, -1.0]]], [[[6.0, -3.0, 1.0, -4.0], [5.0, 6.0, -5.0, -3.0], [4.0, 4.0, 
2.0, -3.0]], [[-7.0, 3.0, -5.0, 3.0], [-4.0, 7.0, -3.0, -7.0], [-3.0, -3.0, 4.0, 3.0]]]])
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[[[-0.0, 0.0, 0.0, -0.0], [0.0, 0.0, 0.0, 0.0], [-0.0, -0.0, -0.0, 0.0]], [[0.0, -0.0, 0.0, 0.0], 
[0.0, 0.0, -0.0, 0.0], [0.0, 0.0, 0.0, -0.0]]], [[[-0.0, 0.0, 0.0, -0.0], [-0.0, 0.0, -0.0, -0.0], [-0.0, -0.0, -0.0, -0.0]], 
[[0.0, 0.0, 0.0, 0.0], [-0.0, -0.0, -0.0, -0.0], [0.0, 0.0, 0.0, -0.0]]], [[[0.0, -0.0, 0.0, -0.0], [0.0, 0.0, -0.0, -0.0], 
[0.0, 0.0, 0.0, -0.0]], [[-0.0, 0.0, -0.0, 0.0], [-0.0, 0.0, -0.0, -0.0], [-0.0, -0.0, 0.0, 0.0]]]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_constData_rank0_offset0(self):
      arg0=Data(5.0,self.functionspace)
      arg1=Data(1.0,self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(5.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_constData_rank1_offset1(self):
      arg0=Data(numpy.array([4.0, -2.0, 4.0]),self.functionspace)
      arg1=Data(numpy.array([5.0, 6.0, 6.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(32.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank2_constData_rank2_offset2(self):
      arg0=Data(numpy.array([[-1.0, 2.0, -7.0], [0.0, 6.0, -6.0]]),self.functionspace)
      arg1=Data(numpy.array([[4.0, 4.0, 4.0], [-4.0, 7.0, 7.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(-24.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank3_constData_rank3_offset3(self):
      arg0=Data(numpy.array([[[5.0, 6.0, -4.0], [6.0, 1.0, 0.0], [0.0, -2.0, -6.0], [-5.0, -3.0, -1.0]], [[0.0, -2.0, 0.0], 
[6.0, 3.0, 0.0], [-3.0, -2.0, 1.0], [0.0, 6.0, -7.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[-4.0, 6.0, 6.0], [-7.0, -4.0, -2.0], [0.0, 6.0, -6.0], [4.0, -3.0, 6.0]], [[3.0, -6.0, 2.0], 
[1.0, -4.0, 7.0], [-4.0, -6.0, 0.0], [-2.0, 0.0, -1.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(-10.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank4_constData_rank4_offset4(self):
      arg0=Data(numpy.array([[[[5.0, -1.0], [7.0, -7.0], [3.0, -2.0]], [[1.0, -3.0], [-1.0, -3.0], [3.0, 2.0]]], [[[0.0, -3.0], 
[1.0, -7.0], [-5.0, -7.0]], [[7.0, 5.0], [3.0, 6.0], [0.0, 2.0]]], [[[-2.0, 5.0], [-5.0, -5.0], [-6.0, -2.0]], [[6.0, 0.0], 
[-7.0, 7.0], [7.0, -4.0]]], [[[4.0, -1.0], [2.0, 5.0], [2.0, 5.0]], [[3.0, -5.0], [3.0, -5.0], [-7.0, 
7.0]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[6.0, 3.0], [2.0, 0.0], [-5.0, 6.0]], [[-1.0, -3.0], [5.0, -1.0], [5.0, 0.0]]], [[[-5.0, 4.0], 
[2.0, -7.0], [4.0, 0.0]], [[2.0, -1.0], [-5.0, 0.0], [2.0, -1.0]]], [[[-4.0, 7.0], [-3.0, 7.0], [-6.0, 0.0]], [[2.0, 3.0], 
[2.0, -6.0], [4.0, 7.0]]], [[[6.0, -7.0], [-5.0, 7.0], [7.0, 0.0]], [[-7.0, 7.0], [2.0, -3.0], [-6.0, 
-2.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=4)
      ref=Data(124.0,self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_constData_rank1_offset0(self):
      arg0=Data(-2.0,self.functionspace)
      arg1=Data(numpy.array([4.0, -3.0]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([-8.0, 6.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_constData_rank2_offset1(self):
      arg0=Data(numpy.array([0.0, -1.0, -3.0]),self.functionspace)
      arg1=Data(numpy.array([[0.0, 0.0], [4.0, 5.0], [6.0, 1.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([-22.0, -8.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank2_constData_rank3_offset2(self):
      arg0=Data(numpy.array([[0.0, -1.0, -5.0], [-3.0, 4.0, 3.0]]),self.functionspace)
      arg1=Data(numpy.array([[[-1.0, 4.0], [6.0, -5.0], [4.0, -4.0]], [[3.0, -1.0], [6.0, 3.0], [0.0, 
1.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=2)
      ref=Data(numpy.array([-11.0, 43.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank3_constData_rank4_offset3(self):
      arg0=Data(numpy.array([[[-1.0, 5.0, 3.0], [-1.0, 0.0, 6.0], [-5.0, 1.0, 3.0], [7.0, -5.0, 2.0]], [[-6.0, -5.0, -3.0], 
[4.0, 2.0, -6.0], [0.0, 2.0, 6.0], [-4.0, 2.0, 3.0]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-2.0, 4.0], [-6.0, 3.0], [0.0, 4.0]], [[4.0, 2.0], [1.0, 0.0], [-3.0, -4.0]], [[1.0, 5.0], 
[4.0, 1.0], [0.0, -6.0]], [[1.0, -3.0], [-6.0, -1.0], [-4.0, 2.0]]], [[[1.0, 1.0], [0.0, -4.0], [-4.0, 0.0]], [[-5.0, -5.0], 
[2.0, -1.0], [3.0, -5.0]], [[-2.0, 5.0], [-6.0, -7.0], [-6.0, 3.0]], [[4.0, 1.0], [-6.0, -1.0], [6.0, 
-7.0]]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=3)
      ref=Data(numpy.array([-108.0, -58.0]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank0_constData_rank2_offset0(self):
      arg0=Data(-5.0,self.functionspace)
      arg1=Data(numpy.array([[3.0, -5.0, 7.0, 1.0, -2.0], [1.0, -7.0, 4.0, 3.0, -4.0], [-7.0, 7.0, -3.0, -1.0, 0.0], [-1.0, 
2.0, 5.0, -3.0, -1.0]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=0)
      ref=Data(numpy.array([[-15.0, 25.0, -35.0, -5.0, 10.0], [-5.0, 35.0, -20.0, -15.0, 20.0], [35.0, -35.0, 15.0, 5.0, -0.0], 
[5.0, -10.0, -25.0, 15.0, 5.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_generalTransposedTensorProduct_constData_rank1_constData_rank3_offset1(self):
      arg0=Data(numpy.array([-5.0, -2.0, -1.0]),self.functionspace)
      arg1=Data(numpy.array([[[3.0, 7.0, 0.0, -1.0, -6.0], [5.0, -7.0, -3.0, -1.0, 3.0], [-7.0, 7.0, 0.0, -5.0, 3.0], [4.0, 
-2.0, 0.0, 2.0, -7.0]], [[-2.0, 1.0, 4.0, 4.0, 4.0], [4.0, 1.0, -7.0, -4.0, -1.0], [-3.0, -4.0, -5.0, 6.0, 4.0], [-1.0, 2.0, 
4.0, -7.0, 7.0]], [[4.0, 5.0, -3.0, -6.0, -5.0], [-4.0, 4.0, 1.0, 6.0, -2.0], [-1.0, 3.0, -4.0, 0.0, -6.0], [-2.0, -6.0, -1.0, 
-4.0, 0.0]]]),self.functionspace)
      res=generalTransposedTensorProduct(arg0,arg1,axis_offset=1)
      ref=Data(numpy.array([[-15.0, -42.0, -5.0, 3.0, 27.0], [-29.0, 29.0, 28.0, 7.0, -11.0], [42.0, -30.0, 14.0, 13.0, -17.0], 
[-16.0, 12.0, -7.0, 8.0, 21.0]]),self.functionspace)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")