% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand_bias_test.R
\name{strand_bias_test}
\alias{strand_bias_test}
\title{Significance test for strand asymmetry}
\usage{
strand_bias_test(strand_occurrences, p_cutoffs = 0.05, fdr_cutoffs = 0.1)
}
\arguments{
\item{strand_occurrences}{Dataframe with mutation count per strand, result
from 'strand_occurrences()'}

\item{p_cutoffs}{Significance cutoff for the p value. Default: 0.05}

\item{fdr_cutoffs}{Significance cutoff for the fdr. Default: 0.1}
}
\value{
Dataframe with poisson test P value for the ratio between the
two strands per group per base substitution type.
}
\description{
This function performs a two sided Poisson test for the ratio between mutations on
each strand. Multiple testing correction is also performed.
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## following mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
  package = "MutationalPatterns"
))

tissue <- c(
  "colon", "colon", "colon",
  "intestine", "intestine", "intestine",
  "liver", "liver", "liver"
)

## Perform the strand bias test.
strand_counts <- strand_occurrences(mut_mat_s, by = tissue)
strand_bias <- strand_bias_test(strand_counts)

## Use different significance cutoffs for the pvalue and fdr
strand_bias_strict <- strand_bias_test(strand_counts,
  p_cutoffs = 0.01, fdr_cutoffs = 0.05
)

## Use multiple (max 3) significance cutoffs.
## This will vary the number of significance stars.
strand_bias_multistars <- strand_bias_test(strand_counts,
  p_cutoffs = c(0.05, 0.01, 0.005),
  fdr_cutoffs = c(0.1, 0.05, 0.01)
)
}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{strand_occurrences}},
\code{\link{plot_strand_bias}}
}
