% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{dySeries}
\alias{dySeries}
\title{dygraph data series}
\usage{
dySeries(dygraph, name = NULL, label = NULL, color = NULL, axis = "y",
  stepPlot = NULL, stemPlot = NULL, fillGraph = NULL, drawPoints = NULL,
  pointSize = NULL, pointShape = NULL, strokeWidth = NULL,
  strokePattern = NULL, strokeBorderWidth = NULL,
  strokeBorderColor = NULL, plotter = NULL)
}
\arguments{
\item{dygraph}{Dygraph to add a series definition to}

\item{name}{Name of series within data set. If no name is specified then 
series are bound to implicitly based on their order within the underlying 
time series object. This parameter can also be a character vector of length
3 that specifies a set of input column names to use as the lower, value,
and upper for a series with a shaded bar drawn around it.}

\item{label}{Label to display for series (uses name if no label defined)}

\item{color}{Color for series. These can be of the form "#AABBCC" or 
"rgb(255,100,200)" or "yellow", etc. If not specified then the global 
colors option (typically based on equally-spaced points around a color wheel).}

\item{axis}{Y-axis to associate the series with ("y" or "y2")}

\item{stepPlot}{When set, display the graph as a step plot instead of a line 
plot.}

\item{stemPlot}{When set, display the graph as a stem plot instead of a line
plot.}

\item{fillGraph}{Should the area underneath the graph be filled? This option 
is not compatible with error bars.}

\item{drawPoints}{Draw a small dot at each point, in addition to a line going
through the point. This makes the individual data points easier to see, but
can increase visual clutter in the chart.}

\item{pointSize}{The size of the dot to draw on each point in pixels. A dot 
is always drawn when a point is "isolated", i.e. there is a missing point 
on either side of it. This also controls the size of those dots.}

\item{pointShape}{The shape of the dot to draw. Can be one of the following:
"dot" (default), "triangle", "square", "diamond", "pentagon", "hexagon",
"circle", "star", "plus" or "ex".}

\item{strokeWidth}{The width of the lines connecting data points. This can be
used to increase the contrast or some graphs.}

\item{strokePattern}{A predefined stroke pattern type ("dotted", "dashed", or
"dotdash") or a custom pattern array where the even index is a draw and odd
is a space in pixels. If \code{NULL} then it draws a solid line. The array 
should have an even length as any odd length array could be expressed as 
a smaller even length array.}

\item{strokeBorderWidth}{Draw a border around graph lines to make crossing 
lines more easily distinguishable. Useful for graphs with many lines.}

\item{strokeBorderColor}{Color for the line border used if 
\code{strokeBorderWidth} is set.}

\item{plotter}{A function which plots the data series. May also be set on on 
a global basis using \code{dyOptions}. See the 
\href{http://dygraphs.com/tests/plotters.html}{dygraphs documentation} for 
additional details on plotting functions.}
}
\value{
Dygraph with additional series
}
\description{
Add a data series to a dygraph plot. Note that options will use the default 
global setting (as determined by \code{\link{dyOptions}}) when not specified 
explicitly. When no \code{dySeries} is specified for a plot then all series 
within the underlying data are plotted.
}
\note{
See the 
  \href{https://rstudio.github.io/dygraphs/gallery-series-options.html}{online
  documentation} for additional details and examples.
}
\examples{
library(dygraphs)

lungDeaths <- cbind(ldeaths, mdeaths, fdeaths)

dygraph(lungDeaths, main = "Deaths from Lung Disease (UK)") \%>\%
  dySeries("mdeaths", drawPoints = TRUE, color = "blue") \%>\%
  dySeries("fdeaths", stepPlot = TRUE, color = "red")   
  
}
