﻿
# game/tutorial_screen_displayables.rpy:3
translate piglatin screen_displayables_7c897a6d:

    # e "There are quite a few screen displayables. Here, I'll tell you about some of the most important ones."
    e "Heretay areay uiteqay aay ewfay creensay isplayablesday. Erehay, Iay'llay elltay ouyay aboutay omesay ofay hetay ostmay importantay onesay."

# game/tutorial_screen_displayables.rpy:11
translate piglatin screen_displayables_menu_fef7b441:

    # e "What would you like to know about?" nointeract
    e "Hatway ouldway ouyay ikelay otay nowkay aboutay?" nointeract

# game/tutorial_screen_displayables.rpy:49
translate piglatin screen_displayable_properties_76c5639a:

    # e "There are a few properties that every screen language displayable shares. Here, I'll demonstrate them for you."
    e "Heretay areay aay ewfay ropertiespay hattay everyay creensay anguagelay isplayableday aresshay. Erehay, Iay'llay emonstrateday hemtay orfay ouyay."

# game/tutorial_screen_displayables.rpy:57
translate piglatin screen_displayable_properties_527d4b4e:

    # e "First off, every screen language displayable supports the position properties. When the container a displayable is in supports it, you can use properties like align, anchor, pos, and so so on."
    e "Irstfay offay, everyay creensay anguagelay isplayableday upportssay hetay ositionpay ropertiespay. Henway hetay ontainercay aay isplayableday isay inay upportssay itay, ouyay ancay useay ropertiespay ikelay alignay, anchoray, ospay, anday osay osay onay."

# game/tutorial_screen_displayables.rpy:69
translate piglatin screen_displayable_properties_8aff26dd:

    # e "The at property applies a transform to the displayable, the same way the at clause in the show statement does."
    e "Hetay atay ropertypay appliesay aay ansformtray otay hetay isplayableday, hetay amesay ayway hetay atay auseclay inay hetay owshay atementstay oesday."

# game/tutorial_screen_displayables.rpy:106
translate piglatin screen_displayable_properties_2ed40a70:

    # e "The id property is mostly used with the say screen, which is used to show dialogue. Outside of the say screen, it isn't used much."
    e "Hetay iday ropertypay isay ostlymay useday ithway hetay aysay creensay, hichway isay useday otay owshay ialogueday. Utsideoay ofay hetay aysay creensay, itay isnay'tay useday uchmay."

# game/tutorial_screen_displayables.rpy:108
translate piglatin screen_displayable_properties_da5733d1:

    # e "It tells Ren'Py which displayables are the background window, 'who' is speaking, and 'what' is being said. This used to apply per-Character styles, and help with auto-forward mode."
    e "Tiay ellstay Enray'Ypay hichway isplayablesday areay hetay ackgroundbay indowway, 'howay' isay peakingsay, anday 'hatway' isay eingbay aidsay. Histay useday otay applyay erpay-Haractercay ylesstay, anday elphay ithway autoay-orwardfay odemay."

# game/tutorial_screen_displayables.rpy:123
translate piglatin screen_displayable_properties_cc09fade:

    # e "The style property lets you specify the style of a single displayable."
    e "Hetay ylestay ropertypay etslay ouyay pecifysay hetay ylestay ofay aay inglesay isplayableday."

# game/tutorial_screen_displayables.rpy:144
translate piglatin screen_displayable_properties_a7f4e25c:

    # e "The style_prefix property sets the prefix of the style that's used for a displayable and its children."
    e "Hetay yle_prefixstay ropertypay etssay hetay refixpay ofay hetay ylestay hattay'say useday orfay aay isplayableday anday itsay ildrenchay."

# game/tutorial_screen_displayables.rpy:146
translate piglatin screen_displayable_properties_6bdb0723:

    # e "For example, when the style_prefix property is 'green', the vbox has the 'green_vbox' style, and the text in it has the 'green_text' style."
    e "Orfay exampleay, henway hetay yle_prefixstay ropertypay isay 'eengray', hetay boxvay ashay hetay 'een_vboxgray' ylestay, anday hetay exttay inay itay ashay hetay 'een_textgray' ylestay."

# game/tutorial_screen_displayables.rpy:150
translate piglatin screen_displayable_properties_8a3a8635:

    # e "There are a few more properties than these, and you can find the rest in the documentation. But these are the ones you can expect to see in your game, in the default screens."
    e "Heretay areay aay ewfay oremay ropertiespay hantay hesetay, anday ouyay ancay indfay hetay estray inay hetay ocumentationday. Utbay hesetay areay hetay onesay ouyay ancay expectay otay eesay inay ouryay amegay, inay hetay efaultday creenssay."

# game/tutorial_screen_displayables.rpy:156
translate piglatin add_displayable_ec121c5c:

    # e "Sometimes you'll have a displayable, like an image, that you want to add to a screen."
    e "Ometimessay ouyay'llay avehay aay isplayableday, ikelay anay imageay, hattay ouyay antway otay adday otay aay creensay."

# game/tutorial_screen_displayables.rpy:165
translate piglatin add_displayable_7ec3e2b0:

    # e "This can be done using the add statement, which adds an image or other displayable to the screen."
    e "Histay ancay ebay oneday usingay hetay adday atementstay, hichway addsay anay imageay oray otheray isplayableday otay hetay creensay."

# game/tutorial_screen_displayables.rpy:167
translate piglatin add_displayable_7112a377:

    # e "There are a few ways to refer to the image. If it's in the images directory or defined with the image statement, you can just put the name inside a quoted string."
    e "Heretay areay aay ewfay aysway otay eferray otay hetay imageay. Fiay itay'say inay hetay imagesay irectoryday oray efinedday ithway hetay imageay atementstay, ouyay ancay ustjay utpay hetay amenay insideay aay uotedqay ringstay."

# game/tutorial_screen_displayables.rpy:176
translate piglatin add_displayable_8ba81c26:

    # e "An image can also be referred to by its filename, relative to the game directory." id add_displayable_8ba81c26
    e "Naay imageay ancay alsoay ebay eferredray otay ybay itsay ilenamefay, elativeray otay hetay amegay irectoryday." id add_displayable_8ba81c26

# game/tutorial_screen_displayables.rpy:185
translate piglatin add_displayable_1f5571e3:

    # e "Other displayables can also be added using the add statement. Here, we add the Solid displayable, showing a solid block of color."
    e "Theroay isplayablesday ancay alsoay ebay addeday usingay hetay adday atementstay. Erehay, eway adday hetay Olidsay isplayableday, owingshay aay olidsay ockblay ofay olorcay."

# game/tutorial_screen_displayables.rpy:195
translate piglatin add_displayable_0213ffa2:

    # e "In addition to the displayable, the add statement can be given transform properties. These can place or otherwise transform the displayable being added."
    e "Niay additionay otay hetay isplayableday, hetay adday atementstay ancay ebay ivengay ansformtray ropertiespay. Hesetay ancay aceplay oray otherwiseay ansformtray hetay isplayableday eingbay addeday."

# game/tutorial_screen_displayables.rpy:207
translate piglatin add_displayable_3a56a464:

    # e "Of course, the add statement can also take the at property, letting you give it a more complex transform."
    e "Foay oursecay, hetay adday atementstay ancay alsoay aketay hetay atay ropertypay, ettinglay ouyay ivegay itay aay oremay omplexcay ansformtray."

# game/tutorial_screen_displayables.rpy:222
translate piglatin text_displayable_96f88225:

    # e "The screen language text statement adds a text displayable to the screen. It takes one argument, the text to be displayed."
    e "Hetay creensay anguagelay exttay atementstay addsay aay exttay isplayableday otay hetay creensay. Tiay akestay oneay argumentay, hetay exttay otay ebay isplayedday."

# game/tutorial_screen_displayables.rpy:224
translate piglatin text_displayable_1ed1a8c2:

    # e "In addition to the common properties that all displayables take, text takes the text style properties. For example, size sets the size of the text."
    e "Niay additionay otay hetay ommoncay ropertiespay hattay allay isplayablesday aketay, exttay akestay hetay exttay ylestay ropertiespay. Orfay exampleay, izesay etssay hetay izesay ofay hetay exttay."

# game/tutorial_screen_displayables.rpy:234
translate piglatin text_displayable_9351d9dd:

    # e "The text displayable can also interpolate values enclosed in square brackets."
    e "Hetay exttay isplayableday ancay alsoay interpolateay aluesvay encloseday inay quaresay acketsbray."

# game/tutorial_screen_displayables.rpy:236
translate piglatin text_displayable_32d76ccb:

    # e "When text is displayed in a screen using the text statement, variables defined in the screen take precedence over those defined outside it." id text_displayable_32d76ccb
    e "Henway exttay isay isplayedday inay aay creensay usingay hetay exttay atementstay, ariablesvay efinedday inay hetay creensay aketay recedencepay overay hosetay efinedday outsideay itay." id text_displayable_32d76ccb

# game/tutorial_screen_displayables.rpy:238
translate piglatin text_displayable_7e84a5d1:

    # e "Those variables may be parameters given to the screen, defined with the default or python statements, or set using the SetScreenVariable action."
    e "Hosetay ariablesvay aymay ebay arameterspay ivengay otay hetay creensay, efinedday ithway hetay efaultday oray ythonpay atementsstay, oray etsay usingay hetay Etscreenvariablesay actionay."

# game/tutorial_screen_displayables.rpy:247
translate piglatin text_displayable_8bc866c4:

    # e "There's not much more to say about text in screens, as it works the same way as all other text in Ren'Py."
    e "Heretay'say otnay uchmay oremay otay aysay aboutay exttay inay creenssay, asay itay orksway hetay amesay ayway asay allay otheray exttay inay Enray'Ypay."

# game/tutorial_screen_displayables.rpy:255
translate piglatin layout_displayables_d75efbae:

    # e "The layout displayables take other displayables and lay them out on the screen."
    e "Hetay ayoutlay isplayablesday aketay otheray isplayablesday anday aylay hemtay outay onay hetay creensay."

# game/tutorial_screen_displayables.rpy:269
translate piglatin layout_displayables_9a15144d:

    # e "For example, the hbox displayable takes its children and lays them out horizontally."
    e "Orfay exampleay, hetay boxhay isplayableday akestay itsay ildrenchay anday ayslay hemtay outay orizontallyhay."

# game/tutorial_screen_displayables.rpy:284
translate piglatin layout_displayables_48eff197:

    # e "The vbox displayable is similar, except it takes its children and arranges them vertically."
    e "Hetay boxvay isplayableday isay imilarsay, exceptay itay akestay itsay ildrenchay anday arrangesay hemtay erticallyvay."

# game/tutorial_screen_displayables.rpy:286
translate piglatin layout_displayables_74de8a66:

    # e "Both of the boxes take the box style properties, the most useful of which is spacing, the amount of space to leave between children."
    e "Othbay ofay hetay oxesbay aketay hetay oxbay ylestay ropertiespay, hetay ostmay usefulay ofay hichway isay pacingsay, hetay amountay ofay pacesay otay eavelay etweenbay ildrenchay."

# game/tutorial_screen_displayables.rpy:301
translate piglatin layout_displayables_a156591f:

    # e "The grid displayable displays its children in a grid of equally-sized cells. It takes two arguments, the number of columns and the number of rows."
    e "Hetay idgray isplayableday isplaysday itsay ildrenchay inay aay idgray ofay equallyay-izedsay ellscay. Tiay akestay wotay argumentsay, hetay umbernay ofay olumnscay anday hetay umbernay ofay owsray."

# game/tutorial_screen_displayables.rpy:303
translate piglatin layout_displayables_126f5816:

    # e "The grid has to be full, or Ren'Py will produce an error. Notice how in this example, the empty cell is filled with a null."
    e "Hetay idgray ashay otay ebay ullfay, oray Enray'Ypay illway roducepay anay erroray. Oticenay owhay inay histay exampleay, hetay emptyay ellcay isay illedfay ithway aay ullnay."

# game/tutorial_screen_displayables.rpy:305
translate piglatin layout_displayables_bfaaaf9b:

    # e "Like the boxes, grid uses the spacing property to specify the space between cells."
    e "Ikelay hetay oxesbay, idgray usesay hetay pacingsay ropertypay otay pecifysay hetay pacesay etweenbay ellscay."

# game/tutorial_screen_displayables.rpy:321
translate piglatin layout_displayables_3e931106:

    # e "Grid also takes the transpose property, to make it fill top-to-bottom before it fills left-to-right."
    e "Ridgay alsoay akestay hetay ansposetray ropertypay, otay akemay itay illfay optay-otay-ottombay eforebay itay illsfay eftlay-otay-ightray."

# game/tutorial_screen_displayables.rpy:338
translate piglatin layout_displayables_afdc1b11:

    # e "And just to demonstrate that all cells are equally-sized, here's what happens when once child is bigger than the others."
    e "Ndaay ustjay otay emonstrateday hattay allay ellscay areay equallyay-izedsay, erehay'say hatway appenshay henway onceay ildchay isay iggerbay hantay hetay othersay."

# game/tutorial_screen_displayables.rpy:353
translate piglatin layout_displayables_a23e2826:

    # e "The fixed displayable displays the children using Ren'Py's normal placement algorithm. This lets you place displayables anywhere in the screen."
    e "Hetay ixedfay isplayableday isplaysday hetay ildrenchay usingay Enray'Ypay'say ormalnay acementplay algorithmay. Histay etslay ouyay aceplay isplayablesday anywhereay inay hetay creensay."

# game/tutorial_screen_displayables.rpy:355
translate piglatin layout_displayables_fd3926ca:

    # e "By default, the layout expands to fill all the space available to it. To prevent that, we use the xsize and ysize properties to set its size in advance."
    e "Ybay efaultday, hetay ayoutlay expandsay otay illfay allay hetay pacesay availableay otay itay. Otay reventpay hattay, eway useay hetay sizexay anday sizeyay ropertiespay otay etsay itsay izesay inay advanceay."

# game/tutorial_screen_displayables.rpy:369
translate piglatin layout_displayables_eff42786:

    # e "When a non-layout displayable is given two or more children, it's not necessary to create a fixed. A fixed is automatically added, and the children are added to it."
    e "Henway aay onnay-ayoutlay isplayableday isay ivengay wotay oray oremay ildrenchay, itay'say otnay ecessarynay otay reatecay aay ixedfay. Aay ixedfay isay automaticallyay addeday, anday hetay ildrenchay areay addeday otay itay."

# game/tutorial_screen_displayables.rpy:384
translate piglatin layout_displayables_c32324a7:

    # e "Finally, there's one convenience to save space. When many displayables are nested, adding a layout to each could cause crazy indent levels."
    e "Inallyfay, heretay'say oneay onveniencecay otay avesay pacesay. Henway anymay isplayablesday areay estednay, addingay aay ayoutlay otay eachay ouldcay ausecay razycay indentay evelslay."

# game/tutorial_screen_displayables.rpy:386
translate piglatin layout_displayables_d7fa0f28:

    # e "The has statement creates a layout, and then adds all further children of its parent to that layout. It's just a convenience to make screens more readable."
    e "Hetay ashay atementstay reatescay aay ayoutlay, anday hentay addsay allay urtherfay ildrenchay ofay itsay arentpay otay hattay ayoutlay. Tiay'say ustjay aay onveniencecay otay akemay creenssay oremay eadableray."

# game/tutorial_screen_displayables.rpy:395
translate piglatin window_displayables_14beb786:

    # e "In the default GUI that Ren'Py creates for a game, most user interface elements expect some sort of background."
    e "Niay hetay efaultday Uigay hattay Enray'Ypay reatescay orfay aay amegay, ostmay useray interfaceay elementsay expectay omesay ortsay ofay ackgroundbay."

# game/tutorial_screen_displayables.rpy:405
translate piglatin window_displayables_495d332b:

    # e "Without the background, text can be hard to read. While a frame isn't strictly required, many screens have one or more of them."
    e "Ithoutway hetay ackgroundbay, exttay ancay ebay ardhay otay eadray. Hileway aay amefray isnay'tay rictlystay equiredray, anymay creenssay avehay oneay oray oremay ofay hemtay."

# game/tutorial_screen_displayables.rpy:417
translate piglatin window_displayables_2c0565ab:

    # e "But when I add a background, it's much easier. That's why there are two displayables that are intended to give backgrounds to user interface elements."
    e "Utbay henway Iay adday aay ackgroundbay, itay'say uchmay easieray. Hattay'say hyway heretay areay wotay isplayablesday hattay areay intendeday otay ivegay ackgroundsbay otay useray interfaceay elementsay."

# game/tutorial_screen_displayables.rpy:419
translate piglatin window_displayables_c7d0968c:

    # e "The two displayables are frame and window. Frame is the one we use above, and it's designed to provide a background for arbitrary parts of the user interface."
    e "Hetay wotay isplayablesday areay amefray anday indowway. Ramefay isay hetay oneay eway useay aboveay, anday itay'say esignedday otay rovidepay aay ackgroundbay orfay arbitraryay artspay ofay hetay useray interfaceay."

# game/tutorial_screen_displayables.rpy:423
translate piglatin window_displayables_7d843f62:

    # e "On the other hand, the window displayable is very specific. It's used to provide the text window. If you're reading what I'm saying, you're looking at the text window right now."
    e "Noay hetay otheray andhay, hetay indowway isplayableday isay eryvay pecificsay. Tiay'say useday otay rovidepay hetay exttay indowway. Fiay ouyay'eray eadingray hatway Iay'may ayingsay, ouyay'eray ookinglay atay hetay exttay indowway ightray ownay."

# game/tutorial_screen_displayables.rpy:425
translate piglatin window_displayables_de5963e4:

    # e "Both frames and windows can be given window style properties, allowing you to change things like the background, margins, and padding around the window."
    e "Othbay amesfray anday indowsway ancay ebay ivengay indowway ylestay ropertiespay, allowingay ouyay otay angechay hingstay ikelay hetay ackgroundbay, arginsmay, anday addingpay arounday hetay indowway."

# game/tutorial_screen_displayables.rpy:433
translate piglatin button_displayables_ea626553:

    # e "One of the most flexible displayables is the button displayable, and its textbutton and imagebutton variants."
    e "Neoay ofay hetay ostmay exibleflay isplayablesday isay hetay uttonbay isplayableday, anday itsay extbuttontay anday imagebuttonay ariantsvay."

# game/tutorial_screen_displayables.rpy:443
translate piglatin button_displayables_372dcc0f:

    # e "A button is a displayable that when selected runs an action. Buttons can be selected by clicking with the mouse, by touch, or with the keyboard and controller."
    e "Aay uttonbay isay aay isplayableday hattay henway electedsay unsray anay actionay. Uttonsbay ancay ebay electedsay ybay ickingclay ithway hetay ousemay, ybay ouchtay, oray ithway hetay eyboardkay anday ontrollercay."

# game/tutorial_screen_displayables.rpy:445
translate piglatin button_displayables_a6b270ff:

    # e "Actions can do many things, like setting variables, showing screens, jumping to a label, or returning a value. There are many {a=https://www.renpy.org/doc/html/screen_actions.html}actions in the Ren'Py documentation{/a}, and you can also write your own."
    e "Ctionsaay ancay oday anymay hingstay, ikelay ettingsay ariablesvay, owingshay creenssay, umpingjay otay aay abellay, oray eturningray aay aluevay. Heretay areay anymay {a=https://www.renpy.org/doc/html/screen_actions.html}actionsay inay hetay Enray'Ypay ocumentationday{/a}, anday ouyay ancay alsoay riteway ouryay ownay."

# game/tutorial_screen_displayables.rpy:458
translate piglatin button_displayables_4c600d20:

    # e "It's also possible to run actions when a button gains and loses focus."
    e "Tiay'say alsoay ossiblepay otay unray actionsay henway aay uttonbay ainsgay anday oseslay ocusfay."

# game/tutorial_screen_displayables.rpy:473
translate piglatin button_displayables_47af4bb9:

    # e "A button takes another displayable as a child. Since that child can be a layout, it can take as many children as you want." id button_displayables_47af4bb9
    e "Aay uttonbay akestay anotheray isplayableday asay aay ildchay. Incesay hattay ildchay ancay ebay aay ayoutlay, itay ancay aketay asay anymay ildrenchay asay ouyay antway." id button_displayables_47af4bb9

# game/tutorial_screen_displayables.rpy:483
translate piglatin button_displayables_d01adde3:

    # e "In many cases, buttons will be given text. To make that easier, there's the textbutton displayable that takes the text as an argument."
    e "Niay anymay asescay, uttonsbay illway ebay ivengay exttay. Otay akemay hattay easieray, heretay'say hetay extbuttontay isplayableday hattay akestay hetay exttay asay anay argumentay."

# game/tutorial_screen_displayables.rpy:485
translate piglatin button_displayables_01c551b3:

    # e "Since the textbutton displayable manages the style of the button text for you, it's the kind of button that's used most often in the default GUI."
    e "Incesay hetay extbuttontay isplayableday anagesmay hetay ylestay ofay hetay uttonbay exttay orfay ouyay, itay'say hetay indkay ofay uttonbay hattay'say useday ostmay oftenay inay hetay efaultday Uigay."

# game/tutorial_screen_displayables.rpy:498
translate piglatin button_displayables_6911fb9b:

    # e "There's also the imagebutton, which takes displayables, one for each state the button can be in, and displays them as the button."
    e "Heretay'say alsoay hetay imagebuttonay, hichway akestay isplayablesday, oneay orfay eachay atestay hetay uttonbay ancay ebay inay, anday isplaysday hemtay asay hetay uttonbay."

# game/tutorial_screen_displayables.rpy:500
translate piglatin button_displayables_49720fa6:

    # e "An imagebutton gives you the most control over what a button looks like, but is harder to translate and won't look as good if the game window is resized."
    e "Naay imagebuttonay ivesgay ouyay hetay ostmay ontrolcay overay hatway aay uttonbay ookslay ikelay, utbay isay arderhay otay anslatetray anday onway'tay ooklay asay oodgay ifay hetay amegay indowway isay esizedray."

# game/tutorial_screen_displayables.rpy:522
translate piglatin button_displayables_e8d40fc8:

    # e "Buttons take Window style properties, that are used to specify the background, margins, and padding. They also take Button-specific properties, like a sound to play on hover."
    e "Uttonsbay aketay Indowway ylestay ropertiespay, hattay areay useday otay pecifysay hetay ackgroundbay, arginsmay, anday addingpay. Heytay alsoay aketay Uttonbay-pecificsay ropertiespay, ikelay aay oundsay otay ayplay onay overhay."

# game/tutorial_screen_displayables.rpy:524
translate piglatin button_displayables_1e40e311:

    # e "When used with a button, style properties can be given prefixes like idle and hover to make the property change with the button state."
    e "Henway useday ithway aay uttonbay, ylestay ropertiespay ancay ebay ivengay refixespay ikelay idleay anday overhay otay akemay hetay ropertypay angechay ithway hetay uttonbay atestay."

# game/tutorial_screen_displayables.rpy:526
translate piglatin button_displayables_220b020d:

    # e "A text button also takes Text style properties, prefixed with text. These are applied to the text displayable it creates internally."
    e "Aay exttay uttonbay alsoay akestay Exttay ylestay ropertiespay, refixedpay ithway exttay. Hesetay areay applieday otay hetay exttay isplayableday itay reatescay internallyay."

# game/tutorial_screen_displayables.rpy:558
translate piglatin button_displayables_b89d12aa:

    # e "Of course, it's prety rare we'd ever customize a button in a screen like that. Instead, we'd create custom styles and tell Ren'Py to use them."
    e "Foay oursecay, itay'say retypay areray eway'day everay ustomizecay aay uttonbay inay aay creensay ikelay hattay. Nsteadiay, eway'day reatecay ustomcay ylesstay anday elltay Enray'Ypay otay useay hemtay."

# game/tutorial_screen_displayables.rpy:577
translate piglatin bar_displayables_946746c2:

    # e "The bar and vbar displayables are flexible displayables that show bars representing a value. The value can be static, animated, or adjustable by the player."
    e "Hetay arbay anday barvay isplayablesday areay exibleflay isplayablesday hattay owshay arsbay epresentingray aay aluevay. Hetay aluevay ancay ebay aticstay, animateday, oray adjustableay ybay hetay ayerplay."

# game/tutorial_screen_displayables.rpy:579
translate piglatin bar_displayables_af3a51b8:

    # e "The value property gives a BarValue, which is an object that determines the bar's value and range. Here, a StaticValue sets the range to 100 and the value to 66, making a bar that's two thirds full."
    e "Hetay aluevay ropertypay ivesgay aay Arvaluebay, hichway isay anay objectay hattay eterminesday hetay arbay'say aluevay anday angeray. Erehay, aay Taticvaluesay etssay hetay angeray otay 001ay anday hetay aluevay otay 66ay, akingmay aay arbay hattay'say wotay hirdstay ullfay."

# game/tutorial_screen_displayables.rpy:581
translate piglatin bar_displayables_62f8b0ab:

    # e "A list of all the BarValues that can be used is found {a=https://www.renpy.org/doc/html/screen_actions.html#bar-values}in the Ren'Py documentation{/a}."
    e "Aay istlay ofay allay hetay Arvaluesbay hattay ancay ebay useday isay oundfay {a=https://www.renpy.org/doc/html/screen_actions.html#bar-values}inay hetay Enray'Ypay ocumentationday{/a}."

# game/tutorial_screen_displayables.rpy:583
translate piglatin bar_displayables_5212eb0a:

    # e "In this example, we give the frame the xsize property. If we didn't do that, the bar would expand to fill all available horizontal space."
    e "Niay histay exampleay, eway ivegay hetay amefray hetay sizexay ropertypay. Fiay eway idnday'tay oday hattay, hetay arbay ouldway expanday otay illfay allay availableay orizontalhay pacesay."

# game/tutorial_screen_displayables.rpy:600
translate piglatin bar_displayables_67295018:

    # e "There are a few different bar styles that are defined in the default GUI. The styles are selected by the style property, with the default selected by the value."
    e "Heretay areay aay ewfay ifferentday arbay ylesstay hattay areay efinedday inay hetay efaultday Uigay. Hetay ylesstay areay electedsay ybay hetay ylestay ropertypay, ithway hetay efaultday electedsay ybay hetay aluevay."

# game/tutorial_screen_displayables.rpy:602
translate piglatin bar_displayables_1b037b21:

    # e "The top style is the 'bar' style. It's used to display values that the player can't adjust, like a life or progress bar."
    e "Hetay optay ylestay isay hetay 'arbay' ylestay. Tiay'say useday otay isplayday aluesvay hattay hetay ayerplay ancay'tay adjustay, ikelay aay ifelay oray rogresspay arbay."

# game/tutorial_screen_displayables.rpy:604
translate piglatin bar_displayables_c2aa4725:

    # e "The middle style is the 'slider' value. It's used for values the player is expected to adjust, like a volume preference." id bar_displayables_c2aa4725
    e "Hetay iddlemay ylestay isay hetay 'iderslay' aluevay. Tiay'say useday orfay aluesvay hetay ayerplay isay expecteday otay adjustay, ikelay aay olumevay referencepay." id bar_displayables_c2aa4725

# game/tutorial_screen_displayables.rpy:606
translate piglatin bar_displayables_2fc44226:

    # e "Finally, the bottom style is the 'scrollbar' style, which is used for horizontal scrollbars. When used as a scrollbar, the thumb in the center changes size to reflect the visible area of a viewport."
    e "Inallyfay, hetay ottombay ylestay isay hetay 'crollbarsay' ylestay, hichway isay useday orfay orizontalhay crollbarssay. Henway useday asay aay crollbarsay, hetay humbtay inay hetay entercay angeschay izesay otay eflectray hetay isiblevay areaay ofay aay iewportvay."

# game/tutorial_screen_displayables.rpy:623
translate piglatin bar_displayables_26eb88bf:

    # e "The vbar displayable is similar to the bar displayable, except it uses vertical styles - 'vbar', 'vslider', and 'vscrollbar' - by default."
    e "Hetay barvay isplayableday isay imilarsay otay hetay arbay isplayableday, exceptay itay usesay erticalvay ylesstay - 'barvay', 'slidervay', anday 'scrollbarvay' - ybay efaultday."

# game/tutorial_screen_displayables.rpy:626
translate piglatin bar_displayables_11cf8af2:

    # e "Bars take the Bar style properties, which can customize the look and feel greatly. Just look at the difference between the bar, slider, and scrollbar styles."
    e "Arsbay aketay hetay Arbay ylestay ropertiespay, hichway ancay ustomizecay hetay ooklay anday eelfay eatlygray. Ustjay ooklay atay hetay ifferenceday etweenbay hetay arbay, iderslay, anday crollbarsay ylesstay."

# game/tutorial_screen_displayables.rpy:635
translate piglatin imagemap_displayables_d62fad02:

    # e "Imagemaps use two or more images to show buttons and bars. Let me start by showing you an example of an imagemap in action."
    e "Magemapsiay useay wotay oray oremay imagesay otay owshay uttonsbay anday arsbay. Etlay emay artstay ybay owingshay ouyay anay exampleay ofay anay imagemapay inay actionay."

# game/tutorial_screen_displayables.rpy:657
translate piglatin swimming_405542a5:

    # e "You chose swimming."
    e "Ouyay osechay wimmingsay."

# game/tutorial_screen_displayables.rpy:659
translate piglatin swimming_264b5873:

    # e "Swimming seems like a lot of fun, but I didn't bring my bathing suit with me."
    e "Wimmingsay eemssay ikelay aay otlay ofay unfay, utbay Iay idnday'tay ingbray ymay athingbay uitsay ithway emay."

# game/tutorial_screen_displayables.rpy:665
translate piglatin science_83e5c0cc:

    # e "You chose science."
    e "Ouyay osechay ciencesay."

# game/tutorial_screen_displayables.rpy:667
translate piglatin science_319cdf4b:

    # e "I've heard that some schools have a competitive science team, but to me research is something that can't be rushed."
    e "Iay'evay eardhay hattay omesay choolssay avehay aay ompetitivecay ciencesay eamtay, utbay otay emay esearchray isay omethingsay hattay ancay'tay ebay ushedray."

# game/tutorial_screen_displayables.rpy:672
translate piglatin art_d2a94440:

    # e "You chose art."
    e "Ouyay osechay artay."

# game/tutorial_screen_displayables.rpy:674
translate piglatin art_e6af6f1d:

    # e "Really good background art is hard to make, which is why so many games use filtered photographs. Maybe you can change that."
    e "Eallyray oodgay ackgroundbay artay isay ardhay otay akemay, hichway isay hyway osay anymay amesgay useay ilteredfay otographsphay. Aybemay ouyay ancay angechay hattay."

# game/tutorial_screen_displayables.rpy:680
translate piglatin home_373ea9a5:

    # e "You chose to go home."
    e "Ouyay osechay otay ogay omehay."

# game/tutorial_screen_displayables.rpy:686
translate piglatin imagemap_done_48eca0a4:

    # e "Anyway..."
    e "Nywayaay..."

# game/tutorial_screen_displayables.rpy:691
translate piglatin imagemap_done_a60635a1:

    # e "To demonstrate how imagemaps are put together, I'll show you the five images that make up a smaller imagemap."
    e "Otay emonstrateday owhay imagemapsay areay utpay ogethertay, Iay'llay owshay ouyay hetay ivefay imagesay hattay akemay upay aay mallersay imagemapay."

# game/tutorial_screen_displayables.rpy:697
translate piglatin imagemap_done_ac9631ef:

    # e "The idle image is used for the background of the imagemap, for hotspot buttons that aren't focused or selected, and for the empty part of an unfocused bar."
    e "Hetay idleay imageay isay useday orfay hetay ackgroundbay ofay hetay imagemapay, orfay otspothay uttonsbay hattay arenay'tay ocusedfay oray electedsay, anday orfay hetay emptyay artpay ofay anay unfocuseday arbay."

# game/tutorial_screen_displayables.rpy:703
translate piglatin imagemap_done_123b5924:

    # e "The hover image is used for hotspots that are focused but not selected, and for the empty part of a focused bar."
    e "Hetay overhay imageay isay useday orfay otspotshay hattay areay ocusedfay utbay otnay electedsay, anday orfay hetay emptyay artpay ofay aay ocusedfay arbay."

# game/tutorial_screen_displayables.rpy:705
translate piglatin imagemap_done_37f538dc:

    # e "Notice how both the bar and button are highlighted in this image. When we display them as part of a screen, only one of them will show up as focused."
    e "Oticenay owhay othbay hetay arbay anday uttonbay areay ighlightedhay inay histay imageay. Henway eway isplayday hemtay asay artpay ofay aay creensay, onlyay oneay ofay hemtay illway owshay upay asay ocusedfay."

# game/tutorial_screen_displayables.rpy:711
translate piglatin imagemap_done_c76b072d:

    # e "Selected images like this selected_idle image are used for parts of the bar that are filled, and for selected buttons, like the current screen and a checked checkbox."
    e "Electedsay imagesay ikelay histay elected_idlesay imageay areay useday orfay artspay ofay hetay arbay hattay areay illedfay, anday orfay electedsay uttonsbay, ikelay hetay urrentcay creensay anday aay eckedchay eckboxchay."

# game/tutorial_screen_displayables.rpy:717
translate piglatin imagemap_done_241a4112:

    # e "Here's the selected_hover image. The button here will never be shown, since it will never be marked as selected."
    e "Erehay'say hetay elected_hoversay imageay. Hetay uttonbay erehay illway evernay ebay ownshay, incesay itay illway evernay ebay arkedmay asay electedsay."

# game/tutorial_screen_displayables.rpy:723
translate piglatin imagemap_done_3d8f454c:

    # e "Finally, an insensitive image can be given, which is used when a hotspot can't be interacted with."
    e "Inallyfay, anay insensitiveay imageay ancay ebay ivengay, hichway isay useday henway aay otspothay ancay'tay ebay interacteday ithway."

# game/tutorial_screen_displayables.rpy:728
translate piglatin imagemap_done_ca286729:

    # e "Imagemaps aren't limited to just images. Any displayable can be used where an image is expected."
    e "Magemapsiay arenay'tay imitedlay otay ustjay imagesay. Nyaay isplayableday ancay ebay useday hereway anay imageay isay expecteday."

# game/tutorial_screen_displayables.rpy:743
translate piglatin imagemap_done_6060b17f:

    # e "Here's an imagemap built using those five images. Now that it's an imagemap, you can interact with it if you want to."
    e "Erehay'say anay imagemapay uiltbay usingay hosetay ivefay imagesay. Ownay hattay itay'say anay imagemapay, ouyay ancay interactay ithway itay ifay ouyay antway otay."

# game/tutorial_screen_displayables.rpy:755
translate piglatin imagemap_done_c817794d:

    # e "To make this a little more concise, we can replace the five images with the auto property, which replaces '%%s' with 'idle', 'hover', 'selected_idle', 'selected_hover', or 'insensitive' as appropriate."
    e "Otay akemay histay aay ittlelay oremay oncisecay, eway ancay eplaceray hetay ivefay imagesay ithway hetay autoay ropertypay, hichway eplacesray '%%say' ithway 'idleay', 'overhay', 'elected_idlesay', 'elected_hoversay', oray 'insensitiveay' asay appropriateay."

# game/tutorial_screen_displayables.rpy:757
translate piglatin imagemap_done_c1ed91b8:

    # e "Feel free to omit the selected and insensitive images if your game doesn't need them. Ren'Py will use the idle or hover images to replace them."
    e "Eelfay eefray otay omitay hetay electedsay anday insensitiveay imagesay ifay ouryay amegay oesnday'tay eednay hemtay. Enray'Ypay illway useay hetay idleay oray overhay imagesay otay eplaceray hemtay."

# game/tutorial_screen_displayables.rpy:759
translate piglatin imagemap_done_166f75db:

    # e "The hotspot and hotbar statements describe areas of the imagemap that should act as buttons or bars, respectively."
    e "Hetay otspothay anday otbarhay atementsstay escribeday areasay ofay hetay imagemapay hattay ouldshay actay asay uttonsbay oray arsbay, espectivelyray."

# game/tutorial_screen_displayables.rpy:761
translate piglatin imagemap_done_becb9688:

    # e "Both take the coordinates of the area, in (x, y, width, height) format."
    e "Othbay aketay hetay oordinatescay ofay hetay areaay, inay (xay, yay, idthway, eighthay) ormatfay."

# game/tutorial_screen_displayables.rpy:763
translate piglatin imagemap_done_fd56baa2:

    # e "A hotspot takes an action that is run when the hotspot is activated. It can also take actions that are run when it's hovered and unhovered, just like a button can."
    e "Aay otspothay akestay anay actionay hattay isay unray henway hetay otspothay isay activateday. Tiay ancay alsoay aketay actionsay hattay areay unray henway itay'say overedhay anday unhovereday, ustjay ikelay aay uttonbay ancay."

# game/tutorial_screen_displayables.rpy:765
translate piglatin imagemap_done_5660a6a2:

    # e "A hotbar takes a BarValue object that describes how full the bar is, and the range of values the bar should display, just like a bar and vbar does."
    e "Aay otbarhay akestay aay Arvaluebay objectay hattay escribesday owhay ullfay hetay arbay isay, anday hetay angeray ofay aluesvay hetay arbay ouldshay isplayday, ustjay ikelay aay arbay anday barvay oesday."

# game/tutorial_screen_displayables.rpy:772
translate piglatin imagemap_done_10496a29:

    # e "A useful pattern is to define a screen with an imagemap that has hotspots that jump to labels, and call that using the call screen statement."
    e "Aay usefulay atternpay isay otay efineday aay creensay ithway anay imagemapay hattay ashay otspotshay hattay umpjay otay abelslay, anday allcay hattay usingay hetay allcay creensay atementstay."

# game/tutorial_screen_displayables.rpy:774
translate piglatin imagemap_done_dcb45224:

    # e "That's what we did in the school example I showed before. Here's the script for it. It's long, but the imagemap itself is fairly simple."
    e "Hattay'say hatway eway idday inay hetay choolsay exampleay Iay owedshay eforebay. Erehay'say hetay criptsay orfay itay. Tiay'say onglay, utbay hetay imagemapay itselfay isay airlyfay implesay."

# game/tutorial_screen_displayables.rpy:778
translate piglatin imagemap_done_5b5bc5e5:

    # e "Imagemaps have pluses and minuses. On one hand, they are easy for a designer to create, and can look very good. At the same time, they can be hard to translate, and text baked into images may be blurry when the window is scaled."
    e "Magemapsiay avehay usesplay anday inusesmay. Noay oneay andhay, heytay areay easyay orfay aay esignerday otay reatecay, anday ancay ooklay eryvay oodgay. Taay hetay amesay imetay, heytay ancay ebay ardhay otay anslatetray, anday exttay akedbay intoay imagesay aymay ebay urryblay henway hetay indowway isay caledsay."

# game/tutorial_screen_displayables.rpy:780
translate piglatin imagemap_done_b6cebf2b:

    # e "It's up to you and your team to decide if imagemaps are right for your project."
    e "Tiay'say upay otay ouyay anday ouryay eamtay otay ecideday ifay imagemapsay areay ightray orfay ouryay rojectpay."

# game/tutorial_screen_displayables.rpy:787
translate piglatin viewport_displayables_e509d50d:

    # e "Sometimes, you'll want to display something bigger than the screen. That's what the viewport displayable is for."
    e "Ometimessay, ouyay'llay antway otay isplayday omethingsay iggerbay hantay hetay creensay. Hattay'say hatway hetay iewportvay isplayableday isay orfay."

# game/tutorial_screen_displayables.rpy:803
translate piglatin viewport_displayables_9853b0e3:

    # e "Here's an example of a simple viewport, used to display a single image that's far bigger than the screen. Since the viewport will expand to the size of the screen, we use the xysize property to make it smaller."
    e "Erehay'say anay exampleay ofay aay implesay iewportvay, useday otay isplayday aay inglesay imageay hattay'say arfay iggerbay hantay hetay creensay. Incesay hetay iewportvay illway expanday otay hetay izesay ofay hetay creensay, eway useay hetay ysizexay ropertypay otay akemay itay mallersay."

# game/tutorial_screen_displayables.rpy:805
translate piglatin viewport_displayables_778668c8:

    # e "By default the viewport can't be moved, so we give the draggable, mousewheel, and arrowkeys properties to allow it to be moved in multiple ways."
    e "Ybay efaultday hetay iewportvay ancay'tay ebay ovedmay, osay eway ivegay hetay raggableday, ousewheelmay, anday arrowkeysay ropertiespay otay alloway itay otay ebay ovedmay inay ultiplemay aysway."

# game/tutorial_screen_displayables.rpy:820
translate piglatin viewport_displayables_bbd63377:

    # e "When I give the viewport the edgescroll property, the viewport automatically scrolls when the mouse is near its edges. The two numbers are the size of the edges, and the speed in pixels per second."
    e "Henway Iay ivegay hetay iewportvay hetay edgescrollay ropertypay, hetay iewportvay automaticallyay crollssay henway hetay ousemay isay earnay itsay edgesay. Hetay wotay umbersnay areay hetay izesay ofay hetay edgesay, anday hetay peedsay inay ixelspay erpay econdsay."

# game/tutorial_screen_displayables.rpy:839
translate piglatin viewport_displayables_7c4678ee:

    # e "Giving the viewport the scrollbars property surrounds it with scrollbars. The scrollbars property can take 'both', 'horizontal', and 'vertical' as values."
    e "Ivinggay hetay iewportvay hetay crollbarssay ropertypay urroundssay itay ithway crollbarssay. Hetay crollbarssay ropertypay ancay aketay 'othbay', 'orizontalhay', anday 'erticalvay' asay aluesvay."

# game/tutorial_screen_displayables.rpy:841
translate piglatin viewport_displayables_197953b5:

    # e "The spacing property controls the space between the viewport and its scrollbars, in pixels."
    e "Hetay pacingsay ropertypay ontrolscay hetay pacesay etweenbay hetay iewportvay anday itsay crollbarssay, inay ixelspay."

# game/tutorial_screen_displayables.rpy:864
translate piglatin viewport_displayables_54dd6e7b:

    # e "The xinitial and yinitial properties set the initial amount of scrolling, as a fraction of the amount that can be scrolled."
    e "Hetay initialxay anday initialyay ropertiespay etsay hetay initialay amountay ofay crollingsay, asay aay actionfray ofay hetay amountay hattay ancay ebay crolledsay."

# game/tutorial_screen_displayables.rpy:885
translate piglatin viewport_displayables_c047efb5:

    # e "Finally, there's the child_size property. To explain what it does, I first have to show you what happens when we don't have it."
    e "Inallyfay, heretay'say hetay ild_sizechay ropertypay. Otay explainay hatway itay oesday, Iay irstfay avehay otay owshay ouyay hatway appenshay henway eway onday'tay avehay itay."

# game/tutorial_screen_displayables.rpy:887
translate piglatin viewport_displayables_c563019f:

    # e "As you can see, the text wraps. That's because Ren'Py is offering it space that isn't big enough."
    e "Saay ouyay ancay eesay, hetay exttay rapsway. Hattay'say ecausebay Enray'Ypay isay offeringay itay pacesay hattay isnay'tay igbay enoughay."

# game/tutorial_screen_displayables.rpy:909
translate piglatin viewport_displayables_4bcf0ad0:

    # e "When we give the screen a child_size, it offers more space to its children, allowing scrolling. It takes a horizontal and vertical size. If one component is None, it takes the size of the viewport."
    e "Henway eway ivegay hetay creensay aay ild_sizechay, itay offersay oremay pacesay otay itsay ildrenchay, allowingay crollingsay. Tiay akestay aay orizontalhay anday erticalvay izesay. Fiay oneay omponentcay isay Onenay, itay akestay hetay izesay ofay hetay iewportvay."

# game/tutorial_screen_displayables.rpy:936
translate piglatin viewport_displayables_ae4ff821:

    # e "Finally, there's the vpgrid displayable. It combines a viewport and a grid into a single displayable, except it's more efficient than either, since it doesn't have to draw every child."
    e "Inallyfay, heretay'say hetay pgridvay isplayableday. Tiay ombinescay aay iewportvay anday aay idgray intoay aay inglesay isplayableday, exceptay itay'say oremay efficientay hantay eitheray, incesay itay oesnday'tay avehay otay rawday everyay ildchay."

# game/tutorial_screen_displayables.rpy:938
translate piglatin viewport_displayables_71fa0b8f:

    # e "It takes the cols and rows properties, which give the number of rows and columns of children. If one is omitted, Ren'Py figures it out from the other and the number of children."
    e "Tiay akestay hetay olscay anday owsray ropertiespay, hichway ivegay hetay umbernay ofay owsray anday olumnscay ofay ildrenchay. Fiay oneay isay omitteday, Enray'Ypay iguresfay itay outay omfray hetay otheray anday hetay umbernay ofay ildrenchay."

translate piglatin strings:

    # game/tutorial_screen_displayables.rpy:9
    old "Common properties all displayables share."
    new "Ommoncay ropertiespay allay isplayablesday areshay."

    # game/tutorial_screen_displayables.rpy:9
    old "Adding images and other displayables."
    new "Ddingaay imagesay anday otheray isplayablesday."

    # game/tutorial_screen_displayables.rpy:9
    old "Text."
    new "Exttay."

    # game/tutorial_screen_displayables.rpy:9
    old "Boxes and other layouts."
    new "Oxesbay anday otheray ayoutslay."

    # game/tutorial_screen_displayables.rpy:9
    old "Windows and frames."
    new "Indowsway anday amesfray."

    # game/tutorial_screen_displayables.rpy:9
    old "Buttons."
    new "Uttonsbay."

    # game/tutorial_screen_displayables.rpy:9
    old "Bars."
    new "Arsbay."

    # game/tutorial_screen_displayables.rpy:9
    old "Viewports."
    new "Iewportsvay."

    # game/tutorial_screen_displayables.rpy:9
    old "Imagemaps."
    new "Magemapsiay."

    # game/tutorial_screen_displayables.rpy:9
    old "That's all for now."
    new "Hattay'say allay orfay ownay."

    # game/tutorial_screen_displayables.rpy:55
    old "This uses position properties."
    new "Histay usesay ositionpay ropertiespay."

    # game/tutorial_screen_displayables.rpy:63
    old "And the world turned upside down..."
    new "Ndaay hetay orldway urnedtay upsideay ownday..."

    # game/tutorial_screen_displayables.rpy:115
    old "Flight pressure in tanks."
    new "Lightfay ressurepay inay ankstay."

    # game/tutorial_screen_displayables.rpy:116
    old "On internal power."
    new "Noay internalay owerpay."

    # game/tutorial_screen_displayables.rpy:117
    old "Launch enabled."
    new "Aunchlay enableday."

    # game/tutorial_screen_displayables.rpy:118
    old "Liftoff!"
    new "Iftofflay!"

    # game/tutorial_screen_displayables.rpy:232
    old "The answer is [answer]."
    new "Hetay answeray isay [answer]."

    # game/tutorial_screen_displayables.rpy:244
    old "Text tags {color=#c8ffc8}work{/color} in screens."
    new "Exttay agstay {color=#c8ffc8}orkway{/color} inay creenssay."

    # game/tutorial_screen_displayables.rpy:336
    old "Bigger"
    new "Iggerbay"

    # game/tutorial_screen_displayables.rpy:401
    old "This is a screen."
    new "Histay isay aay creensay."

    # game/tutorial_screen_displayables.rpy:402
    old "Okay"
    new "Kayoay"

    # game/tutorial_screen_displayables.rpy:440
    old "You clicked the button."
    new "Ouyay ickedclay hetay uttonbay."

    # game/tutorial_screen_displayables.rpy:441
    old "Click me."
    new "Lickcay emay."

    # game/tutorial_screen_displayables.rpy:453
    old "You hovered the button."
    new "Ouyay overedhay hetay uttonbay."

    # game/tutorial_screen_displayables.rpy:454
    old "You unhovered the button."
    new "Ouyay unhovereday hetay uttonbay."

    # game/tutorial_screen_displayables.rpy:470
    old "Heal"
    new "Ealhay"

    # game/tutorial_screen_displayables.rpy:479
    old "This is a textbutton."
    new "Histay isay aay extbuttontay."

    # game/tutorial_screen_displayables.rpy:539
    old "Or me."
    new "Roay emay."

    # game/tutorial_screen_displayables.rpy:541
    old "You clicked the other button."
    new "Ouyay ickedclay hetay otheray uttonbay."

    # game/tutorial_screen_displayables.rpy:880
    old "This text is wider than the viewport."
    new "Histay exttay isay iderway hantay hetay iewportvay."

