<!-- markdownlint-disable first-line-h1 -->
<!-- markdownlint-disable no-duplicate-header -->
<!-- markdownlint-disable header-increment -->
### Release highlights

ROCm 5.6 consists of several AI software ecosystem improvements to our fast-growing user base.  A
few examples include:

* New documentation portal at https://rocm.docs.amd.com
* Ongoing software enhancements for LLMs, ensuring full compliance with the HuggingFace unit test
  suite
* OpenAI Triton, CuPy, HIP Graph support, and many other library performance enhancements
* Improved ROCm deployment and development tools, including CPU-GPU (rocGDB) debugger,
  profiler, and docker containers
* New pseudorandom generators are available in rocRAND.  Added support for half-precision
  transforms in hipFFT/rocFFT.  Added LU refactorization and linear system solver for sparse matrices in
  rocSOLVER.

### OS and GPU support changes

* SLES15 SP5 support was added this release. SLES15 SP3 support was dropped.
* AMD Instinct MI50, Radeon Pro VII, and Radeon VII products (collectively referred to as gfx906 GPUs)
  will be entering the maintenance mode starting Q3 2023. This will be aligned with ROCm 5.7 GA
  release date.
  * No new features and performance optimizations will be supported for the gfx906 GPUs beyond
    ROCm 5.7
  * Bug fixes / critical security patches will continue to be supported for the gfx906 GPUs till Q2 2024
    (EOM will be aligned with the closest ROCm release)
  * Bug fixes during the maintenance will be made to the next ROCm point release
  * Bug fixes will not be back ported to older ROCm releases for this SKU
  * Distro / Operating system updates will continue per the ROCm release cadence for gfx906 GPUs till
    EOM.

### AMDSMI CLI 23.0.0.4

#### Additions

* AMDSMI CLI tool enabled for Linux Bare Metal & Guest

* Package: amd-smi-lib

#### Known issues

* not all Error Correction Code (ECC) fields are currently supported

* RHEL 8 & SLES 15 have extra install steps

### Kernel modules (DKMS)

#### Fixes

* Stability fix for multi GPU system reproducible via ROCm_Bandwidth_Test as reported in
  [Issue 2198](https://github.com/ROCm/ROCm/issues/2198).

### HIP 5.6 (for ROCm 5.6)

#### Optimizations

* Consolidation of hipamd, rocclr and OpenCL projects in clr
* Optimized lock for graph global capture mode

#### Additions

* Added hipRTC support for amd_hip_fp16
* Added hipStreamGetDevice implementation to get the device associated with the stream
* Added HIP_AD_FORMAT_SIGNED_INT16 in hipArray formats
* hipArrayGetInfo for getting information about the specified array
* hipArrayGetDescriptor for getting 1D or 2D array descriptor
* hipArray3DGetDescriptor to get 3D array descriptor

#### Changes

* hipMallocAsync to return success for zero size allocation to match hipMalloc
* Separation of hipcc perl binaries from HIP project to hipcc project. hip-devel package depends on newly added hipcc package
* Consolidation of hipamd, ROCclr, and OpenCL repositories into a single repository called clr. Instructions are updated to build HIP from sources in the HIP Installation guide
* Removed hipBusBandwidth and hipCommander samples from hip-tests

#### Fixes

* Fixed regression in hipMemCpyParam3D when offset is applied

#### Known issues

* Limited testing on xnack+ configuration
  * Multiple HIP tests failures (gpuvm fault or hangs)
* hipSetDevice and hipSetDeviceFlags APIs return hipErrorInvalidDevice instead of hipErrorNoDevice, on a system without GPU
* Known memory leak when code object files are loaded/unloaded via hipModuleLoad/hipModuleUnload APIs. Issue will be fixed in a future ROCm release

#### Upcoming changes in future release

* Removal of gcnarch from hipDeviceProp_t structure
* Addition of new fields in hipDeviceProp_t structure
  * maxTexture1D
  * maxTexture2D
  * maxTexture1DLayered
  * maxTexture2DLayered
  * sharedMemPerMultiprocessor
  * deviceOverlap
  * asyncEngineCount
  * surfaceAlignment
  * unifiedAddressing
  * computePreemptionSupported
  * uuid
* Removal of deprecated code
  * hip-hcc codes from hip code tree
* Correct hipArray usage in HIP APIs such as hipMemcpyAtoH and hipMemcpyHtoA
* HIPMEMCPY_3D fields correction (unsigned int -> size_t)
* Renaming of 'memoryType' in hipPointerAttribute_t structure to 'type'

### ROCgdb-13 (For ROCm 5.6.0)

#### Optimizations

* Improved performances when handling the end of a process with a large number of threads.

#### Known issues

* On certain configurations, ROCgdb can show the following warning message:

  `warning: Probes-based dynamic linker interface failed. Reverting to original interface.`

  This does not affect ROCgdb's functionalities.

### ROCprofiler (for ROCm 5.6.0)

In ROCm 5.6 the `rocprofilerv1` and `rocprofilerv2` include and library files of
ROCm 5.5 are split into separate files. The `rocmtools` files that were
deprecated in ROCm 5.5 have been removed.

  | ROCm 5.6        | rocprofilerv1                       | rocprofilerv2                          |
  |-----------------|-------------------------------------|----------------------------------------|
  | **Tool script** | `bin/rocprof`                       | `bin/rocprofv2`                        |
  | **API include** | `include/rocprofiler/rocprofiler.h` | `include/rocprofiler/v2/rocprofiler.h` |
  | **API library** | `lib/librocprofiler.so.1`           | `lib/librocprofiler.so.2`              |

The ROCm Profiler Tool that uses `rocprofilerV1` can be invoked using the
following command:

```sh
rocprof …
```

To write a custom tool based on the `rocprofilerV1` API do the following:

```C
main.c:
#include <rocprofiler/rocprofiler.h> // Use the rocprofilerV1 API
int main() {
  // Use the rocprofilerV1 API
  return 0;
}
```

This can be built in the following manner:

```sh
gcc main.c -I/opt/rocm-5.6.0/include -L/opt/rocm-5.6.0/lib -lrocprofiler64
```

The resulting `a.out` will depend on
`/opt/rocm-5.6.0/lib/librocprofiler64.so.1`.

The ROCm Profiler that uses `rocprofilerV2` API can be invoked using the
following command:

```sh
rocprofv2 …
```

To write a custom tool based on the `rocprofilerV2` API do the following:

```C
main.c:
#include <rocprofiler/v2/rocprofiler.h> // Use the rocprofilerV2 API
int main() {
  // Use the rocprofilerV2 API
  return 0;
}
```

This can be built in the following manner:

```sh
gcc main.c -I/opt/rocm-5.6.0/include -L/opt/rocm-5.6.0/lib -lrocprofiler64-v2
```

The resulting `a.out` will depend on
`/opt/rocm-5.6.0/lib/librocprofiler64.so.2`.

#### Optimizations

* Improved Test Suite

#### Additions

* 'end_time' need to be disabled in roctx_trace.txt

#### Fixes

* rocprof in ROcm/5.4.0 gpu selector broken.
* rocprof in ROCm/5.4.1 fails to generate kernel info.
* rocprof clobbers LD_PRELOAD.
