An immutable variable was reassigned.

Erroneous code example:

```compile_fail,E0384
fn main() {
    let x = 3;
    x = 5; // error, reassignment of immutable variable
}
```

By default, variables in Rust are immutable. To fix this error, add the keyword
`mut` after the keyword `let` when declaring the variable. For example:

```
fn main() {
    let mut x = 3;
    x = 5;
}
```

Alternatively, you might consider initializing a new variable: either with a new
bound name or (by [shadowing]) with the bound name of your existing variable.
For example:

[shadowing]: https://doc.rust-lang.org/book/ch03-01-variables-and-mutability.html#shadowing

```
fn main() {
    let x = 3;
    let x = 5;
}
```
