## TFSA-2021-154: Division by zero in TFLite

### CVE Number
CVE-2021-37680

### Impact
The implementation of fully connected layers in TFLite is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/fully_connected.cc#L226):

```cc
const int batch_size = input_size / filter->dims->data[1];
```

An attacker can craft a model such that `filter->dims->data[1]` is 0.

### Patches
We have patched the issue in GitHub commit
[718721986aa137691ee23f03638867151f74935f](https://github.com/tensorflow/tensorflow/commit/718721986aa137691ee23f03638867151f74935f).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360. Concurrently, it has also been reported by Yakun Zhang of Baidu Security.
