## TFSA-2022-137: Null dereference on MLIR on empty function attributes

### CVE Number
CVE-2022-36011

### Impact
When [`mlir::tfg::ConvertGenericFunctionToFunctionDef`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/ir/importexport/functiondef_import.cc) is given empty function attributes, it gives a null dereference.
```cpp
// Import the function attributes with a `tf.` prefix to match the current
// infrastructure expectations.
for (const auto& namedAttr : func.attr()) {
  const std::string& name = "tf." + namedAttr.first;
  const AttrValue& tf_attr = namedAttr.second;
  TF_ASSIGN_OR_RETURN(Attribute attr,
                      ConvertAttributeValue(tf_attr, builder, tfgDialect));
  attrs.append(name, attr);
}
```
If `namedAttr.first` is empty, it will crash.

### Patches
We have patched the issue in GitHub commit [1cf45b831eeb0cab8655c9c7c5d06ec6f45fc41b](https://github.com/tensorflow/tensorflow/commit/1cf45b831eeb0cab8655c9c7c5d06ec6f45fc41b).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
