# OGDF

[![Conan Center](https://img.shields.io/conan/v/ogdf)](https://conan.io/center/recipes/ogdf)
[![vcpkg](https://img.shields.io/vcpkg/v/ogdf)](https://vcpkg.roundtrip.dev/ports/ogdf)

OGDF stands both for **O**pen **G**raph **D**rawing **F**ramework (the original name)
and **O**pen **G**raph algorithms and **D**ata structures **F**ramework.

OGDF is a self-contained C++ library for graph algorithms,
in particular for (but not restricted to) automatic graph drawing.
It offers sophisticated algorithms and data structures to use
within your own applications or scientific projects.

OGDF is developed and supported by
[Osnabrück University](https://tcs.informatik.uos.de/),
[University of Passau](https://www.fim.uni-passau.de/en/theoretical-computer-science/),
[University of Konstanz](https://www.cls.uni-konstanz.de/),
[TU Vienna](https://www.ac.tuwien.ac.at/),
and [TU Ilmenau](https://www.tu-ilmenau.de/dma/).

## Shortcuts

* [How to Install](doc/build.md)
* [Release Notes](doc/relnotes.md) and [Porting Guide](doc/porting.md)
* [Reference Documentation](https://ogdf.github.io/doc/ogdf/)
* [Developer's Guide](doc/dev-guide.md)
* [Compiler Defines](doc/defines.md)
* [Official Website](http://ogdf.net/)

## License

This software is distributed under the terms of the GNU
General Public License v2 or v3, with special exceptions.
By installing this software you agree to these license terms.

See [LICENSE.txt](LICENSE.txt) for more information on the license and
included third-party software, like frameworks for
linear programming or unit testing.

## Copyright

All files in the OGDF distribution (except for third-party
software) are copyrighted:

Copyright (C) 1999–2023
