.\" @(#)xthreed.man
.\"
.\" Copyright 1995 - 2024  David A. Bagley
.\"
.\" All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH THREED 6 "15 Aug 2024" "V8.8.4"
.SH NAME
xthreed \- Threed X widget
.SH SYNOPSIS
.B /usr/games/xthreed
[\-geometry [{width}][x{height}][{+\-}{xoff}[{+\-}{yoff}]]]
[\-display [{host}]:[{vs}]] [\-{foreground|fg} {color}]
[\-{background|bg} {color}] [\-{border|bd} {color}]
[\-white {color}] [\-[lt|dk|ltlt|dkdk]gray {color}]
[\-black {color}] [\-another {color}] [\-select {color}]
[\-frame {color}] [\-[no]stippleFrame] [\-delay msecs]
[\-[no]sound] [\-bumpSound {filename}]
[\-moveSound {filename}] [\-[no]surface] [\-object {int}]
[\-x {int}] [\-y {int}] [\-z {int}] [\-theta {int}]
[\-phi {int}] [\-psi {int}] [\-version]
.SH DESCRIPTION
A simple 3D viewer (though may need some work).
.LP
The roll part does not seem to be quite right and may not
track well.  Of note is the mouse to 3D surface detection.
.LP
In the sample data, Cubes and F16 are big, so the polyhedrons
are scaled up to them in the data file.
.LP
Press "\fBL\fP" or "\fBl\fP" keys to move shape left.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to move shape right.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to move shape up.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to move shape down.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to move shape in.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to move shape out.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to change surface.
.LP
Press "\fBB\fP" or "\fBb\fP" keys to change object.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
"\fBQ\fP", "\fBq\fP", or "\fBCTRL\-C\fP" keys kill program.
.LP
Use the key pad or arrow keys to rotate object.
.br
Key pad is defined for Threed as:
.br
  /      Counterclockwise
.sp
  8      Up
.br
  ^
.br
4<5>6  Left, Clockwise, Right
.br
  v
.br
  2      Down
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the threed window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the threed window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the threed window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the color of the surface border (resource
name "\fIsurfaceBorder\fP").
.TP 8
.B \-white \fIcolor\fP
This option specifies the color of the white paintbrush (resource name
"\fIwhiteBrush\fP").
.TP 8
.B \-[lt|dk|ltlt|dkdk]gray \fIcolor\fP
This option specifies the color of the gray the paintbrush (resource name
"\fI[lt|dk|ltlt|dkdk]grayBrush\fP").
.TP 8
.B \-black \fIcolor\fP
This option specifies the color of the black of the paintbrush (resource name
"\fIblackBrush\fP").
.TP 8
.B \-another \fIcolor\fP
This option specifies the of color of the a paintbrush (resource name
"\fIanotherBrush\fP").
.TP 8
.B \-select \fIcolor\fP
This option specifies the color for selected item (resource name
"\fIselectColor\fP").
TP 8
.B \-frame \fIcolor\fP
This option specifies the color of the frame (resource name
"\fIframeColor\fP").
.TP 8
.B \-[no]stippleFrame
This option allows you to toggle the frame stippling (resource name
"\fIstippleFrame\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move
(1\-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound for the clicking of
a new surface (resource name "\fIbumpSound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound (not used yet)
(resource name "\fImoveSound\fP").
.TP 8
.B \-[no]surface
This option allows you to access the hidden surface removal mode and
wire mode (resource name "\fIsurface\fP").
.TP 8
.B \-object <\fIint\fP>
This option allows you to set the object to be viewed (resource name
"\fIobject\fP").
.TP 8
.B \-distance <\fIint\fP>
This option allows you to set the distance of the object to be viewed
(resource name "\fIdistance\fP").
.TP 8
.B \-theta <\fIint\fP>
This option allows you to set the angle of the to be viewed in degrees
(resource name "\fIthetaDegrees\fP").  This corresponds to yaw.
.TP 8
.B \-phi <\fIint\fP>
This option allows you to set the angle of the to be viewed in degrees
(resource name "\fIphiDegrees\fP").  This corresponds to pitch.
.TP 8
.B \-psi <\fIint\fP>
This option allows you to set the angle of the to be viewed in degrees
(resource name "\fIpsiDegrees\fP").  This corresponds to roll.
.TP 8
.B \-version
This option tells you what version of xthreed you have.
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6),
xpanex(6), xmball(6), xpyraminx(6), xoct(6), xrubik(6), xskewb(6),
xdino(6), xbevel(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1995\-2024, David A. Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd AT verizon.net\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttps://www.sillycycle.com/threed.html\fP
