; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i32 @test1(i32 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = or i32 %A, 0
  ret i32 %B
}

define i32 @all_ones(i32 %A) {
; CHECK-LABEL: @all_ones(
; CHECK-NEXT:    ret i32 -1
;
  %B = or i32 %A, -1
  ret i32 %B
}

define <3 x i8> @all_ones_vec_with_undef_elt(<3 x i8> %A) {
; CHECK-LABEL: @all_ones_vec_with_undef_elt(
; CHECK-NEXT:    ret <3 x i8> <i8 -1, i8 -1, i8 -1>
;
  %B = or <3 x i8> %A, <i8 -1, i8 undef, i8 -1>
  ret <3 x i8> %B
}

define i1 @test3(i1 %A) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %B = or i1 %A, false
  ret i1 %B
}

define i1 @test4(i1 %A) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret i1 true
;
  %B = or i1 %A, true
  ret i1 %B
}

define i1 @test5(i1 %A) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %B = or i1 %A, %A
  ret i1 %B
}

define i32 @test6(i32 %A) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = or i32 %A, %A
  ret i32 %B
}

; A | ~A == -1

define i32 @or_not(i32 %A) {
; CHECK-LABEL: @or_not(
; CHECK-NEXT:    ret i32 -1
;
  %NotA = xor i32 %A, -1
  %B = or i32 %A, %NotA
  ret i32 %B
}

define <2 x i4> @or_not_commute_vec_undef(<2 x i4> %A) {
; CHECK-LABEL: @or_not_commute_vec_undef(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %NotA = xor <2 x i4> %A, <i4 -1, i4 undef>
  %B = or <2 x i4> %NotA, %A
  ret <2 x i4> %B
}

define i8 @test8(i8 %A) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    ret i8 -1
;
  %B = or i8 %A, -2
  %C = or i8 %B, 1
  ret i8 %C
}

; Test that (A|c1)|(B|c2) == (A|B)|(c1|c2)
define i8 @test9(i8 %A, i8 %B) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    ret i8 -1
;
  %C = or i8 %A, 1
  %D = or i8 %B, -2
  %E = or i8 %C, %D
  ret i8 %E
}

; (X & C1) | C2 --> (X | C2) & (C1|C2)
define i8 @test10(i8 %A) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    ret i8 -2
;
  %B = or i8 %A, 1
  %C = and i8 %B, -2
  %D = or i8 %C, -2
  ret i8 %D
}

; The following two cases only get folded by InstCombine,
; see InstCombine/or-xor.ll.

; (X ^ C1) | C2 --> (X | C2) ^ (C1&~C2)
define i8 @test11(i8 %A) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[B:%.*]] = or i8 [[A:%.*]], -2
; CHECK-NEXT:    [[C:%.*]] = xor i8 [[B]], 13
; CHECK-NEXT:    [[D:%.*]] = or i8 [[C]], 1
; CHECK-NEXT:    [[E:%.*]] = xor i8 [[D]], 12
; CHECK-NEXT:    ret i8 [[E]]
;
  %B = or i8 %A, -2
  %C = xor i8 %B, 13
  %D = or i8 %C, 1
  %E = xor i8 %D, 12
  ret i8 %E
}

define i8 @test11v(<2 x i8> %A) {
; CHECK-LABEL: @test11v(
; CHECK-NEXT:    [[B:%.*]] = or <2 x i8> [[A:%.*]], <i8 -2, i8 0>
; CHECK-NEXT:    [[CV:%.*]] = xor <2 x i8> [[B]], <i8 13, i8 13>
; CHECK-NEXT:    [[C:%.*]] = extractelement <2 x i8> [[CV]], i32 0
; CHECK-NEXT:    [[D:%.*]] = or i8 [[C]], 1
; CHECK-NEXT:    [[E:%.*]] = xor i8 [[D]], 12
; CHECK-NEXT:    ret i8 [[E]]
;
  %B = or <2 x i8> %A, <i8 -2, i8 0>
  %CV = xor <2 x i8> %B, <i8 13, i8 13>
  %C = extractelement <2 x i8> %CV, i32 0
  %D = or i8 %C, 1
  %E = xor i8 %D, 12
  ret i8 %E
}

; Test the case where integer BitWidth <= 64 && BitWidth % 2 != 0.
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace with V+N.
define i39 @test1_apint(i39 %V, i39 %M) {
; CHECK-LABEL: @test1_apint(
; CHECK-NEXT:    [[N:%.*]] = and i39 [[M:%.*]], -274877906944
; CHECK-NEXT:    [[A:%.*]] = add i39 [[V:%.*]], [[N]]
; CHECK-NEXT:    ret i39 [[A]]
;
  %C1 = xor i39 274877906943, -1 ;; C2 = 274877906943
  %N = and i39 %M, 274877906944
  %A = add i39 %V, %N
  %B = and i39 %A, %C1
  %D = and i39 %V, 274877906943
  %R = or i39 %B, %D
  ret i39 %R
}

define i7 @test2_apint(i7 %X) {
; CHECK-LABEL: @test2_apint(
; CHECK-NEXT:    ret i7 [[X:%.*]]
;
  %Y = or i7 %X, 0
  ret i7 %Y
}

define i17 @test3_apint(i17 %X) {
; CHECK-LABEL: @test3_apint(
; CHECK-NEXT:    ret i17 -1
;
  %Y = or i17 %X, -1
  ret i17 %Y
}

; Test the case where Integer BitWidth > 64 && BitWidth <= 1024.
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace with V+N.
define i399 @test4_apint(i399 %V, i399 %M) {
; CHECK-LABEL: @test4_apint(
; CHECK-NEXT:    [[N:%.*]] = and i399 [[M:%.*]], 18446742974197923840
; CHECK-NEXT:    [[A:%.*]] = add i399 [[V:%.*]], [[N]]
; CHECK-NEXT:    ret i399 [[A]]
;
  %C1 = xor i399 274877906943, -1 ;; C2 = 274877906943
  %N = and i399 %M, 18446742974197923840
  %A = add i399 %V, %N
  %B = and i399 %A, %C1
  %D = and i399 %V, 274877906943
  %R = or i399 %D, %B
  ret i399 %R
}

define i777 @test5_apint(i777 %X) {
; CHECK-LABEL: @test5_apint(
; CHECK-NEXT:    ret i777 [[X:%.*]]
;
  %Y = or i777 %X, 0
  ret i777 %Y
}

define i117 @test6_apint(i117 %X) {
; CHECK-LABEL: @test6_apint(
; CHECK-NEXT:    ret i117 -1
;
  %Y = or i117 %X, -1
  ret i117 %Y
}

; Test the case where integer BitWidth <= 64 && BitWidth % 2 != 0.
; Vector version of test1_apint with the add commuted
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace with V+N.
define <2 x i39> @test7_apint(<2 x i39> %V, <2 x i39> %M) {
; CHECK-LABEL: @test7_apint(
; CHECK-NEXT:    [[N:%.*]] = and <2 x i39> [[M:%.*]], <i39 -274877906944, i39 -274877906944>
; CHECK-NEXT:    [[A:%.*]] = add <2 x i39> [[N]], [[V:%.*]]
; CHECK-NEXT:    ret <2 x i39> [[A]]
;
  %C1 = xor <2 x i39> <i39 274877906943, i39 274877906943>, <i39 -1, i39 -1> ;; C2 = 274877906943
  %N = and <2 x i39> %M, <i39 274877906944, i39 274877906944>
  %A = add <2 x i39> %N, %V
  %B = and <2 x i39> %A, %C1
  %D = and <2 x i39> %V, <i39 274877906943, i39 274877906943>
  %R = or <2 x i39> %B, %D
  ret <2 x i39> %R
}

; Test the case where Integer BitWidth > 64 && BitWidth <= 1024.
; Vector version of test4_apint with the add and the or commuted
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace with V+N.
define <2 x i399> @test8_apint(<2 x i399> %V, <2 x i399> %M) {
; CHECK-LABEL: @test8_apint(
; CHECK-NEXT:    [[N:%.*]] = and <2 x i399> [[M:%.*]], <i399 18446742974197923840, i399 18446742974197923840>
; CHECK-NEXT:    [[A:%.*]] = add <2 x i399> [[N]], [[V:%.*]]
; CHECK-NEXT:    ret <2 x i399> [[A]]
;
  %C1 = xor <2 x i399> <i399 274877906943, i399 274877906943>, <i399 -1, i399 -1> ;; C2 = 274877906943
  %N = and <2 x i399> %M, <i399 18446742974197923840, i399 18446742974197923840>
  %A = add <2 x i399> %N, %V
  %B = and <2 x i399> %A, %C1
  %D = and <2 x i399> %V, <i399 274877906943, i399 274877906943>
  %R = or <2 x i399> %D, %B
  ret <2 x i399> %R
}

; (A & B) | A = A

define i8 @or_and_common_op_commute0(i8 %a, i8 %b) {
; CHECK-LABEL: @or_and_common_op_commute0(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %and = and i8 %a, %b
  %or = or i8 %and, %a
  ret i8 %or
}

define <2 x i8> @or_and_common_op_commute1(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: @or_and_common_op_commute1(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %and = and <2 x i8> %b, %a
  %or = or <2 x i8> %and, %a
  ret <2 x i8> %or
}

define i8 @or_and_common_op_commute2(i8 %a, i8 %b) {
; CHECK-LABEL: @or_and_common_op_commute2(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %and = and i8 %a, %b
  %or = or i8 %a, %and
  ret i8 %or
}

define <2 x i8> @or_and_common_op_commute3(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: @or_and_common_op_commute3(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %and = and <2 x i8> %b, %a
  %or = or <2 x i8> %a, %and
  ret <2 x i8> %or
}

; A | ~(A & B) = -1

define i1 @or_with_not_op_commute1(i1 %a, i1 %b) {
; CHECK-LABEL: @or_with_not_op_commute1(
; CHECK-NEXT:    ret i1 true
;
  %ab = and i1 %a, %b
  %not = xor i1 %ab, -1
  %r = or i1 %a, %not
  ret i1 %r
}

; A | ~(B & A) = -1

define i8 @or_with_not_op_commute2(i8 %a, i8 %b) {
; CHECK-LABEL: @or_with_not_op_commute2(
; CHECK-NEXT:    ret i8 -1
;
  %ab = and i8 %b, %a
  %not = xor i8 %ab, -1
  %r = or i8 %a, %not
  ret i8 %r
}

; ~(A & B) | A = -1

define <3 x i17> @or_with_not_op_commute3(<3 x i17> %a, <3 x i17> %b) {
; CHECK-LABEL: @or_with_not_op_commute3(
; CHECK-NEXT:    ret <3 x i17> <i17 -1, i17 -1, i17 -1>
;
  %ab = and <3 x i17> %a, %b
  %not = xor <3 x i17> %ab, <i17 -1, i17 -1, i17 -1>
  %r = or <3 x i17> %not, %a
  ret <3 x i17> %r
}

; ~(B & A) | A = -1

define <2 x i1> @or_with_not_op_commute4(<2 x i1> %a, <2 x i1> %b) {
; CHECK-LABEL: @or_with_not_op_commute4(
; CHECK-NEXT:    ret <2 x i1> <i1 true, i1 true>
;
  %ab = and <2 x i1> %b, %a
  %not = xor <2 x i1> %ab, <i1 -1, i1 undef>
  %r = or <2 x i1> %not, %a
  ret <2 x i1> %r
}

define i32 @poison(i32 %x) {
; CHECK-LABEL: @poison(
; CHECK-NEXT:    ret i32 poison
;
  %v = or i32 %x, poison
  ret i32 %v
}

; (~A & B) | ~(A | B) --> ~A

define i4 @and_or_not_or_commute0(i4 %A, i4 %B) {
; CHECK-LABEL: @and_or_not_or_commute0(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i4 [[A:%.*]], -1
; CHECK-NEXT:    ret i4 [[NOTA]]
;
  %nota = xor i4 %A, -1
  %and = and i4 %nota, %B
  %or = or i4 %A, %B
  %notab = xor i4 %or, -1
  %r = or i4 %and, %notab
  ret i4 %r
}

define i41 @and_or_not_or_commute1(i41 %A, i41 %B) {
; CHECK-LABEL: @and_or_not_or_commute1(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i41 [[A:%.*]], -1
; CHECK-NEXT:    ret i41 [[NOTA]]
;
  %nota = xor i41 %A, -1
  %and = and i41 %B, %nota
  %or = or i41 %A, %B
  %notab = xor i41 %or, -1
  %r = or i41 %and, %notab
  ret i41 %r
}

define i8 @and_or_not_or_commute2(i8 %A, i8 %B) {
; CHECK-LABEL: @and_or_not_or_commute2(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i8 [[NOTA]]
;
  %nota = xor i8 %A, -1
  %and = and i8 %nota, %B
  %or = or i8 %B, %A
  %notab = xor i8 %or, -1
  %r = or i8 %and, %notab
  ret i8 %r
}

define <2 x i4> @and_or_not_or_commute3(<2 x i4> %A, <2 x i4> %B) {
; CHECK-LABEL: @and_or_not_or_commute3(
; CHECK-NEXT:    [[NOTA:%.*]] = xor <2 x i4> [[A:%.*]], <i4 -1, i4 -1>
; CHECK-NEXT:    ret <2 x i4> [[NOTA]]
;
  %nota = xor <2 x i4> %A, <i4 -1, i4 -1>
  %and = and <2 x i4> %B, %nota
  %or = or <2 x i4> %B, %A
  %notab = xor <2 x i4> %or, <i4 -1, i4 -1>
  %r = or <2 x i4> %and, %notab
  ret <2 x i4> %r
}

define i4 @and_or_not_or_commute4(i4 %A, i4 %B) {
; CHECK-LABEL: @and_or_not_or_commute4(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i4 [[A:%.*]], -1
; CHECK-NEXT:    ret i4 [[NOTA]]
;
  %nota = xor i4 %A, -1
  %and = and i4 %nota, %B
  %or = or i4 %A, %B
  %notab = xor i4 %or, -1
  %r = or i4 %notab, %and
  ret i4 %r
}

define i41 @and_or_not_or_commute5(i41 %A, i41 %B) {
; CHECK-LABEL: @and_or_not_or_commute5(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i41 [[A:%.*]], -1
; CHECK-NEXT:    ret i41 [[NOTA]]
;
  %nota = xor i41 %A, -1
  %and = and i41 %B, %nota
  %or = or i41 %A, %B
  %notab = xor i41 %or, -1
  %r = or i41 %notab, %and
  ret i41 %r
}

define i8 @and_or_not_or_commute6(i8 %A, i8 %B) {
; CHECK-LABEL: @and_or_not_or_commute6(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i8 [[NOTA]]
;
  %nota = xor i8 %A, -1
  %and = and i8 %nota, %B
  %or = or i8 %B, %A
  %notab = xor i8 %or, -1
  %r = or i8 %notab, %and
  ret i8 %r
}

define <2 x i4> @and_or_not_or_commute7(<2 x i4> %A, <2 x i4> %B) {
; CHECK-LABEL: @and_or_not_or_commute7(
; CHECK-NEXT:    [[NOTA:%.*]] = xor <2 x i4> [[A:%.*]], <i4 -1, i4 -1>
; CHECK-NEXT:    ret <2 x i4> [[NOTA]]
;
  %nota = xor <2 x i4> %A, <i4 -1, i4 -1>
  %and = and <2 x i4> %B, %nota
  %or = or <2 x i4> %B, %A
  %notab = xor <2 x i4> %or, <i4 -1, i4 -1>
  %r = or <2 x i4> %notab, %and
  ret <2 x i4> %r
}

; (~A & B) | ~(A | B) --> ~A with logical and
define i1 @and_or_not_or_logical(i1 %A, i1 %B) {
; CHECK-LABEL: @and_or_not_or_logical(
; CHECK-NEXT:    [[V:%.*]] = xor i1 [[A:%.*]], true
; CHECK-NEXT:    ret i1 [[V]]
;
  %V = xor i1 %A, true
  %X = select i1 %V, i1 %B, i1 false
  %W = or i1 %B, %A
  %Y = xor i1 %W, true
  %Z = or i1 %X, %Y
  ret i1 %Z
}

; (~B & A) | ~(A | B) --> ~A with logical and
define i1 @and_or_not_or_logical_rev(i1 %A, i1 %B) {
; CHECK-LABEL: @and_or_not_or_logical_rev(
; CHECK-NEXT:    [[V:%.*]] = xor i1 [[A:%.*]], true
; CHECK-NEXT:    ret i1 [[V]]
;
  %V = xor i1 %A, true
  %X = select i1 %B, i1 %V, i1 false
  %W = or i1 %B, %A
  %Y = xor i1 %W, true
  %Z = or i1 %X, %Y
  ret i1 %Z
}

; (~A & B) | ~(A | B) --> ~A with logical And and logical Or
define i1 @and_or_not_logical_or_logical_rev(i1 %A, i1 %B) {
; CHECK-LABEL: @and_or_not_logical_or_logical_rev(
; CHECK-NEXT:    [[V:%.*]] = xor i1 [[A:%.*]], true
; CHECK-NEXT:    ret i1 [[V]]
;
  %V = xor i1 %A, true
  %X = select i1 %B, i1 %V, i1 false
  %W = select i1 %B, i1 true, i1 %A
  %Y = xor i1 %W, true
  %Z = or i1 %X, %Y
  ret i1 %Z
}

; negative test - It is not safe to propagate an undef element from the 'not' op.

define <2 x i4> @and_or_not_or_commute7_undef_elt(<2 x i4> %A, <2 x i4> %B) {
; CHECK-LABEL: @and_or_not_or_commute7_undef_elt(
; CHECK-NEXT:    [[NOTA:%.*]] = xor <2 x i4> [[A:%.*]], <i4 undef, i4 -1>
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i4> [[B:%.*]], [[NOTA]]
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i4> [[B]], [[A]]
; CHECK-NEXT:    [[NOTAB:%.*]] = xor <2 x i4> [[OR]], <i4 -1, i4 -1>
; CHECK-NEXT:    [[R:%.*]] = or <2 x i4> [[NOTAB]], [[AND]]
; CHECK-NEXT:    ret <2 x i4> [[R]]
;
  %nota = xor <2 x i4> %A, <i4 undef, i4 -1>
  %and = and <2 x i4> %B, %nota
  %or = or <2 x i4> %B, %A
  %notab = xor <2 x i4> %or, <i4 -1, i4 -1>
  %r = or <2 x i4> %notab, %and
  ret <2 x i4> %r
}

; (A | B) | (A ^ B) --> A | B

define i69 @or_or_xor(i69 %A, i69 %B) {
; CHECK-LABEL: @or_or_xor(
; CHECK-NEXT:    [[I1:%.*]] = or i69 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i69 [[I1]]
;
  %i1 = or i69 %A, %B
  %i2 = xor i69 %A, %B
  %i3 = or i69 %i1, %i2
  ret i69 %i3
}

; (B | A) | (A ^ B) --> B | A

define i8 @or_or_xor_inner_or_commuted(i8 %A, i8 %B) {
; CHECK-LABEL: @or_or_xor_inner_or_commuted(
; CHECK-NEXT:    [[I1:%.*]] = or i8 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret i8 [[I1]]
;
  %i1 = or i8 %B, %A
  %i2 = xor i8 %A, %B
  %i3 = or i8 %i1, %i2
  ret i8 %i3
}

; (A ^ B) | (A | B) --> A | B

define <4 x i4> @or_or_xor_commuted(<4 x i4> %A, <4 x i4> %B) {
; CHECK-LABEL: @or_or_xor_commuted(
; CHECK-NEXT:    [[I1:%.*]] = or <4 x i4> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <4 x i4> [[I1]]
;
  %i1 = or <4 x i4> %A, %B
  %i2 = xor <4 x i4> %A, %B
  %i3 = or <4 x i4> %i2, %i1
  ret <4 x i4> %i3
}

; (A ^ B) | (B | A) --> B | A

define i4 @or_or_xor_inner_or_outer_or_commuted(i4 %A, i4 %B) {
; CHECK-LABEL: @or_or_xor_inner_or_outer_or_commuted(
; CHECK-NEXT:    [[I1:%.*]] = or i4 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret i4 [[I1]]
;
  %i1 = or i4 %B, %A
  %i2 = xor i4 %A, %B
  %i3 = or i4 %i2, %i1
  ret i4 %i3
}

define i32 @shifted_all_ones(i32 %shamt) {
; CHECK-LABEL: @shifted_all_ones(
; CHECK-NEXT:    ret i32 -1
;
  %r = lshr i32 -1, %shamt
  %s = sub i32 32, %shamt
  %l = shl i32 -1, %s
  %o = or i32 %r, %l
  ret i32 %o
}

; Sub from less than bitwidth is ok (overlapping ones).

define i32 @shifted_all_ones_commute(i32 %shamt) {
; CHECK-LABEL: @shifted_all_ones_commute(
; CHECK-NEXT:    ret i32 -1
;
  %r = lshr i32 -1, %shamt
  %s = sub i32 31, %shamt
  %l = shl i32 -1, %s
  %o = or i32 %l, %r
  ret i32 %o
}

define <2 x i9> @shifted_all_ones_sub_on_lshr(<2 x i9> %shamt) {
; CHECK-LABEL: @shifted_all_ones_sub_on_lshr(
; CHECK-NEXT:    ret <2 x i9> <i9 -1, i9 -1>
;
  %l = shl <2 x i9> <i9 -1, i9 -1>, %shamt
  %s = sub <2 x i9> <i9 5, i9 5>, %shamt
  %r = lshr <2 x i9> <i9 -1, i9 -1>, %s
  %o = or <2 x i9> %l, %r
  ret <2 x i9> %o
}

define i8 @shifted_all_ones_sub_on_lshr_commute(i8 %shamt) {
; CHECK-LABEL: @shifted_all_ones_sub_on_lshr_commute(
; CHECK-NEXT:    ret i8 -1
;
  %l = shl i8 -1, %shamt
  %s = sub i8 8, %shamt
  %r = lshr i8 -1, %s
  %o = or i8 %r, %l
  ret i8 %o
}

; negative test - need -1 in general case

define i32 @shifted_not_all_ones(i32 %shamt) {
; CHECK-LABEL: @shifted_not_all_ones(
; CHECK-NEXT:    [[R:%.*]] = lshr i32 -2, [[SHAMT:%.*]]
; CHECK-NEXT:    [[S:%.*]] = sub i32 31, [[SHAMT]]
; CHECK-NEXT:    [[L:%.*]] = shl i32 -1, [[S]]
; CHECK-NEXT:    [[O:%.*]] = or i32 [[R]], [[L]]
; CHECK-NEXT:    ret i32 [[O]]
;
  %r = lshr i32 -2, %shamt
  %s = sub i32 31, %shamt
  %l = shl i32 -1, %s
  %o = or i32 %r, %l
  ret i32 %o
}

; negative test - opposite shift amount may be too big

define i32 @shifted_all_ones_greater_than_bitwidth(i32 %shamt) {
; CHECK-LABEL: @shifted_all_ones_greater_than_bitwidth(
; CHECK-NEXT:    [[R:%.*]] = lshr i32 -1, [[SHAMT:%.*]]
; CHECK-NEXT:    [[S:%.*]] = sub i32 33, [[SHAMT]]
; CHECK-NEXT:    [[L:%.*]] = shl i32 -1, [[S]]
; CHECK-NEXT:    [[O:%.*]] = or i32 [[R]], [[L]]
; CHECK-NEXT:    ret i32 [[O]]
;
  %r = lshr i32 -1, %shamt
  %s = sub i32 33, %shamt
  %l = shl i32 -1, %s
  %o = or i32 %r, %l
  ret i32 %o
}

; negative test - shift amount must be derived from same base

define i32 @shifted_all_ones_not_same_amt(i32 %shamt, i32 %other) {
; CHECK-LABEL: @shifted_all_ones_not_same_amt(
; CHECK-NEXT:    [[R:%.*]] = lshr i32 -1, [[SHAMT:%.*]]
; CHECK-NEXT:    [[S:%.*]] = sub i32 32, [[OTHER:%.*]]
; CHECK-NEXT:    [[L:%.*]] = shl i32 -1, [[S]]
; CHECK-NEXT:    [[O:%.*]] = or i32 [[R]], [[L]]
; CHECK-NEXT:    ret i32 [[O]]
;
  %r = lshr i32 -1, %shamt
  %s = sub i32 32, %other
  %l = shl i32 -1, %s
  %o = or i32 %r, %l
  ret i32 %o
}

; (A & B) | ~(A ^ B) --> ~(A ^ B)

define i4 @or_nxor_and_commute0(i4 %a, i4 %b) {
; CHECK-LABEL: @or_nxor_and_commute0(
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i4 [[XOR]], -1
; CHECK-NEXT:    ret i4 [[NOT]]
;
  %and = and i4 %a, %b
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %and, %not
  ret i4 %r
}

define <2 x i4> @or_nxor_and_commute1(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_and_commute1(
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i4> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor <2 x i4> [[XOR]], <i4 -1, i4 -1>
; CHECK-NEXT:    ret <2 x i4> [[NOT]]
;
  %and = and <2 x i4> %a, %b
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 -1>
  %r = or <2 x i4> %not, %and
  ret <2 x i4> %r
}

define i74 @or_nxor_and_commute2(i74 %a, i74 %b) {
; CHECK-LABEL: @or_nxor_and_commute2(
; CHECK-NEXT:    [[XOR:%.*]] = xor i74 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i74 [[XOR]], -1
; CHECK-NEXT:    ret i74 [[NOT]]
;
  %and = and i74 %b, %a
  %xor = xor i74 %a, %b
  %not = xor i74 %xor, -1
  %r = or i74 %and, %not
  ret i74 %r
}

define <2 x i4> @or_nxor_and_commute3(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_and_commute3(
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i4> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor <2 x i4> [[XOR]], <i4 -1, i4 -1>
; CHECK-NEXT:    ret <2 x i4> [[NOT]]
;
  %and = and <2 x i4> %b, %a
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 -1>
  %r = or <2 x i4> %not, %and
  ret <2 x i4> %r
}

; negative test - must have common operands

define i4 @or_nxor_and_wrong_val1(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: @or_nxor_and_wrong_val1(
; CHECK-NEXT:    [[AND:%.*]] = and i4 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[A]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i4 [[XOR]], -1
; CHECK-NEXT:    [[R:%.*]] = or i4 [[AND]], [[NOT]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %and = and i4 %a, %c
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %and, %not
  ret i4 %r
}

; negative test - must have common operands

define i4 @or_nxor_and_wrong_val2(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: @or_nxor_and_wrong_val2(
; CHECK-NEXT:    [[AND:%.*]] = and i4 [[C:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[A:%.*]], [[B]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i4 [[XOR]], -1
; CHECK-NEXT:    [[R:%.*]] = or i4 [[AND]], [[NOT]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %and = and i4 %c, %b
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %and, %not
  ret i4 %r
}

; negative test - undef in 'not' is allowed

define <2 x i4> @or_nxor_and_undef_elt(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_and_undef_elt(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i4> [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i4> [[A]], [[B]]
; CHECK-NEXT:    [[NOT:%.*]] = xor <2 x i4> [[XOR]], <i4 -1, i4 undef>
; CHECK-NEXT:    [[R:%.*]] = or <2 x i4> [[NOT]], [[AND]]
; CHECK-NEXT:    ret <2 x i4> [[R]]
;
  %and = and <2 x i4> %b, %a
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 undef>
  %r = or <2 x i4> %not, %and
  ret <2 x i4> %r
}

; ~(A ^ B) | (A | B) --> -1

define i4 @or_nxor_or_commute0(i4 %a, i4 %b) {
; CHECK-LABEL: @or_nxor_or_commute0(
; CHECK-NEXT:    ret i4 -1
;
  %or = or i4 %a, %b
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %not, %or
  ret i4 %r
}

define <2 x i4> @or_nxor_or_commute1(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_or_commute1(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %or = or <2 x i4> %a, %b
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 -1>
  %r = or <2 x i4> %or, %not
  ret <2 x i4> %r
}

define i74 @or_nxor_or_commute2(i74 %a, i74 %b) {
; CHECK-LABEL: @or_nxor_or_commute2(
; CHECK-NEXT:    ret i74 -1
;
  %or = or i74 %b, %a
  %xor = xor i74 %a, %b
  %not = xor i74 %xor, -1
  %r = or i74 %not, %or
  ret i74 %r
}

define <2 x i4> @or_nxor_or_commute3(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_or_commute3(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %or = or <2 x i4> %b, %a
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 -1>
  %r = or <2 x i4> %or, %not
  ret <2 x i4> %r
}

; negative test - must have common operands

define i4 @or_nxor_or_wrong_val1(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: @or_nxor_or_wrong_val1(
; CHECK-NEXT:    [[OR:%.*]] = or i4 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[A]], [[B:%.*]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i4 [[XOR]], -1
; CHECK-NEXT:    [[R:%.*]] = or i4 [[NOT]], [[OR]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %or = or i4 %a, %c
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %not, %or
  ret i4 %r
}

; negative test - must have common operands

define i4 @or_nxor_or_wrong_val2(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: @or_nxor_or_wrong_val2(
; CHECK-NEXT:    [[OR:%.*]] = or i4 [[C:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[A:%.*]], [[B]]
; CHECK-NEXT:    [[NOT:%.*]] = xor i4 [[XOR]], -1
; CHECK-NEXT:    [[R:%.*]] = or i4 [[NOT]], [[OR]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %or = or i4 %c, %b
  %xor = xor i4 %a, %b
  %not = xor i4 %xor, -1
  %r = or i4 %not, %or
  ret i4 %r
}

; negative test - undef in 'not' is allowed

define <2 x i4> @or_nxor_or_undef_elt(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_nxor_or_undef_elt(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %or = or <2 x i4> %b, %a
  %xor = xor <2 x i4> %a, %b
  %not = xor <2 x i4> %xor, <i4 -1, i4 undef>
  %r = or <2 x i4> %or, %not
  ret <2 x i4> %r
}

; (A ^ B) | (~A | B) --> -1

define i4 @or_xor_not_op_or(i4 %a, i4 %b){
; CHECK-LABEL: @or_xor_not_op_or(
; CHECK-NEXT:    ret i4 -1
;
  %xor = xor i4 %a, %b
  %nota = xor i4 %a, -1
  %or = or i4 %nota, %b
  %r = or i4 %xor, %or
  ret i4 %r
}

; (A ^ B) | (B | ~A) --> -1

define i71  @or_xor_not_op_or_commute1(i71 %a, i71 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute1(
; CHECK-NEXT:    ret i71 -1
;
  %xor = xor i71 %a, %b
  %nota = xor i71  %a, -1
  %or = or i71  %b, %nota
  %r = or i71  %xor, %or
  ret i71  %r
}

; (B ^ A) | (~A | B) --> -1

define i32  @or_xor_not_op_or_commute2(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute2(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %b, %a
  %nota = xor i32  %a, -1
  %or = or i32  %nota, %b
  %r = or i32  %xor, %or
  ret i32  %r
}

; (B ^ A) | (B | ~A) --> -1

define i32  @or_xor_not_op_or_commute3(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute3(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %b, %a
  %nota = xor i32  %a, -1
  %or = or i32  %b, %nota
  %r = or i32  %xor, %or
  ret i32  %r
}

; (~A | B) | (A ^ B) --> -1

define i32  @or_xor_not_op_or_commute4(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute4(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %a, %b
  %nota = xor i32  %a, -1
  %or = or i32  %nota, %b
  %r = or i32  %or, %xor
  ret i32  %r
}

; (B | ~A) | (A ^ B) --> -1

define i32  @or_xor_not_op_or_commute5(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute5(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %a, %b
  %nota = xor i32  %a, -1
  %or = or i32  %b, %nota
  %r = or i32  %or, %xor
  ret i32  %r
}

; (~A | B) | (B ^ A) --> -1

define i32  @or_xor_not_op_or_commute6(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute6(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %b, %a
  %nota = xor i32  %a, -1
  %or = or i32  %nota, %b
  %r = or i32  %or, %xor
  ret i32  %r
}

; (B | ~A)  | (B ^ A) --> -1

define i32  @or_xor_not_op_or_commute7(i32 %a, i32 %b){
; CHECK-LABEL: @or_xor_not_op_or_commute7(
; CHECK-NEXT:    ret i32 -1
;
  %xor = xor i32 %b, %a
  %nota = xor i32  %a, -1
  %or = or i32  %b, %nota
  %r = or i32  %or, %xor
  ret i32  %r
}

define <2 x i4> @or_xor_not_op_or_undef_elt(<2 x i4> %a, <2 x i4> %b) {
; CHECK-LABEL: @or_xor_not_op_or_undef_elt(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %xor = xor <2 x i4> %a, %b
  %nota = xor <2 x i4> %a, <i4 -1, i4 undef>
  %or = or <2 x i4>  %nota, %b
  %r = or <2 x i4> %xor, %or
  ret <2 x i4> %r
}

; negative test

define i16 @or_xor_not_op_or_wrong_val(i16 %a, i16 %b, i16 %c) {
; CHECK-LABEL: @or_xor_not_op_or_wrong_val(
; CHECK-NEXT:    [[XOR:%.*]] = xor i16 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[NOTA:%.*]] = xor i16 [[A]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i16 [[NOTA]], [[B:%.*]]
; CHECK-NEXT:    [[R:%.*]] = or i16 [[XOR]], [[OR]]
; CHECK-NEXT:    ret i16 [[R]]
;
  %xor = xor i16 %a, %c
  %nota = xor i16 %a, -1
  %or = or i16 %nota, %b
  %r = or i16 %xor, %or
  ret i16 %r
}

; ~(x & y) | (x ^ y) --> ~(x & y)

define i4 @or_nand_xor(i4 %x, i4 %y) {
; CHECK-LABEL: @or_nand_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i4 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[NAND:%.*]] = xor i4 [[AND]], -1
; CHECK-NEXT:    ret i4 [[NAND]]
;
  %and = and i4 %x, %y
  %xor = xor i4 %x, %y
  %nand = xor i4 %and, -1
  %or = or i4 %xor, %nand
  ret i4 %or
}

define <2 x i4> @or_nand_xor_commute1(<2 x i4> %x, <2 x i4> %y) {
; CHECK-LABEL: @or_nand_xor_commute1(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i4> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[NAND:%.*]] = xor <2 x i4> [[AND]], <i4 -1, i4 -1>
; CHECK-NEXT:    ret <2 x i4> [[NAND]]
;
  %and = and <2 x i4> %y, %x
  %xor = xor <2 x i4> %x, %y
  %nand = xor <2 x i4> %and, <i4 -1, i4 -1>
  %or = or <2 x i4> %xor, %nand
  ret <2 x i4> %or
}

define i71 @or_nand_xor_commute2(i71 %x, i71 %y) {
; CHECK-LABEL: @or_nand_xor_commute2(
; CHECK-NEXT:    [[AND:%.*]] = and i71 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[NAND:%.*]] = xor i71 [[AND]], -1
; CHECK-NEXT:    ret i71 [[NAND]]
;
  %and = and i71 %x, %y
  %xor = xor i71 %x, %y
  %nand = xor i71 %and, -1
  %or = or i71 %nand, %xor
  ret i71 %or
}

define i4 @or_nand_xor_commute3(i4 %x, i4 %y) {
; CHECK-LABEL: @or_nand_xor_commute3(
; CHECK-NEXT:    [[AND:%.*]] = and i4 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[NAND:%.*]] = xor i4 [[AND]], -1
; CHECK-NEXT:    ret i4 [[NAND]]
;
  %and = and i4 %y, %x
  %xor = xor i4 %x, %y
  %nand = xor i4 %and, -1
  %or = or i4 %nand, %xor
  ret i4 %or
}

; negative test wrong operand

define i4 @or_nand_xor_wrong_val(i4 %x, i4 %y, i4 %z) {
; CHECK-LABEL: @or_nand_xor_wrong_val(
; CHECK-NEXT:    [[AND:%.*]] = and i4 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i4 [[X]], [[Z:%.*]]
; CHECK-NEXT:    [[NAND:%.*]] = xor i4 [[AND]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i4 [[XOR]], [[NAND]]
; CHECK-NEXT:    ret i4 [[OR]]
;
  %and = and i4 %x, %y
  %xor = xor i4 %x, %z
  %nand = xor i4 %and, -1
  %or = or i4 %xor, %nand
  ret i4 %or
}

; negative test - undef element in 'not' is not allowed

define <2 x i4> @or_nand_xor_undef_elt(<2 x i4> %x, <2 x i4> %y) {
; CHECK-LABEL: @or_nand_xor_undef_elt(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i4> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i4> [[X]], [[Y]]
; CHECK-NEXT:    [[NAND:%.*]] = xor <2 x i4> [[AND]], <i4 undef, i4 -1>
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i4> [[XOR]], [[NAND]]
; CHECK-NEXT:    ret <2 x i4> [[OR]]
;
  %and = and <2 x i4> %y, %x
  %xor = xor <2 x i4> %x, %y
  %nand = xor <2 x i4> %and, <i4 undef, i4 -1>
  %or = or <2 x i4> %xor, %nand
  ret <2 x i4> %or
}

declare i32 @llvm.fshl.i32 (i32, i32, i32)
declare i32 @llvm.fshr.i32 (i32, i32, i32)

define i32 @or_shl_fshl(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_shl_fshl(
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshl.i32(i32 [[Y:%.*]], i32 [[X:%.*]], i32 [[S:%.*]])
; CHECK-NEXT:    ret i32 [[FUN]]
;
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_shl_fshl_commute(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_shl_fshl_commute(
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshl.i32(i32 [[Y:%.*]], i32 [[X:%.*]], i32 [[S:%.*]])
; CHECK-NEXT:    ret i32 [[FUN]]
;
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

; negative test - fshl operands are not commutative

define i32 @or_shl_fshl_wrong_order(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_shl_fshl_wrong_order(
; CHECK-NEXT:    [[SHY:%.*]] = shl i32 [[Y:%.*]], [[S:%.*]]
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshl.i32(i32 [[X:%.*]], i32 [[Y]], i32 [[S]])
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[FUN]], [[SHY]]
; CHECK-NEXT:    ret i32 [[OR]]
;
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_fshr(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_lshr_fshr(
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshr.i32(i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[S:%.*]])
; CHECK-NEXT:    ret i32 [[FUN]]
;
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_fshr_commute(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_lshr_fshr_commute(
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshr.i32(i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[S:%.*]])
; CHECK-NEXT:    ret i32 [[FUN]]
;
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

; negative test - fshr operands are not commutative

define i32 @or_lshr_fshr_wrong_order(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: @or_lshr_fshr_wrong_order(
; CHECK-NEXT:    [[SHY:%.*]] = lshr i32 [[Y:%.*]], [[S:%.*]]
; CHECK-NEXT:    [[FUN:%.*]] = call i32 @llvm.fshr.i32(i32 [[Y]], i32 [[X:%.*]], i32 [[S]])
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[FUN]], [[SHY]]
; CHECK-NEXT:    ret i32 [[OR]]
;
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}
