; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefix=AVX --check-prefix=AVX512 --check-prefix=AVX512BW

;
; udiv by 7
;

define <8 x i64> @test_div7_8i64(<8 x i64> %a) nounwind {
; AVX-LABEL: test_div7_8i64:
; AVX:       # BB#0:
; AVX-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX-NEXT:    vpextrq $1, %xmm1, %rcx
; AVX-NEXT:    movabsq $2635249153387078803, %rsi # imm = 0x2492492492492493
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vmovq %xmm1, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm0, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    shrq %rcx
; AVX-NEXT:    addq %rdx, %rcx
; AVX-NEXT:    shrq $2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX-NEXT:    retq
  %res = udiv <8 x i64> %a, <i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7>
  ret <8 x i64> %res
}

define <16 x i32> @test_div7_16i32(<16 x i32> %a) nounwind {
; AVX-LABEL: test_div7_16i32:
; AVX:       # BB#0:
; AVX-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX-NEXT:    vpextrd $1, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vmovd %xmm1, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    shrl %ecx
; AVX-NEXT:    addl %edx, %ecx
; AVX-NEXT:    shrl $2, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm2
; AVX-NEXT:    vpinsrd $1, %eax, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $2, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $3, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm2, %xmm1
; AVX-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vmovd %xmm2, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    shrl %ecx
; AVX-NEXT:    addl %edx, %ecx
; AVX-NEXT:    shrl $2, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm2
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vmovd %xmm2, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    shrl %ecx
; AVX-NEXT:    addl %edx, %ecx
; AVX-NEXT:    shrl $2, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vmovd %xmm0, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    shrl %ecx
; AVX-NEXT:    addl %edx, %ecx
; AVX-NEXT:    shrl $2, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    shrl %eax
; AVX-NEXT:    addl %ecx, %eax
; AVX-NEXT:    shrl $2, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm0
; AVX-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX-NEXT:    retq
  %res = udiv <16 x i32> %a, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  ret <16 x i32> %res
}

define <32 x i16> @test_div7_32i16(<32 x i16> %a) nounwind {
; AVX512F-LABEL: test_div7_32i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = [9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363]
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $2, %ymm0, %ymm0
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm1, %ymm2
; AVX512F-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_div7_32i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpmulhuw {{.*}}(%rip), %zmm0, %zmm1
; AVX512BW-NEXT:    vpsubw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = udiv <32 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  ret <32 x i16> %res
}

define <64 x i8> @test_div7_64i8(<64 x i8> %a) nounwind {
; AVX512F-LABEL: test_div7_64i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = [37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37]
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero,xmm3[8],zero,xmm3[9],zero,xmm3[10],zero,xmm3[11],zero,xmm3[12],zero,xmm3[13],zero,xmm3[14],zero,xmm3[15],zero
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512F-NEXT:    vpmullw %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512F-NEXT:    vpmullw %ymm2, %ymm5, %ymm5
; AVX512F-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm6 = ymm5[2,3],ymm4[2,3]
; AVX512F-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX512F-NEXT:    vpackuswb %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsubb %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm5, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $2, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm6
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero,xmm6[8],zero,xmm6[9],zero,xmm6[10],zero,xmm6[11],zero,xmm6[12],zero,xmm6[13],zero,xmm6[14],zero,xmm6[15],zero
; AVX512F-NEXT:    vpmullw %ymm3, %ymm6, %ymm3
; AVX512F-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm6 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512F-NEXT:    vpmullw %ymm2, %ymm6, %ymm2
; AVX512F-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm6 = ymm2[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpackuswb %ymm6, %ymm2, %ymm2
; AVX512F-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_div7_64i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $1, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %ecx
; AVX512BW-NEXT:    imull $37, %ecx, %edx
; AVX512BW-NEXT:    shrl $8, %edx
; AVX512BW-NEXT:    subb %dl, %cl
; AVX512BW-NEXT:    shrb %cl
; AVX512BW-NEXT:    addb %dl, %cl
; AVX512BW-NEXT:    shrb $2, %cl
; AVX512BW-NEXT:    movzbl %cl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm2
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $2, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $3, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $4, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $5, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $6, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $7, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $9, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $10, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $11, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $12, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $13, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $14, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $15, %xmm1, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm2, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %ecx
; AVX512BW-NEXT:    imull $37, %ecx, %edx
; AVX512BW-NEXT:    shrl $8, %edx
; AVX512BW-NEXT:    subb %dl, %cl
; AVX512BW-NEXT:    shrb %cl
; AVX512BW-NEXT:    addb %dl, %cl
; AVX512BW-NEXT:    shrb $2, %cl
; AVX512BW-NEXT:    movzbl %cl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %ecx
; AVX512BW-NEXT:    imull $37, %ecx, %edx
; AVX512BW-NEXT:    shrl $8, %edx
; AVX512BW-NEXT:    subb %dl, %cl
; AVX512BW-NEXT:    shrb %cl
; AVX512BW-NEXT:    addb %dl, %cl
; AVX512BW-NEXT:    shrb $2, %cl
; AVX512BW-NEXT:    movzbl %cl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %ecx
; AVX512BW-NEXT:    imull $37, %ecx, %edx
; AVX512BW-NEXT:    shrl $8, %edx
; AVX512BW-NEXT:    subb %dl, %cl
; AVX512BW-NEXT:    shrb %cl
; AVX512BW-NEXT:    addb %dl, %cl
; AVX512BW-NEXT:    shrb $2, %cl
; AVX512BW-NEXT:    movzbl %cl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm0, %eax
; AVX512BW-NEXT:    imull $37, %eax, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = udiv <64 x i8> %a, <i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7>
  ret <64 x i8> %res
}

;
; urem by 7
;

define <8 x i64> @test_rem7_8i64(<8 x i64> %a) nounwind {
; AVX-LABEL: test_rem7_8i64:
; AVX:       # BB#0:
; AVX-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX-NEXT:    vpextrq $1, %xmm1, %rcx
; AVX-NEXT:    movabsq $2635249153387078803, %rsi # imm = 0x2492492492492493
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vmovq %xmm1, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm2, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vmovq %xmm0, %rcx
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    mulq %rsi
; AVX-NEXT:    movq %rcx, %rax
; AVX-NEXT:    subq %rdx, %rax
; AVX-NEXT:    shrq %rax
; AVX-NEXT:    addq %rdx, %rax
; AVX-NEXT:    shrq $2, %rax
; AVX-NEXT:    leaq (,%rax,8), %rdx
; AVX-NEXT:    subq %rax, %rdx
; AVX-NEXT:    subq %rdx, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX-NEXT:    retq
  %res = urem <8 x i64> %a, <i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7>
  ret <8 x i64> %res
}

define <16 x i32> @test_rem7_16i32(<16 x i32> %a) nounwind {
; AVX-LABEL: test_rem7_16i32:
; AVX:       # BB#0:
; AVX-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX-NEXT:    vpextrd $1, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vmovd %xmm1, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    movl %ecx, %esi
; AVX-NEXT:    subl %edx, %esi
; AVX-NEXT:    shrl %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    shrl $2, %esi
; AVX-NEXT:    leal (,%rsi,8), %edx
; AVX-NEXT:    subl %esi, %edx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm2
; AVX-NEXT:    vpinsrd $1, %eax, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $2, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $3, %xmm1, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm2, %xmm1
; AVX-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vmovd %xmm2, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    movl %ecx, %esi
; AVX-NEXT:    subl %edx, %esi
; AVX-NEXT:    shrl %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    shrl $2, %esi
; AVX-NEXT:    leal (,%rsi,8), %edx
; AVX-NEXT:    subl %esi, %edx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm2
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vmovd %xmm2, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    movl %ecx, %esi
; AVX-NEXT:    subl %edx, %esi
; AVX-NEXT:    shrl %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    shrl $2, %esi
; AVX-NEXT:    leal (,%rsi,8), %edx
; AVX-NEXT:    subl %esi, %edx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm2, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm2
; AVX-NEXT:    vpextrd $1, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vmovd %xmm0, %ecx
; AVX-NEXT:    imulq $613566757, %rcx, %rdx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rdx
; AVX-NEXT:    movl %ecx, %esi
; AVX-NEXT:    subl %edx, %esi
; AVX-NEXT:    shrl %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    shrl $2, %esi
; AVX-NEXT:    leal (,%rsi,8), %edx
; AVX-NEXT:    subl %esi, %edx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    vmovd %ecx, %xmm3
; AVX-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $2, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $2, %eax, %xmm3, %xmm3
; AVX-NEXT:    vpextrd $3, %xmm0, %eax
; AVX-NEXT:    imulq $613566757, %rax, %rcx # imm = 0x24924925
; AVX-NEXT:    shrq $32, %rcx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    subl %ecx, %edx
; AVX-NEXT:    shrl %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    shrl $2, %edx
; AVX-NEXT:    leal (,%rdx,8), %ecx
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    subl %ecx, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm3, %xmm0
; AVX-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX-NEXT:    retq
  %res = urem <16 x i32> %a, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  ret <16 x i32> %res
}

define <32 x i16> @test_rem7_32i16(<32 x i16> %a) nounwind {
; AVX512F-LABEL: test_rem7_32i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = [9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363,9363]
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpsubw %ymm3, %ymm0, %ymm4
; AVX512F-NEXT:    vpsrlw $1, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddw %ymm3, %ymm4, %ymm3
; AVX512F-NEXT:    vpsrlw $2, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm1, %ymm2
; AVX512F-NEXT:    vpsubw %ymm2, %ymm1, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddw %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpsrlw $2, %ymm2, %ymm2
; AVX512F-NEXT:    vpmullw %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_rem7_32i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpmulhuw {{.*}}(%rip), %zmm0, %zmm1
; AVX512BW-NEXT:    vpsubw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpsrlw $1, %zmm2, %zmm2
; AVX512BW-NEXT:    vpaddw %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vpsrlw $2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpmullw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsubw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = urem <32 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  ret <32 x i16> %res
}

define <64 x i8> @test_rem7_64i8(<64 x i8> %a) nounwind {
; AVX512F-LABEL: test_rem7_64i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37]
; AVX512F-NEXT:    vextracti128 $1, %ymm3, %xmm2
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512F-NEXT:    vpmullw %ymm2, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm5
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero,xmm3[8],zero,xmm3[9],zero,xmm3[10],zero,xmm3[11],zero,xmm3[12],zero,xmm3[13],zero,xmm3[14],zero,xmm3[15],zero
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm6 = ymm3[2,3],ymm5[2,3]
; AVX512F-NEXT:    vinserti128 $1, %xmm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpackuswb %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpsubb %ymm3, %ymm0, %ymm5
; AVX512F-NEXT:    vpsrlw $1, %ymm5, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm5, %ymm6, %ymm6
; AVX512F-NEXT:    vpaddb %ymm3, %ymm6, %ymm3
; AVX512F-NEXT:    vpsrlw $2, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm6, %ymm3, %ymm7
; AVX512F-NEXT:    vpmovsxbw %xmm7, %ymm8
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpmullw %ymm3, %ymm8, %ymm8
; AVX512F-NEXT:    vpmovsxwd %ymm8, %zmm8
; AVX512F-NEXT:    vpmovdb %zmm8, %xmm8
; AVX512F-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512F-NEXT:    vpmovsxbw %xmm7, %ymm7
; AVX512F-NEXT:    vpmullw %ymm3, %ymm7, %ymm7
; AVX512F-NEXT:    vpmovsxwd %ymm7, %zmm7
; AVX512F-NEXT:    vpmovdb %zmm7, %xmm7
; AVX512F-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512F-NEXT:    vpsubb %ymm7, %ymm0, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm7
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm7 = xmm7[0],zero,xmm7[1],zero,xmm7[2],zero,xmm7[3],zero,xmm7[4],zero,xmm7[5],zero,xmm7[6],zero,xmm7[7],zero,xmm7[8],zero,xmm7[9],zero,xmm7[10],zero,xmm7[11],zero,xmm7[12],zero,xmm7[13],zero,xmm7[14],zero,xmm7[15],zero
; AVX512F-NEXT:    vpmullw %ymm2, %ymm7, %ymm2
; AVX512F-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512F-NEXT:    vpmovzxbw {{.*#+}} ymm7 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512F-NEXT:    vpmullw %ymm4, %ymm7, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm4[2,3],ymm2[2,3]
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpackuswb %ymm7, %ymm2, %ymm2
; AVX512F-NEXT:    vpsubb %ymm2, %ymm1, %ymm4
; AVX512F-NEXT:    vpsrlw $1, %ymm4, %ymm4
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsrlw $2, %ymm2, %ymm2
; AVX512F-NEXT:    vpand %ymm6, %ymm2, %ymm2
; AVX512F-NEXT:    vpmovsxbw %xmm2, %ymm4
; AVX512F-NEXT:    vpmullw %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpmovsxwd %ymm4, %zmm4
; AVX512F-NEXT:    vpmovdb %zmm4, %xmm4
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbw %xmm2, %ymm2
; AVX512F-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_rem7_64i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $1, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %ecx
; AVX512BW-NEXT:    shrl $8, %ecx
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %cl, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %cl, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    movb $7, %cl
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %esi
; AVX512BW-NEXT:    imull $37, %esi, %edi
; AVX512BW-NEXT:    shrl $8, %edi
; AVX512BW-NEXT:    movl %esi, %eax
; AVX512BW-NEXT:    subb %dil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %dil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %sil
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm2
; AVX512BW-NEXT:    vpinsrb $1, %edx, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $2, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $3, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $4, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $5, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $6, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $7, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $9, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $10, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $11, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $12, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $13, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $14, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $15, %xmm1, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm2, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %esi
; AVX512BW-NEXT:    imull $37, %esi, %edi
; AVX512BW-NEXT:    shrl $8, %edi
; AVX512BW-NEXT:    movl %esi, %eax
; AVX512BW-NEXT:    subb %dil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %dil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %sil
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %edx, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %esi
; AVX512BW-NEXT:    imull $37, %esi, %edi
; AVX512BW-NEXT:    shrl $8, %edi
; AVX512BW-NEXT:    movl %esi, %eax
; AVX512BW-NEXT:    subb %dil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %dil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %sil
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %edx, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %esi
; AVX512BW-NEXT:    imull $37, %esi, %edi
; AVX512BW-NEXT:    shrl $8, %edi
; AVX512BW-NEXT:    movl %esi, %eax
; AVX512BW-NEXT:    subb %dil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %dil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %sil
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpinsrb $1, %edx, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm0, %edx
; AVX512BW-NEXT:    imull $37, %edx, %esi
; AVX512BW-NEXT:    shrl $8, %esi
; AVX512BW-NEXT:    movl %edx, %eax
; AVX512BW-NEXT:    subb %sil, %al
; AVX512BW-NEXT:    shrb %al
; AVX512BW-NEXT:    addb %sil, %al
; AVX512BW-NEXT:    shrb $2, %al
; AVX512BW-NEXT:    mulb %cl
; AVX512BW-NEXT:    subb %al, %dl
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %res = urem <64 x i8> %a, <i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7,i8 7, i8 7, i8 7, i8 7>
  ret <64 x i8> %res
}
