/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Target;

public class ProcInitializer
extends Initializer {
    LambdaExp proc;

    public ProcInitializer(LambdaExp lexp, Compilation comp) {
        this.field = lexp.allocFieldFor(comp);
        this.proc = lexp;
        LambdaExp heapLambda = lexp.getOwningLambda();
        if (heapLambda instanceof ModuleExp && comp.isStatic()) {
            this.next = comp.clinitChain;
            comp.clinitChain = this;
        } else {
            this.next = heapLambda.initChain;
            heapLambda.initChain = this;
        }
    }

    public static void emitLoadModuleMethod(LambdaExp proc, Compilation comp) {
        CodeAttr code = comp.getCode();
        ClassType procClass = Compilation.typeModuleMethod;
        code.emitNew(procClass);
        code.emitDup(1);
        LambdaExp owning = proc.getOwningLambda();
        if (owning instanceof ClassExp && owning.staticLinkField != null) {
            code.emitLoad(code.getCurrentScope().getVariable(1));
        } else if (!(owning instanceof ModuleExp) || comp.moduleClass == comp.mainClass && !comp.method.getStaticFlag()) {
            code.emitPushThis();
        } else {
            if (comp.moduleInstanceVar == null) {
                comp.moduleInstanceVar = code.locals.current_scope.addVariable(code, comp.moduleClass, "$instance");
                if (comp.moduleClass != comp.mainClass && !comp.isStatic()) {
                    code.emitNew(comp.moduleClass);
                    code.emitDup(comp.moduleClass);
                    code.emitInvokeSpecial(comp.moduleClass.constructor);
                    comp.moduleInstanceMainField = comp.moduleClass.addField("$main", comp.mainClass, 0);
                    code.emitDup(comp.moduleClass);
                    code.emitPushThis();
                    code.emitPutField(comp.moduleInstanceMainField);
                } else {
                    code.emitGetStatic(comp.moduleInstanceMainField);
                }
                code.emitStore(comp.moduleInstanceVar);
            }
            code.emitLoad(comp.moduleInstanceVar);
        }
        code.emitPushInt(proc.getSelectorValue(comp));
        comp.compileConstant(proc.nameDecl != null ? proc.nameDecl.getSymbol() : proc.getName(), Target.pushObject);
        code.emitPushInt(proc.min_args | (proc.keywords == null ? proc.max_args : -1) << 12);
        Method initModuleMethod = procClass.getDeclaredMethod("<init>", 4);
        code.emitInvokeSpecial(initModuleMethod);
        if (proc.properties != null) {
            int len = proc.properties.length;
            for (int i = 0; i < len; i += 2) {
                Object key = proc.properties[i];
                if (key == null || key == "name") continue;
                Object val = proc.properties[i + 1];
                code.emitDup(1);
                comp.compileConstant(key);
                Target target = Target.pushObject;
                if (val instanceof Expression) {
                    ((Expression)val).compile(comp, target);
                } else {
                    comp.compileConstant(val, target);
                }
                Method m = ClassType.make("gnu.mapping.PropertySet").getDeclaredMethod("setProperty", 2);
                code.emitInvokeVirtual(m);
            }
        }
    }

    public void emit(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (!this.field.getStaticFlag()) {
            code.emitPushThis();
        }
        ProcInitializer.emitLoadModuleMethod(this.proc, comp);
        if (this.field.getStaticFlag()) {
            code.emitPutStatic(this.field);
        } else {
            code.emitPutField(this.field);
        }
    }

    public void reportError(String message, Compilation comp) {
        String saveFile = comp.getFileName();
        int saveLine = comp.getLineNumber();
        int saveColumn = comp.getColumnNumber();
        comp.setLocation(this.proc);
        String name = this.proc.getName();
        StringBuffer sbuf = new StringBuffer(message);
        if (name == null) {
            sbuf.append("unnamed procedure");
        } else {
            sbuf.append("procedure ");
            sbuf.append(name);
        }
        comp.error('e', sbuf.toString());
        comp.setLine(saveFile, saveLine, saveColumn);
    }
}

