/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.Instrumentor;
import alt.jiapi.event.EventProducer;
import alt.jiapi.event.EventRuntime;
import alt.jiapi.reflect.FieldExistsException;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.MethodExistsException;
import alt.jiapi.reflect.Signature;
import java.io.IOException;

public abstract class EventInstrumentor
implements Instrumentor {
    private EventProducer ep;
    private JiapiField eventProducerField;
    private JiapiClass currentClass;

    protected EventInstrumentor(EventProducer ep) {
        this.ep = ep;
    }

    public boolean match(String s) {
        return this.ep.match(s);
    }

    public void instrument(JiapiClass jc) {
        this.currentClass = jc;
        if (jc.isInterface()) {
            return;
        }
        JiapiMethod[] dMethods = jc.getDeclaredMethods();
        for (int i = 0; i < dMethods.length; ++i) {
            if (dMethods[i].isSynthetic() || dMethods[i].getInstructionList() == null) continue;
            int su1 = dMethods[i].getInstructionList().stackUsage();
            this.instrument(dMethods[i]);
            int su2 = dMethods[i].getInstructionList().stackUsage();
            if (su1 == su2) continue;
            System.out.println("ERROR: Instrumentation of " + jc.getName() + ": " + dMethods[i] + " changes stack usage from " + su1 + " to " + su2);
        }
    }

    protected JiapiClass getEventProducer() {
        JiapiClass jc = null;
        try {
            jc = new Loader().loadClass(this.ep.getClass().getName());
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e);
        }
        return jc;
    }

    protected JiapiField getEventProducerField() {
        String fieldName = "__jiapi_field_" + EventRuntime.nextFieldNameIndex();
        EventRuntime.setFieldValue(fieldName, this.ep);
        this.eventProducerField = null;
        try {
            this.eventProducerField = this.currentClass.addField(10, this.ep.getClass().getName(), fieldName);
        }
        catch (FieldExistsException fee) {
            // empty catch block
        }
        JiapiMethod clinit = null;
        try {
            clinit = this.currentClass.getDeclaredMethod("<clinit>", new String[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                clinit = this.currentClass.addMethod(8, "<clinit>", new Signature("void", new String[0]));
                clinit.getInstructionList().add(clinit.getInstructionList().getInstructionFactory().returnMethod(clinit));
            }
            catch (MethodExistsException mee) {
                mee.printStackTrace();
            }
        }
        InstructionList il = clinit.getInstructionList();
        InstructionFactory factory = il.getInstructionFactory();
        InstructionList initializer = il.createEmptyList();
        try {
            JiapiClass er = this.currentClass.getLoader().loadClass("alt.jiapi.event.EventRuntime");
            JiapiMethod gfv = er.getDeclaredMethod("getFieldValue", new String[]{"java.lang.String"});
            initializer.add(factory.pushConstant(fieldName));
            initializer.add(factory.invoke(gfv));
            initializer.add(factory.cast(this.ep.getClass().getName()));
            initializer.add(factory.setField(this.eventProducerField));
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        il.insert(0, initializer);
        return this.eventProducerField;
    }

    public JiapiClass getCurrentClass() {
        return this.currentClass;
    }

    public abstract void instrument(JiapiMethod var1);
}

