/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#include <xparsmlbase.hxx>

static ::css::beans::Pair<::rtl::OUString, ::rtl::OUString>
    icustomMathmlHtmlEntitiesData[starmathdatabase::STARMATH_MATHMLHTML_ENTITY_NUMBER] = {
        // clang-format off
        { u"AElig", u"\u00C6" },
        { u"AMP", u"\u0026" },
        { u"Aacute", u"\u00C1" },
        { u"Abreve", u"\u0102" },
        { u"Acirc", u"\u00C2" },
        { u"Acy", u"\u0410" },
        { u"Afr", u"\U0001D504" },
        { u"Agrave", u"\u00C0" },
        { u"Alpha", u"\u0391" },
        { u"Amacr", u"\u0100" },
        { u"And", u"\u2A53" },
        { u"Aogon", u"\u0104" },
        { u"Aopf", u"\U0001D538" },
        { u"ApplyFunction", u"\u2061" },
        { u"Aring", u"\u00C5" },
        { u"Ascr", u"\U0001D49C" },
        { u"Assign", u"\u2254" },
        { u"Atilde", u"\u00C3" },
        { u"Auml", u"\u00C4" },
        { u"Backslash", u"\u2216" },
        { u"Barv", u"\u2AE7" },
        { u"Barwed", u"\u2306" },
        { u"Bcy", u"\u0411" },
        { u"Because", u"\u2235" },
        { u"Bernoullis", u"\u212C" },
        { u"Beta", u"\u0392" },
        { u"Bfr", u"\U0001D505" },
        { u"Bopf", u"\U0001D539" },
        { u"Breve", u"\u02D8" },
        { u"Bscr", u"\u212C" },
        { u"Bumpeq", u"\u224E" },
        { u"CHcy", u"\u0427" },
        { u"COPY", u"\u00A9" },
        { u"Cacute", u"\u0106" },
        { u"Cap", u"\u22D2" },
        { u"CapitalDifferentialD", u"\u2145" },
        { u"Cayleys", u"\u212D" },
        { u"Ccaron", u"\u010C" },
        { u"Ccedil", u"\u00C7" },
        { u"Ccirc", u"\u0108" },
        { u"Cconint", u"\u2230" },
        { u"Cdot", u"\u010A" },
        { u"Cedilla", u"\u00B8" },
        { u"CenterDot", u"\u00B7" },
        { u"Cfr", u"\u212D" },
        { u"Chi", u"\u03A7" },
        { u"CircleDot", u"\u2299" },
        { u"CircleMinus", u"\u2296" },
        { u"CirclePlus", u"\u2295" },
        { u"CircleTimes", u"\u2297" },
        { u"ClockwiseContourIntegral", u"\u2232" },
        { u"CloseCurlyDoubleQuote", u"\u201D" },
        { u"CloseCurlyQuote", u"\u2019" },
        { u"Colon", u"\u2237" },
        { u"Colone", u"\u2A74" },
        { u"Congruent", u"\u2261" },
        { u"Conint", u"\u222F" },
        { u"ContourIntegral", u"\u222E" },
        { u"Copf", u"\u2102" },
        { u"Coproduct", u"\u2210" },
        { u"CounterClockwiseContourIntegral", u"\u2233" },
        { u"Cross", u"\u2A2F" },
        { u"Cscr", u"\U0001D49E" },
        { u"Cup", u"\u22D3" },
        { u"CupCap", u"\u224D" },
        { u"DD", u"\u2145" },
        { u"DDotrahd", u"\u2911" },
        { u"DJcy", u"\u0402" },
        { u"DScy", u"\u0405" },
        { u"DZcy", u"\u040F" },
        { u"Dagger", u"\u2021" },
        { u"Darr", u"\u21A1" },
        { u"Dashv", u"\u2AE4" },
        { u"Dcaron", u"\u010E" },
        { u"Dcy", u"\u0414" },
        { u"Del", u"\u2207" },
        { u"Delta", u"\u0394" },
        { u"Dfr", u"\U0001D507" },
        { u"DiacriticalAcute", u"\u00B4" },
        { u"DiacriticalDot", u"\u02D9" },
        { u"DiacriticalDoubleAcute", u"\u02DD" },
        { u"DiacriticalGrave", u"\u0060" },
        { u"DiacriticalTilde", u"\u02DC" },
        { u"Diamond", u"\u22C4" },
        { u"DifferentialD", u"\u2146" },
        { u"Dopf", u"\U0001D53B" },
        { u"Dot", u"\u00A8" },
        { u"DotDot", u"\u20DC" },
        { u"DotEqual", u"\u2250" },
        { u"DoubleContourIntegral", u"\u222F" },
        { u"DoubleDot", u"\u00A8" },
        { u"DoubleDownArrow", u"\u21D3" },
        { u"DoubleLeftArrow", u"\u21D0" },
        { u"DoubleLeftRightArrow", u"\u21D4" },
        { u"DoubleLeftTee", u"\u2AE4" },
        { u"DoubleLongLeftArrow", u"\u27F8" },
        { u"DoubleLongLeftRightArrow", u"\u27FA" },
        { u"DoubleLongRightArrow", u"\u27F9" },
        { u"DoubleRightArrow", u"\u21D2" },
        { u"DoubleRightTee", u"\u22A8" },
        { u"DoubleUpArrow", u"\u21D1" },
        { u"DoubleUpDownArrow", u"\u21D5" },
        { u"DoubleVerticalBar", u"\u2225" },
        { u"DownArrow", u"\u2193" },
        { u"DownArrowBar", u"\u2913" },
        { u"DownArrowUpArrow", u"\u21F5" },
        { u"DownBreve", u"\u0311" },
        { u"DownLeftRightVector", u"\u2950" },
        { u"DownLeftTeeVector", u"\u295E" },
        { u"DownLeftVector", u"\u21BD" },
        { u"DownLeftVectorBar", u"\u2956" },
        { u"DownRightTeeVector", u"\u295F" },
        { u"DownRightVector", u"\u21C1" },
        { u"DownRightVectorBar", u"\u2957" },
        { u"DownTee", u"\u22A4" },
        { u"DownTeeArrow", u"\u21A7" },
        { u"Downarrow", u"\u21D3" },
        { u"Dscr", u"\U0001D49F" },
        { u"Dstrok", u"\u0110" },
        { u"ENG", u"\u014A" },
        { u"ETH", u"\u00D0" },
        { u"Eacute", u"\u00C9" },
        { u"Ecaron", u"\u011A" },
        { u"Ecirc", u"\u00CA" },
        { u"Ecy", u"\u042D" },
        { u"Edot", u"\u0116" },
        { u"Efr", u"\U0001D508" },
        { u"Egrave", u"\u00C8" },
        { u"Element", u"\u2208" },
        { u"Emacr", u"\u0112" },
        { u"EmptySmallSquare", u"\u25FB" },
        { u"EmptyVerySmallSquare", u"\u25AB" },
        { u"Eogon", u"\u0118" },
        { u"Eopf", u"\U0001D53C" },
        { u"Epsilon", u"\u0395" },
        { u"Equal", u"\u2A75" },
        { u"EqualTilde", u"\u2242" },
        { u"Equilibrium", u"\u21CC" },
        { u"Escr", u"\u2130" },
        { u"Esim", u"\u2A73" },
        { u"Eta", u"\u0397" },
        { u"Euml", u"\u00CB" },
        { u"Exists", u"\u2203" },
        { u"ExponentialE", u"\u2147" },
        { u"Fcy", u"\u0424" },
        { u"Ffr", u"\U0001D509" },
        { u"FilledSmallSquare", u"\u25FC" },
        { u"FilledVerySmallSquare", u"\u25AA" },
        { u"Fopf", u"\U0001D53D" },
        { u"ForAll", u"\u2200" },
        { u"Fouriertrf", u"\u2131" },
        { u"Fscr", u"\u2131" },
        { u"GJcy", u"\u0403" },
        { u"GT", u"\u003E" },
        { u"Gamma", u"\u0393" },
        { u"Gammad", u"\u03DC" },
        { u"Gbreve", u"\u011E" },
        { u"Gcedil", u"\u0122" },
        { u"Gcirc", u"\u011C" },
        { u"Gcy", u"\u0413" },
        { u"Gdot", u"\u0120" },
        { u"Gfr", u"\U0001D50A" },
        { u"Gg", u"\u22D9" },
        { u"Gopf", u"\U0001D53E" },
        { u"GreaterEqual", u"\u2265" },
        { u"GreaterEqualLess", u"\u22DB" },
        { u"GreaterFullEqual", u"\u2267" },
        { u"GreaterGreater", u"\u2AA2" },
        { u"GreaterLess", u"\u2277" },
        { u"GreaterSlantEqual", u"\u2A7E" },
        { u"GreaterTilde", u"\u2273" },
        { u"Gscr", u"\U0001D4A2" },
        { u"Gt", u"\u226B" },
        { u"HARDcy", u"\u042A" },
        { u"Hacek", u"\u02C7" },
        { u"Hat", u"\u005E" },
        { u"Hcirc", u"\u0124" },
        { u"Hfr", u"\u210C" },
        { u"HilbertSpace", u"\u210B" },
        { u"Hopf", u"\u210D" },
        { u"HorizontalLine", u"\u2500" },
        { u"Hscr", u"\u210B" },
        { u"Hstrok", u"\u0126" },
        { u"HumpDownHump", u"\u224E" },
        { u"HumpEqual", u"\u224F" },
        { u"IEcy", u"\u0415" },
        { u"IJlig", u"\u0132" },
        { u"IOcy", u"\u0401" },
        { u"Iacute", u"\u00CD" },
        { u"Icirc", u"\u00CE" },
        { u"Icy", u"\u0418" },
        { u"Idot", u"\u0130" },
        { u"Ifr", u"\u2111" },
        { u"Igrave", u"\u00CC" },
        { u"Im", u"\u2111" },
        { u"Imacr", u"\u012A" },
        { u"ImaginaryI", u"\u2148" },
        { u"Implies", u"\u21D2" },
        { u"Int", u"\u222C" },
        { u"Integral", u"\u222B" },
        { u"Intersection", u"\u22C2" },
        { u"InvisibleComma", u"\u2063" },
        { u"InvisibleTimes", u"\u2062" },
        { u"Iogon", u"\u012E" },
        { u"Iopf", u"\U0001D540" },
        { u"Iota", u"\u0399" },
        { u"Iscr", u"\u2110" },
        { u"Itilde", u"\u0128" },
        { u"Iukcy", u"\u0406" },
        { u"Iuml", u"\u00CF" },
        { u"Jcirc", u"\u0134" },
        { u"Jcy", u"\u0419" },
        { u"Jfr", u"\U0001D50D" },
        { u"Jopf", u"\U0001D541" },
        { u"Jscr", u"\U0001D4A5" },
        { u"Jsercy", u"\u0408" },
        { u"Jukcy", u"\u0404" },
        { u"KHcy", u"\u0425" },
        { u"KJcy", u"\u040C" },
        { u"Kappa", u"\u039A" },
        { u"Kcedil", u"\u0136" },
        { u"Kcy", u"\u041A" },
        { u"Kfr", u"\U0001D50E" },
        { u"Kopf", u"\U0001D542" },
        { u"Kscr", u"\U0001D4A6" },
        { u"LJcy", u"\u0409" },
        { u"LT", u"\u003C" },
        { u"Lacute", u"\u0139" },
        { u"Lambda", u"\u039B" },
        { u"Lang", u"\u27EA" },
        { u"Laplacetrf", u"\u2112" },
        { u"Larr", u"\u219E" },
        { u"Lcaron", u"\u013D" },
        { u"Lcedil", u"\u013B" },
        { u"Lcy", u"\u041B" },
        { u"LeftAngleBracket", u"\u27E8" },
        { u"LeftArrow", u"\u2190" },
        { u"LeftArrowBar", u"\u21E4" },
        { u"LeftArrowRightArrow", u"\u21C6" },
        { u"LeftCeiling", u"\u2308" },
        { u"LeftDoubleBracket", u"\u27E6" },
        { u"LeftDownTeeVector", u"\u2961" },
        { u"LeftDownVector", u"\u21C3" },
        { u"LeftDownVectorBar", u"\u2959" },
        { u"LeftFloor", u"\u230A" },
        { u"LeftRightArrow", u"\u2194" },
        { u"LeftRightVector", u"\u294E" },
        { u"LeftTee", u"\u22A3" },
        { u"LeftTeeArrow", u"\u21A4" },
        { u"LeftTeeVector", u"\u295A" },
        { u"LeftTriangle", u"\u22B2" },
        { u"LeftTriangleBar", u"\u29CF" },
        { u"LeftTriangleEqual", u"\u22B4" },
        { u"LeftUpDownVector", u"\u2951" },
        { u"LeftUpTeeVector", u"\u2960" },
        { u"LeftUpVector", u"\u21BF" },
        { u"LeftUpVectorBar", u"\u2958" },
        { u"LeftVector", u"\u21BC" },
        { u"LeftVectorBar", u"\u2952" },
        { u"Leftarrow", u"\u21D0" },
        { u"Leftrightarrow", u"\u21D4" },
        { u"LessEqualGreater", u"\u22DA" },
        { u"LessFullEqual", u"\u2266" },
        { u"LessGreater", u"\u2276" },
        { u"LessLess", u"\u2AA1" },
        { u"LessSlantEqual", u"\u2A7D" },
        { u"LessTilde", u"\u2272" },
        { u"Lfr", u"\U0001D50F" },
        { u"Ll", u"\u22D8" },
        { u"Lleftarrow", u"\u21DA" },
        { u"Lmidot", u"\u013F" },
        { u"LongLeftArrow", u"\u27F5" },
        { u"LongLeftRightArrow", u"\u27F7" },
        { u"LongRightArrow", u"\u27F6" },
        { u"Longleftarrow", u"\u27F8" },
        { u"Longleftrightarrow", u"\u27FA" },
        { u"Longrightarrow", u"\u27F9" },
        { u"Lopf", u"\U0001D543" },
        { u"LowerLeftArrow", u"\u2199" },
        { u"LowerRightArrow", u"\u2198" },
        { u"Lscr", u"\u2112" },
        { u"Lsh", u"\u21B0" },
        { u"Lstrok", u"\u0141" },
        { u"Lt", u"\u226A" },
        { u"Map", u"\u2905" },
        { u"Mcy", u"\u041C" },
        { u"MediumSpace", u"\u205F" },
        { u"Mellintrf", u"\u2133" },
        { u"Mfr", u"\U0001D510" },
        { u"MinusPlus", u"\u2213" },
        { u"Mopf", u"\U0001D544" },
        { u"Mscr", u"\u2133" },
        { u"Mu", u"\u039C" },
        { u"NJcy", u"\u040A" },
        { u"Nacute", u"\u0143" },
        { u"Ncaron", u"\u0147" },
        { u"Ncedil", u"\u0145" },
        { u"Ncy", u"\u041D" },
        { u"NegativeMediumSpace", u"\u200B" },
        { u"NegativeThickSpace", u"\u200B" },
        { u"NegativeThinSpace", u"\u200B" },
        { u"NegativeVeryThinSpace", u"\u200B" },
        { u"NestedGreaterGreater", u"\u226B" },
        { u"NestedLessLess", u"\u226A" },
        { u"NewLine", u"\u000A" },
        { u"Nfr", u"\U0001D511" },
        { u"NoBreak", u"\u2060" },
        { u"NonBreakingSpace", u"\u00A0" },
        { u"Nopf", u"\u2115" },
        { u"Not", u"\u2AEC" },
        { u"NotCongruent", u"\u2262" },
        { u"NotCupCap", u"\u226D" },
        { u"NotDoubleVerticalBar", u"\u2226" },
        { u"NotElement", u"\u2209" },
        { u"NotEqual", u"\u2260" },
        { u"NotEqualTilde", u"\u2242\u0338" },
        { u"NotExists", u"\u2204" },
        { u"NotGreater", u"\u226F" },
        { u"NotGreaterEqual", u"\u2271" },
        { u"NotGreaterFullEqual", u"\u2267\u0338" },
        { u"NotGreaterGreater", u"\u226B\u0338" },
        { u"NotGreaterLess", u"\u2279" },
        { u"NotGreaterSlantEqual", u"\u2A7E\u0338" },
        { u"NotGreaterTilde", u"\u2275" },
        { u"NotHumpDownHump", u"\u224E\u0338" },
        { u"NotHumpEqual", u"\u224F\u0338" },
        { u"NotLeftTriangle", u"\u22EA" },
        { u"NotLeftTriangleBar", u"\u29CF\u0338" },
        { u"NotLeftTriangleEqual", u"\u22EC" },
        { u"NotLess", u"\u226E" },
        { u"NotLessEqual", u"\u2270" },
        { u"NotLessGreater", u"\u2278" },
        { u"NotLessLess", u"\u226A\u0338" },
        { u"NotLessSlantEqual", u"\u2A7D\u0338" },
        { u"NotLessTilde", u"\u2274" },
        { u"NotNestedGreaterGreater", u"\u2AA2\u0338" },
        { u"NotNestedLessLess", u"\u2AA1\u0338" },
        { u"NotPrecedes", u"\u2280" },
        { u"NotPrecedesEqual", u"\u2AAF\u0338" },
        { u"NotPrecedesSlantEqual", u"\u22E0" },
        { u"NotReverseElement", u"\u220C" },
        { u"NotRightTriangle", u"\u22EB" },
        { u"NotRightTriangleBar", u"\u29D0\u0338" },
        { u"NotRightTriangleEqual", u"\u22ED" },
        { u"NotSquareSubset", u"\u228F\u0338" },
        { u"NotSquareSubsetEqual", u"\u22E2" },
        { u"NotSquareSuperset", u"\u2290\u0338" },
        { u"NotSquareSupersetEqual", u"\u22E3" },
        { u"NotSubset", u"\u2282\u20D2" },
        { u"NotSubsetEqual", u"\u2288" },
        { u"NotSucceeds", u"\u2281" },
        { u"NotSucceedsEqual", u"\u2AB0\u0338" },
        { u"NotSucceedsSlantEqual", u"\u22E1" },
        { u"NotSucceedsTilde", u"\u227F\u0338" },
        { u"NotSuperset", u"\u2283\u20D2" },
        { u"NotSupersetEqual", u"\u2289" },
        { u"NotTilde", u"\u2241" },
        { u"NotTildeEqual", u"\u2244" },
        { u"NotTildeFullEqual", u"\u2247" },
        { u"NotTildeTilde", u"\u2249" },
        { u"NotVerticalBar", u"\u2224" },
        { u"Nscr", u"\U0001D4A9" },
        { u"Ntilde", u"\u00D1" },
        { u"Nu", u"\u039D" },
        { u"OElig", u"\u0152" },
        { u"Oacute", u"\u00D3" },
        { u"Ocirc", u"\u00D4" },
        { u"Ocy", u"\u041E" },
        { u"Odblac", u"\u0150" },
        { u"Ofr", u"\U0001D512" },
        { u"Ograve", u"\u00D2" },
        { u"Omacr", u"\u014C" },
        { u"Omega", u"\u03A9" },
        { u"Omicron", u"\u039F" },
        { u"Oopf", u"\U0001D546" },
        { u"OpenCurlyDoubleQuote", u"\u201C" },
        { u"OpenCurlyQuote", u"\u2018" },
        { u"Or", u"\u2A54" },
        { u"Oscr", u"\U0001D4AA" },
        { u"Oslash", u"\u00D8" },
        { u"Otilde", u"\u00D5" },
        { u"Otimes", u"\u2A37" },
        { u"Ouml", u"\u00D6" },
        { u"OverBar", u"\u203E" },
        { u"OverBrace", u"\u23DE" },
        { u"OverBracket", u"\u23B4" },
        { u"OverParenthesis", u"\u23DC" },
        { u"PartialD", u"\u2202" },
        { u"Pcy", u"\u041F" },
        { u"Pfr", u"\U0001D513" },
        { u"Phi", u"\u03A6" },
        { u"Pi", u"\u03A0" },
        { u"PlusMinus", u"\u00B1" },
        { u"Poincareplane", u"\u210C" },
        { u"Popf", u"\u2119" },
        { u"Pr", u"\u2ABB" },
        { u"Precedes", u"\u227A" },
        { u"PrecedesEqual", u"\u2AAF" },
        { u"PrecedesSlantEqual", u"\u227C" },
        { u"PrecedesTilde", u"\u227E" },
        { u"Prime", u"\u2033" },
        { u"Product", u"\u220F" },
        { u"Proportion", u"\u2237" },
        { u"Proportional", u"\u221D" },
        { u"Pscr", u"\U0001D4AB" },
        { u"Psi", u"\u03A8" },
        { u"QUOT", u"\u0022" },
        { u"Qfr", u"\U0001D514" },
        { u"Qopf", u"\u211A" },
        { u"Qscr", u"\U0001D4AC" },
        { u"RBarr", u"\u2910" },
        { u"REG", u"\u00AE" },
        { u"Racute", u"\u0154" },
        { u"Rang", u"\u27EB" },
        { u"Rarr", u"\u21A0" },
        { u"Rarrtl", u"\u2916" },
        { u"Rcaron", u"\u0158" },
        { u"Rcedil", u"\u0156" },
        { u"Rcy", u"\u0420" },
        { u"Re", u"\u211C" },
        { u"ReverseElement", u"\u220B" },
        { u"ReverseEquilibrium", u"\u21CB" },
        { u"ReverseUpEquilibrium", u"\u296F" },
        { u"Rfr", u"\u211C" },
        { u"Rho", u"\u03A1" },
        { u"RightAngleBracket", u"\u27E9" },
        { u"RightArrow", u"\u2192" },
        { u"RightArrowBar", u"\u21E5" },
        { u"RightArrowLeftArrow", u"\u21C4" },
        { u"RightCeiling", u"\u2309" },
        { u"RightDoubleBracket", u"\u27E7" },
        { u"RightDownTeeVector", u"\u295D" },
        { u"RightDownVector", u"\u21C2" },
        { u"RightDownVectorBar", u"\u2955" },
        { u"RightFloor", u"\u230B" },
        { u"RightTee", u"\u22A2" },
        { u"RightTeeArrow", u"\u21A6" },
        { u"RightTeeVector", u"\u295B" },
        { u"RightTriangle", u"\u22B3" },
        { u"RightTriangleBar", u"\u29D0" },
        { u"RightTriangleEqual", u"\u22B5" },
        { u"RightUpDownVector", u"\u294F" },
        { u"RightUpTeeVector", u"\u295C" },
        { u"RightUpVector", u"\u21BE" },
        { u"RightUpVectorBar", u"\u2954" },
        { u"RightVector", u"\u21C0" },
        { u"RightVectorBar", u"\u2953" },
        { u"Rightarrow", u"\u21D2" },
        { u"Ropf", u"\u211D" },
        { u"RoundImplies", u"\u2970" },
        { u"Rrightarrow", u"\u21DB" },
        { u"Rscr", u"\u211B" },
        { u"Rsh", u"\u21B1" },
        { u"RuleDelayed", u"\u29F4" },
        { u"SHCHcy", u"\u0429" },
        { u"SHcy", u"\u0428" },
        { u"SOFTcy", u"\u042C" },
        { u"Sacute", u"\u015A" },
        { u"Sc", u"\u2ABC" },
        { u"Scaron", u"\u0160" },
        { u"Scedil", u"\u015E" },
        { u"Scirc", u"\u015C" },
        { u"Scy", u"\u0421" },
        { u"Sfr", u"\U0001D516" },
        { u"ShortDownArrow", u"\u2193" },
        { u"ShortLeftArrow", u"\u2190" },
        { u"ShortRightArrow", u"\u2192" },
        { u"ShortUpArrow", u"\u2191" },
        { u"Sigma", u"\u03A3" },
        { u"SmallCircle", u"\u2218" },
        { u"Sopf", u"\U0001D54A" },
        { u"Sqrt", u"\u221A" },
        { u"Square", u"\u25A1" },
        { u"SquareIntersection", u"\u2293" },
        { u"SquareSubset", u"\u228F" },
        { u"SquareSubsetEqual", u"\u2291" },
        { u"SquareSuperset", u"\u2290" },
        { u"SquareSupersetEqual", u"\u2292" },
        { u"SquareUnion", u"\u2294" },
        { u"Sscr", u"\U0001D4AE" },
        { u"Star", u"\u22C6" },
        { u"Sub", u"\u22D0" },
        { u"Subset", u"\u22D0" },
        { u"SubsetEqual", u"\u2286" },
        { u"Succeeds", u"\u227B" },
        { u"SucceedsEqual", u"\u2AB0" },
        { u"SucceedsSlantEqual", u"\u227D" },
        { u"SucceedsTilde", u"\u227F" },
        { u"SuchThat", u"\u220B" },
        { u"Sum", u"\u2211" },
        { u"Sup", u"\u22D1" },
        { u"Superset", u"\u2283" },
        { u"SupersetEqual", u"\u2287" },
        { u"Supset", u"\u22D1" },
        { u"THORN", u"\u00DE" },
        { u"TRADE", u"\u2122" },
        { u"TSHcy", u"\u040B" },
        { u"TScy", u"\u0426" },
        { u"Tab", u"\u0009" },
        { u"Tau", u"\u03A4" },
        { u"Tcaron", u"\u0164" },
        { u"Tcedil", u"\u0162" },
        { u"Tcy", u"\u0422" },
        { u"Tfr", u"\U0001D517" },
        { u"Therefore", u"\u2234" },
        { u"Theta", u"\u0398" },
        { u"ThickSpace", u"\u205F\u200A" },
        { u"ThinSpace", u"\u2009" },
        { u"Tilde", u"\u223C" },
        { u"TildeEqual", u"\u2243" },
        { u"TildeFullEqual", u"\u2245" },
        { u"TildeTilde", u"\u2248" },
        { u"Topf", u"\U0001D54B" },
        { u"TripleDot", u"\u20DB" },
        { u"Tscr", u"\U0001D4AF" },
        { u"Tstrok", u"\u0166" },
        { u"Uacute", u"\u00DA" },
        { u"Uarr", u"\u219F" },
        { u"Uarrocir", u"\u2949" },
        { u"Ubrcy", u"\u040E" },
        { u"Ubreve", u"\u016C" },
        { u"Ucirc", u"\u00DB" },
        { u"Ucy", u"\u0423" },
        { u"Udblac", u"\u0170" },
        { u"Ufr", u"\U0001D518" },
        { u"Ugrave", u"\u00D9" },
        { u"Umacr", u"\u016A" },
        { u"UnderBar", u"\u005F" },
        { u"UnderBrace", u"\u23DF" },
        { u"UnderBracket", u"\u23B5" },
        { u"UnderParenthesis", u"\u23DD" },
        { u"Union", u"\u22C3" },
        { u"UnionPlus", u"\u228E" },
        { u"Uogon", u"\u0172" },
        { u"Uopf", u"\U0001D54C" },
        { u"UpArrow", u"\u2191" },
        { u"UpArrowBar", u"\u2912" },
        { u"UpArrowDownArrow", u"\u21C5" },
        { u"UpDownArrow", u"\u2195" },
        { u"UpEquilibrium", u"\u296E" },
        { u"UpTee", u"\u22A5" },
        { u"UpTeeArrow", u"\u21A5" },
        { u"Uparrow", u"\u21D1" },
        { u"Updownarrow", u"\u21D5" },
        { u"UpperLeftArrow", u"\u2196" },
        { u"UpperRightArrow", u"\u2197" },
        { u"Upsi", u"\u03D2" },
        { u"Upsilon", u"\u03A5" },
        { u"Uring", u"\u016E" },
        { u"Uscr", u"\U0001D4B0" },
        { u"Utilde", u"\u0168" },
        { u"Uuml", u"\u00DC" },
        { u"VDash", u"\u22AB" },
        { u"Vbar", u"\u2AEB" },
        { u"Vcy", u"\u0412" },
        { u"Vdash", u"\u22A9" },
        { u"Vdashl", u"\u2AE6" },
        { u"Vee", u"\u22C1" },
        { u"Verbar", u"\u2016" },
        { u"Vert", u"\u2016" },
        { u"VerticalBar", u"\u2223" },
        { u"VerticalLine", u"\u007C" },
        { u"VerticalSeparator", u"\u2758" },
        { u"VerticalTilde", u"\u2240" },
        { u"VeryThinSpace", u"\u200A" },
        { u"Vfr", u"\U0001D519" },
        { u"Vopf", u"\U0001D54D" },
        { u"Vscr", u"\U0001D4B1" },
        { u"Vvdash", u"\u22AA" },
        { u"Wcirc", u"\u0174" },
        { u"Wedge", u"\u22C0" },
        { u"Wfr", u"\U0001D51A" },
        { u"Wopf", u"\U0001D54E" },
        { u"Wscr", u"\U0001D4B2" },
        { u"Xfr", u"\U0001D51B" },
        { u"Xi", u"\u039E" },
        { u"Xopf", u"\U0001D54F" },
        { u"Xscr", u"\U0001D4B3" },
        { u"YAcy", u"\u042F" },
        { u"YIcy", u"\u0407" },
        { u"YUcy", u"\u042E" },
        { u"Yacute", u"\u00DD" },
        { u"Ycirc", u"\u0176" },
        { u"Ycy", u"\u042B" },
        { u"Yfr", u"\U0001D51C" },
        { u"Yopf", u"\U0001D550" },
        { u"Yscr", u"\U0001D4B4" },
        { u"Yuml", u"\u0178" },
        { u"ZHcy", u"\u0416" },
        { u"Zacute", u"\u0179" },
        { u"Zcaron", u"\u017D" },
        { u"Zcy", u"\u0417" },
        { u"Zdot", u"\u017B" },
        { u"ZeroWidthSpace", u"\u200B" },
        { u"Zeta", u"\u0396" },
        { u"Zfr", u"\u2128" },
        { u"Zopf", u"\u2124" },
        { u"Zscr", u"\U0001D4B5" },
        { u"aacute", u"\u00E1" },
        { u"abreve", u"\u0103" },
        { u"ac", u"\u223E" },
        { u"acE", u"\u223E\u0333" },
        { u"acd", u"\u223F" },
        { u"acirc", u"\u00E2" },
        { u"acute", u"\u00B4" },
        { u"acy", u"\u0430" },
        { u"aelig", u"\u00E6" },
        { u"af", u"\u2061" },
        { u"afr", u"\U0001D51E" },
        { u"agrave", u"\u00E0" },
        { u"alefsym", u"\u2135" },
        { u"aleph", u"\u2135" },
        { u"alpha", u"\u03B1" },
        { u"amacr", u"\u0101" },
        { u"amalg", u"\u2A3F" },
        { u"amp", u"\u0026" },
        { u"and", u"\u2227" },
        { u"andand", u"\u2A55" },
        { u"andd", u"\u2A5C" },
        { u"andslope", u"\u2A58" },
        { u"andv", u"\u2A5A" },
        { u"ang", u"\u2220" },
        { u"ange", u"\u29A4" },
        { u"angle", u"\u2220" },
        { u"angmsd", u"\u2221" },
        { u"angmsdaa", u"\u29A8" },
        { u"angmsdab", u"\u29A9" },
        { u"angmsdac", u"\u29AA" },
        { u"angmsdad", u"\u29AB" },
        { u"angmsdae", u"\u29AC" },
        { u"angmsdaf", u"\u29AD" },
        { u"angmsdag", u"\u29AE" },
        { u"angmsdah", u"\u29AF" },
        { u"angrt", u"\u221F" },
        { u"angrtvb", u"\u22BE" },
        { u"angrtvbd", u"\u299D" },
        { u"angsph", u"\u2222" },
        { u"angst", u"\u00C5" },
        { u"angzarr", u"\u237C" },
        { u"aogon", u"\u0105" },
        { u"aopf", u"\U0001D552" },
        { u"ap", u"\u2248" },
        { u"apE", u"\u2A70" },
        { u"apacir", u"\u2A6F" },
        { u"ape", u"\u224A" },
        { u"apid", u"\u224B" },
        { u"apos", u"\u0027" },
        { u"approx", u"\u2248" },
        { u"approxeq", u"\u224A" },
        { u"aring", u"\u00E5" },
        { u"ascr", u"\U0001D4B6" },
        { u"ast", u"\u002A" },
        { u"asymp", u"\u2248" },
        { u"asympeq", u"\u224D" },
        { u"atilde", u"\u00E3" },
        { u"auml", u"\u00E4" },
        { u"awconint", u"\u2233" },
        { u"awint", u"\u2A11" },
        { u"bNot", u"\u2AED" },
        { u"backcong", u"\u224C" },
        { u"backepsilon", u"\u03F6" },
        { u"backprime", u"\u2035" },
        { u"backsim", u"\u223D" },
        { u"backsimeq", u"\u22CD" },
        { u"barvee", u"\u22BD" },
        { u"barwed", u"\u2305" },
        { u"barwedge", u"\u2305" },
        { u"bbrk", u"\u23B5" },
        { u"bbrktbrk", u"\u23B6" },
        { u"bcong", u"\u224C" },
        { u"bcy", u"\u0431" },
        { u"bdquo", u"\u201E" },
        { u"becaus", u"\u2235" },
        { u"because", u"\u2235" },
        { u"bemptyv", u"\u29B0" },
        { u"bepsi", u"\u03F6" },
        { u"bernou", u"\u212C" },
        { u"beta", u"\u03B2" },
        { u"beth", u"\u2136" },
        { u"between", u"\u226C" },
        { u"bfr", u"\U0001D51F" },
        { u"bigcap", u"\u22C2" },
        { u"bigcirc", u"\u25EF" },
        { u"bigcup", u"\u22C3" },
        { u"bigodot", u"\u2A00" },
        { u"bigoplus", u"\u2A01" },
        { u"bigotimes", u"\u2A02" },
        { u"bigsqcup", u"\u2A06" },
        { u"bigstar", u"\u2605" },
        { u"bigtriangledown", u"\u25BD" },
        { u"bigtriangleup", u"\u25B3" },
        { u"biguplus", u"\u2A04" },
        { u"bigvee", u"\u22C1" },
        { u"bigwedge", u"\u22C0" },
        { u"bkarow", u"\u290D" },
        { u"blacklozenge", u"\u29EB" },
        { u"blacksquare", u"\u25AA" },
        { u"blacktriangle", u"\u25B4" },
        { u"blacktriangledown", u"\u25BE" },
        { u"blacktriangleleft", u"\u25C2" },
        { u"blacktriangleright", u"\u25B8" },
        { u"blank", u"\u2423" },
        { u"blk12", u"\u2592" },
        { u"blk14", u"\u2591" },
        { u"blk34", u"\u2593" },
        { u"block", u"\u2588" },
        { u"bne", u"\u003D\u20E5" },
        { u"bnequiv", u"\u2261\u20E5" },
        { u"bnot", u"\u2310" },
        { u"bopf", u"\U0001D553" },
        { u"bot", u"\u22A5" },
        { u"bottom", u"\u22A5" },
        { u"bowtie", u"\u22C8" },
        { u"boxDL", u"\u2557" },
        { u"boxDR", u"\u2554" },
        { u"boxDl", u"\u2556" },
        { u"boxDr", u"\u2553" },
        { u"boxH", u"\u2550" },
        { u"boxHD", u"\u2566" },
        { u"boxHU", u"\u2569" },
        { u"boxHd", u"\u2564" },
        { u"boxHu", u"\u2567" },
        { u"boxUL", u"\u255D" },
        { u"boxUR", u"\u255A" },
        { u"boxUl", u"\u255C" },
        { u"boxUr", u"\u2559" },
        { u"boxV", u"\u2551" },
        { u"boxVH", u"\u256C" },
        { u"boxVL", u"\u2563" },
        { u"boxVR", u"\u2560" },
        { u"boxVh", u"\u256B" },
        { u"boxVl", u"\u2562" },
        { u"boxVr", u"\u255F" },
        { u"boxbox", u"\u29C9" },
        { u"boxdL", u"\u2555" },
        { u"boxdR", u"\u2552" },
        { u"boxdl", u"\u2510" },
        { u"boxdr", u"\u250C" },
        { u"boxh", u"\u2500" },
        { u"boxhD", u"\u2565" },
        { u"boxhU", u"\u2568" },
        { u"boxhd", u"\u252C" },
        { u"boxhu", u"\u2534" },
        { u"boxminus", u"\u229F" },
        { u"boxplus", u"\u229E" },
        { u"boxtimes", u"\u22A0" },
        { u"boxuL", u"\u255B" },
        { u"boxuR", u"\u2558" },
        { u"boxul", u"\u2518" },
        { u"boxur", u"\u2514" },
        { u"boxv", u"\u2502" },
        { u"boxvH", u"\u256A" },
        { u"boxvL", u"\u2561" },
        { u"boxvR", u"\u255E" },
        { u"boxvh", u"\u253C" },
        { u"boxvl", u"\u2524" },
        { u"boxvr", u"\u251C" },
        { u"bprime", u"\u2035" },
        { u"breve", u"\u02D8" },
        { u"brvbar", u"\u00A6" },
        { u"bscr", u"\U0001D4B7" },
        { u"bsemi", u"\u204F" },
        { u"bsim", u"\u223D" },
        { u"bsime", u"\u22CD" },
        { u"bsol", u"\u005C" },
        { u"bsolb", u"\u29C5" },
        { u"bsolhsub", u"\u27C8" },
        { u"bull", u"\u2022" },
        { u"bullet", u"\u2022" },
        { u"bump", u"\u224E" },
        { u"bumpE", u"\u2AAE" },
        { u"bumpe", u"\u224F" },
        { u"bumpeq", u"\u224F" },
        { u"cacute", u"\u0107" },
        { u"cap", u"\u2229" },
        { u"capand", u"\u2A44" },
        { u"capbrcup", u"\u2A49" },
        { u"capcap", u"\u2A4B" },
        { u"capcup", u"\u2A47" },
        { u"capdot", u"\u2A40" },
        { u"caps", u"\u2229\uFE00" },
        { u"caret", u"\u2041" },
        { u"caron", u"\u02C7" },
        { u"ccaps", u"\u2A4D" },
        { u"ccaron", u"\u010D" },
        { u"ccedil", u"\u00E7" },
        { u"ccirc", u"\u0109" },
        { u"ccups", u"\u2A4C" },
        { u"ccupssm", u"\u2A50" },
        { u"cdot", u"\u010B" },
        { u"cedil", u"\u00B8" },
        { u"cemptyv", u"\u29B2" },
        { u"cent", u"\u00A2" },
        { u"centerdot", u"\u00B7" },
        { u"cfr", u"\U0001D520" },
        { u"chcy", u"\u0447" },
        { u"check", u"\u2713" },
        { u"checkmark", u"\u2713" },
        { u"chi", u"\u03C7" },
        { u"cir", u"\u25CB" },
        { u"cirE", u"\u29C3" },
        { u"circ", u"\u02C6" },
        { u"circeq", u"\u2257" },
        { u"circlearrowleft", u"\u21BA" },
        { u"circlearrowright", u"\u21BB" },
        { u"circledR", u"\u00AE" },
        { u"circledS", u"\u24C8" },
        { u"circledast", u"\u229B" },
        { u"circledcirc", u"\u229A" },
        { u"circleddash", u"\u229D" },
        { u"cire", u"\u2257" },
        { u"cirfnint", u"\u2A10" },
        { u"cirmid", u"\u2AEF" },
        { u"cirscir", u"\u29C2" },
        { u"clubs", u"\u2663" },
        { u"clubsuit", u"\u2663" },
        { u"colon", u"\u003A" },
        { u"colone", u"\u2254" },
        { u"coloneq", u"\u2254" },
        { u"comma", u"\u002C" },
        { u"commat", u"\u0040" },
        { u"comp", u"\u2201" },
        { u"compfn", u"\u2218" },
        { u"complement", u"\u2201" },
        { u"complexes", u"\u2102" },
        { u"cong", u"\u2245" },
        { u"congdot", u"\u2A6D" },
        { u"conint", u"\u222E" },
        { u"copf", u"\U0001D554" },
        { u"coprod", u"\u2210" },
        { u"copy", u"\u00A9" },
        { u"copysr", u"\u2117" },
        { u"crarr", u"\u21B5" },
        { u"cross", u"\u2717" },
        { u"cscr", u"\U0001D4B8" },
        { u"csub", u"\u2ACF" },
        { u"csube", u"\u2AD1" },
        { u"csup", u"\u2AD0" },
        { u"csupe", u"\u2AD2" },
        { u"ctdot", u"\u22EF" },
        { u"cudarrl", u"\u2938" },
        { u"cudarrr", u"\u2935" },
        { u"cuepr", u"\u22DE" },
        { u"cuesc", u"\u22DF" },
        { u"cularr", u"\u21B6" },
        { u"cularrp", u"\u293D" },
        { u"cup", u"\u222A" },
        { u"cupbrcap", u"\u2A48" },
        { u"cupcap", u"\u2A46" },
        { u"cupcup", u"\u2A4A" },
        { u"cupdot", u"\u228D" },
        { u"cupor", u"\u2A45" },
        { u"cups", u"\u222A\uFE00" },
        { u"curarr", u"\u21B7" },
        { u"curarrm", u"\u293C" },
        { u"curlyeqprec", u"\u22DE" },
        { u"curlyeqsucc", u"\u22DF" },
        { u"curlyvee", u"\u22CE" },
        { u"curlywedge", u"\u22CF" },
        { u"curren", u"\u00A4" },
        { u"curvearrowleft", u"\u21B6" },
        { u"curvearrowright", u"\u21B7" },
        { u"cuvee", u"\u22CE" },
        { u"cuwed", u"\u22CF" },
        { u"cwconint", u"\u2232" },
        { u"cwint", u"\u2231" },
        { u"cylcty", u"\u232D" },
        { u"dArr", u"\u21D3" },
        { u"dHar", u"\u2965" },
        { u"dagger", u"\u2020" },
        { u"daleth", u"\u2138" },
        { u"darr", u"\u2193" },
        { u"dash", u"\u2010" },
        { u"dashv", u"\u22A3" },
        { u"dbkarow", u"\u290F" },
        { u"dblac", u"\u02DD" },
        { u"dcaron", u"\u010F" },
        { u"dcy", u"\u0434" },
        { u"dd", u"\u2146" },
        { u"ddagger", u"\u2021" },
        { u"ddarr", u"\u21CA" },
        { u"ddotseq", u"\u2A77" },
        { u"deg", u"\u00B0" },
        { u"delta", u"\u03B4" },
        { u"demptyv", u"\u29B1" },
        { u"dfisht", u"\u297F" },
        { u"dfr", u"\U0001D521" },
        { u"dharl", u"\u21C3" },
        { u"dharr", u"\u21C2" },
        { u"diam", u"\u22C4" },
        { u"diamond", u"\u22C4" },
        { u"diamondsuit", u"\u2666" },
        { u"diams", u"\u2666" },
        { u"die", u"\u00A8" },
        { u"digamma", u"\u03DD" },
        { u"disin", u"\u22F2" },
        { u"div", u"\u00F7" },
        { u"divide", u"\u00F7" },
        { u"divideontimes", u"\u22C7" },
        { u"divonx", u"\u22C7" },
        { u"djcy", u"\u0452" },
        { u"dlcorn", u"\u231E" },
        { u"dlcrop", u"\u230D" },
        { u"dollar", u"\u0024" },
        { u"dopf", u"\U0001D555" },
        { u"dot", u"\u02D9" },
        { u"doteq", u"\u2250" },
        { u"doteqdot", u"\u2251" },
        { u"dotminus", u"\u2238" },
        { u"dotplus", u"\u2214" },
        { u"dotsquare", u"\u22A1" },
        { u"doublebarwedge", u"\u2306" },
        { u"downarrow", u"\u2193" },
        { u"downdownarrows", u"\u21CA" },
        { u"downharpoonleft", u"\u21C3" },
        { u"downharpoonright", u"\u21C2" },
        { u"drbkarow", u"\u2910" },
        { u"drcorn", u"\u231F" },
        { u"drcrop", u"\u230C" },
        { u"dscr", u"\U0001D4B9" },
        { u"dscy", u"\u0455" },
        { u"dsol", u"\u29F6" },
        { u"dstrok", u"\u0111" },
        { u"dtdot", u"\u22F1" },
        { u"dtri", u"\u25BF" },
        { u"dtrif", u"\u25BE" },
        { u"duarr", u"\u21F5" },
        { u"duhar", u"\u296F" },
        { u"dwangle", u"\u29A6" },
        { u"dzcy", u"\u045F" },
        { u"dzigrarr", u"\u27FF" },
        { u"eDDot", u"\u2A77" },
        { u"eDot", u"\u2251" },
        { u"eacute", u"\u00E9" },
        { u"easter", u"\u2A6E" },
        { u"ecaron", u"\u011B" },
        { u"ecir", u"\u2256" },
        { u"ecirc", u"\u00EA" },
        { u"ecolon", u"\u2255" },
        { u"ecy", u"\u044D" },
        { u"edot", u"\u0117" },
        { u"ee", u"\u2147" },
        { u"efDot", u"\u2252" },
        { u"efr", u"\U0001D522" },
        { u"eg", u"\u2A9A" },
        { u"egrave", u"\u00E8" },
        { u"egs", u"\u2A96" },
        { u"egsdot", u"\u2A98" },
        { u"el", u"\u2A99" },
        { u"elinters", u"\u23E7" },
        { u"ell", u"\u2113" },
        { u"els", u"\u2A95" },
        { u"elsdot", u"\u2A97" },
        { u"emacr", u"\u0113" },
        { u"empty", u"\u2205" },
        { u"emptyset", u"\u2205" },
        { u"emptyv", u"\u2205" },
        { u"emsp", u"\u2003" },
        { u"emsp13", u"\u2004" },
        { u"emsp14", u"\u2005" },
        { u"eng", u"\u014B" },
        { u"ensp", u"\u2002" },
        { u"eogon", u"\u0119" },
        { u"eopf", u"\U0001D556" },
        { u"epar", u"\u22D5" },
        { u"eparsl", u"\u29E3" },
        { u"eplus", u"\u2A71" },
        { u"epsi", u"\u03B5" },
        { u"epsilon", u"\u03B5" },
        { u"epsiv", u"\u03F5" },
        { u"eqcirc", u"\u2256" },
        { u"eqcolon", u"\u2255" },
        { u"eqsim", u"\u2242" },
        { u"eqslantgtr", u"\u2A96" },
        { u"eqslantless", u"\u2A95" },
        { u"equals", u"\u003D" },
        { u"equest", u"\u225F" },
        { u"equiv", u"\u2261" },
        { u"equivDD", u"\u2A78" },
        { u"eqvparsl", u"\u29E5" },
        { u"erDot", u"\u2253" },
        { u"erarr", u"\u2971" },
        { u"escr", u"\u212F" },
        { u"esdot", u"\u2250" },
        { u"esim", u"\u2242" },
        { u"eta", u"\u03B7" },
        { u"eth", u"\u00F0" },
        { u"euml", u"\u00EB" },
        { u"euro", u"\u20AC" },
        { u"excl", u"\u0021" },
        { u"exist", u"\u2203" },
        { u"expectation", u"\u2130" },
        { u"exponentiale", u"\u2147" },
        { u"fallingdotseq", u"\u2252" },
        { u"fcy", u"\u0444" },
        { u"female", u"\u2640" },
        { u"ffilig", u"\uFB03" },
        { u"fflig", u"\uFB00" },
        { u"ffllig", u"\uFB04" },
        { u"ffr", u"\U0001D523" },
        { u"filig", u"\uFB01" },
        { u"fjlig", u"\u0066\u006A" },
        { u"flat", u"\u266D" },
        { u"fllig", u"\uFB02" },
        { u"fltns", u"\u25B1" },
        { u"fnof", u"\u0192" },
        { u"fopf", u"\U0001D557" },
        { u"forall", u"\u2200" },
        { u"fork", u"\u22D4" },
        { u"forkv", u"\u2AD9" },
        { u"fpartint", u"\u2A0D" },
        { u"frac12", u"\u00BD" },
        { u"frac13", u"\u2153" },
        { u"frac14", u"\u00BC" },
        { u"frac15", u"\u2155" },
        { u"frac16", u"\u2159" },
        { u"frac18", u"\u215B" },
        { u"frac23", u"\u2154" },
        { u"frac25", u"\u2156" },
        { u"frac34", u"\u00BE" },
        { u"frac35", u"\u2157" },
        { u"frac38", u"\u215C" },
        { u"frac45", u"\u2158" },
        { u"frac56", u"\u215A" },
        { u"frac58", u"\u215D" },
        { u"frac78", u"\u215E" },
        { u"frasl", u"\u2044" },
        { u"frown", u"\u2322" },
        { u"fscr", u"\U0001D4BB" },
        { u"gE", u"\u2267" },
        { u"gEl", u"\u2A8C" },
        { u"gacute", u"\u01F5" },
        { u"gamma", u"\u03B3" },
        { u"gammad", u"\u03DD" },
        { u"gap", u"\u2A86" },
        { u"gbreve", u"\u011F" },
        { u"gcirc", u"\u011D" },
        { u"gcy", u"\u0433" },
        { u"gdot", u"\u0121" },
        { u"ge", u"\u2265" },
        { u"gel", u"\u22DB" },
        { u"geq", u"\u2265" },
        { u"geqq", u"\u2267" },
        { u"geqslant", u"\u2A7E" },
        { u"ges", u"\u2A7E" },
        { u"gescc", u"\u2AA9" },
        { u"gesdot", u"\u2A80" },
        { u"gesdoto", u"\u2A82" },
        { u"gesdotol", u"\u2A84" },
        { u"gesl", u"\u22DB\uFE00" },
        { u"gesles", u"\u2A94" },
        { u"gfr", u"\U0001D524" },
        { u"gg", u"\u226B" },
        { u"ggg", u"\u22D9" },
        { u"gimel", u"\u2137" },
        { u"gjcy", u"\u0453" },
        { u"gl", u"\u2277" },
        { u"glE", u"\u2A92" },
        { u"gla", u"\u2AA5" },
        { u"glj", u"\u2AA4" },
        { u"gnE", u"\u2269" },
        { u"gnap", u"\u2A8A" },
        { u"gnapprox", u"\u2A8A" },
        { u"gne", u"\u2A88" },
        { u"gneq", u"\u2A88" },
        { u"gneqq", u"\u2269" },
        { u"gnsim", u"\u22E7" },
        { u"gopf", u"\U0001D558" },
        { u"grave", u"\u0060" },
        { u"gscr", u"\u210A" },
        { u"gsim", u"\u2273" },
        { u"gsime", u"\u2A8E" },
        { u"gsiml", u"\u2A90" },
        { u"gt", u"\u003E" },
        { u"gtcc", u"\u2AA7" },
        { u"gtcir", u"\u2A7A" },
        { u"gtdot", u"\u22D7" },
        { u"gtlPar", u"\u2995" },
        { u"gtquest", u"\u2A7C" },
        { u"gtrapprox", u"\u2A86" },
        { u"gtrarr", u"\u2978" },
        { u"gtrdot", u"\u22D7" },
        { u"gtreqless", u"\u22DB" },
        { u"gtreqqless", u"\u2A8C" },
        { u"gtrless", u"\u2277" },
        { u"gtrsim", u"\u2273" },
        { u"gvertneqq", u"\u2269\uFE00" },
        { u"gvnE", u"\u2269\uFE00" },
        { u"hArr", u"\u21D4" },
        { u"hairsp", u"\u200A" },
        { u"half", u"\u00BD" },
        { u"hamilt", u"\u210B" },
        { u"hardcy", u"\u044A" },
        { u"harr", u"\u2194" },
        { u"harrcir", u"\u2948" },
        { u"harrw", u"\u21AD" },
        { u"hbar", u"\u210F" },
        { u"hcirc", u"\u0125" },
        { u"hearts", u"\u2665" },
        { u"heartsuit", u"\u2665" },
        { u"hellip", u"\u2026" },
        { u"hercon", u"\u22B9" },
        { u"hfr", u"\U0001D525" },
        { u"hksearow", u"\u2925" },
        { u"hkswarow", u"\u2926" },
        { u"hoarr", u"\u21FF" },
        { u"homtht", u"\u223B" },
        { u"hookleftarrow", u"\u21A9" },
        { u"hookrightarrow", u"\u21AA" },
        { u"hopf", u"\U0001D559" },
        { u"horbar", u"\u2015" },
        { u"hscr", u"\U0001D4BD" },
        { u"hslash", u"\u210F" },
        { u"hstrok", u"\u0127" },
        { u"hybull", u"\u2043" },
        { u"hyphen", u"\u2010" },
        { u"iacute", u"\u00ED" },
        { u"ic", u"\u2063" },
        { u"icirc", u"\u00EE" },
        { u"icy", u"\u0438" },
        { u"iecy", u"\u0435" },
        { u"iexcl", u"\u00A1" },
        { u"iff", u"\u21D4" },
        { u"ifr", u"\U0001D526" },
        { u"igrave", u"\u00EC" },
        { u"ii", u"\u2148" },
        { u"iiiint", u"\u2A0C" },
        { u"iiint", u"\u222D" },
        { u"iinfin", u"\u29DC" },
        { u"iiota", u"\u2129" },
        { u"ijlig", u"\u0133" },
        { u"imacr", u"\u012B" },
        { u"image", u"\u2111" },
        { u"imagline", u"\u2110" },
        { u"imagpart", u"\u2111" },
        { u"imath", u"\u0131" },
        { u"imof", u"\u22B7" },
        { u"imped", u"\u01B5" },
        { u"in", u"\u2208" },
        { u"incare", u"\u2105" },
        { u"infin", u"\u221E" },
        { u"infintie", u"\u29DD" },
        { u"inodot", u"\u0131" },
        { u"int", u"\u222B" },
        { u"intcal", u"\u22BA" },
        { u"integers", u"\u2124" },
        { u"intercal", u"\u22BA" },
        { u"intlarhk", u"\u2A17" },
        { u"intprod", u"\u2A3C" },
        { u"iocy", u"\u0451" },
        { u"iogon", u"\u012F" },
        { u"iopf", u"\U0001D55A" },
        { u"iota", u"\u03B9" },
        { u"iprod", u"\u2A3C" },
        { u"iquest", u"\u00BF" },
        { u"iscr", u"\U0001D4BE" },
        { u"isin", u"\u2208" },
        { u"isinE", u"\u22F9" },
        { u"isindot", u"\u22F5" },
        { u"isins", u"\u22F4" },
        { u"isinsv", u"\u22F3" },
        { u"isinv", u"\u2208" },
        { u"it", u"\u2062" },
        { u"itilde", u"\u0129" },
        { u"iukcy", u"\u0456" },
        { u"iuml", u"\u00EF" },
        { u"jcirc", u"\u0135" },
        { u"jcy", u"\u0439" },
        { u"jfr", u"\U0001D527" },
        { u"jmath", u"\u0237" },
        { u"jopf", u"\U0001D55B" },
        { u"jscr", u"\U0001D4BF" },
        { u"jsercy", u"\u0458" },
        { u"jukcy", u"\u0454" },
        { u"kappa", u"\u03BA" },
        { u"kappav", u"\u03F0" },
        { u"kcedil", u"\u0137" },
        { u"kcy", u"\u043A" },
        { u"kfr", u"\U0001D528" },
        { u"kgreen", u"\u0138" },
        { u"khcy", u"\u0445" },
        { u"kjcy", u"\u045C" },
        { u"kopf", u"\U0001D55C" },
        { u"kscr", u"\U0001D4C0" },
        { u"lAarr", u"\u21DA" },
        { u"lArr", u"\u21D0" },
        { u"lAtail", u"\u291B" },
        { u"lBarr", u"\u290E" },
        { u"lE", u"\u2266" },
        { u"lEg", u"\u2A8B" },
        { u"lHar", u"\u2962" },
        { u"lacute", u"\u013A" },
        { u"laemptyv", u"\u29B4" },
        { u"lagran", u"\u2112" },
        { u"lambda", u"\u03BB" },
        { u"lang", u"\u27E8" },
        { u"langd", u"\u2991" },
        { u"langle", u"\u27E8" },
        { u"lap", u"\u2A85" },
        { u"laquo", u"\u00AB" },
        { u"larr", u"\u2190" },
        { u"larrb", u"\u21E4" },
        { u"larrbfs", u"\u291F" },
        { u"larrfs", u"\u291D" },
        { u"larrhk", u"\u21A9" },
        { u"larrlp", u"\u21AB" },
        { u"larrpl", u"\u2939" },
        { u"larrsim", u"\u2973" },
        { u"larrtl", u"\u21A2" },
        { u"lat", u"\u2AAB" },
        { u"latail", u"\u2919" },
        { u"late", u"\u2AAD" },
        { u"lates", u"\u2AAD\uFE00" },
        { u"lbarr", u"\u290C" },
        { u"lbbrk", u"\u2772" },
        { u"lbrace", u"\u007B" },
        { u"lbrack", u"\u005B" },
        { u"lbrke", u"\u298B" },
        { u"lbrksld", u"\u298F" },
        { u"lbrkslu", u"\u298D" },
        { u"lcaron", u"\u013E" },
        { u"lcedil", u"\u013C" },
        { u"lceil", u"\u2308" },
        { u"lcub", u"\u007B" },
        { u"lcy", u"\u043B" },
        { u"ldca", u"\u2936" },
        { u"ldquo", u"\u201C" },
        { u"ldquor", u"\u201E" },
        { u"ldrdhar", u"\u2967" },
        { u"ldrushar", u"\u294B" },
        { u"ldsh", u"\u21B2" },
        { u"le", u"\u2264" },
        { u"leftarrow", u"\u2190" },
        { u"leftarrowtail", u"\u21A2" },
        { u"leftharpoondown", u"\u21BD" },
        { u"leftharpoonup", u"\u21BC" },
        { u"leftleftarrows", u"\u21C7" },
        { u"leftrightarrow", u"\u2194" },
        { u"leftrightarrows", u"\u21C6" },
        { u"leftrightharpoons", u"\u21CB" },
        { u"leftrightsquigarrow", u"\u21AD" },
        { u"leftthreetimes", u"\u22CB" },
        { u"leg", u"\u22DA" },
        { u"leq", u"\u2264" },
        { u"leqq", u"\u2266" },
        { u"leqslant", u"\u2A7D" },
        { u"les", u"\u2A7D" },
        { u"lescc", u"\u2AA8" },
        { u"lesdot", u"\u2A7F" },
        { u"lesdoto", u"\u2A81" },
        { u"lesdotor", u"\u2A83" },
        { u"lesg", u"\u22DA\uFE00" },
        { u"lesges", u"\u2A93" },
        { u"lessapprox", u"\u2A85" },
        { u"lessdot", u"\u22D6" },
        { u"lesseqgtr", u"\u22DA" },
        { u"lesseqqgtr", u"\u2A8B" },
        { u"lessgtr", u"\u2276" },
        { u"lesssim", u"\u2272" },
        { u"lfisht", u"\u297C" },
        { u"lfloor", u"\u230A" },
        { u"lfr", u"\U0001D529" },
        { u"lg", u"\u2276" },
        { u"lgE", u"\u2A91" },
        { u"lhard", u"\u21BD" },
        { u"lharu", u"\u21BC" },
        { u"lharul", u"\u296A" },
        { u"lhblk", u"\u2584" },
        { u"ljcy", u"\u0459" },
        { u"ll", u"\u226A" },
        { u"llarr", u"\u21C7" },
        { u"llcorner", u"\u231E" },
        { u"llhard", u"\u296B" },
        { u"lltri", u"\u25FA" },
        { u"lmidot", u"\u0140" },
        { u"lmoust", u"\u23B0" },
        { u"lmoustache", u"\u23B0" },
        { u"lnE", u"\u2268" },
        { u"lnap", u"\u2A89" },
        { u"lnapprox", u"\u2A89" },
        { u"lne", u"\u2A87" },
        { u"lneq", u"\u2A87" },
        { u"lneqq", u"\u2268" },
        { u"lnsim", u"\u22E6" },
        { u"loang", u"\u27EC" },
        { u"loarr", u"\u21FD" },
        { u"lobrk", u"\u27E6" },
        { u"longleftarrow", u"\u27F5" },
        { u"longleftrightarrow", u"\u27F7" },
        { u"longmapsto", u"\u27FC" },
        { u"longrightarrow", u"\u27F6" },
        { u"looparrowleft", u"\u21AB" },
        { u"looparrowright", u"\u21AC" },
        { u"lopar", u"\u2985" },
        { u"lopf", u"\U0001D55D" },
        { u"loplus", u"\u2A2D" },
        { u"lotimes", u"\u2A34" },
        { u"lowast", u"\u2217" },
        { u"lowbar", u"\u005F" },
        { u"loz", u"\u25CA" },
        { u"lozenge", u"\u25CA" },
        { u"lozf", u"\u29EB" },
        { u"lpar", u"\u0028" },
        { u"lparlt", u"\u2993" },
        { u"lrarr", u"\u21C6" },
        { u"lrcorner", u"\u231F" },
        { u"lrhar", u"\u21CB" },
        { u"lrhard", u"\u296D" },
        { u"lrm", u"\u200E" },
        { u"lrtri", u"\u22BF" },
        { u"lsaquo", u"\u2039" },
        { u"lscr", u"\U0001D4C1" },
        { u"lsh", u"\u21B0" },
        { u"lsim", u"\u2272" },
        { u"lsime", u"\u2A8D" },
        { u"lsimg", u"\u2A8F" },
        { u"lsqb", u"\u005B" },
        { u"lsquo", u"\u2018" },
        { u"lsquor", u"\u201A" },
        { u"lstrok", u"\u0142" },
        { u"lt", u"\u003C" },
        { u"ltcc", u"\u2AA6" },
        { u"ltcir", u"\u2A79" },
        { u"ltdot", u"\u22D6" },
        { u"lthree", u"\u22CB" },
        { u"ltimes", u"\u22C9" },
        { u"ltlarr", u"\u2976" },
        { u"ltquest", u"\u2A7B" },
        { u"ltrPar", u"\u2996" },
        { u"ltri", u"\u25C3" },
        { u"ltrie", u"\u22B4" },
        { u"ltrif", u"\u25C2" },
        { u"lurdshar", u"\u294A" },
        { u"luruhar", u"\u2966" },
        { u"lvertneqq", u"\u2268\uFE00" },
        { u"lvnE", u"\u2268\uFE00" },
        { u"mDDot", u"\u223A" },
        { u"macr", u"\u00AF" },
        { u"male", u"\u2642" },
        { u"malt", u"\u2720" },
        { u"maltese", u"\u2720" },
        { u"map", u"\u21A6" },
        { u"mapsto", u"\u21A6" },
        { u"mapstodown", u"\u21A7" },
        { u"mapstoleft", u"\u21A4" },
        { u"mapstoup", u"\u21A5" },
        { u"marker", u"\u25AE" },
        { u"mcomma", u"\u2A29" },
        { u"mcy", u"\u043C" },
        { u"mdash", u"\u2014" },
        { u"measuredangle", u"\u2221" },
        { u"mfr", u"\U0001D52A" },
        { u"mho", u"\u2127" },
        { u"micro", u"\u00B5" },
        { u"mid", u"\u2223" },
        { u"midast", u"\u002A" },
        { u"midcir", u"\u2AF0" },
        { u"middot", u"\u00B7" },
        { u"minus", u"\u2212" },
        { u"minusb", u"\u229F" },
        { u"minusd", u"\u2238" },
        { u"minusdu", u"\u2A2A" },
        { u"mlcp", u"\u2ADB" },
        { u"mldr", u"\u2026" },
        { u"mnplus", u"\u2213" },
        { u"models", u"\u22A7" },
        { u"mopf", u"\U0001D55E" },
        { u"mp", u"\u2213" },
        { u"mscr", u"\U0001D4C2" },
        { u"mstpos", u"\u223E" },
        { u"mu", u"\u03BC" },
        { u"multimap", u"\u22B8" },
        { u"mumap", u"\u22B8" },
        { u"nGg", u"\u22D9\u0338" },
        { u"nGt", u"\u226B\u20D2" },
        { u"nGtv", u"\u226B\u0338" },
        { u"nLeftarrow", u"\u21CD" },
        { u"nLeftrightarrow", u"\u21CE" },
        { u"nLl", u"\u22D8\u0338" },
        { u"nLt", u"\u226A\u20D2" },
        { u"nLtv", u"\u226A\u0338" },
        { u"nRightarrow", u"\u21CF" },
        { u"nVDash", u"\u22AF" },
        { u"nVdash", u"\u22AE" },
        { u"nabla", u"\u2207" },
        { u"nacute", u"\u0144" },
        { u"nang", u"\u2220\u20D2" },
        { u"nap", u"\u2249" },
        { u"napE", u"\u2A70\u0338" },
        { u"napid", u"\u224B\u0338" },
        { u"napos", u"\u0149" },
        { u"napprox", u"\u2249" },
        { u"natur", u"\u266E" },
        { u"natural", u"\u266E" },
        { u"naturals", u"\u2115" },
        { u"nbsp", u"\u00A0" },
        { u"nbump", u"\u224E\u0338" },
        { u"nbumpe", u"\u224F\u0338" },
        { u"ncap", u"\u2A43" },
        { u"ncaron", u"\u0148" },
        { u"ncedil", u"\u0146" },
        { u"ncong", u"\u2247" },
        { u"ncongdot", u"\u2A6D\u0338" },
        { u"ncup", u"\u2A42" },
        { u"ncy", u"\u043D" },
        { u"ndash", u"\u2013" },
        { u"ne", u"\u2260" },
        { u"neArr", u"\u21D7" },
        { u"nearhk", u"\u2924" },
        { u"nearr", u"\u2197" },
        { u"nearrow", u"\u2197" },
        { u"nedot", u"\u2250\u0338" },
        { u"nequiv", u"\u2262" },
        { u"nesear", u"\u2928" },
        { u"nesim", u"\u2242\u0338" },
        { u"nexist", u"\u2204" },
        { u"nexists", u"\u2204" },
        { u"nfr", u"\U0001D52B" },
        { u"ngE", u"\u2267\u0338" },
        { u"nge", u"\u2271" },
        { u"ngeq", u"\u2271" },
        { u"ngeqq", u"\u2267\u0338" },
        { u"ngeqslant", u"\u2A7E\u0338" },
        { u"nges", u"\u2A7E\u0338" },
        { u"ngsim", u"\u2275" },
        { u"ngt", u"\u226F" },
        { u"ngtr", u"\u226F" },
        { u"nhArr", u"\u21CE" },
        { u"nharr", u"\u21AE" },
        { u"nhpar", u"\u2AF2" },
        { u"ni", u"\u220B" },
        { u"nis", u"\u22FC" },
        { u"nisd", u"\u22FA" },
        { u"niv", u"\u220B" },
        { u"njcy", u"\u045A" },
        { u"nlArr", u"\u21CD" },
        { u"nlE", u"\u2266\u0338" },
        { u"nlarr", u"\u219A" },
        { u"nldr", u"\u2025" },
        { u"nle", u"\u2270" },
        { u"nleftarrow", u"\u219A" },
        { u"nleftrightarrow", u"\u21AE" },
        { u"nleq", u"\u2270" },
        { u"nleqq", u"\u2266\u0338" },
        { u"nleqslant", u"\u2A7D\u0338" },
        { u"nles", u"\u2A7D\u0338" },
        { u"nless", u"\u226E" },
        { u"nlsim", u"\u2274" },
        { u"nlt", u"\u226E" },
        { u"nltri", u"\u22EA" },
        { u"nltrie", u"\u22EC" },
        { u"nmid", u"\u2224" },
        { u"nopf", u"\U0001D55F" },
        { u"not", u"\u00AC" },
        { u"notin", u"\u2209" },
        { u"notinE", u"\u22F9\u0338" },
        { u"notindot", u"\u22F5\u0338" },
        { u"notinva", u"\u2209" },
        { u"notinvb", u"\u22F7" },
        { u"notinvc", u"\u22F6" },
        { u"notni", u"\u220C" },
        { u"notniva", u"\u220C" },
        { u"notnivb", u"\u22FE" },
        { u"notnivc", u"\u22FD" },
        { u"npar", u"\u2226" },
        { u"nparallel", u"\u2226" },
        { u"nparsl", u"\u2AFD\u20E5" },
        { u"npart", u"\u2202\u0338" },
        { u"npolint", u"\u2A14" },
        { u"npr", u"\u2280" },
        { u"nprcue", u"\u22E0" },
        { u"npre", u"\u2AAF\u0338" },
        { u"nprec", u"\u2280" },
        { u"npreceq", u"\u2AAF\u0338" },
        { u"nrArr", u"\u21CF" },
        { u"nrarr", u"\u219B" },
        { u"nrarrc", u"\u2933\u0338" },
        { u"nrarrw", u"\u219D\u0338" },
        { u"nrightarrow", u"\u219B" },
        { u"nrtri", u"\u22EB" },
        { u"nrtrie", u"\u22ED" },
        { u"nsc", u"\u2281" },
        { u"nsccue", u"\u22E1" },
        { u"nsce", u"\u2AB0\u0338" },
        { u"nscr", u"\U0001D4C3" },
        { u"nshortmid", u"\u2224" },
        { u"nshortparallel", u"\u2226" },
        { u"nsim", u"\u2241" },
        { u"nsime", u"\u2244" },
        { u"nsimeq", u"\u2244" },
        { u"nsmid", u"\u2224" },
        { u"nspar", u"\u2226" },
        { u"nsqsube", u"\u22E2" },
        { u"nsqsupe", u"\u22E3" },
        { u"nsub", u"\u2284" },
        { u"nsubE", u"\u2AC5\u0338" },
        { u"nsube", u"\u2288" },
        { u"nsubset", u"\u2282\u20D2" },
        { u"nsubseteq", u"\u2288" },
        { u"nsubseteqq", u"\u2AC5\u0338" },
        { u"nsucc", u"\u2281" },
        { u"nsucceq", u"\u2AB0\u0338" },
        { u"nsup", u"\u2285" },
        { u"nsupE", u"\u2AC6\u0338" },
        { u"nsupe", u"\u2289" },
        { u"nsupset", u"\u2283\u20D2" },
        { u"nsupseteq", u"\u2289" },
        { u"nsupseteqq", u"\u2AC6\u0338" },
        { u"ntgl", u"\u2279" },
        { u"ntilde", u"\u00F1" },
        { u"ntlg", u"\u2278" },
        { u"ntriangleleft", u"\u22EA" },
        { u"ntrianglelefteq", u"\u22EC" },
        { u"ntriangleright", u"\u22EB" },
        { u"ntrianglerighteq", u"\u22ED" },
        { u"nu", u"\u03BD" },
        { u"num", u"\u0023" },
        { u"numero", u"\u2116" },
        { u"numsp", u"\u2007" },
        { u"nvDash", u"\u22AD" },
        { u"nvHarr", u"\u2904" },
        { u"nvap", u"\u224D\u20D2" },
        { u"nvdash", u"\u22AC" },
        { u"nvge", u"\u2265\u20D2" },
        { u"nvgt", u"\u003E\u20D2" },
        { u"nvinfin", u"\u29DE" },
        { u"nvlArr", u"\u2902" },
        { u"nvle", u"\u2264\u20D2" },
        { u"nvlt", u"\u003C\u20D2" },
        { u"nvltrie", u"\u22B4\u20D2" },
        { u"nvrArr", u"\u2903" },
        { u"nvrtrie", u"\u22B5\u20D2" },
        { u"nvsim", u"\u223C\u20D2" },
        { u"nwArr", u"\u21D6" },
        { u"nwarhk", u"\u2923" },
        { u"nwarr", u"\u2196" },
        { u"nwarrow", u"\u2196" },
        { u"nwnear", u"\u2927" },
        { u"oS", u"\u24C8" },
        { u"oacute", u"\u00F3" },
        { u"oast", u"\u229B" },
        { u"ocir", u"\u229A" },
        { u"ocirc", u"\u00F4" },
        { u"ocy", u"\u043E" },
        { u"odash", u"\u229D" },
        { u"odblac", u"\u0151" },
        { u"odiv", u"\u2A38" },
        { u"odot", u"\u2299" },
        { u"odsold", u"\u29BC" },
        { u"oelig", u"\u0153" },
        { u"ofcir", u"\u29BF" },
        { u"ofr", u"\U0001D52C" },
        { u"ogon", u"\u02DB" },
        { u"ograve", u"\u00F2" },
        { u"ogt", u"\u29C1" },
        { u"ohbar", u"\u29B5" },
        { u"ohm", u"\u03A9" },
        { u"oint", u"\u222E" },
        { u"olarr", u"\u21BA" },
        { u"olcir", u"\u29BE" },
        { u"olcross", u"\u29BB" },
        { u"oline", u"\u203E" },
        { u"olt", u"\u29C0" },
        { u"omacr", u"\u014D" },
        { u"omega", u"\u03C9" },
        { u"omicron", u"\u03BF" },
        { u"omid", u"\u29B6" },
        { u"ominus", u"\u2296" },
        { u"oopf", u"\U0001D560" },
        { u"opar", u"\u29B7" },
        { u"operp", u"\u29B9" },
        { u"oplus", u"\u2295" },
        { u"or", u"\u2228" },
        { u"orarr", u"\u21BB" },
        { u"ord", u"\u2A5D" },
        { u"order", u"\u2134" },
        { u"orderof", u"\u2134" },
        { u"ordf", u"\u00AA" },
        { u"ordm", u"\u00BA" },
        { u"origof", u"\u22B6" },
        { u"oror", u"\u2A56" },
        { u"orslope", u"\u2A57" },
        { u"orv", u"\u2A5B" },
        { u"oscr", u"\u2134" },
        { u"oslash", u"\u00F8" },
        { u"osol", u"\u2298" },
        { u"otilde", u"\u00F5" },
        { u"otimes", u"\u2297" },
        { u"otimesas", u"\u2A36" },
        { u"ouml", u"\u00F6" },
        { u"ovbar", u"\u233D" },
        { u"par", u"\u2225" },
        { u"para", u"\u00B6" },
        { u"parallel", u"\u2225" },
        { u"parsim", u"\u2AF3" },
        { u"parsl", u"\u2AFD" },
        { u"part", u"\u2202" },
        { u"pcy", u"\u043F" },
        { u"percnt", u"\u0025" },
        { u"period", u"\u002E" },
        { u"permil", u"\u2030" },
        { u"perp", u"\u22A5" },
        { u"pertenk", u"\u2031" },
        { u"pfr", u"\U0001D52D" },
        { u"phi", u"\u03C6" },
        { u"phiv", u"\u03D5" },
        { u"phmmat", u"\u2133" },
        { u"phone", u"\u260E" },
        { u"pi", u"\u03C0" },
        { u"pitchfork", u"\u22D4" },
        { u"piv", u"\u03D6" },
        { u"planck", u"\u210F" },
        { u"planckh", u"\u210E" },
        { u"plankv", u"\u210F" },
        { u"plus", u"\u002B" },
        { u"plusacir", u"\u2A23" },
        { u"plusb", u"\u229E" },
        { u"pluscir", u"\u2A22" },
        { u"plusdo", u"\u2214" },
        { u"plusdu", u"\u2A25" },
        { u"pluse", u"\u2A72" },
        { u"plusmn", u"\u00B1" },
        { u"plussim", u"\u2A26" },
        { u"plustwo", u"\u2A27" },
        { u"pm", u"\u00B1" },
        { u"pointint", u"\u2A15" },
        { u"popf", u"\U0001D561" },
        { u"pound", u"\u00A3" },
        { u"pr", u"\u227A" },
        { u"prE", u"\u2AB3" },
        { u"prap", u"\u2AB7" },
        { u"prcue", u"\u227C" },
        { u"pre", u"\u2AAF" },
        { u"prec", u"\u227A" },
        { u"precapprox", u"\u2AB7" },
        { u"preccurlyeq", u"\u227C" },
        { u"preceq", u"\u2AAF" },
        { u"precnapprox", u"\u2AB9" },
        { u"precneqq", u"\u2AB5" },
        { u"precnsim", u"\u22E8" },
        { u"precsim", u"\u227E" },
        { u"prime", u"\u2032" },
        { u"primes", u"\u2119" },
        { u"prnE", u"\u2AB5" },
        { u"prnap", u"\u2AB9" },
        { u"prnsim", u"\u22E8" },
        { u"prod", u"\u220F" },
        { u"profalar", u"\u232E" },
        { u"profline", u"\u2312" },
        { u"profsurf", u"\u2313" },
        { u"prop", u"\u221D" },
        { u"propto", u"\u221D" },
        { u"prsim", u"\u227E" },
        { u"prurel", u"\u22B0" },
        { u"pscr", u"\U0001D4C5" },
        { u"psi", u"\u03C8" },
        { u"puncsp", u"\u2008" },
        { u"qfr", u"\U0001D52E" },
        { u"qint", u"\u2A0C" },
        { u"qopf", u"\U0001D562" },
        { u"qprime", u"\u2057" },
        { u"qscr", u"\U0001D4C6" },
        { u"quaternions", u"\u210D" },
        { u"quatint", u"\u2A16" },
        { u"quest", u"\u003F" },
        { u"questeq", u"\u225F" },
        { u"quot", u"\u0022" },
        { u"rAarr", u"\u21DB" },
        { u"rArr", u"\u21D2" },
        { u"rAtail", u"\u291C" },
        { u"rBarr", u"\u290F" },
        { u"rHar", u"\u2964" },
        { u"race", u"\u223D\u0331" },
        { u"racute", u"\u0155" },
        { u"radic", u"\u221A" },
        { u"raemptyv", u"\u29B3" },
        { u"rang", u"\u27E9" },
        { u"rangd", u"\u2992" },
        { u"range", u"\u29A5" },
        { u"rangle", u"\u27E9" },
        { u"raquo", u"\u00BB" },
        { u"rarr", u"\u2192" },
        { u"rarrap", u"\u2975" },
        { u"rarrb", u"\u21E5" },
        { u"rarrbfs", u"\u2920" },
        { u"rarrc", u"\u2933" },
        { u"rarrfs", u"\u291E" },
        { u"rarrhk", u"\u21AA" },
        { u"rarrlp", u"\u21AC" },
        { u"rarrpl", u"\u2945" },
        { u"rarrsim", u"\u2974" },
        { u"rarrtl", u"\u21A3" },
        { u"rarrw", u"\u219D" },
        { u"ratail", u"\u291A" },
        { u"ratio", u"\u2236" },
        { u"rationals", u"\u211A" },
        { u"rbarr", u"\u290D" },
        { u"rbbrk", u"\u2773" },
        { u"rbrace", u"\u007D" },
        { u"rbrack", u"\u005D" },
        { u"rbrke", u"\u298C" },
        { u"rbrksld", u"\u298E" },
        { u"rbrkslu", u"\u2990" },
        { u"rcaron", u"\u0159" },
        { u"rcedil", u"\u0157" },
        { u"rceil", u"\u2309" },
        { u"rcub", u"\u007D" },
        { u"rcy", u"\u0440" },
        { u"rdca", u"\u2937" },
        { u"rdldhar", u"\u2969" },
        { u"rdquo", u"\u201D" },
        { u"rdquor", u"\u201D" },
        { u"rdsh", u"\u21B3" },
        { u"real", u"\u211C" },
        { u"realine", u"\u211B" },
        { u"realpart", u"\u211C" },
        { u"reals", u"\u211D" },
        { u"rect", u"\u25AD" },
        { u"reg", u"\u00AE" },
        { u"rfisht", u"\u297D" },
        { u"rfloor", u"\u230B" },
        { u"rfr", u"\U0001D52F" },
        { u"rhard", u"\u21C1" },
        { u"rharu", u"\u21C0" },
        { u"rharul", u"\u296C" },
        { u"rho", u"\u03C1" },
        { u"rhov", u"\u03F1" },
        { u"rightarrow", u"\u2192" },
        { u"rightarrowtail", u"\u21A3" },
        { u"rightharpoondown", u"\u21C1" },
        { u"rightharpoonup", u"\u21C0" },
        { u"rightleftarrows", u"\u21C4" },
        { u"rightleftharpoons", u"\u21CC" },
        { u"rightrightarrows", u"\u21C9" },
        { u"rightsquigarrow", u"\u219D" },
        { u"rightthreetimes", u"\u22CC" },
        { u"ring", u"\u02DA" },
        { u"risingdotseq", u"\u2253" },
        { u"rlarr", u"\u21C4" },
        { u"rlhar", u"\u21CC" },
        { u"rlm", u"\u200F" },
        { u"rmoust", u"\u23B1" },
        { u"rmoustache", u"\u23B1" },
        { u"rnmid", u"\u2AEE" },
        { u"roang", u"\u27ED" },
        { u"roarr", u"\u21FE" },
        { u"robrk", u"\u27E7" },
        { u"ropar", u"\u2986" },
        { u"ropf", u"\U0001D563" },
        { u"roplus", u"\u2A2E" },
        { u"rotimes", u"\u2A35" },
        { u"rpar", u"\u0029" },
        { u"rpargt", u"\u2994" },
        { u"rppolint", u"\u2A12" },
        { u"rrarr", u"\u21C9" },
        { u"rsaquo", u"\u203A" },
        { u"rscr", u"\U0001D4C7" },
        { u"rsh", u"\u21B1" },
        { u"rsqb", u"\u005D" },
        { u"rsquo", u"\u2019" },
        { u"rsquor", u"\u2019" },
        { u"rthree", u"\u22CC" },
        { u"rtimes", u"\u22CA" },
        { u"rtri", u"\u25B9" },
        { u"rtrie", u"\u22B5" },
        { u"rtrif", u"\u25B8" },
        { u"rtriltri", u"\u29CE" },
        { u"ruluhar", u"\u2968" },
        { u"rx", u"\u211E" },
        { u"sacute", u"\u015B" },
        { u"sbquo", u"\u201A" },
        { u"sc", u"\u227B" },
        { u"scE", u"\u2AB4" },
        { u"scap", u"\u2AB8" },
        { u"scaron", u"\u0161" },
        { u"sccue", u"\u227D" },
        { u"sce", u"\u2AB0" },
        { u"scedil", u"\u015F" },
        { u"scirc", u"\u015D" },
        { u"scnE", u"\u2AB6" },
        { u"scnap", u"\u2ABA" },
        { u"scnsim", u"\u22E9" },
        { u"scpolint", u"\u2A13" },
        { u"scsim", u"\u227F" },
        { u"scy", u"\u0441" },
        { u"sdot", u"\u22C5" },
        { u"sdotb", u"\u22A1" },
        { u"sdote", u"\u2A66" },
        { u"seArr", u"\u21D8" },
        { u"searhk", u"\u2925" },
        { u"searr", u"\u2198" },
        { u"searrow", u"\u2198" },
        { u"sect", u"\u00A7" },
        { u"semi", u"\u003B" },
        { u"seswar", u"\u2929" },
        { u"setminus", u"\u2216" },
        { u"setmn", u"\u2216" },
        { u"sext", u"\u2736" },
        { u"sfr", u"\U0001D530" },
        { u"sfrown", u"\u2322" },
        { u"sharp", u"\u266F" },
        { u"shchcy", u"\u0449" },
        { u"shcy", u"\u0448" },
        { u"shortmid", u"\u2223" },
        { u"shortparallel", u"\u2225" },
        { u"shy", u"\u00AD" },
        { u"sigma", u"\u03C3" },
        { u"sigmaf", u"\u03C2" },
        { u"sigmav", u"\u03C2" },
        { u"sim", u"\u223C" },
        { u"simdot", u"\u2A6A" },
        { u"sime", u"\u2243" },
        { u"simeq", u"\u2243" },
        { u"simg", u"\u2A9E" },
        { u"simgE", u"\u2AA0" },
        { u"siml", u"\u2A9D" },
        { u"simlE", u"\u2A9F" },
        { u"simne", u"\u2246" },
        { u"simplus", u"\u2A24" },
        { u"simrarr", u"\u2972" },
        { u"slarr", u"\u2190" },
        { u"smallsetminus", u"\u2216" },
        { u"smashp", u"\u2A33" },
        { u"smeparsl", u"\u29E4" },
        { u"smid", u"\u2223" },
        { u"smile", u"\u2323" },
        { u"smt", u"\u2AAA" },
        { u"smte", u"\u2AAC" },
        { u"smtes", u"\u2AAC\uFE00" },
        { u"softcy", u"\u044C" },
        { u"sol", u"\u002F" },
        { u"solb", u"\u29C4" },
        { u"solbar", u"\u233F" },
        { u"sopf", u"\U0001D564" },
        { u"spades", u"\u2660" },
        { u"spadesuit", u"\u2660" },
        { u"spar", u"\u2225" },
        { u"sqcap", u"\u2293" },
        { u"sqcaps", u"\u2293\uFE00" },
        { u"sqcup", u"\u2294" },
        { u"sqcups", u"\u2294\uFE00" },
        { u"sqsub", u"\u228F" },
        { u"sqsube", u"\u2291" },
        { u"sqsubset", u"\u228F" },
        { u"sqsubseteq", u"\u2291" },
        { u"sqsup", u"\u2290" },
        { u"sqsupe", u"\u2292" },
        { u"sqsupset", u"\u2290" },
        { u"sqsupseteq", u"\u2292" },
        { u"squ", u"\u25A1" },
        { u"square", u"\u25A1" },
        { u"squarf", u"\u25AA" },
        { u"squf", u"\u25AA" },
        { u"srarr", u"\u2192" },
        { u"sscr", u"\U0001D4C8" },
        { u"ssetmn", u"\u2216" },
        { u"ssmile", u"\u2323" },
        { u"sstarf", u"\u22C6" },
        { u"star", u"\u2606" },
        { u"starf", u"\u2605" },
        { u"straightepsilon", u"\u03F5" },
        { u"straightphi", u"\u03D5" },
        { u"strns", u"\u00AF" },
        { u"sub", u"\u2282" },
        { u"subE", u"\u2AC5" },
        { u"subdot", u"\u2ABD" },
        { u"sube", u"\u2286" },
        { u"subedot", u"\u2AC3" },
        { u"submult", u"\u2AC1" },
        { u"subnE", u"\u2ACB" },
        { u"subne", u"\u228A" },
        { u"subplus", u"\u2ABF" },
        { u"subrarr", u"\u2979" },
        { u"subset", u"\u2282" },
        { u"subseteq", u"\u2286" },
        { u"subseteqq", u"\u2AC5" },
        { u"subsetneq", u"\u228A" },
        { u"subsetneqq", u"\u2ACB" },
        { u"subsim", u"\u2AC7" },
        { u"subsub", u"\u2AD5" },
        { u"subsup", u"\u2AD3" },
        { u"succ", u"\u227B" },
        { u"succapprox", u"\u2AB8" },
        { u"succcurlyeq", u"\u227D" },
        { u"succeq", u"\u2AB0" },
        { u"succnapprox", u"\u2ABA" },
        { u"succneqq", u"\u2AB6" },
        { u"succnsim", u"\u22E9" },
        { u"succsim", u"\u227F" },
        { u"sum", u"\u2211" },
        { u"sung", u"\u266A" },
        { u"sup", u"\u2283" },
        { u"sup1", u"\u00B9" },
        { u"sup2", u"\u00B2" },
        { u"sup3", u"\u00B3" },
        { u"supE", u"\u2AC6" },
        { u"supdot", u"\u2ABE" },
        { u"supdsub", u"\u2AD8" },
        { u"supe", u"\u2287" },
        { u"supedot", u"\u2AC4" },
        { u"suphsol", u"\u27C9" },
        { u"suphsub", u"\u2AD7" },
        { u"suplarr", u"\u297B" },
        { u"supmult", u"\u2AC2" },
        { u"supnE", u"\u2ACC" },
        { u"supne", u"\u228B" },
        { u"supplus", u"\u2AC0" },
        { u"supset", u"\u2283" },
        { u"supseteq", u"\u2287" },
        { u"supseteqq", u"\u2AC6" },
        { u"supsetneq", u"\u228B" },
        { u"supsetneqq", u"\u2ACC" },
        { u"supsim", u"\u2AC8" },
        { u"supsub", u"\u2AD4" },
        { u"supsup", u"\u2AD6" },
        { u"swArr", u"\u21D9" },
        { u"swarhk", u"\u2926" },
        { u"swarr", u"\u2199" },
        { u"swarrow", u"\u2199" },
        { u"swnwar", u"\u292A" },
        { u"szlig", u"\u00DF" },
        { u"target", u"\u2316" },
        { u"tau", u"\u03C4" },
        { u"tbrk", u"\u23B4" },
        { u"tcaron", u"\u0165" },
        { u"tcedil", u"\u0163" },
        { u"tcy", u"\u0442" },
        { u"tdot", u"\u20DB" },
        { u"telrec", u"\u2315" },
        { u"tfr", u"\U0001D531" },
        { u"there4", u"\u2234" },
        { u"therefore", u"\u2234" },
        { u"theta", u"\u03B8" },
        { u"thetasym", u"\u03D1" },
        { u"thetav", u"\u03D1" },
        { u"thickapprox", u"\u2248" },
        { u"thicksim", u"\u223C" },
        { u"thinsp", u"\u2009" },
        { u"thkap", u"\u2248" },
        { u"thksim", u"\u223C" },
        { u"thorn", u"\u00FE" },
        { u"tilde", u"\u02DC" },
        { u"times", u"\u00D7" },
        { u"timesb", u"\u22A0" },
        { u"timesbar", u"\u2A31" },
        { u"timesd", u"\u2A30" },
        { u"tint", u"\u222D" },
        { u"toea", u"\u2928" },
        { u"top", u"\u22A4" },
        { u"topbot", u"\u2336" },
        { u"topcir", u"\u2AF1" },
        { u"topf", u"\U0001D565" },
        { u"topfork", u"\u2ADA" },
        { u"tosa", u"\u2929" },
        { u"tprime", u"\u2034" },
        { u"trade", u"\u2122" },
        { u"triangle", u"\u25B5" },
        { u"triangledown", u"\u25BF" },
        { u"triangleleft", u"\u25C3" },
        { u"trianglelefteq", u"\u22B4" },
        { u"triangleq", u"\u225C" },
        { u"triangleright", u"\u25B9" },
        { u"trianglerighteq", u"\u22B5" },
        { u"tridot", u"\u25EC" },
        { u"trie", u"\u225C" },
        { u"triminus", u"\u2A3A" },
        { u"triplus", u"\u2A39" },
        { u"trisb", u"\u29CD" },
        { u"tritime", u"\u2A3B" },
        { u"trpezium", u"\u23E2" },
        { u"tscr", u"\U0001D4C9" },
        { u"tscy", u"\u0446" },
        { u"tshcy", u"\u045B" },
        { u"tstrok", u"\u0167" },
        { u"twixt", u"\u226C" },
        { u"twoheadleftarrow", u"\u219E" },
        { u"twoheadrightarrow", u"\u21A0" },
        { u"uArr", u"\u21D1" },
        { u"uHar", u"\u2963" },
        { u"uacute", u"\u00FA" },
        { u"uarr", u"\u2191" },
        { u"ubrcy", u"\u045E" },
        { u"ubreve", u"\u016D" },
        { u"ucirc", u"\u00FB" },
        { u"ucy", u"\u0443" },
        { u"udarr", u"\u21C5" },
        { u"udblac", u"\u0171" },
        { u"udhar", u"\u296E" },
        { u"ufisht", u"\u297E" },
        { u"ufr", u"\U0001D532" },
        { u"ugrave", u"\u00F9" },
        { u"uharl", u"\u21BF" },
        { u"uharr", u"\u21BE" },
        { u"uhblk", u"\u2580" },
        { u"ulcorn", u"\u231C" },
        { u"ulcorner", u"\u231C" },
        { u"ulcrop", u"\u230F" },
        { u"ultri", u"\u25F8" },
        { u"umacr", u"\u016B" },
        { u"uml", u"\u00A8" },
        { u"uogon", u"\u0173" },
        { u"uopf", u"\U0001D566" },
        { u"uparrow", u"\u2191" },
        { u"updownarrow", u"\u2195" },
        { u"upharpoonleft", u"\u21BF" },
        { u"upharpoonright", u"\u21BE" },
        { u"uplus", u"\u228E" },
        { u"upsi", u"\u03C5" },
        { u"upsih", u"\u03D2" },
        { u"upsilon", u"\u03C5" },
        { u"upuparrows", u"\u21C8" },
        { u"urcorn", u"\u231D" },
        { u"urcorner", u"\u231D" },
        { u"urcrop", u"\u230E" },
        { u"uring", u"\u016F" },
        { u"urtri", u"\u25F9" },
        { u"uscr", u"\U0001D4CA" },
        { u"utdot", u"\u22F0" },
        { u"utilde", u"\u0169" },
        { u"utri", u"\u25B5" },
        { u"utrif", u"\u25B4" },
        { u"uuarr", u"\u21C8" },
        { u"uuml", u"\u00FC" },
        { u"uwangle", u"\u29A7" },
        { u"vArr", u"\u21D5" },
        { u"vBar", u"\u2AE8" },
        { u"vBarv", u"\u2AE9" },
        { u"vDash", u"\u22A8" },
        { u"vangrt", u"\u299C" },
        { u"varepsilon", u"\u03F5" },
        { u"varkappa", u"\u03F0" },
        { u"varnothing", u"\u2205" },
        { u"varphi", u"\u03D5" },
        { u"varpi", u"\u03D6" },
        { u"varpropto", u"\u221D" },
        { u"varr", u"\u2195" },
        { u"varrho", u"\u03F1" },
        { u"varsigma", u"\u03C2" },
        { u"varsubsetneq", u"\u228A\uFE00" },
        { u"varsubsetneqq", u"\u2ACB\uFE00" },
        { u"varsupsetneq", u"\u228B\uFE00" },
        { u"varsupsetneqq", u"\u2ACC\uFE00" },
        { u"vartheta", u"\u03D1" },
        { u"vartriangleleft", u"\u22B2" },
        { u"vartriangleright", u"\u22B3" },
        { u"vcy", u"\u0432" },
        { u"vdash", u"\u22A2" },
        { u"vee", u"\u2228" },
        { u"veebar", u"\u22BB" },
        { u"veeeq", u"\u225A" },
        { u"vellip", u"\u22EE" },
        { u"verbar", u"\u007C" },
        { u"vert", u"\u007C" },
        { u"vfr", u"\U0001D533" },
        { u"vltri", u"\u22B2" },
        { u"vnsub", u"\u2282\u20D2" },
        { u"vnsup", u"\u2283\u20D2" },
        { u"vopf", u"\U0001D567" },
        { u"vprop", u"\u221D" },
        { u"vrtri", u"\u22B3" },
        { u"vscr", u"\U0001D4CB" },
        { u"vsubnE", u"\u2ACB\uFE00" },
        { u"vsubne", u"\u228A\uFE00" },
        { u"vsupnE", u"\u2ACC\uFE00" },
        { u"vsupne", u"\u228B\uFE00" },
        { u"vzigzag", u"\u299A" },
        { u"wcirc", u"\u0175" },
        { u"wedbar", u"\u2A5F" },
        { u"wedge", u"\u2227" },
        { u"wedgeq", u"\u2259" },
        { u"weierp", u"\u2118" },
        { u"wfr", u"\U0001D534" },
        { u"wopf", u"\U0001D568" },
        { u"wp", u"\u2118" },
        { u"wr", u"\u2240" },
        { u"wreath", u"\u2240" },
        { u"wscr", u"\U0001D4CC" },
        { u"xcap", u"\u22C2" },
        { u"xcirc", u"\u25EF" },
        { u"xcup", u"\u22C3" },
        { u"xdtri", u"\u25BD" },
        { u"xfr", u"\U0001D535" },
        { u"xhArr", u"\u27FA" },
        { u"xharr", u"\u27F7" },
        { u"xi", u"\u03BE" },
        { u"xlArr", u"\u27F8" },
        { u"xlarr", u"\u27F5" },
        { u"xmap", u"\u27FC" },
        { u"xnis", u"\u22FB" },
        { u"xodot", u"\u2A00" },
        { u"xopf", u"\U0001D569" },
        { u"xoplus", u"\u2A01" },
        { u"xotime", u"\u2A02" },
        { u"xrArr", u"\u27F9" },
        { u"xrarr", u"\u27F6" },
        { u"xscr", u"\U0001D4CD" },
        { u"xsqcup", u"\u2A06" },
        { u"xuplus", u"\u2A04" },
        { u"xutri", u"\u25B3" },
        { u"xvee", u"\u22C1" },
        { u"xwedge", u"\u22C0" },
        { u"yacute", u"\u00FD" },
        { u"yacy", u"\u044F" },
        { u"ycirc", u"\u0177" },
        { u"ycy", u"\u044B" },
        { u"yen", u"\u00A5" },
        { u"yfr", u"\U0001D536" },
        { u"yicy", u"\u0457" },
        { u"yopf", u"\U0001D56A" },
        { u"yscr", u"\U0001D4CE" },
        { u"yucy", u"\u044E" },
        { u"yuml", u"\u00FF" },
        { u"zacute", u"\u017A" },
        { u"zcaron", u"\u017E" },
        { u"zcy", u"\u0437" },
        { u"zdot", u"\u017C" },
        { u"zeetrf", u"\u2128" },
        { u"zeta", u"\u03B6" },
        { u"zfr", u"\U0001D537" },
        { u"zhcy", u"\u0436" },
        { u"zigrarr", u"\u21DD" },
        { u"zopf", u"\U0001D56B" },
        { u"zscr", u"\U0001D4CF" },
        { u"zwj", u"\u200D" },
        { u"zwnj", u"\u200C" }
        // clang-format on
    };

const ::css::uno::Sequence<::css::beans::Pair<OUString, OUString>>
    starmathdatabase::icustomMathmlHtmlEntities(
        icustomMathmlHtmlEntitiesData, starmathdatabase::STARMATH_MATHMLHTML_ENTITY_NUMBER);

static ::css::beans::Pair<::rtl::OUString, ::rtl::OUString>
    icustomMathmlHtmlEntitiesNamesExportData[2] = {
        // clang-format off
        { u"&sigma;", u"\u03C3"},
        { u"&infin;", u"\u221E"}
        // clang-format on
    };
const ::css::uno::Sequence<::css::beans::Pair<::rtl::OUString, ::rtl::OUString>>
    starmathdatabase::icustomMathmlHtmlEntitiesExport(icustomMathmlHtmlEntitiesNamesExportData, 2);

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
