use alloc::collections::VecDeque;

use super::Buf;

impl Buf for VecDeque<u8> {
    fn remaining(&self) -> usize {
        self.len()
    }

    fn bytes(&self) -> &[u8] {
        let (s1, s2) = self.as_slices();
        if s1.is_empty() {
            s2
        } else {
            s1
        }
    }

    fn advance(&mut self, cnt: usize) {
        self.drain(..cnt);
    }
}
