[![Test](https://github.com/rabbitmq/rabbitmq-server/actions/workflows/test.yaml/badge.svg)](https://github.com/rabbitmq/rabbitmq-server/actions/workflows/test.yaml)

# RabbitMQ Server

[RabbitMQ](https://rabbitmq.com) is a [feature rich](https://rabbitmq.com/documentation.html),
multi-protocol messaging and streaming broker. It supports:

 * AMQP 0-9-1
 * AMQP 1.0
 * [RabbitMQ Stream Protocol](https://rabbitmq.com/streams.html)
 * MQTT 3.1.1
 * STOMP 1.0 through 1.2


## Installation

 * [Installation guides](https://rabbitmq.com/download.html) for various platforms
 * [Kubernetes Cluster Operator](https://rabbitmq.com/kubernetes/operator/operator-overview.html)
 * [Changelog](https://www.rabbitmq.com/changelog.html)
 * [Releases](https://github.com/rabbitmq/rabbitmq-server/releases) on GitHub
 * [Currently supported released series](https://www.rabbitmq.com/versions.html)
 * [Supported Erlang versions](https://www.rabbitmq.com/which-erlang.html)


## Tutorials and Documentation

 * [RabbitMQ tutorials](https://rabbitmq.com/getstarted.html)
 * [All documentation guides](https://rabbitmq.com/documentation.html)
 * [RabbitMQ blog](https://blog.rabbitmq.com/)

Some key doc guides include

 * [CLI tools guide](https://rabbitmq.com/cli.html) 
 * [Clustering](https://www.rabbitmq.com/clustering.html) and [Cluster Formation](https://www.rabbitmq.com/cluster-formation.html) guides
 * [Configuration guide](https://rabbitmq.com/configure.html) 
 * [Client libraries and tools](https://rabbitmq.com/devtools.html)
 * [Monitoring](https://rabbitmq.com/monitoring.html) and [Prometheus/Grafana](https://www.rabbitmq.com/prometheus.html) guides
 * [Kubernetes Cluster Operator](https://rabbitmq.com/kubernetes/operator/operator-overview.html)
 * [Production checklist](https://rabbitmq.com/production-checklist.html)
 * [Quorum queues](https://rabbitmq.com/quorum-queues.html): a replicated, data safety- and consistency-oriented queue type
 * [Streams](https://rabbitmq.com/streams.html): a persistent and replicated append-only log with non-destructive consumer semantics
 * [Runnable tutorials](https://github.com/rabbitmq/rabbitmq-tutorials/)

RabbitMQ documentation is also [developed on GitHub](https://github.com/rabbitmq/rabbitmq-website/).

## Commercial Features and Support

 * [Commercial edition of RabbitMQ](https://www.vmware.com/products/rabbitmq.html)
 * [Commercial edition for Kubernetes](https://rabbitmq.com/kubernetes/tanzu/installation.html)
 * [Commercial support](https://rabbitmq.com/services.html) from [VMware](https://vmware.com) for open source RabbitMQ

## Getting Help from the Community

 * [Community Discord server](https://rabbitmq.com/discord/)
 * [Community Slack](https://rabbitmq.com/slack/)
 * [GitHub Discussions](https://github.com/rabbitmq/rabbitmq-server/discussions/)
 * [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
 * `#rabbitmq` on [Libera Chat](https://libera.chat/)


## Contributing

See [CONTRIBUTING.md](./CONTRIBUTING.md) and our [development process overview](https://rabbitmq.com/github.html).

Questions about contributing, internals and so on are very welcome on the [mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Licensing

RabbitMQ server is [licensed under the MPL 2.0](LICENSE-MPL-RabbitMQ).


## Building From Source and Packaging

 * [Contributor resources](https://github.com/rabbitmq/contribute)
 * [Building RabbitMQ from Source](https://rabbitmq.com/build-server.html)
 * [Building RabbitMQ Distribution Packages](https://rabbitmq.com/build-server.html)


## Copyright

(c) 2007-2023 VMware, Inc. or its affiliates.
