// Code generated by re2c, DO NOT EDIT.
//go:generate re2go $INPUT -o $OUTPUT --input-encoding utf8 --loop-switch -i

// This example supports multiple input encodings: UTF-8 and UTF-32.
// Both lexers are generated from the same rules block, and the use
// blocks add only encoding-specific configurations.

package main

import "testing"



func lexUTF8(str []uint8) int {
	var cursor, marker int
	
{
	var yych uint8
	yystate := 0
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0xE2:
				yystate = 3
				continue yyl
			default:
				yystate = 1
				continue yyl
			}
		case 1:
			yystate = 2
			continue yyl
		case 2:
			{ return 1; }
		case 3:
			marker = cursor
			yych = str[cursor]
			switch (yych) {
			case 0x88:
				cursor += 1
				yystate = 4
				continue yyl
			default:
				yystate = 2
				continue yyl
			}
		case 4:
			yych = str[cursor]
			switch (yych) {
			case 0x80:
				cursor += 1
				yystate = 6
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 5:
			cursor = marker
			yystate = 2
			continue yyl
		case 6:
			yych = str[cursor]
			switch (yych) {
			case 'x':
				cursor += 1
				yystate = 7
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 7:
			yych = str[cursor]
			switch (yych) {
			case ' ':
				cursor += 1
				yystate = 8
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 8:
			yych = str[cursor]
			switch (yych) {
			case 0xE2:
				cursor += 1
				yystate = 9
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 9:
			yych = str[cursor]
			switch (yych) {
			case 0x88:
				cursor += 1
				yystate = 10
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 10:
			yych = str[cursor]
			switch (yych) {
			case 0x83:
				cursor += 1
				yystate = 11
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 11:
			yych = str[cursor]
			switch (yych) {
			case 'y':
				cursor += 1
				yystate = 12
				continue yyl
			default:
				yystate = 5
				continue yyl
			}
		case 12:
			{ return 0; }
		default:
			panic("internal lexer error")
		}
	}
}

}

func lexUTF32(str []uint32) int {
	var cursor, marker int
	
{
	var yych uint32
	yystate := 0
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			if (yych == 0x00002200) {
				yystate = 2
				continue yyl
			}
			yystate = 1
			continue yyl
		case 1:
			{ return 1; }
		case 2:
			marker = cursor
			yych = str[cursor]
			if (yych != 'x') {
				yystate = 1
				continue yyl
			}
			cursor += 1
			yych = str[cursor]
			if (yych == ' ') {
				cursor += 1
				yystate = 4
				continue yyl
			}
			yystate = 3
			continue yyl
		case 3:
			cursor = marker
			yystate = 1
			continue yyl
		case 4:
			yych = str[cursor]
			if (yych != 0x00002203) {
				yystate = 3
				continue yyl
			}
			cursor += 1
			yych = str[cursor]
			if (yych != 'y') {
				yystate = 3
				continue yyl
			}
			cursor += 1
			{ return 0; }
		default:
			panic("internal lexer error")
		}
	}
}

}

func TestLex(t *testing.T) {
	s8 := []uint8{0xe2, 0x88, 0x80, 0x78, 0x20, 0xe2, 0x88, 0x83, 0x79};
	if lexUTF8(s8) != 0 {
		t.Errorf("utf8 failed")
	}

	s32 := []uint32{0x2200, 0x78, 0x20, 0x2203, 0x79};
	if lexUTF32(s32) != 0 {
		t.Errorf("utf32 failed")
	}
}
