/* GPhoto.c generated by valac 0.40.4, the Vala compiler
 * generated from GPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gphoto2/gphoto2-context.h>
#include <gphoto.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto2/gphoto2-filesys.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-file.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <gobject/gvaluecollector.h>


#define GP_TYPE_CONTEXT_WRAPPER (gp_context_wrapper_get_type ())
#define GP_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper))
#define GP_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))
#define GP_IS_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_CONTEXT_WRAPPER))
#define GP_IS_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_CONTEXT_WRAPPER))
#define GP_CONTEXT_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))

typedef struct _GPContextWrapper GPContextWrapper;
typedef struct _GPContextWrapperClass GPContextWrapperClass;
typedef struct _GPContextWrapperPrivate GPContextWrapperPrivate;
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
typedef struct _GPParamSpecContextWrapper GPParamSpecContextWrapper;

#define GP_TYPE_SPIN_IDLE_WRAPPER (gp_spin_idle_wrapper_get_type ())
#define GP_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper))
#define GP_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))
#define GP_IS_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_IS_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_SPIN_IDLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))

typedef struct _GPSpinIdleWrapper GPSpinIdleWrapper;
typedef struct _GPSpinIdleWrapperClass GPSpinIdleWrapperClass;
typedef struct _GPSpinIdleWrapperPrivate GPSpinIdleWrapperPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _gp_file_unref0(var) ((var == NULL) ? NULL : (var = (gp_file_unref (var), NULL)))

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()
struct _GPContextWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPContextWrapperPrivate * priv;
	GPContext* context;
};

struct _GPContextWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GPContextWrapper *self);
	void (*idle) (GPContextWrapper* self);
	void (*error) (GPContextWrapper* self, const gchar* text, void* data);
	void (*status) (GPContextWrapper* self, const gchar* text, void* data);
	void (*message) (GPContextWrapper* self, const gchar* text, void* data);
	void (*progress_start) (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
	void (*progress_update) (GPContextWrapper* self, gfloat current, void* data);
	void (*progress_stop) (GPContextWrapper* self);
};

struct _GPParamSpecContextWrapper {
	GParamSpec parent_instance;
};

struct _GPSpinIdleWrapper {
	GPContextWrapper parent_instance;
	GPSpinIdleWrapperPrivate * priv;
};

struct _GPSpinIdleWrapperClass {
	GPContextWrapperClass parent_class;
};


static gpointer gp_context_wrapper_parent_class = NULL;
static gpointer gp_spin_idle_wrapper_parent_class = NULL;

GQuark gphoto_error_quark (void);
gpointer gp_context_wrapper_ref (gpointer instance);
void gp_context_wrapper_unref (gpointer instance);
GParamSpec* gp_param_spec_context_wrapper (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gp_value_set_context_wrapper (GValue* value,
                                   gpointer v_object);
void gp_value_take_context_wrapper (GValue* value,
                                    gpointer v_object);
gpointer gp_value_get_context_wrapper (const GValue* value);
GType gp_context_wrapper_get_type (void) G_GNUC_CONST;
GPContextWrapper* gp_context_wrapper_new (void);
GPContextWrapper* gp_context_wrapper_construct (GType object_type);
static void gp_context_wrapper_on_idle (GPContextWrapper* self,
                                 GPContext* context);
static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context,
                                                       gpointer self);
static void gp_context_wrapper_on_error (GPContextWrapper* self,
                                  GPContext* context,
                                  const gchar* text);
static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context,
                                                         const gchar* text,
                                                         gpointer self);
static void gp_context_wrapper_on_status (GPContextWrapper* self,
                                   GPContext* context,
                                   const gchar* text);
static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context,
                                                           const gchar* text,
                                                           gpointer self);
static void gp_context_wrapper_on_message (GPContextWrapper* self,
                                    GPContext* context,
                                    const gchar* text);
static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context,
                                                             const gchar* text,
                                                             gpointer self);
static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self,
                                            GPContext* context,
                                            gfloat target,
                                            const gchar* text);
static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context,
                                                                            gfloat target,
                                                                            const gchar* text,
                                                                            gpointer self);
static void gp_context_wrapper_on_progress_update (GPContextWrapper* self,
                                            GPContext* context,
                                            guint id,
                                            gfloat current);
static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context,
                                                                             guint id,
                                                                             gfloat current,
                                                                             gpointer self);
static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self,
                                          GPContext* context,
                                          guint id);
static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context,
                                                                         guint id,
                                                                         gpointer self);
void gp_context_wrapper_idle (GPContextWrapper* self);
static void gp_context_wrapper_real_idle (GPContextWrapper* self);
void gp_context_wrapper_error (GPContextWrapper* self,
                               const gchar* text,
                               void* data);
static void gp_context_wrapper_real_error (GPContextWrapper* self,
                                    const gchar* text,
                                    void* data);
void gp_context_wrapper_status (GPContextWrapper* self,
                                const gchar* text,
                                void* data);
static void gp_context_wrapper_real_status (GPContextWrapper* self,
                                     const gchar* text,
                                     void* data);
void gp_context_wrapper_message (GPContextWrapper* self,
                                 const gchar* text,
                                 void* data);
static void gp_context_wrapper_real_message (GPContextWrapper* self,
                                      const gchar* text,
                                      void* data);
void gp_context_wrapper_progress_start (GPContextWrapper* self,
                                        gfloat current,
                                        const gchar* text,
                                        void* data);
static void gp_context_wrapper_real_progress_start (GPContextWrapper* self,
                                             gfloat current,
                                             const gchar* text,
                                             void* data);
void gp_context_wrapper_progress_update (GPContextWrapper* self,
                                         gfloat current,
                                         void* data);
static void gp_context_wrapper_real_progress_update (GPContextWrapper* self,
                                              gfloat current,
                                              void* data);
void gp_context_wrapper_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_finalize (GPContextWrapper * obj);
GType gp_spin_idle_wrapper_get_type (void) G_GNUC_CONST;
GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void);
GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type);
static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base);
void spin_event_loop (void);
static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base,
                                                gfloat current,
                                                void* data);
#define GP_MAX_FILENAME_LENGTH 63
#define GP_MAX_BASEDIR_LENGTH 255
gboolean gp_get_info (GPContext* context,
                      Camera* camera,
                      const gchar* folder,
                      const gchar* filename,
                      CameraFileInfo* info,
                      GError** error);
GBytes* gp_camera_file_to_bytes (GPContext* context,
                                 CameraFile* file);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* gp_get_fallback_metadata (Camera* camera,
                                         GPContext* context,
                                         const gchar* folder,
                                         const gchar* filename);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error);
GdkPixbuf* gp_load_preview (GPContext* context,
                            Camera* camera,
                            const gchar* folder,
                            const gchar* filename,
                            gchar* * preview_md5,
                            GError** error);
GBytes* gp_load_file_into_buffer (GPContext* context,
                                  Camera* camera,
                                  const gchar* folder,
                                  const gchar* filename,
                                  CameraFileType filetype,
                                  GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_photo_preview (GValue* value,
                              gpointer v_object);
void value_take_photo_preview (GValue* value,
                               gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
GBytes* photo_preview_flatten (PhotoPreview* self,
                               GError** error);
#define IMPORT_PREVIEW_MAX_SCALE 128
GdkPixbuf* gp_load_image (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          GError** error);
GInputStream* gp_load_file_into_stream (GPContext* context,
                                        Camera* camera,
                                        const gchar* folder,
                                        const gchar* filename,
                                        CameraFileType filetype,
                                        GError** error);
void gp_save_image (GPContext* context,
                    Camera* camera,
                    const gchar* folder,
                    const gchar* filename,
                    GFile* dest_file,
                    GError** error);
PhotoMetadata* gp_load_metadata (GPContext* context,
                                 Camera* camera,
                                 const gchar* folder,
                                 const gchar* filename,
                                 GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self,
                                            GBytes* buffer,
                                            GError** error);
GFile* app_dirs_get_temp_dir (void);


GQuark
gphoto_error_quark (void)
{
	return g_quark_from_static_string ("gphoto_error-quark");
}


static void
_gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context,
                                                  gpointer self)
{
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_idle ((GPContextWrapper*) self, context);
#line 344 "GPhoto.c"
}


static void
_gp_context_wrapper_on_error_gp_context_error_func (GPContext* context,
                                                    const gchar* text,
                                                    gpointer self)
{
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_error ((GPContextWrapper*) self, context, text);
#line 355 "GPhoto.c"
}


static void
_gp_context_wrapper_on_status_gp_context_status_func (GPContext* context,
                                                      const gchar* text,
                                                      gpointer self)
{
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_status ((GPContextWrapper*) self, context, text);
#line 366 "GPhoto.c"
}


static void
_gp_context_wrapper_on_message_gp_context_message_func (GPContext* context,
                                                        const gchar* text,
                                                        gpointer self)
{
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_message ((GPContextWrapper*) self, context, text);
#line 377 "GPhoto.c"
}


static guint
_gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context,
                                                                      gfloat target,
                                                                      const gchar* text,
                                                                      gpointer self)
{
	guint result;
	result = gp_context_wrapper_on_progress_start ((GPContextWrapper*) self, context, target, text);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 391 "GPhoto.c"
}


static void
_gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context,
                                                                        guint id,
                                                                        gfloat current,
                                                                        gpointer self)
{
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_update ((GPContextWrapper*) self, context, id, current);
#line 403 "GPhoto.c"
}


static void
_gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context,
                                                                    guint id,
                                                                    gpointer self)
{
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_stop ((GPContextWrapper*) self, context, id);
#line 414 "GPhoto.c"
}


GPContextWrapper*
gp_context_wrapper_construct (GType object_type)
{
	GPContextWrapper* self = NULL;
	GPContext* _tmp0_;
	GPContext* _tmp1_;
	GPContext* _tmp2_;
	GPContext* _tmp3_;
	GPContext* _tmp4_;
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPContextWrapper*) g_type_create_instance (object_type);
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = self->context;
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_idle_func (_tmp0_, _gp_context_wrapper_on_idle_gp_context_idle_func, self);
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = self->context;
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_error_func (_tmp1_, _gp_context_wrapper_on_error_gp_context_error_func, self);
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = self->context;
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_status_func (_tmp2_, _gp_context_wrapper_on_status_gp_context_status_func, self);
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = self->context;
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_message_func (_tmp3_, _gp_context_wrapper_on_message_gp_context_message_func, self);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = self->context;
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_progress_funcs (_tmp4_, _gp_context_wrapper_on_progress_start_gp_context_progress_start_func, _gp_context_wrapper_on_progress_update_gp_context_progress_update_func, _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func, self);
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 451 "GPhoto.c"
}


GPContextWrapper*
gp_context_wrapper_new (void)
{
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_context_wrapper_construct (GP_TYPE_CONTEXT_WRAPPER);
#line 460 "GPhoto.c"
}


static void
gp_context_wrapper_real_idle (GPContextWrapper* self)
{
}


void
gp_context_wrapper_idle (GPContextWrapper* self)
{
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->idle (self);
#line 477 "GPhoto.c"
}


static void
gp_context_wrapper_real_error (GPContextWrapper* self,
                               const gchar* text,
                               void* data)
{
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 488 "GPhoto.c"
}


void
gp_context_wrapper_error (GPContextWrapper* self,
                          const gchar* text,
                          void* data)
{
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->error (self, text, data);
#line 501 "GPhoto.c"
}


static void
gp_context_wrapper_real_status (GPContextWrapper* self,
                                const gchar* text,
                                void* data)
{
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 512 "GPhoto.c"
}


void
gp_context_wrapper_status (GPContextWrapper* self,
                           const gchar* text,
                           void* data)
{
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->status (self, text, data);
#line 525 "GPhoto.c"
}


static void
gp_context_wrapper_real_message (GPContextWrapper* self,
                                 const gchar* text,
                                 void* data)
{
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 536 "GPhoto.c"
}


void
gp_context_wrapper_message (GPContextWrapper* self,
                            const gchar* text,
                            void* data)
{
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->message (self, text, data);
#line 549 "GPhoto.c"
}


static void
gp_context_wrapper_real_progress_start (GPContextWrapper* self,
                                        gfloat current,
                                        const gchar* text,
                                        void* data)
{
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 561 "GPhoto.c"
}


void
gp_context_wrapper_progress_start (GPContextWrapper* self,
                                   gfloat current,
                                   const gchar* text,
                                   void* data)
{
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_start (self, current, text, data);
#line 575 "GPhoto.c"
}


static void
gp_context_wrapper_real_progress_update (GPContextWrapper* self,
                                         gfloat current,
                                         void* data)
{
}


void
gp_context_wrapper_progress_update (GPContextWrapper* self,
                                    gfloat current,
                                    void* data)
{
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_update (self, current, data);
#line 596 "GPhoto.c"
}


static void
gp_context_wrapper_real_progress_stop (GPContextWrapper* self)
{
}


void
gp_context_wrapper_progress_stop (GPContextWrapper* self)
{
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_stop (self);
#line 613 "GPhoto.c"
}


static void
gp_context_wrapper_on_idle (GPContextWrapper* self,
                            GPContext* context)
{
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 47 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_idle (self);
#line 627 "GPhoto.c"
}


static void
gp_context_wrapper_on_error (GPContextWrapper* self,
                             GPContext* context,
                             const gchar* text)
{
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 51 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_error (self, text, NULL);
#line 644 "GPhoto.c"
}


static void
gp_context_wrapper_on_status (GPContextWrapper* self,
                              GPContext* context,
                              const gchar* text)
{
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 55 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_status (self, text, NULL);
#line 661 "GPhoto.c"
}


static void
gp_context_wrapper_on_message (GPContextWrapper* self,
                               GPContext* context,
                               const gchar* text)
{
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 59 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_message (self, text, NULL);
#line 678 "GPhoto.c"
}


static guint
gp_context_wrapper_on_progress_start (GPContextWrapper* self,
                                      GPContext* context,
                                      gfloat target,
                                      const gchar* text)
{
	guint result = 0U;
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (GP_IS_CONTEXT_WRAPPER (self), 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (text != NULL, 0U);
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_start (self, target, text, NULL);
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = (guint) 0;
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 701 "GPhoto.c"
}


static void
gp_context_wrapper_on_progress_update (GPContextWrapper* self,
                                       GPContext* context,
                                       guint id,
                                       gfloat current)
{
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 69 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_update (self, current, NULL);
#line 717 "GPhoto.c"
}


static void
gp_context_wrapper_on_progress_stop (GPContextWrapper* self,
                                     GPContext* context,
                                     guint id)
{
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 73 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_stop (self);
#line 732 "GPhoto.c"
}


static void
gp_value_context_wrapper_init (GValue* value)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	value->data[0].v_pointer = NULL;
#line 741 "GPhoto.c"
}


static void
gp_value_context_wrapper_free_value (GValue* value)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (value->data[0].v_pointer);
#line 752 "GPhoto.c"
	}
}


static void
gp_value_context_wrapper_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = gp_context_wrapper_ref (src_value->data[0].v_pointer);
#line 765 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = NULL;
#line 769 "GPhoto.c"
	}
}


static gpointer
gp_value_context_wrapper_peek_pointer (const GValue* value)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 779 "GPhoto.c"
}


static gchar*
gp_value_context_wrapper_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (collect_values[0].v_pointer) {
#line 791 "GPhoto.c"
		GPContextWrapper * object;
		object = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 798 "GPhoto.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 802 "GPhoto.c"
		}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = gp_context_wrapper_ref (object);
#line 806 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 810 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 814 "GPhoto.c"
}


static gchar*
gp_value_context_wrapper_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GPContextWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!object_p) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 830 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = NULL;
#line 836 "GPhoto.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = value->data[0].v_pointer;
#line 840 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = gp_context_wrapper_ref (value->data[0].v_pointer);
#line 844 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 848 "GPhoto.c"
}


GParamSpec*
gp_param_spec_context_wrapper (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GPParamSpecContextWrapper* spec;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return G_PARAM_SPEC (spec);
#line 868 "GPhoto.c"
}


gpointer
gp_value_get_context_wrapper (const GValue* value)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 879 "GPhoto.c"
}


void
gp_value_set_context_wrapper (GValue* value,
                              gpointer v_object)
{
	GPContextWrapper * old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_ref (value->data[0].v_pointer);
#line 902 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 906 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 912 "GPhoto.c"
	}
}


void
gp_value_take_context_wrapper (GValue* value,
                               gpointer v_object)
{
	GPContextWrapper * old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 934 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 938 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 944 "GPhoto.c"
	}
}


static void
gp_context_wrapper_class_init (GPContextWrapperClass * klass)
{
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->finalize = gp_context_wrapper_finalize;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper *)) gp_context_wrapper_real_idle;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->error = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_error;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->status = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_status;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->message = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_message;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_start = (void (*) (GPContextWrapper *, gfloat, const gchar*, void*)) gp_context_wrapper_real_progress_start;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper *, gfloat, void*)) gp_context_wrapper_real_progress_update;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_stop = (void (*) (GPContextWrapper *)) gp_context_wrapper_real_progress_stop;
#line 970 "GPhoto.c"
}


static void
gp_context_wrapper_instance_init (GPContextWrapper * self)
{
	GPContext* _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = gp_context_new ();
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->context = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->ref_count = 1;
#line 984 "GPhoto.c"
}


static void
gp_context_wrapper_finalize (GPContextWrapper * obj)
{
	GPContextWrapper * self;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_signal_handlers_destroy (self);
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_context_unref0 (self->context);
#line 998 "GPhoto.c"
}


GType
gp_context_wrapper_get_type (void)
{
	static volatile gsize gp_context_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_context_wrapper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gp_value_context_wrapper_init, gp_value_context_wrapper_free_value, gp_value_context_wrapper_copy_value, gp_value_context_wrapper_peek_pointer, "p", gp_value_context_wrapper_collect_value, "p", gp_value_context_wrapper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GPContextWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_context_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPContextWrapper), 0, (GInstanceInitFunc) gp_context_wrapper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gp_context_wrapper_type_id;
		gp_context_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GPContextWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gp_context_wrapper_type_id__volatile, gp_context_wrapper_type_id);
	}
	return gp_context_wrapper_type_id__volatile;
}


gpointer
gp_context_wrapper_ref (gpointer instance)
{
	GPContextWrapper * self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return instance;
#line 1027 "GPhoto.c"
}


void
gp_context_wrapper_unref (gpointer instance)
{
	GPContextWrapper * self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		GP_CONTEXT_WRAPPER_GET_CLASS (self)->finalize (self);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1042 "GPhoto.c"
	}
}


GPSpinIdleWrapper*
gp_spin_idle_wrapper_construct (GType object_type)
{
	GPSpinIdleWrapper* self = NULL;
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPSpinIdleWrapper*) gp_context_wrapper_construct (object_type);
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 1055 "GPhoto.c"
}


GPSpinIdleWrapper*
gp_spin_idle_wrapper_new (void)
{
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_spin_idle_wrapper_construct (GP_TYPE_SPIN_IDLE_WRAPPER);
#line 1064 "GPhoto.c"
}


static void
gp_spin_idle_wrapper_real_idle (GPContextWrapper* base)
{
	GPSpinIdleWrapper * self;
#line 82 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 83 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->idle (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper));
#line 85 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 1078 "GPhoto.c"
}


static void
gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base,
                                           gfloat current,
                                           void* data)
{
	GPSpinIdleWrapper * self;
#line 88 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->progress_update (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper), current, data);
#line 91 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 1094 "GPhoto.c"
}


static void
gp_spin_idle_wrapper_class_init (GPSpinIdleWrapperClass * klass)
{
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_spin_idle_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper *)) gp_spin_idle_wrapper_real_idle;
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper *, gfloat, void*)) gp_spin_idle_wrapper_real_progress_update;
#line 1107 "GPhoto.c"
}


static void
gp_spin_idle_wrapper_instance_init (GPSpinIdleWrapper * self)
{
}


GType
gp_spin_idle_wrapper_get_type (void)
{
	static volatile gsize gp_spin_idle_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_spin_idle_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GPSpinIdleWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_spin_idle_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPSpinIdleWrapper), 0, (GInstanceInitFunc) gp_spin_idle_wrapper_instance_init, NULL };
		GType gp_spin_idle_wrapper_type_id;
		gp_spin_idle_wrapper_type_id = g_type_register_static (GP_TYPE_CONTEXT_WRAPPER, "GPSpinIdleWrapper", &g_define_type_info, 0);
		g_once_init_leave (&gp_spin_idle_wrapper_type_id__volatile, gp_spin_idle_wrapper_type_id);
	}
	return gp_spin_idle_wrapper_type_id__volatile;
}


gboolean
gp_get_info (GPContext* context,
             Camera* camera,
             const gchar* folder,
             const gchar* filename,
             CameraFileInfo* info,
             GError** error)
{
	CameraFileInfo _vala_info = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	int res = 0;
	CameraFileInfo _tmp6_ = {0};
	int _tmp7_;
	int _tmp8_;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = strlen (folder);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = _tmp1_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ > GP_MAX_BASEDIR_LENGTH) {
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = TRUE;
#line 1165 "GPhoto.c"
	} else {
		gint _tmp3_;
		gint _tmp4_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = strlen (filename);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = _tmp3_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp4_ > GP_MAX_FILENAME_LENGTH;
#line 1175 "GPhoto.c"
	}
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp0_) {
#line 1179 "GPhoto.c"
		CameraFileInfo _tmp5_ = {0};
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_info = _tmp5_;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = FALSE;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (info) {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*info = _vala_info;
#line 1191 "GPhoto.c"
		} else {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			 (_vala_info);
#line 1195 "GPhoto.c"
		}
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1199 "GPhoto.c"
	}
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = gp_camera_file_get_info (camera, folder, filename, &_tmp6_, context);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (_vala_info);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_info = _tmp6_;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp7_;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = res;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp8_ != GP_OK) {
#line 1213 "GPhoto.c"
		int _tmp9_;
		int _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		gboolean _tmp13_ = FALSE;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = gp_port_result_as_string (_tmp10_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file information for %s/%s: %s", (gint) _tmp9_, folder, filename, _tmp11_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp12_;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return _tmp13_;
#line 1233 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = TRUE;
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (info) {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*info = _vala_info;
#line 1241 "GPhoto.c"
	} else {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 1245 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1249 "GPhoto.c"
}


static gpointer
_GPHOTO_REF_FILE0 (gpointer self)
{
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self ? GPHOTO_REF_FILE (self) : NULL;
#line 1258 "GPhoto.c"
}


GBytes*
gp_camera_file_to_bytes (GPContext* context,
                         CameraFile* file)
{
	GBytes* result = NULL;
	guint8* data = NULL;
	gulong data_len = 0UL;
	int res = 0;
	guint8* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	int _tmp2_;
	int _tmp3_;
	guint8* buffer = NULL;
	guint8* _tmp4_;
	gint buffer_length1;
	gint _buffer_size_;
	gulong _tmp5_;
	gint _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	CameraFile* _tmp8_;
	GBytes* _tmp9_;
#line 118 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 118 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = gp_file_get_data_and_size (file, &_tmp0_, &_tmp1_);
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data = _tmp0_;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data_len = _tmp1_;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp2_;
#line 125 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = res;
#line 125 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp3_ != GP_OK) {
#line 126 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 126 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1304 "GPhoto.c"
	}
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = data;
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer = (guint8*) _tmp4_;
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer_length1 = sizeof (guint8) / sizeof (guint8);
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_buffer_size_ = buffer_length1;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = data_len;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer_length1 = (gint) _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = buffer_length1;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = buffer;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7__length1 = buffer_length1;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = _GPHOTO_REF_FILE0 (file);
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = g_bytes_new_with_free_func (_tmp7_, (gsize) _tmp7__length1, gp_file_unref, _tmp8_);
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp9_;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1332 "GPhoto.c"
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1369 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1370 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1371 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1358 "GPhoto.c"
		glong _tmp2_;
#line 1372 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1372 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 1364 "GPhoto.c"
	}
#line 1374 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1368 "GPhoto.c"
		glong _tmp3_;
#line 1375 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1375 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 1374 "GPhoto.c"
	}
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1378 "GPhoto.c"
		glong _tmp5_;
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 1384 "GPhoto.c"
	} else {
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 1388 "GPhoto.c"
	}
#line 1377 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1394 "GPhoto.c"
		glong _tmp7_;
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 1400 "GPhoto.c"
	} else {
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 1404 "GPhoto.c"
	}
#line 1378 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1379 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1380 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1416 "GPhoto.c"
}


PhotoMetadata*
gp_get_fallback_metadata (Camera* camera,
                          GPContext* context,
                          const gchar* folder,
                          const gchar* filename)
{
	PhotoMetadata* result = NULL;
	CameraStorageInformation* sifs = NULL;
	gint count = 0;
	gint _tmp0_ = 0;
	GPPortInfo port_info = {0};
	GPPortInfo _tmp1_ = {0};
	gchar* path = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp13_;
	GError * _inner_error_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 138 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	sifs = NULL;
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = 0;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_storageinfo (camera, &sifs, &_tmp0_, context);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = _tmp0_;
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_port_info (camera, &_tmp1_);
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	port_info = _tmp1_;
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_port_info_get_path (port_info, &_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	path = _tmp3_;
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = g_strdup ("disk:");
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	prefix = _tmp4_;
#line 149 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = path;
#line 149 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (g_str_has_prefix (_tmp5_, prefix)) {
#line 1479 "GPhoto.c"
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = path;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = strlen (prefix);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = _tmp7_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = path;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = strlen (_tmp9_);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = _tmp10_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = string_slice (_tmp6_, (glong) _tmp8_, (glong) _tmp11_);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		path = _tmp12_;
#line 1505 "GPhoto.c"
	} else {
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1517 "GPhoto.c"
	}
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = photo_metadata_new ();
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp13_;
#line 1523 "GPhoto.c"
	{
		PhotoMetadata* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = metadata;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = path;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = g_strconcat (_tmp15_, folder, NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = _tmp16_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = _tmp18_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_strconcat (_tmp19_, filename, NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = _tmp20_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp22_ = g_file_new_for_path (_tmp21_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = _tmp22_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp23_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (_tmp23_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp21_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp19_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp17_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1567 "GPhoto.c"
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = NULL;
#line 1582 "GPhoto.c"
	}
	__finally69:
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1601 "GPhoto.c"
	}
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (prefix);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1613 "GPhoto.c"
}


static gpointer
_g_bytes_ref0 (gpointer self)
{
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self ? g_bytes_ref (self) : NULL;
#line 1622 "GPhoto.c"
}


GdkPixbuf*
gp_load_preview (GPContext* context,
                 Camera* camera,
                 const gchar* folder,
                 const gchar* filename,
                 gchar* * preview_md5,
                 GError** error)
{
	gchar* _vala_preview_md5 = NULL;
	GdkPixbuf* result = NULL;
	GBytes* raw = NULL;
	GBytes* out_bytes = NULL;
	GBytes* _tmp15_;
	GBytes* _tmp16_;
	GBytes* _tmp17_;
	gchar* _tmp18_;
	GMemoryInputStream* mins = NULL;
	GBytes* _tmp19_;
	GMemoryInputStream* _tmp20_;
	GdkPixbuf* _tmp21_ = NULL;
	GMemoryInputStream* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 166 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	raw = NULL;
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	out_bytes = NULL;
#line 168 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_vala_preview_md5);
#line 168 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_preview_md5 = NULL;
#line 1666 "GPhoto.c"
	{
		GBytes* _tmp0_ = NULL;
		GBytes* _tmp1_;
		GBytes* _tmp2_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = gp_load_file_into_buffer (context, camera, folder, filename, GP_FILE_TYPE_PREVIEW, &_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp1_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1677 "GPhoto.c"
			goto __catch70_g_error;
		}
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = _tmp0_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		raw = _tmp2_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp0_);
#line 1690 "GPhoto.c"
	}
	goto __finally70;
	__catch70_g_error:
	{
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp3_;
		PhotoMetadata* _tmp4_;
		PhotoMetadata* _tmp5_;
		PhotoPreview* preview = NULL;
		PhotoMetadata* _tmp6_;
		PhotoMetadata* _tmp7_;
		PhotoPreview* _tmp8_;
		GBytes* _tmp9_ = NULL;
		PhotoPreview* _tmp10_;
		GBytes* _tmp11_;
		GBytes* _tmp12_;
		GBytes* _tmp13_;
		gchar* _tmp14_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = gp_get_fallback_metadata (camera, context, folder, filename);
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = _tmp3_;
#line 174 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = metadata;
#line 174 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (NULL == _tmp4_) {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (out_bytes);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (raw);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (preview_md5) {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*preview_md5 = _vala_preview_md5;
#line 1733 "GPhoto.c"
			} else {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_g_free0 (_vala_preview_md5);
#line 1737 "GPhoto.c"
			}
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1741 "GPhoto.c"
		}
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = metadata;
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (((guint) 0) == photo_metadata_get_preview_count (_tmp5_)) {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (out_bytes);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (raw);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (preview_md5) {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*preview_md5 = _vala_preview_md5;
#line 1759 "GPhoto.c"
			} else {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_g_free0 (_vala_preview_md5);
#line 1763 "GPhoto.c"
			}
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1767 "GPhoto.c"
		}
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = metadata;
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = metadata;
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = photo_metadata_get_preview (_tmp6_, photo_metadata_get_preview_count (_tmp7_) - 1);
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		preview = _tmp8_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = preview;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = photo_preview_flatten (_tmp10_, &_inner_error_);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = _tmp11_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_photo_preview_unref0 (preview);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 1789 "GPhoto.c"
			goto __finally70;
		}
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = _tmp9_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = NULL;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		raw = _tmp12_;
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = raw;
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp13_);
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_vala_preview_md5);
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_preview_md5 = _tmp14_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp9_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_photo_preview_unref0 (preview);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 1814 "GPhoto.c"
	}
	__finally70:
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (out_bytes);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1827 "GPhoto.c"
	}
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp15_ = raw;
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp16_ = _g_bytes_ref0 (_tmp15_);
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (out_bytes);
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	out_bytes = _tmp16_;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = out_bytes;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp17_);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_vala_preview_md5);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_preview_md5 = _tmp18_;
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp19_ = raw;
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp20_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp19_);
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	mins = _tmp20_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = mins;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_input_stream_get_type (), GInputStream), IMPORT_PREVIEW_MAX_SCALE, IMPORT_PREVIEW_MAX_SCALE, TRUE, NULL, &_inner_error_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = _tmp23_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (mins);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (out_bytes);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1869 "GPhoto.c"
	}
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp24_ = _tmp21_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp24_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp21_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (mins);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (out_bytes);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (raw);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (preview_md5) {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*preview_md5 = _vala_preview_md5;
#line 1889 "GPhoto.c"
	} else {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_vala_preview_md5);
#line 1893 "GPhoto.c"
	}
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1897 "GPhoto.c"
}


GdkPixbuf*
gp_load_image (GPContext* context,
               Camera* camera,
               const gchar* folder,
               const gchar* filename,
               GError** error)
{
	GdkPixbuf* result = NULL;
	GInputStream* ins = NULL;
	GInputStream* _tmp0_;
	GInputStream* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	GInputStream* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = gp_load_file_into_stream (context, camera, folder, filename, GP_FILE_TYPE_NORMAL, &_inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	ins = _tmp0_;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1935 "GPhoto.c"
	}
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = ins;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp1_ == NULL) {
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1947 "GPhoto.c"
	}
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = ins;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = gdk_pixbuf_new_from_stream (_tmp3_, NULL, &_inner_error_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = _tmp4_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1963 "GPhoto.c"
	}
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp5_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp2_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (ins);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1977 "GPhoto.c"
}


void
gp_save_image (GPContext* context,
               Camera* camera,
               const gchar* folder,
               const gchar* filename,
               GFile* dest_file,
               GError** error)
{
	gint fd = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	CameraFile* camera_file = NULL;
	int res = 0;
	gint _tmp9_;
	CameraFile* _tmp10_ = NULL;
	int _tmp11_;
	int _tmp12_;
	CameraFile* _tmp17_;
	int _tmp18_;
	GError * _inner_error_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (camera != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (folder != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (filename != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = g_file_get_path (dest_file);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = _tmp0_;
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = creat (_tmp1_, (mode_t) 0640);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp1_);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	fd = _tmp2_;
#line 204 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = fd;
#line 204 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp3_ < 0) {
#line 2027 "GPhoto.c"
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = errno;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = g_file_get_path (dest_file);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = _tmp5_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "[%d] Error creating file %s: %m", _tmp4_, _tmp6_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = _tmp7_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp6_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp8_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 2051 "GPhoto.c"
	}
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = fd;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = gp_file_new_from_fd (&_tmp10_, _tmp9_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp10_;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp11_;
#line 210 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = res;
#line 210 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp12_ != GP_OK) {
#line 2067 "GPhoto.c"
		int _tmp13_;
		int _tmp14_;
		const gchar* _tmp15_;
		GError* _tmp16_;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = res;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = res;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = gp_port_result_as_string (_tmp14_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp13_, _tmp15_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp16_;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 2088 "GPhoto.c"
	}
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = camera_file;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = gp_camera_file_get (camera, folder, filename, GP_FILE_TYPE_NORMAL, _tmp17_, context);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18_ = res;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp18_ != GP_OK) {
#line 2098 "GPhoto.c"
		int _tmp19_;
		int _tmp20_;
		const gchar* _tmp21_;
		GError* _tmp22_;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = res;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = res;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = gp_port_result_as_string (_tmp20_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp22_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp19_, folder, filename, _tmp21_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp22_;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 2119 "GPhoto.c"
	}
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 2123 "GPhoto.c"
}


static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
#line 5049 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5051 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = (gint) g_bytes_get_size (self);
#line 5051 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2137 "GPhoto.c"
}


PhotoMetadata*
gp_load_metadata (GPContext* context,
                  Camera* camera,
                  const gchar* folder,
                  const gchar* filename,
                  GError** error)
{
	PhotoMetadata* result = NULL;
	GBytes* camera_raw = NULL;
	gboolean _tmp4_ = FALSE;
	GBytes* _tmp5_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp9_;
	PhotoMetadata* _tmp10_;
	GBytes* _tmp11_;
	GError * _inner_error_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 223 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_raw = NULL;
#line 2167 "GPhoto.c"
	{
		GBytes* _tmp0_ = NULL;
		GBytes* _tmp1_;
		GBytes* _tmp2_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = gp_load_file_into_buffer (context, camera, folder, filename, GP_FILE_TYPE_EXIF, &_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp1_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2178 "GPhoto.c"
			goto __catch71_g_error;
		}
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = _tmp0_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = _tmp2_;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp0_);
#line 2191 "GPhoto.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
		PhotoMetadata* _tmp3_;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = gp_get_fallback_metadata (camera, context, folder, filename);
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = _tmp3_;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2209 "GPhoto.c"
	}
	__finally71:
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2220 "GPhoto.c"
	}
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = camera_raw;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp5_ == NULL) {
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = TRUE;
#line 2228 "GPhoto.c"
	} else {
		GBytes* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = camera_raw;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = _vala_g_bytes_get_length (_tmp6_);
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = _tmp7_;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = _tmp8_ == 0;
#line 2241 "GPhoto.c"
	}
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp4_) {
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2251 "GPhoto.c"
	}
#line 233 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = photo_metadata_new ();
#line 233 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp9_;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = metadata;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = camera_raw;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	photo_metadata_read_from_app1_segment (_tmp10_, _tmp11_, &_inner_error_);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2273 "GPhoto.c"
	}
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (camera_raw);
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2281 "GPhoto.c"
}


GInputStream*
gp_load_file_into_stream (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          CameraFileType filetype,
                          GError** error)
{
	GInputStream* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	int _tmp2_;
	int _tmp7_;
	GBytes* bytes = NULL;
	GBytes* _tmp12_;
	GBytes* _tmp13_;
	GFile* temp = NULL;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	int _tmp23_;
	GFileInputStream* _tmp32_ = NULL;
	GFile* _tmp33_;
	GFileInputStream* _tmp34_;
	GFileInputStream* _tmp35_;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2337 "GPhoto.c"
		int _tmp3_;
		int _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2358 "GPhoto.c"
	}
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = gp_camera_file_get (camera, folder, filename, filetype, camera_file, context);
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = res;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp7_ != GP_OK) {
#line 2366 "GPhoto.c"
		int _tmp8_;
		int _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = res;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = res;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = gp_port_result_as_string (_tmp9_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp8_, folder, filename, _tmp10_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp11_;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2387 "GPhoto.c"
	}
#line 256 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = gp_camera_file_to_bytes (context, camera_file);
#line 256 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	bytes = _tmp12_;
#line 257 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = bytes;
#line 257 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp13_ != NULL) {
#line 2397 "GPhoto.c"
		GBytes* _tmp14_;
		GMemoryInputStream* _tmp15_;
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = bytes;
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp14_);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_input_stream_get_type (), GInputStream);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2412 "GPhoto.c"
	}
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp16_ = app_dirs_get_temp_dir ();
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = _tmp16_;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18_ = g_file_get_child (_tmp17_, "import.tmp");
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp19_ = _tmp18_;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp17_);
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	temp = _tmp19_;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp20_ = temp;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = g_file_get_path (_tmp20_);
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = _tmp21_;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = gp_file_save (camera_file, _tmp22_);
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp22_);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = res;
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp23_ != GP_OK) {
#line 2440 "GPhoto.c"
		int _tmp24_;
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		int _tmp28_;
		const gchar* _tmp29_;
		GError* _tmp30_;
		GError* _tmp31_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = res;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp25_ = temp;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26_ = g_file_get_path (_tmp25_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp27_ = _tmp26_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = res;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = gp_port_result_as_string (_tmp28_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp30_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error copying file %s/%s to %s: %s", (gint) _tmp24_, folder, filename, _tmp27_, _tmp29_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp31_ = _tmp30_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp27_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp31_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2479 "GPhoto.c"
	}
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp33_ = temp;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp34_ = g_file_read (_tmp33_, NULL, &_inner_error_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = _tmp34_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2499 "GPhoto.c"
	}
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp35_ = _tmp32_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_input_stream_get_type (), GInputStream);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp32_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (temp);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (bytes);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2517 "GPhoto.c"
}


GBytes*
gp_load_file_into_buffer (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          CameraFileType filetype,
                          GError** error)
{
	GBytes* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	int _tmp2_;
	CameraFile* _tmp7_;
	int _tmp8_;
	CameraFile* _tmp13_;
	GBytes* _tmp14_;
	GError * _inner_error_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 276 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2560 "GPhoto.c"
		int _tmp3_;
		int _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2581 "GPhoto.c"
	}
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = camera_file;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = gp_camera_file_get (camera, folder, filename, filetype, _tmp7_, context);
#line 280 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = res;
#line 280 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp8_ != GP_OK) {
#line 2591 "GPhoto.c"
		int _tmp9_;
		int _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = res;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = res;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = gp_port_result_as_string (_tmp10_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp9_, folder, filename, _tmp11_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp12_;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2612 "GPhoto.c"
	}
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = camera_file;
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = gp_camera_file_to_bytes (context, _tmp13_);
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp14_;
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2624 "GPhoto.c"
}



