/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  11, X'edcd6347cdd12fb63000b605430713544c9d318a'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'2d2d2d2d2d424547494e2043455254494649434154452d2d2d2d2d0a4d494944754443434171436741774942416749424144414e42676b71686b69473977304241517346414442464d517377435159445651514745774a445344455a0a4d4263474131554543684d5154476c7564586767633352796232356e55336468626a45624d426b474131554541784d53633352796232356e55336468626942530a6232393049454e424d423458445441304d446b784d4445774d4445784f466f58445445354d446b774e7a45774d4445784f466f775254454c4d416b47413155450a42684d43513067784754415842674e5642416f5445457870626e563449484e30636d39755a314e3359573478477a415a42674e5642414d54456e4e30636d39750a5a314e3359573467556d39766443424451544343415349774451594a4b6f5a496876634e4151454242514144676745504144434341516f4367674542414c2f790a58324c7150565a75574c5049656b6e4b383678687a366c6a64334e4e6843327a2b5031756f43503373424d755a695a51456a467a686e4b6362587843656f32660a466e76684f4f6a727269735375566b7a757538326f7858443366496b7a7553376d395634453130455a7a676d4b5749662b57754e52666267417555494e6d4c630a345947415842514c50797a7050344f75343868687a2f59516f3538426963733650487935763334714356524f4958447671686a39315038672b70532b4632312f0a37502b4348326a5263564945485a7447384d2f507765545051393564507a705964324f7636535a2f553745576d624d6d5438566355596e3161436878466d79350a6777655642576c6b48364d502b31446545302f744c35633837786f354b4365474b3854647170653773425243347050454548445163695455766b65754a3150720a4b2b314c77647152786f3748674d5269447738434177454141614f42736a4342727a415342674e5648524d4241663845434441474151482f416745424d4173470a413155644477514541774942426a416442674e5648513445466751555861666463415a524d6e376e746d327a74655867594f6f7554653877625159445652306a0a424759775a4941555861666463415a524d6e376e746d327a74655867594f6f7554652b68536152484d455578437a414a42674e5642415954416b4e494d526b770a467759445651514b4578424d615735316543427a64484a76626d6454643246754d527377475159445651514445784a7a64484a76626d64546432467549464a760a6233516751304743415141774451594a4b6f5a496876634e4151454c425141446767454241434f536d71454274424c52396156335579434938676d7a5235696e0a4c74653961555858532b716973364632683253746634734e2b4e6c36476a37524543365370664548347757647769554c354a30434a68796f4f6a5175446c336e0a314477336445342f7a714d5a6479444b455954553735546d7675734e4a426447734c6b726637454154416a6f692f6e72544f5950506853555a7650702f442b590a764f524a39456a353147586c4b316e774542356941382b7444596e694e516e364244314d456749656a7a4b2b66626979376272615a42316b71686f45723253690a376c7542536e55393132737734393445383861324557626d4d766732545648504e7a4370566b704e6b376b69664369776d7739566c646b71597939792f6c43610a45707970376c54664b77376362443034566b38514a573738324c36437375786b6c333436623137776d4f716e38415a6970733374467375415933773d0a2d2d2d2d2d454e442043455254494649434154452d2d2d2d2d0a'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=sun.strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 5 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 6 
);

/* Proposals */

INSERT INTO proposals (
  proposal
) VALUES (
  'aes128-sha256-modp3072'
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_SUN', 'PH_IP_MOON'
);

INSERT INTO ike_config_proposal (
  ike_cfg, prio, prop
) VALUES (
  1, 1, 1
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, mobike, dpd_delay
) VALUES (
  'net-net', 1, 5, 4, 0, 30
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-1', '/usr/local/libexec/ipsec/_updown iptables', 1, 1
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-2', '/usr/local/libexec/ipsec/_updown iptables', 1, 1
);

INSERT INTO child_configs (
  name, updown, start_action, dpd_action
) VALUES (
  'net-3', '/usr/local/libexec/ipsec/_updown iptables', 0, 0
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 2
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 3
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  2, 1, 1
);

INSERT INTO child_config_proposal (
  child_cfg, prio, prop
) VALUES (
  3, 1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010000', X'0a01000f'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010010', X'0a01001f'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010200', X'0a0103ff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020000', X'0a0201ff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020200', X'0a0203ff'
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 4, 0
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  2, 2, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  2, 4, 0
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  3, 3, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  3, 5, 0
);
