/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* carol@strongswan.org */
  3, X'6361726f6c407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  11, X'5c597062572d2a249c5c94569b895ee5c505b6bd'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=carol@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 5 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_CAROL', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 4, 6 
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', '/usr/local/libexec/ipsec/_updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

