#!/usr/bin/env python

# Copyright (c) Twisted Matrix Laboratories.
# See LICENSE for details.

from twisted.internet import reactor
from twisted.internet.protocol import DatagramProtocol

# Here's a UDP version of the simplest possible protocol


class EchoUDP(DatagramProtocol):
    def datagramReceived(self, datagram, address):
        self.transport.write(datagram, address)


def main():
    reactor.listenUDP(8000, EchoUDP())
    reactor.run()


if __name__ == "__main__":
    main()
