/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Inspector-iOS-11.0.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

// ApplicationCache
InspectorBackend.registerDomain("ApplicationCache", ["page"]);
InspectorBackend.registerCommand("ApplicationCache.getFramesWithManifests", null, [], ["frameIds"]);
InspectorBackend.registerCommand("ApplicationCache.enable", null, [], []);
InspectorBackend.registerCommand("ApplicationCache.getManifestForFrame", null, [{"name": "frameId", "type": "string"}], ["manifestURL"]);
InspectorBackend.registerCommand("ApplicationCache.getApplicationCacheForFrame", null, [{"name": "frameId", "type": "string"}], ["applicationCache"]);
InspectorBackend.registerEvent("ApplicationCache.applicationCacheStatusUpdated", null, ["frameId", "manifestURL", "status"]);
InspectorBackend.registerEvent("ApplicationCache.networkStateUpdated", null, ["isNowOnline"]);
InspectorBackend.registerApplicationCacheDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "ApplicationCache");
InspectorBackend.activateDomain("ApplicationCache", ["page"]);

// CSS
InspectorBackend.registerDomain("CSS", ["page"]);
InspectorBackend.registerEnum("CSS.StyleSheetOrigin", {User: "user", UserAgent: "user-agent", Inspector: "inspector", Regular: "regular"});
InspectorBackend.registerEnum("CSS.CSSPropertyStatus", {Active: "active", Inactive: "inactive", Disabled: "disabled", Style: "style"});
InspectorBackend.registerEnum("CSS.CSSMediaSource", {MediaRule: "mediaRule", ImportRule: "importRule", LinkedSheet: "linkedSheet", InlineSheet: "inlineSheet"});
InspectorBackend.registerEnum("CSS.RegionRegionOverset", {Overset: "overset", Fit: "fit", Empty: "empty"});
InspectorBackend.registerCommand("CSS.enable", null, [], []);
InspectorBackend.registerCommand("CSS.disable", null, [], []);
InspectorBackend.registerCommand("CSS.getMatchedStylesForNode", null, [{"name": "nodeId", "type": "number"}, {"name": "includePseudo", "type": "boolean", "optional": true}, {"name": "includeInherited", "type": "boolean", "optional": true}], ["matchedCSSRules", "pseudoElements", "inherited"]);
InspectorBackend.registerCommand("CSS.getInlineStylesForNode", null, [{"name": "nodeId", "type": "number"}], ["inlineStyle", "attributesStyle"]);
InspectorBackend.registerCommand("CSS.getComputedStyleForNode", null, [{"name": "nodeId", "type": "number"}], ["computedStyle"]);
InspectorBackend.registerCommand("CSS.getAllStyleSheets", null, [], ["headers"]);
InspectorBackend.registerCommand("CSS.getStyleSheet", null, [{"name": "styleSheetId", "type": "string"}], ["styleSheet"]);
InspectorBackend.registerCommand("CSS.getStyleSheetText", null, [{"name": "styleSheetId", "type": "string"}], ["text"]);
InspectorBackend.registerCommand("CSS.setStyleSheetText", null, [{"name": "styleSheetId", "type": "string"}, {"name": "text", "type": "string"}], []);
InspectorBackend.registerCommand("CSS.setStyleText", null, [{"name": "styleId", "type": "object"}, {"name": "text", "type": "string"}], ["style"]);
InspectorBackend.registerCommand("CSS.setRuleSelector", null, [{"name": "ruleId", "type": "object"}, {"name": "selector", "type": "string"}], ["rule"]);
InspectorBackend.registerCommand("CSS.createStyleSheet", null, [{"name": "frameId", "type": "string"}], ["styleSheetId"]);
InspectorBackend.registerCommand("CSS.addRule", null, [{"name": "styleSheetId", "type": "string"}, {"name": "selector", "type": "string"}], ["rule"]);
InspectorBackend.registerCommand("CSS.getSupportedCSSProperties", null, [], ["cssProperties"]);
InspectorBackend.registerCommand("CSS.getSupportedSystemFontFamilyNames", null, [], ["fontFamilyNames"]);
InspectorBackend.registerCommand("CSS.forcePseudoState", null, [{"name": "nodeId", "type": "number"}, {"name": "forcedPseudoClasses", "type": "object"}], []);
InspectorBackend.registerCommand("CSS.getNamedFlowCollection", null, [{"name": "documentNodeId", "type": "number"}], ["namedFlows"]);
InspectorBackend.registerEvent("CSS.mediaQueryResultChanged", null, []);
InspectorBackend.registerEvent("CSS.styleSheetChanged", null, ["styleSheetId"]);
InspectorBackend.registerEvent("CSS.styleSheetAdded", null, ["header"]);
InspectorBackend.registerEvent("CSS.styleSheetRemoved", null, ["styleSheetId"]);
InspectorBackend.registerEvent("CSS.namedFlowCreated", null, ["namedFlow"]);
InspectorBackend.registerEvent("CSS.namedFlowRemoved", null, ["documentNodeId", "flowName"]);
InspectorBackend.registerEvent("CSS.regionOversetChanged", null, ["namedFlow"]);
InspectorBackend.registerEvent("CSS.registeredNamedFlowContentElement", null, ["documentNodeId", "flowName", "contentNodeId", "nextContentNodeId"]);
InspectorBackend.registerEvent("CSS.unregisteredNamedFlowContentElement", null, ["documentNodeId", "flowName", "contentNodeId"]);
InspectorBackend.registerCSSDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "CSS");
InspectorBackend.activateDomain("CSS", ["page"]);

// Console
InspectorBackend.registerDomain("Console", ["javascript", "page", "worker"]);
InspectorBackend.registerEnum("Console.ConsoleMessageSource", {XML: "xml", JavaScript: "javascript", Network: "network", ConsoleAPI: "console-api", Storage: "storage", Appcache: "appcache", Rendering: "rendering", CSS: "css", Security: "security", ContentBlocker: "content-blocker", Other: "other"});
InspectorBackend.registerEnum("Console.ConsoleMessageLevel", {Log: "log", Info: "info", Warning: "warning", Error: "error", Debug: "debug"});
InspectorBackend.registerEnum("Console.ConsoleMessageType", {Log: "log", Dir: "dir", DirXML: "dirxml", Table: "table", Trace: "trace", Clear: "clear", StartGroup: "startGroup", StartGroupCollapsed: "startGroupCollapsed", EndGroup: "endGroup", Assert: "assert", Timing: "timing", Profile: "profile", ProfileEnd: "profileEnd"});
InspectorBackend.registerCommand("Console.enable", null, [], []);
InspectorBackend.registerCommand("Console.disable", null, [], []);
InspectorBackend.registerCommand("Console.clearMessages", null, [], []);
InspectorBackend.registerCommand("Console.setMonitoringXHREnabled", null, [{"name": "enabled", "type": "boolean"}], []);
InspectorBackend.registerCommand("Console.addInspectedNode", null, [{"name": "nodeId", "type": "number"}], []);
InspectorBackend.registerEvent("Console.messageAdded", null, ["message"]);
InspectorBackend.registerEvent("Console.messageRepeatCountUpdated", null, ["count"]);
InspectorBackend.registerEvent("Console.messagesCleared", null, []);
InspectorBackend.registerEvent("Console.heapSnapshot", null, ["timestamp", "snapshotData", "title"]);
InspectorBackend.registerConsoleDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Console");
InspectorBackend.activateDomain("Console", ["javascript", "page"]);

// DOM
InspectorBackend.registerDomain("DOM", ["page"]);
InspectorBackend.registerEnum("DOM.PseudoType", {Before: "before", After: "after"});
InspectorBackend.registerEnum("DOM.ShadowRootType", {UserAgent: "user-agent", Open: "open", Closed: "closed"});
InspectorBackend.registerEnum("DOM.CustomElementState", {Builtin: "builtin", Custom: "custom", Waiting: "waiting", Failed: "failed"});
InspectorBackend.registerEnum("DOM.LiveRegionRelevant", {Additions: "additions", Removals: "removals", Text: "text"});
InspectorBackend.registerEnum("DOM.AccessibilityPropertiesChecked", {True: "true", False: "false", Mixed: "mixed"});
InspectorBackend.registerEnum("DOM.AccessibilityPropertiesCurrent", {True: "true", False: "false", Page: "page", Step: "step", Location: "location", Date: "date", Time: "time"});
InspectorBackend.registerEnum("DOM.AccessibilityPropertiesInvalid", {True: "true", False: "false", Grammar: "grammar", Spelling: "spelling"});
InspectorBackend.registerEnum("DOM.AccessibilityPropertiesLiveRegionStatus", {Assertive: "assertive", Polite: "polite", Off: "off"});
InspectorBackend.registerCommand("DOM.getDocument", null, [], ["root"]);
InspectorBackend.registerCommand("DOM.requestChildNodes", null, [{"name": "nodeId", "type": "number"}, {"name": "depth", "type": "number", "optional": true}], []);
InspectorBackend.registerCommand("DOM.querySelector", null, [{"name": "nodeId", "type": "number"}, {"name": "selector", "type": "string"}], ["nodeId"]);
InspectorBackend.registerCommand("DOM.querySelectorAll", null, [{"name": "nodeId", "type": "number"}, {"name": "selector", "type": "string"}], ["nodeIds"]);
InspectorBackend.registerCommand("DOM.setNodeName", null, [{"name": "nodeId", "type": "number"}, {"name": "name", "type": "string"}], ["nodeId"]);
InspectorBackend.registerCommand("DOM.setNodeValue", null, [{"name": "nodeId", "type": "number"}, {"name": "value", "type": "string"}], []);
InspectorBackend.registerCommand("DOM.removeNode", null, [{"name": "nodeId", "type": "number"}], []);
InspectorBackend.registerCommand("DOM.setAttributeValue", null, [{"name": "nodeId", "type": "number"}, {"name": "name", "type": "string"}, {"name": "value", "type": "string"}], []);
InspectorBackend.registerCommand("DOM.setAttributesAsText", null, [{"name": "nodeId", "type": "number"}, {"name": "text", "type": "string"}, {"name": "name", "type": "string", "optional": true}], []);
InspectorBackend.registerCommand("DOM.removeAttribute", null, [{"name": "nodeId", "type": "number"}, {"name": "name", "type": "string"}], []);
InspectorBackend.registerCommand("DOM.getEventListenersForNode", null, [{"name": "nodeId", "type": "number"}, {"name": "objectGroup", "type": "string", "optional": true}], ["listeners"]);
InspectorBackend.registerCommand("DOM.getAccessibilityPropertiesForNode", null, [{"name": "nodeId", "type": "number"}], ["properties"]);
InspectorBackend.registerCommand("DOM.getOuterHTML", null, [{"name": "nodeId", "type": "number"}], ["outerHTML"]);
InspectorBackend.registerCommand("DOM.setOuterHTML", null, [{"name": "nodeId", "type": "number"}, {"name": "outerHTML", "type": "string"}], []);
InspectorBackend.registerCommand("DOM.performSearch", null, [{"name": "query", "type": "string"}, {"name": "nodeIds", "type": "object", "optional": true}], ["searchId", "resultCount"]);
InspectorBackend.registerCommand("DOM.getSearchResults", null, [{"name": "searchId", "type": "string"}, {"name": "fromIndex", "type": "number"}, {"name": "toIndex", "type": "number"}], ["nodeIds"]);
InspectorBackend.registerCommand("DOM.discardSearchResults", null, [{"name": "searchId", "type": "string"}], []);
InspectorBackend.registerCommand("DOM.requestNode", null, [{"name": "objectId", "type": "string"}], ["nodeId"]);
InspectorBackend.registerCommand("DOM.setInspectModeEnabled", null, [{"name": "enabled", "type": "boolean"}, {"name": "highlightConfig", "type": "object", "optional": true}], []);
InspectorBackend.registerCommand("DOM.highlightRect", null, [{"name": "x", "type": "number"}, {"name": "y", "type": "number"}, {"name": "width", "type": "number"}, {"name": "height", "type": "number"}, {"name": "color", "type": "object", "optional": true}, {"name": "outlineColor", "type": "object", "optional": true}, {"name": "usePageCoordinates", "type": "boolean", "optional": true}], []);
InspectorBackend.registerCommand("DOM.highlightQuad", null, [{"name": "quad", "type": "object"}, {"name": "color", "type": "object", "optional": true}, {"name": "outlineColor", "type": "object", "optional": true}, {"name": "usePageCoordinates", "type": "boolean", "optional": true}], []);
InspectorBackend.registerCommand("DOM.highlightSelector", null, [{"name": "highlightConfig", "type": "object"}, {"name": "selectorString", "type": "string"}, {"name": "frameId", "type": "string", "optional": true}], []);
InspectorBackend.registerCommand("DOM.highlightNode", null, [{"name": "highlightConfig", "type": "object"}, {"name": "nodeId", "type": "number", "optional": true}, {"name": "objectId", "type": "string", "optional": true}], []);
InspectorBackend.registerCommand("DOM.hideHighlight", null, [], []);
InspectorBackend.registerCommand("DOM.highlightFrame", null, [{"name": "frameId", "type": "string"}, {"name": "contentColor", "type": "object", "optional": true}, {"name": "contentOutlineColor", "type": "object", "optional": true}], []);
InspectorBackend.registerCommand("DOM.pushNodeByPathToFrontend", null, [{"name": "path", "type": "string"}], ["nodeId"]);
InspectorBackend.registerCommand("DOM.resolveNode", null, [{"name": "nodeId", "type": "number"}, {"name": "objectGroup", "type": "string", "optional": true}], ["object"]);
InspectorBackend.registerCommand("DOM.getAttributes", null, [{"name": "nodeId", "type": "number"}], ["attributes"]);
InspectorBackend.registerCommand("DOM.moveTo", null, [{"name": "nodeId", "type": "number"}, {"name": "targetNodeId", "type": "number"}, {"name": "insertBeforeNodeId", "type": "number", "optional": true}], ["nodeId"]);
InspectorBackend.registerCommand("DOM.undo", null, [], []);
InspectorBackend.registerCommand("DOM.redo", null, [], []);
InspectorBackend.registerCommand("DOM.markUndoableState", null, [], []);
InspectorBackend.registerCommand("DOM.focus", null, [{"name": "nodeId", "type": "number"}], []);
InspectorBackend.registerEvent("DOM.documentUpdated", null, []);
InspectorBackend.registerEvent("DOM.setChildNodes", null, ["parentId", "nodes"]);
InspectorBackend.registerEvent("DOM.attributeModified", null, ["nodeId", "name", "value"]);
InspectorBackend.registerEvent("DOM.attributeRemoved", null, ["nodeId", "name"]);
InspectorBackend.registerEvent("DOM.inlineStyleInvalidated", null, ["nodeIds"]);
InspectorBackend.registerEvent("DOM.characterDataModified", null, ["nodeId", "characterData"]);
InspectorBackend.registerEvent("DOM.childNodeCountUpdated", null, ["nodeId", "childNodeCount"]);
InspectorBackend.registerEvent("DOM.childNodeInserted", null, ["parentNodeId", "previousNodeId", "node"]);
InspectorBackend.registerEvent("DOM.childNodeRemoved", null, ["parentNodeId", "nodeId"]);
InspectorBackend.registerEvent("DOM.shadowRootPushed", null, ["hostId", "root"]);
InspectorBackend.registerEvent("DOM.shadowRootPopped", null, ["hostId", "rootId"]);
InspectorBackend.registerEvent("DOM.customElementStateChanged", null, ["nodeId", "customElementState"]);
InspectorBackend.registerEvent("DOM.pseudoElementAdded", null, ["parentId", "pseudoElement"]);
InspectorBackend.registerEvent("DOM.pseudoElementRemoved", null, ["parentId", "pseudoElementId"]);
InspectorBackend.registerDOMDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "DOM");
InspectorBackend.activateDomain("DOM", ["page"]);

// DOMDebugger
InspectorBackend.registerDomain("DOMDebugger", ["page"]);
InspectorBackend.registerEnum("DOMDebugger.DOMBreakpointType", {SubtreeModified: "subtree-modified", AttributeModified: "attribute-modified", NodeRemoved: "node-removed"});
InspectorBackend.registerCommand("DOMDebugger.setDOMBreakpoint", null, [{"name": "nodeId", "type": "number"}, {"name": "type", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.removeDOMBreakpoint", null, [{"name": "nodeId", "type": "number"}, {"name": "type", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.setEventListenerBreakpoint", null, [{"name": "eventName", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.removeEventListenerBreakpoint", null, [{"name": "eventName", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.setInstrumentationBreakpoint", null, [{"name": "eventName", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.removeInstrumentationBreakpoint", null, [{"name": "eventName", "type": "string"}], []);
InspectorBackend.registerCommand("DOMDebugger.setXHRBreakpoint", null, [{"name": "url", "type": "string"}, {"name": "isRegex", "type": "boolean", "optional": true}], []);
InspectorBackend.registerCommand("DOMDebugger.removeXHRBreakpoint", null, [{"name": "url", "type": "string"}], []);
InspectorBackend.activateDomain("DOMDebugger", ["page"]);

// DOMStorage
InspectorBackend.registerDomain("DOMStorage", ["page"]);
InspectorBackend.registerCommand("DOMStorage.enable", null, [], []);
InspectorBackend.registerCommand("DOMStorage.disable", null, [], []);
InspectorBackend.registerCommand("DOMStorage.getDOMStorageItems", null, [{"name": "storageId", "type": "object"}], ["entries"]);
InspectorBackend.registerCommand("DOMStorage.setDOMStorageItem", null, [{"name": "storageId", "type": "object"}, {"name": "key", "type": "string"}, {"name": "value", "type": "string"}], []);
InspectorBackend.registerCommand("DOMStorage.removeDOMStorageItem", null, [{"name": "storageId", "type": "object"}, {"name": "key", "type": "string"}], []);
InspectorBackend.registerEvent("DOMStorage.domStorageItemsCleared", null, ["storageId"]);
InspectorBackend.registerEvent("DOMStorage.domStorageItemRemoved", null, ["storageId", "key"]);
InspectorBackend.registerEvent("DOMStorage.domStorageItemAdded", null, ["storageId", "key", "newValue"]);
InspectorBackend.registerEvent("DOMStorage.domStorageItemUpdated", null, ["storageId", "key", "oldValue", "newValue"]);
InspectorBackend.registerDOMStorageDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "DOMStorage");
InspectorBackend.activateDomain("DOMStorage", ["page"]);

// Database
InspectorBackend.registerDomain("Database", ["page"]);
InspectorBackend.registerCommand("Database.enable", null, [], []);
InspectorBackend.registerCommand("Database.disable", null, [], []);
InspectorBackend.registerCommand("Database.getDatabaseTableNames", null, [{"name": "databaseId", "type": "string"}], ["tableNames"]);
InspectorBackend.registerCommand("Database.executeSQL", null, [{"name": "databaseId", "type": "string"}, {"name": "query", "type": "string"}], ["columnNames", "values", "sqlError"]);
InspectorBackend.registerEvent("Database.addDatabase", null, ["database"]);
InspectorBackend.registerDatabaseDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Database");
InspectorBackend.activateDomain("Database", ["page"]);

// Debugger
InspectorBackend.registerDomain("Debugger", ["javascript", "page", "worker"]);
InspectorBackend.registerEnum("Debugger.BreakpointActionType", {Log: "log", Evaluate: "evaluate", Sound: "sound", Probe: "probe"});
InspectorBackend.registerEnum("Debugger.ScopeType", {Global: "global", With: "with", Closure: "closure", Catch: "catch", FunctionName: "functionName", GlobalLexicalEnvironment: "globalLexicalEnvironment", NestedLexical: "nestedLexical"});
InspectorBackend.registerCommand("Debugger.enable", null, [], []);
InspectorBackend.registerCommand("Debugger.disable", null, [], []);
InspectorBackend.registerCommand("Debugger.setAsyncStackTraceDepth", null, [{"name": "depth", "type": "number"}], []);
InspectorBackend.registerCommand("Debugger.setBreakpointsActive", null, [{"name": "active", "type": "boolean"}], []);
InspectorBackend.registerCommand("Debugger.setBreakpointByUrl", null, [{"name": "lineNumber", "type": "number"}, {"name": "url", "type": "string", "optional": true}, {"name": "urlRegex", "type": "string", "optional": true}, {"name": "columnNumber", "type": "number", "optional": true}, {"name": "options", "type": "object", "optional": true}], ["breakpointId", "locations"]);
InspectorBackend.registerCommand("Debugger.setBreakpoint", null, [{"name": "location", "type": "object"}, {"name": "options", "type": "object", "optional": true}], ["breakpointId", "actualLocation"]);
InspectorBackend.registerCommand("Debugger.removeBreakpoint", null, [{"name": "breakpointId", "type": "string"}], []);
InspectorBackend.registerCommand("Debugger.continueUntilNextRunLoop", null, [], []);
InspectorBackend.registerCommand("Debugger.continueToLocation", null, [{"name": "location", "type": "object"}], []);
InspectorBackend.registerCommand("Debugger.stepOver", null, [], []);
InspectorBackend.registerCommand("Debugger.stepInto", null, [], []);
InspectorBackend.registerCommand("Debugger.stepOut", null, [], []);
InspectorBackend.registerCommand("Debugger.pause", null, [], []);
InspectorBackend.registerCommand("Debugger.resume", null, [], []);
InspectorBackend.registerCommand("Debugger.searchInContent", null, [{"name": "scriptId", "type": "string"}, {"name": "query", "type": "string"}, {"name": "caseSensitive", "type": "boolean", "optional": true}, {"name": "isRegex", "type": "boolean", "optional": true}], ["result"]);
InspectorBackend.registerCommand("Debugger.getScriptSource", null, [{"name": "scriptId", "type": "string"}], ["scriptSource"]);
InspectorBackend.registerCommand("Debugger.getFunctionDetails", null, [{"name": "functionId", "type": "string"}], ["details"]);
InspectorBackend.registerCommand("Debugger.setPauseOnExceptions", null, [{"name": "state", "type": "string"}], []);
InspectorBackend.registerCommand("Debugger.setPauseOnAssertions", null, [{"name": "enabled", "type": "boolean"}], []);
InspectorBackend.registerCommand("Debugger.evaluateOnCallFrame", null, [{"name": "callFrameId", "type": "string"}, {"name": "expression", "type": "string"}, {"name": "objectGroup", "type": "string", "optional": true}, {"name": "includeCommandLineAPI", "type": "boolean", "optional": true}, {"name": "doNotPauseOnExceptionsAndMuteConsole", "type": "boolean", "optional": true}, {"name": "returnByValue", "type": "boolean", "optional": true}, {"name": "generatePreview", "type": "boolean", "optional": true}, {"name": "saveResult", "type": "boolean", "optional": true}], ["result", "wasThrown", "savedResultIndex"]);
InspectorBackend.registerEvent("Debugger.globalObjectCleared", null, []);
InspectorBackend.registerEvent("Debugger.scriptParsed", null, ["scriptId", "url", "startLine", "startColumn", "endLine", "endColumn", "isContentScript", "sourceURL", "sourceMapURL", "module"]);
InspectorBackend.registerEvent("Debugger.scriptFailedToParse", null, ["url", "scriptSource", "startLine", "errorLine", "errorMessage"]);
InspectorBackend.registerEvent("Debugger.breakpointResolved", null, ["breakpointId", "location"]);
InspectorBackend.registerEnum("Debugger.PausedReason", {XHR: "XHR", DOM: "DOM", EventListener: "EventListener", Exception: "exception", Assert: "assert", CSPViolation: "CSPViolation", DebuggerStatement: "DebuggerStatement", Breakpoint: "Breakpoint", PauseOnNextStatement: "PauseOnNextStatement", Other: "other"});
InspectorBackend.registerEvent("Debugger.paused", null, ["callFrames", "reason", "data", "asyncStackTrace"]);
InspectorBackend.registerEvent("Debugger.resumed", null, []);
InspectorBackend.registerEvent("Debugger.didSampleProbe", null, ["sample"]);
InspectorBackend.registerEvent("Debugger.playBreakpointActionSound", null, ["breakpointActionId"]);
InspectorBackend.registerDebuggerDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Debugger");
InspectorBackend.activateDomain("Debugger", ["javascript", "page"]);

// Heap
InspectorBackend.registerDomain("Heap", ["javascript", "page", "worker"]);
InspectorBackend.registerEnum("Heap.GarbageCollectionType", {Full: "full", Partial: "partial"});
InspectorBackend.registerCommand("Heap.enable", null, [], []);
InspectorBackend.registerCommand("Heap.disable", null, [], []);
InspectorBackend.registerCommand("Heap.gc", null, [], []);
InspectorBackend.registerCommand("Heap.snapshot", null, [], ["timestamp", "snapshotData"]);
InspectorBackend.registerCommand("Heap.startTracking", null, [], []);
InspectorBackend.registerCommand("Heap.stopTracking", null, [], []);
InspectorBackend.registerCommand("Heap.getPreview", null, [{"name": "heapObjectId", "type": "number"}], ["string", "functionDetails", "preview"]);
InspectorBackend.registerCommand("Heap.getRemoteObject", null, [{"name": "heapObjectId", "type": "number"}, {"name": "objectGroup", "type": "string", "optional": true}], ["result"]);
InspectorBackend.registerEvent("Heap.garbageCollected", null, ["collection"]);
InspectorBackend.registerEvent("Heap.trackingStart", null, ["timestamp", "snapshotData"]);
InspectorBackend.registerEvent("Heap.trackingComplete", null, ["timestamp", "snapshotData"]);
InspectorBackend.registerHeapDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Heap");
InspectorBackend.activateDomain("Heap", ["javascript", "page"]);

// IndexedDB
InspectorBackend.registerDomain("IndexedDB", ["page"]);
InspectorBackend.registerEnum("IndexedDB.KeyType", {Number: "number", String: "string", Date: "date", Array: "array"});
InspectorBackend.registerEnum("IndexedDB.KeyPathType", {Null: "null", String: "string", Array: "array"});
InspectorBackend.registerCommand("IndexedDB.enable", null, [], []);
InspectorBackend.registerCommand("IndexedDB.disable", null, [], []);
InspectorBackend.registerCommand("IndexedDB.requestDatabaseNames", null, [{"name": "securityOrigin", "type": "string"}], ["databaseNames"]);
InspectorBackend.registerCommand("IndexedDB.requestDatabase", null, [{"name": "securityOrigin", "type": "string"}, {"name": "databaseName", "type": "string"}], ["databaseWithObjectStores"]);
InspectorBackend.registerCommand("IndexedDB.requestData", null, [{"name": "securityOrigin", "type": "string"}, {"name": "databaseName", "type": "string"}, {"name": "objectStoreName", "type": "string"}, {"name": "indexName", "type": "string"}, {"name": "skipCount", "type": "number"}, {"name": "pageSize", "type": "number"}, {"name": "keyRange", "type": "object", "optional": true}], ["objectStoreDataEntries", "hasMore"]);
InspectorBackend.registerCommand("IndexedDB.clearObjectStore", null, [{"name": "securityOrigin", "type": "string"}, {"name": "databaseName", "type": "string"}, {"name": "objectStoreName", "type": "string"}], []);
InspectorBackend.registerIndexedDBDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "IndexedDB");
InspectorBackend.activateDomain("IndexedDB", ["page"]);

// Inspector
InspectorBackend.registerDomain("Inspector", ["javascript", "page"]);
InspectorBackend.registerCommand("Inspector.enable", null, [], []);
InspectorBackend.registerCommand("Inspector.disable", null, [], []);
InspectorBackend.registerCommand("Inspector.initialized", null, [], []);
InspectorBackend.registerEvent("Inspector.evaluateForTestInFrontend", null, ["script"]);
InspectorBackend.registerEvent("Inspector.inspect", null, ["object", "hints"]);
InspectorBackend.registerEvent("Inspector.activateExtraDomains", null, ["domains"]);
InspectorBackend.registerInspectorDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Inspector");
InspectorBackend.activateDomain("Inspector", ["javascript", "page"]);

// LayerTree
InspectorBackend.registerDomain("LayerTree", ["page"]);
InspectorBackend.registerCommand("LayerTree.enable", null, [], []);
InspectorBackend.registerCommand("LayerTree.disable", null, [], []);
InspectorBackend.registerCommand("LayerTree.layersForNode", null, [{"name": "nodeId", "type": "number"}], ["layers"]);
InspectorBackend.registerCommand("LayerTree.reasonsForCompositingLayer", null, [{"name": "layerId", "type": "string"}], ["compositingReasons"]);
InspectorBackend.registerEvent("LayerTree.layerTreeDidChange", null, []);
InspectorBackend.registerLayerTreeDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "LayerTree");
InspectorBackend.activateDomain("LayerTree", ["page"]);

// Memory
InspectorBackend.registerDomain("Memory", ["page"]);
InspectorBackend.registerEnum("Memory.CategoryDataType", {JavaScript: "javascript", JIT: "jit", Images: "images", Layers: "layers", Page: "page", Other: "other"});
InspectorBackend.registerCommand("Memory.enable", null, [], []);
InspectorBackend.registerCommand("Memory.disable", null, [], []);
InspectorBackend.registerCommand("Memory.startTracking", null, [], []);
InspectorBackend.registerCommand("Memory.stopTracking", null, [], []);
InspectorBackend.registerEnum("Memory.MemoryPressureSeverity", {Critical: "critical", NonCritical: "non-critical"});
InspectorBackend.registerEvent("Memory.memoryPressure", null, ["timestamp", "severity"]);
InspectorBackend.registerEvent("Memory.trackingStart", null, ["timestamp"]);
InspectorBackend.registerEvent("Memory.trackingUpdate", null, ["event"]);
InspectorBackend.registerEvent("Memory.trackingComplete", null, []);
InspectorBackend.registerMemoryDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Memory");
InspectorBackend.activateDomain("Memory", ["page"]);

// Network
InspectorBackend.registerDomain("Network", ["page"]);
InspectorBackend.registerEnum("Network.ResponseSource", {Unknown: "unknown", Network: "network", MemoryCache: "memory-cache", DiskCache: "disk-cache"});
InspectorBackend.registerEnum("Network.MetricsPriority", {Low: "low", Medium: "medium", High: "high"});
InspectorBackend.registerEnum("Network.InitiatorType", {Parser: "parser", Script: "script", Other: "other"});
InspectorBackend.registerCommand("Network.enable", null, [], []);
InspectorBackend.registerCommand("Network.disable", null, [], []);
InspectorBackend.registerCommand("Network.setExtraHTTPHeaders", null, [{"name": "headers", "type": "object"}], []);
InspectorBackend.registerCommand("Network.getResponseBody", null, [{"name": "requestId", "type": "string"}], ["body", "base64Encoded"]);
InspectorBackend.registerCommand("Network.setResourceCachingDisabled", null, [{"name": "disabled", "type": "boolean"}], []);
InspectorBackend.registerCommand("Network.loadResource", null, [{"name": "frameId", "type": "string"}, {"name": "url", "type": "string"}], ["content", "mimeType", "status"]);
InspectorBackend.registerCommand("Network.resolveWebSocket", null, [{"name": "requestId", "type": "string"}, {"name": "objectGroup", "type": "string", "optional": true}], ["object"]);
InspectorBackend.registerEvent("Network.requestWillBeSent", null, ["requestId", "frameId", "loaderId", "documentURL", "request", "timestamp", "initiator", "redirectResponse", "type", "targetId"]);
InspectorBackend.registerEvent("Network.responseReceived", null, ["requestId", "frameId", "loaderId", "timestamp", "type", "response"]);
InspectorBackend.registerEvent("Network.dataReceived", null, ["requestId", "timestamp", "dataLength", "encodedDataLength"]);
InspectorBackend.registerEvent("Network.loadingFinished", null, ["requestId", "timestamp", "sourceMapURL", "metrics"]);
InspectorBackend.registerEvent("Network.loadingFailed", null, ["requestId", "timestamp", "errorText", "canceled"]);
InspectorBackend.registerEvent("Network.requestServedFromMemoryCache", null, ["requestId", "frameId", "loaderId", "documentURL", "timestamp", "initiator", "resource"]);
InspectorBackend.registerEvent("Network.webSocketWillSendHandshakeRequest", null, ["requestId", "timestamp", "walltime", "request"]);
InspectorBackend.registerEvent("Network.webSocketHandshakeResponseReceived", null, ["requestId", "timestamp", "response"]);
InspectorBackend.registerEvent("Network.webSocketCreated", null, ["requestId", "url"]);
InspectorBackend.registerEvent("Network.webSocketClosed", null, ["requestId", "timestamp"]);
InspectorBackend.registerEvent("Network.webSocketFrameReceived", null, ["requestId", "timestamp", "response"]);
InspectorBackend.registerEvent("Network.webSocketFrameError", null, ["requestId", "timestamp", "errorMessage"]);
InspectorBackend.registerEvent("Network.webSocketFrameSent", null, ["requestId", "timestamp", "response"]);
InspectorBackend.registerNetworkDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Network");
InspectorBackend.activateDomain("Network", ["page"]);

// Page
InspectorBackend.registerDomain("Page", ["page"]);
InspectorBackend.registerEnum("Page.ResourceType", {Document: "Document", Stylesheet: "Stylesheet", Image: "Image", Font: "Font", Script: "Script", XHR: "XHR", Fetch: "Fetch", WebSocket: "WebSocket", Other: "Other"});
InspectorBackend.registerEnum("Page.CoordinateSystem", {Viewport: "Viewport", Page: "Page"});
InspectorBackend.registerCommand("Page.enable", null, [], []);
InspectorBackend.registerCommand("Page.disable", null, [], []);
InspectorBackend.registerCommand("Page.reload", null, [{"name": "ignoreCache", "type": "boolean", "optional": true}, {"name": "revalidateAllResources", "type": "boolean", "optional": true}, {"name": "scriptToEvaluateOnLoad", "type": "string", "optional": true}], []);
InspectorBackend.registerCommand("Page.navigate", null, [{"name": "url", "type": "string"}], []);
InspectorBackend.registerCommand("Page.getCookies", null, [], ["cookies"]);
InspectorBackend.registerCommand("Page.deleteCookie", null, [{"name": "cookieName", "type": "string"}, {"name": "url", "type": "string"}], []);
InspectorBackend.registerCommand("Page.getResourceTree", null, [], ["frameTree"]);
InspectorBackend.registerCommand("Page.getResourceContent", null, [{"name": "frameId", "type": "string"}, {"name": "url", "type": "string"}], ["content", "base64Encoded"]);
InspectorBackend.registerCommand("Page.searchInResource", null, [{"name": "frameId", "type": "string"}, {"name": "url", "type": "string"}, {"name": "query", "type": "string"}, {"name": "caseSensitive", "type": "boolean", "optional": true}, {"name": "isRegex", "type": "boolean", "optional": true}, {"name": "requestId", "type": "string", "optional": true}], ["result"]);
InspectorBackend.registerCommand("Page.searchInResources", null, [{"name": "text", "type": "string"}, {"name": "caseSensitive", "type": "boolean", "optional": true}, {"name": "isRegex", "type": "boolean", "optional": true}], ["result"]);
InspectorBackend.registerCommand("Page.setShowPaintRects", null, [{"name": "result", "type": "boolean"}], []);
InspectorBackend.registerCommand("Page.setEmulatedMedia", null, [{"name": "media", "type": "string"}], []);
InspectorBackend.registerCommand("Page.getCompositingBordersVisible", null, [], ["result"]);
InspectorBackend.registerCommand("Page.setCompositingBordersVisible", null, [{"name": "visible", "type": "boolean"}], []);
InspectorBackend.registerCommand("Page.snapshotNode", null, [{"name": "nodeId", "type": "number"}], ["dataURL"]);
InspectorBackend.registerCommand("Page.snapshotRect", null, [{"name": "x", "type": "number"}, {"name": "y", "type": "number"}, {"name": "width", "type": "number"}, {"name": "height", "type": "number"}, {"name": "coordinateSystem", "type": "string"}], ["dataURL"]);
InspectorBackend.registerCommand("Page.archive", null, [], ["data"]);
InspectorBackend.registerEvent("Page.domContentEventFired", null, ["timestamp"]);
InspectorBackend.registerEvent("Page.loadEventFired", null, ["timestamp"]);
InspectorBackend.registerEvent("Page.frameNavigated", null, ["frame"]);
InspectorBackend.registerEvent("Page.frameDetached", null, ["frameId"]);
InspectorBackend.registerEvent("Page.frameStartedLoading", null, ["frameId"]);
InspectorBackend.registerEvent("Page.frameStoppedLoading", null, ["frameId"]);
InspectorBackend.registerEvent("Page.frameScheduledNavigation", null, ["frameId", "delay"]);
InspectorBackend.registerEvent("Page.frameClearedScheduledNavigation", null, ["frameId"]);
InspectorBackend.registerPageDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Page");
InspectorBackend.activateDomain("Page", ["page"]);

// Runtime
InspectorBackend.registerDomain("Runtime", ["javascript", "page", "worker"]);
InspectorBackend.registerEnum("Runtime.RemoteObjectType", {Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol"});
InspectorBackend.registerEnum("Runtime.RemoteObjectSubtype", {Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Error: "error", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Class: "class", Proxy: "proxy"});
InspectorBackend.registerEnum("Runtime.ObjectPreviewType", {Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol"});
InspectorBackend.registerEnum("Runtime.ObjectPreviewSubtype", {Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Error: "error", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Class: "class", Proxy: "proxy"});
InspectorBackend.registerEnum("Runtime.PropertyPreviewType", {Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol", Accessor: "accessor"});
InspectorBackend.registerEnum("Runtime.PropertyPreviewSubtype", {Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Error: "error", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Class: "class", Proxy: "proxy"});
InspectorBackend.registerEnum("Runtime.SyntaxErrorType", {None: "none", Irrecoverable: "irrecoverable", UnterminatedLiteral: "unterminated-literal", Recoverable: "recoverable"});
InspectorBackend.registerCommand("Runtime.parse", null, [{"name": "source", "type": "string"}], ["result", "message", "range"]);
InspectorBackend.registerCommand("Runtime.evaluate", null, [{"name": "expression", "type": "string"}, {"name": "objectGroup", "type": "string", "optional": true}, {"name": "includeCommandLineAPI", "type": "boolean", "optional": true}, {"name": "doNotPauseOnExceptionsAndMuteConsole", "type": "boolean", "optional": true}, {"name": "contextId", "type": "number", "optional": true}, {"name": "returnByValue", "type": "boolean", "optional": true}, {"name": "generatePreview", "type": "boolean", "optional": true}, {"name": "saveResult", "type": "boolean", "optional": true}], ["result", "wasThrown", "savedResultIndex"]);
InspectorBackend.registerCommand("Runtime.callFunctionOn", null, [{"name": "objectId", "type": "string"}, {"name": "functionDeclaration", "type": "string"}, {"name": "arguments", "type": "object", "optional": true}, {"name": "doNotPauseOnExceptionsAndMuteConsole", "type": "boolean", "optional": true}, {"name": "returnByValue", "type": "boolean", "optional": true}, {"name": "generatePreview", "type": "boolean", "optional": true}], ["result", "wasThrown"]);
InspectorBackend.registerCommand("Runtime.getPreview", null, [{"name": "objectId", "type": "string"}], ["preview"]);
InspectorBackend.registerCommand("Runtime.getProperties", null, [{"name": "objectId", "type": "string"}, {"name": "ownProperties", "type": "boolean", "optional": true}, {"name": "generatePreview", "type": "boolean", "optional": true}], ["result", "internalProperties"]);
InspectorBackend.registerCommand("Runtime.getDisplayableProperties", null, [{"name": "objectId", "type": "string"}, {"name": "generatePreview", "type": "boolean", "optional": true}], ["properties", "internalProperties"]);
InspectorBackend.registerCommand("Runtime.getCollectionEntries", null, [{"name": "objectId", "type": "string"}, {"name": "objectGroup", "type": "string", "optional": true}, {"name": "startIndex", "type": "number", "optional": true}, {"name": "numberToFetch", "type": "number", "optional": true}], ["entries"]);
InspectorBackend.registerCommand("Runtime.saveResult", null, [{"name": "value", "type": "object"}, {"name": "contextId", "type": "number", "optional": true}], ["savedResultIndex"]);
InspectorBackend.registerCommand("Runtime.releaseObject", null, [{"name": "objectId", "type": "string"}], []);
InspectorBackend.registerCommand("Runtime.releaseObjectGroup", null, [{"name": "objectGroup", "type": "string"}], []);
InspectorBackend.registerCommand("Runtime.enable", null, [], []);
InspectorBackend.registerCommand("Runtime.disable", null, [], []);
InspectorBackend.registerCommand("Runtime.getRuntimeTypesForVariablesAtOffsets", null, [{"name": "locations", "type": "object"}], ["types"]);
InspectorBackend.registerCommand("Runtime.enableTypeProfiler", null, [], []);
InspectorBackend.registerCommand("Runtime.disableTypeProfiler", null, [], []);
InspectorBackend.registerCommand("Runtime.enableControlFlowProfiler", null, [], []);
InspectorBackend.registerCommand("Runtime.disableControlFlowProfiler", null, [], []);
InspectorBackend.registerCommand("Runtime.getBasicBlocks", null, [{"name": "sourceID", "type": "string"}], ["basicBlocks"]);
InspectorBackend.registerEvent("Runtime.executionContextCreated", null, ["context"]);
InspectorBackend.registerRuntimeDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Runtime");
InspectorBackend.activateDomain("Runtime", ["javascript", "page"]);

// ScriptProfiler
InspectorBackend.registerDomain("ScriptProfiler", ["javascript", "page"]);
InspectorBackend.registerEnum("ScriptProfiler.EventType", {API: "API", Microtask: "Microtask", Other: "Other"});
InspectorBackend.registerCommand("ScriptProfiler.startTracking", null, [{"name": "includeSamples", "type": "boolean", "optional": true}], []);
InspectorBackend.registerCommand("ScriptProfiler.stopTracking", null, [], []);
InspectorBackend.registerEvent("ScriptProfiler.trackingStart", null, ["timestamp"]);
InspectorBackend.registerEvent("ScriptProfiler.trackingUpdate", null, ["event"]);
InspectorBackend.registerEvent("ScriptProfiler.trackingComplete", null, ["samples"]);
InspectorBackend.registerEvent("ScriptProfiler.programmaticCaptureStarted", null, []);
InspectorBackend.registerEvent("ScriptProfiler.programmaticCaptureStopped", null, []);
InspectorBackend.registerScriptProfilerDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "ScriptProfiler");
InspectorBackend.activateDomain("ScriptProfiler", ["javascript", "page"]);

// Timeline
InspectorBackend.registerDomain("Timeline", ["page"]);
InspectorBackend.registerEnum("Timeline.EventType", {EventDispatch: "EventDispatch", ScheduleStyleRecalculation: "ScheduleStyleRecalculation", RecalculateStyles: "RecalculateStyles", InvalidateLayout: "InvalidateLayout", Layout: "Layout", Paint: "Paint", Composite: "Composite", RenderingFrame: "RenderingFrame", TimerInstall: "TimerInstall", TimerRemove: "TimerRemove", TimerFire: "TimerFire", EvaluateScript: "EvaluateScript", TimeStamp: "TimeStamp", Time: "Time", TimeEnd: "TimeEnd", FunctionCall: "FunctionCall", ProbeSample: "ProbeSample", ConsoleProfile: "ConsoleProfile", RequestAnimationFrame: "RequestAnimationFrame", CancelAnimationFrame: "CancelAnimationFrame", FireAnimationFrame: "FireAnimationFrame"});
InspectorBackend.registerEnum("Timeline.Instrument", {ScriptProfiler: "ScriptProfiler", Timeline: "Timeline", Memory: "Memory", Heap: "Heap"});
InspectorBackend.registerCommand("Timeline.start", null, [{"name": "maxCallStackDepth", "type": "number", "optional": true}], []);
InspectorBackend.registerCommand("Timeline.stop", null, [], []);
InspectorBackend.registerCommand("Timeline.setAutoCaptureEnabled", null, [{"name": "enabled", "type": "boolean"}], []);
InspectorBackend.registerCommand("Timeline.setInstruments", null, [{"name": "instruments", "type": "object"}], []);
InspectorBackend.registerEvent("Timeline.eventRecorded", null, ["record"]);
InspectorBackend.registerEvent("Timeline.recordingStarted", null, ["startTime"]);
InspectorBackend.registerEvent("Timeline.recordingStopped", null, ["endTime"]);
InspectorBackend.registerEvent("Timeline.autoCaptureStarted", null, []);
InspectorBackend.registerEvent("Timeline.programmaticCaptureStarted", null, []);
InspectorBackend.registerEvent("Timeline.programmaticCaptureStopped", null, []);
InspectorBackend.registerTimelineDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Timeline");
InspectorBackend.activateDomain("Timeline", ["page"]);

// Worker
InspectorBackend.registerDomain("Worker", ["page"]);
InspectorBackend.registerCommand("Worker.enable", null, [], []);
InspectorBackend.registerCommand("Worker.disable", null, [], []);
InspectorBackend.registerCommand("Worker.initialized", null, [{"name": "workerId", "type": "string"}], []);
InspectorBackend.registerCommand("Worker.sendMessageToWorker", null, [{"name": "workerId", "type": "string"}, {"name": "message", "type": "string"}], []);
InspectorBackend.registerEvent("Worker.workerCreated", null, ["workerId", "url"]);
InspectorBackend.registerEvent("Worker.workerTerminated", null, ["workerId"]);
InspectorBackend.registerEvent("Worker.dispatchMessageFromWorker", null, ["workerId", "message"]);
InspectorBackend.registerWorkerDispatcher = InspectorBackend.registerDispatcher.bind(InspectorBackend, "Worker");
InspectorBackend.activateDomain("Worker", ["page"]);
