/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "APIObject.h"
#include "StorageNamespaceIdentifier.h"
#include "WebPageGroupData.h"
#include <wtf/Ref.h>

namespace WebCore {
class PageGroup;
}

namespace WebKit {

class WebUserContentController;

class WebPageGroupProxy : public RefCounted<WebPageGroupProxy> {
public:
    static Ref<WebPageGroupProxy> create(const WebPageGroupData&);
    virtual ~WebPageGroupProxy();

    const String& identifier() const { return m_data.identifier; }
    PageGroupIdentifier pageGroupID() const { return m_data.pageGroupID; }
    // Namespace IDs for local storage namespaces are currently equivalent to web page group IDs.
    StorageNamespaceIdentifier localStorageNamespaceIdentifier() const { return makeObjectIdentifier<StorageNamespaceIdentifierType>(pageGroupID().toUInt64()); }
    WebCore::PageGroup* corePageGroup() const { return m_pageGroup; }

private:
    WebPageGroupProxy(const WebPageGroupData&);

    WebPageGroupData m_data;
    WebCore::PageGroup* m_pageGroup;
};

} // namespace WebKit
